#include "info_bar_button_wrapper.h"

#include "Properties/category_property.h"
#include "Properties/string_property.h"
#include "Properties/winid_property.h"
#include "allocator_mgr.h"
#include "wxgui_defs.h"

InfoBarButtonWrapper::InfoBarButtonWrapper()
    : wxcWidget(ID_WXINFOBARBUTTON)
{
    m_properties.Clear();
    m_styles.Clear();
    m_sizerFlags.Clear();

    SetPropertyString(_("Common Settings"), "wxInfoBarButton");
    Add<CategoryProperty>(_("Common Settings"));
    Add<WinIdProperty>();
    Add<StringProperty>(PROP_NAME, "", _("Name"));
    Add<StringProperty>(PROP_LABEL,
                        _("My Label"),
                        _("The label of the button. It may only be empty if the button ID is one of the stock ids "
                          "in which case the corresponding stock label (see wxGetStockLabel()) will be used"));

    RegisterEvent(wxT("wxEVT_COMMAND_BUTTON_CLICKED"), wxT("wxCommandEvent"),
                  _("Process a wxEVT_COMMAND_BUTTON_CLICKED event, when the button is clicked."),
                  wxT("wxCommandEventHandler"));

    m_namePattern = "m_infoBarButton";
    SetName(GenerateName());
}

wxcWidget* InfoBarButtonWrapper::Clone() const { return new InfoBarButtonWrapper(); }

wxString InfoBarButtonWrapper::CppCtorCode() const
{
    wxString cppCode;
    cppCode << GetParent()->GetName() << "->AddButton(" << GetId() << ", " << Label() << ");\n";
    return cppCode;
}

void InfoBarButtonWrapper::GetIncludeFile(wxArrayString& headers) const { wxUnusedVar(headers); }

wxString InfoBarButtonWrapper::GetWxClassName() const { return ""; }

void InfoBarButtonWrapper::ToXRC(wxString& text, XRC_TYPE type) const
{
    wxUnusedVar(type);
    text << "<object class=\"wxInfoBarButton\" name=\"" << GetId() << "\">" << XRCLabel() << XRCSuffix();
}
