import { LicenseKeyDto, LicenseResponseDto } from 'src/dtos/license.dto';
import { ServerAboutResponseDto, ServerApkLinksDto, ServerConfigDto, ServerFeaturesDto, ServerMediaTypesResponseDto, ServerPingResponse, ServerStatsResponseDto, ServerStorageResponseDto, ServerThemeDto, ServerVersionHistoryResponseDto, ServerVersionResponseDto } from 'src/dtos/server.dto';
import { VersionCheckStateResponseDto } from 'src/dtos/system-metadata.dto';
import { ServerService } from 'src/services/server.service';
import { SystemMetadataService } from 'src/services/system-metadata.service';
import { VersionService } from 'src/services/version.service';
export declare class ServerController {
    private service;
    private systemMetadataService;
    private versionService;
    constructor(service: ServerService, systemMetadataService: SystemMetadataService, versionService: VersionService);
    getAboutInfo(): Promise<ServerAboutResponseDto>;
    getApkLinks(): ServerApkLinksDto;
    getStorage(): Promise<ServerStorageResponseDto>;
    pingServer(): ServerPingResponse;
    getServerVersion(): ServerVersionResponseDto;
    getVersionHistory(): Promise<ServerVersionHistoryResponseDto[]>;
    getServerFeatures(): Promise<ServerFeaturesDto>;
    getTheme(): Promise<ServerThemeDto>;
    getServerConfig(): Promise<ServerConfigDto>;
    getServerStatistics(): Promise<ServerStatsResponseDto>;
    getSupportedMediaTypes(): ServerMediaTypesResponseDto;
    getServerLicense(): Promise<LicenseResponseDto>;
    setServerLicense(license: LicenseKeyDto): Promise<LicenseResponseDto>;
    deleteServerLicense(): Promise<void>;
    getVersionCheck(): Promise<VersionCheckStateResponseDto>;
}
