import { Response } from 'express';
import { AssetResponseDto } from 'src/dtos/asset-response.dto';
import { AuthDto } from 'src/dtos/auth.dto';
import { AssetDeltaSyncDto, AssetDeltaSyncResponseDto, AssetFullSyncDto, SyncAckDeleteDto, SyncAckDto, SyncAckSetDto, SyncStreamDto } from 'src/dtos/sync.dto';
import { GlobalExceptionFilter } from 'src/middleware/global-exception.filter';
import { SyncService } from 'src/services/sync.service';
export declare class SyncController {
    private service;
    private errorService;
    constructor(service: SyncService, errorService: GlobalExceptionFilter);
    getFullSyncForUser(auth: AuthDto, dto: AssetFullSyncDto): Promise<AssetResponseDto[]>;
    getDeltaSync(auth: AuthDto, dto: AssetDeltaSyncDto): Promise<AssetDeltaSyncResponseDto>;
    getSyncStream(auth: AuthDto, res: Response, dto: SyncStreamDto): Promise<void>;
    getSyncAck(auth: AuthDto): Promise<SyncAckDto[]>;
    sendSyncAck(auth: AuthDto, dto: SyncAckSetDto): Promise<undefined>;
    deleteSyncAck(auth: AuthDto, dto: SyncAckDeleteDto): Promise<void>;
}
