import { BulkIdResponseDto, BulkIdsDto } from 'src/dtos/asset-ids.response.dto';
import { AuthDto } from 'src/dtos/auth.dto';
import { TagBulkAssetsDto, TagBulkAssetsResponseDto, TagCreateDto, TagResponseDto, TagUpdateDto, TagUpsertDto } from 'src/dtos/tag.dto';
import { TagService } from 'src/services/tag.service';
import { UUIDParamDto } from 'src/validation';
export declare class TagController {
    private service;
    constructor(service: TagService);
    createTag(auth: AuthDto, dto: TagCreateDto): Promise<TagResponseDto>;
    getAllTags(auth: AuthDto): Promise<TagResponseDto[]>;
    upsertTags(auth: AuthDto, dto: TagUpsertDto): Promise<TagResponseDto[]>;
    bulkTagAssets(auth: AuthDto, dto: TagBulkAssetsDto): Promise<TagBulkAssetsResponseDto>;
    getTagById(auth: AuthDto, { id }: UUIDParamDto): Promise<TagResponseDto>;
    updateTag(auth: AuthDto, { id }: UUIDParamDto, dto: TagUpdateDto): Promise<TagResponseDto>;
    deleteTag(auth: AuthDto, { id }: UUIDParamDto): Promise<void>;
    tagAssets(auth: AuthDto, { id }: UUIDParamDto, dto: BulkIdsDto): Promise<BulkIdResponseDto[]>;
    untagAssets(auth: AuthDto, dto: BulkIdsDto, { id }: UUIDParamDto): Promise<BulkIdResponseDto[]>;
}
