"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimelineController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const decorators_1 = require("../decorators");
const auth_dto_1 = require("../dtos/auth.dto");
const time_bucket_dto_1 = require("../dtos/time-bucket.dto");
const enum_1 = require("../enum");
const auth_guard_1 = require("../middleware/auth.guard");
const timeline_service_1 = require("../services/timeline.service");
let TimelineController = class TimelineController {
    service;
    constructor(service) {
        this.service = service;
    }
    getTimeBuckets(auth, dto) {
        return this.service.getTimeBuckets(auth, dto);
    }
    getTimeBucket(auth, dto) {
        return this.service.getTimeBucket(auth, dto);
    }
};
exports.TimelineController = TimelineController;
__decorate([
    (0, common_1.Get)('buckets'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AssetRead, sharedLink: true }),
    (0, decorators_1.Endpoint)({
        summary: 'Get time buckets',
        description: 'Retrieve a list of all minimal time buckets.',
        history: new decorators_1.HistoryBuilder().added('v1').internal('v1'),
    }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/time-bucket.dto").TimeBucketsResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, time_bucket_dto_1.TimeBucketDto]),
    __metadata("design:returntype", void 0)
], TimelineController.prototype, "getTimeBuckets", null);
__decorate([
    (0, common_1.Get)('bucket'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AssetRead, sharedLink: true }),
    (0, swagger_1.ApiOkResponse)({ type: time_bucket_dto_1.TimeBucketAssetResponseDto }),
    (0, common_1.Header)('Content-Type', 'application/json'),
    (0, decorators_1.Endpoint)({
        summary: 'Get time bucket',
        description: 'Retrieve a string of all asset ids in a given time bucket.',
        history: new decorators_1.HistoryBuilder().added('v1').internal('v1'),
    }),
    openapi.ApiResponse({ status: 200, type: String }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, time_bucket_dto_1.TimeBucketAssetDto]),
    __metadata("design:returntype", void 0)
], TimelineController.prototype, "getTimeBucket", null);
exports.TimelineController = TimelineController = __decorate([
    (0, swagger_1.ApiTags)(enum_1.ApiTag.Timeline),
    (0, common_1.Controller)('timeline'),
    __metadata("design:paramtypes", [timeline_service_1.TimelineService])
], TimelineController);
//# sourceMappingURL=timeline.controller.js.map