"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TrashController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const decorators_1 = require("../decorators");
const asset_ids_response_dto_1 = require("../dtos/asset-ids.response.dto");
const auth_dto_1 = require("../dtos/auth.dto");
const enum_1 = require("../enum");
const auth_guard_1 = require("../middleware/auth.guard");
const trash_service_1 = require("../services/trash.service");
let TrashController = class TrashController {
    service;
    constructor(service) {
        this.service = service;
    }
    emptyTrash(auth) {
        return this.service.empty(auth);
    }
    restoreTrash(auth) {
        return this.service.restore(auth);
    }
    restoreAssets(auth, dto) {
        return this.service.restoreAssets(auth, dto);
    }
};
exports.TrashController = TrashController;
__decorate([
    (0, common_1.Post)('empty'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AssetDelete }),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    (0, decorators_1.Endpoint)({
        summary: 'Empty trash',
        description: 'Permanently delete all items in the trash.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: common_1.HttpStatus.OK, type: require("../dtos/trash.dto").TrashResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto]),
    __metadata("design:returntype", Promise)
], TrashController.prototype, "emptyTrash", null);
__decorate([
    (0, common_1.Post)('restore'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AssetDelete }),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    (0, decorators_1.Endpoint)({
        summary: 'Restore trash',
        description: 'Restore all items in the trash.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: common_1.HttpStatus.OK, type: require("../dtos/trash.dto").TrashResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto]),
    __metadata("design:returntype", Promise)
], TrashController.prototype, "restoreTrash", null);
__decorate([
    (0, common_1.Post)('restore/assets'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AssetDelete }),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    (0, decorators_1.Endpoint)({
        summary: 'Restore assets',
        description: 'Restore specific assets from the trash.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: common_1.HttpStatus.OK, type: require("../dtos/trash.dto").TrashResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, asset_ids_response_dto_1.BulkIdsDto]),
    __metadata("design:returntype", Promise)
], TrashController.prototype, "restoreAssets", null);
exports.TrashController = TrashController = __decorate([
    (0, swagger_1.ApiTags)(enum_1.ApiTag.Trash),
    (0, common_1.Controller)('trash'),
    __metadata("design:paramtypes", [trash_service_1.TrashService])
], TrashController);
//# sourceMappingURL=trash.controller.js.map