import { NotificationLevel, NotificationType } from 'src/enum';
export declare class TestEmailResponseDto {
    messageId: string;
}
export declare class TemplateResponseDto {
    name: string;
    html: string;
}
export declare class TemplateDto {
    template: string;
}
export declare class NotificationDto {
    id: string;
    createdAt: Date;
    level: NotificationLevel;
    type: NotificationType;
    title: string;
    description?: string;
    data?: any;
    readAt?: Date;
}
export declare class NotificationSearchDto {
    id?: string;
    level?: NotificationLevel;
    type?: NotificationType;
    unread?: boolean;
}
export declare class NotificationCreateDto {
    level?: NotificationLevel;
    type?: NotificationType;
    title: string;
    description?: string | null;
    data?: any;
    readAt?: Date | null;
    userId: string;
}
export declare class NotificationUpdateDto {
    readAt?: Date | null;
}
export declare class NotificationUpdateAllDto {
    ids: string[];
    readAt?: Date | null;
}
export declare class NotificationDeleteAllDto {
    ids: string[];
}
export type MapNotification = {
    id: string;
    createdAt: Date;
    updateId?: string;
    level: NotificationLevel;
    type: NotificationType;
    data: any | null;
    title: string;
    description: string | null;
    readAt: Date | null;
};
export declare const mapNotification: (notification: MapNotification) => NotificationDto;
