"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var MaintenanceWebsocketRepository_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MaintenanceWebsocketRepository = exports.serverEvents = void 0;
const common_1 = require("@nestjs/common");
const websockets_1 = require("@nestjs/websockets");
const socket_io_1 = require("socket.io");
const app_repository_1 = require("../repositories/app.repository");
const logging_repository_1 = require("../repositories/logging.repository");
exports.serverEvents = ['AppRestart'];
let MaintenanceWebsocketRepository = MaintenanceWebsocketRepository_1 = class MaintenanceWebsocketRepository {
    logger;
    appRepository;
    websocketServer;
    constructor(logger, appRepository) {
        this.logger = logger;
        this.appRepository = appRepository;
        this.logger.setContext(MaintenanceWebsocketRepository_1.name);
    }
    afterInit(websocketServer) {
        this.logger.log('Initialized websocket server');
        websocketServer.on('AppRestart', () => this.appRepository.exitApp());
    }
    clientBroadcast(event, ...data) {
        this.websocketServer?.emit(event, ...data);
    }
    serverSend(event, ...args) {
        this.logger.debug(`Server event: ${event} (send)`);
        this.websocketServer?.serverSideEmit(event, ...args);
    }
    handleConnection(client) {
        this.logger.log(`Websocket Connect:    ${client.id}`);
    }
    handleDisconnect(client) {
        this.logger.log(`Websocket Disconnect: ${client.id}`);
    }
};
exports.MaintenanceWebsocketRepository = MaintenanceWebsocketRepository;
__decorate([
    (0, websockets_1.WebSocketServer)(),
    __metadata("design:type", socket_io_1.Server)
], MaintenanceWebsocketRepository.prototype, "websocketServer", void 0);
exports.MaintenanceWebsocketRepository = MaintenanceWebsocketRepository = MaintenanceWebsocketRepository_1 = __decorate([
    (0, websockets_1.WebSocketGateway)({
        cors: true,
        path: '/api/socket.io',
        transports: ['websocket'],
    }),
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [logging_repository_1.LoggingRepository,
        app_repository_1.AppRepository])
], MaintenanceWebsocketRepository);
//# sourceMappingURL=maintenance-websocket.repository.js.map