import { CanActivate, ExecutionContext } from '@nestjs/common';
import { Reflector } from '@nestjs/core';
import { Request } from 'express';
import { AuthDto } from 'src/dtos/auth.dto';
import { Permission } from 'src/enum';
import { LoggingRepository } from 'src/repositories/logging.repository';
import { AuthService } from 'src/services/auth.service';
type AdminRoute = {
    admin?: true;
};
type SharedLinkRoute = {
    sharedLink?: true;
};
type AuthenticatedOptions = {
    permission?: Permission | false;
} & (AdminRoute | SharedLinkRoute);
export declare const Authenticated: (options?: AuthenticatedOptions) => MethodDecorator;
export declare const Auth: (...dataOrPipes: any[]) => ParameterDecorator;
export declare const FileResponse: () => MethodDecorator & ClassDecorator;
export declare const GetLoginDetails: (...dataOrPipes: any[]) => ParameterDecorator;
export interface AuthRequest extends Request {
    user?: AuthDto;
}
export interface AuthenticatedRequest extends Request {
    user: AuthDto;
}
export declare class AuthGuard implements CanActivate {
    private logger;
    private reflector;
    private authService;
    constructor(logger: LoggingRepository, reflector: Reflector, authService: AuthService);
    canActivate(context: ExecutionContext): Promise<boolean>;
}
export {};
