"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketAdapter = void 0;
const platform_socket_io_1 = require("@nestjs/platform-socket.io");
const redis_adapter_1 = require("@socket.io/redis-adapter");
const ioredis_1 = require("ioredis");
const config_repository_1 = require("../repositories/config.repository");
class WebSocketAdapter extends platform_socket_io_1.IoAdapter {
    app;
    constructor(app) {
        super(app);
        this.app = app;
    }
    createIOServer(port, options) {
        const { redis } = this.app.get(config_repository_1.ConfigRepository).getEnv();
        const server = super.createIOServer(port, options);
        const pubClient = new ioredis_1.Redis(redis);
        const subClient = pubClient.duplicate();
        server.adapter((0, redis_adapter_1.createAdapter)(pubClient, subClient));
        return server;
    }
}
exports.WebSocketAdapter = WebSocketAdapter;
//# sourceMappingURL=websocket.adapter.js.map