import { Insertable, Kysely, Updateable } from 'kysely';
import { AlbumUserRole } from 'src/enum';
import { DB } from 'src/schema';
import { AlbumUserTable } from 'src/schema/tables/album-user.table';
export type AlbumPermissionId = {
    albumId: string;
    userId: string;
};
export declare class AlbumUserRepository {
    private db;
    constructor(db: Kysely<DB>);
    create(albumUser: Insertable<AlbumUserTable>): Promise<{
        role: AlbumUserRole;
        albumId: string;
        userId: string;
    }>;
    update({ userId, albumId }: AlbumPermissionId, dto: Updateable<AlbumUserTable>): Promise<{
        updatedAt: Date;
        updateId: string;
        createdAt: Date;
        role: AlbumUserRole;
        albumId: string;
        userId: string;
        createId: string;
    }>;
    delete({ userId, albumId }: AlbumPermissionId): Promise<void>;
}
