"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var EventRepository_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventRepository = void 0;
const common_1 = require("@nestjs/common");
const core_1 = require("@nestjs/core");
const lodash_1 = __importDefault(require("lodash"));
const enum_1 = require("../enum");
const config_repository_1 = require("./config.repository");
const logging_repository_1 = require("./logging.repository");
let EventRepository = EventRepository_1 = class EventRepository {
    moduleRef;
    configRepository;
    logger;
    emitHandlers = {};
    constructor(moduleRef, configRepository, logger) {
        this.moduleRef = moduleRef;
        this.configRepository = configRepository;
        this.logger = logger;
        this.logger.setContext(EventRepository_1.name);
    }
    setup({ services }) {
        const reflector = this.moduleRef.get(core_1.Reflector, { strict: false });
        const items = [];
        const worker = this.configRepository.getWorker();
        if (!worker) {
            throw new Error('Unable to determine worker type');
        }
        for (const Service of services) {
            const instance = this.moduleRef.get(Service);
            const ctx = Object.getPrototypeOf(instance);
            for (const property of Object.getOwnPropertyNames(ctx)) {
                const descriptor = Object.getOwnPropertyDescriptor(ctx, property);
                if (!descriptor || descriptor.get || descriptor.set) {
                    continue;
                }
                const handler = instance[property];
                if (typeof handler !== 'function') {
                    continue;
                }
                const event = reflector.get(enum_1.MetadataKey.EventConfig, handler);
                if (!event) {
                    continue;
                }
                const workers = event.workers ?? Object.values(enum_1.ImmichWorker);
                if (!workers.includes(worker)) {
                    continue;
                }
                items.push({
                    event: event.name,
                    priority: event.priority || 0,
                    server: event.server ?? false,
                    handler: handler.bind(instance),
                    label: `${Service.name}.${handler.name}`,
                });
            }
        }
        const handlers = lodash_1.default.orderBy(items, ['priority'], ['asc']);
        for (const handler of handlers) {
            this.addHandler(handler);
        }
    }
    addHandler(item) {
        const event = item.event;
        if (!this.emitHandlers[event]) {
            this.emitHandlers[event] = [];
        }
        this.emitHandlers[event].push(item);
    }
    emit(event, ...args) {
        return this.onEvent({ name: event, args, server: false });
    }
    async onEvent(event) {
        const handlers = this.emitHandlers[event.name] || [];
        for (const { handler, server } of handlers) {
            if (!server && event.server) {
                continue;
            }
            await handler(...event.args);
        }
    }
};
exports.EventRepository = EventRepository;
exports.EventRepository = EventRepository = EventRepository_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [core_1.ModuleRef,
        config_repository_1.ConfigRepository,
        logging_repository_1.LoggingRepository])
], EventRepository);
//# sourceMappingURL=event.repository.js.map