import { Insertable, Kysely, Updateable } from 'kysely';
import { NotificationSearchDto } from 'src/dtos/notification.dto';
import { DB } from 'src/schema';
import { NotificationTable } from 'src/schema/tables/notification.table';
export declare class NotificationRepository {
    private db;
    constructor(db: Kysely<DB>);
    cleanup(): Promise<import("kysely").DeleteResult[]>;
    search(userId: string, dto: NotificationSearchDto): Promise<{
        id: string;
        type: import("../enum").NotificationType;
        description: string | null;
        title: string;
        createdAt: Date;
        data: any;
        level: import("../enum").NotificationLevel;
        readAt: Date | null;
    }[]>;
    create(notification: Insertable<NotificationTable>): Promise<{
        id: string;
        type: import("../enum").NotificationType;
        description: string | null;
        title: string;
        createdAt: Date;
        data: any;
        level: import("../enum").NotificationLevel;
        readAt: Date | null;
    }>;
    get(id: string): Promise<{
        id: string;
        type: import("../enum").NotificationType;
        description: string | null;
        title: string;
        createdAt: Date;
        data: any;
        level: import("../enum").NotificationLevel;
        readAt: Date | null;
    } | undefined>;
    update(id: string, notification: Updateable<NotificationTable>): Promise<{
        id: string;
        type: import("../enum").NotificationType;
        description: string | null;
        title: string;
        createdAt: Date;
        data: any;
        level: import("../enum").NotificationLevel;
        readAt: Date | null;
    }>;
    updateAll(ids: string[], notification: Updateable<NotificationTable>): Promise<void>;
    delete(id: string): Promise<void>;
    deleteAll(ids: string[]): Promise<void>;
}
