import { Insertable, Kysely } from 'kysely';
import { SyncEntityType } from 'src/enum';
import { DB } from 'src/schema';
import { SessionSyncCheckpointTable } from 'src/schema/tables/sync-checkpoint.table';
export declare class SyncCheckpointRepository {
    private db;
    constructor(db: Kysely<DB>);
    getAll(sessionId: string): Promise<{
        type: SyncEntityType;
        ack: string;
    }[]>;
    upsertAll(items: Insertable<SessionSyncCheckpointTable>[]): Promise<import("kysely").InsertResult[]>;
    deleteAll(sessionId: string, types?: SyncEntityType[]): Promise<import("kysely").DeleteResult[]>;
    getNow(): Promise<{
        nowId: string;
    }>;
}
