"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.up = up;
exports.down = down;
const kysely_1 = require("kysely");
const items = [
    { oldName: 'album.addAsset', newName: 'albumAsset.create' },
    { oldName: 'album.removeAsset', newName: 'albumAsset.delete' },
    { oldName: 'admin.user.create', newName: 'adminUser.create' },
    { oldName: 'admin.user.read', newName: 'adminUser.read' },
    { oldName: 'admin.user.update', newName: 'adminUser.update' },
    { oldName: 'admin.user.delete', newName: 'adminUser.delete' },
];
async function up(db) {
    for (const { oldName, newName } of items) {
        await (0, kysely_1.sql) `UPDATE "api_key" SET "permissions" = array_replace("permissions", ${oldName}, ${newName})`.execute(db);
    }
}
async function down(db) {
    for (const { oldName, newName } of items) {
        await (0, kysely_1.sql) `UPDATE "api_key" SET "permissions" = array_replace("permissions", ${newName}, ${oldName})`.execute(db);
    }
}
//# sourceMappingURL=1753464178233-RenameApiKeyPermissions.js.map