import { AssetBulkUploadCheckResponseDto, AssetMediaResponseDto, CheckExistingAssetsResponseDto } from 'src/dtos/asset-media-response.dto';
import { AssetBulkUploadCheckDto, AssetMediaCreateDto, AssetMediaOptionsDto, AssetMediaReplaceDto, AssetMediaSize, CheckExistingAssetsDto } from 'src/dtos/asset-media.dto';
import { AuthDto } from 'src/dtos/auth.dto';
import { AuthRequest } from 'src/middleware/auth.guard';
import { BaseService } from 'src/services/base.service';
import { UploadFile, UploadRequest } from 'src/types';
import { ImmichFileResponse } from 'src/utils/file';
export interface AssetMediaRedirectResponse {
    targetSize: AssetMediaSize | 'original';
}
export declare class AssetMediaService extends BaseService {
    getUploadAssetIdByChecksum(auth: AuthDto, checksum?: string): Promise<AssetMediaResponseDto | undefined>;
    canUploadFile({ auth, fieldName, file, body }: UploadRequest): true;
    getUploadFilename({ auth, fieldName, file, body }: UploadRequest): string;
    getUploadFolder({ auth, fieldName, file }: UploadRequest): string;
    onUploadError(request: AuthRequest, file: Express.Multer.File): Promise<void>;
    uploadAsset(auth: AuthDto, dto: AssetMediaCreateDto, file: UploadFile, sidecarFile?: UploadFile): Promise<AssetMediaResponseDto>;
    replaceAsset(auth: AuthDto, id: string, dto: AssetMediaReplaceDto, file: UploadFile, sidecarFile?: UploadFile): Promise<AssetMediaResponseDto>;
    downloadOriginal(auth: AuthDto, id: string): Promise<ImmichFileResponse>;
    viewThumbnail(auth: AuthDto, id: string, dto: AssetMediaOptionsDto): Promise<ImmichFileResponse | AssetMediaRedirectResponse>;
    playbackVideo(auth: AuthDto, id: string): Promise<ImmichFileResponse>;
    checkExistingAssets(auth: AuthDto, checkExistingAssetsDto: CheckExistingAssetsDto): Promise<CheckExistingAssetsResponseDto>;
    bulkUploadCheck(auth: AuthDto, dto: AssetBulkUploadCheckDto): Promise<AssetBulkUploadCheckResponseDto>;
    private handleUploadError;
    private replaceFileData;
    private createCopy;
    private create;
    private requireQuota;
    private findOrFail;
}
