import { AuthDto } from 'src/dtos/auth.dto';
import { NotificationCreateDto } from 'src/dtos/notification.dto';
import { SystemConfigSmtpDto } from 'src/dtos/system-config.dto';
import { EmailTemplate } from 'src/repositories/email.repository';
import { BaseService } from 'src/services/base.service';
export declare class NotificationAdminService extends BaseService {
    create(auth: AuthDto, dto: NotificationCreateDto): Promise<import("src/dtos/notification.dto").NotificationDto>;
    sendTestEmail(id: string, dto: SystemConfigSmtpDto, tempTemplate?: string): Promise<{
        messageId: string;
    }>;
    getTemplate(name: EmailTemplate, customTemplate: string): Promise<{
        name: EmailTemplate;
        html: string;
    }>;
}
