import { Writable } from 'node:stream';
import { AssetResponseDto } from 'src/dtos/asset-response.dto';
import { AuthDto } from 'src/dtos/auth.dto';
import { AssetDeltaSyncDto, AssetDeltaSyncResponseDto, AssetFullSyncDto, SyncAckDeleteDto, SyncAckSetDto, SyncStreamDto } from 'src/dtos/sync.dto';
import { SyncEntityType, SyncRequestType } from 'src/enum';
import { BaseService } from 'src/services/base.service';
export declare const SYNC_TYPES_ORDER: SyncRequestType[];
export declare class SyncService extends BaseService {
    getAcks(auth: AuthDto): Promise<{
        type: SyncEntityType;
        ack: string;
    }[]>;
    setAcks(auth: AuthDto, dto: SyncAckSetDto): Promise<undefined>;
    deleteAcks(auth: AuthDto, dto: SyncAckDeleteDto): Promise<undefined>;
    stream(auth: AuthDto, response: Writable, dto: SyncStreamDto): Promise<undefined>;
    onAuditTableCleanup(): Promise<void>;
    private needsFullSync;
    private syncAuthUsersV1;
    private syncUsersV1;
    private syncPartnersV1;
    private syncAssetsV1;
    private syncPartnerAssetsV1;
    private syncAssetExifsV1;
    private syncPartnerAssetExifsV1;
    private syncAlbumsV1;
    private syncAlbumUsersV1;
    private syncAlbumAssetsV1;
    private syncAlbumAssetExifsV1;
    private syncAlbumToAssetsV1;
    private syncMemoriesV1;
    private syncMemoryAssetsV1;
    private syncStackV1;
    private syncPartnerStackV1;
    private syncPeopleV1;
    private syncAssetFacesV1;
    private syncUserMetadataV1;
    private syncAssetMetadataV1;
    private upsertBackfillCheckpoint;
    getFullSync(auth: AuthDto, dto: AssetFullSyncDto): Promise<AssetResponseDto[]>;
    getDeltaSync(auth: AuthDto, dto: AssetDeltaSyncDto): Promise<AssetDeltaSyncResponseDto>;
}
