"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TrashService = void 0;
const common_1 = require("@nestjs/common");
const constants_1 = require("../constants");
const decorators_1 = require("../decorators");
const enum_1 = require("../enum");
const base_service_1 = require("./base.service");
let TrashService = class TrashService extends base_service_1.BaseService {
    async restoreAssets(auth, dto) {
        const { ids } = dto;
        if (ids.length === 0) {
            return { count: 0 };
        }
        await this.requireAccess({ auth, permission: enum_1.Permission.AssetDelete, ids });
        await this.trashRepository.restoreAll(ids);
        await this.eventRepository.emit('AssetRestoreAll', { assetIds: ids, userId: auth.user.id });
        this.logger.log(`Restored ${ids.length} asset(s) from trash`);
        return { count: ids.length };
    }
    async restore(auth) {
        const count = await this.trashRepository.restore(auth.user.id);
        if (count > 0) {
            this.logger.log(`Restored ${count} asset(s) from trash`);
        }
        return { count };
    }
    async empty(auth) {
        const count = await this.trashRepository.empty(auth.user.id);
        if (count > 0) {
            await this.jobRepository.queue({ name: enum_1.JobName.AssetEmptyTrash, data: {} });
        }
        return { count };
    }
    async onAssetsDelete() {
        await this.jobRepository.queue({ name: enum_1.JobName.AssetEmptyTrash, data: {} });
    }
    async handleEmptyTrash() {
        const assets = this.trashRepository.getDeletedIds();
        let count = 0;
        const batch = [];
        for await (const { id } of assets) {
            batch.push(id);
            if (batch.length === constants_1.JOBS_ASSET_PAGINATION_SIZE) {
                await this.handleBatch(batch);
                count += batch.length;
                batch.length = 0;
            }
        }
        await this.handleBatch(batch);
        count += batch.length;
        batch.length = 0;
        this.logger.log(`Queued ${count} asset(s) for deletion from the trash`);
        return enum_1.JobStatus.Success;
    }
    async handleBatch(ids) {
        this.logger.debug(`Queueing ${ids.length} asset(s) for deletion from the trash`);
        await this.jobRepository.queueAll(ids.map((assetId) => ({
            name: enum_1.JobName.AssetDelete,
            data: {
                id: assetId,
                deleteOnDisk: true,
            },
        })));
    }
};
exports.TrashService = TrashService;
__decorate([
    (0, decorators_1.OnEvent)({ name: 'AssetDeleteAll' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], TrashService.prototype, "onAssetsDelete", null);
__decorate([
    (0, decorators_1.OnJob)({ name: enum_1.JobName.AssetEmptyTrash, queue: enum_1.QueueName.BackgroundTask }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], TrashService.prototype, "handleEmptyTrash", null);
exports.TrashService = TrashService = __decorate([
    (0, common_1.Injectable)()
], TrashService);
//# sourceMappingURL=trash.service.js.map