"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.processCheckConstraints = void 0;
const types_1 = require("../types");
const processCheckConstraints = (ctx, items) => {
    for (const { item: { object, options }, } of items.filter((item) => item.type === 'checkConstraint')) {
        const table = ctx.getTableByObject(object);
        if (!table) {
            ctx.warnMissingTable('@Check', object);
            continue;
        }
        const tableName = table.name;
        table.constraints.push({
            type: types_1.ConstraintType.CHECK,
            name: options.name || ctx.getNameFor({ type: 'check', tableName, expression: options.expression }),
            tableName,
            expression: options.expression,
            synchronize: options.synchronize ?? true,
        });
    }
};
exports.processCheckConstraints = processCheckConstraints;
//# sourceMappingURL=check-constraint.processor.js.map