"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readOverrides = void 0;
const kysely_1 = require("kysely");
const readOverrides = async (ctx, db) => {
    try {
        const result = await kysely_1.sql
            .raw(`SELECT name, value FROM "${ctx.overrideTableName}"`)
            .execute(db);
        for (const { name, value } of result.rows) {
            ctx.overrides.push({ name, value, synchronize: true });
        }
    }
    catch (error) {
        ctx.warn('Overrides', `Error reading override table: ${error}`);
    }
};
exports.readOverrides = readOverrides;
//# sourceMappingURL=override.reader.js.map