"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.asConstraintBody = exports.transformConstraints = void 0;
const helpers_1 = require("../helpers");
const types_1 = require("../types");
const transformConstraints = (ctx, item) => {
    switch (item.type) {
        case 'ConstraintAdd': {
            return `ALTER TABLE "${item.constraint.tableName}" ADD ${(0, exports.asConstraintBody)(item.constraint)};`;
        }
        case 'ConstraintRename': {
            return `ALTER TABLE "${item.tableName}" RENAME CONSTRAINT "${item.oldName}" TO "${item.newName}";`;
        }
        case 'ConstraintDrop': {
            return `ALTER TABLE "${item.tableName}" DROP CONSTRAINT "${item.constraintName}";`;
        }
        default: {
            return false;
        }
    }
};
exports.transformConstraints = transformConstraints;
const withAction = (constraint) => ` ON UPDATE ${constraint.onUpdate ?? types_1.ActionType.NO_ACTION} ON DELETE ${constraint.onDelete ?? types_1.ActionType.NO_ACTION}`;
const asConstraintBody = (constraint) => {
    const base = `CONSTRAINT "${constraint.name}"`;
    switch (constraint.type) {
        case types_1.ConstraintType.PRIMARY_KEY: {
            const columnNames = (0, helpers_1.asColumnList)(constraint.columnNames);
            return `${base} PRIMARY KEY (${columnNames})`;
        }
        case types_1.ConstraintType.FOREIGN_KEY: {
            const columnNames = (0, helpers_1.asColumnList)(constraint.columnNames);
            const referenceColumnNames = (0, helpers_1.asColumnList)(constraint.referenceColumnNames);
            return (`${base} FOREIGN KEY (${columnNames}) REFERENCES "${constraint.referenceTableName}" (${referenceColumnNames})` +
                withAction(constraint));
        }
        case types_1.ConstraintType.UNIQUE: {
            const columnNames = (0, helpers_1.asColumnList)(constraint.columnNames);
            return `${base} UNIQUE (${columnNames})`;
        }
        case types_1.ConstraintType.CHECK: {
            return `${base} CHECK (${constraint.expression})`;
        }
        default: {
            throw new Error(`Unknown constraint type: ${constraint.type}`);
        }
    }
};
exports.asConstraintBody = asConstraintBody;
//# sourceMappingURL=constraint.transformer.js.map