"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.transformExtensions = void 0;
const transformExtensions = (ctx, item) => {
    switch (item.type) {
        case 'ExtensionCreate': {
            return asExtensionCreate(item.extension);
        }
        case 'ExtensionDrop': {
            return asExtensionDrop(item.extensionName);
        }
        default: {
            return false;
        }
    }
};
exports.transformExtensions = transformExtensions;
const asExtensionCreate = (extension) => {
    return `CREATE EXTENSION IF NOT EXISTS "${extension.name}";`;
};
const asExtensionDrop = (extensionName) => {
    return `DROP EXTENSION "${extensionName}";`;
};
//# sourceMappingURL=extension.transformer.js.map