import { HtmlToTextOptions, SelectorDefinition } from "html-to-text";
import { Options as Options$1 } from "prettier";

//#region src/shared/options.d.ts
type Options = {
  /**
   * @deprecated use {@link pretty} instead
   */
  pretty?: boolean;
} & ({
  /**
   * @deprecated use {@link toPlainText} instead
   */
  plainText?: false;
} | {
  /**
   * @deprecated use {@link toPlainText} instead
   */
  plainText?: true;
  /**
   * These are options you can pass down directly to the library we use for
   * converting the rendered email's HTML into plain text.
   *
   * @see https://github.com/html-to-text/node-html-to-text
   */
  htmlToTextOptions?: HtmlToTextOptions;
});
//#endregion
//#region src/shared/utils/pretty.d.ts
declare const pretty: (str: string, options?: Options$1) => Promise<string>;
//#endregion
//#region src/shared/utils/to-plain-text.d.ts
declare const plainTextSelectors: SelectorDefinition[];
declare function toPlainText(html: string, options?: HtmlToTextOptions): string;
//#endregion
//#region src/node/render.d.ts
declare const render: (node: React.ReactNode, options?: Options) => Promise<string>;
//#endregion
//#region src/node/index.d.ts
/**
 * @deprecated use {@link render}
 */
declare const renderAsync: (element: React.ReactElement, options?: Options) => Promise<string>;
//#endregion
export { Options, plainTextSelectors, pretty, render, renderAsync, toPlainText };
//# sourceMappingURL=index.d.mts.map