"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.delay = delay;
exports.until = until;
const node_timers_1 = __importDefault(require("node:timers"));
function delay(millis, unref = false) {
    return new Promise((resolve) => {
        const t = node_timers_1.default.setTimeout(() => resolve(), millis);
        if (unref)
            t.unref();
    });
}
/**
 * Run the given thunk until the promise is resolved to true, or the timeout
 * passes.
 */
async function until(f, timeoutMs, delayMs = 50) {
    const timeoutAt = Date.now() + timeoutMs;
    let count = 0;
    while (Date.now() < timeoutAt) {
        if (await f(count)) {
            return true;
        }
        else {
            count++;
            await delay(delayMs);
        }
    }
    return false;
}
//# sourceMappingURL=Async.js.map