"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.tryEach = tryEach;
exports.cleanError = cleanError;
exports.asError = asError;
const String_1 = require("./String");
/**
 * When we wrap errors, an Error always prefixes the toString() and stack with
 * "Error: ", so we can remove that prefix.
 */
function tryEach(arr) {
    for (const f of arr) {
        try {
            f();
        }
        catch {
            //
        }
    }
}
function cleanError(s) {
    return String(s)
        .trim()
        .replace(/^error: /i, "");
}
function asError(err) {
    var _a, _b;
    return err instanceof Error
        ? err
        : new Error((_b = (_a = (0, String_1.toNotBlank)(err != null && typeof err === "object" && "message" in err
            ? err === null || err === void 0 ? void 0 : err.message
            : undefined)) !== null && _a !== void 0 ? _a : (0, String_1.toNotBlank)(err)) !== null && _b !== void 0 ? _b : "(unknown)");
}
//# sourceMappingURL=Error.js.map