"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.map = map;
exports.isFunction = isFunction;
exports.fromEntries = fromEntries;
exports.omit = omit;
/**
 * Only call and return the result of `f` if `obj` is defined (not null nor
 * undefined)
 */
function map(obj, f) {
    return obj != null ? f(obj) : undefined;
}
function isFunction(obj) {
    return typeof obj === "function";
}
function fromEntries(arr) {
    const o = {};
    for (const [key, value] of arr) {
        if (key != null) {
            o[key] = value;
        }
    }
    return o;
}
function omit(t, ...keysToOmit) {
    const result = { ...t };
    for (const ea of keysToOmit) {
        delete result[ea];
    }
    return result;
}
//# sourceMappingURL=Object.js.map