export declare class Rate {
    #private;
    readonly periodMs: number;
    readonly warmupMs: number;
    /**
     * @param periodMs the length of time to retain event timestamps for computing
     * rate. Events older than this value will be discarded.
     * @param warmupMs return `null` from {@link Rate#msPerEvent} if it's been less
     * than `warmupMs` since construction or {@link Rate#clear}.
     */
    constructor(periodMs?: number, warmupMs?: number);
    onEvent(): void;
    get eventCount(): number;
    get msSinceLastEvent(): number | null;
    get msPerEvent(): number | null;
    get eventsPerMs(): number;
    get eventsPerSecond(): number;
    get eventsPerMinute(): number;
    clear(): this;
}
