"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _StreamHandler_instances, _StreamHandler_logger, _StreamHandler_onStdout, _StreamHandler_onStderr;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StreamHandler = void 0;
const Object_1 = require("./Object");
const String_1 = require("./String");
/**
 * Handles stdout/stderr stream processing for child processes.
 * Manages stream event listeners, data routing, and error handling.
 */
class StreamHandler {
    constructor(options, emitter) {
        _StreamHandler_instances.add(this);
        this.emitter = emitter;
        _StreamHandler_logger.set(this, void 0);
        __classPrivateFieldSet(this, _StreamHandler_logger, options.logger, "f");
    }
    /**
     * Set up stream event listeners for a child process
     */
    setupStreamListeners(proc, context) {
        const stdin = proc.stdin;
        if (stdin == null)
            throw new Error("Given proc had no stdin");
        stdin.on("error", (err) => context.onError("stdin.error", err));
        const stdout = proc.stdout;
        if (stdout == null)
            throw new Error("Given proc had no stdout");
        stdout.on("error", (err) => context.onError("stdout.error", err));
        stdout.on("data", (data) => __classPrivateFieldGet(this, _StreamHandler_instances, "m", _StreamHandler_onStdout).call(this, data, context));
        (0, Object_1.map)(proc.stderr, (stderr) => {
            stderr.on("error", (err) => context.onError("stderr.error", err));
            stderr.on("data", (data) => __classPrivateFieldGet(this, _StreamHandler_instances, "m", _StreamHandler_onStderr).call(this, data, context));
        });
    }
    /**
     * Process stdout data directly (for testing or manual processing)
     */
    processStdout(data, context) {
        __classPrivateFieldGet(this, _StreamHandler_instances, "m", _StreamHandler_onStdout).call(this, data, context);
    }
    /**
     * Process stderr data directly (for testing or manual processing)
     */
    processStderr(data, context) {
        __classPrivateFieldGet(this, _StreamHandler_instances, "m", _StreamHandler_onStderr).call(this, data, context);
    }
    /**
     * Check if data is considered blank/empty
     */
    isBlankData(data) {
        return (0, String_1.blank)(data);
    }
    /**
     * Get stream handler statistics
     */
    getStats() {
        return {
            handlerActive: true,
            emitterConnected: this.emitter != null,
        };
    }
}
exports.StreamHandler = StreamHandler;
_StreamHandler_logger = new WeakMap(), _StreamHandler_instances = new WeakSet(), _StreamHandler_onStdout = function _StreamHandler_onStdout(data, context) {
    if (data == null)
        return;
    const task = context.getCurrentTask();
    if (task != null && task.pending) {
        // eslint-disable-next-line @typescript-eslint/no-explicit-any, @typescript-eslint/no-unsafe-argument
        this.emitter.emit("taskData", data, task, context);
        task.onStdout(data);
    }
    else if (context.isEnding()) {
        // don't care if we're already being shut down.
    }
    else if (!(0, String_1.blank)(data)) {
        // eslint-disable-next-line @typescript-eslint/no-explicit-any, @typescript-eslint/no-unsafe-argument
        this.emitter.emit("noTaskData", data, null, context);
        context.end(false, "stdout.error");
    }
}, _StreamHandler_onStderr = function _StreamHandler_onStderr(data, context) {
    if ((0, String_1.blank)(data))
        return;
    __classPrivateFieldGet(this, _StreamHandler_logger, "f").call(this).warn(context.name + ".onStderr(): " + String(data));
    const task = context.getCurrentTask();
    if (task != null && task.pending) {
        task.onStderr(data);
    }
    else if (!context.isEnding()) {
        // If we're ending and there isn't a task, don't worry about it.
        // eslint-disable-next-line @typescript-eslint/no-explicit-any, @typescript-eslint/no-unsafe-argument
        this.emitter.emit("noTaskData", null, data, context);
        context.end(false, "stderr");
    }
};
//# sourceMappingURL=StreamHandler.js.map