import { BatchClusterEmitter } from "./BatchClusterEmitter";
import { BatchProcess } from "./BatchProcess";
import { Logger } from "./Logger";
import { Task } from "./Task";
/**
 * Manages task queuing, scheduling, and assignment to ready processes.
 * Handles the task lifecycle from enqueue to assignment.
 */
export declare class TaskQueueManager {
    #private;
    private readonly emitter?;
    constructor(logger: () => Logger, emitter?: BatchClusterEmitter | undefined);
    /**
     * Add a task to the queue for processing
     */
    enqueueTask<T>(task: Task<T>, ended: boolean): Promise<T>;
    /**
     * Simple enqueue method (alias for enqueueTask without ended check)
     */
    enqueue(task: Task<unknown>): void;
    /**
     * Get the number of pending tasks in the queue
     */
    get pendingTaskCount(): number;
    /**
     * Get all pending tasks (mostly for testing)
     */
    get pendingTasks(): readonly Task[];
    /**
     * Check if the queue is empty
     */
    get isEmpty(): boolean;
    /**
     * Attempt to assign the next task to a ready process.
     * Returns true if a task was successfully assigned.
     */
    tryAssignNextTask(readyProcess: BatchProcess | undefined, retries?: number): boolean;
    /**
     * Process all pending tasks by assigning them to ready processes.
     * Returns the number of tasks successfully assigned.
     */
    processQueue(findReadyProcess: () => BatchProcess | undefined): number;
    /**
     * Clear all pending tasks (used during shutdown)
     */
    clearAllTasks(): void;
    /**
     * Get statistics about task assignment and queue state
     */
    getQueueStats(): {
        pendingTaskCount: number;
        isEmpty: boolean;
    };
}
