"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isJobInList = void 0;
const content = `--[[
  Checks if job is in a given list.
  Input:
    KEYS[1]
    ARGV[1]
  Output:
    1 if element found in the list.
]]
-- Includes
--[[
  Functions to check if a item belongs to a list.
]]
local function checkItemInList(list, item)
  for _, v in pairs(list) do
    if v == item then
      return 1
    end
  end
  return nil
end
local items = redis.call("LRANGE", KEYS[1] , 0, -1)
return checkItemInList(items, ARGV[1])
`;
exports.isJobInList = {
    name: 'isJobInList',
    content,
    keys: 1,
};
//# sourceMappingURL=isJobInList-1.js.map