"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.firstDateTime = firstDateTime;
const CapturedAtTagNames_1 = require("./CapturedAtTagNames");
const ExifDateTime_1 = require("./ExifDateTime");
const String_1 = require("./String");
/**
 * Returns the first date/time tag in `dateTimeTags` that strictly parses from
 * EXIF.
 */
function firstDateTime(tags, dateTimeTags = CapturedAtTagNames_1.CapturedAtTagNames) {
    for (const tag of dateTimeTags) {
        const dt = tags?.[tag];
        if (dt instanceof ExifDateTime_1.ExifDateTime) {
            return dt;
        }
        else if ((0, String_1.isString)(dt)) {
            const edt = ExifDateTime_1.ExifDateTime.fromEXIF(dt);
            if (edt != null) {
                return edt;
            }
        }
    }
    return;
}
//# sourceMappingURL=FirstDateTime.js.map