import { Maybe } from "./Maybe";
export declare function isNumber(n: unknown): n is number;
export declare function isInteger(n: unknown): n is number;
export declare function isFloat(n: unknown): n is number;
export declare function toFloat(n: unknown): Maybe<number>;
export declare function toInt(n: unknown): Maybe<number>;
/**
 * Rounds a number to a specified number of decimal places.
 *
 * @param value - The number to round
 * @param precision - The number of decimal places to retain
 * @returns The rounded number with specified precision
 *
 * @example
 * roundToDecimalPlaces(3.14159, 2) // Returns 3.14
 * roundToDecimalPlaces(123.456789, 3) // Returns 123.457
 * roundToDecimalPlaces(0.0001234, 4) // Returns 0.0001
 */
export declare function roundToDecimalPlaces(value: number, precision: number): number;
