import { DatabaseConnection, Dialect, DialectAdapter, Driver, Kysely, DatabaseIntrospector, QueryCompiler, PostgresDriver, CompiledQuery, QueryResult } from 'kysely';

interface PostgresJSDialectConfig {
    /**
     * Called every time a connection is acquired from the pool.
     */
    onReserveConnection?: (connection: DatabaseConnection) => Promise<void>;
    /**
     * An instance, or a factory returning an instance, of `postgres`'s `Sql` (returned by `postgres(...)`) or Bun's `SQL` class.
     */
    readonly postgres: PostgresJSSql | (() => PostgresJSSql | Promise<PostgresJSSql>);
}
interface PostgresJSSql {
    end(): Promise<void>;
    reserve(): Promise<PostgresJSReservedSql>;
}
interface PostgresJSReservedSql {
    release(): void;
    unsafe(query: string, parameters?: any[], queryOptions?: any): PostgresJSPendingQuery;
}
interface PostgresJSPendingQuery extends Promise<any[] & Iterable<any> & PostgresJSResultQueryMeta> {
    cursor?: (rows?: number) => AsyncIterable<any[]>;
}
interface PostgresJSResultQueryMeta {
    command: string;
    count: number;
}

declare class PostgresJSDialect implements Dialect {
    #private;
    constructor(config: PostgresJSDialectConfig);
    createAdapter(): DialectAdapter;
    createDriver(): Driver;
    createIntrospector(db: Kysely<any>): DatabaseIntrospector;
    createQueryCompiler(): QueryCompiler;
}

declare const RELEASE_CONNECTION_SYMBOL: unique symbol;
declare class PostgresJSDriver extends PostgresDriver {
    #private;
    constructor(config: PostgresJSDialectConfig);
    acquireConnection(): Promise<PostgresJSConnection>;
    destroy(): Promise<void>;
    init(): Promise<void>;
    releaseConnection(connection: DatabaseConnection): Promise<void>;
}
declare class PostgresJSConnection implements DatabaseConnection {
    #private;
    constructor(reservedConnection: PostgresJSReservedSql);
    executeQuery<R>(compiledQuery: CompiledQuery<unknown>): Promise<QueryResult<R>>;
    streamQuery<R>(compiledQuery: CompiledQuery<unknown>, chunkSize: number): AsyncIterableIterator<QueryResult<R>>;
    [RELEASE_CONNECTION_SYMBOL](): void;
}
declare class PostgresJSDialectError extends Error {
    constructor(message: string);
}

export { PostgresJSDialect, type PostgresJSDialectConfig, PostgresJSDialectError, PostgresJSDriver };
