/*
 *  GL/glu.h    OpenGL utility functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef __GLU_H__
#define __GLU_H__

#ifndef __glu_h__
#define __glu_h__

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#include <GL/gl.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Abstract data types */
typedef struct GLUnurbs         GLUnurbs;
typedef struct GLUquadric       GLUquadric;
typedef struct GLUtesselator    GLUtesselator;
typedef struct GLUnurbs         GLUnurbsObj;
typedef struct GLUquadric       GLUquadricObj;
typedef struct GLUtesselator    GLUtesselatorObj;
typedef struct GLUtesselator    GLUtriangulatorObj;

/* OpenGL utility version numbers */
#define GLU_VERSION_1_1 1
#define GLU_VERSION_1_2 1

/* OpenGL utility errors */
#define GLU_INVALID_ENUM            100900
#define GLU_INVALID_VALUE           100901
#define GLU_OUT_OF_MEMORY           100902
#define GLU_INCOMPATIBLE_GL_VERSION 100903

/* OpenGL utility string names */
#define GLU_VERSION     100800
#define GLU_EXTENSIONS  100801

/* OpenGL utility boolean values */
#define GLU_TRUE    GL_TRUE
#define GLU_FALSE   GL_FALSE

/* OpenGL utility quadric normal values */
#define GLU_SMOOTH  100000
#define GLU_FLAT    100001
#define GLU_NONE    100002

/* OpenGL utility quadric draw styles */
#define GLU_POINT       100010
#define GLU_LINE        100011
#define GLU_FILL        100012
#define GLU_SILHOUETTE  100013

/* OpenGL utility quadric orientations */
#define GLU_OUTSIDE 100020
#define GLU_INSIDE  100021

/* OpenGL utility tesselation maximum coordinate */
#define GLU_TESS_MAX_COORD  1.0e150

/* OpenGL utility tesselation properties */
#define GLU_TESS_WINDING_RULE   100140
#define GLU_TESS_BOUNDARY_ONLY  100141
#define GLU_TESS_TOLERANCE      100142

/* OpenGL utility tesselation winding values */
#define GLU_TESS_WINDING_ODD            100130
#define GLU_TESS_WINDING_NONZERO        100131
#define GLU_TESS_WINDING_POSITIVE       100132
#define GLU_TESS_WINDING_NEGATIVE       100133
#define GLU_TESS_WINDING_ABS_GEQ_TWO    100134

/* OpenGL utility tesselation callback values */
#define GLU_TESS_BEGIN          100100
#define GLU_TESS_VERTEX         100101
#define GLU_TESS_END            100102
#define GLU_TESS_ERROR          100103
#define GLU_TESS_EDGE_FLAG      100104
#define GLU_TESS_COMBINE        100105
#define GLU_TESS_BEGIN_DATA     100106
#define GLU_TESS_VERTEX_DATA    100107
#define GLU_TESS_END_DATA       100108
#define GLU_TESS_ERROR_DATA     100109
#define GLU_TESS_EDGE_FLAG_DATA 100110
#define GLU_TESS_COMBINE_DATA   100111

/* OpenGL utility tesselation errors */
#define GLU_TESS_ERROR1                 100151
#define GLU_TESS_ERROR2                 100152
#define GLU_TESS_ERROR3                 100153
#define GLU_TESS_ERROR4                 100154
#define GLU_TESS_ERROR5                 100155
#define GLU_TESS_ERROR6                 100156
#define GLU_TESS_ERROR7                 100157
#define GLU_TESS_ERROR8                 100158
#define GLU_TESS_MISSING_BEGIN_POLYGON  GLU_TESS_ERROR1
#define GLU_TESS_MISSING_BEGIN_CONTOUR  GLU_TESS_ERROR2
#define GLU_TESS_MISSING_END_POLYGON    GLU_TESS_ERROR3
#define GLU_TESS_MISSING_END_CONTOUR    GLU_TESS_ERROR4
#define GLU_TESS_COORD_TOO_LARGE        GLU_TESS_ERROR5
#define GLU_TESS_NEED_COMBINE_CALLBACK  GLU_TESS_ERROR6

/* OpenGL utility NURBS properties */
#define GLU_AUTO_LOAD_MATRIX        100200
#define GLU_CULLING                 100201
#define GLU_PARAMETRIC_TOLERANCE    100202
#define GLU_SAMPLING_TOLERANCE      100203
#define GLU_DISPLAY_MODE            100204
#define GLU_SAMPLING_METHOD         100205
#define GLU_U_STEP                  100206
#define GLU_V_STEP                  100207

/* OpenGL utility NURBS sampling values */
#define GLU_PATH_LENGTH         100215
#define GLU_PARAMETRIC_ERROR    100216
#define GLU_DOMAIN_DISTANCE     100217

/* OpenGL utility NURBS trim values */
#define GLU_MAP1_TRIM_2 100210
#define GLU_MAP1_TRIM_3 100211

/* OpenGL utility NURBS display values */
#define GLU_OUTLINE_POLYGON 100240
#define GLU_OUTLINE_PATCH   100241

/* OpenGL utility NURBS errors */
#define GLU_NURBS_ERROR1    100251
#define GLU_NURBS_ERROR2    100252
#define GLU_NURBS_ERROR3    100253
#define GLU_NURBS_ERROR4    100254
#define GLU_NURBS_ERROR5    100255
#define GLU_NURBS_ERROR6    100256
#define GLU_NURBS_ERROR7    100257
#define GLU_NURBS_ERROR8    100258
#define GLU_NURBS_ERROR9    100259
#define GLU_NURBS_ERROR10   100260
#define GLU_NURBS_ERROR11   100261
#define GLU_NURBS_ERROR12   100262
#define GLU_NURBS_ERROR13   100263
#define GLU_NURBS_ERROR14   100264
#define GLU_NURBS_ERROR15   100265
#define GLU_NURBS_ERROR16   100266
#define GLU_NURBS_ERROR17   100267
#define GLU_NURBS_ERROR18   100268
#define GLU_NURBS_ERROR19   100269
#define GLU_NURBS_ERROR20   100270
#define GLU_NURBS_ERROR21   100271
#define GLU_NURBS_ERROR22   100272
#define GLU_NURBS_ERROR23   100273
#define GLU_NURBS_ERROR24   100274
#define GLU_NURBS_ERROR25   100275
#define GLU_NURBS_ERROR26   100276
#define GLU_NURBS_ERROR27   100277
#define GLU_NURBS_ERROR28   100278
#define GLU_NURBS_ERROR29   100279
#define GLU_NURBS_ERROR30   100280
#define GLU_NURBS_ERROR31   100281
#define GLU_NURBS_ERROR32   100282
#define GLU_NURBS_ERROR33   100283
#define GLU_NURBS_ERROR34   100284
#define GLU_NURBS_ERROR35   100285
#define GLU_NURBS_ERROR36   100386
#define GLU_NURBS_ERROR37   100387

/* OpenGL utility contour types */
#define GLU_CW          100120
#define GLU_CCW         100121
#define GLU_INTERIOR    100122
#define GLU_EXTERIOR    100123
#define GLU_UNKNOWN     100124

/* Old names for compatibility */
#define GLU_BEGIN       GLU_TESS_BEGIN
#define GLU_VERTEX      GLU_TESS_VERTEX
#define GLU_END         GLU_TESS_END
#define GLU_ERROR       GLU_TESS_ERROR
#define GLU_EDGE_FLAG   GLU_EDGE_FLAG

/* OpenGL utility callbacks */
typedef void (CALLBACK *GLUquadricErrorProc)( GLenum );
typedef void (CALLBACK *GLUtessBeginProc)( GLenum );
typedef void (CALLBACK *GLUtessEdgeFlagProc)( GLboolean );
typedef void (CALLBACK *GLUtessVertexProc)( void * );
typedef void (CALLBACK *GLUtessEndProc)( void );
typedef void (CALLBACK *GLUtessErrorProc)( GLenum );
typedef void (CALLBACK *GLUtessCombineProc)( GLdouble [3], void * [4], GLfloat [4], void ** );
typedef void (CALLBACK *GLUtessBeginDataProc)( GLenum, void * );
typedef void (CALLBACK *GLUtessEdgeFlagDataProc)( GLboolean, void * );
typedef void (CALLBACK *GLUtessVertexDataProc)( void *, void * );
typedef void (CALLBACK *GLUtessEndDataProc)( void * );
typedef void (CALLBACK *GLUtessErrorDataProc)( GLenum, void * );
typedef void (CALLBACK *GLUtessCombineDataProc)( GLdouble[3], void * [4], GLfloat [4], void **, void * );
typedef void (CALLBACK *GLUnurbsErrorProc)( GLenum );

/* Functions in GLU32.DLL */
void APIENTRY               gluBeginCurve( GLUnurbs * );
void APIENTRY               gluBeginPolygon( GLUtesselator * );
void APIENTRY               gluBeginSurface( GLUnurbs * );
void APIENTRY               gluBeginTrim( GLUnurbs * );
int APIENTRY                gluBuild1DMipmaps( GLenum, GLint, GLint, GLenum, GLenum, const void * );
int APIENTRY                gluBuild2DMipmaps( GLenum, GLint, GLint, GLint, GLenum, GLenum, const void * );
void APIENTRY               gluCylinder( GLUquadric *, GLdouble, GLdouble, GLdouble, GLint, GLint );
void APIENTRY               gluDeleteNurbsRenderer( GLUnurbs * );
void APIENTRY               gluDeleteQuadric( GLUquadric * );
void APIENTRY               gluDeleteTess( GLUtesselator * );
void APIENTRY               gluDisk( GLUquadric *, GLdouble, GLdouble, GLint, GLint );
void APIENTRY               gluEndCurve( GLUnurbs * );
void APIENTRY               gluEndPolygon( GLUtesselator * );
void APIENTRY               gluEndSurface( GLUnurbs * );
void APIENTRY               gluEndTrim( GLUnurbs * );
const GLubyte * APIENTRY    gluErrorString( GLenum );
const wchar_t * APIENTRY    gluErrorUnicodeStringEXT( GLenum );
void APIENTRY               gluGetNurbsProperty( GLUnurbs *, GLenum, GLfloat * );
const GLubyte * APIENTRY    gluGetString( GLenum );
void APIENTRY               gluGetTessProperty( GLUtesselator *, GLenum, GLdouble * );
void APIENTRY               gluLoadSamplingMatrices( GLUnurbs *, const GLfloat [16], const GLfloat [16], const GLint[4] );
void APIENTRY               gluLookAt( GLdouble, GLdouble, GLdouble, GLdouble, GLdouble, GLdouble, GLdouble, GLdouble, GLdouble );
GLUnurbs * APIENTRY         gluNewNurbsRenderer( void );
GLUquadric * APIENTRY       gluNewQuadric( void );
GLUtesselator * APIENTRY    gluNewTess( void );
void APIENTRY               gluNextContour( GLUtesselator *, GLenum );
void APIENTRY               gluNurbsCallback( GLUnurbs *, GLenum, void (CALLBACK *)() );
void APIENTRY               gluNurbsCurve( GLUnurbs *, GLint, GLfloat *, GLint, GLfloat *, GLint, GLenum );
void APIENTRY               gluNurbsProperty( GLUnurbs *, GLenum, GLfloat );
void APIENTRY               gluNurbsSurface( GLUnurbs *, GLint, float *, GLint, GLfloat *, GLint, GLint, GLfloat *, GLint, GLint, GLenum );
void APIENTRY               gluOrtho2D( GLdouble, GLdouble, GLdouble, GLdouble );
void APIENTRY               gluPartialDisk( GLUquadric *, GLdouble, GLdouble, GLint, GLint, GLdouble, GLdouble );
void APIENTRY               gluPerspective( GLdouble, GLdouble, GLdouble, GLdouble );
void APIENTRY               gluPickMatrix( GLdouble, GLdouble, GLdouble, GLdouble, GLint [4] );
int APIENTRY                gluProject( GLdouble, GLdouble, GLdouble, const GLdouble [16], const GLdouble [16], const GLint [4], GLdouble *, GLdouble *, GLdouble * );
void APIENTRY               gluPwlCurve( GLUnurbs *, GLint, GLfloat *, GLint, GLenum );
void APIENTRY               gluQuadricCallback( GLUquadric *, GLenum, void (CALLBACK *)() );
void APIENTRY               gluQuadricDrawStyle( GLUquadric *, GLenum );
void APIENTRY               gluQuadricNormals( GLUquadric *, GLenum );
void APIENTRY               gluQuadricOrientation( GLUquadric *, GLenum );
void APIENTRY               gluQuadricTexture( GLUquadric *, GLboolean );
int APIENTRY                gluScaleImage( GLenum, GLint, GLint, GLenum, const void *, GLint, GLint, GLenum, void * );
void APIENTRY               gluSphere( GLUquadric *, GLdouble, GLint, GLint );
void APIENTRY               gluTessBeginContour( GLUtesselator * );
void APIENTRY               gluTessBeginPolygon( GLUtesselator *, void * );
void APIENTRY               gluTessCallback( GLUtesselator *, GLenum, void (CALLBACK *)() );
void APIENTRY               gluTessEndContour( GLUtesselator * );
void APIENTRY               gluTessEndPolygon( GLUtesselator * );
void APIENTRY               gluTessNormal( GLUtesselator *, GLdouble, GLdouble, GLdouble );
void APIENTRY               gluTessProperty( GLUtesselator *, GLenum, GLdouble );
void APIENTRY               gluTessVertex( GLUtesselator *, GLdouble [3], void * );
int APIENTRY                gluUnProject( GLdouble, GLdouble, GLdouble, const GLdouble [16], const GLdouble [16], const GLint [4], GLdouble *, GLdouble *, GLdouble * );

/* Functions implemented as macros */
#ifdef UNICODE
    #define gluErrorStringWIN( x )  (LPCWSTR)gluErrorUnicodeStringEXT( x )
#else
    #define gluErrorStringWIN( x )  (LPCSTR)gluErrorString( x )
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __glu_h__ */

#endif /* __GLU_H__ */
