/*
 *  mountmgr.h  Mount point manager definitions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _MOUNTMGR_
#define _MOUNTMGR_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Mount point manager device names */
#if (NTDDI_VERSION >= 0x05000000)
    #define MOUNTMGR_DEVICE_NAME        L"\\Device\\MountPointManager"
    #define MOUNTMGR_DOS_DEVICE_NAME    L"\\\\.\\MountPointManager"
#endif

/* Mount control types */
#if (NTDDI_VERSION >= 0x05000000)
    #define MOUNTMGRCONTROLTYPE 0x0000006DL
    #define MOUNTDEVCONTROLTYPE 0x0000004DL
#endif

/* Mount point manager device I/O control types */
#if (NTDDI_VERSION >= 0x05000000)
    #define IOCTL_MOUNTMGR_CREATE_POINT \
        CTL_CODE( MOUNTMGRCONTROLTYPE, 0, METHOD_BUFFERED, FILE_READ_ACCESS | \
        FILE_WRITE_ACCESS )
    #define IOCTL_MOUNTMGR_DELETE_POINTS \
        CTL_CODE( MOUNTMGRCONTROLTYPE, 1, METHOD_BUFFERED, FILE_READ_ACCESS | \
        FILE_WRITE_ACCESS )
    #define IOCTL_MOUNTMGR_QUERY_POINTS \
        CTL_CODE( MOUNTMGRCONTROLTYPE, 2, METHOD_BUFFERED, FILE_ANY_ACCESS )
    #define IOCTL_MOUNTMGR_DELETE_POINTS_DBONLY \
        CTL_CODE( MOUNTMGRCONTROLTYPE, 3, METHOD_BUFFERED, FILE_READ_ACCESS | \
        FILE_WRITE_ACCESS )
    #define IOCTL_MOUNTMGR_NEXT_DRIVE_LETTER \
        CTL_CODE( MOUNTMGRCONTROLTYPE, 4, METHOD_BUFFERED, FILE_READ_ACCESS | \
        FILE_WRITE_ACCESS )
    #define IOCTL_MOUNTMGR_AUTO_DL_ASSIGNMENTS \
        CTL_CODE( MOUNTMGRCONTROLTYPE, 5, METHOD_BUFFERED, FILE_READ_ACCESS | \
        FILE_WRITE_ACCESS )
    #define IOCTL_MOUNTMGR_VOLUME_MOUNT_POINT_CREATED \
        CTL_CODE( MOUNTMGRCONTROLTYPE, 6, METHOD_BUFFERED, FILE_READ_ACCESS | \
        FILE_WRITE_ACCESS )
    #define IOCTL_MOUNTMGR_VOLUME_MOUNT_POINT_DELETED \
        CTL_CODE( MOUNTMGRCONTROLTYPE, 7, METHOD_BUFFERED, FILE_READ_ACCESS | \
        FILE_WRITE_ACCESS )
    #define IOCTL_MOUNTMGR_CHANGE_NOTIFY \
        CTL_CODE( MOUNTMGRCONTROLTYPE, 8, METHOD_BUFFERED, FILE_READ_ACCESS )
    #define IOCTL_MOUNTMGR_KEEP_LINKS_WHEN_OFFLINE \
        CTL_CODE( MOUNTMGRCONTROLTYPE, 9, METHOD_BUFFERED, FILE_READ_ACCESS | \
        FILE_WRITE_ACCESS )
    #define IOCTL_MOUNTMGR_CHECK_UNPROCESSED_VOLUMES \
        CTL_CODE( MOUNTMGRCONTROLTYPE, 10, METHOD_BUFFERED, FILE_READ_ACCESS )
    #define IOCTL_MOUNTMGR_VOLUME_ARRIVAL_NOTIFICATION \
        CTL_CODE( MOUNTMGRCONTROLTYPE, 11, METHOD_BUFFERED, FILE_READ_ACCESS )
#endif
#if (NTDDI_VERSION >= 0x05010000)
    #define IOCTL_MOUNTMGR_QUERY_DOS_VOLUME_PATH \
        CTL_CODE( MOUNTMGRCONTROLTYPE, 12, METHOD_BUFFERED, FILE_ANY_ACCESS )
    #define IOCTL_MOUNTMGR_QUERY_DOS_VOLUME_PATHS \
        CTL_CODE( MOUNTMGRCONTROLTYPE, 13, METHOD_BUFFERED, FILE_ANY_ACCESS )
#endif
#if (NTDDI_VERSION >= 0x05020000)
    #define IOCTL_MOUNTMGR_SCRUB_REGISTRY \
        CTL_CODE( MOUNTMGRCONTROLTYPE, 14, METHOD_BUFFERED, FILE_READ_ACCESS | \
        FILE_WRITE_ACCESS )
    #define IOCTL_MOUNTMGR_QUERY_AUTO_MOUNT \
        CTL_CODE( MOUNTMGRCONTROLTYPE, 15, METHOD_BUFFERED, FILE_ANY_ACCESS)
    #define IOCTL_MOUNTMGR_SET_AUTO_MOUNT \
        CTL_CODE( MOUNTMGRCONTROLTYPE, 16, METHOD_BUFFERED, FILE_READ_ACCESS | \
        FILE_WRITE_ACCESS )
#endif
#if (NTDDI_VERSION >= 0x06010000)
    #define IOCTL_MOUNTMGR_BOOT_DL_ASSIGNMENT \
        CTL_CODE( MOUNTMGRCONTROLTYPE, 17, METHOD_BUFFERED, FILE_READ_ACCESS | \
        FILE_WRITE_ACCESS )
    #define IOCTL_MOUNTMGR_TRACELOG_CACHE \
        CTL_CODE( MOUNTMGRCONTROLTYPE, 18, METHOD_BUFFERED, FILE_READ_ACCESS )
#endif

/* Mount device I/O control codes */
#if (NTDDI_VERSION >= 0x05000000)
    #define IOCTL_MOUNTDEV_QUERY_DEVICE_NAME \
        CTL_CODE( MOUNTDEVCONTROLTYPE, 2, METHOD_BUFFERED, FILE_ANY_ACCESS )
#endif

/* IOCTL_MOUNTMGR_CREATE_POINT parameters */
#if (NTDDI_VERSION >= 0x05000000)
typedef struct _MOUNTMGR_CREATE_POINT_INPUT {
    USHORT  SymbolicLinkNameOffset;
    USHORT  SymbolicLinkNameLength;
    USHORT  DeviceNameOffset;
    USHORT  DeviceNameLength;
} MOUNTMGR_CREATE_POINT_INPUT;
typedef MOUNTMGR_CREATE_POINT_INPUT *PMOUNTMGR_CREATE_POINT_INPUT;
#endif

/* Mount point manager mount point */
#if (NTDDI_VERSION >= 0x05000000)
typedef struct _MOUNTMGR_MOUNT_POINT {
    ULONG   SymbolicLinkNameOffset;
    USHORT  SymbolicLinkNameLength;
    ULONG   UniqueIdOffset;
    USHORT  UniqueIdLength;
    ULONG   DeviceNameOffset;
    USHORT  DeviceNameLength;
} MOUNTMGR_MOUNT_POINT;
typedef MOUNTMGR_MOUNT_POINT    *PMOUNTMGR_MOUNT_POINT;
#endif

/* Mount point manager mount points */
#if (NTDDI_VERSION >= 0x05000000)
typedef struct _MOUNTMGR_MOUNT_POINTS {
    ULONG                   Size;
    ULONG                   NumberOfMountPoints;
    MOUNTMGR_MOUNT_POINT    MountPoints[1];
} MOUNTMGR_MOUNT_POINTS;
typedef MOUNTMGR_MOUNT_POINTS   *PMOUNTMGR_MOUNT_POINTS;
#endif

/* IOCTL_MOUNTMGR_NEXT_DRIVE_LETTER parameters */
#if (NTDDI_VERSION >= 0x05000000)
typedef struct _MOUNTMGR_DRIVE_LETTER_TARGET {
    USHORT  DeviceNameLength;
    WCHAR   DeviceName[1];
} MOUNTMGR_DRIVE_LETTER_TARGET;
typedef MOUNTMGR_DRIVE_LETTER_TARGET    *PMOUNTMGR_DRIVE_LETTER_TARGET;
#endif

/* Mount point manager drive letter information */
#if (NTDDI_VERSION >= 0x05000000)
typedef struct _MOUNTMGR_DRIVE_LETTER_INFORMATION {
    BOOLEAN DriveLetterWasAssigned;
    UCHAR   CurrentDriveLetter;
} MOUNTMGR_DRIVE_LETTER_INFORMATION;
typedef MOUNTMGR_DRIVE_LETTER_INFORMATION   *PMOUNTMGR_DRIVE_LETTER_INFORMATION;
#endif

/* Mount point manager volume mount point */
#if (NTDDI_VERSION >= 0x05000000)
typedef struct _MOUNTMGR_VOLUME_MOUNT_POINT {
    USHORT  SourceVolumeNameOffset;
    USHORT  SourceVolumeNameLength;
    USHORT  TargetVolumeNameOffset;
    USHORT  TargetVolumeNameLength;
} MOUNTMGR_VOLUME_MOUNT_POINT;
typedef MOUNTMGR_VOLUME_MOUNT_POINT *PMOUNTMGR_VOLUME_MOUNT_POINT;
#endif

/* Mount point manager change notification information */
#if (NTDDI_VERSION >= 0x05000000)
typedef struct _MOUNTMGR_CHANGE_NOTIFY_INFO {
    ULONG   EpicNumber;
} MOUNTMGR_CHANGE_NOTIFY_INFO;
typedef MOUNTMGR_CHANGE_NOTIFY_INFO *PMOUNTMGR_CHANGE_NOTIFY_INFO;
#endif

/* Mount point manager target name */
#if (NTDDI_VERSION >= 0x05000000)
typedef struct _MOUNTMGR_TARGET_NAME {
    USHORT  DeviceNameLength;
    WCHAR   DeviceName[1];
} MOUNTMGR_TARGET_NAME;
typedef MOUNTMGR_TARGET_NAME    *PMOUNTMGR_TARGET_NAME;
#endif

/* Mount point manager macros */
#if (NTDDI_VERSION >= 0x05000000)
    #define MOUNTMGR_IS_DRIVE_LETTER( x ) \
        ((x)->Length == 28 && (x)->Buffer[0] == '\\' && (x)->Buffer[1] == 'D' && \
        (x)->Buffer[2] == 'o' && (x)->Buffer[3] == 's' && (x)->Buffer[4] == 'D' && \
        (x)->Buffer[5] == 'e' && (x)->Buffer[6] == 'v' && (x)->Buffer[7] == 'i' && \
        (x)->Buffer[8] == 'c' && (x)->Buffer[9] == 'e' && (x)->Buffer[10] == 's' && \
        (x)->Buffer[11] == '\\' && (x)->Buffer[12] >= 'A' && (x)->Buffer[12] <= 'Z' && \
        (x)->Buffer[13] == ':')
    #define MOUNTMGR_IS_VOLUME_NAME( x ) \
        (((x)->Length == 96 || ((x)->Length == 98 && (x)->Buffer[48] == '\\')) && \
        (x)->Buffer[0] == '\\' && ((x)->Buffer[1] == '?' || (x)->Buffer[1] == '\\') && \
        (x)->Buffer[2] == '?' && (x)->Buffer[3] == '\\' && (x)->Buffer[4] == 'v' && \
        (x)->Buffer[5] == 'o' && (x)->Buffer[6] == 'l' && (x)->Buffer[7] == 'u' && \
        (x)->Buffer[8] == 'm' && (x)->Buffer[9] == 'e' && (x)->Buffer[10] == '{' && \
        (x)->Buffer[19] == '-' && (x)->Buffer[24] == '-' && (x)->Buffer[29] == '-' && \
        (x)->Buffer[34] == '-' && (x)->Buffer[47] == '}')
#endif
#if (NTDDI_VERSION >= 0x05010000)
    #define MOUNTMGR_IS_DOS_VOLUME_NAME( x ) \
        (MOUNTMGR_IS_VOLUME_NAME( x ) && (x)->Length == 96 && (x)->Buffer[1] == '\\')
    #define MOUNTMGR_IS_DOS_VOLUME_NAME_WB( x ) \
        (MOUNTMGR_IS_VOLUME_NAME( x ) && (x)->Length == 98 && (x)->Buffer[1] == '\\')
    #define MOUNTMGR_IS_NT_VOLUME_NAME( x ) \
        (MOUNTMGR_IS_VOLUME_NAME( x ) && (x)->Length == 96 && (x)->Buffer[1] == '?')
    #define MOUNTMGR_IS_NT_VOLUME_NAME_WB( x ) \
        (MOUNTMGR_IS_VOLUME_NAME( x ) && (x)->Length == 98 && (x)->Buffer[1] == '?')
#endif

/* Mount device name */
#if (NTDDI_VERSION >= 0x05000000)
typedef struct _MOUNTDEV_NAME {
    USHORT  NameLength;
    WCHAR   Name[1];
} MOUNTDEV_NAME;
typedef MOUNTDEV_NAME   *PMOUNTDEV_NAME;
#endif

/* Mount point manager volume paths */
#if (NTDDI_VERSION >= 0x05010000)
typedef struct _MOUNTMGR_VOLUME_PATHS {
    ULONG   MultiSzLength;
    WCHAR   MultiSz[1];
} MOUNTMGR_VOLUME_PATHS;
typedef MOUNTMGR_VOLUME_PATHS   *PMOUNTMGR_VOLUME_PATHS;
#endif

/* Mount point manager automatic mount states */
#if (NTDDI_VERSION >= 0x05020000)
typedef enum _MOUNTMGR_AUTO_MOUNT_STATE {
    Disabled    = 0,
    Enabled     = 1
} MOUNTMGR_AUTO_MOUNT_STATE;
#endif

/* IOCTL_MOUNTMGR_QUERY_AUTO_MOUNT parameters */
#if (NTDDI_VERSION >= 0x05020000)
typedef struct _MOUNTMGR_QUERY_AUTO_MOUNT {
    MOUNTMGR_AUTO_MOUNT_STATE   CurrentState;
} MOUNTMGR_QUERY_AUTO_MOUNT;
typedef MOUNTMGR_QUERY_AUTO_MOUNT   *PMOUNTMGR_QUERY_AUTO_MOUNT;
#endif

/* IOCTL_MOUNTMGR_SET_AUTO_MOUNT parameters */
#if (NTDDI_VERSION >= 0x05020000)
typedef struct _MOUNTMGR_SET_AUTO_MOUNT {
    MOUNTMGR_AUTO_MOUNT_STATE   NewState;
} MOUNTMGR_SET_AUTO_MOUNT;
typedef MOUNTMGR_SET_AUTO_MOUNT *PMOUNTMGR_SET_AUTO_MOUNT;
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _MOUNTMGR_ */
