/*
 *  ntifs.h     NT Installable File System (IFS) functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _NTIFS_
#define _NTIFS_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#include <ntddk.h>
#include <ntnls.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Primitive data types */
typedef ULONG_PTR           SID_HASH_ENTRY;
typedef ULONG_PTR           *PSID_HASH_ENTRY;
typedef USHORT              SECURITY_DESCRIPTOR_CONTROL;
typedef USHORT              *PSECURITY_DESCRIPTOR_CONTROL;
typedef ULONG               LSA_OPERATIONAL_MODE;
typedef ULONG               *PLSA_OPERATIONAL_MODE;
typedef UNICODE_STRING      LSA_UNICODE_STRING;
typedef UNICODE_STRING      *PLSA_UNICODE_STRING;
typedef STRING              LSA_STRING;
typedef STRING              *PLSA_STRING;
typedef OBJECT_ATTRIBUTES   LSA_OBJECT_ATTRIBUTES;
typedef OBJECT_ATTRIBUTES   *PLSA_OBJECT_ATTRIBUTES;
typedef ULONG               ACCESS_REASON;
typedef ULONG               LBN;
typedef LBN                 *PLBN;
typedef ULONG               VBN;
typedef VBN                 *PVBN;
typedef PVOID               OPLOCK;
typedef PVOID               *POPLOCK;
typedef PVOID               PNOTIFY_SYNC;
#if (NTDDI_VERSION >= 0x06000000)
typedef ULONG               FSRTL_ALLOCATE_ECPLIST_FLAGS;
typedef ULONG               FSRTL_ALLOCATE_ECP_FLAGS;
typedef ULONG               FSRTL_ECP_LOOKASIDE_FLAGS;
#endif

/* Data type aliases */
#define EX_PUSH_LOCK    ULONG_PTR
#define PEX_PUSH_LOCK   PULONG_PTR

/* Flag manipulation macros */
#ifndef FlagOn
    #define FlagOn( x, p )          ((x) & (p))
#endif
#ifndef BooleanFlagOn
    #define BooleanFlagOn( x, p )   ((BOOLEAN)(((x) & (p)) != 0))
#endif
#ifndef SetFlag
    #define SetFlag( x, p )         ((x) |= (p))
#endif
#ifndef ClearFlag
    #define ClearFlag( x, p )       ((x) &= ~(p))
#endif

/* Current SID revision */
#define SID_REVISION    1

/* SID hash size */
#define SID_HASH_SIZE   32

/* SID identifier authority values */
#define SECURITY_NULL_SID_AUTHORITY         { 0, 0, 0, 0, 0, 0 }
#define SECURITY_WORLD_SID_AUTHORITY        { 0, 0, 0, 0, 0, 1 }
#define SECURITY_LOCAL_SID_AUTHORITY        { 0, 0, 0, 0, 0, 2 }
#define SECURITY_CREATOR_SID_AUTHORITY      { 0, 0, 0, 0, 0, 3 }
#define SECURITY_NON_UNIQUE_AUTHORITY       { 0, 0, 0, 0, 0, 4 }
#define SECURITY_NT_AUTHORITY               { 0, 0, 0, 0, 0, 5 }
#define SECURITY_RESOURCE_MANAGER_AUTHORITY { 0, 0, 0, 0, 0, 9 }
#define SECURITY_MANDATORY_LABEL_AUTHORITY  { 0, 0, 0, 0, 0, 16 }

/* Relative identifiers */
#define SECURITY_NULL_RID                               0x00000000L
#define SECURITY_WORLD_RID                              0x00000000L
#define SECURITY_LOCAL_RID                              0x00000000L
#define SECURITY_LOCAL_LOGON_RID                        0x00000001L
#define SECURITY_CREATOR_OWNER_RID                      0x00000000L
#define SECURITY_CREATOR_GROUP_RID                      0x00000001L
#define SECURITY_CREATOR_OWNER_SERVER_RID               0x00000002L
#define SECURITY_CREATOR_GROUP_SERVER_RID               0x00000003L
#define SECURITY_CREATOR_OWNER_RIGHTS_RID               0x00000004L
#define SECURITY_DIALUP_RID                             0x00000001L
#define SECURITY_NETWORK_RID                            0x00000002L
#define SECURITY_BATCH_RID                              0x00000003L
#define SECURITY_INTERACTIVE_RID                        0x00000004L
#define SECURITY_LOGON_IDS_RID                          0x00000005L
#define SECURITY_SERVICE_RID                            0x00000006L
#define SECURITY_ANONYMOUS_LOGON_RID                    0x00000007L
#define SECURITY_PROXY_RID                              0x00000008L
#define SECURITY_ENTERPRISE_CONTROLLERS_RID             0x00000009L
#define SECURITY_SERVER_LOGON_RID \
    SECURITY_ENTERPRISE_CONTROLLERS_RID
#define SECURITY_PRINCIPAL_SELF_RID                     0x0000000AL
#define SECURITY_AUTHENTICATED_USER_RID                 0x0000000BL
#define SECURITY_RESTRICTED_CODE_RID                    0x0000000CL
#define SECURITY_TERMINAL_SERVER_RID                    0x0000000DL
#define SECURITY_REMOTE_LOGON_RID                       0x0000000EL
#define SECURITY_THIS_ORGANIZATION_RID                  0x0000000FL
#define SECURITY_IUSER_RID                              0x00000011L
#define SECURITY_LOCAL_SYSTEM_RID                       0x00000012L
#define SECURITY_LOCAL_SERVICE_RID                      0x00000013L
#define SECURITY_NETWORK_SERVICE_RID                    0x00000014L
#define SECURITY_NT_NON_UNIQUE                          0x00000015L
#define SECURITY_ENTERPRISE_READONLY_CONTROLLERS_RID    0x00000016L
#define SECURITY_BUILTIN_DOMAIN_RID                     0x00000020L
#define SECURITY_WRITE_RESTRICTED_CODE_RID              0x00000021L
#define SECURITY_PACKAGE_BASE_RID                       0x00000040L
#define SECURITY_PACKAGE_NTLM_RID                       0x0000000AL
#define SECURITY_PACKAGE_SCHANNEL_RID                   0x0000000EL
#define SECURITY_PACKAGE_DIGEST_RID                     0x00000015L
#define SECURITY_CRED_TYPE_BASE_RID                     0x00000041L
#define SECURITY_CRED_TYPE_THIS_ORG_CERT_RID            0x00000001L
#define SECURITY_MIN_BASE_RID                           0x00000050L
#define SECURITY_SERVICE_ID_BASE_RID                    0x00000050L
#define SECURITY_RESERVED_ID_BASE_RID                   0x00000051L
#define SECURITY_APPPOOL_ID_BASE_RID                    0x00000052L
#define SECURITY_VIRTUALSERVER_ID_BASE_RID              0x00000053L
#define SECURITY_USERMODEDRIVERHOST_ID_BASE_RID         0x00000054L
#define SECURITY_CLOUD_INFRASTRUCTURE_SERVICES_ID_BASE_RID  0x00000055L
#define SECURITY_WMIHOST_ID_BASE_RID                    0x00000056L
#define SECURITY_TASK_ID_BASE_RID                       0x00000057L
#define SECURITY_NFS_ID_BASE_RID                        0x00000058L
#define SECURITY_COM_ID_BASE_RID                        0x00000059L
#define SECURITY_MAX_BASE_RID                           0x0000006FL
#define SECURITY_MAX_ALWAYS_FITLERED                    0x000003E7L
#define SECURITY_MIN_NEVER_FILTERED                     0x000003E8L
#define SECURITY_OTHER_ORGANIZATION_RID                 0x000003E8L
#define SECURITY_WINDOWSMOBILE_ID_BASE_RID              0x00000070L
#define SECURITY_MANDATORY_UNTRUSTED_RID                0x00000000L
#define SECURITY_MANDATORY_LOW_RID                      0x00001000L
#define SECURITY_MANDATORY_MEDIUM_RID                   0x00002000L
#define SECURITY_MANDATORY_HIGH_RID                     0x00003000L
#define SECURITY_MANDATORY_SYSTEM_RID                   0x00004000L
#define SECURITY_MANDATORY_PROTECTED_PROCESS_RID        0x00005000L
#define SECURITY_MANDATORY_MAXIMUM_USER_RID \
    SECURITY_MANDATORY_SYSTEM_RID

/* Relative identifier counts */
#define SECURITY_LOGON_IDS_RID_COUNT                        3L
#define SECURITY_NT_NON_UNIQUE_SUB_AUTH_COUNT               3L
#define SECURITY_PACKAGE_RID_COUNT                          2L
#define SECURITY_CRED_TYPE_RID_COUNT                        2L
#define SECURITY_SERVICE_ID_RID_COUNT                       6L
#define SECURITY_APPPOOL_ID_RID_COUNT                       6L
#define SECURITY_VIRTUALSERVER_ID_RID_COUNT                 6L
#define SECURITY_USERMODEDRIVERHOST_ID_RID_COUNT            6L
#define SECURITY_CLOUD_INFRASTRUCTURE_SERVICES_ID_RID_COUNT 6L
#define SECURITY_WMIHOST_ID_RID_COUNT                       6L
#define SECURITY_VIRTUALACCOUNT_ID_RID_COUNT                6L

/* ACE types */
#define ACCESS_ALLOWED_ACE_TYPE                 0x00
#define ACCESS_DENIED_ACE_TYPE                  0x01
#define SYSTEM_AUDIT_ACE_TYPE                   0x02
#define SYSTEM_ALARM_ACE_TYPE                   0x03
#define ACCESS_ALLOWED_COMPOUND_ACE_TYPE        0x04
#define ACCESS_ALLOWED_OBJECT_ACE_TYPE          0x05
#define ACCESS_DENIED_OBJECT_ACE_TYPE           0x06
#define SYSTEM_AUDIT_OBJECT_ACE_TYPE            0x07
#define SYSTEM_ALARM_OBJECT_ACE_TYPE            0x08
#define ACCESS_ALLOWED_CALLBACK_ACE_TYPE        0x09
#define ACCESS_DENIED_CALLBACK_ACE_TYPE         0x0A
#define ACCESS_ALLOWED_CALLBACK_OBJECT_ACE_TYPE 0x0B
#define ACCESS_DENIED_CALLBACK_OBJECT_ACE_TYPE  0x0C
#define SYSTEM_AUDIT_CALLBACK_ACE_TYPE          0x0D
#define SYSTEM_ALARM_CALLBACK_ACE_TYPE          0x0E
#define SYSTEM_AUDIT_CALLBACK_OBJECT_ACE_TYPE   0x0F
#define SYSTEM_ALARM_CALLBACK_OBJECT_ACE_TYPE   0x10
#define SYSTEM_MANDATORY_LABEL_ACE_TYPE         0x11
#define ACCESS_MIN_MS_ACE_TYPE                  ACCESS_ALLOWED_ACE_TYPE
#define ACCESS_MAX_MS_ACE_TYPE                  SYSTEM_ALARM_OBJECT_ACE_TYPE
#define ACCESS_MAX_MS_V2_ACE_TYPE               SYSTEM_ALARM_ACE_TYPE
#define ACCESS_MAX_MS_V3_ACE_TYPE               ACCESS_ALLOWED_COMPOUND_ACE_TYPE
#define ACCESS_MAX_MS_V4_ACE_TYPE               SYSTEM_ALARM_OBJECT_ACE_TYPE
#define ACCESS_MAX_MS_V5_ACE_TYPE               SYSTEM_MANDATORY_LABEL_ACE_TYPE
#define ACCESS_MIN_MS_OBJECT_ACE_TYPE           ACCESS_ALLOWED_OBJECT_ACE_TYPE
#define ACCESS_MAX_MS_OBJECT_ACE_TYPE           SYSTEM_ALARM_OBJECT_ACE_TYPE

/* ACE inherit flags */
#define OBJECT_INHERIT_ACE          0x01
#define CONTAINER_INHERIT_ACE       0x02
#define NO_PROPAGATE_INHERIT_ACE    0x04
#define INHERIT_ONLY_ACE            0x08
#define INHERITED_ACE               0x10
#define VALID_INHERIT_FLAGS         0x1F

/* ACE flags */
#define SUCCESSFUL_ACCESS_ACE_FLAG  0x40
#define FAILED_ACCESS_ACE_FLAG      0x80

/* System mandatory label ACE access mask flags */
#define SYSTEM_MANDATORY_LABEL_NO_WRITE_UP      0x00000001L
#define SYSTEM_MANDATORY_LABEL_NO_READ_UP       0x00000002L
#define SYSTEM_MANDATORY_LABEL_NO_EXECUTE_UP    0x00000004L
#define SYSTEM_MANDATORY_LABEL_VALID_MASK \
    (SYSTEM_MANDATORY_LABEL_NO_WRITE_UP | SYSTEM_MANDATORY_LABEL_NO_READ_UP | \
    SYSTEM_MANDATORY_LABEL_NO_EXECUTE_UP)

/* Security descriptor control flags */
#define SE_OWNER_DEFAULTED          0x0001
#define SE_GROUP_DEFAULTED          0x0002
#define SE_DACL_PRESENT             0x0004
#define SE_DACL_DEFAULTED           0x0008
#define SE_SACL_PRESENT             0x0010
#define SE_SACL_DEFAULTED           0x0020
#define SE_DACL_AUTO_INHERIT_REQ    0x0100
#define SE_SACL_AUTO_INHERIT_REQ    0x0200
#define SE_DACL_AUTO_INHERITED      0x0400
#define SE_SACL_AUTO_INHERITED      0x0800
#define SE_DACL_PROTECTED           0x1000
#define SE_SACL_PROTECTED           0x2000
#define SE_RM_CONTROL_VALID         0x4000
#define SE_SELF_RELATIVE            0x8000

/* Object type list level values */
#define ACCESS_OBJECT_GUID          0
#define ACCESS_PROPERTY_SET_GUID    1
#define ACCESS_PROPERTY_GUID        2
#define ACCESS_MAX_LEVEL            4

/* Audit alarm flags */
#define AUDIT_ALLOW_NO_PRIVILEGE    0x00000001L

/* Directory Service source and object type name */
#define ACCESS_DS_SOURCE_A              "DS"
#define ACCESS_DS_SOURCE_W              L"DS"
#define ACCESS_DS_OBJECT_TYPE_NAME_A    "Directory Service Object"
#define ACCESS_DS_OBJECT_TYPE_NAME_W    L"Directory Service Object"

/* Access reason masks */
#define ACCESS_REASON_TYPE_MASK 0xFFFF0000
#define ACCESS_REASON_DATA_MASK 0x0000FFFF

/* Security descriptor flags */
#define SE_SECURITY_DESCRIPTOR_FLAG_NO_OWNER_ACE    0x00000001L
#define SE_SECURITY_DESCRIPTOR_FLAG_NO_LABEL_ACE    0x00000002L
#define SE_SECURITY_DESCRIPTOR_VALID_FLAGS          0x00000003L

/* Token access rights */
#define TOKEN_ASSIGN_PRIMARY    0x0001L
#define TOKEN_DUPLICATE         0x0002L
#define TOKEN_IMPERSONATE       0x0004L
#define TOKEN_QUERY             0x0008L
#define TOKEN_QUERY_SOURCE      0x0010L
#define TOKEN_ADJUST_PRIVILEGES 0x0020L
#define TOKEN_ADJUST_GROUPS     0x0040L
#define TOKEN_ADJUST_DEFAULT    0x0080L
#define TOKEN_ADJUST_SESSIONID  0x0100L
#define TOKEN_ALL_ACCESS \
    (STANDARD_RIGHTS_REQUIRED | TOKEN_ASSIGN_PRIMARY | TOKEN_DUPLICATE | \
    TOKEN_IMPERSONATE | TOKEN_QUERY | TOKEN_QUERY_SOURCE | TOKEN_ADJUST_PRIVILEGES | \
    TOKEN_ADJUST_GROUPS | TOKEN_ADJUST_DEFAULT | TOKEN_ADJUST_SESSIONID)
#define TOKEN_READ              (STANDARD_RIGHTS_READ | TOKEN_QUERY)
#define TOKEN_WRITE \
    (STANDARD_RIGHTS_WRITE | TOKEN_ADJUST_PRIVILEGES | TOKEN_ADJUST_GROUPS | \
    TOKEN_ADJUST_DEFAULT)
#define TOKEN_EXECUTE           (STANDARD_RIGHTS_EXECUTE)

/* Token mandatory policy flags */
#define TOKEN_MANDATORY_POLICY_OFF              0x00000000L
#define TOKEN_MANDATORY_POLICY_NO_WRITE_UP      0x00000001L
#define TOKEN_MANDATORY_POLICY_NEW_PROCESS_MIN  0x00000002L
#define TOKEN_MANDATORY_POLICY_VALID_MASK \
    (TOKEN_MANDATORY_POLICY_NO_WRITE_UP | TOKEN_MANDATORY_POLICY_NEW_PROCESS_MIN)

/* Number of token audit policy subcategories */
#define POLICY_AUDIT_SUBCATEGORY_COUNT  53

/* Length of a token source name */
#define TOKEN_SOURCE_LENGTH 8

/* Heap flags */
#define HEAP_NO_SERIALIZE               0x00000001L
#define HEAP_GROWABLE                   0x00000002L
#define HEAP_GENERATE_EXCEPTIONS        0x00000004L
#define HEAP_ZERO_MEMORY                0x00000008L
#define HEAP_REALLOC_IN_PLACE_ONLY      0x00000010L
#define HEAP_TAIL_CHECKING_ENABLED      0x00000020L
#define HEAP_FREE_CHECKING_ENABLED      0x00000040L
#define HEAP_DISABLE_COALESCE_ON_FREE   0x00000080L
#define HEAP_CREATE_ALIGN_16            0x00010000L
#define HEAP_CREATE_ENABLE_TRACING      0x00020000L
#define HEAP_CREATE_ENABLE_EXECUTE      0x00040000L

/* Heap settable user flags */
#define HEAP_SETTABLE_USER_VALUE    0x00000100L
#define HEAP_SETTABLE_USER_FLAG1    0x00000200L
#define HEAP_SETTABLE_USER_FLAG2    0x00000400L
#define HEAP_SETTABLE_USER_FLAG3    0x00000800L
#define HEAP_SETTABLE_USER_FLAGS    0x00000E00L

/* Heap classes */
#define HEAP_CLASS_0    0x00000000L
#define HEAP_CLASS_1    0x00001000L
#define HEAP_CLASS_2    0x00002000L
#define HEAP_CLASS_3    0x00003000L
#define HEAP_CLASS_4    0x00004000L
#define HEAP_CLASS_5    0x00005000L
#define HEAP_CLASS_6    0x00006000L
#define HEAP_CLASS_7    0x00007000L
#define HEAP_CLASS_8    0x00008000L
#define HEAP_CLASS_MASK 0x0000F000L

/* RtlDuplicateUnicodeString() flags */
#define RTL_DUPLICATE_UNICODE_STRING_NULL_TERMINATE         0x00000001L
#define RTL_DUPLICATE_UNICODE_STRING_ALLOCATE_NULL_STRING   0x00000002L

/* Compression formats */
#define COMPRESSION_FORMAT_NONE     0x0000
#define COMPRESSION_FORMAT_DEFAULT  0x0001
#define COMPRESSION_FORMAT_LZNT1    0x0002

/* Compression engines */
#define COMPRESSION_ENGINE_STANDARD 0x0000
#define COMPRESSION_ENGINE_MAXIMUM  0x0100
#define COMPRESSION_ENGINE_HIBER    0x0200

/* System volume information folder name */
#define RTL_SYSTEM_VOLUME_INFORMATION_FOLDER    L"System Volume Information"

/* MSV1.0 constants */
#define MSV1_0_PACKAGE_NAME             "MICROSOFT_AUTHENTICATION_PACKAGE_V1_0"
#define MSV1_0_PACKAGE_NAMEW            L"MICROSOFT_AUTHENTICATION_PACKAGE_V1_0"
#define MSV1_0_PACKAGE_NAMEW_LENGTH \
    (sizeof( MSV1_0_PACKAGE_NAMEW ) - sizeof( WCHAR ))
#define MSV1_0_SUBAUTHENTICATION_KEY \
    "SYSTEM\\CurrentControlSet\\Control\\Lsa\\MSV1_0"
#define MSV1_0_SUBAUTHENTICATION_VALUE  "Auth"

/* MSV1.0 string lengths */
#define MSV1_0_CHALLENGE_LENGTH             8
#define MSV1_0_USER_SESSION_KEY_LENGTH      16
#define MSV1_0_LANMAN_SESSION_KEY_LENGTH    8

/* MSV1.0 parameter control flags */
#define MSV1_0_CLEARTEXT_PASSWORD_ALLOWED       0x00000002L
#define MSV1_0_UPDATE_LOGON_STATISTICS          0x00000004L
#define MSV1_0_RETURN_USER_PARAMETERS           0x00000008L
#define MSV1_0_DONT_TRY_GUEST_ACCOUNT           0x00000010L
#define MSV1_0_ALLOW_SERVER_TRUST_ACCOUNT       0x00000020L
#define MSV1_0_RETURN_PASSWORD_EXPIRY           0x00000040L
#define MSV1_0_USE_CLIENT_CHALLENGE             0x00000080L
#define MSV1_0_TRY_GUEST_ACCOUNT_ONLY           0x00000100L
#define MSV1_0_RETURN_PROFILE_PATH              0x00000200L
#define MSV1_0_TRY_SPECIFIED_DOMAIN_ONLY        0x00000400L
#define MSV1_0_ALLOW_WORKSTATION_TRUST_ACCOUNT  0x00000800L
#define MSV1_0_DISABLE_PERSONAL_FALLBACK        0x00001000L
#define MSV1_0_ALLOW_FORCE_GUEST                0x00002000L
#if (_WIN32_WINNT >= 0x0502)
    #define MSV1_0_CLEARTEXT_PASSWORD_SUPPLIED  0x00004000L
    #define MSV1_0_USE_DOMAIN_FOR_ROUTING_ONLY  0x00008000L
#endif
#define MSV1_0_ALLOW_MSVCHAPV2                  0x00010000L
#if (_WIN32_WINNT >= 0x0600)
    #define MSV1_0_S4U2SELF                     0x00020000L
    #define MSV1_0_CHECK_LOGONHOURS_FOR_S4U     0x00040000L
#endif
#define MSV1_0_SUBAUTHENTICATION_DLL_EX         0x00100000L
#define MSV1_0_SUBAUTHENTICATION_DLL            0xFF000000L
#define MSV1_0_SUBAUTHENTICATION_DLL_SHIFT      24
#define MSV1_0_MNS_LOGON                        0x01000000L

/* MSV1.0 subauthentication DLL values */
#define MSV1_0_SUBAUTHENTICATION_DLL_RAS    2
#define MSV1_0_SUBAUTHENTICATION_DLL_IIS    132

/* MSV1.0 S4U logon flags */
#if (_WIN32_WINNT >= 0x0600)
    #define MSV1_0_S4U_LOGON_FLAG_CHECK_LOGONHOURS  0x00000002L
#endif

/* Logon user flags */
#define LOGON_USER                      0x00000001L
#define LOGON_NOENCRYPTION              0x00000002L
#define LOGON_CACHED_ACCOUNT            0x00000004L
#define LOGON_USED_LM_PASSWORD          0x00000008L
#define LOGON_EXTRA_SIDS                0x00000020L
#define LOGON_SUBAUTH_SESSION_KEY       0x00000040L
#define LOGON_SERVER_TRUST_ACCOUNT      0x00000080L
#define LOGON_NTLMV2_ENABLED            0x00000100L
#define LOGON_RESOURCE_GROUPS           0x00000200L
#define LOGON_PROFILE_PATH_RETURNED     0x00000400L
#define LOGON_NT_V2                     0x00000800L
#define LOGON_LM_V2                     0x00001000L
#define LOGON_NTLM_V2                   0x00002000L
#if (_WIN32_WINNT >= 0x0600)
    #define LOGON_OPTIMIZED             0x00004000L
    #define LOGON_WINLOGON              0x00008000L
    #define LOGON_PKINIT                0x00010000L
    #define LOGON_NO_OPTIMIZED          0x00020000L
#endif
#define MSV1_0_SUBAUTHENTICATION_FLAGS  0xFF000000L
#define LOGON_GRACE_LOGON               0x01000000L

/* MSV1.0 supplemental credential constants */
#define MSV1_0_OWF_PASSWORD_LENGTH  16
#define MSV1_0_CRED_LM_PRESENT      0x00000001L
#define MSV1_0_CRED_NT_PRESENT      0x00000002L
#define MSV1_0_CRED_VERSION         0L

/* MSV1.0 NTLM3 constants */
#define MSV1_0_NTLM3_RESPONSE_LENGTH    16
#define MSV1_0_NTLM3_OWF_LENGTH         16
#if (_WIN32_WINNT == 0x0500)
    #define MSV1_0_MAX_NTLM3_LIFE       1800
#else
    #define MSV1_0_MAX_NTLM3_LIFE       129600
#endif
#define MSV1_0_MAX_AVL_SIZE             64000

/* MSV1.0 AV flags */
#if (_WIN32_WINNT >= 0x0501)
    #define MSV1_0_AV_FLAG_FORCE_GUEST              0x00000001L
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define MSV1_0_AV_FLAG_MIC_HANDSHAKE_MESSAGES   0x00000002L
#endif

/* Get challenge response flags */
#define USE_PRIMARY_PASSWORD            0x00000001L
#define RETURN_PRIMARY_USERNAME         0x00000002L
#define RETURN_PRIMARY_LOGON_DOMAINNAME 0x00000004L
#define RETURN_NON_NT_USER_SESSION_KEY  0x00000008L
#define GENERATE_CLIENT_CHALLENGE       0x00000010L
#define GCR_NTLM3_PARMS                 0x00000020L
#define GCR_TARGET_INFO                 0x00000040L
#define RETURN_RESERVED_PARAMETER       0x00000080L
#define GCR_ALLOW_NTLM                  0x00000100L
#define GCR_USE_OEM_SET                 0x00000200L
#define GCR_MACHINE_CREDENTIAL          0x00000400L
#define GCR_USE_OWF_PASSWORD            0x00000800L
#define GCR_ALLOW_LM                    0x00001000L
#define GCR_ALLOW_NO_TARGET             0x00002000L

/* File oplock request return values */
#define FILE_OPLOCK_BROKEN_TO_LEVEL_2   0x00000007L
#define FILE_OPLOCK_BROKEN_TO_NONE      0x00000008L
#define FILE_OPBATCH_BREAK_UNDERWAY     0x00000009L

/* File change notification flags */
#define FILE_NOTIFY_CHANGE_FILE_NAME    0x00000001L
#define FILE_NOTIFY_CHANGE_DIR_NAME     0x00000002L
#define FILE_NOTIFY_CHANGE_NAME         0x00000003L
#define FILE_NOTIFY_CHANGE_ATTRIBUTES   0x00000004L
#define FILE_NOTIFY_CHANGE_SIZE         0x00000008L
#define FILE_NOTIFY_CHANGE_LAST_WRITE   0x00000010L
#define FILE_NOTIFY_CHANGE_LAST_ACCESS  0x00000020L
#define FILE_NOTIFY_CHANGE_CREATION     0x00000040L
#define FILE_NOTIFY_CHANGE_EA           0x00000080L
#define FILE_NOTIFY_CHANGE_SECURITY     0x00000100L
#define FILE_NOTIFY_CHANGE_STREAM_NAME  0x00000200L
#define FILE_NOTIFY_CHANGE_STREAM_SIZE  0x00000400L
#define FILE_NOTIFY_CHANGE_STREAM_WRITE 0x00000800L
#define FILE_NOTIFY_VALID_MASK          0x00000FFFL

/* File actions */
#define FILE_ACTION_ADDED                   0x00000001L
#define FILE_ACTION_REMOVED                 0x00000002L
#define FILE_ACTION_MODIFIED                0x00000003L
#define FILE_ACTION_RENAMED_OLD_NAME        0x00000004L
#define FILE_ACTION_RENAMED_NEW_NAME        0x00000005L
#define FILE_ACTION_ADDED_STREAM            0x00000006L
#define FILE_ACTION_REMOVED_STREAM          0x00000007L
#define FILE_ACTION_MODIFIED_STREAM         0x00000008L
#define FILE_ACTION_REMOVED_BY_DELETE       0x00000009L
#define FILE_ACTION_ID_NOT_TUNNELLED        0x0000000AL
#define FILE_ACTION_TUNNELLED_ID_COLLISION  0x0000000BL

/* Named pipe types */
#define FILE_PIPE_BYTE_STREAM_TYPE      0x00000000L
#define FILE_PIPE_MESSAGE_TYPE          0x00000001L
#define FILE_PIPE_ACCEPT_REMOTE_CLIENTS 0x00000000L
#define FILE_PIPE_REJECT_REMOTE_CLIENTS 0x00000002L
#define FILE_PIPE_TYPE_VALID_MASK       0x00000003L

/* Named pipe completion modes */
#define FILE_PIPE_QUEUE_OPERATION       0x00000000L
#define FILE_PIPE_COMPLETE_OPERATION    0x00000001L

/* Named pipe read modes */
#define FILE_PIPE_BYTE_STREAM_MODE  0x00000000L
#define FILE_PIPE_MESSAGE_MODE      0x00000001L

/* Named pipe configuration flags */
#define FILE_PIPE_INBOUND       0x00000000L
#define FILE_PIPE_OUTBOUND      0x00000001L
#define FILE_PIPE_FULL_DUPLEX   0x00000002L

/* Named pipe state flags */
#define FILE_PIPE_DISCONNECTED_STATE    0x00000001L
#define FILE_PIPE_LISTENING_STATE       0x00000002L
#define FILE_PIPE_CONNECTED_STATE       0x00000003L
#define FILE_PIPE_CLOSING_STATE         0x00000004L

/* Named pipe end flags */
#define FILE_PIPE_CLIENT_END    0x00000000L
#define FILE_PIPE_SERVER_END    0x00000001L

/* File system flags */
#define FILE_CASE_SENSITIVE_SEARCH          0x00000001L
#define FILE_CASE_PRESERVED_NAMES           0x00000002L
#define FILE_UNICODE_ON_DISK                0x00000004L
#define FILE_PERSISTENT_ACLS                0x00000008L
#define FILE_FILE_COMPRESSION               0x00000010L
#define FILE_VOLUME_QUOTAS                  0x00000020L
#define FILE_SUPPORTS_SPARSE_FILES          0x00000040L
#define FILE_SUPPORTS_REPARSE_POINTS        0x00000080L
#define FILE_SUPPORTS_REMOTE_STORAGE        0x00000100L
#define FILE_VOLUME_IS_COMPRESSED           0x00008000L
#define FILE_SUPPORTS_OBJECT_IDS            0x00010000L
#define FILE_SUPPORTS_ENCRYPTION            0x00020000L
#define FILE_NAMED_STREAMS                  0x00040000L
#define FILE_READ_ONLY_VOLUME               0x00080000L
#define FILE_SEQUENTIAL_WRITE_ONCE          0x00100000L
#define FILE_SUPPORTS_TRANSACTIONS          0x00200000L
#define FILE_SUPPORTS_HARD_LINKS            0x00400000L
#define FILE_SUPPORTS_EXTENDED_ATTRIBUTES   0x00800000L
#define FILE_SUPPORTS_OPEN_BY_FILE_ID       0x01000000L
#define FILE_SUPPORTS_USN_JOURNAL           0x02000000L

/* File extended attribute flags */
#define FILE_NEED_EA    0x00000080L

/* File extended attribute types */
#define FILE_EA_TYPE_BINARY     0xFFFE
#define FILE_EA_TYPE_ASCII      0xFFFD
#define FILE_EA_TYPE_BITMAP     0xFFFB
#define FILE_EA_TYPE_METAFILE   0xFFFA
#define FILE_EA_TYPE_ICON       0xFFF9
#define FILE_EA_TYPE_EA         0xFFEE
#define FILE_EA_TYPE_MVMT       0xFFDF
#define FILE_EA_TYPE_MVST       0xFFDE
#define FILE_EA_TYPE_ASN1       0xFFDD
#define FILE_EA_TYPE_FAMILY_IDS 0xFF01

/* File identifier global transaction directory information flags */
#define FILE_ID_GLOBAL_TX_DIR_INFO_FLAG_WRITELOCKED         0x00000001L
#define FILE_ID_GLOBAL_TX_DIR_INFO_FLAG_VISIBLE_TO_TX       0x00000002L
#define FILE_ID_GLOBAL_TX_DIR_INFO_FLAG_VISIBLE_OUTSIDE_TX  0x00000004L

/* DOS wildcard characters */
#define ANSI_DOS_STAR   '<'
#define ANSI_DOS_QM     '>'
#define ANSI_DOS_DOT    '"'
#define DOS_START       L'<'
#define DOS_QM          L'>'
#define DOS_DOT         L'"'

/* Remote protocol flags */
#define REMOTE_PROTOCOL_FLAG_LOOPBACK   0x00000001L
#define REMOTE_PROTOCOL_FLAG_OFFLINE    0x00000002L

/* File system volume control flags */
#define FILE_VC_QUOTA_NONE              0x00000000L
#define FILE_VC_QUOTA_TRACK             0x00000001L
#define FILE_VC_QUOTA_ENFORCE           0x00000002L
#define FILE_VC_QUOTA_MASK              0x00000003L
#define FILE_VC_CONTENT_INDEX_DISABLED  0x00000008L
#define FILE_VC_LOG_QUOTA_THRESHOLD     0x00000010L
#define FILE_VC_LOG_QUOTA_LIMIT         0x00000020L
#define FILE_VC_LOG_VOLUME_THRESHOLD    0x00000040L
#define FILE_VC_LOG_VOLUME_LIMIT        0x00000080L
#define FILE_VC_QUOTAS_INCOMPLETE       0x00000100L
#define FILE_VC_QUOTAS_REBUILDING       0x00000200L
#define FILE_VC_VALID_MASK              0x000003FFL

/* File system control codes */
#define FSCTL_REQUEST_OPLOCK_LEVEL_1 \
    CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 0, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FSCTL_REQUEST_OPLOCK_LEVEL_2 \
    CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 1, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FSCTL_REQUEST_BATCH_OPLOCK \
    CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 2, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FSCTL_OPLOCK_BREAK_ACKNOWLEDGE \
    CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 3, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FSCTL_OPBATCH_ACK_CLOSE_PENDING \
    CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 4, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FSCTL_OPLOCK_BREAK_NOTIFY \
    CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 5, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FSCTL_LOCK_VOLUME \
    CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 6, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FSCTL_UNLOCK_VOLUME \
    CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 7, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FSCTL_DISMOUNT_VOLUME \
    CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 8, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FSCTL_IS_VOLUME_MOUNTED \
    CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 10, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FSCTL_IS_PATHNAME_VALID \
    CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 11, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FSCTL_MARK_VOLUME_DIRTY \
    CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 12, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FSCTL_QUERY_RETRIEVAL_POINTERS \
    CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 14, METHOD_NEITHER, FILE_ANY_ACCESS )
#define FSCTL_GET_COMPRESSION \
    CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 15, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FSCTL_SET_COMPRESSION \
    CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 16, METHOD_BUFFERED, FILE_READ_DATA | \
    FILE_WRITE_DATA )
#define FSCTL_SET_BOOTLOADER_ACCESSED \
    CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 19, METHOD_NEITHER, FILE_ANY_ACCESS )
#define FSCTL_OPLOCK_BREAK_ACK_NO_2 \
    CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 20, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FSCTL_INVALIDATE_VOLUMES \
    CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 21, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FSCTL_QUERY_FAT_BPB \
    CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 22, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FSCTL_REQUEST_FILTER_OPLOCK \
    CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 23, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FSCTL_FILESYSTEM_GET_STATISTICS \
    CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 24, METHOD_BUFFERED, FILE_ANY_ACCESS )
#if (_WIN32_WINNT >= 0x0400)
    #define FSCTL_GET_NTFS_VOLUME_DATA \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 25, METHOD_BUFFERED, FILE_ANY_ACCESS )
    #define FSCTL_GET_NTFS_FILE_RECORD \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 26, METHOD_BUFFERED, FILE_ANY_ACCESS )
    #define FSCTL_GET_VOLUME_BITMAP \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 27, METHOD_NEITHER, FILE_ANY_ACCESS )
    #define FSCTL_GET_RETRIEVAL_POINTERS \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 28, METHOD_NEITHER, FILE_ANY_ACCESS )
    #define FSCTL_MOVE_FILE \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 29, METHOD_BUFFERED, FILE_SPECIAL_ACCESS )
    #define FSCTL_IS_VOLUME_DIRTY \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 30, METHOD_BUFFERED, FILE_ANY_ACCESS )
    #define FSCTL_ALLOW_EXTENDED_DASD_IO \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 32, METHOD_NEITHER, FILE_ANY_ACCESS )
#endif
#if (_WIN32_WINNT >= 0x0500)
    #define FSCTL_FIND_FILES_BY_SID \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 35, METHOD_NEITHER, FILE_ANY_ACCESS )
    #define FSCTL_SET_OBJECT_ID \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 38, METHOD_BUFFERED, FILE_SPECIAL_ACCESS )
    #define FSCTL_GET_OBJECT_ID \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 39, METHOD_BUFFERED, FILE_ANY_ACCESS )
    #define FSCTL_DELETE_OBJECT_ID \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 40, METHOD_BUFFERED, FILE_SPECIAL_ACCESS )
    #define FSCTL_SET_REPARSE_POINT \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 41, METHOD_BUFFERED, FILE_SPECIAL_ACCESS )
    #define FSCTL_GET_REPARSE_POINT \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 42, METHOD_BUFFERED, FILE_ANY_ACCESS )
    #define FSCTL_DELETE_REPARSE_POINT \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 43, METHOD_BUFFERED, FILE_SPECIAL_ACCESS )
    #define FSCTL_ENUM_USN_DATA \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 44, METHOD_NEITHER, FILE_ANY_ACCESS )
    #define FSCTL_SECURITY_ID_CHECK \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 45, METHOD_NEITHER, FILE_READ_DATA )
    #define FSCTL_READ_USN_JOURNAL \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 46, METHOD_NEITHER, FILE_ANY_ACCESS )
    #define FSCTL_SET_OBJECT_ID_EXTENDED \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 47, METHOD_BUFFERED, FILE_SPECIAL_ACCESS )
    #define FSCTL_CREATE_OR_GET_OBJECT_ID \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 48, METHOD_BUFFERED, FILE_ANY_ACCESS )
    #define FSCTL_SET_SPARSE \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 49, METHOD_BUFFERED, FILE_SPECIAL_ACCESS )
    #define FSCTL_SET_ZERO_DATA \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 50, METHOD_BUFFERED, FILE_WRITE_DATA )
    #define FSCTL_QUERY_ALLOCATED_RANGES \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 51, METHOD_NEITHER, FILE_READ_DATA )
    #define FSCTL_ENABLE_UPGRADE \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 52, METHOD_BUFFERED, FILE_WRITE_DATA )
    #define FSCTL_SET_ENCRYPTION \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 53, METHOD_NEITHER, FILE_ANY_ACCESS )
    #define FSCTL_ENCRYPTION_FSCTL_IO \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 54, METHOD_NEITHER, FILE_ANY_ACCESS )
    #define FSCTL_WRITE_RAW_ENCRYPTED \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 55, METHOD_NEITHER, FILE_SPECIAL_ACCESS )
    #define FSCTL_READ_RAW_ENCRYPTED \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 56, METHOD_NEITHER, FILE_SPECIAL_ACCESS )
    #define FSCTL_CREATE_USN_JOURNAL \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 57, METHOD_NEITHER, FILE_ANY_ACCESS )
    #define FSCTL_READ_FILE_USN_DATA \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 58, METHOD_NEITHER, FILE_ANY_ACCESS )
    #define FSCTL_WRITE_USN_CLOSE_RECORD \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 59, METHOD_NEITHER, FILE_ANY_ACCESS )
    #define FSCTL_EXTEND_VOLUME \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 60, METHOD_BUFFERED, FILE_ANY_ACCESS )
    #define FSCTL_QUERY_USN_JOURNAL \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 61, METHOD_BUFFERED, FILE_ANY_ACCESS )
    #define FSCTL_DELETE_USN_JOURNAL \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 62, METHOD_BUFFERED, FILE_ANY_ACCESS )
    #define FSCTL_MARK_HANDLE \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 63, METHOD_BUFFERED, FILE_ANY_ACCESS )
    #define FSCTL_SIS_COPYFILE \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 64, METHOD_BUFFERED, FILE_ANY_ACCESS )
    #define FSCTL_SIS_LINK_FILES \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 65, METHOD_BUFFERED, FILE_READ_DATA | \
        FILE_WRITE_DATA )
    #define FSCTL_RECALL_FILE \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 69, METHOD_NEITHER, FILE_ANY_ACCESS )
    #define FSCTL_READ_FROM_PLEX \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 71, METHOD_OUT_DIRECT, FILE_READ_DATA )
    #define FSCTL_FILE_PREFETCH \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 72, METHOD_BUFFERED, FILE_SPECIAL_ACCESS )
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define FSCTL_MAKE_MEDIA_COMPATIBLE \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 76, METHOD_BUFFERED, FILE_WRITE_DATA )
    #define FSCTL_SET_DEFECT_MANAGEMENT \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 77, METHOD_BUFFERED, FILE_WRITE_DATA )
    #define FSCTL_QUERY_SPARING_INFO \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 78, METHOD_BUFFERED, FILE_ANY_ACCESS )
    #define FSCTL_QUERY_ON_DISK_VOLUME_INFO \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 79, METHOD_BUFFERED, FILE_ANY_ACCESS )
    #define FSCTL_SET_VOLUME_COMPRESSION_STATE \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 80, METHOD_BUFFERED, FILE_SPECIAL_ACCESS )
    #define FSCTL_TXFS_MODIFY_RM \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 81, METHOD_BUFFERED, FILE_WRITE_DATA )
    #define FSCTL_TXFS_QUERY_RM_INFORMATION \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 82, METHOD_BUFFERED, FILE_READ_DATA )
    #define FSCTL_TXFS_ROLLFORWARD_REDO \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 84, METHOD_BUFFERED, FILE_WRITE_DATA )
    #define FSCTL_TXFS_ROLLFORWARD_UNDO \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 85, METHOD_BUFFERED, FILE_WRITE_DATA )
    #define FSCTL_TXFS_START_RM \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 86, METHOD_BUFFERED, FILE_WRITE_DATA )
    #define FSCTL_TXFS_SHUTDOWN_RM \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 87, METHOD_BUFFERED, FILE_WRITE_DATA )
    #define FSCTL_TXFS_READ_BACKUP_INFORMATION \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 88, METHOD_BUFFERED, FILE_READ_DATA )
    #define FSCTL_TXFS_WRITE_BACKUP_INFORMATION \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 89, METHOD_BUFFERED, FILE_WRITE_DATA )
    #define FSCTL_TXFS_CREATE_SECONDARY_RM \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 90, METHOD_BUFFERED, FILE_WRITE_DATA )
    #define FSCTL_TXFS_GET_METADATA_INFO \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 91, METHOD_BUFFERED, FILE_READ_DATA )
    #define FSCTL_TXFS_GET_TRANSACTED_VERSION \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 92, METHOD_BUFFERED, FILE_READ_DATA )
    #define FSCTL_TXFS_SAVEPOINT_INFORMATION \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 94, METHOD_BUFFERED, FILE_WRITE_DATA )
    #define FSCTL_TXFS_CREATE_MINIVERSION \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 95, METHOD_BUFFERED, FILE_WRITE_DATA )
    #define FSCTL_TXFS_TRANSACTION_ACTIVE \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 99, METHOD_BUFFERED, FILE_READ_DATA )
    #define FSCTL_SET_ZERO_ON_DEALLOCATION \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 101, METHOD_BUFFERED, FILE_SPECIAL_ACCESS )
    #define FSCTL_SET_REPAIR \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 102, METHOD_BUFFERED, FILE_ANY_ACCESS )
    #define FSCTL_GET_REPAIR \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 103, METHOD_BUFFERED, FILE_ANY_ACCESS )
    #define FSCTL_WAIT_FOR_REPAIR \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 104, METHOD_BUFFERED, FILE_ANY_ACCESS )
    #define FSCTL_INITIATE_REPAIR \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 106, METHOD_BUFFERED, FILE_ANY_ACCESS )
    #define FSCTL_CSC_INTERNAL \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 107, METHOD_NEITHER, FILE_ANY_ACCESS )
    #define FSCTL_SHRINK_VOLUME \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 108, METHOD_BUFFERED, FILE_SPECIAL_ACCESS )
    #define FSCTL_SET_SHORT_NAME_BEHAVIOR \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 109, METHOD_BUFFERED, FILE_ANY_ACCESS )
    #define FSCTL_DFSR_SET_GHOST_HANDLE_STATE \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 110, METHOD_BUFFERED, FILE_ANY_ACCESS )
    #define FSCTL_TXFS_LIST_TRANSACTION_LOCKED_FILES \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 120, METHOD_BUFFERED, FILE_READ_DATA )
    #define FSCTL_TXFS_LIST_TRANSACTIONS \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 121, METHOD_BUFFERED, FILE_READ_DATA )
    #define FSCTL_QUERY_PAGEFILE_ENCRYPTION \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 122, METHOD_BUFFERED, FILE_ANY_ACCESS )
    #define FSCTL_RESET_VOLUME_ALLOCATION_HINTS \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 123, METHOD_BUFFERED, FILE_ANY_ACCESS )
#endif
#if (_WIN32_WINNT >= 0x0601)
    #define FSCTL_QUERY_DEPENDENT_VOLUME \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 124, METHOD_BUFFERED, FILE_ANY_ACCESS )
    #define FSCTL_SD_GLOBAL_CHANGE \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 125, METHOD_BUFFERED, FILE_ANY_ACCESS )
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define FSCTL_TXFS_READ_BACKUP_INFORMATION2 \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 126, METHOD_BUFFERED, FILE_ANY_ACCESS )
#endif
#if (_WIN32_WINNT >= 0x0601)
    #define FSCTL_LOOKUP_STREAM_FROM_CLUSTER \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 127, METHOD_BUFFERED, FILE_ANY_ACCESS )
    #define FSCTL_TXFS_WRITE_BACKUP_INFORMATION2 \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 128, METHOD_BUFFERED, FILE_ANY_ACCESS )
    #define FSCTL_FILE_TYPE_NOTIFICATION \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 129, METHOD_BUFFERED, FILE_ANY_ACCESS )
    #define FSCTL_GET_BOOT_AREA_INFO \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 140, METHOD_BUFFERED, FILE_ANY_ACCESS )
    #define FSCTL_GET_RETRIEVAL_POINTER_BASE \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 141, METHOD_BUFFERED, FILE_ANY_ACCESS )
    #define FSCTL_SET_PERSISTENT_VOLUME_STATE \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 142, METHOD_BUFFERED, FILE_ANY_ACCESS )
    #define FSCTL_QUERY_PERSISTENT_VOLUME_STATE \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 143, METHOD_BUFFERED, FILE_ANY_ACCESS )
    #define FSCTL_REQUEST_OPLOCK \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 144, METHOD_BUFFERED, FILE_ANY_ACCESS )
    #define FSCTL_CSV_TUNNEL_REQUEST \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 145, METHOD_BUFFERED, FILE_ANY_ACCESS )
    #define FSCTL_IS_CSV_FILE \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 146, METHOD_BUFFERED, FILE_ANY_ACCESS )
    #define FSCTL_QUERY_FILE_SYSTEM_RECOGNITION \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 147, METHOD_BUFFERED, FILE_ANY_ACCESS )
    #define FSCTL_CSV_GET_VOLUME_PATH_NAME \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 148, METHOD_BUFFERED, FILE_ANY_ACCESS )
    #define FSCTL_CSV_GET_VOLUME_NAME_FOR_VOLUME_MOUNT_POINT \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 149, METHOD_BUFFERED, FILE_ANY_ACCESS )
    #define FSCTL_CSV_GET_VOLUME_PATH_NAMES_FOR_VOLUME_NAME \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 150, METHOD_BUFFERED, FILE_ANY_ACCESS )
    #define FSCTL_IS_FILE_ON_CSV_VOLUME \
        CTL_CODE( FILE_DEVICE_FILE_SYSTEM, 151, METHOD_BUFFERED, FILE_ANY_ACCESS )
#endif
#define FSCTL_MARK_AS_SYSTEM_HIVE   FSCTL_SET_BOOTLOADER_ACCESSED

/* USN reasons */
#if (_WIN32_WINNT >= 0x0500)
    #define USN_REASON_DATA_OVERWRITE           0x00000001L
    #define USN_REASON_DATA_EXTEND              0x00000002L
    #define USN_REASON_DATA_TRUNCATION          0x00000004L
    #define USN_REASON_NAMED_DATA_OVERWRITE     0x00000010L
    #define USN_REASON_NAMED_DATA_EXTEND        0x00000020L
    #define USN_REASON_NAMED_DATA_TRUNCATION    0x00000040L
    #define USN_REASON_FILE_CREATE              0x00000100L
    #define USN_REASON_FILE_DELETE              0x00000200L
    #define USN_REASON_EA_CHANGE                0x00000400L
    #define USN_REASON_SECURITY_CHANGE          0x00000800L
    #define USN_REASON_RENAME_OLD_NAME          0x00001000L
    #define USN_REASON_RENAME_NEW_NAME          0x00002000L
    #define USN_REASON_INDEXABLE_CHANGE         0x00004000L
    #define USN_REASON_BASIC_INFO_CHANGE        0x00008000L
    #define USN_REASON_HARD_LINK_CHANGE         0x00010000L
    #define USN_REASON_COMPRESSION_CHANGE       0x00020000L
    #define USN_REASON_ENCRYPTION_CHANGE        0x00040000L
    #define USN_REASON_OBJECT_ID_CHANGE         0x00080000L
    #define USN_REASON_REPARSE_POINT_CHANGE     0x00100000L
    #define USN_REASON_STREAM_CHANGE            0x00200000L
    #define USN_REASON_TRANSACTED_CHANGE        0x00400000L
    #define USN_REASON_CLOSE                    0x80000000L
#endif

/* FSCTL_DELETE_USN_JOURNAL flags */
#if (_WIN32_WINNT >= 0x0500)
    #define USN_DELETE_FLAG_DELETE  0x00000001L
    #define USN_DELETE_FLAG_NOTIFY  0x00000002L
    #define USN_DELETE_VALID_FLAGS  0x00000003L
#endif

/* FSCTL_MARK_HANDLE source information flags */
#if (_WIN32_WINNT >= 0x0500)
    #define USN_SOURCE_DATA_MANAGEMENT          0x00000001L
    #define USN_SOURCE_AUXILIARY_DATA           0x00000002L
    #define USN_SOURCE_REPLICATION_MANAGEMENT   0x00000004L
#endif

/* FSCTL_MARK_HANDLE handle information flags */
#if (_WIN32_WINNT >= 0x0500)
    #define MARK_HANDLE_PROTECT_CLUSTERS    0x00000001L
    #define MARK_HANDLE_TXF_SYSTEM_LOG      0x00000004L
    #define MARK_HANDLE_NOT_TXF_SYSTEM_LOG  0x00000008L
#endif
#if (_WIN32_WINNT >= 0x0601)
    #define MARK_HANDLE_REALTIME            0x00000020L
    #define MARK_HANDLE_NOT_REALTIME        0x00000040L
#endif

/* 8.3 name flags */
#if (_WIN32_WINNT >= 0x0601)
    #define NO_8DOT3_NAME_PRESENT   0x00000001L
    #define REMOVED_8DOT3_NAME      0x00000002L
#endif

/* Persistent volume states */
#if (_WIN32_WINNT >= 0x0601)
    #define PERSISTENT_VOLUME_STATE_SHORT_NAME_CREATION_DISABLED    0x00000001L
#endif

/* FSCTL_IS_VOLUME_DIRTY returned flags */
#if (_WIN32_WINNT >= 0x0500)
    #define VOLUME_IS_DIRTY             0x00000001L
    #define VOLUME_UPGRADE_SCHEDULED    0x00000002L
    #define VOLUME_SESSION_OPEN         0x00000004L
#endif

/* File prefetch types */
#if (_WIN32_WINNT >= 0x0500)
    #define FILE_PREFETCH_TYPE_FOR_CREATE       0x00000001L
    #define FILE_PREFETCH_TYPE_FOR_DIRENUM      0x00000002L
    #define FILE_PREFETCH_TYPE_FOR_CREATE_EX    0x00000003L
    #define FILE_PREFETCH_TYPE_FOR_DIRENUM_EX   0x00000004L
    #define FILE_PREFETCH_TYPE_MAX              0x00000004L
#endif

/* File system types */
#define FILESYSTEM_STATISTICS_TYPE_NTFS     1
#define FILESYSTEM_STATISTICS_TYPE_FAT      2
#define FILESYSTEM_STATISTICS_TYPE_EXFAT    3

/* Encryption operations */
#if (_WIN32_WINNT >= 0x0500)
    #define FILE_SET_ENCRYPTION         0x00000001L
    #define FILE_CLEAR_ENCRYPTION       0x00000002L
    #define STREAM_SET_ENCRYPTION       0x00000003L
    #define STREAM_CLEAR_ENCRYPTION     0x00000004L
    #define MAXIMUM_ENCRYPTION_VALUE    0x00000004L
#endif

/* Compression formats */
#if (_WIN32_WINNT >= 0x0500)
    #define COMPRESSION_FORMAT_SPARSE   0x4000
#endif

/* FSCTL_SIS_COPYFILE flags */
#if (_WIN32_WINNT >= 0x0500)
    #define COPYFILE_SIS_LINK       0x00000001L
    #define COPYFILE_SIS_REPLACE    0x00000002L
    #define COPYFILE_SIS_FLAGS      0x00000003L
#endif

/* FSCTL_SET_REPAIR flags */
#if (_WIN32_WINNT >= 0x0600)
    #define SET_REPAIR_ENABLED                          0x00000001L
    #define SET_REPAIR_VOLUME_BITMAP_SCAN               0x00000002L
    #define SET_REPAIR_DELETE_CROSSLINK                 0x00000004L
    #define SET_REPAIR_WARN_ABOUT_DATA_LOSS             0x00000008L
    #define SET_REPAIR_DISABLED_AND_BUGCHECK_ON_CORRUPT 0x00000010L
    #define SET_REPAIR_VALID_MASK                       0x0000000FL
#endif

/* TXFS flags */
#if (_WIN32_WINNT >= 0x0600)
    #define TXFS_RM_FLAG_LOGGING_MODE                           0x00000001L
    #define TXFS_RM_FLAG_RENAME_RM                              0x00000002L
    #define TXFS_RM_FLAG_LOG_CONTAINER_COUNT_MAX                0x00000004L
    #define TXFS_RM_FLAG_LOG_CONTAINER_COUNT_MIN                0x00000008L
    #define TXFS_RM_FLAG_LOG_GROWTH_INCREMENT_NUM_CONTAINERS    0x00000010L
    #define TXFS_RM_FLAG_LOG_GROWTH_INCREMENT_PERCENT           0x00000020L
    #define TXFS_RM_FLAG_LOG_AUTO_SHRINK_PERCENTAGE             0x00000040L
    #define TXFS_RM_FLAG_LOG_NO_CONTAINER_COUNT_MAX             0x00000080L
    #define TXFS_RM_FLAG_LOG_NO_CONTAINER_COUNT_MIN             0x00000100L
    #define TXFS_RM_FLAG_GROW_LOG                               0x00000400L
    #define TXFS_RM_FLAG_SHRINK_LOG                             0x00000800L
    #define TXFS_RM_FLAG_ENFORCE_MINIMUM_SIZE                   0x00001000L
    #define TXFS_RM_FLAG_PRESERVE_CHANGES                       0x00002000L
    #define TXFS_RM_FLAG_RESET_RM_AT_NEXT_START                 0x00004000L
    #define TXFS_RM_FLAG_DO_NOT_RESET_RM_AT_NEXT_START          0x00008000L
    #define TXFS_RM_FLAG_PREFER_CONSISTENCY                     0x00010000L
    #define TXFS_RM_FLAG_PREFER_AVAILABILITY                    0x00020000L
    #define TXFS_MODIFY_RM_VALID_FLAGS \
        (TXFS_RM_FLAG_LOGGING_MODE | TXFS_RM_FLAG_RENAME_RM | \
        TXFS_RM_FLAG_LOG_CONTAINER_COUNT_MAX | TXFS_RM_FLAG_LOG_CONTAINER_COUNT_MIN | \
        TXFS_RM_FLAG_LOG_GROWTH_INCREMENT_NUM_CONTAINERS | \
        TXFS_RM_FLAG_LOG_GROWTH_INCREMENT_PERCENT | \
        TXFS_RM_FLAG_LOG_AUTO_SHRINK_PERCENTAGE | \
        TXFS_RM_FLAG_LOG_NO_CONTAINER_COUNT_MAX | \
        TXFS_RM_FLAG_LOG_NO_CONTAINER_COUNT_MIN | TXFS_RM_FLAG_GROW_LOG | \
        TXFS_RM_FLAG_SHRINK_LOG | TXFS_RM_FLAG_ENFORCE_MINIMUM_SIZE | \
        TXFS_RM_FLAG_PRESERVE_CHANGES | TXFS_RM_FLAG_RESET_RM_AT_NEXT_START | \
        TXFS_RM_FLAG_DO_NOT_RESET_RM_AT_NEXT_START | TXFS_RM_FLAG_PREFER_CONSISTENCY | \
        TXFS_RM_FLAG_PREFER_AVAILABILITY)
    #define TXFS_QUERY_RM_INFORMATION_VALID_FLAGS \
        (TXFS_RM_FLAG_LOG_GROWTH_INCREMENT_NUM_CONTAINERS | \
        TXFS_RM_FLAG_LOG_GROWTH_INCREMENT_PERCENT | \
        TXFS_RM_FLAG_LOG_NO_CONTAINER_COUNT_MAX | \
        TXFS_RM_FLAG_LOG_NO_CONTAINER_COUNT_MIN | \
        TXFS_RM_FLAG_RESET_RM_AT_NEXT_START | \
        TXFS_RM_FLAG_DO_NOT_RESET_RM_AT_NEXT_START | TXFS_RM_FLAG_PREFER_CONSISTENCY | \
        TXFS_RM_FLAG_PREFER_AVAILABILITY)
#endif

/* TXFS logging modes */
#if (_WIN32_WINNT >= 0x0600)
    #define TXFS_LOGGING_MODE_SIMPLE    0x0001
    #define TXFS_LOGGING_MODE_FULL      0x0002
#endif

/* TXFS transaction states */
#if (_WIN32_WINNT >= 0x0600)
    #define TXFS_TRANSACTION_STATE_NONE         0x00
    #define TXFS_TRANSACTION_STATE_ACTIVE       0x01
    #define TXFS_TRANSACTION_STATE_PREPARED     0x02
    #define TXFS_TRANSACTION_STATE_NOTACTIVE    0x03
#endif

/* TXFS RM states */
#if (_WIN32_WINNT >= 0x0600)
    #define TXFS_RM_STATE_NOT_STARTED   0
    #define TXFS_RM_STATE_STARTING      1
    #define TXFS_RM_STATE_ACTIVE        2
    #define TXFS_RM_STATE_SHUTTING_DOWN 3
#endif

/* FSCTL_TXFS_ROLLFORWARD_REDO flags */
#if (_WIN32_WINNT >= 0x0600)
    #define TXFS_ROLLFORWARD_REDO_FLAG_USE_LAST_REDO_LSN        0x00000001L
    #define TXFS_ROLLFORWARD_REDO_FLAG_USE_LAST_VIRTUAL_CLOCK   0x00000002L
    #define TXFS_ROLLFORWARD_REDO_VALID_FLAGS \
        (TXFS_ROLLFORWARD_REDO_FLAG_USE_LAST_REDO_LSN | \
        TXFS_ROLLFORWARD_REDO_FLAG_USE_LAST_VIRTUAL_CLOCK)
#endif

/* FSCTL_TXFS_START_RM flags */
#if (_WIN32_WINNT >= 0x0600)
    #define TXFS_START_RM_FLAG_LOG_CONTAINER_COUNT_MAX              0x00000001L
    #define TXFS_START_RM_FLAG_LOG_CONTAINER_COUNT_MIN              0x00000002L
    #define TXFS_START_RM_FLAG_LOG_CONTAINER_SIZE                   0x00000004L
    #define TXFS_START_RM_FLAG_LOG_GROWTH_INCREMENT_NUM_CONTAINERS  0x00000008L
    #define TXFS_START_RM_FLAG_LOG_GROWTH_INCREMENT_PERCENT         0x00000010L
    #define TXFS_START_RM_FLAG_LOG_AUTO_SHRINK_PERCENTAGE           0x00000020L
    #define TXFS_START_RM_FLAG_LOG_NO_CONTAINER_COUNT_MAX           0x00000040L
    #define TXFS_START_RM_FLAG_LOG_NO_CONTAINER_COUNT_MIN           0x00000080L
    #define TXFS_START_RM_FLAG_RECOVER_BEST_EFFORT                  0x00000200L
    #define TXFS_START_RM_FLAG_LOGGING_MODE                         0x00000400L
    #define TXFS_START_RM_FLAG_PRESERVE_CHANGES                     0x00000800L
    #define TXFS_START_RM_FLAG_PREFER_CONSISTENCY                   0x00001000L
    #define TXFS_START_RM_FLAG_PREFER_AVAILABILITY                  0x00002000L
    #define TXFS_START_RM_VALID_FLAG \
        (TXFS_START_RM_FLAG_LOG_CONTAINER_COUNT_MAX | \
        TXFS_START_RM_FLAG_LOG_CONTAINER_COUNT_MIN | \
        TXFS_START_RM_FLAG_LOG_CONTAINER_SIZE | \
        TXFS_START_RM_FLAG_LOG_GROWTH_INCREMENT_NUM_CONTAINERS | \
        TXFS_START_RM_FLAG_LOG_GROWTH_INCREMENT_PERCENT | \
        TXFS_START_RM_FLAG_LOG_AUTO_SHRINK_PERCENTAGE | \
        TXFS_START_RM_FLAG_LOG_NO_CONTAINER_COUNT_MAX | \
        TXFS_START_RM_FLAG_LOG_NO_CONTAINER_COUNT_MIN | \
        TXFS_START_RM_FLAG_RECOVER_BEST_EFFORT | \
        TXFS_START_RM_FLAG_LOGGING_MODE | TXFS_START_RM_FLAG_PRESERVE_CHANGES | \
        TXFS_START_RM_FLAG_PREFER_CONSISTENCY | TXFS_START_RM_FLAG_PREFER_AVAILABILITY)
#endif

/* FSCTL_TXFS_LIST_TRANSACTION_LOCKED_FILES entry flags */
#if (_WIN32_WINNT >= 0x0600)
    #define TXFS_LIST_TRANSACTION_LOCKED_FILES_ENTRY_FLAG_CREATED   0x00000001L
    #define TXFS_LIST_TRANSACTION_LOCKED_FILES_ENTRY_FLAG_DELETED   0x00000002L
#endif

/* FSCTL_TXFS_GET_TRANSACTED_VERSION special values */
#if (_WIN32_WINNT >= 0x0600)
    #define TXFS_TRANSACTED_VERSION_NONTRANSACTED   0xFFFFFFFEL
    #define TXFS_TRANSACTED_VERSION_UNCOMMITTED     0xFFFFFFFFL
#endif

/* TXFS savepoint flags */
#if (_WIN32_WINNT >= 0x0600)
    #define TXFS_SAVEPOINT_SET          0x00000001L
    #define TXFS_SAVEPOINT_ROLLBACK     0x00000002L
    #define TXFS_SAVEPOINT_CLEAR        0x00000004L
    #define TXFS_SAVEPOINT_CLEAR_ALL    0x00000010L
#endif

/* Oplock levels */
#if (_WIN32_WINNT >= 0x0601)
    #define OPLOCK_LEVEL_CACHE_READ     0x00000001L
    #define OPLOCK_LEVEL_CACHE_HANDLE   0x00000002L
    #define OPLOCK_LEVEL_CACHE_WRITE    0x00000004L
#endif

/* FSCTL_REQUEST_OPLOCK input flags */
#if (_WIN32_WINNT >= 0x0601)
    #define REQUEST_OPLOCK_INPUT_FLAG_REQUEST               0x00000001L
    #define REQUEST_OPLOCK_INPUT_FLAG_ACK                   0x00000002L
    #define REQUEST_OPLOCK_INPUT_FLAG_COMPLETE_ACK_ON_CLOSE 0x00000004L
#endif

/* FSCTL_REQUEST_OPLOCK output flags */
#if (_WIN32_WINNT >= 0x0601)
    #define REQUEST_OPLOCK_OUTPUT_FLAG_ACK_REQUIRED     0x00000001L
    #define REQUEST_OPLOCK_OUTPUT_FLAG_MODES_PROVIDED   0x00000002L
#endif

/* FSCTL_REQUEST_OPLOCK parameters revision number */
#if (_WIN32_WINNT >= 0x0601)
    #define REQUEST_OPLOCK_CURRENT_VERSION  1
#endif

/* FSCTL_SD_GLOBAL_CHANGE types */
#if (_WIN32_WINNT >= 0x0601)
    #define SD_GLOBAL_CHANGE_TYPE_MACHINE_SID   1L
#endif

/* Extended encrypted data information flags */
#if (_WIN32_WINNT >= 0x0601)
    #define ENCRYPTED_DATA_INFO_SPARSE_FILE 1L
#endif

/* FSCTL_LOOKUP_STREAM_FROM_CLUSTER entry flags */
#if (_WIN32_WINNT >= 0x0601)
    #define LOOKUP_STREAM_FROM_CLUSTER_ENTRY_FLAG_PAGE_FILE         0x00000001L
    #define LOOKUP_STREAM_FROM_CLUSTER_ENTRY_FLAG_DENY_DEFRAG_SET   0x00000002L
    #define LOOKUP_STREAM_FROM_CLUSTER_ENTRY_FLAG_FS_SYSTEM_FILE    0x00000004L
    #define LOOKUP_STREAM_FROM_CLUSTER_ENTRY_FLAG_TXF_SYSTEM_FILE   0x00000008L
    #define LOOKUP_STREAM_FROM_CLUSTER_ENTRY_ATTRIBUTE_MASK         0xFF000000L
    #define LOOKUP_STREAM_FROM_CLUSTER_ENTRY_ATTRIBUTE_DATA         0x01000000L
    #define LOOKUP_STREAM_FROM_CLUSTER_ENTRY_ATTRIBUTE_INDEX        0x02000000L
    #define LOOKUP_STREAM_FROM_CLUSTER_ENTRY_ATTRIBUTE_SYSTEM       0x03000000L
#endif

/* FSCTL_FILE_TYPE_NOTIFICATION flags */
#if (_WIN32_WINNT >= 0x0601)
    #define FILE_TYPE_NOTIFICATION_FLAG_USAGE_BEGIN 0x00000001L
    #define FILE_TYPE_NOTIFICATION_FLAG_USAGE_END   0x00000002L
#endif

/* Symbolic link flags */
#define SYMLINK_FLAG_RELATIVE   1L

/* Reparse tags */
#define IO_REPARSE_TAG_MOUNT_POINT                  0xA0000003L
#define IO_REPARSE_TAG_HSM                          0xC0000004L
#define IO_REPARSE_TAG_DRIVE_EXTENDER               0x80000005L
#define IO_REPARSE_TAG_HSM2                         0x80000006L
#define IO_REPARSE_TAG_SIS                          0x80000007L
#define IO_REPARSE_TAG_WIM                          0x80000008L
#define IO_REPARSE_TAG_CSV                          0x80000009L
#define IO_REPARSE_TAG_DFS                          0x8000000AL
#define IO_REPARSE_TAG_SYMLINK                      0x8000000CL
#define IO_REPARSE_TAG_DFSR                         0x80000012L
#define IO_REPARSE_TAG_IFSTEST_CONGRUENT            0x00000009L
#define IO_REPARSE_TAG_MOONWALK_HSM                 0x0000000AL
#define IO_REPARSE_TAG_TSINGHUA_UNIVERSITY_RESEARCH 0x0000000BL
#define IO_REPARSE_TAG_ARKIVIO                      0x0000000CL
#define IO_REPARSE_TAG_SOLUTIONSOFT                 0x2000000DL
#define IO_REPARSE_TAG_COMMVAULT                    0x0000000EL
#define IO_REPARSE_TAG_OVERTONE                     0x0000000FL
#define IO_REPARSE_TAG_SYMANTEC_HSM2                0x00000010L
#define IO_REPARSE_TAG_ENIGMA_HSM                   0x00000011L
#define IO_REPARSE_TAG_SYMANTEC_HSM                 0x00000012L
#define IO_REPARSE_TAG_INTERCOPE_HSM                0x00000013L
#define IO_REPARSE_TAG_KOM_NETWORKS_HSM             0x00000014L
#define IO_REPARSE_TAG_MEMORY_TECH_HSM              0x00000015L
#define IO_REPARSE_TAG_BRIDGEHEAD_HSM               0x00000016L
#define IO_REPARSE_TAG_OSR_SAMPLE                   0x20000017L
#define IO_REPARSE_TAG_GLOBAL360_HSM                0x00000018L
#define IO_REPARSE_TAG_ALTIRIS_HSM                  0x00000019L
#define IO_REPARSE_TAG_HERMES_HSM                   0x0000001AL
#define IO_REPARSE_TAG_POINTSOFT_HSM                0x0000001BL
#define IO_REPARSE_TAG_GRAU_DATASTORAGE_HSM         0x0000001CL
#define IO_REPARSE_TAG_COMMVAULT_HSM                0x0000001DL
#define IO_REPARSE_TAG_DATASTOR_SIS                 0x0000001EL
#define IO_REPARSE_TAG_TAG_EDSI_HSM                 0x0000001FL
#define IO_REPARSE_TAG_HP_HSM                       0x00000020L
#define IO_REPARSE_TAG_SER_HSM                      0x00000021L
#define IO_REPARSE_TAG_DOUBLE_TAKE_HSM              0x00000022L
#define IO_REPARSE_TAG_WISDATA_HSM                  0x00000023L
#define IO_REPARSE_TAG_MIMOSA_HSM                   0x00000024L
#define IO_REPARSE_TAG_HSAG_HSM                     0x00000025L
#define IO_REPARSE_TAG_ADA_HSM                      0x00000026L
#define IO_REPARSE_TAG_AUTN_HSM                     0x00000027L
#define IO_REPARSE_TAG_NEXSAN_HSM                   0x00000028L
#define IO_REPARSE_TAG_DOUBLE_TAKE_SIS              0x00000029L
#define IO_REPARSE_TAG_SONY_HSM                     0x0000002AL
#define IO_REPARSE_TAG_ELTAN_HSM                    0x0000002BL
#define IO_REPARSE_TAG_UTIXO_HSM                    0x0000002CL
#define IO_REPARSE_TAG_QUEST_HSM                    0x0000002DL
#define IO_REPARSE_TAG_DATAGLOBAL_HSM               0x0000002EL
#define IO_REPARSE_TAG_QI_TECH_HSM                  0x0000002FL
#define IO_REPARSE_TAG_DATAFIRST_HSM                0x00000030L
#define IO_REPARSE_TAG_C2CSYSTEMS_HSM               0x00000031L

/* Network file system control codes */
#define FSCTL_LMR_GET_LINK_TRACKING_INFORMATION \
    CTL_CODE( FILE_DEVICE_NETWORK_FILE_SYSTEM, 58, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FSCTL_LMR_SET_LINK_TRACKING_INFORMATION \
    CTL_CODE( FILE_DEVICE_NETWORK_FILE_SYSTEM, 59, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FSCTL_LMR_ARE_FILE_OBJECTS_ON_SAME_SERVER \
    CTL_CODE( FILE_DEVICE_NETWORK_FILE_SYSTEM, 60, METHOD_BUFFERED, FILE_ANY_ACCESS )

/* Named pipe file system control codes */
#define FSCTL_PIPE_ASSIGN_EVENT \
    CTL_CODE( FILE_DEVICE_NAMED_PIPE, 0, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FSCTL_PIPE_DISCONNECT \
    CTL_CODE( FILE_DEVICE_NAMED_PIPE, 1, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FSCTL_PIPE_LISTEN \
    CTL_CODE( FILE_DEVICE_NAMED_PIPE, 2, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FSCTL_PIPE_PEEK \
    CTL_CODE( FILE_DEVICE_NAMED_PIPE, 3, METHOD_BUFFERED, FILE_READ_DATA )
#define FSCTL_PIPE_QUERY_EVENT \
    CTL_CODE( FILE_DEVICE_NAMED_PIPE, 4, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FSCTL_PIPE_TRANSCEIVE \
    CTL_CODE( FILE_DEVICE_NAMED_PIPE, 5, METHOD_NEITHER, FILE_READ_DATA | \
    FILE_WRITE_DATA )
#define FSCTL_PIPE_WAIT \
    CTL_CODE( FILE_DEVICE_NAMED_PIPE, 6, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FSCTL_PIPE_IMPERSONATE \
    CTL_CODE( FILE_DEVICE_NAMED_PIPE, 7, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FSCTL_PIPE_SET_CLIENT_PROCESS \
    CTL_CODE( FILE_DEVICE_NAMED_PIPE, 8, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FSCTL_PIPE_QUERY_CLIENT_PROCESS \
    CTL_CODE( FILE_DEVICE_NAMED_PIPE, 9, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FSCTL_PIPE_GET_PIPE_ATTRIBUTE \
    CTL_CODE( FILE_DEVICE_NAMED_PIPE, 10, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FSCTL_PIPE_SET_PIPE_ATTRIBUTE \
    CTL_CODE( FILE_DEVICE_NAMED_PIPE, 11, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FSCTL_PIPE_GET_CONNECTION_ATTRIBUTE \
    CTL_CODE( FILE_DEVICE_NAMED_PIPE, 12, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FSCTL_PIPE_SET_CONNECTION_ATTRIBUTE \
    CTL_CODE( FILE_DEVICE_NAMED_PIPE, 13, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FSCTL_PIPE_GET_HANDLE_ATTRIBUTE \
    CTL_CODE( FILE_DEVICE_NAMED_PIPE, 14, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FSCTL_PIPE_SET_HANDLE_ATTRIBUTE \
    CTL_CODE( FILE_DEVICE_NAMED_PIPE, 15, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define FSCTL_PIPE_FLUSH \
    CTL_CODE( FILE_DEVICE_NAMED_PIPE, 16, METHOD_BUFFERED, FILE_WRITE_DATA )
#define FSCTL_PIPE_INTERNAL_READ \
    CTL_CODE( FILE_DEVICE_NAMED_PIPE, 2045, METHOD_BUFFERED, FILE_READ_DATA )
#define FSCTL_PIPE_INTERNAL_WRITE \
    CTL_CODE( FILE_DEVICE_NAMED_PIPE, 2046, METHOD_BUFFERED, FILE_WRITE_DATA )
#define FSCTL_PIPE_INTERNAL_TRANSCEIVE \
    CTL_CODE( FILE_DEVICE_NAMED_PIPE, 2047, METHOD_NEITHER, FILE_READ_DATA | \
    FILE_WRITE_DATA )
#define FSCTL_PIPE_INTERNAL_READ_OVFLOW \
    CTL_CODE( FILE_DEVICE_NAMED_PIPE, 2048, METHOD_BUFFERED, FILE_READ_DATA )

/* Device number special value */
#define CSV_INVALID_DEVICE_NUMBER   0xFFFFFFFFL

/* Named pipe entry types */
#define FILE_PIPE_READ_DATA     0x00000000L
#define FILE_PIPE_WRITE_SPACE   0x00000001L

/* Named pipe computer name length */
#define FILE_PIPE_COMPUTER_NAME_LENGTH  15

/* FSCTL_QUERY_DEPENDENT_VOLUME request flags */
#if (_WIN32_WINNT >= 0x0601)
    #define QUERY_DEPENDENT_VOLUME_REQUEST_FLAG_HOST_VOLUMES    0x00000001L
    #define QUERY_DEPENDENT_VOLUME_REQUEST_FLAG_GUEST_VOLUMES   0x00000002L
#endif

/* Mailslot file system control codes */
#define FSCTL_MAILSLOT_PEEK \
    CTL_CODE( FILE_DEVICE_MAILSLOT, 0, METHOD_NEITHER, FILE_READ_DATA )

/* System page priority constants */
#define SYSTEM_PAGE_PRIORITY_BITS   3
#define SYSTEM_PAGE_PRIORITY_LEVELS (1 << SYSTEM_PAGE_PRIORITY_BITS)

/* Token flags */
#define TOKEN_HAS_TRAVERSE_PRIVILEGE    0x0001
#define TOKEN_HAS_BACKUP_PRIVILEGE      0x0002
#define TOKEN_HAS_RESTORE_PRIVILEGE     0x0004
#define TOKEN_WRITE_RESTRICTED          0x0008
#define TOKEN_IS_RESTRICTED             0x0010
#define TOKEN_SESSION_NOT_REFERENCED    0x0020
#define TOKEN_SANDBOX_INERT             0x0040
#define TOKEN_HAS_IMPERSONATE_PRIVILEGE 0x0080
#define SE_BACKUP_PRIVILEGES_CHECKED    0x0100
#define TOKEN_VIRTUALIZE_ALLOWED        0x0200
#define TOKEN_VIRTUALIZE_ENABLED        0x0400
#define TOKEN_IS_FILTERED               0x0800
#define TOKEN_UIACCESS                  0x1000
#define TOKEN_NOT_LOW                   0x2000

/* I/O flags */
#define IO_OPEN_PAGING_FILE             0x0002
#define IO_OPEN_TARGET_DIRECTORY        0x0004
#define IO_STOP_ON_SYMLINK              0x0008
#define IO_MM_PAGING_FILE               0x0010

/* File system filter operations */
#define FS_FILTER_ACQUIRE_FOR_SECTION_SYNCHRONIZATION   0xFF
#define FS_FILTER_RELEASE_FOR_SECTION_SYNCHRONIZATION   0xFE
#define FS_FILTER_ACQUIRE_FOR_MOD_WRITE                 0xFD
#define FS_FILTER_RELEASE_FOR_MOD_WRITE                 0xFC
#define FS_FILTER_ACQUIRE_FOR_CC_FLUSH                  0xFB
#define FS_FILTER_RELEASE_FOR_CC_FLUSH                  0xFA

/* I/O file object pool charge constants */
#define IO_FILE_OBJECT_NON_PAGED_POOL_CHARGE    64
#define IO_FILE_OBJECT_PAGED_POOL_CHARGE        1024

/* Memory management prefetch flags mask */
#if (NTDDI_VERSION >= 0x05010000)
    #define MM_PREFETCH_FLAGS_MASK  ((1 << (2 * SYSTEM_PAGE_PRIORITY_BITS)) - 1)
#endif

/* FCB header version numbers */
#define FSRTL_FCB_HEADER_V0 0x00
#define FSRTL_FCB_HEADER_V1 0x01

/* FCB header flags */
#define FSRTL_FLAG_FILE_MODIFIED        0x01
#define FSRTL_FLAG_FILE_LENGTH_CHANGED  0x02
#define FSRTL_FLAG_LIMIT_MODIFIED_PAGES 0x04
#define FSRTL_FLAG_ACQUIRE_MAIN_RSRC_EX 0x08
#define FSRTL_FLAG_ACQUIRE_MAIN_RSRC_SH 0x10
#define FSRTL_FLAG_USER_MAPPED_FILE     0x20
#define FSRTL_FLAG_ADVANCED_HEADER      0x40
#define FSRTL_FLAG_EOF_ADVANCE_ACTIVE   0x80

/* FCB header secondary flags */
#define FSRTL_FLAG2_DO_MODIFIED_WRITE           0x01
#define FSRTL_FLAG2_SUPPORTS_FILTER_CONTEXTS    0x02
#define FSRTL_FLAG2_PURGE_WHEN_MAPPED           0x04
#define FSRTL_FLAG2_IS_PAGING_FILE              0x08

/* Top level IRP constants */
#define FSRTL_FSP_TOP_LEVEL_IRP         0x0001
#define FSRTL_CACHE_TOP_LEVEL_IRP       0x0002
#define FSRTL_MOD_WRITE_TOP_LEVEL_IRP   0x0003
#define FSRTL_FAST_IO_TOP_LEVEL_IRP     0x0004
#define FSRTL_NETWORK1_TOP_LEVEL_IRP    0x0005
#define FSRTL_NETWORK2_TOP_LEVEL_IRP    0x0006
#define FSRTL_MAX_TOP_LEVEL_IRP_FLAG    0xFFFF

/* Auxiliary flags */
#define FSRTL_AUXILIARY_FLAG_DEALLOCATE 0x00000001L

/* Legal DBCS character flags */
#define FSRTL_FAT_LEGAL         0x01
#define FSRTL_HPFS_LEGAL        0x02
#define FSRTL_NTFS_LEGAL        0x04
#define FSRTL_WILD_CHARACTER    0x08
#define FSRTL_OLE_LEGAL         0x10
#define FSRTL_NTFS_STREAM_LEGAL (FSRTL_NTFS_LEGAL | FSRTL_OLE_LEGAL)

/* MCB flags */
#define MCB_FLAG_RAISE_ON_ALLOCATION_FAILURE    1

/* FsRtlCheckOplockEx() flags */
#if (NTDDI_VERSION >= 0x06000100)
    #define OPLOCK_FLAG_COMPLETE_IF_OPLOCKED    0x00000001L
#endif
#if (NTDDI_VERSION >= 0x06010000)
    #define OPLOCK_FLAG_OPLOCK_KEY_CHECK_ONLY   0x00000002L
    #define OPLOCK_FLAG_BACK_OUT_ATOMIC_OPLOCK  0x00000004L
    #define OPLOCK_FLAG_IGNORE_OPLOCK_KEYS      0x00000008L
#endif

/* FsRtlOplockFsctrlEx() flags */
#if (NTDDI_VERSION >= 0x06010000)
    #define OPLOCK_FSCTRL_FLAG_ALL_KEYS_MATCH   0x00000001L
#endif

/* Volume operations */
#define FSRTL_VOLUME_DISMOUNT           1
#define FSRTL_VOLUME_DISMOUNT_FAILED    2
#define FSRTL_VOLUME_LOCK               3
#define FSRTL_VOLUME_LOCK_FAILED        4
#define FSRTL_VOLUME_UNLOCK             5
#define FSRTL_VOLUME_MOUNT              6
#define FSRTL_VOLUME_NEEDS_CHKDSK       7
#define FSRTL_VOLUME_WORM_NEAR_FULL     8
#define FSRTL_VOLUME_WEARING_OUT        9
#define FSRTL_VOLUME_FORCED_CLOSED      10
#define FSRTL_VOLUME_INFO_MAKE_COMPAT   11
#define FSRTL_VOLUME_PREPARING_EJECT    12
#define FSRTL_VOLUME_CHANGE_SIZE        13
#define FSRTL_VOLUME_BACKGROUND_FORMAT  14

/* FsRtlRegisterUncRegisterEx() flags */
#if (NTDDI_VERSION >= 0x06000000)
    #define FSRTL_UNC_PROVIDER_FLAGS_MAILSLOTS_SUPPORTED    0x00000001L
    #define FSRTL_UNC_PROVIDER_FLAGS_CSC_ENABLED            0x00000002L
    #define FSRTL_UNC_PROVIDER_FLAGS_DOMAIN_SVC_AWARE       0x00000004L
#endif
 
/* Extra create parameter list allocation flags */
#if (NTDDI_VERSION >= 0x06000000)
    #define FSRTL_ALLOCATE_ECPLIST_FLAG_CHARGE_QUOTA    0x00000001L
#endif

/* Extra create parameter allocation flags */
#if (NTDDI_VERSION >= 0x06000000)
    #define FSRTL_ALLOCATE_ECP_FLAG_CHARGE_QUOTA    0x00000001L
    #define FSRTL_ALLOCATE_ECP_FLAG_NONPAGED_POOL   0x00000002L
#endif

/* Extra create parameter lookaside flags */
#if (NTDDI_VERSION >= 0x06000000)
    #define FSRTL_ECP_LOOKASIDE_FLAG_NONPAGED_POOL  0x00000002L
#endif

/* Network open extra create parameter flags */
#if (NTDDI_VERSION >= 0x06010000)
    #define NETWORK_OPEN_ECP_IN_FLAG_DISABLE_HANDLE_COLLAPSING          0x00000001L
    #define NETWORK_OPEN_ECP_IN_FLAG_DISABLE_HANDLE_DURABILITY          0x00000002L
    #define NETWORK_OPEN_ECP_IN_FLAG_FORCE_BUFFERED_SYNCHRONOUS_IO_HACK 0x80000000L
#endif

/* Virtual disk nesting flags */
#if (NTDDI_VERSION >= 0x06000000)
    #define FSRTL_VIRTDISK_FULLY_ALLOCATED  0x00000001L
    #define FSRTL_VIRTDISK_NO_DRIVE_LETTER  0x00000002L
#endif

/* FsRtlLogCcFlushError() flags */
#define FSRTL_CC_FLUSH_ERROR_FLAG_NO_HARD_ERROR 0x00000001L
#define FSRTL_CC_FLUSH_ERROR_FLAG_NO_LOG_ENTRY  0x00000002L

/* Cache manager constants */
#define VACB_MAPPING_GRANULARITY    0x00040000
#define VACB_OFFSET_SHIFT           18

/* CcPurgeCacheSection() flags */
#define UNINITIALIZE_CACHE_MAPS     0x00000001L
#define DO_NOT_RETRY_PURGE          0x00000002L
#define DO_NOT_PURGE_DIRTY_PAGES    0x00000004L

/* CcCoherencyFlushAndPurgeCache() flags */
#define CC_FLUSH_AND_PURGE_NO_PURGE 0x00000001L

/* Pin flags */
#define PIN_WAIT                        1L
#define PIN_EXCLUSIVE                   2L
#define PIN_NO_READ                     4L
#define PIN_IF_BCB                      8L
#define PIN_CALLER_TRACKS_DIRTY_DATA    32L
#define PIN_HIGH_PRIORITY               64L

/* Mapping flags */
#define MAP_WAIT            1L
#define MAP_NO_READ         16L
#define MAP_HIGH_PRIORITY   64L

/* Security user data flags */
#define UNDERSTANDS_LONG_NAMES  1L
#define NO_LONG_NAMES           2L

/* MUP device name */
#define DD_MUP_DEVICE_NAME  L"\\Device\\Mup"

/* Redirector device I/O control codes */
#define IOCTL_REDIR_QUERY_PATH \
    CTL_CODE( FILE_DEVICE_NETWORK_FILE_SYSTEM, 99, METHOD_NEITHER, FILE_ANY_ACCESS )
#define IOCTL_REDIR_QUERY_PATH_EX \
    CTL_CODE( FILE_DEVICE_NETWORK_FILE_SYSTEM, 100, METHOD_NEITHER, FILE_ANY_ACCESS )

/* Volume snap device I/O control codes */
#define VOLSNAPCONTROLTYPE  ((ULONG)'S')
#define IOCTL_VOLSNAP_FLUSH_AND_HOLD_WRITES \
    CTL_CODE( VOLSNAPCONTROLTYPE, 0, METHOD_BUFFERED, FILE_READ_ACCESS | \
    FILE_WRITE_ACCESS )

/* Opaque data types */
typedef struct _KPROCESS            *PKPROCESS;
typedef struct _KPROCESS            *PRKPROCESS;
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _ECP_LIST            ECP_LIST;
typedef struct _ECP_LIST            *PECP_LIST;
#endif
#if (NTDDI_VERSION >= 0x06010000)
typedef struct _ECP_HEADER          ECP_HEADER;
typedef struct _ECP_HEADER          *PECP_HEADER;
typedef struct sockaddr_storage     *PSOCKADDR_STORAGE_NFS;
#endif

/* SID identifier authority */
typedef struct _SID_IDENTIFIER_AUTHORITY {
    UCHAR   Value[6];
} SID_IDENTIFIER_AUTHORITY;
typedef SID_IDENTIFIER_AUTHORITY    *PSID_IDENTIFIER_AUTHORITY;

/* Security identifier */
typedef struct _SID {
    UCHAR                       Revision;
    UCHAR                       SubAuthorityCount;
    SID_IDENTIFIER_AUTHORITY    IdentifierAuthority;
    ULONG                       SubAuthority[ANYSIZE_ARRAY];
} SID;
typedef SID *PISID;

/* SID types */
typedef enum _SID_NAME_USE {
    SidTypeUser             = 1,
    SidTypeGroup            = 2,
    SidTypeDomain           = 3,
    SidTypeAlias            = 4,
    SidTypeWellKnownGroup   = 5,
    SidTypeDeletedAccount   = 6,
    SidTypeInvalid          = 7,
    SidTypeUnknown          = 8,
    SidTypeComputer         = 9,
    SidTypeLabel            = 10
} SID_NAME_USE;
typedef SID_NAME_USE    *PSID_NAME_USE;

/* SID and attributes */
typedef struct _SID_AND_ATTRIBUTES {
    PSID    Sid;
    ULONG   Attributes;
} SID_AND_ATTRIBUTES;
typedef SID_AND_ATTRIBUTES  *PSID_AND_ATTRIBUTES;

/* SID and attributes hash */
typedef struct _SID_AND_ATTRIBUTES_HASH {
    ULONG               SidCounty;
    PSID_AND_ATTRIBUTES SidAttr;
    SID_HASH_ENTRY      Hash[SID_HASH_SIZE];
} SID_AND_ATTRIBUTES_HASH;
typedef SID_AND_ATTRIBUTES_HASH *PSID_AND_ATTRIBUTES_HASH;

/* ACE header */
typedef struct _ACE_HEADER {
    UCHAR   AceType;
    UCHAR   AceFlags;
    USHORT  AceSize;
} ACE_HEADER;
typedef ACE_HEADER  *PACE_HEADER;

/* Access allowed ACE */
typedef struct _ACCESS_ALLOWED_ACE {
    ACE_HEADER  Header;
    ACCESS_MASK Mask;
    ULONG       SidStart;
} ACCESS_ALLOWED_ACE;
typedef ACCESS_ALLOWED_ACE  *PACCESS_ALLLOWED_ACE;

/* Access denied ACE */
typedef struct _ACCESS_DENIED_ACE {
    ACE_HEADER  Header;
    ACCESS_MASK Mask;
    ULONG       SidStart;
} ACCESS_DENIED_ACE;
typedef ACCESS_DENIED_ACE   *PACCESS_DENIED_ACE;

/* System audit ACE */
typedef struct _SYSTEM_AUDIT_ACE {
    ACE_HEADER  Header;
    ACCESS_MASK Mask;
    ULONG       SidStart;
} SYSTEM_AUDIT_ACE;
typedef SYSTEM_AUDIT_ACE    *PSYSTEM_AUDIT_ACE;

/* System alarm ACE */
typedef struct _SYSTEM_ALARM_ACE {
    ACE_HEADER  Header;
    ACCESS_MASK Mask;
    ULONG       SidStart;
} SYSTEM_ALARM_ACE;
typedef SYSTEM_ALARM_ACE    *PSYSTEM_ALARM_ACE;

/* System mandatory label ACE */
typedef struct _SYSTEM_MANDATORY_LABEL_ACE {
    ACE_HEADER  Header;
    ACCESS_MASK Mask;
    ULONG       SidStart;
} SYSTEM_MANDATORY_LABEL_ACE;
typedef SYSTEM_MANDATORY_LABEL_ACE  *PSYSTEM_MANDATORY_LABEL_ACE;

/* Relative security descriptor */
typedef struct _SECURITY_DESCRIPTOR_RELATIVE {
    UCHAR                       Revision;
    UCHAR                       Sbz1;
    SECURITY_DESCRIPTOR_CONTROL Control;
    ULONG                       Owner;
    ULONG                       Group;
    ULONG                       Sacl;
    ULONG                       Dacl;
} SECURITY_DESCRIPTOR_RELATIVE;
typedef SECURITY_DESCRIPTOR_RELATIVE    *PISECURITY_DESCRIPTOR_RELATIVE;

/* Security descriptor */
typedef struct _SECURITY_DESCRIPTOR {
    UCHAR                       Revision;
    UCHAR                       Sbz1;
    SECURITY_DESCRIPTOR_CONTROL Control;
    PSID                        Owner;
    PSID                        Group;
    PACL                        Sacl;
    PACL                        Dacl;
} SECURITY_DESCRIPTOR;
typedef SECURITY_DESCRIPTOR *PISECURITY_DESCRIPTOR;

/* Object type list */
typedef struct _OBJECT_TYPE_LIST {
    USHORT  Level;
    USHORT  Sbz;
    GUID    *ObjectType;
} OBJECT_TYPE_LIST;
typedef OBJECT_TYPE_LIST    *POBJECT_TYPE_LIST;

/* Audit event types */
typedef enum _AUDIT_EVENT_TYPE {
    AuditEventObjectAccess,
    AuditEventDirectoryServiceAccess
} AUDIT_EVENT_TYPE;

/* Access reason types */
typedef enum _ACCESS_REASON_TYPE {
    AccessReasonNone                = 0x00000000,
    AccessReasonAllowedAce          = 0x00010000,
    AccessReasonDeniedAce           = 0x00020000,
    AccessReasonAllowedParentAce    = 0x00030000,
    AccessReasonDeniedParentAce     = 0x00040000,
    AccessReasonMissingPrivilege    = 0x00100000,
    AccessReasonFromPrivilege       = 0x00200000,
    AccessReasonIntegrityLevel      = 0x00300000,
    AccessReasonOwnership           = 0x00400000,
    AccessReasonNullDacl            = 0x00500000,
    AccessReasonEmptyDacl           = 0x00600000,
    AccessReasonNoSD                = 0x00700000,
    AccessReasonNoGrant             = 0x00800000
} ACCESS_REASON_TYPE;

/* Access reasons */
typedef struct _ACCESS_REASONS {
    ACCESS_REASON   Data[32];
} ACCESS_REASONS;
typedef ACCESS_REASONS  *PACCESS_REASONS;

/* Security descriptor */
typedef struct _SE_SECURITY_DESCRIPTOR {
    ULONG                   Size;
    ULONG                   Flags;
    PSECURITY_DESCRIPTOR    SecurityDescriptor;
} SE_SECURITY_DESCRIPTOR;
typedef SE_SECURITY_DESCRIPTOR  *PSE_SECURITY_DESCRIPTOR;

/* Security access request */
typedef struct _SE_ACCESS_REQUEST {
    ULONG                   Size;
    PSE_SECURITY_DESCRIPTOR SeSecurityDescriptor;
    ACCESS_MASK             DesiredAccess;
    ACCESS_MASK             PreviouslyGrantedAccess;
    PSID                    PrincipalSelfSid;
    PGENERIC_MAPPING        GenericMapping;
    ULONG                   ObjectTypeListCount;
    POBJECT_TYPE_LIST       ObjectTypeList;
} SE_ACCESS_REQUEST;
typedef SE_ACCESS_REQUEST   *PSE_ACCESS_REQUEST;

/* Security access reply */
typedef struct _SE_ACCESS_REPLY {
    ULONG           Size;
    ULONG           ResultListCount;
    PACCESS_MASK    GrantedAccess;
    PULONG          AccessStatus;
    PACCESS_REASONS AccessReason;
    PPRIVILEGE_SET  *Privileges;
} SE_ACCESS_REPLY;
typedef SE_ACCESS_REPLY *PSE_ACCESS_REPLY;

/* Security audit operations */
typedef enum _SE_AUDIT_OPERATION {
    AuditPrivilegeObject                    = 0,
    AuditPrivilegeService                   = 1,
    AuditAccessCheck                        = 2,
    AuditOpenObject                         = 3,
    AuditOpenObjectWithTransaction          = 4,
    AuditCloseObject                        = 5,
    AuditDeleteObject                       = 6,
    AuditOpenObjectForDelete                = 7,
    AuditOpenObjectForDeleteWithTransaction = 8,
    AuditCloseNonObject                     = 9,
    AuditOpenNonObject                      = 10,
    AuditObjectReference                    = 11,
    AuditHandleCreation                     = 12
} SE_AUDIT_OPERATION;
typedef SE_AUDIT_OPERATION  *PSE_AUDIT_OPERATION;

/* Security audit information */
typedef struct _SE_AUDIT_INFO {
    ULONG               Size;
    AUDIT_EVENT_TYPE    AuditType;
    SE_AUDIT_OPERATION  AuditOperation;
    ULONG               AuditFlags;
    UNICODE_STRING      SubsystemName;
    UNICODE_STRING      ObjectTypeName;
    UNICODE_STRING      ObjectName;
    PVOID               HandleId;
    GUID                *TransactionId;
    LUID                *OperationId;
    BOOLEAN             ObjectCreation;
    BOOLEAN             GenerateOnClose;
} SE_AUDIT_INFO;
typedef SE_AUDIT_INFO   *PSE_AUDIT_INFO;

/* Token types */
typedef enum _TOKEN_TYPE {
    TokenPrimary        = 1,
    TokenImpersonation  = 2
} TOKEN_TYPE;
typedef TOKEN_TYPE  *PTOKEN_TYPE;

/* Token elevation types */
typedef enum _TOKEN_ELEVATION_TYPE {
    TokenElevationTypeDefault   = 1,
    TokenElevationTypeFull      = 2,
    TokenElevationTypeLimited   = 3
} TOKEN_ELEVATION_TYPE;
typedef TOKEN_ELEVATION_TYPE    *PTOKEN_ELEVATION_TYPE;

/* Token information classes */
typedef enum _TOKEN_INFORMATION_CLASS {
    TokenUser                   = 1,
    TokenGroups                 = 2,
    TokenPrivileges             = 3,
    TokenOwner                  = 4,
    TokenPrimaryGroup           = 5,
    TokenDefaultDacl            = 6,
    TokenSource                 = 7,
    TokenType                   = 8,
    TokenImpersonationLevel     = 9,
    TokenStatistics             = 10,
    TokenRestrictedSids         = 11,
    TokenSessionId              = 12,
    TokenGroupsAndPrivileges    = 13,
    TokenSessionReference       = 14,
    TokenSandBoxInert           = 15,
    TokenAuditPolicy            = 16,
    TokenOrigin                 = 17,
    TokenElevationType          = 18,
    TokenLinkedToken            = 19,
    TokenElevation              = 20,
    TokenHasRestrictions        = 21,
    TokenAccessInformation      = 22,
    TokenVirtualizationAllowed  = 23,
    TokenVirtualizationEnabled  = 24,
    TokenIntegrityLevel         = 25,
    TokenUIAccess               = 26,
    TokenMandatoryPolicy        = 27,
    TokenLogonSid               = 28,
    MaxTokenInfoClass           = 29
} TOKEN_INFORMATION_CLASS;
typedef TOKEN_INFORMATION_CLASS *PTOKEN_INFORMATION_CLASS;

/* Token user */
typedef struct _TOKEN_USER {
    SID_AND_ATTRIBUTES  User;
} TOKEN_USER;
typedef TOKEN_USER  *PTOKEN_USER;

/* Token groups */
typedef struct _TOKEN_GROUPS {
    ULONG               GroupCount;
    SID_AND_ATTRIBUTES  Groups[ANYSIZE_ARRAY];
} TOKEN_GROUPS;
typedef TOKEN_GROUPS    *PTOKEN_GROUPS;

/* Token privileges */
typedef struct _TOKEN_PRIVILEGES {
    ULONG               PrivilegeCount;
    LUID_AND_ATTRIBUTES Privileges[ANYSIZE_ARRAY];
} TOKEN_PRIVILEGES;
typedef TOKEN_PRIVILEGES    *PTOKEN_PRIVILEGES;

/* Token owner */
typedef struct _TOKEN_OWNER {
    PSID    Owner;
} TOKEN_OWNER;
typedef TOKEN_OWNER *PTOKEN_OWNER;

/* Token primary group */
typedef struct _TOKEN_PRIMARY_GROUP {
    PSID    PrimaryGroup;
} TOKEN_PRIMARY_GROUP;
typedef TOKEN_PRIMARY_GROUP *PTOKEN_PRIMARY_GROUP;

/* Token default DACL */
typedef struct _TOKEN_DEFAULT_DACL {
    PACL    DefaultDacl;
} TOKEN_DEFAULT_DACL;
typedef TOKEN_DEFAULT_DACL  *PTOKEN_DEFAULT_DACL;

/* Token groups and privileges */
typedef struct _TOKEN_GROUPS_AND_PRIVILEGES {
    ULONG                   SidCount;
    ULONG                   SidLength;
    PSID_AND_ATTRIBUTES     Sids;
    ULONG                   RestrictedSidCount;
    ULONG                   RestrictedSidLength;
    PSID_AND_ATTRIBUTES     RestrictedSids;
    ULONG                   PrivilegeCount;
    ULONG                   PrivilegeLength;
    PLUID_AND_ATTRIBUTES    Privileges;
    LUID                    AuthenticationId;
} TOKEN_GROUPS_AND_PRIVILEGES;
typedef TOKEN_GROUPS_AND_PRIVILEGES *PTOKEN_GROUPS_AND_PRIVILEGES;

/* Token linked token */
typedef struct _TOKEN_LINKED_TOKEN {
    HANDLE  LinkedToken;
} TOKEN_LINKED_TOKEN;
typedef TOKEN_LINKED_TOKEN  *PTOKEN_LINKED_TOKEN;

/* Token elevation */
typedef struct _TOKEN_ELEVATION {
    ULONG   TokenIsElevated;
} TOKEN_ELEVATION;
typedef TOKEN_ELEVATION *PTOKEN_ELEVATION;

/* Token mandatory label */
typedef struct _TOKEN_MANDATORY_LABEL {
    SID_AND_ATTRIBUTES  Label;
} TOKEN_MANDATORY_LABEL;
typedef TOKEN_MANDATORY_LABEL   *PTOKEN_MANDATORY_LABEL;

/* Toke mandatory policy */
typedef struct _TOKEN_MANDATORY_POLICY {
    ULONG   Policy;
} TOKEN_MANDATORY_POLICY;
typedef TOKEN_MANDATORY_POLICY  *PTOKEN_MANDATORY_POLICY;

/* Token access information */
typedef struct _TOKEN_ACCESS_INFORMATION {
    PSID_AND_ATTRIBUTES_HASH        SidHash;
    PSID_AND_ATTRIBUTES_HASH        RestrictedSidHash;
    PTOKEN_PRIVILEGES               Privileges;
    LUID                            AuthenticationId;
    TOKEN_TYPE                      TokenType;
    SECURITY_IMPERSONATION_LEVEL    ImpersonationLevel;
    TOKEN_MANDATORY_POLICY          MandatoryPolicy;
    ULONG                           Flags;
} TOKEN_ACCESS_INFORMATION;
typedef TOKEN_ACCESS_INFORMATION    *PTOKEN_ACCESS_INFORMATION;

/* Token audit policy */
typedef struct _TOKEN_AUDIT_POLICY {
    UCHAR   PerUserPolicy[(POLICY_AUDIT_SUBCATEGORY_COUNT >> 1) + 1];
} TOKEN_AUDIT_POLICY;
typedef TOKEN_AUDIT_POLICY  *PTOKEN_AUDIT_POLICY;

/* Token source */
typedef struct _TOKEN_SOURCE {
    CHAR    SourceName[TOKEN_SOURCE_LENGTH];
    LUID    SourceIdentifier;
} TOKEN_SOURCE;
typedef TOKEN_SOURCE* PTOKEN_SOURCE;

/* Token statistics */
typedef struct _TOKEN_STATISTICS {
    LUID                            TokenId;
    LUID                            AuthenticationId;
    LARGE_INTEGER                   ExpirationTime;
    TOKEN_TYPE                      TokenType;
    SECURITY_IMPERSONATION_LEVEL    ImpersonationLevel;
    ULONG                           DynamicCharged;
    ULONG                           DynamicAvailable;
    ULONG                           GroupCount;
    ULONG                           PrivilegeCount;
    LUID                            ModifiedId;
} TOKEN_STATISTICS;
typedef TOKEN_STATISTICS    *PTOKEN_STATISTICS;

/* Token control */
typedef struct _TOKEN_CONTROL {
    LUID            TokenId;
    LUID            AuthenticationId;
    LUID            ModifiedId;
    TOKEN_SOURCE    TokenSource;
} TOKEN_CONTROL;
typedef TOKEN_CONTROL   *PTOKEN_CONTROL;

/* Token origin */
typedef struct _TOKEN_ORIGIN {
    LUID    OriginatingLogonSession;
} TOKEN_ORIGIN;
typedef TOKEN_ORIGIN    *PTOKEN_ORIGIN;

/* Mandatory levels */
typedef enum _MANDATORY_LEVEL {
    MandatoryLevelUntrusted     = 0,
    MandatoryLevelLow           = 1,
    MandatoryLevelMedium        = 2,
    MandatoryLevelHigh          = 3,
    MandatoryLevelSystem        = 4,
    MandatoryLevelSecureProcess = 5,
    MandatoryLevelCount         = 6
} MANDATORY_LEVEL;
typedef MANDATORY_LEVEL *PMANDATORY_LEVEL;

/* Heap commit routine */
typedef NTSTATUS    (NTAPI RTL_HEAP_COMMIT_ROUTINE)( PVOID, PVOID *, PSIZE_T );
typedef RTL_HEAP_COMMIT_ROUTINE *PRTL_HEAP_COMMIT_ROUTINE;

/* Heap parameters */
typedef struct _RTL_HEAP_PARAMETERS {
    ULONG                       Length;
    SIZE_T                      SegmentReserve;
    SIZE_T                      SegmentCommit;
    SIZE_T                      DeCommitFreeBlockThreshold;
    SIZE_T                      DeCommitTotalFreeThreshold;
    SIZE_T                      MaximumAllocationSize;
    SIZE_T                      VirtualMemoryThreshold;
    SIZE_T                      InitialCommit;
    SIZE_T                      InitialReserve;
    PRTL_HEAP_COMMIT_ROUTINE    CommitRoutine;
    SIZE_T                      Reserved[2];
} RTL_HEAP_PARAMETERS;
typedef RTL_HEAP_PARAMETERS *PRTL_HEAP_PARAMETERS;

/* String callbacks */
typedef PVOID       (NTAPI RTL_ALLOCATE_STRING_ROUTINE)( SIZE_T );
#if (_WIN32_WINNT >= 0x0600)
typedef PVOID       (NTAPI RTL_REALLOCATE_STRING_ROUTINE)( SIZE_T, PVOID );
#endif
typedef VOID        (NTAPI RTL_FREE_STRING_ROUTINE)( PVOID );
typedef RTL_ALLOCATE_STRING_ROUTINE     *PRTL_ALLOCATE_STRING_ROUTINE;
#if (_WIN32_WINNT >= 0x0600)
typedef RTL_REALLOCATE_STRING_ROUTINE   *PRTL_REALLOCATE_STRING_ROUTINE;
#endif
typedef RTL_FREE_STRING_ROUTINE         *PRTL_FREE_STRING_ROUTINE;

/* Generate name context */
typedef struct _GENERATE_NAME_CONTEXT {
    USHORT  Checksum;
    BOOLEAN ChecksumInserted;
    UCHAR   NameLength;
    WCHAR   NameBuffer[8];
    ULONG   ExtensionLength;
    WCHAR   ExtensionBuffer[4];
    ULONG   LastIndexValue;
} GENERATE_NAME_CONTEXT;
typedef GENERATE_NAME_CONTEXT   *PGENERATE_NAME_CONTEXT;

/* Prefix table entry */
typedef struct _PREFIX_TABLE_ENTRY {
    CSHORT                      NodeTypeCode;
    CSHORT                      NameLength;
    struct _PREFIX_TABLE_ENTRY  *NextPrefixTree;
    RTL_SPLAY_LINKS             Links;
    PSTRING                     Prefix;
} PREFIX_TABLE_ENTRY;
typedef PREFIX_TABLE_ENTRY  *PPREFIX_TABLE_ENTRY;

/* Prefix table */
typedef struct _PREFIX_TABLE {
    CSHORT              NodeTypeCode;
    CSHORT              NameLength;
    PPREFIX_TABLE_ENTRY NextPrefixTree;
} PREFIX_TABLE;
typedef PREFIX_TABLE    *PPREFIX_TABLE;

/* Unicode prefix table entry */
typedef struct _UNICODE_PREFIX_TABLE_ENTRY {
    CSHORT                              NodeTypeCode;
    CSHORT                              NameLength;
    struct _UNICODE_PREFIX_TABLE_ENTRY  *NextPrefixTree;
    struct _UNICODE_PREFIX_TABLE_ENTRY  *CaseMatch;
    RTL_SPLAY_LINKS                     Links;
    PUNICODE_STRING                     Prefix;
} UNICODE_PREFIX_TABLE_ENTRY;
typedef UNICODE_PREFIX_TABLE_ENTRY  *PUNICODE_PREFIX_TABLE_ENTRY;

/* Unicode prefix table */
typedef struct _UNICODE_PREFIX_TABLE {
    CSHORT                      NodeTypeCode;
    CSHORT                      NameLength;
    PUNICODE_PREFIX_TABLE_ENTRY NextPrefixTree;
    PUNICODE_PREFIX_TABLE_ENTRY LastNextEntry;
} UNICODE_PREFIX_TABLE;
typedef UNICODE_PREFIX_TABLE    *PUNICODE_PREFIX_TABLE;

/* Compressed data information */
typedef struct _COMPRESSED_DATA_INFO {
    USHORT  CompressionFormatAndEngine;
    UCHAR   CompressionUnitShift;
    UCHAR   ChunkShift;
    UCHAR   ClusterShift;
    UCHAR   Reserved;
    USHORT  NumberOfChunks;
    ULONG   CompressedChunkSizes[ANYSIZE_ARRAY];
} COMPRESSED_DATA_INFO;
typedef COMPRESSED_DATA_INFO    *PCOMPRESSED_DATA_INFO;

/* Security logon types */
typedef enum _SECURITY_LOGON_TYPE {
    UndefinedLogonType      = 0,
    Interactive             = 2,
    Network                 = 3,
    Batch                   = 4,
    Service                 = 5,
    Proxy                   = 6,
    Unlock                  = 7,
    NetworkCleartxt         = 8,
#if (_WIN32_WINNT >= 0x0501)
    NewCredentials          = 9,
    RemoteInteractive       = 10,
#if (_WIN32_WINNT >= 0x0502)
    CachedInteractive       = 11,
    CachedRemoteInteractive = 12,
    CachedUnlock            = 13,
#else
    CachedInteractive       = 11
#endif
#else
    NewCredentials          = 9
#endif
} SECURITY_LOGON_TYPE;
typedef SECURITY_LOGON_TYPE *PSECURITY_LOGON_TYPE;

/* MSV1.0 logon submit types */
typedef enum _MSV1_0_LOGON_SUBMIT_TYPE {
    MsV1_0InteractiveLogon          = 2,
    MsV1_0Lm20Logon                 = 3,
    MsV1_0NetworkLogon              = 4,
    MsV1_0SubAuthLogon              = 5,
    MsV1_0WorkstationUnlockLogon    = 7,
    MsV1_0S4ULogon                  = 12,
    MsV1_0VirtualLogon              = 82
} MSV1_0_LOGON_SUBMIT_TYPE;
typedef MSV1_0_LOGON_SUBMIT_TYPE    *PMSV1_0_LOGON_SUBMIT_TYPE;

/* MSV1.0 profile buffer types */
typedef enum _MSV1_0_PROFILE_BUFFER_TYPE {
    MsV1_0InteractiveProfile    = 2,
    MsV1_0Lm20LogonProfile      = 3,
    MsV1_0SmartCardProfile      = 4
} MSV1_0_PROFILE_BUFFER_TYPE;
typedef MSV1_0_PROFILE_BUFFER_TYPE  *PMSV1_0_PROFILE_BUFFER_TYPE;

/* MSV1.0 interactive logon authentication information */
typedef struct _MSV1_0_INTERACTIVE_LOGON {
    MSV1_0_LOGON_SUBMIT_TYPE    MessageType;
    UNICODE_STRING              LogonDomainName;
    UNICODE_STRING              UserName;
    UNICODE_STRING              Password;
} MSV1_0_INTERACTIVE_LOGON;
typedef MSV1_0_INTERACTIVE_LOGON    *PMSV1_0_INTERACTIVE_LOGON;

/* MSV1.0 interactive profile buffer */
typedef struct _MSV1_0_INTERACTIVE_PROFILE {
    MSV1_0_PROFILE_BUFFER_TYPE  MessageType;
    USHORT                      LogonCount;
    USHORT                      BadPasswordCount;
    LARGE_INTEGER               LogonTime;
    LARGE_INTEGER               LogoffTime;
    LARGE_INTEGER               KickOffTime;
    LARGE_INTEGER               PasswordLastSet;
    LARGE_INTEGER               PasswordCanChange;
    LARGE_INTEGER               PasswordMustChange;
    UNICODE_STRING              LogonScript;
    UNICODE_STRING              HomeDirectory;
    UNICODE_STRING              FullName;
    UNICODE_STRING              ProfilePath;
    UNICODE_STRING              HomeDirectoryDrive;
    UNICODE_STRING              LogonServer;
    ULONG                       UserFlags;
} MSV1_0_INTERACTIVE_PROFILE;
typedef MSV1_0_INTERACTIVE_PROFILE  *PMSV1_0_INTERACTIVE_PROFILE;

/* MSV1.0 LAN Manager 2.0 logon authentication information */
typedef struct _MSV1_0_LM20_LOGON {
    MSV1_0_LOGON_SUBMIT_TYPE    MessageType;
    UNICODE_STRING              LogonDomainName;
    UNICODE_STRING              UserName;
    UNICODE_STRING              Workstation;
    UCHAR                       ChallengeToClient[MSV1_0_CHALLENGE_LENGTH];
    STRING                      CaseSensitiveChallengeResponse;
    STRING                      CaseInsensitiveChallengeResponse;
    ULONG                       ParameterControl;
} MSV1_0_LM20_LOGON;
typedef MSV1_0_LM20_LOGON   *PMSV1_0_LM20_LOGON;

/* MSV1.0 subauthentication logon authentication information */
typedef struct _MSV1_0_SUBAUTH_LOGON {
    MSV1_0_LOGON_SUBMIT_TYPE    MessageType;
    UNICODE_STRING              LogonDomainName;
    UNICODE_STRING              UserName;
    UNICODE_STRING              Workstation;
    UCHAR                       ChallengeToClient[MSV1_0_CHALLENGE_LENGTH];
    STRING                      AuthenticationInfo1;
    STRING                      AuthenticationInfo2;
    ULONG                       ParameterControl;
    ULONG                       SubAuthPackageId;
} MSV1_0_SUBAUTH_LOGON;
typedef MSV1_0_SUBAUTH_LOGON    *PMSV1_0_SUBAUTH_LOGON;

/* MSV1.0 S4U logon authentication information */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _MSV1_0_S4U_LOGON {
    MSV1_0_LOGON_SUBMIT_TYPE    MessageType;
    ULONG                       Flags;
    UNICODE_STRING              UserPrincipalName;
    UNICODE_STRING              DomainName;
} MSV1_0_S4U_LOGON;
typedef MSV1_0_S4U_LOGON    *PMSV1_0_S4U_LOGON;
#endif

/* MSV1.0 LAN Manager 2.0 logon profile buffer */
typedef struct _MSV1_0_LM20_LOGON_PROFILE {
    MSV1_0_PROFILE_BUFFER_TYPE  MessageType;
    LARGE_INTEGER               KickOffTime;
    LARGE_INTEGER               LogoffTime;
    ULONG                       UserFlags;
    UCHAR                       UserSessionKey[MSV1_0_USER_SESSION_KEY_LENGTH];
    UNICODE_STRING              LogonDomainName;
    UCHAR                       LanmanSessionKey[MSV1_0_LANMAN_SESSION_KEY_LENGTH];
    UNICODE_STRING              LogonServer;
    UNICODE_STRING              UserParameters;
} MSV1_0_LM20_LOGON_PROFILE;
typedef MSV1_0_LM20_LOGON_PROFILE   *PMSV1_0_LM20_LOGON_PROFILE;

/* MSV1.0 supplemental credential */
typedef struct _MSV1_0_SUPPLEMENTAL_CREDENTIAL {
    ULONG   Version;
    ULONG   Flags;
    UCHAR   LmPassword[MSV1_0_OWF_PASSWORD_LENGTH];
    UCHAR   NtPassword[MSV1_0_OWF_PASSWORD_LENGTH];
} MSV1_0_SUPPLEMENTAL_CREDENTIAL;
typedef MSV1_0_SUPPLEMENTAL_CREDENTIAL  *PMSV1_0_SUPPLEMENTAL_CREDENTIAL;

/* MSV1.0 NTLM3 response */
typedef struct _MSV1_0_NTLM3_RESPONSE {
    UCHAR       Response[MSV1_0_NTLM3_RESPONSE_LENGTH];
    UCHAR       RespType;
    UCHAR       HiRespType;
    USHORT      Flags;
    ULONG       MsgWord;
    ULONGLONG   TimeStamp;
    UCHAR       ChallengeFromClient[MSV1_0_CHALLENGE_LENGTH];
    ULONG       AvPairsOff;
    UCHAR       Buffer[1];
} MSV1_0_NTLM3_RESPONSE;
typedef MSV1_0_NTLM3_RESPONSE   *PMSV1_0_NTLM3_RESPONSE;

/* MSV1.0 AV identifiers */
typedef enum {
    MsvAvEOL                = 0,
    MsvAvNbComputerName     = 1,
    MsvAvNbDomainName       = 2,
    MsvAvDnsComputerName    = 3,
    MsvAvDnsDomainName      = 4,
#if (_WIN32_WINNT >= 0x0501)
    MsvAvDnsTreeName        = 5,
    MsvAvFlags              = 6,
#endif
#if (_WIN32_WINNT >= 0x0600)
    MsvAvTimestamp          = 7,
    MsvAvRestrictions       = 8,
    MsvAvTargetName         = 9,
    MsvAvChannelBindings    = 10
#endif
} MSV1_0_AVID;

/* MSV1.0 AV pair */
typedef struct _MSV1_0_AV_PAIR {
    USHORT  AvId;
    USHORT  AvLen;
} MSV1_0_AV_PAIR;
typedef MSV1_0_AV_PAIR  *PMSV1_0_AV_PAIR;

/* MSV1.0 protocol message types */
typedef enum _MSV1_0_PROTOCOL_MESSAGE_TYPE {
    MsV1_0Lm20ChallengeRequest      = 0,
    MsV1_0Lm20GetChallengeResponse  = 1,
    MsV1_0EnumerateUsers            = 2,
    MsV1_0GetUserInfo               = 3,
    MsV1_0ReLogonUsers              = 4,
    MsV1_0ChangePassword            = 5,
    MsV1_0ChangeCachedPassword      = 6,
    MsV1_0GenericPassthrough        = 7,
    MsV1_0CacheLogon                = 8,
    MsV1_0SubAuth                   = 9,
    MsV1_0DeriveCredential          = 10,
    MsV1_0CacheLookup               = 11,
#if (_WIN32_WINNT >= 0x0501)
    MsV1_0SetProcessOption          = 12,
#endif
#if (_WIN32_WINNT >= 0x0600)
    MsV1_0ConfigLocalAliases        = 13,
    MsV1_0ClearCachedCredentials    = 14
#endif
} MSV1_0_PROTOCOL_MESSAGE_TYPE;

/* MSV1.0 LAN Manager 2.0 challenge request */
typedef struct _MSV1_0_LM20_CHALLENGE_REQUEST {
    MSV1_0_PROTOCOL_MESSAGE_TYPE    MessageType;
} MSV1_0_LM20_CHALLENGE_REQUEST;
typedef MSV1_0_LM20_CHALLENGE_REQUEST   *PMSV1_0_LM20_CHALLENGE_REQUEST;

/* MSV1.0 LAN Manager 2.0 challenge response */
typedef struct _MSV1_0_LM20_CHALLENGE_RESPONSE {
    MSV1_0_PROTOCOL_MESSAGE_TYPE    MessageType;
    UCHAR                           ChallengeToClient[MSV1_0_CHALLENGE_LENGTH];
} MSV1_0_LM20_CHALLENGE_RESPONSE;
typedef MSV1_0_LM20_CHALLENGE_RESPONSE  *PMSV1_0_LM20_CHALLENGE_RESPONSE;

/* MSV1.0 get challenge response request (version 1) */
typedef struct _MSV1_0_GETCHALLENRESP_REQUEST_V1 {
    MSV1_0_PROTOCOL_MESSAGE_TYPE    MessageType;
    ULONG                           ParameterControl;
    LUID                            LogonId;
    UNICODE_STRING                  Password;
    UCHAR                           ChallengeToClient[MSV1_0_CHALLENGE_LENGTH];
} MSV1_0_GETCHALLENRESP_REQUEST_V1;
typedef MSV1_0_GETCHALLENRESP_REQUEST_V1    *PMSV1_0_GETCHALLENRESP_REQUEST_V1;

/* MSV1.0 get challenge response request */
typedef struct _MSV1_0_GETCHALLENRESP_REQUEST {
    MSV1_0_PROTOCOL_MESSAGE_TYPE    MessageType;
    ULONG                           ParameterControl;
    LUID                            LogonId;
    UNICODE_STRING                  Password;
    UCHAR                           ChallengeToClient[MSV1_0_CHALLENGE_LENGTH];
    UNICODE_STRING                  UserName;
    UNICODE_STRING                  LogonDomainName;
    UNICODE_STRING                  ServerName;
} MSV1_0_GETCHALLENRESP_REQUEST;
typedef MSV1_0_GETCHALLENRESP_REQUEST   *PMSV1_0_GETCHALLENRESP_REQUEST;

/* MSV1.0 get challenge response response */
typedef struct _MSV1_0_GETCHALLENRESP_RESPONSE {
    MSV1_0_PROTOCOL_MESSAGE_TYPE    MessageType;
    STRING                          CaseSensitiveChallengeResponse;
    STRING                          CaseInsensitiveChallengeResponse;
    UNICODE_STRING                  UserName;
    UNICODE_STRING                  LogonDomainName;
    UCHAR                           UserSessionKey[MSV1_0_USER_SESSION_KEY_LENGTH];
    UCHAR                           LanmanSessionKey[MSV1_0_LANMAN_SESSION_KEY_LENGTH];
} MSV1_0_GETCHALLENRESP_RESPONSE;
typedef MSV1_0_GETCHALLENRESP_RESPONSE  *PMSV1_0_GETCHALLENRESP_RESPONSE;

/* MSV1.0 enumerate users request */
typedef struct _MSV1_0_ENUMUSERS_REQUEST {
    MSV1_0_PROTOCOL_MESSAGE_TYPE    MessageType;
} MSV1_0_ENUMUSERS_REQUEST;
typedef MSV1_0_ENUMUSERS_REQUEST    *PMSV1_0_ENUMUSERS_REQUEST;

/* MSV1.0 enumerate users response */
typedef struct _MSV1_0_ENUMUSERS_RESPONSE {
    MSV1_0_PROTOCOL_MESSAGE_TYPE    MessageType;
    ULONG                           NumberOfLoggedOnUsers;
    PLUID                           LogonIds;
    PULONG                          EnumHandles;
} MSV1_0_ENUMUSERS_RESPONSE;
typedef MSV1_0_ENUMUSERS_RESPONSE   *PMSV1_0_ENUMUSERS_RESPONSE;

/* MSV1.0 get user information request */
typedef struct _MSV1_0_GETUSERINFO_REQUEST {
    MSV1_0_PROTOCOL_MESSAGE_TYPE    MessageType;
    LUID                            LogonId;
} MSV1_0_GETUSERINFO_REQUEST;
typedef MSV1_0_GETUSERINFO_REQUEST  *PMSV1_0_GETUSERINFO_REQUEST;

/* MSV1.0 get user information response */
typedef struct _MSV1_0_GETUSERINFO_RESPONSE {
    MSV1_0_PROTOCOL_MESSAGE_TYPE    MessageType;
    PSID                            UserSid;
    UNICODE_STRING                  UserName;
    UNICODE_STRING                  LogonDomainName;
    UNICODE_STRING                  LogonServer;
    SECURITY_LOGON_TYPE             LogonType;
} MSV1_0_GETUSERINFO_RESPONSE;
typedef MSV1_0_GETUSERINFO_RESPONSE *PMSV1_0_GETUSERINFO_RESPONSE;

/* File change notification information */
typedef struct _FILE_NOTIFY_INFORMATION {
    ULONG   NextEntryOffset;
    ULONG   Action;
    ULONG   FileNameLength;
    WCHAR   FileName[1];
} FILE_NOTIFY_INFORMATION;
typedef FILE_NOTIFY_INFORMATION *PFILE_NOTIFY_INFORMATION;

/* File directory information */
typedef struct _FILE_DIRECTORY_INFORMATION {
    ULONG           NextEntryOffset;
    ULONG           FileIndex;
    LARGE_INTEGER   CreationTime;
    LARGE_INTEGER   LastAccessTime;
    LARGE_INTEGER   LastWriteTime;
    LARGE_INTEGER   ChangeTime;
    LARGE_INTEGER   EndOfFile;
    LARGE_INTEGER   AllocationSize;
    ULONG           FileAttributes;
    ULONG           FileNameLength;
    WCHAR           FileName[1];
} FILE_DIRECTORY_INFORMATION;
typedef FILE_DIRECTORY_INFORMATION  *PFILE_DIRECTORY_INFORMATION;

/* File full directory information */
typedef struct _FILE_FULL_DIR_INFORMATION {
    ULONG           NextEntryOffset;
    ULONG           FileIndex;
    LARGE_INTEGER   CreationTime;
    LARGE_INTEGER   LastAccessTime;
    LARGE_INTEGER   LastWriteTime;
    LARGE_INTEGER   ChangeTime;
    LARGE_INTEGER   EndOfFile;
    LARGE_INTEGER   AllocationSize;
    ULONG           FileAttributes;
    ULONG           FileNameLength;
    ULONG           EaSize;
    WCHAR           FileName[1];
} FILE_FULL_DIR_INFORMATION;
typedef FILE_FULL_DIR_INFORMATION   *PFILE_FULL_DIR_INFORMATION;

/* File identifier full directory information */
typedef struct _FILE_ID_FULL_DIR_INFORMATION {
    ULONG           NextEntryOffset;
    ULONG           FileIndex;
    LARGE_INTEGER   CreationTime;
    LARGE_INTEGER   LastAccessTime;
    LARGE_INTEGER   LastWriteTime;
    LARGE_INTEGER   ChangeTime;
    LARGE_INTEGER   EndOfFile;
    LARGE_INTEGER   AllocationSize;
    ULONG           FileAttributes;
    ULONG           FileNameLength;
    ULONG           EaSize;
    LARGE_INTEGER   FileId;
    WCHAR           FileName[1];
} FILE_ID_FULL_DIR_INFORMATION;
typedef FILE_ID_FULL_DIR_INFORMATION    *PFILE_ID_FULL_DIR_INFORMATION;

/* File both directory information */
typedef struct _FILE_BOTH_DIR_INFORMATION {
    ULONG           NextEntryOffset;
    ULONG           FileIndex;
    LARGE_INTEGER   CreationTime;
    LARGE_INTEGER   LastAccessTime;
    LARGE_INTEGER   LastWriteTime;
    LARGE_INTEGER   ChangeTime;
    LARGE_INTEGER   EndOfFile;
    LARGE_INTEGER   AllocationSize;
    ULONG           FileAttributes;
    ULONG           FileNameLength;
    ULONG           EaSize;
    CCHAR           ShortNameLength;
    WCHAR           ShortName[12];
    WCHAR           FileName[1];
} FILE_BOTH_DIR_INFORMATION;
typedef FILE_BOTH_DIR_INFORMATION   *PFILE_BOTH_DIR_INFORMATION;

/* File identifier both directory information */
typedef struct _FILE_ID_BOTH_DIR_INFORMATION {
    ULONG           NextEntryOffset;
    ULONG           FileIndex;
    LARGE_INTEGER   CreationTime;
    LARGE_INTEGER   LastAccessTime;
    LARGE_INTEGER   LastWriteTime;
    LARGE_INTEGER   ChangeTime;
    LARGE_INTEGER   EndOfFile;
    LARGE_INTEGER   AllocationSize;
    ULONG           FileAttributes;
    ULONG           FileNameLength;
    ULONG           EaSize;
    CCHAR           ShortNameLength;
    WCHAR           ShortName[12];
    LARGE_INTEGER   FileId;
    WCHAR           FileName[1];
} FILE_ID_BOTH_DIR_INFORMATION;
typedef FILE_ID_BOTH_DIR_INFORMATION    *PFILE_ID_BOTH_DIR_INFORMATION;

/* File names information */
typedef struct _FILE_NAMES_INFORMATION {
    ULONG   NextEntryOffset;
    ULONG   FileIndex;
    ULONG   FileNameLength;
    WCHAR   FileName[1];
} FILE_NAMES_INFORMATION;
typedef FILE_NAMES_INFORMATION  *PFILE_NAMES_INFORMATION;

/* File identifier global transaction directory information */
typedef struct _FILE_ID_GLOBAL_TX_DIR_INFORMATION {
    ULONG           NextEntryOffset;
    ULONG           FileIndex;
    LARGE_INTEGER   CreationTime;
    LARGE_INTEGER   LastAccessTime;
    LARGE_INTEGER   LastWriteTime;
    LARGE_INTEGER   ChangeTime;
    LARGE_INTEGER   EndOfFile;
    LARGE_INTEGER   AllocationSize;
    ULONG           FileAttributes;
    ULONG           FileNameLength;
    LARGE_INTEGER   FileId;
    GUID            LockingTransactionId;
    ULONG           TxInfoFlags;
    WCHAR           FileName[1];
} FILE_ID_GLOBAL_TX_DIR_INFORMATION;
typedef FILE_ID_GLOBAL_TX_DIR_INFORMATION   *PFILE_ID_GLOBAL_TX_DIR_INFORMATION;

/* File object identifier information */
typedef struct _FILE_OBJECTID_INFORMATION {
    LONGLONG    FileReference;
    UCHAR       ObjectId[16];
    union {
        struct {
            UCHAR   BirthVolumeId[16];
            UCHAR   BirthObjectId[16];
            UCHAR   DomainId[16];
        };
        UCHAR   ExtendedInfo[48];
    };
} FILE_OBJECTID_INFORMATION;
typedef FILE_OBJECTID_INFORMATION   *PFILE_OBJECTID_INFORMATION;

/* File internal information */
typedef struct _FILE_INTERNAL_INFORMATION {
    LARGE_INTEGER   IndexNumber;
} FILE_INTERNAL_INFORMATION;
typedef FILE_INTERNAL_INFORMATION   *PFILE_INTERNAL_INFORMATION;

/* File extended attribute information */
typedef struct _FILE_EA_INFORMATION {
    ULONG   EaSize;
} FILE_EA_INFORMATION;
typedef FILE_EA_INFORMATION *PFILE_EA_INFORMATION;

/* File access information */
typedef struct _FILE_ACCESS_INFORMATION {
    ACCESS_MASK AccessFlags;
} FILE_ACCESS_INFORMATION;
typedef FILE_ACCESS_INFORMATION *PFILE_ACCESS_INFORMATION;

/* File mode information */
typedef struct _FILE_MODE_INFORMATION {
    ULONG   Mode;
} FILE_MODE_INFORMATION;
typedef FILE_MODE_INFORMATION   *PFILE_MODE_INFORMATION;

/* File all information */
typedef struct _FILE_ALL_INFORMATION {
    FILE_BASIC_INFORMATION      BasicInformation;
    FILE_STANDARD_INFORMATION   StandardInformation;
    FILE_INTERNAL_INFORMATION   InternalInformation;
    FILE_EA_INFORMATION         EaInformation;
    FILE_ACCESS_INFORMATION     AccessInformation;
    FILE_POSITION_INFORMATION   PositionInformation;
    FILE_MODE_INFORMATION       ModeInformation;
    FILE_ALIGNMENT_INFORMATION  AlignmentInformation;
    FILE_NAME_INFORMATION       NameInformation;
} FILE_ALL_INFORMATION;
typedef FILE_ALL_INFORMATION    *PFILE_ALL_INFORMATION;

/* File allocation information */
typedef struct _FILE_ALLOCATION_INFORMATION {
    LARGE_INTEGER   AllocationSize;
} FILE_ALLOCATION_INFORMATION;
typedef FILE_ALLOCATION_INFORMATION *PFILE_ALLOCATION_INFORMATION;

/* File compression information */
typedef struct _FILE_COMPRESSION_INFORMATION {
    LARGE_INTEGER   CompressedFileSize;
    USHORT          CompressionFormat;
    UCHAR           CompressionUnitShift;
    UCHAR           ChunkShift;
    UCHAR           ClusterShift;
    UCHAR           Reserved[3];
} FILE_COMPRESSION_INFORMATION;
typedef FILE_COMPRESSION_INFORMATION    *PFILE_COMPRESSION_INFORMATION;

/* File link information */
typedef struct _FILE_LINK_INFORMATION {
    BOOLEAN ReplaceIfExists;
    HANDLE  RootDirectory;
    ULONG   FileNameLength;
    WCHAR   FileName[1];
} FILE_LINK_INFORMATION;
typedef FILE_LINK_INFORMATION   *PFILE_LINK_INFORMATION;

/* File move cluster information */
typedef struct _FILE_MOVE_CLUSTER_INFORMATION {
    ULONG   ClusterCount;
    HANDLE  RootDirectory;
    ULONG   FileNameLength;
    WCHAR   FileName[1];
} FILE_MOVE_CLUSTER_INFORMATION;
typedef FILE_MOVE_CLUSTER_INFORMATION   *PFILE_MOVE_CLUSTER_INFORMATION;

/* File rename information */
typedef struct _FILE_RENAME_INFORMATION {
    BOOLEAN ReplaceIfExists;
    HANDLE  RootDirectory;
    ULONG   FileNameLength;
    WCHAR   FileName[1];
} FILE_RENAME_INFORMATION;
typedef FILE_RENAME_INFORMATION *PFILE_RENAME_INFORMATION;

/* File stream information */
typedef struct _FILE_STREAM_INFORMATION {
    ULONG           NextEntryOffset;
    ULONG           StreamNameLength;
    LARGE_INTEGER   StreamSize;
    LARGE_INTEGER   StreamAllocationSize;
    WCHAR           StreamName[1];
} FILE_STREAM_INFORMATION;
typedef FILE_STREAM_INFORMATION *PFILE_STREAM_INFORMATION;

/* File tracking information */
typedef struct _FILE_TRACKING_INFORMATION {
    HANDLE  DestinationFile;
    ULONG   ObjectInformationLength;
    CHAR    ObjectInformation[1];
} FILE_TRACKING_INFORMATION;
typedef FILE_TRACKING_INFORMATION   *PFILE_TRACKING_INFORMATION;

/* File completion information */
typedef struct _FILE_COMPLETION_INFORMATION {
    HANDLE  Port;
    PVOID   Key;
} FILE_COMPLETION_INFORMATION;
typedef FILE_COMPLETION_INFORMATION *PFILE_COMPLETION_INFORMATION;

/* File pipe information */
typedef struct _FILE_PIPE_INFORMATION {
    ULONG   ReadMode;
    ULONG   CompletionMode;
} FILE_PIPE_INFORMATION;
typedef FILE_PIPE_INFORMATION   *PFILE_PIPE_INFORMATION;

/* File pipe local information */
typedef struct _FILE_PIPE_LOCAL_INFORMATION {
    ULONG   NamedPipeType;
    ULONG   NamedPipeConfiguration;
    ULONG   MaximumInstances;
    ULONG   CurrentInstances;
    ULONG   InboundQuota;
    ULONG   ReadDataAvailable;
    ULONG   OutboundQuota;
    ULONG   WriteDataAvailable;
    ULONG   NamedPipeState;
    ULONG   NamedPipeEnd;
} FILE_PIPE_LOCAL_INFORMATION;
typedef FILE_PIPE_LOCAL_INFORMATION *PFILE_PIPE_LOCAL_INFORMATION;

/* File pipe remote information */
typedef struct _FILE_PIPE_REMOTE_INFORMATION {
    LARGE_INTEGER   CollectDataTime;
    ULONG           MaximumCollectionCount;
} FILE_PIPE_REMOTE_INFORMATION;
typedef FILE_PIPE_REMOTE_INFORMATION    *PFILE_PIPE_REMOTE_INFORMATION;

/* File mailslot query information */
typedef struct _FILE_MAILSLOT_QUERY_INFORMATION {
    ULONG           MaximumMessageSize;
    ULONG           MailslotQuota;
    ULONG           NextMessageSize;
    ULONG           MessagesAvailable;
    LARGE_INTEGER   ReadTimeout;
} FILE_MAILSLOT_QUERY_INFORMATION;
typedef FILE_MAILSLOT_QUERY_INFORMATION *PFILE_MAILSLOT_QUERY_INFORMATION;

/* File mailslot set information */
typedef struct _FILE_MAILSLOT_SET_INFORMATION {
    PLARGE_INTEGER  ReadTimeout;
} FILE_MAILSLOT_SET_INFORMATION;
typedef FILE_MAILSLOT_SET_INFORMATION   *PFILE_MAILSLOT_SET_INFORMATION;

/* File reparse point information */
typedef struct _FILE_REPARSE_POINT_INFORMATION {
    LONGLONG    FileReference;
    ULONG       Tag;
} FILE_REPARSE_POINT_INFORMATION;
typedef FILE_REPARSE_POINT_INFORMATION  *PFILE_REPARSE_POINT_INFORMATION;

/* File link entry information */
typedef struct _FILE_LINK_ENTRY_INFORMATION {
    ULONG       NextEntryOffset;
    LONGLONG    ParentFileId;
    ULONG       FileNameLength;
    WCHAR       FileName[1];
} FILE_LINK_ENTRY_INFORMATION;
typedef FILE_LINK_ENTRY_INFORMATION *PFILE_LINK_ENTRY_INFORMATION;

/* File links information */
typedef struct _FILE_LINKS_INFORMATION {
    ULONG                       BytesNeeded;
    ULONG                       EntriesReturned;
    FILE_LINK_ENTRY_INFORMATION Entry;
} FILE_LINKS_INFORMATION;
typedef FILE_LINKS_INFORMATION  *PFILE_LINKS_INFORMATION;

/* File network physical name information */
typedef struct _FILE_NETWORK_PHYSICAL_NAME_INFORMATION {
    ULONG   FileNameLength;
    WCHAR   FileName[1];
} FILE_NETWORK_PHYSICAL_NAME_INFORMATION;
typedef FILE_NETWORK_PHYSICAL_NAME_INFORMATION  *PFILE_NETWORK_PHYSICAL_NAME_INFORMATION;

/* File standard link information */
typedef struct _FILE_STANDARD_LINK_INFORMATION {
    ULONG   NumberOfAccessibleLinks;
    ULONG   TotalNumberOfLinks;
    BOOLEAN DeletePending;
    BOOLEAN Directory;
} FILE_STANDARD_LINK_INFORMATION;
typedef FILE_STANDARD_LINK_INFORMATION  *PFILE_STANDARD_LINK_INFORMATION;

/* File get extended attributes information */
typedef struct _FILE_GET_EA_INFORMATION {
    ULONG   NextEntryOffset;
    UCHAR   EaNameLength;
    CHAR    EaName[1];
} FILE_GET_EA_INFORMATION;
typedef FILE_GET_EA_INFORMATION *PFILE_GET_EA_INFORMATION;

/* File remote protocol information */
typedef struct _FILE_REMOTE_PROTOCOL_INFORMATION {
    USHORT  SignatureVersion;
    USHORT  SignatureSize;
    ULONG   Protocol;
    USHORT  ProtocolMajorVersion;
    USHORT  ProtocolMinorVersion;
    USHORT  ProtocolRevision;
    USHORT  Reserved;
    ULONG   Flags;
    struct {
        ULONG   Reserved[8];
    } GenericReserved;
    struct {
        ULONG   Reserved[16];
    } ProtocolSpecificReserved;
} FILE_REMOTE_PROTOCOL_INFORMATION;
typedef FILE_REMOTE_PROTOCOL_INFORMATION    *PFILE_REMOTE_PROTOCOL_INFORMATION;

/* File get quota information */
typedef struct _FILE_GET_QUOTA_INFORMATION {
    ULONG   NextEntryOffset;
    ULONG   SidLength;
    SID     Sid;
} FILE_GET_QUOTA_INFORMATION;
typedef FILE_GET_QUOTA_INFORMATION  *PFILE_GET_QUOTA_INFORMATION;

/* File quota information */
typedef struct _FILE_QUOTA_INFORMATION {
    ULONG           NextEntryOffset;
    ULONG           SidLength;
    LARGE_INTEGER   ChangeTime;
    LARGE_INTEGER   QuotaUsed;
    LARGE_INTEGER   QuotaThreshold;
    LARGE_INTEGER   QuotaLimit;
    SID             Sid;
} FILE_QUOTA_INFORMATION;
typedef FILE_QUOTA_INFORMATION  *PFILE_QUOTA_INFORMATION;

/* File system attribute information */
typedef struct _FILE_FS_ATTRIBUTE_INFORMATION {
    ULONG   FileSystemAttributes;
    LONG    MaximumComponentNameLength;
    ULONG   FileSystemNameLength;
    WCHAR   FileSystemName[1];
} FILE_FS_ATTRIBUTE_INFORMATION;
typedef FILE_FS_ATTRIBUTE_INFORMATION   *PFILE_FS_ATTRIBUTE_INFORMATION;

/* File system driver path information */
typedef struct _FILE_FS_DRIVER_PATH_INFORMATION {
    BOOLEAN DriverInPath;
    ULONG   DriverNameLength;
    WCHAR   DriverName[1];
} FILE_FS_DRIVER_PATH_INFORMATION;
typedef FILE_FS_DRIVER_PATH_INFORMATION *PFILE_FS_DRIVER_PATH_INFORMATION;

/* File system volume flags information */
typedef struct _FILE_FS_VOLUME_FLAGS_INFORMATION {
    ULONG   Flags;
} FILE_FS_VOLUME_FLAGS_INFORMATION;
typedef FILE_FS_VOLUME_FLAGS_INFORMATION    *PFILE_FS_VOLUME_FLAGS_INFORMATION;

/* FSCTL_IS_CSV_FILE parameters */
#if (_WIN32_WINNT >= 0x0601)
typedef struct _CSV_NAMESPACE_INFO {
    ULONG           Version;
    ULONG           DeviceNumber;
    LARGE_INTEGER   StartingOffset;
    ULONG           SectorSize;
} CSV_NAMESPACE_INFO;
typedef CSV_NAMESPACE_INFO  *PCSV_NAMESPACE_INFO;
#endif

/* File system control information */
typedef struct _FILE_FS_CONTROL_INFORMATION {
    LARGE_INTEGER   FreeSpaceStartFiltering;
    LARGE_INTEGER   FreeSpaceThreshold;
    LARGE_INTEGER   FreeSpaceStopFiltering;
    LARGE_INTEGER   DefaultQuotaThreshold;
    LARGE_INTEGER   DefaultQuotaLimit;
    ULONG           FileSystemControlFlags;
} FILE_FS_CONTROL_INFORMATION;
typedef FILE_FS_CONTROL_INFORMATION *PFILE_FS_CONTROL_INFORMATION;

/* Path name buffer */
typedef struct _PATHNAME_BUFFER {
    ULONG   PathNameLength;
    WCHAR   Name[1];
} PATHNAME_BUFFER;
typedef PATHNAME_BUFFER *PPATHNAME_BUFFER;

/* IOCTL_QUERY_FAT_BPB returned data */
typedef struct _FSCTL_QUERY_FAT_BPB_BUFFER {
    UCHAR   First0x24BytesOfBootSector[0x24];
} FSCTL_QUERY_FAT_BPB_BUFFER;
typedef FSCTL_QUERY_FAT_BPB_BUFFER  *PFSCTL_QUERY_FAT_BPB_BUFFER;

/* NTFS volume data buffer */
#if (_WIN32_WINNT >= 0x0400)
typedef struct {
    LARGE_INTEGER   VolumeSerialNumber;
    LARGE_INTEGER   NumberSectors;
    LARGE_INTEGER   TotalClusters;
    LARGE_INTEGER   FreeClusters;
    LARGE_INTEGER   TotalReserved;
    ULONG           BytesPerSector;
    ULONG           BytesPerCluster;
    ULONG           BytesPerFileRecordSegment;
    ULONG           ClustersPerFileRecordSegment;
    LARGE_INTEGER   MftValidDataLength;
    LARGE_INTEGER   MftStartLcn;
    LARGE_INTEGER   Mft2StartLcn;
    LARGE_INTEGER   MftZoneStart;
    LARGE_INTEGER   MftZoneEnd;
} NTFS_VOLUME_DATA_BUFFER;
typedef NTFS_VOLUME_DATA_BUFFER *PNTFS_VOLUME_DATA_BUFFER;
#endif

/* NTFS extended volume data */
#if (_WIN32_WINNT >= 0x0400)
typedef struct {
    ULONG   ByteCount;
    USHORT  MajorVersion;
    USHORT  MinorVersion;
} NTFS_EXTENDED_VOLUME_DATA;
typedef NTFS_EXTENDED_VOLUME_DATA   *PNTFS_EXTENDED_VOLUME_DATA;
#endif

/* Starting LCN input buffer */
#if (_WIN32_WINNT >= 0x0400)
typedef struct {
    LARGE_INTEGER   StartingLcn;
} STARTING_LCN_INPUT_BUFFER;
typedef STARTING_LCN_INPUT_BUFFER   *PSTARTING_LCN_INPUT_BUFFER;
#endif

/* Volume bitmap buffer */
#if (_WIN32_WINNT >= 0x0400)
typedef struct {
    LARGE_INTEGER   StartingLcn;
    LARGE_INTEGER   BitmapSize;
    UCHAR           Buffer[1];
} VOLUME_BITMAP_BUFFER;
typedef VOLUME_BITMAP_BUFFER    *PVOLUME_BITMAP_BUFFER;
#endif

/* Starting VCN input buffer */
#if (_WIN32_WINNT >= 0x0400)
typedef struct {
    LARGE_INTEGER   StartingVcn;
} STARTING_VCN_INPUT_BUFFER;
typedef STARTING_VCN_INPUT_BUFFER   *PSTARTING_VCN_INPUT_BUFFER;
#endif

/* Retrieval pointers buffer */
#if (_WIN32_WINNT >= 0x0400)
typedef struct RETRIEVAL_POINTERS_BUFFER {
    ULONG           ExtentCount;
    LARGE_INTEGER   StartingVcn;
    struct {
        LARGE_INTEGER   NextVcn;
        LARGE_INTEGER   Lcn;
    } Extents[1];
} RETRIEVAL_POINTERS_BUFFER;
typedef RETRIEVAL_POINTERS_BUFFER   *PRETRIEVAL_POINTERS_BUFFER;
#endif

/* NTFS file record input buffer */
#if (_WIN32_WINNT >= 0x0400)
typedef struct {
    LARGE_INTEGER   FileReferenceNumber;
} NTFS_FILE_RECORD_INPUT_BUFFER;
typedef NTFS_FILE_RECORD_INPUT_BUFFER   *PNTFS_FILE_RECORD_INPUT_BUFFER;
#endif

/* NTFS file record output buffer */
#if (_WIN32_WINNT >= 0x0400)
typedef struct {
    LARGE_INTEGER   FileReferenceNumber;
    ULONG           FileRecordLength;
    UCHAR           FileRecordBuffer[1];
} NTFS_FILE_RECORD_OUTPUT_BUFFER;
typedef NTFS_FILE_RECORD_OUTPUT_BUFFER  *PNTFS_FILE_RECORD_OUTPUT_BUFFER;
#endif

/* FSCTL_MOVE_FILE parameters */
#if (_WIN32_WINNT >= 0x0400)
typedef struct {
    HANDLE          FileHandle;
    LARGE_INTEGER   StartingVcn;
    LARGE_INTEGER   StartingLcn;
    ULONG           ClusterCount;
} MOVE_FILE_DATA;
typedef MOVE_FILE_DATA  *PMOVE_FILE_DATA;
#endif

/* FSCTL_MOVE_FILE record data */
#if (_WIN32_WINNT >= 0x0400)
typedef struct {
    HANDLE          FileHandle;
    LARGE_INTEGER   SourceFileRecord;
    LARGE_INTEGER   TargetFileRecord;
} MOVE_FILE_RECORD_DATA;
typedef MOVE_FILE_RECORD_DATA   *PMOVE_FILE_RECORD_DATA;
#endif

/* FSCTL_FIND_FILES_BY_SID parameters */
#if (_WIN32_WINNT >= 0x0500)
typedef struct {
    ULONG   Restart;
    SID     Sid;
} FIND_BY_SID_DATA;
typedef FIND_BY_SID_DATA    *PFIND_BY_SID_DATA;
#endif

/* FSCTL_FIND_FILES_BY_SID returned data */
#if (_WIN32_WINNT >= 0x0500)
typedef struct {
    ULONG   NextEntryOffset;
    ULONG   FileIndex;
    ULONG   FileNameLength;
    WCHAR   FileName[1];
} FIND_BY_SID_OUTPUT;
typedef FIND_BY_SID_OUTPUT  *PFIND_BY_SID_OUTPUT;
#endif

/* FSCTL_ENUM_USN_DATA parameters */
#if (_WIN32_WINNT >= 0x0500)
typedef struct {
    ULONGLONG   StartFileReferenceNumber;
    USN         LowUsn;
    USN         HighUsn;
} MFT_ENUM_DATA;
typedef MFT_ENUM_DATA   *PMFT_ENUM_DATA;
#endif

/* FSCTL_CREATE_USN_JOURNAL parameters */
#if (_WIN32_WINNT >= 0x0500)
typedef struct {
    ULONGLONG   MaximumSize;
    ULONGLONG   AllocationDelta;
} CREATE_USN_JOURNAL_DATA;
typedef CREATE_USN_JOURNAL_DATA *PCREATE_USN_JOURNAL_DATA;
#endif

/* FSCTL_READ_USN_JOURNAL parameters */
#if (_WIN32_WINNT >= 0x0500)
typedef struct {
    USN         StartUsn;
    ULONG       ReasonMask;
    ULONG       ReturnOnlyOnClose;
    ULONGLONG   Timeout;
    ULONGLONG   BytesToWaitFor;
    ULONGLONG   UsnJournalID;
} READ_USN_JOURNAL_DATA;
typedef READ_USN_JOURNAL_DATA   *PREAD_USN_JOURNAL_DATA;
#endif

/* USN record */
#if (_WIN32_WINNT >= 0x0500)
typedef struct {
    ULONG           RecordLength;
    USHORT          MajorVersion;
    USHORT          MinorVersion;
    ULONGLONG       FileReferenceNumber;
    ULONGLONG       ParentFileReferenceNumber;
    USN             Usn;
    LARGE_INTEGER   TimeStamp;
    ULONG           Reason;
    ULONG           SourceInfo;
    ULONG           SecurityId;
    ULONG           FileAttributes;
    USHORT          FileNameLength;
    USHORT          FileNameOffset;
    WCHAR           FileName[1];
} USN_RECORD;
typedef USN_RECORD  *PUSN_RECORD;
#endif

/* USN journal data */
#if (_WIN32_WINNT >= 0x0500)
typedef struct {
    ULONGLONG   UsnJournalID;
    USN         FirstUsn;
    USN         NextUsn;
    USN         LowestValidUsn;
    USN         MaxUsn;
    ULONGLONG   MaximumSize;
    ULONGLONG   AllocationDelta;
} USN_JOURNAL_DATA;
typedef USN_JOURNAL_DATA    *PUSN_JOURNAL_DATA;
#endif

/* FSCTL_DELETE_USN_JOURNAL parameters */
#if (_WIN32_WINNT >= 0x0500)
typedef struct {
    ULONGLONG   UsnJournalID;
    ULONG       DeleteFlags;
} DELETE_USN_JOURNAL_DATA;
typedef DELETE_USN_JOURNAL_DATA *PDELETE_USN_JOURNAL_DATA;
#endif

/* FSCTL_MARK_HANDLE parameters */
#if (_WIN32_WINNT >= 0x0500)
typedef struct {
    ULONG   UsnSourceInfo;
    HANDLE  VolumeHandle;
    ULONG   HandleInfo;
} MARK_HANDLE_INFO;
typedef MARK_HANDLE_INFO    *PMARK_HANDLE_INFO;
#endif

/* Bulk security test data */
#if (_WIN32_WINNT >= 0x0500)
typedef struct {
    ACCESS_MASK DesiredAccess;
    ULONG       SecurityIds[1];
} BULK_SECURITY_TEST_DATA;
typedef BULK_SECURITY_TEST_DATA *PBULK_SECURITY_TEST_DATA;
#endif

/* FSCTL_FILE_PREFETCH parameters */
#if (_WIN32_WINNT >= 0x0500)
typedef struct _FILE_PREFETCH {
    ULONG       Type;
    ULONG       Count;
    ULONGLONG   Prefetch[1];
} FILE_PREFETCH;
typedef FILE_PREFETCH   *PFILE_PREFETCH;
#endif

/* FSCTL_FILE_PREFETCH parameters (extended version) */
#if (_WIN32_WINNT >= 0x0500)
typedef struct _FILE_PREFETCH_EX {
    ULONG       Type;
    ULONG       Count;
    PVOID       Context;
    ULONGLONG   Prefetch[1];
} FILE_PREFETCH_EX;
typedef FILE_PREFETCH_EX    *PFILE_PREFETCH_EX;
#endif

/* File system statistics */
typedef struct _FILESYSTEM_STATISTICS {
    USHORT  FileSystemType;
    USHORT  Version;
    ULONG   SizeOfCompleteStructure;
    ULONG   UserFileReads;
    ULONG   UserFileReadBytes;
    ULONG   UserDiskReads;
    ULONG   UserFileWrites;
    ULONG   UserFileWriteBytes;
    ULONG   UserDiskWrites;
    ULONG   MetaDataReads;
    ULONG   MetaDataReadBytes;
    ULONG   MetaDataDiskReads;
    ULONG   MetaDataWrites;
    ULONG   MetaDataWriteBytes;
    ULONG   MetaDataDiskWrites;
} FILESYSTEM_STATISTICS;
typedef FILESYSTEM_STATISTICS   *PFILESYSTEM_STATISTICS;

/* FAT statistics */
typedef struct _FAT_STATISTICS {
    ULONG   CreateHits;
    ULONG   SuccessfulCreates;
    ULONG   FailedCreates;
    ULONG   NonCachedReads;
    ULONG   NonCachedReadBytes;
    ULONG   NonCachedWrites;
    ULONG   NonCachedWriteBytes;
    ULONG   NonCachedDiskReads;
    ULONG   NonCachedDiskWrites;
} FAT_STATISTICS;
typedef FAT_STATISTICS  *PFAT_STATISTICS;

/* Extended FAT statistics */
typedef struct _EXFAT_STATISTICS {
    ULONG   CreateHits;
    ULONG   SuccessfulCreates;
    ULONG   FailedCreates;
    ULONG   NonCachedReads;
    ULONG   NonCachedReadBytes;
    ULONG   NonCachedWrites;
    ULONG   NonCachedWriteBytes;
    ULONG   NonCachedDiskReads;
    ULONG   NonCachedDiskWrites;
} EXFAT_STATISTICS;
typedef EXFAT_STATISTICS    *PEXFAT_STATISTICS;

/* NTFS statistics */
typedef struct _NTFS_STATISTICS {
    ULONG   LogFileFullExceptions;
    ULONG   OtherExceptions;
    ULONG   MftReads;
    ULONG   MftReadBytes;
    ULONG   MftWrites;
    ULONG   MftWriteBytes;
    struct {
        USHORT  Write;
        USHORT  Create;
        USHORT  SetInfo;
        USHORT  Flush;
    } MftWritesUserLevel;
    USHORT  MftWritesFlushForLogFileFull;
    USHORT  MftWritesLazyWriter;
    USHORT  MftWritesUserRequest;
    ULONG   Mft2Writes;
    ULONG   Mft2WriteBytes;
    struct {
        USHORT  Write;
        USHORT  Create;
        USHORT  SetInfo;
        USHORT  Flush;
    } Mft2WritesUserLevel;
    USHORT  Mft2WritesFlushForLogFileFull;
    USHORT  Mft2WritesLazyWriter;
    USHORT  Mft2WritesUserRequest;
    ULONG   RootIndexReads;
    ULONG   RootIndexReadBytes;
    ULONG   RootIndexWrites;
    ULONG   RootIndexWriteBytes;
    ULONG   BitmapReads;
    ULONG   BitmapReadBytes;
    ULONG   BitmapWrites;
    ULONG   BitmapWriteBytes;
    USHORT  BitmapWritesFlushForLogFileFull;
    USHORT  BitmapWritesLazyWriter;
    USHORT  BitmapWritesUserRequest;
    struct {
        USHORT  Write;
        USHORT  Create;
        USHORT  SetInfo;
    } BitmapWritesUserLevel;
    ULONG   MftBitmapReads;
    ULONG   MftBitmapReadBytes;
    ULONG   MftBitmapWrites;
    ULONG   MftBitmapWriteBytes;
    USHORT  MftBitmapWritesFlushForLogFileFull;
    USHORT  MftBitmapWritesLazyWriter;
    USHORT  MftBitmapWritesUserRequest;
    struct {
        USHORT  Write;
        USHORT  Create;
        USHORT  SetInfo;
        USHORT  Flush;
    } MftBitmapWritesUserLevel;
    ULONG   UserIndexReads;
    ULONG   UserIndexReadBytes;
    ULONG   UserIndexWrites;
    ULONG   UserIndexWriteBytes;
    ULONG   LogFileReads;
    ULONG   LogFileReadBytes;
    ULONG   LogFileWrites;
    ULONG   LogFileWriteBytes;
    struct {
        ULONG   Calls;
        ULONG   Clusters;
        ULONG   Hints;
        ULONG   RunsReturned;
        ULONG   HintsHonored;
        ULONG   HintsClustered;
        ULONG   Cache;
        ULONG   CacheClusters;
        ULONG   CacheMiss;
        ULONG   CacheMissClusters;
    } Allocate;
} NTFS_STATISTICS;
typedef NTFS_STATISTICS *PNTFS_STATISTICS;

/* File object identifier buffer */
#if (_WIN32_WINNT >= 0x0500)
typedef struct _FILE_OBJECTID_BUFFER {
    UCHAR   ObjectId[16];
    union {
        struct {
            UCHAR   BirthVolumeId[16];
            UCHAR   BirthObjectId[16];
            UCHAR   DomainId[16];
        };
        UCHAR   ExtendedInfo[48];
    };
} FILE_OBJECTID_BUFFER;
typedef FILE_OBJECTID_BUFFER    *PFILE_OBJECTID_BUFFER;
#endif

/* FSCTL_SET_SPARSE parameters */
#if (_WIN32_WINNT >= 0x0500)
typedef struct _FILE_SET_SPARSE_BUFFER {
    BOOLEAN SetSparse;
} FILE_SET_SPARSE_BUFFER;
typedef FILE_SET_SPARSE_BUFFER  *PFILE_SET_SPARSE_BUFFER;
#endif

/* FSCTL_SET_ZERO_DATA parameters */
#if (_WIN32_WINNT >= 0x0500)
typedef struct _FILE_ZERO_DATA_INFORMATION {
    LARGE_INTEGER   FileOffset;
    LARGE_INTEGER   BeyondFinalZero;
} FILE_ZERO_DATA_INFORMATION;
typedef FILE_ZERO_DATA_INFORMATION  *PFILE_ZERO_DATA_INFORMATION;
#endif

/* File allocated range buffer */
#if (_WIN32_WINNT >= 0x0500)
typedef struct _FILE_ALLOCATED_RANGE_BUFFER {
    LARGE_INTEGER   FileOffset;
    LARGE_INTEGER   Length;
} FILE_ALLOCATED_RANGE_BUFFER;
typedef FILE_ALLOCATED_RANGE_BUFFER *PFILE_ALLOCATE_RANGE_BUFFER;
#endif

/* Encryption buffer */
#if (_WIN32_WINNT >= 0x0500)
typedef struct _ENCRYPTION_BUFFER {
    ULONG   EncryptionOperation;
    UCHAR   Private[1];
} ENCRYPTION_BUFFER;
typedef ENCRYPTION_BUFFER   *PENCRYPTION_BUFFER;
#endif

/* Decryption status buffer */
#if (_WIN32_WINNT >= 0x0500)
typedef struct _DECRYPTION_STATUS_BUFFER {
    BOOLEAN NoEncryptedStreams;
} DECRYPTION_STATUS_BUFFER;
typedef DECRYPTION_STATUS_BUFFER    *PDECRYPTION_STATUS_BUFFER;
#endif

/* Raw encrypted data request information */
#if (_WIN32_WINNT >= 0x0500)
typedef struct _REQUEST_RAW_ENCRYPTED_DATA {
    LONGLONG    FileOffset;
    ULONG       Length;
} REQUEST_RAW_ENCRYPTED_DATA;
typedef REQUEST_RAW_ENCRYPTED_DATA  *PREQEUST_RAW_ENCRYPTED_DATA;
#endif

/* Encrypted data information */
#if (_WIN32_WINNT >= 0x0500)
typedef struct _ENCRYPTED_DATA_INFO {
    ULONGLONG   StartingFileOffset;
    ULONG       OutputBufferOffset;
    ULONG       BytesWithinFileSize;
    ULONG       BytesWithinValidDataLength;
    USHORT      CompressionFormat;
    UCHAR       DataUnitShift;
    UCHAR       ChunkShift;
    UCHAR       ClusterShift;
    UCHAR       EncryptionFormat;
    USHORT      NumberOfDataBlocks;
    ULONG       DataBlockSize[ANYSIZE_ARRAY];
} ENCRYPTED_DATA_INFO;
typedef ENCRYPTED_DATA_INFO *PENCRYPTED_DATA_INFO;
#endif

/* Plex data read request information */
#if (_WIN32_WINNT >= 0x0500)
typedef struct _PLEX_READ_DATA_REQUEST {
    LARGE_INTEGER   ByteOffset;
    ULONG           ByteLength;
    ULONG           PlexNumber;
} PLEX_READ_DATA_REQUEST;
typedef PLEX_READ_DATA_REQUEST  *PPLEX_READ_DATA_REQUEST;
#endif

/* FSCTL_SIS_COPYFILE parameters */
#if (_WIN32_WINNT >= 0x0500)
typedef struct _SI_COPYFILE {
    ULONG   SourceFileNameLength;
    ULONG   DestinationFileNameLength;
    ULONG   Flags;
    WCHAR   FileNameBuffer[1];
} SI_COPYFILE;
typedef SI_COPYFILE *PSI_COPYFILE;
#endif

/* FSCTL_MAKE_MEDIA_COMPATIBLE parameters */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _FILE_MAKE_COMPATIBLE_BUFFER {
    BOOLEAN CloseDisc;
} FILE_MAKE_COMPATIBLE_BUFFER;
typedef FILE_MAKE_COMPATIBLE_BUFFER *PFILE_MAKE_COMPATIBLE_BUFFER;
#endif

/* FSCTL_SET_DEFECT_MANAGEMENT parameters */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _FILE_SET_DEFECT_MGMT_BUFFER {
    BOOLEAN Disable;
} FILE_SET_DEFECT_MGMT_BUFFER;
typedef FILE_SET_DEFECT_MGMT_BUFFER *PFILE_SET_DEFECT_MGMT_BUFFER;
#endif

/* FSCTL_QUERY_SPARING_INFO returned data */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _FILE_QUERY_SPARING_BUFFER {
    ULONG   SparingUnitBytes;
    BOOLEAN SoftwareSparing;
    ULONG   TotalSpareBlocks;
    ULONG   FreeSpareBlocks;
} FILE_QUERY_SPARING_BUFFER;
typedef FILE_QUERY_SPARING_BUFFER   *PFILE_QUERY_SPARING_BUFFER;
#endif

/* FSCTL_QUERY_ON_DISK_VOLUME_INFO returned data */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _FILE_QUERY_ON_DISK_VOL_INFO_BUFFER {
    LARGE_INTEGER   DirectoryCount;
    LARGE_INTEGER   FileCount;
    USHORT          FsFormatMajVersion;
    USHORT          FsFormatMinVersion;
    WCHAR           FsFormatName[12];
    LARGE_INTEGER   FormatTime;
    LARGE_INTEGER   LastUpdateTime;
    WCHAR           CopyrightInfo[34];
    WCHAR           AbstractInfo[34];
    WCHAR           FormattingImplementationInfo[34];
    WCHAR           LastModifyingImplementationInfo[34];
} FILE_QUERY_ON_DISK_VOL_INFO_BUFFER;
typedef FILE_QUERY_ON_DISK_VOL_INFO_BUFFER  *PFILE_QUERY_ON_DISK_VOL_INFO_BUFFER;
#endif

/* FSCTL_SHRINK_VOLUME request types */
#if (_WIN32_WINNT >= 0x0600)
typedef enum _SHRINK_VOLUME_REQUEST_TYPES {
    ShrinkPrepare   = 1,
    ShrinkCommit    = 2,
    ShrinkAbort     = 3
} SHRINK_VOLUME_REQUEST_TYPES;
typedef SHRINK_VOLUME_REQUEST_TYPES *PSHRINK_VOLUME_REQUEST_TYPES;
#endif

/* FSCTL_SHRINK_VOLUME parameters */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _SHRINK_VOLUME_INFORMATION {
    SHRINK_VOLUME_REQUEST_TYPES ShrinkRequestType;
    ULONGLONG                   Flags;
    LONGLONG                    NewNumberOfSectors;
} SHRINK_VOLUME_INFORMATION;
typedef SHRINK_VOLUME_INFORMATION   *PSHRINK_VOLUME_INFORMATION;
#endif

/* FSCTL_TXFS_MODIFY_RM parameters */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _TXFS_MODIFY_RM {
    ULONG       Flags;
    ULONG       LogContainerCountMax;
    ULONG       LogContainerCountMin;
    ULONG       LogContainerCount;
    ULONG       LogGrowthIncrement;
    ULONG       LogAutoShrinkPercentage;
    ULONGLONG   Reserved;
    USHORT      LoggingMode;
} TXFS_MODIFY_RM;
typedef TXFS_MODIFY_RM  *PTXFS_MODIFY_RM;
#endif

/* FSCTL_TXFS_QUERY_RM_INFORMATION parameters */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _TXFS_QUERY_RM_INFORMATION {
    ULONG           BytesRequired;
    ULONGLONG       TailLsn;
    ULONGLONG       CurrentLsn;
    ULONGLONG       ArchiveTailLsn;
    ULONGLONG       LogContainerSize;
    LARGE_INTEGER   HighestVirtualClock;
    ULONG           LogContainerCount;
    ULONG           LogContainerCountMax;
    ULONG           LogContainerCountMin;
    ULONG           LogGrowthIncrement;
    ULONG           LogAutoShrinkPercentage;
    ULONG           Flags;
    USHORT          LoggingMode;
    USHORT          Reserved;
    USHORT          RmState;
    ULONGLONG       LogCapacity;
    ULONGLONG       LogFree;
    ULONGLONG       TopsSize;
    ULONGLONG       TopsUsed;
    ULONGLONG       TransactionCount;
    ULONGLONG       OnePCCount;
    ULONGLONG       TwoPCCount;
    ULONGLONG       NumberLogFileFull;
    ULONGLONG       OldestTransactionAge;
    GUID            RMName;
    ULONG           TmLogPathOffset;
} TXFS_QUERY_RM_INFORMATION;
typedef TXFS_QUERY_RM_INFORMATION   *PTXFS_QUERY_RM_INFORMATION;
#endif

/* FSCTL_TXFS_ROLLFORWARD_REDO parameters */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _TXFS_ROLLFORWARD_REDO_INFORMATION {
    LARGE_INTEGER   LastVirtualClock;
    ULONGLONG       LastRedoLsn;
    ULONGLONG       HighestRecoveryLsn;
    ULONG           Flags;
} TXFS_ROLLFORWARD_REDO_INFORMATION;
typedef TXFS_ROLLFORWARD_REDO_INFORMATION   *PTXFS_ROLLFORWARD_REDO_INFORMATION;
#endif

/* FSCTL_TXFS_STAR_RM parameters */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _TXFS_START_RM_INFORMATION {
    ULONG       Flags;
    ULONGLONG   LogContainerSize;
    ULONG       LogContainerCountMin;
    ULONG       LogContainerCountMax;
    ULONG       LogGrowthIncrement;
    ULONG       LogAutoShrinkPercentage;
    ULONG       TmLogPathOffset;
    USHORT      TmLogPathLength;
    USHORT      LoggingMode;
    USHORT      LogPathLength;
    USHORT      Reserved;
    WCHAR       LogPath[1];
} TXFS_START_RM_INFORMATION;
typedef TXFS_START_RM_INFORMATION   *PTXFS_START_RM_INFORMATION;
#endif

/* FSCTL_TXFS_GET_METADATA_INFO returned data */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _TXFS_GET_METADATA_INFO_OUT {
    struct {
        LONGLONG    LowPart;
        LONGLONG    HighPart;
    } TxfFileId;
    GUID        LockingTransaction;
    ULONGLONG   LastLsn;
    ULONG       TransactionState;
} TXFS_GET_METADATA_INFO_OUT;
typedef TXFS_GET_METADATA_INFO_OUT  *PTXFS_GET_METADATA_INFO_OUT;
#endif

/* FSCTL_TXFS_LIST_TRANSACTION_LOCKED_FILES entry */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _TXFS_LIST_TRANSACTION_LOCKED_FILES_ENTRY {
    ULONGLONG   Offset;
    ULONG       NameFlags;
    LONGLONG    FileId;
    ULONG       Reserved1;
    ULONG       Reserved2;
    LONGLONG    Reserved3;
    WCHAR       FileName[1];
} TXFS_LIST_TRANSACTION_LOCKED_FILES_ENTRY;
typedef TXFS_LIST_TRANSACTION_LOCKED_FILES_ENTRY    *PTXFS_TRANSACTION_LOCKED_FILES_ENTRY;
#endif

/* FSCTL_TXFS_LIST_TRANSACTION_LOCKED_FILES parameters */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _TXFS_LIST_TRANSACTION_LOCKED_FILES {
    GUID        KtmTransaction;
    ULONGLONG   NumberOfFiles;
    ULONGLONG   BufferSizeRequired;
    ULONGLONG   Offset;
} TXFS_LIST_TRANSACTION_LOCKED_FILES;
typedef TXFS_LIST_TRANSACTION_LOCKED_FILES  *PTXFS_LIST_TRANSACTION_LOCKED_FILES;
#endif

/* FSCTL_TXFS_LIST_TRANSACTIONS entry */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _TXFS_LIST_TRANSACTIONS_ENTRY {
    GUID        TransactionId;
    ULONG       TransactionState;
    ULONG       Reserved1;
    ULONG       Reserved2;
    LONGLONG    Reserved3;
} TXFS_LIST_TRANSACTIONS_ENTRY;
typedef TXFS_LIST_TRANSACTIONS_ENTRY    *PTXFS_LIST_TRANSACTIONS_ENTRY;
#endif

/* FSCTL_TXFS_LIST_TRANSACTIONS parameters */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _TXFS_LIST_TRANSACTIONS {
    ULONGLONG   NumberOfTransactions;
    ULONGLONG   BufferSizeRequired;
} TXFS_LIST_TRANSACTIONS;
typedef TXFS_LIST_TRANSACTIONS  *PTXFS_LIST_TRANSACTIONS;
#endif

/* FSCTL_TXFS_READ_BACKUP_INFORMATION returned data */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _TXFS_READ_BACKUP_INFORMATION_OUT {
    union {
        ULONG   BufferLength;
        UCHAR   Buffer[1];
    };
} TXFS_READ_BACKUP_INFORMATION_OUT;
typedef TXFS_READ_BACKUP_INFORMATION_OUT    *PTXFS_READ_BACKUP_INFORMATION_OUT;
#endif

/* FSCTL_TXFS_WRITE_BACKUP_INFORMATION parameters */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _TXFS_WRITE_BACKUP_INFORMATION {
    UCHAR   Buffer[1];
} TXFS_WRITE_BACKUP_INFORMATION;
typedef TXFS_WRITE_BACKUP_INFORMATION   *PTXFS_WRITE_BACKUP_INFORMATION;
#endif

/* FSCTL_TXFS_GET_TRANSACTED_VERSION parameters */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _TXFS_GET_TRANSACTED_VERSION {
    ULONG   ThisBaseVersion;
    ULONG   LatestVersion;
    USHORT  ThisMiniVersion;
    USHORT  FirstMiniVersion;
    USHORT  LatestMiniVersion;
} TXFS_GET_TRANSACTED_VERSION;
typedef TXFS_GET_TRANSACTED_VERSION *PTXFS_GET_TRANSACTED_VERSION;
#endif

/* FSCTL_TXFS_SAVEPOINT_INFORMATION parameters */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _TXFS_SAVEPOINT_INFORMATION {
    HANDLE  KtmTransaction;
    ULONG   ActionCode;
    ULONG   SavepointId;
} TXFS_SAVEPOINT_INFORMATION;
typedef TXFS_SAVEPOINT_INFORMATION  *PTXFS_SAVEPOINT_INFORMATION;
#endif

/* FSCTL_TXFS_CREATE_MINIVERSION returned data */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _TXFS_CREATE_MINIVERSION_INFO {
    USHORT  StructureVersion;
    USHORT  StructureLength;
    ULONG   BaseVersion;
    USHORT  MiniVersion;
} TXFS_CREATE_MINIVERSION_INFO;
typedef TXFS_CREATE_MINIVERSION_INFO    *PTXFS_CREATE_MINIVERSION_INFO;
#endif

/* FSCTL_TXFS_TRANSACTION_ACTIVE returned data */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _TXFS_TRANSACTION_ACTIVE_INFO {
    BOOLEAN TransactionsActiveAtSnapshot;
} TXFS_TRANSACTION_ACTIVE_INFO;
typedef TXFS_TRANSACTION_ACTIVE_INFO    *PTXFS_TRANSACTION_ACTIVE_INFO;
#endif

/* FSCTL_GET_BOOT_AREA_INFO returned data */
#if (_WIN32_WINNT >= 0x0601)
typedef struct _BOOT_AREA_INFO {
    ULONG   BootSectorCount;
    struct {
        LARGE_INTEGER   Offset;
    } BootSectors[2];
} BOOT_AREA_INFO;
typedef BOOT_AREA_INFO  *PBOOT_AREA_INFO;
#endif

/* FSCTL_GET_RETRIEVAL_POINTER_BASE returned data */
#if (_WIN32_WINNT >= 0x0601)
typedef struct _RETRIEVAL_POINTER_BASE {
    LARGE_INTEGER   FileAreaOffset;
} RETRIEVAL_POINTER_BASE;
typedef RETRIEVAL_POINTER_BASE  *PRETRIEVAL_POINTER_BASE;
#endif

/* File system persistent volume information */
#if (_WIN32_WINNT >= 0x0601)
typedef struct _FILE_FS_PERSISTENT_VOLUME_INFORMATION {
    ULONG   VolumeFlags;
    ULONG   FlagMask;
    ULONG   Version;
    ULONG   Reserved;
} FILE_FS_PERSISTENT_VOLUME_INFORMATION;
typedef FILE_FS_PERSISTENT_VOLUME_INFORMATION   *PFILE_FS_PERSISTENT_VOLUME_INFORMATION;
#endif

/* File system recognition information */
#if (_WIN32_WINNT >= 0x0601)
typedef struct _FILE_SYSTEM_RECOGNITION_INFORMATION {
    CHAR    FileSystem[9];
} FILE_SYSTEM_RECOGNITION_INFORMATION;
typedef FILE_SYSTEM_RECOGNITION_INFORMATION *PFILE_SYSTEM_RECOGNITION_INFORMATION;
#endif

/* FSCTL_REQUEST_OPLOCK parameters */
#if (_WIN32_WINNT >= 0x0601)
typedef struct _REQUEST_OPLOCK_INPUT_BUFFER {
    USHORT  StructureVersion;
    USHORT  StructureLength;
    ULONG   RequestedOplockLevel;
    ULONG   Flags;
} REQUEST_OPLOCK_INPUT_BUFFER;
typedef REQUEST_OPLOCK_INPUT_BUFFER *PREQUEST_OPLOCK_INPUT_BUFFER;
#endif

/* FSCTL_REQUEST_OPLOCK returned data */
#if (_WIN32_WINNT >= 0x0601)
typedef struct _REQUEST_OPLOCK_OUTPUT_BUFFER {
    USHORT      StructureVersion;
    USHORT      StructureLength;
    ULONG       OriginalOplockLevel;
    ULONG       NewOplockLevel;
    ULONG       Flags;
    ACCESS_MASK AccessMode;
    USHORT      ShareMode;
} REQUEST_OPLOCK_OUTPUT_BUFFER;
typedef REQUEST_OPLOCK_OUTPUT_BUFFER    *PREQUEST_OPLOCK_OUTPUT_BUFFER;
#endif

/* SD_GLOBAL_CHANGE_TYPE_MACHINE_SID parameters */
#if (_WIN32_WINNT >= 0x0601)
typedef struct _SD_CHANGE_MACHINE_SID_INPUT {
    USHORT  CurrentMachineSIDOffset;
    USHORT  CurrentMachineSIDLength;
    USHORT  NewMachineSIDOffset;
    USHORT  NewMachineSIDLength;
} SD_CHANGE_MACHINE_SID_INPUT;
typedef SD_CHANGE_MACHINE_SID_INPUT *PSD_CHANGE_MACHINE_SID_INPUT;
#endif

/* SD_GLOBAL_CHANGE_TYPE_MACHINE_SID returned data */
#if (_WIN32_WINNT >= 0x0601)
typedef struct _SD_CHANGE_MACHINE_SID_OUTPUT {
    ULONGLONG   NumSDChangedSuccess;
    ULONGLONG   NumSDChangedFail;
    ULONGLONG   NumSDUnused;
    ULONGLONG   NumSDTotal;
    ULONGLONG   NumMftSDChangedSuccess;
    ULONGLONG   NumMftSDChangedFail;
    ULONGLONG   NumMftSDTotal;
} SD_CHANGE_MACHINE_SID_OUTPUT;
typedef SD_CHANGE_MACHINE_SID_OUTPUT    *PSD_CHANGE_MACHINE_SID_OUTPUT;
#endif

/* FSCTL_SD_GLOBAL_CHANGE parameters */
#if (_WIN32_WINNT >= 0x0601)
typedef struct _SD_GLOBAL_CHANGE_INPUT {
    ULONG   Flags;
    ULONG   ChangeType;
    union {
        SD_CHANGE_MACHINE_SID_INPUT SdChange;
    };
} SD_GLOBAL_CHANGE_INPUT;
typedef SD_GLOBAL_CHANGE_INPUT  *PSD_GLOBAL_CHANGE_INPUT;
#endif

/* FSCTL_SD_GLOBAL_CHANGE returned data */
#if (_WIN32_WINNT >= 0x0601)
typedef struct _SD_GLOBAL_CHANGE_OUTPUT {
    ULONG   Flags;
    ULONG   ChangeType;
    union {
        SD_CHANGE_MACHINE_SID_OUTPUT    SdChange;
    };
} SD_GLOBAL_CHANGE_OUTPUT;
typedef SD_GLOBAL_CHANGE_OUTPUT *PSD_GLOBAL_CHANGE_OUTPUT;
#endif

/* Extended encrypted data information */
#if (_WIN32_WINNT >= 0x0601)
typedef struct _EXTENDED_ENCRYPTED_DATA_INFO {
    ULONG   ExtendedCode;
    ULONG   Length;
    ULONG   Flags;
    ULONG   Reserved;
} EXTENDED_ENCRYPTED_DATA_INFO;
typedef EXTENDED_ENCRYPTED_DATA_INFO    *PEXTENDED_ENCRYPTED_DATA_INFO;
#endif

/* FSCTL_LOOKUP_STREAM_FROM_CLUSTER parameters */
#if (_WIN32_WINNT >= 0x0601)
typedef struct _LOOKUP_STREAM_FROM_CLUSTER_INPUT {
    ULONG           Flags;
    ULONG           NumberOfClusters;
    LARGE_INTEGER   Cluster[1];
} LOOKUP_STREAM_FROM_CLUSTER_INPUT;
typedef LOOKUP_STREAM_FROM_CLUSTER_INPUT    *PLOOKUP_STREAM_FROM_CLUSTER_INPUT;
#endif

/* FSCTL_LOOKUP_STREAM_FROM_CLUSTER returned data */
#if (_WIN32_WINNT >= 0x0601)
typedef struct _LOOKUP_STREAM_FROM_CLUSTER_OUTPUT {
    ULONG   Offset;
    ULONG   NumberOfMatches;
    ULONG   BufferSizeRequired;
} LOOKUP_STREAM_FROM_CLUSTER_OUTPUT;
typedef LOOKUP_STREAM_FROM_CLUSTER_OUTPUT   *PLOOKUP_STREAM_FROM_CLUSTER_OUTPUT;
#endif

/* FSCTL_LOOKUP_STREAM_FROM_CLUSTER entry */
#if (_WIN32_WINNT >= 0x0601)
typedef struct _LOOKUP_STREAM_FROM_CLUSTER_ENTRY {
    ULONG           OffsetToNext;
    ULONG           Flags;
    LARGE_INTEGER   Reserved;
    LARGE_INTEGER   Cluster;
    WCHAR           FileName[1];
} LOOKUP_STREAM_FROM_CLUSTER_ENTRY;
typedef LOOKUP_STREAM_FROM_CLUSTER_ENTRY    *PLOOKUP_STREAM_FROM_CLUSTER_ENTRY;
#endif

/* FSCTL_FILE_TYPE_NOTIFICATION parameters */
#if (_WIN32_WINNT >= 0x0601)
typedef struct _FILE_TYPE_NOTIFICATION_INPUT {
    ULONG   Flags;
    ULONG   NumFileTypeIDs;
    GUID    FileTypeID[1];
} FILE_TYPE_NOTIFICATION_INPUT;
typedef FILE_TYPE_NOTIFICATION_INPUT    *PFILE_TYPE_NOTIFICATION_INPUT;
#endif

/* Reparse data buffer */
typedef struct _REPARSE_DATA_BUFFER {
    ULONG   ReparseTag;
    USHORT  ReparseDataLength;
    USHORT  Reserved;
    union {
        struct {
            USHORT  SubstituteNameOffset;
            USHORT  SubstituteNameLength;
            USHORT  PrintNameOffset;
            USHORT  PrintNameLength;
            ULONG   Flags;
            WCHAR   PathBuffer[1];
        } SymbolicLinkReparseBuffer;
        struct {
            USHORT  SubstituteNameOffset;
            USHORT  SubstituteNameLength;
            USHORT  PrintNameOffset;
            USHORT  PrintNameLength;
            WCHAR   PathBuffer[1];
        } MountPointReparseBuffer;
        struct {
            UCHAR   DataBuffer[1];
        } GenericReparseBuffer;
    };
} REPARSE_DATA_BUFFER;
typedef REPARSE_DATA_BUFFER *PREPARSE_DATA_BUFFER;

/* Reparse GUID data buffer */
typedef struct _REPARSE_GUID_DATA_BUFFER {
    ULONG   ReparseTag;
    USHORT  ReparseDataLength;
    USHORT  Reserved;
    GUID    ReparseGuid;
    struct {
        UCHAR   DataBuffer[1];
    } GenericReparseBuffer;
} REPARSE_GUID_DATA_BUFFER;
typedef REPARSE_GUID_DATA_BUFFER    *PREPARSE_GUID_DATA_BUFFER;

/* Reparse index key */
#pragma pack( __push, 4 )
typedef struct _REPARSE_INDEX_KEY {
    ULONG           FileReparseTag;
    LARGE_INTEGER   FileId;
} REPARSE_INDEX_KEY;
typedef REPARSE_INDEX_KEY   *PREPARSE_INDEX_KEY;
#pragma pack( __pop )

/* FSCTL_PIPE_ASSIGN_EVENT parameters */
typedef struct _FILE_PIPE_ASSIGN_EVENT_BUFFER {
    HANDLE  EventHandle;
    ULONG   KeyValue;
} FILE_PIPE_ASSIGN_EVENT_BUFFER;
typedef FILE_PIPE_ASSIGN_EVENT_BUFFER   *PFILE_PIPE_ASSIGN_EVENT_BUFFER;

/* FSCTL_PIPE_PEEK parameters */
typedef struct _FILE_PIPE_PEEK_BUFFER {
    ULONG   NamedPipeState;
    ULONG   ReadDataAvailable;
    ULONG   NumberOfMessages;
    ULONG   MessageLength;
    CHAR    Data[1];
} FILE_PIPE_PEEK_BUFFER;
typedef FILE_PIPE_PEEK_BUFFER   *PFILE_PIPE_PEEK_BUFFER;

/* FSCTL_PIPE_QUERY_EVENT parameters */
typedef struct _FILE_PIPE_EVENT_BUFFER {
    ULONG   NamedPipeState;
    ULONG   EntryType;
    ULONG   ByteCount;
    ULONG   KeyValue;
    ULONG   NumberRequests;
} FILE_PIPE_EVENT_BUFFER;
typedef FILE_PIPE_EVENT_BUFFER  *PFILE_PIPE_EVENT_BUFFER;

/* FSCTL_PIPE_WAIT parameters */
typedef struct _FILE_PIPE_WAIT_FOR_BUFFER {
    LARGE_INTEGER   Timeout;
    ULONG           NameLength;
    BOOLEAN         TimeoutSpecified;
    WCHAR           Name[1];
} FILE_PIPE_WAIT_FOR_BUFFER;
typedef FILE_PIPE_WAIT_FOR_BUFFER   *PFILE_PIPE_WAIT_FOR_BUFFER;

/* FSCTL_PIPE_SET_CLIENT_PROCESS parameters */
typedef struct _FILE_PIPE_CLIENT_PROCESS_BUFFER {
    PVOID   ClientSession;
    PVOID   ClientProcess;
} FILE_PIPE_CLIENT_PROCESS_BUFFER;
typedef FILE_PIPE_CLIENT_PROCESS_BUFFER *PFILE_PIPE_CLIENT_PROCESS_BUFFER;

/* FSCTL_PIPE_SET_CLIENT_PROCESS parameters (extended version) */
typedef struct _FILE_PIPE_CLIENT_PROCESS_BUFFER_EX {
    PVOID   ClientSession;
    PVOID   ClientProcess;
    USHORT  ClientComputerNameLength;
    WCHAR   ClientComputerBuffer[FILE_PIPE_COMPUTER_NAME_LENGTH + 1];
} FILE_PIPE_CLIENT_PROCESS_BUFFER_EX;
typedef FILE_PIPE_CLIENT_PROCESS_BUFFER_EX  *PFILE_PIPE_CLIENT_PROCESS_BUFFER_EX;

/* Link tracking information types */
typedef enum _LINK_TRACKING_INFORMATION_TYPE {
    NtfsLinkTrackingInformation = 0,
    DfsLinkTrackingInformation  = 1
} LINK_TRACKING_INFORMATION_TYPE;
typedef LINK_TRACKING_INFORMATION_TYPE  *PLINK_TRACKING_INFORMATION_TYPE;

/* Link tracking information */
typedef struct _LINK_TRACKING_INFORMATION {
    LINK_TRACKING_INFORMATION_TYPE  Type;
    UCHAR                           VolumeId[16];
} LINK_TRACKING_INFORMATION;
typedef LINK_TRACKING_INFORMATION   *PLINK_TRACKING_INFORMATION;

/* Remote link tracking information */
typedef struct _REMOTE_LINK_TRACKING_INFORMATION_ {
    PVOID   TargetFileObject;
    ULONG   TargetLinkTrackingInformationLength;
    UCHAR   TargetLinkTrackingInformationBuffer[1];
} REMOTE_LINK_TRACKING_INFORMATION;
typedef REMOTE_LINK_TRACKING_INFORMATION    *PREMOTE_LINK_TRACKING_INFORMATION;

/* Virtual storage type */
#if (_WIN32_WINNT >= 0x0601)
typedef struct _VIRTUAL_STORAGE_TYPE {
    ULONG   DeviceId;
    GUID    VendorId;
} VIRTUAL_STORAGE_TYPE;
typedef VIRTUAL_STORAGE_TYPE    *PVIRTUAL_STORAGE_TYPE;
#endif

/* FSCTL_QUERY_DEPENDENT_VOLUME parameters */
#if (_WIN32_WINNT >= 0x0601)
typedef struct _STORAGE_QUERY_DEPENDENT_VOLUME_REQUEST {
    ULONG   RequestLevel;
    ULONG   RequestFlags;
} STORAGE_QUERY_DEPENDENT_VOLUME_REQUEST;
typedef STORAGE_QUERY_DEPENDENT_VOLUME_REQUEST  *PSTORAGE_QUERY_DEPENDENT_VOLUME_REQUEST;
#endif

/* FSCTL_QUERY_DEPENDENT_VOLUME level 1 entry */
#if (_WIN32_WINNT >= 0x0601)
typedef struct _STORAGE_QUERY_DEPENDENT_VOLUME_LEV1_ENTRY {
    ULONG                   EntryLength;
    ULONG                   DependencyTypeFlags;
    ULONG                   ProviderSpecificFlags;
    VIRTUAL_STORAGE_TYPE    VirtualStorageType;
} STORAGE_QUERY_DEPENDENT_VOLUME_LEV1_ENTRY;
typedef STORAGE_QUERY_DEPENDENT_VOLUME_LEV1_ENTRY   *PSTORAGE_QUERY_DEPENDENT_VOLUME_LEV1_ENTRY;
#endif

/* FSCTL_QUERY_DEPENDENT_VOLUME level 2 entry */
#if (_WIN32_WINNT >= 0x0601)
typedef struct _STORAGE_QUERY_DEPENDENT_VOLUME_LEV2_ENTRY {
    ULONG                   EntryLength;
    ULONG                   DependencyTypeFlags;
    ULONG                   ProviderSpecificFlags;
    VIRTUAL_STORAGE_TYPE    VirtualStorageType;
    ULONG                   AncestorLevel;
    ULONG                   HostVolumeNameOffset;
    ULONG                   HostVolumeNameSize;
    ULONG                   DependentVolumeNameOffset;
    ULONG                   DependentVolumeNameSize;
    ULONG                   RelativePathOffset;
    ULONG                   RelativePathSize;
    ULONG                   DependentDeviceNameOffset;
    ULONG                   DependentDeviceNameSize;
} STORAGE_QUERY_DEPENDENT_VOLUME_LEV2_ENTRY;
typedef STORAGE_QUERY_DEPENDENT_VOLUME_LEV2_ENTRY   *PSTORAGE_QUERY_DEPENDENT_VOLUME_LEV2_ENTRY;
#endif

/* FSCTL_QUERY_DEPENDENT_VOLUME returned data */
#if (_WIN32_WINNT >= 0x0601)
typedef struct _STORAGE_QUERY_DEPENDENT_VOLUME_RESPONSE {
    ULONG   ResponseLevel;
    ULONG   NumberEntries;
    union {
        STORAGE_QUERY_DEPENDENT_VOLUME_LEV1_ENTRY   Lev1Depends[1];
        STORAGE_QUERY_DEPENDENT_VOLUME_LEV2_ENTRY   Lev2Depends[1];
    };
} STORAGE_QUERY_DEPENDENT_VOLUME_RESPONSE;
typedef STORAGE_QUERY_DEPENDENT_VOLUME_RESPONSE *PSTORAGE_QUERY_DEPENDENT_VOLUME_RESPONSE;
#endif

/* Object information classes */
typedef enum _OBJECT_INFORMATION_CLASS {
    ObjectBasicInformation  = 0,
    ObjectTypeInformation   = 2
} OBJECT_INFORMATION_CLASS;

/* Public object basic information */
typedef struct _PUBLIC_OBJECT_BASIC_INFORMATION {
    ULONG       Attributes;
    ACCESS_MASK GrantedAccess;
    ULONG       HandleCount;
    ULONG       PointerCount;
    ULONG       Reserved[10];
} PUBLIC_OBJECT_BASIC_INFORMATION;
typedef PUBLIC_OBJECT_BASIC_INFORMATION *PPUBLIC_OBJECT_BASIC_INFORMATION;

/* Public object type information */
typedef struct _PUBLIC_OBJECT_TYPE_INFORMATION {
    UNICODE_STRING  TypeName;
    ULONG           Reserved[22];
} PUBLIC_OBJECT_TYPE_INFORMATION;
typedef PUBLIC_OBJECT_TYPE_INFORMATION  *PPUBLIC_OBJECT_TYPE_INFORMATION;

/* Security client context */
typedef struct _SECURITY_CLIENT_CONTEXT {
    SECURITY_QUALITY_OF_SERVICE SecurityQos;
    PACCESS_TOKEN               ClientToken;
    BOOLEAN                     DirectlyAccessClientToken;
    BOOLEAN                     DirectAccessEffectiveOnly;
    BOOLEAN                     ServerIsRemote;
    TOKEN_CONTROL               ClientTokenControl;
} SECURITY_CLIENT_CONTEXT;
typedef SECURITY_CLIENT_CONTEXT *PSECURITY_CLIENT_CONTEXT;

/* Kernel asynchronous procedure call state */
typedef struct _KAPC_STATE {
    LIST_ENTRY          ApcListHead[MaximumMode];
    struct _KPROCESS    *Process;
    BOOLEAN             KernelApcInProgress;
    BOOLEAN             KernelApcPending;
    BOOLEAN             UserApcPending;
} KAPC_STATE;
typedef KAPC_STATE  *PKAPC_STATE;
typedef KAPC_STATE  *PRKAPC_STATE;

/* Kernel queue */
typedef struct _KQUEUE {
    DISPATCHER_HEADER   Header;
    LIST_ENTRY          EntryListHead;
    volatile ULONG      CurrentCount;
    ULONG               MaximumCount;
    LIST_ENTRY          ThreadListHead;
} KQUEUE;
typedef KQUEUE  *PKQUEUE;
typedef KQUEUE  *PRKQUEUE;

/* Security exports */
typedef struct _SE_EXPORTS {
    LUID    SeCreateTokenPrivilege;
    LUID    SeAssignPrimaryTokenPrivilege;
    LUID    SeLockMemoryPrivilege;
    LUID    SeIncreaseQuotaPrivilege;
    LUID    SeUnsolicitedInputPrivilege;
    LUID    SeTcbPrivilege;
    LUID    SeSecurityPrivilege;
    LUID    SeTakeOwnershipPrivilege;
    LUID    SeLoadDriverPrivilege;
    LUID    SeCreatePagefilePrivilege;
    LUID    SeIncreaseBasePriorityPrivilege;
    LUID    SeSystemProfilePrivilege;
    LUID    SeSystemtimePrivilege;
    LUID    SeProfileSingleProcessPrivilege;
    LUID    SeCreatePermanentPrivilege;
    LUID    SeBackupPrivilege;
    LUID    SeRestorePrivilege;
    LUID    SeShutdownPrivilege;
    LUID    SeDebugPrivilege;
    LUID    SeAuditPrivilege;
    LUID    SeSystemEnvironmentPrivilege;
    LUID    SeChangeNotifyPrivilege;
    LUID    SeRemoteShutdownPrivilege;
    PSID    SeNullSid;
    PSID    SeWorldSid;
    PSID    SeLocalSid;
    PSID    SeCreatorOwnerSid;
    PSID    SeCreatorGroupSid;
    PSID    SeNtAuthoritySid;
    PSID    SeDialupSid;
    PSID    SeNetworkSid;
    PSID    SeBatchSid;
    PSID    SeInteractiveSid;
    PSID    SeLocalSystemSid;
    PSID    SeAliasAdminsSid;
    PSID    SeAliasUsersSid;
    PSID    SeAliasGuestsSid;
    PSID    SeAliasPowerUsersSid;
    PSID    SeAliasAccountOpsSid;
    PSID    SeAliasSystemOpsSid;
    PSID    SeAliasPrintOpsSid;
    PSID    SeAliasBackupOpsSid;
    PSID    SeAuthenticatedUsersSid;
    PSID    SeRestrictedSid;
    PSID    SeAnonymousLogonSid;
    LUID    SeUndockPrivilege;
    LUID    SeSyncAgentPrivilege;
    LUID    SeEnableDelegationPrivilege;
    PSID    SeLocalServiceSid;
    PSID    SeNetworkServiceSid;
    LUID    SeManageVolumePrivilege;
    LUID    SeImpersonatePrivilege;
    LUID    SeCreateGlobalPrivilege;
    LUID    SeTrustedCredManAccessPrivilege;
    LUID    SeRelabelPrivilege;
    LUID    SeIncreaseWorkingSetPrivilege;
    LUID    SeTimeZonePrivilege;
    LUID    SeCreateSymbolicLinkPrivilege;
    PSID    SeIUserSid;
    PSID    SeUntrustedMandatorySid;
    PSID    SeLowMandatorySid;
    PSID    SeMediumMandatorySid;
    PSID    SeHighMandatorySid;
    PSID    SeSystemMandatorySid;
    PSID    SeOwnerRightsSid;
} SE_EXPORTS;
typedef SE_EXPORTS  *PSE_EXPORTS;

/* Security logon session terminated routine */
typedef NTSTATUS    (NTAPI *PSE_LOGON_SESSION_TERMINATED_ROUTINE)( PLUID );

/* Driver file system notification callback */
typedef VOID        NTAPI DRIVER_FS_NOTIFICATION( struct _DEVICE_OBJECT *, BOOLEAN );
typedef DRIVER_FS_NOTIFICATION  *PDRIVER_FS_NOTIFICATION;

/* File system filter section synchronization types */
typedef enum _FS_FILTER_SECTION_SYNC_TYPE {
    SyncTypeOther           = 0,
    SyncTypeCreateSection   = 1
} FS_FILTER_SECTION_SYNC_TYPE;
typedef FS_FILTER_SECTION_SYNC_TYPE *PFS_FILTER_SECTION_SYNC_TYPE;

/* File system filter stream file object notification types */
typedef enum _FS_FILTER_STREAM_FO_NOTIFICATION_TYPE {
    NotifyTypeCreate    = 0,
    NotifyTypeRetired   = 1
} FS_FILTER_STREAM_FO_NOTIFICATION_TYPE;
typedef FS_FILTER_STREAM_FO_NOTIFICATION_TYPE   *PFS_FILTER_STREAM_FO_NOTIFICATION_TYPE;

/* File system filter parameters */
typedef union _FS_FILTER_PARAMETERS {
    struct {
        PLARGE_INTEGER  EndingOffset;
        PERESOURCE      *ResourceToRelease;
    } AcquireForModifiedPageWriter;
    struct {
        PERESOURCE  ResourceToRelease;
    } ReleaseForModifiedPageWriter;
    struct {
        FS_FILTER_SECTION_SYNC_TYPE SyncType;
        ULONG                       PageProtection;
    } AcquireForSectionSynchronization;
    struct {
        FS_FILTER_STREAM_FO_NOTIFICATION_TYPE   NotificationType;
        BOOLEAN                                 SafeToRecurse;
    } NotifyStreamFileObject;
    struct {
        PVOID   Argument1;
        PVOID   Argument2;
        PVOID   Argument3;
        PVOID   Argument4;
        PVOID   Argument5;
    } Others;
} FS_FILTER_PARAMETERS;
typedef FS_FILTER_PARAMETERS    *PFS_FILTER_PARAMETERS;

/* File system filter callback data */
typedef struct _FS_FILTER_CALLBACK_DATA {
    ULONG                   SizeOfFsFilterCallbackData;
    UCHAR                   Operation;
    UCHAR                   Reserved;
    struct _DEVICE_OBJECT   *DeviceObject;
    struct _FILE_OBJECT     *FileObject;
    FS_FILTER_PARAMETERS    Parameters;
} FS_FILTER_CALLBACK_DATA;
typedef FS_FILTER_CALLBACK_DATA *PFS_FILTER_CALLBACK_DATA;

/* File system filter callbacks */
typedef NTSTATUS    (NTAPI *PFS_FILTER_CALLBACK)( PFS_FILTER_CALLBACK_DATA, PVOID * );
typedef NTSTATUS    (NTAPI *PFS_FILTER_COMPLETION_CALLBACK)( PFS_FILTER_CALLBACK_DATA, NTSTATUS, PVOID );
typedef struct _FS_FILTER_CALLBACKS {
    ULONG                           SizeOfFsFilterCallbacks;
    ULONG                           Reserved;
    PFS_FILTER_CALLBACK             PreAcquireForSectionSynchronization;
    PFS_FILTER_COMPLETION_CALLBACK  PostAcquireForSectionSynchronization;
    PFS_FILTER_CALLBACK             PreReleaseForSectionSynchronization;
    PFS_FILTER_COMPLETION_CALLBACK  PostReleaseForSectionSynchronization;
    PFS_FILTER_CALLBACK             PreAcquireForCcFlush;
    PFS_FILTER_COMPLETION_CALLBACK  PostAcquireForCcFlush;
    PFS_FILTER_CALLBACK             PreReleaseForCcFlush;
    PFS_FILTER_COMPLETION_CALLBACK  PostReleaseForCcFlush;
    PFS_FILTER_CALLBACK             PreAcquireForModifiedPageWriter;
    PFS_FILTER_COMPLETION_CALLBACK  PostAcquireForModifiedPageWriter;
    PFS_FILTER_CALLBACK             PreReleaseForModifiedPageWriter;
    PFS_FILTER_COMPLETION_CALLBACK  PostReleaseForModifiedPageWriter;
} FS_FILTER_CALLBACKS;
typedef FS_FILTER_CALLBACKS *PFS_FILTER_CALLBACKS;

/* I/O priority information */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _IO_PRIORITY_INFO {
    ULONG               Size;
    ULONG               ThreadPriority;
    ULONG               PagePriority;
    IO_PRIORITY_HINT    IoPriority;
} IO_PRIORITY_INFO;
typedef IO_PRIORITY_INFO    *PIO_PRIORITY_INFO;
#endif

/* Memory management flush types */
typedef enum _MMFLUSH_TYPE {
    MmFlushForDelete    = 0,
    MmFlushForWrite     = 1
} MMFLUSH_TYPE;

/* Read list */
typedef struct _READ_LIST {
    PFILE_OBJECT            FileObject;
    ULONG                   NumberOfEntries;
    LOGICAL                 IsImage;
    FILE_SEGMENT_ELEMENT    List[ANYSIZE_ARRAY];
} READ_LIST;
typedef READ_LIST   *PREAD_LIST;

/* Memory management prefetch flags */
#if (NTDDI_VERSION >= 0x05010000)
typedef union _MM_PREFETCH_FLAGS {
    struct {
        ULONG   Priority            : SYSTEM_PAGE_PRIORITY_BITS;
        ULONG   RepurposePriority   : SYSTEM_PAGE_PRIORITY_BITS;
    } Flags;
    ULONG   AllFlags;
} MM_PREFETCH_FLAGS;
typedef MM_PREFETCH_FLAGS   *PMM_PREFETCH_FLAGS;
#endif

/* Fast I/O possible values */
typedef enum _FAST_IO_POSSIBLE {
    FastIoIsNotPossible     = 0,
    FastIoIsPossible        = 1,
    FastIoIsQuestionable    = 2
} FAST_IO_POSSIBLE;

/* Common FCB header */
typedef struct _FSRTL_COMMON_FCB_HEADER {
    CSHORT          NodeTypeCode;
    CSHORT          NodeByteSize;
    UCHAR           Flags;
    UCHAR           IsFastIoPossible;
    UCHAR           Flags2;
    UCHAR           Reserved    : 4;
    UCHAR           Version     : 4;
    PERESOURCE      Resource;
    PERESOURCE      PagingIoResource;
    LARGE_INTEGER   AllocationSize;
    LARGE_INTEGER   FileSize;
    LARGE_INTEGER   ValidDataLength;
} FSRTL_COMMON_FCB_HEADER;
typedef FSRTL_COMMON_FCB_HEADER *PFSRTL_COMMON_FCB_HEADER;

/* Advanced FCB header */
#ifdef __cplusplus
typedef struct _FSRTL_ADVANCED_FCB_HEADER : FSRTL_COMMON_FCB_HEADER {
#else
typedef struct _FSRTL_ADVANCED_FCB_HEADER {
    FSRTL_COMMON_FCB_HEADER;
#endif
    PFAST_MUTEX     FastMutex;
    LIST_ENTRY      FilterContexts;
#if (NTDDI_VERSION >= 0x06000000)
    EX_PUSH_LOCK    PushLock;
    PVOID           *FileContextSupportPointer;
#endif
} FSRTL_ADVANCED_FCB_HEADER;
typedef FSRTL_ADVANCED_FCB_HEADER   *PFSRTL_ADVANCED_FCB_HEADER;

/* EOF wait block */
typedef struct _EOF_WAIT_BLOCK {
    LIST_ENTRY  EofWaitLinks;
    KEVENT      Event;
} EOF_WAIT_BLOCK;
typedef EOF_WAIT_BLOCK  *PEOF_WAIT_BLOCK;

/* Auxiliary buffer */
typedef struct _FSRTL_AUXILIARY_BUFFER {
    PVOID   Buffer;
    ULONG   Length;
    ULONG   Flags;
    PMDL    Mdl;
} FSRTL_AUXILIARY_BUFFER;
typedef FSRTL_AUXILIARY_BUFFER  *PFSRTL_AUXILIARY_BUFFER;

/* File lock information */
typedef struct _FILE_LOCK_INFO {
    LARGE_INTEGER   StartingByte;
    LARGE_INTEGER   Length;
    BOOLEAN         ExclusiveLock;
    ULONG           Key;
    PFILE_OBJECT    FileObject;
    PVOID           ProcessId;
    LARGE_INTEGER   EndingByte;
    LONG volatile   LockRequestsInProgress;
} FILE_LOCK_INFO;
typedef FILE_LOCK_INFO  *PFILE_LOCK_INFO;

/* Locking callbacks */
typedef NTSTATUS    (NTAPI *PCOMPLETE_LOCK_IRP_ROUTINE)( PVOID, PIRP );
typedef VOID        (NTAPI *PUNLOCK_ROUTINE)( PVOID, PFILE_LOCK_INFO );

/* File lock */
typedef struct _FILE_LOCK {
    PCOMPLETE_LOCK_IRP_ROUTINE  CompleteLockIrpRoutine;
    PUNLOCK_ROUTINE             UnlockRoutine;
    BOOLEAN                     FastIoIsQuestionable;
    BOOLEAN                     SpareC[3];
    PVOID                       LockInformation;
    FILE_LOCK_INFO              LastReturnedLockInfo;
    PVOID                       LastReturnedLock;
} FILE_LOCK;
typedef FILE_LOCK   *PFILE_LOCK;

/* Tunnel */
typedef struct {
    FAST_MUTEX          Mutex;
    PRTL_SPLAY_LINKS    Cache;
    LIST_ENTRY          TimerQueue;
    USHORT              NumEntries;
} TUNNEL;
typedef TUNNEL  *PTUNNEL;

/* Comparison results */
typedef enum _FSRTL_COMPARISON_RESULT {
    LessThan    = -1,
    EqualTo     = 0,
    GreaterThan = 1
} FSRTL_COMPARISON_RESULT;

/* Base mapped control block */
typedef struct _BASE_MCB {
    ULONG   MaximumPairCount;
    ULONG   PairCount;
    USHORT  PoolType;
    USHORT  Flags;
    PVOID   Mapping;
} BASE_MCB;
typedef BASE_MCB    *PBASE_MCB;

/* Large mapped control block */
typedef struct _LARGE_MCB {
    PKGUARDED_MUTEX GuardedMutex;
    BASE_MCB        BaseMcb;
} LARGE_MCB;
typedef LARGE_MCB   *PLARGE_MCB;

/* Mapped control block */
typedef struct _MCB {
    LARGE_MCB   DummyFieldThatSizesThisStructureCorrectly;
} MCB;
typedef MCB *PMCB;

/* Oplock callbacks */
typedef VOID        (NTAPI *POPLOCK_WAIT_COMPLETE_ROUTINE)( PVOID, PIRP );
typedef VOID        (NTAPI *POPLOCK_FS_PREPOST_IRP)( PVOID, PIRP );

/* Oplock key extra create parameter context */
#if (NTDDI_VERSION >= 0x06010000)
typedef struct _OPLOCK_KEY_ECP_CONTEXT {
    GUID    OplockKey;
    ULONG   Reserved;
} OPLOCK_KEY_ECP_CONTEXT;
typedef OPLOCK_KEY_ECP_CONTEXT  *POPLOCK_KEY_ECP_CONTEXT;
#endif

/* Change notification callbacks */
typedef BOOLEAN     (NTAPI *PCHECK_FOR_TRAVERSE_ACCESS)( PVOID, PVOID, PSECURITY_SUBJECT_CONTEXT );
typedef BOOLEAN     (NTAPI *PFILTER_REPORT_CHANGE)( PVOID, PVOID );

/* Stack overflow callback */
typedef VOID        (NTAPI *PFSRTL_STACK_OVERFLOW_ROUTINE)( PVOID, PKEVENT );

/* MUP provider information (level 1) */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _FSRTL_MUP_PROVIDER_INFO_LEVEL_1 {
    ULONG32 ProviderId;
} FSRTL_MUP_PROVIDER_INFO_LEVEL_1;
typedef FSRTL_MUP_PROVIDER_INFO_LEVEL_1 *PFSRTL_MUP_PROVIDER_INFO_LEVEL_1;
#endif

/* MUP provider information (level 2) */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _FSRTL_MUP_PROVIDER_INFO_LEVEL_2 {
    ULONG32         ProviderId;
    UNICODE_STRING  ProviderName;
} FSRTL_MUP_PROVIDER_INFO_LEVEL_2;
typedef FSRTL_MUP_PROVIDER_INFO_LEVEL_2 *PFSRTL_MUP_PROVIDER_INFO_LEVEL_2;
#endif

/* Per file context */
typedef struct _FSRTL_PER_FILE_CONTEXT {
    LIST_ENTRY      Links;
    PVOID           OwnerId;
    PVOID           InstanceId;
    PFREE_FUNCTION  FreeCallback;
} FSRTL_PER_FILE_CONTEXT;
typedef FSRTL_PER_FILE_CONTEXT  *PFSRTL_PER_FILE_CONTEXT;

/* Per stream context */
typedef struct _FSRTL_PER_STREAM_CONTEXT {
    LIST_ENTRY      Links;
    PVOID           OwnerId;
    PVOID           InstanceId;
    PFREE_FUNCTION  FreeCallback;
} FSRTL_PER_STREAM_CONTEXT;
typedef FSRTL_PER_STREAM_CONTEXT    *PFSRTL_PER_STREAM_CONTEXT;

/* Tear down per stream contexts callback */
#if (NTDDI_VERSION >= 0x05000000)
typedef VOID        (NTAPI *PFN_FSRTLTEARDOWNPERSTREAMCONTEXTS)( PFSRTL_ADVANCED_FCB_HEADER );
#endif

/* Per file object context */
typedef struct _FSRTL_PER_FILEOBJECT_CONTEXT {
    LIST_ENTRY  Links;
    PVOID       OwnerId;
    PVOID       InstanceId;
} FSRTL_PER_FILEOBJECT_CONTEXT;
typedef FSRTL_PER_FILEOBJECT_CONTEXT    *PFSRTL_PER_FILEOBJECT_CONTEXT;

/* Extra create parameter cleanup callback */
#if (NTDDI_VERSION >= 0x06000000)
typedef VOID        (NTAPI *PFSRTL_EXTRA_CREATE_PARAMETER_CLEANUP_CALLBACK)( PVOID, LPCGUID );
#endif

/* Network open location qualifiers */
#if (NTDDI_VERSION >= 0x06000000)
typedef enum {
    NetworkOpenLocationAny      = 0,
    NetworkOpenLocationRemote   = 1,
    NetworkOpenLocationLoopback = 2
} NETWORK_OPEN_LOCATION_QUALIFIER;
#endif

/* Network open integrity qualifiers */
#if (NTDDI_VERSION >= 0x06000000)
typedef enum {
    NetworkOpenIntegrityAny         = 0,
    NetworkOpenIntegrityNone        = 1,
    NetworkOpenIntegritySigned      = 2,
    NetworkOpenIntegrityEncrypted   = 3,
    NetworkOpenIntegrityMaximum     = 4
} NETWORK_OPEN_INTEGRITY_QUALIFIER;
#endif

/* Network open extra create parameter context */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _NETWORK_OPEN_ECP_CONTEXT {
    USHORT  Size;
    USHORT  Reserved;
    struct {
        struct {
            NETWORK_OPEN_LOCATION_QUALIFIER     Location;
            NETWORK_OPEN_INTEGRITY_QUALIFIER    Integrity;
#if (NTDDI_VERSION >= 0x06010000)
            ULONG                               Flags;
#endif
        } in;
        struct {
            NETWORK_OPEN_LOCATION_QUALIFIER     Location;
            NETWORK_OPEN_INTEGRITY_QUALIFIER    Integrity;
#if (NTDDI_VERSION >= 0x06010000)
            ULONG                               Flags;
#endif
        } out;
    };
} NETWORK_OPEN_ECP_CONTEXT;
typedef NETWORK_OPEN_ECP_CONTEXT    *PNETWORK_OPEN_ECP_CONTEXT;
#endif

/* Network open extra create parameter context (version 0) */
#if (NTDDI_VERSION >= 0x06010000)
typedef struct _NETWORK_OPEN_ECP_CONTEXT_V0 {
    USHORT  Size;
    USHORT  Reserved;
    struct {
        struct {
            NETWORK_OPEN_LOCATION_QUALIFIER     Location;
            NETWORK_OPEN_INTEGRITY_QUALIFIER    Integrity;
        } in;
        struct {
            NETWORK_OPEN_LOCATION_QUALIFIER     Location;
            NETWORK_OPEN_INTEGRITY_QUALIFIER    Integrity;
        } out;
    };
} NETWORK_OPEN_ECP_CONTEXT_V0;
typedef NETWORK_OPEN_ECP_CONTEXT_V0 *PNETWORK_OPEN_ECP_CONTEXT_V0;
#endif

/* Prefetch open extra create parameter context */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _PREFETCH_OPEN_ECP_CONTEXT {
    PVOID   Context;
} PREFETCH_OPEN_ECP_CONTEXT;
typedef PREFETCH_OPEN_ECP_CONTEXT   *PPREFETCH_OPEN_ECP_CONTEXT;
#endif

/* NFS open extra create parameter context */
#if (NTDDI_VERSION >= 0x06010000)
typedef struct _NFS_OPEN_ECP_CONTEXT {
    PUNICODE_STRING         ExportAlias;
    PSOCKADDR_STORAGE_NFS   ClientSocketAddress;
} NFS_OPEN_ECP_CONTEXT;
typedef NFS_OPEN_ECP_CONTEXT    *PNFS_OPEN_ECP_CONTEXT;
typedef NFS_OPEN_ECP_CONTEXT    **PPNFS_OPEN_ECP_CONTEXT;
#endif

/* SRV open extra create parameter context */
#if (NTDDI_VERSION >= 0x06010000)
typedef struct _SRV_OPEN_ECP_CONTEXT {
    PUNICODE_STRING         ShareName;
    PSOCKADDR_STORAGE_NFS   SocketAddress;
    BOOLEAN                 OplockBlockState;
    BOOLEAN                 OplockAppState;
    BOOLEAN                 OplockFinalState;
} SRV_OPEN_ECP_CONTEXT;
typedef SRV_OPEN_ECP_CONTEXT    *PSRV_OPEN_ECP_CONTEXT;
#endif

/* Change backing types */
#if (NTDDI_VERSION >= 0x06000000)
typedef enum _FSRTL_CHANGE_BACKING_TYPE {
    ChangeDataControlArea   = 0,
    ChangeImageControlArea  = 1,
    ChangeSharedCacheMap    = 2
} FSRTL_CHANGE_BACKING_TYPE;
typedef FSRTL_CHANGE_BACKING_TYPE   *PFSRTL_CHANGE_BACKING_TYPE;
#endif

/* Public BCB */
typedef struct _PUBLIC_BCB {
    CSHORT          NodeTypeCode;
    CSHORT          NodeByteSize;
    ULONG           MappedLength;
    LARGE_INTEGER   MappedFileOffset;
} PUBLIC_BCB;
typedef PUBLIC_BCB  *PPUBLIC_BCB;

/* File sizes */
typedef struct _CC_FILE_SIZES {
    LARGE_INTEGER   AllocationSize;
    LARGE_INTEGER   FileSize;
    LARGE_INTEGER   ValidDataLength;
} CC_FILE_SIZES;
typedef CC_FILE_SIZES   *PCC_FILE_SIZES;

/* Cache manager callbacks */
typedef BOOLEAN     (NTAPI *PACQUIRE_FOR_LAZY_WRITE)( PVOID, BOOLEAN );
typedef VOID        (NTAPI *PRELEASE_FROM_LAZY_WRITE)( PVOID );
typedef BOOLEAN     (NTAPI *PACQUIRE_FOR_READ_AHEAD)( PVOID, BOOLEAN );
typedef VOID        (NTAPI *PRELEASE_FROM_READ_AHEAD)( PVOID );
typedef VOID        (NTAPI *PDIRTY_PAGE_ROUTINE)( PFILE_OBJECT, PLARGE_INTEGER, ULONG, PLARGE_INTEGER, PLARGE_INTEGER, PVOID, PVOID );
typedef VOID        (NTAPI *PFLUSH_TO_LSN)( PVOID, LARGE_INTEGER );
typedef VOID        (NTAPI *PCC_POST_DEFERRED_WRITE)( PVOID, PVOID );
typedef struct _CACHE_MANAGER_CALLBACKS {
    PACQUIRE_FOR_LAZY_WRITE     AcquireForLazyWrite;
    PRELEASE_FROM_LAZY_WRITE    ReleaseFromLazyWrite;
    PACQUIRE_FOR_READ_AHEAD     AcquireForReadAhead;
    PRELEASE_FROM_READ_AHEAD    ReleaseFromReadAhead;
} CACHE_MANAGER_CALLBACKS;
typedef CACHE_MANAGER_CALLBACKS *PCACHE_MANAGER_CALLBACKS;

/* Cache uninitialize event */
typedef struct _CACHE_UNINITIALIZE_EVENT {
    struct _CACHE_UNINITIALIZE_EVENT    *Next;
    KEVENT                              Event;
} CACHE_UNINITIALIZE_EVENT;
typedef CACHE_UNINITIALIZE_EVENT    *PCACHE_UNINITIALIZE_EVENT;

/* The Microsoft version of ntifs.h contains the contents of sspi.h.  In the interest
 * of efficiency, a #include directive is used here instead.  It is necessary to make
 * sure that UNICODE is defined, because only the Unicode versions of the functions in
 * sspi.h are supported in kernel mode.
 */
#ifndef UNICODE
    #define UNICODE
#endif
#ifndef SECURITY_KERNEL
    #define SECURITY_KERNEL
#endif
#include <sspi.h>

/* Security user data */
typedef struct _SECURITY_USER_DATA {
    SECURITY_STRING UserName;
    SECURITY_STRING LogonDomainName;
    SECURITY_STRING LogonServer;
    PSID            pSid;
} SECURITY_USER_DATA;
typedef SECURITY_USER_DATA  *PSECURITY_USER_DATA;
typedef SECURITY_USER_DATA  SecurityUserData;
typedef SECURITY_USER_DATA  *PSecurityUserData;

/* Query path request */
typedef struct _QUERY_PATH_REQUEST {
    ULONG                   PathNameLength;
    PIO_SECURITY_CONTEXT    SecurityContext;
    WCHAR                   FilePathName[1];
} QUERY_PATH_REQUEST;
typedef QUERY_PATH_REQUEST  *PQUERY_PATH_REQUEST;

/* Query path request (extended version) */
typedef struct _QUERY_PATH_REQUEST_EX {
    PIO_SECURITY_CONTEXT    pSecurityContext;
    ULONG                   EaLength;
    PVOID                   pEaBuffer;
    UNICODE_STRING          PathName;
    UNICODE_STRING          DomainServiceName;
    ULONG_PTR               Reserved[3];
} QUERY_PATH_REQUEST_EX;
typedef QUERY_PATH_REQUEST_EX   *PQUERY_PATH_REQUEST_EX;

/* Query path response */
typedef struct _QUERY_PATH_RESPONSE {
    ULONG   LengthAccepted;
} QUERY_PATH_RESPONSE;
typedef QUERY_PATH_RESPONSE *PQUERY_PATH_RESPONSE;

/* Global variables in NTOSKRNL.EXE */
extern NTKERNELAPI ULONG                __cdecl CcFastMdlReadWait;
extern NTKERNELAPI UCHAR const * const  * __cdecl FsRtlLegalAnsiCharacterArray;
extern NTKERNELAPI ULONG                __cdecl IoReadOperationCount;
extern NTKERNELAPI LARGE_INTEGER        __cdecl IoReadTransferCount;
extern NTKERNELAPI KSPIN_LOCK           __cdecl IoStatisticsLock;
extern NTKERNELAPI ULONG                __cdecl IoWriteOperationCount;
extern NTKERNELAPI LARGE_INTEGER        __cdecl IoWriteTransferCount;
extern NTKERNELAPI PUSHORT              * __cdecl NlsOemLeadByteInfo;
extern NTKERNELAPI PSE_EXPORTS          __cdecl SeExports;

/* Functions in NTOSKRNL.EXE and NTDLL.DLL */
NTSYSAPI NTSTATUS       NTAPI ZwDuplicateToken( HANDLE, ACCESS_MASK, POBJECT_ATTRIBUTES, BOOLEAN, TOKEN_TYPE, PHANDLE );
NTSYSAPI NTSTATUS       NTAPI ZwQueryEaFile( HANDLE, PIO_STATUS_BLOCK, PVOID, ULONG, BOOLEAN, PVOID, ULONG, PULONG, BOOLEAN );
NTSYSAPI NTSTATUS       NTAPI ZwSetEaFile( HANDLE, PIO_STATUS_BLOCK, PVOID, ULONG );
#if (NTDDI_VERSION >= 0x05000000)
NTSYSAPI PPREFIX_TABLE_ENTRY NTAPI PfxFindPrefix( PPREFIX_TABLE, PSTRING );
NTSYSAPI VOID           NTAPI PfxInitialize( PPREFIX_TABLE );
NTSYSAPI BOOLEAN        NTAPI PfxInsertPrefix( PPREFIX_TABLE, PSTRING, PPREFIX_TABLE_ENTRY );
NTSYSAPI VOID           NTAPI PfxRemovePrefix( PPREFIX_TABLE, PPREFIX_TABLE_ENTRY );
NTSYSAPI NTSTATUS       NTAPI RtlAddAccessAllowedAce( PACL, ULONG, ACCESS_MASK, PSID );
NTSYSAPI NTSTATUS       NTAPI RtlAddAccessAllowedAceEx( PACL, ULONG, ULONG, ACCESS_MASK, PSID );
NTSYSAPI NTSTATUS       NTAPI RtlAddAce( PACL, ULONG, ULONG, PVOID, ULONG );
NTSYSAPI NTSTATUS       NTAPI RtlAllocateAndInitializeSid( PSID_IDENTIFIER_AUTHORITY, UCHAR, ULONG, ULONG, ULONG, ULONG, ULONG, ULONG, ULONG, ULONG, PSID * );
NTSYSAPI PVOID          NTAPI RtlAllocateHeap( PVOID, ULONG, SIZE_T );
NTSYSAPI NTSTATUS       NTAPI RtlAppendStringToString( PSTRING, const STRING * );
NTSYSAPI VOID           NTAPI RtlCaptureContext( PCONTEXT );
NTSYSAPI SIZE_T         NTAPI RtlCompareMemoryUlong( PVOID, SIZE_T, ULONG );
NTSYSAPI NTSTATUS       NTAPI RtlConvertSidToUnicodeString( PUNICODE_STRING, PSID, BOOLEAN );
NTSYSAPI VOID           NTAPI RtlCopyLuid( PLUID, PLUID );
NTSYSAPI NTSTATUS       NTAPI RtlCopySid( ULONG, PSID, PSID );
NTSYSAPI NTSTATUS       NTAPI RtlCreateAcl( PACL, ULONG, ULONG );
NTSYSAPI BOOLEAN        NTAPI RtlCreateUnicodeString( PUNICODE_STRING, PCWSTR );
NTSYSAPI NTSTATUS       NTAPI RtlCustomCPToUnicodeN( PCPTABLEINFO, PWCH, ULONG, PULONG, PCH, ULONG );
NTSYSAPI NTSTATUS       NTAPI RtlDeleteAce( PACL, ULONG );
NTSYSAPI NTSTATUS       NTAPI RtlDowncaseUnicodeString( PUNICODE_STRING, PCUNICODE_STRING, BOOLEAN );
NTSYSAPI BOOLEAN        NTAPI RtlEqualPrefixSid( PSID, PSID );
NTSYSAPI BOOLEAN        NTAPI RtlEqualSid( PSID, PSID );
NTSYSAPI PUNICODE_PREFIX_TABLE_ENTRY NTAPI RtlFindUnicodePrefix( PUNICODE_PREFIX_TABLE, PUNICODE_STRING, ULONG );
NTSYSAPI BOOLEAN        NTAPI RtlFreeHeap( PVOID, ULONG, PVOID );
NTSYSAPI VOID           NTAPI RtlFreeOemString( POEM_STRING );
NTSYSAPI PVOID          NTAPI RtlFreeSid( PSID );
NTSYSAPI NTSTATUS       NTAPI RtlGetAce( PACL, ULONG, PVOID * );
NTSYSAPI NTSTATUS       NTAPI RtlGetDaclSecurityDescriptor( PSECURITY_DESCRIPTOR, PBOOLEAN, PACL *, PBOOLEAN );
NTSYSAPI NTSTATUS       NTAPI RtlGetOwnerSecurityDescriptor( PSECURITY_DESCRIPTOR, PSID *, PBOOLEAN );
NTSYSAPI VOID           NTAPI RtlInitCodePageTable( PUSHORT, PCPTABLEINFO );
NTSYSAPI NTSTATUS       NTAPI RtlInitializeSid( PSID, PSID_IDENTIFIER_AUTHORITY, UCHAR );
NTSYSAPI VOID           NTAPI RtlInitializeUnicodePrefix( PUNICODE_PREFIX_TABLE );
NTSYSAPI BOOLEAN        NTAPI RtlInsertUnicodePrefix( PUNICODE_PREFIX_TABLE, PUNICODE_STRING, PUNICODE_PREFIX_TABLE_ENTRY );
NTSYSAPI BOOLEAN        NTAPI RtlIsNameLegalDOS8Dot3( PCUNICODE_STRING, POEM_STRING, PBOOLEAN );
NTSYSAPI BOOLEAN        NTAPI RtlIsValidOemCharacter( PWCHAR );
NTSYSAPI ULONG          NTAPI RtlLengthRequiredSid( ULONG );
NTSYSAPI ULONG          NTAPI RtlLengthSid( PSID );
NTSYSAPI NTSTATUS       NTAPI RtlMultiByteToUnicodeN( PWCH, ULONG, PULONG, PCSTR, ULONG );
NTSYSAPI NTSTATUS       NTAPI RtlMultiByteToUnicodeSize( PULONG, PCSTR, ULONG );
NTSYSAPI PUNICODE_PREFIX_TABLE_ENTRY NTAPI RtlNextUnicodePrefix( PUNICODE_PREFIX_TABLE, BOOLEAN );
NTSYSAPI ULONG          NTAPI RtlNtStatusToDosError( NTSTATUS );
NTSYSAPI NTSTATUS       NTAPI RtlOemStringToCountedUnicodeString( PUNICODE_STRING, PCOEM_STRING, BOOLEAN );
NTSYSAPI NTSTATUS       NTAPI RtlOemStringToUnicodeString( PUNICODE_STRING, PCOEM_STRING, BOOLEAN );
NTSYSAPI NTSTATUS       NTAPI RtlOemToUnicodeN( PWSTR, ULONG, PULONG, PCH, ULONG );
NTSYSAPI ULONG          NTAPI RtlRandom( PULONG );
NTSYSAPI VOID           NTAPI RtlRemoveUnicodePrefix( PUNICODE_PREFIX_TABLE, PUNICODE_PREFIX_TABLE_ENTRY );
NTSYSAPI VOID           NTAPI RtlSecondsSince1970ToTime( ULONG, PLARGE_INTEGER );
NTSYSAPI VOID           NTAPI RtlSecondsSince1980ToTime( ULONG, PLARGE_INTEGER );
NTSYSAPI NTSTATUS       NTAPI RtlSetOwnerSecurityDescriptor( PSECURITY_DESCRIPTOR, PSID, BOOLEAN );
NTSYSAPI PULONG         NTAPI RtlSubAuthoritySid( PSID, ULONG );
NTSYSAPI BOOLEAN        NTAPI RtlTimeToSecondsSince1970( PLARGE_INTEGER, PULONG );
NTSYSAPI BOOLEAN        NTAPI RtlTimeToSecondsSince1980( PLARGE_INTEGER, PULONG );
NTSYSAPI NTSTATUS       NTAPI RtlUnicodeStringToCountedOemString( POEM_STRING, PCUNICODE_STRING, BOOLEAN );
NTSYSAPI NTSTATUS       NTAPI RtlUnicodeStringToOemString( POEM_STRING, PCUNICODE_STRING, BOOLEAN );
NTSYSAPI NTSTATUS       NTAPI RtlUnicodeToCustomCPN( PCPTABLEINFO, PCH, ULONG, PULONG, PWCH, ULONG );
NTSYSAPI NTSTATUS       NTAPI RtlUnicodeToMultiByteN( PCHAR, ULONG, PULONG, PWCH, ULONG );
NTSYSAPI NTSTATUS       NTAPI RtlUnicodeToMultiByteSize( PULONG, PWCH, ULONG );
NTSYSAPI NTSTATUS       NTAPI RtlUnicodeToOemN( PCHAR, ULONG, PULONG, PWCH, ULONG );
NTSYSAPI NTSTATUS       NTAPI RtlUpcaseUnicodeStringToCountedOemString( POEM_STRING, PCUNICODE_STRING, BOOLEAN );
NTSYSAPI NTSTATUS       NTAPI RtlUpcaseUnicodeStringToOemString( POEM_STRING, PCUNICODE_STRING, BOOLEAN );
NTSYSAPI NTSTATUS       NTAPI RtlUpcaseUnicodeToCustomCPN( PCPTABLEINFO, PCH, ULONG, PULONG, PWCH, ULONG );
NTSYSAPI NTSTATUS       NTAPI RtlUpcaseUnicodeToMultiByteN( PCHAR, ULONG, PULONG, PWCH, ULONG );
NTSYSAPI NTSTATUS       NTAPI RtlUpcaseUnicodeToOemN( PCHAR, ULONG, PULONG, PWCH, ULONG );
NTSYSAPI BOOLEAN        NTAPI RtlValidSid( PSID );
NTSYSAPI ULONG          NTAPI RtlxOemStringToUnicodeSize( PCOEM_STRING );
NTSYSAPI ULONG          NTAPI RtlxUnicodeStringToOemSize( PCUNICODE_STRING );
NTSYSAPI NTSTATUS       NTAPI ZwAllocateVirtualMemory( HANDLE, PVOID *, ULONG_PTR, PSIZE_T, ULONG, ULONG );
NTSYSAPI NTSTATUS       NTAPI ZwCreateEvent( PHANDLE, ACCESS_MASK, POBJECT_ATTRIBUTES, EVENT_TYPE, BOOLEAN );
NTSYSAPI NTSTATUS       NTAPI ZwDeleteFile( POBJECT_ATTRIBUTES );
NTSYSAPI NTSTATUS       NTAPI ZwDeviceIoControlFile( HANDLE, HANDLE, PIO_APC_ROUTINE, PVOID, PIO_STATUS_BLOCK, ULONG, PVOID, ULONG, PVOID, ULONG );
NTSYSAPI NTSTATUS       NTAPI ZwDuplicateObject( HANDLE, HANDLE, HANDLE, PHANDLE, ACCESS_MASK, ULONG, ULONG );
NTSYSAPI NTSTATUS       NTAPI ZwFlushVirtualMemory( HANDLE, PVOID *, PSIZE_T, PIO_STATUS_BLOCK );
NTSYSAPI NTSTATUS       NTAPI ZwFreeVirtualMemory( HANDLE, PVOID *, PSIZE_T, ULONG );
NTSYSAPI NTSTATUS       NTAPI ZwFsControlFile( HANDLE, HANDLE, PIO_APC_ROUTINE, PVOID, PIO_STATUS_BLOCK, ULONG, PVOID, ULONG, PVOID, ULONG );
NTSYSAPI NTSTATUS       NTAPI ZwNotifyChangeKey( HANDLE, HANDLE, PIO_APC_ROUTINE, PVOID, PIO_STATUS_BLOCK, ULONG, BOOLEAN, PVOID, ULONG, BOOLEAN );
NTSYSAPI NTSTATUS       NTAPI ZwOpenDirectoryObject( PHANDLE, ACCESS_MASK, POBJECT_ATTRIBUTES );
NTSYSAPI NTSTATUS       NTAPI ZwQueryDirectoryFile( HANDLE, HANDLE, PIO_APC_ROUTINE, PVOID, PIO_STATUS_BLOCK, PVOID, ULONG, FILE_INFORMATION_CLASS, BOOLEAN, PUNICODE_STRING, BOOLEAN );
NTSYSAPI NTSTATUS       NTAPI ZwQueryInformationToken( HANDLE, TOKEN_INFORMATION_CLASS, PVOID, ULONG, PULONG );
NTSYSAPI NTSTATUS       NTAPI ZwQuerySecurityObject( HANDLE, SECURITY_INFORMATION, PSECURITY_DESCRIPTOR, ULONG, PULONG );
NTSYSAPI NTSTATUS       NTAPI ZwQueryVolumeInformationFile( HANDLE, PIO_STATUS_BLOCK, PVOID, ULONG, FS_INFORMATION_CLASS );
NTSYSAPI NTSTATUS       NTAPI ZwSetEvent( HANDLE, PLONG );
NTSYSAPI NTSTATUS       NTAPI ZwSetSecurityObject( HANDLE, SECURITY_INFORMATION, PSECURITY_DESCRIPTOR );
NTSYSAPI NTSTATUS       NTAPI ZwSetVolumeInformationFile( HANDLE, PIO_STATUS_BLOCK, PVOID, ULONG, FS_INFORMATION_CLASS );
NTSYSAPI NTSTATUS       NTAPI ZwWaitForSingleObject( HANDLE, BOOLEAN, PLARGE_INTEGER );
#endif
#if (NTDDI_VERSION >= 0x05010000)
NTSYSAPI USHORT         NTAPI RtlCaptureStackBackTrace( ULONG, ULONG, PVOID *, PULONG );
NTSYSAPI NTSTATUS       NTAPI RtlCompressBuffer( USHORT, PUCHAR, ULONG, PUCHAR, ULONG, ULONG, PULONG, PVOID );
NTSYSAPI NTSTATUS       NTAPI RtlCompressChunks( PUCHAR, ULONG, PUCHAR, ULONG, PCOMPRESSED_DATA_INFO, ULONG, PVOID );
NTSYSAPI PVOID          NTAPI RtlCreateHeap( ULONG, PVOID, SIZE_T, SIZE_T, PVOID, PRTL_HEAP_PARAMETERS );
NTSYSAPI NTSTATUS       NTAPI RtlCreateSystemVolumeInformationFolder( PUNICODE_STRING );
NTSYSAPI NTSTATUS       NTAPI RtlDecompressBuffer( USHORT, PUCHAR, ULONG, PUCHAR, ULONG, PULONG );
NTSYSAPI NTSTATUS       NTAPI RtlDecompressChunks( PUCHAR, ULONG, PUCHAR, ULONG, PUCHAR, ULONG, PCOMPRESSED_DATA_INFO );
NTSYSAPI NTSTATUS       NTAPI RtlDecompressFragment( USHORT, PUCHAR, ULONG, PUCHAR, ULONG, ULONG, PULONG, PVOID );
NTSYSAPI NTSTATUS       NTAPI RtlDescribeChunk( USHORT, PUCHAR *, PUCHAR, PUCHAR *, PULONG );
NTSYSAPI PVOID          NTAPI RtlDestroyHeap( PVOID );
NTSYSAPI NTSTATUS       NTAPI RtlDuplicateUnicodeString( ULONG, const UNICODE_STRING *, UNICODE_STRING * );
NTSYSAPI VOID           NTAPI RtlFillMemoryUlong( PVOID, SIZE_T, ULONG );
NTSYSAPI NTSTATUS       NTAPI RtlGetCompressionWorkSpaceSize( USHORT, PULONG, PULONG );
NTSYSAPI PSID_IDENTIFIER_AUTHORITY NTAPI RtlIdentifierAuthoritySid( PSID );
NTSYSAPI NTSTATUS       NTAPI RtlInitUnicodeStringEx( PUNICODE_STRING, PCWSTR );
NTSYSAPI ULONG          NTAPI RtlNtStatusToDosErrorNoTeb( NTSTATUS );
NTSYSAPI ULONG          NTAPI RtlRandomEx( PULONG );
NTSYSAPI NTSTATUS       NTAPI RtlReserveChunk( USHORT, PUCHAR *, PUCHAR, PUCHAR *, ULONG );
NTSYSAPI PUCHAR         NTAPI RtlSubAuthorityCountSid( PSID );
NTSYSAPI NTSTATUS       NTAPI RtlValidateUnicodeString( ULONG, const UNICODE_STRING * );
NTSYSAPI NTSTATUS       NTAPI ZwOpenProcessTokenEx( HANDLE, ACCESS_MASK, ULONG, PHANDLE );
NTSYSAPI NTSTATUS       NTAPI ZwOpenThreadTokenEx( HANDLE, ACCESS_MASK, BOOLEAN, ULONG, PHANDLE );
NTSYSAPI NTSTATUS       NTAPI ZwQueryObject( HANDLE, OBJECT_INFORMATION_CLASS, PVOID, ULONG, PULONG );
#endif
#if (NTDDI_VERSION >= 0x05020000)
NTSYSAPI NTSTATUS       NTAPI RtlInitAnsiStringEx( PANSI_STRING, PCSZ );
#endif
#if (NTDDI_VERSION >= 0x05020100)
NTSYSAPI NTSTATUS       NTAPI RtlAbsoluteToSelfRelativeSD( PSECURITY_DESCRIPTOR, PSECURITY_DESCRIPTOR, PULONG );
NTSYSAPI NTSTATUS       NTAPI RtlGetGroupSecurityDescriptor( PSECURITY_DESCRIPTOR, PSID *, PBOOLEAN );
NTSYSAPI NTSTATUS       NTAPI RtlGetSaclSecurityDescriptor( PSECURITY_DESCRIPTOR, PBOOLEAN, PACL *, PBOOLEAN );
NTSYSAPI NTSTATUS       NTAPI RtlSelfRelativeToAbsoluteSD( PSECURITY_DESCRIPTOR, PSECURITY_DESCRIPTOR, PULONG, PACL, PULONG, PACL, PULONG, PSID, PULONG, PSID, PULONG );
NTSYSAPI NTSTATUS       NTAPI RtlSetGroupSecurityDescriptor( PSECURITY_DESCRIPTOR, PSID, BOOLEAN );
#endif
#if (NTDDI_VERSION >= 0x06000000)
NTSYSAPI LONG           NTAPI RtlCompareAltitudes( PCUNICODE_STRING, PCUNICODE_STRING );
NTSYSAPI NTSTATUS       NTAPI RtlCreateServiceSid( UNICODE_STRING *, PSID, PULONG );
NTSYSAPI NTSTATUS       NTAPI RtlIdnToAscii( ULONG, PCWSTR, LONG, PWSTR, PLONG );
NTSYSAPI NTSTATUS       NTAPI RtlIdnToNameprepUnicode( ULONG, PCWSTR, LONG, PWSTR, PLONG );
NTSYSAPI NTSTATUS       NTAPI RtlIdnToUnicode( ULONG, PCWSTR, LONG, PWSTR, PLONG );
NTSYSAPI NTSTATUS       NTAPI RtlIsNormalizedString( ULONG, PCWSTR, LONG, PBOOLEAN );
NTSYSAPI NTSTATUS       NTAPI RtlNormalizeString( ULONG, PCWSTR, LONG, PWSTR, PLONG );
NTSYSAPI NTSTATUS       NTAPI ZwFlushBuffersFile( HANDLE, PIO_STATUS_BLOCK );
NTSYSAPI NTSTATUS       NTAPI ZwLockFile( HANDLE, HANDLE, PIO_APC_ROUTINE, PVOID, PIO_STATUS_BLOCK, PLARGE_INTEGER, PLARGE_INTEGER, ULONG, BOOLEAN, BOOLEAN );
NTSYSAPI NTSTATUS       NTAPI ZwQueryQuotaInformationFile( HANDLE, PIO_STATUS_BLOCK, PVOID, ULONG, BOOLEAN, PVOID, ULONG, PSID, BOOLEAN );
NTSYSAPI NTSTATUS       NTAPI ZwSetQuotaInformationFile( HANDLE, PIO_STATUS_BLOCK, PVOID, ULONG );
NTSYSAPI NTSTATUS       NTAPI ZwUnlockFile( HANDLE, PIO_STATUS_BLOCK, PLARGE_INTEGER, PLARGE_INTEGER, ULONG );
#endif
#if (NTDDI_VERSION >= 0x06010000)
NTSYSAPI NTSTATUS       NTAPI RtlCreateVirtualAccount( PCUNICODE_STRING, ULONG, PSID, PULONG );
NTSYSAPI NTSTATUS       NTAPI RtlReplaceSidInSd( PSECURITY_DESCRIPTOR, PSID, PSID, ULONG * );
NTSYSAPI NTSTATUS       NTAPI ZwSetInformationToken( HANDLE, TOKEN_INFORMATION_CLASS, PVOID, ULONG );
#endif

/* Functions in NTOSKRNL.EXE and NTDLL.DLL that are defined differently on different
 * versions of Windows.
 */
#if (NTDDI_VERSION >= 0x06000100)
NTSYSAPI NTSTATUS       NTAPI RtlGenerate8dot3Name( PCUNICODE_STRING, BOOLEAN, PGENERATE_NAME_CONTEXT, PUNICODE_STRING );
#elif (NTDDI_VERSION >= 0x05000000)
NTSYSAPI NTSTATUS       NTAPI RtlGenerate8dot3Name( PCUNICODE_STRING, BOOLEAN, PGENERATE_NAME_CONTEXT, PUNICODE_STRING );
#endif

/* System call functions in NTOSKRNL.EXE and NTDLL.DLL */
#if (NTDDI_VERSION >= 0x05000000)
NTSYSCALLAPI NTSTATUS   NTAPI NtAdjustPrivilegesToken( HANDLE, BOOLEAN, PTOKEN_PRIVILEGES, ULONG, PTOKEN_PRIVILEGES, PULONG );
NTSYSCALLAPI NTSTATUS   NTAPI NtAllocateVirtualMemory( HANDLE, PVOID *, ULONG_PTR, PSIZE_T, ULONG, ULONG );
NTSYSCALLAPI NTSTATUS   NTAPI NtClose( HANDLE );
NTSYSCALLAPI NTSTATUS   NTAPI NtCreateFile( PHANDLE, ACCESS_MASK, POBJECT_ATTRIBUTES, PIO_STATUS_BLOCK, PLARGE_INTEGER, ULONG, ULONG, ULONG, ULONG, PVOID, ULONG );
NTSYSCALLAPI NTSTATUS   NTAPI NtDeviceIoControlFile( HANDLE, HANDLE, PIO_APC_ROUTINE, PVOID, PIO_STATUS_BLOCK, ULONG, PVOID, ULONG, PVOID, ULONG );
NTSYSCALLAPI NTSTATUS   NTAPI NtFreeVirtualMemory( HANDLE, PVOID *, PSIZE_T, ULONG );
NTSYSCALLAPI NTSTATUS   NTAPI NtFsControlFile( HANDLE, HANDLE, PIO_APC_ROUTINE, PVOID, PIO_STATUS_BLOCK, ULONG, PVOID, ULONG, PVOID, ULONG );
NTSYSCALLAPI NTSTATUS   NTAPI NtLockFile( HANDLE, HANDLE, PIO_APC_ROUTINE, PVOID, PIO_STATUS_BLOCK, PLARGE_INTEGER, PLARGE_INTEGER, ULONG, BOOLEAN, BOOLEAN );
NTSYSCALLAPI NTSTATUS   NTAPI NtOpenFile( PHANDLE, ACCESS_MASK, POBJECT_ATTRIBUTES, PIO_STATUS_BLOCK, ULONG, ULONG );
NTSYSCALLAPI NTSTATUS   NTAPI NtOpenProcessToken( HANDLE, ACCESS_MASK, PHANDLE );
NTSYSCALLAPI NTSTATUS   NTAPI NtOpenThreadToken( HANDLE, ACCESS_MASK, BOOLEAN, PHANDLE );
NTSYSCALLAPI NTSTATUS   NTAPI NtQueryDirectoryFile( HANDLE, HANDLE, PIO_APC_ROUTINE, PVOID, PIO_STATUS_BLOCK, PVOID, ULONG, FILE_INFORMATION_CLASS, BOOLEAN, PUNICODE_STRING, BOOLEAN );
NTSYSCALLAPI NTSTATUS   NTAPI NtQueryInformationFile( HANDLE, PIO_STATUS_BLOCK, PVOID, ULONG, FILE_INFORMATION_CLASS );
NTSYSCALLAPI NTSTATUS   NTAPI NtQueryInformationToken( HANDLE, TOKEN_INFORMATION_CLASS, PVOID, ULONG, PULONG );
NTSYSCALLAPI NTSTATUS   NTAPI NtQueryQuotaInformationFile( HANDLE, PIO_STATUS_BLOCK, PVOID, ULONG, BOOLEAN, PVOID, ULONG, PSID, BOOLEAN );
NTSYSCALLAPI NTSTATUS   NTAPI NtQuerySecurityObject( HANDLE, SECURITY_INFORMATION, PSECURITY_DESCRIPTOR, ULONG, PULONG );
NTSYSCALLAPI NTSTATUS   NTAPI NtQueryVolumeInformationFile( HANDLE, PIO_STATUS_BLOCK, PVOID, ULONG, FS_INFORMATION_CLASS );
NTSYSCALLAPI NTSTATUS   NTAPI NtReadFile( HANDLE, HANDLE, PIO_APC_ROUTINE, PVOID, PIO_STATUS_BLOCK, PVOID, ULONG, PLARGE_INTEGER, PULONG );
NTSYSCALLAPI NTSTATUS   NTAPI NtSetInformationFile( HANDLE, PIO_STATUS_BLOCK, PVOID, ULONG, FILE_INFORMATION_CLASS );
NTSYSCALLAPI NTSTATUS   NTAPI NtSetQuotaInformationFile( HANDLE, PIO_STATUS_BLOCK, PVOID, ULONG );
NTSYSCALLAPI NTSTATUS   NTAPI NtSetSecurityObject( HANDLE, SECURITY_INFORMATION, PSECURITY_DESCRIPTOR );
NTSYSCALLAPI NTSTATUS   NTAPI NtSetVolumeInformationFile( HANDLE, PIO_STATUS_BLOCK, PVOID, ULONG, FS_INFORMATION_CLASS );
NTSYSCALLAPI NTSTATUS   NTAPI NtUnlockFile( HANDLE, PIO_STATUS_BLOCK, PLARGE_INTEGER, PLARGE_INTEGER, ULONG );
NTSYSCALLAPI NTSTATUS   NTAPI NtWriteFile( HANDLE, HANDLE, PIO_APC_ROUTINE, PVOID, PIO_STATUS_BLOCK, PVOID, ULONG, PLARGE_INTEGER, PULONG );
#endif
#if (NTDDI_VERSION >= 0x05010000)
NTSYSCALLAPI NTSTATUS   NTAPI NtAccessCheckAndAuditAlarm( PUNICODE_STRING, PVOID, PUNICODE_STRING, PUNICODE_STRING, PSECURITY_DESCRIPTOR, ACCESS_MASK, PGENERIC_MAPPING, BOOLEAN, PACCESS_MASK, PNTSTATUS, PBOOLEAN );
NTSYSCALLAPI NTSTATUS   NTAPI NtAccessCheckByTypeAndAuditAlarm( PUNICODE_STRING, PVOID, PUNICODE_STRING, PUNICODE_STRING, PSECURITY_DESCRIPTOR, PSID, ACCESS_MASK, AUDIT_EVENT_TYPE, ULONG, POBJECT_TYPE_LIST, ULONG, PGENERIC_MAPPING, BOOLEAN, PACCESS_MASK, PNTSTATUS, PBOOLEAN );
NTSYSCALLAPI NTSTATUS   NTAPI NtAccessCheckByTypeResultListAndAuditAlarm( PUNICODE_STRING, PVOID, PUNICODE_STRING, PUNICODE_STRING, PSECURITY_DESCRIPTOR, PSID, ACCESS_MASK, AUDIT_EVENT_TYPE, ULONG, POBJECT_TYPE_LIST, ULONG, PGENERIC_MAPPING, BOOLEAN, PACCESS_MASK, PNTSTATUS, PBOOLEAN );
NTSYSCALLAPI NTSTATUS   NTAPI NtAccessCheckByTypeResultListAndAuditAlarmByHandle( PUNICODE_STRING, PVOID, HANDLE, PUNICODE_STRING, PUNICODE_STRING, PSECURITY_DESCRIPTOR, PSID, ACCESS_MASK, AUDIT_EVENT_TYPE, ULONG, POBJECT_TYPE_LIST, ULONG, PGENERIC_MAPPING, BOOLEAN, PACCESS_MASK, PNTSTATUS, PBOOLEAN );
NTSYSCALLAPI NTSTATUS   NTAPI NtAdjustGroupsToken( HANDLE, BOOLEAN, PTOKEN_GROUPS, ULONG, PTOKEN_GROUPS, PULONG );
NTSYSCALLAPI NTSTATUS   NTAPI NtCloseObjectAuditAlarm( PUNICODE_STRING, PVOID, BOOLEAN );
NTSYSCALLAPI NTSTATUS   NTAPI NtCreateSection( PHANDLE, ACCESS_MASK, POBJECT_ATTRIBUTES, PLARGE_INTEGER, ULONG, ULONG, HANDLE );
NTSYSCALLAPI NTSTATUS   NTAPI NtDeleteObjectAuditAlarm( PUNICODE_STRING, PVOID, BOOLEAN );
NTSYSCALLAPI NTSTATUS   NTAPI NtDuplicateToken( HANDLE, ACCESS_MASK, POBJECT_ATTRIBUTES, BOOLEAN, TOKEN_TYPE, PHANDLE );
NTSYSCALLAPI NTSTATUS   NTAPI NtFilterToken( HANDLE, ULONG, PTOKEN_GROUPS, PTOKEN_PRIVILEGES, PTOKEN_GROUPS, PHANDLE );
NTSYSCALLAPI NTSTATUS   NTAPI NtImpersonateAnonymousToken( HANDLE );
NTSYSCALLAPI NTSTATUS   NTAPI NtOpenObjectAuditAlarm( PUNICODE_STRING, PVOID, PUNICODE_STRING, PUNICODE_STRING, PSECURITY_DESCRIPTOR, HANDLE, ACCESS_MASK, ACCESS_MASK, PPRIVILEGE_SET, BOOLEAN, BOOLEAN, PBOOLEAN );
NTSYSCALLAPI NTSTATUS   NTAPI NtOpenProcessTokenEx( HANDLE, ACCESS_MASK, ULONG, PHANDLE );
NTSYSCALLAPI NTSTATUS   NTAPI NtOpenThreadTokenEx( HANDLE, ACCESS_MASK, BOOLEAN, ULONG, PHANDLE );
NTSYSCALLAPI NTSTATUS   NTAPI NtPrivilegeCheck( HANDLE, PPRIVILEGE_SET, PBOOLEAN );
NTSYSCALLAPI NTSTATUS   NTAPI NtPrivilegeObjectAuditAlarm( PUNICODE_STRING, PVOID, HANDLE, ACCESS_MASK, PPRIVILEGE_SET, BOOLEAN );
NTSYSCALLAPI NTSTATUS   NTAPI NtPrivilegedServiceAuditAlarm( PUNICODE_STRING, PUNICODE_STRING, HANDLE, PPRIVILEGE_SET, BOOLEAN );
NTSYSCALLAPI NTSTATUS   NTAPI NtSetInformationThread( HANDLE, THREADINFOCLASS, PVOID, ULONG );
NTSYSCALLAPI NTSTATUS   NTAPI NtSetInformationToken( HANDLE, TOKEN_INFORMATION_CLASS, PVOID, ULONG );
#endif

/* Functions in NTOSKRNL.EXE */
NTKERNELAPI VOID        NTAPI ExInitializePushLock( PEX_PUSH_LOCK );
NTKERNELAPI NTSTATUS    NTAPI FsRtlInsertPerFileContext( PVOID *, PFSRTL_PER_FILE_CONTEXT );
NTKERNELAPI NTSTATUS    NTAPI FsRtlInsertPerFileObjectContext( PFILE_OBJECT, PFSRTL_PER_FILEOBJECT_CONTEXT );
NTKERNELAPI PFSRTL_PER_FILE_CONTEXT NTAPI FsRtlLookupPerFileContext( PVOID *, PVOID, PVOID );
NTKERNELAPI PFSRTL_PER_FILEOBJECT_CONTEXT NTAPI FsRtlLookupPerFileObjectContext( PFILE_OBJECT, PVOID, PVOID );
NTKERNELAPI PFSRTL_PER_FILE_CONTEXT NTAPI FsRtlRemovePerFileContext( PVOID *, PVOID, PVOID );
NTKERNELAPI PFSRTL_PER_FILEOBJECT_CONTEXT NTAPI FsRtlRemovePerFileObjectContext( PFILE_OBJECT, PVOID, PVOID );
NTKERNELAPI VOID        NTAPI FsRtlTeardownPerFileContexts( PVOID * );
NTKERNELAPI NTSTATUS    NTAPI LsaFreeReturnBuffer( PVOID );
NTKERNELAPI NTSTATUS    NTAPI LsaLogonUser( HANDLE, PLSA_STRING, SECURITY_LOGON_TYPE, ULONG, PVOID, ULONG, PTOKEN_GROUPS, PTOKEN_SOURCE, PVOID *, PULONG, PLUID, PHANDLE, PQUOTA_LIMITS, PNTSTATUS );
NTKERNELAPI NTSTATUS    NTAPI LsaRegisterLogonProcess( PLSA_STRING, PHANDLE, PLSA_OPERATIONAL_MODE );
NTKERNELAPI NTSTATUS    NTAPI PsLookupProcessByProcessId( HANDLE, PEPROCESS * );
NTKERNELAPI NTSTATUS    NTAPI PsLookupThreadByThreadId( HANDLE, PETHREAD * );
NTKERNELAPI NTSTATUS    NTAPI SeAccessCheckFromState( PSECURITY_DESCRIPTOR, PTOKEN_ACCESS_INFORMATION, PTOKEN_ACCESS_INFORMATION, ACCESS_MASK, ACCESS_MASK, PPRIVILEGE_SET *, PGENERIC_MAPPING, KPROCESSOR_MODE, PACCESS_MASK, PNTSTATUS );
NTKERNELAPI NTSTATUS    NTAPI SeLocateProcessImageName( PEPROCESS, PUNICODE_STRING * );
NTKERNELAPI NTSTATUS    NTAPI SeReportSecurityEventWithSubCategory( ULONG, PUNICODE_STRING, PSID, PSE_ADT_PARAMETER_ARRAY, ULONG );
#if (NTDDI_VERSION >= 0x05000000)
NTKERNELAPI BOOLEAN     NTAPI CcCanIWrite( PFILE_OBJECT, ULONG, BOOLEAN, UCHAR );
NTKERNELAPI BOOLEAN     NTAPI CcCopyRead( PFILE_OBJECT, PLARGE_INTEGER, ULONG, BOOLEAN, PVOID, PIO_STATUS_BLOCK );
NTKERNELAPI BOOLEAN     NTAPI CcCopyWrite( PFILE_OBJECT, PLARGE_INTEGER, ULONG, BOOLEAN, PVOID );
NTKERNELAPI VOID        NTAPI CcDeferWrite( PFILE_OBJECT, PCC_POST_DEFERRED_WRITE, PVOID, PVOID, ULONG, BOOLEAN );
NTKERNELAPI VOID        NTAPI CcFastCopyRead( PFILE_OBJECT, ULONG, ULONG, ULONG, PVOID, PIO_STATUS_BLOCK );
NTKERNELAPI VOID        NTAPI CcFastCopyWrite( PFILE_OBJECT, ULONG, ULONG, PVOID );
NTKERNELAPI VOID        NTAPI CcFlushCache( PSECTION_OBJECT_POINTERS, PLARGE_INTEGER, ULONG, PIO_STATUS_BLOCK );
NTKERNELAPI PFILE_OBJECT NTAPI CcGetFileObjectFromBcb( PVOID );
NTKERNELAPI PFILE_OBJECT NTAPI CcGetFileObjectFromSectionPtrs( PSECTION_OBJECT_POINTERS );
NTKERNELAPI LARGE_INTEGER NTAPI CcGetFlushedValidData( PSECTION_OBJECT_POINTERS, BOOLEAN );
NTKERNELAPI VOID        NTAPI CcInitializeCacheMap( PFILE_OBJECT, PCC_FILE_SIZES, BOOLEAN, PCACHE_MANAGER_CALLBACKS, PVOID );
NTKERNELAPI BOOLEAN     NTAPI CcIsThereDirtyData( PVPB );
NTKERNELAPI VOID        NTAPI CcMdlRead( PFILE_OBJECT, PLARGE_INTEGER, ULONG, PMDL *, PIO_STATUS_BLOCK );
NTKERNELAPI VOID        NTAPI CcMdlReadComplete( PFILE_OBJECT, PMDL );
NTKERNELAPI VOID        NTAPI CcMdlWriteComplete( PFILE_OBJECT, PLARGE_INTEGER, PMDL );
NTKERNELAPI BOOLEAN     NTAPI CcPinMappedData( PFILE_OBJECT, PLARGE_INTEGER, ULONG, ULONG, PVOID * );
NTKERNELAPI BOOLEAN     NTAPI CcPinRead( PFILE_OBJECT, PLARGE_INTEGER, ULONG, ULONG, PVOID *, PVOID * );
NTKERNELAPI VOID        NTAPI CcPrepareMdlWrite( PFILE_OBJECT, PLARGE_INTEGER, ULONG, PMDL *, PIO_STATUS_BLOCK );
NTKERNELAPI BOOLEAN     NTAPI CcPreparePinWrite( PFILE_OBJECT, PLARGE_INTEGER, ULONG, BOOLEAN, ULONG, PVOID *, PVOID * );
NTKERNELAPI PVOID       NTAPI CcRemapBcb( PVOID );
NTKERNELAPI VOID        NTAPI CcRepinBcb( PVOID );
NTKERNELAPI VOID        NTAPI CcScheduleReadAhead( PFILE_OBJECT, PLARGE_INTEGER, ULONG );
NTKERNELAPI VOID        NTAPI CcSetAdditionalCacheAttributes( PFILE_OBJECT, BOOLEAN, BOOLEAN );
NTKERNELAPI VOID        NTAPI CcSetBcbOwnerPointer( PVOID, PVOID );
NTKERNELAPI VOID        NTAPI CcSetDirtyPageThreshold( PFILE_OBJECT, ULONG );
NTKERNELAPI VOID        NTAPI CcSetDirtyPinnedData( PVOID, PLARGE_INTEGER );
NTKERNELAPI VOID        NTAPI CcSetFileSizes( PFILE_OBJECT, PCC_FILE_SIZES );
NTKERNELAPI VOID        NTAPI CcSetReadAheadGranularity( PFILE_OBJECT, ULONG );
NTKERNELAPI BOOLEAN     NTAPI CcUninitializeCacheMap( PFILE_OBJECT, PLARGE_INTEGER, PCACHE_UNINITIALIZE_EVENT );
NTKERNELAPI VOID        NTAPI CcUnpinData( PVOID );
NTKERNELAPI VOID        NTAPI CcUnpinDataForThread( PVOID, ERESOURCE_THREAD );
NTKERNELAPI VOID        NTAPI CcUnpinRepinnedBcb( PVOID, BOOLEAN, PIO_STATUS_BLOCK );
NTKERNELAPI NTSTATUS    NTAPI CcWaitForCurrentLazyWriterActivity( VOID );
NTKERNELAPI BOOLEAN     NTAPI CcZeroData( PFILE_OBJECT, PLARGE_INTEGER, PLARGE_INTEGER, BOOLEAN );
NTKERNELAPI VOID        NTAPI ExDisableResourceBoostLite( PERESOURCE );
NTKERNELAPI SIZE_T      NTAPI ExQueryPoolBlockSize( PVOID, PBOOLEAN );
NTKERNELAPI VOID        NTAPI FsRtlAcquireFileExclusive( PFILE_OBJECT );
NTKERNELAPI BOOLEAN     NTAPI FsRtlAddLargeMcbEntry( PLARGE_MCB, LONGLONG, LONGLONG, LONGLONG );
NTKERNELAPI BOOLEAN     NTAPI FsRtlAddMcbEntry( PMCB, VBN, LBN, ULONG );
NTKERNELAPI VOID        NTAPI FsRtlAddToTunnelCache( TUNNEL *, ULONGLONG, UNICODE_STRING *, UNICODE_STRING *, BOOLEAN, ULONG, VOID * );
NTKERNELAPI PFILE_LOCK  NTAPI FsRtlAllocateFileLock( PCOMPLETE_LOCK_IRP_ROUTINE, PUNLOCK_ROUTINE );
NTKERNELAPI PERESOURCE  NTAPI FsRtlAllocateResource( VOID );
NTKERNELAPI BOOLEAN     NTAPI FsRtlAreNamesEqual( PCUNICODE_STRING, PCUNICODE_STRING, BOOLEAN, PCWCH );
NTKERNELAPI NTSTATUS    NTAPI FsRtlBalanceReads( PDEVICE_OBJECT );
NTKERNELAPI BOOLEAN     NTAPI FsRtlCheckLockForReadAccess( PFILE_LOCK, PIRP );
NTKERNELAPI BOOLEAN     NTAPI FsRtlCheckLockForWriteAccess( PFILE_LOCK, PIRP );
NTKERNELAPI NTSTATUS    NTAPI FsRtlCheckOplock( POPLOCK, PIRP, PVOID, POPLOCK_WAIT_COMPLETE_ROUTINE, POPLOCK_FS_PREPOST_IRP );
NTKERNELAPI BOOLEAN     NTAPI FsRtlCopyRead( PFILE_OBJECT, PLARGE_INTEGER, ULONG, BOOLEAN, ULONG, PVOID, PIO_STATUS_BLOCK, PDEVICE_OBJECT );
NTKERNELAPI BOOLEAN     NTAPI FsRtlCopyWrite( PFILE_OBJECT, PLARGE_INTEGER, ULONG, BOOLEAN, ULONG, PVOID, PIO_STATUS_BLOCK, PDEVICE_OBJECT );
NTKERNELAPI NTSTATUS    NTAPI FsRtlCreateSectionForDataScan( PHANDLE, PVOID *, PLARGE_INTEGER, PFILE_OBJECT, ACCESS_MASK, POBJECT_ATTRIBUTES, PLARGE_INTEGER, ULONG, ULONG, ULONG );
NTKERNELAPI BOOLEAN     NTAPI FsRtlCurrentBatchOplock( POPLOCK );
NTKERNELAPI VOID        NTAPI FsRtlDeleteKeyFromTunnelCache( TUNNEL *, ULONGLONG );
NTKERNELAPI VOID        NTAPI FsRtlDeleteTunnelCache( TUNNEL * );
NTKERNELAPI VOID        NTAPI FsRtlDeregisterUncProvider( HANDLE );
NTKERNELAPI VOID        NTAPI FsRtlDissectDbcs( ANSI_STRING, PANSI_STRING, PANSI_STRING );
NTKERNELAPI VOID        NTAPI FsRtlDissectName( UNICODE_STRING, PUNICODE_STRING, PUNICODE_STRING );
NTKERNELAPI BOOLEAN     NTAPI FsRtlDoesDbcsContainWildCards( PANSI_STRING );
NTKERNELAPI BOOLEAN     NTAPI FsRtlDoesNameContainWildCards( PUNICODE_STRING );
NTKERNELAPI BOOLEAN     NTAPI FsRtlFastCheckLockForRead( PFILE_LOCK, PLARGE_INTEGER, PLARGE_INTEGER, ULONG, PFILE_OBJECT, PVOID );
NTKERNELAPI BOOLEAN     NTAPI FsRtlFastCheckLockForWrite( PFILE_LOCK, PLARGE_INTEGER, PLARGE_INTEGER, ULONG, PVOID, PVOID );
NTKERNELAPI NTSTATUS    NTAPI FsRtlFastUnlockAll( PFILE_LOCK, PFILE_OBJECT, PEPROCESS, PVOID );
NTKERNELAPI NTSTATUS    NTAPI FsRtlFastUnlockAllByKey( PFILE_LOCK, PFILE_OBJECT, PEPROCESS, ULONG, PVOID );
NTKERNELAPI NTSTATUS    NTAPI FsRtlFastUnlockSingle( PFILE_LOCK, PFILE_OBJECT, LARGE_INTEGER *, PLARGE_INTEGER, PEPROCESS, ULONG, PVOID, BOOLEAN );
NTKERNELAPI BOOLEAN     NTAPI FsRtlFindInTunnelCache( TUNNEL *, ULONGLONG, UNICODE_STRING *, UNICODE_STRING *, UNICODE_STRING *, ULONG *, VOID * );
NTKERNELAPI VOID        NTAPI FsRtlFreeFileLock( PFILE_LOCK );
NTKERNELAPI NTSTATUS    NTAPI FsRtlGetFileSize( PFILE_OBJECT, PLARGE_INTEGER );
NTKERNELAPI PFILE_LOCK_INFO NTAPI FsRtlGetNextFileLock( PFILE_LOCK, BOOLEAN );
NTKERNELAPI BOOLEAN     NTAPI FsRtlGetNextLargeMcbEntry( PLARGE_MCB, ULONG, PLONGLONG, PLONGLONG, PLONGLONG );
NTKERNELAPI BOOLEAN     NTAPI FsRtlGetNextMcbEntry( PMCB, ULONG, PVBN, PLBN, PULONG );
NTKERNELAPI VOID        NTAPI FsRtlInitializeFileLock( PFILE_LOCK, PCOMPLETE_LOCK_IRP_ROUTINE, PUNLOCK_ROUTINE );
NTKERNELAPI VOID        NTAPI FsRtlInitializeLargeMcb( PLARGE_MCB, POOL_TYPE );
NTKERNELAPI VOID        NTAPI FsRtlInitializeMcb( PMCB, POOL_TYPE );
NTKERNELAPI VOID        NTAPI FsRtlInitializeOplock( POPLOCK );
NTKERNELAPI VOID        NTAPI FsRtlInitializeTunnelCache( TUNNEL * );
NTKERNELAPI BOOLEAN     NTAPI FsRtlIsDbcsInExpression( PANSI_STRING, PANSI_STRING );
NTKERNELAPI BOOLEAN     NTAPI FsRtlIsFatDbcsLegal( ANSI_STRING, BOOLEAN, BOOLEAN, BOOLEAN );
NTKERNELAPI BOOLEAN     NTAPI FsRtlIsHpfsDbcsLegal( ANSI_STRING, BOOLEAN, BOOLEAN, BOOLEAN );
NTKERNELAPI BOOLEAN     NTAPI FsRtlIsNameInExpression( PUNICODE_STRING, PUNICODE_STRING, BOOLEAN, PWCH );
NTKERNELAPI BOOLEAN     NTAPI FsRtlIsNtstatusExpected( NTSTATUS );
NTKERNELAPI BOOLEAN     NTAPI FsRtlLookupLargeMcbEntry( PLARGE_MCB, LONGLONG, PLONGLONG, PLONGLONG, PLONGLONG, PLONGLONG, PULONG );
NTKERNELAPI BOOLEAN     NTAPI FsRtlLookupLastLargeMcbEntry( PLARGE_MCB, PLONGLONG, PLONGLONG );
NTKERNELAPI BOOLEAN     NTAPI FsRtlLookupLastLargeMcbEntryAndIndex( PLARGE_MCB, PLONGLONG, PLONGLONG, PULONG );
NTKERNELAPI BOOLEAN     NTAPI FsRtlLookupLastMcbEntry( PMCB, PVBN, PLBN );
NTKERNELAPI BOOLEAN     NTAPI FsRtlLookupMcbEntry( PMCB, VBN, PLBN, PULONG, PULONG );
NTKERNELAPI BOOLEAN     NTAPI FsRtlMdlReadCompleteDev( PFILE_OBJECT, PMDL, PDEVICE_OBJECT );
NTKERNELAPI BOOLEAN     NTAPI FsRtlMdlReadDev( PFILE_OBJECT, PLARGE_INTEGER, ULONG, ULONG, PMDL *, PIO_STATUS_BLOCK, PDEVICE_OBJECT );
NTKERNELAPI BOOLEAN     NTAPI FsRtlMdlWriteCompleteDev( PFILE_OBJECT, PLARGE_INTEGER, PMDL, PDEVICE_OBJECT );
NTKERNELAPI NTSTATUS    NTAPI FsRtlNormalizeNtstatus( NTSTATUS, NTSTATUS );
NTKERNELAPI VOID        NTAPI FsRtlNotifyCleanup( PNOTIFY_SYNC, PLIST_ENTRY, PVOID );
NTKERNELAPI VOID        NTAPI FsRtlNotifyFilterReportChange( PNOTIFY_SYNC, PLIST_ENTRY, PSTRING, USHORT, PSTRING, PSTRING, ULONG, ULONG, PVOID, PVOID );
NTKERNELAPI VOID        NTAPI FsRtlNotifyFullChangeDirectory( PNOTIFY_SYNC, PLIST_ENTRY, PVOID, PSTRING, BOOLEAN, BOOLEAN, ULONG, PIRP, PCHECK_FOR_TRAVERSE_ACCESS, PSECURITY_SUBJECT_CONTEXT );
NTKERNELAPI VOID        NTAPI FsRtlNotifyFullReportChange( PNOTIFY_SYNC, PLIST_ENTRY, PSTRING, USHORT, PSTRING, PSTRING, ULONG, ULONG, PVOID );
NTKERNELAPI VOID        NTAPI FsRtlNotifyInitializeSync( PNOTIFY_SYNC * );
NTKERNELAPI VOID        NTAPI FsRtlNotifyUninitializeSync( PNOTIFY_SYNC * );
NTKERNELAPI NTSTATUS    NTAPI FsRtlNotifyVolumeEvent( PFILE_OBJECT, ULONG );
NTKERNELAPI ULONG       NTAPI FsRtlNumberOfRunsInLargeMcb( PLARGE_MCB );
NTKERNELAPI ULONG       NTAPI FsRtlNumberOfRunsInMcb( PMCB );
NTKERNELAPI NTSTATUS    NTAPI FsRtlOplockFsctrl( POPLOCK, PIRP, ULONG );
NTKERNELAPI BOOLEAN     NTAPI FsRtlOplockIsFastIoPossible( POPLOCK );
NTKERNELAPI VOID        NTAPI FsRtlPostPagingFileStackOverflow( PVOID, PKEVENT, PFSRTL_STACK_OVERFLOW_ROUTINE );
NTKERNELAPI VOID        NTAPI FsRtlPostStackOverflow( PVOID, PKEVENT, PFSRTL_STACK_OVERFLOW_ROUTINE );
NTKERNELAPI BOOLEAN     NTAPI FsRtlPrepareMdlWriteDev( PFILE_OBJECT, PLARGE_INTEGER, ULONG, ULONG, PMDL *, PIO_STATUS_BLOCK, PDEVICE_OBJECT );
NTKERNELAPI BOOLEAN     NTAPI FsRtlPrivateLock( PFILE_LOCK, PFILE_OBJECT, PLARGE_INTEGER, PLARGE_INTEGER, PEPROCESS, ULONG, BOOLEAN, BOOLEAN, PIO_STATUS_BLOCK, PIRP, PVOID, BOOLEAN );
NTKERNELAPI NTSTATUS    NTAPI FsRtlProcessFileLock( PFILE_LOCK, PIRP, PVOID );
NTKERNELAPI NTSTATUS    NTAPI FsRtlRegisterUncProvider( PHANDLE, PUNICODE_STRING, BOOLEAN );
NTKERNELAPI VOID        NTAPI FsRtlReleaseFile( PFILE_OBJECT );
NTKERNELAPI VOID        NTAPI FsRtlRemoveLargeMcbEntry( PLARGE_MCB, LONGLONG, LONGLONG );
NTKERNELAPI VOID        NTAPI FsRtlRemoveMcbEntry( PMCB, VBN, ULONG );
NTKERNELAPI VOID        NTAPI FsRtlResetLargeMcb( PLARGE_MCB, BOOLEAN );
NTKERNELAPI BOOLEAN     NTAPI FsRtlSplitLargeMcb( PLARGE_MCB, LONGLONG, LONGLONG );
NTKERNELAPI VOID        NTAPI FsRtlTeardownPerStreamContexts( PFSRTL_ADVANCED_FCB_HEADER );
NTKERNELAPI VOID        NTAPI FsRtlTruncateLargeMcb( PLARGE_MCB, LONGLONG );
NTKERNELAPI VOID        NTAPI FsRtlTruncateMcb( PMCB, VBN );
NTKERNELAPI VOID        NTAPI FsRtlUninitializeFileLock( PFILE_LOCK );
NTKERNELAPI VOID        NTAPI FsRtlUninitializeLargeMcb( PLARGE_MCB );
NTKERNELAPI VOID        NTAPI FsRtlUninitializeMcb( PMCB );
NTKERNELAPI VOID        NTAPI FsRtlUninitializeOplock( POPLOCK );
NTKERNELAPI VOID        NTAPI IoAcquireVpbSpinLock( PKIRQL );
NTKERNELAPI NTSTATUS    NTAPI IoCheckDesiredAccess( PACCESS_MASK, ACCESS_MASK );
NTKERNELAPI NTSTATUS    NTAPI IoCheckEaBufferValidity( PFILE_FULL_EA_INFORMATION, ULONG, PULONG );
NTKERNELAPI NTSTATUS    NTAPI IoCheckFunctionAccess( ACCESS_MASK, UCHAR, UCHAR, ULONG, PVOID, PVOID );
NTKERNELAPI NTSTATUS    NTAPI IoCheckQuerySetFileInformation( FILE_INFORMATION_CLASS, ULONG, BOOLEAN );
NTKERNELAPI NTSTATUS    NTAPI IoCheckQuerySetVolumeInformation( FS_INFORMATION_CLASS, ULONG, BOOLEAN );
NTKERNELAPI NTSTATUS    NTAPI IoCheckQuotaBufferValidity( PFILE_QUOTA_INFORMATION, ULONG, PULONG );
NTKERNELAPI PFILE_OBJECT NTAPI IoCreateStreamFileObject( PFILE_OBJECT, PDEVICE_OBJECT );
NTKERNELAPI PFILE_OBJECT NTAPI IoCreateStreamFileObjectLite( PFILE_OBJECT, PDEVICE_OBJECT );
NTKERNELAPI BOOLEAN     NTAPI IoFastQueryNetworkAttributes( POBJECT_ATTRIBUTES, ACCESS_MASK, ULONG, PIO_STATUS_BLOCK, PFILE_NETWORK_OPEN_INFORMATION );
NTKERNELAPI PDEVICE_OBJECT NTAPI IoGetAttachedDevice( PDEVICE_OBJECT );
NTKERNELAPI PDEVICE_OBJECT NTAPI IoGetBaseFileSystemDeviceObject( PFILE_OBJECT );
NTKERNELAPI PEPROCESS   NTAPI IoGetRequestorProcess( PIRP );
NTKERNELAPI ULONG       NTAPI IoGetRequestorProcessId( PIRP );
NTKERNELAPI NTSTATUS    NTAPI IoGetRequestorSessionId( PIRP, PULONG );
NTKERNELAPI PIRP        NTAPI IoGetTopLevelIrp( VOID );
NTKERNELAPI BOOLEAN     NTAPI IoIsOperationSynchronous( PIRP );
NTKERNELAPI BOOLEAN     NTAPI IoIsSystemThread( PETHREAD );
NTKERNELAPI BOOLEAN     NTAPI IoIsValidNameGraftingBuffer( PIRP, PREPARSE_DATA_BUFFER );
NTKERNELAPI NTSTATUS    NTAPI IoPageRead( PFILE_OBJECT, PMDL, PLARGE_INTEGER, PKEVENT, PIO_STATUS_BLOCK );
NTKERNELAPI NTSTATUS    NTAPI IoQueryFileInformation( PFILE_OBJECT, FILE_INFORMATION_CLASS, ULONG, PVOID, PULONG );
NTKERNELAPI NTSTATUS    NTAPI IoQueryVolumeInformation( PFILE_OBJECT, FS_INFORMATION_CLASS, ULONG, PVOID, PULONG );
NTKERNELAPI VOID        NTAPI IoQueueThreadIrp( PIRP );
NTKERNELAPI VOID        NTAPI IoRegisterFileSystem( PDEVICE_OBJECT );
NTKERNELAPI NTSTATUS    NTAPI IoRegisterFsRegistrationChange( PDRIVER_OBJECT, PDRIVER_FS_NOTIFICATION );
NTKERNELAPI VOID        NTAPI IoReleaseVpbSpinLock( KIRQL );
NTKERNELAPI VOID        NTAPI IoSetDeviceToVerify( PETHREAD, PDEVICE_OBJECT );
NTKERNELAPI NTSTATUS    NTAPI IoSetInformation( PFILE_OBJECT, FILE_INFORMATION_CLASS, ULONG, PVOID );
NTKERNELAPI VOID        NTAPI IoSetTopLevelIrp( PIRP );
NTKERNELAPI NTSTATUS    NTAPI IoSynchronousPageWrite( PFILE_OBJECT, PMDL, PLARGE_INTEGER, PKEVENT, PIO_STATUS_BLOCK );
NTKERNELAPI PEPROCESS   NTAPI IoThreadToProcess( PETHREAD );
NTKERNELAPI VOID        NTAPI IoUnregisterFileSystem( PDEVICE_OBJECT );
NTKERNELAPI VOID        NTAPI IoUnregisterFsRegistrationChange( PDRIVER_OBJECT, PDRIVER_FS_NOTIFICATION );
NTKERNELAPI NTSTATUS    NTAPI IoVerifyVolume( PDEVICE_OBJECT, BOOLEAN );
NTKERNELAPI VOID        NTAPI KeAttachProcess( PRKPROCESS );
NTKERNELAPI VOID        NTAPI KeDetachProcess( VOID );
NTKERNELAPI VOID        NTAPI KeInitializeMutant( PRKMUTANT, BOOLEAN );
NTKERNELAPI VOID        NTAPI KeInitializeQueue( PRKQUEUE, ULONG );
NTKERNELAPI LONG        NTAPI KeInsertHeadQueue( PRKQUEUE, PLIST_ENTRY );
NTKERNELAPI LONG        NTAPI KeInsertQueue( PRKQUEUE, PLIST_ENTRY );
NTKERNELAPI LONG        NTAPI KeReadStateMutant( PRKMUTANT );
NTKERNELAPI LONG        NTAPI KeReadStateQueue( PRKQUEUE );
NTKERNELAPI LONG        NTAPI KeReleaseMutant( PRKMUTANT, KPRIORITY, BOOLEAN, BOOLEAN );
NTKERNELAPI PLIST_ENTRY NTAPI KeRemoveQueue( PRKQUEUE, KPROCESSOR_MODE, PLARGE_INTEGER );
NTKERNELAPI PLIST_ENTRY NTAPI KeRundownQueue( PRKQUEUE );
NTKERNELAPI UCHAR       NTAPI KeSetIdealProcessorThread( PKTHREAD, UCHAR );
NTKERNELAPI BOOLEAN     NTAPI KeSetKernelStackSwapEnable( BOOLEAN );
NTKERNELAPI VOID        NTAPI KeStackAttachProcess( PRKPROCESS, PRKAPC_STATE );
NTKERNELAPI VOID        NTAPI KeUnstackDetachProcess( PRKAPC_STATE );
NTKERNELAPI BOOLEAN     NTAPI MmCanFileBeTruncated( PSECTION_OBJECT_POINTERS, PLARGE_INTEGER );
NTKERNELAPI BOOLEAN     NTAPI MmFlushImageSection( PSECTION_OBJECT_POINTERS, MMFLUSH_TYPE );
NTKERNELAPI BOOLEAN     NTAPI MmForceSectionClosed( PSECTION_OBJECT_POINTERS, BOOLEAN );
NTKERNELAPI BOOLEAN     NTAPI MmIsRecursiveIoFault( VOID );
NTKERNELAPI BOOLEAN     NTAPI MmSetAddressRangeModified( PVOID, SIZE_T );
NTKERNELAPI NTSTATUS    NTAPI ObInsertObject( PVOID, PACCESS_STATE, ACCESS_MASK, ULONG, PVOID *, PHANDLE );
NTKERNELAPI VOID        NTAPI ObMakeTemporaryObject( PVOID );
NTKERNELAPI NTSTATUS    NTAPI ObOpenObjectByPointer( PVOID, ULONG, PACCESS_STATE, ACCESS_MASK, POBJECT_TYPE, KPROCESSOR_MODE, PHANDLE );
NTKERNELAPI NTSTATUS    NTAPI ObQueryNameString( PVOID, POBJECT_NAME_INFORMATION, ULONG, PULONG );
NTKERNELAPI NTSTATUS    NTAPI ObQueryObjectAuditingByHandle( HANDLE, PBOOLEAN );
NTKERNELAPI NTSTATUS    NTAPI PsAssignImpersonationToken( PETHREAD, HANDLE );
NTKERNELAPI VOID        NTAPI PsChargePoolQuota( PEPROCESS, POOL_TYPE, ULONG_PTR );
NTKERNELAPI BOOLEAN     NTAPI PsDisableImpersonation( PETHREAD, PSE_IMPERSONATION_STATE );
NTKERNELAPI LARGE_INTEGER NTAPI PsGetProcessExitTime( VOID );
NTKERNELAPI NTSTATUS    NTAPI PsImpersonateClient( PETHREAD, PACCESS_TOKEN, BOOLEAN, BOOLEAN, SECURITY_IMPERSONATION_LEVEL );
NTKERNELAPI BOOLEAN     NTAPI PsIsThreadTerminating( PETHREAD );
NTKERNELAPI PACCESS_TOKEN NTAPI PsReferenceImpersonationToken( PETHREAD, PBOOLEAN, PBOOLEAN, PSECURITY_IMPERSONATION_LEVEL );
NTKERNELAPI PACCESS_TOKEN NTAPI PsReferencePrimaryToken( PEPROCESS );
NTKERNELAPI VOID        NTAPI PsRestoreImpersonation( PETHREAD, PSE_IMPERSONATION_STATE );
NTKERNELAPI VOID        NTAPI PsReturnPoolQuota( PEPROCESS, POOL_TYPE, ULONG_PTR );
NTKERNELAPI VOID        NTAPI PsRevertToSelf( VOID );
NTKERNELAPI NTSTATUS    NTAPI SeAppendPrivileges( PACCESS_STATE, PPRIVILEGE_SET );
NTKERNELAPI BOOLEAN     NTAPI SeAuditingFileEvents( BOOLEAN, PSECURITY_DESCRIPTOR );
NTKERNELAPI BOOLEAN     NTAPI SeAuditingFileOrGlobalEvents( BOOLEAN, PSECURITY_DESCRIPTOR, PSECURITY_SUBJECT_CONTEXT );
NTKERNELAPI NTSTATUS    NTAPI SeCreateClientSecurity( PETHREAD, PSECURITY_QUALITY_OF_SERVICE, BOOLEAN, PSECURITY_CLIENT_CONTEXT );
NTKERNELAPI NTSTATUS    NTAPI SeCreateClientSecurityFromSubjectContext( PSECURITY_SUBJECT_CONTEXT, PSECURITY_QUALITY_OF_SERVICE, BOOLEAN, PSECURITY_CLIENT_CONTEXT );
NTKERNELAPI VOID        NTAPI SeDeleteObjectAuditAlarm( PVOID, HANDLE );
NTKERNELAPI VOID        NTAPI SeFreePrivileges( PPRIVILEGE_SET );
NTKERNELAPI VOID        NTAPI SeImpersonateClient( PSECURITY_CLIENT_CONTEXT, PETHREAD );
NTKERNELAPI NTSTATUS    NTAPI SeImpersonateClientEx( PSECURITY_CLIENT_CONTEXT, PETHREAD );
NTKERNELAPI NTSTATUS    NTAPI SeMarkLogonSessionForTerminationNotification( PLUID );
NTKERNELAPI VOID        NTAPI SeOpenObjectAuditAlarm( PUNICODE_STRING, PVOID, PUNICODE_STRING, PSECURITY_DESCRIPTOR, PACCESS_STATE, BOOLEAN, BOOLEAN, KPROCESSOR_MODE, PBOOLEAN );
NTKERNELAPI VOID        NTAPI SeOpenObjectForDeleteAuditAlarm( PUNICODE_STRING, PVOID, PUNICODE_STRING, PSECURITY_DESCRIPTOR, PACCESS_STATE, BOOLEAN, BOOLEAN, KPROCESSOR_MODE, PBOOLEAN );
NTKERNELAPI BOOLEAN     NTAPI SePrivilegeCheck( PPRIVILEGE_SET, PSECURITY_SUBJECT_CONTEXT, KPROCESSOR_MODE );
NTKERNELAPI NTSTATUS    NTAPI SeQueryAuthenticationIdToken( PACCESS_TOKEN, PLUID );
NTKERNELAPI NTSTATUS    NTAPI SeQueryInformationToken( PACCESS_TOKEN, TOKEN_INFORMATION_CLASS, PVOID * );
NTKERNELAPI NTSTATUS    NTAPI SeQuerySecurityDescriptorInfo( PSECURITY_INFORMATION, PSECURITY_DESCRIPTOR, PULONG, PSECURITY_DESCRIPTOR * );
NTKERNELAPI NTSTATUS    NTAPI SeQuerySessionIdToken( PACCESS_TOKEN, PULONG );
NTKERNELAPI NTSTATUS    NTAPI SeRegisterLogonSessionTerminatedRoutine( PSE_LOGON_SESSION_TERMINATED_ROUTINE );
NTKERNELAPI VOID        NTAPI SeSetAccessStateGenericMapping( PACCESS_STATE, PGENERIC_MAPPING );
NTKERNELAPI NTSTATUS    NTAPI SeSetSecurityDescriptorInfo( PVOID, PSECURITY_INFORMATION, PSECURITY_DESCRIPTOR, PSECURITY_DESCRIPTOR *, POOL_TYPE, PGENERIC_MAPPING );
NTKERNELAPI NTSTATUS    NTAPI SeSetSecurityDescriptorInfoEx( PVOID, PSECURITY_INFORMATION, PSECURITY_DESCRIPTOR, PSECURITY_DESCRIPTOR *, ULONG, POOL_TYPE, PGENERIC_MAPPING );
NTKERNELAPI BOOLEAN     NTAPI SeTokenIsAdmin( PACCESS_TOKEN );
NTKERNELAPI BOOLEAN     NTAPI SeTokenIsRestricted( PACCESS_TOKEN );
NTKERNELAPI TOKEN_TYPE  NTAPI SeTokenType( PACCESS_TOKEN );
NTKERNELAPI NTSTATUS    NTAPI SeUnregisterLogonSessionTerminatedRoutine( PSE_LOGON_SESSION_TERMINATED_ROUTINE );
#endif
#if (NTDDI_VERSION >= 0x05000300)
NTKERNELAPI BOOLEAN     NTAPI SeAuditingHardLinkEvents( BOOLEAN, PSECURITY_DESCRIPTOR );
#endif
#if (NTDDI_VERSION >= 0x05010000)
NTKERNELAPI LARGE_INTEGER NTAPI CcGetDirtyPages( PVOID, PDIRTY_PAGE_ROUTINE, PVOID, PVOID );
NTKERNELAPI VOID        NTAPI CcMdlWriteAbort( PFILE_OBJECT, PMDL );
NTKERNELAPI VOID        NTAPI CcSetLogHandleForFile( PFILE_OBJECT, PVOID, PFLUSH_TO_LSN );
NTKERNELAPI VOID        NTAPI FsRtlIncrementCcFastReadNoWait( VOID );
NTKERNELAPI VOID        NTAPI FsRtlIncrementCcFastReadNotPossible( VOID );
NTKERNELAPI VOID        NTAPI FsRtlIncrementCcFastReadResourceMiss( VOID );
NTKERNELAPI VOID        NTAPI FsRtlIncrementCcFastReadWait( VOID );
NTKERNELAPI NTSTATUS    NTAPI FsRtlInsertPerStreamContext( PFSRTL_ADVANCED_FCB_HEADER, PFSRTL_PER_STREAM_CONTEXT );
NTKERNELAPI PFSRTL_PER_STREAM_CONTEXT NTAPI FsRtlLookupPerStreamContextInternal( PFSRTL_ADVANCED_FCB_HEADER, PVOID, PVOID );
NTKERNELAPI VOID        NTAPI FsRtlNotifyFilterChangeDirectory( PNOTIFY_SYNC, PLIST_ENTRY, PVOID, PSTRING, BOOLEAN, BOOLEAN, ULONG, PIRP, PCHECK_FOR_TRAVERSE_ACCESS, PSECURITY_SUBJECT_CONTEXT, PFILTER_REPORT_CHANGE );
NTKERNELAPI NTSTATUS    NTAPI FsRtlRegisterFileSystemFilterCallbacks( struct _DRIVER_OBJECT *, PFS_FILTER_CALLBACKS );
NTKERNELAPI PFSRTL_PER_STREAM_CONTEXT NTAPI FsRtlRemovePerStreamContext( PFSRTL_ADVANCED_FCB_HEADER, PVOID, PVOID );
NTKERNELAPI PFILE_OBJECT NTAPI IoCreateStreamFileObjectEx( PFILE_OBJECT, PDEVICE_OBJECT, PHANDLE );
NTKERNELAPI NTSTATUS    NTAPI IoEnumerateDeviceObjectList( PDRIVER_OBJECT, PDEVICE_OBJECT *, ULONG, PULONG );
NTKERNELAPI PDEVICE_OBJECT NTAPI IoGetDeviceAttachmentBaseRef( PDEVICE_OBJECT );
NTKERNELAPI NTSTATUS    NTAPI IoGetDiskDeviceObject( PDEVICE_OBJECT, PDEVICE_OBJECT * );
NTKERNELAPI PDEVICE_OBJECT NTAPI IoGetLowerDeviceObject( PDEVICE_OBJECT );
NTKERNELAPI NTSTATUS    NTAPI IoQueryFileDosDeviceName( PFILE_OBJECT, POBJECT_NAME_INFORMATION * );
NTKERNELAPI NTSTATUS    NTAPI MmPrefetchPages( ULONG, PREAD_LIST * );
NTKERNELAPI NTSTATUS    NTAPI PoQueueShutdownWorkItem( PWORK_QUEUE_ITEM );
NTKERNELAPI NTSTATUS    NTAPI PsChargeProcessPoolQuota( PEPROCESS, POOL_TYPE, ULONG_PTR );
NTKERNELAPI VOID        NTAPI PsDereferenceImpersonationToken( PACCESS_TOKEN );
NTKERNELAPI VOID        NTAPI PsDereferencePrimaryToken( PACCESS_TOKEN );
NTKERNELAPI BOOLEAN     NTAPI PsIsSystemThread( PETHREAD );
NTKERNELAPI VOID        NTAPI SeAuditHardLinkCreation( PUNICODE_STRING, PUNICODE_STRING, BOOLEAN );
NTKERNELAPI NTSTATUS    NTAPI SeFilterToken( PACCESS_TOKEN, ULONG, PTOKEN_GROUPS, PTOKEN_PRIVILEGES, PTOKEN_GROUPS, PACCESS_TOKEN * );
#endif
#if ((NTDDI_VERSION >= 0x05010200) && (NTDDI_VERSION < 0x05020000)) || (NTDDI_VERSION >= 0x06000000)
NTKERNELAPI BOOLEAN     NTAPI SeTokenIsWriteRestricted( PACCESS_TOKEN );
#endif
#if (NTDDI_VERSION >= 0x05010200)
NTKERNELAPI BOOLEAN     NTAPI SeAuditingFileEventsWithContext( BOOLEAN, PSECURITY_DESCRIPTOR, PSECURITY_SUBJECT_CONTEXT );
NTKERNELAPI BOOLEAN     NTAPI SeAuditingHardLinkEventsWithContext( BOOLEAN, PSECURITY_DESCRIPTOR, PSECURITY_SUBJECT_CONTEXT );
#endif
#if (NTDDI_VERSION >= 0x05020000)
NTKERNELAPI BOOLEAN     NTAPI FsRtlAddBaseMcbEntry( PBASE_MCB, LONGLONG, LONGLONG, LONGLONG );
NTKERNELAPI BOOLEAN     NTAPI FsRtlCurrentOplock( POPLOCK );
NTKERNELAPI BOOLEAN     NTAPI FsRtlGetNextBaseMcbEntry( PBASE_MCB, ULONG, PLONGLONG, PLONGLONG, PLONGLONG );
NTKERNELAPI VOID        NTAPI FsRtlInitializeBaseMcb( PBASE_MCB, POOL_TYPE );
NTKERNELAPI BOOLEAN     NTAPI FsRtlLookupBaseMcbEntry( PBASE_MCB, LONGLONG, PLONGLONG, PLONGLONG, PLONGLONG, PLONGLONG, PULONG );
NTKERNELAPI BOOLEAN     NTAPI FsRtlLookupLastBaseMcbEntry( PBASE_MCB, PLONGLONG, PLONGLONG );
NTKERNELAPI BOOLEAN     NTAPI FsRtlLookupLastBaseMcbEntryAndIndex( PBASE_MCB, PLONGLONG, PLONGLONG, PULONG );
NTKERNELAPI ULONG       NTAPI FsRtlNumberOfRunsInBaseMcb( PBASE_MCB );
NTKERNELAPI NTSTATUS    NTAPI FsRtlOplockBreakToNone( POPLOCK, PIO_STACK_LOCATION, PIRP, PVOID, POPLOCK_WAIT_COMPLETE_ROUTINE, POPLOCK_FS_PREPOST_IRP );
NTKERNELAPI BOOLEAN     NTAPI FsRtlRemoveBaseMcbEntry( PBASE_MCB, LONGLONG, LONGLONG );
NTKERNELAPI VOID        NTAPI FsRtlResetBaseMcb( PBASE_MCB );
NTKERNELAPI BOOLEAN     NTAPI FsRtlSplitBaseMcb( PBASE_MCB, LONGLONG, LONGLONG );
NTKERNELAPI VOID        NTAPI FsRtlTruncateBaseMcb( PBASE_MCB, LONGLONG );
NTKERNELAPI VOID        NTAPI FsRtlUninitializeBaseMcb( PBASE_MCB );
#endif
#if (NTDDI_VERSION >= 0x05020100)
NTKERNELAPI NTSTATUS    NTAPI IoEnumerateRegisteredFiltersList( PDRIVER_OBJECT *, ULONG, PULONG );
#endif
#if (NTDDI_VERSION >= 0x06000000)
NTKERNELAPI PFILE_OBJECT NTAPI CcGetFileObjectFromSectionPtrsRef( PSECTION_OBJECT_POINTERS );
NTKERNELAPI BOOLEAN     NTAPI CcIsThereDirtyDataEx( PVPB, PULONG );
NTKERNELAPI NTSTATUS    NTAPI CcSetFileSizesEx( PFILE_OBJECT, PCC_FILE_SIZES );
NTKERNELAPI VOID        NTAPI CcSetParallelFlushFile( PFILE_OBJECT, BOOLEAN );
NTKERNELAPI VOID        NTAPI FsRtlAcknowledgeEcp( PVOID );
NTKERNELAPI NTSTATUS    NTAPI FsRtlAddBaseMcbEntryEx( PBASE_MCB, LONGLONG, LONGLONG, LONGLONG );
NTKERNELAPI NTSTATUS    NTAPI FsRtlAllocateExtraCreateParameter( LPCGUID, ULONG, FSRTL_ALLOCATE_ECP_FLAGS, PFSRTL_EXTRA_CREATE_PARAMETER_CLEANUP_CALLBACK, ULONG, PVOID * );
NTKERNELAPI NTSTATUS    NTAPI FsRtlAllocateExtraCreateParameterFromLookasideList( LPCGUID, ULONG, FSRTL_ALLOCATE_ECP_FLAGS, PFSRTL_EXTRA_CREATE_PARAMETER_CLEANUP_CALLBACK, PVOID, PVOID * );
NTKERNELAPI NTSTATUS    NTAPI FsRtlAllocateExtraCreateParameterList( FSRTL_ALLOCATE_ECPLIST_FLAGS, PECP_LIST * );
NTKERNELAPI BOOLEAN     NTAPI FsRtlAreVolumeStartupApplicationsComplete( VOID );
NTKERNELAPI NTSTATUS    NTAPI FsRtlCancellableWaitForMultipleObjects( ULONG, PVOID [], WAIT_TYPE, PLARGE_INTEGER, PKWAIT_BLOCK, PIRP );
NTKERNELAPI NTSTATUS    NTAPI FsRtlCancellableWaitForSingleObject( PVOID, PLARGE_INTEGER, PIRP );
NTKERNELAPI NTSTATUS    NTAPI FsRtlChangeBackingFileObject( PFILE_OBJECT, PFILE_OBJECT, FSRTL_CHANGE_BACKING_TYPE, ULONG );
NTKERNELAPI VOID        NTAPI FsRtlDeleteExtraCreateParameterLookasideList( PVOID, FSRTL_ECP_LOOKASIDE_FLAGS );
NTKERNELAPI NTSTATUS    NTAPI FsRtlFindExtraCreateParameter( PECP_LIST, LPCGUID, PVOID *, ULONG * );
NTKERNELAPI VOID        NTAPI FsRtlFreeExtraCreateParameter( PVOID );
NTKERNELAPI VOID        NTAPI FsRtlFreeExtraCreateParameterList( PECP_LIST );
NTKERNELAPI NTSTATUS    NTAPI FsRtlGetEcpListFromIrp( PIRP, PECP_LIST * );
NTKERNELAPI NTSTATUS    NTAPI FsRtlGetNextExtraCreateParameter( PECP_LIST, PVOID, LPGUID, PVOID *, ULONG * );
NTKERNELAPI NTSTATUS    NTAPI FsRtlGetVirtualDiskNestingLevel( PDEVICE_OBJECT, PULONG, PULONG );
NTKERNELAPI VOID        NTAPI FsRtlIncrementCcFastMdlReadWait( VOID );
NTKERNELAPI VOID        NTAPI FsRtlInitExtraCreateParameterLookasideList( PVOID, FSRTL_ECP_LOOKASIDE_FLAGS, SIZE_T, ULONG );
NTKERNELAPI BOOLEAN     NTAPI FsRtlInitializeBaseMcbEx( PBASE_MCB, POOL_TYPE, USHORT );
NTKERNELAPI NTSTATUS    NTAPI FsRtlInsertExtraCreateParameter( PECP_LIST, PVOID );
NTKERNELAPI BOOLEAN     NTAPI FsRtlIsEcpAcknowledged( PVOID );
NTKERNELAPI BOOLEAN     NTAPI FsRtlIsEcpFromUserMode( PVOID );
NTKERNELAPI LOGICAL     NTAPI FsRtlIsPagingFile( PFILE_OBJECT );
NTKERNELAPI NTSTATUS    NTAPI FsRtlLogCcFlushError( PUNICODE_STRING, PDEVICE_OBJECT, PSECTION_OBJECT_POINTERS, NTSTATUS, ULONG );
NTKERNELAPI NTSTATUS    NTAPI FsRtlMupGetProviderIdFromName( PUNICODE_STRING, PULONG32 );
NTKERNELAPI NTSTATUS    NTAPI FsRtlMupGetProviderInfoFromFileObject( PFILE_OBJECT, ULONG, PVOID, PULONG );
NTKERNELAPI VOID        NTAPI FsRtlNotifyCleanupAll( PNOTIFY_SYNC, PLIST_ENTRY );
NTKERNELAPI NTSTATUS    NTAPI FsRtlNotifyVolumeEventEx( PFILE_OBJECT, ULONG, PTARGET_DEVICE_CUSTOM_NOTIFICATION );
NTKERNELAPI ULONG       NTAPI FsRtlQueryMaximumVirtualDiskNestingLevel( VOID );
NTKERNELAPI NTSTATUS    NTAPI FsRtlRegisterUncProviderEx( PHANDLE, PUNICODE_STRING, PDEVICE_OBJECT, ULONG );
NTKERNELAPI NTSTATUS    NTAPI FsRtlRemoveDotsFromPath( PWSTR, USHORT, USHORT * );
NTKERNELAPI NTSTATUS    NTAPI FsRtlRemoveExtraCreateParameter( PECP_LIST, LPCGUID, PVOID *, ULONG * );
NTKERNELAPI NTSTATUS    NTAPI FsRtlSetEcpListIntoIrp( PIRP, PECP_LIST );
NTKERNELAPI NTSTATUS    NTAPI FsRtlValidateReparsePointBuffer( ULONG, PREPARSE_DATA_BUFFER );
NTKERNELAPI ULONG       NTAPI MmDoesFileHaveUserWritableReferences( PSECTION_OBJECT_POINTERS );
NTKERNELAPI BOOLEAN     NTAPI ObIsKernelHandle( HANDLE );
NTKERNELAPI VOID        NTAPI SeAuditHardLinkCreationWithTransaction( PUNICODE_STRING, PUNICODE_STRING, BOOLEAN, GUID * );
NTKERNELAPI VOID        NTAPI SeAuditTransactionStateChange( GUID *, GUID *, ULONG );
NTKERNELAPI VOID        NTAPI SeDeleteObjectAuditAlarmWithTransaction( PVOID, HANDLE, GUID * );
NTKERNELAPI VOID        NTAPI SeExamineSacl( PACL, PACCESS_TOKEN, ACCESS_MASK, BOOLEAN, PBOOLEAN, PBOOLEAN );
NTKERNELAPI VOID        NTAPI SeOpenObjectAuditAlarmWithTransaction( PUNICODE_STRING, PVOID, PUNICODE_STRING, PSECURITY_DESCRIPTOR, PACCESS_STATE, BOOLEAN, BOOLEAN, KPROCESSOR_MODE, GUID *, PBOOLEAN );
NTKERNELAPI VOID        NTAPI SeOpenObjectForDeleteAuditAlarmWithTransaction( PUNICODE_STRING, PVOID, PUNICODE_STRING, PSECURITY_DESCRIPTOR, PACCESS_STATE, BOOLEAN, BOOLEAN, KPROCESSOR_MODE, GUID *, PBOOLEAN );
#endif
#if (NTDDI_VERSION >= 0x06000100)
NTKERNELAPI NTSTATUS    NTAPI FsRtlCheckOplockEx( POPLOCK, PIRP, ULONG, PVOID, POPLOCK_WAIT_COMPLETE_ROUTINE, POPLOCK_FS_PREPOST_IRP );
#endif
#if (NTDDI_VERSION >= 0x06010000)
NTKERNELAPI VOID        NTAPI CcCoherencyFlushAndPurgeCache( PSECTION_OBJECT_POINTERS, PLARGE_INTEGER, ULONG, PIO_STATUS_BLOCK, ULONG );
NTKERNELAPI BOOLEAN     NTAPI CcCopyWriteWontFlush( PFILE_OBJECT, PLARGE_INTEGER, ULONG );
NTKERNELAPI BOOLEAN     NTAPI FsRtlAreThereCurrentOrInProgressFileLocks( PFILE_LOCK );
NTKERNELAPI BOOLEAN     NTAPI FsRtlCurrentOplockH( POPLOCK );
NTKERNELAPI NTSTATUS    NTAPI FsRtlInitializeExtraCreateParameter( PECP_HEADER, ULONG, PFSRTL_EXTRA_CREATE_PARAMETER_CLEANUP_CALLBACK, ULONG, LPCGUID, PVOID );
NTKERNELAPI NTSTATUS    NTAPI FsRtlInitializeExtraCreateParameterList( PECP_LIST );
NTKERNELAPI NTSTATUS    NTAPI FsRtlOplockBreakH( POPLOCK, PIRP, ULONG, PVOID, POPLOCK_WAIT_COMPLETE_ROUTINE, POPLOCK_FS_PREPOST_IRP );
NTKERNELAPI NTSTATUS    NTAPI FsRtlOplockBreakToNoneEx( POPLOCK, PIRP, ULONG, PVOID, POPLOCK_WAIT_COMPLETE_ROUTINE, POPLOCK_FS_PREPOST_IRP );
NTKERNELAPI NTSTATUS    NTAPI FsRtlOplockFsctrlEx( POPLOCK, PIRP, ULONG, ULONG );
NTKERNELAPI BOOLEAN     NTAPI FsRtlOplockIsSharedRequest( PIRP );
NTKERNELAPI BOOLEAN     NTAPI FsRtlOplockKeysEqual( PFILE_OBJECT, PFILE_OBJECT );
NTKERNELAPI NTSTATUS    NTAPI IoRegisterFsRegistrationChangeMountAware( PDRIVER_OBJECT, PDRIVER_FS_NOTIFICATION, BOOLEAN );
NTKERNELAPI NTSTATUS    NTAPI IoReplaceFileObjectName( PFILE_OBJECT, PWSTR, USHORT );
NTKERNELAPI NTSTATUS    NTAPI ObOpenObjectByPointerWithTag( PVOID, ULONG, PACCESS_STATE, ACCESS_MASK, POBJECT_TYPE, KPROCESSOR_MODE, ULONG, PHANDLE );
NTKERNELAPI BOOLEAN     NTAPI SeAuditingAnyFileEventsWithContext( PSECURITY_DESCRIPTOR, PSECURITY_SUBJECT_CONTEXT );
#endif

/* Functions in NTOSKRNL.EXE with different signatures on different versions */
#if (NTDDI_VERSION >= 0x05010000)
NTKERNELAPI BOOLEAN     NTAPI CcMapData( PFILE_OBJECT, PLARGE_INTEGER, ULONG, ULONG, PVOID *, PVOID * );
#else
NTKERNELAPI BOOLEAN     NTAPI CcMapData( PFILE_OBJECT, PLARGE_INTEGER, ULONG, BOOLEAN, PVOID *, PVOID * );
#endif
#if (NTDDI_VERSION >= 0x06000000)
NTKERNELAPI BOOLEAN     NTAPI CcPurgeCacheSection( PSECTION_OBJECT_POINTERS, PLARGE_INTEGER, ULONG, ULONG );
#elif (NTDDI_VERSION >= 0x05000000)
NTKERNELAPI BOOLEAN     NTAPI CcPurgeCacheSection( PSECTION_OBJECT_POINTERS, PLARGE_INTEGER, ULONG, BOOLEAN );
#endif

/* Functions in HAL.DLL */
#ifdef _X86_
NTHALAPI KIRQL          FASTCALL KeAcquireSpinLockRaiseToSynch( PKSPIN_LOCK );
#endif
#if (NTDDI_VERSION >= 0x05010000)
#ifdef _X86_
NTHALAPI KIRQL          FASTCALL KeAcquireQueuedSpinLock( KSPIN_LOCK_QUEUE_NUMBER );
NTHALAPI VOID           FASTCALL KeReleaseQueuedSpinLock( KSPIN_LOCK_QUEUE_NUMBER, KIRQL );
NTHALAPI LOGICAL        FASTCALL KeTryToAcquireQueuedSpinLock( KSPIN_LOCK_QUEUE_NUMBER, PKIRQL );
#endif
#endif

/* Functions in KSECDD.SYS */
KSECDDDECLSPEC HRESULT  SEC_ENTRY GetSecurityUserInfo( PLUID, ULONG, PSecurityUserData * );
KSECDDDECLSPEC SECURITY_STATUS SEC_ENTRY MapSecurityError( SECURITY_STATUS );

/* Functions implemented as macros */
#define RtlUnicodeStringToOemSize( x ) \
    ((*NlsMbOemCodePageTag) ? RtlxUnicodeStringToOemSize( x ) : \
    ((x)->Length + sizeof( UNICODE_NULL )) / sizeof( WCHAR ))
#define RtlOemStringToUnicodeSize( x ) \
    ((*NlsMbOemCodePageTag) ? RtlxOemStringToUnicodeSize( x ) : \
    ((x)->Length + sizeof( ANSI_NULL )) * sizeof( WCHAR ))
#define RtlOemStringToCountedUnicodeSize( x ) \
    (ULONG)(RtlOemStringToUnicodeSize( x ) - sizeof( UNICODE_NULL ))
#define RtlOffsetToPointer( p1, p2 )    (PCHAR)((PCHAR)(p1) + (ULONG_PTR)(p2))
#define RtlPointerToOffset( p1, p2 )    (ULONG)((PCHAR)(p2) - (PCHAR)(p1))
#define SeLengthSid( x )                (8 + (4 * ((SID *)(x))->SubAuthorityCount))
#define SeDeleteClientSecurity( x ) \
    if( SeTokenType( (x)->ClientToken ) == TokenPrimary ) { \
        PsDereferencePrimaryToken( (x)->ClientToken ); \
    } else { \
        PsDereferenceImpersonationToken( (x)->ClientToken ); \
    }
#define SeStopImpersonatingClient()     PsRevertToSelf()
#define SeQuerySubjectContextToken( x ) \
    (((PSECURITY_SUBJECT_CONTEXT)(x))->ClientToken != NULL ? \
    ((PSECURITY_SUBJECT_CONTEXT)(x))->ClientToken : \
    ((PSECURITY_SUBJECT_CONTEXT)(x))->PrimaryToken)
#define IoIsFileOpenedExclusively( x ) \
    ((BOOLEAN)!((x)->SharedRead || (x)->SharedWrite || (x)->SharedDelete))
#define FsRtlFastLock( p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11 ) \
    FsRtlPrivateLock( p1, p2, p3, p4, p5, p6, p7, p8, p9, NULL, p10, p11 )
#define FsRtlAreThereCurrentFileLocks( x ) \
    ((x)->FastIoIsQuestionable)
#define FsRtlIncrementLockRequestsInProgress( x ) \
    { \
        ASSERT( (x)->LockRequestsInProgress >= 0 ); \
        InterlockedIncrement( (LONG volatile *)&((x)->LockRequestsInProgress) ); \
    }
#define FsRtlDecrementLockRequestsInProgress( x ) \
    { \
        ASSERT( (x)->LockRequestsInProgress > 0 ); \
        InterlockedDecrement( (LONG volatile *)&((x)->LockRequestsInProgress) ); \
    }
#define FsRtlTestAnsiCharacter( x, p1, p2, p3 ) \
    (((SCHAR)(x) < 0) ? p1 : ((*FsRtlLegalAnsiCharacterArray)[(x)] & \
    (p3) | ((p2) ? FSRTL_WILD_CHARACTER : 0)))
#define FsRtlIsAnsiCharacterWild( x ) \
    FsRtlTestAnsiCharacter( x, FALSE, FALSE, FSRTL_WILD_CHARACTER )
#define FsRtlIsAnsiCharacterLegalFat( x, p ) \
    FsRtlTestAnsiCharacter( x, TRUE, p, FSRTL_FAT_LEGAL )
#define FsRtlIsAnsiCharacterLegalHpfs( x, p ) \
    FsRtlTestAnsiCharacter( x, TRUE, p, FSRTL_HPFS_LEGAL )
#define FsRtlIsAnsiCharacterLegalNtfs( x, p ) \
    FsRtlTestAnsiCharacter( x, TRUE, p, FSRTL_NTFS_LEGAL )
#define FsRtlIsAnsiCharacterLegalNtfsStream( x, p ) \
    FsRtlTestAnsiCharacter( x, TRUE, p, FSRTL_NTFS_STREAM_LEGAL )
#define FsRtlIsAnsiCharacterLegal( x, p ) \
    FsRtlTestAnsiCharacter( x, TRUE, FALSE, p )
#define FsRtlIsLeadDbcsCharacter( x ) \
    ((BOOLEAN)((UCHAR)(x) < 0x80 ? FALSE : ((*NlsMbCodePageTag) && \
    ((*NlsOemLeadByteInfo)[(UCHAR)(x)] != 0))))
#define FsRtlAllocatePoolWithTag( p1, p2, p3 ) \
    ExAllocatePoolWithTag( (POOL_TYPE)((p1) | POOL_RAISE_IF_ALLOCATION_FAILURE), \
    p2, p3)
#define FsRtlAllocatePoolWithQuotaTag( p1, p2, p3 ) \
    ExAllocatePoolWithQuotaTag( (POOL_TYPE)((p1) | POOL_RAISE_IF_ALLOCATION_FAILURE), \
    p2, p3)
#define FsRtlIsUnicodeCharacterWild( x ) \
    (((x) >= 0x40) ? FALSE : ((*FsRtlLegalAnsiCharacterArray)[(x)] & \
    FSRTL_WILD_CHARACTER))
#define FsRtlInitPerFileContext( x, p1, p2, p3 ) \
    ((x)->OwnerId = (p1), (x)->InstanceId = (p2), (x)->FreeCallback = (p3))
#define FsRtlSupportsPerFileContexts( x ) \
    ((FsRtlGetPerStreamContextPointer( x ) != NULL) && \
    (FsRtlGetPerStreamContextPointer( x )->Version >= FSRTL_FCB_HEADER_V1) && \
    (FsRtlGetPerStreamContextPointer( x )->FileContextSupportPointer != NULL))
#define FsRtlGetPerFileContextPointer( x ) \
    (FsRtlSupportsPerFileContexts( x ) ? \
    FsRtlGetPerStreamContextPointer( x )->FileContextSupportPointer : NULL)
#define FsRtlSetupAdvancedHeaderEx( x, p1, p2 ) \
    { \
        FsRtlSetupAdvancedHeader( x, p1 ); \
        if( (p2) != NULL ) { \
            (x)->FileContextSupportPointer = (p2); \
        } \
    }
#define FsRtlInitPerStreamContext( x, p1, p2, p3 ) \
    ((x)->OwnerId = (p1), (x)->InstanceId = (p2), (x)->FreeCallback = (p3))
#define FsRtlGetPerStreamContextPointer( x ) \
    ((PFSRTL_ADVANCED_FCB_HEADER)((x)->FsContext))
#define FsRtlSupportsPerStreamContexts( x ) \
    ((FsRtlGetPerStreamContextPointer( x ) != NULL) && \
    (FsRtlGetPerStreamContextPointer( x )->Flags2 & \
    FSRTL_FLAG2_SUPPORTS_FILTER_CONTEXTS))
#define FsRtlLookupPerStreamContext( x, p1, p2 ) \
    ((((x) != NULL) && ((x)->Flags2 & FSRTL_FLAG2_SUPPORTS_FILTER_CONTEXTS) && \
    !IsListEmpty( &(x)->FilterContexts )) ? \
    FsRtlLookupPerStreamContextInternal( x, p1, p2 ) : NULL)
#define FsRtlInitPerFileObjectContext( x, p1, p2 ) \
    ((x)->OwnerId = (p1), (x)->InstanceId = (p2))
#define FsRtlCompleteRequest( x, p ) \
    { \
        (x)->IoStatus.Status = (p); \
        IoCompleteRequest( x, IO_DISK_INCREMENT ); \
    }
#define FsRtlEnterFileSystem()          KeEnterCriticalRegion()
#define FsRtlExitFileSystem()           KeLeaveCriticalRegion()
#define CcIsFileCached( x ) \
    (((x)->SectionObjectPointer != NULL) && \
    (((PSECTION_OBJECT_POINTERS)(x)->SectionObjectPointer)->SharedCacheMap != NULL))
#define CcGetFileSizePointer( x ) \
    ((PLARGE_INTEGER)((x)->SectionObjectPointer->SharedCacheMap) + 1)
#if (NTDDI_VERSION < 0x06010000)
    #define CcCopyWriteWontFlush( p1, p2, p3 ) ((p3) <= 0x00010000)
#endif
#define CcReadAhead( p1, p2, p3 ) \
    { \
        if( (p3) >= 256 ) { \
            CcScheduleReadAhead( p1, p2, p3 ); \
        } \
    }

/* Other macros */
#define LEGAL_ANSI_CHARACTER_ARRAY  (*FsRtlLegalAnsiCharacterArray)
#define NLS_OEM_LEAD_BYTE_INFO      (*NlsOemLeadByteInfo)

__inline void FsRtlSetupAdvancedHeader( PVOID x, PFAST_MUTEX p )
{
    PFSRTL_ADVANCED_FCB_HEADER v = (PFSRTL_ADVANCED_FCB_HEADER)x;
    v->Flags |= FSRTL_FLAG_ADVANCED_HEADER;
    v->Flags2 |= FSRTL_FLAG2_SUPPORTS_FILTER_CONTEXTS;
#if (NTDDI_VERSION >= 0x06000000)
    v->Version = FSRTL_FCB_HEADER_V1;
#else
    v->Version = FSRTL_FCB_HEADER_V0;
#endif
    InitializeListHead( &v->FilterContexts );
    if( p != NULL ) {
        v->FastMutex = p;
    }
#if (NTDDI_VERSION >= 0x06000000)
        *((PULONG_PTR)&v->PushLock) = 0;
        v->FileContextSupportPointer = NULL;
#endif
}

#if (NTDDI_VERSION >= 0x06000000)

__inline VOID IoInitializePriorityInfo( PIO_PRIORITY_INFO x )
{
    x->Size = sizeof( IO_PRIORITY_INFO );
    x->ThreadPriority = 0xFFFF;
    x->IoPriority = IoPriorityNormal;
    x->PagePriority = 0;
}

#endif /* (NTDDI_VERSION >= 0x06000000) */

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _NTIFS_ */
