/*
 *  wdm.h       Windows Driver Model (WDM) functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _WDMDDK_
#define _WDMDDK_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#define _ETW_KM_
#include <excpt.h>
#include <ntdef.h>
#include <ntstatus.h>
#include <bugcodes.h>
#include <ntiologc.h>
#include <driverspecs.h>
#include <string.h>
#include <ktmtypes.h>
#ifdef RUN_WPP
    #include <evntrace.h>
    #include <stdarg.h>
#endif
#include <evntprov.h>
#if (NTDDI_VERSION >= 0x06000000)
    #include <devpropdef.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Suppress inclusion of winnt.h. */
#define NT_INCLUDED

/* Support single-group legacy functions only under pre-Windows 7 or x86 or when
 * processor groups are disabled. */
#if (NTDDI_VERSION < 0x06010000) || defined( _X86_ ) || !defined( NT_PROCESSOR_GROUPS )
    #define SINGLE_GROUP_LEGACY_API 1
#endif

/* Macro to specify NT kernel and hardware abstraction layer functions */
#define NTKERNELAPI         DECLSPEC_IMPORT
#define NTHALAPI            DECLSPEC_IMPORT

/* Macro to specify common log file system functions */
#define CLFSUSER_API

/* Primitive data types */
typedef ULONG               ACCESS_MASK;
typedef ACCESS_MASK         *PACCESS_MASK;
typedef BOOLEAN             SECURITY_CONTEXT_TRACKING_MODE;
typedef BOOLEAN             *PSECURITY_CONTEXT_TRACKING_MODE;
typedef ULONG               SECURITY_INFORMATION;
typedef ULONG               *PSECURITY_INFORMATION;
typedef LONG                KPRIORITY;
typedef ULONG_PTR           KSPIN_LOCK;
typedef KSPIN_LOCK          *PKSPIN_LOCK;
typedef ULONG               EXECUTION_STATE;
typedef ULONG               *PEXECUTION_STATE;
typedef int                 CM_RESOURCE_TYPE;
typedef CCHAR               KPROCESSOR_MODE;
typedef PVOID               PKIPI_CONTEXT;
typedef ULONG_PTR           ERESOURCE_THREAD;
typedef ERESOURCE_THREAD    *PERESOURCE_THREAD;
typedef ULONG               PNP_DEVICE_STATE;
typedef ULONG               *PPNP_DEVICE_STATE;
typedef ULONG               OB_OPERATION;
typedef GUID                UOW;
typedef GUID                *PUOW;
typedef GUID                *PGUID;
typedef GUID                KCRM_PROTOCOL_ID;
typedef GUID                *PKCRM_PROTOCOL_ID;
#ifdef _X86_
typedef ULONG               PFN_COUNT;
typedef LONG                SPFN_NUMBER;
typedef LONG                *PSPFN_NUMBER;
typedef ULONG               PFN_NUMBER;
typedef ULONG               *PPFN_NUMBER;
#endif
#if (NTDDI_VERSION >= 0x05000000)
typedef ULONG               NODE_REQUIREMENT;
#endif
#if (NTDDI_VERSION >= 0x05020100)
typedef ULONG               CLFS_CONTAINER_ID;
typedef CLFS_CONTAINER_ID   *PCLFS_CONTAINER_ID;
typedef CLFS_CONTAINER_ID   **PPCLFS_CONTAINER_ID;
typedef ULONG               CLS_RECORD_TYPE;
typedef ULONG               *PCLS_RECORD_TYPE;
typedef ULONG               **PPCLS_RECORD_TYPE;
typedef CLS_RECORD_TYPE     CLFS_RECORD_TYPE;
typedef CLS_RECORD_TYPE     *PCLFS_RECORD_TYPE;
typedef CLS_RECORD_TYPE     **PPCLFS_RECORD_TYPE;
typedef GUID                CLFS_LOG_ID;
typedef UINT32              CLS_CONTAINER_STATE;
typedef UINT32              *PCLS_CONTAINER_STATE;
typedef UINT32              *PPCLS_CONTAINER_STATE;
typedef CLS_CONTAINER_STATE CLFS_CONTAINER_STATE;
typedef CLS_CONTAINER_STATE *PCLFS_CONTAINER_STATE;
typedef CLS_CONTAINER_STATE *PPCLFS_CONTAINER_STATE;
typedef UCHAR               CLFS_SCAN_MODE;
typedef UCHAR               *PCLFS_SCAN_MODE;
typedef PVOID               CLFS_MGMT_CLIENT;
typedef PVOID               *PCLFS_MGMT_CLIENT;
#endif

/* Device type data type */
#define DEVICE_TYPE ULONG

/* Address bases */
#define KADDRESS_BASE   0
#define UADDRESS_BASE   0

/* Standard access rights */
#define DELETE                      0x00010000L
#define READ_CONTROL                0x00020000L
#define WRITE_DAC                   0x00040000L
#define WRITE_OWNER                 0x00080000L
#define SYNCHRONIZE                 0x00100000L
#define STANDARD_RIGHTS_REQUIRED    0x000F0000L
#define STANDARD_RIGHTS_READ        READ_CONTROL
#define STANDARD_RIGHTS_WRITE       READ_CONTROL
#define STANDARD_RIGHTS_EXECUTE     READ_CONTROL
#define STANDARD_RIGHTS_ALL         0x001F0000L
#define SPECIFIC_RIGHTS_ALL         0x0000FFFFL
#define ACCESS_SYSTEM_SECURITY      0x01000000L
#define MAXIMUM_ALLOWED             0x02000000L
#define GENERIC_READ                0x80000000L
#define GENERIC_WRITE               0x40000000L
#define GENERIC_EXECUTE             0x20000000L
#define GENERIC_ALL                 0x10000000L

/* Current ACL revisions */
#define ACL_REVISION    2
#define ACL_REVISION_DS 4

/* All ACL revisions */
#define ACL_REVISION1       1
#define ACL_REVISION2       2
#define ACL_REVISION3       3
#define ACL_REVISION4       4
#define MIN_ACL_REVISION    ACL_REVISION2
#define MAX_ACL_REVISION    ACL_REVISION4

/* Current security descriptor revision */
#define SECURITY_DESCRIPTOR_REVISION    1

/* All security descriptor revisions */
#define SECURITY_DESCRIPTOR_REVISION1   1

/* Privilege attributes */
#define SE_PRIVILEGE_ENABLED_BY_DEFAULT 0x00000001L
#define SE_PRIVILEGE_ENABLED            0x00000002L
#define SE_PRIVILEGE_REMOVED            0x00000004L
#define SE_PRIVILEGE_USED_FOR_ACCESS    0x00000008L
#define SE_PRIVILEGE_VALID_ATTRIBUTES \
    (SE_PRIVILEGE_ENABLED_BY_DEFAULT | SE_PRIVILEGE_ENABLED | \
    SE_PRIVILEGE_REMOVED | SE_PRIVLEGE_USED_FOR_ACCESS)

/* Privilege set control flags */
#define PRIVILEGE_SET_ALL_NECESSARY 1

/* Well-known privileges */
#define SE_MIN_WELL_KNOWN_PRIVILEGE         2L
#define SE_CREATE_TOKEN_PRIVILEGE           2L
#define SE_ASSIGNPRIMARYTOKEN_PRIVILEGE     3L
#define SE_LOCK_MEMORY_PRIVILEGE            4L
#define SE_INCREASE_QUOTA_PRIVILEGE         5L
#define SE_MACHINE_ACCOUNT_PRIVILEGE        6L
#define SE_TCB_PRIVILEGE                    7L
#define SE_SECURITY_PRIVILEGE               8L
#define SE_TAKE_OWNERSHIP_PRIVILEGE         9L
#define SE_LOAD_DRIVER_PRIVILEGE            10L
#define SE_SYSTEM_PROFILE_PRIVILEGE         11L
#define SE_SYSTEMTIME_PRIVILEGE             12L
#define SE_PROF_SINGLE_PROCESS_PRIVILEGE    13L
#define SE_INC_BASE_PRIORITY_PRIVILEGE      14L
#define SE_CREATE_PAGEFILE_PRIVILEGE        15L
#define SE_CREATE_PERMANENT_PRIVILEGE       16L
#define SE_BACKUP_PRIVILEGE                 17L
#define SE_RESTORE_PRIVILEGE                18L
#define SE_SHUTDOWN_PRIVILEGE               19L
#define SE_DEBUG_PRIVILEGE                  20L
#define SE_AUDIT_PRIVILEGE                  21L
#define SE_SYSTEM_ENVIRONMENT_PRIVILEGE     22L
#define SE_CHANGE_NOTIFY_PRIVILEGE          23L
#define SE_REMOTE_SHUTDOWN_PRIVILEGE        24L
#define SE_UNDOCK_PRIVILEGE                 25L
#define SE_SYNC_AGENT_PRIVILEGE             26L
#define SE_ENABLE_DELEGATION_PRIVILEGE      27L
#define SE_MANAGE_VOLUME_PRIVILEGE          28L
#define SE_IMPERSONATE_PRIVILEGE            29L
#define SE_CREATE_GLOBAL_PRIVILEGE          30L
#define SE_TRUSTED_CREDMON_ACCESS_PRIVILEGE 31L
#define SE_RELABEL_PRIVILEGE                32L
#define SE_INC_WORKING_SET_PRIVILEGE        33L
#define SE_TIME_ZONE_PRIVILEGE              34L
#define SE_CREATE_SYMBOLIC_LINK_PRIVILEGE   35L
#define SE_MAX_WELL_KNOWN_PRIVILEGE         SE_CREATE_SYMBOLIC_LINK_PRIVILEGE

/* Security tracking modes */
#define SECURITY_DYNAMIC_TRACKING   TRUE
#define SECURITY_STATIC_TRACKING    FALSE

/* Security information types */
#define OWNER_SECURITY_INFORMATION              0x00000001L
#define GROUP_SECURITY_INFORMATION              0x00000002L
#define DACL_SECURITY_INFORMATION               0x00000004L
#define SACL_SECURITY_INFORMATION               0x00000008L
#define LABEL_SECURITY_INFORMATION              0x00000010L
#define PROTECTED_DACL_SECURITY_INFORMATION     0x80000000L
#define PROTECTED_SACL_SECURITY_INFORMATION     0x40000000L
#define UNPROTECTED_DACL_SECURITY_INFORMATION   0x20000000L
#define UNPROTECTED_SACL_SECURITY_INFORMATION   0x10000000L

/* Security audit object flags */
#define SE_ADT_OBJECT_ONLY  0x0001

/* Maximum numbers of audit parameters */
#define SE_MAX_AUDIT_PARAMETERS         32
#define SE_MAX_GENERIC_AUDIT_PARAMETERS 28

/* Security audit parameter flags */
#define SE_ADT_PARAMETERS_SELF_RELATIVE     0x00000001L
#define SE_ADT_PARAMETERS_SEND_TO_LSA       0x00000002L
#define SE_ADT_PARAMETER_EXTENSIBLE_AUDIT   0x00000004L
#define SE_ADT_PARAMETER_GENERIC_AUDIT      0x00000008L
#define SE_ADT_PARAMETER_WRITE_SYNCHRONOUS  0x00000010L

/* Priority levels */
#define LOW_PRIORITY            0L
#define LOW_REALTIME_PRIORITY   16L
#define HIGH_PRIORITY           31L
#define MAXIMUM_PRIORITY        32L

/* Extended save alignment */
#define XSAVE_ALIGN 64

/* Size of the extended registers in the x86 context record */
#ifdef _X86_
    #define MAXIMUM_SUPPORTED_EXTENSION 512
#endif

/* Lock queue flags */
#define LOCK_QUEUE_WAIT                 1
#define LOCK_QUEUE_WAIT_BIT             0
#define LOCK_QUEUE_OWNER                2
#define LOCK_QUEUE_OWNER_BIT            1
#define LOCK_QUEUE_TIMER_LOCK_SHIFT     4
#define LOCK_QUEUE_TIMER_TABLE_LOCKS    (1 << (8 - LOCK_QUEUE_TIMER_LOCK_SHIFT))

/* Device types */
#define FILE_DEVICE_BEEP                0x00000001L
#define FILE_DEVICE_CD_ROM              0x00000002L
#define FILE_DEVICE_CD_ROM_FILE_SYSTEM  0x00000003L
#define FILE_DEVICE_CONTROLLER          0x00000004L
#define FILE_DEVICE_DATALINK            0x00000005L
#define FILE_DEVICE_DFS                 0x00000006L
#define FILE_DEVICE_DISK                0x00000007L
#define FILE_DEVICE_DISK_FILE_SYSTEM    0x00000008L
#define FILE_DEVICE_FILE_SYSTEM         0x00000009L
#define FILE_DEVICE_INPORT_PORT         0x0000000AL
#define FILE_DEVICE_KEYBOARD            0x0000000BL
#define FILE_DEVICE_MAILSLOT            0x0000000CL
#define FILE_DEVICE_MIDI_IN             0x0000000DL
#define FILE_DEVICE_MIDI_OUT            0x0000000EL
#define FILE_DEVICE_MOUSE               0x0000000FL
#define FILE_DEVICE_MULTI_UNC_PROVIDER  0x00000010L
#define FILE_DEVICE_NAMED_PIPE          0x00000011L
#define FILE_DEVICE_NETWORK             0x00000012L
#define FILE_DEVICE_NETWORK_BROWSER     0x00000013L
#define FILE_DEVICE_NETWORK_FILE_SYSTEM 0x00000014L
#define FILE_DEVICE_NULL                0x00000015L
#define FILE_DEVICE_PARALLEL_PORT       0x00000016L
#define FILE_DEVICE_PHYSICAL_NETCARD    0x00000017L
#define FILE_DEVICE_PRINTER             0x00000018L
#define FILE_DEVICE_SCANNER             0x00000019L
#define FILE_DEVICE_SERIAL_MOUSE_PORT   0x0000001AL
#define FILE_DEVICE_SERIAL_PORT         0x0000001BL
#define FILE_DEVICE_SCREEN              0x0000001CL
#define FILE_DEVICE_SOUND               0x0000001DL
#define FILE_DEVICE_STREAMS             0x0000001EL
#define FILE_DEVICE_TAPE                0x0000001FL
#define FILE_DEVICE_TAPE_FILE_SYSTEM    0x00000020L
#define FILE_DEVICE_TRANSPORT           0x00000021L
#define FILE_DEVICE_UNKNOWN             0x00000022L
#define FILE_DEVICE_VIDEO               0x00000023L
#define FILE_DEVICE_VIRTUAL_DISK        0x00000024L
#define FILE_DEVICE_WAVE_IN             0x00000025L
#define FILE_DEVICE_WAVE_OUT            0x00000026L
#define FILE_DEVICE_8042_PORT           0x00000027L
#define FILE_DEVICE_NETWORK_REDIRECTOR  0x00000028L
#define FILE_DEVICE_BATTERY             0x00000029L
#define FILE_DEVICE_BUS_EXTENDER        0x0000002AL
#define FILE_DEVICE_MODEM               0x0000002BL
#define FILE_DEVICE_VDM                 0x0000002CL
#define FILE_DEVICE_MASS_STORAGE        0x0000002DL
#define FILE_DEVICE_SMB                 0x0000002EL
#define FILE_DEVICE_KS                  0x0000002FL
#define FILE_DEVICE_CHANGER             0x00000030L
#define FILE_DEVICE_SMARTCARD           0x00000031L
#define FILE_DEVICE_ACPI                0x00000032L
#define FILE_DEVICE_DVD                 0x00000033L
#define FILE_DEVICE_FULLSCREEN_VIDEO    0x00000034L
#define FILE_DEVICE_DFS_FILE_SYSTEM     0x00000035L
#define FILE_DEVICE_DFS_VOLUME          0x00000036L
#define FILE_DEVICE_SERENUM             0x00000037L
#define FILE_DEVICE_TERMSRV             0x00000038L
#define FILE_DEVICE_KSEC                0x00000039L
#define FILE_DEVICE_FIPS                0x0000003AL
#define FILE_DEVICE_INFINIBAND          0x0000003BL
#define FILE_DEVICE_VMBUS               0x0000003EL
#define FILE_DEVICE_CRYPT_PROVIDER      0x0000003FL
#define FILE_DEVICE_WPD                 0x00000040L
#define FILE_DEVICE_BLUETOOTH           0x00000041L
#define FILE_DEVICE_MT_COMPOSITE        0x00000042L
#define FILE_DEVICE_MT_TRANSPORT        0x00000043L
#define FILE_DEVICE_BIOMETRIC           0x00000044L
#define FILE_DEVICE_PMI                 0x00000045L

/* Buffering methods */
#define METHOD_BUFFERED             0L
#define METHOD_IN_DIRECT            1L
#define METHOD_OUT_DIRECT           2L
#define METHOD_NEITHER              3L
#define METHOD_DIRECT_TO_HARDWARE   METHOD_IN_DIRECT
#define METHOD_DIRECT_FROM_HARDWARE METHOD_OUT_DIRECT

/* File access types */
#define FILE_ANY_ACCESS     0x0000L
#define FILE_SPECIAL_ACCESS FILE_ANY_ACCESS
#define FILE_READ_ACCESS    0x0001L
#define FILE_WRITE_ACCESS   0x0002L

/* Macros to manipulate I/O control codes */
#define CTL_CODE( p1, p2, p3, p4 ) \
    (((p1) << 16) | ((p4) << 14) | ((p2) << 2) | (p3))
#define DEVICE_TYPE_FROM_CTL_CODE( x )  (((ULONG)(x & 0xFFFF0000L)) >> 16)
#define METHOD_FROM_CTL_CODE( x )       ((ULONG)(x & 0x00000003L))

/* File access rights */
#define FILE_READ_DATA              0x0001L
#define FILE_LIST_DIRECTORY         0x0001L
#define FILE_WRITE_DATA             0x0002L
#define FILE_ADD_FILE               0x0002L
#define FILE_APPEND_DATA            0x0004L
#define FILE_ADD_SUBDIRECTORY       0x0004L
#define FILE_CREATE_PIPE_INSTANCE   0x0004L
#define FILE_READ_EA                0x0008L
#define FILE_WRITE_EA               0x0010L
#define FILE_EXECUTE                0x0020L
#define FILE_TRAVERSE               0x0020L
#define FILE_DELETE_CHILD           0x0040L
#define FILE_READ_ATTRIBUTES        0x0080L
#define FILE_WRITE_ATTRIBUTES       0x0100L
#define FILE_ALL_ACCESS             (STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | 0x01FFL)
#define FILE_GENERIC_READ \
    (STANDARD_RIGHTS_READ | SYNCHRONIZE | FILE_READ_DATA | FILE_READ_ATTRIBUTES | \
    FILE_READ_EA)
#define FILE_GENERIC_WRITE \
    (STANDARD_RIGHTS_WRITE | SYNCHRONIZE | FILE_WRITE_DATA | FILE_WRITE_ATTRIBUTES | \
    FILE_WRITE_EA | FILE_APPEND_DATA)
#define FILE_GENERIC_EXECUTE \
    (STANDARD_RIGHTS_EXECUTE | SYNCHRONIZE | FILE_READ_ATTRIBUTES | FILE_EXECUTE)

/* File sharing options */
#define FILE_SHARE_READ     0x00000001L
#define FILE_SHARE_WRITE    0x00000002L
#define FILE_SHARE_DELETE   0x00000004L

/* File attributes */
#define FILE_ATTRIBUTE_READONLY             0x00000001L
#define FILE_ATTRIBUTE_HIDDEN               0x00000002L
#define FILE_ATTRIBUTE_SYSTEM               0x00000004L
#define FILE_ATTRIBUTE_DIRECTORY            0x00000010L
#define FILE_ATTRIBUTE_ARCHIVE              0x00000020L
#define FILE_ATTRIBUTE_DEVICE               0x00000040L
#define FILE_ATTRIBUTE_NORMAL               0x00000080L
#define FILE_ATTRIBUTE_TEMPORARY            0x00000100L
#define FILE_ATTRIBUTE_SPARSE_FILE          0x00000200L
#define FILE_ATTRIBUTE_REPARSE_POINT        0x00000400L
#define FILE_ATTRIBUTE_COMPRESSED           0x00000800L
#define FILE_ATTRIBUTE_OFFLINE              0x00001000L
#define FILE_ATTRIBUTE_NOT_CONTENT_INDEXED  0x00002000L
#define FILE_ATTRIBUTE_ENCRYPTED            0x00004000L
#define FILE_ATTRIBUTE_VIRTUAL              0x00010000L
#if (NTDDI_VERSION >= 0x05020100)
    #define FILE_ATTRIBUTE_DEDICATED        FILE_ATTRIBUTE_TEMPORARY
#endif

/* File creation dispositions */
#define FILE_SUPERSEDE              0x00000000L
#define FILE_OPEN                   0x00000001L
#define FILE_CREATE                 0x00000002L
#define FILE_OPEN_IF                0x00000003L
#define FILE_OVERWRITE              0x00000004L
#define FILE_OVERWRITE_IF           0x00000005L
#define FILE_MAXIMUM_DISPOSITION    0x00000005L

/* File open/create option flags */
#define FILE_DIRECTORY_FILE             0x00000001L
#define FILE_WRITE_THROUGH              0x00000002L
#define FILE_SEQUENTIAL_ONLY            0x00000004L
#define FILE_NO_INTERMEDIATE_BUFFERING  0x00000008L
#define FILE_SYNCHRONOUS_IO_ALERT       0x00000010L
#define FILE_SYNCHRONOUS_IO_NONALERT    0x00000020L
#define FILE_NON_DIRECTORY_FILE         0x00000040L
#define FILE_CREATE_TREE_CONNECTION     0x00000080L
#define FILE_COMPLETE_IF_OPLOCKED       0x00000100L
#define FILE_NO_EA_KNOWLEDGE            0x00000200L
#define FILE_OPEN_REMOTE_INSTANCE       0x00000400L
#define FILE_RANDOM_ACCESS              0x00000800L
#define FILE_DELETE_ON_CLOSE            0x00001000L
#define FILE_OPEN_BY_FILE_ID            0x00002000L
#define FILE_OPEN_FOR_BACKUP_INTENT     0x00004000L
#define FILE_NO_COMPRESSION             0x00008000L
#if (NTDDI_VERSION >= 0x06010000)
    #define FILE_OPEN_REQUIRING_OPLOCK  0x00010000L
    #define FILE_DISALLOW_EXCLUSIVE     0x00020000L
#endif
#define FILE_RESERVE_OPFILTER           0x00100000L
#define FILE_OPEN_REPARSE_POINT         0x00200000L
#define FILE_OPEN_NO_RECALL             0x00400000L
#define FILE_OPEN_FOR_FREE_SPACE_QUERY  0x00800000L
#define FILE_VALID_OPTION_FLAGS         0x00FFFFFFL
#define FILE_VALID_PIPE_OPTION_FLAGS    0x00000032L
#define FILE_VALID_MAILSLOT_OPTION_FLAGS    0x00000032L
#define FILE_VALID_SET_FLAGS            0x00000036L

/* File open/create return values */
#define FILE_SUPERSEDED     0x00000000L
#define FILE_OPENED         0x00000001L
#define FILE_CREATED        0x00000002L
#define FILE_OVERWRITTEN    0x00000003L
#define FILE_EXISTS         0x00000004L
#define FILE_DOES_NOT_EXIST 0x00000005L

/* File byte offset parameters */
#define FILE_WRITE_TO_END_OF_FILE       0xFFFFFFFFL
#define FILE_USE_FILE_POINTER_POSITION  0xFFFFFFFEL

/* File alignments */
#define FILE_BYTE_ALIGNMENT     0x00000000L
#define FILE_WORD_ALIGNMENT     0x00000001L
#define FILE_LONG_ALIGNMENT     0x00000003L
#define FILE_QUAD_ALIGNMENT     0x00000007L
#define FILE_OCTA_ALIGNMENT     0x0000000FL
#define FILE_32_BYTE_ALIGNMENT  0x0000001FL
#define FILE_64_BYTE_ALIGNMENT  0x0000003FL
#define FILE_128_BYTE_ALIGNMENT 0x0000007FL
#define FILE_256_BYTE_ALIGNMENT 0x000000FFL
#define FILE_512_BYTE_ALIGNMENT 0x000001FFL

/* Maximum file name length */
#define MAXIMUM_FILENAME_LENGTH 256

/* File device characteristics */
#define FILE_REMOVABLE_MEDIA                0x00000001L
#define FILE_READ_ONLY_DEVICE               0x00000002L
#define FILE_FLOPPY_DISKETTE                0x00000004L
#define FILE_WRITE_ONCE_MEDIA               0x00000008L
#define FILE_REMOTE_DEVICE                  0x00000010L
#define FILE_DEVICE_IS_MOUNTED              0x00000020L
#define FILE_VIRTUAL_VOLUME                 0x00000040L
#define FILE_AUTOGENERATED_DEVICE_NAME      0x00000080L
#define FILE_DEVICE_SECURE_OPEN             0x00000100L
#define FILE_CHARACTERISTIC_PNP_DEVICE      0x00000800L
#define FILE_CHARACTERISTIC_TS_DEVICE       0x00001000L
#define FILE_CHARACTERISTIC_WEBDAV_DEVICE   0x00002000L

/* I/O session state event flags */
#define IO_SESSION_STATE_ALL_EVENTS         0xFFFFFFFFL
#define IO_SESSION_STATE_CREATION_EVENT     0x00000001L
#define IO_SESSION_STATE_TERMINATION_EVENT  0x00000002L
#define IO_SESSION_STATE_CONNECT_EVENT      0x00000004L
#define IO_SESSION_STATE_DISCONNECT_EVENT   0x00000008L
#define IO_SESSION_STATE_LOGON_EVENT        0x00000010L
#define IO_SESSION_STATE_LOGOFF_EVENT       0x00000020L
#define IO_SESSION_STATE_VALID_EVENT_MASK   0x0000003FL

/* I/O session maximum payload size */
#define IO_SESSION_MAX_PAYLOAD_SIZE 256

/* File I/O completion notification flags */
#define FILE_SKIP_COMPLETION_PORT_ON_SUCCESS    0x00000001L
#define FILE_SKIP_SET_EVENT_ON_HANDLE           0x00000002L
#define FILE_SKIP_SET_USER_EVENT_ON_FAST_IO     0x00000004L

/* Registry key access rights */
#define KEY_QUERY_VALUE         0x0001L
#define KEY_SET_VALUE           0x0002L
#define KEY_CREATE_SUB_KEY      0x0004L
#define KEY_ENUMERATE_SUB_KEYS  0x0008L
#define KEY_NOTIFY              0x0010L
#define KEY_CREATE_LINK         0x0020L
#define KEY_WOW64_64KEY         0x0100L
#define KEY_WOW64_32KEY         0x0200L
#define KEY_WOW64_RES           0x0300L
#define KEY_ALL_ACCESS          (STANDARD_RIGHTS_REQUIRED | 0x003FL)
#define KEY_READ \
    (STANDARD_RIGHTS_READ | KEY_QUERY_VALUE | KEY_ENUMERATE_SUB_KEYS | KEY_NOTIFY)
#define KEY_WRITE \
    (STANDARD_RIGHTS_WRITE | KEY_SET_VALUE | KEY_CREATE_SUB_KEY)
#define KEY_EXECUTE             KEY_READ

/* Registry key open/create flags */
#define REG_OPTION_RESERVED         0x00000000L
#define REG_OPTION_NON_VOLATILE     0x00000000L
#define REG_OPTION_VOLATILE         0x00000001L
#define REG_OPTION_CREATE_LINK      0x00000002L
#define REG_OPTION_BACKUP_RESTORE   0x00000004L
#define REG_OPTION_OPEN_LINK        0x00000008L
#define REG_LEGAL_OPTION \
    (REG_OPTION_RESERVED | REG_OPTION_NON_VOLATILE | REG_OPTION_VOLATILE | \
    REG_OPTION_CREATE_LINK | REG_OPTION_BACKUP_RESTORE | REG_OPTION_OPEN_LINK)
#define REG_OPEN_LEGAL_OPTION \
    (REG_OPTION_RESERVED | REG_OPTION_BACKUP_RESTORE | REG_OPTION_OPEN_LINK)

/* Registry key open/create dispositions */
#define REG_CREATED_NEW_KEY     0x00000001L
#define REG_OPENED_EXISTING_KEY 0x00000002L

/* Registry hive formats */
#define REG_STANDARD_FORMAT 0x00000001L
#define REG_LATEST_FORMAT   0x00000002L
#define REG_NO_COMPRESSION  0x00000004L

/* Registry key restore flags */
#define REG_WHOLE_HIVE_VOLATILE     0x00000001L
#define REG_REFRESH_HIVE            0x00000002L
#define REG_NO_LAZY_FLUSH           0x00000004L
#define REG_FORCE_RESTORE           0x00000008L
#define REG_APP_HIVE                0x00000010L
#define REG_PROCESS_PRIVATE         0x00000020L
#define REG_START_JOURNAL           0x00000040L
#define REG_HIVE_EXACT_FILE_GROWTH  0x00000080L
#define REG_HIVE_NO_RM              0x00000100L
#define REG_HIVE_SINGLE_LOG         0x00000200L
#define REG_BOOT_HIVE               0x00000400L

/* Registry unload flags */
#define REG_FORCE_UNLOAD    1L

/* Registry key change notification flags */
#define REG_NOTIFY_CHANGE_NAME          0x00000001L
#define REG_NOTIFY_CHANGE_ATTRIBUTES    0x00000002L
#define REG_NOTIFY_CHANGE_LAST_SET      0x00000004L
#define REG_NOTIFY_CHANGE_SECURITY      0x00000008L
#define REG_LEGAL_CHANGE_FILTER \
    (REG_NOTIFY_CHANGE_NAME | REG_NOTIFY_CHANGE_ATTRIBUTES | \
    REG_NOTIFY_CHANGE_LAST_SET | REG_NOTIFY_CHANGE_SECURITY)

/* Object name path separator */
#define OBJ_NAME_PATH_SEPARATOR L'\\'

/* Object type access rights */
#define OBJECT_TYPE_CREATE      0x0001L
#define OBJECT_TYPE_ALL_ACCESS  (STANDARD_RIGHTS_REQUIRED | 0x0001L)

/* Directory access rights */
#define DIRECTORY_QUERY                 0x0001L
#define DIRECTORY_TRAVERSE              0x0002L
#define DIRECTORY_CREATE_OBJECT         0x0004L
#define DIRECTORY_CREATE_SUBDIRECTORY   0x0008L
#define DIRECTORY_ALL_ACCESS            (STANDARD_RIGHTS_REQUIRED | 0x000FL)

/* Symbolic link access rights */
#define SYMBOLIC_LINK_QUERY         0x0001L
#define SYMBOLIC_LINK_ALL_ACCESS    (STANDARD_RIGHTS_REQUIRED | 0x0001L)

/* Duplication flags */
#define DUPLICATE_CLOSE_SOURCE      0x00000001L
#define DUPLICATE_SAME_ACCESS       0x00000002L
#define DUPLICATE_SAME_ATTRIBUTES   0x00000004L

/* Section access rights */
#define SECTION_QUERY                   0x0001L
#define SECTION_MAP_WRITE               0x0002L
#define SECTION_MAP_READ                0x0004L
#define SECTION_MAP_EXECUTE             0x0008L
#define SECTION_EXTEND_SIZE             0x0010L
#define SECTION_MAP_EXECUTE_EXPLICIT    0x0020L
#define SECTION_ALL_ACCESS              (STANDARD_RIGHTS_REQUIRED | 0x001F)

/* Session access rights */
#define SESSION_QUERY_ACCESS    0x0001L
#define SESSION_MODIFY_ACCESS   0x0002L
#define SESSION_ALL_ACCESS      (STANDARD_RIGHTS_REQUIRED | 0x0003L)

/* Segment access rights */
#define SEGMENT_ALL_ACCESS  SECTION_ALL_ACCESS

/* Memory protection and allocation flags */
#define PAGE_NOACCESS           0x00000001L
#define PAGE_READONLY           0x00000002L
#define PAGE_READWRITE          0x00000004L
#define PAGE_WRITECOPY          0x00000008L
#define PAGE_EXECUTE            0x00000010L
#define PAGE_EXECUTE_READ       0x00000020L
#define PAGE_EXECUTE_READWRITE  0x00000040L
#define PAGE_EXECUTE_WRITECOPY  0x00000080L
#define PAGE_GUARD              0x00000100L
#define PAGE_NOCACHE            0x00000200L
#define PAGE_WRITECOMBINE       0x00000400L
#define MEM_COMMIT              0x00001000L
#define MEM_RESERVE             0x00002000L
#define MEM_DECOMMIT            0x00004000L
#define MEM_RELEASE             0x00008000L
#define MEM_FREE                0x00010000L
#define MEM_PRIVATE             0x00020000L
#define MEM_MAPPED              0x00040000L
#define MEM_RESET               0x00080000L
#define MEM_TOP_DOWN            0x00100000L
#define MEM_LARGE_PAGES         0x20000000L
#define MEM_4MB_PAGES           0x80000000L
#define SEC_RESERVE             0x04000000L
#define SEC_COMMIT              0x08000000L
#define SEC_LARGE_PAGES         0x80000000L

/* Process access rights */
#define PROCESS_DUP_HANDLE                  0x0040L
#if (NTDDI_VERSION >= 0x06000000)
    #define PROCESS_ALL_ACCESS \
        (STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | 0xFFFFL)
#else
    #define PROCESS_ALL_ACCESS \
        (STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | 0x0FFFL)
#endif

/* Maximum number of processors */
#define MAXIMUM_PROC_PER_GROUP  32
#define MAXIMUM_PROCESSORS      MAXIMUM_PROC_PER_GROUP

/* Thread access rights */
#define THREAD_TERMINATE                    0x0001L
#define THREAD_SUSPEND_RESUME               0x0002L
#define THREAD_ALERT                        0x0004L
#define THREAD_GET_CONTEXT                  0x0008L
#define THREAD_SET_CONTEXT                  0x0010L
#define THREAD_SET_INFORMATION              0x0020L
#define THREAD_SET_LIMITED_INFORMATION      0x0400L
#define THREAD_QUERY_LIMITED_INFORMATION    0x0800L
#if (NTDDI_VERSION >= 0x06000000)
    #define THREAD_ALL_ACCESS \
        (STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | 0xFFFFL)
#else
    #define THREAD_ALL_ACCESS \
        (STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | 0x03FFL)
#endif

/* Maximum power state value */
#define POWER_SYSTEM_MAXIMUM    7

/* Battery device I/O control codes */
#define IOCTL_QUERY_DEVICE_POWER_STATE \
    CTL_CODE( FILE_DEVICE_BATTERY, 0x0000, METHOD_BUFFERED, FILE_READ_ACCESS )
#define IOCTL_SET_DEVICE_WAKE \
    CTL_CODE( FILE_DEVICE_BATTERY, 0x0001, METHOD_BUFFERED, FILE_WRITE_ACCESS )
#define IOCTL_CANCEL_DEVICE_WAKE \
    CTL_CODE( FILE_DEVICE_BATTERY, 0x0002, METHOD_BUFFERED, FILE_WRITE_ACCESS )

/* Execution state values */
#define ES_SYSTEM_REQUIRED      0x00000001L
#define ES_DISPLAY_REQUIRED     0x00000002L
#define ES_USER_PRESENT         0x00000004L
#define ES_AWAYMODE_REQUIRED    0x00000040L
#define ES_CONTINUOUS           0x80000000L

/* Diagnostic reason version number */
#if (_WIN32_WINNT >= 0x0601)
    #define DIAGNOSTIC_REASON_VERSION   0L
#endif

/* Diagnostic reason flags */
#if (_WIN32_WINNT >= 0x0601)
    #define DIAGNOSTIC_REASON_SIMPLE_STRING     0x00000001L
    #define DIAGNOSTIC_REASON_DETAILED_STRING   0x00000002L
    #define DIAGNOSTIC_REASON_NOT_SPECIFIED     0x80000000L
#endif

/* Power request context version number */
#define POWER_REQUEST_CONTEXT_VERSION   0L

/* Power request context flags */
#define POWER_REQUEST_CONTEXT_SIMPLE_STRING     0x00000001L
#define POWER_REQUEST_CONTEXT_DETAILED_STRING   0x00000002L

/* Device power capabilities */
#if (NTDDI_VERSION >= 0x05010000)
    #define PDCAP_D0_SUPPORTED              0x00000001L
    #define PDCAP_D1_SUPPORTED              0x00000002L
    #define PDCAP_D2_SUPPORTED              0x00000004L
    #define PDCAP_D3_SUPPORTED              0x00000008L
    #define PDCAP_WAKE_FROM_D0_SUPPORTED    0x00000010L
    #define PDCAP_WAKE_FROM_D1_SUPPORTED    0x00000020L
    #define PDCAP_WAKE_FROM_D2_SUPPORTED    0x00000040L
    #define PDCAP_WAKE_FROM_D3_SUPPORTED    0x00000080L
    #define PDCAP_WARM_EJECT_SUPPORTED      0x00000100L
#endif

/* Registry value types */
#define REG_NONE                        0L
#define REG_SZ                          1L
#define REG_EXPAND_SZ                   2L
#define REG_BINARY                      3L
#define REG_DWORD                       4L
#define REG_DWORD_LITTLE_ENDIAN         4L
#define REG_DWORD_BIG_ENDIAN            5L
#define REG_LINK                        6L
#define REG_MULTI_SZ                    7L
#define REG_RESOURCE_LIST               8L
#define REG_FULL_RESOURCE_DESCRIPTOR    9L
#define REG_RESOURCE_REQUIREMENTS_LIST  10L
#define REG_QWORD                       11L
#define REG_QWORD_LITTLE_ENDIAN         11L

/* Service types */
#define SERVICE_KERNEL_DRIVER       0x00000001L
#define SERVICE_FILE_SYSTEM_DRIVER  0x00000002L
#define SERVICE_ADAPTER             0x00000004L
#define SERVICE_RECOGNIZER_DRIVER   0x00000008L
#define SERVICE_DRIVER \
    (SERVICE_KERNEL_DRIVER | SERVICE_FILE_SYSTEM_DRIVER | SERVICE_RECOGNIZER_DRIVER)
#define SERVICE_WIN32_OWN_PROCESS   0x00000010L
#define SERVICE_WIN32_SHARE_PROCESS 0x00000020L
#define SERVICE_WIN32 \
    (SERVICE_WIN32_OWN_PROCESS | SERVICE_WIN32_SHARE_PROCESS)
#define SERVICE_INTERACTIVE_PROCESS 0x00000100L
#define SERVICE_TYPE_ALL \
    (SERVICE_WIN32 | SERVICE_ADAPTER | SERVICE_DRIVER | SERVICE_INTERACTIVE_PROCESS)

/* Service start types */
#define SERVICE_BOOT_START      0x00000000L
#define SERVICE_SYSTEM_START    0x00000001L
#define SERVICE_AUTO_START      0x00000002L
#define SERVICE_DEMAND_START    0x00000003L
#define SERVICE_DISABLED        0x00000004L

/* Service error control types */
#define SERVICE_ERROR_IGNORE    0x00000000L
#define SERVICE_ERROR_NORMAL    0x00000001L
#define SERVICE_ERROR_SEVERE    0x00000002L
#define SERVICE_ERROR_CRITICAL  0x00000003L

/* Service node flags */
#define CM_SERVICE_NETWORK_BOOT_LOAD        0x00000001L
#define CM_SERVICE_VIRTUAL_DISK_BOOT_LOAD   0x00000002L
#define CM_SERVICE_USB_DISK_BOOT_LOAD       0x00000004L
#define CM_SERVICE_VALID_PROMOTION_MASK \
    (CM_SERVICE_NETWORK_BOOT_LOAD | CM_SERVICE_VIRTUAL_DISK_BOOT_LOAD | \
    CM_SERVICE_USB_DISK_BOOT_LOAD)

/* Resource types */
#define CmResourceTypeNull              0
#define CmResourceTypePort              1
#define CmResourceTypeInterrupt         2
#define CmResourceTypeMemory            3
#define CmResourceTypeDma               4
#define CmResourceTypeDeviceSpecific    5
#define CmResourceTypeBusNumber         6
#define CmResourceTypeMemoryLarge       7
#define CmResourceTypeNonArbitrated     128
#define CmResourceTypeConfigData        128
#define CmResourceTypeDevicePrivate     129
#define CmResourceTypePcCardConfig      130
#define CmResourceTypeMfCardConfig      131

/* Resource interrupt flags */
#define CM_RESOURCE_INTERRUPT_LEVEL_SENSITIVE   0
#define CM_RESOURCE_INTERRUPT_LATCHED           1
#define CM_RESOURCE_INTERRUPT_MESSAGE           2
#define CM_RESOURCE_INTERRUPT_POLICY_INCLUDED   4

/* Resource interrupt level flags */
#define CM_RESOURCE_INTERRUPT_LEVEL_LATCHED_BITS    0x0001

/* Resource interrupt messages */
#define CM_RESOURCE_INTERRUPT_MESSAGE_TOKEN ((ULONG)-2)

/* Resource memory flags */
#define CM_RESOURCE_MEMORY_READ_WRITE           0x0000
#define CM_RESOURCE_MEMORY_READ_ONLY            0x0001
#define CM_RESOURCE_MEMORY_WRITE_ONLY           0x0002
#define CM_RESOURCE_MEMORY_WRITEABILITY_MASK    0x0003
#define CM_RESOURCE_MEMORY_PREFETCHABLE         0x0004
#define CM_RESOURCE_MEMORY_COMBINEDWRITE        0x0008
#define CM_RESOURCE_MEMORY_24                   0x0010
#define CM_RESOURCE_MEMORY_CACHEABLE            0x0020
#define CM_RESOURCE_MEMORY_WINDOW_DECODE        0x0040
#define CM_RESOURCE_MEMORY_BAR                  0x0080
#define CM_RESOURCE_MEMORY_COMPAT_FOR_INACCESSIBLE_RANGE    0x0100
#define CM_RESOURCE_MEMORY_LARGE                0x0E00
#define CM_RESOURCE_MEMORY_LARGE_40             0x0200
#define CM_RESOURCE_MEMORY_LARGE_48             0x0400
#define CM_RESOURCE_MEMORY_LARGE_64             0x0800

/* Resource memory maximum lengths */
#define CM_RESOURCE_MEMORY_LARGE_40_MAXLEN  0x000000FFFFFFFF00LL
#define CM_RESOURCE_MEMORY_LARGE_48_MAXLEN  0x0000FFFFFFFF0000LL
#define CM_RESOURCE_MEMORY_LARGE_64_MAXLEN  0xFFFFFFFF00000000LL

/* Resource port flags */
#define CM_RESOURCE_PORT_MEMORY             0x0000
#define CM_RESOURCE_PORT_IO                 0x0001
#define CM_RESOURCE_PORT_10_BIT_DECODE      0x0004
#define CM_RESOURCE_PORT_12_BIT_DECODE      0x0008
#define CM_RESOURCE_PORT_16_BIT_DECODE      0x0010
#define CM_RESOURCE_PORT_POSITIVE_DECODE    0x0020
#define CM_RESOURCE_PORT_PASSIVE_DECODE     0x0040
#define CM_RESOURCE_PORT_WINDOW_DECODE      0x0080
#define CM_RESOURCE_PORT_BAR                0x0100

/* Resource DMA flags */
#define CM_RESOURCE_DMA_8           0x0000
#define CM_RESOURCE_DMA_16          0x0001
#define CM_RESOURCE_DMA_32          0x0002
#define CM_RESOURCE_DMA_8_AND_16    0x0004
#define CM_RESOURCE_DMA_BUS_MASTER  0x0008
#define CM_RESOURCE_DMA_TYPE_A      0x0010
#define CM_RESOURCE_DMA_TYPE_B      0x0020
#define CM_RESOURCE_DMA_TYPE_F      0x0040

/* EISA function information masks */
#define EISA_FUNCTION_ENABLED       0x80
#define EISA_FREE_FORM_DATA         0x40
#define EISA_HAS_PORT_INIT_ENTRY    0x20
#define EISA_HAS_PORT_RANGE         0x10
#define EISA_HAS_DMA_ENTRY          0x08
#define EISA_HAS_IRQ_ENTRY          0x04
#define EISA_HAS_MEMORY_ENTRY       0x02
#define EISA_HAS_TYPE_ENTRY         0x01
#define EISA_HAS_INFORMATION \
    (EISA_HAS_PORT_RANGE + EISA_HAS_DMA_ENTRY + EISA_HAS_IRQ_ENTRY + \
    EISA_HAS_MEMORY_ENTRY + EISA_HAS_TYPE_ENTRY)

/* EISA memory configuration masks */
#define EISA_MORE_ENTRIES       0x80
#define EISA_SYSTEM_MEMORY      0x00
#define EISA_MEMORY_TYPE_RAM    0x01

/* EISA BIOS call return codes */
#define EISA_INVALID_SLOT           0x80
#define EISA_INVALID_FUNCTION       0x81
#define EISA_INVALID_CONFIGURATION  0x82
#define EISA_EMPTY_SLOT             0x83
#define EISA_INVALID_BIOS_CALL      0x86

/* I/O resource options */
#define IO_RESOURCE_PREFERRED   0x01
#define IO_RESOURCE_DEFAULT     0x02
#define IO_RESOURCE_ALTERNATIVE 0x08

/* Query registry flags */
#define RTL_QUERY_REGISTRY_SUBKEY   0x00000001L
#define RTL_QUERY_REGISTRY_TOPKEY   0x00000002L
#define RTL_QUERY_REGISTRY_REQUIRED 0x00000004L
#define RTL_QUERY_REGISTRY_NOVALUE  0x00000008L
#define RTL_QUERY_REGISTRY_NOEXPAND 0x00000010L
#define RTL_QUERY_REGISTRY_DIRECT   0x00000020L
#define RTL_QUERY_REGISTRY_DELETE   0x00000040L
#define RTL_QUERY_REGISTRY_NOSTRING 0x00000080L

/* Registry relative to values */
#define RTL_REGISTRY_ABSOLUTE   0L
#define RTL_REGISTRY_SERVICES   1L
#define RTL_REGISTRY_CONTROL    2L
#define RTL_REGISTRY_WINDOWS_NT 3L
#define RTL_REGISTRY_DEVICEMAP  4L
#define RTL_REGISTRY_USER       5L
#define RTL_REGISTRY_MAXIMUM    6L
#define RTL_REGISTRY_HANDLE     0x40000000L
#define RTL_REGISTRY_OPTIONAL   0x80000000L

/* RtlHashUnicodeString() algorithms */
#define HASH_STRING_ALGORITHM_DEFAULT   0L
#define HASH_STRING_ALGORITHM_X65599    1L
#define HASH_STRING_ALGORITHM_INVALID   0xFFFFFFFFL

/* DbgBreakPointWithStatus() status values */
#define DBG_STATUS_CONTROL_C        1L
#define DBG_STATUS_SYSRQ            2L
#define DBG_STATUS_BUGCHECK_FIRST   3L
#define DBG_STATUS_BUGCHECK_SECOND  4L
#define DBG_STATUS_FATAL            5L
#define DBG_STATUS_DEBUG_CONTROL    6L
#define DBG_STATUS_WORKER           7L

/* Sizes and masks */
#define SHORT_SIZE      sizeof( USHORT )
#define SHORT_MASK      (SHORT_SIZE - 1)
#define LONG_SIZE       sizeof( LONG )
#define LONGLONG_SIZE   sizeof( LONGLONG )
#define LONG_MASK       (LONG_SIZE - 1)
#define LONGLONG_MASK   (LONGLONG_SIZE - 1)
#define LOWBYTE_MASK    0x00FF

/* Macros to extract bytes */
#define FIRSTBYTE( x )  ((x) & LOWBYTE_MASK)
#define SECONDBYTE( x ) (((x) >> 8) & LOWBYTE_MASK)
#define THIRDBYTE( x )  (((x) >> 16) & LOWBYTE_MASK)
#define FOURTHBYTE( x ) (((x) >> 24) & LOWBYTE_MASK)

/* Bit indices */
#define SHORT_LEAST_SIGNIFICANT_BIT     0
#define SHORT_MOST_SIGNIFICANT_BIT      1
#define LONG_LEAST_SIGNIFICANT_BIT      0
#define LONG_3RD_MOST_SIGNIFICANT_BIT   1
#define LONG_2ND_MOST_SIGNIFICANT_BIT   2
#define LONG_MOST_SIGNIFICANT_BIT       3

/* Transaction manager access rights */
#define TRANSACTIONMANAGER_QUERY_INFORMATION    0x0001L
#define TRANSACTIONMANAGER_SET_INFORMATION      0x0002L
#define TRANSACTIONMANAGER_RECOVER              0x0004L
#define TRANSACTIONMANAGER_RENAME               0x0008L
#define TRANSACTIONMANAGER_CREATE_RM            0x0010L
#define TRANSACTIONMANAGER_BIND_TRANSACTION     0x0020L
#define TRANSACTIONMANAGER_GENERIC_READ \
    (STANDARD_RIGHTS_READ | TRANSACTIONMANAGER_QUERY_INFORMATION)
#define TRANSACTIONMANAGER_GENERIC_WRITE \
    (STANDARD_RIGHTS_WRITE | TRANSACTIONMANAGER_SET_INFORMATION | \
    TRANSACTIONMANAGER_RECOVER | TRANSACTIONMANAGER_RENAME | \
    TRANSACTIONMANAGER_CREATE_RM)
#define TRANSACTIONMANAGER_GENERIC_EXECUTE      STANDARD_RIGHTS_EXECUTE
#define TRANSACTIONMANAGER_ALL_ACCESS \
    (STANDARD_RIGHTS_REQUIRED | TRANSACTIONMANAGER_GENERIC_READ | \
    TRANSACTIONMANAGER_GENERIC_WRITE | TRANSACTIONMANAGER_GENERIC_EXECUTE | \
    TRANSACTIONMANAGER_BIND_TRANSACTION)

/* Transaction access rights */
#define TRANSACTION_QUERY_INFORMATION   0x0001L
#define TRANSACTION_SET_INFORMATION     0x0002L
#define TRANSACTION_ENLIST              0x0004L
#define TRANSACTION_COMMIT              0x0008L
#define TRANSACTION_ROLLBACK            0x0010L
#define TRANSACTION_PROPAGATE           0x0020L
#define TRANSACTION_GENERIC_READ \
    (STANDARD_RIGHTS_READ | TRANSACTION_QUERY_INFORMATION | SYNCHRONIZE)
#define TRANSACTION_GENERIC_WRITE \
    (STANDARD_RIGHTS_WRITE | TRANSACTION_SET_INFORMATION | TRANSACTION_COMMIT | \
    TRANSACTION_ENLIST | TRANSACTION_ROLLBACK | TRANSACTION_PROPAGATE | SYNCHRONIZE)
#define TRANSACTION_GENERIC_EXECUTE \
    (STANDARD_RIGHTS_EXECUTE | TRANSACTION_COMMIT | TRANSACTION_ROLLBACK | SYNCHRONIZE)
#define TRANSACTION_ALL_ACCESS \
    (STANDARD_RIGHTS_REQUIRED | TRANSACTION_GENERIC_READ | TRANSACTION_GENERIC_WRITE | \
    TRANSACTION_GENERIC_EXECUTE)
#define TRANSACTION_RESOURCE_MANAGER_RIGHTS \
    (TRANSACTION_GENERIC_READ | STANDARD_RIGHTS_WRITE | TRANSACTION_SET_INFORMATION | \
    TRANSACTION_ENLIST | TRANSACTION_ROLLBACK | TRANSACTION_PROPAGATE | SYNCHRONIZE)

/* Resource manager access rights */
#define RESOURCEMANAGER_QUERY_INFORMATION       0x0001L
#define RESOURCEMANAGER_SET_INFORMATION         0x0002L
#define RESOURCEMANAGER_RECOVER                 0x0004L
#define RESOURCEMANAGER_ENLIST                  0x0008L
#define RESOURCEMANAGER_GET_NOTIFICATION        0x0010L
#define RESOURCEMANAGER_REGISTER_PROTOCOL       0x0020L
#define RESOURCEMANAGER_COMPLETE_PROPAGATION    0x0040L
#define RESOURCEMANAGER_GENERIC_READ \
    (STANDARD_RIGHTS_READ | RESOURCEMANAGER_QUERY_INFORMATION | SYNCHRONIZE)
#define RESOURCEMANAGER_GENERIC_WRITE \
    (STANDARD_RIGHTS_WRITE | RESOURCEMANAGER_SET_INFORMATION | \
    RESOURCEMANAGER_RECOVER | RESOURCEMANAGER_ENLIST | \
    RESOURCEMANAGER_GET_NOTIFICATION | RESOURCEMANAGER_REGISTER_PROTOCOL | \
    RESOURCEMANAGER_COMPLETE_PROPAGATION | SYNCHRONIZE)
#define RESOURCEMANAGER_GENERIC_EXECUTE \
    (STANDARD_RIGHTS_EXECUTE | RESOURCEMANAGER_RECOVER | RESOURCEMANAGER_ENLIST | \
    RESOURCEMANAGER_GET_NOTIFICATION | RESOURCEMANAGER_COMPLETE_PROPAGATION | \
    SYNCHRONIZE)
#define RESOURCEMANAGER_ALL_ACCESS \
    (STANDARD_RIGHTS_REQUIRED | RESOURCEMANAGER_GENERIC_READ | \
    RESOURCEMANAGER_GENERIC_WRITE | RESOURCEMANAGER_GENERIC_EXECUTE)

/* Enlistment access rights */
#define ENLISTMENT_QUERY_INFORMATION    0x0001L
#define ENLISTMENT_SET_INFORMATION      0x0002L
#define ENLISTMENT_RECOVER              0x0004L
#define ENLISTMENT_SUBORDINATE_RIGHTS   0x0008L
#define ENLISTMENT_SUPERIOR_RIGHTS      0x0010L
#define ENLISTMENT_GENERIC_READ \
    (STANDARD_RIGHTS_READ | ENLISTMENT_QUERY_INFORMATION)
#define ENLISTMENT_GENERIC_WRITE \
    (STANDARD_RIGHTS_WRITE | ENLISTMENT_SET_INFORMATION | ENLISTMENT_RECOVER | \
    ENLISTMENT_SUBORDINATE_RIGHTS | ENLISTMENT_SUPERIOR_RIGHTS)
#define ENLISTMENT_GENERIC_EXECUTE \
    (STANDARD_RIGHTS_EXECUTE | ENLISTMENT_RECOVER | ENLISTMENT_SUBORDINATE_RIGHTS | \
    ENLISTMENT_SUPERIOR_RIGHTS)
#define ENLISTMENT_ALL_ACCESS \
    (STANDARD_RIGHTS_REQUIRED | ENLISTMENT_GENERIC_READ | ENLISTMENT_GENERIC_WRITE | \
    ENLISTMENT_GENERIC_EXECUTE)

/* Deferred procedure call types */
#define DPC_NORMAL      0
#define DPC_THREADED    1

/* Memory descriptor list flags */
#define MDL_MAPPED_TO_SYSTEM_VA     0x0001
#define MDL_PAGES_LOCKED            0x0002
#define MDL_SOURCE_IS_NONPAGED_POOL 0x0004
#define MDL_ALLOCATED_FIXED_SIZE    0x0008
#define MDL_PARTIAL                 0x0010
#define MDL_PARTIAL_HAS_BEEN_MAPPED 0x0020
#define MDL_IO_PAGE_READ            0x0040
#define MDL_WRITE_OPERATION         0x0080
#define MDL_PARENT_MAPPED_SYSTEM_VA 0x0100
#define MDL_FREE_EXTRA_PTES         0x0200
#define MDL_DESCRIBES_AWE           0x0400
#define MDL_IO_SPACE                0x0800
#define MDL_NETWORK_HEADER          0x1000
#define MDL_MAPPING_CAN_FAIL        0x2000
#define MDL_ALLOCATED_MUST_SUCCEED  0x4000
#define MDL_INTERNAL                0x8000
#define MDL_MAPPING_FLAGS \
    (MDL_MAPPED_TO_SYSTEM_VA | MDL_PAGES_LOCKED | MDL_SOURCE_IS_NONPAGED_POOL | \
    MDL_PARTIAL_HAS_BEEN_MAPPED | MDL_PARENT_MAPPED_SYSTEM_VA | MDL_SYSTEM_VA | \
    MDL_IO_SPACE)

/* Dispatcher header bit counts */
#define TIMER_EXPIRED_INDEX_BITS    6
#define TIMER_PROCESSOR_INDEX_BITS  5

/* Flush multiple maximum */
#ifdef _X86_
    #define FLUSH_MULTIPLE_MAXIMUM  32
#endif

/* IRQ levels */
#ifdef _X86_
    #define PASSIVE_LEVEL   0
    #define LOW_LEVEL       0
    #define APC_LEVEL       1
    #define DISPATCH_LEVEL  2
    #define CMCI_LEVEL      5
    #define PROFILE_LEVEL   27
    #define CLOCK1_LEVEL    28
    #define CLOCK2_LEVEL    28
    #define IPI_LEVEL       29
    #define POWER_LEVEL     30
    #define HIGH_LEVEL      31
    #define CLOCK_LEVEL     CLOCK2_LEVEL
#endif

/* Page size */
#ifdef _X86_
    #define PAGE_SIZE   0x1000
    #define PAGE_SHIFT  12L
#endif

/* Kernel user shared data address */
#ifdef _X86_
    #define KIP0PCRADDRESS      0xFFDFF000
    #define KI_USER_SHARED_DATA 0xFFDF0000
#endif

/* Result type flags */
#ifdef _X86_
    #define EFLAG_SIGN      0x8000
    #define EFLAG_ZERO      0x4000
    #define EFLAG_SELECT    (EFLAG_SIGN | EFLAG_ZERO)
    #define RESULT_NEGATIVE ((EFLAG_SIGN & ~EFLAG_ZERO) & EFLAG_SELECT)
    #define RESULT_ZERO     ((~EFLAG_SIGN & EFLAG_ZERO) & EFLAG_SELECT)
    #define RESULT_POSITIVE ((~EFLAG_SIGN & ~EFLAG_ZERO) & EFLAG_SELECT)
#endif

/* Event access rights */
#define EVENT_QUERY_STATE   0x0001L
#define EVENT_MODIFY_STATE  0x0002L
#define EVENT_ALL_ACCESS    (STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | 0x0003L)

/* Semaphore access rights */
#define SEMAPHORE_QUERY_STATE   0x0001L
#define SEMAPHORE_MODIFY_STATE  0x0002L
#define SEMAPHORE_ALL_ACCESS    (STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | 0x0003L)

/* Cache associativity special value */
#define CACHE_FULLY_ASSOCIATIVE 0xFF

/* Processor features */
#define PF_FLOATING_POINT_PRECISION_ERRATA  0L
#define PF_FLOATING_POINT_EMULATED          1L
#define PF_COMPARE_EXCHANGE_DOUBLE          2L
#define PF_MMX_INSTRUCTIONS_AVAILABLE       3L
#define PF_PPC_MOVEMEM_64BIT_OK             4L
#define PF_ALPHA_BYTE_INSTRUCTIONS          5L
#define PF_XMMI_INSTRUCTIONS_AVAILABLE      6L
#define PF_3DNOW_INSTRUCTIONS_AVAILABLE     7L
#define PF_RDTSC_INSTRUCTION_AVAILABLE      8L
#define PF_PAE_ENABLED                      9L
#define PF_XMMI64_INSTRUCTIONS_AVAILABLE    10L
#define PF_SSE_DAZ_MODE_AVAILABLE           11L
#define PF_NX_ENABLED                       12L
#define PF_SSE3_INSTRUCTIONS_AVAILABLE      13L
#define PF_COMPARE_EXCHANGE128              14L
#define PF_COMPARE64_EXCHANGE128            15L
#define PF_CHANNELS_ENABLED                 16L
#define PF_XSAVE_ENABLED                    17L

/* Maximum processor feature */
#define PROCESSOR_FEATURE_MAX   64

/* Exception flags */
#define EXCEPTION_NONCONTINUABLE    0x00000001L

/* Maximum number of exception parameters */
#define EXCEPTION_MAXIMUM_PARAMETERS    15

/* Thread wait objects */
#define THREAD_WAIT_OBJECTS 3

/* Kernel bug check add pages flags */
#define KB_ADD_PAGES_FLAG_VIRTUAL_ADDRESS           0x00000001L
#define KB_ADD_PAGES_FLAG_PHYSICAL_ADDRESS          0x00000002L
#define KB_ADD_PAGES_FLAG_ADDITIONAL_RANGES_EXIST   0x80000000L

/* Exceptions */
#define EXCEPTION_DIVIDED_BY_ZERO       0x00
#define EXCEPTION_DEBUG                 0x01
#define EXCEPTION_NMI                   0x02
#define EXCEPTION_INT3                  0x03
#define EXCEPTION_BOUND_CHECK           0x05
#define EXCEPTION_INVALID_OPCODE        0x06
#define EXCEPTION_NPX_NOT_AVAILABLE     0x07
#define EXCEPTION_DOUBLE_FAULT          0x08
#define EXCEPTION_NPX_OVERRUN           0x09
#define EXCEPTION_INVALID_TSS           0x0A
#define EXCEPTION_SEGMENT_NOT_PRESENT   0x0B
#define EXCEPTION_STACK_FAULT           0x0C
#define EXCEPTION_GP_FAULT              0x0D
#define EXCEPTION_RESERVED_TRAP         0x0F
#define EXCEPTION_NPX_ERROR             0x10
#define EXCEPTION_ALIGNMENT_CHECK       0x11

/* Guarded mutex flags */
#define GM_LOCK_BIT     0x00000001L
#define GM_LOCK_BIT_V   0x00000000L
#define GM_WAITER_WOKEN 0x00000002L
#define GM_WAITER_INC   0x00000004L

/* KeRegisterProcessorChangeCallback() flags */
#define KE_PROCESSOR_CHANGE_ADD_EXISTING    1L

/* Processor index special value */
#define INVALID_PROCESSOR_INDEX 0xFFFFFFFFL

/* Pool constants */
#define POOL_COLD_ALLOCATION                256
#define POOL_QUOTA_FAIL_INSTEAD_OF_RAISE    8
#define POOL_RAISE_IF_ALLOCATION_FAILURE    16

/* Fast mutex flags */
#define FM_LOCK_BIT             0x00000001L
#define FM_LOCK_BIT_V           0x00000000L
#define FM_LOCK_WAITER_WOKEN    0x00000002L
#define FM_LOCK_WAITER_INC      0x00000004L

/* Lookaside constants */
#if (NTDDI_VERSION >= 0x06000000)
    #define EX_LOOKASIDE_LIST_EX_FLAGS_RAISE_ON_FAIL    0x00000001L
    #define EX_LOOKASIDE_LIST_EX_FLAGS_FAIL_NO_RAISE    0x00000002L
    #define EX_MAXIMUM_LOOKASIDE_DEPTH_BASE             256
    #define EX_MAXIMUM_LOOKASIDE_DEPTH_LIMIT            1024
#endif

/* Executive resource flags */
#define ResourceNeverExclusive          0x0010
#define ResourceReleaseByOtherThread    0x0020
#define ResourceOwnedExclusive          0x0080

/* Resource hash table size */
#define RESOURCE_HASH_TABLE_SIZE    64

/* ExSetResourceOwnerPointerEx() flags */
#if (NTDDI_VERSION >= 0x06010000)
    #define FLAG_OWNER_POINTER_IS_THREAD    0x00000001L
#endif

/* Executive rundown flags */
#define EX_RUNDOWN_ACTIVE       0x00000001L
#define EX_RUNDOWN_COUNT_SHIFT  1
#define EX_RUNDOWN_COUNT_INC    0x00000002L

/* Event increments */
#define EVENT_INCREMENT         1
#define IO_NO_INCREMENT         0
#define IO_CD_ROM_INCREMENT     1
#define IO_DISK_INCREMENT       1
#define IO_KEYBOARD_INCREMENT   6
#define IO_MAILSLOT_INCREMENT   2
#define IO_MOUSE_INCREMENT      6
#define IO_NAMED_PIPE_INCREMENT 2
#define IO_NETWORK_INCREMENT    2
#define IO_PARALLEL_INCREMENT   1
#define IO_SERIAL_INCREMENT     2
#define IO_SOUND_INCREMENT      8
#define IO_VIDEO_INCREMENT      1
#define SEMAPHORE_INCREMENT     1

/* Paging macros */
#define ROUND_TO_PAGES( x ) \
    (((ULONG_PTR)(x) + PAGE_SIZE - 1) & ~(PAGE_SIZE - 1))
#define BYTES_TO_PAGES( x ) \
    (((x) >> PAGE_SHIFT) + (((x) & (PAGE_SIZE - 1)) != 0))
#define BYTE_OFFSET( x ) \
    ((ULONG)((LONG_PTR)(x) & (PAGE_SIZE - 1)))
#define PAGE_ALIGN( x ) \
    ((PVOID)((ULONG_PTR)(x) & ~(PAGE_SIZE - 1)))
#define ADDRESS_AND_SIZE_TO_SPAN_PAGES( p1, p2 ) \
    ((ULONG)((((ULONG_PTR)(p1) & (PAGE_SIZE - 1)) + (p2) + (PAGE_SIZE - 1)) >> \
    PAGE_SHIFT))
#define COMPUTE_PAGES_SPANNED( p1, p2 ) \
    ADDRESS_AND_SIZE_TO_SPAN_PAGES( p1, p2 )

/* Memory management maximum disk I/O size */
#define MM_MAXIMUM_DISK_IO_SIZE 0x00010000

/* MmAllocatePagesForMdlEx() flags */
#define MM_DONT_ZERO_ALLOCATION                 0x00000001L
#define MM_ALLOCATE_FROM_LOCAL_NODE_ONLY        0x00000002L
#define MM_ALLOCATE_FULLY_REQUIRED              0x00000004L
#define MM_ALLOCATE_NO_WAIT                     0x00000008L
#define MM_ALLOCATE_PREFER_CONTIGUOUS           0x00000010L
#define MM_ALLOCATE_REQUIRE_CONTIGUOUS_CHUNKS   0x00000020L

/* Node requirement values */
#define MM_ANY_NODE_OK  0x80000000L

/* Initial privilege count */
#define INITIAL_PRIVILEGE_COUNT 3

/* I/O types */
#define IO_TYPE_ADAPTER         0x00000001L
#define IO_TYPE_CONTROLLER      0x00000002L
#define IO_TYPE_DEVICE          0x00000003L
#define IO_TYPE_DRIVER          0x00000004L
#define IO_TYPE_FILE            0x00000005L
#define IO_TYPE_IRP             0x00000006L
#define IO_TYPE_MASTER_ADAPTER  0x00000007L
#define IO_TYPE_OPEN_PACKET     0x00000008L
#define IO_TYPE_TIMER           0x00000009L
#define IO_TYPE_VPB             0x0000000AL
#define IO_TYPE_ERROR_LOG       0x0000000BL
#define IO_TYPE_ERROR_MESSAGE   0x0000000CL
#define IO_TYPE_DEVICE_OBJECT_EXTENSION 0x0000000DL

/* I/O request packet major function codes */
#define IRP_MJ_CREATE                   0x00
#define IRP_MJ_CREATE_NAMED_PIPE        0x01
#define IRP_MJ_CLOSE                    0x02
#define IRP_MJ_READ                     0x03
#define IRP_MJ_WRITE                    0x04
#define IRP_MJ_QUERY_INFORMATION        0x05
#define IRP_MJ_SET_INFORMATION          0x06
#define IRP_MJ_QUERY_EA                 0x07
#define IRP_MJ_SET_EA                   0x08
#define IRP_MJ_FLUSH_BUFFERS            0x09
#define IRP_MJ_QUERY_VOLUME_INFORMATION 0x0A
#define IRP_MJ_SET_VOLUME_INFORMATION   0x0B
#define IRP_MJ_DIRECTORY_CONTROL        0x0C
#define IRP_MJ_FILE_SYSTEM_CONTROL      0x0D
#define IRP_MJ_DEVICE_CONTROL           0x0E
#define IRP_MJ_INTERNAL_DEVICE_CONTROL  0x0F
#define IRP_MJ_SHUTDOWN                 0x10
#define IRP_MJ_LOCK_CONTROL             0x11
#define IRP_MJ_CLEANUP                  0x12
#define IRP_MJ_CREATE_MAILSLOT          0x13
#define IRP_MJ_QUERY_SECURITY           0x14
#define IRP_MJ_SET_SECURITY             0x15
#define IRP_MJ_POWER                    0x16
#define IRP_MJ_SYSTEM_CONTROL           0x17
#define IRP_MJ_DEVICE_CHANGE            0x18
#define IRP_MJ_QUERY_QUOTA              0x19
#define IRP_MJ_SET_QUOTA                0x1A
#define IRP_MJ_PNP                      0x1B
#define IRP_MJ_PNP_POWER                IRP_MJ_PNP
#define IRP_MJ_MAXIMUM_FUNCTION         0x1B
#define IRP_MJ_SCSI                     IRP_MJ_INTERNAL_DEVICE_CONTROL

/* I/O request packet minor function codes for SCSI */
#define IRP_MN_SCSI_CLASS   0x01

/* I/O request packet minor function codes for Plug and Play */
#define IRP_MN_START_DEVICE                 0x00
#define IRP_MN_QUERY_REMOVE_DEVICE          0x01
#define IRP_MN_REMOVE_DEVICE                0x02
#define IRP_MN_CANCEL_REMOVE_DEVICE         0x03
#define IRP_MN_STOP_DEVICE                  0x04
#define IRP_MN_QUERY_STOP_DEVICE            0x05
#define IRP_MN_CANCEL_STOP_DEVICE           0x06
#define IRP_MN_QUERY_DEVICE_RELATIONS       0x07
#define IRP_MN_QUERY_INTERFACE              0x08
#define IRP_MN_QUERY_CAPABILITIES           0x09
#define IRP_MN_QUERY_RESOURCES              0x0A
#define IRP_MN_QUERY_RESOURCE_REQUIREMENTS  0x0B
#define IRP_MN_QUERY_DEVICE_TEXT            0x0C
#define IRP_MN_FILTER_RESOURCE_REQUIREMENTS 0x0D
#define IRP_MN_READ_CONFIG                  0x0F
#define IRP_MN_WRITE_CONFIG                 0x10
#define IRP_MN_EJECT                        0x11
#define IRP_MN_SET_LOCK                     0x12
#define IRP_MN_QUERY_ID                     0x13
#define IRP_MN_QUERY_PNP_DEVICE_STATE       0x14
#define IRP_MN_QUERY_BUS_INFORMATION        0x15
#define IRP_MN_DEVICE_USAGE_NOTIFICATION    0x16
#define IRP_MN_SURPRISE_REMOVAL             0x17
#if (NTDDI_VERSION >= 0x06010000)
    #define IRP_MN_DEVICE_ENUMERATED        0x19
#endif

/* I/O request packet minor function codes for power */
#define IRP_MN_WAIT_WAKE        0x00
#define IRP_MN_POWER_SEQUENCE   0x01
#define IRP_MN_SET_POWER        0x02
#define IRP_MN_QUERY_POWER      0x03

/* I/O request packet minor function codes for WMI */
#define IRP_MN_QUERY_ALL_DATA           0x00
#define IRP_MN_QUERY_SINGLE_INSTANCE    0x01
#define IRP_MN_CHANGE_SINGLE_INSTANCE   0x02
#define IRP_MN_CHANGE_SINGLE_ITEM       0x03
#define IRP_MN_ENABLE_EVENTS            0x04
#define IRP_MN_DISABLE_EVENTS           0x05
#define IRP_MN_ENABLE_COLLECTION        0x06
#define IRP_MN_DISABLE_COLLECTION       0x07
#define IRP_MN_REGINFO                  0x08
#define IRP_MN_EXECUTE_METHOD           0x09
#define IRP_MN_REGINFO_EX               0x0B

/* IoCreateFile() flags */
#define IO_FORCE_ACCESS_CHECK       0x0001
#define IO_NO_PARAMETER_CHECKING    0x0100

/* I/O information fields */
#define IO_REPARSE  0
#define IO_REMOUNT  1

/* Volume parameter block flags */
#define VPB_MOUNTED                 0x00000001L
#define VPB_LOCKED                  0x00000002L
#define VPB_PERSISTENT              0x00000004L
#define VPB_REMOVE_PENDING          0x00000008L
#define VPB_RAW_MOUNT               0x00000010L
#define VPB_DIRECT_WRITES_ALLOWED   0x00000020L

/* Maximum volume label length */
#define MAXIMUM_VOLUME_LABEL_LENGTH (32 * sizeof( WCHAR ))

/* Device object flags */
#define DO_VERIFY_VOLUME            0x00000002L
#define DO_BUFFERED_IO              0x00000004L
#define DO_EXCLUSIVE                0x00000008L
#define DO_DIRECT_IO                0x00000010L
#define DO_MAP_IO_BUFFER            0x00000020L
#define DO_DEVICE_INITIALIZING      0x00000080L
#define DO_SHUTDOWN_REGISTERED      0x00000800L
#define DO_BUS_ENUMERATED_DEVICE    0x00001000L
#define DO_POWER_PAGABLE            0x00002000L
#define DO_POWER_INRUSH             0x00004000L

/* Driver object flags */
#define DRVO_UNLOAD_INVOKED 0x00000001L
#define DRVO_LEGACY_DRIVER  0x00000002L
#define DRVO_BUILTIN_DRIVER 0x00000004L

/* File object flags */
#define FO_FILE_OPEN                        0x00000001L
#define FO_SYNCHRONOUS_IO                   0x00000002L
#define FO_ALERTABLE_IO                     0x00000004L
#define FO_NO_INTERMEDIATE_BUFFERING        0x00000008L
#define FO_WRITE_THROUGH                    0x00000010L
#define FO_SEQUENTIAL_ONLY                  0x00000020L
#define FO_CACHE_SUPPORTED                  0x00000040L
#define FO_NAMED_PIPE                       0x00000080L
#define FO_STREAM_FILE                      0x00000100L
#define FO_MAILSLOT                         0x00000200L
#define FO_GENERATE_AUDIT_ON_CLOSE          0x00000400L
#define FO_QUEUE_IRP_TO_THREAD              FO_GENERATE_AUDIT_ON_CLOSE
#define FO_DIRECT_DEVICE_OPEN               0x00000800L
#define FO_FILE_MODIFIED                    0x00001000L
#define FO_FILE_SIZE_CHANGED                0x00002000L
#define FO_CLEANUP_COMPLETE                 0x00004000L
#define FO_TEMPORARY_FILE                   0x00008000L
#define FO_DELETE_ON_CLOSE                  0x00010000L
#define FO_OPENED_CASE_SENSITIVE            0x00020000L
#define FO_HANDLE_CREATED                   0x00040000L
#define FO_FILE_FAST_IO_READ                0x00080000L
#define FO_RANDOM_ACCESS                    0x00100000L
#define FO_FILE_OPEN_CANCELLED              0x00200000L
#define FO_VOLUME_OPEN                      0x00400000L
#define FO_REMOTE_ORIGIN                    0x01000000L
#define FO_DISALLOW_EXCLUSIVE               0x02000000L
#define FO_SKIP_COMPLETION_PORT             FO_DISALLOW_EXCLUSIVE
#define FO_SKIP_SET_EVENT                   0x04000000L
#define FO_SKIP_SET_FAST_IO                 0x08000000L
#define FO_FLAGS_VALID_ONLY_DURING_CREATE   FO_DISALLOW_EXCLUSIVE

/* I/O request packet flags */
#define IRP_NOCACHE                 0x00000001L
#define IRP_PAGING_IO               0x00000002L
#define IRP_MOUNT_COMPLETION        0x00000002L
#define IRP_SYNCHRONOUS_API         0x00000004L
#define IRP_ASSOCIATED_IRP          0x00000008L
#define IRP_BUFFERED_IO             0x00000010L
#define IRP_DEALLOCATE_BUFFER       0x00000020L
#define IRP_INPUT_OPERATION         0x00000040L
#define IRP_SYNCHRONOUS_PAGING_IO   0x00000040L
#define IRP_CREATE_OPERATION        0x00000080L
#define IRP_READ_OPERATION          0x00000100L
#define IRP_WRITE_OPERATION         0x00000200L
#define IRP_CLOSE_OPERATION         0x00000400L
#define IRP_DEFER_IO_COMPLETION     0x00000800L
#define IRP_OB_QUERY_NAME           0x00001000L
#define IRP_HOLD_DEVICE_QUEUE       0x00002000L

/* I/O request packet allocation flags */
#define IRP_QUOTA_CHARGED           0x01
#define IRP_ALLOCATED_MUST_SUCCEED  0x02
#define IRP_ALLOCATED_FIXED_SIZE    0x04
#define IRP_LOOKASIDE_ALLOCATION    0x08

/* Stack location flags */
#define SL_PENDING_RETURNED         0x01
#define SL_ERROR_RETURNED           0x02
#define SL_INVOKE_ON_CANCEL         0x20
#define SL_INVOKE_ON_SUCCESS        0x40
#define SL_INVOKE_ON_ERROR          0x80
#define SL_FORCE_ACCESS_CHECK       0x01
#define SL_OPEN_PAGING_FILE         0x02
#define SL_OPEN_TARGET_DIRECTORY    0x04
#define SL_STOP_ON_SYMLINK          0x08
#define SL_CASE_SENSITIVE           0x80
#define SL_KEY_SPECIFIED            0x01
#define SL_OVERRIDE_VERIFY_VOLUME   0x02
#define SL_WRITE_THROUGH            0x04
#define SL_FT_SEQUENTIAL_WRITE      0x08
#define SL_FORCE_DIRECT_WRITE       0x10
#define SL_REALTIME_STREAM          0x20
#define SL_READ_ACCESS_GRANTED      0x01
#define SL_WRITE_ACCESS_GRANTED     0x04
#define SL_FAIL_IMMEDIATELY         0x01
#define SL_EXCLUSIVE_LOCK           0x02
#define SL_RESTART_SCAN             0x01
#define SL_RETURN_SINGLE_ENTRY      0x02
#define SL_INDEX_SPECIFIED          0x04
#define SL_WATCH_TREE               0x01
#define SL_ALLOW_RAW_MOUNT          0x01

/* Plug and Play device states */
#define PNP_DEVICE_DISABLED                         0x00000001L
#define PNP_DEVICE_DONT_DISPLAY_IN_UI               0x00000002L
#define PNP_DEVICE_FAILED                           0x00000004L
#define PNP_DEVICE_REMOVED                          0x00000008L
#define PNP_DEVICE_RESOURCE_REQUIREMENTS_CHANGED    0x00000010L
#define PNP_DEVICE_NOT_DISABLEABLE                  0x00000020L

/* Status special value */
#define STATUS_CONTINUE_COMPLETION  STATUS_SUCCESS

/* I/O interrupt connection versions */
#define CONNECT_FULLY_SPECIFIED         0x00000001L
#define CONNECT_LINE_BASED              0x00000002L
#define CONNECT_MESSAGE_BASED           0x00000003L
#define CONNECT_FULLY_SPECIFIED_GROUP   0x00000004L
#define CONNECT_CURRENT_VERSION         0x00000004L

/* WDM version numbers */
#define WDM_MAJOR_VERSION   0x06
#define WDM_MINOR_VERSION   0x00

/* IoWMIRegistrationControl() action codes */
#define WMIREG_ACTION_REGISTER      1L
#define WMIREG_ACTION_DEREGISTER    2L
#define WMIREG_ACTION_REREGISTER    3L
#define WMIREG_ACTION_UPDATE_GUIDS  4L
#define WMIREG_ACTION_BLOCK_IRPS    5L

/* IRP_MN_REGINFO codes */
#define WMIREGISTER 0
#define WMIUPDATE   1

/* I/O CSQ types */
#define IO_TYPE_CSQ_IRP_CONTEXT 1
#define IO_TYPE_CSQ             2
#define IO_TYPE_CSQ_EX          3

/* EtwWriteEx() flags */
#define EVENT_WRITE_FLAG_NO_FAULTING    0x00000001L

/* Plug and Play replace parameters version number */
#define PNP_REPLACE_PARAMETERS_VERSION  2L

/* Plug and Play replace driver interface version number */
#define PNP_REPLACE_DRIVER_INTERFACE_VERSION    1L

/* Plug and Play replace flags */
#define PNP_REPLACE_MEMORY_SUPPORTED            0x00000001L
#define PNP_REPLACE_PROCESSOR_SUPPORTED         0x00000002L
#define PNP_REPLACE_HARDWARE_MEMORY_MIRRORING   0x00000004L
#define PNP_REPLACE_HARDWARE_PAGE_COPY          0x00000008L
#define PNP_REPLACE_HARDWARE_QUIESCE            0x00000010L

/* Plug and Play registry keys */
#define PLUGPLAY_REGKEY_DEVICE              1L
#define PLUGPLAY_REGKEY_DRIVER              2L
#define PLUGPLAY_REGKEY_CURRENT_HWPROFILE   4L

/* Device interface flags */
#define DEVICE_INTERFACE_INCLUDE_NONACTIVE  0x00000001L

/* Plug and Play notify flags */
#define PNPNOTIFY_DEVICE_INTERFACE_INCLUDE_EXISTING_INTERFACES  0x00000001L

/* Plug and Play property flags */
#if (NTDDI_VERSION >= 0x06000000)
    #define PLUGPLAY_PROPERTY_PERSISTENT    0x00000001L
#endif

/* Device description version numbers */
#define DEVICE_DESCRIPTION_VERSION  0
#define DEVICE_DESCRIPTION_VERSION1 1
#define DEVICE_DESCRIPTION_VERSION2 2

/* Callback power states */
#define PO_CB_SYSTEM_POWER_POLICY       0
#define PO_CB_AC_STATUS                 1
#define PO_CB_BUTTON_COLLISION          2
#define PO_CB_SYSTEM_STATE_LOCK         3
#define PO_CB_LID_SWITCH_STATE          4
#define PO_CB_PROCESSOR_POWER_POLICY    5

/* Object registration version numbers */
#define OB_FLT_REGISTRATION_VERSION_0100    0x0100
#define OB_FLT_REGISTRATION_VERSION         OB_FLT_REGISTRATION_VERSION_0100

/* Object operations */
#define OB_OPERATION_HANDLE_CREATE      0x00000001L
#define OB_OPERATION_HANDLE_DUPLICATE   0x00000002L

/* PCI base address counts */
#define PCI_TYPE0_ADDRESSES 6
#define PCI_TYPE1_ADDRESSES 2
#define PCI_TYPE2_ADDRESSES 5

/* PCI maximum values */
#define PCI_MAX_DEVICES         32
#define PCI_MAX_FUNCTION        8
#define PCI_MAX_BRIDGE_NUMBER   0xFF

/* PCI vendor identifier special value */
#define PCI_INVALID_VENDORID    0xFFFF

/* PCI common configuration header types */
#define PCI_MULTIFUNCTION       0x80
#define PCI_DEVICE_TYPE         0x00
#define PCI_BRIDGE_TYPE         0x01
#define PCI_CARDBUS_BRIDGE_TYPE 0x02

/* PCI common configuration commands */
#define PCI_ENABLE_IO_SPACE                 0x0001
#define PCI_ENABLE_MEMORY_SPACE             0x0002
#define PCI_ENABLE_BUS_MASTER               0x0004
#define PCI_ENABLE_SPECIAL_CYCLES           0x0008
#define PCI_ENABLE_WRITE_AND_INVALIDATE     0x0010
#define PCI_ENABLE_VGA_COMPATIBLE_PALETTE   0x0020
#define PCI_ENABLE_PARITY                   0x0040
#define PCI_ENABLE_WAIT_CYCLE               0x0080
#define PCI_ENABLE_SERR                     0x0100
#define PCI_ENABLE_FAST_BACK_TO_BACK        0x0200
#define PCI_DISABLE_LEVEL_INTERRUPT         0x0400

/* PCI common configuration status values */
#define PCI_STATUS_INTERRUPT_PENDING        0x0008
#define PCI_STATUS_CAPABILITIES_LIST        0x0010
#define PCI_STATUS_66MHZ_CAPABLE            0x0020
#define PCI_STATUS_UDF_SUPPORTED            0x0040
#define PCI_STATUS_FAST_BACK_TO_BACK        0x0080
#define PCI_STATUS_DATA_PARITY_DETECTED     0x0100
#define PCI_STATUS_DEVSEL                   0x0600
#define PCI_STATUS_SIGNALED_TARGET_ABORT    0x0800
#define PCI_STATUS_RECEIVED_TARGET_ABORT    0x1000
#define PCI_STATUS_RECEIVED_MASTER_ABORT    0x2000
#define PCI_STATUS_SIGNALED_SYSTEM_ERROR    0x4000
#define PCI_STATUS_DETECTED_PARITY_ERROR    0x8000

/* PCI address space values */
#define PCI_WHICHSPACE_CONFIG   0x00000000
#define PCI_WHICHSPACE_ROM      0x52696350

/* PCI capability identifiers */
#define PCI_CAPABILITY_ID_POWER_MANAGEMENT  0x01
#define PCI_CAPABILITY_ID_AGP               0x02
#define PCI_CAPABILITY_ID_VPD               0x03
#define PCI_CAPABILITY_ID_SLOT_ID           0x04
#define PCI_CAPABILITY_ID_MSI               0x05
#define PCI_CAPABILITY_ID_CPCI_HOTSWAP      0x06
#define PCI_CAPABILITY_ID_PCIX              0x07
#define PCI_CAPABILITY_ID_HYPERTRANSPORT    0x08
#define PCI_CAPABILITY_ID_VENDOR_SPECIFIC   0x09
#define PCI_CAPABILITY_ID_DEBUG_PORT        0x0A
#define PCI_CAPABILITY_ID_CPCI_RES_CTRL     0x0B
#define PCI_CAPABILITY_ID_SHPC              0x0C
#define PCI_CAPABILITY_ID_P2P_SSID          0x0D
#define PCI_CAPABILITY_ID_AGP_TARGET        0x0E
#define PCI_CAPABILITY_ID_SECURE            0x0F
#define PCI_CAPABILITY_ID_PCI_EXPRESS       0x10
#define PCI_CAPABILITY_ID_MSIX              0x11

/* PCI express capabilitiy identifiers */
#define PCI_EXPRESS_ADVANCED_ERROR_REPORTING_CAP_ID                 0x0001
#define PCI_EXPRESS_VIRTUAL_CHANNEL_CAP_ID                          0x0002
#define PCI_EXPRESS_DEVICE_SERIAL_NUMBER_CAP_ID                     0x0003
#define PCI_EXPRESS_POWER_BUDGETING_CAP_ID                          0x0004
#define PCI_EXPRESS_RC_LINK_DECLARATION_CAP_ID                      0x0005
#define PCI_EXPRESS_RC_INTERNAL_LINK_CONTROL_CAP_ID                 0x0006
#define PCI_EXPRESS_RC_EVENT_COLLECTOR_ENDPOINT_ASSOCIATION_CAP_ID  0x0007
#define PCI_EXPRESS_MFVC_CAP_ID                                     0x0008
#define PCI_EXPRESS_VC_AND_MFVC_CAP_ID                              0x0009
#define PCI_EXPRESS_RCRB_HEADER_CAP_ID                              0x000A
#define PCI_EXPRESS_SINGLE_ROOT_IO_VIRTUALIZATION_CAP_ID            0x0010

/* Error reporting root commands */
#define ROOT_CMD_ENABLE_CORRECTABLE_ERROR_REPORTING 0x00000001L
#define ROOT_CMD_ENABLE_NONFATAL_ERROR_REPORTING    0x00000002L
#define ROOT_CMD_ENABLE_FATAL_ERROR_REPORTING       0x00000004L
#define ROOT_CMD_ERROR_REPORTING_ENABLE_MASK \
    (ROOT_CMD_ENABLE_CORRECTABLE_ERROR_REPORTING | \
    ROOT_CMD_ENABLE_NONFATAL_ERROR_REPORTING | ROOT_CMD_ENABLE_FATAL_ERROR_REPORTING)

/* PCI classes */
#define PCI_CLASS_PRE_20                0x00
#define PCI_CLASS_MASS_STORAGE_CTLR     0x01
#define PCI_CLASS_NETWORK_CTLR          0x02
#define PCI_CLASS_DISPLAY_CTLR          0x03
#define PCI_CLASS_MULTIMEDIA_DEV        0x04
#define PCI_CLASS_MEMORY_CTLR           0x05
#define PCI_CLASS_BRIDGE_DEV            0x06
#define PCI_CLASS_SIMPLE_COMMS_CTLR     0x07
#define PCI_CLASS_BASE_SYSTEM_DEV       0x08
#define PCI_CLASS_INPUT_DEV             0x09
#define PCI_CLASS_DOCKING_STATION       0x0A
#define PCI_CLASS_PROCESSOR             0x0B
#define PCI_CLASS_SERIAL_BUS_CTLR       0x0C
#define PCI_CLASS_WIRELESS_CTLR         0x0D
#define PCI_CLASS_INTELLIGENT_IO_CTLR   0x0E
#define PCI_CLASS_SATELLITE_COMMS_CTLR  0x0F
#define PCI_CLASS_ENCRYPTION_DECRYPTION 0x10
#define PCI_CLASS_DATA_ACQ_SIGNAL_PROC  0x11
#define PCI_CLASS_NOT_DEFINED           0xFF

/* PCI subclasses */
#define PCI_SUBCLASS_PRE_20_NON_VGA         0x00
#define PCI_SUBCLASS_PRE_20_VGA             0x01
#define PCI_SUBCLASS_MSC_SCSI_BUS_CTLR      0x00
#define PCI_SUBCLASS_MSC_IDE_CTLR           0x01
#define PCI_SUBCLASS_MSC_FLOPPY_CTLR        0x02
#define PCI_SUBCLASS_MSC_IPI_CTLR           0x03
#define PCI_SUBCLASS_MSC_RAID_CTLR          0x04
#define PCI_SUBCLASS_MSC_OTHER              0x80
#define PCI_SUBCLASS_NET_ETHERNET_CTLR      0x00
#define PCI_SUBCLASS_NET_TOKEN_RING_CTLR    0x01
#define PCI_SUBCLASS_NET_FDDI_CTLR          0x02
#define PCI_SUBCLASS_NET_ATM_CTLR           0x03
#define PCI_SUBCLASS_NET_ISDN_CTLR          0x04
#define PCI_SUBCLASS_NET_OTHER              0x80
#define PCI_SUBCLASS_VID_VGA_CTLR           0x00
#define PCI_SUBCLASS_VID_XGA_CTLR           0x01
#define PCI_SUBCLASS_VID_3D_CTLR            0x02
#define PCI_SUBCLASS_VID_OTHER              0x80
#define PCI_SUBCLASS_MM_VIDEO_DEV           0x00
#define PCI_SUBCLASS_MM_AUDIO_DEV           0x01
#define PCI_SUBCLASS_MM_TELEPHONY_DEV       0x02
#define PCI_SUBCLASS_MM_OTHER               0x80
#define PCI_SUBCLASS_MEM_RAM                0x00
#define PCI_SUBCLASS_MEM_FLASH              0x01
#define PCI_SUBCLASS_MEM_OTHER              0x80
#define PCI_SUBCLASS_BR_HOST                0x00
#define PCI_SUBCLASS_BR_ISA                 0x01
#define PCI_SUBCLASS_BR_EISA                0x02
#define PCI_SUBCLASS_BR_MCA                 0x03
#define PCI_SUBCLASS_BR_PCI_TO_PCI          0x04
#define PCI_SUBCLASS_BR_PCMCIA              0x05
#define PCI_SUBCLASS_BR_NUBUS               0x06
#define PCI_SUBCLASS_BR_CARDBUS             0x07
#define PCI_SUBCLASS_BR_RACEWAY             0x08
#define PCI_SUBCLASS_BR_OTHER               0x80
#define PCI_SUBCLASS_COM_SERIAL             0x00
#define PCI_SUBCLASS_COM_PARALLEL           0x01
#define PCI_SUBCLASS_COM_MULTIPORT          0x02
#define PCI_SUBCLASS_COM_MODEM              0x03
#define PCI_SUBCLASS_COM_OTHER              0x80
#define PCI_SUBCLASS_SYS_INTERRUPT_CTLR     0x00
#define PCI_SUBCLASS_SYS_DMA_CTLR           0x01
#define PCI_SUBCLASS_SYS_SYSTEM_TIMER       0x02
#define PCI_SUBCLASS_SYS_REAL_TIME_CLOCK    0x03
#define PCI_SUBCLASS_SYS_GEN_HOTPLUG_CTLR   0x04
#define PCI_SUBCLASS_SYS_SDIO_CTRL          0x05
#define PCI_SUBCLASS_SYS_OTHER              0x80
#define PCI_SUBCLASS_INP_KEYBOARD           0x00
#define PCI_SUBCLASS_INP_DIGITIZER          0x01
#define PCI_SUBCLASS_INP_MOUSE              0x02
#define PCI_SUBCLASS_INP_SCANNER            0x03
#define PCI_SUBCLASS_INP_GAMEPORT           0x04
#define PCI_SUBCLASS_INP_OTHER              0x80
#define PCI_SUBCLASS_DOC_GENERIC            0x00
#define PCI_SUBCLASS_DOC_OTHER              0x80
#define PCI_SUBCLASS_PROC_386               0x00
#define PCI_SUBCLASS_PROC_486               0x01
#define PCI_SUBCLASS_PROC_PENTIUM           0x02
#define PCI_SUBCLASS_PROC_ALPHA             0x10
#define PCI_SUBCLASS_PROC_POWERPC           0x20
#define PCI_SUBCLASS_PROC_COPROCESSOR       0x40
#define PCI_SUBCLASS_SB_IEEE1394            0x00
#define PCI_SUBCLASS_SB_ACCESS              0x01
#define PCI_SUBCLASS_SB_SSA                 0x02
#define PCI_SUBCLASS_SB_USB                 0x03
#define PCI_SUBCLASS_SB_FIBRE_CHANNEL       0x04
#define PCI_SUBCLASS_SB_SMBUS               0x05
#define PCI_SUBCLASS_WIRELESS_IRDA          0x00
#define PCI_SUBCLASS_WIRELESS_CON_IR        0x01
#define PCI_SUBCLASS_WIRELESS_RF            0x10
#define PCI_SUBCLASS_WIRELESS_OTHER         0x80
#define PCI_SUBCLASS_INTIO_I2O              0x00
#define PCI_SUBCLASS_SAT_TV                 0x01
#define PCI_SUBCLASS_SAT_AUDIO              0x02
#define PCI_SUBCLASS_SAT_VOICE              0x03
#define PCI_SUBCLASS_SAT_DATA               0x04
#define PCI_SUBCLASS_CRYPTO_NET_COMP        0x00
#define PCI_SUBCLASS_CRYPTO_ENTERTAINMENT   0x10
#define PCI_SUBCLASS_CRYPTO_OTHER           0x80
#define PCI_SUBCLASS_DASP_DPIO              0x00
#define PCI_SUBCLASS_DASP_OTHER             0x80

/* PCI base address flags */
#define PCI_ADDRESS_IO_SPACE            0x00000001L
#define PCI_ADDRESS_MEMORY_TYPE_MASK    0x00000006L
#define PCI_ADDRESS_MEMORY_PREFETCHABLE 0x00000008L
#define PCI_ADDRESS_IO_ADDRESS_MASK     0xFFFFFFFCL
#define PCI_ADDRESS_MEMORY_ADDRESS_MASK 0xFFFFFFF0L
#define PCI_ADDRESS_ROM_ADDRESS_MASK    0xFFFFF800L

/* PCI types */
#define PCI_TYPE_32BIT  0
#define PCI_TYPE_20BIT  2
#define PCI_TYPE_64BIT  4

/* PCI ROM base address flags */
#define PCI_ROMADDRESS_ENABLED  0x00000001L

/* PCI interface version numbers */
#define PCI_DEVICE_PRESENT_INTERFACE_VERSION            1
#define PCI_EXPRESS_LINK_QUIESCENT_INTERFACE_VERSION    1
#define PCI_EXPRESS_ROOT_PORT_INTERFACE_VERSION         1
#define PCI_MSIX_TABLE_CONFIG_INTERFACE_VERSION         1

/* PCI device presence flags */
#define PCI_USE_SUBSYSTEM_IDS   0x00000001L
#define PCI_USE_REVISION        0x00000002L
#define PCI_USE_VENDEV_IDS      0x00000004L
#define PCI_USE_CLASS_SUBCLASS  0x00000008L
#define PCI_USE_PROGIF          0x00000010L
#define PCI_USE_LOCAL_BUS       0x00000020L
#define PCI_USE_LOCAL_DEVICE    0x00000040L

/* Extended attribute entry names */
#if (NTDDI_VERSION >= 0x05020100)
    #define EA_CONTAINER_NAME   "ContainerName"
    #define EA_CONTAINER_SIZE   "ContainerSize"
#endif

/* Common log file system base log extension */
#if (NTDDI_VERSION >= 0x05020100)
    #define CLFS_BASELOG_EXTENSION  L".blf"
#endif

/* Common log file system flags */
#if (NTDDI_VERSION >= 0x05020100)
    #define CLFS_FLAG_NO_FLAGS              0x00000000L
    #define CLFS_FLAG_FORCE_APPEND          0x00000001L
    #define CLFS_FLAG_FORCE_FLUSH           0x00000002L
    #define CLFS_FLAG_USE_RESERVATION       0x00000004L
    #define CLFS_FLAG_REENTRANT_FILE_SYSTEM 0x00000008L
    #define CLFS_FLAG_NON_REENTRANT_FILTER  0x00000010L
    #define CLFS_FLAG_REENTRANT_FILTER      0x00000020L
    #define CLFS_FLAG_IGNORE_SHARE_ACCESS   0x00000040L
    #define CLFS_FLAG_READ_IN_PROGRESS      0x00000080L
    #define CLFS_FLAG_MINIFILTER_LEVEL      0x00000100L
    #define CLFS_FLAG_HIDDEN_SYSTEM_LOG     0x00000200L
    #define CLFS_FLAG_FILTER_INTERMEDIATE_LEVEL CLFS_FLAG_NON_REENTRANT_FILTER
    #define CLFS_FLAG_FILTER_TOP_LEVEL      CLFS_FLAG_REENTRANT_FILTER
#endif

/* Common log file system record types */
#if (NTDDI_VERSION >= 0x05020100)
    #define ClfsNullRecord      0x00
    #define ClfsDataRecord      0x01
    #define ClfsRestartRecord   0x02
    #define ClfsClientRecord    0x03
#endif

/* Common log file system container prefixes */
#if (NTDDI_VERSION >= 0x05020100)
    #define CLFS_CONTAINER_STREAM_PREFIX    L"%BLF%:"
    #define CLFS_CONTAINER_RELATIVE_PREFIX  L"%BLF%\\"
#endif

/* Common log file system container states */
#if (NTDDI_VERSION >= 0x05020100)
    #define ClsContainerInitializing                0x01
    #define ClsContainerInactive                    0x02
    #define ClsContainerActive                      0x04
    #define ClsContainerActivePendingDelete         0x08
    #define ClsContainerPendingArchive              0x10
    #define ClsContainerPendingArchiveAndDelete     0x20
    #define ClfsContainerInitializing               0x01
    #define ClfsContainerInactive                   0x02
    #define ClfsContainerActive                     0x04
    #define ClfsContainerActivePendingDelete        0x08
    #define ClfsContainerPendingArchive             0x10
    #define ClfsContainerPendingArchiveAndDelete    0x20
#endif

/* Common log file system maximum container information size */
#if (NTDDI_VERSION >= 0x05020100)
    #define CLFS_MAX_CONTAINER_INFO 256
#endif

/* Common log file system scan modes */
#if (NTDDI_VERSION >= 0x05020100)
    #define CLFS_SCAN_INIT          0x01
    #define CLFS_SCAN_FORWARD       0x02
    #define CLFS_SCAN_BACKWARD      0x04
    #define CLFS_SCAN_CLOSE         0x08
    #define CLFS_SCAN_INITIALIZED   0x10
    #define CLFS_SCAN_BUFFERED      0x20
#endif

/* Common log file system log size limits */
#if (NTDDI_VERSION >= 0x05020100)
    #define CLFS_LOG_SIZE_MINIMUM   0x0000000000000000LL
    #define CLFS_LOG_SIZE_MAXIMUM   0xFFFFFFFFFFFFFFFFLL
#endif

/* Common log file system management policy version number */
#if (NTDDI_VERSION >= 0x05020100)
    #define CLFS_MGMT_POLICY_VERSION    0x00000001L
#endif

/* Log policy flags */
#if (NTDDI_VERSION >= 0x05020100)
    #define LOG_POLICY_OVERWRITE    0x00000001L
    #define LOG_POLICY_PERSIST      0x00000002L
#endif

/* Common log file system management client registration version number */
#if (NTDDI_VERSION >= 0x05020100)
    #define CLFS_MGMT_CLIENT_REGISTRATION_VERSION   0x00000001L
#endif

/* PCW version numbers */
#define PCW_VERSION_1       0x0100
#define PCW_CURRENT_VERSION PCW_VERSION_1

/* Opaque data types */
typedef struct _CALLBACK_OBJECT                 *PCALLBACK_OBJECT;
#ifdef _NTIFS_H_INCLUDED
typedef struct _KPROCESS                        *PEPROCESS;
typedef struct _KTHREAD                         *PETHREAD;
#else
typedef struct _EPROCESS                        *PEPROCESS;
typedef struct _ETHREAD                         *PETHREAD;
#endif
typedef struct _IO_TIMER                        *PIO_TIMER;
typedef struct _KINTERRUPT                      *PKINTERRUPT;
typedef struct _KTHREAD                         *PKTHREAD;
typedef struct _KTHREAD                         *PRKTHREAD;
typedef struct _KPROCESS                        *PKPROCESS;
typedef struct _KPROCESS                        *PRKPROCESS;
typedef struct _OBJECT_TYPE                     *POBJECT_TYPE;
typedef struct _CONTEXT                         *PCONTEXT;
typedef struct _FILE_GET_QUOTA_INFORMATION      *PFILE_GET_QUOTA_INFORMATION;
typedef struct _EX_RUNDOWN_REF_CACHE_AWARE      *PEX_RUNDOWN_REF_CACHE_AWARE;
typedef struct _CALLBACK_OBJECT                 *PCALLBACK_OBJECT;
typedef struct _IO_REMOVE_LOCK_TRACKING_BLOCK   *PIO_REMOVE_LOCK_TRACKING_BLOCK;
typedef struct _IO_WORKITEM                     *PIO_WORKITEM;
#ifdef _NTDDK_H_INCLUDED
typedef struct _ADAPTER_OBJECT                  *PADAPTER_OBJECT;
#else
typedef struct _DMA_ADAPTER                     *PADAPTER_OBJECT;
#endif
typedef struct _KTRANSACTION                    KTRANSACTION;
typedef struct _KTRANSACTION                    *PKTRANSACTION;
typedef struct _KTRANSACTION                    *PRKTRANSACTION;
typedef struct _KENLISTMENT                     KENLISTMENT;
typedef struct _KENLISTMENT                     *PKENLISTMENT;
typedef struct _KENLISTMENT                     *PRKENLISTMENT;
typedef struct _KRESOURCEMANAGER                KRESOURCEMANAGER;
typedef struct _KRESOURCEMANAGER                *PKRESOURCEMANAGER;
typedef struct _KRESOURCEMANAGER                *PRKRESOURCEMANAGER;
typedef struct _KTM                             KTM;
typedef struct _KTM                             *PKTM;
typedef struct _KTM                             *PRKTM;
typedef struct _PCW_INSTANCE                    *PPCW_INSTANCE;
typedef struct _PCW_REGISTRATION                *PPCW_REGISTRATION;
typedef struct _PCW_BUFFER                      *PPCW_BUFFER;

/* Opaque data types related to security */
typedef PVOID   PACCESS_TOKEN;
typedef PVOID   PSECURITY_DESCRIPTOR;
typedef PVOID   PSID;

/* Generic mapping */
typedef struct _GENERIC_MAPPING {
    ACCESS_MASK GenericRead;
    ACCESS_MASK GenericWrite;
    ACCESS_MASK GenericExecute;
    ACCESS_MASK GenericAll;
} GENERIC_MAPPING;
typedef GENERIC_MAPPING *PGENERIC_MAPPING;

/* LUID and attributes */
#pragma pack( __push, 4 )
typedef struct _LUID_AND_ATTRIBUTES {
    LUID    Luid;
    ULONG   Attributes;
} LUID_AND_ATTRIBUTES;
typedef LUID_AND_ATTRIBUTES *PLUID_AND_ATTRIBUTES;
#pragma pack( __pop )

/* Access control list */
typedef struct _ACL {
    UCHAR   AclRevision;
    UCHAR   Sbz1;
    USHORT  AclSize;
    USHORT  AceCount;
    USHORT  Sbz2;
} ACL;
typedef ACL *PACL;

/* Privilege set */
typedef struct _PRIVILEGE_SET {
    ULONG               PrivilegeCount;
    ULONG               Control;
    LUID_AND_ATTRIBUTES Privilege[ANYSIZE_ARRAY];
} PRIVILEGE_SET;
typedef PRIVILEGE_SET   *PPRIVILEGE_SET;

/* Security impersonation levels */
typedef enum _SECURITY_IMPERSONATION_LEVEL {
    SecurityAnonymous,
    SecurityIdentification,
    SecurityImpersonation,
    SecurityDelegation
} SECURITY_IMPERSONATION_LEVEL;
typedef SECURITY_IMPERSONATION_LEVEL* PSECURITY_IMPERSONATION_LEVEL;

/* Security quality of service */
typedef struct _SECURITY_QUALITY_OF_SERVICE {
    ULONG                           Length;
    SECURITY_IMPERSONATION_LEVEL    ImpersonationLevel;
    SECURITY_CONTEXT_TRACKING_MODE  ContextTrackingMode;
    BOOLEAN                         EffectiveOnly;
} SECURITY_QUALITY_OF_SERVICE;
typedef SECURITY_QUALITY_OF_SERVICE *PSECURITY_QUALITY_OF_SERVICE;

/* Security impersonation state */
typedef struct _SE_IMPERSONATION_STATE {
    PACCESS_TOKEN                   Token;
    BOOLEAN                         CopyOnOpen;
    BOOLEAN                         EffectiveOnly;
    SECURITY_IMPERSONATION_LEVEL    Level;
} SE_IMPERSONATION_STATE;
typedef SE_IMPERSONATION_STATE  *PSE_IMPERSONATION_STATE;

/* Security audit parameter types */
typedef enum _SE_ADT_PARAMETER_TYPE {
    SeAdtParmTypeNone               = 0,
    SeAdtParmTypeString             = 1,
    SeAdtParmTypeFileSpec           = 2,
    SeAdtParmTypeUlong              = 3,
    SeAdtParmTypeSid                = 4,
    SeAdtParmTypeLogonId            = 5,
    SeAdtParmTypeNoLogonId          = 6,
    SeAdtParmTypeAccessMask         = 7,
    SeAdtParmTypePrivs              = 8,
    SeAdtParmTypeObjectTypes        = 9,
    SeAdtParmTypeHexUlong           = 10,
    SeAdtParmTypePtr                = 11,
    SeAdtParmTypeTime               = 12,
    SeAdtParmTypeGuid               = 13,
    SeAdtParmTypeLuid               = 14,
    SeAdtParmTypeHexInt64           = 15,
    SeAdtParmTypeStringList         = 16,
    SeAdtParmTypeSidList            = 17,
    SeAdtParmTypeDuration           = 18,
    SeAdtParmTypeUserAccountControl = 19,
    SeAdtParmTypeNoUac              = 20,
    SeAdtParmTypeMessage            = 21,
    SeAdtParmTypeDateTime           = 22,
    SeAdtParmTypeSockAddr           = 23,
    SeAdtParmTypeSD                 = 24,
    SeAdtParmTypeLogonHours         = 25,
    SeAdtParmTypeLogonIdNoSid       = 26,
    SeAdtParmTypeUlongNoConv        = 27,
    SeAdtParmTypeSockAddrNoPort     = 28,
    SeAdtParmTypeAccessReason       = 29
} SE_ADT_PARAMETER_TYPE;
typedef SE_ADT_PARAMETER_TYPE   *PSE_ADT_PARAMETER_TYPE;

/* Security audit object type */
typedef struct _SE_ADT_OBJECT_TYPE {
    GUID        ObjectType;
    USHORT      Flags;
    USHORT      Level;
    ACCESS_MASK AccessMask;
} SE_ADT_OBJECT_TYPE;
typedef SE_ADT_OBJECT_TYPE  *PSE_ADT_OBJECT_TYPE;

/* Security audit parameter array entry */
typedef struct _SE_ADT_PARAMETER_ARRAY_ENTRY {
    SE_ADT_PARAMETER_TYPE   Type;
    ULONG                   Length;
    ULONG_PTR               Data[2];
    PVOID                   Address;
} SE_ADT_PARAMETER_ARRAY_ENTRY;
typedef SE_ADT_PARAMETER_ARRAY_ENTRY    *PSE_ADT_PARAMETER_ARRAY_ENTRY;

/* Security audit access reason */
typedef struct _SE_ADT_ACCESS_REASON {
    ACCESS_MASK             AccessMask;
    ULONG                   AccessReasons[32];
    ULONG                   ObjectTypeIndex;
    ULONG                   AccessGranted;
    PSECURITY_DESCRIPTOR    SecurityDescriptor;
} SE_ADT_ACCESS_REASON;
typedef SE_ADT_ACCESS_REASON    *PSE_ADT_ACCESS_REASON;

/* Security audit parameter array */
typedef struct _SE_ADT_PARAMETER_ARRAY {
    ULONG                           CategoryId;
    ULONG                           AuditId;
    ULONG                           ParameterCount;
    ULONG                           Length;
    USHORT                          FlatSubCategoryId;
    USHORT                          Type;
    ULONG                           Flags;
    SE_ADT_PARAMETER_ARRAY_ENTRY    Parameters[SE_MAX_AUDIT_PARAMETERS];
} SE_ADT_PARAMETER_ARRAY;
typedef SE_ADT_PARAMETER_ARRAY  *PSE_ADT_PARAMETER_ARRAY;

/* Kernel system time */
typedef struct _KSYSTEM_TIME {
    ULONG   LowPart;
    LONG    High1Time;
    LONG    High2Time;
} KSYSTEM_TIME;
typedef KSYSTEM_TIME    *PKSYSTEM_TIME;

/* Kernel spin lock queue numbers */
typedef enum _KSPIN_LOCK_QUEUE_NUMBER {
    LockQueueExpansionLock      = 1,
    LockQueueSystemSpaceLock    = 3,
    LockQueueVacbLock           = 4,
    LockQueueMasterLock         = 5,
    LockQueueNonPagedPoolLock   = 6,
    LockQueueIoCancelLock       = 7,
    LockQueueWorkQueueLock      = 8,
    LockQueueIoVpbLock          = 9,
    LockQueueIoDatabaseLock     = 10,
    LockQueueIoCompletionLock   = 11,
    LockQueueNtfsStructLock     = 12,
    LockQueueAfdWorkQueueLock   = 13,
    LockQueueBcbLock            = 14,
    LockQueueMmNonPagedPoolLock = 15,
    LockQueueMaximumLock        = 17
} KSPIN_LOCK_QUEUE_NUMBER;
typedef KSPIN_LOCK_QUEUE_NUMBER *PKSPIN_LOCK_QUEUE_NUMBER;

/* Kernel spin lock queue */
typedef struct _KSPIN_LOCK_QUEUE {
    struct _KSPIN_LOCK_QUEUE * volatile Next;
    PKSPIN_LOCK volatile                Lock;
} KSPIN_LOCK_QUEUE;
typedef KSPIN_LOCK_QUEUE    *PKSPIN_LOCK_QUEUE;

/* Kernel lock queue handle */
typedef struct _KLOCK_QUEUE_HANDLE {
    KSPIN_LOCK_QUEUE    LockQueue;
    KIRQL               OldIrql;
} KLOCK_QUEUE_HANDLE;
typedef KLOCK_QUEUE_HANDLE  *PKLOCK_QUEUE_HANDLE;

/* Kernel interrupt routine */
typedef VOID        NTAPI KINTERRUPT_ROUTINE( VOID );
typedef KINTERRUPT_ROUTINE  *PKINTERRUPT_ROUTINE;

/* Kernel profile sources */
typedef enum _KPROFILE_SOURCE {
    ProfileTime                 = 0,
    ProfileAlignmentFixup       = 1,
    ProfileTotalIssues          = 2,
    ProfilePipelineDry          = 3,
    ProfileLoadInstructions     = 4,
    ProfilePipelineFrozen       = 5,
    ProfileBranchInstructions   = 6,
    ProfileTotalNonissues       = 7,
    ProfileDcacheMisses         = 8,
    ProfileIcacheMisses         = 9,
    ProfileCacheMisses          = 10,
    ProfileBranchMispredictions = 11,
    ProfileStoreInstructions    = 12,
    ProfileFpInstructions       = 13,
    ProfileIntegerInstructions  = 14,
    Profile2Issue               = 15,
    Profile3Issue               = 16,
    Profile4Issue               = 17,
    ProfileSpecialInstructions  = 18,
    ProfileTotalCycles          = 19,
    ProfileIcacheIssues         = 20,
    ProfileDcacheAccesses       = 21,
    ProfileMemoryBarrierCycles  = 22,
    ProfileLoadLinkedIssues     = 23,
    ProfileMaximum              = 24
} KPROFILE_SOURCE;

/* 128-bit register */
typedef struct _M128A {
    ULONGLONG   Low;
    LONGLONG    High;
} M128A;
typedef M128A   *PM128A;

/* Extended save format */
typedef struct _XSAVE_FORMAT {
    USHORT  ControlWord;
    USHORT  StatusWord;
    UCHAR   TagWord;
    UCHAR   Reserved1;
    USHORT  ErrorOpcode;
    ULONG   ErrorOffset;
    USHORT  ErrorSelector;
    USHORT  Reserved2;
    ULONG   DataOffset;
    USHORT  DataSelector;
    USHORT  Reserved3;
    ULONG   MxCsr;
    ULONG   MxCsr_Mask;
    M128A   FloatRegisters[8];
    M128A   XmmRegisters[8];
    UCHAR   Reserved4[192];
    ULONG   StackControl[7];
    ULONG   Cr0NpxState;
} XSAVE_FORMAT;
typedef XSAVE_FORMAT    *PXSAVE_FORMAT;

/* Extended save area header */
typedef struct _XSAVE_AREA_HEADER {
    ULONG64 Mask;
    ULONG64 Reserved[7];
} XSAVE_AREA_HEADER;
typedef XSAVE_AREA_HEADER   *PXSAVE_AREA_HEADER;

/* Extended save area */
typedef struct _XSAVE_AREA {
    XSAVE_FORMAT        LegacyState;
    XSAVE_AREA_HEADER   Header;
} XSAVE_AREA;
typedef XSAVE_AREA  *PXSAVE_AREA;

/* Extended state context */
typedef struct _XSTATE_CONTEXT {
    ULONG64     Mask;
    ULONG       Length;
    ULONG       Reserved1;
    PXSAVE_AREA Area;
#ifdef _X86_
    ULONG       Reserved2;
#endif
    PVOID       Buffer;
#ifdef _X86_
    ULONG       Reserved3;
#endif
} XSTATE_CONTEXT;
typedef XSTATE_CONTEXT  *PXSTATE_CONTEXT;

/* Context chunk */
typedef struct _CONTEXT_CHUNK {
    LONG    Offset;
    ULONG   Length;
} CONTEXT_CHUNK;
typedef CONTEXT_CHUNK   *PCONTEXT_CHUNK;

/* Extended context */
typedef struct _CONTEXT_EX {
    CONTEXT_CHUNK   All;
    CONTEXT_CHUNK   Legacy;
    CONTEXT_CHUNK   XState;
} CONTEXT_EX;
typedef CONTEXT_EX  *PCONTEXT_EX;

/* I/O status block */
typedef struct _IO_STATUS_BLOCK {
    union {
        NTSTATUS    Status;
        PVOID       Pointer;
    };
    ULONG_PTR   Information;
} IO_STATUS_BLOCK;
typedef IO_STATUS_BLOCK *PIO_STATUS_BLOCK;

/* I/O asynchronous procedure call routine */
typedef VOID        (NTAPI *PIO_APC_ROUTINE)( PVOID, PIO_STATUS_BLOCK, ULONG );

/* I/O session events */
typedef enum _IO_SESSION_EVENT {
    IoSessionEventIgnore        = 0,
    IoSessionEventCreated       = 1,
    IoSessionEventTerminated    = 2,
    IoSessionEventConnected     = 3,
    IoSessionEventDisconnected  = 4,
    IoSessionEventLogon         = 5,
    IoSessionEventLogoff        = 6,
    IoSessionEventMax           = 7
} IO_SESSION_EVENT;
typedef IO_SESSION_EVENT    *PIO_SESSION_EVENT;

/* I/O session states */
typedef enum _IO_SESSION_STATE {
    IoSessionStateCreated               = 1,
    IoSessionStateInitialized           = 2,
    IoSessionStateConnected             = 3,
    IoSessionStateDisconnected          = 4,
    IoSessionStateDisconnectedLoggedOn  = 5,
    IoSessionStateLoggedOn              = 6,
    IoSessionStateLoggedOff             = 7,
    IoSessionStateTerminated            = 8,
    IoSessionStateMax                   = 9
} IO_SESSION_STATE;
typedef IO_SESSION_STATE    *PIO_SESSION_STATE;

/* I/O session connect information */
typedef struct _IO_SESSION_CONNECT_INFO {
    ULONG   SessionId;
    BOOLEAN LocalSession;
} IO_SESSION_CONNECT_INFO;
typedef IO_SESSION_CONNECT_INFO *PIO_SESSION_CONNECT_INFO;

/* File information classes */
typedef enum _FILE_INFORMATION_CLASS {
    FileDirectoryInformation            = 1,
    FileFullDirectoryInformation        = 2,
    FileBothDirectoryInformation        = 3,
    FileBasicInformation                = 4,
    FileStandardInformation             = 5,
    FileInternalInformation             = 6,
    FileEaInformation                   = 7,
    FileAccessInformation               = 8,
    FileNameInformation                 = 9,
    FileRenameInformation               = 10,
    FileLinkInformation                 = 11,
    FileNamesInformation                = 12,
    FileDispositionInformation          = 13,
    FilePositionInformation             = 14,
    FileFullEaInformation               = 15,
    FileModeInformation                 = 16,
    FileAlignmentInformation            = 17,
    FileAllInformation                  = 18,
    FileAllocationInformation           = 19,
    FileEndOfFileInformation            = 20,
    FileAlternateNameInformation        = 21,
    FileStreamInformation               = 22,
    FilePipeInformation                 = 23,
    FilePipeLocalInformation            = 24,
    FilePipeRemoteInformation           = 25,
    FileMailslotQueryInformation        = 26,
    FileMailslotSetInformation          = 27,
    FileCompressionInformation          = 28,
    FileObjectIdInformation             = 29,
    FileCompletionInformation           = 30,
    FileMoveClusterInformation          = 31,
    FileQuotaInformation                = 32,
    FileReparsePointInformation         = 33,
    FileNetworkOpenInformation          = 34,
    FileAttributeTagInformation         = 35,
    FileTrackingInformation             = 36,
    FileIdBothDirectoryInformation      = 37,
    FileIdFullDirectoryInformation      = 38,
    FileValidDataLengthInformation      = 39,
    FileShortNameInformation            = 40,
    FileIoCompletionNotificationInformation = 41,
    FileIoStatusBlockRangeInformation   = 42,
    FileIoPriorityHintInformation       = 43,
    FileSfioReserveInformation          = 44,
    FileSfioVolumeInformation           = 45,
    FileHardLinkInformation             = 46,
    FileProcessIdsUsingFileInformation  = 47,
    FileNormalizedNameInformation       = 48,
    FileNetworkPhysicalNameInformation  = 49,
    FileIdGlobalTxDirectoryInformation  = 50,
    FileIsRemoteDeviceInformation       = 51,
    FileAttributeCacheInformation       = 52,
    FileNumaNodeInformation             = 53,
    FileStandardLinkInformation         = 54,
    FileRemoteProtocolInformation       = 55,
    FileMaximumInformation              = 56
} FILE_INFORMATION_CLASS;
typedef FILE_INFORMATION_CLASS  *PFILE_INFORMATION_CLASS;

/* File basic information */
typedef struct _FILE_BASIC_INFORMATION {
    LARGE_INTEGER   CreationTime;
    LARGE_INTEGER   LastAccessTime;
    LARGE_INTEGER   LastWriteTime;
    LARGE_INTEGER   ChangeTime;
    ULONG           FileAttributes;
} FILE_BASIC_INFORMATION;
typedef FILE_BASIC_INFORMATION  *PFILE_BASIC_INFORMATION;

/* File standard information */
typedef struct _FILE_STANDARD_INFORMATION {
    LARGE_INTEGER   AllocationSize;
    LARGE_INTEGER   EndOfFile;
    ULONG           NumberOfLinks;
    BOOLEAN         DeletePending;
    BOOLEAN         Directory;
} FILE_STANDARD_INFORMATION;
typedef FILE_STANDARD_INFORMATION   *PFILE_STANDARD_INFORMATION;

/* File position information */
typedef struct _FILE_POSITION_INFORMATION {
    LARGE_INTEGER   CurrentByteOffset;
} FILE_POSITION_INFORMATION;
typedef FILE_POSITION_INFORMATION   *PFILE_POSITION_INFORMATION;

/* File network open information */
typedef struct _FILE_NETWORK_OPEN_INFORMATION {
    LARGE_INTEGER   CreationTime;
    LARGE_INTEGER   LastAccessTime;
    LARGE_INTEGER   LastWriteTime;
    LARGE_INTEGER   ChangeTime;
    LARGE_INTEGER   AllocationSize;
    LARGE_INTEGER   EndOfFile;
    ULONG           FileAttributes;
} FILE_NETWORK_OPEN_INFORMATION;
typedef FILE_NETWORK_OPEN_INFORMATION   *PFILE_NETWORK_OPEN_INFORMATION;

/* File full extended attribute information */
typedef struct _FILE_FULL_EA_INFORMATION {
    ULONG   NextEntryOffset;
    UCHAR   Flags;
    UCHAR   EaNameLength;
    USHORT  EaValueLength;
    CHAR    EaName[1];
} FILE_FULL_EA_INFORMATION;
typedef FILE_FULL_EA_INFORMATION    *PFILE_FULL_EA_INFORMATION;

/* File SFIO reserve information */
typedef struct _FILE_SFIO_RESERVE_INFORMATION {
    ULONG   RequestsPerPeriod;
    ULONG   Period;
    BOOLEAN RetryFailures;
    BOOLEAN Discardable;
    ULONG   RequestSize;
    ULONG   NumOutstandingRequests;
} FILE_SFIO_RESERVE_INFORMATION;
typedef FILE_SFIO_RESERVE_INFORMATION   *PFILE_SFIO_RESERVE_INFORMATION;

/* File SFIO volume information */
typedef struct _FILE_SFIO_VOLUME_INFORMATION {
    ULONG   MaximumRequestsPerPeriod;
    ULONG   MinimumPeriod;
    ULONG   MinimumTransferSize;
} FILE_SFIO_VOLUME_INFORMATION;
typedef FILE_SFIO_VOLUME_INFORMATION    *PFILE_SFIO_VOLUME_INFORMATION;

/* I/O priority hints */
typedef enum _IO_PRIORITY_HINT {
    IoPriorityVeryLow   = 0,
    IoPriorityLow       = 1,
    IoPriorityNormal    = 2,
    IoPriorityHigh      = 3,
    IoPriorityCritical  = 4,
    MaxIoPriorityTypes  = 5
} IO_PRIORITY_HINT;

/* File I/O priority hint information */
typedef struct _FILE_IO_PRIORITY_HINT_INFORMATION {
    IO_PRIORITY_HINT    PriorityHint;
} FILE_IO_PRIORITY_HINT_INFORMATION;
typedef FILE_IO_PRIORITY_HINT_INFORMATION   *PFILE_IO_PRIORITY_HINT_INFORMATION;

/* File I/O completion notification information */
typedef struct _FILE_IO_COMPLETION_NOTIFICATION_INFORMATION {
    ULONG   Flags;
} FILE_IO_COMPLETION_NOTIFICATION_INFORMATION;
typedef FILE_IO_COMPLETION_NOTIFICATION_INFORMATION *PFILE_IO_COMPLETION_NOTIFICATION_INFORMATION;

/* File process identifiers using file information */
typedef struct _FILE_PROCESS_IDS_USING_FILE_INFORMATION {
    ULONG       NumberOfProcessIdsInList;
    ULONG_PTR   ProcessIdList[1];
} FILE_PROCESS_IDS_USING_FILE_INFORMATION;
typedef FILE_PROCESS_IDS_USING_FILE_INFORMATION *PFILE_PROCESS_IDS_USING_FILE_INFORMATION;

/* File is remote device information */
typedef struct _FILE_IS_REMOTE_DEVICE_INFORMATION {
    BOOLEAN IsRemote;
} FILE_IS_REMOTE_DEVICE_INFORMATION;
typedef FILE_IS_REMOTE_DEVICE_INFORMATION   *PFILE_IS_REMOTE_DEVICE_INFORMATION;

/* File numa node information */
typedef struct _FILE_NUMA_NODE_INFORMATION {
    USHORT  NodeNumber;
} FILE_NUMA_NODE_INFORMATION;
typedef FILE_NUMA_NODE_INFORMATION  *PFILE_NUMA_NODE_INFORMATION;

/* File I/O status block information */
typedef struct _FILE_IOSTATUSBLOCK_RANGE_INFORMATION {
    PUCHAR  IoStatusBlockRange;
    ULONG   Length;
} FILE_IOSTATUSBLOCK_RANGE_INFORMATION;
typedef FILE_IOSTATUSBLOCK_RANGE_INFORMATION    *PFILE_IOSTATUSBLOCK_RANGE_INFORMATION;

/* File system information classes */
typedef enum _FSINFOCLASS {
    FileFsVolumeInformation         = 1,
    FileFsLabelInformation          = 2,
    FileFsSizeInformation           = 3,
    FileFsDeviceInformation         = 4,
    FileFsAttributeInformation      = 5,
    FileFsControlInformation        = 6,
    FileFsFullSizeInformation       = 7,
    FileFsObjectIdInformation       = 8,
    FileFsDriverPathInformation     = 9,
    FileFsVolumeFlagsInformation    = 10,
    FileFsMaximumInformation        = 11
} FS_INFORMATION_CLASS;
typedef FS_INFORMATION_CLASS    *PFS_INFORMATION_CLASS;

/* File system device information */
typedef struct _FILE_FS_DEVICE_INFORMATION {
    DEVICE_TYPE DeviceType;
    ULONG       Characteristics;
} FILE_FS_DEVICE_INFORMATION;
typedef FILE_FS_DEVICE_INFORMATION  *PFILE_FS_DEVICE_INFORMATION;

/* Interface types */
typedef enum _INTERFACE_TYPE {
    InterfaceTypeUndefined  = -1,
    Internal                = 0,
    Isa                     = 1,
    Eisa                    = 2,
    MicroChannel            = 3,
    TurboChannel            = 4,
    PCIBus                  = 5,
    VMEBus                  = 6,
    NuBus                   = 7,
    PCMCIABus               = 8,
    CBus                    = 9,
    MPIBus                  = 10,
    MPSABus                 = 11,
    ProcessorInternal       = 12,
    InternalPowerBus        = 13,
    PNPISABus               = 14,
    PNPBus                  = 15,
    Vmcs                    = 16,
    MaximumInterfaceType    = 17
} INTERFACE_TYPE;
typedef INTERFACE_TYPE  *PINTERFACE_TYPE;

/* DMA widths */
typedef enum _DMA_WIDTH {
    Width8Bits      = 0,
    Width16Bits     = 1,
    Width32Bits     = 2,
    MaximumDmaWidth = 3
} DMA_WIDTH;
typedef DMA_WIDTH   *PDMA_WIDTH;

/* DMA speeds */
typedef enum _DMA_SPEED {
    Compatible      = 0,
    TypeA           = 1,
    TypeB           = 2,
    TypeC           = 3,
    TypeF           = 4,
    MaximumDmaSpeed = 5
} DMA_SPEED;
typedef DMA_SPEED   *PDMA_SPEED;

/* Interface referencing routines */
typedef VOID        (NTAPI *PINTERFACE_REFERENCE)( PVOID );
typedef VOID        (NTAPI *PINTERFACE_DEREFERENCE)( PVOID );

/* I/O error log packet */
typedef struct _IO_ERROR_LOG_PACKET {
    UCHAR           MajorFunctionCode;
    UCHAR           RetryCount;
    USHORT          DumpDataSize;
    USHORT          NumberOfStrings;
    USHORT          StringOffset;
    USHORT          EventCategory;
    NTSTATUS        ErrorCode;
    ULONG           UniqueErrorValue;
    NTSTATUS        FinalStatus;
    ULONG           SequenceNumber;
    ULONG           IoControlCode;
    LARGE_INTEGER   DeviceOffset;
    ULONG           DumpData[1];
} IO_ERROR_LOG_PACKET;
typedef IO_ERROR_LOG_PACKET *PIO_ERROR_LOG_PACKET;

/* I/O error log message */
typedef struct _IO_ERROR_LOG_MESSAGE {
    USHORT              Type;
    USHORT              Size;
    USHORT              DriverNameLength;
    LARGE_INTEGER       TimeStamp;
    ULONG               DriverNameOffset;
    IO_ERROR_LOG_PACKET EntryData;
} IO_ERROR_LOG_MESSAGE;
typedef IO_ERROR_LOG_MESSAGE    *PIO_ERROR_LOG_MESSAGE;

/* Registry key basic information */
typedef struct _KEY_BASIC_INFORMATION {
    LARGE_INTEGER   LastWriteTime;
    ULONG           TitleIndex;
    ULONG           NameLength;
    WCHAR           Name[1];
} KEY_BASIC_INFORMATION;
typedef KEY_BASIC_INFORMATION   *PKEY_BASIC_INFORMATION;

/* Registry key node information */
typedef struct _KEY_NODE_INFORMATION {
    LARGE_INTEGER   LastWriteTime;
    ULONG           TitleIndex;
    ULONG           ClassOffset;
    ULONG           ClassLength;
    ULONG           NameLength;
    WCHAR           Name[1];
} KEY_NODE_INFORMATION;
typedef KEY_NODE_INFORMATION    *PKEY_NODE_INFORMATION;

/* Registry key full information */
typedef struct _KEY_FULL_INFORMATION {
    LARGE_INTEGER   LastWriteTime;
    ULONG           TitleIndex;
    ULONG           ClassOffset;
    ULONG           ClassLength;
    ULONG           SubKeys;
    ULONG           MaxNameLen;
    ULONG           MaxClassLen;
    ULONG           Values;
    ULONG           MaxValueNameLen;
    ULONG           MaxValueDataLen;
    WCHAR           Class[1];
} KEY_FULL_INFORMATION;
typedef KEY_FULL_INFORMATION    *PKEY_FULL_INFORMATION;

/* Registry key information classes */
typedef enum _KEY_INFORMATION_CLASS {
    KeyBasicInformation             = 0,
    KeyNodeInformation              = 1,
    KeyFullInformation              = 2,
    KeyNameInformation              = 3,
    KeyCachedInformation            = 4,
    KeyFlagsInformation             = 5,
    KeyVirtualizationInformation    = 6,
    KeyHandleTagsInformation        = 7,
    MaxKeyInfoClass                 = 8
} KEY_INFORMATION_CLASS;

/* Registry key write time information */
typedef struct _KEY_WRITE_TIME_INFORMATION {
    LARGE_INTEGER   LastWriteTime;
} KEY_WRITE_TIME_INFORMATION;
typedef KEY_WRITE_TIME_INFORMATION  *PKEY_WRITE_TIME_INFORMATION;

/* Registry key WOW64 flags information */
typedef struct _KEY_WOW64_FLAGS_INFORMATION {
    ULONG   UserFlags;
} KEY_WOW64_FLAGS_INFORMATION;
typedef KEY_WOW64_FLAGS_INFORMATION *PKEY_WOW64_FLAGS_INFORMATION;

/* Registry key handle tags information */
typedef struct _KEY_HANDLE_TAGS_INFORMATION {
    ULONG   HandleTags;
} KEY_HANDLE_TAGS_INFORMATION;
typedef KEY_HANDLE_TAGS_INFORMATION *PKEY_HANDLE_TAGS_INFORMATION;

/* Registry key control flags information */
typedef struct _KEY_CONTROL_FLAGS_INFORMATION {
    ULONG   ControlFlags;
} KEY_CONTROL_FLAGS_INFORMATION;
typedef KEY_CONTROL_FLAGS_INFORMATION   *PKEY_CONTROL_FLAGS_INFORMATION;

/* Registry key set virtualization information */
typedef struct _KEY_SET_VIRTUALIZATION_INFORMATION {
    ULONG   VirtualTarget   : 1;
    ULONG   VirtualStore    : 1;
    ULONG   VirtualSource   : 1;
    ULONG   Reserved        : 29;
} KEY_SET_VIRTUALIZATION_INFORMATION;
typedef KEY_SET_VIRTUALIZATION_INFORMATION  *PKEY_SET_VIRTUALIZATION_INFORMATION;

/* Registry set information classes */
typedef enum _KEY_SET_INFORMATION_CLASS {
    KeyWriteTimeInformation         = 0,
    KeyWow64FlagsInformation        = 1,
    KeyControlFlagsInformation      = 2,
    KeySetVirtualizationInformation = 3,
    KeySetDebugInformation          = 4,
    KeySetHandleTagsInformation     = 5,
    MaxKeySetInfoClass              = 6
} KEY_SET_INFORMATION_CLASS;

/* Registry key value basic information */
typedef struct _KEY_VALUE_BASIC_INFORMATION {
    ULONG   TitleIndex;
    ULONG   Type;
    ULONG   NameLength;
    WCHAR   Name[1];
} KEY_VALUE_BASIC_INFORMATION;
typedef KEY_VALUE_BASIC_INFORMATION *PKEY_VALUE_BASIC_INFORMATION;

/* Registry key value full information */
typedef struct _KEY_VALUE_FULL_INFORMATION {
    ULONG   TitleIndex;
    ULONG   Type;
    ULONG   DataOffset;
    ULONG   DataLength;
    ULONG   NameLength;
    WCHAR   Name[1];
} KEY_VALUE_FULL_INFORMATION;
typedef KEY_VALUE_FULL_INFORMATION  *PKEY_VALUE_FULL_INFORMATION;

/* Registry key value partial information */
typedef struct _KEY_VALUE_PARTIAL_INFORMATION {
    ULONG   TitleIndex;
    ULONG   Type;
    ULONG   DataLength;
    UCHAR   Data[1];
} KEY_VALUE_PARTIAL_INFORMATION;
typedef KEY_VALUE_PARTIAL_INFORMATION   *PKEY_VALUE_PARTIAL_INFORMATION;

/* Registry key value partial information (64-bit version) */
typedef struct _KEY_VALUE_PARTIAL_INFORMATION_ALIGN64 {
    ULONG   Type;
    ULONG   DataLength;
    UCHAR   Data[1];
} KEY_VALUE_PARTIAL_INFORMATION_ALIGN64;
typedef KEY_VALUE_PARTIAL_INFORMATION_ALIGN64   *PKEY_VALUE_PARTIAL_INFORMATION_ALIGN64;

/* Registry key value entry */
typedef struct _KEY_VALUE_ENTRY {
    PUNICODE_STRING ValueName;
    ULONG           DataLength;
    ULONG           DataOffset;
    ULONG           Type;
} KEY_VALUE_ENTRY;
typedef KEY_VALUE_ENTRY *PKEY_VALUE_ENTRY;

/* Registry key value information classes */
typedef enum _KEY_VALUE_INFORMATION_CLASS {
    KeyValueBasicInformation            = 0,
    KeyValueFullInformation             = 1,
    KeyValuePartialInformation          = 2,
    KeyValueFullInformationAlign64      = 3,
    KeyValuePartialInformationAlign64   = 4,
    MaxKeyValueInfoClass                = 5
} KEY_VALUE_INFORMATION_CLASS;

/* Object name information */
typedef struct _OBJECT_NAME_INFORMATION {
    UNICODE_STRING  Name;
} OBJECT_NAME_INFORMATION;
typedef OBJECT_NAME_INFORMATION *POBJECT_NAME_INFORMATION;

/* Section inherit values */
typedef enum _SECTION_INHERIT {
    ViewShare   = 1,
    ViewUnmap   = 2
} SECTION_INHERIT;

/* Client identifier */
typedef struct _CLIENT_ID {
    HANDLE  UniqueProcess;
    HANDLE  UniqueThread;
} CLIENT_ID;
typedef CLIENT_ID   *PCLIENT_ID;

/* System power states */
typedef enum _SYSTEM_POWER_STATE {
    PowerSystemUnspecified  = 0,
    PowerSystemWorking      = 1,
    PowerSystemSleeping1    = 2,
    PowerSystemSleeping2    = 3,
    PowerSystemSleeping3    = 4,
    PowerSystemHibernate    = 5,
    PowerSystemShutdown     = 6,
    PowerSystemMaximum      = 7
} SYSTEM_POWER_STATE;
typedef SYSTEM_POWER_STATE  *PSYSTEM_POWER_STATE;

/* Power actions */
typedef enum {
    PowerActionNone             = 0,
    PowerActionReserved         = 1,
    PowerActionSleep            = 2,
    PowerActionHibernate        = 3,
    PowerActionShutdown         = 4,
    PowerActionShutdownReset    = 5,
    PowerActionShutdownOff      = 6,
    PowerActionWarmEject        = 7
} POWER_ACTION;
typedef POWER_ACTION    *PPOWER_ACTION;

/* Device power states */
typedef enum _DEVICE_POWER_STATE {
    PowerDeviceUnspecified  = 0,
    PowerDeviceD0           = 1,
    PowerDeviceD1           = 2,
    PowerDeviceD2           = 3,
    PowerDeviceD3           = 4,
    PowerDeviceMaximum      = 5
} DEVICE_POWER_STATE;
typedef DEVICE_POWER_STATE  *PDEVICE_POWER_STATE;

/* Monitor display states */
typedef enum _MONITOR_DISPLAY_STATE {
    PowerMonitorOff = 0,
    PowerMonitorOn  = 1,
    PowerMonitorDim = 2
} MONITOR_DISPLAY_STATE;
typedef MONITOR_DISPLAY_STATE   *PMONITOR_DISPLAY_STATE;

/* Power state */
typedef union _POWER_STATE {
    SYSTEM_POWER_STATE  SystemState;
    DEVICE_POWER_STATE  DeviceState;
} POWER_STATE;
typedef POWER_STATE *PPOWER_STATE;

/* Power state types */
typedef enum _POWER_STATE_TYPE {
    SystemPowerState    = 0,
    DevicePowerState    = 1
} POWER_STATE_TYPE;
typedef POWER_STATE_TYPE    *PPOWER_STATE_TYPE;

/* System power state context */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _SYSTEM_POWER_STATE_CONTEXT {
    union {
        struct {
            ULONG   Reserved1               : 8;
            ULONG   TargetSystemState       : 4;
            ULONG   EffectiveSystemState    : 4;
            ULONG   CurrentSystemState      : 4;
            ULONG   IgnoreHibernationPath   : 1;
            ULONG   PseudoTransition        : 1;
            ULONG   Reserved2               : 10;
        };
        ULONG   ContextAsUlong;
    };
} SYSTEM_POWER_STATE_CONTEXT;
typedef SYSTEM_POWER_STATE_CONTEXT  *PSYSTEM_POWER_STATE_CONTEXT;
#endif

/* Counted reason context */
#if (NTDDI_VERSION >= 0x06010000)
typedef struct _COUNTED_REASON_CONTEXT {
    ULONG   Version;
    ULONG   Flags;
    union {
        struct {
            UNICODE_STRING  ResourceFileName;
            USHORT          ResourceReasonId;
            ULONG           StringCount;
            PUNICODE_STRING ReasonStrings;
        };
        UNICODE_STRING  SimpleString;
    };
} COUNTED_REASON_CONTEXT;
typedef COUNTED_REASON_CONTEXT  *PCOUNTED_REASON_CONTEXT;
#endif

/* Latency time values */
typedef enum {
    LT_DONT_CARE,
    LT_LOWEST_LATENCY
} LATENCY_TIME;

/* Power request types */
typedef enum _POWER_REQUEST_TYPE {
    PowerRequestDisplayRequired     = 0,
    PowerRequestSystemRequired      = 1,
    PowerRequestAwayModeRequired    = 2
} POWER_REQUEST_TYPE;
typedef POWER_REQUEST_TYPE  *PPOWER_REQUEST_TYPE;

/* Power data */
#if (NTDDI_VERSION >= 0x05010000)
typedef struct CM_Power_Data_s {
    ULONG               PD_Size;
    DEVICE_POWER_STATE  PD_MostRecentPowerState;
    ULONG               PD_Capabilities;
    ULONG               PD_D1Latency;
    ULONG               PD_D2Latency;
    ULONG               PD_D3Latency;
    DEVICE_POWER_STATE  PD_PowerStateMapping[POWER_SYSTEM_MAXIMUM];
    SYSTEM_POWER_STATE  PD_DeepestSystemWake;
} CM_POWER_DATA;
typedef CM_POWER_DATA   *PCM_POWER_DATA;
#endif

/* Power information levels */
typedef enum {
    SystemPowerPolicyAc             = 0,
    SystemPowerPolicyDc             = 1,
    VerifySystemPolicyAc            = 2,
    VerifySystemPolicyDc            = 3,
    SystemPowerCapabilities         = 4,
    SystemBatteryState              = 5,
    SystemPowerStateHandler         = 6,
    ProcessorStateHandler           = 7,
    SystemPowerPolicyCurrent        = 8,
    AdministratorPowerPolicy        = 9,
    SystemReserveHiberFile          = 10,
    ProcessorInformation            = 11,
    SystemPowerInformation          = 12,
    ProcessorStateHandler2          = 13,
    LastWakeTime                    = 14,
    LastSleepTime                   = 15,
    SystemExecutionState            = 16,
    SystemPowerStateNotifyHandler   = 17,
    ProcessorPowerPolicyAc          = 18,
    ProcessorPowerPolicyDc          = 19,
    VerifyProcessorPowerPolicyAc    = 20,
    VerifyProcessorPowerPolicyDc    = 21,
    ProcessorPowerPolicyCurrent     = 22,
    SystemPowerStateLogging         = 23,
    SystemPowerLoggingEntry         = 24,
    SetPowerSettingValue            = 25,
    NotifyUserPowerSetting          = 26,
    SystemVideoState                = 29,
    TraceApplicationPowerMessage    = 30,
    TraceApplicationPowerMessageEnd = 31,
    ProcessorPerfStates             = 32,
    ProcessorIdleStates             = 33,
    ProcessorCap                    = 34,
    SystemWakeSource                = 35,
    SystemHiberFileInformation      = 36,
    TraceServicePowerMessage        = 37,
    ProcessorLoad                   = 38,
    PowerShutdownNotification       = 39,
    MonitorCapabilities             = 40,
    SessionPowerInit                = 41,
    SessionDisplayState             = 42,
    PowerRequestCreate              = 43,
    PowerRequestAction              = 44,
    GetPowerRequestList             = 45,
    ProcessorInformationEx          = 46,
    NotifyUserModeLegacyPowerEvent  = 47,
    GroupPark                       = 48,
    ProcessorIdleDomains            = 49,
    WakeTimerList                   = 50,
    SystemHiberFileSize             = 51,
    PowerInformationLevelMaximum    = 52
} POWER_INFORMATION_LEVEL;

/* System power conditions */
typedef enum {
    PoAc,
    PoDc,
    PoHot,
    PoConditionMaximum
} SYSTEM_POWER_CONDITION;

/* Structure to set a power setting */
typedef struct {
    ULONG                   Version;
    GUID                    Guid;
    SYSTEM_POWER_CONDITION  PowerCondition;
    ULONG                   DataLength;
    UCHAR                   Data[ANYSIZE_ARRAY];
} SET_POWER_SETTING_VALUE;
typedef SET_POWER_SETTING_VALUE *PSET_POWER_SETTING_VALUE;

/* User power setting notification information */
typedef struct {
    GUID    Guid;
} NOTIFY_USER_POWER_SETTING;
typedef NOTIFY_USER_POWER_SETTING   *PNOTIFY_USER_POWER_SETTING;

/* Application launch setting value */
typedef struct _APPLICATIONLAUNCH_SETTING_VALUE {
    LARGE_INTEGER   ActivationTime;
    ULONG           Flags;
    ULONG           ButtonInstanceID;
} APPLICATIONLAUNCH_SETTING_VALUE;
typedef APPLICATIONLAUNCH_SETTING_VALUE *PAPPLICATIONLAUNCH_SETTING_VALUE;

/* Power platform roles */
typedef enum {
    PlatformRoleUnspecified         = 0,
    PlatformRoleDesktop             = 1,
    PlatformRoleMobile              = 2,
    PlatformRoleWorkstation         = 3,
    PlatformRoleEnterpriseServer    = 4,
    PlatformRoleSOHOServer          = 5,
    PlatformRoleAppliancePC         = 6,
    PlatformRolePerformanceServer   = 7,
    PlatformRoleMaximum             = 8
} POWER_PLATFORM_ROLE;

/* Battery reporting scale */
#if (NTDDI_VERSION >= 0x05010000)
typedef struct {
    ULONG   Granularity;
    ULONG   Capacity;
} BATTERY_REPORTING_SCALE;
typedef BATTERY_REPORTING_SCALE *PBATTERY_REPORTING_SCALE;
#endif

/* Service node types */
typedef enum _CM_SERVICE_NODE_TYPE {
    DriverType                  = SERVICE_KERNEL_DRIVER,
    FileSystemType              = SERVICE_FILE_SYSTEM_DRIVER,
    Win32ServiceOwnProcess      = SERVICE_WIN32_OWN_PROCESS,
    Win32ServiceShareProcess    = SERVICE_WIN32_SHARE_PROCESS,
    AdapterType                 = SERVICE_ADAPTER,
    RecognizerType              = SERVICE_RECOGNIZER_DRIVER
} SERVICE_NODE_TYPE;

/* Service load types */
typedef enum _CM_SERVICE_LOAD_TYPE {
    BootLoad    = SERVICE_BOOT_START,
    SystemLoad  = SERVICE_SYSTEM_START,
    AutoLoad    = SERVICE_AUTO_START,
    DemandLoad  = SERVICE_DEMAND_START,
    DisableLoad = SERVICE_DISABLED
} SERVICE_LOAD_TYPE;

/* Service error control types */
typedef enum _CM_ERROR_CONTROL_TYPE {
    IgnoreError     = SERVICE_ERROR_IGNORE,
    NormalError     = SERVICE_ERROR_NORMAL,
    SevereError     = SERVICE_ERROR_SEVERE,
    CriticalError   = SERVICE_ERROR_CRITICAL
} SERVICE_ERROR_TYPE;

/* Share dispositions */
typedef enum _CM_SHARE_DISPOSITION {
    CmResourceShareUndetermined     = 0,
    CmResourceShareDeviceExclusive  = 1,
    CmResourceShareDriverExclusive  = 2,
    CmResourceShareShared           = 3
} CM_SHARE_DISPOSITION;

/* Partial resource descriptor */
#pragma pack( __push, 4 )
typedef struct _CM_PARTIAL_RESOURCE_DESCRIPTOR {
    UCHAR   Type;
    UCHAR   ShareDisposition;
    USHORT  Flags;
    union {
        struct {
            PHYSICAL_ADDRESS    Start;
            ULONG               Length;
        } Generic;
        struct {
            PHYSICAL_ADDRESS    Start;
            ULONG               Length;
        } Port;
        struct {
#ifdef NT_PROCESSOR_GROUPS
            USHORT      Level;
            USHORT      Group;
#else
            ULONG       Level;
#endif
            ULONG       Vector;
            KAFFINITY   Affinity;
        } Interrupt;
        struct {
            union {
                struct {
#ifdef NT_PROCESSOR_GROUPS
                    USHORT      Group;
#else
                    USHORT      Reserved;
#endif
                    USHORT      MessageCount;
                    ULONG       Vector;
                    KAFFINITY   Affinity;
                } Raw;
                struct {
#ifdef NT_PROCESSOR_GROUPS
                    USHORT      Level;
                    USHORT      Group;
#else
                    ULONG       Level;
#endif
                    ULONG       Vector;
                    KAFFINITY   Affinity;
                } Translated;
            };
        } MessageInterrupt;
        struct {
            PHYSICAL_ADDRESS    Start;
            ULONG               Length;
        } Memory;
        struct {
            ULONG   Channel;
            ULONG   Port;
            ULONG   Reserved1;
        } Dma;
        struct {
            ULONG   Data[3];
        } DevicePrivate;
        struct {
            ULONG   Start;
            ULONG   Length;
            ULONG   Reserved;
        } BusNumber;
        struct {
            ULONG   DataSize;
            ULONG   Reserved1;
            ULONG   Reserved2;
        } DeviceSpecificData;
        struct {
            PHYSICAL_ADDRESS    Start;
            ULONG               Length40;
        } Memory40;
        struct {
            PHYSICAL_ADDRESS    Start;
            ULONG               Length48;
        } Memory48;
        struct {
            PHYSICAL_ADDRESS    Start;
            ULONG               Length64;
        } Memory64;
    } u;
} CM_PARTIAL_RESOURCE_DESCRIPTOR;
typedef CM_PARTIAL_RESOURCE_DESCRIPTOR  *PCM_PARTIAL_RESOURCE_DESCRIPTOR;
#pragma pack( __pop )

/* Partial resource list */
typedef struct _CM_PARTIAL_RESOURCE_LIST {
    USHORT                          Version;
    USHORT                          Revision;
    ULONG                           Count;
    CM_PARTIAL_RESOURCE_DESCRIPTOR  PartialDescriptors[1];
} CM_PARTIAL_RESOURCE_LIST;
typedef CM_PARTIAL_RESOURCE_LIST    *PCM_PARTIAL_RESOURCE_LIST;

/* Full resource descriptor */
typedef struct _CM_FULL_RESOURCE_DESCRIPTOR {
    INTERFACE_TYPE              InterfaceType;
    ULONG                       BusNumber;
    CM_PARTIAL_RESOURCE_LIST    PartialResourceList;
} CM_FULL_RESOURCE_DESCRIPTOR;
typedef CM_FULL_RESOURCE_DESCRIPTOR *PCM_FULL_RESOURCE_DESCRIPTOR;

/* Resource list */
typedef struct _CM_RESOURCE_LIST {
    ULONG                       Count;
    CM_FULL_RESOURCE_DESCRIPTOR List[1];
} CM_RESOURCE_LIST;
typedef CM_RESOURCE_LIST    *PCM_RESOURCE_LIST;

/* Device flags */
typedef struct _DEVICE_FLAGS {
    ULONG   Failed      : 1;
    ULONG   ReadOnly    : 1;
    ULONG   Removable   : 1;
    ULONG   ConsoleIn   : 1;
    ULONG   ConsoleOut  : 1;
    ULONG   Input       : 1;
    ULONG   Output      : 1;
} DEVICE_FLAGS;
typedef DEVICE_FLAGS    *PDEVICE_FLAGS;

/* Component information */
typedef struct _CM_COMPONENT_INFORMATION {
    DEVICE_FLAGS    Flags;
    ULONG           Version;
    ULONG           Key;
    KAFFINITY       AffinityMask;
} CM_COMPONENT_INFORMATION;
typedef CM_COMPONENT_INFORMATION    *PCM_COMPONENT_INFORMATION;

/* ROM block */
typedef struct _CM_ROM_BLOCK {
    ULONG   Address;
    ULONG   Size;
} CM_ROM_BLOCK;
typedef CM_ROM_BLOCK    *PC_ROM_BLOCK;

/* The following structures get one-byte packing. */
#pragma pack( __push, 1 )

/* Interrupt 13 drive parameter */
typedef struct _CM_INT13_DRIVE_PARAMETER {
    USHORT  DriveSelect;
    ULONG   MaxCylinders;
    USHORT  SectorsPerTrack;
    USHORT  MaxHeads;
    USHORT  NumberDrives;
} CM_INT13_DRIVE_PARAMETER;
typedef CM_INT13_DRIVE_PARAMETER    *PCM_INT13_DRIVE_PARAMETER;

/* MCA POS data */
typedef struct _CM_MCA_POS_DATA {
    USHORT  AdapterId;
    UCHAR   PosData1;
    UCHAR   PosData2;
    UCHAR   PosData3;
    UCHAR   PosData4;
} CM_MCA_POS_DATA;
typedef CM_MCA_POS_DATA *PCM_MCA_POS_DATA;

/* EISA memory type */
typedef struct _EISA_MEMORY_TYPE {
    UCHAR   ReadWrite   : 1;
    UCHAR   Cached      : 1;
    UCHAR   Reserved0   : 1;
    UCHAR   Type        : 2;
    UCHAR   Shared      : 1;
    UCHAR   Reserved1   : 1;
    UCHAR   MoreEntries : 1;
} EISA_MEMORY_TYPE;
typedef EISA_MEMORY_TYPE    *PEISA_MEMORY_TYPE;

/* EISA memory configuration */
typedef struct _EISA_MEMORY_CONFIGURATION {
    EISA_MEMORY_TYPE    ConfigurationByte;
    UCHAR               DataSize;
    USHORT              AddressLowWord;
    UCHAR               AddressHighByte;
    USHORT              MemorySize;
} EISA_MEMORY_CONFIGURATION;
typedef EISA_MEMORY_CONFIGURATION   *PEISA_MEMORY_CONFIGURATION;

/* EISA IRQ descriptor */
typedef struct _EISA_IRQ_DESCRIPTOR {
    UCHAR   Interrupt       : 4;
    UCHAR   Reserved        : 1;
    UCHAR   LevelTriggered  : 1;
    UCHAR   Shared          : 1;
    UCHAR   MoreEntries     : 1;
} EISA_IRQ_DESCRIPTOR;
typedef EISA_IRQ_DESCRIPTOR *PEISA_IRQ_DESCRIPTOR;

/* EISA IRQ configuration */
typedef struct _EISA_IRQ_CONFIGURATION {
    EISA_IRQ_DESCRIPTOR ConfigurationByte;
    UCHAR               Reserved;
} EISA_IRQ_CONFIGURATION;
typedef EISA_IRQ_CONFIGURATION  *PEISA_IRQ_CONFIGURATION;

/* DMA configuration byte 0 */
typedef struct _DMA_CONFIGURATION_BYTE0 {
    UCHAR   Channel     : 3;
    UCHAR   Reserved    : 3;
    UCHAR   Shared      : 1;
    UCHAR   MoreEntries : 1;
} DMA_CONFIGURATION_BYTE0;

/* DMA configuration byte 1 */
typedef struct _DMA_CONFIGURATION_BYTE1 {
    UCHAR   Reserved0       : 2;
    UCHAR   TransferSize    : 2;
    UCHAR   Timing          : 2;
    UCHAR   Reserved1       : 2;
} DMA_CONFIGURATION_BYTE1;

/* EISA DMA configuration */
typedef struct _EISA_DMA_CONFIGURATION {
    DMA_CONFIGURATION_BYTE0 ConfigurationByte0;
    DMA_CONFIGURATION_BYTE1 ConfigurationByte1;
} EISA_DMA_CONFIGURATION;
typedef EISA_DMA_CONFIGURATION  *PEISA_DMA_CONFIGURATION;

/* EISA port descriptor */
typedef struct _EISA_PORT_DESCRIPTOR {
    UCHAR   NumberPorts : 5;
    UCHAR   Reserved    : 1;
    UCHAR   Shared      : 1;
    UCHAR   MoreEntries : 1;
} EISA_PORT_DESCRIPTOR;
typedef EISA_PORT_DESCRIPTOR    *PEISA_PORT_DESCRIPTOR;

/* EISA port configuration */
typedef struct _EISA_PORT_CONFIGURATION {
    EISA_PORT_DESCRIPTOR    Configuration;
    USHORT                  PortAddress;
} EISA_PORT_CONFIGURATION;
typedef EISA_PORT_CONFIGURATION *PEISA_PORT_CONFIGURATION;

/* EISA slot information */
typedef struct _CM_EISA_SLOT_INFORMATION {
    UCHAR   ReturnCode;
    UCHAR   ReturnFlags;
    UCHAR   MajorRevision;
    UCHAR   MinorRevision;
    USHORT  Checksum;
    UCHAR   NumberFunctions;
    UCHAR   FunctionInformation;
    ULONG   CompressedId;
} CM_EISA_SLOT_INFORMATION;
typedef CM_EISA_SLOT_INFORMATION    *PCM_EISA_SLOT_INFORMATION;

/* EISA function information */
typedef struct _CM_EISA_FUNCTION_INFORMATION {
    ULONG                       CompressedId;
    UCHAR                       IdSlotFlags1;
    UCHAR                       IdSlotFlags2;
    UCHAR                       MinorRevision;
    UCHAR                       MajorRevision;
    UCHAR                       Selections[256];
    UCHAR                       FunctionFlags;
    UCHAR                       TypeString[80];
    EISA_MEMORY_CONFIGURATION   EisaMemory[9];
    EISA_IRQ_CONFIGURATION      EisaIrq[7];
    EISA_DMA_CONFIGURATION      EisaDma[4];
    EISA_PORT_CONFIGURATION     EisaPort[20];
    UCHAR                       InitializationData[60];
} CM_EISA_FUNCTION_INFORMATION;
typedef CM_EISA_FUNCTION_INFORMATION    *PCM_EISA_FUNCTION_INFORMATION;

/* Plug and Play BIOS device node */
typedef struct _CM_PNP_BIOS_DEVICE_NODE {
    USHORT  Size;
    UCHAR   Node;
    ULONG   ProductId;
    UCHAR   DeviceType[3];
    USHORT  DeviceAttributes;
} CM_PNP_BIOS_DEVICE_NODE;
typedef CM_PNP_BIOS_DEVICE_NODE *PCM_PNP_BIOS_DEVICE_NODE;

/* Plug and Play BIOS installation check */
typedef struct _CM_PNP_BIOS_INSTALLATION_CHECK {
    UCHAR   Signature[4];
    UCHAR   Revision;
    UCHAR   Length;
    USHORT  ControlField;
    UCHAR   Checksum;
    ULONG   EventFlagAddress;
    USHORT  RealModeEntryOffset;
    USHORT  RealModeEntrySegment;
    USHORT  ProtectedModeEntryOffset;
    ULONG   ProtectedModeCodeBaseAddress;
    ULONG   OemDeviceId;
    USHORT  RealModeDataBaseAddress;
    ULONG   ProtectedModeDataBaseAddress;
} CM_PNP_BIOS_INSTALLATION_CHECK;
typedef CM_PNP_BIOS_INSTALLATION_CHECK  *PCM_PNP_BIOS_INSTALLATION_CHECK;

/* Revert to default packing. */
#pragma pack( __pop )

/* SCSI device data */
typedef struct _CM_SCSI_DEVICE_DATA {
    USHORT  Version;
    USHORT  Revision;
    UCHAR   HostIdentifier;
} CM_SCSI_DEVICE_DATA;
typedef CM_SCSI_DEVICE_DATA *PCM_SCSI_DEVICE_DATA;

/* Video device data */
typedef struct _CM_VIDEO_DEVICE_DATA {
    USHORT  Version;
    USHORT  Revision;
    ULONG   VideoClock;
} CM_VIDEO_DEVICE_DATA;
typedef CM_VIDEO_DEVICE_DATA    *PCM_VIDEO_DEVICE_DATA;

/* Sonic device data */
typedef struct _CM_SONIC_DEVICE_DATA {
    USHORT  Version;
    USHORT  Revision;
    USHORT  DataConfigurationRegister;
    UCHAR   EthernetAddress[8];
} CM_SONIC_DEVICE_DATA;
typedef CM_SONIC_DEVICE_DATA    *PCM_SONIC_DEVICE_DATA;

/* Serial device data */
typedef struct _CM_SERIAL_DEVICE_DATA {
    USHORT  Version;
    USHORT  Revision;
    ULONG   BaudClock;
} CM_SERIAL_DEVICE_DATA;
typedef CM_SERIAL_DEVICE_DATA   *PCM_SERIAL_DEVICE_DATA;

/* Monitor device data */
typedef struct _CM_MONITOR_DEVICE_DATA {
    USHORT  Version;
    USHORT  Revision;
    USHORT  HorizontalScreenSize;
    USHORT  VerticalScreenSize;
    USHORT  HorizontalResolution;
    USHORT  VerticalResolution;
    USHORT  HorizontalDisplayTimeLow;
    USHORT  HorizontalDisplayTime;
    USHORT  HorizontalDisplayTimeHigh;
    USHORT  HorizontalBackPorchLow;
    USHORT  HorizontalBackPorch;
    USHORT  HorizontalBackPorchHigh;
    USHORT  HorizontalFrontPorchLow;
    USHORT  HorizontalFrontPorch;
    USHORT  HorizontalFrontPorchHigh;
    USHORT  HorizontalSyncLow;
    USHORT  HorizontalSync;
    USHORT  HorizontalSyncHigh;
    USHORT  VerticalBackPorchLow;
    USHORT  VerticalBackPorch;
    USHORT  VerticalBackPorchHigh;
    USHORT  VerticalFrontPorchLow;
    USHORT  VerticalFrontPorch;
    USHORT  VerticalFrontPorchHigh;
    USHORT  VerticalSyncLow;
    USHORT  VerticalSync;
    USHORT  VerticalSyncHigh;
} CM_MONITOR_DEVICE_DATA;
typedef CM_MONITOR_DEVICE_DATA  *PCM_MONITOR_DEVICE_DATA;

/* Floppy device data */
typedef struct _CM_FLOPPY_DEVICE_DATA {
    USHORT  Version;
    USHORT  Revision;
    CHAR    Size[8];
    ULONG   MaxDensity;
    ULONG   MountDensity;
    UCHAR   StepRateHeadUnloadTime;
    UCHAR   HeadLoadTime;
    UCHAR   MotorOffTime;
    UCHAR   SectorLengthCode;
    UCHAR   SectorPerTrack;
    UCHAR   ReadWriteGapLength;
    UCHAR   DataTransferLength;
    UCHAR   FormatGapLength;
    UCHAR   FormatFillCharacter;
    UCHAR   HeadSettleTime;
    UCHAR   MotorSettleTime;
    UCHAR   MaximumTrackValue;
    UCHAR   DataTransferRate;
} CM_FLOPPY_DEVICE_DATA;
typedef CM_FLOPPY_DEVICE_DATA   *PCM_FLOPPY_DEVICE_DATA;

/* Keyboard device data */
typedef struct _CM_KEYBOARD_DEVICE_DATA {
    USHORT  Version;
    USHORT  Revision;
    UCHAR   Type;
    UCHAR   Subtype;
    USHORT  KeyboardFlags;
} CM_KEYBOARD_DEVICE_DATA;
typedef CM_KEYBOARD_DEVICE_DATA *PCM_KEYBOARD_DEVICE_DATA;

/* Disk geometry device data */
typedef struct _CM_DISK_GEOMETRY_DEVICE_DATA {
    ULONG   BytesPerSector;
    ULONG   NumberOfCylinders;
    ULONG   SectorsPerTrack;
    ULONG   NumberOfHeads;
} CM_DISK_GEOMETRY_DEVICE_DATA;
typedef CM_DISK_GEOMETRY_DEVICE_DATA    *PCM_DISK_GEOMETRY_DEVICE_DATA;

/* IRQ device policies */
#ifdef NT_PROCESSOR_GROUPS
enum _IRQ_DEVICE_POLICY_USHORT {
    IrqPolicyMachineDefault                     = 0,
    IrqPolicyAllCloseProcessors                 = 1,
    IrqPolicyOneCloseProcessor                  = 2,
    IrqPolicyAllProcessorsInMachine             = 3,
    IrqPolicySpecifiedProcessors                = 4,
    IrqPolicySpreadMessagesAcrossAllProcessors  = 5
};
typedef USHORT              IRQ_DEVICE_POLICY;
#else
typedef enum _IRQ_DEVICE_POLICY {
    IrqPolicyMachineDefault                     = 0,
    IrqPolicyAllCloseProcessors                 = 1,
    IrqPolicyOneCloseProcessor                  = 2,
    IrqPolicyAllProcessorsInMachine             = 3,
    IrqPolicySpecifiedProcessors                = 4,
    IrqPolicySpreadMessagesAcrossAllProcessors  = 5
} IRQ_DEVICE_POLICY;
#endif
typedef IRQ_DEVICE_POLICY   *PIRQ_DEVICE_POLICY;

/* IRQ priorities */
typedef enum _IRQ_PRIORITY {
    IrqPriorityUndefined    = 0,
    IrqPriorityLow          = 1,
    IrqPriorityNormal       = 2,
    IrqPriorityHigh         = 3
} IRQ_PRIORITY;
typedef IRQ_PRIORITY    *PIRQ_PRIORITY;

/* IRQ group policy values */
typedef enum _IRQ_GROUP_POLICY {
    GroupAffinityAllGroupZero   = 0,
    GroupAffinityDontCare       = 1
} IRQ_GROUP_POLICY;
typedef IRQ_GROUP_POLICY    *PIRQ_GROUP_POLICY;

/* I/O resource descriptor */
typedef struct _IO_RESOURCE_DESCRIPTOR {
    UCHAR   Option;
    UCHAR   Type;
    UCHAR   ShareDisposition;
    UCHAR   Spare1;
    USHORT  Flags;
    USHORT  Spare2;
    union {
        struct {
            ULONG               Length;
            ULONG               Alignment;
            PHYSICAL_ADDRESS    MinimumAddress;
            PHYSICAL_ADDRESS    MaximumAddress;
        } Port;
        struct {
            ULONG               Length;
            ULONG               Alignment;
            PHYSICAL_ADDRESS    MinimumAddress;
            PHYSICAL_ADDRESS    MaximumAddress;
        } Memory;
        struct {
            ULONG               MinimumVector;
            ULONG               MaximumVector;
            IRQ_DEVICE_POLICY   AffinityPolicy;
#ifdef NT_PROCESSOR_GROUPS
            USHORT              Group;
#endif
            IRQ_PRIORITY        PriorityPolicy;
            KAFFINITY           TargetedProcessors;
        } Interrupt;
        struct {
            ULONG   MinimumChannel;
            ULONG   MaximumChannel;
        } Dma;
        struct {
            ULONG               Length;
            ULONG               Alignment;
            PHYSICAL_ADDRESS    MinimumAddress;
            PHYSICAL_ADDRESS    MaximumAddress;
        } Generic;
        struct {
            ULONG   Data[3];
        } DevicePrivate;
        struct {
            ULONG   Length;
            ULONG   MinBusNumber;
            ULONG   MaxBusNumber;
            ULONG   Reserved;
        } BusNumber;
        struct {
            ULONG   Priority;
            ULONG   Reserved1;
            ULONG   Reserved2;
        } ConfigData;
        struct {
            ULONG               Length40;
            ULONG               Alignment40;
            PHYSICAL_ADDRESS    MinimumAddress;
            PHYSICAL_ADDRESS    MaximumAddress;
        } Memory40;
        struct {
            ULONG               Length48;
            ULONG               Alignment48;
            PHYSICAL_ADDRESS    MinimumAddress;
            PHYSICAL_ADDRESS    MaximumAddress;
        } Memory48;
        struct {
            ULONG               Length64;
            ULONG               Alignment64;
            PHYSICAL_ADDRESS    MinimumAddress;
            PHYSICAL_ADDRESS    MaximumAddress;
        } Memory64;
    } u;
} IO_RESOURCE_DESCRIPTOR;
typedef IO_RESOURCE_DESCRIPTOR  *PIO_RESOURCE_DESCRIPTOR;

/* I/O resource list */
typedef struct _IO_RESOURCE_LIST {
    USHORT                  Version;
    USHORT                  Revision;
    ULONG                   Count;
    IO_RESOURCE_DESCRIPTOR  Descriptors[1];
} IO_RESOURCE_LIST;
typedef IO_RESOURCE_LIST    *PIO_RESOURCE_LIST;

/* I/O resource requirements list */
typedef struct _IO_RESOURCE_REQUIREMENTS_LIST {
    ULONG               ListSize;
    INTERFACE_TYPE      InterfaceType;
    ULONG               BusNumber;
    ULONG               SlotNumber;
    ULONG               Reserved[3];
    ULONG               AlternativeLists;
    IO_RESOURCE_LIST    List[1];
} IO_RESOURCE_REQUIREMENTS_LIST;
typedef IO_RESOURCE_REQUIREMENTS_LIST   *PIO_RESOURCE_REQUIREMENTS_LIST;

/* Interlocked singly linked list entry */
typedef struct _SLIST_ENTRY {
    struct _SLIST_ENTRY *Next;
} SLIST_ENTRY;
typedef SLIST_ENTRY *PSLIST_ENTRY;

/* Interlocked singly linked list header */
typedef union _SLIST_HEADER {
    ULONGLONG Alignment;
    struct {
        SLIST_ENTRY Next;
        USHORT       Depth;
        USHORT      Sequence;
    };
} SLIST_HEADER;
typedef SLIST_HEADER    *PSLIST_HEADER;
typedef SLIST_HEADER    SLIST_HEADER32;
typedef SLIST_HEADER    *PSLIST_HEADER32;

/* Query registry callback */
typedef NTSTATUS    NTAPI RTL_QUERY_REGISTRY_ROUTINE( PWSTR, ULONG, PVOID, ULONG, PVOID, PVOID );
typedef RTL_QUERY_REGISTRY_ROUTINE  *PRTL_QUERY_REGISTRY_ROUTINE;

/* Query registry table */
typedef struct _RTL_QUERY_REGISTRY_TABLE {
    PRTL_QUERY_REGISTRY_ROUTINE QueryRoutine;
    ULONG                       Flags;
    PWSTR                       Name;
    PVOID                       EntryContext;
    ULONG                       DefaultType;
    PVOID                       DefaultData;
    ULONG                       DefaultLength;
} RTL_QUERY_REGISTRY_TABLE;
typedef RTL_QUERY_REGISTRY_TABLE    *PRTL_QUERY_REGISTRY_TABLE;

/* Debug print callback */
#if (NTDDI_VERSION >= 0x06000000)
typedef VOID        (NTAPI *PDEBUG_PRINT_CALLBACK)( PSTRING, ULONG, ULONG );
#endif

/* Time fields */
typedef struct _TIME_FIELDS {
    CSHORT  Year;
    CSHORT  Month;
    CSHORT  Day;
    CSHORT  Hour;
    CSHORT  Minute;
    CSHORT  Second;
    CSHORT  Milliseconds;
    CSHORT  Weekday;
} TIME_FIELDS;
typedef TIME_FIELDS *PTIME_FIELDS;

/* Bitmap */
typedef struct _RTL_BITMAP {
    ULONG   SizeOfBitMap;
    PULONG  Buffer;
} RTL_BITMAP;
typedef RTL_BITMAP  *PRTL_BITMAP;

/* Bitmap run */
typedef struct _RTL_BITMAP_RUN {
    ULONG   StartingIndex;
    ULONG   NumberOfBits;
} RTL_BITMAP_RUN;
typedef RTL_BITMAP_RUN  *PRTL_BITMAP_RUN;

/* Transaction outcomes */
typedef enum _TRANSACTION_OUTCOME {
    TransactionOutcomeUndetermined  = 1,
    TransactionOutcomeCommitted     = 2,
    TransactionOutcomeAborted       = 3
} TRANSACTION_OUTCOME;

/* Transaction states */
typedef enum _TRANSACTION_STATE {
    TransactionStateNormal          = 1,
    TransactionStateIndoubt         = 2,
    TransactionStateCommittedNotify = 3
} TRANSACTION_STATE;

/* Transaction basic information */
typedef struct _TRANSACTION_BASIC_INFORMATION {
    GUID    TransactionId;
    ULONG   State;
    ULONG   Outcome;
} TRANSACTION_BASIC_INFORMATION;
typedef TRANSACTION_BASIC_INFORMATION   *PTRANSACTION_BASIC_INFORMATION;

/* Transaction manager basic information */
typedef struct _TRANSACTIONMANAGER_BASIC_INFORMATION {
    GUID            TmIdentity;
    LARGE_INTEGER   VirtualClock;
} TRANSACTIONMANAGER_BASIC_INFORMATION;
typedef TRANSACTIONMANAGER_BASIC_INFORMATION    *PTRANSACTIONMANAGER_BASIC_INFORMATION;

/* Transaction manager log information */
typedef struct _TRANSACTIONMANAGER_LOG_INFORMATION {
    GUID    LogIdentity;
} TRANSACTIONMANAGER_LOG_INFORMATION;
typedef TRANSACTIONMANAGER_LOG_INFORMATION  *PTRANSACTIONMANAGER_LOG_INFORMATION;

/* Transaction manager log path information */
typedef struct _TRANSACTIONMANAGER_LOGPATH_INFORMATION {
    ULONG   LogPathLength;
    WCHAR   LogPath[1];
} TRANSACTIONMANAGER_LOGPATH_INFORMATION;
typedef TRANSACTIONMANAGER_LOGPATH_INFORMATION  *PTRANSACTIONMANAGER_LOGPATH_INFORMATION;

/* Transaction manager recovery information */
typedef struct _TRANSACTIONMANAGER_RECOVERY_INFORMATION {
    ULONGLONG   LastRecoveredLsn;
} TRANSACTIONMANAGER_RECOVERY_INFORMATION;
typedef TRANSACTIONMANAGER_RECOVERY_INFORMATION *PTRANSACTIONMANAGER_RECOVERY_INFORMATION;

/* Transaction properties information */
typedef struct _TRANSACTION_PROPERTIES_INFORMATION {
    ULONG           IsolationLevel;
    ULONG           IsolationFlags;
    LARGE_INTEGER   Timeout;
    ULONG           Outcome;
    ULONG           DescriptionLength;
    WCHAR           Description[1];
} TRANSACTION_PROPERTIES_INFORMATION;
typedef TRANSACTION_PROPERTIES_INFORMATION  *PTRANSACTION_PROPERTIES_INFORMATION;

/* Transaction bind information */
typedef struct _TRANSACTION_BIND_INFORMATION {
    HANDLE  TmHandle;
} TRANSACTION_BIND_INFORMATION;
typedef TRANSACTION_BIND_INFORMATION    *PTRANSACTION_BIND_INFORMATION;

/* Transaction enlistment pair */
typedef struct _TRANSACTION_ENLISTMENT_PAIR {
    GUID    EnlistmentId;
    GUID    ResourceManagerId;
} TRANSACTION_ENLISTMENT_PAIR;
typedef TRANSACTION_ENLISTMENT_PAIR *PTRANSACTION_ENLISTMENT_PAIR;

/* Transaction enlistments information */
typedef struct _TRANSACTION_ENLISTMENTS_INFORMATION {
    ULONG                       NumberOfEnlistments;
    TRANSACTION_ENLISTMENT_PAIR EnlistmentPair[1];
} TRANSACTION_ENLISTMENTS_INFORMATION;
typedef TRANSACTION_ENLISTMENTS_INFORMATION *PTRANSACTION_ENLISTMENTS_INFORMATION;

/* Transaction superior enlistment information */
typedef struct _TRANSACTION_SUPERIOR_ENLISTMENT_INFORMATION {
    TRANSACTION_ENLISTMENT_PAIR SuperiorEnlistmentPair;
} TRANSACTION_SUPERIOR_ENLISTMENT_INFORMATION;
typedef TRANSACTION_SUPERIOR_ENLISTMENT_INFORMATION *PTRANSACTION_SUPERIOR_ENLISTMENT_INFORMATION;

/* Resource manager basic information */
typedef struct _RESOURCEMANAGER_BASIC_INFORMATION {
    GUID    ResourceManagerId;
    ULONG   DescriptionLength;
    WCHAR   Description[1];
} RESOURCEMANAGER_BASIC_INFORMATION;
typedef RESOURCEMANAGER_BASIC_INFORMATION   *PRESOURCEMANAGER_BASIC_INFORMATION;

/* Resource manager completion information */
typedef struct _RESOURCEMANAGER_COMPLETION_INFORMATION {
    HANDLE      IoCompletionPortHandle;
    ULONG_PTR   CompletionKey;
} RESOURCEMANAGER_COMPLETION_INFORMATION;
typedef RESOURCEMANAGER_COMPLETION_INFORMATION  *PRESOURCEMANAGER_COMPLETION_INFORMATION;

/* Transaction information classes */
typedef enum _TRANSACTION_INFORMATION_CLASS {
    TransactionBasicInformation                 = 0,
    TransactionPropertiesInformation            = 1,
    TransactionEnlistmentInformation            = 2,
    TransactionSuperiorEnlistmentInformation    = 3
} TRANSACTION_INFORMATION_CLASS;

/* Transaction manager information classes */
typedef enum _TRANSACTIONMANAGER_INFORMATION_CLASS {
    TransactionManagerBasicInformation          = 0,
    TransactionManagerLogInformation            = 1,
    TransactionManagerLogPathInformation        = 2,
    TransactionManagerRecoveryInformation       = 3
} TRANSACTIONMANAGER_INFORMATION_CLASS;

/* Resource manager information classes */
typedef enum _RESOURCEMANAGER_INFORMATION_CLASS {
    ResourceManagerBasicInformation         = 0,
    ResourceManagerCompletionInformation    = 1
} RESOURCEMANAGER_INFORMATION_CLASS;

/* Enlistment basic information */
typedef struct _ENLISTMENT_BASIC_INFORMATION {
    GUID    EnlistmentId;
    GUID    TransactionId;
    GUID    ResourceManagerId;
} ENLISTMENT_BASIC_INFORMATION;
typedef ENLISTMENT_BASIC_INFORMATION    *PENLISTMENT_BASIC_INFORMATION;

/* Enlistment CRM information */
typedef struct _ENLISTMENT_CRM_INFORMATION {
    GUID    CrmTransactionManagerId;
    GUID    CrmResourceManagerId;
    GUID    CrmEnlistmentId;
} ENLISTMENT_CRM_INFORMATION;
typedef ENLISTMENT_CRM_INFORMATION  *PENLISTMENT_CRM_INFORMATION;

/* Enlistment information classes */
typedef enum _ENLISTMENT_INFORMATION_CLASS {
    EnlistmentBasicInformation      = 0,
    EnlistmentRecoveryInformation   = 1,
    EnlistmentCrmInformation        = 2
} ENLISTMENT_INFORMATION_CLASS;

/* Transaction list entry */
typedef struct _TRANSACTION_LIST_ENTRY {
    UOW UOW;
} TRANSACTION_LIST_ENTRY;
typedef TRANSACTION_LIST_ENTRY  *PTRANSACTION_LIST_ENTRY;

/* Transaction list information */
typedef struct _TRANSACTION_LIST_INFORMATION {
    ULONG                   NumberOfTransactions;
    TRANSACTION_LIST_ENTRY  TransactionInformation[1];
} TRANSACTION_LIST_INFORMATION;
typedef TRANSACTION_LIST_INFORMATION    *PTRANSACTION_LIST_INFORMATION;

/* Kernel transaction manager object types */
typedef enum _KTMOBJECT_TYPE {
    KTMOBJECT_TRANSACTION           = 0,
    KTMOBJECT_TRANSACTION_MANAGER   = 1,
    KTMOBJECT_RESOURCE_MANAGER      = 2,
    KTMOBJECT_ENLISTMENT            = 3,
    KTMOBJECT_INVALID               = 4
} KTMOBJECT_TYPE;
typedef KTMOBJECT_TYPE  *PKTMOBJECT_TYPE;

/* Kernel transaction manager object cursor */
typedef struct _KTMOBJECT_CURSOR {
    GUID    LastQuery;
    ULONG   ObjectIdCount;
    GUID    ObjectIds[1];
} KTMOBJECT_CURSOR;
typedef KTMOBJECT_CURSOR    *PKTMOBJECT_CURSOR;

/* Pool types */
typedef enum _POOL_TYPE {
    NonPagedPool                            = 0,
    PagedPool                               = 1,
    NonPagedPoolMustSucceed                 = 2,
    DontUseThisType                         = 3,
    NonPagedPoolCacheAligned                = 4,
    PagedPoolCacheAligned                   = 5,
    NonPagedPoolCacheAlignedMustS           = 6,
    MaxPoolType                             = 7,
    NonPagedPoolSession                     = 32,
    PagedPoolSession                        = 33,
    NonPagedPoolMustSucceedSession          = 34,
    DontUseThisTypeSession                  = 35,
    NonPagedPoolCachedAlignedSession        = 36,
    PagedPoolCacheAlignedSession            = 37,
    NonPagedPoolCacheAlignedMustSSession    = 38
} POOL_TYPE;

/* Pool callbacks */
typedef PVOID       (NTAPI ALLOCATE_FUNCTION)( POOL_TYPE, SIZE_T, ULONG );
typedef VOID        (NTAPI FREE_FUNCTION)( PVOID );
typedef PVOID       (NTAPI ALLOCATE_FUNCTION_EX)( POOL_TYPE, SIZE_T, ULONG, struct _LOOKASIDE_LIST_EX * );
typedef VOID        (NTAPI FREE_FUNCTION_EX)( PVOID, struct _LOOKASIDE_LIST_EX * );
typedef ALLOCATE_FUNCTION       *PALLOCATE_FUNCTION;
typedef FREE_FUNCTION           *PFREE_FUNCTION;
typedef ALLOCATE_FUNCTION_EX    *PALLOCATE_FUNCTION_EX;
typedef FREE_FUNCTION_EX        *PFREE_FUNCTION_EX;

/* General lookaside layout */
#define GENERAL_LOOKASIDE_LAYOUT \
    union { \
        SLIST_HEADER        ListHead; \
        SINGLE_LIST_ENTRY   SingleListHead; \
    }; \
    USHORT      Depth; \
    USHORT      MaximumDepth; \
    ULONG       TotalAllocates; \
    union { \
        ULONG   AllocateMisses; \
        ULONG   AllocateHits; \
    }; \
    ULONG       TotalFrees; \
    union { \
        ULONG   FreeMisses; \
        ULONG   FreeHits; \
    }; \
    POOL_TYPE   Type; \
    ULONG       Tag; \
    ULONG       Size; \
    union { \
        PALLOCATE_FUNCTION_EX   AllocateEx; \
        PALLOCATE_FUNCTION      Allocate; \
    }; \
    union { \
        PFREE_FUNCTION_EX   FreeEx; \
        PFREE_FUNCTION      Free; \
    }; \
    LIST_ENTRY  ListEntry; \
    ULONG       LastTotalAllocates; \
    union { \
        ULONG   LastAllocateMisses; \
        ULONG   LastAllocateHits; \
    }; \
    ULONG       Future[2];

/* General lookaside */
typedef struct _GENERAL_LOOKASIDE {
    GENERAL_LOOKASIDE_LAYOUT
} GENERAL_LOOKASIDE;
typedef GENERAL_LOOKASIDE   *PGENERAL_LOOKASIDE;

/* General lookaside pool */
typedef struct _GENERAL_LOOKASIDE_POOL {
    GENERAL_LOOKASIDE_LAYOUT
} GENERAL_LOOKASIDE_POOL;
typedef GENERAL_LOOKASIDE_POOL  *PGENERAL_LOOKASIDE_POOL;

/* Modes */
typedef enum _MODE {
    KernelMode  = 0,
    UserMode    = 1,
    MaximumMode = 2
} MODE;

/* Asynchronous procedure call routines */
typedef VOID        (NTAPI KNORMAL_ROUTINE)( PVOID, PVOID, PVOID );
typedef KNORMAL_ROUTINE         *PKNORMAL_ROUTINE;
typedef VOID        (NTAPI KKERNEL_ROUTINE)( struct _KAPC *, PKNORMAL_ROUTINE *, PVOID *, PVOID *, PVOID * );
typedef VOID        (NTAPI KRUNDOWN_ROUTINE)( struct _KAPC * );
typedef BOOLEAN     (NTAPI KSYNCHRONIZE_ROUTINE)( PVOID );
typedef BOOLEAN     (NTAPI KTRANSFER_ROUTINE)( VOID );
typedef KKERNEL_ROUTINE         *PKKERNEL_ROUTINE;
typedef KRUNDOWN_ROUTINE        *PKRUNDOWN_ROUTINE;
typedef KSYNCHRONIZE_ROUTINE    *PKSYNCHRONIZE_ROUTINE;
typedef KTRANSFER_ROUTINE       *PKTRANSFER_ROUTINE;

/* Kernel asynchronous procedure call */
typedef struct _KAPC {
    UCHAR               Type;
    UCHAR               SpareByte0;
    UCHAR               Size;
    UCHAR               SpareByte1;
    ULONG               SpareLong0;
    struct _KTHREAD     *Thread;
    LIST_ENTRY          ApcListEntry;
    PKKERNEL_ROUTINE    KernelRoutine;
    PKRUNDOWN_ROUTINE   RundownRoutine;
    PKNORMAL_ROUTINE    NormalRoutine;
    PVOID               NormalContext;
    PVOID               SystemArgument1;
    PVOID               SystemArgument2;
    CCHAR               ApcStateIndex;
    KPROCESSOR_MODE     ApcMode;
    BOOLEAN             Inserted;
} KAPC;
typedef KAPC    *PKAPC;
typedef KAPC    *PRKAPC;

/* Deferred procedure call routine */
typedef VOID        (NTAPI KDEFERRED_ROUTINE)( struct _KDPC *, PVOID, PVOID, PVOID );
typedef KDEFERRED_ROUTINE   *PKDEFERRED_ROUTINE;

/* Kernel deferred procedure call importance values */
typedef enum _KDPC_IMPORTANCE {
    LowImportance           = 0,
    MediumImportance        = 1,
    HighImportance          = 2,
#if (NTDDI_VERSION >= 0x05000000)
    MediumHighImportance    = 3,
#endif
} KDPC_IMPORTANCE;

/* Kernel deferred procedure call */
typedef struct _KDPC {
    UCHAR               Type;
    UCHAR               Importance;
    volatile USHORT     Number;
    LIST_ENTRY          DpcListEntry;
    PKDEFERRED_ROUTINE  DeferredRoutine;
    PVOID               DeferredContext;
    PVOID               SystemArgument1;
    PVOID               SystemArgument2;
#if (NTDDI_VERSION >= 0x05000000)
    PVOID               DpcData;
#else
    PULONG              Lock;
#endif
} KDPC;
typedef KDPC    *PKDPC;
typedef KDPC    *PRKDPC;

/* Kernel interprocessor interrupt worker callback */
typedef VOID        (NTAPI KIPI_WORKER)( PKIPI_CONTEXT, PVOID, PVOID, PVOID );
typedef KIPI_WORKER *PKIPI_WORKER;

/* Kernel interprocessor interrupt counts */
typedef struct _KIPI_COUNTS {
    ULONG   Freeze;
    ULONG   Packet;
    ULONG   DPC;
    ULONG   APC;
    ULONG   FlushSingleTb;
    ULONG   FlushMultipleTb;
    ULONG   FlushEntireTb;
    ULONG   GenericCall;
    ULONG   ChangeColor;
    ULONG   SweepDcache;
    ULONG   SweepIcache;
    ULONG   SweepIcacheRange;
    ULONG   FlushIoBuffers;
    ULONG   GratuitousDPC;
} KIPI_COUNTS;
typedef KIPI_COUNTS *PKIPI_COUNTS;

/* Memory descriptor list */
typedef struct _MDL {
    struct _MDL         *Next;
    CSHORT              Size;
    CSHORT              MdlFlags;
    struct _EPROCESS    *Process;
    PVOID               MappedSystemVa;
    PVOID               StartVa;
    ULONG               ByteCount;
    ULONG               ByteOffset;
} MDL;
typedef MDL *PMDL;
typedef MDL *PMDLX;

/* Dispatcher header */
typedef struct _DISPATCHER_HEADER {
    union {
        struct {
            UCHAR   Type;
            union {
                union {
                    UCHAR   TimerControlFlags;
                    struct {
                        UCHAR   Absolute                : 1;
                        UCHAR   Coalescable             : 1;
                        UCHAR   KeepShifting            : 1;
                        UCHAR   EncodedTolerableDelay   : 5;
                    };
                };
                UCHAR   Abandoned;
                BOOLEAN Signalling;
            };
            union {
                union {
                    UCHAR   ThreadControlFlags;
                    struct {
                        UCHAR   CpuThrottled        : 1;
                        UCHAR   CycleProfiling      : 1;
                        UCHAR   CounterProfiling    : 1;
                        UCHAR   Reserved            : 5;
                    };
                };
                UCHAR   Hand;
                UCHAR   Size;
            };
            union {
                union {
                    UCHAR   TimerMiscFlags;
                    struct {
#ifdef _X86_
                        UCHAR           Index       : 1;
                        UCHAR           Processor   : TIMER_PROCESSOR_INDEX_BITS;
#else
                        UCHAR           Index       : TIMER_EXPIRED_INDEX_BITS;
#endif
                        UCHAR           Inserted    : 1;
                        volatile UCHAR  Expired     : 1;
                    };
                };
                union {
                    BOOLEAN DebugActive;
                    struct {
                        BOOLEAN ActiveDR7       : 1;
                        BOOLEAN Instrumented    : 1;
                        BOOLEAN Reserved2       : 4;
                        BOOLEAN UmsScheduled    : 1;
                        BOOLEAN UmsPrimary      : 1;
                    };
                };
                BOOLEAN DpcActive;
            };
        };
        volatile LONG   Lock;
    };
    LONG        SingalState;
    LIST_ENTRY  WaitListHead;
} DISPATCHER_HEADER;

/* Kernel event */
typedef struct _KEVENT {
    DISPATCHER_HEADER   Header;
} KEVENT;
typedef KEVENT  *PKEVENT;
typedef KEVENT  *PRKEVENT;

/* Kernel gate */
typedef struct _KGATE {
    DISPATCHER_HEADER   Header;
} KGATE;
typedef KGATE   *PKGATE;

/* Kernel timer */
typedef struct _KTIMER {
    DISPATCHER_HEADER   Header;
    ULARGE_INTEGER      DueTime;
    LIST_ENTRY          TimerListEntry;
    struct _KDPC        *Dpc;
#ifndef _X86_
    ULONG               Processor;
#endif
    ULONG               Period;
} KTIMER;
typedef KTIMER  *PKTIMER;
typedef KTIMER  *PRKTIMER;

/* Lock operations */
typedef enum _LOCK_OPERATION {
    IoReadAccess    = 0,
    IoWriteAccess   = 1,
    IoModifyAccess  = 2
} LOCK_OPERATION;

/* Kernel floating save area */
#ifdef _X86_
typedef struct _KFLOATING_SAVE {
    ULONG   ControlWord;
    ULONG   StatusWord;
    ULONG   ErrorOffset;
    ULONG   ErrorSelector;
    ULONG   DataOffset;
    ULONG   DataSelector;
    ULONG   Cr0NpxState;
    ULONG   Spare1;
} KFLOATING_SAVE;
typedef KFLOATING_SAVE  *PKFLOATING_SAVE;
#endif

/* AMD L1 cache information */
#ifdef _X86_
typedef union _AMD_L1_CACHE_INFO {
    ULONG   Ulong;
    struct {
        UCHAR   LineSize;
        UCHAR   LinesPerTag;
        UCHAR   Associativity;
        UCHAR   Size;
    };
} AMD_L1_CACHE_INFO;
typedef AMD_L1_CACHE_INFO   *PAMD_L1_CACHE_INFO;
#endif

/* AMD L2 cache information */
#ifdef _X86_
typedef union _AMD_L2_CACHE_INFO {
    ULONG   Ulong;
    struct {
        UCHAR   LineSize;
        UCHAR   LinesPerTag     : 4;
        UCHAR   Associativity   : 4;
        USHORT  Size;
    };
} AMD_L2_CACHE_INFO;
typedef AMD_L2_CACHE_INFO   *PAMD_L2_CACHE_INFO;
#endif

/* AMD L3 cache information */
#ifdef _X86_
typedef union _AMD_L3_CACHE_INFO {
    ULONG   Ulong;
    struct {
        UCHAR   LineSize;
        UCHAR   LinesPerTag     : 4;
        UCHAR   Associativity   : 4;
        USHORT  Reserved        : 2;
        USHORT  Size            : 14;
    };
} AMD_L3_CACHE_INFO;
typedef AMD_L3_CACHE_INFO   *PAMD_L3_CACHE_INFO;
#endif

/* Intel cache types */
#ifdef _X86_
typedef enum _INTEL_CACHE_TYPE {
    IntelCacheNull          = 0,
    IntelCacheData          = 1,
    IntelCacheInstruction   = 2,
    IntelCacheUnified       = 3,
    IntelCacheRam           = 4,
    IntelCacheTrace         = 5
} INTEL_CACHE_TYPE;
#endif

/* Intel EAX cache information */
#ifdef _X86_
typedef union INTEL_CACHE_INFO_EAX {
    ULONG   Ulong;
    struct {
        INTEL_CACHE_TYPE    Type                : 5;
        ULONG               Level               : 3;
        ULONG               SelfInitializing    : 1;
        ULONG               FullyAssociative    : 1;
        ULONG               Reserved            : 4;
        ULONG               ThreadsSharing      : 12;
        ULONG               ProcessorCores      : 6;
    };
} INTEL_CACHE_INFO_EAX;
typedef INTEL_CACHE_INFO_EAX    *PINTEL_CACHE_INFO_EAX;
#endif

/* Intel EBX cache information */
#ifdef _X86_
typedef union INTEL_CACHE_INFO_EBX {
    ULONG   Ulong;
    struct {
        ULONG   LineSize        : 12;
        ULONG   Partitions      : 10;
        ULONG   Associativity   : 10;
    };
} INTEL_CACHE_INFO_EBX;
typedef INTEL_CACHE_INFO_EBX    *PINTEL_CACHE_INFO_EBX;
#endif

/* Logical processor relationships */
typedef enum _LOGICAL_PROCESSOR_RELATIONSHIP {
    RelationProcessorCore       = 0,
    RelationNumaNode            = 1,
    RelationCache               = 2,
    RelationProcessorPackage    = 3,
    RelationGroup               = 4,
    RelationAll                 = 0xFFFF
} LOGICAL_PROCESSOR_RELATIONSHIP;

/* Processor cache types */
typedef enum _PROCESSOR_CACHE_TYPE {
    CacheUnified,
    CacheInstruction,
    CacheData,
    CacheTrace
} PROCESSOR_CACHE_TYPE;

/* Cache descriptor */
typedef struct _CACHE_DESCRIPTOR {
    UCHAR                   Level;
    UCHAR                   Associativity;
    USHORT                  LineSize;
    ULONG                   Size;
    PROCESSOR_CACHE_TYPE    Type;
} CACHE_DESCRIPTOR;
typedef CACHE_DESCRIPTOR    *PCACHE_DESCRIPTOR;

/* System logical processor information */
typedef struct _SYSTEM_LOGICAL_PROCESSOR_INFORMATION {
    ULONG_PTR                       ProcessorMask;
    LOGICAL_PROCESSOR_RELATIONSHIP  Relationship;
    union {
        struct {
            UCHAR   Flags;
        } ProcessorFlags;
        struct {
            ULONG   NodeNumber;
        } NumaNode;
        CACHE_DESCRIPTOR    Cache;
        ULONGLONG           Reserved[2];
    };
} SYSTEM_LOGICAL_PROCESSOR_INFORMATION;
typedef SYSTEM_LOGICAL_PROCESSOR_INFORMATION    *PSYSTEM_LOGICAL_PROCESSOR_INFORMATION;

/* Processor relationship */
typedef struct _PROCESSOR_RELATIONSHIP {
    UCHAR           Flags;
    UCHAR           Reserved[21];
    USHORT          GroupCount;
    GROUP_AFFINITY  GroupMask[ANYSIZE_ARRAY];
} PROCESSOR_RELATIONSHIP;
typedef PROCESSOR_RELATIONSHIP  *PPROCESSOR_RELATIONSHIP;

/* Numa node relationship */
typedef struct _NUMA_NODE_RELATIONSHIP {
    ULONG           NodeNumber;
    UCHAR           Reserved[20];
    GROUP_AFFINITY  GroupMask;
} NUMA_NODE_RELATIONSHIP;
typedef NUMA_NODE_RELATIONSHIP  *PNUMA_NODE_RELATIONSHIP;

/* Cache relationship */
typedef struct _CACHE_RELATIONSHIP {
    UCHAR                   Level;
    UCHAR                   Associativity;
    USHORT                  LineSize;
    ULONG                   CacheSize;
    PROCESSOR_CACHE_TYPE    Type;
    UCHAR                   Reserved[20];
    GROUP_AFFINITY          GroupMask;
} CACHE_RELATIONSHIP;
typedef CACHE_RELATIONSHIP  *PCACHE_RELATIONSHIP;

/* Processor group information */
typedef struct _PROCESSOR_GROUP_INFO {
    UCHAR       MaximumProcessorCount;
    UCHAR       ActiveProcessorCount;
    UCHAR       Reserved[38];
    KAFFINITY   ActiveProcessorMask;
} PROCESSOR_GROUP_INFO;
typedef PROCESSOR_GROUP_INFO    *PPROCESSOR_GROUP_INFO;

/* Group relationship */
typedef struct _GROUP_RELATIONSHIP {
    USHORT                  MaximumGroupCount;
    USHORT                  ActiveGroupCount;
    UCHAR                   Reserved[20];
    PROCESSOR_GROUP_INFO    GroupInfo[ANYSIZE_ARRAY];
} GROUP_RELATIONSHIP;
typedef GROUP_RELATIONSHIP  *PGROUP_RELATIONSHIP;

/* System logical processor information (extended version) */
typedef struct _SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX {
    LOGICAL_PROCESSOR_RELATIONSHIP  Relationship;
    ULONG                           Size;
    union {
        PROCESSOR_RELATIONSHIP  Processor;
        NUMA_NODE_RELATIONSHIP  NumaNode;
        CACHE_RELATIONSHIP      Cache;
        GROUP_RELATIONSHIP      Group;
    };
} SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX;
typedef SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX *PSYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX;

/* Alternative architecture types */
typedef enum _ALTERNATIVE_ARCHITECTURE_TYPE {
    StandardDesign  = 0,
    NEC98x86        = 1,
    EndAlternatives = 2
} ALTERNATIVE_ARCHITECTURE_TYPE;

typedef struct _EXCEPTION_RECORD {
    NTSTATUS                    ExceptionCode;
    ULONG                       ExceptionFlags;
    struct _EXCEPTION_RECORD    *ExceptionRecord;
    PVOID                       ExceptionAddress;
    ULONG                       NumberParameters;
    ULONG_PTR                   ExceptionInformation[EXCEPTION_MAXIMUM_PARAMETERS];
} EXCEPTION_RECORD;
typedef EXCEPTION_RECORD    *PEXCEPTION_RECORD;

/* Exception record (32-bit version) */
typedef struct _EXCEPTION_RECORD32 {
    NTSTATUS    ExceptionCode;
    ULONG       ExceptionFlags;
    ULONG       ExceptionRecord;
    ULONG       ExceptionAddress;
    ULONG       NumberParameters;
    ULONG       ExceptionInformation[EXCEPTION_MAXIMUM_PARAMETERS];
} EXCEPTION_RECORD32;
typedef EXCEPTION_RECORD32  *PEXCEPTION_RECORD32;

/* Exception record (64-bit version) */
typedef struct _EXCEPTION_RECORD64 {
    NTSTATUS    ExceptionCode;
    ULONG       ExceptionFlags;
    ULONG64     ExceptionRecord;
    ULONG64     ExceptionAddress;
    ULONG       NumberParameters;
    ULONG       __unusedAlignment;
    ULONG64     ExceptionInformation[EXCEPTION_MAXIMUM_PARAMETERS];
} EXCEPTION_RECORD64;
typedef EXCEPTION_RECORD64  *PEXCEPTION_RECORD64;

/* Pointers to exception and context records */
typedef struct _EXCEPTION_POINTERS {
    PEXCEPTION_RECORD   ExceptionRecord;
    PCONTEXT            ContextRecord;
} EXCEPTION_POINTERS;
typedef EXCEPTION_POINTERS  *PEXCEPTION_POINTERS;

/* Kernel interrupt modes */
typedef enum _KINTERRUPT_MODE {
    LevelSensitive  = 0,
    Latched         = 1
} KINTERRUPT_MODE;

/* Kernel interrupt polarities */
typedef enum _KINTERRUPT_POLARITY {
    InterruptPolarityUnknown    = 0,
    InterruptActiveHigh         = 1,
    InterruptActiveLow          = 2
} KINTERRUPT_POLARITY;
typedef KINTERRUPT_POLARITY *PKINTERRUPT_POLARITY;

/* Kernel wait reasons */
typedef enum _KWAIT_REASON {
    Executive           = 0,
    FreePage            = 1,
    PageIn              = 2,
    PoolAllocation      = 3,
    DelayExecution      = 4,
    Suspended           = 5,
    UserRequest         = 6,
    WrExecutive         = 7,
    WrFreePage          = 8,
    WrPageIn            = 9,
    WrPoolAllocation    = 10,
    WrDelayExecution    = 11,
    WrSuspended         = 12,
    WrUserRequest       = 13,
    WrEventPair         = 14,
    WrQueue             = 15,
    WrLpcReceive        = 16,
    WrLpcReply          = 17,
    WrVirtualMemory     = 18,
    WrPageOut           = 19,
    WrRendezvous        = 20,
    WrKeyedEvent        = 21,
    WrTerminated        = 22,
    WrProcessInSwap     = 23,
    WrCpuRateControl    = 24,
    WrCalloutStack      = 25,
    WrKernel            = 26,
    WrResource          = 27,
    WrPushLock          = 28,
    WrMutex             = 29,
    WrQuantumEnd        = 30,
    WrDispatchInt       = 31,
    WrPreempted         = 32,
    WrYieldExecution    = 33,
    WrFastMutex         = 34,
    WrGuardedMutex      = 35,
    WrRundown           = 36,
    MaximumWaitReason   = 37,
} KWAIT_REASON;

/* Kernel wait block */
typedef struct _KWAIT_BLOCK {
    LIST_ENTRY          WaitListEntry;
    struct _KTHREAD     *Thread;
    PVOID               Object;
    struct _KWAIT_BLOCK *NextWaitBlock;
    USHORT              WaitKey;
    UCHAR               WaitType;
    volatile UCHAR      BlockState;
} KWAIT_BLOCK;
typedef KWAIT_BLOCK *PKWAIT_BLOCK;
typedef KWAIT_BLOCK *PRKWAIT_BLOCK;

/* Kernel thread start routine */
typedef VOID        (NTAPI KSTART_ROUTINE)( PVOID );
typedef KSTART_ROUTINE  *PKSTART_ROUTINE;

/* Kernel device queue */
typedef struct _KDEVICE_QUEUE {
    CSHORT      Type;
    CSHORT      Size;
    LIST_ENTRY  DeviceListHead;
    KSPIN_LOCK  Lock;
    BOOLEAN     Busy;
} KDEVICE_QUEUE;
typedef KDEVICE_QUEUE   *PKDEVICE_QUEUE;
typedef KDEVICE_QUEUE   *PRKDEVICE_QUEUE;

/* Kernel device queue entry */
typedef struct _KDEVICE_QUEUE_ENTRY {
    LIST_ENTRY  DeviceListEntry;
    ULONG       SortKey;
    BOOLEAN     Inserted;
} KDEVICE_QUEUE_ENTRY;
typedef KDEVICE_QUEUE_ENTRY *PKDEVICE_QUEUE_ENTRY;
typedef KDEVICE_QUEUE_ENTRY *PRKDEVICE_QUEUE_ENTRY;

/* Kernel service routines */
typedef BOOLEAN     (NTAPI KSERVICE_ROUTINE)( struct _KINTERRUPT *, PVOID );
typedef BOOLEAN     (NTAPI KMESSAGE_SERVICE_ROUTINE)( struct _KINTERRUPT *, PVOID, ULONG );
typedef KSERVICE_ROUTINE            *PKSERVICE_ROUTINE;
typedef KMESSAGE_SERVICE_ROUTINE    *PKMESSAGE_SERVICE_ROUTINE;

/* Kernel mutant */
typedef struct _KMUTANT {
    DISPATCHER_HEADER   Header;
    LIST_ENTRY          MutantListEntry;
    struct _KTHREAD     *OwnerThread;
    BOOLEAN             Abandoned;
    UCHAR               ApcDisable;
} KMUTANT;
typedef KMUTANT *PKMUTANT;
typedef KMUTANT *PRKMUTANT;
typedef KMUTANT KMUTEX;
typedef KMUTANT *PKMUTEX;
typedef KMUTANT *PRKMUTEX;

/* Kernel semaphore */
typedef struct _KSEMAPHORE {
    DISPATCHER_HEADER   Header;
    LONG                Limit;
} KSEMAPHORE;
typedef KSEMAPHORE  *PKSEMAPHORE;
typedef KSEMAPHORE  *PRKSEMAPHORE;

/* Interprocess interrupt broadcast worker */
typedef ULONG_PTR   (NTAPI KIPI_BROADCAST_WORKER)( ULONG_PTR );
typedef KIPI_BROADCAST_WORKER   *PKIPI_BROADCAST_WORKER;

/* Kernel deferred procedure call watchdog information */
typedef struct _KDPC_WATCHDOG_INFORMATION {
    ULONG   DpcTimeLimit;
    ULONG   DpcTimeCount;
    ULONG   DpcWatchdogLimit;
    ULONG   DpcWatchdogCount;
    ULONG   Reserved;
} KDPC_WATCHDOG_INFORMATION;
typedef KDPC_WATCHDOG_INFORMATION   *PKDPC_WATCHDOG_INFORMATION;

/* Kernel bug check buffer dump states */
typedef enum _KBUGCHECK_BUFFER_DUMP_STATE {
    BufferEmpty         = 0,
    BufferInserted      = 1,
    BufferStarted       = 2,
    BufferFinished      = 3,
    BufferIncomplete    = 4
} KBUGCHECK_BUFFER_DUMP_STATE;

/* Kernel bug check callback routine */
typedef VOID        (NTAPI KBUGCHECK_CALLBACK_ROUTINE)( PVOID, ULONG );
typedef KBUGCHECK_CALLBACK_ROUTINE  *PKBUGCHECK_CALLBACK_ROUTINE;

/* Kernel bug check callback record */
typedef struct _KBUGCHECK_CALLBACK_RECORD {
    LIST_ENTRY                  Entry;
    PKBUGCHECK_CALLBACK_ROUTINE CallbackRoutine;
    PVOID                       Buffer;
    ULONG                       Length;
    PUCHAR                      Component;
    ULONG_PTR                   Checksum;
    UCHAR                       State;
} KBUGCHECK_CALLBACK_RECORD;
typedef KBUGCHECK_CALLBACK_RECORD   *PKBUGCHECK_CALLBACK_RECORD;

/* Kernel bug check callback reasons */
typedef enum _KBUGCHECK_CALLBACK_REASON {
    KbCallbackInvalid           = 0,
    KbCallbackSecondaryDumpData = 2,
    KbCallbackDumpIo            = 3,
    KbCallbackAddPages          = 4
} KBUGCHECK_CALLBACK_REASON;

/* Kernel bug check reason callback routine */
typedef VOID        (NTAPI KBUGCHECK_REASON_CALLBACK_ROUTINE)( KBUGCHECK_CALLBACK_REASON, struct _KBUGCHECK_REASON_CALLBACK_RECORD *, PVOID, ULONG );
typedef KBUGCHECK_REASON_CALLBACK_ROUTINE   *PKBUGCHECK_REASON_CALLBACK_ROUTINE;

/* Kernel bug check reason callback record */
typedef struct _KBUGCHECK_REASON_CALLBACK_RECORD {
    LIST_ENTRY                          Entry;
    PKBUGCHECK_REASON_CALLBACK_ROUTINE  CallbackRoutine;
    PUCHAR                              Component;
    ULONG_PTR                           Checksum;
    KBUGCHECK_CALLBACK_REASON           Reason;
    UCHAR                               State;
} KBUGCHECK_REASON_CALLBACK_RECORD;
typedef KBUGCHECK_REASON_CALLBACK_RECORD    *PKBUGCHECK_REASON_CALLBACK_RECORD;

/* Kernel bug check secondary dump data */
typedef struct _KBUGCHECK_SECONDARY_DUMP_DATA {
    PVOID   InBuffer;
    ULONG   InBufferLength;
    ULONG   MaximumAllowed;
    GUID    Guid;
    PVOID   OutBuffer;
    ULONG   OutBufferLength;
} KBUGCHECK_SECONDARY_DUMP_DATA;
typedef KBUGCHECK_SECONDARY_DUMP_DATA   *PKBUGCHECK_SECONDARY_DUMP_DATA;

/* Kernel bug check dump I/O types */
typedef enum _KBUGCHECK_DUMP_IO_TYPE {
    KbDumpIoInvalid         = 0,
    KbDumpIoHeader          = 1,
    KbDumpIoBody            = 2,
    KbDumpIoSecondaryData   = 3,
    KbDumpIoComplete        = 4
} KBUGCHECK_DUMP_IO_TYPE;

/* Kernel bug check dump I/O data */
typedef struct _KBUGCHECK_DUMP_IO {
    ULONG64                 Offset;
    PVOID                   Buffer;
    ULONG                   BufferLength;
    KBUGCHECK_DUMP_IO_TYPE  Type;
} KBUGCHECK_DUMP_IO;
typedef KBUGCHECK_DUMP_IO   *PKBUGCHECK_DUMP_IO;

/* Kernel bug check add pages data */
typedef struct _KBUGCHECK_ADD_PAGES {
    PVOID       Context;
    ULONG       Flags;
    ULONG       BugCheckCode;
    ULONG_PTR   Address;
    ULONG_PTR   Count;
} KBUGCHECK_ADD_PAGES;
typedef KBUGCHECK_ADD_PAGES *PKBUGCHECK_ADD_PAGES;

/* NMI callback */
typedef BOOLEAN     (NTAPI *PNMI_CALLBACK)( PVOID, BOOLEAN );

/* Memory caching type origins */
typedef enum _MEMORY_CACHING_TYPE_ORIG {
    MmFrameBufferCached = 2
} MEMORY_CACHING_TYPE_ORIG;

/* Memory caching types */
typedef enum _MEMORY_CACHING_TYPE {
    MmNonCached                 = FALSE,
    MmCached                    = TRUE,
    MmWriteCombined             = MmFrameBufferCached,
    MmHardwareCoherentCached    = 3,
    MmNonCachedUnordered        = 4,
    MmUSWCCached                = 5,
    MmMaximumCacheType          = 6
} MEMORY_CACHING_TYPE;

/* Kernel guarded mutex */
typedef struct _KGUARDED_MUTEX {
    volatile LONG   Count;
    PKTHREAD        Owner;
    ULONG           Contention;
    KGATE           Gate;
    union {
        struct {
            SHORT   KernelApcDisable;
            SHORT   SpecialApcDisable;
        };
        ULONG   CombinedApcDisable;
    };
} KGUARDED_MUTEX;
typedef KGUARDED_MUTEX  *PKGUARDED_MUTEX;

/* Kernel processor change notify states */
typedef enum {
    KeProcessorAddStartNotify       = 0,
    KeProcessorAddCompleteNotify    = 1,
    KeProcessorAddFailureNotify     = 2
} KE_PROCESSOR_CHANGE_NOTIFY_STATE;

/* Kernel processor change notify context */
typedef struct _KE_PROCESSOR_CHANGE_NOTIFY_CONTEXT {
    KE_PROCESSOR_CHANGE_NOTIFY_STATE    State;
    ULONG                               NtNumber;
    NTSTATUS                            Status;
#if (NTDDI_VERSION >= 0x06010000)
    PROCESSOR_NUMBER                    ProcNumber;
#endif
} KE_PROCESSOR_CHANGE_NOTIFY_CONTEXT;
typedef KE_PROCESSOR_CHANGE_NOTIFY_CONTEXT  *PKE_PROCESSOR_CHANGE_NOTIFY_CONTEXT;

/* Processor callback function */
typedef VOID        (NTAPI PROCESSOR_CALLBACK_FUNCTION)( PVOID, PKE_PROCESSOR_CHANGE_NOTIFY_CONTEXT, PNTSTATUS );
typedef PROCESSOR_CALLBACK_FUNCTION *PPROCESSOR_CALLBACK_FUNCTION;

/* Extended state save */
typedef struct _XSTATE_SAVE {
#if defined( _X86_ )
    union {
        struct {
            LONG64              Reserved1;
            ULONG               Reserved2;
            struct _XSTATE_SAVE *Prev;
            PXSAVE_AREA         Reserved3;
            struct _KTHREAD     *Thread;
            PVOID               Reserved4;
            UCHAR               Level;
        };
        XSTATE_CONTEXT  XStateContext;
    };
#else
    ULONG   dummy;
#endif
} XSTATE_SAVE;
typedef XSTATE_SAVE *PXSTATE_SAVE;

/* Kernel debugging options */
typedef enum _KD_OPTION {
    KD_OPTION_SET_BLOCK_ENABLE  = 0
} KD_OPTION;

/* Executive pool priorities */
typedef enum _EX_POOL_PRIORITY {
    LowPoolPriority                         = 0,
    LowPoolPrioritySpecialPoolOverrun       = 8,
    LowPoolPrioritySpecialPoolUnderrun      = 9,
    NormalPoolPriority                      = 16,
    NormalPoolPrioritySpecialPoolOverrun    = 24,
    NormalPoolPrioritySpecialPoolUnderrun   = 25,
    HighPoolPriority                        = 32,
    HighPoolPrioritySpecialPoolOverrun      = 40,
    HighPoolPrioritySpecialPoolUnderrun     = 41
} EX_POOL_PRIORITY;

/* Fast mutex */
typedef struct _FAST_MUTEX {
    volatile LONG   Count;
    PKTHREAD        Owner;
    ULONG           Contention;
    KEVENT          Event;
    ULONG           OldIrql;
} FAST_MUTEX;
typedef FAST_MUTEX  *PFAST_MUTEX;

/* Lookaside list (extended version) */
typedef struct _LOOKASIDE_LIST_EX {
    GENERAL_LOOKASIDE_POOL  L;
} LOOKASIDE_LIST_EX;
typedef LOOKASIDE_LIST_EX   *PLOOKASIDE_LIST_EX;

/* Nonpaged lookaside list */
typedef struct _NPAGED_LOOKASIDE_LIST {
    GENERAL_LOOKASIDE   L;
    KSPIN_LOCK          Lock__ObsoleteButDoNotDelete;
} NPAGED_LOOKASIDE_LIST;
typedef NPAGED_LOOKASIDE_LIST   *PNPAGED_LOOKASIDE_LIST;

/* Paged lookaside list */
typedef struct _PAGED_LOOKASIDE_LIST {
    GENERAL_LOOKASIDE   L;
    FAST_MUTEX          Lock__ObsoleteButDoNotDelete;
} PAGED_LOOKASIDE_LIST;
typedef PAGED_LOOKASIDE_LIST    *PPAGED_LOOKASIDE_LIST;

/* Work queue types */
typedef enum _WORK_QUEUE_TYPE {
    CriticalWorkQueue       = 0,
    DelayedWorkQueue        = 1,
    HyperCriticalWorkQueue  = 2,
    MaximumWorkQueue        = 3
} WORK_QUEUE_TYPE;

/* Worker thread routine */
typedef VOID        (NTAPI WORKER_THREAD_ROUTINE)( PVOID );
typedef WORKER_THREAD_ROUTINE   *PWORKER_THREAD_ROUTINE;

/* Work queue item */
typedef struct _WORK_QUEUE_ITEM {
    LIST_ENTRY              List;
    PWORKER_THREAD_ROUTINE  WorkerRoutine;
    PVOID                   Parameter;
} WORK_QUEUE_ITEM;
typedef WORK_QUEUE_ITEM *PWORK_QUEUE_ITEM;

/* Owner entry */
typedef struct _OWNER_ENTRY {
    ERESOURCE_THREAD    OwnerThread;
    union {
        struct {
            ULONG   IoPriorityBoosted   : 1;
            ULONG   OwnerReferenced     : 1;
            ULONG   OwnerCount          : 30;
        };
        ULONG   TableSize;
    };
} OWNER_ENTRY;
typedef OWNER_ENTRY *POWNER_ENTRY;

/* Executive resource */
typedef struct _ERESOURCE {
    LIST_ENTRY      SystemResourcesList;
    POWNER_ENTRY    OwnerTable;
    SHORT           ActiveCount;
    USHORT          Flag;
    PKSEMAPHORE     SharedWaiters;
    PKEVENT         ExclusiveWaiters;
    OWNER_ENTRY     OwnerEntry;
    ULONG           ActiveEntries;
    ULONG           ContentionCount;
    ULONG           NumberOfSharedWaiters;
    ULONG           NumberOfExclusiveWaiters;
    union {
        PVOID       Address;
        ULONG_PTR   CreatorBackTraceIndex;
    };
    KSPIN_LOCK      SpinLock;
} ERESOURCE;
typedef ERESOURCE   *PERESOURCE;

/* Resource hash entry */
typedef struct _RESOURCE_HASH_ENTRY {
    LIST_ENTRY  ListEntry;
    PVOID       Address;
    ULONG       ContentionCount;
    ULONG       Number;
} RESOURCE_HASH_ENTRY;
typedef RESOURCE_HASH_ENTRY *PRESOURCE_HASH_ENTRY;

/* Resource performance data */
typedef struct _RESOURCE_PERFORMANCE_DATA {
    ULONG       ActiveResourceCount;
    ULONG       TotalResourceCount;
    ULONG       ExclusionAcquire;
    ULONG       SharedFirstLevel;
    ULONG       SharedSecondLevel;
    ULONG       StarveFirstLevel;
    ULONG       StarveSecondLevel;
    ULONG       WaitForExclusive;
    ULONG       OwnerTableExpands;
    ULONG       MaximumTableExpand;
    LIST_ENTRY  HashTable[RESOURCE_HASH_TABLE_SIZE];
} RESOURCE_PERFORMANCE_DATA;
typedef RESOURCE_PERFORMANCE_DATA   *PRESOURCE_PERFORMANCE_DATA;

/* Executive rundown reference */
typedef struct _EX_RUNDOWN_REF {
    union {
        ULONG_PTR   Count;
        PVOID       Ptr;
    };
} EX_RUNDOWN_REF;
typedef EX_RUNDOWN_REF  *PEX_RUNDOWN_REF;

/* Callback function */
typedef VOID        (NTAPI CALLBACK_FUNCTION)( PVOID, PVOID, PVOID );
typedef CALLBACK_FUNCTION   *PCALLBACK_FUNCTION;

/* Executive callback function */
typedef NTSTATUS    (NTAPI EX_CALLBACK_FUNCTION)( PVOID, PVOID, PVOID );
typedef EX_CALLBACK_FUNCTION    *PEX_CALLBACK_FUNCTION;

/* Registry notification classes */
typedef enum _REG_NOTIFY_CLASS {
    RegNtDeleteKey                  = 0,
    RegNtPreDeleteKey               = RegNtDeleteKey,
    RegNtSetValueKey                = 1,
    RegNtPreSetValueKey             = RegNtSetValueKey,
    RegNtDeleteValueKey             = 2,
    RegNtPreDeleteValueKey          = RegNtDeleteValueKey,
    RegNtSetInformationKey          = 3,
    RegNtPreSetInformationKey       = RegNtSetInformationKey,
    RegNtRenameKey                  = 4,
    RegNtPreRenameKey               = RegNtRenameKey,
    RegNtEnumerateKey               = 5,
    RegNtPreEnumerateKey            = RegNtEnumerateKey,
    RegNtEnumerateValueKey          = 6,
    RegNtPreEnumerateValueKey       = RegNtEnumerateValueKey,
    RegNtQueryKey                   = 7,
    RegNtPreQueryKey                = RegNtQueryKey,
    RegNtQueryValueKey              = 8,
    RegNtPreQueryValueKey           = RegNtQueryValueKey,
    RegNtQueryMultipleValueKey      = 9,
    RegNtPreQueryMultipleValueKey   = RegNtQueryMultipleValueKey,
    RegNtPreCreateKey               = 10,
    RegNtPostCreateKey              = 11,
    RegNtPreOpenKey                 = 12,
    RegNtPostOpenKey                = 13,
    RegNtKeyHandleClose             = 14,
    RegNtPreKeyHandleClose          = RegNtKeyHandleClose,
    RegNtPostDeleteKey              = 15,
    RegNtPostSetValueKey            = 16,
    RegNtPostDeleteValueKey         = 17,
    RegNtPostSetInformationKey      = 18,
    RegNtPostRenameKey              = 19,
    RegNtPostEnumerateKey           = 20,
    RegNtPostEnumerateValueKey      = 21,
    RegNtPostQueryKey               = 22,
    RegNtPostQueryValueKey          = 23,
    RegNtPostQueryMultipleValueKey  = 24,
    RegNtPostKeyHandleClose         = 25,
    RegNtPreCreateKeyEx             = 26,
    RegNtPostCreateKeyEx            = 27,
    RegNtPreOpenKeyEx               = 28,
    RegNtPostOpenKeyEx              = 29,
    RegNtPreFlushKey                = 30,
    RegNtPostFlushKey               = 31,
    RegNtPreLoadKey                 = 32,
    RegNtPostLoadKey                = 33,
    RegNtPreUnLoadKey               = 34,
    RegNtPostUnLoadKey              = 35,
    RegNtPreQueryKeySecurity        = 36,
    RegNtPostQueryKeySecurity       = 37,
    RegNtPreSetKeySecurity          = 38,
    RegNtPostSetKeySecurity         = 39,
    RegNtCallbackObjectContextCleanup   = 40,
    RegNtPreRestoreKey              = 41,
    RegNtPostRestoreKey             = 42,
    RegNtPreSaveKey                 = 43,
    RegNtPostSaveKey                = 44,
    RegNtPreReplaceKey              = 45,
    RegNtPostReplaceKey             = 46,
    MaxRegNtNotifyClass             = 47
} REG_NOTIFY_CLASS;

/* Registry delete key information */
typedef struct _REG_DELETE_KEY_INFORMATION {
    PVOID   Object;
    PVOID   CallContext;
    PVOID   ObjectContext;
    PVOID   Reserved;
} REG_DELETE_KEY_INFORMATION;
typedef REG_DELETE_KEY_INFORMATION  *PREG_DELETE_KEY_INFORMATION;
#if (NTDDI_VERSION >= 0x06000000)
typedef REG_DELETE_KEY_INFORMATION  REG_FLUSH_KEY_INFORMATION;
typedef REG_DELETE_KEY_INFORMATION  *PREG_FLUSH_KEY_INFORMATION;
#endif

/* Registry set value key information */
typedef struct _REG_SET_VALUE_KEY_INFORMATION {
    PVOID           Object;
    PUNICODE_STRING ValueName;
    ULONG           TitleIndex;
    ULONG           Type;
    PVOID           Data;
    ULONG           DataSize;
    PVOID           CallContext;
    PVOID           ObjectContext;
    PVOID           Reserved;
} REG_SET_VALUE_KEY_INFORMATION;
typedef REG_SET_VALUE_KEY_INFORMATION   *PREG_SET_VALUE_KEY_INFORMATION;

/* Registry delete value key information */
typedef struct _REG_DELETE_VALUE_KEY_INFORMATION {
    PVOID           Object;
    PUNICODE_STRING ValueName;
    PVOID           CallContext;
    PVOID           ObjectContext;
    PVOID           Reserved;
} REG_DELETE_VALUE_KEY_INFORMATION;
typedef REG_DELETE_VALUE_KEY_INFORMATION    *PREG_DELETE_VALUE_KEY_INFORMATION;

/* Registry set information key information */
typedef struct _REG_SET_INFORMATION_KEY_INFORMATION {
    PVOID                       Object;
    KEY_SET_INFORMATION_CLASS   KeySetInformationClass;
    PVOID                       KeySetInformation;
    ULONG                       KeySetInformationLength;
    PVOID                       CallContext;
    PVOID                       ObjectContext;
    PVOID                       Reserved;
} REG_SET_INFORMATION_KEY_INFORMATION;
typedef REG_SET_INFORMATION_KEY_INFORMATION *PREG_SET_INFORMATION_KEY_INFORMATION;

/* Registry enumerate key information */
typedef struct _REG_ENUMERATE_KEY_INFORMATION {
    PVOID                   Object;
    ULONG                   Index;
    KEY_INFORMATION_CLASS   KeyInformationClass;
    PVOID                   KeyInformation;
    ULONG                   Length;
    PULONG                  ResultLength;
    PVOID                   CallContext;
    PVOID                   ObjectContext;
    PVOID                   Reserved;
} REG_ENUMERATE_KEY_INFORMATION;
typedef REG_ENUMERATE_KEY_INFORMATION   *PREG_ENUMERATE_KEY_INFORMATION;

/* Registry enumerate value key information */
typedef struct _REG_ENUMERATE_VALUE_KEY_INFORMATION {
    PVOID                       Object;
    ULONG                       Index;
    KEY_VALUE_INFORMATION_CLASS KeyValueInformationClass;
    PVOID                       KeyValueInformation;
    ULONG                       Length;
    PULONG                      ResultLength;
    PVOID                       CallContext;
    PVOID                       ObjectContext;
    PVOID                       Reserved;
} REG_ENUMERATE_VALUE_KEY_INFORMATION;
typedef REG_ENUMERATE_VALUE_KEY_INFORMATION *PREG_ENUMERATE_VALUE_KEY_INFORMATION;

/* Registry query key information */
typedef struct _REG_QUERY_KEY_INFORMATION {
    PVOID                   Object;
    KEY_INFORMATION_CLASS   KeyInformationClass;
    PVOID                   KeyInformation;
    ULONG                   Length;
    PULONG                  ResultLength;
    PVOID                   CallContext;
    PVOID                   ObjectContext;
    PVOID                   Reserved;
} REG_QUERY_KEY_INFORMATION;
typedef REG_QUERY_KEY_INFORMATION   *PREG_QUERY_KEY_INFORMATION;

/* Registry query value key information */
typedef struct _REG_QUERY_VALUE_KEY_INFORMATION {
    PVOID                       Object;
    PUNICODE_STRING             ValueName;
    KEY_VALUE_INFORMATION_CLASS KeyValueInformationClass;
    PVOID                       KeyValueInformation;
    ULONG                       Length;
    PULONG                      ResultLength;
    PVOID                       CallContext;
    PVOID                       ObjectContext;
    PVOID                       Reserved;
} REG_QUERY_VALUE_KEY_INFORMATION;
typedef REG_QUERY_VALUE_KEY_INFORMATION *PREG_QUERY_VALUE_KEY_INFORMATION;

/* Registry query multiple value key information */
typedef struct _REG_QUERY_MULTIPLE_VALUE_KEY_INFORMATION {
    PVOID               Object;
    PKEY_VALUE_ENTRY    ValueEntries;
    ULONG               EntryCount;
    PVOID               ValueBuffer;
    PULONG              BufferLength;
    PULONG              RequiredBufferLength;
    PVOID               CallContext;
    PVOID               ObjectContext;
    PVOID               Reserved;
} REG_QUERY_MULTIPLE_VALUE_KEY_INFORMATION;
typedef REG_QUERY_MULTIPLE_VALUE_KEY_INFORMATION    *PREG_QUERY_MULTIPLE_VALUE_KEY_INFORMATION;

/* Registry rename key information */
typedef struct _REG_RENAME_KEY_INFORMATION {
    PVOID           Object;
    PUNICODE_STRING NewName;
    PVOID           CallContext;
    PVOID           ObjectContext;
    PVOID           Reserved;
} REG_RENAME_KEY_INFORMATION;
typedef REG_RENAME_KEY_INFORMATION  *PREG_RENAME_KEY_INFORMATION;

/* Registry key handle close information */
typedef struct _REG_KEY_HANDLE_CLOSE_INFORMATION {
    PVOID   Object;
    PVOID   CallContext;
    PVOID   ObjectContext;
    PVOID   Reserved;
} REG_KEY_HANDLE_CLOSE_INFORMATION;
typedef REG_KEY_HANDLE_CLOSE_INFORMATION    *PREG_KEY_HANDLE_CLOSE_INFORMATION;

/* Registry create key information */
typedef struct _REG_CREATE_KEY_INFORMATION {
    PUNICODE_STRING CompleteName;
    PVOID           RootObject;
    PVOID           ObjectType;
    ULONG           CreateOptions;
    PUNICODE_STRING Class;
    PVOID           SecurityDescriptor;
    PVOID           SecurityQualityOfService;
    ACCESS_MASK     DesiredAccess;
    ACCESS_MASK     GrantedAccess;
    PULONG          Disposition;
    PVOID           *ResultObject;
    PVOID           CallContext;
    PVOID           RootObjectContext;
    PVOID           Transaction;
    PVOID           Reserved;
} REG_CREATE_KEY_INFORMATION;
typedef REG_CREATE_KEY_INFORMATION  *PREG_CREATE_KEY_INFORMATION;
typedef REG_CREATE_KEY_INFORMATION  REG_OPEN_KEY_INFORMATION;
typedef REG_CREATE_KEY_INFORMATION  *PREG_OPEN_KEY_INFORMATION;

/* Registry create key information (version 1) */
typedef struct _REG_CREATE_KEY_INFORMATION_V1 {
    PUNICODE_STRING CompleteName;
    PVOID           RootObject;
    PVOID           ObjectType;
    ULONG           Options;
    PUNICODE_STRING Class;
    PVOID           SecurityDescriptor;
    PVOID           SecurityQualityOfService;
    ACCESS_MASK     DesiredAccess;
    ACCESS_MASK     GrantedAccess;
    PULONG          Disposition;
    PVOID           *ResultObject;
    PVOID           CallContext;
    PVOID           RootObjectContext;
    PVOID           Transaction;
    ULONG_PTR       Version;
    PUNICODE_STRING RemainingName;
    ULONG           Wow64Flags;
    ULONG           Attributes;
    KPROCESSOR_MODE CheckAccessMode;
} REG_CREATE_KEY_INFORMATION_V1;
typedef REG_CREATE_KEY_INFORMATION_V1   REG_OPEN_KEY_INFORMATION_V1;
typedef REG_CREATE_KEY_INFORMATION_V1   *PREG_CREATE_KEY_INFORMATION_V1;
typedef REG_CREATE_KEY_INFORMATION_V1   *PREG_OPEN_KEY_INFORMATION_V1;

/* Registry post-operation information */
typedef struct _REG_POST_OPERATION_INFORMATION {
    PVOID       Object;
    NTSTATUS    Status;
    PVOID       PreInformation;
    NTSTATUS    ReturnStatus;
    PVOID       CallContext;
    PVOID       ObjectContext;
    PVOID       Reserved;
} REG_POST_OPERATION_INFORMATION;
typedef REG_POST_OPERATION_INFORMATION  *PREG_POST_OPERATION_INFORMATION;

/* Registry pre-create key information */
typedef struct _REG_PRE_CREATE_KEY_INFORMATION {
    PUNICODE_STRING CompleteName;
} REG_PRE_CREATE_KEY_INFORMATION;
typedef REG_PRE_CREATE_KEY_INFORMATION  *PREG_PRE_CREATE_KEY_INFORMATION;
typedef REG_PRE_CREATE_KEY_INFORMATION  REG_PRE_OPEN_KEY_INFORMATION;
typedef REG_PRE_CREATE_KEY_INFORMATION  *PREG_PRE_OPEN_KEY_INFORMATION;

/* Registry post-create key information */
typedef struct _REG_POST_CREATE_KEY_INFORMATION {
    PUNICODE_STRING CompleteName;
    PVOID           Object;
    NTSTATUS        Status;
} REG_POST_CREATE_KEY_INFORMATION;
typedef REG_POST_CREATE_KEY_INFORMATION *PREG_POST_CREATE_KEY_INFORMATION;
typedef REG_POST_CREATE_KEY_INFORMATION REG_POST_OPEN_KEY_INFORMATION;
typedef REG_POST_CREATE_KEY_INFORMATION *PREG_POST_OPEN_KEY_INFORMATION;

/* Registry load key information */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _REG_LOAD_KEY_INFORMATION {
    PVOID           Object;
    PUNICODE_STRING KeyName;
    PUNICODE_STRING SourceFile;
    ULONG           Flags;
    PVOID           TrustClassObject;
    PVOID           UserEvent;
    ACCESS_MASK     DesiredAccess;
    PHANDLE         RootHandle;
    PVOID           CallContext;
    PVOID           ObjectContext;
    PVOID           Reserved;
} REG_LOAD_KEY_INFORMATION;
typedef REG_LOAD_KEY_INFORMATION    *PREG_LOAD_KEY_INFORMATION;
#endif

/* Registry unload key information */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _REG_UNLOAD_KEY_INFORMATION {
    PVOID   Object;
    PVOID   UserEvent;
    PVOID   CallContext;
    PVOID   ObjectContext;
    PVOID   Reserved;
} REG_UNLOAD_KEY_INFORMATION;
typedef REG_UNLOAD_KEY_INFORMATION  *PREG_UNLOAD_KEY_INFORMATION;
#endif

/* Registry callback context cleanup information */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _REG_CALLBACK_CONTEXT_CLEANUP_INFORMATION {
    PVOID   Object;
    PVOID   ObjectContext;
    PVOID   Reserved;
} REG_CALLBACK_CONTEXT_CLEANUP_INFORMATION;
typedef REG_CALLBACK_CONTEXT_CLEANUP_INFORMATION    *PREG_CALLBACK_CONTEXT_CLEANUP_INFORMATION;
#endif

/* Registry query key security information */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _REG_QUERY_KEY_SECURITY_INFORMATION {
    PVOID                   Object;
    PSECURITY_INFORMATION   SecurityInformation;
    PSECURITY_DESCRIPTOR    SecurityDescriptor;
    PULONG                  Length;
    PVOID                   CallContext;
    PVOID                   ObjectContext;
    PVOID                   Reserved;
} REG_QUERY_KEY_SECURITY_INFORMATION;
typedef REG_QUERY_KEY_SECURITY_INFORMATION  *PREG_QUERY_KEY_SECURITY_INFORMATION;
#endif

/* Registry set key security information */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _REG_SET_KEY_SECURITY_INFORMATION {
    PVOID                   Object;
    PSECURITY_INFORMATION   SecurityInformation;
    PSECURITY_DESCRIPTOR    SecurityDescriptor;
    PVOID                   CallContext;
    PVOID                   ObjectContext;
    PVOID                   Reserved;
} REG_SET_KEY_SECURITY_INFORMATION;
typedef REG_SET_KEY_SECURITY_INFORMATION    *PREG_SET_KEY_SECURITY_INFORMATION;
#endif

/* Registry restore key information */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _REG_RESTORE_KEY_INFORMATION {
    PVOID   Object;
    HANDLE  FileHandle;
    ULONG   Flags;
    PVOID   CallContext;
    PVOID   ObjectContext;
    PVOID   Reserved;
} REG_RESTORE_KEY_INFORMATION;
typedef REG_RESTORE_KEY_INFORMATION *PREG_RESTORE_KEY_INFORMATION;
#endif

/* Registry save key information */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _REG_SAVE_KEY_INFORMATION {
    PVOID   Object;
    HANDLE  FileHandle;
    ULONG   Format;
    PVOID   CallContext;
    PVOID   ObjectContext;
    PVOID   Reserved;
} REG_SAVE_KEY_INFORMATION;
typedef REG_SAVE_KEY_INFORMATION    *PREG_SAVE_KEY_INFORMATION;
#endif

/* Registry replace key information */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _REG_REPLACE_KEY_INFORMATION {
    PVOID           Object;
    PUNICODE_STRING OldFileName;
    PUNICODE_STRING NewFileName;
    PVOID           CallContext;
    PVOID           ObjectContext;
    PVOID           Reserved;
} REG_REPLACE_KEY_INFORMATION;
typedef REG_REPLACE_KEY_INFORMATION *PREG_REPLACE_KEY_INFORMATION;
#endif

/* Memory management system sizes */
typedef enum _MM_SYSTEMSIZE {
    MmSmallSystem   = 0,
    MmMediumSystem  = 1,
    MmLargeSystem   = 2
} MM_SYSTEMSIZE;

/* Memory management page priorities */
typedef enum _MM_PAGE_PRIORITY {
    LowPagePriority     = 0,
    NormalPagePriority  = 16,
    HighPagePriority    = 32
} MM_PAGE_PRIORITY;

/* Memory management callbacks */
typedef NTSTATUS    (NTAPI *PMM_DLL_INITIALIZE)( PUNICODE_STRING );
typedef NTSTATUS    (NTAPI *PMM_DLL_UNLOAD)( VOID );

/* Security operation codes */
typedef enum _SECURITY_OPERATION_CODE {
    SetSecurityDescriptor       = 0,
    QuerySecurityDescriptor     = 1,
    DeleteSecurityDescriptor    = 2,
    AssignSecurityDescriptor    = 3
} SECURITY_OPERATION_CODE;
typedef SECURITY_OPERATION_CODE *PSECURITY_OPERATION_CODE;

/* Security subject context */
typedef struct _SECURITY_SUBECT_CONTEXT {
    PACCESS_TOKEN                   ClientToken;
    SECURITY_IMPERSONATION_LEVEL    ImpersonationLevel;
    PACCESS_TOKEN                   PrimaryToken;
    PVOID                           ProcessAuditId;
} SECURITY_SUBJECT_CONTEXT;
typedef SECURITY_SUBJECT_CONTEXT    *PSECURITY_SUBJECT_CONTEXT;

/* Initial privilege set */
typedef struct _INITIAL_PRIVILEGE_SET {
    ULONG               PrivilegeCount;
    ULONG               Control;
    LUID_AND_ATTRIBUTES Privilege[INITIAL_PRIVILEGE_COUNT];
} INITIAL_PRIVILEGE_SET;
typedef INITIAL_PRIVILEGE_SET   *PINITIAL_PRIVILEGE_SET;

/* Access state */
typedef struct _ACCESS_STATE {
    LUID                        OperationID;
    BOOLEAN                     SecurityEvaluated;
    BOOLEAN                     GenerateAudit;
    BOOLEAN                     GenerateOnClose;
    BOOLEAN                     PrivilegesAllocated;
    ULONG                       Flags;
    ACCESS_MASK                 RemainingDesiredAccess;
    ACCESS_MASK                 PreviouslyGrantedAccess;
    ACCESS_MASK                 OriginalDesiredAccess;
    SECURITY_SUBJECT_CONTEXT    SubjectSecurityContext;
    PSECURITY_DESCRIPTOR        SecurityDescriptor;
    PVOID                       AuxData;
    union {
        INITIAL_PRIVILEGE_SET   InitialPrivilegeSet;
        PRIVILEGE_SET           PrivilegeSet;
    } Privileges;
    BOOLEAN                     AuditPrivileges;
    UNICODE_STRING              ObjectName;
    UNICODE_STRING              ObjectTypeName;
} ACCESS_STATE;
typedef ACCESS_STATE    *PACCESS_STATE;

/* NTFS dereference exported security descriptor callback */
typedef VOID        (NTAPI *PNTFS_DEREF_EXPORTED_SECURITY_DESCRIPTOR)( PVOID, PSECURITY_DESCRIPTOR );

/* IoCreateFile() types */
typedef enum _CREATE_FILE_TYPE {
    CreateFileTypeNone      = 0,
    CreateFileTypeNamedPipe = 1,
    CreateFileTypeMailslot  = 2
} CREATE_FILE_TYPE;

/* I/O callbacks */
typedef VOID        (NTAPI IO_DPC_ROUTINE)( PKDPC, struct _DEVICE_OBJECT *, struct _IRP *, PVOID );
typedef VOID        (NTAPI IO_TIMER_ROUTINE)( struct _DEVICE_OBJECT *, PVOID );
typedef IO_DPC_ROUTINE      *PIO_DPC_ROUTINE;
typedef IO_TIMER_ROUTINE    *PIO_TIMER_ROUTINE;

/* Driver callbacks */
typedef NTSTATUS    (NTAPI DRIVER_INITIALIZE)( struct _DRIVER_OBJECT *, PUNICODE_STRING );
typedef VOID        (NTAPI DRIVER_CANCEL)( struct _DEVICE_OBJECT *, struct _IRP * );
typedef NTSTATUS    (NTAPI DRIVER_DISPATCH)( struct _DEVICE_OBJECT *, struct _IRP * );
typedef VOID        (NTAPI DRIVER_STARTIO)( struct _DEVICE_OBJECT *, struct _IRP * );
typedef VOID        (NTAPI DRIVER_UNLOAD)( struct _DRIVER_OBJECT * );
typedef NTSTATUS    (NTAPI DRIVER_ADD_DEVICE)( struct _DRIVER_OBJECT *, struct _DEVICE_OBJECT * );
typedef DRIVER_INITIALIZE   *PDRIVER_INITIALIZE;
typedef DRIVER_CANCEL       *PDRIVER_CANCEL;
typedef DRIVER_DISPATCH     *PDRIVER_DISPATCH;
typedef DRIVER_STARTIO      *PDRIVER_STARTIO;
typedef DRIVER_UNLOAD       *PDRIVER_UNLOAD;
typedef DRIVER_ADD_DEVICE   *PDRIVER_ADD_DEVICE;

/* Fast I/O callbacks */
typedef BOOLEAN     (NTAPI FAST_IO_CHECK_IF_POSSIBLE)( struct _FILE_OBJECT *, PLARGE_INTEGER, ULONG, BOOLEAN, ULONG, BOOLEAN, PIO_STATUS_BLOCK, struct _DEVICE_OBJECT * );
typedef BOOLEAN     (NTAPI FAST_IO_READ)( struct _FILE_OBJECT *, PLARGE_INTEGER, ULONG, BOOLEAN, ULONG, PVOID, PIO_STATUS_BLOCK, struct _DEVICE_OBJECT * );
typedef BOOLEAN     (NTAPI FAST_IO_WRITE)( struct _FILE_OBJECT *, PLARGE_INTEGER, ULONG, BOOLEAN, ULONG, PVOID, PIO_STATUS_BLOCK, struct _DEVICE_OBJECT * );
typedef BOOLEAN     (NTAPI FAST_IO_QUERY_BASIC_INFO)( struct _FILE_OBJECT *, BOOLEAN, PFILE_BASIC_INFORMATION, PIO_STATUS_BLOCK, struct _DEVICE_OBJECT * );
typedef BOOLEAN     (NTAPI FAST_IO_QUERY_STANDARD_INFO)( struct _FILE_OBJECT *, BOOLEAN, PFILE_STANDARD_INFORMATION, PIO_STATUS_BLOCK, struct _DEVICE_OBJECT * );
typedef BOOLEAN     (NTAPI FAST_IO_LOCK)( struct _FILE_OBJECT *, PLARGE_INTEGER, PLARGE_INTEGER, PEPROCESS, ULONG, BOOLEAN, BOOLEAN, PIO_STATUS_BLOCK, struct _DEVICE_OBJECT * );
typedef BOOLEAN     (NTAPI FAST_IO_UNLOCK_SINGLE)( struct _FILE_OBJECT *, PLARGE_INTEGER, PLARGE_INTEGER, PEPROCESS, ULONG, PIO_STATUS_BLOCK, struct _DEVICE_OBJECT * );
typedef BOOLEAN     (NTAPI FAST_IO_UNLOCK_ALL)( struct _FILE_OBJECT *, PEPROCESS, PIO_STATUS_BLOCK, struct _DEVICE_OBJECT * );
typedef BOOLEAN     (NTAPI FAST_IO_UNLOCK_ALL_BY_KEY)( struct _FILE_OBJECT *, PVOID, ULONG, PIO_STATUS_BLOCK, struct _DEVICE_OBJECT * );
typedef BOOLEAN     (NTAPI FAST_IO_DEVICE_CONTROL)( struct _FILE_OBJECT *, BOOLEAN, PVOID, ULONG, PVOID, ULONG, ULONG, PIO_STATUS_BLOCK, struct _DEVICE_OBJECT * );
typedef VOID        (NTAPI FAST_IO_ACQUIRE_FILE)( struct _FILE_OBJECT * );
typedef VOID        (NTAPI FAST_IO_RELEASE_FILE)( struct _FILE_OBJECT * );
typedef VOID        (NTAPI FAST_IO_DETACH_DEVICE)( struct _DEVICE_OBJECT *, struct _DEVICE_OBJECT * );
typedef BOOLEAN     (NTAPI FAST_IO_QUERY_NETWORK_OPEN_INFO)( struct _FILE_OBJECT *, BOOLEAN, struct _FILE_NETWORK_OPEN_INFORMATION *, struct _IO_STATUS_BLOCK *, struct _DEVICE_OBJECT * );
typedef BOOLEAN     (NTAPI FAST_IO_MDL_READ)( struct _FILE_OBJECT *, PLARGE_INTEGER, ULONG, ULONG, PMDL *, PIO_STATUS_BLOCK, struct _DEVICE_OBJECT * );
typedef BOOLEAN     (NTAPI FAST_IO_MDL_READ_COMPLETE)( struct _FILE_OBJECT *, PMDL, struct _DEVICE_OBJECT * );
typedef BOOLEAN     (NTAPI FAST_IO_PREPARE_MDL_WRITE)( struct _FILE_OBJECT *, PLARGE_INTEGER, ULONG, ULONG, PMDL *, PIO_STATUS_BLOCK, struct _DEVICE_OBJECT * );
typedef BOOLEAN     (NTAPI FAST_IO_MDL_WRITE_COMPLETE)( struct _FILE_OBJECT *, PLARGE_INTEGER, PMDL, struct _DEVICE_OBJECT * );
typedef NTSTATUS    (NTAPI FAST_IO_ACQUIRE_FOR_MOD_WRITE)( struct _FILE_OBJECT *, PLARGE_INTEGER, struct _ERESOURCE **, struct _DEVICE_OBJECT * );
typedef NTSTATUS    (NTAPI FAST_IO_RELEASE_FOR_MOD_WRITE)( struct _FILE_OBJECT *, struct _ERESOURCE *, struct _DEVICE_OBJECT * );
typedef NTSTATUS    (NTAPI FAST_IO_ACQUIRE_FOR_CCFLUSH)( struct _FILE_OBJECT *, struct _DEVICE_OBJECT * );
typedef NTSTATUS    (NTAPI FAST_IO_RELEASE_FOR_CCFLUSH)( struct _FILE_OBJECT *, struct _DEVICE_OBJECT * );
typedef BOOLEAN     (NTAPI FAST_IO_READ_COMPRESSED)( struct _FILE_OBJECT *, PLARGE_INTEGER, ULONG, ULONG, PVOID, PMDL *, PIO_STATUS_BLOCK, struct _COMPRESSED_DATA_INFO *, ULONG, struct _DEVICE_OBJECT * );
typedef BOOLEAN     (NTAPI FAST_IO_WRITE_COMPRESSED)( struct _FILE_OBJECT *, PLARGE_INTEGER, ULONG, ULONG, PVOID, PMDL *, PIO_STATUS_BLOCK, struct _COMPRESSED_DATA_INFO *, ULONG, struct _DEVICE_OBJECT * );
typedef BOOLEAN     (NTAPI FAST_IO_MDL_READ_COMPLETE_COMPRESSED)( struct _FILE_OBJECT *, PMDL, struct _DEVICE_OBJECT * );
typedef BOOLEAN     (NTAPI FAST_IO_MDL_WRITE_COMPLETE_COMPRESSED)( struct _FILE_OBJECT *, PLARGE_INTEGER, PMDL, struct _DEVICE_OBJECT * );
typedef BOOLEAN     (NTAPI FAST_IO_QUERY_OPEN)( struct _IRP *, PFILE_NETWORK_OPEN_INFORMATION, struct _DEVICE_OBJECT * );
typedef FAST_IO_CHECK_IF_POSSIBLE       *PFAST_IO_CHECK_IF_POSSIBLE;
typedef FAST_IO_READ                    *PFAST_IO_READ;
typedef FAST_IO_WRITE                   *PFAST_IO_WRITE;
typedef FAST_IO_QUERY_BASIC_INFO        *PFAST_IO_QUERY_BASIC_INFO;
typedef FAST_IO_QUERY_STANDARD_INFO     *PFAST_IO_QUERY_STANDARD_INFO;
typedef FAST_IO_LOCK                    *PFAST_IO_LOCK;
typedef FAST_IO_UNLOCK_SINGLE           *PFAST_IO_UNLOCK_SINGLE;
typedef FAST_IO_UNLOCK_ALL              *PFAST_IO_UNLOCK_ALL;
typedef FAST_IO_UNLOCK_ALL_BY_KEY       *PFAST_IO_UNLOCK_ALL_BY_KEY;
typedef FAST_IO_DEVICE_CONTROL          *PFAST_IO_DEVICE_CONTROL;
typedef FAST_IO_ACQUIRE_FILE            *PFAST_IO_ACQUIRE_FILE;
typedef FAST_IO_RELEASE_FILE            *PFAST_IO_RELEASE_FILE;
typedef FAST_IO_DETACH_DEVICE           *PFAST_IO_DETACH_DEVICE;
typedef FAST_IO_QUERY_NETWORK_OPEN_INFO *PFAST_IO_QUERY_NETWORK_OPEN_INFO;
typedef FAST_IO_MDL_READ                *PFAST_IO_MDL_READ;
typedef FAST_IO_MDL_READ_COMPLETE       *PFAST_IO_MDL_READ_COMPLETE;
typedef FAST_IO_PREPARE_MDL_WRITE       *PFAST_IO_PREPARE_MDL_WRITE;
typedef FAST_IO_MDL_WRITE_COMPLETE      *PFAST_IO_MDL_WRITE_COMPLETE;
typedef FAST_IO_ACQUIRE_FOR_MOD_WRITE   *PFAST_IO_ACQUIRE_FOR_MOD_WRITE;
typedef FAST_IO_RELEASE_FOR_MOD_WRITE   *PFAST_IO_RELEASE_FOR_MOD_WRITE;
typedef FAST_IO_ACQUIRE_FOR_CCFLUSH     *PFAST_IO_ACQUIRE_FOR_CCFLUSH;
typedef FAST_IO_RELEASE_FOR_CCFLUSH     *PFAST_IO_RELEASE_FOR_CCFLUSH;
typedef FAST_IO_READ_COMPRESSED         *PFAST_IO_READ_COMPRESSED;
typedef FAST_IO_WRITE_COMPRESSED        *PFAST_IO_WRITE_COMPRESSED;
typedef FAST_IO_MDL_READ_COMPLETE_COMPRESSED    *PFAST_IO_MDL_READ_COMPLETE_COMPRESSED;
typedef FAST_IO_MDL_WRITE_COMPLETE_COMPRESSED   *PFAST_IO_MDL_WRITE_COMPLETE_COMPRESSED;
typedef FAST_IO_QUERY_OPEN              *PFAST_IO_QUERY_OPEN;

/* Fast I/O dispatch table */
typedef struct _FAST_IO_DISPATCH {
    ULONG                               SizeOfFastIoDispatch;
    PFAST_IO_CHECK_IF_POSSIBLE          FastIoCheckIfPossible;
    PFAST_IO_READ                       FastIoRead;
    PFAST_IO_WRITE                      FastIoWrite;
    PFAST_IO_QUERY_BASIC_INFO           FastIoQueryBasicInfo;
    PFAST_IO_QUERY_STANDARD_INFO        FastIoQueryStandardInfo;
    PFAST_IO_LOCK                       FastIoLock;
    PFAST_IO_UNLOCK_SINGLE              FastIoUnlockSingle;
    PFAST_IO_UNLOCK_ALL                 FastIoUnlockAll;
    PFAST_IO_UNLOCK_ALL_BY_KEY          FastIoUnlockAllByKey;
    PFAST_IO_DEVICE_CONTROL             FastIoDeviceControl;
    PFAST_IO_ACQUIRE_FILE               AcquireFileForNtCreateSection;
    PFAST_IO_RELEASE_FILE               ReleaseFileForNtCreateSection;
    PFAST_IO_DETACH_DEVICE              FastIoDetachDevice;
    PFAST_IO_QUERY_NETWORK_OPEN_INFO    FastIoQueryNetworkOpenInfo;
    PFAST_IO_ACQUIRE_FOR_MOD_WRITE      AcquireForModWrite;
    PFAST_IO_MDL_READ                   MdlRead;
    PFAST_IO_MDL_READ_COMPLETE          MdlReadComplete;
    PFAST_IO_PREPARE_MDL_WRITE          PrepareMdlWrite;
    PFAST_IO_MDL_WRITE_COMPLETE         MdlWriteComplete;
    PFAST_IO_READ_COMPRESSED            FastIoReadCompressed;
    PFAST_IO_WRITE_COMPRESSED           FastIoWriteCompressed;
    PFAST_IO_MDL_READ_COMPLETE_COMPRESSED   MdlReadCompleteCompressed;
    PFAST_IO_MDL_WRITE_COMPLETE_COMPRESSED  MdlWriteCompleteCompressed;
    PFAST_IO_QUERY_OPEN                 FastIoQueryOpen;
    PFAST_IO_RELEASE_FOR_MOD_WRITE      ReleaseForModWrite;
    PFAST_IO_ACQUIRE_FOR_CCFLUSH        AcquireForCcFlush;
    PFAST_IO_RELEASE_FOR_CCFLUSH        ReleaseForCcFlush;
} FAST_IO_DISPATCH;
typedef FAST_IO_DISPATCH    *PFAST_IO_DISPATCH;

/* I/O allocation actions */
typedef enum _IO_ALLOCATION_ACTION {
    KeepObject                      = 1,
    DeallocateObject                = 2,
    DeallocateObjectKeepRegisters   = 3
} IO_ALLOCATION_ACTION;
typedef IO_ALLOCATION_ACTION    *PIO_ALLOCATION_ACTION;

/* Driver control callback */
typedef IO_ALLOCATION_ACTION (NTAPI DRIVER_CONTROL)( struct _DEVICE_OBJECT *, struct _IRP *, PVOID, PVOID );
typedef DRIVER_CONTROL  *PDRIVER_CONTROL;

/* I/O security context */
typedef struct _IO_SECURITY_CONTEXT {
    PSECURITY_QUALITY_OF_SERVICE    SecurityQos;
    PACCESS_STATE                   AccessState;
    ACCESS_MASK                     DesiredAccess;
    ULONG                           FullCreateOptions;
} IO_SECURITY_CONTEXT;
typedef IO_SECURITY_CONTEXT *PIO_SECURITY_CONTEXT;

/* Volume parameter block */
typedef struct _VPB {
    CSHORT                  Type;
    CSHORT                  Size;
    USHORT                  Flags;
    USHORT                  VolumeLabelLength;
    struct _DEVICE_OBJECT   *DeviceObject;
    struct _DEVICE_OBJECT   *RealDevice;
    ULONG                   SerialNumber;
    ULONG                   ReferenceCount;
    WCHAR                   VolumeLabel[MAXIMUM_VOLUME_LABEL_LENGTH / sizeof( WCHAR )];
} VPB;
typedef VPB *PVPB;

/* Wait context block */
typedef struct _WAIT_CONTEXT_BLOCK {
    KDEVICE_QUEUE_ENTRY WaitQueueEntry;
    PDRIVER_CONTROL     DeviceRoutine;
    PVOID               DeviceContext;
    ULONG               NumberOfMapRegisters;
    PVOID               DeviceObject;
    PVOID               CurrentIrp;
    PKDPC               BufferChainingDpc;
} WAIT_CONTEXT_BLOCK;
typedef WAIT_CONTEXT_BLOCK  *PWAIT_CONTEXT_BLOCK;

/* Device object */
typedef struct _DEVICE_OBJECT {
    CSHORT                  Type;
    USHORT                  Size;
    LONG                    ReferenceCount;
    struct _DRIVER_OBJECT   *DriverObject;
    struct _DEVICE_OBJECT   *NextDevice;
    struct _DEVICE_OBJECT   *AttachedDevice;
    struct _IRP             *CurrentIrp;
    PIO_TIMER               Timer;
    ULONG                   Flags;
    ULONG                   Characteristics;
    PVPB                    Vpb;
    PVOID                   DeviceExtension;
    DEVICE_TYPE             DeviceType;
    CCHAR                   StackSize;
    union {
        LIST_ENTRY          ListEntry;
        WAIT_CONTEXT_BLOCK  Wcb;
    } Queue;
    ULONG                   AlignmentRequirement;
    KDEVICE_QUEUE           DeviceQueue;
    KDPC                    Dpc;
    ULONG                   ActiveThreadCount;
    PSECURITY_DESCRIPTOR    SecurityDescriptor;
    KEVENT                  DeviceLock;
    USHORT                  SectorSize;
    USHORT                  Spare1;
    struct _DEVOBJ_EXTENSION    *DeviceObjectExtension;
    PVOID                   Reserved;
} DEVICE_OBJECT;
typedef DEVICE_OBJECT   *PDEVICE_OBJECT;

/* Device object extension */
typedef struct _DEVOBJ_EXTENSION {
    CSHORT          Type;
    USHORT          Size;
    PDEVICE_OBJECT  DeviceObject;
} DEVOBJ_EXTENSION;
typedef DEVOBJ_EXTENSION *PDEVOBJ_EXTENSION;

/* Driver extension */
typedef struct _DRIVER_EXTENSION {
    struct _DRIVER_OBJECT   *DriverObject;
    PDRIVER_ADD_DEVICE      AddDevice;
    ULONG                   Count;
    UNICODE_STRING          ServiceKeyName;
} DRIVER_EXTENSION;
typedef DRIVER_EXTENSION *PDRIVER_EXTENSION;

/* Driver object */
typedef struct _DRIVER_OBJECT {
    CSHORT              Type;
    CSHORT              Size;
    PDEVICE_OBJECT      DeviceObject;
    ULONG               Flags;
    PVOID               DriverStart;
    ULONG               DriverSize;
    PVOID               DriverSection;
    PDRIVER_EXTENSION   DriverExtension;
    UNICODE_STRING      DriverName;
    PUNICODE_STRING     HardwareDatabase;
    PFAST_IO_DISPATCH   FastIoDispatch;
    PDRIVER_INITIALIZE  DriverInit;
    PDRIVER_STARTIO     DriverStartIo;
    PDRIVER_UNLOAD      DriverUnload;
    PDRIVER_DISPATCH    MajorFunction[IRP_MJ_MAXIMUM_FUNCTION + 1];
} DRIVER_OBJECT;
typedef DRIVER_OBJECT   *PDRIVER_OBJECT;

/* Section object pointers */
typedef struct _SECTION_OBJECT_POINTERS {
    PVOID   DataSectionObject;
    PVOID   SharedCacheMap;
    PVOID   ImageSectionObject;
} SECTION_OBJECT_POINTERS;
typedef SECTION_OBJECT_POINTERS *PSECTION_OBJECT_POINTERS;

/* I/O completion context */
typedef struct _IO_COMPLETION_CONTEXT {
    PVOID   Port;
    PVOID   Key;
} IO_COMPLETION_CONTEXT;
typedef IO_COMPLETION_CONTEXT   *PIO_COMPLETION_CONTEXT;

/* File object */
typedef struct _FILE_OBJECT {
    CSHORT                      Type;
    CSHORT                      Size;
    PDEVICE_OBJECT              DeviceObject;
    PVPB                        Vpb;
    PVOID                       FsContext;
    PVOID                       FsContext2;
    PSECTION_OBJECT_POINTERS    SectionObjectPointer;
    PVOID                       PrivateCacheMap;
    NTSTATUS                    FinalStatus;
    struct _FILE_OBJECT         *RelatedFileObject;
    BOOLEAN                     LockOperation;
    BOOLEAN                     DeletePending;
    BOOLEAN                     ReadAccess;
    BOOLEAN                     WriteAccess;
    BOOLEAN                     DeleteAccess;
    BOOLEAN                     SharedRead;
    BOOLEAN                     SharedWrite;
    BOOLEAN                     SharedDelete;
    ULONG                       Flags;
    UNICODE_STRING              FileName;
    LARGE_INTEGER               CurrentByteOffset;
    ULONG                       Waiters;
    ULONG                       Busy;
    PVOID                       LastLock;
    KEVENT                      Lock;
    KEVENT                      Event;
    PIO_COMPLETION_CONTEXT      CompletionContext;
    KSPIN_LOCK                  IrpListLock;
    LIST_ENTRY                  IrpList;
    PVOID                       FileObjectExtension;
} FILE_OBJECT;
typedef FILE_OBJECT *PFILE_OBJECT;
#if (NTDDI_VERSION >= 0x05020100)
typedef FILE_OBJECT LOG_FILE_OBJECT;
typedef FILE_OBJECT *PLOG_FILE_OBJECT;
typedef FILE_OBJECT **PPLOG_FILE_OBJECT;
#endif

/* I/O request packet */
typedef struct _IRP {
    CSHORT              Type;
    USHORT              Size;
    PMDL                MdlAddress;
    ULONG               Flags;
    union {
        struct _IRP *MasterIrp;
        LONG        IrpCount;
        PVOID       SystemBuffer;
    } AssociatedIrp;
    LIST_ENTRY          ThreadListEntry;
    IO_STATUS_BLOCK     IoStatus;
    KPROCESSOR_MODE     RequestorMode;
    BOOLEAN             PendingReturned;
    CHAR                StackCount;
    CHAR                CurrentLocation;
    BOOLEAN             Cancel;
    KIRQL               CancelIrql;
    CCHAR               ApcEnvironment;
    UCHAR               AllocationFlags;
    PIO_STATUS_BLOCK    UserIosb;
    PKEVENT             UserEvent;
    union {
        struct {
            union {
                PIO_APC_ROUTINE UserApcRoutine;
                PVOID           IssuingProcess;
            };
            PVOID   UserApcContext;
        } AsynchronousParameters;
        LARGE_INTEGER   AllocationSize;
    } Overlay;
    PDRIVER_CANCEL      CancelRoutine;
    PVOID               UserBuffer;
    union {
        struct {
            union {
                KDEVICE_QUEUE_ENTRY DeviceQueueEntry;
                struct {
                    PVOID   DriverContext[4];
                };
            };
            PETHREAD    Thread;
            PCHAR       AuxiliaryBuffer;
            struct {
                LIST_ENTRY  ListEntry;
                union {
                    struct _IO_STACK_LOCATION   *CurrentStackLocation;
                    ULONG                       PacketType;
                };
            };
            PFILE_OBJECT    OriginalFileObject;
        } Overlay;
        KAPC    Apc;
        PVOID   CompletionKey;
    } Tail;
} IRP;
typedef IRP *PIRP;

/* I/O completion routine */
typedef NTSTATUS    (NTAPI IO_COMPLETION_ROUTINE)( PDEVICE_OBJECT, PIRP, PVOID );
typedef IO_COMPLETION_ROUTINE   *PIO_COMPLETION_ROUTINE;

/* Device relation types */
typedef enum _DEVICE_RELATION_TYPE {
    BusRelations            = 0,
    EjectionRelations       = 1,
    PowerRelations          = 2,
    RemovalRelations        = 3,
    TargetDeviceRelation    = 4,
    SingleBusRelations      = 5,
    TransportRelations      = 6
} DEVICE_RELATION_TYPE;
typedef DEVICE_RELATION_TYPE    *PDEVICE_RELATION_TYPE;

/* Device relations */
typedef struct _DEVICE_RELATIONS {
    ULONG           Count;
    PDEVICE_OBJECT  Objects[1];
} DEVICE_RELATIONS;
typedef DEVICE_RELATIONS    *PDEVICE_RELATIONS;

/* Device usage notification types */
typedef enum _DEVICE_USAGE_NOTIFICATION_TYPE {
    DeviceUsageTypeUndefined    = 0,
    DeviceUsageTypePaging       = 1,
    DeviceUsageTypeHibernation  = 2,
    DeviceUsageTypeDumpFile     = 3
} DEVICE_USAGE_NOTIFICATION_TYPE;

/* Interface */
typedef struct _INTERFACE {
    USHORT                  Size;
    USHORT                  Version;
    PVOID                   Context;
    PINTERFACE_REFERENCE    InterfaceReference;
    PINTERFACE_DEREFERENCE  InterfaceDereference;
} INTERFACE;
typedef INTERFACE   *PINTERFACE;

/* Device capabilities */
typedef struct _DEVICE_CAPABILITIES {
    USHORT              Size;
    USHORT              Version;
    ULONG               DeviceD1            : 1;
    ULONG               DeviceD2            : 1;
    ULONG               LockSupported       : 1;
    ULONG               EjectSupported      : 1;
    ULONG               Removable           : 1;
    ULONG               DockDevice          : 1;
    ULONG               UniqueID            : 1;
    ULONG               SilentInstall       : 1;
    ULONG               RawDeviceOK         : 1;
    ULONG               SurpriseRemovalOK   : 1;
    ULONG               WakeFromD0          : 1;
    ULONG               WakeFromD1          : 1;
    ULONG               WakeFromD2          : 1;
    ULONG               WakeFromD3          : 1;
    ULONG               HardwareDisabled    : 1;
    ULONG               NonDynamic          : 1;
    ULONG               WarmEjectSupported  : 1;
    ULONG               NoDisplayInUI       : 1;
    ULONG               Reserved1           : 1;
    ULONG               Reserved            : 13;
    ULONG               Address;
    ULONG               UINumber;
    DEVICE_POWER_STATE  DeviceState[POWER_SYSTEM_MAXIMUM];
    SYSTEM_POWER_STATE  SystemWake;
    DEVICE_POWER_STATE  DeviceWake;
    ULONG               D1Latency;
    ULONG               D2Latency;
    ULONG               D3Latency;
} DEVICE_CAPABILITIES;
typedef DEVICE_CAPABILITIES *PDEVICE_CAPABILITIES;

/* Power sequence */
typedef struct _POWER_SEQUENCE {
    ULONG   SequenceD1;
    ULONG   SequenceD2;
    ULONG   SequenceD3;
} POWER_SEQUENCE;
typedef POWER_SEQUENCE  *PPOWER_SEQUENCE;

/* Bus query identifier types */
typedef enum {
    BusQueryDeviceID            = 0,
    BusQueryHardwareIDs         = 1,
    BusQueryCompatibleIDs       = 2,
    BusQueryInstanceIDs         = 3,
    BusQueryDeviceSerialNumber  = 4,
    BusQueryContainerID         = 5
} BUS_QUERY_ID_TYPE;
typedef BUS_QUERY_ID_TYPE   *PBUS_QUERY_ID_TYPE;

/* Device text types */
typedef enum {
    DeviceTextDescription           = 0,
    DeviceTextLocationInformation   = 1
} DEVICE_TEXT_TYPE;
typedef DEVICE_TEXT_TYPE    *PDEVICE_TEXT_TYPE;

/* I/O stack locations */
#pragma pack( __push, 4 )
typedef struct _IO_STACK_LOCATION {
    UCHAR           MajorFunction;
    UCHAR           MinorFunction;
    UCHAR           Flags;
    UCHAR           Control;
    union {
        struct {
            PIO_SECURITY_CONTEXT    SecurityContext;
            ULONG                   Options;
            USHORT                  FileAttributes;
            USHORT                  ShareAccess;
            ULONG                   EaLength;
        } Create;
        struct {
            ULONG           Length;
            ULONG           Key;
            LARGE_INTEGER   ByteOffset;
        } Read;
        struct {
            ULONG           Length;
            ULONG           Key;
            LARGE_INTEGER   ByteOffset;
        } Write;
        struct {
            ULONG                   Length;
            PUNICODE_STRING         FileName;
            FILE_INFORMATION_CLASS  FileInformationClass;
            ULONG                   FileIndex;
        } QueryDirectory;
        struct {
            ULONG   Length;
            ULONG   CompletionFilter;
        } NotifyDirectory;
        struct {
            ULONG                   Length;
            FILE_INFORMATION_CLASS  FileInformationClass;
        } QueryFile;
        struct {
            ULONG                   Length;
            FILE_INFORMATION_CLASS  FileInformationClass;
            PFILE_OBJECT            FileObject;
            union {
                struct {
                    BOOLEAN ReplaceIfExists;
                    BOOLEAN AdvanceOnly;
                };
                ULONG   ClusterCount;
                HANDLE  DeleteHandle;
            };
        } SetFile;
        struct {
            ULONG   Length;
            PVOID   EaList;
            ULONG   EaListLength;
            ULONG   EaIndex;
        } QueryEa;
        struct {
            ULONG   Length;
        } SetEa;
        struct {
            ULONG                   Length;
            FS_INFORMATION_CLASS    FsInformationClass;
        } QueryVolume;
        struct {
            ULONG                   Length;
            FS_INFORMATION_CLASS    FsInformationClass;
        } SetVolume;
        struct {
            ULONG   OutputBufferLength;
            ULONG   InputBufferLength;
            ULONG   FsControlCode;
            PVOID   Type3InputBuffer;
        } FileSystemControl;
        struct {
            PLARGE_INTEGER  Length;
            ULONG           Key;
            LARGE_INTEGER   ByteOffset;
        } LockControl;
        struct {
            ULONG   OutputBufferLength;
            ULONG   InputBufferLength;
            ULONG   IoControlCode;
            PVOID   Type3InputBuffer;
        } DeviceIoControl;
        struct {
            SECURITY_INFORMATION    SecurityInformation;
            ULONG                   Length;
        } QuerySecurity;
        struct {
            SECURITY_INFORMATION    SecurityInformation;
            PSECURITY_DESCRIPTOR    SecurityDescriptor;
        } SetSecurity;
        struct {
            PVPB            Vpb;
            PDEVICE_OBJECT  DeviceObject;
        } MountVolume;
        struct {
            PVPB            Vpb;
            PDEVICE_OBJECT  DeviceObject;
        } VerifyVolume;
        struct {
            struct _SCSI_REQUEST_BLOCK  *Srb;
        } Scsi;
        struct {
            ULONG                       Length;
            PSID                        StartSid;
            PFILE_GET_QUOTA_INFORMATION SidList;
            ULONG                       SidListLength;
        } QueryQuota;
        struct {
            ULONG   Length;
        } SetQuota;
        struct {
            DEVICE_RELATION_TYPE    Type;
        } QueryDeviceRelations;
        struct {
            CONST GUID  *InterfaceType;
            USHORT      Size;
            USHORT      Version;
            PINTERFACE  Interface;
            PVOID       InterfaceSpecificData;
        } QueryInterface;
        struct {
            PDEVICE_CAPABILITIES    Capabilities;
        } DeviceCapabilities;
        struct {
            PIO_RESOURCE_REQUIREMENTS_LIST  IoResourceRequirementList;
        } FilterResourceRequirements;
        struct {
            ULONG   WhichSpace;
            PVOID   Buffer;
            ULONG   Offset;
            ULONG   Length;
        } ReadWriteConfig;
        struct {
            BOOLEAN Lock;
        } SetLock;
        struct {
            BUS_QUERY_ID_TYPE   IdType;
        } QueryId;
        struct {
            DEVICE_TEXT_TYPE    DeviceTextType;
            LCID                LocaleId;
        } QueryDeviceText;
        struct {
            BOOLEAN                         InPath;
            BOOLEAN                         Reserved[3];
            DEVICE_USAGE_NOTIFICATION_TYPE  Type;
        } UsageNotification;
        struct {
            SYSTEM_POWER_STATE  PowerState;
        } WaitWake;
        struct {
            PPOWER_SEQUENCE PowerSequence;
        } PowerSequence;
        struct {
#if (NTDDI_VERSION >= 0x06000000)
            union {
                ULONG                       SystemContext;
                SYSTEM_POWER_STATE_CONTEXT  SystemPowerStateContext;
            };
#else
            ULONG   SystemContext;
#endif
            POWER_STATE_TYPE    Type;
            POWER_STATE         State;
            POWER_ACTION        ShutdownType;
        } Power;
        struct {
            PCM_RESOURCE_LIST   AllocatedResources;
            PCM_RESOURCE_LIST   AllocatedResourcesTranslated;
        } StartDevice;
        struct {
            ULONG_PTR   ProviderId;
            PVOID       DataPath;
            ULONG       BufferSize;
            PVOID       Buffer;
        } WMI;
        struct {
            PVOID   Argument1;
            PVOID   Argument2;
            PVOID   Argument3;
            PVOID   Argument4;
        } Others;
    } Parameters;
    PDEVICE_OBJECT  DeviceObject;
    PFILE_OBJECT    FileObject;
    PIO_COMPLETION_ROUTINE  CompletionRoutine;
    PVOID           Context;
} IO_STACK_LOCATION;
typedef IO_STACK_LOCATION   *PIO_STACK_LOCATION;
#pragma pack( __pop )

/* Share access */
typedef struct _SHARE_ACCESS {
    ULONG   OpenCount;
    ULONG   Readers;
    ULONG   Writers;
    ULONG   Deleters;
    ULONG   SharedRead;
    ULONG   SharedWrite;
    ULONG   SharedDelete;
} SHARE_ACCESS;
typedef SHARE_ACCESS    *PSHARE_ACCESS;

/* I/O paging priorities */
typedef enum _IO_PAGING_PRIORITY {
    IoPagingPriorityInvalid = 0,
    IoPagingPriorityNormal  = 1,
    IoPagingPriorityHigh    = 2
} IO_PAGING_PRIORITY;

/* Boot disk information */
typedef struct _BOOTDISK_INFORMATION {
    LONGLONG    BootPartitionOffset;
    LONGLONG    SystemPartitionOffset;
    ULONG       BootDeviceSignature;
    ULONG       SystemDeviceSignature;
} BOOTDISK_INFORMATION;
typedef BOOTDISK_INFORMATION    *PBOOTDISK_INFORMATION;

/* Boot disk information (extended version) */
typedef struct _BOOTDISK_INFORMATION_EX {
    LONGLONG    BootPartitionOffset;
    LONGLONG    SystemPartitionOffset;
    ULONG       BootDeviceSignature;
    ULONG       SystemDeviceSignature;
    GUID        BootDeviceGuid;
    GUID        SystemDeviceGuid;
    BOOLEAN     BootDeviceIsGpt;
    BOOLEAN     SystemDeviceIsGpt;
} BOOTDISK_INFORMATION_EX;
typedef BOOTDISK_INFORMATION_EX *PBOOTDISK_INFORMATION_EX;

/* Loader partition information (extended version) */
#if (NTDDI_VERSION >= 0x06010000)
typedef struct _LOADER_PARTITION_INFORMATION_EX {
    ULONG   PartitionStyle;
    ULONG   PartitionNumber;
    union {
        ULONG   Signature;
        GUID    DeviceId;
    };
    ULONG   Flags;
} LOADER_PARTITION_INFORMATION_EX;
typedef LOADER_PARTITION_INFORMATION_EX *PLOADER_PARTITION_INFORMATION_EX;
#endif

/* Boot disk information (lite version) */
#if (NTDDI_VERSION >= 0x06010000)
typedef struct _BOOTDISK_INFORMATION_LITE {
    ULONG                           NumberEntries;
    LOADER_PARTITION_INFORMATION_EX Entries[1];
} BOOTDISK_INFORMATION_LITE;
typedef BOOTDISK_INFORMATION_LITE   *PBOOTDISK_INFORMATION_LITE;
#elif (NTDDI_VERSION >= 0x06000000)
typedef struct _BOOTDISK_INFORMATION_LITE {
    ULONG   BootDeviceSignature;
    ULONG   SystemDeviceSignature;
    GUID    BootDeviceGuid;
    GUID    SystemDeviceGuid;
    BOOLEAN BootDeviceIsGpt;
    BOOLEAN SystemDeviceIsGpt;
} BOOTDISK_INFORMATION_LITE;
typedef BOOTDISK_INFORMATION_LITE   *PBOOTDISK_INFORMATION_LITE;
#endif

/* I/O completion routine results */
typedef enum _IO_COMPLETION_ROUTINE_RESULT {
    ContinueCompletion  = STATUS_CONTINUE_COMPLETION,
    StopCompletion      = STATUS_MORE_PROCESSING_REQUIRED
} IO_COMPLETION_ROUTINE_RESULT;
typedef IO_COMPLETION_ROUTINE_RESULT    *PIO_COMPLETION_ROUTINE_RESULT;

/* I/O interrupt message information entry */
typedef struct _IO_INTERRUPT_MESSAGE_INFO_ENTRY {
    PHYSICAL_ADDRESS    MessageAddress;
    KAFFINITY           TargetProcessorSet;
    PKINTERRUPT         InterruptObject;
    ULONG               MessageData;
    ULONG               Vector;
    KIRQL               Irql;
    KINTERRUPT_MODE     Mode;
    KINTERRUPT_POLARITY Polarity;
} IO_INTERRUPT_MESSAGE_INFO_ENTRY;
typedef IO_INTERRUPT_MESSAGE_INFO_ENTRY *PIO_INTERRUPT_MESSAGE_INFO_ENTRY;

/* I/O interrupt message information */
typedef struct _IO_INTERRUPT_MESSAGE_INFO {
    KIRQL                           UnifiedIrql;
    ULONG                           MessageCount;
    IO_INTERRUPT_MESSAGE_INFO_ENTRY MessageInfo[1];
} IO_INTERRUPT_MESSAGE_INFO;
typedef IO_INTERRUPT_MESSAGE_INFO   *PIO_INTERRUPT_MESSAGE_INFO;

/* I/O connect interrupt fully specified parameters */
typedef struct _IO_CONNECT_INTERRUPT_FULLY_SPECIFIED_PARAMETERS {
    PDEVICE_OBJECT      PhysicalDeviceObject;
    PKINTERRUPT         *InterruptObject;
    PKSERVICE_ROUTINE   ServiceRoutine;
    PVOID               ServiceContext;
    PKSPIN_LOCK         SpinLock;
    KIRQL               SynchronizeIrql;
    BOOLEAN             FloatingSave;
    BOOLEAN             ShareVector;
    ULONG               Vector;
    KIRQL               Irql;
    KINTERRUPT_MODE     InterruptMode;
    KAFFINITY           ProcessorEnableMask;
    USHORT              Group;
} IO_CONNECT_INTERRUPT_FULLY_SPECIFIED_PARAMETERS;
typedef IO_CONNECT_INTERRUPT_FULLY_SPECIFIED_PARAMETERS *PIO_CONNECT_INTERRUPT_FULLY_SPECIFIED_PARAMETERS;

/* I/O connect interrupt line-based parameters */
typedef struct _IO_CONNECT_INTERRUPT_LINE_BASED_PARAMETERS {
    PDEVICE_OBJECT      PhysicalDeviceObject;
    PKINTERRUPT         *InterruptObject;
    PKSERVICE_ROUTINE   ServiceRoutine;
    PVOID               ServiceContext;
    PKSPIN_LOCK         SpinLock;
    KIRQL               SynchronizeIrql;
    BOOLEAN             FloatingSave;
} IO_CONNECT_INTERRUPT_LINE_BASED_PARAMETERS;
typedef IO_CONNECT_INTERRUPT_LINE_BASED_PARAMETERS  *PIO_CONNECT_INTERRUPT_LINE_BASED_PARAMETERS;

/* I/O connect interrupt message-based parameters */
typedef struct _IO_CONNECT_INTERRUPT_MESSAGE_BASED_PARAMETERS {
    PDEVICE_OBJECT              PhysicalDeviceObject;
    union {
        PVOID                       *Generic;
        PIO_INTERRUPT_MESSAGE_INFO  *InterruptMessageTable;
        PKINTERRUPT                 *InterruptObject;
    } ConnectionContext;
    PKMESSAGE_SERVICE_ROUTINE   MessageServiceRoutine;
    PVOID                       ServiceContext;
    PKSPIN_LOCK                 SpinLock;
    KIRQL                       SynchronizeIrql;
    BOOLEAN                     FloatingSave;
    PKSERVICE_ROUTINE           FallbackServiceRoutine;
} IO_CONNECT_INTERRUPT_MESSAGE_BASED_PARAMETERS;
typedef IO_CONNECT_INTERRUPT_MESSAGE_BASED_PARAMETERS   *PIO_CONNECT_INTERRUPT_MESSAGE_BASED_PARAMETERS;

/* I/O connect interrupt parameters */
typedef struct _IO_CONNECT_INTERRUPT_PARAMETERS {
    ULONG   Version;
    union {
        IO_CONNECT_INTERRUPT_FULLY_SPECIFIED_PARAMETERS FullySpecified;
        IO_CONNECT_INTERRUPT_LINE_BASED_PARAMETERS      LineBased;
        IO_CONNECT_INTERRUPT_MESSAGE_BASED_PARAMETERS   MessageBased;
    };
} IO_CONNECT_INTERRUPT_PARAMETERS;
typedef IO_CONNECT_INTERRUPT_PARAMETERS *PIO_CONNECT_INTERRUPT_PARAMETERS;

/* I/O disconnect interrupt parameters */
typedef struct _IO_DISCONNECT_INTERRUPT_PARAMETERS {
    ULONG   Version;
    union {
        PVOID                       Generic;
        PKINTERRUPT                 InterruptObject;
        PIO_INTERRUPT_MESSAGE_INFO  InterruptMessageTable;
    } ConnectionContext;
} IO_DISCONNECT_INTERRUPT_PARAMETERS;
typedef IO_DISCONNECT_INTERRUPT_PARAMETERS  *PIO_DISCONNECT_INTERRUPT_PARAMETERS;

/* I/O remove lock common block */
typedef struct _IO_REMOVE_LOCK_COMMON_BLOCK {
    BOOLEAN Removed;
    BOOLEAN Reserved[3];
    LONG    IoCount;
    KEVENT  RemoveEvent;
} IO_REMOVE_LOCK_COMMON_BLOCK;

/* I/O remove lock debug block */
typedef struct _IO_REMOVE_LOCK_DBG_BLOCK {
    LONG        Signature;
    ULONG       HighWatermark;
    LONGLONG    MaxLockedTicks;
    LONG        AllocateTag;
    LIST_ENTRY  LockList;
    KSPIN_LOCK  Spin;
    LONG        LowMemoryCount;
    ULONG       Reserved1[4];
    PVOID       Reserved2;
    PIO_REMOVE_LOCK_TRACKING_BLOCK  Blocks;
} IO_REMOVE_LOCK_DBG_BLOCK;

/* I/O remove lock */
typedef struct _IO_REMOVE_LOCK {
    IO_REMOVE_LOCK_COMMON_BLOCK Common;
#if DBG
    IO_REMOVE_LOCK_DBG_BLOCK    Dbg;
#endif
} IO_REMOVE_LOCK;
typedef IO_REMOVE_LOCK  *PIO_REMOVE_LOCK;

/* I/O work item routine */
typedef VOID        NTAPI IO_WORKITEM_ROUTINE( PDEVICE_OBJECT, PVOID );
typedef VOID        NTAPI IO_WORKITEM_ROUTINE_EX( PVOID, PVOID, PIO_WORKITEM );
typedef IO_WORKITEM_ROUTINE     *PIO_WORKITEM_ROUTINE;
typedef IO_WORKITEM_ROUTINE_EX  *PIO_WORKITEM_ROUTINE_EX;

/* WMI notification callback */
typedef VOID        (NTAPI FWMI_NOTIFICATION_CALLBACK)( PVOID, PVOID );
typedef FWMI_NOTIFICATION_CALLBACK  *WMI_NOTIFICATION_CALLBACK;

/* I/O cancel safe queue IRP context */
typedef struct _IO_CSQ_IRP_CONTEXT {
    ULONG           Type;
    PIRP            Irp;
    struct IO_CSQ   *Csq;
} IO_CSQ_IRP_CONTEXT;
typedef IO_CSQ_IRP_CONTEXT  *PIO_CSQ_IRP_CONTEXT;

/* I/O cancel safe queue routines */
typedef VOID        (NTAPI IO_CSQ_INSERT_IRP)( struct _IO_CSQ *, PIRP );
typedef NTSTATUS    (NTAPI IO_CSQ_INSERT_IRP_EX)( struct _IO_CSQ *, PIRP, PVOID );
typedef VOID        (NTAPI IO_CSQ_REMOVE_IRP)( struct _IO_CSQ *, PIRP );
typedef PIRP        (NTAPI IO_CSQ_PEEK_NEXT_IRP)( struct _IO_CSQ *, PIRP, PVOID );
typedef VOID        (NTAPI IO_CSQ_ACQUIRE_LOCK)( struct _IO_CSQ *, PKIRQL );
typedef VOID        (NTAPI IO_CSQ_RELEASE_LOCK)( struct _IO_CSQ *, PKIRQL );
typedef VOID        (NTAPI IO_CSQ_COMPLETE_CANCELED_IRP)( struct _IO_CSQ *, PIRP );
typedef IO_CSQ_INSERT_IRP               *PIO_CSQ_INSERT_IRP;
typedef IO_CSQ_INSERT_IRP_EX            *PIO_CSQ_INSERT_IRP_EX;
typedef IO_CSQ_REMOVE_IRP               *PIO_CSQ_REMOVE_IRP;
typedef IO_CSQ_PEEK_NEXT_IRP            *PIO_CSQ_PEEK_NEXT_IRP;
typedef IO_CSQ_ACQUIRE_LOCK             *PIO_CSQ_ACQUIRE_LOCK;
typedef IO_CSQ_RELEASE_LOCK             *PIO_CSQ_RELEASE_LOCK;
typedef IO_CSQ_COMPLETE_CANCELED_IRP    *PIO_CSQ_COMPLETE_CANCELED_IRP;

/* I/O cancel safe queue */
typedef struct _IO_CSQ {
    ULONG                           Type;
    PIO_CSQ_INSERT_IRP              CsqInsertIrp;
    PIO_CSQ_REMOVE_IRP              CsqRemoveIrp;
    PIO_CSQ_PEEK_NEXT_IRP           CsqPeekNextIrp;
    PIO_CSQ_ACQUIRE_LOCK            CsqAcquireLock;
    PIO_CSQ_RELEASE_LOCK            CsqReleaseLock;
    PIO_CSQ_COMPLETE_CANCELED_IRP   CsqCompleteCanceledIrp;
    PVOID                           ReservePointer;
} IO_CSQ;
typedef IO_CSQ  *PIO_CSQ;

/* I/O access types */
typedef enum _IO_ACCESS_TYPE {
    ReadAccess      = 0,
    WriteAccess     = 1,
    ModifyAccess    = 2
} IO_ACCESS_TYPE;

/* I/O access modes */
typedef enum _IO_ACCESS_MODE {
    SequentialAccess    = 0,
    RandomAccess        = 1
} IO_ACCESS_MODE;

/* I/O container notification classes */
typedef enum _IO_CONTAINER_NOTIFICATION_CLASS {
    IoSessionStateNotification      = 0,
    IoMaxContainerNotificationClass = 1
} IO_CONTAINER_NOTIFICATION_CLASS;

/* I/O session state notification */
typedef struct _IO_SESSION_STATE_NOTIFICATION {
    ULONG   Size;
    ULONG   Flags;
    PVOID   IoObject;
    ULONG   EventMask;
    PVOID   Context;
} IO_SESSION_STATE_NOTIFICATION;
typedef IO_SESSION_STATE_NOTIFICATION   *PIO_SESSION_STATE_NOTIFICATION;

/* I/O container information classes */
typedef enum _IO_CONTAINER_INFORMATION_CLASS {
    IoSessionStateInformation       = 0,
    IoMaxContainerInformationClass  = 1
} IO_CONTAINER_INFORMATION_CLASS;

/* I/O session state information */
typedef struct _IO_SESSION_STATE_INFORMATION {
    ULONG               SessionId;
    IO_SESSION_STATE    SessionState;
    BOOLEAN             LocalSession;
} IO_SESSION_STATE_INFORMATION;
typedef IO_SESSION_STATE_INFORMATION    *PIO_SESSION_STATE_INFORMATION;

/* I/O container notification function */
#if (NTDDI_VERSION >= 0x06010000)
typedef NTSTATUS    (NTAPI *PIO_CONTAINER_NOTIFICATION_FUNCTION)();
#endif

/* I/O session notification function */
#if (NTDDI_VERSION >= 0x06010000)
typedef NTSTATUS    (NTAPI IO_SESSION_NOTIFICATION_FUNCTION)( PVOID, PVOID, ULONG, PVOID, PVOID, ULONG );
typedef IO_SESSION_NOTIFICATION_FUNCTION    *PIO_SESSION_NOTIFICATION_FUNCTION;
#endif

/* Trace session settings */
typedef struct _ETW_TRACE_SESSION_SETTINGS {
    ULONG   Version;
    ULONG   BufferSize;
    ULONG   MinimumBuffers;
    ULONG   MaximumBuffers;
    ULONG   LoggerMode;
    ULONG   FlushTimer;
    ULONG   FlushThreshold;
    ULONG   ClockType;
} ETW_TRACE_SESSION_SETTINGS;
typedef ETW_TRACE_SESSION_SETTINGS  *PETW_TRACE_SESSION_SETTINGS;

/* Trace information classes */
typedef enum _TRACE_INFORMATION_CLASS {
    TraceIdClass                = 0,
    TraceHandleClass            = 1,
    TraceEnableFlagsClass       = 2,
    TraceEnableLevelClass       = 3,
    GlobalLoggerHandleClass     = 4,
    EventLoggerHandleClass      = 5,
    AllLoggerHandlesClass       = 6,
    TraceHandleByNameClass      = 7,
    LoggerEventsLostClass       = 8,
    TraceSessionSettingsClass   = 9,
    LoggerEventsLoggedClass     = 10,
    MaxTraceInformationClass    = 11
} TRACE_INFORMATION_CLASS;

/* Enable callback */
typedef VOID        (NTAPI *PETWENABLECALLBACK)( LPCGUID, ULONG, UCHAR, ULONGLONG, ULONGLONG, PEVENT_FILTER_DESCRIPTOR );

/* Device registry properties */
typedef enum {
    DevicePropertyDeviceDescription             = 0,
    DevicePropertyHardwareID                    = 1,
    DevicePropertyCompatibleIDs                 = 2,
    DevicePropertyBootConfiguration             = 3,
    DevicePropertyBootConfigurationTranslated   = 4,
    DevicePropertyClassName                     = 5,
    DevicePropertyClassGuid                     = 6,
    DevicePropertyDriverKeyName                 = 7,
    DevicePropertyManufacturer                  = 8,
    DevicePropertyFriendlyName                  = 9,
    DevicePropertyLocationInformation           = 10,
    DevicePropertyPhysicalDeviceObjectName      = 11,
    DevicePropertyBusTypeGuid                   = 12,
    DevicePropertyLegacyBusType                 = 13,
    DevicePropertyBusNumber                     = 14,
    DevicePropertyEnumeratorName                = 15,
    DevicePropertyAddress                       = 16,
    DevicePropertyUINumber                      = 17,
    DevicePropertyInstallState                  = 18,
    DevicePropertyRemovalPolicy                 = 19,
    DevicePropertyResourceRequirements          = 20,
    DevicePropertyAllocatedResources            = 21,
    DevicePropertyContainerID                   = 22,
} DEVICE_REGISTRY_PROPERTY;

/* Bus interface callbacks */
typedef BOOLEAN     (NTAPI TRANSLATE_BUS_ADDRESS)( PVOID, PHYSICAL_ADDRESS, ULONG, PULONG, PPHYSICAL_ADDRESS );
typedef struct _DMA_ADAPTER * (NTAPI GET_DMA_ADAPTER)( PVOID, struct _DEVICE_DESCRIPTION *, PULONG );
typedef ULONG       (NTAPI GET_SET_DEVICE_DATA)( PVOID, ULONG, PVOID, ULONG, ULONG );
typedef TRANSLATE_BUS_ADDRESS   *PTRANSLATE_BUS_ADDRESS;
typedef GET_DMA_ADAPTER         *PGET_DMA_ADAPTER;
typedef GET_SET_DEVICE_DATA     *PGET_SET_DEVICE_DATA;

/* Device install states */
typedef enum _DEVICE_INSTALL_STATE {
    InstallStateInstalled       = 0,
    InstallStateNeedsReinstall  = 1,
    InstallStateFailedInstall   = 2,
    InstallStateFinishInstall   = 3
} DEVICE_INSTALL_STATE;
typedef DEVICE_INSTALL_STATE    *PDEVICE_INSTALL_STATE;

/* Plug and Play bus information */
typedef struct _PNP_BUS_INFORMATION {
    GUID            BusTypeGuid;
    INTERFACE_TYPE  LegacyBusType;
    ULONG           BusNumber;
} PNP_BUS_INFORMATION;
typedef PNP_BUS_INFORMATION *PPNP_BUS_INFORMATION;

/* Legacy bus information */
typedef struct _LEGACY_BUS_INFORMATION {
    GUID            BusTypeGuid;
    INTERFACE_TYPE  LegacyBusType;
    ULONG           BusNumber;
} LEGACY_BUS_INFORMATION;
typedef LEGACY_BUS_INFORMATION  *PLEGACY_BUS_INFORMATION;

/* Device removal policies */
typedef enum _DEVICE_REMOVAL_POLICY {
    RemovalPolicyExpectNoRemoval        = 1,
    RemovalPolicyExpectOrderlyRemoval   = 2,
    RemovalPolicyExpectSurpriseRemoval  = 3
} DEVICE_REMOVAL_POLICY;
typedef DEVICE_REMOVAL_POLICY   *PDEVICE_REMOVAL_POLICY;

/* Bus interface standard */
typedef struct _BUS_INTERFACE_STANDARD {
    USHORT                  Size;
    USHORT                  Version;
    PVOID                   Context;
    PINTERFACE_REFERENCE    InterfaceReference;
    PINTERFACE_DEREFERENCE  InterfaceDereference;
    PTRANSLATE_BUS_ADDRESS  TranslateBusAddress;
    PGET_DMA_ADAPTER        GetDmaAdapter;
    PGET_SET_DEVICE_DATA    SetBusData;
    PGET_SET_DEVICE_DATA    GetBusData;
} BUS_INTERFACE_STANDARD;
typedef BUS_INTERFACE_STANDARD  *PBUS_INTERFACE_STANDARD;

/* Reenumerate self callback */
typedef VOID        (NTAPI *PREENUMERATE_SELF)( PVOID );

/* Reenumerate self interface standard */
typedef struct _REENUMERATE_SELF_INTERFACE_STANDARD {
    USHORT                  Size;
    USHORT                  Version;
    PVOID                   Context;
    PINTERFACE_REFERENCE    InterfaceReference;
    PINTERFACE_DEREFERENCE  InterfaceDereference;
    PREENUMERATE_SELF       SurpriseRemoveAndReenumerateSelf;
} REENUMERATE_SELF_INTERFACE_STANDARD;
typedef REENUMERATE_SELF_INTERFACE_STANDARD *PREENUMERATE_SELF_INTERFACE_STANDARD;

/* ACPI interface callbacks */
typedef BOOLEAN     (NTAPI *PGPE_SERVICE_ROUTINE)( PVOID, PVOID );
typedef NTSTATUS    (NTAPI *PGPE_CONNECT_VECTOR)( PDEVICE_OBJECT, ULONG, KINTERRUPT_MODE, BOOLEAN, PGPE_SERVICE_ROUTINE, PVOID, PVOID );
typedef NTSTATUS    (NTAPI *PGPE_DISCONNECT_VECTOR)( PVOID );
typedef NTSTATUS    (NTAPI *PGPE_ENABLE_EVENT)( PDEVICE_OBJECT, PVOID );
typedef NTSTATUS    (NTAPI *PGPE_DISABLE_EVENT)( PDEVICE_OBJECT, PVOID );
typedef NTSTATUS    (NTAPI *PGPE_CLEAR_STATUS)( PDEVICE_OBJECT, PVOID );
typedef VOID        (NTAPI *PDEVICE_NOTIFY_CALLBACK)( PVOID, ULONG );
typedef NTSTATUS    (NTAPI *PREGISTER_FOR_DEVICE_NOTIFICATIONS)( PDEVICE_OBJECT, PDEVICE_NOTIFY_CALLBACK, PVOID );
typedef void        (NTAPI *PUNREGISTER_FOR_DEVICE_NOTIFICATIONS)( PDEVICE_OBJECT, PDEVICE_NOTIFY_CALLBACK );
typedef BOOLEAN     (NTAPI *PGPE_SERVICE_ROUTINE2)( PVOID, PVOID );
typedef NTSTATUS    (NTAPI *PGPE_CONNECT_VECTOR2)( PVOID, ULONG, KINTERRUPT_MODE, BOOLEAN, PGPE_SERVICE_ROUTINE, PVOID, PVOID * );
typedef NTSTATUS    (NTAPI *PGPE_DISCONNECT_VECTOR2)( PVOID, PVOID );
typedef NTSTATUS    (NTAPI *PGPE_ENABLE_EVENT2)( PVOID, PVOID );
typedef NTSTATUS    (NTAPI *PGPE_DISABLE_EVENT2)( PVOID, PVOID );
typedef NTSTATUS    (NTAPI *PGPE_CLEAR_STATUS2)( PVOID, PVOID );
typedef VOID        (NTAPI *PDEVICE_NOTIFY_CALLBACK2)( PVOID, ULONG );
typedef NTSTATUS    (NTAPI *PREGISTER_FOR_DEVICE_NOTIFICATIONS2)( PVOID, PDEVICE_NOTIFY_CALLBACK2, PVOID );
typedef VOID        (NTAPI *PUNREGISTER_FOR_DEVICE_NOTIFICATIONS2)( PVOID );

/* ACPI interface standard */
typedef struct _ACPI_INTERFACE_STANDARD {
    USHORT                                  Size;
    USHORT                                  Version;
    PVOID                                   Context;
    PINTERFACE_REFERENCE                    InterfaceReference;
    PINTERFACE_DEREFERENCE                  InterfaceDereference;
    PGPE_CONNECT_VECTOR                     GpeConnectVector;
    PGPE_DISCONNECT_VECTOR                  GpeDisconnectVector;
    PGPE_ENABLE_EVENT                       GpeEnableEvent;
    PGPE_DISABLE_EVENT                      GpeDisableEvent;
    PGPE_CLEAR_STATUS                       GpeClearStatus;
    PREGISTER_FOR_DEVICE_NOTIFICATIONS      RegisterForDeviceNotifications;
    PUNREGISTER_FOR_DEVICE_NOTIFICATIONS    UnregisterForDeviceNotifications;
} ACPI_INTERFACE_STANDARD;
typedef ACPI_INTERFACE_STANDARD *PACPI_INTERFACE_STANDARD;

/* ACPI interface standard (version 2) */
typedef struct {
    USHORT                                  Size;
    USHORT                                  Version;
    PVOID                                   Context;
    PINTERFACE_REFERENCE                    InterfaceReference;
    PINTERFACE_DEREFERENCE                  InterfaceDereference;
    PGPE_CONNECT_VECTOR2                    GpeConnectVector;
    PGPE_DISCONNECT_VECTOR2                 GpeDisconnectVector;
    PGPE_ENABLE_EVENT2                      GpeEnableEvent;
    PGPE_DISABLE_EVENT2                     GpeDisableEvent;
    PGPE_CLEAR_STATUS2                      GpeClearStatus;
    PREGISTER_FOR_DEVICE_NOTIFICATIONS2     RegisterForDeviceNotifications;
    PUNREGISTER_FOR_DEVICE_NOTIFICATIONS2   UnregisterForDeviceNotifications;
} ACPI_INTERFACE_STANDARD2;
typedef ACPI_INTERFACE_STANDARD2    *PACPI_INTERFACE_STANDARD2;

/* I/O device eject callback */
typedef VOID        (NTAPI *PIO_DEVICE_EJECT_CALLBACK)( NTSTATUS, PVOID );

/* I/O notification event categories */
typedef enum _IO_NOTIFICATION_EVENT_CATEGORY {
    EventCategoryHardwareProfileChange  = 1,
    EventCategoryDeviceInterfaceChange  = 2,
    EventCategoryTargetDeviceChange     = 3
} IO_NOTIFICATION_EVENT_CATEGORY;

/* Driver notification callback */
typedef NTSTATUS    (NTAPI DRIVER_NOTIFICATION_CALLBACK_ROUTINE)( PVOID, PVOID );
typedef DRIVER_NOTIFICATION_CALLBACK_ROUTINE    *PDRIVER_NOTIFICATION_CALLBACK_ROUTINE;

/* Device change complete callback */
typedef VOID        (NTAPI DEVICE_CHANGE_COMPLETE_CALLBACK)( PVOID );
typedef DEVICE_CHANGE_COMPLETE_CALLBACK *PDEVICE_CHANGE_COMPLETE_CALLBACK;

/* Plug and Play notification header */
typedef struct _PLUGPLAY_NOTIFICATION_HEADER {
    USHORT  Version;
    USHORT  Size;
    GUID    Event;
} PLUGPLAY_NOTIFICATION_HEADER;
typedef PLUGPLAY_NOTIFICATION_HEADER    *PPLUGPLAY_NOTIFICATION_HEADER;

/* Hardware profile change notification */
typedef struct _HWPROFILE_CHANGE_NOTIFICATION {
    USHORT  Version;
    USHORT  Size;
    GUID    Event;
} HWPROFILE_CHANGE_NOTIFICATION;
typedef HWPROFILE_CHANGE_NOTIFICATION   *PHWPROFILE_CHANGE_NOTIFICATION;

/* Device interface change notification */
typedef struct _DEVICE_INTERFACE_CHANGE_NOTIFICATION {
    USHORT          Version;
    USHORT          Size;
    GUID            Event;
    GUID            InterfaceClassGuid;
    PUNICODE_STRING SymbolicLinkName;
} DEVICE_INTERFACE_CHANGE_NOTIFICATION;
typedef DEVICE_INTERFACE_CHANGE_NOTIFICATION    *PDEVICE_INTERFACE_CHANGE_NOTIFICATION;

/* Target device removal notification */
typedef struct _TARGET_DEVICE_REMOVAL_NOTIFICATION {
    USHORT          Version;
    USHORT          Size;
    GUID            Event;
    PFILE_OBJECT    FileObject;
} TARGET_DEVICE_REMOVAL_NOTIFICATION;
typedef TARGET_DEVICE_REMOVAL_NOTIFICATION  *PTARGET_DEVICE_REMOVAL_NOTIFICATION;

/* Target device custom notification */
typedef struct _TARGET_DEVICE_CUSTOM_NOTIFICATION {
    USHORT          Version;
    USHORT          Size;
    GUID            Event;
    PFILE_OBJECT    FileObject;
    LONG            NameBufferOffset;
    UCHAR           CustomDataBuffer[1];
} TARGET_DEVICE_CUSTOM_NOTIFICATION;
typedef TARGET_DEVICE_CUSTOM_NOTIFICATION   *PTARGET_DEVICE_CUSTOM_NOTIFICATION;

/* Plug and Play replace driver interface callbacks */
typedef NTSTATUS    (NTAPI *PREPLACE_DRIVER_INIT)( struct _PNP_REPLACE_DRIVE_INTERFACE *, PVOID );
typedef NTSTATUS    (NTAPI *PREPLACE_MAP_MEMORY)( PHYSICAL_ADDRESS, PHYSICAL_ADDRESS, PLARGE_INTEGER, PVOID *, PVOID * );

/* Plug and Play replace memory list */
typedef struct _PNP_REPLACE_MEMORY_LIST {
    ULONG       AllocatedCount;
    ULONG       Count;
    ULONGLONG   TotalLength;
    struct {
        PHYSICAL_ADDRESS    Address;
        ULONGLONG           Length;
    } Ranges[ANYSIZE_ARRAY];
} PNP_REPLACE_MEMORY_LIST;
typedef PNP_REPLACE_MEMORY_LIST *PPNP_REPLACE_MEMORY_LIST;

/* Plug and Play replace processor list */
typedef struct _PNP_REPLACE_PROCESSOR_LIST {
    PKAFFINITY  Affinity;
    ULONG       GroupCount;
    ULONG       AllocatedCount;
    ULONG       Count;
    ULONG       ApicIds[ANYSIZE_ARRAY];
} PNP_REPLACE_PROCESSOR_LIST;
typedef PNP_REPLACE_PROCESSOR_LIST  *PPNP_REPLACE_PROCESSOR_LIST;

/* Plug and Play replace processor list (version 1) */
typedef struct _PNP_REPLACE_PROCESSOR_LIST_V1 {
    KAFFINITY   AffinityMask;
    ULONG       AllocatedCount;
    ULONG       Count;
    ULONG       ApicIds[ANYSIZE_ARRAY];
} PNP_REPLACE_PROCESSOR_LIST_V1;
typedef PNP_REPLACE_PROCESSOR_LIST_V1   *PPNP_REPLACE_PROCESSOR_LIST_V1;

/* Plug and Play replace parameters */
typedef struct _PNP_REPLACE_PARAMETERS {
    ULONG                       Size;
    ULONG                       Version;
    ULONG64                     Target;
    ULONG64                     Spare;
    PPNP_REPLACE_PROCESSOR_LIST TargetProcessors;
    PPNP_REPLACE_PROCESSOR_LIST SpareProcessors;
    PPNP_REPLACE_MEMORY_LIST    TargetMemory;
    PPNP_REPLACE_MEMORY_LIST    SpareMemory;
    PREPLACE_MAP_MEMORY         MapMemory;
} PNP_REPLACE_PARAMETERS;
typedef PNP_REPLACE_PARAMETERS  *PPNP_REPLACE_PARAMETERS;

/* Plug and Play replace driver interface callbacks */
typedef VOID        (NTAPI *PREPLACE_UNLOAD)( VOID );
typedef NTSTATUS    (NTAPI *PREPLACE_BEGIN)( PPNP_REPLACE_PARAMETERS, PVOID * );
typedef NTSTATUS    (NTAPI *PREPLACE_END)( PVOID );
typedef NTSTATUS    (NTAPI *PREPLACE_MIRROR_PHYSICAL_MEMORY)( PVOID, PHYSICAL_ADDRESS, LARGE_INTEGER );
typedef NTSTATUS    (NTAPI *PREPLACE_SET_PROCESSOR_ID)( PVOID, ULONG, BOOLEAN );
typedef NTSTATUS    (NTAPI *PREPLACE_SWAP)( PVOID );
typedef NTSTATUS    (NTAPI *PREPLACE_INITIATE_HARDWARE_MIRROR)( PVOID );
typedef NTSTATUS    (NTAPI *PREPLACE_MIRROR_PLATFORM_MEMORY)( PVOID );
typedef NTSTATUS    (NTAPI *PREPLACE_GET_MEMORY_DESTINATION)( PVOID, PHYSICAL_ADDRESS, PPHYSICAL_ADDRESS );
typedef NTSTATUS    (NTAPI *PREPLACE_ENABLE_DISABLE_HARDWARE_QUIESCE)( PVOID, BOOLEAN );

/* Plug and Play replace driver interface */
typedef struct _PNP_REPLACE_DRIVER_INTERFACE {
    ULONG                                       Size;
    ULONG                                       Version;
    ULONG                                       Flags;
    PREPLACE_UNLOAD                             Unload;
    PREPLACE_BEGIN                              BeginReplace;
    PREPLACE_END                                EndReplace;
    PREPLACE_MIRROR_PHYSICAL_MEMORY             MirrorPhysicalMemory;
    PREPLACE_SET_PROCESSOR_ID                   SetProcessorId;
    PREPLACE_SWAP                               Swap;
    PREPLACE_INITIATE_HARDWARE_MIRROR           InitiateHardwareMirror;
    PREPLACE_MIRROR_PLATFORM_MEMORY             MirrorPlatformMemory;
    PREPLACE_GET_MEMORY_DESTINATION             GetMemoryDestination;
    PREPLACE_ENABLE_DISABLE_HARDWARE_QUIESCE    EnableDisableHardwareQuiesce;
} PNP_REPLACE_DRIVER_INTERFACE;
typedef PNP_REPLACE_DRIVER_INTERFACE    *PPNP_REPLACE_DRIVER_INTERFACE;

/* Device description */
typedef struct _DEVICE_DESCRIPTION {
    ULONG           Version;
    BOOLEAN         Master;
    BOOLEAN         ScatterGather;
    BOOLEAN         DemandMode;
    BOOLEAN         AutoInitialize;
    BOOLEAN         Dma32BitAddresses;
    BOOLEAN         IgnoreCount;
    BOOLEAN         Reserved1;
    BOOLEAN         Dma64BitAddresses;
    ULONG           BusNumber;
    ULONG           DmaChannel;
    INTERFACE_TYPE  InterfaceType;
    DMA_WIDTH       DmaWidth;
    DMA_SPEED       DmaSpeed;
    ULONG           MaximumLength;
    ULONG           DmaPort;
} DEVICE_DESCRIPTION;
typedef DEVICE_DESCRIPTION  *PDEVICE_DESCRIPTION;

/* Scatter gather element */
typedef struct _SCATTER_GATHER_ELEMENT {
    PHYSICAL_ADDRESS    Address;
    ULONG               Length;
    ULONG_PTR           Reserved;
} SCATTER_GATHER_ELEMENT;
typedef SCATTER_GATHER_ELEMENT  *PSCATTER_GATHER_ELEMENT;

/* Scatter gather list */
typedef struct _SCATTER_GATHER_LIST {
    ULONG                   NumberOfElements;
    ULONG_PTR               Reserved;
    SCATTER_GATHER_ELEMENT  Elements[];
} SCATTER_GATHER_LIST;
typedef SCATTER_GATHER_LIST *PSCATTER_GATHER_LIST;

/* DMA adapter */
typedef struct _DMA_ADAPTER {
    USHORT                  Version;
    USHORT                  Size;
    struct _DMA_OPERATIONS  *DmaOperations;
} DMA_ADAPTER;
typedef DMA_ADAPTER *PDMA_ADAPTER;

/* Driver list control callback */
typedef VOID        (NTAPI DRIVER_LIST_CONTROL)( struct _DEVICE_OBJECT *, struct _IRP *, PSCATTER_GATHER_LIST, PVOID );
typedef DRIVER_LIST_CONTROL *PDRIVER_LIST_CONTROL;

/* DMA callbacks */
typedef VOID        (NTAPI *PPUT_DMA_ADAPTER)( PDMA_ADAPTER );
typedef PVOID       (NTAPI *PALLOCATE_COMMON_BUFFER)( PDMA_ADAPTER, ULONG, PPHYSICAL_ADDRESS, BOOLEAN );
typedef VOID        (NTAPI *PFREE_COMMON_BUFFER)( PDMA_ADAPTER, ULONG, PHYSICAL_ADDRESS, PVOID, BOOLEAN );
typedef NTSTATUS    (NTAPI *PALLOCATE_ADAPTER_CHANNEL)( PDMA_ADAPTER, PDEVICE_OBJECT, ULONG, PDRIVER_CONTROL, PVOID );
typedef BOOLEAN     (NTAPI *PFLUSH_ADAPTER_BUFFERS)( PDMA_ADAPTER, PMDL, PVOID, PVOID, ULONG, BOOLEAN );
typedef VOID        (NTAPI *PFREE_ADAPTER_CHANNEL)( PDMA_ADAPTER );
typedef VOID        (NTAPI *PFREE_MAP_REGISTERS)( PDMA_ADAPTER, PVOID, ULONG );
typedef PHYSICAL_ADDRESS (NTAPI *PMAP_TRANSFER)( PDMA_ADAPTER, PMDL, PVOID, PVOID, PULONG, BOOLEAN );
typedef ULONG       (NTAPI *PGET_DMA_ALIGNMENT)( PDMA_ADAPTER );
typedef ULONG       (NTAPI *PREAD_DMA_COUNTER)( PDMA_ADAPTER );
typedef NTSTATUS    (NTAPI *PGET_SCATTER_GATHER_LIST)( PDMA_ADAPTER, PDEVICE_OBJECT, PMDL, PVOID, ULONG, PDRIVER_LIST_CONTROL, PVOID, BOOLEAN );
typedef VOID        (NTAPI *PPUT_SCATTER_GATHER_LIST)( PDMA_ADAPTER, PSCATTER_GATHER_LIST, BOOLEAN );
typedef NTSTATUS    (NTAPI *PCALCULATE_SCATTER_GATHER_LIST_SIZE)( PDMA_ADAPTER, PMDL, PVOID, ULONG, PULONG, PULONG );
typedef NTSTATUS    (NTAPI *PBUILD_SCATTER_GATHER_LIST)( PDMA_ADAPTER, PDEVICE_OBJECT, PMDL, PVOID, ULONG, PDRIVER_LIST_CONTROL, PVOID, BOOLEAN, PVOID, ULONG );
typedef NTSTATUS    (NTAPI *PBUILD_MDL_FROM_SCATTER_GATHER_LIST)( PDMA_ADAPTER, PSCATTER_GATHER_LIST, PMDL, PMDL * );

/* DMA operations */
typedef struct _DMA_OPERATIONS {
    ULONG                               Size;
    PPUT_DMA_ADAPTER                    PutDmaAdapter;
    PALLOCATE_COMMON_BUFFER             AllocateCommonBuffer;
    PFREE_COMMON_BUFFER                 FreeCommonBuffer;
    PALLOCATE_ADAPTER_CHANNEL           AllocateAdapterChannel;
    PFLUSH_ADAPTER_BUFFERS              FlushAdapterBuffers;
    PFREE_ADAPTER_CHANNEL               FreeAdapterChannel;
    PFREE_MAP_REGISTERS                 FreeMapRegisters;
    PMAP_TRANSFER                       MapTransfer;
    PGET_DMA_ALIGNMENT                  GetDmaAlignment;
    PREAD_DMA_COUNTER                   ReadDmaCounter;
    PGET_SCATTER_GATHER_LIST            GetScatterGatherList;
    PPUT_SCATTER_GATHER_LIST            PutScatterGatherList;
    PCALCULATE_SCATTER_GATHER_LIST_SIZE CalculateScatterGatherListSize;
    PBUILD_SCATTER_GATHER_LIST          BuildScatterGatherList;
    PBUILD_MDL_FROM_SCATTER_GATHER_LIST BuildMdlFromScatterGatherList;
} DMA_OPERATIONS;
typedef DMA_OPERATIONS  *PDMA_OPERATIONS;

/* Power callbacks */
typedef VOID        (NTAPI REQUEST_POWER_COMPLETE)( PDEVICE_OBJECT, UCHAR, POWER_STATE, PVOID, PIO_STATUS_BLOCK );
typedef NTSTATUS    (NTAPI POWER_SETTING_CALLBACK)( LPCGUID, PVOID, ULONG, PVOID );
typedef REQUEST_POWER_COMPLETE  *PREQUEST_POWER_COMPLETE;
typedef POWER_SETTING_CALLBACK  *PPOWER_SETTING_CALLBACK;

/* Object handle information */
typedef struct _OBJECT_HANDLE_INFORMATION {
    ULONG       HandleAttributes;
    ACCESS_MASK GrantedAccess;
} OBJECT_HANDLE_INFORMATION;
typedef OBJECT_HANDLE_INFORMATION   *POBJECT_HANDLE_INFORMATION;

/* Object pre-create handle information */
typedef struct _OB_PRE_CREATE_HANDLE_INFORMATION {
    ACCESS_MASK DesiredAccess;
    ACCESS_MASK OriginalDesiredAccess;
} OB_PRE_CREATE_HANDLE_INFORMATION;
typedef OB_PRE_CREATE_HANDLE_INFORMATION    *POB_PRE_CREATE_HANDLE_INFORMATION;

/* Object pre-duplicate handle information */
typedef struct _OB_PRE_DUPLICATE_HANDLE_INFORMATION {
    ACCESS_MASK DesiredAccess;
    ACCESS_MASK OriginalDesiredAccess;
    PVOID       SourceProcess;
    PVOID       TargetProcess;
} OB_PRE_DUPLICATE_HANDLE_INFORMATION;
typedef OB_PRE_DUPLICATE_HANDLE_INFORMATION *POB_PRE_DUPLICATE_HANDLE_INFORMATION;

/* Object pre-operation parameters */
typedef union _OB_PRE_OPERATION_PARAMETERS {
    OB_PRE_CREATE_HANDLE_INFORMATION    CreateHandleInformation;
    OB_PRE_DUPLICATE_HANDLE_INFORMATION DuplicateHandleInformation;
} OB_PRE_OPERATION_PARAMETERS;
typedef OB_PRE_OPERATION_PARAMETERS *POB_PRE_OPERATION_PARAMETERS;

/* Object pre-operation information */
typedef struct _OB_PRE_OPERATION_INFORMATION {
    OB_OPERATION                    Operation;
    union {
        ULONG   Flags;
        struct {
            ULONG   KernelHandle    : 1;
            ULONG   Reserved        : 31;
        };
    };
    PVOID                           Object;
    POBJECT_TYPE                    ObjectType;
    PVOID                           CallContext;
    POB_PRE_OPERATION_PARAMETERS    Parameters;
} OB_PRE_OPERATION_INFORMATION;
typedef OB_PRE_OPERATION_INFORMATION    *POB_PRE_OPERATION_INFORMATION;

/* Object post-create handle information */
typedef struct _OB_POST_CREATE_HANDLE_INFORMATION {
    ACCESS_MASK GrantedAccess;
} OB_POST_CREATE_HANDLE_INFORMATION;
typedef OB_POST_CREATE_HANDLE_INFORMATION   *POB_POST_CREATE_HANDLE_INFORMATION;

/* Object post-duplicate handle information */
typedef struct _OB_POST_DUPLICATE_HANDLE_INFORMATION {
    ACCESS_MASK GrantedAccess;
} OB_POST_DUPLICATE_HANDLE_INFORMATION;
typedef OB_POST_DUPLICATE_HANDLE_INFORMATION    *POB_POST_DUPLICATE_HANDLE_INFORMATION;

/* Object post-operation parameters */
typedef union _OB_POST_OPERATION_PARAMETERS {
    OB_POST_CREATE_HANDLE_INFORMATION       CreateHandleInformation;
    OB_POST_DUPLICATE_HANDLE_INFORMATION    DuplicateHandleInformation;
} OB_POST_OPERATION_PARAMETERS;
typedef OB_POST_OPERATION_PARAMETERS    *POB_POST_OPERATION_PARAMETERS;

/* Object post-operation information */
typedef struct _OB_POST_OPERATION_INFORMATION {
    OB_OPERATION                    Operation;
    union {
        ULONG   Flags;
        struct {
            ULONG   KernelHandle    : 1;
            ULONG   Reserved        : 31;
        };
    };
    PVOID                           Object;
    POBJECT_TYPE                    ObjectType;
    PVOID                           CallContext;
    NTSTATUS                        ReturnStatus;
    POB_POST_OPERATION_PARAMETERS   Parameters;
} OB_POST_OPERATION_INFORMATION;
typedef OB_POST_OPERATION_INFORMATION   *POB_POST_OPERATION_INFORMATION;

/* Object pre-operation callback status values */
typedef enum _OB_PREOP_CALLBACK_STATUS {
    OB_PREOP_SUCCESS    = 0
} OB_PREOP_CALLBACK_STATUS;
typedef OB_PREOP_CALLBACK_STATUS    *POB_PREOP_CALLBACK_STATUS;

/* Object pre-operation and post-operation callbacks */
typedef OB_PREOP_CALLBACK_STATUS (NTAPI *POB_PRE_OPERATION_CALLBACK)( PVOID, POB_PRE_OPERATION_INFORMATION );
typedef VOID        (NTAPI *POB_POST_OPERATION_CALLBACK)( PVOID, POB_POST_OPERATION_INFORMATION );

/* Object operation registration */
typedef struct _OB_OPERATION_REGISTRATION {
    POBJECT_TYPE                *ObjectType;
    OB_OPERATION                Operations;
    POB_PRE_OPERATION_CALLBACK  PreOperation;
    POB_POST_OPERATION_CALLBACK PostOperation;
} OB_OPERATION_REGISTRATION;
typedef OB_OPERATION_REGISTRATION   *POB_OPERATION_REGISTRATION;

/* Object callback registration */
typedef struct _OB_CALLBACK_REGISTRATION {
    USHORT                      Version;
    USHORT                      OperationRegistrationCount;
    UNICODE_STRING              Altitude;
    PVOID                       RegistrationContext;
    OB_OPERATION_REGISTRATION   *OperationRegistration;
} OB_CALLBACK_REGISTRATION;
typedef OB_CALLBACK_REGISTRATION    *POB_CALLBACK_REGISTRATION;

/* PCI slot number */
typedef struct _PCI_SLOT_NUMBER {
    union {
        struct {
            ULONG   DeviceNumber    : 5;
            ULONG   FunctionNumber  : 3;
            ULONG   Reserved        : 24;
        } bits;
        ULONG   AsULONG;
    } u;
} PCI_SLOT_NUMBER;
typedef PCI_SLOT_NUMBER *PPCI_SLOT_NUMBER;

/* PCI common header */
typedef struct _PCI_COMMON_HEADER {
    USHORT  VendorID;
    USHORT  DeviceID;
    USHORT  Command;
    USHORT  Status;
    UCHAR   RevisionID;
    UCHAR   ProgIf;
    UCHAR   SubClass;
    UCHAR   BaseClass;
    UCHAR   CacheLineSize;
    UCHAR   LatencyTimer;
    UCHAR   HeaderType;
    UCHAR   BIST;
    union {
        struct _PCI_HEADER_TYPE_0 {
            ULONG   BaseAddresses[PCI_TYPE0_ADDRESSES];
            ULONG   CIS;
            USHORT  SubVendorID;
            USHORT  SubSystemID;
            ULONG   ROMBaseAddress;
            UCHAR   CapabilitiesPtr;
            UCHAR   Reserved1[3];
            ULONG   Reserved2;
            UCHAR   InterruptLine;
            UCHAR   InterruptPin;
            UCHAR   MinimumGrant;
            UCHAR   MaximumLatency;
        } type0;
        struct _PCI_HEADER_TYPE_1 {
            ULONG   BaseAddresses[PCI_TYPE1_ADDRESSES];
            UCHAR   PrimaryBus;
            UCHAR   SecondaryBus;
            UCHAR   SubordinateBus;
            UCHAR   SecondaryLatency;
            UCHAR   IOBase;
            UCHAR   IOLimit;
            USHORT  SecondaryStatus;
            USHORT  MemoryBase;
            USHORT  MemoryLimit;
            USHORT  PrefetchBase;
            USHORT  PrefetchLimit;
            ULONG   PrefetchBaseUpper32;
            ULONG   PrefetchLimitUpper32;
            USHORT  IOBaseUpper16;
            USHORT  IOLimitUpper16;
            UCHAR   CapabilitiesPtr;
            UCHAR   Reserved1[3];
            ULONG   ROMBaseAddress;
            UCHAR   InterruptLine;
            UCHAR   InterruptPin;
            USHORT  BridgeControl;
        } type1;
        struct _PCI_HEADER_TYPE_2 {
            ULONG   SocketRegistersBaseAddress;
            UCHAR   CapabilitiesPtr;
            UCHAR   Reserved;
            USHORT  SecondaryStatus;
            UCHAR   PrimaryBus;
            UCHAR   SecondaryBus;
            UCHAR   SubordinateBus;
            UCHAR   SecondaryLatency;
            struct {
                ULONG   Base;
                ULONG   Limit;
            } Range[PCI_TYPE2_ADDRESSES - 1];
            UCHAR   InterruptLine;
            UCHAR   InterruptPin;
            USHORT  BridgeControl;
        } type2;
    } u;
} PCI_COMMON_HEADER;
typedef PCI_COMMON_HEADER   *PPCI_COMMON_HEADER;

/* PCI common configuration */
#ifdef __cplusplus
typedef struct _PCI_COMMON_CONFIG : PCI_COMMON_HEADER {
#else
typedef struct _PCI_COMMON_CONFIG {
    PCI_COMMON_HEADER;
#endif
    UCHAR   DeviceSpecific[192];
} PCI_COMMON_CONFIG;
typedef PCI_COMMON_CONFIG   *PPCI_COMMON_CONFIG;

/* PCI configuration structure lengths */
#define PCI_COMMON_HDR_LENGTH       FIELD_OFFSET( PCI_COMMON_CONFIG, DeviceSpecific )
#define PCI_EXTENDED_CONFIG_LENGTH  0x00001000

/* Macros to test for PCI common configuration types */
#define PCI_CONFIGURATION_TYPE( x ) \
    (((PPCI_COMMON_CONFIG)(x))->HeaderType & ~PCI_MULTIFUNCTION)
#define PCI_MULTIFUNCTION_DEVICE( x ) \
    ((((PPCI_COMMON_CONFIG)(x))->HeaderType & PCI_MULTIFUNCTION) != 0)

/* PCI capabilities header */
typedef struct _PCI_CAPABILITIES_HEADER {
    UCHAR   CapabilityID;
    UCHAR   Next;
} PCI_CAPABILITIES_HEADER;
typedef PCI_CAPABILITIES_HEADER *PPCI_CAPABILITIES_HEADER;

/* PCI power management capability */
typedef struct _PCI_PMC {
    UCHAR   Version                         : 3;
    UCHAR   PMEClock                        : 1;
    UCHAR   Rsvd1                           : 1;
    UCHAR   DeviceSpecificInitialization    : 1;
    UCHAR   Rsvd2                           : 2;
    struct _PM_SUPPORT {
        UCHAR   Rsvd2       : 1;
        UCHAR   D1          : 1;
        UCHAR   D2          : 1;
        UCHAR   PMED0       : 1;
        UCHAR   PMED1       : 1;
        UCHAR   PMED2       : 1;
        UCHAR   PMED3Hot    : 1;
        UCHAR   PMED3Cold   : 1;
    } Support;
} PCI_PMC;
typedef PCI_PMC *PPCI_PMC;

/* PCI power management capability status register */
typedef struct _PCI_PMCSR {
    USHORT  PowerState  : 2;
    USHORT  Rsvd1       : 6;
    USHORT  PMEEnable   : 1;
    USHORT  DataSelect  : 4;
    USHORT  DataScale   : 2;
    USHORT  PMEStatus   : 1;
} PCI_PMCSR;
typedef PCI_PMCSR   *PPCI_PMCSR;

/* PCI power management capability status register for bridge support extensions */
typedef struct _PCI_PMCSR_BSE {
    UCHAR   Rsvd1                       : 6;
    UCHAR   D3HotSupportsStopClock      : 1;
    UCHAR   BusPowerClockControlEnabled : 1;
} PCI_PMCSR_BSE;
typedef PCI_PMCSR_BSE   *PPCI_PMCSR_BSE;

/* PCI power management capability */
typedef struct _PCI_PM_CAPABILITY {
    PCI_CAPABILITIES_HEADER Header;
    union {
        PCI_PMC Capabilities;
        USHORT  AsUSHORT;
    } PMC;
    union {
        PCI_PMCSR   ControlStatus;
        USHORT      AsUSHORT;
    } PMCSR;
    union {
        PCI_PMCSR_BSE   BridgeSupport;
        UCHAR           AsUCHAR;
    } PMCSR_BSE;
    UCHAR                   Data;
} PCI_PM_CAPABILITY;
typedef PCI_PM_CAPABILITY   *PPCI_PM_CAPABILITY;

/* PCI-X capability */
typedef struct {
    PCI_CAPABILITIES_HEADER Header;
    union {
        struct {
            USHORT  DataParityErrorRecoveryEnable   : 1;
            USHORT  EnableRelaxedOrdering           : 1;
            USHORT  MaxMemoryReadByteCount          : 2;
            USHORT  MaxOutstandingSplitTransactions : 3;
            USHORT  Reserved                        : 9;
        } bits;
        USHORT  AsUSHORT;
    } Command;
    union {
        struct {
            ULONG   FunctionNumber                          : 3;
            ULONG   DeviceNumber                            : 5;
            ULONG   BusNumber                               : 8;
            ULONG   Device64Bit                             : 1;
            ULONG   Capable133MHz                           : 1;
            ULONG   SplitCompletionDiscarded                : 1;
            ULONG   UnexpectedSplitCompletion               : 1;
            ULONG   DeviceComplexity                        : 1;
            ULONG   DesignedMaxMemoryReadByteCount          : 2;
            ULONG   DesignedMaxOutstandingSplitTransactions : 3;
            ULONG   DesignedMaxCumulativeReadSize           : 3;
            ULONG   ReceivedSplitCompletionErrorMessage     : 1;
            ULONG   CapablePCIX266                          : 1;
            ULONG   CapablePCIX533                          : 1;
        } bits;
        ULONG   AsULONG;
    } Status;
} PCI_X_CAPABILITY;
typedef PCI_X_CAPABILITY    *PPCI_X_CAPABILITY;

/* PCI express enhanced capability header */
typedef struct _PCI_EXPRESS_ENHANCED_CAPABILITY_HEADER {
    USHORT  CapabilityID;
    USHORT  Version : 4;
    USHORT  Next    : 12;
} PCI_EXPRESS_ENHANCED_CAPABILITY_HEADER;
typedef PCI_EXPRESS_ENHANCED_CAPABILITY_HEADER  *PPCI_EXPRESS_ENHANCED_CAPABILITY_HEADER;

/* PCI express serial number capability */
typedef struct _PCI_EXPRESS_SERIAL_NUMBER_CAPABILITY {
    PCI_EXPRESS_ENHANCED_CAPABILITY_HEADER  Header;
    ULONG                                   LowSerialNumber;
    ULONG                                   HighSerialNumber;
} PCI_EXPRESS_SERIAL_NUMBER_CAPABILITY;
typedef PCI_EXPRESS_SERIAL_NUMBER_CAPABILITY    *PPCI_EXPRESS_SERIAL_NUMBER_CAPABILITY;

/* PCI express uncorrectable error status */
typedef union _PCI_EXPRESS_UNCORRECTABLE_ERROR_STATUS {
    struct {
        ULONG   Undefined                   : 1;
        ULONG   Reserved1                   : 3;
        ULONG   DataLinkProtocolError       : 1;
        ULONG   SurpriseErrorDown           : 1;
        ULONG   Reserved2                   : 6;
        ULONG   PoisonedTLP                 : 1;
        ULONG   FlowControlProtocolError    : 1;
        ULONG   CompletionTimeout           : 1;
        ULONG   CompleterAbort              : 1;
        ULONG   UnexpectedCompletion        : 1;
        ULONG   ReceiverOverflow            : 1;
        ULONG   MalformedTLP                : 1;
        ULONG   ECRCError                   : 1;
        ULONG   UnsupportedRequestError     : 1;
        ULONG   Reserved3                   : 11;
    };
    ULONG   AsULONG;
} PCI_EXPRESS_UNCORRECTABLE_ERROR_STATUS;
typedef PCI_EXPRESS_UNCORRECTABLE_ERROR_STATUS  *PPCI_ERROR_UNCORRECTABLE_ERROR_STATUS;

/* PCI express uncorrectable error mask */
typedef union _PCI_EXPRESS_UNCORRECTABLE_ERROR_MASK {
    struct {
        ULONG   Undefined                   : 1;
        ULONG   Reserved1                   : 3;
        ULONG   DataLinkProtocolError       : 1;
        ULONG   SurpriseDownError           : 1;
        ULONG   Reserved2                   : 6;
        ULONG   PoisonedTLP                 : 1;
        ULONG   FlowControlProtocolError    : 1;
        ULONG   CompletionTimeout           : 1;
        ULONG   CompleterAbort              : 1;
        ULONG   UnexpectedCompletion        : 1;
        ULONG   ReceiverOverflow            : 1;
        ULONG   MalformedTLP                : 1;
        ULONG   ECRCError                   : 1;
        ULONG   UnsupportedRequestError     : 1;
        ULONG   Reserved3                   : 11;
    };
    ULONG   AsULONG;
} PCI_EXPRESS_UNCORRECTABLE_ERROR_MASK;
typedef PCI_EXPRESS_UNCORRECTABLE_ERROR_MASK    *PPCI_EXPRESS_UNCORRECTABLE_ERROR_MASK;

/* PCI express uncorrectable error severity */
typedef union _PCI_EXPRESS_UNCORRECTABLE_ERROR_SEVERITY {
    struct {
        ULONG   Undefined                   : 1;
        ULONG   Reserved1                   : 3;
        ULONG   DataLinkProtocolError       : 1;
        ULONG   SurpriseDownError           : 1;
        ULONG   Reserved2                   : 6;
        ULONG   PoisonedTLP                 : 1;
        ULONG   FlowControlProtocolError    : 1;
        ULONG   CompletionTimeout           : 1;
        ULONG   CompleterAbort              : 1;
        ULONG   UnexpectedCompletion        : 1;
        ULONG   ReceiverOverflow            : 1;
        ULONG   MalformedTLP                : 1;
        ULONG   ECRCError                   : 1;
        ULONG   UnsupportedRequestError     : 1;
        ULONG   Reserved3                   : 11;
    };
    ULONG   AsULONG;
} PCI_EXPRESS_UNCORRECTABLE_ERROR_SEVERITY;
typedef PCI_EXPRESS_UNCORRECTABLE_ERROR_SEVERITY    *PPCI_EXPRESS_UNCORRECTABLE_ERROR_SEVERITY;

/* PCI express correctable error status */
typedef union _PCI_EXPRESS_CORRECTABLE_ERROR_STATUS {
    struct {
        ULONG   ReceiverError           : 1;
        ULONG   Reserved1               : 5;
        ULONG   BadTLP                  : 1;
        ULONG   BadDLLP                 : 1;
        ULONG   ReplayNumRollover       : 1;
        ULONG   Reserved2               : 3;
        ULONG   ReplayTimerTimeout      : 1;
        ULONG   AdvisoryNonFatalError   : 1;
        ULONG   Reserved3               : 18;
    };
    ULONG   AsULONG;
} PCI_EXPRESS_CORRECTABLE_ERROR_STATUS;
typedef PCI_EXPRESS_CORRECTABLE_ERROR_STATUS    *PPCI_EXPRESS_CORRECTABLE_ERROR_STATUS;

/* PCI express correctable error mask */
typedef union _PCI_EXPRESS_CORRECTABLE_ERROR_MASK {
    struct {
        ULONG   ReceiverError           : 1;
        ULONG   Reserved1               : 5;
        ULONG   BadTLP                  : 1;
        ULONG   BadDLLP                 : 1;
        ULONG   ReplayNumRollover       : 1;
        ULONG   Reserved2               : 3;
        ULONG   ReplayTimerTimeout      : 1;
        ULONG   AdvisoryNonFatalError   : 1;
        ULONG   Reserved3               : 18;
    };
    ULONG   AsULONG;
} PCI_EXPRESS_CORRECTABLE_ERROR_MASK;
typedef PCI_EXPRESS_CORRECTABLE_ERROR_MASK  *PPCI_EXPRESS_CORRECTABLE_ERROR_MASK;

/* PCI express advanced error reporting capabilities */
typedef union _PCI_EXPRESS_AER_CAPABILITIES {
    struct {
        ULONG   FirstErrorPointer       : 5;
        ULONG   ECRCGenerationCapable   : 1;
        ULONG   ECRCGenerationEnable    : 1;
        ULONG   ECRCCheckCapable        : 1;
        ULONG   ECRCCheckEnable         : 1;
        ULONG   Reserved                : 23;
    };
    ULONG   AsULONG;
} PCI_EXPRESS_AER_CAPABILITIES;
typedef PCI_EXPRESS_AER_CAPABILITIES    *PPCI_EXPRESS_AER_CAPABILITIES;

/* PCI express root error command */
typedef union _PCI_EXPRESS_ROOT_ERROR_COMMAND {
    struct {
        ULONG   CorrectableErrorReportingEnable : 1;
        ULONG   NonFatalErrorReportingEnable    : 1;
        ULONG   FatalErrorReportingEnable       : 1;
        ULONG   Reserved                        : 29;
    };
    ULONG   AsULONG;
} PCI_EXPRESS_ROOT_ERROR_COMMAND;
typedef PCI_EXPRESS_ROOT_ERROR_COMMAND  *PPCI_EXPRESS_ROOT_ERROR_COMMAND;

/* PCI express root error status */
typedef union _PCI_EXPRESS_ROOT_ERROR_STATUS {
    struct {
        ULONG   CorrectableErrorReceived            : 1;
        ULONG   MultipleCorrectableErrorsReceived   : 1;
        ULONG   UncorrectableErrorReceived          : 1;
        ULONG   MultipleUncorrectableErrorsReceived : 1;
        ULONG   FirstUncorrectableFatal             : 1;
        ULONG   NonFatalErrorMessagesReceived       : 1;
        ULONG   FatalErrorMessagesReceived          : 1;
        ULONG   Reserved                            : 20;
        ULONG   AdvancedErrorInterruptMessageNumber : 5;
    };
    ULONG   AsULONG;
} PCI_EXPRESS_ROOT_ERROR_STATUS;
typedef PCI_EXPRESS_ROOT_ERROR_STATUS   *PPCI_EXPRESS_ROOT_ERROR_STATUS;

/* PCI express error source identifier */
typedef union _PCI_EXPRESS_ERROR_SOURCE_ID {
    struct {
        USHORT  CorrectableSourceIdFun      : 3;
        USHORT  CorrectableSourceIdDev      : 5;
        USHORT  CorrectableSourceIdBus      : 8;
        USHORT  UncorrectableSourceIdFun    : 3;
        USHORT  UncorrectableSourceIdDev    : 5;
        USHORT  UncorrectableSourceIdBus    : 8;
    };
    ULONG   AsULONG;
} PCI_EXPRESS_ERROR_SOURCE_ID;
typedef PCI_EXPRESS_ERROR_SOURCE_ID *PPCI_EXPRESS_ERROR_SOURCE_ID;

/* PCI express secondary uncorrectable error status */
typedef union _PCI_EXPRESS_SEC_UNCORRECTABLE_ERROR_STATUS {
    struct {
        ULONG   TargetAbortOnSplitCompletion            : 1;
        ULONG   MasterAbortOnSplitCompletion            : 1;
        ULONG   ReceivedTargetAbort                     : 1;
        ULONG   ReceivedMasterAbort                     : 1;
        ULONG   RsvdZ                                   : 1;
        ULONG   UnexpectedSplitCompletionError          : 1;
        ULONG   UncorrectableSplitCompletion            : 1;
        ULONG   UncorrectableDataError                  : 1;
        ULONG   UncorrectableAttributeError             : 1;
        ULONG   UncorrectableAddressError               : 1;
        ULONG   DelayedTransactionDiscardTimerExpired   : 1;
        ULONG   PERRAsserted                            : 1;
        ULONG   SERRAsserted                            : 1;
        ULONG   InternalBridgeError                     : 1;
        ULONG   Reserved                                : 18;
    };
    ULONG   AsULONG;
} PCI_EXPRESS_SEC_UNCORRECTABLE_ERROR_STATUS;
typedef PCI_EXPRESS_SEC_UNCORRECTABLE_ERROR_STATUS  *PPCI_EXPRESS_SEC_UNCORRECTABLE_ERROR_STATUS;

/* PCI express secondary uncorrectable error mask */
typedef union _PCI_EXPRESS_SEC_UNCORRECTABLE_ERROR_MASK {
    struct {
        ULONG   TargetAbortOnSplitCompletion            : 1;
        ULONG   MasterAbortOnSplitCompletion            : 1;
        ULONG   ReceivedTargetAbort                     : 1;
        ULONG   ReceivedMasterAbort                     : 1;
        ULONG   RsvdZ                                   : 1;
        ULONG   UnexpectedSplitCompletionError          : 1;
        ULONG   UncorrectableSplitCompletion            : 1;
        ULONG   UncorrectableDataError                  : 1;
        ULONG   UncorrectableAttributeError             : 1;
        ULONG   UncorrectableAddressError               : 1;
        ULONG   DelayedTransactionDiscardTimerExpired   : 1;
        ULONG   PERRAsserted                            : 1;
        ULONG   SERRAsserted                            : 1;
        ULONG   InternalBridgeError                     : 1;
        ULONG   Reserved                                : 18;
    };
    ULONG   AsULONG;
} PCI_EXPRESS_SEC_UNCORRECTABLE_ERROR_MASK;
typedef PCI_EXPRESS_SEC_UNCORRECTABLE_ERROR_MASK    *PPCI_EXPRESS_SEC_UNCORRECTABLE_ERROR_MASK;

/* PCI express secondary uncorrectable error severity */
typedef union _PCI_EXPRESS_SEC_UNCORRECTABLE_ERROR_SEVERITY {
    struct {
        ULONG   TargetAbortOnSplitCompletion            : 1;
        ULONG   MasterAbortOnSplitCompletion            : 1;
        ULONG   ReceivedTargetAbort                     : 1;
        ULONG   ReceivedMasterAbort                     : 1;
        ULONG   RsvdZ                                   : 1;
        ULONG   UnexpectedSplitCompletionError          : 1;
        ULONG   UncorrectableSplitCompletion            : 1;
        ULONG   UncorrectableDataError                  : 1;
        ULONG   UncorrectableAttributeError             : 1;
        ULONG   UncorrectableAddressError               : 1;
        ULONG   DelayedTransactionDiscardTimerExpired   : 1;
        ULONG   PERRAsserted                            : 1;
        ULONG   SERRAsserted                            : 1;
        ULONG   InternalBridgeError                     : 1;
        ULONG   Reserved                                : 18;
    };
    ULONG   AsULONG;
} PCI_EXPRESS_SEC_UNCORRECTABLE_ERROR_SEVERITY;
typedef PCI_EXPRESS_SEC_UNCORRECTABLE_ERROR_SEVERITY    *PPCI_EXPRESS_SEC_UNCORRECTABLE_ERROR_SEVERITY;

/* PCI express secondary advanced error reporting capabilities */
typedef union _PCI_EXPRESS_SEC_AER_CAPABILITIES {
    struct {
        ULONG   SecondaryUncorrectableFirstErrorPtr : 5;
        ULONG   Reserved                            : 27;
    };
    ULONG   AsULONG;
} PCI_EXPRESS_SEC_AER_CAPABILITIES;
typedef PCI_EXPRESS_SEC_AER_CAPABILITIES    *PPCI_EXPRESS_SEC_AER_CAPABILITIES;

/* PCI express advanced error reporting capability */
typedef struct _PCI_EXPRESS_AER_CAPABILITY {
    PCI_EXPRESS_ENHANCED_CAPABILITY_HEADER          Header;
    PCI_EXPRESS_UNCORRECTABLE_ERROR_STATUS          UncorrectableErrorStatus;
    PCI_EXPRESS_UNCORRECTABLE_ERROR_MASK            UncorrectableErrorMask;
    PCI_EXPRESS_UNCORRECTABLE_ERROR_SEVERITY        UncorrectableErrorSeverity;
    PCI_EXPRESS_CORRECTABLE_ERROR_STATUS            CorrectableErrorStatus;
    PCI_EXPRESS_CORRECTABLE_ERROR_MASK              CorrectableErrorMask;
    PCI_EXPRESS_AER_CAPABILITIES                    CapabilitiesAndControl;
    ULONG                                           HeaderLog[4];
    PCI_EXPRESS_SEC_UNCORRECTABLE_ERROR_STATUS      SecUncorrectableErrorStatus;
    PCI_EXPRESS_SEC_UNCORRECTABLE_ERROR_MASK        SecUncorrectableErrorMask;
    PCI_EXPRESS_SEC_UNCORRECTABLE_ERROR_SEVERITY    SecUncorrectableErrorSeverity;
    PCI_EXPRESS_SEC_AER_CAPABILITIES                SecCapabilitiesAndControl;
    ULONG                                           SecHeaderLog[4];
} PCI_EXPRESS_AER_CAPABILITY;
typedef PCI_EXPRESS_AER_CAPABILITY  *PPCI_EXPRESS_AER_CAPABILITY;

/* PCI express root part advanced error reporting capability */
typedef struct _PCI_EXPRESS_ROOTPART_AER_CAPABILITY {
    PCI_EXPRESS_ENHANCED_CAPABILITY_HEADER      Header;
    PCI_EXPRESS_UNCORRECTABLE_ERROR_STATUS      UncorrectableErrorStatus;
    PCI_EXPRESS_UNCORRECTABLE_ERROR_MASK        UncorrectableErrorMask;
    PCI_EXPRESS_UNCORRECTABLE_ERROR_SEVERITY    UncorrectableErrorSeverity;
    PCI_EXPRESS_CORRECTABLE_ERROR_STATUS        CorrectableErrorStatus;
    PCI_EXPRESS_CORRECTABLE_ERROR_MASK          CorrectableErrorMask;
    PCI_EXPRESS_AER_CAPABILITIES                CapabilitiesAndControl;
    ULONG                                       HeaderLog[4];
    PCI_EXPRESS_ROOT_ERROR_COMMAND              RootErrorCommand;
    PCI_EXPRESS_ROOT_ERROR_STATUS               RootErrorStatus;
    PCI_EXPRESS_ERROR_SOURCE_ID                 ErrorSourceId;
} PCI_EXPRESS_ROOTPART_AER_CAPABILITY;
typedef PCI_EXPRESS_ROOTPART_AER_CAPABILITY *PPCI_EXPRESS_ROOTPART_AER_CAPABILITY;

/* PCI express bridge advanced error reporting capability */
typedef struct _PCI_EXPRESS_BRIDGE_AER_CAPABILITY {
    PCI_EXPRESS_ENHANCED_CAPABILITY_HEADER          Header;
    PCI_EXPRESS_UNCORRECTABLE_ERROR_STATUS          UncorrectableErrorStatus;
    PCI_EXPRESS_UNCORRECTABLE_ERROR_MASK            UncorrectableErrorMask;
    PCI_EXPRESS_UNCORRECTABLE_ERROR_SEVERITY        UncorrectableErrorSeverity;
    PCI_EXPRESS_CORRECTABLE_ERROR_STATUS            CorrectableErrorStatus;
    PCI_EXPRESS_CORRECTABLE_ERROR_MASK              CorrectableErrorMask;
    PCI_EXPRESS_AER_CAPABILITIES                    CapabilitiesAndControl;
    ULONG                                           HeaderLog[4];
    PCI_EXPRESS_SEC_UNCORRECTABLE_ERROR_STATUS      SecUncorrectableErrorStatus;
    PCI_EXPRESS_SEC_UNCORRECTABLE_ERROR_MASK        SecUncorrectableErrorMask;
    PCI_EXPRESS_SEC_UNCORRECTABLE_ERROR_SEVERITY    SecUncorrectableErrorSeverity;
    PCI_EXPRESS_SEC_AER_CAPABILITIES                SecCapabilitiesAndControl;
    ULONG                                           SecHeaderLog[4];
} PCI_EXPRESS_BRIDGE_AER_CAPABILITY;
typedef PCI_EXPRESS_BRIDGE_AER_CAPABILITY   *PPCI_EXPRESS_BRIDGE_AER_CAPABILITY;

/* PCI express single root I/O virtualization capabilities */
typedef union _PCI_EXPRESS_SRIOV_CAPS {
    struct {
        ULONG   VFMigrationCapable          : 1;
        ULONG   Reserved1                   : 20;
        ULONG   VFMigrationInterruptNumber  : 11;
    };
    ULONG   AsULONG;
} PCI_EXPRESS_SRIOV_CAPS;
typedef PCI_EXPRESS_SRIOV_CAPS  *PPCI_EXPRESS_SRIOV_CAPS;

/* PCI express single root I/O virtualization control */
typedef union _PCI_EXPRESS_SRIOV_CONTROL {
    struct {
        USHORT  VFEnable                    : 1;
        USHORT  VFMigrationEnable           : 1;
        USHORT  VFMigrationInterruptEnable  : 1;
        USHORT  VFMemorySpaceEnable         : 1;
        USHORT  ARICapableHierarchy         : 1;
        USHORT  Reserved1                   : 11;
    };
    USHORT  AsUSHORT;
} PCI_EXPRESS_SRIOV_CONTROL;
typedef PCI_EXPRESS_SRIOV_CONTROL   *PPCI_EXPRESS_SRIOV_CONTROL;

/* PCI express single root I/O virtualization status */
typedef union _PCI_EXPRESS_SRIOV_STATUS {
    struct {
        USHORT  VFMigrationStatus   : 1;
        USHORT  Reserved1           : 15;
    };
    USHORT  AsUSHORT;
} PCI_EXPRESS_SRIOV_STATUS;
typedef PCI_EXPRESS_SRIOV_STATUS    *PPCI_EXPRESS_SRIOV_STATUS;

/* PCI express single root I/O virtualization migration state array */
typedef union _PCI_EXPRESS_SRIOV_MIGRATION_STATE_ARRAY {
    struct {
        ULONG   VFMigrationStateBIR     : 3;
        ULONG   VFMigrationStateOffset  : 29;
    };
    ULONG   AsULONG;
} PCI_EXPRESS_SRIOV_MIGRATION_STATE_ARRAY;
typedef PCI_EXPRESS_SRIOV_MIGRATION_STATE_ARRAY *PPCI_EXPRESS_SRIOV_MIGRATION_STATE_ARRAY;

/* PCI express single root I/O virtualization capability */
typedef struct _PCI_EXPRESS_SRIOV_CAPABILITY {
    PCI_EXPRESS_ENHANCED_CAPABILITY_HEADER  Header;
    PCI_EXPRESS_SRIOV_CAPS                  SRIOVCapabilities;
    PCI_EXPRESS_SRIOV_CONTROL               SRIOVControl;
    PCI_EXPRESS_SRIOV_STATUS                SRIOVStatus;
    USHORT                                  InitialVFs;
    USHORT                                  TotalVFs;
    USHORT                                  NumVFs;
    UCHAR                                   FunctionDependencyLink;
    UCHAR                                   RsvdP1;
    USHORT                                  FirstVFOffset;
    USHORT                                  VFStride;
    USHORT                                  RsvdP2;
    USHORT                                  VFDeviceId;
    ULONG                                   SupportedPageSizes;
    ULONG                                   SystemPageSize;
    ULONG                                   BaseAddresses[PCI_TYPE0_ADDRESSES];
    PCI_EXPRESS_SRIOV_MIGRATION_STATE_ARRAY VFMigrationStateArrayOffset;
} PCI_EXPRESS_SRIOV_CAPABILITY;
typedef PCI_EXPRESS_SRIOV_CAPABILITY    *PPCI_EXPRESS_SRIOV_CAPABILITY;

/* PCI device presence parameters */
typedef struct _PCI_DEVICE_PRESENCE_PARAMETERS {
    ULONG   Size;
    ULONG   Flags;
    USHORT  VendorID;
    USHORT  DeviceID;
    UCHAR   RevisionID;
    USHORT  SubVendorID;
    USHORT  SubSystemID;
    UCHAR   BaseClass;
    UCHAR   SubClass;
    UCHAR   ProgIf;
} PCI_DEVICE_PRESENCE_PARAMETERS;
typedef PCI_DEVICE_PRESENCE_PARAMETERS  *PPCI_DEVICE_PRESENCE_PARAMETERS;

/* PCI callbacks */
typedef BOOLEAN     (NTAPI PCI_IS_DEVICE_PRESENT)( USHORT, USHORT, UCHAR, USHORT, USHORT, ULONG );
typedef BOOLEAN     (NTAPI PCI_IS_DEVICE_PRESENT_EX)( PVOID, PPCI_DEVICE_PRESENCE_PARAMETERS );
typedef NTSTATUS    (NTAPI PCI_EXPRESS_ENTER_LINK_QUIESCENT_MODE)( PVOID );
typedef NTSTATUS    (NTAPI PCI_EXPRESS_EXIT_LINK_QUIESCENT_MODE)( PVOID );
typedef ULONG       (NTAPI *PPCI_EXPRESS_ROOT_PORT_READ_CONFIG_SPACE)( PVOID, PVOID, ULONG, ULONG );
typedef ULONG       (NTAPI *PPCI_EXPRESS_ROOT_PORT_WRITE_CONFIG_SPACE)( PVOID, PVOID, ULONG, ULONG );
typedef NTSTATUS    (NTAPI PCI_MSIX_SET_ENTRY)( PVOID, ULONG, ULONG );
typedef NTSTATUS    (NTAPI PCI_MSIX_MASKUNMASK_ENTRY)( PVOID, ULONG );
typedef NTSTATUS    (NTAPI PCI_MSIX_GET_ENTRY)( PVOID, ULONG, PULONG, PBOOLEAN );
typedef NTSTATUS    (NTAPI PCI_MSIX_GET_TABLE_SIZE)( PVOID, PULONG );
typedef PCI_IS_DEVICE_PRESENT                   *PPCI_IS_DEVICE_PRESENT;
typedef PCI_IS_DEVICE_PRESENT_EX                *PPCI_IS_DEVICE_PRESENT_EX;
typedef PCI_EXPRESS_ENTER_LINK_QUIESCENT_MODE   *PPCI_EXPRESS_ENTER_LINK_QUIESCENT_MODE;
typedef PCI_EXPRESS_EXIT_LINK_QUIESCENT_MODE    *PPCI_EXPRESS_EXIT_LINK_QUIESCENT_MODE;
typedef PCI_MSIX_SET_ENTRY                      *PPCI_MSIX_SET_ENTRY;
typedef PCI_MSIX_MASKUNMASK_ENTRY               *PPCI_MSIX_MASKUNMASK_ENTRY;
typedef PCI_MSIX_GET_ENTRY                      *PPCI_MSIX_GET_ENTRY;
typedef PCI_MSIX_GET_TABLE_SIZE                 *PPCI_MSIX_GET_TABLE_SIZE;

/* PCI device present interface */
typedef struct _PCI_DEVICE_PRESENT_INTERFACE {
    USHORT                      Size;
    USHORT                      Version;
    PVOID                       Context;
    PINTERFACE_REFERENCE        InterfaceReference;
    PINTERFACE_DEREFERENCE      InterfaceDereference;
    PPCI_IS_DEVICE_PRESENT      IsDevicePresent;
    PPCI_IS_DEVICE_PRESENT_EX   IsDevicePresentEx;
} PCI_DEVICE_PRESENT_INTERFACE;
typedef PCI_DEVICE_PRESENT_INTERFACE    *PPCI_DEVICE_PRESENT_INTERFACE;

/* PCI express link quiescent interface */
typedef struct _PCI_EXPRESS_LINK_QUIESCENT_INTERFACE {
    USHORT                                  Size;
    USHORT                                  Version;
    PVOID                                   Context;
    PINTERFACE_REFERENCE                    InterfaceReference;
    PINTERFACE_DEREFERENCE                  InterfaceDereference;
    PPCI_EXPRESS_ENTER_LINK_QUIESCENT_MODE  PciExpressEnterLinkQuiescentMode;
    PPCI_EXPRESS_EXIT_LINK_QUIESCENT_MODE   PciExpressExitLinkQuiescentMode;
} PCI_EXPRESS_LINK_QUIESCENT_MODE;
typedef PCI_EXPRESS_LINK_QUIESCENT_MODE *PPCI_EXPRESS_LINK_QUIESCENT_MODE;

/* PCI express root port interface */
typedef struct _PCI_EXPRESS_ROOT_PORT_INTERFACE {
    USHORT                                      Size;
    USHORT                                      Version;
    PVOID                                       Context;
    PINTERFACE_REFERENCE                        InterfaceReference;
    PINTERFACE_DEREFERENCE                      InterfaceDereference;
    PPCI_EXPRESS_ROOT_PORT_READ_CONFIG_SPACE    ReadConfigSpace;
    PPCI_EXPRESS_ROOT_PORT_WRITE_CONFIG_SPACE   WriteConfigSpace;
} PCI_EXPRESS_ROOT_PORT_INTERFACE;
typedef PCI_EXPRESS_ROOT_PORT_INTERFACE *PPCI_EXPRESS_ROOT_PORT_INTERFACE;

/* PCI MSI-X table configuration interface */
typedef struct _PCI_MSIX_TABLE_CONFIG_INTERFACE {
    USHORT                      Size;
    USHORT                      Version;
    PVOID                       Context;
    PINTERFACE_REFERENCE        InterfaceReference;
    PINTERFACE_DEREFERENCE      InterfaceDereference;
    PPCI_MSIX_SET_ENTRY         SetTableEntry;
    PPCI_MSIX_MASKUNMASK_ENTRY  MaskTableEntry;
    PPCI_MSIX_MASKUNMASK_ENTRY  UnmaskTableEntry;
    PPCI_MSIX_GET_ENTRY         GetTableEntry;
    PPCI_MSIX_GET_TABLE_SIZE    GetTableSize;
} PCI_MSIX_TABLE_CONFIG_INTERFACE;
typedef PCI_MSIX_TABLE_CONFIG_INTERFACE *PPCI_MSIX_TABLE_CONFIG_INTERFACE;

/* EM rule states */
typedef enum {
    STATE_FALSE     = 0,
    STATE_UNKNOWN   = 1,
    STATE_TRUE      = 2
} EM_RULE_STATE;
typedef EM_RULE_STATE   *PEM_RULE_STATE;

/* EM entry data */
typedef struct _EM_ENTRY_DATA {
    PVOID   Data;
    ULONG   DataLength;
} EM_ENTRY_DATA;
typedef EM_ENTRY_DATA   *PEM_ENTRY_DATA;

/* EM callbacks */
typedef EM_RULE_STATE (NTAPI EM_CALLBACK_ROUTINE)( EM_ENTRY_DATA **, ULONG, LPCSTR *, ULONG, PULONG, ULONG, PVOID );
typedef VOID        (NTAPI EM_LAZYENTRY_CALLBACK_ROUTINE)( LPCGUID, PVOID );
typedef VOID        (NTAPI EM_RULE_STATE_NOTIFY_ROUTINE)( EM_RULE_STATE, LPCGUID, PVOID );
typedef EM_CALLBACK_ROUTINE             *PEM_CALLBACK_ROUTINE;
typedef PEM_CALLBACK_ROUTINE            EM_CALLBACK_FUNC;
typedef EM_LAZYENTRY_CALLBACK_ROUTINE   *PEM_LAZYENTRY_CALLBACK_ROUTINE;
typedef PEM_LAZYENTRY_CALLBACK_ROUTINE  EM_LAZYENTRY_CALLBACK;
typedef EM_RULE_STATE_NOTIFY_ROUTINE    *PEM_RULE_STATE_NOTIFY_ROUTINE;
typedef PEM_RULE_STATE_NOTIFY_ROUTINE   EM_RULE_STATE_NOTIFY;

/* EM entry registration */
typedef struct _EM_ENTRY_REGISTRATION {
    LPCGUID                 EntryGuid;
    EM_LAZYENTRY_CALLBACK   LazyEntryCallback;
    PVOID                   LazyCallbackContext;
} EM_ENTRY_REGISTRATION;
typedef EM_ENTRY_REGISTRATION   *PEM_ENTRY_REGISTRATION;

/* EM callback registration */
typedef struct _EM_CALLBACK_REGISTRATION {
    LPCGUID             CallbackGuid;
    EM_CALLBACK_FUNC    CallbackFunction;
    PVOID               Context;
} EM_CALLBACK_REGISTRATION;
typedef EM_CALLBACK_REGISTRATION    *PEM_CALLBACK_REGISTRATION;

/* EM client notification registration */
typedef struct _EM_CLIENT_NOTIFICATION_REGISTRATION {
    LPCGUID                 RuleId;
    EM_RULE_STATE_NOTIFY    RuleNotifyCallback;
    PVOID                   Context;
} EM_CLIENT_NOTIFICATION_REGISTRATION;
typedef EM_CLIENT_NOTIFICATION_REGISTRATION *PEM_CLIENT_NOTIFICATION_REGISTRATION;

/* Common log file system LSN */
#if (NTDDI_VERSION >= 0x05020100)
typedef struct _CLS_LSN {
    ULONGLONG   Internal;
} CLS_LSN;
typedef CLS_LSN     *PCLS_LSN;
typedef CLS_LSN     *PPCLS_LSN;
typedef CLS_LSN     CLFS_LSN;
typedef CLFS_LSN    *PCLFS_LSN;
typedef CLFS_LSN    **PPCLFS_LSN;
#endif

/* Common log file system context modes */
#if (NTDDI_VERSION >= 0x05020100)
typedef enum _CLS_CONTEXT_MODE {
    ClsContextNone      = 0x00,
    ClsContextUndoNext  = 0x01,
    ClsContextPrevious  = 0x02,
    ClsContextForward   = 0x03
} CLS_CONTEXT_MODE;
typedef CLS_CONTEXT_MODE    *PCLS_CONTEXT_MODE;
typedef CLS_CONTEXT_MODE    **PPCLS_CONTEXT_MODE;
typedef enum _CLFS_CONTEXT_MODE {
    ClfsContextNone     = 0x00,
    ClfsContextUndoNext = 0x01,
    ClfsContextPrevious = 0x02,
    ClfsContextForward  = 0x03
} CLFS_CONTEXT_MODE;
typedef CLFS_CONTEXT_MODE   *PCLFS_CONTEXT_MODE;
typedef CLFS_CONTEXT_MODE   *PPCLFS_CONTEXT_MODE;
#endif

/* Common log file system node identifier */
#if (NTDDI_VERSION >= 0x05020100)
typedef struct _CLFS_NODE_ID {
    ULONG   cType;
    ULONG   cbNode;
} CLFS_NODE_ID;
typedef CLFS_NODE_ID    *PCLFS_NODE_ID;
#endif

/* Common log file system write entry */
#if (NTDDI_VERSION >= 0x05020100)
typedef struct _CLS_WRITE_ENTRY {
    PVOID   Buffer;
    ULONG   ByteLength;
} CLS_WRITE_ENTRY;
typedef CLS_WRITE_ENTRY     *PCLS_WRITE_ENTRY;
typedef CLS_WRITE_ENTRY     **PPCLS_WRITE_ENTRY;
typedef CLS_WRITE_ENTRY     CLFS_WRITE_ENTRY;
typedef CLFS_WRITE_ENTRY    *PCLFS_WRITE_ENTRY;
typedef CLFS_WRITE_ENTRY    **PPCLFS_WRITE_ENTRY;
#endif

/* Common log file system information */
#if (NTDDI_VERSION >= 0x05020100)
typedef struct _CLS_INFORMATION {
    LONGLONG    TotalAvailable;
    LONGLONG    CurrentAvailable;
    LONGLONG    TotalReservation;
    ULONGLONG   BaseFileSize;
    ULONGLONG   ContainerSize;
    ULONG       TotalContainers;
    ULONG       FreeContainers;
    ULONG       TotalClients;
    ULONG       Attributes;
    ULONG       FlushThreshold;
    ULONG       SectorSize;
    CLS_LSN     MinArchiveTailLsn;
    CLS_LSN     BaseLsn;
    CLS_LSN     LastFlushedLsn;
    CLS_LSN     LastLsn;
    CLS_LSN     RestartLsn;
    GUID        Identity;
} CLS_INFORMATION;
typedef CLS_INFORMATION     *PCLS_INFORMATION;
typedef CLS_INFORMATION     **PPCLS_INFORMATION;
typedef CLS_INFORMATION     CLFS_INFORMATION;
typedef CLFS_INFORMATION    *PCLFS_INFORMATION;
typedef CLFS_INFORMATION    **PPCLFS_INFORMATION;
#endif

/* Common log file system client information */
#if (NTDDI_VERSION >= 0x05020100)
typedef struct _CLS_CLIENT_INFORMATION {
    CLS_INFORMATION ClfsInfo;
    ULONG           ClientAttributes;
    LONGLONG        ClientUndoCommitment;
    CLS_LSN         ClientArchiveTailLsn;
    CLS_LSN         ClientBaseLsn;
    CLS_LSN         ClientLastLsn;
    CLS_LSN         ClientRestartLsn;
} CLS_CLIENT_INFORMATION;
typedef CLS_CLIENT_INFORMATION  *PCLS_CLIENT_INFORMATION;
typedef CLS_CLIENT_INFORMATION  *PPCLS_CLIENT_INFORMATION;
typedef CLS_CLIENT_INFORMATION  CLFS_CLIENT_INFORMATION;
typedef CLFS_CLIENT_INFORMATION *PCLFS_CLIENT_INFORMATION;
typedef CLFS_CLIENT_INFORMATION *PPCLFS_CLIENT_INFORMATION;
#endif

/* Common log file system log name information */
#if (NTDDI_VERSION >= 0x05020100)
typedef struct _CLFS_LOG_NAME_INFORMATION {
    USHORT  NameLengthInBytes;
    WCHAR   Name[1];
} CLFS_LOG_NAME_INFORMATION;
typedef CLFS_LOG_NAME_INFORMATION   *PCLFS_LOG_NAME_INFORMATION;
typedef CLFS_LOG_NAME_INFORMATION   *PPCLFS_LOG_NAME_INFORMATION;
#endif

/* Common log file system stream identifier information */
#if (NTDDI_VERSION >= 0x05020100)
typedef struct _CLFS_STREAM_ID_INFORMATION {
    UCHAR   StreamIdentifier;
} CLFS_STREAM_ID_INFORMATION;
typedef CLFS_STREAM_ID_INFORMATION  *PCLFS_STREAM_ID_INFORMATION;
typedef CLFS_STREAM_ID_INFORMATION  *PPCLFS_STREAM_ID_INFORMATION;
#endif

/* Common log file system physical LSN information */
#if (NTDDI_VERSION >= 0x06000000)
#pragma pack( __push, 8 )
typedef struct _CLFS_PHYSICAL_LSN_INFORMATION {
    UCHAR       StreamIdentifier;
    CLFS_LSN    VirtualLsn;
    CLFS_LSN    PhysicalLsn;
} CLFS_PHYSICAL_LSN_INFORMATION;
typedef CLFS_PHYSICAL_LSN_INFORMATION   *PCLFS_PHYSICAL_LSN_INFORMATION;
#pragma pack( __pop )
#endif

/* Common log file system container information */
#if (NTDDI_VERSION >= 0x05020100)
typedef struct _CLS_CONTAINER_INFORMATION {
    ULONG                   FileAttributes;
    ULONGLONG               CreationTime;
    ULONGLONG               LastAccessTime;
    ULONGLONG               LastWriteTime;
    LONGLONG                ContainerSize;
    ULONG                   FileNameActualLength;
    ULONG                   FileNameLength;
    WCHAR                   FileName[CLFS_MAX_CONTAINER_INFO];
    CLFS_CONTAINER_STATE    State;
    CLFS_CONTAINER_ID       PhysicalContainerId;
    CLFS_CONTAINER_ID       LogicalContainerId;
} CLS_CONTAINER_INFORMATION;
typedef CLS_CONTAINER_INFORMATION   *PCLS_CONTAINER_INFORMATION;
typedef CLS_CONTAINER_INFORMATION   **PPCLS_CONTAINER_INFORMATION;
typedef CLS_CONTAINER_INFORMATION   CLFS_CONTAINER_INFORMATION;
typedef CLFS_CONTAINER_INFORMATION  *PCLFS_CONTAINER_INFORMATION;
typedef CLFS_CONTAINER_INFORMATION  **PPCFLS_CONTAINER_INFORMATION;
#endif

/* Common log file system log information classes */
#if (NTDDI_VERSION >= 0x05020100)
typedef enum _CLS_LOG_INFORMATION_CLASS {
    ClfsLogBasicInformation             = 0x00,
    ClfsLogBasicInformationPhysical     = 0x01,
    ClfsLogPhysicalNameInformation      = 0x02,
#if (NTDDI_VERSION >= 0x06000000)
    ClfsLogStreamIdentifierInformation  = 0x03,
    ClfsLogSystemMarkingInformation     = 0x04,
    ClfsLogPhysicalLsnInformation       = 0x05
#else
    ClfsLogStreamIdentifierInformation  = 0x03
#endif
} CLS_LOG_INFORMATION_CLASS;
typedef CLS_LOG_INFORMATION_CLASS   *PCLS_LOG_INFORMATION_CLASS;
typedef CLS_LOG_INFORMATION_CLASS   **PPCLS_LOG_INFORMATION_CLASS;
typedef CLS_LOG_INFORMATION_CLASS   CLFS_LOG_INFORMATION_CLASS;
typedef CLFS_LOG_INFORMATION_CLASS  *PCLFS_LOG_INFORMATION_CLASS;
typedef CLFS_LOG_INFORMATION_CLASS  **PPCFLS_LOG_INFORMATION_CLASS;
#endif

/* Common log file system I/O statistics classes */
#if (NTDDI_VERSION >= 0x05020100)
typedef enum _CLS_IOSTATS_CLASS {
    ClsIoStatsDefault   = 0x0000,
    ClsIoStatsMax       = 0xFFFF
} CLS_IOSTATS_CLASS;
typedef CLS_IOSTATS_CLASS   *PCLS_IOSTATS_CLASS;
typedef CLS_IOSTATS_CLASS   **PPCLS_IOSTATS_CLASS;
typedef enum _CLFS_IOSTATS_CLASS {
    ClfsIoStatsDefault  = 0x0000,
    ClfsIoStatsMax      = 0xFFFF
} CLFS_IOSTATS_CLASS;
typedef CLFS_IOSTATS_CLASS  *PCLFS_IOSTATS_CLASS;
typedef CLFS_IOSTATS_CLASS  **PPCLFS_IOSTATS_CLASS;
#endif

/* Common log file system I/O statistics header */
#if (NTDDI_VERSION >= 0x05020100)
typedef struct _CLS_IO_STATISTICS_HEADER {
    UCHAR               ubMajorVersion;
    UCHAR               ubMinorVersion;
    CLFS_IOSTATS_CLASS  eStatsClass;
    USHORT              cbLength;
    ULONG               coffData;
} CLS_IO_STATISTICS_HEADER;
typedef CLS_IO_STATISTICS_HEADER    *PCLS_IO_STATISTICS_HEADER;
typedef CLS_IO_STATISTICS_HEADER    **PPCLS_IO_STATISTICS_HEADER;
typedef CLS_IO_STATISTICS_HEADER    CLFS_IO_STATISTICS_HEADER;
typedef CLFS_IO_STATISTICS_HEADER   *PCLFS_IO_STATISTICS_HEADER;
typedef CLFS_IO_STATISTICS_HEADER   **PPCLFS_IO_STATISTICS_HEADER;
#endif

/* Common log file system I/O statistics */
#if (NTDDI_VERSION >= 0x05020100)
typedef struct _CLS_IO_STATISTICS {
    CLS_IO_STATISTICS_HEADER    hdrIoStats;
    ULONGLONG                   cFlush;
    ULONGLONG                   cbFlush;
    ULONGLONG                   cMetaFlush;
    ULONGLONG                   cbMetaFlush;
} CLS_IO_STATISTICS;
typedef CLS_IO_STATISTICS   *PCLS_IO_STATISTICS;
typedef CLS_IO_STATISTICS   **PPCLS_IO_STATISTICS;
typedef CLS_IO_STATISTICS   CLFS_IO_STATISTICS;
typedef CLFS_IO_STATISTICS  *PCLFS_IO_STATISTICS;
typedef CLFS_IO_STATISTICS  **PPCLFS_IO_STATISTICS;
#endif

/* Common log file system scan context */
#if (NTDDI_VERSION >= 0x05020100)
typedef struct _CLS_SCAN_CONTEXT {
    CLFS_NODE_ID                cidNode;
    PLOG_FILE_OBJECT            plfoLog;
    ULONG                       cIndex;
    ULONG                       cContainers;
    ULONG                       cContainersReturned;
    CLFS_SCAN_MODE              eScanMode;
    PCLS_CONTAINER_INFORMATION  pinfoContainer;
} CLS_SCAN_CONTEXT;
typedef CLS_SCAN_CONTEXT    *PCLS_SCAN_CONTEXT;
typedef CLS_SCAN_CONTEXT    *PPCLS_SCAN_CONTEXT;
typedef CLS_SCAN_CONTEXT    CLFS_SCAN_CONTEXT;
typedef CLFS_SCAN_CONTEXT   *PCLFS_SCAN_CONTEXT;
typedef CLFS_SCAN_CONTEXT   **PPCLFS_SCAN_CONTEXT;
#endif

/* Common log file system archive descriptor */
#if (NTDDI_VERSION >= 0x05020100)
typedef struct _CLS_ARCHIVE_DESCRIPTOR {
    ULONGLONG                   coffLow;
    ULONGLONG                   coffHigh;
    CLS_CONTAINER_INFORMATION   infoContainer;
} CLS_ARCHIVE_DESCRIPTOR;
typedef CLS_ARCHIVE_DESCRIPTOR  *PCLS_ARCHIVE_DESCRIPTOR;
typedef CLS_ARCHIVE_DESCRIPTOR  *PPCLS_ARCHIVE_DESCRIPTOR;
typedef CLS_ARCHIVE_DESCRIPTOR  CLFS_ARCHIVE_DESCRIPTOR;
typedef CLFS_ARCHIVE_DESCRIPTOR *PCLFS_ARCHIVE_DESCRIPTOR;
typedef CLFS_ARCHIVE_DESCRIPTOR **PPCLFS_ARCHIVE_DESCRIPTOR;
#endif

/* Common log file system callbacks */
#if (NTDDI_VERSION >= 0x05020100)
typedef PVOID       (NTAPI *CLFS_BLOCK_ALLOCATION)( ULONG, PVOID );
typedef void        (NTAPI *CLFS_BLOCK_DEALLOCATION)( PVOID, PVOID );
#endif

/* Common log file system log archive modes */
#if (NTDDI_VERSION >= 0x05020100)
typedef enum _CLFS_LOG_ARCHIVE_MODE {
    ClfsLogArchiveEnabled   = 0x01,
    ClfsLogArchiveDisabled  = 0x02
} CLFS_LOG_ARCHIVE_MODE;
typedef CLFS_LOG_ARCHIVE_MODE   *PCLFS_LOG_ARCHIVE_MODE;
#endif

/* Common log file system management policy types */
#if (NTDDI_VERSION >= 0x05020100)
typedef enum _CLFS_MGMT_POLICY_TYPE {
    ClfsMgmtPolicyMaximumSize           = 0,
    ClfsMgmtPolicyMinimumSize           = 1,
    ClfsMgmtPolicyNewContainerSize      = 2,
    ClfsMgmtPolicyGrowthRate            = 3,
    ClfsMgmtPolicyLogTail               = 4,
    ClfsMgmtPolicyAutoShrink            = 5,
    ClfsMgmtPolicyAutoGrow              = 6,
    ClfsMgmtPolicyNewContainerPrefix    = 7,
    ClfsMgmtPolicyNewContainerSuffix    = 8,
    ClfsMgmtPolicyNewContainerExtension = 9,
    ClfsMgmtPolicyInvalid               = 10
} CLFS_MGMT_POLICY_TYPE;
typedef CLFS_MGMT_POLICY_TYPE   *PCLFS_MGMT_POLICY_TYPE;
#define CLFS_MGMT_NUM_POLICIES  ClfsMgmtPolicyInvalid
#endif

/* Common log file system management policy */
#if (NTDDI_VERSION >= 0x05020100)
typedef struct _CLFS_MGMT_POLICY {
    ULONG                   Version;
    ULONG                   LengthInBytes;
    ULONG                   PolicyFlags;
    CLFS_MGMT_POLICY_TYPE   PolicyType;
    union {
        struct {
            ULONG   Containers;
        } MaximumSize;
        struct {
            ULONG   Containers;
        } MinimumSize;
        struct {
            ULONG   SizeInBytes;
        } NewContainerSize;
        struct {
            ULONG   AbsoluteGrowthInContainers;
            ULONG   RelativeGrowthPercentage;
        } GrowthRate;
        struct {
            ULONG   MinimumAvailablePercentage;
            ULONG   MinimumAvailableContainers;
        } LogTail;
        struct {
            ULONG   Percentage;
        } AutoShrink;
        struct {
            ULONG   Enabled;
        } AutoGrow;
        struct {
            USHORT  PrefixLengthInBytes;
            WCHAR   PrefixString[1];
        } NewContainerPrefix;
        struct {
            ULONGLONG   NextContainerSuffix;
        } NewContainerSuffix;
        struct {
            USHORT  ExtensionLengthInBytes;
            WCHAR   ExtensionString[1];
        } NewContainerExtension;
    } PolicyParameters;
} CLFS_MGMT_POLICY;
typedef CLFS_MGMT_POLICY    *PCLFS_MGMT_POLICY;
#endif

/* Common log file system management notification types */
#if (NTDDI_VERSION >= 0x05020100)
typedef enum _CLFS_MGMT_NOTIFICATION_TYPE {
    ClfsMgmtAdvanceTailNotification     = 0,
    ClfsMgmtLogFullHandlerNotification  = 1,
    ClfsMgmtLogUnpinnedNotification     = 2,
    ClfsMgmtLogWriteNotification        = 3
} CLFS_MGMT_NOTIFICATION_TYPE;
typedef CLFS_MGMT_NOTIFICATION_TYPE *PCLFS_MGMT_NOTIFICATION_TYPE;
#endif

/* Common log file system management notification */
#if (NTDDI_VERSION >= 0x05020100)
typedef struct _CLFS_MGMT_NOTIFICATION {
    CLFS_MGMT_NOTIFICATION_TYPE Notification;
    CLFS_LSN                    Lsn;
    USHORT                      LogIsPinned;
} CLFS_MGMT_NOTIFICATION;
typedef CLFS_MGMT_NOTIFICATION  *PCLFS_MGMT_NOTIFICATION;
#endif

/* Common log file system callbacks */
#if (NTDDI_VERSION >= 0x05020100)
typedef NTSTATUS    (NTAPI *PCLFS_CLIENT_ADVANCE_TAIL_CALLBACK)( PLOG_FILE_OBJECT, PCLFS_LSN, PVOID );
typedef VOID        (NTAPI *PCLFS_CLIENT_LFF_HANDLER_COMPLETE_CALLBACK)( PLOG_FILE_OBJECT, NTSTATUS, BOOLEAN, PVOID );
typedef VOID        (NTAPI *PCLFS_CLIENT_LOG_UNPINNED_CALLBACK)( PLOG_FILE_OBJECT, PVOID );
typedef VOID        (NTAPI *PCLFS_SET_LOG_SIZE_COMPLETE_CALLBACK)( PLOG_FILE_OBJECT, NTSTATUS, PVOID );
#endif

/* Common log file system management client registration */
#if (NTDDI_VERSION >= 0x05020100)
typedef struct _CLFS_MGMT_CLIENT_REGISTRATION {
    ULONG                                       Version;
    PCLFS_CLIENT_ADVANCE_TAIL_CALLBACK          AdvanceTailCallback;
    PVOID                                       AdvanceTailCallbackData;
    PCLFS_CLIENT_LFF_HANDLER_COMPLETE_CALLBACK  LogGrowthCompleteCallback;
    PVOID                                       LogGrowthCompleteCallbackData;
    PCLFS_CLIENT_LOG_UNPINNED_CALLBACK          LogUnpinnedCallback;
    PVOID                                       LogUnpinnedCallbackData;
} CLFS_MGMT_CLIENT_REGISTRATION;
typedef CLFS_MGMT_CLIENT_REGISTRATION   *PCLFS_MGMT_CLIENT_REGISTRATION;
#endif

/* Transaction manager callbacks */
typedef NTSTATUS    (NTAPI *PTM_RM_NOTIFICATION)( PKENLISTMENT, PVOID, PVOID, ULONG, PLARGE_INTEGER, ULONG, PVOID );
typedef NTSTATUS    (NTAPI *PTM_PROPAGATE_ROUTINE)( PVOID, PVOID, NTSTATUS, GUID );

/* PCW counter descriptor */
typedef struct _PCW_COUNTER_DESCRIPTOR {
    USHORT  Id;
    USHORT  StructIndex;
    USHORT  Offset;
    USHORT  Size;
} PCW_COUNTER_DESCRIPTOR;
typedef PCW_COUNTER_DESCRIPTOR  *PPCW_COUNTER_DESCRIPTOR;

/* PCW data */
typedef struct _PCW_DATA {
    const VOID  *Data;
    ULONG       Size;
} PCW_DATA;
typedef PCW_DATA    *PPCW_DATA;

/* PCW counter information */
typedef struct _PCW_COUNTER_INFORMATION {
    ULONG64             CounterMask;
    PCUNICODE_STRING    InstanceMask;
} PCW_COUNTER_INFORMATION;
typedef PCW_COUNTER_INFORMATION *PPCW_COUNTER_INFORMATION;

/* PCW mask information */
typedef struct _PCW_MASK_INFORMATION {
    ULONG64             CounterMask;
    PCUNICODE_STRING    InstanceMask;
    ULONG               InstanceId;
    BOOLEAN             CollectMultiple;
    PPCW_BUFFER         Buffer;
    PKEVENT             CancelEvent;
} PCW_MASK_INFORMATION;
typedef PCW_MASK_INFORMATION    *PPCW_MASK_INFORMATION;

/* PCW callback information */
typedef union _PCW_CALLBACK_INFORMATION {
    PCW_COUNTER_INFORMATION AddCounter;
    PCW_COUNTER_INFORMATION RemoveCounter;
    PCW_MASK_INFORMATION    EnumerateInstances;
    PCW_MASK_INFORMATION    CollectData;
} PCW_CALLBACK_INFORMATION;
typedef PCW_CALLBACK_INFORMATION    *PPCW_CALLBACK_INFORMATION;

/* PCW callback types */
typedef enum _PCW_CALLBACK_TYPE {
    PcwCallbackAddCounter           = 0,
    PcwCallbackRemoveCounter        = 1,
    PcwCallbackEnumerateInstances   = 2,
    PcwCallbackCollectData          = 3
} PCW_CALLBACK_TYPE;
typedef PCW_CALLBACK_TYPE   *PPCW_CALLBACK_TYPE;

/* PCW callback */
typedef NTSTATUS    (NTAPI PCW_CALLBACK)( PCW_CALLBACK_TYPE, PPCW_CALLBACK_INFORMATION, PVOID );
typedef PCW_CALLBACK    *PPCW_CALLBACK;

/* PCW registration information */
typedef struct _PCW_REGISTRATION_INFORMATION {
    ULONG                   Version;
    PCUNICODE_STRING        Name;
    ULONG                   CounterCount;
    PPCW_COUNTER_DESCRIPTOR Counters;
    PPCW_CALLBACK           Callback;
    PVOID                   CallbackContext;
} PCW_REGISTRATION_INFORMATION;
typedef PCW_REGISTRATION_INFORMATION    *PPCW_REGISTRATION_INFORMATION;


/* Global variables in NTOSKRNL.EXE and NTDLL.DLL */
extern NTSYSAPI BOOLEAN         * __cdecl NlsMbCodePageTag;
extern NTSYSAPI BOOLEAN         * __cdecl NlsMbOemCodePageTag;

/* Global variables in NTOSKRNL.EXE */
extern NTKERNELAPI PBOOLEAN     __cdecl KdDebuggerEnabled;
extern NTKERNELAPI PBOOLEAN     __cdecl KdDebuggerNotPresent;
extern NTKERNELAPI PBOOLEAN     __cdecl Mm64BitPhysicalAddress;
extern NTKERNELAPI PVOID        __cdecl MmBadPointer;
extern NTKERNELAPI POBJECT_TYPE * __cdecl CmKeyObjectType;
extern NTKERNELAPI POBJECT_TYPE * __cdecl IoFileObjectType;
extern NTKERNELAPI POBJECT_TYPE * __cdecl ExEventObjectType;
extern NTKERNELAPI POBJECT_TYPE * __cdecl ExSemaphoreObjectType;
extern NTKERNELAPI POBJECT_TYPE * __cdecl TmTransactionManagerObjectType;
extern NTKERNELAPI POBJECT_TYPE * __cdecl TmResourceManagerObjectType;
extern NTKERNELAPI POBJECT_TYPE * __cdecl TmEnlistmentObjectType;
extern NTKERNELAPI POBJECT_TYPE * __cdecl TmTransactionObjectType;
extern NTKERNELAPI POBJECT_TYPE * __cdecl PsProcessType;
extern NTKERNELAPI POBJECT_TYPE * __cdecl PsThreadType;
extern NTKERNELAPI POBJECT_TYPE * __cdecl SeTokenObjectType;
#ifdef _X86_
extern NTKERNELAPI volatile KSYSTEM_TIME __cdecl KeTickCount;
#endif
#if (NTDDI_VERSION >= 0x06000000)
extern NTKERNELAPI volatile CCHAR __cdecl KeNumberProcessors;
#elif (NTDDI_VERSION >= 0x05010000)
extern NTKERNELAPI CCHAR    __cdecl KeNumberProcessors;
#else
extern NTKERNELAPI PCCHAR   __cdecl KeNumberProcessors;
#endif

/* Global variables in CLFS.SYS */
#if (NTDDI_VERSION >= 0x05020100)
extern CLFSUSER_API const CLFS_LSN __cdecl CLFS_LSN_INVALID;
extern CLFSUSER_API const CLFS_LSN __cdecl CLFS_LSN_NULL;
#endif

/* Functions in NTOSKRNL.EXE and NTDLL.DLL */
NTSYSAPI ULONG          __cdecl DbgPrint( PCSTR, ... );
NTSYSAPI VOID           NTAPI RtlAssert( PVOID, PVOID, ULONG, PSTR );
NTSYSAPI VOID           NTAPI RtlFreeUnicodeString( PUNICODE_STRING );
NTSYSAPI NTSTATUS       NTAPI RtlGUIDFromString( PUNICODE_STRING, GUID * );
NTSYSAPI VOID           NTAPI RtlInitUnicodeString( PUNICODE_STRING, PCWSTR );
NTSYSAPI BOOLEAN        NTAPI RtlIsNtDdiVersionAvailable( ULONG );
NTSYSAPI BOOLEAN        NTAPI RtlIsServicePackVersionInstalled( ULONG );
NTSYSAPI NTSTATUS       NTAPI RtlStringFromGUID( REFGUID, PUNICODE_STRING );
#if (NTDDI_VERSION >= 0x05000000)
NTSYSAPI VOID           NTAPI DbgBreakPoint( VOID );
NTSYSAPI VOID           NTAPI DbgBreakPointWithStatus( ULONG );
NTSYSAPI ULONG          __cdecl DbgPrintReturnControlC( PCCH, ... );
NTSYSAPI NTSTATUS       NTAPI RtlAnsiStringToUnicodeString( PUNICODE_STRING, PCANSI_STRING, BOOLEAN );
NTSYSAPI NTSTATUS       NTAPI RtlAppendUnicodeStringToString( PUNICODE_STRING, PCUNICODE_STRING );
NTSYSAPI NTSTATUS       NTAPI RtlAppendUnicodeToString( PUNICODE_STRING, PCWSTR );
NTSYSAPI BOOLEAN        NTAPI RtlAreBitsClear( PRTL_BITMAP, ULONG, ULONG );
NTSYSAPI BOOLEAN        NTAPI RtlAreBitsSet( PRTL_BITMAP, ULONG, ULONG );
NTSYSAPI NTSTATUS       NTAPI RtlCheckRegistryKey( ULONG, PWSTR );
NTSYSAPI VOID           NTAPI RtlClearAllBits( PRTL_BITMAP );
NTSYSAPI VOID           NTAPI RtlClearBits( PRTL_BITMAP, ULONG, ULONG );
NTSYSAPI SIZE_T         NTAPI RtlCompareMemory( const VOID *, const VOID *, SIZE_T );
NTSYSAPI LONG           NTAPI RtlCompareUnicodeString( PCUNICODE_STRING, PCUNICODE_STRING, BOOLEAN );
NTSYSAPI LONG           NTAPI RtlCompareUnicodeStrings( PCWCH, SIZE_T, PCWCH, SIZE_T, BOOLEAN );
NTSYSAPI VOID           NTAPI RtlCopyUnicodeString( PUNICODE_STRING, PCUNICODE_STRING );
NTSYSAPI NTSTATUS       NTAPI RtlCreateRegistryKey( ULONG, PWSTR );
NTSYSAPI NTSTATUS       NTAPI RtlCreateSecurityDescriptor( PSECURITY_DESCRIPTOR, ULONG );
NTSYSAPI NTSTATUS       NTAPI RtlDeleteRegistryValue( ULONG, PCWSTR, PCWSTR );
NTSYSAPI BOOLEAN        NTAPI RtlEqualUnicodeString( PCUNICODE_STRING, PCUNICODE_STRING, BOOLEAN );
NTSYSAPI LARGE_INTEGER  NTAPI RtlExtendedIntegerMultiply( LARGE_INTEGER, LONG );
NTSYSAPI LARGE_INTEGER  NTAPI RtlExtendedLargeIntegerDivide( LARGE_INTEGER, ULONG, PULONG );
NTSYSAPI LARGE_INTEGER  NTAPI RtlExtendedMagicDivide( LARGE_INTEGER, LARGE_INTEGER, CCHAR );
NTSYSAPI ULONG          NTAPI RtlFindClearBits( PRTL_BITMAP, ULONG, ULONG );
NTSYSAPI ULONG          NTAPI RtlFindClearBitsAndSet( PRTL_BITMAP, ULONG, ULONG );
NTSYSAPI ULONG          NTAPI RtlFindClearRuns( PRTL_BITMAP, PRTL_BITMAP_RUN, ULONG, BOOLEAN );
NTSYSAPI ULONG          NTAPI RtlFindFirstRunClear( PRTL_BITMAP, PULONG );
NTSYSAPI ULONG          NTAPI RtlFindLastBackwardRunClear( PRTL_BITMAP, ULONG, PULONG );
NTSYSAPI CCHAR          NTAPI RtlFindLeastSignificantBit( ULONGLONG );
NTSYSAPI ULONG          NTAPI RtlFindLongestClearRun( PRTL_BITMAP, PULONG );
NTSYSAPI CCHAR          NTAPI RtlFindMostSignificantBit( ULONGLONG );
NTSYSAPI ULONG          NTAPI RtlFindNextForwardRunClear( PRTL_BITMAP, ULONG, PULONG );
NTSYSAPI ULONG          NTAPI RtlFindSetBits( PRTL_BITMAP, ULONG, ULONG );
NTSYSAPI ULONG          NTAPI RtlFindSetBitsAndClear( PRTL_BITMAP, ULONG, ULONG );
NTSYSAPI VOID           NTAPI RtlFreeAnsiString( PANSI_STRING );
NTSYSAPI NTSTATUS       NTAPI RtlHashUnicodeString( const UNICODE_STRING *, BOOLEAN, ULONG, PULONG );
NTSYSAPI VOID           NTAPI RtlInitAnsiString( PANSI_STRING, PCSZ );
NTSYSAPI VOID           NTAPI RtlInitString( PSTRING, PCSZ );
NTSYSAPI VOID           NTAPI RtlInitializeBitMap( PRTL_BITMAP, PULONG, ULONG );
NTSYSAPI NTSTATUS       NTAPI RtlInt64ToUnicodeString( ULONGLONG, ULONG, PUNICODE_STRING );
NTSYSAPI NTSTATUS       NTAPI RtlIntegerToUnicodeString( ULONG, ULONG, PUNICODE_STRING );
NTSYSAPI ULONG          NTAPI RtlLengthSecurityDescriptor( PSECURITY_DESCRIPTOR );
NTSYSAPI ULONG          NTAPI RtlNumberOfClearBits( PRTL_BITMAP );
NTSYSAPI ULONG          NTAPI RtlNumberOfSetBits( PRTL_BITMAP );
NTSYSAPI NTSTATUS       NTAPI RtlQueryRegistryValues( ULONG, PCWSTR, PRTL_QUERY_REGISTRY_TABLE, PVOID, PVOID );
NTSYSAPI VOID           NTAPI RtlSetAllBits( PRTL_BITMAP );
NTSYSAPI VOID           NTAPI RtlSetBits( PRTL_BITMAP, ULONG, ULONG );
NTSYSAPI NTSTATUS       NTAPI RtlSetDaclSecurityDescriptor( PSECURITY_DESCRIPTOR, BOOLEAN, PACL, BOOLEAN );
NTSYSAPI BOOLEAN        NTAPI RtlTimeFieldsToTime( PTIME_FIELDS, PLARGE_INTEGER );
NTSYSAPI VOID           NTAPI RtlTimeToTimeFields( PLARGE_INTEGER, PTIME_FIELDS );
NTSYSAPI NTSTATUS       NTAPI RtlUnicodeStringToAnsiString( PANSI_STRING, PCUNICODE_STRING, BOOLEAN );
NTSYSAPI NTSTATUS       NTAPI RtlUnicodeStringToInteger( PCUNICODE_STRING, ULONG, PULONG );
NTSYSAPI ULONG          FASTCALL RtlUlongByteSwap( ULONG );
NTSYSAPI ULONGLONG      FASTCALL RtlUlonglongByteSwap( ULONGLONG );
NTSYSAPI WCHAR          NTAPI RtlUpcaseUnicodeChar( WCHAR );
NTSYSAPI USHORT         FASTCALL RtlUshortByteSwap( USHORT );
NTSYSAPI BOOLEAN        NTAPI RtlValidRelativeSecurityDescriptor( PSECURITY_DESCRIPTOR, ULONG, SECURITY_INFORMATION );
NTSYSAPI BOOLEAN        NTAPI RtlValidSecurityDescriptor( PSECURITY_DESCRIPTOR );
NTSYSAPI NTSTATUS       NTAPI RtlWriteRegistryValue( ULONG, PCWSTR, PCWSTR, ULONG, PVOID, ULONG );
NTSYSAPI ULONG          NTAPI RtlxAnsiStringToUnicodeSize( PCANSI_STRING );
NTSYSAPI ULONG          NTAPI RtlxUnicodeStringToAnsiSize( PCUNICODE_STRING );
NTSYSAPI NTSTATUS       NTAPI ZwClose( HANDLE );
NTSYSAPI NTSTATUS       NTAPI ZwCreateDirectoryObject( PHANDLE, ACCESS_MASK, POBJECT_ATTRIBUTES );
NTSYSAPI NTSTATUS       NTAPI ZwCreateFile( PHANDLE, ACCESS_MASK, POBJECT_ATTRIBUTES, PIO_STATUS_BLOCK, PLARGE_INTEGER, ULONG, ULONG, ULONG, ULONG, PVOID, ULONG );
NTSYSAPI NTSTATUS       NTAPI ZwCreateKey( PHANDLE, ACCESS_MASK, POBJECT_ATTRIBUTES, ULONG, PUNICODE_STRING, ULONG, PULONG );
NTSYSAPI NTSTATUS       NTAPI ZwCreateSection( PHANDLE, ACCESS_MASK, POBJECT_ATTRIBUTES, PLARGE_INTEGER, ULONG, ULONG, HANDLE );
NTSYSAPI NTSTATUS       NTAPI ZwDeleteKey( HANDLE );
NTSYSAPI NTSTATUS       NTAPI ZwDeleteValueKey( HANDLE, PUNICODE_STRING );
NTSYSAPI NTSTATUS       NTAPI ZwEnumerateKey( HANDLE, ULONG, KEY_INFORMATION_CLASS, PVOID, ULONG, PULONG );
NTSYSAPI NTSTATUS       NTAPI ZwEnumerateValueKey( HANDLE, ULONG, KEY_VALUE_INFORMATION_CLASS, PVOID, ULONG, PULONG );
NTSYSAPI NTSTATUS       NTAPI ZwFlushKey( HANDLE );
NTSYSAPI NTSTATUS       NTAPI ZwLoadDriver( PUNICODE_STRING );
NTSYSAPI NTSTATUS       NTAPI ZwMakeTemporaryObject( HANDLE );
NTSYSAPI NTSTATUS       NTAPI ZwMapViewOfSection( HANDLE, HANDLE, PVOID *, ULONG_PTR, SIZE_T, PLARGE_INTEGER, PSIZE_T, SECTION_INHERIT, ULONG, ULONG );
NTSYSAPI NTSTATUS       NTAPI ZwOpenFile( PHANDLE, ACCESS_MASK, POBJECT_ATTRIBUTES, PIO_STATUS_BLOCK, ULONG, ULONG );
NTSYSAPI NTSTATUS       NTAPI ZwOpenKey( PHANDLE, ACCESS_MASK, POBJECT_ATTRIBUTES );
NTSYSAPI NTSTATUS       NTAPI ZwOpenSection( PHANDLE, ACCESS_MASK, POBJECT_ATTRIBUTES );
NTSYSAPI NTSTATUS       NTAPI ZwOpenSymbolicLinkObject( PHANDLE, ACCESS_MASK, POBJECT_ATTRIBUTES );
NTSYSAPI NTSTATUS       NTAPI ZwQueryFullAttributesFile( POBJECT_ATTRIBUTES, PFILE_NETWORK_OPEN_INFORMATION );
NTSYSAPI NTSTATUS       NTAPI ZwQueryInformationFile( HANDLE, PIO_STATUS_BLOCK, PVOID, ULONG, FILE_INFORMATION_CLASS );
NTSYSAPI NTSTATUS       NTAPI ZwQueryKey( HANDLE, KEY_INFORMATION_CLASS, PVOID, ULONG, PULONG );
NTSYSAPI NTSTATUS       NTAPI ZwQuerySymbolicLinkObject( HANDLE, PUNICODE_STRING, PULONG );
NTSYSAPI NTSTATUS       NTAPI ZwQueryValueKey( HANDLE, PUNICODE_STRING, KEY_VALUE_INFORMATION_CLASS, PVOID, ULONG, PULONG );
NTSYSAPI NTSTATUS       NTAPI ZwReadFile( HANDLE, HANDLE, PIO_APC_ROUTINE, PVOID, PIO_STATUS_BLOCK, PVOID, ULONG, PLARGE_INTEGER, PULONG );
NTSYSAPI NTSTATUS       NTAPI ZwSetInformationFile( HANDLE, PIO_STATUS_BLOCK, PVOID, ULONG, FILE_INFORMATION_CLASS );
NTSYSAPI NTSTATUS       NTAPI ZwSetValueKey( HANDLE, PUNICODE_STRING, ULONG, ULONG, PVOID, ULONG );
NTSYSAPI NTSTATUS       NTAPI ZwUnloadDriver( PUNICODE_STRING );
NTSYSAPI NTSTATUS       NTAPI ZwUnmapViewOfSection( HANDLE, PVOID );
NTSYSAPI NTSTATUS       NTAPI ZwWriteFile( HANDLE, HANDLE, PIO_APC_ROUTINE, PVOID, PIO_STATUS_BLOCK, PVOID, ULONG, PLARGE_INTEGER, PULONG );
#endif
#if (NTDDI_VERSION >= 0x05000300)
NTSYSAPI VOID           FASTCALL RtlPrefetchMemoryNonTemporal( PVOID, SIZE_T );
#endif
#if (NTDDI_VERSION >= 0x05010000)
NTSYSAPI ULONG          __cdecl DbgPrintEx( ULONG, ULONG, PCSTR, ... );
NTSYSAPI NTSTATUS       NTAPI DbgQueryDebugFilterState( ULONG, ULONG );
NTSYSAPI NTSTATUS       NTAPI DbgSetDebugFilterState( ULONG, ULONG, BOOLEAN );
NTSYSAPI VOID           NTAPI RtlClearBit( PRTL_BITMAP, ULONG );
NTSYSAPI WCHAR          NTAPI RtlDowncaseUnicodeChar( WCHAR );
NTSYSAPI VOID           NTAPI RtlSetBit( PRTL_BITMAP, ULONG );
NTSYSAPI BOOLEAN        NTAPI RtlTestBit( PRTL_BITMAP, ULONG );
NTSYSAPI ULONG          NTAPI vDbgPrintEx( ULONG, ULONG, PCCH, va_list );
NTSYSAPI ULONG          NTAPI vDbgPrintExWithPrefix( PCCH, ULONG, ULONG, PCCH, va_list );
#endif
#if (NTDDI_VERSION >= 0x05020000)
NTSYSAPI NTSTATUS       NTAPI ZwOpenEvent( PHANDLE, ACCESS_MASK, POBJECT_ATTRIBUTES );
#endif
#if (NTDDI_VERSION >= 0x06000000)
NTSYSAPI NTSTATUS       NTAPI DbgSetDebugPrintCallback( PDEBUG_PRINT_CALLBACK, BOOLEAN );
NTSYSAPI ULONGLONG      NTAPI RtlCmDecodeMemIoResource( PCM_PARTIAL_RESOURCE_DESCRIPTOR, PULONGLONG );
NTSYSAPI NTSTATUS       NTAPI RtlCmEncodeMemIoResource( PCM_PARTIAL_RESOURCE_DESCRIPTOR, UCHAR, ULONGLONG, ULONGLONG );
NTSYSAPI NTSTATUS       NTAPI RtlFindClosestEncodableLength( ULONGLONG, PULONGLONG );
NTSYSAPI ULONGLONG      NTAPI RtlIoDecodeMemIoResource( PIO_RESOURCE_DESCRIPTOR, PULONGLONG, PULONGLONG, PULONGLONG );
NTSYSAPI NTSTATUS       NTAPI RtlIoEncodeMemIoResource( PIO_RESOURCE_DESCRIPTOR, UCHAR, ULONGLONG, ULONGLONG, ULONGLONG, ULONGLONG );
NTSYSAPI ULONG          NTAPI RtlNumberOfSetBitsUlongPtr( ULONG_PTR );
NTSYSAPI NTSTATUS       NTAPI ZwCommitComplete( HANDLE, PLARGE_INTEGER );
NTSYSAPI NTSTATUS       NTAPI ZwCommitEnlistment( HANDLE, PLARGE_INTEGER );
NTSYSAPI NTSTATUS       NTAPI ZwCommitTransaction( HANDLE, BOOLEAN );
NTSYSAPI NTSTATUS       NTAPI ZwCreateEnlistment( PHANDLE, ACCESS_MASK, HANDLE, HANDLE, POBJECT_ATTRIBUTES, ULONG, NOTIFICATION_MASK, PVOID );
NTSYSAPI NTSTATUS       NTAPI ZwCreateKeyTransacted( PHANDLE, ACCESS_MASK, POBJECT_ATTRIBUTES, ULONG, PUNICODE_STRING, ULONG, HANDLE, PULONG );
NTSYSAPI NTSTATUS       NTAPI ZwCreateResourceManager( PHANDLE, ACCESS_MASK, HANDLE, LPGUID, POBJECT_ATTRIBUTES, ULONG, PUNICODE_STRING );
NTSYSAPI NTSTATUS       NTAPI ZwCreateTransaction( PHANDLE, ACCESS_MASK, POBJECT_ATTRIBUTES, LPGUID, HANDLE, ULONG, ULONG, ULONG, PLARGE_INTEGER, PUNICODE_STRING );
NTSYSAPI NTSTATUS       NTAPI ZwCreateTransactionManager( PHANDLE, ACCESS_MASK, POBJECT_ATTRIBUTES, PUNICODE_STRING, ULONG, ULONG );
NTSYSAPI NTSTATUS       NTAPI ZwEnumerateTransactionObject( HANDLE, KTMOBJECT_TYPE, PKTMOBJECT_CURSOR, ULONG, PULONG );
NTSYSAPI NTSTATUS       NTAPI ZwGetNotificationResourceManager( HANDLE, PTRANSACTION_NOTIFICATION, ULONG, PLARGE_INTEGER, PULONG, ULONG, ULONG_PTR );
NTSYSAPI NTSTATUS       NTAPI ZwOpenEnlistment( PHANDLE, ACCESS_MASK, HANDLE, LPGUID, POBJECT_ATTRIBUTES );
NTSYSAPI NTSTATUS       NTAPI ZwOpenKeyTransacted( PHANDLE, ACCESS_MASK, POBJECT_ATTRIBUTES, HANDLE );
NTSYSAPI NTSTATUS       NTAPI ZwOpenResourceManager( PHANDLE, ACCESS_MASK, HANDLE, LPGUID, POBJECT_ATTRIBUTES );
NTSYSAPI NTSTATUS       NTAPI ZwOpenTransaction( PHANDLE, ACCESS_MASK, POBJECT_ATTRIBUTES, LPGUID, HANDLE );
NTSYSAPI NTSTATUS       NTAPI ZwOpenTransactionManager( PHANDLE, ACCESS_MASK, POBJECT_ATTRIBUTES, PUNICODE_STRING, LPGUID, ULONG );
NTSYSAPI NTSTATUS       NTAPI ZwPrePrepareComplete( HANDLE, PLARGE_INTEGER );
NTSYSAPI NTSTATUS       NTAPI ZwPrePrepareEnlistment( HANDLE, PLARGE_INTEGER );
NTSYSAPI NTSTATUS       NTAPI ZwPrepareComplete( HANDLE, PLARGE_INTEGER );
NTSYSAPI NTSTATUS       NTAPI ZwPrepareEnlistment( HANDLE, PLARGE_INTEGER );
NTSYSAPI NTSTATUS       NTAPI ZwQueryInformationEnlistment( HANDLE, ENLISTMENT_INFORMATION_CLASS, PVOID, ULONG, PULONG );
NTSYSAPI NTSTATUS       NTAPI ZwQueryInformationResourceManager( HANDLE, RESOURCEMANAGER_INFORMATION_CLASS, PVOID, ULONG, PULONG );
NTSYSAPI NTSTATUS       NTAPI ZwQueryInformationTransaction( HANDLE, TRANSACTION_INFORMATION_CLASS, PVOID, ULONG, PULONG );
NTSYSAPI NTSTATUS       NTAPI ZwQueryInformationTransactionManager( HANDLE, TRANSACTIONMANAGER_INFORMATION_CLASS, PVOID, ULONG, PULONG );
NTSYSAPI NTSTATUS       NTAPI ZwReadOnlyEnlistment( HANDLE, PLARGE_INTEGER );
NTSYSAPI NTSTATUS       NTAPI ZwRecoverEnlistment( HANDLE, PVOID );
NTSYSAPI NTSTATUS       NTAPI ZwRecoverResourceManager( HANDLE );
NTSYSAPI NTSTATUS       NTAPI ZwRecoverTransactionManager( HANDLE );
NTSYSAPI NTSTATUS       NTAPI ZwRollbackComplete( HANDLE, PLARGE_INTEGER );
NTSYSAPI NTSTATUS       NTAPI ZwRollbackEnlistment( HANDLE, PLARGE_INTEGER );
NTSYSAPI NTSTATUS       NTAPI ZwRollbackTransaction( HANDLE, BOOLEAN );
NTSYSAPI NTSTATUS       NTAPI ZwRollforwardTransactionManager( HANDLE, PLARGE_INTEGER );
NTSYSAPI NTSTATUS       NTAPI ZwSetInformationEnlistment( HANDLE, ENLISTMENT_INFORMATION_CLASS, PVOID, ULONG );
NTSYSAPI NTSTATUS       NTAPI ZwSetInformationResourceManager( HANDLE, RESOURCEMANAGER_INFORMATION_CLASS, PVOID, ULONG );
NTSYSAPI NTSTATUS       NTAPI ZwSetInformationTransaction( HANDLE, TRANSACTION_INFORMATION_CLASS, PVOID, ULONG );
NTSYSAPI NTSTATUS       NTAPI ZwSetInformationTransactionManager( HANDLE, TRANSACTIONMANAGER_INFORMATION_CLASS, PVOID, ULONG );
NTSYSAPI NTSTATUS       NTAPI ZwSinglePhaseReject( HANDLE, PLARGE_INTEGER );
#endif
#if (NTDDI_VERSION >= 0x06010000)
NTSYSAPI ULONG64        NTAPI RtlGetEnabledExtendedFeatures( ULONG64 );
NTSYSAPI NTSTATUS       NTAPI RtlUTF8ToUnicodeN( PWSTR, ULONG, PULONG, PCCH, ULONG );
NTSYSAPI NTSTATUS       NTAPI RtlUnicodeToUTF8N( PCHAR, ULONG, PULONG, PCWCH, ULONG );
NTSYSAPI NTSTATUS       NTAPI ZwNotifyChangeMultipleKeys( HANDLE, ULONG, OBJECT_ATTRIBUTES [], HANDLE, PIO_APC_ROUTINE, PVOID, PIO_STATUS_BLOCK, ULONG, BOOLEAN, PVOID, ULONG, BOOLEAN );
NTSYSAPI NTSTATUS       NTAPI ZwOpenKeyEx( PHANDLE, ACCESS_MASK, POBJECT_ATTRIBUTES, ULONG );
NTSYSAPI NTSTATUS       NTAPI ZwOpenKeyTransactedEx( PHANDLE, ACCESS_MASK, POBJECT_ATTRIBUTES, ULONG, HANDLE );
NTSYSAPI NTSTATUS       NTAPI ZwQueryMultipleValueKey( HANDLE, PKEY_VALUE_ENTRY, ULONG, PVOID, PULONG, PULONG );
NTSYSAPI NTSTATUS       NTAPI ZwRenameKey( HANDLE, PUNICODE_STRING );
NTSYSAPI NTSTATUS       NTAPI ZwSetInformationKey( HANDLE, KEY_SET_INFORMATION_CLASS, PVOID, ULONG );
#endif

/* System call functions in NTOSKRNL.EXE and NTDLL.DLL */
#if (NTDDI_VERSION >= 0x06000000)
NTSYSCALLAPI NTSTATUS   NTAPI NtCommitComplete( HANDLE, PLARGE_INTEGER );
NTSYSCALLAPI NTSTATUS   NTAPI NtCommitEnlistment( HANDLE, PLARGE_INTEGER );
NTSYSCALLAPI NTSTATUS   NTAPI NtCommitTransaction( HANDLE, BOOLEAN );
NTSYSCALLAPI NTSTATUS   NTAPI NtCreateEnlistment( PHANDLE, ACCESS_MASK, HANDLE, HANDLE, POBJECT_ATTRIBUTES, ULONG, NOTIFICATION_MASK, PVOID );
NTSYSCALLAPI NTSTATUS   NTAPI NtCreateResourceManager( PHANDLE, ACCESS_MASK, HANDLE, LPGUID, POBJECT_ATTRIBUTES, ULONG, PUNICODE_STRING );
NTSYSCALLAPI NTSTATUS   NTAPI NtCreateTransaction( PHANDLE, ACCESS_MASK, POBJECT_ATTRIBUTES, LPGUID, HANDLE, ULONG, ULONG, ULONG, PLARGE_INTEGER, PUNICODE_STRING );
NTSYSCALLAPI NTSTATUS   NTAPI NtCreateTransactionManager( PHANDLE, ACCESS_MASK, POBJECT_ATTRIBUTES, PUNICODE_STRING, ULONG, ULONG );
NTSYSCALLAPI NTSTATUS   NTAPI NtEnumerateTransactionObject( HANDLE, KTMOBJECT_TYPE, PKTMOBJECT_CURSOR, ULONG, PULONG );
NTSYSCALLAPI NTSTATUS   NTAPI NtGetNotificationResourceManager( HANDLE, PTRANSACTION_NOTIFICATION, ULONG, PLARGE_INTEGER, PULONG, ULONG, ULONG_PTR );
NTSYSCALLAPI NTSTATUS   NTAPI NtOpenEnlistment( PHANDLE, ACCESS_MASK, HANDLE, LPGUID, POBJECT_ATTRIBUTES );
NTSYSCALLAPI NTSTATUS   NTAPI NtOpenResourceManager( PHANDLE, ACCESS_MASK, HANDLE, LPGUID, POBJECT_ATTRIBUTES );
NTSYSCALLAPI NTSTATUS   NTAPI NtOpenTransaction( PHANDLE, ACCESS_MASK, POBJECT_ATTRIBUTES, LPGUID, HANDLE );
NTSYSCALLAPI NTSTATUS   NTAPI NtOpenTransactionManager( PHANDLE, ACCESS_MASK, POBJECT_ATTRIBUTES, PUNICODE_STRING, LPGUID, ULONG );
NTSYSCALLAPI NTSTATUS   NTAPI NtPrePrepareComplete( HANDLE, PLARGE_INTEGER );
NTSYSCALLAPI NTSTATUS   NTAPI NtPrePrepareEnlistment( HANDLE, PLARGE_INTEGER );
NTSYSCALLAPI NTSTATUS   NTAPI NtPrepareComplete( HANDLE, PLARGE_INTEGER );
NTSYSCALLAPI NTSTATUS   NTAPI NtPrepareEnlistment( HANDLE, PLARGE_INTEGER );
NTSYSCALLAPI NTSTATUS   NTAPI NtPropagationComplete( HANDLE, ULONG, ULONG, PVOID );
NTSYSCALLAPI NTSTATUS   NTAPI NtPropagationFailed( HANDLE, ULONG, NTSTATUS );
NTSYSCALLAPI NTSTATUS   NTAPI NtPullTransaction( PHANDLE, POBJECT_ATTRIBUTES, ACCESS_MASK, ULONG, PCRM_PROTOCOL_ID, ULONG, PVOID );
NTSYSCALLAPI NTSTATUS   NTAPI NtQueryInformationEnlistment( HANDLE, ENLISTMENT_INFORMATION_CLASS, PVOID, ULONG, PULONG );
NTSYSCALLAPI NTSTATUS   NTAPI NtQueryInformationResourceManager( HANDLE, RESOURCEMANAGER_INFORMATION_CLASS, PVOID, ULONG, PULONG );
NTSYSCALLAPI NTSTATUS   NTAPI NtQueryInformationTransaction( HANDLE, TRANSACTION_INFORMATION_CLASS, PVOID, ULONG, PULONG );
NTSYSCALLAPI NTSTATUS   NTAPI NtQueryInformationTransactionManager( HANDLE, TRANSACTIONMANAGER_INFORMATION_CLASS, PVOID, ULONG, PULONG );
NTSYSCALLAPI NTSTATUS   NTAPI NtReadOnlyEnlistment( HANDLE, PLARGE_INTEGER );
NTSYSCALLAPI NTSTATUS   NTAPI NtRecoverEnlistment( HANDLE, PVOID );
NTSYSCALLAPI NTSTATUS   NTAPI NtRecoverResourceManager( HANDLE );
NTSYSCALLAPI NTSTATUS   NTAPI NtRecoverTransactionManager( HANDLE );
NTSYSCALLAPI NTSTATUS   NTAPI NtRegisterProtocolAddressInformation( HANDLE, PCRM_PROTOCOL_ID, ULONG, PVOID, ULONG );
NTSYSCALLAPI NTSTATUS   NTAPI NtRenameTransactionManager( PUNICODE_STRING, LPGUID );
NTSYSCALLAPI NTSTATUS   NTAPI NtReadOnlyEnlistment( HANDLE, PLARGE_INTEGER );
NTSYSCALLAPI NTSTATUS   NTAPI NtRollbackEnlistment( HANDLE, PLARGE_INTEGER );
NTSYSCALLAPI NTSTATUS   NTAPI NtRollbackTransaction( HANDLE, BOOLEAN );
NTSYSCALLAPI NTSTATUS   NTAPI NtRollforwardTransactionManager( HANDLE, PLARGE_INTEGER );
NTSYSCALLAPI NTSTATUS   NTAPI NtSetInformationEnlistment( HANDLE, ENLISTMENT_INFORMATION_CLASS, PVOID, ULONG );
NTSYSCALLAPI NTSTATUS   NTAPI NtSetInformationResourceManager( HANDLE, RESOURCEMANAGER_INFORMATION_CLASS, PVOID, ULONG );
NTSYSCALLAPI NTSTATUS   NTAPI NtSetInformationTransaction( HANDLE, TRANSACTION_INFORMATION_CLASS, PVOID, ULONG );
NTSYSCALLAPI NTSTATUS   NTAPI NtSetInformationTransactionManager( HANDLE, TRANSACTIONMANAGER_INFORMATION_CLASS, PVOID, ULONG );
NTSYSCALLAPI NTSTATUS   NTAPI NtSinglePhaseReject( HANDLE, PLARGE_INTEGER );
#endif

/* Functions in RTLVER.LIB */
BOOLEAN                 NTAPI WdmlibRtlIsNtDdiVersionAvailable( ULONG );
BOOLEAN                 NTAPI WdmlibRtlIsServicePackVersionInstalled( ULONG );

/* Functions in NTOSKRNL.EXE */
NTKERNELAPI NTSTATUS    NTAPI EmClientQueryRuleState( LPCGUID, PEM_RULE_STATE );
NTKERNELAPI VOID        NTAPI EmClientRuleDeregisterNotification( PVOID );
NTKERNELAPI NTSTATUS    NTAPI EmClientRuleEvaluate( LPCGUID, EM_ENTRY_DATA **, ULONG, PEM_RULE_STATE );
NTKERNELAPI NTSTATUS    NTAPI EmClientRuleRegisterNotification( PDRIVER_OBJECT, PEM_CLIENT_NOTIFICATION_REGISTRATION, ULONG, PVOID * );
NTKERNELAPI VOID        NTAPI EmProviderDeregister( PVOID );
NTKERNELAPI VOID        NTAPI EmProviderDeregisterEntry( PVOID );
NTKERNELAPI NTSTATUS    NTAPI EmProviderRegister( PDRIVER_OBJECT, PEM_ENTRY_REGISTRATION, ULONG, PEM_CALLBACK_REGISTRATION, ULONG, PVOID * );
NTKERNELAPI NTSTATUS    NTAPI EmProviderRegisterEntry( PVOID, LPCGUID, PEM_ENTRY_DATA, PVOID * );
NTKERNELAPI PSLIST_ENTRY FASTCALL ExInterlockedFlushSList( PSLIST_HEADER );
NTKERNELAPI PSLIST_ENTRY FASTCALL InterlockedPopEntrySList( PSLIST_HEADER );
NTKERNELAPI PSLIST_ENTRY FASTCALL InterlockedPushEntrySList( PSLIST_HEADER, PSLIST_ENTRY );
NTKERNELAPI VOID        NTAPI IoGetStackLimits( PULONG_PTR, PULONG_PTR );
NTKERNELAPI VOID        NTAPI KeClearEvent( PRKEVENT );
NTKERNELAPI PKTHREAD    NTAPI KeGetCurrentThread( VOID );
NTKERNELAPI ULONG       NTAPI KeGetProcessorIndexFromNumber( PPROCESSOR_NUMBER );
NTKERNELAPI NTSTATUS    NTAPI KeGetProcessorNumberFromIndex( ULONG, PPROCESSOR_NUMBER );
NTKERNELAPI VOID        NTAPI KeInitializeEvent( PRKEVENT, EVENT_TYPE, BOOLEAN );
NTKERNELAPI NTSTATUS    NTAPI PsWrapApcWow64Thread( PVOID *, PVOID * );
NTKERNELAPI NTSTATUS    NTAPI TmCommitComplete( PKENLISTMENT, PLARGE_INTEGER );
NTKERNELAPI NTSTATUS    NTAPI TmCommitEnlistment( PKENLISTMENT, PLARGE_INTEGER );
NTKERNELAPI NTSTATUS    NTAPI TmCommitTransaction( PKTRANSACTION, BOOLEAN );
NTKERNELAPI NTSTATUS    NTAPI TmCreateEnlistment( PHANDLE, KPROCESSOR_MODE, ACCESS_MASK, POBJECT_ATTRIBUTES, PRKRESOURCEMANAGER, PKTRANSACTION, ULONG, NOTIFICATION_MASK, PVOID );
NTKERNELAPI NTSTATUS    NTAPI TmDereferenceEnlistmentKey( PKENLISTMENT, PBOOLEAN );
NTKERNELAPI NTSTATUS    NTAPI TmEnableCallbacks( PKRESOURCEMANAGER, PTM_RM_NOTIFICATION, PVOID );
NTKERNELAPI VOID        NTAPI TmGetTransactionId( PKTRANSACTION, PUOW );
NTKERNELAPI BOOLEAN     NTAPI TmIsTransactionActive( PKTRANSACTION );
NTKERNELAPI NTSTATUS    NTAPI TmPrePrepareComplete( PKENLISTMENT, PLARGE_INTEGER );
NTKERNELAPI NTSTATUS    NTAPI TmPrePrepareEnlistment( PKENLISTMENT, PLARGE_INTEGER );
NTKERNELAPI NTSTATUS    NTAPI TmPrepareComplete( PKENLISTMENT, PLARGE_INTEGER );
NTKERNELAPI NTSTATUS    NTAPI TmPrepareEnlistment( PKENLISTMENT, PLARGE_INTEGER );
NTKERNELAPI NTSTATUS    NTAPI TmPropagationComplete( PKRESOURCEMANAGER, ULONG, ULONG, PVOID );
NTKERNELAPI NTSTATUS    NTAPI TmPropagationFailed( PKRESOURCEMANAGER, ULONG, NTSTATUS );
NTKERNELAPI NTSTATUS    NTAPI TmReadOnlyEnlistment( PKENLISTMENT, PLARGE_INTEGER );
NTKERNELAPI NTSTATUS    NTAPI TmRecoverEnlistment( PKENLISTMENT, PVOID );
NTKERNELAPI NTSTATUS    NTAPI TmRecoverResourceManager( PKRESOURCEMANAGER );
NTKERNELAPI NTSTATUS    NTAPI TmRecoverTransactionManager( PKTM, PLARGE_INTEGER );
NTKERNELAPI NTSTATUS    NTAPI TmReferenceEnlistmentKey( PKENLISTMENT, PVOID * );
NTKERNELAPI NTSTATUS    NTAPI TmRequestOutcomeEnlistment( PKENLISTMENT, PLARGE_INTEGER );
NTKERNELAPI NTSTATUS    NTAPI TmRollbackComplete( PKENLISTMENT, PLARGE_INTEGER );
NTKERNELAPI NTSTATUS    NTAPI TmRollbackEnlistment( PKENLISTMENT, PLARGE_INTEGER );
NTKERNELAPI NTSTATUS    NTAPI TmRollbackTransaction( PKTRANSACTION, BOOLEAN );
NTKERNELAPI VOID        NTAPI KeInitializeDpc( PRKDPC, PKDEFERRED_ROUTINE, PVOID );
NTKERNELAPI BOOLEAN     NTAPI KeInsertQueueDpc( PRKDPC, PVOID, PVOID );
NTKERNELAPI BOOLEAN     NTAPI KeRemoveQueueDpc( PRKDPC );
NTKERNELAPI VOID        NTAPI KeSetImportanceDpc( PRKDPC, KDPC_IMPORTANCE );
#ifdef SINGLE_GROUP_LEGACY_API
NTKERNELAPI VOID        NTAPI KeSetTargetProcessorDpc( PRKDPC, CCHAR );
#endif
NTKERNELAPI VOID        NTAPI KeInitializeDeviceQueue( PKDEVICE_QUEUE );
NTKERNELAPI BOOLEAN     NTAPI KeInsertDeviceQueue( PKDEVICE_QUEUE, PKDEVICE_QUEUE_ENTRY );
NTKERNELAPI BOOLEAN     NTAPI KeInsertByKeyDeviceQueue( PKDEVICE_QUEUE, PKDEVICE_QUEUE_ENTRY, ULONG );
NTKERNELAPI PKDEVICE_QUEUE_ENTRY NTAPI KeRemoveDeviceQueue( PKDEVICE_QUEUE );
NTKERNELAPI PKDEVICE_QUEUE_ENTRY NTAPI KeRemoveByKeyDeviceQueue( PKDEVICE_QUEUE, ULONG );
NTKERNELAPI BOOLEAN     NTAPI KeRemoveEntryDeviceQueue( PKDEVICE_QUEUE, PKDEVICE_QUEUE_ENTRY );
NTKERNELAPI BOOLEAN     NTAPI KeSynchronizeExecution( PKINTERRUPT, PKSYNCHRONIZE_ROUTINE, PVOID );
NTKERNELAPI LONG        NTAPI KeReadStateEvent( PRKEVENT );
NTKERNELAPI LONG        NTAPI KeResetEvent( PRKEVENT );
NTKERNELAPI LONG        NTAPI KeSetEvent( PRKEVENT, KPRIORITY, BOOLEAN );
NTKERNELAPI VOID        NTAPI KeInitializeMutex( PRKMUTEX, ULONG );
NTKERNELAPI LONG        NTAPI KeReleaseMutex( PRKMUTEX, BOOLEAN );
NTKERNELAPI VOID        NTAPI KeInitializeSemaphore( PRKSEMAPHORE, LONG, LONG );
NTKERNELAPI LONG        NTAPI KeReadStateSemaphore( PRKSEMAPHORE );
NTKERNELAPI LONG        NTAPI KeReleaseSemaphore( PRKSEMAPHORE, KPRIORITY, LONG, BOOLEAN );
NTKERNELAPI NTSTATUS    NTAPI KeDelayExecutionThread( KPROCESSOR_MODE, BOOLEAN, PLARGE_INTEGER );
NTKERNELAPI KPRIORITY   NTAPI KeSetPriorityThread( PKTHREAD, KPRIORITY );
NTKERNELAPI VOID        NTAPI KeEnterCriticalRegion( VOID );
NTKERNELAPI VOID        NTAPI KeLeaveCriticalRegion( VOID );
NTKERNELAPI VOID        NTAPI KeInitializeTimer( PKTIMER );
NTKERNELAPI VOID        NTAPI KeInitializeTimerEx( PKTIMER, TIMER_TYPE );
NTKERNELAPI BOOLEAN     NTAPI KeCancelTimer( PKTIMER );
NTKERNELAPI BOOLEAN     NTAPI KeReadStateTimer( PKTIMER );
NTKERNELAPI BOOLEAN     NTAPI KeSetTimer( PKTIMER, LARGE_INTEGER, PKDPC );
NTKERNELAPI BOOLEAN     NTAPI KeSetTimerEx( PKTIMER, LARGE_INTEGER, LONG, PKDPC );
NTKERNELAPI NTSTATUS    NTAPI KeWaitForMultipleObjects( ULONG, PVOID [], WAIT_TYPE, KWAIT_REASON, KPROCESSOR_MODE, BOOLEAN, PLARGE_INTEGER, PKWAIT_BLOCK );
NTKERNELAPI NTSTATUS    NTAPI KeWaitForSingleObject( PVOID, KWAIT_REASON, KPROCESSOR_MODE, BOOLEAN, PLARGE_INTEGER );
NTKERNELAPI DECLSPEC_NORETURN VOID NTAPI KeBugCheckEx( ULONG, ULONG_PTR, ULONG_PTR, ULONG_PTR, ULONG_PTR );
NTKERNELAPI BOOLEAN     NTAPI KeDeregisterBugCheckCallback( PKBUGCHECK_CALLBACK_RECORD );
NTKERNELAPI BOOLEAN     NTAPI KeRegisterBugCheckCallback( PKBUGCHECK_CALLBACK_RECORD, PKBUGCHECK_CALLBACK_ROUTINE, PVOID, ULONG, PUCHAR );
NTKERNELAPI VOID        NTAPI KeQuerySystemTime( PLARGE_INTEGER );
NTKERNELAPI ULONG       NTAPI KeQueryTimeIncrement( VOID );
NTKERNELAPI PVOID       NTAPI ExAllocatePool( POOL_TYPE, SIZE_T );
NTKERNELAPI PVOID       NTAPI ExAllocatePoolWithQuota( POOL_TYPE, SIZE_T );
NTKERNELAPI PVOID       NTAPI ExAllocatePoolWithQuotaTag( POOL_TYPE, SIZE_T, ULONG );
NTKERNELAPI PVOID       NTAPI ExAllocatePoolWithTag( POOL_TYPE, SIZE_T, ULONG );
NTKERNELAPI VOID        NTAPI ExFreePool( PVOID );
NTKERNELAPI VOID        FASTCALL ExAcquireFastMutexUnsafe( PFAST_MUTEX );
NTKERNELAPI VOID        FASTCALL ExReleaseFastMutexUnsafe( PFAST_MUTEX );
NTKERNELAPI BOOLEAN     FASTCALL ExTryToAcquireFastMutex( PFAST_MUTEX );
NTKERNELAPI ULONG       FASTCALL ExInterlockedAddUlong( PULONG, ULONG, PKSPIN_LOCK );
NTKERNELAPI PLIST_ENTRY FASTCALL ExInterlockedInsertHeadList( PLIST_ENTRY, PLIST_ENTRY, PKSPIN_LOCK );
NTKERNELAPI PLIST_ENTRY FASTCALL ExInterlockedInsertTailList( PLIST_ENTRY, PLIST_ENTRY, PKSPIN_LOCK );
NTKERNELAPI PLIST_ENTRY FASTCALL ExInterlockedRemoveHeadList( PLIST_ENTRY, PKSPIN_LOCK );
NTKERNELAPI PSINGLE_LIST_ENTRY FASTCALL ExInterlockedPopEntryList( PSINGLE_LIST_ENTRY, PKSPIN_LOCK );
NTKERNELAPI PSINGLE_LIST_ENTRY FASTCALL ExInterlockedPushEntryList( PSINGLE_LIST_ENTRY, PSINGLE_LIST_ENTRY, PKSPIN_LOCK );
#ifdef _X86_
NTKERNELAPI PVOID       NTAPI ExAllocateFromPagedLookasideList( PPAGED_LOOKASIDE_LIST );
NTKERNELAPI VOID        NTAPI ExFreeToPagedLookasideList( PPAGED_LOOKASIDE_LIST, PVOID );
NTKERNELAPI LONGLONG    FASTCALL ExfInterlockedCompareExchange64( LONGLONG volatile *, PLONGLONG, PLONGLONG );
NTKERNELAPI LONG        FASTCALL InterlockedCompareExchange( LONG volatile *, LONG, LONG );
NTKERNELAPI LONG        FASTCALL InterlockedDecrement( LONG volatile * );
NTKERNELAPI LONG        FASTCALL InterlockedExchange( LONG volatile *, LONG );
NTKERNELAPI LONG        FASTCALL InterlockedExchangeAdd( LONG volatile *, LONG );
NTKERNELAPI LONG        FASTCALL InterlockedIncrement( LONG volatile * );
NTKERNELAPI NTSTATUS    NTAPI KeRestoreFloatingPointState( PKFLOATING_SAVE );
NTKERNELAPI NTSTATUS    NTAPI KeSaveFloatingPointState( PKFLOATING_SAVE );
NTKERNELAPI VOID        NTAPI READ_REGISTER_BUFFER_UCHAR( PUCHAR, PUCHAR, ULONG );
NTKERNELAPI VOID        NTAPI READ_REGISTER_BUFFER_ULONG( PULONG, PULONG, ULONG );
NTKERNELAPI VOID        NTAPI READ_REGISTER_BUFFER_USHORT( PUSHORT, PUSHORT, ULONG );
NTKERNELAPI UCHAR       NTAPI READ_REGISTER_UCHAR( PUCHAR );
NTKERNELAPI ULONG       NTAPI READ_REGISTER_ULONG( PULONG );
NTKERNELAPI USHORT      NTAPI READ_REGISTER_USHORT( PUSHORT );
NTKERNELAPI VOID        NTAPI WRITE_REGISTER_BUFFER_UCHAR( PUCHAR, PUCHAR, ULONG );
NTKERNELAPI VOID        NTAPI WRITE_REGISTER_BUFFER_ULONG( PULONG, PULONG, ULONG );
NTKERNELAPI VOID        NTAPI WRITE_REGISTER_BUFFER_USHORT( PUSHORT, PUSHORT, ULONG );
NTKERNELAPI VOID        NTAPI WRITE_REGISTER_UCHAR( PUCHAR, UCHAR );
NTKERNELAPI VOID        NTAPI WRITE_REGISTER_ULONG( PULONG, ULONG );
NTKERNELAPI VOID        NTAPI WRITE_REGISTER_USHORT( PUSHORT, USHORT );
NTKERNELAPI VOID        NTAPI KeInitializeSpinLock( PKSPIN_LOCK );
NTKERNELAPI VOID        FASTCALL KefAcquireSpinLockAtDpcLevel( PKSPIN_LOCK );
NTKERNELAPI VOID        FASTCALL KefReleaseSpinLockFromDpcLevel( PKSPIN_LOCK );
NTHALAPI KIRQL          FASTCALL KfAcquireSpinLock( PKSPIN_LOCK );
NTHALAPI VOID           FASTCALL KfReleaseSpinLock( PKSPIN_LOCK, KIRQL );
#endif
#ifdef _X86_
NTKERNELAPI PSLIST_ENTRY FASTCALL ExInterlockedPopEntrySList( PSLIST_HEADER, PKSPIN_LOCK );
NTKERNELAPI PSLIST_ENTRY FASTCALL ExInterlockedPushEntrySList( PSLIST_HEADER, PSLIST_ENTRY, PKSPIN_LOCK );
#else
#define ExInterlockedPopEntrySList(Head, Lock) \
    ExpInterlockedPopEntrySList(Head)
#define ExInterlockedPushEntrySList(Head, Entry, Lock) \
    ExpInterlockedPushEntrySList(Head, Entry)
NTKERNELAPI PSLIST_ENTRY FASTCALL ExpInterlockedPopEntrySList( PSLIST_HEADER );
NTKERNELAPI PSLIST_ENTRY FASTCALL ExpInterlockedPushEntrySList( PSLIST_HEADER, PSLIST_ENTRY );
#endif
#if (NTDDI_VERSION >= 0x05000000)
NTKERNELAPI BOOLEAN     NTAPI ExAcquireResourceExclusiveLite( PERESOURCE, BOOLEAN );
NTKERNELAPI BOOLEAN     NTAPI ExAcquireResourceSharedLite( PERESOURCE, BOOLEAN );
NTKERNELAPI BOOLEAN     NTAPI ExAcquireSharedStarveExclusive( PERESOURCE, BOOLEAN );
NTKERNELAPI BOOLEAN     NTAPI ExAcquireSharedWaitForExclusive( PERESOURCE, BOOLEAN );
NTKERNELAPI PVOID       NTAPI ExAllocatePoolWithTagPriority( POOL_TYPE, SIZE_T, ULONG, EX_POOL_PRIORITY );
NTKERNELAPI VOID        NTAPI ExConvertExclusiveToSharedLite( PERESOURCE );
NTKERNELAPI NTSTATUS    NTAPI ExCreateCallback( PCALLBACK_OBJECT *, POBJECT_ATTRIBUTES, BOOLEAN, BOOLEAN );
NTKERNELAPI VOID        NTAPI ExDeleteNPagedLookasideList( PNPAGED_LOOKASIDE_LIST );
NTKERNELAPI VOID        NTAPI ExDeletePagedLookasideList( PPAGED_LOOKASIDE_LIST );
NTKERNELAPI NTSTATUS    NTAPI ExDeleteResourceLite( PERESOURCE );
NTKERNELAPI VOID        NTAPI ExFreePoolWithTag( PVOID, ULONG );
NTKERNELAPI ULONG       NTAPI ExGetExclusiveWaiterCount( PERESOURCE );
NTKERNELAPI KPROCESSOR_MODE NTAPI ExGetPreviousMode( VOID );
NTKERNELAPI ULONG       NTAPI ExGetSharedWaiterCount( PERESOURCE );
NTKERNELAPI VOID        NTAPI ExInitializeNPagedLookasideList( PNPAGED_LOOKASIDE_LIST, PALLOCATE_FUNCTION, PFREE_FUNCTION, ULONG, SIZE_T, ULONG, USHORT );
NTKERNELAPI VOID        NTAPI ExInitializePagedLookasideList( PPAGED_LOOKASIDE_LIST, PALLOCATE_FUNCTION, PFREE_FUNCTION, ULONG, SIZE_T, ULONG, USHORT );
NTKERNELAPI NTSTATUS    NTAPI ExInitializeResourceLite( PERESOURCE );
NTKERNELAPI LARGE_INTEGER NTAPI ExInterlockedAddLargeInteger( PLARGE_INTEGER, LARGE_INTEGER, PKSPIN_LOCK );
NTKERNELAPI BOOLEAN     NTAPI ExIsProcessorFeaturePresent( ULONG );
NTKERNELAPI BOOLEAN     NTAPI ExIsResourceAcquiredExclusiveLite( PERESOURCE );
NTKERNELAPI ULONG       NTAPI ExIsResourceAcquiredSharedLite( PERESOURCE );
NTKERNELAPI VOID        NTAPI ExLocalTimeToSystemTime( PLARGE_INTEGER, PLARGE_INTEGER );
NTKERNELAPI VOID        NTAPI ExNotifyCallback( PVOID, PVOID, PVOID );
NTKERNELAPI VOID        NTAPI ExQueueWorkItem( PWORK_QUEUE_ITEM, WORK_QUEUE_TYPE );
NTKERNELAPI DECLSPEC_NORETURN VOID NTAPI ExRaiseStatus( NTSTATUS );
NTKERNELAPI PVOID       NTAPI ExRegisterCallback( PCALLBACK_OBJECT, PCALLBACK_FUNCTION, PVOID );
NTKERNELAPI NTSTATUS    NTAPI ExReinitializeResourceLite( PERESOURCE );
NTKERNELAPI VOID        NTAPI ExReleaseResourceForThreadLite( PERESOURCE, ERESOURCE_THREAD );
NTKERNELAPI VOID        FASTCALL ExReleaseResourceLite( PERESOURCE );
NTKERNELAPI VOID        NTAPI ExSetResourceOwnerPointer( PERESOURCE, PVOID );
NTKERNELAPI ULONG       NTAPI ExSetTimerResolution( ULONG, BOOLEAN );
NTKERNELAPI VOID        NTAPI ExSystemTimeToLocalTime( PLARGE_INTEGER, PLARGE_INTEGER );
NTKERNELAPI VOID        NTAPI ExUnregisterCallback( PVOID );
NTKERNELAPI VOID        NTAPI IoAcquireCancelSpinLock( PKIRQL );
NTKERNELAPI NTSTATUS    NTAPI IoAcquireRemoveLockEx( PIO_REMOVE_LOCK, PVOID, PCSTR, ULONG, ULONG );
NTKERNELAPI NTSTATUS    NTAPI IoAllocateDriverObjectExtension( PDRIVER_OBJECT, PVOID, ULONG, PVOID * );
NTKERNELAPI PVOID       NTAPI IoAllocateErrorLogEntry( PVOID, UCHAR );
NTKERNELAPI PIRP        NTAPI IoAllocateIrp( CCHAR, BOOLEAN );
NTKERNELAPI PMDL        NTAPI IoAllocateMdl( PVOID, ULONG, BOOLEAN, BOOLEAN, PIRP );
NTKERNELAPI PIO_WORKITEM NTAPI IoAllocateWorkItem( PDEVICE_OBJECT );
NTKERNELAPI NTSTATUS    NTAPI IoAttachDevice( PDEVICE_OBJECT, PUNICODE_STRING, PDEVICE_OBJECT * );
NTKERNELAPI PDEVICE_OBJECT NTAPI IoAttachDeviceToDeviceStack( PDEVICE_OBJECT, PDEVICE_OBJECT );
NTKERNELAPI PIRP        NTAPI IoBuildAsynchronousFsdRequest( ULONG, PDEVICE_OBJECT, PVOID, ULONG, PLARGE_INTEGER, PIO_STATUS_BLOCK );
NTKERNELAPI PIRP        NTAPI IoBuildDeviceIoControlRequest( ULONG, PDEVICE_OBJECT, PVOID, ULONG, PVOID, ULONG, BOOLEAN, PKEVENT, PIO_STATUS_BLOCK );
NTKERNELAPI VOID        NTAPI IoBuildPartialMdl( PMDL, PMDL, PVOID, ULONG );
NTKERNELAPI PIRP        NTAPI IoBuildSynchronousFsdRequest( ULONG, PDEVICE_OBJECT, PVOID, ULONG, PLARGE_INTEGER, PKEVENT, PIO_STATUS_BLOCK );
NTKERNELAPI BOOLEAN     NTAPI IoCancelIrp( PIRP );
NTKERNELAPI NTSTATUS    NTAPI IoCheckShareAccess( ACCESS_MASK, ULONG, PFILE_OBJECT, PSHARE_ACCESS, BOOLEAN );
NTKERNELAPI NTSTATUS    NTAPI IoConnectInterrupt( PKINTERRUPT *, PKSERVICE_ROUTINE, PVOID, PKSPIN_LOCK, ULONG, KIRQL, KIRQL, KINTERRUPT_MODE, BOOLEAN, KAFFINITY, BOOLEAN );
NTKERNELAPI NTSTATUS    NTAPI IoCreateDevice( PDRIVER_OBJECT, ULONG, PUNICODE_STRING, DEVICE_TYPE, ULONG, BOOLEAN, PDEVICE_OBJECT * );
NTKERNELAPI NTSTATUS    NTAPI IoCreateFile( PHANDLE, ACCESS_MASK, POBJECT_ATTRIBUTES, PIO_STATUS_BLOCK, PLARGE_INTEGER, ULONG, ULONG, ULONG, ULONG, PVOID, ULONG, CREATE_FILE_TYPE, PVOID, ULONG );
NTKERNELAPI PKEVENT     NTAPI IoCreateNotificationEvent( PUNICODE_STRING, PHANDLE );
NTKERNELAPI NTSTATUS    NTAPI IoCreateSymbolicLink( PUNICODE_STRING, PUNICODE_STRING );
NTKERNELAPI PKEVENT     NTAPI IoCreateSynchronizationEvent( PUNICODE_STRING, PHANDLE );
NTKERNELAPI NTSTATUS    NTAPI IoCreateUnprotectedSymbolicLink( PUNICODE_STRING, PUNICODE_STRING );
NTKERNELAPI VOID        NTAPI IoDeleteDevice( PDEVICE_OBJECT );
NTKERNELAPI NTSTATUS    NTAPI IoDeleteSymbolicLink( PUNICODE_STRING );
NTKERNELAPI VOID        NTAPI IoDetachDevice( PDEVICE_OBJECT );
NTKERNELAPI VOID        NTAPI IoDisconnectInterrupt( PKINTERRUPT );
NTKERNELAPI VOID        NTAPI IoFreeIrp( PIRP );
NTKERNELAPI VOID        NTAPI IoFreeMdl( PMDL );
NTKERNELAPI VOID        NTAPI IoFreeWorkItem( PIO_WORKITEM );
NTKERNELAPI PDEVICE_OBJECT NTAPI IoGetAttachedDeviceReference( PDEVICE_OBJECT );
NTKERNELAPI NTSTATUS    NTAPI IoGetBootDiskInformation( PBOOTDISK_INFORMATION, ULONG );
NTKERNELAPI PEPROCESS   NTAPI IoGetCurrentProcess( VOID );
NTKERNELAPI NTSTATUS    NTAPI IoGetDeviceInterfaceAlias( PUNICODE_STRING, CONST GUID *, PUNICODE_STRING );
NTKERNELAPI NTSTATUS    NTAPI IoGetDeviceInterfaces( CONST GUID *, PDEVICE_OBJECT, ULONG, PWSTR * );
NTKERNELAPI NTSTATUS    NTAPI IoGetDeviceObjectPointer( PUNICODE_STRING, ACCESS_MASK, PFILE_OBJECT *, PDEVICE_OBJECT * );
NTKERNELAPI NTSTATUS    NTAPI IoGetDeviceProperty( PDEVICE_OBJECT, DEVICE_REGISTRY_PROPERTY, ULONG, PVOID, PULONG );
NTKERNELAPI struct _DMA_ADAPTER * NTAPI IoGetDmaAdapter( PDEVICE_OBJECT, struct _DEVICE_DESCRIPTION *, PULONG );
NTKERNELAPI PVOID       NTAPI IoGetDriverObjectExtension( PDRIVER_OBJECT, PVOID );
NTKERNELAPI PVOID       NTAPI IoGetInitialStack( VOID );
NTKERNELAPI PDEVICE_OBJECT NTAPI IoGetRelatedDeviceObject( PFILE_OBJECT );
NTKERNELAPI PIRP        NTAPI IoGetTopLevelIrp( VOID );
NTKERNELAPI VOID        NTAPI IoInitializeIrp( PIRP, USHORT, CCHAR );
NTKERNELAPI VOID        NTAPI IoInitializeRemoveLockEx( PIO_REMOVE_LOCK, ULONG, ULONG, ULONG, ULONG );
NTKERNELAPI NTSTATUS    NTAPI IoInitializeTimer( PDEVICE_OBJECT, PIO_TIMER_ROUTINE, PVOID );
NTKERNELAPI VOID        NTAPI IoInvalidateDeviceRelations( PDEVICE_OBJECT, DEVICE_RELATION_TYPE );
NTKERNELAPI VOID        NTAPI IoInvalidateDeviceState( PDEVICE_OBJECT );
NTKERNELAPI BOOLEAN     NTAPI IoIsWdmVersionAvailable( UCHAR, UCHAR );
NTKERNELAPI NTSTATUS    NTAPI IoOpenDeviceInterfaceRegistryKey( PUNICODE_STRING, ACCESS_MASK, PHANDLE );
NTKERNELAPI NTSTATUS    NTAPI IoOpenDeviceRegistryKey( PDEVICE_OBJECT, ULONG, ACCESS_MASK, PHANDLE );
NTKERNELAPI VOID        NTAPI IoQueueWorkItem( PIO_WORKITEM, PIO_WORKITEM_ROUTINE, WORK_QUEUE_TYPE, PVOID );
NTKERNELAPI NTSTATUS    NTAPI IoRegisterDeviceInterface( PDEVICE_OBJECT, CONST GUID *, PUNICODE_STRING, PUNICODE_STRING );
NTKERNELAPI NTSTATUS    NTAPI IoRegisterLastChanceShutdownNotification( PDEVICE_OBJECT );
NTKERNELAPI NTSTATUS    NTAPI IoRegisterPlugPlayNotification( IO_NOTIFICATION_EVENT_CATEGORY, ULONG, PVOID, PDRIVER_OBJECT, PDRIVER_NOTIFICATION_CALLBACK_ROUTINE, PVOID, PVOID * );
NTKERNELAPI NTSTATUS    NTAPI IoRegisterShutdownNotification( PDEVICE_OBJECT );
NTKERNELAPI VOID        NTAPI IoReleaseCancelSpinLock( KIRQL );
NTKERNELAPI VOID        NTAPI IoReleaseRemoveLockAndWaitEx( PIO_REMOVE_LOCK, PVOID, ULONG );
NTKERNELAPI VOID        NTAPI IoReleaseRemoveLockEx( PIO_REMOVE_LOCK, PVOID, ULONG );
NTKERNELAPI VOID        NTAPI IoRemoveShareAccess( PFILE_OBJECT, PSHARE_ACCESS );
NTKERNELAPI NTSTATUS    NTAPI IoReportTargetDeviceChange( PDEVICE_OBJECT, PVOID );
NTKERNELAPI NTSTATUS    NTAPI IoReportTargetDeviceChangeAsynchronous( PDEVICE_OBJECT, PVOID, PDEVICE_CHANGE_COMPLETE_CALLBACK, PVOID );
NTKERNELAPI VOID        NTAPI IoRequestDeviceEject( PDEVICE_OBJECT );
NTKERNELAPI VOID        NTAPI IoReuseIrp( PIRP, NTSTATUS );
NTKERNELAPI NTSTATUS    NTAPI IoSetDeviceInterfaceState( PUNICODE_STRING, BOOLEAN );
NTKERNELAPI VOID        NTAPI IoSetShareAccess( ACCESS_MASK, ULONG, PFILE_OBJECT, PSHARE_ACCESS );
NTKERNELAPI VOID        NTAPI IoSetTopLevelIrp( PIRP );
NTKERNELAPI VOID        NTAPI IoStartNextPacket( PDEVICE_OBJECT, BOOLEAN );
NTKERNELAPI VOID        NTAPI IoStartNextPacketByKey( PDEVICE_OBJECT, BOOLEAN, ULONG );
NTKERNELAPI VOID        NTAPI IoStartPacket( PDEVICE_OBJECT, PIRP, PULONG, PDRIVER_CANCEL );
NTKERNELAPI VOID        NTAPI IoStartTimer( PDEVICE_OBJECT );
NTKERNELAPI VOID        NTAPI IoStopTimer( PDEVICE_OBJECT );
NTKERNELAPI NTSTATUS    NTAPI IoUnregisterPlugPlayNotification( PVOID );
NTKERNELAPI VOID        NTAPI IoUnregisterShutdownNotification( PDEVICE_OBJECT );
NTKERNELAPI VOID        NTAPI IoUpdateShareAccess( PFILE_OBJECT, PSHARE_ACCESS );
NTKERNELAPI NTSTATUS    NTAPI IoWMIAllocateInstanceIds( GUID *, ULONG, ULONG * );
NTKERNELAPI NTSTATUS    NTAPI IoWMIQuerySingleInstanceMultiple( PVOID *, PUNICODE_STRING, ULONG, ULONG *, PVOID );
NTKERNELAPI NTSTATUS    NTAPI IoWMIRegistrationControl( PDEVICE_OBJECT, ULONG );
NTKERNELAPI NTSTATUS    NTAPI IoWMISuggestInstanceName( PDEVICE_OBJECT, PUNICODE_STRING, BOOLEAN, PUNICODE_STRING );
NTKERNELAPI NTSTATUS    NTAPI IoWMIWriteEvent( PVOID );
NTKERNELAPI VOID        NTAPI IoWriteErrorLogEntry( PVOID );
NTKERNELAPI NTSTATUS    FASTCALL IofCallDriver( PDEVICE_OBJECT, PIRP );
NTKERNELAPI VOID        FASTCALL IofCompleteRequest( PIRP, CCHAR );
NTKERNELAPI NTSTATUS    NTAPI KdDisableDebugger( VOID );
NTKERNELAPI NTSTATUS    NTAPI KdEnableDebugger( VOID );
NTKERNELAPI ULONGLONG   NTAPI KeQueryInterruptTime( VOID );
NTKERNELAPI KPRIORITY   NTAPI KeQueryPriorityThread( PKTHREAD );
NTKERNELAPI LONG        NTAPI KeReadStateMutex( PRKMUTEX );
NTKERNELAPI PVOID       NTAPI MmAllocateContiguousMemory( SIZE_T, PHYSICAL_ADDRESS );
NTKERNELAPI PVOID       NTAPI MmAllocateContiguousMemorySpecifyCache( SIZE_T, PHYSICAL_ADDRESS, PHYSICAL_ADDRESS, PHYSICAL_ADDRESS, MEMORY_CACHING_TYPE );
NTKERNELAPI PVOID       NTAPI MmAllocateContiguousMemorySpecifyCacheNode( SIZE_T, PHYSICAL_ADDRESS, PHYSICAL_ADDRESS, PHYSICAL_ADDRESS, MEMORY_CACHING_TYPE, NODE_REQUIREMENT );
NTKERNELAPI PMDL        NTAPI MmAllocatePagesForMdl( PHYSICAL_ADDRESS, PHYSICAL_ADDRESS, PHYSICAL_ADDRESS, SIZE_T );
NTKERNELAPI VOID        NTAPI MmBuildMdlForNonPagedPool( PMDLX );
NTKERNELAPI PMDL        NTAPI MmCreateMdl( PMDL, PVOID, SIZE_T );
NTKERNELAPI VOID        NTAPI MmFreeContiguousMemory( PVOID );
NTKERNELAPI VOID        NTAPI MmFreeContiguousMemorySpecifyCache( PVOID, SIZE_T, MEMORY_CACHING_TYPE );
NTKERNELAPI VOID        NTAPI MmFreePagesFromMdl( PMDLX );
NTKERNELAPI PVOID       NTAPI MmGetSystemRoutineAddress( PUNICODE_STRING );
NTKERNELAPI LOGICAL     NTAPI MmIsDriverVerifying( struct _DRIVER_OBJECT * );
NTKERNELAPI PVOID       NTAPI MmLockPagableDataSection( PVOID );
NTKERNELAPI PVOID       NTAPI MmMapIoSpace( PHYSICAL_ADDRESS, SIZE_T, MEMORY_CACHING_TYPE );
NTKERNELAPI PVOID       NTAPI MmMapLockedPages( PMDL, KPROCESSOR_MODE );
NTKERNELAPI PVOID       NTAPI MmMapLockedPagesSpecifyCache( PMDLX, KPROCESSOR_MODE, MEMORY_CACHING_TYPE, PVOID, ULONG, MM_PAGE_PRIORITY );
NTKERNELAPI PVOID       NTAPI MmPageEntireDriver( PVOID );
NTKERNELAPI VOID        NTAPI MmProbeAndLockPages( PMDLX, KPROCESSOR_MODE, LOCK_OPERATION );
NTKERNELAPI VOID        NTAPI MmProbeAndLockProcessPages( PMDL, PEPROCESS, KPROCESSOR_MODE, LOCK_OPERATION );
NTKERNELAPI MM_SYSTEMSIZE NTAPI MmQuerySystemSize( VOID );
NTKERNELAPI VOID        NTAPI MmResetDriverPaging( PVOID );
NTKERNELAPI SIZE_T      NTAPI MmSizeOfMdl( PVOID, SIZE_T );
NTKERNELAPI VOID        NTAPI MmUnlockPagableImageSection( PVOID );
NTKERNELAPI VOID        NTAPI MmUnlockPages( PMDLX );
NTKERNELAPI VOID        NTAPI MmUnmapIoSpace( PVOID, SIZE_T );
NTKERNELAPI VOID        NTAPI MmUnmapLockedPages( PVOID, PMDL );
NTKERNELAPI NTSTATUS    NTAPI ObGetObjectSecurity( PVOID, PSECURITY_DESCRIPTOR *, PBOOLEAN );
NTKERNELAPI NTSTATUS    NTAPI ObReferenceObjectByHandle( HANDLE, ACCESS_MASK, POBJECT_TYPE, KPROCESSOR_MODE, PVOID *, POBJECT_HANDLE_INFORMATION );
NTKERNELAPI NTSTATUS    NTAPI ObReferenceObjectByPointer( PVOID, ACCESS_MASK, POBJECT_TYPE, KPROCESSOR_MODE );
NTKERNELAPI VOID        NTAPI ObReleaseObjectSecurity( PSECURITY_DESCRIPTOR, BOOLEAN );
NTKERNELAPI LONG_PTR    FASTCALL ObfDereferenceObject( PVOID );
NTKERNELAPI LONG_PTR    FASTCALL ObfReferenceObject( PVOID );
NTKERNELAPI NTSTATUS    NTAPI PoCallDriver( PDEVICE_OBJECT, PIRP );
NTKERNELAPI PULONG      NTAPI PoRegisterDeviceForIdleDetection( PDEVICE_OBJECT, ULONG, ULONG, DEVICE_POWER_STATE );
NTKERNELAPI PVOID       NTAPI PoRegisterSystemState( PVOID, EXECUTION_STATE );
NTKERNELAPI NTSTATUS    NTAPI PoRequestPowerIrp( PDEVICE_OBJECT, UCHAR, POWER_STATE, PREQUEST_POWER_COMPLETE, PVOID, PIRP * );
NTKERNELAPI POWER_STATE NTAPI PoSetPowerState( PDEVICE_OBJECT, POWER_STATE_TYPE, POWER_STATE );
NTKERNELAPI VOID        NTAPI PoSetSystemState( EXECUTION_STATE );
NTKERNELAPI VOID        NTAPI PoStartNextPowerIrp( PIRP );
NTKERNELAPI VOID        NTAPI PoUnregisterSystemState( PVOID );
NTKERNELAPI VOID        NTAPI ProbeForRead( PVOID, SIZE_T, ULONG );
NTKERNELAPI VOID        NTAPI ProbeForWrite( PVOID, SIZE_T, ULONG );
NTKERNELAPI NTSTATUS    NTAPI PsCreateSystemThread( PHANDLE, ULONG, POBJECT_ATTRIBUTES, HANDLE, PCLIENT_ID, PKSTART_ROUTINE, PVOID );
NTKERNELAPI NTSTATUS    NTAPI PsTerminateSystemThread( NTSTATUS );
NTKERNELAPI BOOLEAN     NTAPI SeAccessCheck( PSECURITY_DESCRIPTOR, PSECURITY_SUBJECT_CONTEXT, BOOLEAN, ACCESS_MASK, ACCESS_MASK, PPRIVILEGE_SET *, PGENERIC_MAPPING, KPROCESSOR_MODE, PACCESS_MASK, PNTSTATUS );
NTKERNELAPI NTSTATUS    NTAPI SeAssignSecurity( PSECURITY_DESCRIPTOR, PSECURITY_DESCRIPTOR, PSECURITY_DESCRIPTOR *, BOOLEAN, PSECURITY_SUBJECT_CONTEXT, PGENERIC_MAPPING, POOL_TYPE );
NTKERNELAPI NTSTATUS    NTAPI SeAssignSecurityEx( PSECURITY_DESCRIPTOR, PSECURITY_DESCRIPTOR, PSECURITY_DESCRIPTOR *, GUID *, BOOLEAN, ULONG, PSECURITY_SUBJECT_CONTEXT, PGENERIC_MAPPING, POOL_TYPE );
NTKERNELAPI VOID        NTAPI SeCaptureSubjectContext( PSECURITY_SUBJECT_CONTEXT );
NTKERNELAPI NTSTATUS    NTAPI SeDeassignSecurity( PSECURITY_DESCRIPTOR * );
NTKERNELAPI VOID        NTAPI SeLockSubjectContext( PSECURITY_SUBJECT_CONTEXT );
NTKERNELAPI VOID        NTAPI SeReleaseSubjectContext( PSECURITY_SUBJECT_CONTEXT );
NTKERNELAPI VOID        NTAPI SeUnlockSubjectContext( PSECURITY_SUBJECT_CONTEXT );
NTKERNELAPI BOOLEAN     NTAPI SeValidSecurityDescriptor( ULONG, PSECURITY_DESCRIPTOR );
#ifdef SINGLE_GROUP_LEGACY_API
NTKERNELAPI ULONG       NTAPI KeQueryActiveProcessorCount( PKAFFINITY );
NTKERNELAPI KAFFINITY   NTAPI KeQueryActiveProcessors( VOID );
NTKERNELAPI VOID        NTAPI KeRevertToUserAffinityThread( VOID );
NTKERNELAPI VOID        NTAPI KeSetSystemAffinityThread( KAFFINITY );
#endif
#endif
#if (NTDDI_VERSION >= 0x05010000)
NTKERNELAPI NTSTATUS    NTAPI CmRegisterCallback( PEX_CALLBACK_FUNCTION, PVOID, PLARGE_INTEGER );
NTKERNELAPI NTSTATUS    NTAPI CmUnRegisterCallback( LARGE_INTEGER );
NTKERNELAPI BOOLEAN     FASTCALL ExAcquireRundownProtection( PEX_RUNDOWN_REF );
NTKERNELAPI VOID        FASTCALL ExInitializeRundownProtection( PEX_RUNDOWN_REF );
NTKERNELAPI VOID        FASTCALL ExReInitializeRundownProtection( PEX_RUNDOWN_REF );
NTKERNELAPI VOID        FASTCALL ExReleaseRundownProtection( PEX_RUNDOWN_REF );
NTKERNELAPI VOID        FASTCALL ExRundownCompleted( PEX_RUNDOWN_REF );
NTKERNELAPI BOOLEAN     NTAPI ExVerifySuite( SUITE_TYPE );
NTKERNELAPI VOID        FASTCALL ExWaitForRundownProtectionRelease( PEX_RUNDOWN_REF );
NTKERNELAPI NTSTATUS    NTAPI IoCsqInitialize( PIO_CSQ, PIO_CSQ_INSERT_IRP, PIO_CSQ_REMOVE_IRP, PIO_CSQ_PEEK_NEXT_IRP, PIO_CSQ_ACQUIRE_LOCK, PIO_CSQ_RELEASE_LOCK, PIO_CSQ_COMPLETE_CANCELED_IRP );
NTKERNELAPI VOID        NTAPI IoCsqInsertIrp( PIO_CSQ, PIRP, PIO_CSQ_IRP_CONTEXT );
NTKERNELAPI PIRP        NTAPI IoCsqRemoveIrp( PIO_CSQ, PIO_CSQ_IRP_CONTEXT );
NTKERNELAPI PIRP        NTAPI IoCsqRemoveNextIrp( PIO_CSQ, PVOID );
NTKERNELAPI BOOLEAN     NTAPI IoForwardIrpSynchronously( PDEVICE_OBJECT, PIRP );
NTKERNELAPI VOID        NTAPI IoFreeErrorLogEntry( PVOID );
NTKERNELAPI NTSTATUS    NTAPI IoSetCompletionRoutineEx( PDEVICE_OBJECT, PIRP, PIO_COMPLETION_ROUTINE, PVOID, BOOLEAN, BOOLEAN, BOOLEAN );
NTKERNELAPI VOID        NTAPI IoSetStartIoAttributes( PDEVICE_OBJECT, BOOLEAN, BOOLEAN );
NTKERNELAPI NTSTATUS    NTAPI IoWMIDeviceObjectToInstanceName( PVOID, PDEVICE_OBJECT, PUNICODE_STRING );
NTKERNELAPI NTSTATUS    NTAPI IoWMIExecuteMethod( PVOID, PUNICODE_STRING, ULONG, ULONG, PULONG, PUCHAR );
NTKERNELAPI NTSTATUS    NTAPI IoWMIHandleToInstanceName( PVOID, HANDLE, PUNICODE_STRING );
NTKERNELAPI NTSTATUS    NTAPI IoWMIOpenBlock( GUID *, ULONG, PVOID * );
NTKERNELAPI NTSTATUS    NTAPI IoWMIQueryAllData( PVOID, ULONG *, PVOID );
NTKERNELAPI NTSTATUS    NTAPI IoWMIQueryAllDataMultiple( PVOID *, ULONG, ULONG *, PVOID );
NTKERNELAPI NTSTATUS    NTAPI IoWMIQuerySingleInstance( PVOID, PUNICODE_STRING, ULONG *, PVOID );
NTKERNELAPI NTSTATUS    NTAPI IoWMISetNotificationCallback( PVOID, WMI_NOTIFICATION_CALLBACK, PVOID );
NTKERNELAPI NTSTATUS    NTAPI IoWMISetSingleInstance( PVOID, PUNICODE_STRING, ULONG, ULONG, PVOID );
NTKERNELAPI NTSTATUS    NTAPI IoWMISetSingleItem( PVOID, PUNICODE_STRING, ULONG, ULONG, ULONG, PVOID );
NTKERNELAPI VOID        FASTCALL KeAcquireInStackQueuedSpinLockAtDpcLevel( PKSPIN_LOCK, PKLOCK_QUEUE_HANDLE );
NTKERNELAPI KIRQL       NTAPI KeAcquireInterruptSpinLock( PKINTERRUPT );
NTKERNELAPI BOOLEAN     NTAPI KeAreApcsDisabled( VOID );
NTKERNELAPI ULONG       NTAPI KeGetRecommendedSharedDataAlignment( VOID );
NTKERNELAPI ULONG       NTAPI KeQueryRuntimeThread( PKTHREAD, PULONG );
NTKERNELAPI PKDEVICE_QUEUE_ENTRY NTAPI KeRemoveByKeyDeviceQueueIfBusy( PKDEVICE_QUEUE, ULONG );
NTKERNELAPI VOID        FASTCALL KeReleaseInStackQueuedSpinLockFromDpcLevel( PKLOCK_QUEUE_HANDLE );
NTKERNELAPI VOID        NTAPI KeReleaseInterruptSpinLock( PKINTERRUPT, KIRQL );
NTKERNELAPI NTSTATUS    NTAPI MmAddVerifierThunks( PVOID, ULONG );
NTKERNELAPI NTSTATUS    NTAPI MmAdvanceMdl( PMDLX, ULONG );
NTKERNELAPI PVOID       NTAPI MmAllocateMappingAddress( SIZE_T, ULONG );
NTKERNELAPI VOID        NTAPI MmFreeMappingAddress( PVOID, ULONG );
NTKERNELAPI NTSTATUS    NTAPI MmIsVerifierEnabled( PULONG );
NTKERNELAPI PVOID       NTAPI MmMapLockedPagesWithReservedMapping( PVOID, ULONG, PMDLX, MEMORY_CACHING_TYPE );
NTKERNELAPI NTSTATUS    NTAPI MmProtectMdlSystemAddress( PMDLX, ULONG );
NTKERNELAPI VOID        NTAPI MmUnmapReservedMapping( PVOID, ULONG, PMDLX );
NTKERNELAPI NTSTATUS    NTAPI WmiQueryTraceInformation( TRACE_INFORMATION_CLASS, PVOID, ULONG, PULONG, PVOID );
#ifdef RUN_WPP
NTKERNELAPI NTSTATUS    __cdecl WmiTraceMessage( TRACEHANDLE, ULONG, LPGUID, USHORT, ... );
NTKERNELAPI NTSTATUS    NTAPI WmiTraceMessageVa( TRACEHANDLE, ULONG, LPGUID, USHORT, va_list );
#endif
#endif
#if (NTDDI_VERSION >= 0x05010100)
NTKERNELAPI NTSTATUS    NTAPI IoValidateDeviceIoControlAccess( PIRP, ULONG );
NTKERNELAPI BOOLEAN     NTAPI KeDeregisterBugCheckReasonCallback( PKBUGCHECK_REASON_CALLBACK_RECORD );
NTKERNELAPI BOOLEAN     NTAPI KeRegisterBugCheckReasonCallback( PKBUGCHECK_REASON_CALLBACK_RECORD, PKBUGCHECK_REASON_CALLBACK_ROUTINE, KBUGCHECK_CALLBACK_REASON, PUCHAR );
#endif
#if (NTDDI_VERSION >= 0x05010200)
NTKERNELAPI BOOLEAN     FASTCALL ExAcquireRundownProtectionEx( PEX_RUNDOWN_REF, ULONG );
NTKERNELAPI VOID        FASTCALL ExReleaseRundownProtectionEx( PEX_RUNDOWN_REF, ULONG );
NTKERNELAPI VOID        NTAPI KeFlushQueuedDpcs( VOID );
#endif
#if (NTDDI_VERSION >= 0x05020000)
NTKERNELAPI NTSTATUS    NTAPI IoCsqInitializeEx( PIO_CSQ, PIO_CSQ_INSERT_IRP_EX, PIO_CSQ_REMOVE_IRP, PIO_CSQ_PEEK_NEXT_IRP, PIO_CSQ_ACQUIRE_LOCK, PIO_CSQ_RELEASE_LOCK, PIO_CSQ_COMPLETE_CANCELED_IRP );
NTKERNELAPI NTSTATUS    NTAPI IoCsqInsertIrpEx( PIO_CSQ, PIRP, PIO_CSQ_IRP_CONTEXT, PVOID );
NTKERNELAPI BOOLEAN     NTAPI KdRefreshDebuggerNotPresent( VOID );
NTKERNELAPI KIRQL       FASTCALL KeAcquireSpinLockForDpc( PKSPIN_LOCK );
NTKERNELAPI NTSTATUS    NTAPI KeDeregisterNmiCallback( PVOID );
NTKERNELAPI ULONG_PTR   NTAPI KeIpiGenericCall( PKIPI_BROADCAST_WORKER, ULONG_PTR );
NTKERNELAPI PVOID       NTAPI KeRegisterNmiCallback( PNMI_CALLBACK, PVOID );
NTKERNELAPI VOID        FASTCALL KeReleaseSpinLockForDpc( PKSPIN_LOCK, KIRQL );
NTKERNELAPI LOGICAL     NTAPI MmIsIoSpaceActive( PHYSICAL_ADDRESS, SIZE_T );
#ifdef _X86_
NTKERNELAPI BOOLEAN     FASTCALL KeTestSpinLock( PKSPIN_LOCK );
#endif
#endif
#if (NTDDI_VERSION >= 0x05020100)
NTKERNELAPI BOOLEAN     FASTCALL ExAcquireRundownProtectionCacheAware( PEX_RUNDOWN_REF_CACHE_AWARE );
NTKERNELAPI BOOLEAN     FASTCALL ExAcquireRundownProtectionCacheAwareEx( PEX_RUNDOWN_REF_CACHE_AWARE, ULONG );
NTKERNELAPI PEX_RUNDOWN_REF_CACHE_AWARE NTAPI ExAllocateCacheAwareRundownProtection( POOL_TYPE, ULONG );
NTKERNELAPI PVOID       NTAPI ExEnterCriticalRegionAndAcquireResourceExclusive( PERESOURCE );
NTKERNELAPI PVOID       NTAPI ExEnterCriticalRegionAndAcquireResourceShared( PERESOURCE );
NTKERNELAPI PVOID       NTAPI ExEnterCriticalRegionAndAcquireSharedWaitForExclusive( PERESOURCE );
NTKERNELAPI VOID        NTAPI ExFreeCacheAwareRundownProtection( PEX_RUNDOWN_REF_CACHE_AWARE );
NTKERNELAPI VOID        NTAPI ExInitializeRundownProtectionCacheAware( PEX_RUNDOWN_REF_CACHE_AWARE, SIZE_T );
NTKERNELAPI VOID        FASTCALL ExReInitializeRundownProtectionCacheAware( PEX_RUNDOWN_REF_CACHE_AWARE );
NTKERNELAPI VOID        FASTCALL ExReleaseResourceAndLeaveCriticalRegion( PERESOURCE );
NTKERNELAPI VOID        FASTCALL ExReleaseRundownProtectionCacheAware( PEX_RUNDOWN_REF_CACHE_AWARE );
NTKERNELAPI VOID        FASTCALL ExReleaseRundownProtectionCacheAwareEx( PEX_RUNDOWN_REF_CACHE_AWARE, ULONG );
NTKERNELAPI VOID        FASTCALL ExRundownCompletedCacheAware( PEX_RUNDOWN_REF_CACHE_AWARE );
NTKERNELAPI SIZE_T      NTAPI ExSizeOfRundownProtectionCacheAware( VOID );
NTKERNELAPI VOID        FASTCALL ExWaitForRundownProtectionReleaseCacheAware( PEX_RUNDOWN_REF_CACHE_AWARE );
NTKERNELAPI NTSTATUS    NTAPI KdChangeOption( KD_OPTION, ULONG, PVOID, ULONG, PVOID, PULONG );
NTKERNELAPI VOID        FASTCALL KeAcquireGuardedMutex( PKGUARDED_MUTEX );
NTKERNELAPI VOID        FASTCALL KeAcquireGuardedMutexUnsafe( PKGUARDED_MUTEX );
NTKERNELAPI BOOLEAN     NTAPI KeAreAllApcsDisabled( VOID );
NTKERNELAPI VOID        NTAPI KeEnterGuardedRegion( VOID );
NTKERNELAPI VOID        FASTCALL KeInitializeGuardedMutex( PKGUARDED_MUTEX );
NTKERNELAPI VOID        NTAPI KeInitializeThreadedDpc( PRKDPC, PKDEFERRED_ROUTINE, PVOID );
NTKERNELAPI VOID        NTAPI KeLeaveGuardedRegion( VOID );
NTKERNELAPI VOID        FASTCALL KeReleaseGuardedMutex( PKGUARDED_MUTEX );
NTKERNELAPI VOID        FASTCALL KeReleaseGuardedMutexUnsafe( PKGUARDED_MUTEX );
NTKERNELAPI BOOLEAN     FASTCALL KeTryToAcquireGuardedMutex( PKGUARDED_MUTEX );
NTKERNELAPI PMDL        NTAPI MmAllocatePagesForMdlEx( PHYSICAL_ADDRESS, PHYSICAL_ADDRESS, PHYSICAL_ADDRESS, SIZE_T, MEMORY_CACHING_TYPE, ULONG );
NTKERNELAPI NTSTATUS    NTAPI SeReportSecurityEvent( ULONG, PUNICODE_STRING, PSID, PSE_ADT_PARAMETER_ARRAY );
NTKERNELAPI NTSTATUS    NTAPI SeSetAuditParameter( PSE_ADT_PARAMETER_ARRAY, SE_ADT_PARAMETER_TYPE, ULONG, PVOID );
#ifdef _X86_
NTKERNELAPI BOOLEAN     FASTCALL KeTryToAcquireSpinLockAtDpcLevel( PKSPIN_LOCK );
#endif
#endif
#if (NTDDI_VERSION >= 0x06000000)
NTKERNELAPI NTSTATUS    NTAPI CmCallbackGetKeyObjectID( PLARGE_INTEGER, PVOID, PULONG_PTR, PCUNICODE_STRING * );
NTKERNELAPI PVOID       NTAPI CmGetBoundTransaction( PLARGE_INTEGER, PVOID );
NTKERNELAPI VOID        NTAPI CmGetCallbackVersion( PULONG, PULONG );
NTKERNELAPI NTSTATUS    NTAPI CmRegisterCallbackEx( PEX_CALLBACK_FUNCTION, PCUNICODE_STRING, PVOID, PVOID, PLARGE_INTEGER, PVOID );
NTKERNELAPI NTSTATUS    NTAPI CmSetCallbackObjectContext( PVOID, PLARGE_INTEGER, PVOID, PVOID * );
NTKERNELAPI NTSTATUS    NTAPI EtwActivityIdControl( ULONG, LPGUID );
NTKERNELAPI BOOLEAN     NTAPI EtwEventEnabled( REGHANDLE, PCEVENT_DESCRIPTOR );
NTKERNELAPI BOOLEAN     NTAPI EtwProviderEnabled( REGHANDLE, UCHAR, ULONGLONG );
NTKERNELAPI NTSTATUS    NTAPI EtwRegister( LPCGUID, PETWENABLECALLBACK, PVOID, PREGHANDLE );
NTKERNELAPI NTSTATUS    NTAPI EtwUnregister( REGHANDLE );
NTKERNELAPI NTSTATUS    NTAPI EtwWrite( REGHANDLE, PCEVENT_DESCRIPTOR, LPCGUID, ULONG, PEVENT_DATA_DESCRIPTOR );
NTKERNELAPI NTSTATUS    NTAPI EtwWriteString( REGHANDLE, UCHAR, ULONGLONG, LPCGUID, PCWSTR );
NTKERNELAPI NTSTATUS    NTAPI EtwWriteTransfer( REGHANDLE, PCEVENT_DESCRIPTOR, LPCGUID, LPCGUID, ULONG, PEVENT_DATA_DESCRIPTOR );
NTKERNELAPI VOID        NTAPI ExDeleteLookasideListEx( PLOOKASIDE_LIST_EX );
NTKERNELAPI VOID        NTAPI ExFlushLookasideListEx( PLOOKASIDE_LIST_EX );
NTKERNELAPI NTSTATUS    NTAPI ExInitializeLookasideListEx( PLOOKASIDE_LIST_EX, PALLOCATE_FUNCTION_EX, PFREE_FUNCTION_EX, POOL_TYPE, ULONG, SIZE_T, ULONG, USHORT );
NTKERNELAPI NTSTATUS    NTAPI IoAllocateSfioStreamIdentifier( PFILE_OBJECT, ULONG, PVOID, PVOID * );
NTKERNELAPI NTSTATUS    NTAPI IoCheckShareAccessEx( ACCESS_MASK, ULONG, PFILE_OBJECT, PSHARE_ACCESS, BOOLEAN, PBOOLEAN );
NTKERNELAPI NTSTATUS    NTAPI IoConnectInterruptEx( PIO_CONNECT_INTERRUPT_PARAMETERS );
NTKERNELAPI VOID        NTAPI IoDisconnectInterruptEx( PIO_DISCONNECT_INTERRUPT_PARAMETERS );
NTKERNELAPI NTSTATUS    NTAPI IoFreeSfioStreamIdentifier( PFILE_OBJECT, PVOID );
NTKERNELAPI NTSTATUS    NTAPI IoGetBootDiskInformationLite( PBOOTDISK_INFORMATION_LITE * );
NTKERNELAPI NTSTATUS    NTAPI IoGetDevicePropertyData( PDEVICE_OBJECT, CONST DEVPROPKEY *, LCID, ULONG, ULONG, PVOID, PULONG, PDEVPROPTYPE );
NTKERNELAPI IO_PRIORITY_HINT NTAPI IoGetIoPriorityHint( PIRP );
NTKERNELAPI PVOID       NTAPI IoGetSfioStreamIdentifier( PFILE_OBJECT, PVOID );
NTKERNELAPI VOID        NTAPI IoInitializeWorkItem( PVOID, PIO_WORKITEM );
NTKERNELAPI VOID        NTAPI IoQueueWorkItemEx( PIO_WORKITEM, PIO_WORKITEM_ROUTINE_EX, WORK_QUEUE_TYPE, PVOID );
NTKERNELAPI NTSTATUS    NTAPI IoRequestDeviceEjectEx( PDEVICE_OBJECT, PIO_DEVICE_EJECT_CALLBACK, PVOID, PDRIVER_OBJECT );
NTKERNELAPI NTSTATUS    NTAPI IoSetDevicePropertyData( PDEVICE_OBJECT, CONST DEVPROPKEY *, LCID, ULONG, DEVPROPTYPE, ULONG, PVOID );
NTKERNELAPI NTSTATUS    NTAPI IoSetIoPriorityHint( PIRP, IO_PRIORITY_HINT );
NTKERNELAPI VOID        NTAPI IoSetShareAccessEx( ACCESS_MASK, ULONG, PFILE_OBJECT, PSHARE_ACCESS, PBOOLEAN );
NTKERNELAPI ULONG       NTAPI IoSizeofWorkItem( VOID );
NTKERNELAPI VOID        NTAPI IoUninitializeWorkItem( PIO_WORKITEM );
NTKERNELAPI LOGICAL     NTAPI IoWithinStackLimits( ULONG_PTR, SIZE_T );
NTKERNELAPI VOID        FASTCALL KeAcquireInStackQueuedSpinLockForDpc( PKSPIN_LOCK, PKLOCK_QUEUE_HANDLE );
NTKERNELAPI NTSTATUS    NTAPI KeQueryDpcWatchdogInformation( PKDPC_WATCHDOG_INFORMATION );
NTKERNELAPI VOID        FASTCALL KeReleaseInStackQueuedSpinLockForDpc( PKLOCK_QUEUE_HANDLE );
NTKERNELAPI LOGICAL     NTAPI MmIsDriverVerifyingByAddress( PVOID );
NTKERNELAPI VOID        NTAPI ObDereferenceObjectDeferDelete( PVOID );
NTKERNELAPI BOOLEAN     NTAPI PoGetSystemWake( PIRP );
NTKERNELAPI NTSTATUS    NTAPI PoRegisterPowerSettingCallback( PDEVICE_OBJECT, LPCGUID, PPOWER_SETTING_CALLBACK, PVOID, PVOID * );
NTKERNELAPI VOID        NTAPI PoSetSystemWake( PIRP );
NTKERNELAPI NTSTATUS    NTAPI PoUnregisterPowerSettingCallback( PVOID );
NTKERNELAPI ULONG       NTAPI SeComputeAutoInheritByObjectType( PVOID, PSECURITY_DESCRIPTOR, PSECURITY_DESCRIPTOR );
#ifdef SINGLE_GROUP_LEGACY_API
NTKERNELAPI ULONG       NTAPI KeQueryMaximumProcessorCount( VOID );
NTKERNELAPI VOID        NTAPI KeRevertToUserAffinityThreadEx( KAFFINITY );
NTKERNELAPI KAFFINITY   NTAPI KeSetSystemAffinityThreadEx( KAFFINITY );
#endif
#endif
#if (NTDDI_VERSION >= 0x06000100)
NTKERNELAPI VOID        NTAPI KeDeregisterProcessorChangeCallback( PVOID );
NTKERNELAPI PVOID       NTAPI KeRegisterProcessorChangeCallback( PPROCESSOR_CALLBACK_FUNCTION, PVOID, ULONG );
NTKERNELAPI USHORT      NTAPI ObGetFilterVersion();
NTKERNELAPI NTSTATUS    NTAPI ObRegisterCallbacks( POB_CALLBACK_REGISTRATION, PVOID * );
NTKERNELAPI VOID        NTAPI ObUnRegisterCallbacks( PVOID );
NTKERNELAPI VOID        NTAPI PoSetDeviceBusyEx( PULONG );
#endif
#if (NTDDI_VERSION >= 0x06010000)
NTKERNELAPI NTSTATUS    NTAPI EtwWriteEx( REGHANDLE, PCEVENT_DESCRIPTOR, ULONG64, ULONG, LPCGUID, LPCGUID, ULONG, PEVENT_DATA_DESCRIPTOR );
NTKERNELAPI VOID        NTAPI ExSetResourceOwnerPointerEx( PERESOURCE, PVOID, ULONG );
NTKERNELAPI NTSTATUS    NTAPI IoGetAffinityInterrupt( PKINTERRUPT, PGROUP_AFFINITY );
NTKERNELAPI NTSTATUS    NTAPI IoGetContainerInformation( IO_CONTAINER_INFORMATION_CLASS, PVOID, PVOID, ULONG );
NTKERNELAPI NTSTATUS    NTAPI IoGetDeviceNumaNode( PDEVICE_OBJECT, PUSHORT );
NTKERNELAPI NTSTATUS    NTAPI IoRegisterContainerNotification( IO_CONTAINER_NOTIFICATION_CLASS, PIO_CONTAINER_NOTIFICATION_FUNCTION, PVOID, ULONG, PVOID );
NTKERNELAPI NTSTATUS    NTAPI IoReplacePartitionUnit( PDEVICE_OBJECT, PDEVICE_OBJECT, ULONG );
NTKERNELAPI VOID        NTAPI IoUnregisterContainerNotification( PVOID );
NTKERNELAPI NTSTATUS    NTAPI IoUnregisterPlugPlayNotificationEx( PVOID );
NTKERNELAPI USHORT      NTAPI KeGetCurrentNodeNumber( VOID );
NTKERNELAPI ULONG       NTAPI KeGetCurrentProcessorNumberEx( PPROCESSOR_NUMBER );
NTKERNELAPI USHORT      NTAPI KeQueryActiveGroupCount( VOID );
NTKERNELAPI ULONG       NTAPI KeQueryActiveProcessorCountEx( USHORT );
NTKERNELAPI KAFFINITY   NTAPI KeQueryGroupAffinity( USHORT );
NTKERNELAPI USHORT      NTAPI KeQueryHighestNodeNumber( VOID );
NTKERNELAPI NTSTATUS    NTAPI KeQueryLogicalProcessorRelationship( PPROCESSOR_NUMBER, LOGICAL_PROCESSOR_RELATIONSHIP, PSYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX, PULONG );
NTKERNELAPI USHORT      NTAPI KeQueryMaximumGroupCount( VOID );
NTKERNELAPI ULONG       NTAPI KeQueryMaximumProcessorCountEx( USHORT );
NTKERNELAPI VOID        NTAPI KeQueryNodeActiveAffinity( USHORT, PGROUP_AFFINITY, PUSHORT );
NTKERNELAPI USHORT      NTAPI KeQueryNodeMaximumProcessorCount( USHORT );
NTKERNELAPI ULONGLONG   NTAPI KeQueryUnbiasedInterruptTime( VOID );
NTKERNELAPI VOID        NTAPI KeRestoreExtendedProcessorState( PXSTATE_SAVE );
NTKERNELAPI VOID        NTAPI KeRevertToUserGroupAffinityThread( PGROUP_AFFINITY );
NTKERNELAPI NTSTATUS    NTAPI KeSaveExtendedProcessorState( ULONG64, PXSTATE_SAVE );
NTKERNELAPI BOOLEAN     NTAPI KeSetCoalescableTimer( PKTIMER, LARGE_INTEGER, ULONG, ULONG, PKDPC );
NTKERNELAPI VOID        NTAPI KeSetSystemGroupAffinityThread( PGROUP_AFFINITY, PGROUP_AFFINITY );
NTKERNELAPI NTSTATUS    NTAPI KeSetTargetProcessorDpcEx( PKDPC, PPROCESSOR_NUMBER );
NTKERNELAPI VOID        NTAPI ObDereferenceObjectDeferDeleteWithTag( PVOID, ULONG );
NTKERNELAPI NTSTATUS    NTAPI ObReferenceObjectByHandleWithTag( HANDLE, ACCESS_MASK, POBJECT_TYPE, KPROCESSOR_MODE, ULONG, PVOID *, POBJECT_HANDLE_INFORMATION );
NTKERNELAPI NTSTATUS    NTAPI ObReferenceObjectByPointerWithTag( PVOID, ACCESS_MASK, POBJECT_TYPE, KPROCESSOR_MODE, ULONG );
NTKERNELAPI LONG_PTR    FASTCALL ObfDereferenceObjectWithTag( PVOID, ULONG );
NTKERNELAPI LONG_PTR    FASTCALL ObfReferenceObjectWithTag( PVOID, ULONG );
NTKERNELAPI NTSTATUS    NTAPI PcwAddInstance( PPCW_BUFFER, PCUNICODE_STRING, ULONG, ULONG, PPCW_DATA );
NTKERNELAPI VOID        NTAPI PcwCloseInstance( PPCW_INSTANCE );
NTKERNELAPI NTSTATUS    NTAPI PcwCreateInstance( PPCW_INSTANCE *, PPCW_REGISTRATION, PCUNICODE_STRING, ULONG, PPCW_DATA );
NTKERNELAPI NTSTATUS    NTAPI PcwRegister( PPCW_REGISTRATION *, PPCW_REGISTRATION_INFORMATION );
NTKERNELAPI VOID        NTAPI PcwUnregister( PPCW_REGISTRATION );
NTKERNELAPI NTSTATUS    NTAPI PoClearPowerRequest( PVOID, POWER_REQUEST_TYPE );
NTKERNELAPI NTSTATUS    NTAPI PoCreatePowerRequest( PVOID *, PDEVICE_OBJECT, PCOUNTED_REASON_CONTEXT );
NTKERNELAPI VOID        NTAPI PoDeletePowerRequest( PVOID );
NTKERNELAPI VOID        NTAPI PoEndDeviceBusy( PULONG );
NTKERNELAPI BOOLEAN     NTAPI PoQueryWatchdogTime( PDEVICE_OBJECT, PULONG );
NTKERNELAPI NTSTATUS    NTAPI PoSetPowerRequest( PVOID, POWER_REQUEST_TYPE );
NTKERNELAPI VOID        NTAPI PoStartDeviceBusy( PULONG );
#endif

/* Functions in HAL.DLL */
NTHALAPI VOID           NTAPI KeFlushWriteBuffer( VOID );
NTHALAPI VOID           FASTCALL ExAcquireFastMutex( PFAST_MUTEX );
NTHALAPI VOID           FASTCALL ExReleaseFastMutex( PFAST_MUTEX );
#ifdef _X86_
NTHALAPI KIRQL          NTAPI KeGetCurrentIrql( VOID );
NTHALAPI VOID           NTAPI READ_PORT_BUFFER_UCHAR( PUCHAR, PUCHAR, ULONG );
NTHALAPI VOID           NTAPI READ_PORT_BUFFER_ULONG( PULONG, PULONG, ULONG );
NTHALAPI VOID           NTAPI READ_PORT_BUFFER_USHORT( PUSHORT, PUSHORT, ULONG );
NTHALAPI UCHAR          NTAPI READ_PORT_UCHAR( PUCHAR );
NTHALAPI ULONG          NTAPI READ_PORT_ULONG( PULONG );
NTHALAPI USHORT         NTAPI READ_PORT_USHORT( PUSHORT );
NTHALAPI VOID           NTAPI WRITE_PORT_BUFFER_UCHAR( PUCHAR, PUCHAR, ULONG );
NTHALAPI VOID           NTAPI WRITE_PORT_BUFFER_ULONG( PULONG, PULONG, ULONG );
NTHALAPI VOID           NTAPI WRITE_PORT_BUFFER_USHORT( PUSHORT, PUSHORT, ULONG );
NTHALAPI VOID           NTAPI WRITE_PORT_UCHAR( PUCHAR, UCHAR );
NTHALAPI VOID           NTAPI WRITE_PORT_ULONG( PULONG, ULONG );
NTHALAPI VOID           NTAPI WRITE_PORT_USHORT( PUSHORT, USHORT );
NTHALAPI KIRQL          NTAPI KeRaiseIrqlToDpcLevel( VOID );
NTHALAPI VOID           FASTCALL KfLowerIrql( KIRQL );
NTHALAPI KIRQL          FASTCALL KfRaiseIrql( KIRQL );
#endif
#if (NTDDI_VERSION >= 0x05000000)
NTHALAPI LARGE_INTEGER  NTAPI KeQueryPerformanceCounter( PLARGE_INTEGER );
NTHALAPI VOID           NTAPI KeStallExecutionProcessor( ULONG );
#endif
#if (NTDDI_VERSION >= 0x05010000)
#ifdef _X86_
NTHALAPI VOID           FASTCALL KeAcquireInStackQueuedSpinLock( PKSPIN_LOCK, PKLOCK_QUEUE_HANDLE );
NTHALAPI VOID           FASTCALL KeReleaseInStackQueuedSpinLock( PKLOCK_QUEUE_HANDLE );
#endif
#endif

/* Functions in CLFS.SYS */
#if (NTDDI_VERSION >= 0x05020100)
CLFSUSER_API NTSTATUS   NTAPI ClfsAddLogContainer( PLOG_FILE_OBJECT, PULONGLONG, PUNICODE_STRING );
CLFSUSER_API NTSTATUS   NTAPI ClfsAddLogContainerSet( PLOG_FILE_OBJECT, USHORT, PULONGLONG, PUNICODE_STRING );
CLFSUSER_API NTSTATUS   NTAPI ClfsAdvanceLogBase( PVOID, PCLFS_LSN, ULONG );
CLFSUSER_API NTSTATUS   NTAPI ClfsAlignReservedLog( PVOID, ULONG, LONGLONG [], PLONGLONG );
CLFSUSER_API NTSTATUS   NTAPI ClfsAllocReservedLog( PVOID, ULONG, PLONGLONG );
CLFSUSER_API NTSTATUS   NTAPI ClfsCloseAndResetLogFile( PLOG_FILE_OBJECT );
CLFSUSER_API NTSTATUS   NTAPI ClfsCloseLogFileObject( PLOG_FILE_OBJECT );
CLFSUSER_API NTSTATUS   NTAPI ClfsCreateLogFile( PPLOG_FILE_OBJECT, PUNICODE_STRING, ACCESS_MASK, ULONG, PSECURITY_DESCRIPTOR, ULONG, ULONG, ULONG, ULONG, PVOID, ULONG );
CLFSUSER_API NTSTATUS   NTAPI ClfsCreateMarshallingArea( PLOG_FILE_OBJECT, POOL_TYPE, PALLOCATE_FUNCTION, PFREE_FUNCTION, ULONG, ULONG, ULONG, PVOID * );
CLFSUSER_API NTSTATUS   NTAPI ClfsCreateScanContext( PLOG_FILE_OBJECT, ULONG, ULONG, CLFS_SCAN_MODE, PCLFS_SCAN_CONTEXT );
CLFSUSER_API NTSTATUS   NTAPI ClfsDeleteLogByPointer( PLOG_FILE_OBJECT );
CLFSUSER_API NTSTATUS   NTAPI ClfsDeleteLogFile( PUNICODE_STRING, PVOID, ULONG, PVOID, ULONG );
CLFSUSER_API NTSTATUS   NTAPI ClfsDeleteMarshallingArea( PVOID );
CLFSUSER_API CLFS_LSN   NTAPI ClfsEarlierLsn( PCLFS_LSN );
CLFSUSER_API void       NTAPI ClfsFinalize( void );
CLFSUSER_API NTSTATUS   NTAPI ClfsFlushBuffers( PVOID );
CLFSUSER_API NTSTATUS   NTAPI ClfsFlushToLsn( PVOID, PCLFS_LSN, PCLFS_LSN );
CLFSUSER_API NTSTATUS   NTAPI ClfsFreeReservedLog( PVOID, ULONG, PLONGLONG );
CLFSUSER_API NTSTATUS   NTAPI ClfsGetContainerName( PLOG_FILE_OBJECT, CLFS_CONTAINER_ID, PUNICODE_STRING, PULONG );
CLFSUSER_API NTSTATUS   NTAPI ClfsGetIoStatistics( PLOG_FILE_OBJECT, PVOID, ULONG, CLFS_IOSTATS_CLASS, PULONG );
CLFSUSER_API NTSTATUS   NTAPI ClfsGetLogFileInformation( PLOG_FILE_OBJECT, PCLFS_INFORMATION, PULONG );
CLFSUSER_API NTSTATUS   NTAPI ClfsInitialize( void );
CLFSUSER_API CLFS_LSN   NTAPI ClfsLaterLsn( PCLFS_LSN );
CLFSUSER_API ULONG      NTAPI ClfsLsnBlockOffset( const CLFS_LSN * );
CLFSUSER_API CLFS_CONTAINER_ID NTAPI ClfsLsnContainer( const CLFS_LSN * );
CLFSUSER_API CLFS_LSN   NTAPI ClfsLsnCreate( CLFS_CONTAINER_ID, ULONG, ULONG );
CLFSUSER_API NTSTATUS   NTAPI ClfsLsnDifference( PCLFS_LSN, PCLFS_LSN, ULONG, ULONG, PLONGLONG );
CLFSUSER_API BOOLEAN    NTAPI ClfsLsnEqual( const CLFS_LSN *, const CLFS_LSN * );
CLFSUSER_API BOOLEAN    NTAPI ClfsLsnGreater( const CLFS_LSN *, const CLFS_LSN * );
CLFSUSER_API CLFS_LSN   NTAPI ClfsLsnIncrement( PCLFS_LSN );
CLFSUSER_API BOOLEAN    NTAPI ClfsLsnInvalid( const CLFS_LSN * );
CLFSUSER_API BOOLEAN    NTAPI ClfsLsnLess( const CLFS_LSN *, const CLFS_LSN * );
CLFSUSER_API BOOLEAN    NTAPI ClfsLsnNull( const CLFS_LSN * );
CLFSUSER_API ULONG      NTAPI ClfsLsnRecordSequence( const CLFS_LSN * );
CLFSUSER_API NTSTATUS   NTAPI ClfsMgmtDeregisterManagedClient( CLFS_MGMT_CLIENT );
CLFSUSER_API NTSTATUS   NTAPI ClfsMgmtHandleLogFileFull( CLFS_MGMT_CLIENT );
CLFSUSER_API NTSTATUS   NTAPI ClfsMgmtInstallPolicy( PLOG_FILE_OBJECT, PCLFS_MGMT_POLICY, ULONG );
CLFSUSER_API NTSTATUS   NTAPI ClfsMgmtQueryPolicy( PLOG_FILE_OBJECT, CLFS_MGMT_POLICY_TYPE, PCLFS_MGMT_POLICY, PULONG );
CLFSUSER_API NTSTATUS   NTAPI ClfsMgmtRegisterManagedClient( PLOG_FILE_OBJECT, PCLFS_MGMT_CLIENT_REGISTRATION, PCLFS_MGMT_CLIENT );
CLFSUSER_API NTSTATUS   NTAPI ClfsMgmtRemovePolicy( PLOG_FILE_OBJECT, CLFS_MGMT_POLICY_TYPE );
CLFSUSER_API NTSTATUS   NTAPI ClfsMgmtSetLogFileSize( PLOG_FILE_OBJECT, PULONGLONG, PULONGLONG, PCLFS_SET_LOG_SIZE_COMPLETE_CALLBACK, PVOID );
CLFSUSER_API NTSTATUS   NTAPI ClfsMgmtSetLogFileSizeAsClient( PLOG_FILE_OBJECT, PCLFS_MGMT_CLIENT, PULONGLONG, PULONGLONG, PCLFS_SET_LOG_SIZE_COMPLETE_CALLBACK, PVOID );
CLFSUSER_API NTSTATUS   NTAPI ClfsMgmtTailAdvanceFailure( CLFS_MGMT_CLIENT, NTSTATUS );
CLFSUSER_API NTSTATUS   NTAPI ClfsReadLogRecord( PVOID, PCLFS_LSN, CLFS_CONTEXT_MODE, PVOID *, PULONG, PCLFS_RECORD_TYPE, PCLFS_LSN, PCLFS_LSN, PVOID * );
CLFSUSER_API NTSTATUS   NTAPI ClfsReadNextLogRecord( PVOID, PVOID *, PULONG, PCLFS_RECORD_TYPE, PCLFS_LSN, PCLFS_LSN, PCLFS_LSN, PCLFS_LSN );
CLFSUSER_API NTSTATUS   NTAPI ClfsReadPreviousRestartArea( PVOID, PVOID *, PULONG, PCLFS_LSN );
CLFSUSER_API NTSTATUS   NTAPI ClfsReadRestartArea( PVOID, PVOID *, PULONG, PCLFS_LSN, PVOID * );
CLFSUSER_API NTSTATUS   NTAPI ClfsRemoveLogContainer( PLOG_FILE_OBJECT, PUNICODE_STRING, BOOLEAN );
CLFSUSER_API NTSTATUS   NTAPI ClfsRemoveLogContainerSet( PLOG_FILE_OBJECT, USHORT, PUNICODE_STRING, BOOLEAN );
CLFSUSER_API NTSTATUS   NTAPI ClfsReserveAndAppendLog( PVOID, PCLFS_WRITE_ENTRY, ULONG, PCLFS_LSN, PCLFS_LSN, ULONG, PLONGLONG, ULONG, PCLFS_LSN );
CLFSUSER_API NTSTATUS   NTAPI ClfsReserveAndAppendLogAligned( PVOID, PCLFS_WRITE_ENTRY, ULONG, ULONG, PCLFS_LSN, PCLFS_LSN, ULONG, PLONGLONG, ULONG, PCLFS_LSN );
CLFSUSER_API NTSTATUS   NTAPI ClfsScanLogContainers( PCLFS_SCAN_CONTEXT, CLFS_SCAN_MODE );
CLFSUSER_API NTSTATUS   NTAPI ClfsSetArchiveTail( PLOG_FILE_OBJECT, PCLFS_LSN );
CLFSUSER_API NTSTATUS   NTAPI ClfsSetEndOfLog( PLOG_FILE_OBJECT, PCLFS_LSN );
CLFSUSER_API NTSTATUS   NTAPI ClfsSetLogFileInformation( PLOG_FILE_OBJECT, CLFS_LOG_INFORMATION_CLASS, PVOID, ULONG );
CLFSUSER_API NTSTATUS   NTAPI ClfsTerminateReadLog( PVOID );
CLFSUSER_API NTSTATUS   NTAPI ClfsWriteRestartArea( PVOID, PVOID, ULONG, PCLFS_LSN, ULONG, PULONG, PCLFS_LSN );
#endif
#if (NTDDI_VERSION >= 0x06000000)
CLFSUSER_API NTSTATUS   NTAPI ClfsQueryLogFileInformation( PLOG_FILE_OBJECT, CLFS_LOG_INFORMATION_CLASS, PVOID, ULONG, PVOID, PULONG );
#endif

/* Debugging macros */
#if DBG
    #define ASSERT( x ) \
        ((void)((!(x)) ? (RtlAssert( #x, __FILE__, __LINE__, NULL ), FALSE) : TRUE))
    #define ASSERTMSG( x, p ) \
        ((void)((!(x)) ? (RtlAssert( #x, __FILE__, __LINE__, p ), FALSE) : TRUE))
    #define RTL_SOFT_ASSERT( x ) \
        ((!(x)) ? (DbgPrint( "%s(%d): Soft assertion failed\n   Expression: %s\n", \
        __FILE__, __LINE__, #x ), FALSE) : TRUE)
    #define RTL_SOFT_ASSERTMSG( x, p ) \
        ((!(x)) ? (DbgPrint( \
        "%s(%d): Soft assertion failed\n   Expression: %s\n   Message: %s\n", \
        __FILE__, __LINE__, #x, p ), FALSE) : TRUE)
    #define RTL_VERIFY                  ASSERT
    #define RTL_VERIFYMSG               ASSERTMSG
    #define RTL_SORT_VERIFY             RTL_SOFT_ASSERT
    #define RTL_SORT_VERIFYMSG          RTL_SOFT_ASSERTMSG
    #define PAGED_CODE() \
        { \
            if( KeGetCurrentIrql() > APC_LEVEL ) { \
                KdPrint( ("EX: Pageable code called at IRQL %d\n", KeGetCurrentIrql()) ); \
                ASSERT( FALSE ); \
            } \
        }
    #define PAGED_CODE_LOCKED()         ((void)0);
#else
    #define ASSERT( x )                 ((void)0)
    #define ASSERTMSG( x, p )           ((void)0)
    #define RTL_SOFT_ASSERT( x )        ((void)0)
    #define RTL_SOFT_ASSERTMSG( x, p )  ((void)0)
    #define RTL_VERIFY( x )             ((x) ? TRUE : FALSE)
    #define RTL_VERIFYMSG( x, p )       ((x) ? TRUE : FALSE)
    #define RTL_SOFT_VERIFY( x )        ((x) ? TRUE : FALSE)
    #define RTL_SOFT_VERIFYMSG( x, p )  ((x) ? TRUE : FALSE)
    #define PAGED_CODE()                ((void)0);
    #define PAGED_CODE_LOCKED()         ((void)0);
#endif

/* Functions implemented as macros */
#define NtCurrentProcess()                  ((HANDLE)(ULONG_PTR)-1)
#define NtCurrentThread()                   ((HANDLE)(ULONG_PTR)-2)
#define PsGetCurrentProcess()               IoGetCurrentProcess()
#define PsGetCurrentThread()                ((PETHREAD)KeGetCurrentThread())
#define ZwCurrentProcess()                  NtCurrentProcess()
#define ZwCurrentThread()                   NtCurrentThread()
#define InitializeListHead32( x ) \
    ((x)->Flink = (x)->Blink = PtrToUlong( x ))
#define RtlIntPtrToUnicodeString( p1, p2, p3 ) \
    RtlIntegerToUnicodeString( p1, p2, p3 )
#define RtlUnicodeStringToAnsiSize( x ) \
    ((*NlsMbCodePageTag) ? RtlxUnicodeStringToAnsiSize( x ) : \
    ((x)->Length + sizeof( UNICODE_NULL )) / sizeof( WCHAR ))
#define RtlAnsiStringToUnicodeSize( x ) \
    ((*NlsMbCodePageTag) ? RtlxAnsiStringToUnicodeSize( x ) : \
    ((x)->Length + sizeof( ANSI_NULL )) * sizeof( WCHAR ))
#define RtlEqualMemory( p1, p2, p3 )        !memcmp( p1, p2, p3 )
#define RtlMoveMemory( p1, p2, p3 )         memmove( p1, p2, p3 )
#define RtlCopyMemory( p1, p2, p3 )         memcpy( p1, p2, p3 )
#define RtlFillMemory( p1, p2, p3 )         memset( p1, p3, p2 )
#define RtlZeroMemory( p1, p2 )             memset( p1, 0, p2 )
#if DBG
    #define KdPrint( x )                    DbgPrint x
    #define KdPrintEx( x )                  DbgPrintEx x
    #define vKdPrintEx( x )                 vDbgPrintEx x
    #define vKdPrintExWithStatus( x )       vDbgPrintExWithStatus x
    #define KdBreakPoint()                  DbgBreakPoint()
    #define KdBreakPointWithStatus( x )     DbgBreakPointWithStatus( x )
#else
    #define KdPrint( x )
    #define KdPrintEx( x )
    #define vKdPrintEx( x )
    #define vKdPrintExWithStatus( x )
    #define KdBreakPoint()
    #define KdBreakPointWithStatus( x )
#endif
#define RtlLargeIntegerAnd( x, p1, p2 ) \
    (x).QuadPart = (p1).QuadPart & (p2).QuadPart
#define RtlLargeIntegerGreaterThan( p1, p2 ) \
    ((((p1).HighPart == (p2).HighPart) && ((p1).LowPart > (p2).LowPart)) || \
    ((p1).HighPart > (p2).HighPart))
#define RtlLargeIntegerGreaterThanOrEqualTo( p1, p2 ) \
    ((((p1).HighPart == (p2).HighPart) && ((p1).LowPart >= (p2).LowPart)) || \
    ((p1).HighPart > (p2).HighPart))
#define RtlLargeIntegerEqualTo( p1, p2 ) \
    (!(((p1).LowPart ^ (p2).LowPart) | ((p1).HighPart ^ (p2).HighPart)))
#define RtlLargeIntegerNotEqualTo( p1, p2 ) \
    ((((p1).LowPart ^ (p2).LowPart) | ((p1).HighPart ^ ((p2).HighPart)))
#define RtlLargeIntegerLessThan( p1, p2 ) \
    ((((p1).HighPart == (p2).HighPart) && ((p1).LowPart < (p2).LowPart)) || \
    ((p1).HighPart < (p2).HighPart))
#define RtlLargeIntegerLessThanOrEqualTo( p1, p2 ) \
    ((((p1).HighPart == (p2).HighPart) && ((p1).LowPart <= (p2).LowPart)) || \
    ((p1).HighPart < (p2).HighPart))
#define RtlLargeIntegerGreaterThanZero( x ) \
    ((((x).HighPart == 0) && ((x).LowPart > 0)) || ((x).HighPart > 0)
#define RtlLargeIntegerGreaterThanOrEqualToZero( x ) \
    ((x).HighPart >= 0)
#define RtlLargeIntegerEqualToZero( x ) \
    (!((x).LowPart | (x).HighPart))
#define RtlLargeIntegerNotEqualToZero( x ) \
    ((x).LowPart | (x).HighPart)
#define RtlLargeIntegerLessThanZero( x ) \
    ((x).HighPart < 0)
#define RtlLargeIntegerLessThanOrEqualToZero( x ) \
    (((x).HighPart < 0) || !((x).LowPart | (x).HighPart))
#define RtlStoreUshort( p1, p2 ) \
    if( (ULONG_PTR)(p1) & SHORT_MASK ) { \
        ((PUCHAR)(p1))[SHORT_LEAST_SIGNIFICANT_BIT] = (UCHAR)FIRSTBYTE( p2 ); \
        ((PUCHAR)(p1))[SHORT_MOST_SIGNIFICANT_BIT] = (UCHAR)SECONDBYTE( p2 ); \
    } else { \
        *((PUSHORT)(p1)) = (USHORT)(p2); \
    }
#define RtlStoreUlong( p1, p2 ) \
    if( (ULONG_PTR)(p1) & LONG_MASK ) { \
        ((PUCHAR)(p1))[LONG_LEAST_SIGNIFICANT_BIT] = (UCHAR)FIRSTBYTE( p2 ); \
        ((PUCHAR)(p1))[LONG_3RD_MOST_SIGNIFICANT_BIT] = (UCHAR)SECONDBYTE( p2 ); \
        ((PUCHAR)(p1))[LONG_2ND_MOST_SIGNIFICANT_BIT] = (UCHAR)THIRDBYTE( p2 ); \
        ((PUCHAR)(p1))[LONG_MOST_SIGNFICIANT_BIT] = (UCHAR)FOURTHBYTE( p2 ); \
    } else { \
        *((PULONG)(p1)) = (ULONG)(p2); \
    }
#define RtlStoreUlonglong( p1, p2 ) \
    if( (ULONG_PTR)(p1) & LONGLONG_MASK ) { \
        RtlStoreUlong( (ULONG_PTR)(p1), (ULONGLONG)(p2) & 0xFFFFFFFF ); \
        RtlStoreUlong( (ULONG_PTR)(p1) + sizeof( ULONG ), (ULONGLONG)(p2) >> 32 ); \
    } else { \
        *((PULONGLONG)(p1)) = (ULONGLONG)(p2); \
    }
#define RtlStoreUlongPtr( p1, p2 )      RtlStoreUlong( p1, p2 )
#define RtlRetrieveUshort( p1, p2 ) \
    if( (ULONG_PTR)(p2) & SHORT_MASK ) { \
        ((PUCHAR)(p1))[0] = ((PUCHAR)(p2))[0]; \
        ((PUCHAR)(p1))[0] = ((PUCHAR)(p2))[1]; \
    } else { \
        *((PUSHORT)(p1)) = *((PUSHORT)(p2)); \
    }
#define RtlRetrieveUlong( p1, p2 ) \
    if( (ULONG_PTR)(p2) & LONG_MASK ) { \
        ((PUCHAR)(p1))[0] = ((PUCHAR)(p2))[0]; \
        ((PUCHAR)(p1))[1] = ((PUCHAR)(p2))[1]; \
        ((PUCHAR)(p1))[2] = ((PUCHAR)(p2))[2]; \
        ((PUCHAR)(p1))[3] = ((PUCHAR)(p2))[3]; \
    } else { \
        *((PULONG)(p1)) = *((PULONG)(p2)); \
    }
#define RtlCheckBit( x, p ) \
    ((((x)->Buffer[(p) / 32]) >> ((p) % 32)) & 0x00000001)
#define RtlEqualLuid( p1, p2 ) \
    (((p1)->LowPart == (p2)->LowPart) && ((p1)->HighPart == ((p2)->HighPart))
#define RtlIsZeroLuid( x ) \
    ((BOOLEAN)(((x)->LowPart | (x)->HighPart) == 0))
#ifdef _X86_
    #define KeGetDcacheFillSize()           1L
    #define KeFlushIoBuffers( p1, p2, p3 )
    #define ExAcquireSpinLock( p1, p2 )     KeAcquireSpinLock( p1, p2 )
    #define ExReleaseSpinLock( p1, p2 )     KeReleaseSpinLock( p1, p2 )
    #define ExAcquireSpinLockAtDpcLevel( x ) \
        KeAcquireSpinLockAtDpcLevel( x )
    #define ExReleaseSpinLockFromDpcLevel( x ) \
        ExReleaseSpinLockFromDpcLevel( x )
    #define KeQueryTickCount( x ) \
        { \
            KSYSTEM_TIME volatile *v = *((PKSYSTEM_TIME *)&KeTickCount); \
            for( ;; ) { \
                (x)->HighPart = v->High1Time; \
                (x)->LowPart = v->LowPart; \
                if( (x)->HighPart = v->High2Time ) { \
                    break; \
                } \
            } \
        }
    #define MmGetProcedureAddress( x )      (x)
    #define MmLockPagableCodeSection( x )   MmLockPagableDataSection( x )
    #define ExInterlockedIncrementLong( x, p ) \
        Exfi386InterlockedIncrementLong( x )
    #define ExInterlockedDecrementLong( x, p ) \
        Exfi386InterlockedDecrementLong( x )
    #define ExInterlockedExchangeUlong( p1, p2, p3 ) \
        Exfi386InterlockedExchangeUlong( p1, p2 )
    #define InterlockedCompareExchangePointer( p1, p2, p3 ) \
        (PVOID)InterlockedCompareExchange( (PLONG)(p1), (LONG)(p2), (LONG)(p3) )
    #define InterlockedCompareExchange64( p1, p2, p3 ) \
        ExfInterlockedCompareExchange64( p1, &(p2), &(p3) )
    #define InterlockedExchangePointer( p1, p2 ) \
        (PVOID)InterlockedExchange( (PLONG)(p1), (LONG)(p2) )
    #define InterlockedExchangeAddSizeT( p1, p2 ) \
        InterlockedExchangeAdd( (LONG *)(p1), p2 )
    #define InterlockedIncrementSizeT( x )  InterlockedIncrement( (LONG *)(x) )
    #define InterlockedDecrementSizeT( x )  InterlockedDecrement( (LONG *)(x) )
    #define KeAcquireSpinLockAtDpcLevel( x ) \
        KefAcquireSpinLockAtDpcLevel( x )
    #define KeReleaseSpinLockFromDpcLevel( x ) \
        KefReleaseSpinLockFromDpcLevel( x )
    #define KeAcquireSpinLock( p1, p2 )     (*(p2) = KfAcquireSpinLock( p1 ))
    #define KeReleaseSpinLock( p1, p2 )     KfReleaseSpinLock( p1, p2 )
    #define KeLowerIrql( x )                KfLowerIrql( x )
    #define KeRaiseIrql( p1, p2 )           (*(p2) = KfRaiseIrql( p1 ))
#endif
#define KeInitializeCallbackRecord( x )     (x)->State = BufferEmpty
#ifndef POOL_TAGGING
    #define ExAllocatePoolWithTag( p1, p2, p3 ) \
        ExAllocatePool( p1, p2 )
    #define ExAllocatePoolWithQuotaTag( p1, p2, p3 ) \
        ExAllocatePoolWithQuota( p1, p2 )
#endif
#define ExQueryDepthSList( x )              (x)->Depth
#define InterlockedFlushSList( x )          ExInterlockedFlushSList( x )
#define QueryDepthSList( x )                ExQueryDepthSList( x )
#define ExInitializeWorkItem( x, p1, p2 ) \
    (x)->WorkerRoutine = (p1); \
    (x)->Parameter = (p2); \
    (x)->List.Flink = NULL;
#define ExReleaseResource( x )              ExReleaseResourceLite( x )
#define ExGetCurrentResourceThread()        ((ULONG_PTR)PsGetCurrentThread())
#define MmGetMdlPfnArray( x )               ((PPFN_NUMBER)(x + 1))
#define MmGetMdlVirtualAddress( x ) \
    ((PVOID)((PCHAR)((x)->StartVa) + (x)->ByteOffset))
#define MmGetMdlByteCount( x )              ((x)->ByteCount)
#define MmGetMdlByteOffset( x )             ((x)->ByteOffset)
#define MmGetMdlBaseVa( x )                 ((x)->StartVa)
#define MmInitializeMdl( x, p1, p2 ) \
    { \
        (x)->Next = (PMDL)NULL; \
        (x)->Size = (CSHORT)(sizeof( MDL ) + (sizeof( PFN_NUMBER ) * \
            ADDRESS_AND_SIZE_TO_SPAN_PAGES( p1, p2 ))); \
        (x)->MdlFlags = 0; \
        (x)->StartVa = (PVOID)PAGE_ALIGN( p1 ); \
        (x)->ByteOffset = BYTE_OFFSET( p1 ); \
        (x)->ByteCount = (ULONG)(p2); \
    }
#define MmGetSystemAddressForMdlSafe( x, p ) \
    (((x)->MdlFlags & (MDL_MAPPED_TO_SYSTEM_VA | MDL_SOURCE_IS_NONPAGED_POOL)) ? \
    (x)->MappedSystemVa : MmMapLockedPagesSpecifyCache( x, KernelMode, MmCached, \
    NULL, FALSE, p ))
#define MmGetSystemAddressForMdl( x ) \
    (((x)->MdlFlags & (MDL_MAPPED_TO_SYSTEM_VA | MDL_SOURCE_IS_NONPAGED_POOL)) ? \
    (x)->MappedSystemVa : MmMapLockedPages( x, KernelMode ))
#define MmPrepareMdlForReuse( x ) \
    if( ((x)->MdlFlags & MDL_PARTIAL_HAS_BEEN_MAPPED) != 0 ) { \
        ASSERT( ((x)->MdlFlags & MDL_PARTIAL) != 0 ); \
        MmUnmapLockedPages( (x)->MappedSystemVa, x ); \
    } else if( ((x)->MdlFlags & MDL_PARTIAL) == 0 ) { \
        ASSERT( ((x)->MdlFlags & MDL_MAPPED_TO_SYSTEM_VA) == 0 ); \
    }
#define IoCallDriver( p1, p2 )              IofCallDriver( p1, p2 )
#define IoCompleteRequest( p1, p2 )         IofCompleteRequest( p1, p2 )
#define IoGetCurrentIrpStackLocation( x )   ((x)->Tail.Overlay.CurrentStackLocation)
#define IoGetFunctionCodeFromCtlCode( x )   ((x >> 2) & 0x00000FFFL)
#define IoCallDriverStackSafeDefault( p1, p2 ) \
    IoCallDriver( p1, p2 )
#define IoGetNextIrpStackLocation( x )      ((x)->Tail.Overlay.CurrentStackLocation - 1)
#define IoInitializeDpcRequest( p1, p2 ) \
    KeInitializeDpc( &(p1)->Dpc, (PKDEFERRED_ROUTINE)(p2), p1 )
#define IoIsErrorUserInduced( x ) \
    ((BOOLEAN)(((x) == STATUS_DEVICE_NOT_READY) || ((x) == STATUS_IO_TIMEOUT) || \
    ((x) == STATUS_MEDIA_WRITE_PROTECTED) || ((x) == STATUS_NO_MEDIA_IN_DEVICE) || \
    ((x) == STATUS_VERIFY_REQUIRED) || ((x) == STATUS_UNRECOGNIZED_MEDIA) || \
    ((x) == STATUS_WRONG_VOLUME)))
#define IoMarkIrpPending( x ) \
    (IoGetCurrentIrpStackLocation( x )->Control |= SL_PENDING_RETURNED)
#define IoRequestDpc( p1, p2, p3 )          KeInsertQueueDpc( &(p1)->Dpc, p1, p2 )
#define IoSetCancelRoutine( p1, p2 ) \
    (PDRIVER_CANCEL)(ULONG_PTR)InterlockedExchangePointer( \
    (PVOID *)&(p1)->CancelRoutine, (PVOID)(ULONG_PTR)(p2) )
#define IoSetNextIrpStackLocation( x ) \
    { \
        (x)->CurrentLocation--; \
        (x)->Tail.Overlay.CurrentStackLocation--; \
    }
#define IoCopyCurrentIrpStackLocationToNext( x ) \
    { \
        PIO_STACK_LOCATION v1; \
        PIO_STACK_LOCATION v2; \
        v1 = IoGetCurrentIrpStackLocation( x ); \
        v2 = IoGetNextIrpStackLocation( x ); \
        RtlCopyMemory( v2, v1, (SIZE_T)&((IO_STACK_LOCATION *)0)->CompletionRoutine ); \
        v2->Control = 0; \
    }
#define IoSkipCurrentIrpStackLocation( x ) \
    { \
        (x)->CurrentLocation++; \
        (x)->Tail.Overlay.CurrentStackLocation++; \
    }
#define IoInitializeRemoveLock( p1, p2, p3, p4 ) \
    IoInitializeRemoveLockEx( p1, p2, p3, p4, sizeof( IO_REMOVE_LOCK ) )
#if DBG
    #define IoAcquireRemoveLock( p1, p2 ) \
        IoAcquireRemoveLockEx( p1, p2, __FILE__, __LINE__, sizeof( IO_REMOVE_LOCK ) )
#else
    #define IoAcquireRemoveLock( p1, p2 ) \
        IoAcquireRemoveLockEx( p1, p2, "", 1, sizeof( IO_REMOVE_LOCK ) )
#endif
#define IoReleaseRemoveLock( p1, p2 ) \
    IoReleaseRemoveLockEx( p1, p2, sizeof( IO_REMOVE_LOCK ) )
#define IoReleaseRemoveLockAndWait( p1, p2 ) \
    IoReleaseRemoveLockAndWaitEx( p1, p2, sizeof( IO_REMOVE_LOCK ) )
#define IoSizeOfIrp( x ) \
    ((USHORT)(sizeof( IRP ) + ((x) * sizeof( IO_STACK_LOCATION ))))
#define IoWMIDeviceObjectToProviderId( x )  ((ULONG)(x))
#define IoAdjustPagingPathCount( p1, p2 ) \
    if( p2 ) { \
        InterlockedIncrement( p1 ); \
    } else { \
        InterlockedDecrement( p1 ); \
    }
#define PoSetDeviceBusy( x )                (*(x) = 0)
#define ObDereferenceObject( x )            ObfDereferenceObject( x )
#define ObReferenceObject( x )              ObfReferenceObject( x )
#if (NTDDI_VERSION >= 0x06010000)
    #define ObDereferenceObjectWithTag( x, p )  ObfDereferenceObjectWithTag( x, p )
    #define ObReferenceObjectWithTag( x, p )    ObfReferenceObjectWithTag( x, p )
#endif

/* Aliases */
#define RtlCopyBytes                            RtlCopyMemory
#define RtlZeroBytes                            RtlZeroMemory
#define RtlFillBytes                            RtlFillMemory
#define RtlCopyMemoryNonTemporal                RtlCopyMemory
#define RtlIsNtDdiVersionAvailable              WdmlibRtlIsNtDdiVersionAvailable
#define RtlIsServicePackVersionInstalled        WdmlibRtlIsServicePackVersionInstalled
#ifdef _X86_
    #define ExInterlockedAddUlong               ExfInterlockedAddUlong
    #define ExInterlockedInsertHeadList         ExfInterlockedInsertHeadList
    #define ExInterlockedInsertTailList         ExfInterlockedInsertTailList
    #define ExInterlockedRemoveHeadList         ExfInterlockedRemoveHeadList
    #define ExInterlockedPopEntryList           ExfInterlockedPopEntryList
    #define ExInterlockedPushEntryList          ExfInterlockedPushEntryList
    #define InterlockedIncrementAcquire         InterlockedIncrement
    #define InterlockedIncrementRelease         InterlockedIncrement
    #define InterlockedDecrementAcquire         InterlockedDecrement
    #define InterlockedDecrementRelease         InterlockedDecrement
    #define InterlockedCompareExchangeAcquire   InterlockedCompareExchange
    #define InterlockedCompareExchangeRelease   InterlockedCompareExchange
    #define InterlockedCompareExchangeAcquire64 InterlockedCompareExchange64
    #define InterlockedCompareExchangeRelease64 InterlockedCompareExchange64
    #define InterlockedCompareExchangePointerAcquire    InterlockedCompareExchangePointer
    #define InterlockedCompareExchangePointerRelease    InterlockedCompareExchangePointer
#endif
#define KeWaitForMutexObject                    KeWaitForSingleObject
#define ExInitializeSListHead                   InitializeSListHead
#define ExIsResourceAcquiredLite                ExIsResourceAcquiredSharedLite
#define IoForwardAndCatchIrp                    IoForwardIrpSynchronously

/* Other macros */
#define NLS_MB_CODE_PAGE_TAG        (*NlsMbCodePageTag)
#define NLS_MB_OEM_CODE_PAGE_TAG    (*NlsMbOemCodePageTag)
#define KD_DEBUGGER_ENABLED         (*KdDebuggerEnabled)
#define KD_DEBUGGER_NOT_PRESENT     (*KdDebuggerNotPresent)

__inline VOID InitializeListHead( PLIST_ENTRY x )
{
    x->Flink = x->Blink = x;
}

__inline BOOLEAN IsListEmpty( const LIST_ENTRY *x )
{
    return( (BOOLEAN)(x->Flink == x) );
}

__inline BOOLEAN RemoveEntryList( PLIST_ENTRY x )
{
    PLIST_ENTRY v1;
    PLIST_ENTRY v2;
    v1 = x->Flink;
    v2 = x->Blink;
    v2->Flink = v1;
    v1->Blink = v2;
    return( (BOOLEAN)(v1 == v2) );
}

__inline PLIST_ENTRY RemoveHeadList( PLIST_ENTRY x )
{
    PLIST_ENTRY v1;
    PLIST_ENTRY v2;
    v1 = x->Flink;
    v2 = v1->Flink;
    x->Flink = v2;
    v2->Blink = x;
    return( v1 );
}

__inline PLIST_ENTRY RemoveTailList( PLIST_ENTRY x )
{
    PLIST_ENTRY v1;
    PLIST_ENTRY v2;
    v1 = x->Blink;
    v2 = v1->Blink;
    x->Blink = v2;
    v2->Flink = x;
    return( v1 );
}

__inline VOID InsertTailList( PLIST_ENTRY x, PLIST_ENTRY p )
{
    PLIST_ENTRY v;
    v = x->Blink;
    p->Flink = x;
    p->Blink = v;
    v->Flink = p;
    x->Blink = p;
}

__inline VOID InsertHeadList( PLIST_ENTRY x, PLIST_ENTRY p )
{
    PLIST_ENTRY v;
    v = x->Flink;
    p->Flink = v;
    p->Blink = x;
    v->Blink = p;
    x->Flink = p;
}

__inline VOID AppendTailList( PLIST_ENTRY x, PLIST_ENTRY p )
{
    PLIST_ENTRY v;
    v = x->Blink;
    x->Blink->Flink = p;
    x->Blink = p->Blink;
    p->Blink->Flink = x;
    p->Blink = v;
}

__inline PSINGLE_LIST_ENTRY PopEntryList( PSINGLE_LIST_ENTRY x )
{
    PSINGLE_LIST_ENTRY  v;
    v = x->Next;
    if( v != NULL ) {
        x->Next = v->Next;
    }
    return( v );
}

__inline VOID PushEntryList( PSINGLE_LIST_ENTRY x, PSINGLE_LIST_ENTRY p )
{
    p->Next = x->Next;
    x->Next = p;
}

__inline VOID RtlInitEmptyUnicodeString( PUNICODE_STRING x, PWCHAR p1, USHORT p2 )
{
    x->Length = 0;
    x->MaximumLength = p2;
    x->Buffer = p1;
}

__inline VOID RtlInitEmptyAnsiString( PANSI_STRING x, PCHAR p1, USHORT p2 )
{
    x->Length = 0;
    x->MaximumLength = p2;
    x->Buffer = p1;
}

__inline LARGE_INTEGER RtlLargeIntegerAdd( LARGE_INTEGER p1, LARGE_INTEGER p2 )
{
    LARGE_INTEGER   v;
    v.QuadPart = p1.QuadPart + p2.QuadPart;
    return( v );
}

__inline LARGE_INTEGER RtlEnlargedIntegerMultiply( LONG p1, LONG p2 )
{
    LARGE_INTEGER   v;
    v.QuadPart = (LONGLONG)p1 * (LONGLONG)p2;
    return( v );
}

__inline LARGE_INTEGER RtlEnlargedUnsignedMultiply( ULONG p1, ULONG p2 )
{
    LARGE_INTEGER   v;
    v.QuadPart = (ULONGLONG)p1 * (ULONGLONG)p2;
    return( v );
}

__inline ULONG RtlEnlargedUnsignedDivide( ULARGE_INTEGER p1, ULONG p2, PULONG p3 )
{
    ULONG   v;
    v = (ULONG)(p1.QuadPart / p2);
    if( p3 != NULL ) {
        *p3 = (ULONG)(p1.QuadPart % p2);
    }
    return( v );
}

__inline LARGE_INTEGER RtlLargeIntegerNegate( LARGE_INTEGER x )
{
    LARGE_INTEGER   v;
    v.QuadPart = -x.QuadPart;
    return( v );
}

__inline LARGE_INTEGER RtlLargeIntegerSubtract( LARGE_INTEGER p1, LARGE_INTEGER p2 )
{
    LARGE_INTEGER   v;
    v.QuadPart = p1.QuadPart - p2.QuadPart;
    return( v );
}

__inline LARGE_INTEGER RtlConvertLongToLargeInteger( LONG x )
{
    LARGE_INTEGER   v;
    v.QuadPart = x;
    return( v );
}

__inline LARGE_INTEGER RtlConvertUlongToLargeInteger( ULONG x )
{
    LARGE_INTEGER   v;
    v.QuadPart = x;
    return( v );
}

__inline LARGE_INTEGER RtlLargeIntegerShiftLeft( LARGE_INTEGER x, CCHAR p )
{
    LARGE_INTEGER   v;
    v.QuadPart = x.QuadPart << p;
    return( v );
}

__inline LARGE_INTEGER RtlLargeIntegerShiftRight( LARGE_INTEGER x, CCHAR p )
{
    LARGE_INTEGER   v;
    v.QuadPart = (ULONG64)x.QuadPart >> p;
    return( v );
}

__inline LARGE_INTEGER RtlLargeIntegerArithmeticShift( LARGE_INTEGER x, CCHAR p )
{
    LARGE_INTEGER   v;
    v.QuadPart = x.QuadPart >> p;
    return( v );
}

__inline VOID ExInitializeFastMutex( PFAST_MUTEX x )
{
    x->Count = FM_LOCK_BIT;
    x->Owner = NULL;
    x->Contention = 0;
    KeInitializeEvent( &x->Event, SynchronizationEvent, FALSE );
}

__inline VOID InitializeSListHead( PSLIST_HEADER x )
{
    RtlZeroMemory( x, sizeof( SLIST_HEADER ) );
}

__inline PVOID ExAllocateFromNPagedLookasideList( PNPAGED_LOOKASIDE_LIST x )
{
    PVOID   v;
    x->L.TotalAllocates++;
#ifdef _X86_
    v = ExInterlockedPopEntrySList( &x->L.ListHead, &x->Lock__ObsoleteButDoNotDelete );
#else
    v = InterlockedPopEntrySList( &x->L.ListHead );
#endif
    if( v == NULL ) {
        x->L.AllocateMisses++;
        v = (x->L.Allocate)( x->L.Type, x->L.Size, x->L.Tag );
    }
    return( v );
}

__inline VOID ExFreeToNPagedLookasideList( PNPAGED_LOOKASIDE_LIST x, PVOID p )
{
    x->L.TotalFrees++;
    if( ExQueryDepthSList( &x->L.ListHead ) >= x->L.Depth ) {
        x->L.FreeMisses++;
        (x->L.Free)( p );
    } else {
#ifdef _X86_
        ExInterlockedPushEntrySList( &x->L.ListHead, (PSLIST_ENTRY)p,
                                     &x->Lock__ObsoleteButDoNotDelete );
#else
        InterlockedPushEntrySList( &x->L.ListHead, (PSLIST_ENTRY)p );
#endif
    }
}

__inline VOID IoSetCompletionRoutine( PIRP x, PIO_COMPLETION_ROUTINE p1, PVOID p2,
                                      BOOLEAN p3, BOOLEAN p4, BOOLEAN p5 )
{
    PIO_STACK_LOCATION  v;
    ASSERT( (p1 || p2 || p3) ? (p1 != NULL) : TRUE );
    v = IoGetNextIrpStackLocation( x );
    v->CompletionRoutine = p1;
    v->Context = p2;
    v->Control = 0;
    if( p3 ) {
        v->Control = SL_INVOKE_ON_SUCCESS;
    }
    if( p4 ) {
        v->Control |= SL_INVOKE_ON_ERROR;
    }
    if( p5 ) {
        v->Control |= SL_INVOKE_ON_CANCEL;
    }
}

#if (NTDDI_VERSION >= 0x06000000)

__inline PVOID ExAllocateFromLookasideListEx( PLOOKASIDE_LIST_EX x )
{
    PVOID   v;
    x->L.TotalAllocates++;
    v = InterlockedPopEntrySList( &x->L.ListHead );
    if( v == NULL ) {
        x->L.AllocateMisses++;
        v = (x->L.AllocateEx)( x->L.Type, x->L.Size, x->L.Tag, x );
    }
    return( v );
}

__inline VOID ExFreeToLookasideListEx( PLOOKASIDE_LIST_EX x, PVOID p )
{
    x->L.TotalFrees++;
    if( ExQueryDepthSList( &x->L.ListHead ) >= x->L.Depth ) {
        x->L.FreeMisses++;
        (x->L.FreeEx)( p, x );
    } else {
        InterlockedPushEntrySList( &x->L.ListHead, (PSLIST_ENTRY)p );
    }
}

__inline ULONG_PTR IoGetRemainingStackSize( VOID )
{
    ULONG_PTR   v1;
    ULONG_PTR   v2;
    IoGetStackLimits( &v2, &v1 );
    return( (ULONG_PTR)(&v1) - v2 );
}

#ifndef _NTDDK_

__inline PVOID HalAllocateCommonBuffer( PDMA_ADAPTER p1, ULONG p2, PPHYSICAL_ADDRESS p3,
                                        BOOLEAN p4 )
{
    PALLOCATE_COMMON_BUFFER v1;
    PVOID                   v2;
    v1 = *(p1)->DmaOperations->AllocateCommonBuffer;
    ASSERT( v1 != NULL );
    v2 = v1( p1, p2, p3, p4 );
    return( v2 );
}

__inline VOID HalFreeCommonBuffer( PDMA_ADAPTER p1, ULONG p2, PHYSICAL_ADDRESS p3,
                                   PVOID p4, BOOLEAN p5 )
{
    PFREE_COMMON_BUFFER v;
    v = *(p1)->DmaOperations->FreeCommonBuffer;
    ASSERT( v != NULL );
    v( p1, p2, p3, p4, p5 );
}

__inline NTSTATUS IoAllocateAdapterChannel( PDMA_ADAPTER p1, PDEVICE_OBJECT p2, ULONG p3,
                                            PDRIVER_CONTROL p4, PVOID p5 )
{
    PALLOCATE_ADAPTER_CHANNEL   v1;
    NTSTATUS                    v2;
    v1 = *(p1)->DmaOperations->AllocateAdapterChannel;
    ASSERT( v1 != NULL );
    v2 = v1( p1, p2, p3, p4, p5 );
    return( v2 );
}

__inline BOOLEAN IoFlushAdapterBuffers( PDMA_ADAPTER p1, PMDL p2, PVOID p3, PVOID p4,
                                        ULONG p5, BOOLEAN p6 )
{
    PFLUSH_ADAPTER_BUFFERS  v1;
    BOOLEAN                 v2;
    v1 = *(p1)->DmaOperations->FlushAdapterBuffers;
    ASSERT( v1 != NULL );
    v2 = v1( p1, p2, p3, p4, p5, p6 );
    return( v2 );
}

__inline VOID IoFreeAdapterChannel( PDMA_ADAPTER x )
{
    PFREE_ADAPTER_CHANNEL   v;
    v = *(x)->DmaOperations->FreeAdapterChannel;
    ASSERT( v != NULL );
    v( x );
}

__inline VOID IoFreeMapRegisters( PDMA_ADAPTER p1, PVOID p2, ULONG p3 )
{
    PFREE_MAP_REGISTERS v;
    v = *(p1)->DmaOperations->FreeMapRegisters;
    ASSERT( v != NULL );
    v( p1, p2, p3 );
}

__inline PHYSICAL_ADDRESS IoMapTransfer( PDMA_ADAPTER p1, PMDL p2, PVOID p3, PVOID p4,
                                         PULONG p5, BOOLEAN p6 )
{
    PMAP_TRANSFER       v1;
    PHYSICAL_ADDRESS    v2;
    v1 = *(p1)->DmaOperations->MapTransfer;
    ASSERT( v1 != NULL );
    v2 = v1( p1, p2, p3, p4, p5, p6 );
    return( v2 );
}

__inline ULONG HalGetDmaAlignment( PDMA_ADAPTER x )
{
    PGET_DMA_ALIGNMENT  v1;
    ULONG               v2;
    v1 = *(x)->DmaOperations->GetDmaAlignment;
    ASSERT( v1 != NULL );
    v2 = v1( x );
    return( v2 );
}

__inline ULONG HalReadDmaCounter( PDMA_ADAPTER x )
{
    PREAD_DMA_COUNTER   v1;
    ULONG               v2;
    v1 = *(x)->DmaOperations->ReadDmaCounter;
    ASSERT( v1 != NULL );
    v2 = v1( x );
    return( v2 );
}

#endif /* _NTDDK_H_INCLUDED */
#endif /* (NTDDI_VERSION >= 0x06000000) */

#if (NTDDI_VERSION >= 0x06000100)

__inline VOID IoInitializeThradedDpcRequest( PDEVICE_OBJECT x, PIO_DPC_ROUTINE p )
{
    KeInitializeThreadedDpc( &x->Dpc, (PKDEFERRED_ROUTINE)p, x );
}

#endif /* (NTDDI_VERSION >= 0x06000100) */

#if (NTDDI_VERSION >= 0x05020100)
#ifdef __cplusplus

inline CLFS_LSN operator++( CLFS_LSN &x )
{
    x = ClfsLsnIncrement( &x );
    return( x );
}

inline BOOLEAN operator<( const CLFS_LSN &p1, const CLFS_LSN &p2 )
{
    return( ClfsLsnLess( (PCLFS_LSN)&p1, (PCLFS_LSN)&p2 ) );
}

inline BOOLEAN operator>( const CLFS_LSN &p1, const CLFS_LSN &p2 )
{
    return( ClfsLsnGreater( (PCLFS_LSN)&p1, (PCLFS_LSN)&p2 ) );
}

inline BOOLEAN operator==( const CLFS_LSN &p1, const CLFS_LSN &p2 )
{
    return( ClfsLsnEqual( (PCLFS_LSN)&p1, (PCLFS_LSN)&p2 ) );
}

inline BOOLEAN operator!=( const CLFS_LSN &p1, const CLFS_LSN &p2 )
{
    return( !ClfsLsnEqual( (PCLFS_LSN)&p1, (PCLFS_LSN)&p2 ) );
}

inline BOOLEAN operator<=( const CLFS_LSN &p1, const CLFS_LSN &p2 )
{
    return( !ClfsLsnGreater( (PCLFS_LSN)&p1, (PCLFS_LSN)&p2 ) );
}

inline BOOLEAN operator>=( const CLFS_LSN &p1, const CLFS_LSN &p2 )
{
    return( !ClfsLsnLess( (PCLFS_LSN)&p1, (PCLFS_LSN)&p2 ) );
}

#endif /* __cplusplus */
#endif /* (NTDDI_VERSION >= 0x05020100) */

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _WDMDDK_ */
