/*
 *  ddstream.h  DirectDraw streaming interfaces
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#include <rpc.h>
#include <rpcndr.h>
#ifndef COM_NO_WINDOWS_H
    #include <windows.h>
    #include <ole2.h>
#endif

#ifndef __ddstream_h__
#define __ddstream_h__

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#include <mmstream.h>
#include <ddraw.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Forward declarations */
typedef interface IDirectDrawStreamSample   IDirectDrawStreamSample;

/* DirectDraw streaming flags */
enum {
    DDSFF_PROGRESSIVERENDER = 0x00000001
};

/* IDirectDrawMediaStream interface */
#undef INTERFACE
#define INTERFACE   IDirectDrawMediaStream
DECLARE_INTERFACE_( IDirectDrawMediaStream, IMediaStream ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IMediaStream methods */
    STDMETHOD( GetMultiMediaStream )( THIS_ IMultiMediaStream ** ) PURE;
    STDMETHOD( GetInformation )( THIS_ MSPID *, STREAM_TYPE * ) PURE;
    STDMETHOD( SetSameFormat )( THIS_ IMediaStream *, DWORD ) PURE;
    STDMETHOD( AllocateSample )( THIS_ DWORD, IStreamSample ** ) PURE;
    STDMETHOD( CreateSharedSample )( THIS_ IStreamSample *, DWORD, IStreamSample ** ) PURE;
    STDMETHOD( SendEndOfStream )( THIS_ DWORD ) PURE;

    /* IDirectDrawMediaStream methods */
    STDMETHOD( GetFormat )( THIS_ DDSURFACEDESC *, IDirectDrawPalette **, DDSURFACEDESC *, DWORD * ) PURE;
    STDMETHOD( SetFormat )( THIS_ const DDSURFACEDESC *, IDirectDrawPalette * ) PURE;
    STDMETHOD( GetDirectDraw )( THIS_ IDirectDraw ** ) PURE;
    STDMETHOD( SetDirectDraw )( THIS_ IDirectDraw * ) PURE;
    STDMETHOD( CreateSample )( THIS_ IDirectDrawSurface *, const RECT *, DWORD, IDirectDrawStreamSample ** ) PURE;
    STDMETHOD( GetTimePerFrame )( THIS_ STREAM_TIME * ) PURE;
};

/* IDirectDrawStreamSample interface */
#undef INTERFACE
#define INTERFACE   IDirectDrawStreamSample
DECLARE_INTERFACE_( IDirectDrawStreamSample, IStreamSample ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IStreamSample methods */
    STDMETHOD( GetMediaStream )( THIS_ IMediaStream ** ) PURE;
    STDMETHOD( GetSampleTimes )( THIS_ STREAM_TIME *, STREAM_TIME *, STREAM_TIME * ) PURE;
    STDMETHOD( SetSampleTimes )( THIS_ const STREAM_TIME *, const STREAM_TIME * ) PURE;
    STDMETHOD( Update )( THIS_ DWORD, HANDLE, PAPCFUNC, DWORD_PTR ) PURE;
    STDMETHOD( CompletionStatus )( DWORD, DWORD ) PURE;

    /* IDirectDrawStreamSample methods */
    STDMETHOD( GetSurface )( THIS_ IDirectDrawSurface **, RECT * ) PURE;
    STDMETHOD( SetRect )( THIS_ const RECT * ) PURE;
};

/* C object macros */
#if (!defined( __cplusplus ) || defined( CINTERFACE )) && defined( COBJMACROS )
    #define IDirectDrawMediaStream_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IDirectDrawMediaStream_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IDirectDrawMediaStream_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IDirectDrawMediaStream_GetMultiMediaStream( x, p ) \
        (x)->lpVtbl->GetMultiMediaStream( x, p )
    #define IDirectDrawMediaStream_GetInformation( x, p1, p2 ) \
        (x)->lpVtbl->GetInformation( x, p1, p2 )
    #define IDirectDrawMediaStream_SetSameFormat( x, p1, p2 ) \
        (x)->lpVtbl->SetSameFormat( x, p1, p2 )
    #define IDirectDrawMediaStream_AllocateSample( x, p1, p2 ) \
        (x)->lpVtbl->AllocateSample( x, p1, p2 )
    #define IDirectDrawMediaStream_CreateSharedSample( x, p1, p2, p3 ) \
        (x)->lpVtbl->CreateSharedSample( x, p1, p2, p3 )
    #define IDirectDrawMediaStream_SendEndOfStream( x, p ) \
        (x)->lpVtbl->SendEndOfStream( x, p )
    #define IDirectDrawMediaStream_GetFormat( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetFormat( x, p1, p2, p3, p4 )
    #define IDirectDrawMediaStream_SetFormat( x, p1, p2 ) \
        (x)->lpVtbl->SetFormat( x, p1, p2 )
    #define IDirectDrawMediaStream_GetDirectDraw( x, p ) \
        (x)->lpVtbl->GetDirectDraw( x, p )
    #define IDirectDrawMediaStream_SetDirectDraw( x, p ) \
        (x)->lpVtbl->SetDirectDraw( x, p )
    #define IDirectDrawMediaStream_CreateSample( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->CreateSample( x, p1, p2, p3, p4 )
    #define IDirectDrawMediaStream_GetTimePerFrame( x, p ) \
        (x)->lpVtbl->GetTimePerFrame( x, p )
    #define IDirectDrawStreamSample_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IDirectDrawStreamSample_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IDirectDrawStreamSample_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IDirectDrawStreamSample_GetMediaStream( x, p ) \
        (x)->lpVtbl->GetMediaStream( x, p )
    #define IDirectDrawStreamSample_GetSampleTimes( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetSampleTimes( x, p1, p2, p3 )
    #define IDirectDrawStreamSample_SetSampleTimes( x, p1, p2 ) \
        (x)->lpVtbl->SetSampleTimes( x, p1, p2 ) \
    #define IDirectDrawStreamSample_Update( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->Update( x, p1, p2, p3, p4 )
    #define IDirectDrawStreamSample_CompletionStatus( x, p1, p2 ) \
        (x)->lpVtbl->CompletionStatus( x, p1, p2 )
    #define IDirectDrawStreamSample_GetSurface( x, p1, p2 ) \
        (x)->lpVtbl->GetSurface( x, p1, p2 )
    #define IDirectDrawStreamSample_SetRect( x, p ) \
        (x)->lpVtbl->SetRect( x, p )
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

/* GUIDs */
EXTERN_C const IID  __cdecl IID_IDirectDrawMediaStream;
EXTERN_C const IID  __cdecl IID_IDirectDrawStreamSample;

#endif /* __ddstream_h__ */
