/*
 *  dimm.h      Active IMM interfaces
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#include <rpc.h>
#include <rpcndr.h>
#ifndef COM_NO_WINDOWS_H
    #include <windows.h>
    #include <ole2.h>
#endif

#ifndef __dimm_h__
#define __dimm_h__

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#include <imm.h>

#ifdef __cplusplus
extern "C" {
#endif

/* IME menu item string size */
#if (WINVER < 0x040A)
    #define IMEMENUITEM_STRING_SIZE 80
#endif

/* IME menu item information */
#if (WINVER < 0x040A)
typedef struct {
    UINT    cbSize;
    UINT    fType;
    UINT    fState;
    UINT    wID;
    HBITMAP hbmpChecked;
    HBITMAP hbmpUnchecked;
    DWORD   dwItemData;
    CHAR    szString[IMEMENUITEM_STRING_SIZE];
    HBITMAP hbmpItem;
} IMEMENUITEMINFOA;
typedef struct {
    UINT    cbSize;
    UINT    fType;
    UINT    fState;
    UINT    wID;
    HBITMAP hbmpChecked;
    HBITMAP hbmpUnchecked;
    DWORD   dwItemData;
    WCHAR   szString[IMEMENUITEM_STRING_SIZE];
    HBITMAP hbmpItem;
} IMEMENUITEMINFOW;
#endif

/* Input context */
#ifndef _DDKIMM_H_
typedef struct {
    HWND            hWnd;
    BOOL            fOpen;
    POINT           ptStatusWndPos;
    POINT           ptSoftKbdPos;
    DWORD           fdwConversion;
    DWORD           fdwSentence;
    union {
        LOGFONTA    A;
        LOGFONTW    W;
    } lfFont;
    COMPOSITIONFORM cfCompForm;
    CANDIDATEFORM   cfCandForm[4];
    HIMCC           hCompStr;
    HIMCC           hCandInfo;
    HIMCC           hGuideLine;
    HIMCC           hPrivate;
    DWORD           dwNumMsgBuf;
    HIMCC           hMsgBuf;
    DWORD           fdwInit;
    DWORD           dwReserve[3];
} INPUTCONTEXT;
#endif

/* IME information */
#ifndef _DDKIMM_H_
typedef struct {
    DWORD   dwPrivateDataSize;
    DWORD   fdwProperty;
    DWORD   fdwConversionCaps;
    DWORD   fdwSentenceCaps;
    DWORD   fdwUICaps;
    DWORD   fdwSCSCaps;
    DWORD   fdwSelectCaps;
} IMEINFO;
#endif

/* IEnumRegisterWordA interface */
#undef INTERFACE
#define INTERFACE   IEnumRegisterWordA
DECLARE_INTERFACE_( IEnumRegisterWordA, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IEnumRegisterWordA methods */
    STDMETHOD( Clone )( THIS_ IEnumRegisterWordA ** ) PURE;
    STDMETHOD( Next )( THIS_ ULONG, REGISTERWORDA *, ULONG * ) PURE;
    STDMETHOD( Reset )( THIS ) PURE;
    STDMETHOD( Skip )( THIS_ ULONG ) PURE;
};

/* IEnumRegisterWordW interface */
#undef INTERFACE
#define INTERFACE   IEnumRegisterWordW
DECLARE_INTERFACE_( IEnumRegisterWordW, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IEnumRegisterWordA methods */
    STDMETHOD( Clone )( THIS_ IEnumRegisterWordW ** ) PURE;
    STDMETHOD( Next )( THIS_ ULONG, REGISTERWORDW *, ULONG * ) PURE;
    STDMETHOD( Reset )( THIS ) PURE;
    STDMETHOD( Skip )( THIS_ ULONG ) PURE;
};

/* IEnumInputContext interface */
#undef INTERFACE
#define INTERFACE   IEnumInputContext
DECLARE_INTERFACE_( IEnumInputContext, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IEnumInputContext methods */
    STDMETHOD( Clone )( THIS_ IEnumInputContext ** ) PURE;
    STDMETHOD( Next )( THIS_ ULONG, HIMC *, ULONG * ) PURE;
    STDMETHOD( Reset )( THIS ) PURE;
    STDMETHOD( Skip )( THIS_ ULONG ) PURE;
};

/* IActiveIMMRegistrar interface */
#undef INTERFACE
#define INTERFACE   IActiveIMMRegistrar
DECLARE_INTERFACE_( IActiveIMMRegistrar, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IActiveIMMRegistrar methods */
    STDMETHOD( RegisterIME )( THIS_ REFCLSID, LANGID, LPCWSTR, LPCWSTR ) PURE;
    STDMETHOD( UnregisterIME )( THIS_ REFCLSID ) PURE;
};

/* IActiveIMMMessagePumpOwner interface */
#undef INTERFACE
#define INTERFACE   IActiveIMMMessagePumpOwner
DECLARE_INTERFACE_( IActiveIMMMessagePumpOwner, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IActiveIMMMessagePumpOwner methods */
    STDMETHOD( Start )( THIS ) PURE;
    STDMETHOD( End )( THIS ) PURE;
    STDMETHOD( OnTranslateMessage )( THIS_ const MSG * ) PURE;
    STDMETHOD( Puase )( THIS_ DWORD * ) PURE;
    STDMETHOD( Resume )( THIS_ DWORD ) PURE;
};

/* IActiveIMMApp interface */
#undef INTERFACE
#define INTERFACE   IActiveIMMApp
DECLARE_INTERFACE_( IActiveIMMApp, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IActiveIMMApp methods */
    STDMETHOD( AssociateContext )( THIS_ HWND, HIMC, HIMC * ) PURE;
    STDMETHOD( ConfigureIMEA )( THIS_ HKL, HWND, DWORD, REGISTERWORDA * ) PURE;
    STDMETHOD( ConfigureIMEW )( THIS_ HKL, HWND, DWORD, REGISTERWORDW * ) PURE;
    STDMETHOD( CreateContext )( THIS_ HIMC * ) PURE;
    STDMETHOD( DestroyContext )( THIS_ HIMC ) PURE;
    STDMETHOD( EnumRegisterWordA )( THIS_ HKL, LPSTR, DWORD, LPSTR, LPVOID, IEnumRegisterWordA ** ) PURE;
    STDMETHOD( EnumRegisterWordW )( THIS_ HKL, LPWSTR, DWORD, LPWSTR, LPVOID, IEnumRegisterWordW ** ) PURE;
    STDMETHOD( EscapeA )( THIS_ HKL, HIMC, UINT, LPVOID, LRESULT * ) PURE;
    STDMETHOD( EscapeW )( THIS_ HKL, HIMC, UINT, LPVOID, LRESULT * ) PURE;
    STDMETHOD( GetCandidateListA )( THIS_ HIMC, DWORD, UINT, CANDIDATELIST *, UINT * ) PURE;
    STDMETHOD( GetCandidateListW )( THIS_ HIMC, DWORD, UINT, CANDIDATELIST *, UINT * ) PURE;
    STDMETHOD( GetCandidateListCountA )( THIS_ HIMC, DWORD *, DWORD * ) PURE;
    STDMETHOD( GetCandidateListCountW )( THIS_ HIMC, DWORD *, DWORD * ) PURE;
    STDMETHOD( GetCandidateWindow )( THIS_ HIMC, DWORD, CANDIDATEFORM * ) PURE;
    STDMETHOD( GetCompositionFontA )( THIS_ HIMC, LOGFONTA * ) PURE;
    STDMETHOD( GetCompositionFontW )( THIS_ HIMC, LOGFONTW * ) PURE;
    STDMETHOD( GetCompositionStringA )( THIS_ HIMC, DWORD, DWORD, LONG *, LPVOID ) PURE;
    STDMETHOD( GetCompositionStringW )( THIS_ HIMC, DWORD, DWORD, LONG *, LPVOID ) PURE;
    STDMETHOD( GetCompositionWindow )( THIS_ HIMC, COMPOSITIONFORM * ) PURE;
    STDMETHOD( GetContext )( THIS_ HWND, HIMC * ) PURE;
    STDMETHOD( GetConversionListA )( THIS_ HKL, HIMC, LPSTR, UINT, UINT, CANDIDATELIST *, UINT * ) PURE;
    STDMETHOD( GetConversionListW )( THIS_ HKL, HIMC, LPWSTR, UINT, UINT, CANDIDATELIST *, UINT * ) PURE;
    STDMETHOD( GetConversionStatus )( THIS_ HIMC, DWORD *, DWORD * ) PURE;
    STDMETHOD( GetDefaultIMEWnd )( THIS_ HWND, HWND * ) PURE;
    STDMETHOD( GetDescriptionA )( THIS_ HKL, UINT, LPSTR, UINT * ) PURE;
    STDMETHOD( GetDescriptionW )( THIS_ HKL, UINT, LPWSTR, UINT * ) PURE;
    STDMETHOD( GetGuideLineA )( THIS_ HIMC, DWORD, DWORD, LPSTR, DWORD * ) PURE;
    STDMETHOD( GetGuideLineW )( THIS_ HIMC, DWORD, DWORD, LPWSTR, DWORD * ) PURE;
    STDMETHOD( GetIMEFileNameA )( THIS_ HKL, UINT, LPSTR, UINT * ) PURE;
    STDMETHOD( GetIMEFileNameW )( THIS_ HKL, UINT, LPWSTR, UINT * ) PURE;
    STDMETHOD( GetOpenStatus )( THIS_ HIMC ) PURE;
    STDMETHOD( GetProperty )( THIS_ HKL, DWORD, DWORD * ) PURE;
    STDMETHOD( GetRegisterWordStyleA )( THIS_ HKL, UINT, STYLEBUFA *, UINT * ) PURE;
    STDMETHOD( GetRegisterWordStyleW )( THIS_ HKL, UINT, STYLEBUFW *, UINT * ) PURE;
    STDMETHOD( GetStatusWindowPos )( THIS_ HIMC, POINT * ) PURE;
    STDMETHOD( GetVirtualKey )( THIS_ HWND, UINT * ) PURE;
    STDMETHOD( InstallIMEA )( THIS_ LPSTR, LPSTR, HKL * ) PURE;
    STDMETHOD( InstallIMEW )( THIS_ LPWSTR, LPWSTR, HKL * ) PURE;
    STDMETHOD( IsIME )( THIS_ HKL ) PURE;
    STDMETHOD( IsUIMessageA )( THIS_ HWND, UINT, WPARAM, LPARAM ) PURE;
    STDMETHOD( IsUIMessageW )( THIS_ HWND, UINT, WPARAM, LPARAM ) PURE;
    STDMETHOD( NotifyIME )( THIS_ HIMC, DWORD, DWORD, DWORD ) PURE;
    STDMETHOD( RegisterWordA )( THIS_ HKL, LPSTR, DWORD, LPSTR ) PURE;
    STDMETHOD( RegisterWordW )( THIS_ HKL, LPWSTR, DWORD, LPWSTR ) PURE;
    STDMETHOD( ReleaseContext )( THIS_ HWND, HIMC ) PURE;
    STDMETHOD( SetCandidateWindow )( THIS_ HIMC, CANDIDATEFORM * ) PURE;
    STDMETHOD( SetCompositionFontA )( THIS_ HIMC, LOGFONTA * ) PURE;
    STDMETHOD( SetCompositionFontW )( THIS_ HIMC, LOGFONTW * ) PURE;
    STDMETHOD( SetCompositionStringA )( THIS_ HIMC, DWORD, LPVOID, DWORD, LPVOID, DWORD ) PURE;
    STDMETHOD( SetCompositionStringW )( THIS_ HIMC, DWORD, LPVOID, DWORD, LPVOID, DWORD ) PURE;
    STDMETHOD( SetCompositionWindow )( THIS_ HIMC, COMPOSITIONFORM * ) PURE;
    STDMETHOD( SetConversionStatus )( THIS_ HIMC, DWORD, DWORD ) PURE;
    STDMETHOD( SetOpenStatus )( THIS_ HIMC, BOOL ) PURE;
    STDMETHOD( SetStatusWindowPos )( THIS_ HIMC, POINT * ) PURE;
    STDMETHOD( SimulateHotKey )( THIS_ HWND, DWORD ) PURE;
    STDMETHOD( UnregisterWordA )( THIS_ HKL, LPSTR, DWORD, LPSTR ) PURE;
    STDMETHOD( UnregisterWordW )( THIS_ HKL, LPWSTR, DWORD, LPWSTR ) PURE;
    STDMETHOD( Activate )( THIS_ BOOL ) PURE;
    STDMETHOD( Deactivate )( THIS ) PURE;
    STDMETHOD( OnDefWindowProc )( THIS_ HWND, UINT, WPARAM, LPARAM, LRESULT * ) PURE;
    STDMETHOD( FilterClientWindows )( THIS_ ATOM *, UINT ) PURE;
    STDMETHOD( GetCodePageA )( THIS_ HKL, UINT * ) PURE;
    STDMETHOD( GetLangId )( THIS_ HKL, LANGID * ) PURE;
    STDMETHOD( AssociateContextEx )( THIS_ HWND, HIMC, DWORD ) PURE;
    STDMETHOD( DisableIME )( THIS_ DWORD ) PURE;
    STDMETHOD( GetImeMenuItemsA )( THIS_ HIMC, DWORD, DWORD, IMEMENUITEMINFOA *, IMEMENUITEMINFOA *, DWORD, DWORD * ) PURE;
    STDMETHOD( GetImeMenuItemsW )( THIS_ HIMC, DWORD, DWORD, IMEMENUITEMINFOW *, IMEMENUITEMINFOW *, DWORD, DWORD * ) PURE;
    STDMETHOD( EnumInputContext )( THIS_ DWORD, IEnumInputContext ** ) PURE;
};

/* IActiveIMMIME interface */
#undef INTERFACE
#define INTERFACE   IActiveIMMIME
DECLARE_INTERFACE_( IActiveIMMIME, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IActiveIMMIME methods */
    STDMETHOD( AssociateContext )( THIS_ HWND, HIMC, HIMC * ) PURE;
    STDMETHOD( ConfigureIMEA )( THIS_ HKL, HWND, DWORD, REGISTERWORDA * ) PURE;
    STDMETHOD( ConfigureIMEW )( THIS_ HKL, HWND, DWORD, REGISTERWORDW * ) PURE;
    STDMETHOD( CreateContext )( THIS_ HIMC * ) PURE;
    STDMETHOD( DestroyContext )( THIS_ HIMC ) PURE;
    STDMETHOD( EnumRegisterWordA )( THIS_ HKL, LPSTR, DWORD, LPSTR, LPVOID, IEnumRegisterWordA ** ) PURE;
    STDMETHOD( EnumRegisterWordW )( THIS_ HKL, LPWSTR, DWORD, LPWSTR, LPVOID, IEnumRegisterWordW ** ) PURE;
    STDMETHOD( EscapeA )( THIS_ HKL, HIMC, UINT, LPVOID, LRESULT * ) PURE;
    STDMETHOD( EscapeW )( THIS_ HKL, HIMC, UINT, LPVOID, LRESULT * ) PURE;
    STDMETHOD( GetCandidateListA )( THIS_ HIMC, DWORD, UINT, CANDIDATELIST *, UINT * ) PURE;
    STDMETHOD( GetCandidateListW )( THIS_ HIMC, DWORD, UINT, CANDIDATELIST *, UINT * ) PURE;
    STDMETHOD( GetCandidateListCountA )( THIS_ HIMC, DWORD *, DWORD * ) PURE;
    STDMETHOD( GetCandidateListCountW )( THIS_ HIMC, DWORD *, DWORD * ) PURE;
    STDMETHOD( GetCandidateWindow )( THIS_ HIMC, DWORD, CANDIDATEFORM * ) PURE;
    STDMETHOD( GetCompositionFontA )( THIS_ HIMC, LOGFONTA * ) PURE;
    STDMETHOD( GetCompositionFontW )( THIS_ HIMC, LOGFONTW * ) PURE;
    STDMETHOD( GetCompositionStringA )( THIS_ HIMC, DWORD, DWORD, LONG *, LPVOID ) PURE;
    STDMETHOD( GetCompositionStringW )( THIS_ HIMC, DWORD, DWORD, LONG *, LPVOID ) PURE;
    STDMETHOD( GetCompositionWindow )( THIS_ HIMC, COMPOSITIONFORM * ) PURE;
    STDMETHOD( GetContext )( THIS_ HWND, HIMC * ) PURE;
    STDMETHOD( GetConversionListA )( THIS_ HKL, HIMC, LPSTR, UINT, UINT, CANDIDATELIST *, UINT * ) PURE;
    STDMETHOD( GetConversionListW )( THIS_ HKL, HIMC, LPWSTR, UINT, UINT, CANDIDATELIST *, UINT * ) PURE;
    STDMETHOD( GetConversionStatus )( THIS_ HIMC, DWORD *, DWORD * ) PURE;
    STDMETHOD( GetDefaultIMEWnd )( THIS_ HWND, HWND * ) PURE;
    STDMETHOD( GetDescriptionA )( THIS_ HKL, UINT, LPSTR, UINT * ) PURE;
    STDMETHOD( GetDescriptionW )( THIS_ HKL, UINT, LPWSTR, UINT * ) PURE;
    STDMETHOD( GetGuideLineA )( THIS_ HIMC, DWORD, DWORD, LPSTR, DWORD * ) PURE;
    STDMETHOD( GetGuideLineW )( THIS_ HIMC, DWORD, DWORD, LPWSTR, DWORD * ) PURE;
    STDMETHOD( GetIMEFileNameA )( THIS_ HKL, UINT, LPSTR, UINT * ) PURE;
    STDMETHOD( GetIMEFileNameW )( THIS_ HKL, UINT, LPWSTR, UINT * ) PURE;
    STDMETHOD( GetOpenStatus )( THIS_ HIMC ) PURE;
    STDMETHOD( GetProperty )( THIS_ HKL, DWORD, DWORD * ) PURE;
    STDMETHOD( GetRegisterWordStyleA )( THIS_ HKL, UINT, STYLEBUFA *, UINT * ) PURE;
    STDMETHOD( GetRegisterWordStyleW )( THIS_ HKL, UINT, STYLEBUFW *, UINT * ) PURE;
    STDMETHOD( GetStatusWindowPos )( THIS_ HIMC, POINT * ) PURE;
    STDMETHOD( GetVirtualKey )( THIS_ HWND, UINT * ) PURE;
    STDMETHOD( InstallIMEA )( THIS_ LPSTR, LPSTR, HKL * ) PURE;
    STDMETHOD( InstallIMEW )( THIS_ LPWSTR, LPWSTR, HKL * ) PURE;
    STDMETHOD( IsIME )( THIS_ HKL ) PURE;
    STDMETHOD( IsUIMessageA )( THIS_ HWND, UINT, WPARAM, LPARAM ) PURE;
    STDMETHOD( IsUIMessageW )( THIS_ HWND, UINT, WPARAM, LPARAM ) PURE;
    STDMETHOD( NotifyIME )( THIS_ HIMC, DWORD, DWORD, DWORD ) PURE;
    STDMETHOD( RegisterWordA )( THIS_ HKL, LPSTR, DWORD, LPSTR ) PURE;
    STDMETHOD( RegisterWordW )( THIS_ HKL, LPWSTR, DWORD, LPWSTR ) PURE;
    STDMETHOD( ReleaseContext )( THIS_ HWND, HIMC ) PURE;
    STDMETHOD( SetCandidateWindow )( THIS_ HIMC, CANDIDATEFORM * ) PURE;
    STDMETHOD( SetCompositionFontA )( THIS_ HIMC, LOGFONTA * ) PURE;
    STDMETHOD( SetCompositionFontW )( THIS_ HIMC, LOGFONTW * ) PURE;
    STDMETHOD( SetCompositionStringA )( THIS_ HIMC, DWORD, LPVOID, DWORD, LPVOID, DWORD ) PURE;
    STDMETHOD( SetCompositionStringW )( THIS_ HIMC, DWORD, LPVOID, DWORD, LPVOID, DWORD ) PURE;
    STDMETHOD( SetCompositionWindow )( THIS_ HIMC, COMPOSITIONFORM * ) PURE;
    STDMETHOD( SetConversionStatus )( THIS_ HIMC, DWORD, DWORD ) PURE;
    STDMETHOD( SetOpenStatus )( THIS_ HIMC, BOOL ) PURE;
    STDMETHOD( SetStatusWindowPos )( THIS_ HIMC, POINT * ) PURE;
    STDMETHOD( SimulateHotKey )( THIS_ HWND, DWORD ) PURE;
    STDMETHOD( UnregisterWordA )( THIS_ HKL, LPSTR, DWORD, LPSTR ) PURE;
    STDMETHOD( UnregisterWordW )( THIS_ HKL, LPWSTR, DWORD, LPWSTR ) PURE;
    STDMETHOD( GenerateMessage )( THIS_ HIMC ) PURE;
    STDMETHOD( LockIMC )( THIS_ HIMC, INPUTCONTEXT ** ) PURE;
    STDMETHOD( UnlockIMC )( THIS_ HIMC ) PURE;
    STDMETHOD( GetIMCLockCount )( THIS_ HIMC, DWORD * ) PURE;
    STDMETHOD( CreateIMCC )( THIS_ DWORD, HIMCC * ) PURE;
    STDMETHOD( DestroyIMCC )( THIS_ HIMCC ) PURE;
    STDMETHOD( LockIMCC )( THIS_ HIMCC, void ** ) PURE;
    STDMETHOD( UnlockIMCC )( THIS_ HIMCC ) PURE;
    STDMETHOD( ReSizeIMCC )( THIS_ HIMCC, DWORD, HIMCC * ) PURE;
    STDMETHOD( GetIMCCSize )( THIS_ HIMCC, DWORD * ) PURE;
    STDMETHOD( GetIMCCLockCount )( THIS_ HIMCC, DWORD * ) PURE;
    STDMETHOD( GetHotKey )( THIS_ DWORD, UINT *, UINT *, HKL * ) PURE;
    STDMETHOD( SetHotKey )( THIS_ DWORD, UINT, UINT, HKL ) PURE;
    STDMETHOD( CreateSoftKeyboard )( THIS_ UINT, HWND, int, int, HWND * ) PURE;
    STDMETHOD( DestroySoftKeyboard )( THIS_ HWND ) PURE;
    STDMETHOD( ShowSoftKeyboard )( THIS_ HWND, int ) PURE;
    STDMETHOD( GetCodePageA )( THIS_ HKL, UINT * ) PURE;
    STDMETHOD( GetLangId )( THIS_ HKL, LANGID * ) PURE;
    STDMETHOD( KeybdEvent )( THIS_ LANGID, BYTE, BYTE, DWORD, DWORD ) PURE;
    STDMETHOD( LockModal )( THIS ) PURE;
    STDMETHOD( UnlockModal )( THIS ) PURE;
    STDMETHOD( AssociateContextEx )( THIS_ HWND, HIMC, DWORD ) PURE;
    STDMETHOD( DisableIME )( THIS_ DWORD ) PURE;
    STDMETHOD( GetImeMenuItemsA )( THIS_ HIMC, DWORD, DWORD, IMEMENUITEMINFOA *, IMEMENUITEMINFOA *, DWORD, DWORD * ) PURE;
    STDMETHOD( GetImeMenuItemsW )( THIS_ HIMC, DWORD, DWORD, IMEMENUITEMINFOW *, IMEMENUITEMINFOW *, DWORD, DWORD * ) PURE;
    STDMETHOD( EnumInputContext )( THIS_ DWORD, IEnumInputContext ** ) PURE;
    STDMETHOD( RequestMessageA )( THIS_ HIMC, WPARAM, LPARAM, LRESULT * ) PURE;
    STDMETHOD( RequestMessageW )( THIS_ HIMC, WPARAM, LPARAM, LRESULT * ) PURE;
    STDMETHOD( SendIMCA )( THIS_ HWND, UINT, WPARAM, LPARAM, LRESULT * ) PURE;
    STDMETHOD( SendIMCW )( THIS_ HWND, UINT, WPARAM, LPARAM, LRESULT * ) PURE;
    STDMETHOD( IsSleeping )( THIS ) PURE;
};

/* IActiveIME interface */
#undef INTERFACE
#define INTERFACE   IActiveIME
DECLARE_INTERFACE_( IActiveIME, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IActiveIME methods */
    STDMETHOD( Inquire )( THIS_ DWORD, IMEINFO *, LPWSTR, DWORD * ) PURE;
    STDMETHOD( ConversionList )( THIS_ HIMC, LPWSTR, UINT, UINT, CANDIDATELIST *, UINT * ) PURE;
    STDMETHOD( Configure )( THIS_ HKL, HWND, DWORD, REGISTERWORDW * ) PURE;
    STDMETHOD( Destroy )( THIS_ UINT ) PURE;
    STDMETHOD( Escape )( THIS_ HIMC, UINT, void *, LRESULT * ) PURE;
    STDMETHOD( SetActiveContext )( THIS_ HIMC, BOOL ) PURE;
    STDMETHOD( ProcessKey )( THIS_ HIMC, UINT, DWORD, BYTE * ) PURE;
    STDMETHOD( Notify )( THIS_ HIMC, DWORD, DWORD, DWORD ) PURE;
    STDMETHOD( Select )( THIS_ HIMC, BOOL ) PURE;
    STDMETHOD( SetCompositionString )( THIS_ HIMC, DWORD, void *, DWORD, void *, DWORD ) PURE;
    STDMETHOD( ToAsciiEx )( THIS_ UINT, UINT, BYTE *, UINT, HIMC, DWORD *, UINT * ) PURE;
    STDMETHOD( RegisterWord )( THIS_ LPWSTR, DWORD, LPWSTR ) PURE;
    STDMETHOD( UnregisterWord )( THIS_ LPWSTR, DWORD, LPWSTR ) PURE;
    STDMETHOD( GetRegisterWordStyle )( THIS_ UINT, STYLEBUFW *, UINT * ) PURE;
    STDMETHOD( EnumRegisterWord )( THIS_ LPWSTR, DWORD, LPWSTR, LPVOID, IEnumRegisterWordW ** ) PURE;
    STDMETHOD( GetCodePageA )( THIS_ UINT * ) PURE;
    STDMETHOD( GetLangId )( THIS_ LANGID * ) PURE;
};

/* IActiveIME2 interface */
#undef INTERFACE
#define INTERFACE   IActiveIME2
DECLARE_INTERFACE_( IActiveIME2, IActiveIME ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IActiveIME methods */
    STDMETHOD( Inquire )( THIS_ DWORD, IMEINFO *, LPWSTR, DWORD * ) PURE;
    STDMETHOD( ConversionList )( THIS_ HIMC, LPWSTR, UINT, UINT, CANDIDATELIST *, UINT * ) PURE;
    STDMETHOD( Configure )( THIS_ HKL, HWND, DWORD, REGISTERWORDW * ) PURE;
    STDMETHOD( Destroy )( THIS_ UINT ) PURE;
    STDMETHOD( Escape )( THIS_ HIMC, UINT, void *, LRESULT * ) PURE;
    STDMETHOD( SetActiveContext )( THIS_ HIMC, BOOL ) PURE;
    STDMETHOD( ProcessKey )( THIS_ HIMC, UINT, DWORD, BYTE * ) PURE;
    STDMETHOD( Notify )( THIS_ HIMC, DWORD, DWORD, DWORD ) PURE;
    STDMETHOD( Select )( THIS_ HIMC, BOOL ) PURE;
    STDMETHOD( SetCompositionString )( THIS_ HIMC, DWORD, void *, DWORD, void *, DWORD ) PURE;
    STDMETHOD( ToAsciiEx )( THIS_ UINT, UINT, BYTE *, UINT, HIMC, DWORD *, UINT * ) PURE;
    STDMETHOD( RegisterWord )( THIS_ LPWSTR, DWORD, LPWSTR ) PURE;
    STDMETHOD( UnregisterWord )( THIS_ LPWSTR, DWORD, LPWSTR ) PURE;
    STDMETHOD( GetRegisterWordStyle )( THIS_ UINT, STYLEBUFW *, UINT * ) PURE;
    STDMETHOD( EnumRegisterWord )( THIS_ LPWSTR, DWORD, LPWSTR, LPVOID, IEnumRegisterWordW ** ) PURE;
    STDMETHOD( GetCodePageA )( THIS_ UINT * ) PURE;
    STDMETHOD( GetLangId )( THIS_ LANGID * ) PURE;

    /* IActiveIME2 methods */
    STDMETHOD( Sleep )( THIS ) PURE;
    STDMETHOD( Unsleep )( THIS_ BOOL ) PURE;
};

/* C object macros */
#if (!defined( __cplusplus ) || defined( CINTERFACE )) && defined( COBJMACROS )
    #define IEnumRegisterWordA_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IEnumRegisterWordA_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IEnumRegisterWordA_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IEnumRegisterWordA_Clone( x, p ) \
        (x)->lpVtbl->Clone( x, p )
    #define IEnumRegisterWordA_Next( x, p1, p2, p3 ) \
        (x)->lpVtbl->Next( x, p1, p2, p3 )
    #define IEnumRegisterWordA_Reset( x ) \
        (x)->lpVtbl->Reset( x )
    #define IEnumRegisterWordA_Skip( x, p ) \
        (x)->lpVtbl->Skip( x, p )
    #define IEnumRegisterWordW_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IEnumRegisterWordW_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IEnumRegisterWordW_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IEnumRegisterWordW_Clone( x, p ) \
        (x)->lpVtbl->Clone( x, p )
    #define IEnumRegisterWordW_Next( x, p1, p2, p3 ) \
        (x)->lpVtbl->Next( x, p1, p2, p3 )
    #define IEnumRegisterWordW_Reset( x ) \
        (x)->lpVtbl->Reset( x )
    #define IEnumRegisterWordW_Skip( x, p ) \
        (x)->lpVtbl->Skip( x, p )
    #define IEnumInputContext_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IEnumInputContext_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IEnumInputContext_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IEnumInputContext_Clone( x, p ) \
        (x)->lpVtbl->Clone( x, p )
    #define IEnumInputContext_Next( x, p1, p2, p3 ) \
        (x)->lpVtbl->Next( x, p1, p2, p3 )
    #define IEnumInputContext_Reset( x ) \
        (x)->lpVtbl->Reset( x )
    #define IEnumInputContext_Skip( x, p ) \
        (x)->lpVtbl->Skip( x, p )
    #define IActiveIMMRegistrar_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IActiveIMMRegistrar_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IActiveIMMRegistrar_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IActiveIMMRegistrar_RegisterIME( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->RegisterIME( x, p1, p2, p3, p4 )
    #define IActiveIMMRegistrar_UnregisterIME( x, p ) \
        (x)->lpVtbl->UnregisterIME( x, p )
    #define IActiveIMMMessagePumpOwner_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IActiveIMMMessagePumpOwner_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IActiveIMMMessagePumpOwner_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IActiveIMMMessagePumpOwner_Start( x ) \
        (x)->lpVtbl->Start( x )
    #define IActiveIMMMessagePumpOwner_End( x ) \
        (x)->lpVtbl->End( x )
    #define IActiveIMMMessagePumpOwner_OnTranslateMessage( x, p ) \
        (x)->lpVtbl->OnTranslateMessage( x, p )
    #define IActiveIMMMessagePumpOwner_Pause( x, p ) \
        (x)->lpVtbl->Pause( x, p )
    #define IActiveIMMMessagePumpOwner_Resume( x, p ) \
        (x)->lpVtbl->Resume( x, p )
    #define IActiveIMMApp_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IActiveIMMApp_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IActiveIMMApp_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IActiveIMMApp_AssociateContext( x, p1, p2, p3 ) \
        (x)->lpVtbl->AssociateContext( x, p1, p2, p3 )
    #define IActiveIMMApp_ConfigureIMEA( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->ConfigureIMEA( x, p1, p2, p3, p4 )
    #define IActiveIMMApp_ConfigureIMEW( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->ConfigureIMEW( x, p1, p2, p3, p4 )
    #define IActiveIMMApp_CreateContext( x, p ) \
        (x)->lpVtbl->CreateContext( x, p )
    #define IActiveIMMApp_DestroyContext( x ) \
        (x)->lpVtbl->DestroyContext( x )
    #define IActiveIMMApp_EnumRegisterWordA( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->EnumRegisterWordA( x, p1, p2, p3, p4, p5, p6 )
    #define IActiveIMMApp_EnumRegisterWordW( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->EnumRegisterWordW( x, p1, p2, p3, p4, p5, p6 )
    #define IActiveIMMApp_EscapeA( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->EscapeA( x, p1, p2, p3, p4, p5 )
    #define IActiveIMMApp_EscapeW( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->EscapeW( x, p1, p2, p3, p4, p5 )
    #define IActiveIMMApp_GetCandidateListA( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetCandidateListA( x, p1, p2, p3, p4, p5 )
    #define IActiveIMMApp_GetCandidateListW( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetCandidateListW( x, p1, p2, p3, p4, p5 )
    #define IActiveIMMApp_GetCandidateListCountA( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetCandidateListCountA( x, p1, p2, p3 )
    #define IActiveIMMApp_GetCandidateListCountW( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetCandidateListCountW( x, p1, p2, p3 )
    #define IActiveIMMApp_GetCandidateWindow( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetCandidateWindow( x, p1, p2, p3 )
    #define IActiveIMMApp_GetCompositionFontA( x, p1, p2 ) \
        (x)->lpVtbl->GetCompositionFontA( x, p1, p2 )
    #define IActiveIMMApp_GetComposotionFontW( x, p1, p2 ) \
        (x)->lpVtbl->GetCompositionFontW( x, p1, p2 )
    #define IActiveIMMApp_GetCompositionStringA( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetCompositionStringA( x, p1, p2, p3, p4, p5 )
    #define IActiveIMMApp_GetCompositionStringW( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetCompositionStringW( x, p1, p2, p3, p4, p5 )
    #define IActiveIMMApp_GetCompositionWindow( x, p1, p2 ) \
        (x)->lpVtbl->GetCompositionWindow( x, p1, p2 )
    #define IActiveIMMApp_GetContext( x, p1, p2 ) \
        (x)->lpVtbl->GetContext( x, p1, p2 )
    #define IActiveIMMApp_GetConversionListA( x, p1, p2, p3, p4, p5, p6, p7 ) \
        (x)->lpVtbl->GetConversionListA( x, p1, p2, p3, p4, p5, p6, p7 )
    #define IActiveIMMApp_GetConversionListW( x, p1, p2, p3, p4, p5, p6, p7 ) \
        (x)->lpVtbl->GetConversionListW( x, p1, p2, p3, p4, p5, p6, p7 )
    #define IActiveIMMApp_GetConversionStatus( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetConversionStatus( x, p1, p2, p3 )
    #define IActiveIMMApp_GetDefaultIMEWnd( x, p1, p2 ) \
        (x)->lpVtbl->GetDefaultIMEWnd( x, p1, p2 )
    #define IActiveIMMApp_GetDescriptionA( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetDescriptionA( x, p1, p2, p3, p4 )
    #define IActiveIMMApp_GetDescriptionW( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetDescriptionW( x, p1, p2, p3, p4 )
    #define IActiveIMMApp_GetGuideLineA( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetGuideLineA( x, p1, p2, p3, p4, p5 )
    #define IActiveIMMApp_GetGuideLineW( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetGuideLineW( x, p1, p2, p3, p4, p5 )
    #define IActiveIMMApp_GetIMEFileNameA( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetIMEFileNameA( x, p1, p2, p3, p4 )
    #define IActiveIMMApp_GetIMEFileNameW( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetIMEFileNameW( x, p1, p2, p3, p4 )
    #define IActiveIMMApp_GetOpenStatus( x, p ) \
        (x)->lpVtbl->GetOpenStatus( x, p )
    #define IActiveIMMApp_GetProperty( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetProperty( x, p1, p2, p3 )
    #define IActiveIMMApp_GetRegisterWordStyleA( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetRegisterWordStyleA( x, p1, p2, p3, p4 )
    #define IActiveIMMApp_GetRegisterWordStyleW( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetRegisterWordStyleW( x, p1, p2, p3, p4 )
    #define IActiveIMMApp_GetStatusWindowPos( x, p1, p2 ) \
        (x)->lpVtbl->GetStatusWindowPos( x, p1, p2 )
    #define IActiveIMMApp_GetVirtualKey( x, p1, p2 ) \
        (x)->lpVtbl->GetVirtualKey( x, p1, p2 )
    #define IActiveIMMApp_InstallIMEA( x, p1, p2, p3 ) \
        (x)->lpVtbl->InstallIMEA( x, p1, p2, p3 )
    #define IActiveIMMApp_InstallIMEW( x, p1, p2, p3 ) \
        (x)->lpVtbl->InstallIMEW( x, p1, p2, p3 )
    #define IActiveIMMApp_IsIME( x, p ) \
        (x)->lpVtbl->IsIME( x, p )
    #define IActiveIMMApp_IsUIMessageA( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->IsUIMessageA( x, p1, p2, p3, p4 )
    #define IActiveIMMApp_IsUIMessageW( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->IsUIMessageW( x, p1, p2, p3, p4 )
    #define IActiveIMMApp_NotifyIME( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->NotifyIME( x, p1, p2, p3, p4 )
    #define IActiveIMMApp_RegisterWordA( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->RegisterWordA( x, p1, p2, p3, p4 )
    #define IActiveIMMApp_RegisterWordW( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->RegisterWordW( x, p1, p2, p3, p4 )
    #define IActiveIMMApp_ReleaseContext( x, p1, p2 ) \
        (x)->lpVtbl->ReleaseContext( x, p1, p2 )
    #define IActiveIMMApp_SetCandidateWindow( x, p1, p2 ) \
        (x)->lpVtbl->SetCandidateWindow( x, p1, p2 )
    #define IActiveIMMApp_SetCompositionFontA( x, p1, p2 ) \
        (x)->lpVtbl->SetCompositionFontA( x, p1, p2 )
    #define IActiveIMMApp_SetCompositionFontW( x, p1, p2 ) \
        (x)->lpVtbl->SetCompositionFontW( x, p1, p2 )
    #define IActiveIMMApp_SetCompositionStringA( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->SetCompositionStringA( x, p1, p2, p3, p4, p5, p6 )
    #define IActiveIMMApp_SetCompositionStringW( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->SetCompositionStringW( x, p1, p2, p3, p4, p5, p6 )
    #define IActiveIMMApp_SetCompositionWindow( x, p1, p2 ) \
        (x)->lpVtbl->SetCompositionWindow( x, p1, p2 )
    #define IActiveIMMApp_SetConversionStatus( x, p1, p2, p3 ) \
        (x)->lpVtbl->SetConversionStatus( x, p1, p2, p3 )
    #define IActiveIMMApp_SetOpenStatus( x, p1, p2 ) \
        (x)->lpVtbl->SetOpenStatus( x, p1, p2 )
    #define IActiveIMMApp_SetStatusWindowPos( x, p1, p2 ) \
        (x)->lpVtbl->SetStatusWindowPos( x, p1, p2 )
    #define IActiveIMMApp_SimulateHotKey( x, p1, p2 ) \
        (x)->lpVtbl->SimulateHotKey( x, p1, p2 )
    #define IActiveIMMApp_UnregisterWordA( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->UnregisterWordA( x, p1, p2, p3, p4 )
    #define IActiveIMMApp_UnregisterWordW( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->UnregisterWordW( x, p1, p2, p3, p4 )
    #define IActiveIMMApp_Activate( x, p ) \
        (x)->lpVtbl->Activate( x, p )
    #define IActiveIMMApp_Deactivate( x ) \
        (x)->lpVtbl->Deactivate( x )
    #define IActiveIMMApp_OnDefWindowProc( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->OnDefWindowProc( x, p1, p2, p3, p4, p5 )
    #define IActiveIMMApp_FilterClientWindows( x, p1, p2 ) \
        (x)->lpVtbl->FilterClientWindows( x, p1, p2 )
    #define IActiveIMMApp_GetCodePageA( x, p1, p2 ) \
        (x)->lpVtbl->GetCodePageA( x, p1, p2 )
    #define IActiveIMMApp_GetLangId( x, p1, p2 ) \
        (x)->lpVtbl->GetLangId( x, p1, p2 )
    #define IActiveIMMApp_AssociateContextEx( x, p1, p2, p3 ) \
        (x)->lpVtbl->AssociateContextEx( x, p1, p2, p3 )
    #define IActiveIMMApp_DisableIME( x, p ) \
        (x)->lpVtbl->DisableIME( x, p )
    #define IActiveIMMApp_GetImeMenuItemsA( x, p1, p2, p3, p4, p5, p6, p7 ) \
        (x)->lpVtbl->GetImeMenuItemsA( x, p1, p2, p3, p4, p5, p6, p7 )
    #define IActiveIMMApp_GetImeMenuItemsW( x, p1, p2, p3, p4, p5, p6, p7 ) \
        (x)->lpVtbl->GetImeMenuItemsW( x, p1, p2, p3, p4, p5, p6, p7 )
    #define IActiveIMMApp_EnumInputContext( x, p1, p2 ) \
        (x)->lpVtbl->EnumInputContext( x, p1, p2 )
    #define IActiveIMMIME_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IActiveIMMIME_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IActiveIMMIME_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IActiveIMMIME_AssociateContext( x, p1, p2, p3 ) \
        (x)->lpVtbl->AssociateContext( x, p1, p2, p3 )
    #define IActiveIMMIME_ConfigureIMEA( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->ConfigureIMEA( x, p1, p2, p3, p4 )
    #define IActiveIMMIME_ConfigureIMEW( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->ConfigureIMEW( x, p1, p2, p3, p4 )
    #define IActiveIMMIME_CreateContext( x, p ) \
        (x)->lpVtbl->CreateContext( x, p )
    #define IActiveIMMIME_DestroyContext( x, p ) \
        (x)->lpVtbl->DestroyContext( x, p )
    #define IActiveIMMIME_EnumRegisterWordA( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->EnumRegisterWordA( x, p1, p2, p3, p4, p5, p6 )
    #define IActiveIMMIME_EnumRegisterWordW( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->EnumRegisterWordW( x, p1, p2, p3, p4, p5, p6 )
    #define IActiveIMMIME_EscapeA( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->EscapeA( x, p1, p2, p3, p4, p5 )
    #define IActiveIMMIME_EscapeW( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->EscapeW( x, p1, p2, p3, p4, p5 )
    #define IActiveIMMIME_GetCandidateListA( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetCandidateListA( x, p1, p2, p3, p4, p5 )
    #define IActiveIMMIME_GetCandidateListW( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetCandidateListW( x, p1, p2, p3, p4, p5 )
    #define IActiveIMMIME_GetCandidateListCountA( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetCandidateListCountA( x, p1, p2, p3 )
    #define IActiveIMMIME_GetCandidateListCountW( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetCandidateListCountW( x, p1, p2, p3 )
    #define IActiveIMMIME_GetCandidateWindow( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetCandidateWindow( x, p1, p2, p3 )
    #define IActiveIMMIME_GetCompositionFontA( x, p1, p2 ) \
        (x)->lpVtbl->GetCompositionFontA( x, p1, p2 )
    #define IActiveIMMIME_GetCompositionFontW( x, p1, p2 ) \
        (x)->lpVtbl->GetCompositionFontW( x, p1, p2 )
    #define IActiveIMMIME_GetCompositionStringA( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetCompositionStringA( x, p1, p2, p3, p4, p5 )
    #define IActiveIMMIME_GetCompositionStringW( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetCompositionStringW( x, p1, p2, p3, p4, p5 )
    #define IActiveIMMIME_GetCompositionWindow( x, p1, p2 ) \
        (x)->lpVtbl->GetCompositionWindow( x, p1, p2 )
    #define IActiveIMMIME_GetContext( x, p1, p2 ) \
        (x)->lpVtbl->GetContext( x, p1, p2 )
    #define IActiveIMMIME_GetConversionListA( x, p1, p2, p3, p4, p5, p6, p7 ) \
        (x)->lpVtbl->GetConversionListA( x, p1, p2, p3, p4, p5, p6, p7 )
    #define IActiveIMMIME_GetConversionListW( x, p1, p2, p3, p4, p5, p6, p7 ) \
        (x)->lpVtbl->GetConversionListW( x, p1, p2, p3, p4, p5, p6, p7 )
    #define IActiveIMMIME_GetConversionStatus( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetConversionStatus( x, p1, p2, p3 )
    #define IActiveIMMIME_GetDefaultIMEWnd( x, p1, p2 ) \
        (x)->lpVtbl->GetDefaultIMEWnd( x, p1, p2 )
    #define IActiveIMMIME_GetDescriptionA( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetDescriptionA( x, p1, p2, p3, p4 )
    #define IActiveIMMIME_GetDescriptionW( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetDescriptionW( x, p1, p2, p3, p4 )
    #define IActiveIMMIME_GetGuideLineA( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetGuideLineA( x, p1, p2, p3, p4, p5 )
    #define IActiveIMMIME_GetGuideLineW( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetGuideLineW( x, p1, p2, p3, p4, p5 )
    #define IActiveIMMIME_GetIMEFileNameA( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetIMEFileNameA( x, p1, p2, p3, p4 )
    #define IActiveIMMIME_GetIMEFileNameW( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetIMEFileNameW( x, p1, p2, p3, p4 )
    #define IActiveIMMIME_GetOpenStatus( x, p ) \
        (x)->lpVtbl->GetOpenStatus( x, p )
    #define IActiveIMMIME_GetProperty( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetProperty( x, p1, p2, p3 )
    #define IActiveIMMIME_GetRegisterWordStyleA( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetRegisterWordStyleA( x, p1, p2, p3, p4 )
    #define IActiveIMMIME_GetRegisterWordStyleW( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetRegisterWordStyleW( x, p1, p2, p3, p4 )
    #define IActiveIMMIME_GetStatusWindowPos( x, p1, p2 ) \
        (x)->lpVtbl->GetStatusWindowPos( x, p1, p2 )
    #define IActiveIMMIME_GetVirtualKey( x, p1, p2 ) \
        (x)->lpVtbl->GetVirtualKey( x, p1, p2 )
    #define IActiveIMMIME_InstallIMEA( x, p1, p2, p3 ) \
        (x)->lpVtbl->InstallIMEA( x, p1, p2, p3 )
    #define IActiveIMMIME_InstallIMEW( x, p1, p2, p3 ) \
        (x)->lpVtbl->InstallIMEW( x, p1, p2, p3 )
    #define IActiveIMMIME_IsIME( x, p ) \
        (x)->lpVtbl->IsIME( x, p )
    #define IActiveIMMIME_IsUIMessageA( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->IsUIMessageA( x, p1, p2, p3, p4 )
    #define IActiveIMMIME_IsUIMessageW( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->IsUIMessageW( x, p1, p2, p3, p4 )
    #define IActiveIMMIME_NotifyIME( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->NotifyIME( x, p1, p2, p3, p4 )
    #define IActiveIMMIME_RegisterWordA( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->RegisterWordA( x, p1, p2, p3, p4 )
    #define IActiveIMMIME_RegisterWordW( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->RegisterWordW( x, p1, p2, p3, p4 )
    #define IActiveIMMIME_ReleaseContext( x, p1, p2 ) \
        (x)->lpVtbl->ReleaseContext( x, p1, p2 )
    #define IActiveIMMIME_SetCandidateWindow( x, p1, p2 ) \
        (x)->lpVtbl->SetCandidateWindow( x, p1, p2 )
    #define IActiveIMMIME_SetCompositionFontA( x, p1, p2 ) \
        (x)->lpVtbl->SetCompositionFontA( x, p1, p2 )
    #define IActiveIMMIME_SetCompositionFontW( x, p1, p2 ) \
        (x)->lpVtbl->SetCompositionFontW( x, p1, p2 )
    #define IActiveIMMIME_SetCompositionStringA( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->SetCompositionStringA( x, p1, p2, p3, p4, p5, p6 )
    #define IActiveIMMIME_SetCompositionStringW( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->SetCompositionStringW( x, p1, p2, p3, p4, p5, p6 )
    #define IActiveIMMIME_SetCompositionWindow( x, p1, p2 ) \
        (x)->lpVtbl->SetCompositionWindow( x, p1, p2 )
    #define IActiveIMMIME_SetConversionStatus( x, p1, p2, p3 ) \
        (x)->lpVtbl->SetConversionStatus( x, p1, p2, p3 )
    #define IActiveIMMIME_SetOpenStatus( x, p1, p2 ) \
        (x)->lpVtbl->SetOpenStatus( x, p1, p2 )
    #define IActiveIMMIME_SetStatusWindowPos( x, p1, p2 ) \
        (x)->lpVtbl->SetStatusWindowPos( x, p1, p2 )
    #define IActiveIMMIME_SimulateHotKey( x, p1, p2 ) \
        (x)->lpVtbl->SimulateHotKey( x, p1, p2 )
    #define IActiveIMMIME_UnregisterWordA( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->UnregisterWordA( x, p1, p2, p3, p4 )
    #define IActiveIMMIME_UnregisterWordW( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->UnregisterWordW( x, p1, p2, p3, p4 )
    #define IActiveIMMIME_GenerateMessage( x, p ) \
        (x)->lpVtbl->GenerateMessage( x, p )
    #define IActiveIMMIME_LockIMC( x, p1, p2 ) \
        (x)->lpVtbl->LockIMC( x, p1, p2 )
    #define IActiveIMMIME_UnlockIMC( x, p ) \
        (x)->lpVtbl->UnlockIMC( x, p )
    #define IActiveIMMIME_GetIMCLockCount( x, p1, p2 ) \
        (x)->lpVtbl->GetIMCLockCount( x, p1, p2 )
    #define IActiveIMMIME_CreateIMCC( x, p1, p2 ) \
        (x)->lpVtbl->CreateIMCC( x, p1, p2 )
    #define IActiveIMMIME_DestroyIMCC( x, p ) \
        (x)->lpVtbl->DestroyIMCC( x, p )
    #define IActiveIMMIME_LockIMCC( x, p1, p2 ) \
        (x)->lpVtbl->LockIMCC( x, p1, p2 )
    #define IActiveIMMIME_UnlockIMCC( x, p ) \
        (x)->lpVtbl->UnlockIMCC( x, p )
    #define IActiveIMMIME_ReSizeIMCC( x, p1, p2, p3 ) \
        (x)->lpVtbl->ReSizeIMCC( x, p1, p2, p3 )
    #define IActiveIMMIME_GetIMCCSize( x, p1, p2 ) \
        (x)->lpVtbl->GetIMCCSize( x, p1, p2 )
    #define IActiveIMMIME_GetIMCCLockCount( x, p1, p2 ) \
        (x)->lpVtbl->GetIMCCLockCount( x, p1, p2 )
    #define IActiveIMMIME_GetHotKey( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetHotKey( x, p1, p2, p3, p4 )
    #define IActiveIMMIME_SetHotKey( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->SetHotKey( x, p1, p2, p3, p4 )
    #define IActiveIMMIME_CreateSoftKeyboard( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->CreateSoftKeyboard( x, p1, p2, p3, p4, p5 )
    #define IActiveIMMIME_DestroySoftKeyboard( x, p ) \
        (x)->lpVtbl->DestroySoftKeyboard( x, p )
    #define IActiveIMMIME_ShowSoftKeyboard( x, p1, p2 ) \
        (x)->lpVtbl->ShowSoftKeyboard( x, p1, p2 )
    #define IActiveIMMIME_GetCodePageA( x, p1, p2 ) \
        (x)->lpVtbl->GetCodePageA( x, p1, p2 )
    #define IActiveIMMIME_GetLangId( x, p1, p2 ) \
        (x)->lpVtbl->GetLangId( x, p1, p2 )
    #define IActiveIMMIME_KeybdEvent( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->KeybdEvent( x, p1, p2, p3, p4, p5 )
    #define IActiveIMMIME_LockModal( x ) \
        (x)->lpVtbl->LockModal( x )
    #define IActiveIMMIME_UnlockModal( x ) \
        (x)->lpVtbl->UnlockModal( x )
    #define IActiveIMMIME_AssociateContextEx( x, p1, p2, p3 ) \
        (x)->lpVtbl->AssociateContextEx( x, p1, p2, p3 )
    #define IActiveIMMIME_DisableIME( x, p ) \
        (x)->lpVtbl->DisableIME( x, p )
    #define IActiveIMMIME_GetImeMenuItemsA( x, p1, p2, p3, p4, p5, p6, p7 ) \
        (x)->lpVtbl->GetImeMenuItemsA( x, p1, p2, p3, p4, p5, p6, p7 )
    #define IActiveIMMIME_GetImeMenuItemsW( x, p1, p2, p3, p4, p5, p6, p7 ) \
        (x)->lpVtbl->GetImeMenuItemsW( x, p1, p2, p3, p4, p5, p6, p7 )
    #define IActiveIMMIME_EnumInputContext( x, p1, p2 ) \
        (x)->lpVtbl->EnumInputContext( x, p1, p2 )
    #define IActiveIMMIME_RequestMessageA( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->RequestMessageA( x, p1, p2, p3, p4 )
    #define IActiveIMMIME_RequestMessageW( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->RequestMessageW( x, p1, p2, p3, p4 )
    #define IActiveIMMIME_SendIMCA( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->SendIMCA( x, p1, p2, p3, p4, p5 )
    #define IActiveIMMIME_SendIMCW( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->SendIMCW( x, p1, p2, p3, p4, p5 )
    #define IActiveIMMIME_IsSleeping( x ) \
        (x)->lpVtbl->IsSleeping( x )
    #define IActiveIME_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IActiveIME_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IActiveIME_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IActiveIME_Inquire( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->Inquire( x, p1, p2, p3, p4 )
    #define IActiveIME_ConversionList( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->ConversionList( x, p1, p2, p3, p4, p5, p6 )
    #define IActiveIME_Configure( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->Configure( x, p1, p2, p3, p4 )
    #define IActiveIME_Destroy( x, p ) \
        (x)->lpVtbl->Destroy( x, p )
    #define IActiveIME_Escape( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->Escape( x, p1, p2, p3, p4 )
    #define IActiveIME_SetActiveContext( x, p1, p2 ) \
        (x)->lpVtbl->SetActiveContext( x, p1, p2 )
    #define IActiveIME_ProcessKey( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->ProcessKey( x, p1, p2, p3, p4 )
    #define IActiveIME_Notify( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->Notify( x, p1, p2, p3, p4 )
    #define IActiveIME_Select( x, p1, p2 ) \
        (x)->lpVtbl->Select( x, p1, p2 )
    #define IActiveIME_SetCompositionString( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->SetCompositionString( x, p1, p2, p3, p4, p5, p6 )
    #define IActiveIME_ToAsciiEx( x, p1, p2, p3, p4, p5, p6, p7 ) \
        (x)->lpVtbl->ToAsciiEx( x, p1, p2, p3, p4, p5, p6, p7 )
    #define IActiveIME_RegisterWord( x, p1, p2, p3 ) \
        (x)->lpVtbl->RegisterWord( x, p1, p2, p3 )
    #define IActiveIME_UnregisterWord( x, p1, p2, p3 ) \
        (x)->lpVtbl->UnregisterWord( x, p1, p2, p3 )
    #define IActiveIME_GetRegisterWordStyle( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetRegisterWordStyle( x, p1, p2, p3 )
    #define IActiveIME_EnumRegisterWord( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->EnumRegisterWord( x, p1, p2, p3, p4, p5 )
    #define IActiveIME_GetCodePageA( x, p ) \
        (x)->lpVtbl->GetCodePageA( x, p )
    #define IActiveIME_GetLangId( x, p ) \
        (x)->lpVtbl->GetLangId( x, p )
    #define IActiveIME2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IActiveIME2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IActiveIME2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IActiveIME2_Inquire( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->Inquire( x, p1, p2, p3, p4 )
    #define IActiveIME2_ConversionList( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->ConversionList( x, p1, p2, p3, p4, p5, p6 )
    #define IActiveIME2_Configure( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->Configure( x, p1, p2, p3, p4 )
    #define IActiveIME2_Destroy( x, p ) \
        (x)->lpVtbl->Destroy( x, p )
    #define IActiveIME2_Escape( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->Escape( x, p1, p2, p3, p4 )
    #define IActiveIME2_SetActiveContext( x, p1, p2 ) \
        (x)->lpVtbl->SetActiveContext( x, p1, p2 )
    #define IActiveIME2_ProcessKey( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->ProcessKey( x, p1, p2, p3, p4 )
    #define IActiveIME2_Notify( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->Notify( x, p1, p2, p3, p4 )
    #define IActiveIME2_Select( x, p1, p2 ) \
        (x)->lpVtbl->Select( x, p1, p2 )
    #define IActiveIME2_SetCompositionString( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->SetCompositionString( x, p1, p2, p3, p4, p5, p6 )
    #define IActiveIME2_ToAsciiEx( x, p1, p2, p3, p4, p5, p6, p7 ) \
        (x)->lpVtbl->ToAsciiEx( x, p1, p2, p3, p4, p5, p6, p7 )
    #define IActiveIME2_RegisterWord( x, p1, p2, p3 ) \
        (x)->lpVtbl->RegisterWord( x, p1, p2, p3 )
    #define IActiveIME2_UnregisterWord( x, p1, p2, p3 ) \
        (x)->lpVtbl->UnregisterWord( x, p1, p2, p3 )
    #define IActiveIME2_GetRegisterWordStyle( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetRegisterWordStyle( x, p1, p2, p3 )
    #define IActiveIME2_EnumRegisterWord( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->EnumRegisterWord( x, p1, p2, p3, p4, p5 )
    #define IActiveIME2_GetCodePageA( x, p ) \
        (x)->lpVtbl->GetCodePageA( x, p )
    #define IActiveIME2_GetLangId( x, p ) \
        (x)->lpVtbl->GetLangId( x, p )
    #define IActiveIME2_Sleep( x ) \
        (x)->lpVtbl->Sleep( x )
    #define IActiveIME2_Unsleep( x, p ) \
        (x)->lpVtbl->Unsleep( x, p )
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

/* GUIDs */
EXTERN_C const IID      __cdecl LIBID_ActiveIMM;
EXTERN_C const IID      __cdecl IID_IEnumRegisterWordA;
EXTERN_C const IID      __cdecl IID_IEnumRegisterWordW;
EXTERN_C const IID      __cdecl IID_IEnumInputContext;
EXTERN_C const IID      __cdecl IID_IActiveIMMRegistrar;
EXTERN_C const IID      __cdecl IID_IActiveIMMMessagePumpOwner;
EXTERN_C const IID      __cdecl IID_IActiveIMMApp;
EXTERN_C const IID      __cdecl IID_IActiveIMMIME;
EXTERN_C const IID      __cdecl IID_IActiveIME;
EXTERN_C const IID      __cdecl IID_IActiveIME2;
EXTERN_C const CLSID    __cdecl CLSID_CActiveIMM;

#endif /* __dimm_h__ */
