/*
 *  d3drmdef.h  Direct3DRM definitions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef __D3DRMDEFS_H__
#define __D3DRMDEFS_H__

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#include <d3dtypes.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Direct3DRM calling convention */
#define D3DRMAPI    __stdcall

/* Direct3DRM color model data type */
typedef D3DCOLORMODEL   D3DRMCOLORMODEL;
typedef D3DCOLORMODEL   *LPD3DRMCOLORMODEL;

/* Other Direct3DRM primitive data types */
typedef DWORD   D3DRMSAVEOPTIONS;
typedef DWORD   D3DRMANIMATIONOPTIONS;
typedef DWORD   D3DRMINTERPOLATIONOPTIONS;
typedef DWORD   D3DRMLOADOPTIONS;
typedef DWORD   D3DRMMAPPING;
typedef DWORD   D3DRMMAPPINGFLAG;
typedef DWORD   *LPD3DRMMAPPING;
typedef LONG    D3DRMGROUPINDEX;

/* Direct3DRM render modes */
#define D3DRMRENDERMODE_BLENDEDTRANSPARENCY         1
#define D3DRMRENDERMODE_SORTEDTRANSPARENCY          2
#define D3DRMRENDERMODE_LIGHTINMODELSPACE           8
#define D3DRMRENDERMODE_VIEWDEPENDENTSPECULAR       16
#define D3DRMRENDERMODE_DISABLEDSORTEDALPHAZWRITE   32

/* Direct3DRM texture flags */
#define D3DRMTEXTURE_FORCERESIDENT          0x00000001L
#define D3DRMTEXTURE_STATIC                 0x00000002L
#define D3DRMTEXTURE_DOWNSAMPLEPOINT        0x00000004L
#define D3DRMTEXTURE_DOWNSAMPLEBILINEAR     0x00000008L
#define D3DRMTEXTURE_DOWNSAMPLEREDUCEDEPTH  0x00000010L
#define D3DRMTEXTURE_DOWNSAMPLENONE         0x00000020L
#define D3DRMTEXTURE_CHANGEDPIXELS          0x00000040L
#define D3DRMTEXTURE_CHANGEDPALETTE         0x00000080L
#define D3DRMTEXTURE_INVALIDATEONLY         0x00000100L

/* Direct3DRM shadow flags */
#define D3DRMSHADOW_TRUEALPHA   0x00000001L

/* Direct3DRM wire frame types */
#define D3DRMWIREFRAME_CULL         1
#define D3DRMWIREFRAME_HIDDENLINE   2

/* Direct3DRM options */
#define D3DRMOPTIONS_LEFTHANDED     0x00000001L
#define D3DRMOPTIONS_RIGHTHANDED    0x00000002L

/* Direct3DRM XOF save options */
#define D3DRMXOFSAVE_NORMALS            1L
#define D3DRMXOFSAVE_TEXTURECOORDINATES 2L
#define D3DRMXOFSAVE_MATERIALS          4L
#define D3DRMXOFSAVE_TEXTURENAMES       8L
#define D3DRMXOFSAVE_ALL                15L
#define D3DRMXOFSAVE_TEMPLATES          16L
#define D3DRMXOFSAVE_TEXTURETOPOLOGY    32L

/* Direct3DRM material override flags */
#define D3DRMMATERIALOVERRIDE_DIFFUSE_ALPHAONLY     0x00000001L
#define D3DRMMATERIALOVERRIDE_DIFFUSE_RGBONLY       0x00000002L
#define D3DRMMATERIALOVERRIDE_DIFFUSE               0x00000003L
#define D3DRMMATERIALOVERRIDE_AMBIENT               0x00000004L
#define D3DRMMATERIALOVERRIDE_EMISSIVE              0x00000008L
#define D3DRMMATERIALOVERRIDE_SPECULAR              0x00000010L
#define D3DRMMATERIALOVERRIDE_POWER                 0x00000020L
#define D3DRMMATERIALOVERRIDE_TEXTURE               0x00000040L
#define D3DRMMATERIALOVERRIDE_DIFFUSE_ALPHAMULTIPLY 0x00000080L
#define D3DRMMATERIALOVERRIDE_ALL                   0x000000FFL

/* Undocumented flags */
#define D3DRMFPTF_ALPHA         0x00000001L
#define D3DRMFPTF_NOALPHA       0x00000002L
#define D3DRMFPTF_PALETTIZED    0x00000004L
#define D3DRMFPTF_NOTPALETTIZED 0x00000008L

/* Direct3DRM state change flags */
#define D3DRMSTATECHANGE_UPDATEONLY     0x00000001L
#define D3DRMSTATECHANGE_VOLATILE       0x00000002L
#define D3DRMSTATECHANGE_NONVOLATILE    0x00000004L
#define D3DRMSTATECHANGE_RENDER         0x00000020L
#define D3DRMSTATECHANGE_LIGHT          0x00000040L

/* IDirect3DRM3::CreateDeviceFromSurface() flags */
#define D3DRMDEVICE_NOZBUFFER   0x00000001L

/* IDirect3DRMObject2::SetClientData() flags */
#define D3DRMCLIENTDATA_NONE        0x00000001L
#define D3DRMCLIENTDATA_LOCALFREE   0x00000002L
#define D3DRMCLIENTDATA_IUNKNOWN    0x00000004L

/* IDirect3DRMFrame2::AddMoveCallback() flags */
#define D3DRMCALLBACK_PREORDER  0
#define D3DRMCALLBACK_POSTORDER 1

/* IDirect3DRMMeshBuilder2::RayPick() flags */
#define D3DRMRAYPICK_ONLYBOUNDINGBOXES          0x01
#define D3DRMRAYPICK_IGNOREFURTHERPRIMITIVES    0x02
#define D3DRMRAYPICK_INTERPOLATEUV              0x04
#define D3DRMRAYPICK_INTERPOLATECOLOR           0x08
#define D3DRMRAYPICK_INTERPOLATENORMAL          0x10

/* IDirect3DRMMeshBuilder3::AddFacesIndexed() flags */
#define D3DRMADDFACES_VERTICESONLY  1

/* IDirect3DRMMeshBuilder2::GenerateNormals() flags */
#define D3DRMGENERATENORMALS_PRECOMPACT     1
#define D3DRMGENERATENORMALS_USECREASEANGLE 2

/* IDirect3DRMMeshBuilder3::GetParentMesh() values */
#define D3DRMMESHBUILDER_DIRECTPARENT   1
#define D3DRMMESHBUILDER_ROOTMESH       2

/* IDirect3DRMMeshBuilder3::Enable() flags */
#define D3DRMMESHBUILDER_RENDERENABLE   0x00000001L
#define D3DRMMESHBUILDER_PICKENABLE     0x00000002L

/* IDirect3DRMMeshBuilder3::AddMeshBuilder() flags */
#define D3DRMMESHBUILDER_DONTCOPYAPPDATA    1
#define D3DRMMESHBUILDER_FLATTENSUBMESHES   2
#define D3DRMMESHBUILDER_NOSUBMESHES        4

/* IDirect3DRMObject2::GetAge() flags */
#define D3DRMMESHBUILDERAGE_GEOMETRY    0x00000001L
#define D3DRMMESHBUILDERAGE_MATERIALS   0x00000002L
#define D3DRMMESHBUILDERAGE_TEXTURES    0x00000004L

/* IDirect3DRMMeshBuilder3::AddTriangles() flags */
#define D3DRMFVF_TYPE           0x00000001L
#define D3DRMFVF_NORMAL         0x00000002L
#define D3DRMFVF_COLOR          0x00000004L
#define D3DRMFVF_TEXTURECOORDS  0x00000008L

/* Direct3DRM vertex flags */
#define D3DRMVERTEX_STRIP   0x00000001L
#define D3DRMVERTEX_FAN     0x00000002L
#define D3DRMVERTEX_LIST    0x00000004L

/* IDirect3DRMViewport2::Clear2() flags */
#define D3DRMCLEAR_TARGET       0x00000001L
#define D3DRMCLEAR_ZBUFFER      0x00000002L
#define D3DRMCLEAR_DIRTYRECTS   0x00000004L
#define D3DRMCLEAR_ALL \
    (D3DRMCLEAR_TARGET | D3DRMCLEAR_ZBUFFER | D3DRMCLEAR_DIRTYRECTS)

/* IDirect3DRMFrame3::SetSceneFogMethod() flags */
#define D3DRMFOGMETHOD_VERTEX   0x00000001L
#define D3DRMFOGMETHOD_TABLE    0x00000002L
#define D3DRMFOGMETHOD_ANY      0x00000004L

/* IDirect3DRMFrame3::SetTraversalOptions() flags */
#define D3DRMFRAME_RENDERENABLE 0x00000001L
#define D3DRMFRAME_PICKENABLE   0x00000002L

/* Direct3DRM animation options */
#define D3DRMANIMATION_OPEN             0x00000001L
#define D3DRMANIMATION_CLOSED           0x00000002L
#define D3DRMANIMATION_LINEARPOSITION   0x00000004L
#define D3DRMANIMATION_SPLINEPOSITION   0x00000008L
#define D3DRMANIMATION_SCALEANDROTATION 0x00000010L
#define D3DRMANIMATION_POSITION         0x00000020L

/* Direct3DRM interpolation options */
#define D3DRMINTERPOLATION_OPEN         0x00000001L
#define D3DRMINTERPOLATION_CLOSED       0x00000002L
#define D3DRMINTERPOLATION_LINEAR       0x00000004L
#define D3DRMINTERPOLATION_SPLINE       0x00000008L
#define D3DRMINTERPOLATION_VERTEXCOLOR  0x00000040L
#define D3DRMINTERPOLATION_SLERPNORMALS 0x00000080L
#define D3DRMINTERPOLATION_NEAREST      0x00000100L

/* Direct3DRM load options */
#define D3DRMLOAD_FROMFILE              0x00000000L
#define D3DRMLOAD_FROMRESOURCE          0x00000001L
#define D3DRMLOAD_FROMMEMORY            0x00000002L
#define D3DRMLOAD_FROMSTREAM            0x00000004L
#define D3DRMLOAD_FROMURL               0x00000008L
#define D3DRMLOAD_BYNAME                0x00000010L
#define D3DRMLOAD_BYPOSITION            0x00000020L
#define D3DRMLOAD_BYGUID                0x00000040L
#define D3DRMLOAD_FIRST                 0x00000080L
#define D3DRMLOAD_INSTANCEBYREFERENCE   0x00000100L
#define D3DRMLOAD_INSTANCEBYCOPYING     0x00000200L
#define D3DRMLOAD_ASYNCHRONOUS          0x00000400L

/* Direct3DRM mesh status flags */
#define D3DRMPMESHSTATUS_VALID              0x00000001L
#define D3DRMPMESHSTATUS_INTERRUPTED        0x00000002L
#define D3DRMPMESHSTATUS_BASEMESHCOMPLETE   0x00000004L
#define D3DRMPMESHSTATUS_COMPLETE           0x00000008L
#define D3DRMPMESHSTATUS_RENDERABLE         0x00000010L

/* Direct3DRM mesh events */
#define D3DRMPMESHEVENT_BASEMESH    0x00000001L
#define D3DRMPMESHEVENT_COMPLETE    0x00000002L

/* Direct3DRM animation key types */
#define D3DRMANIMATION_ROTATEKEY    0x00000001L
#define D3DRMANIMATION_SCALEKEY     0x00000002L
#define D3DRMANIMATION_POSITIONKEY  0x00000003L

/* Direct3DRM mapping flags */
#define D3DRMMAP_WRAPU          1L
#define D3DRMMAP_WRPAV          2L
#define D3DRMMAP_PERSPCORRECT   4L

/* Direct3DRM group index special value */
#define D3DRMGROUP_ALLGROUPS    (-1L)

/* Direct3DRM 4-dimensional vector */
typedef struct _D3DRMVECTOR4D {
    D3DVALUE    x;
    D3DVALUE    y;
    D3DVALUE    z;
    D3DVALUE    w;
} D3DRMVECTOR4D;
typedef D3DRMVECTOR4D   *LPD3DRMVECTOR4D;

/* Direct3DRM 4-dimensional matrix */
typedef D3DVALUE    D3DRMMATRIX4D[4][4];

/* Direct3DRM quaternion */
typedef struct _D3DRMQUATERNION {
    D3DVALUE    s;
    D3DVECTOR   v;
} D3DRMQUATERNION;
typedef D3DRMQUATERNION *LPD3DRMQUATERNION;

/* Direct3DRM ray */
typedef struct _D3DRMRAY {
    D3DVECTOR   dvDir;
    D3DVECTOR   dvPos;
} D3DRMRAY;
typedef D3DRMRAY    *LPD3DRMRAY;

/* Direct3DRM box */
typedef struct _D3DRMBOX {
    D3DVECTOR   min;
    D3DVECTOR   max;
} D3DRMBOX;
typedef D3DRMBOX    *LPD3DRMBOX;

/* Direct3DRM wrap callback */
typedef void (*D3DRMWRAPCALLBACK)( LPD3DVECTOR, int *, int *, LPD3DVECTOR, LPD3DVECTOR, LPVOID );

/* Direct3DRM light types */
typedef enum _D3DRMLIGHTTYPE {
    D3DRMLIGHT_AMBIENT          = 0,
    D3DRMLIGHT_POINT            = 1,
    D3DRMLIGHT_SPOT             = 2,
    D3DRMLIGHT_DIRECTIONAL      = 3,
    D3DRMLIGHT_PARALLELPOINT    = 4
} D3DRMLIGHTTYPE;
typedef D3DRMLIGHTTYPE  *LPD3DRMLIGHTTYPE;

/* Direct3DRM shade modes */
typedef enum _D3DRMSHADEMODE {
    D3DRMSHADE_FLAT     = 0,
    D3DRMSHADE_GOURAUD  = 1,
    D3DRMSHADE_PHONG    = 2,
    D3DRMSHADE_MASK     = 7,
    D3DRMSHADE_MAX      = 8
} D3DRMSHADEMODE;
typedef D3DRMSHADEMODE  *LPD3DRMSHADEMODE;

/* Direct3DRM light modes */
typedef enum _D3DRMLIGHTMODE {
    D3DRMLIGHT_OFF  = 0 * D3DRMSHADE_MAX,
    D3DRMLIGHT_ON   = 1 * D3DRMSHADE_MAX,
    D3DRMLIGHT_MASK = 7 * D3DRMSHADE_MAX,
    D3DRMLIGHT_MAX  = 8 * D3DRMSHADE_MAX
} D3DRMLIGHTMODE;
typedef D3DRMLIGHTMODE  *LPD3DRMLIGHTMODE;

/* Direct3DRM fill modes */
typedef enum _D3DRMFILLMODE {
    D3DRMFILL_POINTS    = 0 * D3DRMLIGHT_MAX,
    D3DRMFILL_WIREFRAME = 1 * D3DRMLIGHT_MAX,
    D3DRMFILL_SOLID     = 2 * D3DRMLIGHT_MAX,
    D3DRMFILL_MASK      = 7 * D3DRMLIGHT_MAX,
    D3DRMFILL_MAX       = 8 * D3DRMLIGHT_MAX
} D3DRMFILLMODE;
typedef D3DRMFILLMODE   *LPD3DRMFILLMODE;

/* Direct3DRM render qualities */
typedef DWORD                   D3DRMRENDERQUALITY;
typedef DWORD                   *LPD3DRMRENDERQUALITY;
#define D3DRMRENDER_WIREFRAME   (D3DRMSHADE_FLAT + D3DRMLIGHT_OFF + D3DRMFILL_WIREFRAME)
#define D3DRMRENDER_UNLITFLAT   (D3DRMSHADE_FLAT + D3DRMLIGHT_OFF + D3DRMFILL_SOLID)
#define D3DRMRENDER_FLAT        (D3DRMSHADE_FLAT + D3DRMLIGHT_ON + D3DRMFILL_SOLID)
#define D3DRMRENDER_GOURAND     (D3DRMSHADE_GOURAND + D3DRMLIGHT_ON + D3DRMFILL_SOLID)
#define D3DRMRENDER_PHONG       (D3DRMSHADE_PHONG + D3DRMLIGHT_ON + D3DRMFILL_SOLID)

/* Direct3DRM texture quality */
typedef enum _D3DRMTEXTUREQUALITY {
    D3DRMTEXTURE_NEAREST            = 0,
    D3DRMTEXTURE_LINEAR             = 1,
    D3DRMTEXTURE_MIPNEAREST         = 2,
    D3DRMTEXTURE_MIPLINEAR          = 3,
    D3DRMTEXTURE_LINEARMIPNEAREST   = 4,
    D3DRMTEXTURE_LINEARMIPLINEAR    = 5
} D3DRMTEXTUREQUALITY;
typedef D3DRMTEXTUREQUALITY *LPD3DRMTEXTUREQUALITY;

/* Direct3DRM combine types */
typedef enum _D3DRMCOMBINETYPE {
    D3DRMCOMBINE_REPLACE    = 0,
    D3DRMCOMBINE_BEFORE     = 1,
    D3DRMCOMBINE_AFTER      = 2
} D3DRMCOMBINETYPE;
typedef D3DRMCOMBINETYPE    *LPD3DRMCOMBINETYPE;

/* Direct3DRM palette flags */
typedef enum _D3DRMPALETTEFLAGS {
    D3DRMPALETTE_FREE       = 0,
    D3DRMPALETTE_READONLY   = 1,
    D3DRMPALETTE_RESERVED   = 2
} D3DRMPALETTEFLAGS;
typedef D3DRMPALETTEFLAGS   *LPD3DRMPALETTEFLAGS;

/* Direct3DRM palette entry */
typedef struct _D3DRMPALETTEENTRY {
    unsigned char   red;
    unsigned char   green;
    unsigned char   blue;
    unsigned char   flags;
} D3DRMPALETTEENTRY;
typedef D3DRMPALETTEENTRY   *LPD3DRMPALETTEENTRY;

/* Direct3DRM image */
typedef struct _D3DRMIMAGE {
    int                 width;
    int                 height;
    int                 aspectx;
    int                 aspecty;
    int                 depth;
    int                 rgb;
    int                 bytes_per_line;
    void                *buffer1;
    void                *buffer2;
    unsigned long       red_mask;
    unsigned long       green_mask;
    unsigned long       blue_mask;
    unsigned long       alpha_mask;
    int                 palette_size;
    D3DRMPALETTEENTRY   *palette;
} D3DRMIMAGE;
typedef D3DRMIMAGE  *LPD3DRMIMAGE;

/* Direct3DRM wrap types */
typedef enum _D3DRMWRAPTYPE {
    D3DRMWRAP_FLAT      = 0,
    D3DRMWRAP_CYLINDER  = 1,
    D3DRMWRAP_SPHERE    = 2,
    D3DRMWRAP_CHROME    = 3,
    D3DRMWRAP_SHEET     = 4,
    D3DRMWRAP_BOX       = 5
} D3DRMWRAPTYPE;
typedef D3DRMWRAPTYPE   *LPD3DRMWRAPTYPE;

/* Direct3DRM projection types */
typedef enum _D3DRMPROJECTIONTYPE {
    D3DRMPROJECT_PERSPECTIVE            = 0,
    D3DRMPROJECT_ORTHOGRAPHIC           = 1,
    D3DRMPROJECT_RIGHTHANDPERSPECTIVE   = 2,
    D3DRMPROJECT_RIGHTHANDORTHOGRAPHIC  = 3
} D3DRMPROJECTIONTYPE;
typedef D3DRMPROJECTIONTYPE *LPD3DRMPROJECTIONTYPE;

/* Direct3DRM XOF formats */
typedef enum _D3DRMXOFFORMAT {
    D3DRMXOF_BINARY     = 0,
    D3DRMXOF_COMPRESSED = 1,
    D3DRMXOF_TEXT       = 2
} D3DRMXOFFORMAT;
typedef D3DRMXOFFORMAT  *LPD3DRMXOFFORMAT;

/* Direct3DRM color sources */
typedef enum _D3DRMCOLORSOURCE {
    D3DRMCOLOR_FROMFACE     = 0,
    D3DRMCOLOR_FROMVERTEX   = 1
} D3DRMCOLORSOURCE;
typedef D3DRMCOLORSOURCE    *LPD3DRMCOLORSOURCE;

/* Direct3DRM frame constraints */
typedef enum _D3DRMFRAMECONSTRAINT {
    D3DRMCONSTRAINT_Z   = 0,
    D3DRMCONSTRAINT_Y   = 1,
    D3DRMCONSTRAINT_X   = 2
} D3DRMFRAMECONSTRAINT;
typedef D3DRMFRAMECONSTRAINT    *LPD3DRMFRAMECONSTRAINT;

/* Direct3DRM material modes */
typedef enum _D3DRMMATERIALMODE {
    D3DRMMATERIAL_FROMMESH      = 0,
    D3DRMMATERIAL_FROMPARENT    = 1,
    D3DRMMATERIAL_FROMFRAME     = 2
} D3DRMMATERIALMODE;
typedef D3DRMMATERIALMODE   *LPD3DRMMATERIALMODE;

/* Direct3DRM fog modes */
typedef enum _D3DRMFOGMODE {
    D3DRMFOG_LINEAR             = 0,
    D3DRMFOG_EXPONENTIAL        = 1,
    D3DRMFOG_EXPONENTIALSQUARED = 2,
} D3DRMFOGMODE;
typedef D3DRMFOGMODE    *LPD3DRMFOGMODE;

/* Direct3DRM z-buffer modes */
typedef enum _D3DRMZBUFFERMODE {
    D3DRMZBUFFER_FROMPARENT = 0,
    D3DRMZBUFFER_ENABLE     = 1,
    D3DRMZBUFFER_DISABLE    = 2
} D3DRMZBUFFERMODE;
typedef D3DRMZBUFFERMODE    *LPD3DRMZBUFFERMODE;

/* Direct3DRM sort modes */
typedef enum _D3DRMSORTMODE {
    D3DRMSORT_FROMPARENT    = 0,
    D3DRMSORT_NONE          = 1,
    D3DRMSORT_FRONTTOBACK   = 2,
    D3DRMSORT_BACKTOFRONT   = 3
} D3DRMSORTMODE;
typedef D3DRMSORTMODE   *LPD3DRMSORTMODE;

/* Direct3DRM material overrides */
typedef struct _D3DRMMATERIALOVERRIDE {
    DWORD           dwSize;
    DWORD           dwFlags;
    D3DCOLORVALUE   dcDiffuse;
    D3DCOLORVALUE   dcAmbient;
    D3DCOLORVALUE   dcEmissive;
    D3DCOLORVALUE   dcSpecular;
    D3DVALUE        dvPower;
    LPUNKNOWN       lpD3DRMTex;
} D3DRMMATERIALOVERRIDE;
typedef D3DRMMATERIALOVERRIDE   *LPD3DRMMATERIALOVERRIDE;

/* Direct3DRM load resource information */
typedef struct _D3DRMLOADRESOURCE {
    HMODULE hModule;
    LPCTSTR lpName;
    LPCTSTR lpType;
} D3DRMLOADRESOURCE;
typedef D3DRMLOADRESOURCE   *LPD3DRMLOADRESOURCE;

/* Direct3DRM load memory information */
typedef struct _D3DRMLOADMEMORY {
    LPVOID  lpMemory;
    DWORD   dSize;
} D3DRMLOADMEMORY;
typedef D3DRMLOADMEMORY *LPD3DRMLOADMEMORY;

/* Direct3DRM mesh load status */
typedef struct _D3DRMPMESHLOADSTATUS {
    DWORD   dwSize;
    DWORD   dwPMeshSize;
    DWORD   dwBaseMeshSize;
    DWORD   dwBytesLoaded;
    DWORD   dwVerticesLoaded;
    DWORD   dwFacesLoaded;
    HRESULT dwLoadResult;
    DWORD   dwFlags;
} D3DRMPMESHLOADSTATUS;
typedef D3DRMPMESHLOADSTATUS    *LPD3DRMPMESHLOADSTATUS;

/* Direct3DRM user visual reasons */
typedef enum _D3DRMUSERVISUALREASON {
    D3DRMUSERVISUAL_CANSEE  = 0,
    D3DRMUSERVISUAL_RENDER  = 1
} D3DRMUSERVISUALREASON;
typedef D3DRMUSERVISUALREASON   *LPD3DRMUSERVISUALREASON;

/* Direct3DRM animation key */
typedef struct _D3DRMANIMATIONKEY {
    DWORD       dwSize;
    DWORD       dwKeyType;
    D3DVALUE    dvTime;
    DWORD       dwID;
    union {
        D3DRMQUATERNION dqRotateKey;
        D3DVECTOR       dvScaleKey;
        D3DVECTOR       dvPositionKey;
    };
} D3DRMANIMATIONKEY;
typedef D3DRMANIMATIONKEY   *LPD3DRMANIMATIONKEY;

/* Direct3DRM vertex */
typedef struct _D3DRMVERTEX {
    D3DVECTOR   position;
    D3DVECTOR   normal;
    D3DVALUE    tu;
    D3DVALUE    tv;
    D3DCOLOR    color;
} D3DRMVERTEX;
typedef D3DRMVERTEX *LPD3DRMVERTEX;

/* Functions in D3DRM.DLL */
extern D3DVALUE D3DRMAPI    D3DRMColorGetAlpha( D3DCOLOR );
extern D3DVALUE D3DRMAPI    D3DRMColorGetBlue( D3DCOLOR );
extern D3DVALUE D3DRMAPI    D3DRMColorGetGreen( D3DCOLOR );
extern D3DVALUE D3DRMAPI    D3DRMColorGetRed( D3DCOLOR );
extern D3DCOLOR D3DRMAPI    D3DRMCreateColorRGB( D3DVALUE, D3DVALUE, D3DVALUE );
extern D3DCOLOR D3DRMAPI    D3DRMCreateColorRGBA( D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE );
extern void D3DRMAPI        D3DRMMatrixFromQuaternion( D3DRMMATRIX4D, LPD3DRMQUATERNION );
extern LPD3DRMQUATERNION D3DRMAPI   D3DRMQuaternionFromRotation( LPD3DRMQUATERNION, LPD3DVECTOR, D3DVALUE );
extern LPD3DRMQUATERNION D3DRMAPI   D3DRMQuaternionMultiply( LPD3DRMQUATERNION, LPD3DRMQUATERNION, LPD3DRMQUATERNION );
extern LPD3DRMQUATERNION D3DRMAPI   D3DRMQuaternionSlerp( LPD3DRMQUATERNION, LPD3DRMQUATERNION, LPD3DRMQUATERNION, D3DVALUE );
extern LPD3DVECTOR D3DRMAPI D3DRMVectorAdd( LPD3DVECTOR, LPD3DVECTOR, LPD3DVECTOR );
extern LPD3DVECTOR D3DRMAPI D3DRMVectorCrossProduct( LPD3DVECTOR, LPD3DVECTOR, LPD3DVECTOR );
extern D3DVALUE D3DRMAPI    D3DRMVectorDotProduct( LPD3DVECTOR, LPD3DVECTOR );
extern D3DVALUE D3DRMAPI    D3DRMVectorModulus( LPD3DVECTOR );
extern LPD3DVECTOR D3DRMAPI D3DRMVectorNormalize( LPD3DVECTOR );
extern LPD3DVECTOR D3DRMAPI D3DRMVectorRandom( LPD3DVECTOR );
extern LPD3DVECTOR D3DRMAPI D3DRMVectorReflect( LPD3DVECTOR, LPD3DVECTOR, LPD3DVECTOR );
extern LPD3DVECTOR D3DRMAPI D3DRMVectorRotate( LPD3DVECTOR, LPD3DVECTOR, LPD3DVECTOR, D3DVALUE );
extern LPD3DVECTOR D3DRMAPI D3DRMVectorScale( LPD3DVECTOR, LPD3DVECTOR, D3DVALUE );
extern LPD3DVECTOR D3DRMAPI D3DRMVectorSubtract( LPD3DVECTOR, LPD3DVECTOR, LPD3DVECTOR );

/* Alias */
#define D3DRMVectorNormalise    D3DRMVectorNormalize

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __D3DRMDEFS_H__ */
