/*
 *  d3drmobj.h  Direct3DRM object interfaces
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _D3DRMOBJ_H_
#define _D3DRMOBJ_H_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#include <d3drmdef.h>
#include <d3d.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Macros to simplify various definitions in this file */
#define IUNKNOWN_METHODS( x ) \
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) x; \
    STDMETHOD_( ULONG, AddRef )( THIS ) x; \
    STDMETHOD_( ULONG, Release )( THIS ) x
#define IDIRECT3DRMOBJECT_METHODS( x ) \
    STDMETHOD( Clone )( THIS_ LPUNKNOWN, REFIID, LPVOID * ) x; \
    STDMETHOD( AddDestroyCallback )( THIS_ D3DRMOBJECTCALLBACK, LPVOID ) x; \
    STDMETHOD( DeleteDestroyCallback )( THIS_ D3DRMOBJECTCALLBACK, LPVOID ) x; \
    STDMETHOD( SetAppData )( THIS_ DWORD ) x; \
    STDMETHOD_( DWORD, GetAppData )( THIS ) x; \
    STDMETHOD( SetName )( THIS_ LPCSTR ) x; \
    STDMETHOD( GetName )( THIS_ LPDWORD, LPSTR ) x; \
    STDMETHOD( GetClassName )( THIS_ LPDWORD, LPSTR ) x
#define WIN_TYPES( p1, p2 ) \
    typedef interface p1    *LP##p2; \
    typedef interface p1    **LPLP##p2

/* Pointers to interface */
WIN_TYPES( IDirect3DRM, DIRECT3DRM );
WIN_TYPES( IDirect3DRMObject, DIRECT3DRMOBJECT );
WIN_TYPES( IDirect3DRMVisual, DIRECT3DRMVISUAL );
WIN_TYPES( IDirect3DRMDevice, DIRECT3DRMDEVICE );
WIN_TYPES( IDirect3DRMDevice2, DIRECT3DRMDEVICE2 );
WIN_TYPES( IDirect3DRMDevice3, DIRECT3DRMDEVICE3 );
WIN_TYPES( IDirect3DRMViewport, DIRECT3DRMVIEWPORT );
WIN_TYPES( IDirect3DRMViewport2, DIRECT3DRMVIEWPORT2 );
WIN_TYPES( IDirect3DRMFrame, DIRECT3DRMFRAME );
WIN_TYPES( IDirect3DRMFrame2, DIRECT3DRMFRAME2 );
WIN_TYPES( IDirect3DRMFrame3, DIRECT3DRMFRAME3 );
WIN_TYPES( IDirect3DRMMesh, DIRECT3DRMMESH );
WIN_TYPES( IDirect3DRMProgressiveMesh, DIRECT3DRMPROGRESSIVEMESH );
WIN_TYPES( IDirect3DRMShadow, DIRECT3DRMSHADOW );
WIN_TYPES( IDirect3DRMShadow2, DIRECT3DRMSHADOW2 );
WIN_TYPES( IDirect3DRMFace, DIRECT3DRMFACE );
WIN_TYPES( IDirect3DRMFace2, DIRECT3DRMFACE2 );
WIN_TYPES( IDirect3DRMMeshBuilder, DIRECT3DRMMESHBUILDER );
WIN_TYPES( IDirect3DRMMeshBuilder2, DIRECT3DRMMESHBUILDER2 );
WIN_TYPES( IDirect3DRMMeshBuilder3, DIRECT3DRMMESHBUILDER3 );
WIN_TYPES( IDirect3DRMLight, DIRECT3DRMLIGHT );
WIN_TYPES( IDirect3DRMTexture, DIRECT3DRMTEXTURE );
WIN_TYPES( IDirect3DRMTexture2, DIRECT3DRMTEXTURE2 );
WIN_TYPES( IDirect3DRMTexture3, DIRECT3DRMTEXTURE3 );
WIN_TYPES( IDirect3DRMWrap, DIRECT3DRMWRAP );
WIN_TYPES( IDirect3DRMMaterial, DIRECT3DRMMATERIAL );
WIN_TYPES( IDirect3DRMMaterial2, DIRECT3DRMMATERIAL2 );
WIN_TYPES( IDirect3DRMAnimation, DIRECT3DRMANIMATION );
WIN_TYPES( IDirect3DRMAnimation2, DIRECT3DRMANIMATION2 );
WIN_TYPES( IDirect3DRMAnimationSet, DIRECT3DRMANIMATIONSET );
WIN_TYPES( IDirect3DRMAnimationSet2, DIRECT3DRMANIMATIONSET2 );
WIN_TYPES( IDirect3DRMUserVisual, DIRECT3DRMUSERVISUAL );
WIN_TYPES( IDirect3DRMArray, DIRECT3DRMARRAY );
WIN_TYPES( IDirect3DRMObjectArray, DIRECT3DRMOBJECTARRAY );
WIN_TYPES( IDirect3DRMDeviceArray, DIRECT3DRMDEVICEARRAY );
WIN_TYPES( IDirect3DRMFrameArray, DIRECT3DRMFRAMEARRAY );
WIN_TYPES( IDirect3DRMViewportArray, DIRECT3DRMVIEWPORTARRAY );
WIN_TYPES( IDirect3DRMVisualArray, DIRECT3DRMVISUALARRAY );
WIN_TYPES( IDirect3DRMAnimationArray, DIRECT3DRMANIMATIONARRAY );
WIN_TYPES( IDirect3DRMPickedArray, DIRECT3DRMPICKEDARRAY );
WIN_TYPES( IDirect3DRMLightArray, DIRECT3DRMLIGHTARRAY );
WIN_TYPES( IDirect3DRMFaceArray, DIRECT3DRMFACEARRAY );
WIN_TYPES( IDirect3DRMPicked2Array, DIRECT3DRMPICKED2ARRAY );
WIN_TYPES( IDirect3DRMInterpolator, DIRECT3DRMINTERPOLATOR );
WIN_TYPES( IDirect3DRMClippedVisual, DIRECT3DRMCLIPPEDVISUAL );

/* Direct3DRM callbacks */
typedef void (__cdecl *D3DRMOBJECTCALLBACK)( LPDIRECT3DRMOBJECT, LPVOID );
typedef void (__cdecl *D3DRMFRAMEMOVECALLBACK)( LPDIRECT3DRMOBJECT, LPVOID, D3DVALUE );
typedef void (__cdecl *D3DRMFRAME3MOVECALLBACK)( LPDIRECT3DRMFRAME3, LPVOID, D3DVALUE );
typedef void (__cdecl *D3DRMUPDATECALLBACK)( LPDIRECT3DRMDEVICE, LPVOID, int, LPD3DRECT );
typedef int (__cdecl *D3DRMUSERVISUALCALLBACK)( LPDIRECT3DRMUSERVISUAL, LPVOID, D3DRMUSERVISUALREASON, LPDIRECT3DRMDEVICE, LPDIRECT3DRMVIEWPORT );
typedef HRESULT (__cdecl *D3DRMLOADTEXTURECALLBACK)( char *, void *, LPDIRECT3DRMTEXTURE * );
typedef HRESULT (__cdecl *D3DRMLOADTEXTURE3CALLBACK)( char *, void *, LPDIRECT3DRMTEXTURE3 * );
typedef void (__cdecl *D3DRMLOADCALLBACK)( LPDIRECT3DRMOBJECT, REFIID, LPVOID );
typedef HRESULT (__cdecl *D3DRMDOWNSAMPLECALLBACK)( LPDIRECT3DRMTEXTURE3, LPVOID, LPDIRECTDRAWSURFACE, LPDIRECTDRAWSURFACE );
typedef HRESULT (__cdecl *D3DRMVALIDATIONCALLBACK)( LPDIRECT3DRMTEXTURE3, LPVOID, DWORD, DWORD, LPRECT );

/* Direct3DRM pick description */
typedef struct _D3DRMPICKDESC {
    ULONG       ulFaceIdx;
    LONG        lGroupIdx;
    D3DVECTOR   vPosition;
} D3DRMPICKDESC;
typedef D3DRMPICKDESC   *LPD3DRMPICKDESC;

/* Direct3DRM pick description (version 2) */
typedef struct _D3DRMPICKDESC2 {
    ULONG       ulFaceIdx;
    LONG        lGroupIdx;
    D3DVECTOR   dvPosition;
    D3DVALUE    tu;
    D3DVALUE    tv;
    D3DVECTOR   dvNormal;
    D3DCOLOR    dcColor;
} D3DRMPICKDESC2;
typedef D3DRMPICKDESC2  *LPD3DRMPICKDESC2;

/* IDirect3DRMObject interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMObject
DECLARE_INTERFACE_( IDirect3DRMObject, IUnknown ) {
    IUNKNOWN_METHODS( PURE );
    IDIRECT3DRMOBJECT_METHODS( PURE );
};

/* IDirect3DRMObject2 interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMObject2
DECLARE_INTERFACE_( IDirect3DRMObject2, IUnknown ) {
    IUNKNOWN_METHODS( PURE );
    
    /* IDirect3DRMObject2 methods */
    STDMETHOD( AddDestroyCallback )( THIS_ D3DRMOBJECTCALLBACK, LPVOID ) PURE;
    STDMETHOD( Clone )( THIS_ LPUNKNOWN, REFIID, LPVOID * ) PURE;
    STDMETHOD( DeleteDestroyCallback )( THIS_ D3DRMOBJECTCALLBACK, LPVOID ) PURE;
    STDMETHOD( GetClientData )( THIS_ DWORD, LPVOID * ) PURE;
    STDMETHOD( GetDirect3DRM )( THIS_ LPDIRECT3DRM * ) PURE;
    STDMETHOD( GetName )( THIS_ LPDWORD, LPSTR ) PURE;
    STDMETHOD( SetClientData )( THIS_ DWORD, LPVOID, DWORD ) PURE;
    STDMETHOD( SetName )( THIS_ LPCSTR ) PURE;
    STDMETHOD( GetAge )( THIS_ DWORD, LPDWORD ) PURE;
};

/* IDirect3DRMVisual interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMVisual
DECLARE_INTERFACE_( IDirect3DRMVisual, IDirect3DRMObject ) {
    IUNKNOWN_METHODS( PURE );
    IDIRECT3DRMOBJECT_METHODS( PURE );
};

/* IDirect3DRMDevice interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMDevice
DECLARE_INTERFACE_( IDirect3DRMDevice, IDirect3DRMObject ) {
    IUNKNOWN_METHODS( PURE );
    IDIRECT3DRMOBJECT_METHODS( PURE );
    
    /* IDirect3DRMDevice methods */
    STDMETHOD( Init )( THIS_ ULONG, ULONG ) PURE;
    STDMETHOD( InitFromD3D )( THIS_ LPDIRECT3D, LPDIRECT3DDEVICE ) PURE;
    STDMETHOD( InitFromClipper )( THIS_ LPDIRECTDRAWCLIPPER, LPGUID, int, int ) PURE;
    STDMETHOD( Update )( THIS ) PURE;
    STDMETHOD( AddUpdateCallback )( THIS_ D3DRMUPDATECALLBACK, LPVOID ) PURE;
    STDMETHOD( DeleteUpdateCallback )( THIS_ D3DRMUPDATECALLBACK, LPVOID ) PURE;
    STDMETHOD( SetBufferCount )( THIS_ DWORD ) PURE;
    STDMETHOD_( DWORD, GetBufferCount )( THIS ) PURE;
    STDMETHOD( SetDither )( THIS_ BOOL ) PURE;
    STDMETHOD( SetShades )( THIS_ DWORD ) PURE;
    STDMETHOD( SetQuality )( THIS_ D3DRMRENDERQUALITY ) PURE;
    STDMETHOD( SetTextureQuality )( THIS_ D3DRMTEXTUREQUALITY ) PURE;
    STDMETHOD( GetViewports )( THIS_ LPDIRECT3DRMVIEWPORTARRAY * ) PURE;
    STDMETHOD_( BOOL, GetDither )( THIS ) PURE;
    STDMETHOD_( DWORD, GetShades )( THIS ) PURE;
    STDMETHOD_( DWORD, GetHeight )( THIS ) PURE;
    STDMETHOD_( DWORD, GetWidth )( THIS ) PURE;
    STDMETHOD_( DWORD, GetTrianglesDrawn )( THIS ) PURE;
    STDMETHOD_( DWORD, GetWireframeOptions )( THIS ) PURE;
    STDMETHOD_( D3DRMRENDERQUALITY, GetQuality )( THIS ) PURE;
    STDMETHOD_( D3DCOLORMODEL, GetColorModel )( THIS ) PURE;
    STDMETHOD_( D3DRMTEXTUREQUALITY, GetTextureQuality )( THIS ) PURE;
    STDMETHOD( GetDirect3DDevice )( THIS_ LPDIRECT3DDEVICE * ) PURE;
};

/* IDirect3DRMDevice2 interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMDevice2
DECLARE_INTERFACE_( IDirect3DRMDevice2, IDirect3DRMDevice ) {
    IUNKNOWN_METHODS( PURE );
    IDIRECT3DRMOBJECT_METHODS( PURE );
    
    /* IDirect3DRMDevice methods */
    STDMETHOD( Init )( THIS_ ULONG, ULONG ) PURE;
    STDMETHOD( InitFromD3D )( THIS_ LPDIRECT3D, LPDIRECT3DDEVICE ) PURE;
    STDMETHOD( InitFromClipper )( THIS_ LPDIRECTDRAWCLIPPER, LPGUID, int, int ) PURE;
    STDMETHOD( Update )( THIS ) PURE;
    STDMETHOD( AddUpdateCallback )( THIS_ D3DRMUPDATECALLBACK, LPVOID ) PURE;
    STDMETHOD( DeleteUpdateCallback )( THIS_ D3DRMUPDATECALLBACK, LPVOID ) PURE;
    STDMETHOD( SetBufferCount )( THIS_ DWORD ) PURE;
    STDMETHOD_( DWORD, GetBufferCount )( THIS ) PURE;
    STDMETHOD( SetDither )( THIS_ BOOL ) PURE;
    STDMETHOD( SetShades )( THIS_ DWORD ) PURE;
    STDMETHOD( SetQuality )( THIS_ D3DRMRENDERQUALITY ) PURE;
    STDMETHOD( SetTextureQuality )( THIS_ D3DRMTEXTUREQUALITY ) PURE;
    STDMETHOD( GetViewports )( THIS_ LPDIRECT3DRMVIEWPORTARRAY * ) PURE;
    STDMETHOD_( BOOL, GetDither )( THIS ) PURE;
    STDMETHOD_( DWORD, GetShades )( THIS ) PURE;
    STDMETHOD_( DWORD, GetHeight )( THIS ) PURE;
    STDMETHOD_( DWORD, GetWidth )( THIS ) PURE;
    STDMETHOD_( DWORD, GetTrianglesDrawn )( THIS ) PURE;
    STDMETHOD_( DWORD, GetWireframeOptions )( THIS ) PURE;
    STDMETHOD_( D3DRMRENDERQUALITY, GetQuality )( THIS ) PURE;
    STDMETHOD_( D3DCOLORMODEL, GetColorModel )( THIS ) PURE;
    STDMETHOD_( D3DRMTEXTUREQUALITY, GetTextureQuality )( THIS ) PURE;
    STDMETHOD( GetDirect3DDevice )( THIS_ LPDIRECT3DDEVICE * ) PURE;

    /* IDirect3DRMDevice2 methods */
    STDMETHOD( InitFromD3D2 )( THIS_ LPDIRECT3D2, LPDIRECT3DDEVICE2 ) PURE;
    STDMETHOD( InitFromSurface )( THIS_ LPGUID, LPDIRECTDRAW, LPDIRECTDRAWSURFACE ) PURE;
    STDMETHOD( SetRenderMode )( THIS_ DWORD ) PURE;
    STDMETHOD_( DWORD, GetRenderMode )( THIS ) PURE;
    STDMETHOD( GetDirect3DDevice2 )( THIS_ LPDIRECT3DDEVICE2 * ) PURE;
};

/* IDirect3DRMDevice3 interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMDevice3
DECLARE_INTERFACE_( IDirect3DRMDevice3, IDirect3DRMObject ) {
    IUNKNOWN_METHODS( PURE );
    IDIRECT3DRMOBJECT_METHODS( PURE );
    
    /* IDirect3DRMDevice methods */
    STDMETHOD( Init )( THIS_ ULONG, ULONG ) PURE;
    STDMETHOD( InitFromD3D )( THIS_ LPDIRECT3D, LPDIRECT3DDEVICE ) PURE;
    STDMETHOD( InitFromClipper )( THIS_ LPDIRECTDRAWCLIPPER, LPGUID, int, int ) PURE;
    STDMETHOD( Update )( THIS ) PURE;
    STDMETHOD( AddUpdateCallback )( THIS_ D3DRMUPDATECALLBACK, LPVOID ) PURE;
    STDMETHOD( DeleteUpdateCallback )( THIS_ D3DRMUPDATECALLBACK, LPVOID ) PURE;
    STDMETHOD( SetBufferCount )( THIS_ DWORD ) PURE;
    STDMETHOD_( DWORD, GetBufferCount )( THIS ) PURE;
    STDMETHOD( SetDither )( THIS_ BOOL ) PURE;
    STDMETHOD( SetShades )( THIS_ DWORD ) PURE;
    STDMETHOD( SetQuality )( THIS_ D3DRMRENDERQUALITY ) PURE;
    STDMETHOD( SetTextureQuality )( THIS_ D3DRMTEXTUREQUALITY ) PURE;
    STDMETHOD( GetViewports )( THIS_ LPDIRECT3DRMVIEWPORTARRAY * ) PURE;
    STDMETHOD_( BOOL, GetDither )( THIS ) PURE;
    STDMETHOD_( DWORD, GetShades )( THIS ) PURE;
    STDMETHOD_( DWORD, GetHeight )( THIS ) PURE;
    STDMETHOD_( DWORD, GetWidth )( THIS ) PURE;
    STDMETHOD_( DWORD, GetTrianglesDrawn )( THIS ) PURE;
    STDMETHOD_( DWORD, GetWireframeOptions )( THIS ) PURE;
    STDMETHOD_( D3DRMRENDERQUALITY, GetQuality )( THIS ) PURE;
    STDMETHOD_( D3DCOLORMODEL, GetColorModel )( THIS ) PURE;
    STDMETHOD_( D3DRMTEXTUREQUALITY, GetTextureQuality )( THIS ) PURE;
    STDMETHOD( GetDirect3DDevice )( THIS_ LPDIRECT3DDEVICE * ) PURE;

    /* IDirect3DRMDevice2 methods */
    STDMETHOD( InitFromD3D2 )( THIS_ LPDIRECT3D2, LPDIRECT3DDEVICE2 ) PURE;
    STDMETHOD( InitFromSurface )( THIS_ LPGUID, LPDIRECTDRAW, LPDIRECTDRAWSURFACE ) PURE;
    STDMETHOD( SetRenderMode )( THIS_ DWORD ) PURE;
    STDMETHOD_( DWORD, GetRenderMode )( THIS ) PURE;
    STDMETHOD( GetDirect3DDevice2 )( THIS_ LPDIRECT3DDEVICE2 * ) PURE;

    /* IDirect3DRMDevice3 methods */
    STDMETHOD( FindPreferredTextureFormat )( THIS_ DWORD, DWORD, LPDDPIXELFORMAT ) PURE;
    STDMETHOD( RenderStateChange )( THIS_ D3DRENDERSTATETYPE, DWORD, DWORD ) PURE;
    STDMETHOD( LightStateChange )( THIS_ D3DLIGHTSTATETYPE, DWORD, DWORD ) PURE;
    STDMETHOD( GetStateChangeOptions )( THIS_ DWORD, DWORD, LPDWORD ) PURE;
    STDMETHOD( SetStateChangeOptions )( THIS_ DWORD, DWORD, DWORD ) PURE;
};

/* IDirect3DRMViewport interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMViewport
DECLARE_INTERFACE_( IDirect3DRMViewport, IDirect3DRMObject ) {
    IUNKNOWN_METHODS( PURE );
    IDIRECT3DRMOBJECT_METHODS( PURE );
    
    /* IDirect3DRMViewport methods */
    STDMETHOD( Init )( THIS_ LPDIRECT3DRMDEVICE, LPDIRECT3DRMFRAME, DWORD, DWORD, DWORD, DWORD ) PURE;
    STDMETHOD( Clear )( THIS ) PURE;
    STDMETHOD( Render )( THIS_ LPDIRECT3DRMFRAME ) PURE;
    STDMETHOD( SetFront )( THIS_ D3DVALUE ) PURE;
    STDMETHOD( SetBack )( THIS_ D3DVALUE ) PURE;
    STDMETHOD( SetField )( THIS_ D3DVALUE ) PURE;
    STDMETHOD( SetUniformScaling )( THIS_ BOOL ) PURE;
    STDMETHOD( SetCamera )( THIS_ LPDIRECT3DRMFRAME ) PURE;
    STDMETHOD( SetProjection )( THIS_ D3DRMPROJECTIONTYPE ) PURE;
    STDMETHOD( Transform )( THIS_ D3DRMVECTOR4D *, D3DVECTOR * ) PURE;
    STDMETHOD( InverseTransform )( THIS_ D3DVECTOR *, D3DRMVECTOR4D * ) PURE;
    STDMETHOD( Configure )( THIS_ LONG, LONG, DWORD, DWORD ) PURE;
    STDMETHOD( ForceUpdate )( THIS_ DWORD, DWORD, DWORD, DWORD ) PURE;
    STDMETHOD( SetPlane )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( GetCamera )( THIS_ LPDIRECT3DRMFRAME * ) PURE;
    STDMETHOD( GetDevice )( THIS_ LPDIRECT3DRMDEVICE * ) PURE;
    STDMETHOD( GetPlane )( THIS_ D3DVALUE *, D3DVALUE *, D3DVALUE *, D3DVALUE * ) PURE;
    STDMETHOD( Pick )( THIS_ LONG, LONG, LPDIRECT3DRMPICKEDARRAY * ) PURE;
    STDMETHOD_( BOOL, GetUniformScaling )( THIS ) PURE;
    STDMETHOD_( LONG, GetX )( THIS ) PURE;
    STDMETHOD_( LONG, GetY )( THIS ) PURE;
    STDMETHOD_( DWORD, GetWidth )( THIS ) PURE;
    STDMETHOD_( DWORD, GetHeight )( THIS ) PURE;
    STDMETHOD_( D3DVALUE, GetField )( THIS ) PURE;
    STDMETHOD_( D3DVALUE, GetBack )( THIS ) PURE;
    STDMETHOD_( D3DVALUE, GetFront )( THIS ) PURE;
    STDMETHOD_( D3DRMPROJECTIONTYPE, GetProjection )( THIS ) PURE;
    STDMETHOD( GetDirect3DViewport )( THIS_ LPDIRECT3DVIEWPORT * ) PURE;
};

/* IDirect3DRMViewport2 interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMViewport2
DECLARE_INTERFACE_( IDirect3DRMViewport2, IDirect3DRMObject ) {
    IUNKNOWN_METHODS( PURE );
    IDIRECT3DRMOBJECT_METHODS( PURE );
    
    /* IDirect3DRMViewport2 methods */
    STDMETHOD( Init )( THIS_ LPDIRECT3DRMDEVICE3, LPDIRECT3DRMFRAME3, DWORD, DWORD, DWORD, DWORD ) PURE;
    STDMETHOD( Clear )( THIS_ DWORD ) PURE;
    STDMETHOD( Render )( THIS_ LPDIRECT3DRMFRAME3 ) PURE;
    STDMETHOD( SetFront )( THIS_ D3DVALUE ) PURE;
    STDMETHOD( SetBack )( THIS_ D3DVALUE ) PURE;
    STDMETHOD( SetField )( THIS_ D3DVALUE ) PURE;
    STDMETHOD( SetUniformScaling )( THIS_ BOOL ) PURE;
    STDMETHOD( SetCamera )( THIS_ LPDIRECT3DRMFRAME3 ) PURE;
    STDMETHOD( SetProjection )( THIS_ D3DRMPROJECTIONTYPE ) PURE;
    STDMETHOD( Transform )( THIS_ D3DRMVECTOR4D *, D3DVECTOR * ) PURE;
    STDMETHOD( InverseTransform )( THIS_ D3DVECTOR *, D3DRMVECTOR4D * ) PURE;
    STDMETHOD( Configure )( THIS_ LONG, LONG, DWORD, DWORD ) PURE;
    STDMETHOD( ForceUpdate )( THIS_ DWORD, DWORD, DWORD, DWORD ) PURE;
    STDMETHOD( SetPlane )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( GetCamera )( THIS_ LPDIRECT3DRMFRAME3 * ) PURE;
    STDMETHOD( GetDevice )( THIS_ LPDIRECT3DRMDEVICE3 * ) PURE;
    STDMETHOD( GetPlane )( THIS_ D3DVALUE *, D3DVALUE *, D3DVALUE *, D3DVALUE * ) PURE;
    STDMETHOD( Pick )( THIS_ LONG, LONG, LPDIRECT3DRMPICKEDARRAY * ) PURE;
    STDMETHOD_( BOOL, GetUniformScaling )( THIS ) PURE;
    STDMETHOD_( LONG, GetX )( THIS ) PURE;
    STDMETHOD_( LONG, GetY )( THIS ) PURE;
    STDMETHOD_( DWORD, GetWidth )( THIS ) PURE;
    STDMETHOD_( DWORD, GetHeight )( THIS ) PURE;
    STDMETHOD_( D3DVALUE, GetField )( THIS ) PURE;
    STDMETHOD_( D3DVALUE, GetBack )( THIS ) PURE;
    STDMETHOD_( D3DVALUE, GetFront )( THIS ) PURE;
    STDMETHOD_( D3DRMPROJECTIONTYPE, GetProjection )( THIS ) PURE;
    STDMETHOD( GetDirect3DViewport )( THIS_ LPDIRECT3DVIEWPORT * ) PURE;
    STDMETHOD( TransformVectors )( THIS_ DWORD, LPD3DRMVECTOR4D, LPD3DVECTOR ) PURE;
    STDMETHOD( InverseTransformVectors )( THIS_ DWORD, LPD3DVECTOR, LPD3DRMVECTOR4D ) PURE;
};

/* IDirect3DRMFrame interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMFrame
DECLARE_INTERFACE_( IDirect3DRMFrame, IDirect3DRMVisual ) {
    IUNKNOWN_METHODS( PURE );
    IDIRECT3DRMOBJECT_METHODS( PURE );
    
    /* IDirect3DRMFrame methods */
    STDMETHOD( AddChild )( THIS_ LPDIRECT3DRMFRAME ) PURE;
    STDMETHOD( AddLight )( THIS_ LPDIRECT3DRMLIGHT ) PURE;
    STDMETHOD( AddMoveCallback )( THIS_ D3DRMFRAMEMOVECALLBACK, VOID * ) PURE;
    STDMETHOD( AddTransform )( THIS_ D3DRMCOMBINETYPE, D3DRMMATRIX4D ) PURE;
    STDMETHOD( AddTranslation )( THIS_ D3DRMCOMBINETYPE, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( AddScale )( THIS_ D3DRMCOMBINETYPE, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( AddRotation )( THIS_ D3DRMCOMBINETYPE, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( AddVisual )( THIS_ LPDIRECT3DRMVISUAL ) PURE;
    STDMETHOD( GetChildren )( THIS_ LPDIRECT3DRMFRAMEARRAY * ) PURE;
    STDMETHOD_( D3DCOLOR, GetColor )( THIS ) PURE;
    STDMETHOD( GetLights )( THIS_ LPDIRECT3DRMLIGHTARRAY * ) PURE;
    STDMETHOD_( D3DRMMATERIALMODE, GetMaterialMode )( THIS ) PURE;
    STDMETHOD( GetParent )( THIS_ LPDIRECT3DRMFRAME * ) PURE;
    STDMETHOD( GetPosition )( THIS_ LPDIRECT3DRMFRAME, LPD3DVECTOR ) PURE;
    STDMETHOD( GetRotation )( THIS_ LPDIRECT3DRMFRAME, LPD3DVECTOR, LPD3DVALUE ) PURE;
    STDMETHOD( GetScene )( THIS_ LPDIRECT3DRMFRAME * ) PURE;
    STDMETHOD_( D3DRMSORTMODE, GetSortMode )( THIS ) PURE;
    STDMETHOD( GetTexture )( THIS_ LPDIRECT3DRMTEXTURE * ) PURE;
    STDMETHOD( GetTransform )( THIS_ D3DRMMATRIX4D ) PURE;
    STDMETHOD( GetVelocity )( THIS_ LPDIRECT3DRMFRAME, LPD3DVECTOR, BOOL ) PURE;
    STDMETHOD( GetOrientation )( THIS_ LPDIRECT3DRMFRAME, LPD3DVECTOR, LPD3DVECTOR ) PURE;
    STDMETHOD( GetVisuals )( THIS_ LPDIRECT3DRMVISUALARRAY * ) PURE;
    STDMETHOD( GetTextureTopology )( THIS_ BOOL *, BOOL * ) PURE;
    STDMETHOD( InverseTransform )( THIS_ D3DVECTOR *, D3DVECTOR * ) PURE;
    STDMETHOD( Load )( THIS_ LPVOID, LPVOID, D3DRMLOADOPTIONS, D3DRMLOADTEXTURECALLBACK, LPVOID ) PURE;
    STDMETHOD( LookAt )( THIS_ LPDIRECT3DRMFRAME, LPDIRECT3DRMFRAME, D3DRMFRAMECONSTRAINT ) PURE;
    STDMETHOD( Move )( THIS_ D3DVALUE ) PURE;
    STDMETHOD( DeleteChild )( THIS_ LPDIRECT3DRMFRAME ) PURE;
    STDMETHOD( DeleteLight )( THIS_ LPDIRECT3DRMLIGHT ) PURE;
    STDMETHOD( DeleteMoveCallback )( THIS_ D3DRMFRAMEMOVECALLBACK, VOID * ) PURE;
    STDMETHOD( DeleteVisual )( THIS_ LPDIRECT3DRMVISUAL ) PURE;
    STDMETHOD_( D3DCOLOR, GetSceneBackground )( THIS ) PURE;
    STDMETHOD( GetSceneBackgroundDepth )( THIS_ LPDIRECTDRAWSURFACE * ) PURE;
    STDMETHOD_( D3DCOLOR, GetSceneFogColor )( THIS ) PURE;
    STDMETHOD_( BOOL, GetSceneFogEnable )( THIS ) PURE;
    STDMETHOD_( D3DRMFOGMODE, GetSceneFogMode )( THIS ) PURE;
    STDMETHOD( GetSceneFogParams )( THIS_ D3DVALUE *, D3DVALUE *, D3DVALUE * ) PURE;
    STDMETHOD( SetSceneBackground )( THIS_ D3DCOLOR ) PURE;
    STDMETHOD( SetSceneBackgroundRGB )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetSceneBackgroundDepth )( THIS_ LPDIRECTDRAWSURFACE ) PURE;
    STDMETHOD( SetSceneBackgroundImage )( THIS_ LPDIRECT3DRMTEXTURE ) PURE;
    STDMETHOD( SetSceneFogEnable )( THIS_ BOOL ) PURE;
    STDMETHOD( SetSceneFogColor )( THIS_ D3DCOLOR ) PURE;
    STDMETHOD( SetSceneFogMode )( THIS_ D3DRMFOGMODE ) PURE;
    STDMETHOD( SetSceneFogParams )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetColor )( THIS_ D3DCOLOR ) PURE;
    STDMETHOD( SetColorRGB )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD_( D3DRMZBUFFERMODE, GetZbufferMode )( THIS ) PURE;
    STDMETHOD( SetMaterialMode )( THIS_ D3DRMMATERIALMODE ) PURE;
    STDMETHOD( SetOrientation )( THIS_ LPDIRECT3DRMFRAME, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetPosition )( THIS_ LPDIRECT3DRMFRAME, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetRotation )( THIS_ LPDIRECT3DRMFRAME, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetSortMode )( THIS_ D3DRMSORTMODE ) PURE;
    STDMETHOD( SetTexture )( THIS_ LPDIRECT3DRMTEXTURE ) PURE;
    STDMETHOD( SetTextureTopology )( THIS_ BOOL, BOOL ) PURE;
    STDMETHOD( SetVelocity )( THIS_ LPDIRECT3DRMFRAME, D3DVALUE, D3DVALUE, D3DVALUE, BOOL ) PURE;
    STDMETHOD( SetZbufferMode )( THIS_ D3DRMZBUFFERMODE ) PURE;
    STDMETHOD( Transform )( THIS_ D3DVECTOR *, D3DVECTOR * ) PURE;
};

/* IDirect3DRMFrame2 interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMFrame2
DECLARE_INTERFACE_( IDirect3DRMFrame2, IDirect3DRMFrame ) {
    IUNKNOWN_METHODS( PURE );
    IDIRECT3DRMOBJECT_METHODS( PURE );
    
    /* IDirect3DRMFrame methods */
    STDMETHOD( AddChild )( THIS_ LPDIRECT3DRMFRAME ) PURE;
    STDMETHOD( AddLight )( THIS_ LPDIRECT3DRMLIGHT ) PURE;
    STDMETHOD( AddMoveCallback )( THIS_ D3DRMFRAMEMOVECALLBACK, VOID * ) PURE;
    STDMETHOD( AddTransform )( THIS_ D3DRMCOMBINETYPE, D3DRMMATRIX4D ) PURE;
    STDMETHOD( AddTranslation )( THIS_ D3DRMCOMBINETYPE, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( AddScale )( THIS_ D3DRMCOMBINETYPE, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( AddRotation )( THIS_ D3DRMCOMBINETYPE, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( AddVisual )( THIS_ LPDIRECT3DRMVISUAL ) PURE;
    STDMETHOD( GetChildren )( THIS_ LPDIRECT3DRMFRAMEARRAY * ) PURE;
    STDMETHOD_( D3DCOLOR, GetColor )( THIS ) PURE;
    STDMETHOD( GetLights )( THIS_ LPDIRECT3DRMLIGHTARRAY * ) PURE;
    STDMETHOD_( D3DRMMATERIALMODE, GetMaterialMode )( THIS ) PURE;
    STDMETHOD( GetParent )( THIS_ LPDIRECT3DRMFRAME * ) PURE;
    STDMETHOD( GetPosition )( THIS_ LPDIRECT3DRMFRAME, LPD3DVECTOR ) PURE;
    STDMETHOD( GetRotation )( THIS_ LPDIRECT3DRMFRAME, LPD3DVECTOR, LPD3DVALUE ) PURE;
    STDMETHOD( GetScene )( THIS_ LPDIRECT3DRMFRAME * ) PURE;
    STDMETHOD_( D3DRMSORTMODE, GetSortMode )( THIS ) PURE;
    STDMETHOD( GetTexture )( THIS_ LPDIRECT3DRMTEXTURE * ) PURE;
    STDMETHOD( GetTransform )( THIS_ D3DRMMATRIX4D ) PURE;
    STDMETHOD( GetVelocity )( THIS_ LPDIRECT3DRMFRAME, LPD3DVECTOR, BOOL ) PURE;
    STDMETHOD( GetOrientation )( THIS_ LPDIRECT3DRMFRAME, LPD3DVECTOR, LPD3DVECTOR ) PURE;
    STDMETHOD( GetVisuals )( THIS_ LPDIRECT3DRMVISUALARRAY * ) PURE;
    STDMETHOD( GetTextureTopology )( THIS_ BOOL *, BOOL * ) PURE;
    STDMETHOD( InverseTransform )( THIS_ D3DVECTOR *, D3DVECTOR * ) PURE;
    STDMETHOD( Load )( THIS_ LPVOID, LPVOID, D3DRMLOADOPTIONS, D3DRMLOADTEXTURECALLBACK, LPVOID ) PURE;
    STDMETHOD( LookAt )( THIS_ LPDIRECT3DRMFRAME, LPDIRECT3DRMFRAME, D3DRMFRAMECONSTRAINT ) PURE;
    STDMETHOD( Move )( THIS_ D3DVALUE ) PURE;
    STDMETHOD( DeleteChild )( THIS_ LPDIRECT3DRMFRAME ) PURE;
    STDMETHOD( DeleteLight )( THIS_ LPDIRECT3DRMLIGHT ) PURE;
    STDMETHOD( DeleteMoveCallback )( THIS_ D3DRMFRAMEMOVECALLBACK, VOID * ) PURE;
    STDMETHOD( DeleteVisual )( THIS_ LPDIRECT3DRMVISUAL ) PURE;
    STDMETHOD_( D3DCOLOR, GetSceneBackground )( THIS ) PURE;
    STDMETHOD( GetSceneBackgroundDepth )( THIS_ LPDIRECTDRAWSURFACE * ) PURE;
    STDMETHOD_( D3DCOLOR, GetSceneFogColor )( THIS ) PURE;
    STDMETHOD_( BOOL, GetSceneFogEnable )( THIS ) PURE;
    STDMETHOD_( D3DRMFOGMODE, GetSceneFogMode )( THIS ) PURE;
    STDMETHOD( GetSceneFogParams )( THIS_ D3DVALUE *, D3DVALUE *, D3DVALUE * ) PURE;
    STDMETHOD( SetSceneBackground )( THIS_ D3DCOLOR ) PURE;
    STDMETHOD( SetSceneBackgroundRGB )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetSceneBackgroundDepth )( THIS_ LPDIRECTDRAWSURFACE ) PURE;
    STDMETHOD( SetSceneBackgroundImage )( THIS_ LPDIRECT3DRMTEXTURE ) PURE;
    STDMETHOD( SetSceneFogEnable )( THIS_ BOOL ) PURE;
    STDMETHOD( SetSceneFogColor )( THIS_ D3DCOLOR ) PURE;
    STDMETHOD( SetSceneFogMode )( THIS_ D3DRMFOGMODE ) PURE;
    STDMETHOD( SetSceneFogParams )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetColor )( THIS_ D3DCOLOR ) PURE;
    STDMETHOD( SetColorRGB )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD_( D3DRMZBUFFERMODE, GetZbufferMode )( THIS ) PURE;
    STDMETHOD( SetMaterialMode )( THIS_ D3DRMMATERIALMODE ) PURE;
    STDMETHOD( SetOrientation )( THIS_ LPDIRECT3DRMFRAME, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetPosition )( THIS_ LPDIRECT3DRMFRAME, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetRotation )( THIS_ LPDIRECT3DRMFRAME, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetSortMode )( THIS_ D3DRMSORTMODE ) PURE;
    STDMETHOD( SetTexture )( THIS_ LPDIRECT3DRMTEXTURE ) PURE;
    STDMETHOD( SetTextureTopology )( THIS_ BOOL, BOOL ) PURE;
    STDMETHOD( SetVelocity )( THIS_ LPDIRECT3DRMFRAME, D3DVALUE, D3DVALUE, D3DVALUE, BOOL ) PURE;
    STDMETHOD( SetZbufferMode )( THIS_ D3DRMZBUFFERMODE ) PURE;
    STDMETHOD( Transform )( THIS_ D3DVECTOR *, D3DVECTOR * ) PURE;

    /* IDirect3DRMFrame2 methods */
    STDMETHOD( AddMoveCallback2 )( THIS_ D3DRMFRAMEMOVECALLBACK, VOID *, DWORD ) PURE;
    STDMETHOD( GetBox )( THIS_ LPD3DRMBOX ) PURE;
    STDMETHOD_( BOOL, GetBoxEnable )( THIS ) PURE;
    STDMETHOD( GetAxes )( THIS_ LPD3DVECTOR, LPD3DVECTOR ) PURE;
    STDMETHOD( GetMaterial )( THIS_ LPDIRECT3DRMMATERIAL * ) PURE;
    STDMETHOD_( BOOL, GetInheritAxes )( THIS ) PURE;
    STDMETHOD( GetHierarchyBox )( THIS_ LPD3DRMBOX ) PURE;
    STDMETHOD( SetBox )( THIS_ LPD3DRMBOX ) PURE;
    STDMETHOD( SetBoxEnable )( THIS_ BOOL ) PURE;
    STDMETHOD( SetAxes )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetInheritAxes )( THIS_ BOOL ) PURE;
    STDMETHOD( SetMaterial )( THIS_ LPDIRECT3DRMMATERIAL ) PURE;
    STDMETHOD( SetQuaternion )( THIS_ LPDIRECT3DRMFRAME, D3DRMQUATERNION * ) PURE;
    STDMETHOD( RayPick )( THIS_ LPDIRECT3DRMFRAME, LPD3DRMRAY, DWORD, LPDIRECT3DRMPICKED2ARRAY * ) PURE;
    STDMETHOD( Save )( THIS_ LPCSTR, D3DRMXOFFORMAT, D3DRMSAVEOPTIONS ) PURE;
};

/* IDirect3DRMFrame3 interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMFrame3
DECLARE_INTERFACE_( IDirect3DRMFrame3, IDirect3DRMVisual ) {
    IUNKNOWN_METHODS( PURE );
    IDIRECT3DRMOBJECT_METHODS( PURE );
    
    /* IDirect3DRMFrame3 methods */
    STDMETHOD( AddChild )( THIS_ LPDIRECT3DRMFRAME3 ) PURE;
    STDMETHOD( AddLight )( THIS_ LPDIRECT3DRMLIGHT ) PURE;
    STDMETHOD( AddMoveCallback )( THIS_ D3DRMFRAME3MOVECALLBACK, VOID *, DWORD ) PURE;
    STDMETHOD( AddTransform )( THIS_ D3DRMCOMBINETYPE, D3DRMMATRIX4D ) PURE;
    STDMETHOD( AddTranslation )( THIS_ D3DRMCOMBINETYPE, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( AddScale )( THIS_ D3DRMCOMBINETYPE, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( AddRotation )( THIS_ D3DRMCOMBINETYPE, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( AddVisual )( THIS_ LPUNKNOWN ) PURE;
    STDMETHOD( GetChildren )( THIS_ LPDIRECT3DRMFRAMEARRAY * ) PURE;
    STDMETHOD_( D3DCOLOR, GetColor )( THIS ) PURE;
    STDMETHOD( GetLights )( THIS_ LPDIRECT3DRMLIGHTARRAY * ) PURE;
    STDMETHOD_( D3DRMMATERIALMODE, GetMaterialMode )( THIS ) PURE;
    STDMETHOD( GetParent )( THIS_ LPDIRECT3DRMFRAME3 * ) PURE;
    STDMETHOD( GetPosition )( THIS_ LPDIRECT3DRMFRAME3, LPD3DVECTOR ) PURE;
    STDMETHOD( GetRotation )( THIS_ LPDIRECT3DRMFRAME3, LPD3DVECTOR, LPD3DVALUE ) PURE;
    STDMETHOD( GetScene )( THIS_ LPDIRECT3DRMFRAME3 * ) PURE;
    STDMETHOD_( D3DRMSORTMODE, GetSortMode )( THIS ) PURE;
    STDMETHOD( GetTexture )( THIS_ LPDIRECT3DRMTEXTURE3 * ) PURE;
    STDMETHOD( GetTransform )( THIS_ LPDIRECT3DRMFRAME3, D3DRMMATRIX4D ) PURE;
    STDMETHOD( GetVelocity )( THIS_ LPDIRECT3DRMFRAME3, LPD3DVECTOR, BOOL ) PURE;
    STDMETHOD( GetOrientation )( THIS_ LPDIRECT3DRMFRAME3, LPD3DVECTOR, LPD3DVECTOR ) PURE;
    STDMETHOD( GetVisuals )( THIS_ LPDWORD, LPUNKNOWN * ) PURE;
    STDMETHOD( InverseTransform )( THIS_ D3DVECTOR *, D3DVECTOR * ) PURE;
    STDMETHOD( Load )( THIS_ LPVOID, LPVOID, D3DRMLOADOPTIONS, D3DRMLOADTEXTURE3CALLBACK, LPVOID ) PURE;
    STDMETHOD( LookAt )( THIS_ LPDIRECT3DRMFRAME3, LPDIRECT3DRMFRAME3, D3DRMFRAMECONSTRAINT ) PURE;
    STDMETHOD( Move )( THIS_ D3DVALUE ) PURE;
    STDMETHOD( DeleteChild )( THIS_ LPDIRECT3DRMFRAME3 ) PURE;
    STDMETHOD( DeleteLight )( THIS_ LPDIRECT3DRMLIGHT ) PURE;
    STDMETHOD( DeleteMoveCallback )( THIS_ D3DRMFRAME3MOVECALLBACK, VOID * ) PURE;
    STDMETHOD( DeleteVisual )( THIS_ LPUNKNOWN ) PURE;
    STDMETHOD_( D3DCOLOR, GetSceneBackground )( THIS ) PURE;
    STDMETHOD( GetSceneBackgroundDepth )( THIS_ LPDIRECTDRAWSURFACE * ) PURE;
    STDMETHOD_( D3DCOLOR, GetSceneFogColor )( THIS ) PURE;
    STDMETHOD_( BOOL, GetSceneFogEnable )( THIS ) PURE;
    STDMETHOD_( D3DRMFOGMODE, GetSceneFogMode )( THIS ) PURE;
    STDMETHOD( GetSceneFogParams )( THIS_ D3DVALUE *, D3DVALUE *, D3DVALUE * ) PURE;
    STDMETHOD( SetSceneBackground )( THIS_ D3DCOLOR ) PURE;
    STDMETHOD( SetSceneBackgroundRGB )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetSceneBackgroundDepth )( THIS_ LPDIRECTDRAWSURFACE ) PURE;
    STDMETHOD( SetSceneBackgroundImage )( THIS_ LPDIRECT3DRMTEXTURE3 ) PURE;
    STDMETHOD( SetSceneFogEnable )( THIS_ BOOL ) PURE;
    STDMETHOD( SetSceneFogColor )( THIS_ D3DCOLOR ) PURE;
    STDMETHOD( SetSceneFogMode )( THIS_ D3DRMFOGMODE ) PURE;
    STDMETHOD( SetSceneFogParams )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetColor )( THIS_ D3DCOLOR ) PURE;
    STDMETHOD( SetColorRGB )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD_( D3DRMZBUFFERMODE, GetZbufferMode )( THIS ) PURE;
    STDMETHOD( SetMaterialMode )( THIS_ D3DRMMATERIALMODE ) PURE;
    STDMETHOD( SetOrientation )( THIS_ LPDIRECT3DRMFRAME3, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetPosition )( THIS_ LPDIRECT3DRMFRAME3, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetRotation )( THIS_ LPDIRECT3DRMFRAME3, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetSortMode )( THIS_ D3DRMSORTMODE ) PURE;
    STDMETHOD( SetTexture )( THIS_ LPDIRECT3DRMTEXTURE3 ) PURE;
    STDMETHOD( SetVelocity )( THIS_ LPDIRECT3DRMFRAME3, D3DVALUE, D3DVALUE, D3DVALUE, BOOL ) PURE;
    STDMETHOD( SetZbufferMode )( THIS_ D3DRMZBUFFERMODE ) PURE;
    STDMETHOD( Transform )( THIS_ D3DVECTOR *, D3DVECTOR * ) PURE;
    STDMETHOD( GetBox )( THIS_ LPD3DRMBOX ) PURE;
    STDMETHOD_( BOOL, GetBoxEnable )( THIS ) PURE;
    STDMETHOD( GetAxes )( THIS_ LPD3DVECTOR, LPD3DVECTOR ) PURE;
    STDMETHOD( GetMaterial )( THIS_ LPDIRECT3DRMMATERIAL2 * ) PURE;
    STDMETHOD_( BOOL, GetInheritAxes )( THIS ) PURE;
    STDMETHOD( GetHierarchyBox )( THIS_ LPD3DRMBOX ) PURE;
    STDMETHOD( SetBox )( THIS_ LPD3DRMBOX ) PURE;
    STDMETHOD( SetBoxEnable )( THIS_ BOOL ) PURE;
    STDMETHOD( SetAxes )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetInheritAxes )( THIS_ BOOL ) PURE;
    STDMETHOD( SetMaterial )( THIS_ LPDIRECT3DRMMATERIAL2 ) PURE;
    STDMETHOD( SetQuaternion )( THIS_ LPDIRECT3DRMFRAME3, D3DRMQUATERNION * ) PURE;
    STDMETHOD( RayPick )( THIS_ LPDIRECT3DRMFRAME3, LPD3DRMRAY, DWORD, LPDIRECT3DRMPICKED2ARRAY * ) PURE;
    STDMETHOD( Save )( THIS_ LPCSTR, D3DRMXOFFORMAT, D3DRMSAVEOPTIONS ) PURE;
    STDMETHOD( TransformVectors )( THIS_ LPDIRECT3DRMFRAME3, DWORD, LPD3DVECTOR, LPD3DVECTOR ) PURE;
    STDMETHOD( InverseTransformVectors )( THIS_ LPDIRECT3DRMFRAME3, DWORD, LPD3DVECTOR, LPD3DVECTOR ) PURE;
    STDMETHOD( SetTraversalOptions )( THIS_ DWORD ) PURE;
    STDMETHOD( GetTraversalOptions )( THIS_ LPDWORD ) PURE;
    STDMETHOD( SetSceneFogMethod )( THIS_ DWORD ) PURE;
    STDMETHOD( GetSceneFogMethod )( THIS_ LPDWORD ) PURE;
    STDMETHOD( SetMaterialOverride )( THIS_ LPD3DRMMATERIALOVERRIDE ) PURE;
    STDMETHOD( GetMaterialOverride )( THIS_ LPD3DRMMATERIALOVERRIDE ) PURE;
};

/* IDirect3DRMMesh interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMMesh
DECLARE_INTERFACE_( IDirect3DRMMesh, IDirect3DRMVisual ) {
    IUNKNOWN_METHODS( PURE );
    IDIRECT3DRMOBJECT_METHODS( PURE );
    
    /* IDirect3DRMMesh methods */
    STDMETHOD( Scale )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( Translate )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( GetBox )( THIS_ D3DRMBOX * ) PURE;
    STDMETHOD( AddGroup )( THIS_ unsigned, unsigned, unsigned, unsigned *, D3DRMGROUPINDEX * ) PURE;
    STDMETHOD( SetVertices )( THIS_ D3DRMGROUPINDEX, unsigned, unsigned, D3DRMVERTEX * ) PURE;
    STDMETHOD( SetGroupColor )( THIS_ D3DRMGROUPINDEX, D3DCOLOR ) PURE;
    STDMETHOD( SetGroupColorRGB )( THIS_ D3DRMGROUPINDEX, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetGroupMapping )( THIS_ D3DRMGROUPINDEX, D3DRMMAPPING ) PURE;
    STDMETHOD( SetGroupQuality )( THIS_ D3DRMGROUPINDEX, D3DRMRENDERQUALITY ) PURE;
    STDMETHOD( SetGroupMaterial )( THIS_ D3DRMGROUPINDEX, LPDIRECT3DRMMATERIAL ) PURE;
    STDMETHOD( SetGroupTexture )( THIS_ D3DRMGROUPINDEX, LPDIRECT3DRMTEXTURE ) PURE;
    STDMETHOD_( unsigned, GetGroupCount )( THIS ) PURE;
    STDMETHOD( GetGroup )( THIS_ D3DRMGROUPINDEX, unsigned *, unsigned *, unsigned *, DWORD *, unsigned * ) PURE;
    STDMETHOD( GetVertices )( THIS_ D3DRMGROUPINDEX, DWORD, DWORD, D3DRMVERTEX * ) PURE;
    STDMETHOD_( D3DCOLOR, GetGroupColor )( THIS_ D3DRMGROUPINDEX ) PURE;
    STDMETHOD_( D3DRMMAPPING, GetGroupMapping )( THIS_ D3DRMGROUPINDEX ) PURE;
    STDMETHOD_( D3DRMRENDERQUALITY, GetGroupQuality )( THIS_ D3DRMGROUPINDEX ) PURE;
    STDMETHOD( GetGroupMaterial )( THIS_ D3DRMGROUPINDEX, LPDIRECT3DRMMATERIAL * ) PURE;
    STDMETHOD( GetGroupTexture )( THIS_ D3DRMGROUPINDEX, LPDIRECT3DRMTEXTURE * ) PURE;
};

/* IDirect3DRMProgressiveMesh interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMProgressiveMesh
DECLARE_INTERFACE_( IDirect3DRMProgressiveMesh, IDirect3DRMVisual ) {
    IUNKNOWN_METHODS( PURE );
    IDIRECT3DRMOBJECT_METHODS( PURE );
    
    /* IDirect3DRMProgressiveMesh methods */
    STDMETHOD( Load )( THIS_ LPVOID, LPVOID, D3DRMLOADOPTIONS, D3DRMLOADTEXTURECALLBACK, LPVOID ) PURE;
    STDMETHOD( GetLoadStatus )( THIS_ LPD3DRMPMESHLOADSTATUS ) PURE;
    STDMETHOD( SetMinRenderDetail )( THIS_ D3DVALUE ) PURE;
    STDMETHOD( Abort )( THIS_ DWORD ) PURE;
    STDMETHOD( GetFaceDetail )( THIS_ LPDWORD ) PURE;
    STDMETHOD( GetVertexDetail )( THIS_ LPDWORD ) PURE;
    STDMETHOD( SetFaceDetail )( THIS_ DWORD ) PURE;
    STDMETHOD( SetVertexDetail )( THIS_ DWORD ) PURE;
    STDMETHOD( GetFaceDetailRange )( THIS_ LPDWORD, LPDWORD ) PURE;
    STDMETHOD( GetVertexDetailRange )( THIS_ LPDWORD, LPDWORD ) PURE;
    STDMETHOD( GetDetail )( THIS_ D3DVALUE * ) PURE;
    STDMETHOD( SetDetail )( THIS_ D3DVALUE ) PURE;
    STDMETHOD( RegisterEvents )( THIS_ HANDLE, DWORD, DWORD ) PURE;
    STDMETHOD( CreateMesh )( THIS_ LPDIRECT3DRMMESH * ) PURE;
    STDMETHOD( Duplicate )( THIS_ LPDIRECT3DRMPROGRESSIVEMESH * ) PURE;
    STDMETHOD( GetBox )( THIS_ LPD3DRMBOX ) PURE;
    STDMETHOD( SetQuality )( THIS_ D3DRMRENDERQUALITY ) PURE;
    STDMETHOD( GetQuality )( THIS_ LPD3DRMRENDERQUALITY ) PURE;
};

/* IDirect3DRMShadow interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMShadow
DECLARE_INTERFACE_( IDirect3DRMShadow, IDirect3DRMVisual ) {
    IUNKNOWN_METHODS( PURE );
    IDIRECT3DRMOBJECT_METHODS( PURE );
    
    /* IDirect3DRMShadow methods */
    STDMETHOD( Init )( THIS_ LPDIRECT3DRMVISUAL, LPDIRECT3DRMLIGHT, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
};

/* IDirect3DRMShadow2 interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMShadow2
DECLARE_INTERFACE_( IDirect3DRMShadow2, IDirect3DRMVisual ) {
    IUNKNOWN_METHODS( PURE );
    IDIRECT3DRMOBJECT_METHODS( PURE );
    
    /* IDirect3DRMShadow methods */
    STDMETHOD( Init )( THIS_ LPDIRECT3DRMVISUAL, LPDIRECT3DRMLIGHT, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    
    /* IDirect3DRMShadow2 methods */
    STDMETHOD( GetVisual )( THIS_ LPDIRECT3DRMVISUAL * ) PURE;
    STDMETHOD( SetVisual )( THIS_ LPUNKNOWN, DWORD ) PURE;
    STDMETHOD( GetLight )( THIS_ LPDIRECT3DRMLIGHT * ) PURE;
    STDMETHOD( SetLight )( THIS_ LPDIRECT3DRMLIGHT, DWORD ) PURE;
    STDMETHOD( GetPlane )( THIS_ LPD3DVALUE, LPD3DVALUE, LPD3DVALUE, LPD3DVALUE, LPD3DVALUE, LPD3DVALUE ) PURE;
    STDMETHOD( SetPlane )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE, DWORD ) PURE;
    STDMETHOD( GetOptions )( THIS_ LPDWORD ) PURE;
    STDMETHOD( SetOptions )( THIS_ DWORD ) PURE;
};

/* IDirect3DRMFace interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMFace
DECLARE_INTERFACE_( IDirect3DRMFace, IDirect3DRMObject ) {
    IUNKNOWN_METHODS( PURE );
    IDIRECT3DRMOBJECT_METHODS( PURE );
    
    /* IDirect3DRMFace methods */
    STDMETHOD( AddVertex )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( AddVertexAndNormalIndexed )( THIS_ DWORD, DWORD ) PURE;
    STDMETHOD( SetColorRGB )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetColor )( THIS_ D3DCOLOR ) PURE;
    STDMETHOD( SetTexture )( THIS_ LPDIRECT3DRMTEXTURE ) PURE;
    STDMETHOD( SetTextureCoordinates )( THIS_ DWORD, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetMaterial )( THIS_ LPDIRECT3DRMMATERIAL ) PURE;
    STDMETHOD( SetTextureTopology )( THIS_ BOOL, BOOL ) PURE;
    STDMETHOD( GetVertex )( THIS_ DWORD, D3DVECTOR *, D3DVECTOR * ) PURE;
    STDMETHOD( GetVertices )( THIS_ DWORD *, D3DVECTOR *, D3DVECTOR * ) PURE;
    STDMETHOD( GetTextureCoordinates )( THIS_ DWORD, D3DVALUE *, D3DVALUE * ) PURE;
    STDMETHOD( GetTextureTopology )( THIS_ BOOL *, BOOL * ) PURE;
    STDMETHOD( GetNormal )( THIS_ D3DVECTOR * ) PURE;
    STDMETHOD( GetTexture )( THIS_ LPDIRECT3DRMTEXTURE * ) PURE;
    STDMETHOD( GetMaterial )( THIS_ LPDIRECT3DRMMATERIAL * ) PURE;
    STDMETHOD_( int, GetVertexCount )( THIS ) PURE;
    STDMETHOD_( int, GetVertexIndex )( THIS_ DWORD ) PURE;
    STDMETHOD_( int, GetTextureCoordinateIndex )( THIS_ DWORD ) PURE;
    STDMETHOD_( D3DCOLOR, GetColor )( THIS ) PURE;
};

/* IDirect3DRMFace2 interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMFace2
DECLARE_INTERFACE_( IDirect3DRMFace2, IDirect3DRMObject ) {
    IUNKNOWN_METHODS( PURE );
    IDIRECT3DRMOBJECT_METHODS( PURE );
    
    /* IDirect3DRMFace2 methods */
    STDMETHOD( AddVertex )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( AddVertexAndNormalIndexed )( THIS_ DWORD, DWORD ) PURE;
    STDMETHOD( SetColorRGB )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetColor )( THIS_ D3DCOLOR ) PURE;
    STDMETHOD( SetTexture )( THIS_ LPDIRECT3DRMTEXTURE3 ) PURE;
    STDMETHOD( SetTextureCoordinates )( THIS_ DWORD, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetMaterial )( THIS_ LPDIRECT3DRMMATERIAL2 ) PURE;
    STDMETHOD( SetTextureTopology )( THIS_ BOOL, BOOL ) PURE;
    STDMETHOD( GetVertex )( THIS_ DWORD, D3DVECTOR *, D3DVECTOR * ) PURE;
    STDMETHOD( GetVertices )( THIS_ DWORD *, D3DVECTOR *, D3DVECTOR * ) PURE;
    STDMETHOD( GetTextureCoordinates )( THIS_ DWORD, D3DVALUE *, D3DVALUE * ) PURE;
    STDMETHOD( GetTextureTopology )( THIS_ BOOL *, BOOL * ) PURE;
    STDMETHOD( GetNormal )( THIS_ D3DVECTOR * ) PURE;
    STDMETHOD( GetTexture )( THIS_ LPDIRECT3DRMTEXTURE3 * ) PURE;
    STDMETHOD( GetMaterial )( THIS_ LPDIRECT3DRMMATERIAL2 * ) PURE;
    STDMETHOD_( int, GetVertexCount )( THIS ) PURE;
    STDMETHOD_( int, GetVertexIndex )( THIS_ DWORD ) PURE;
    STDMETHOD_( int, GetTextureCoordinateIndex )( THIS_ DWORD ) PURE;
    STDMETHOD_( D3DCOLOR, GetColor )( THIS ) PURE;
};

/* IDirect3DRMMeshBuilder interfaces */
#undef INTERFACE
#define INTERFACE   IDirect3DRMMeshBuilder
DECLARE_INTERFACE_( IDirect3DRMMeshBuilder, IDirect3DRMVisual ) {
    IUNKNOWN_METHODS( PURE );
    IDIRECT3DRMOBJECT_METHODS( PURE );
    
    /* IDirect3DRMMeshBuilder methods */
    STDMETHOD( Load )( THIS_ LPVOID, LPVOID, D3DRMLOADOPTIONS, D3DRMLOADTEXTURECALLBACK, LPVOID ) PURE;
    STDMETHOD( Save )( THIS_ const char *, D3DRMXOFFORMAT, D3DRMSAVEOPTIONS ) PURE;
    STDMETHOD( Scale )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( Translate )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetColorSource )( THIS_ D3DRMCOLORSOURCE ) PURE;
    STDMETHOD( GetBox )( THIS_ D3DRMBOX * ) PURE;
    STDMETHOD( GenerateNormals )( THIS ) PURE;
    STDMETHOD_( D3DRMCOLORSOURCE, GetColorSource )( THIS ) PURE;
    STDMETHOD( AddMesh )( THIS_ LPDIRECT3DRMMESH ) PURE;
    STDMETHOD( AddMeshBuilder )( THIS_ LPDIRECT3DRMMESHBUILDER ) PURE;
    STDMETHOD( AddFrame )( THIS_ LPDIRECT3DRMFRAME ) PURE;
    STDMETHOD( AddFace )( THIS_ LPDIRECT3DRMFACE ) PURE;
    STDMETHOD( AddFaces )( THIS_ DWORD, D3DVECTOR *, DWORD, D3DVECTOR *, DWORD *, LPDIRECT3DRMFACEARRAY * ) PURE;
    STDMETHOD( ReserveSpace )( THIS_ DWORD, DWORD, DWORD ) PURE;
    STDMETHOD( SetColorRGB )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetColor )( THIS_ D3DCOLOR ) PURE;
    STDMETHOD( SetTexture )( THIS_ LPDIRECT3DRMTEXTURE ) PURE;
    STDMETHOD( SetMaterial )( THIS_ LPDIRECT3DRMMATERIAL ) PURE;
    STDMETHOD( SetTextureTopology )( THIS_ BOOL, BOOL ) PURE;
    STDMETHOD( SetQuality )( THIS_ D3DRMRENDERQUALITY ) PURE;
    STDMETHOD( SetPerspective )( THIS_ BOOL ) PURE;
    STDMETHOD( SetVertex )( THIS_ DWORD, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetNormal )( THIS_ DWORD, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetTextureCoordinates )( THIS_ DWORD, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetVertexColor )( THIS_ DWORD, D3DCOLOR ) PURE;
    STDMETHOD( SetVertexColorRGB )( THIS_ DWORD, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( GetFaces )( THIS_ LPDIRECT3DRMFACEARRAY * ) PURE;
    STDMETHOD( GetVertices )( THIS_ DWORD *, D3DVECTOR *, DWORD *, D3DVECTOR *, DWORD *, DWORD * ) PURE;
    STDMETHOD( GetTextureCoordinates )( THIS_ DWORD, D3DVALUE *, D3DVALUE * ) PURE;
    STDMETHOD_( int, AddVertex )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD_( int, AddNormal )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( CreateFace )( THIS_ LPDIRECT3DRMFACE * ) PURE;
    STDMETHOD_( D3DRMRENDERQUALITY, GetQuality )( THIS ) PURE;
    STDMETHOD_( BOOL, GetPerspective )( THIS ) PURE;
    STDMETHOD_( int, GetFaceCount )( THIS ) PURE;
    STDMETHOD_( int, GetVertexCount )( THIS ) PURE;
    STDMETHOD_( D3DCOLOR, GetVertexColor )( THIS_ DWORD ) PURE;
    STDMETHOD( CreateMesh )( THIS_ LPDIRECT3DRMMESH * ) PURE;
};

/* IDirect3DRMMeshBuilder2 interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMMeshBuilder2
DECLARE_INTERFACE_( IDirect3DRMMeshBuilder2, IDirect3DRMMeshBuilder ) {
    IUNKNOWN_METHODS( PURE );
    IDIRECT3DRMOBJECT_METHODS( PURE );
    
    /* IDirect3DRMMeshBuilder methods */
    STDMETHOD( Load )( THIS_ LPVOID, LPVOID, D3DRMLOADOPTIONS, D3DRMLOADTEXTURECALLBACK, LPVOID ) PURE;
    STDMETHOD( Save )( THIS_ const char *, D3DRMXOFFORMAT, D3DRMSAVEOPTIONS ) PURE;
    STDMETHOD( Scale )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( Translate )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetColorSource )( THIS_ D3DRMCOLORSOURCE ) PURE;
    STDMETHOD( GetBox )( THIS_ D3DRMBOX * ) PURE;
    STDMETHOD( GenerateNormals )( THIS ) PURE;
    STDMETHOD_( D3DRMCOLORSOURCE, GetColorSource )( THIS ) PURE;
    STDMETHOD( AddMesh )( THIS_ LPDIRECT3DRMMESH ) PURE;
    STDMETHOD( AddMeshBuilder )( THIS_ LPDIRECT3DRMMESHBUILDER ) PURE;
    STDMETHOD( AddFrame )( THIS_ LPDIRECT3DRMFRAME ) PURE;
    STDMETHOD( AddFace )( THIS_ LPDIRECT3DRMFACE ) PURE;
    STDMETHOD( AddFaces )( THIS_ DWORD, D3DVECTOR *, DWORD, D3DVECTOR *, DWORD *, LPDIRECT3DRMFACEARRAY * ) PURE;
    STDMETHOD( ReserveSpace )( THIS_ DWORD, DWORD, DWORD ) PURE;
    STDMETHOD( SetColorRGB )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetColor )( THIS_ D3DCOLOR ) PURE;
    STDMETHOD( SetTexture )( THIS_ LPDIRECT3DRMTEXTURE ) PURE;
    STDMETHOD( SetMaterial )( THIS_ LPDIRECT3DRMMATERIAL ) PURE;
    STDMETHOD( SetTextureTopology )( THIS_ BOOL, BOOL ) PURE;
    STDMETHOD( SetQuality )( THIS_ D3DRMRENDERQUALITY ) PURE;
    STDMETHOD( SetPerspective )( THIS_ BOOL ) PURE;
    STDMETHOD( SetVertex )( THIS_ DWORD, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetNormal )( THIS_ DWORD, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetTextureCoordinates )( THIS_ DWORD, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetVertexColor )( THIS_ DWORD, D3DCOLOR ) PURE;
    STDMETHOD( SetVertexColorRGB )( THIS_ DWORD, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( GetFaces )( THIS_ LPDIRECT3DRMFACEARRAY * ) PURE;
    STDMETHOD( GetVertices )( THIS_ DWORD *, D3DVECTOR *, DWORD *, D3DVECTOR *, DWORD *, DWORD * ) PURE;
    STDMETHOD( GetTextureCoordinates )( THIS_ DWORD, D3DVALUE *, D3DVALUE * ) PURE;
    STDMETHOD_( int, AddVertex )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD_( int, AddNormal )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( CreateFace )( THIS_ LPDIRECT3DRMFACE * ) PURE;
    STDMETHOD_( D3DRMRENDERQUALITY, GetQuality )( THIS ) PURE;
    STDMETHOD_( BOOL, GetPerspective )( THIS ) PURE;
    STDMETHOD_( int, GetFaceCount )( THIS ) PURE;
    STDMETHOD_( int, GetVertexCount )( THIS ) PURE;
    STDMETHOD_( D3DCOLOR, GetVertexColor )( THIS_ DWORD ) PURE;
    STDMETHOD( CreateMesh )( THIS_ LPDIRECT3DRMMESH * ) PURE;

    /* IDirect3DRMMeshBuilder2 methods */
    STDMETHOD( GenerateNormals2 )( THIS_ D3DVALUE, DWORD ) PURE;
    STDMETHOD( GetFace )( THIS_ DWORD, LPDIRECT3DRMFACE * ) PURE;
};

/* IDirect3DRMMeshBuilder3 interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMMeshBuilder3
DECLARE_INTERFACE_( IDirect3DRMMeshBuilder3, IDirect3DRMVisual ) {
    IUNKNOWN_METHODS( PURE );
    IDIRECT3DRMOBJECT_METHODS( PURE );

    /* IDirect3DRMMeshBuilder3 methods */
    STDMETHOD( Load )( THIS_ LPVOID, LPVOID, D3DRMLOADOPTIONS, D3DRMLOADTEXTURE3CALLBACK, LPVOID ) PURE;
    STDMETHOD( Save )( THIS_ const char *, D3DRMXOFFORMAT, D3DRMSAVEOPTIONS ) PURE;
    STDMETHOD( Scale )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( Translate )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetColorSource )( THIS_ D3DRMCOLORSOURCE ) PURE;
    STDMETHOD( GetBox )( THIS_ D3DRMBOX * ) PURE;
    STDMETHOD( GenerateNormals )( THIS_ D3DVALUE, DWORD ) PURE;
    STDMETHOD_( D3DRMCOLORSOURCE, GetColorSource )( THIS ) PURE;
    STDMETHOD( AddMesh )( THIS_ LPDIRECT3DRMMESH ) PURE;
    STDMETHOD( AddMeshBuilder )( THIS_ LPDIRECT3DRMMESHBUILDER, DWORD ) PURE;
    STDMETHOD( AddFrame )( THIS_ LPDIRECT3DRMFRAME3 ) PURE;
    STDMETHOD( AddFace )( THIS_ LPDIRECT3DRMFACE2 ) PURE;
    STDMETHOD( AddFaces )( THIS_ DWORD, D3DVECTOR *, DWORD, D3DVECTOR *, DWORD *, LPDIRECT3DRMFACEARRAY * ) PURE;
    STDMETHOD( ReserveSpace )( THIS_ DWORD, DWORD, DWORD ) PURE;
    STDMETHOD( SetColorRGB )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetColor )( THIS_ D3DCOLOR ) PURE;
    STDMETHOD( SetTexture )( THIS_ LPDIRECT3DRMTEXTURE3 ) PURE;
    STDMETHOD( SetMaterial )( THIS_ LPDIRECT3DRMMATERIAL2 ) PURE;
    STDMETHOD( SetTextureTopology )( THIS_ BOOL, BOOL ) PURE;
    STDMETHOD( SetQuality )( THIS_ D3DRMRENDERQUALITY ) PURE;
    STDMETHOD( SetPerspective )( THIS_ BOOL ) PURE;
    STDMETHOD( SetVertex )( THIS_ DWORD, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetNormal )( THIS_ DWORD, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetTextureCoordinates )( THIS_ DWORD, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetVertexColor )( THIS_ DWORD, D3DCOLOR ) PURE;
    STDMETHOD( SetVertexColorRGB )( THIS_ DWORD, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( GetFaces )( THIS_ LPDIRECT3DRMFACEARRAY * ) PURE;
    STDMETHOD( GetGeometry )( THIS_ DWORD *, D3DVECTOR *, DWORD *, D3DVECTOR *, DWORD *, DWORD * ) PURE;
    STDMETHOD( GetTextureCoordinates )( THIS_ DWORD, D3DVALUE *, D3DVALUE * ) PURE;
    STDMETHOD_( int, AddVertex )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD_( int, AddNormal )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( CreateFace )( THIS_ LPDIRECT3DRMFACE2 * ) PURE;
    STDMETHOD_( D3DRMRENDERQUALITY, GetQuality )( THIS ) PURE;
    STDMETHOD_( BOOL, GetPerspective )( THIS ) PURE;
    STDMETHOD_( int, GetFaceCount )( THIS ) PURE;
    STDMETHOD_( int, GetVertexCount )( THIS ) PURE;
    STDMETHOD_( D3DCOLOR, GetVertexColor )( THIS_ DWORD ) PURE;
    STDMETHOD( CreateMesh )( THIS_ LPDIRECT3DRMMESH * ) PURE;
    STDMETHOD( GetFace )( THIS_ DWORD, LPDIRECT3DRMFACE2 * ) PURE;
    STDMETHOD( GetVertex )( THIS_ DWORD, LPD3DVECTOR ) PURE;
    STDMETHOD( GetNormal )( THIS_ DWORD, LPD3DVECTOR ) PURE;
    STDMETHOD( DeleteVertices )( THIS_ DWORD, DWORD ) PURE;
    STDMETHOD( DeleteNormals )( THIS_ DWORD, DWORD ) PURE;
    STDMETHOD( DeleteFace )( THIS_ LPDIRECT3DRMFACE2 ) PURE;
    STDMETHOD( Empty )( THIS_ DWORD ) PURE;
    STDMETHOD( Optimize )( THIS_ DWORD ) PURE;
    STDMETHOD( AddFacesIndexed )( THIS_ DWORD, DWORD *, DWORD *, DWORD * ) PURE;
    STDMETHOD( CreateSubMesh )( THIS_ LPUNKNOWN * ) PURE;
    STDMETHOD( GetParentMesh )( THIS_ DWORD, LPUNKNOWN * ) PURE;
    STDMETHOD( GetSubMeshes )( THIS_ LPDWORD, LPUNKNOWN * ) PURE;
    STDMETHOD( DeleteSubMesh )( THIS_ LPUNKNOWN ) PURE;
    STDMETHOD( Enable )( THIS_ DWORD ) PURE;
    STDMETHOD( GetEnable )( THIS_ DWORD * ) PURE;
    STDMETHOD( AddTriangles )( THIS_ DWORD, DWORD, DWORD, LPVOID ) PURE;
    STDMETHOD( SetVertices )( THIS_ DWORD, DWORD, LPD3DVECTOR ) PURE;
    STDMETHOD( GetVertices )( THIS_ DWORD, LPDWORD, LPD3DVECTOR ) PURE;
    STDMETHOD( SetNormals )( THIS_ DWORD, DWORD, LPD3DVECTOR ) PURE;
    STDMETHOD( GetNormals )( THIS_ DWORD, LPDWORD, LPD3DVECTOR ) PURE;
    STDMETHOD_( int, GetNormalCount )( THIS ) PURE;
};

/* IDirect3DRMLight interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMLight
DECLARE_INTERFACE_( IDirect3DRMLight, IDirect3DRMObject ) {
    IUNKNOWN_METHODS( PURE );
    IDIRECT3DRMOBJECT_METHODS( PURE );
    
    /* IDirect3DRMLight methods */
    STDMETHOD( SetType )( THIS_ D3DRMLIGHTTYPE ) PURE;
    STDMETHOD( SetColor )( THIS_ D3DCOLOR ) PURE;
    STDMETHOD( SetColorRGB )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetRange )( THIS_ D3DVALUE ) PURE;
    STDMETHOD( SetUmbra )( THIS_ D3DVALUE ) PURE;
    STDMETHOD( SetPenumbra )( THIS_ D3DVALUE ) PURE;
    STDMETHOD( SetConstantAttenuation )( THIS_ D3DVALUE ) PURE;
    STDMETHOD( SetLinearAttenuation )( THIS_ D3DVALUE ) PURE;
    STDMETHOD( SetQuadraticAttenuation )( THIS_ D3DVALUE ) PURE;
    STDMETHOD_( D3DVALUE, GetRange )( THIS ) PURE;
    STDMETHOD_( D3DVALUE, GetUmbra )( THIS ) PURE;
    STDMETHOD_( D3DVALUE, GetPenumbra )( THIS ) PURE;
    STDMETHOD_( D3DVALUE, GetConstantAttenuation )( THIS ) PURE;
    STDMETHOD_( D3DVALUE, GetLinearAttenuation )( THIS ) PURE;
    STDMETHOD_( D3DVALUE, GetQuadraticAttenuation )( THIS ) PURE;
    STDMETHOD_( D3DCOLOR, GetColor )( THIS ) PURE;
    STDMETHOD_( D3DRMLIGHTTYPE, GetType )( THIS ) PURE;
    STDMETHOD( SetEnableFrame )( THIS_ LPDIRECT3DRMFRAME ) PURE;
    STDMETHOD( GetEnableFrame )( THIS_ LPDIRECT3DRMFRAME * ) PURE;
};

/* IDirect3DRMTexture interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMTexture
DECLARE_INTERFACE_( IDirect3DRMTexture, IDirect3DRMVisual ) {
    IUNKNOWN_METHODS( PURE );
    IDIRECT3DRMOBJECT_METHODS( PURE );
    
    /* IDirect3DRMTexture methods */
    STDMETHOD( InitFromFile )( THIS_ const char * ) PURE;
    STDMETHOD( InitFromSurface )( THIS_ LPDIRECTDRAWSURFACE ) PURE;
    STDMETHOD( InitFromResource )( THIS_ HRSRC ) PURE;
    STDMETHOD( Changed )( THIS_ BOOL, BOOL ) PURE;
    STDMETHOD( SetColors )( THIS_ DWORD ) PURE;
    STDMETHOD( SetShades )( THIS_ DWORD ) PURE;
    STDMETHOD( SetDecalSize )( THIS_ D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetDecalOrigin )( THIS_ LONG, LONG ) PURE;
    STDMETHOD( SetDecalScale )( THIS_ DWORD ) PURE;
    STDMETHOD( SetDecalTransparency )( THIS_ BOOL ) PURE;
    STDMETHOD( SetDecalTransparentColor )( THIS_ D3DCOLOR ) PURE;
    STDMETHOD( GetDecalSize )( THIS_ D3DVALUE *, D3DVALUE * ) PURE;
    STDMETHOD( GetDecalOrigin )( THIS_ LONG *, LONG * ) PURE;
    STDMETHOD_( D3DRMIMAGE *, GetImage )( THIS ) PURE;
    STDMETHOD_( DWORD, GetShades )( THIS ) PURE;
    STDMETHOD_( DWORD, GetColors )( THIS ) PURE;
    STDMETHOD_( DWORD, GetDecalScale )( THIS ) PURE;
    STDMETHOD_( BOOL, GetDecalTransparency )( THIS ) PURE;
    STDMETHOD_( D3DCOLOR, GetDecalTransparentColor )( THIS ) PURE;
};

/* IDirect3DRMTexture2 interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMTexture2
DECLARE_INTERFACE_( IDirect3DRMTexture2, IDirect3DRMTexture ) {
    IUNKNOWN_METHODS( PURE );
    IDIRECT3DRMOBJECT_METHODS( PURE );
    
    /* IDirect3DRMTexture methods */
    STDMETHOD( InitFromFile )( THIS_ const char * ) PURE;
    STDMETHOD( InitFromSurface )( THIS_ LPDIRECTDRAWSURFACE ) PURE;
    STDMETHOD( InitFromResource )( THIS_ HRSRC ) PURE;
    STDMETHOD( Changed )( THIS_ BOOL, BOOL ) PURE;
    STDMETHOD( SetColors )( THIS_ DWORD ) PURE;
    STDMETHOD( SetShades )( THIS_ DWORD ) PURE;
    STDMETHOD( SetDecalSize )( THIS_ D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetDecalOrigin )( THIS_ LONG, LONG ) PURE;
    STDMETHOD( SetDecalScale )( THIS_ DWORD ) PURE;
    STDMETHOD( SetDecalTransparency )( THIS_ BOOL ) PURE;
    STDMETHOD( SetDecalTransparentColor )( THIS_ D3DCOLOR ) PURE;
    STDMETHOD( GetDecalSize )( THIS_ D3DVALUE *, D3DVALUE * ) PURE;
    STDMETHOD( GetDecalOrigin )( THIS_ LONG *, LONG * ) PURE;
    STDMETHOD_( D3DRMIMAGE *, GetImage )( THIS ) PURE;
    STDMETHOD_( DWORD, GetShades )( THIS ) PURE;
    STDMETHOD_( DWORD, GetColors )( THIS ) PURE;
    STDMETHOD_( DWORD, GetDecalScale )( THIS ) PURE;
    STDMETHOD_( BOOL, GetDecalTransparency )( THIS ) PURE;
    STDMETHOD_( D3DCOLOR, GetDecalTransparentColor )( THIS ) PURE;

    /* IDirect3DRMTexture2 methods */
    STDMETHOD( InitFromImage )( THIS_ LPD3DRMIMAGE ) PURE;
    STDMETHOD( InitFromResource2 )( THIS_ HMODULE, LPCTSTR, LPCTSTR ) PURE;
    STDMETHOD( GenerateMIPMap )( THIS_ DWORD ) PURE;
};

/* IDirect3DRMTexture3 interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMTexture3
DECLARE_INTERFACE_( IDirect3DRMTexture3, IDirect3DRMVisual ) {
    IUNKNOWN_METHODS( PURE );
    IDIRECT3DRMOBJECT_METHODS( PURE );
    
    /* IDirect3DRMTexture3 methods */
    STDMETHOD( InitFromFile )( THIS_ const char * ) PURE;
    STDMETHOD( InitFromSurface )( THIS_ LPDIRECTDRAWSURFACE ) PURE;
    STDMETHOD( InitFromResource )( THIS_ HRSRC ) PURE;
    STDMETHOD( Changed )( THIS_ DWORD, DWORD, LPRECT ) PURE;
    STDMETHOD( SetColors )( THIS_ DWORD ) PURE;
    STDMETHOD( SetShades )( THIS_ DWORD ) PURE;
    STDMETHOD( SetDecalSize )( THIS_ D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetDecalOrigin )( THIS_ LONG, LONG ) PURE;
    STDMETHOD( SetDecalScale )( THIS_ DWORD ) PURE;
    STDMETHOD( SetDecalTransparency )( THIS_ BOOL ) PURE;
    STDMETHOD( SetDecalTransparentColor )( THIS_ D3DCOLOR ) PURE;
    STDMETHOD( GetDecalSize )( THIS_ D3DVALUE *, D3DVALUE * ) PURE;
    STDMETHOD( GetDecalOrigin )( THIS_ LONG *, LONG * ) PURE;
    STDMETHOD_( D3DRMIMAGE *, GetImage )( THIS ) PURE;
    STDMETHOD_( DWORD, GetShades )( THIS ) PURE;
    STDMETHOD_( DWORD, GetColors )( THIS ) PURE;
    STDMETHOD_( DWORD, GetDecalScale )( THIS ) PURE;
    STDMETHOD_( BOOL, GetDecalTransparency )( THIS ) PURE;
    STDMETHOD_( D3DCOLOR, GetDecalTransparentColor )( THIS ) PURE;
    STDMETHOD( InitFromImage )( THIS_ LPD3DRMIMAGE ) PURE;
    STDMETHOD( InitFromResource2 )( THIS_ HMODULE, LPCTSTR, LPCTSTR ) PURE;
    STDMETHOD( GenerateMIPMap )( THIS_ DWORD ) PURE;
    STDMETHOD( GetSurface )( THIS_ DWORD, LPDIRECTDRAWSURFACE * ) PURE;
    STDMETHOD( SetCacheOptions )( THIS_ LONG, DWORD ) PURE;
    STDMETHOD( GetCacheOptions )( THIS_ LPLONG, LPDWORD ) PURE;
    STDMETHOD( SetDownsampleCallback )( THIS_ D3DRMDOWNSAMPLECALLBACK, LPVOID ) PURE;
    STDMETHOD( SetValidationCallback )( THIS_ D3DRMVALIDATIONCALLBACK, LPVOID ) PURE;
};

/* IDirect3DRMWrap interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMWrap
DECLARE_INTERFACE_( IDirect3DRMWrap, IDirect3DRMObject ) {
    IUNKNOWN_METHODS( PURE );
    IDIRECT3DRMOBJECT_METHODS( PURE );
    
    /* IDirect3DRMWrap methods */
    STDMETHOD( Init )( THIS_ D3DRMWRAPTYPE, LPDIRECT3DRMFRAME, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( Apply )( THIS_ LPDIRECT3DRMOBJECT ) PURE;
    STDMETHOD( ApplyRelative )( THIS_ LPDIRECT3DRMOBJECT, LPDIRECT3DRMOBJECT ) PURE;
};

/* IDirect3DRMMaterial interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMMaterial
DECLARE_INTERFACE_( IDirect3DRMMaterial, IDirect3DRMObject ) {
    IUNKNOWN_METHODS( PURE );
    IDIRECT3DRMOBJECT_METHODS( PURE );
    
    /* IDirect3DRMMaterial methods */
    STDMETHOD( SetPower )( THIS_ D3DVALUE ) PURE;
    STDMETHOD( SetSpecular )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetEmissive )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD_( D3DVALUE, GetPower )( THIS ) PURE;
    STDMETHOD( GetSpecular )( THIS_ D3DVALUE *, D3DVALUE *, D3DVALUE * ) PURE;
    STDMETHOD( GetEmissive )( THIS_ D3DVALUE *, D3DVALUE *, D3DVALUE * ) PURE;
};

/* IDirect3DRMMaterial2 interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMMaterial2
DECLARE_INTERFACE_( IDirect3DRMMaterial2, IDirect3DRMObject ) {
    IUNKNOWN_METHODS( PURE );
    IDIRECT3DRMOBJECT_METHODS( PURE );
    
    /* IDirect3DRMMaterial2 methods */
    STDMETHOD( SetPower )( THIS_ D3DVALUE ) PURE;
    STDMETHOD( SetSpecular )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( SetEmissive )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD_( D3DVALUE, GetPower )( THIS ) PURE;
    STDMETHOD( GetSpecular )( THIS_ D3DVALUE *, D3DVALUE *, D3DVALUE * ) PURE;
    STDMETHOD( GetEmissive )( THIS_ D3DVALUE *, D3DVALUE *, D3DVALUE * ) PURE;
    STDMETHOD( GetAmbient )( THIS_ D3DVALUE *, D3DVALUE *, D3DVALUE * ) PURE;
    STDMETHOD( SetAmbient )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
};

/* IDirect3DRMAnimation interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMAnimation
DECLARE_INTERFACE_( IDirect3DRMAnimation, IDirect3DRMObject ) {
    IUNKNOWN_METHODS( PURE );
    IDIRECT3DRMOBJECT_METHODS( PURE );
    
    /* IDirect3DRMAnimation methods */
    STDMETHOD( SetOptions )( THIS_ D3DRMANIMATIONOPTIONS ) PURE;
    STDMETHOD( AddRotateKey )( THIS_ D3DVALUE, D3DRMQUATERNION * ) PURE;
    STDMETHOD( AddPositiveKey )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( AddScaleKey )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( DeleteKey )( THIS_ D3DVALUE ) PURE;
    STDMETHOD( SetFrame )( THIS_ LPDIRECT3DRMFRAME ) PURE;
    STDMETHOD( SetTime )( THIS_ D3DVALUE ) PURE;
    STDMETHOD_( D3DRMANIMATIONOPTIONS, GetOptions )( THIS ) PURE;
};

/* IDirect3DRMAnimation2 interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMAnimation2
DECLARE_INTERFACE_( IDirect3DRMAnimation2, IDirect3DRMObject ) {
    IUNKNOWN_METHODS( PURE );
    IDIRECT3DRMOBJECT_METHODS( PURE );
    
    /* IDirect3DRMAnimation2 methods */
    STDMETHOD( SetOptions )( THIS_ D3DRMANIMATIONOPTIONS ) PURE;
    STDMETHOD( AddRotateKey )( THIS_ D3DVALUE, D3DRMQUATERNION * ) PURE;
    STDMETHOD( AddPositiveKey )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( AddScaleKey )( THIS_ D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE ) PURE;
    STDMETHOD( DeleteKey )( THIS_ D3DVALUE ) PURE;
    STDMETHOD( SetFrame )( THIS_ LPDIRECT3DRMFRAME3 ) PURE;
    STDMETHOD( SetTime )( THIS_ D3DVALUE ) PURE;
    STDMETHOD_( D3DRMANIMATIONOPTIONS, GetOptions )( THIS ) PURE;
    STDMETHOD( GetFrame )( THIS_ LPDIRECT3DRMFRAME3 * ) PURE;
    STDMETHOD( DeleteKeyByID )( THIS_ DWORD ) PURE;
    STDMETHOD( AddKey )( THIS_ LPD3DRMANIMATIONKEY ) PURE;
    STDMETHOD( ModifyKey )( THIS_ LPD3DRMANIMATIONKEY ) PURE;
    STDMETHOD( GetKeys )( THIS_ D3DVALUE, D3DVALUE, LPDWORD, LPD3DRMANIMATIONKEY ) PURE;
};

/* IDirect3DRMAnimationSet interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMAnimationSet
DECLARE_INTERFACE_( IDirect3DRMAnimationSet, IDirect3DRMObject ) {
    IUNKNOWN_METHODS( PURE );
    IDIRECT3DRMOBJECT_METHODS( PURE );
    
    /* IDirect3DRMAnimationSet methods */
    STDMETHOD( AddAnimation )( THIS_ LPDIRECT3DRMANIMATION ) PURE;
    STDMETHOD( Load )( THIS_ LPVOID, LPVOID, D3DRMLOADOPTIONS, D3DRMLOADTEXTURECALLBACK, LPVOID, LPDIRECT3DRMFRAME ) PURE;
    STDMETHOD( DeleteAnimation )( THIS_ LPDIRECT3DRMANIMATION ) PURE;
    STDMETHOD( SetTime )( THIS_ D3DVALUE ) PURE;
};

/* IDirect3DRMAnimationSet2 interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMAnimationSet2
DECLARE_INTERFACE_( IDirect3DRMAnimationSet2, IDirect3DRMObject ) {
    IUNKNOWN_METHODS( PURE );
    IDIRECT3DRMOBJECT_METHODS( PURE );
    
    /* IDirect3DRMAnimationSet2 methods */
    STDMETHOD( AddAnimation )( THIS_ LPDIRECT3DRMANIMATION2 ) PURE;
    STDMETHOD( Load )( THIS_ LPVOID, LPVOID, D3DRMLOADOPTIONS, D3DRMLOADTEXTURE3CALLBACK, LPVOID, LPDIRECT3DRMFRAME3 ) PURE;
    STDMETHOD( DeleteAnimation )( THIS_ LPDIRECT3DRMANIMATION2 ) PURE;
    STDMETHOD( SetTime )( THIS_ D3DVALUE ) PURE;
    STDMETHOD( GetAnimations )( THIS_ LPDIRECT3DRMANIMATIONARRAY * ) PURE;
};

/* IDirect3DRMUserVisual interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMUserVisual
DECLARE_INTERFACE_( IDirect3DRMUserVisual, IDirect3DRMVisual ) {
    IUNKNOWN_METHODS( PURE );
    IDIRECT3DRMOBJECT_METHODS( PURE );
    
    /* IDirect3DRMUserVisual methods */
    STDMETHOD( Init )( THIS_ D3DRMUSERVISUALCALLBACK, void * ) PURE;
};

/* IDirect3DRMArray interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMArray
DECLARE_INTERFACE_( IDirect3DRMArray, IUnknown ) {
    IUNKNOWN_METHODS( PURE );
    
    /* IDirect3DRMArray methods */
    STDMETHOD_( DWORD, GetSize )( THIS ) PURE;
};

/* IDirect3DRMObjectArray interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMObjectArray
DECLARE_INTERFACE_( IDirect3DRMObjectArray, IDirect3DRMArray ) {
    IUNKNOWN_METHODS( PURE );
    
    /* IDirect3DRMArray methods */
    STDMETHOD_( DWORD, GetSize )( THIS ) PURE;

    /* IDirect3DRMObjectArray methods */
    STDMETHOD( GetElement )( THIS_ DWORD, LPDIRECT3DRMOBJECT * ) PURE;
};

/* IDirect3DRMDeviceArray interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMDeviceArray
DECLARE_INTERFACE_( IDirect3DRMDeviceArray, IDirect3DRMArray ) {
    IUNKNOWN_METHODS( PURE );
    
    /* IDirect3DRMArray methods */
    STDMETHOD_( DWORD, GetSize )( THIS ) PURE;

    /* IDirect3DRMDeviceArray methods */
    STDMETHOD( GetElement )( THIS_ DWORD, LPDIRECT3DRMDEVICE * ) PURE;
};

/* IDirect3DRMFrameArray interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMFrameArray
DECLARE_INTERFACE_( IDirect3DRMFrameArray, IDirect3DRMArray ) {
    IUNKNOWN_METHODS( PURE );
    
    /* IDirect3DRMArray methods */
    STDMETHOD_( DWORD, GetSize )( THIS ) PURE;

    /* IDirect3DRMFrameArray methods */
    STDMETHOD( GetElement )( THIS_ DWORD, LPDIRECT3DRMFRAME * ) PURE;
};

/* IDirect3DRMViewportArray interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMViewportArray
DECLARE_INTERFACE_( IDirect3DRMViewportArray, IDirect3DRMArray ) {
    IUNKNOWN_METHODS( PURE );
    
    /* IDirect3DRMArray methods */
    STDMETHOD_( DWORD, GetSize )( THIS ) PURE;

    /* IDirect3DRMViewportArray methods */
    STDMETHOD( GetElement )( THIS_ DWORD, LPDIRECT3DRMVIEWPORT * ) PURE;
};

/* IDirect3DRMVisualArray interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMVisualArray
DECLARE_INTERFACE_( IDirect3DRMVisualArray, IDirect3DRMArray ) {
    IUNKNOWN_METHODS( PURE );
    
    /* IDirect3DRMArray methods */
    STDMETHOD_( DWORD, GetSize )( THIS ) PURE;

    /* IDirect3DRMVisualArray methods */
    STDMETHOD( GetElement )( THIS_ DWORD, LPDIRECT3DRMVISUAL * ) PURE;
};

/* IDirect3DRMAnimationArray interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMAnimationArray
DECLARE_INTERFACE_( IDirect3DRMAnimationArray, IDirect3DRMArray ) {
    IUNKNOWN_METHODS( PURE );
    
    /* IDirect3DRMArray methods */
    STDMETHOD_( DWORD, GetSize )( THIS ) PURE;

    /* IDirect3DRMAnimationArray methods */
    STDMETHOD( GetElement )( THIS_ DWORD, LPDIRECT3DRMANIMATION2 * ) PURE;
};

/* IDirect3DRMPickedArray interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMPickedArray
DECLARE_INTERFACE_( IDirect3DRMPickedArray, IDirect3DRMArray ) {
    IUNKNOWN_METHODS( PURE );
    
    /* IDirect3DRMArray methods */
    STDMETHOD_( DWORD, GetSize )( THIS ) PURE;

    /* IDirect3DRMPickedArray methods */
    STDMETHOD( GetPick )( THIS_ DWORD, LPDIRECT3DRMVISUAL *, LPDIRECT3DRMFRAMEARRAY *, LPD3DRMPICKDESC ) PURE;
};

/* IDirect3DRMLightArray interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMLightArray
DECLARE_INTERFACE_( IDirect3DRMLightArray, IDirect3DRMArray ) {
    IUNKNOWN_METHODS( PURE );
    
    /* IDirect3DRMArray methods */
    STDMETHOD_( DWORD, GetSize )( THIS ) PURE;

    /* IDirect3DRMLightArray methods */
    STDMETHOD( GetElement )( THIS_ DWORD, LPDIRECT3DRMLIGHT * ) PURE;
};

/* IDirect3DRMFaceArray interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMFaceArray
DECLARE_INTERFACE_( IDirect3DRMFaceArray, IDirect3DRMArray ) {
    IUNKNOWN_METHODS( PURE );
    
    /* IDirect3DRMArray methods */
    STDMETHOD_( DWORD, GetSize )( THIS ) PURE;

    /* IDirect3DRMFaceArray methods */
    STDMETHOD( GetElement )( THIS_ DWORD, LPDIRECT3DRMFACE * ) PURE;
};

/* IDirect3DRMPicked2Array interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMPicked2Array
DECLARE_INTERFACE_( IDirect3DRMPicked2Array, IDirect3DRMArray ) {
    IUNKNOWN_METHODS( PURE );
    
    /* IDirect3DRMArray methods */
    STDMETHOD_( DWORD, GetSize )( THIS ) PURE;

    /* IDirect3DRMPicked2Array methods */
    STDMETHOD( GetPick )( THIS_ DWORD, LPDIRECT3DRMVISUAL *, LPDIRECT3DRMFRAMEARRAY *, LPD3DRMPICKDESC2 ) PURE;
};

/* IDirect3DRMInterpolator interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMInterpolator
DECLARE_INTERFACE_( IDirect3DRMInterpolator, IDirect3DRMObject ) {
    IUNKNOWN_METHODS( PURE );
    
    /* IDirect3DRMArray methods */
    STDMETHOD_( DWORD, GetSize )( THIS ) PURE;

    /* IDirect3DRMInterpolator methods */
    STDMETHOD( AttachObject )( THIS_ LPDIRECT3DRMOBJECT ) PURE;
    STDMETHOD( GetAttachedObjects )( THIS_ LPDIRECT3DRMOBJECTARRAY * ) PURE;
    STDMETHOD( DetachObject )( THIS_ LPDIRECT3DRMOBJECT ) PURE;
    STDMETHOD( SetIndex )( THIS_ D3DVALUE ) PURE;
    STDMETHOD_( D3DVALUE, GetIndex )( THIS ) PURE;
    STDMETHOD( Interpolate )( THIS_ D3DVALUE, LPDIRECT3DRMOBJECT, D3DRMINTERPOLATIONOPTIONS ) PURE;
};

/* IDirect3DRMClippedVisual interface */
#undef INTERFACE
#define INTERFACE   IDirect3DRMClippedVisual
DECLARE_INTERFACE_( IDirect3DRMClippedVisual, IDirect3DRMVisual ) {
    IUNKNOWN_METHODS( PURE );
    IDIRECT3DRMOBJECT_METHODS( PURE );
    
    /* IDirect3DRMClippedVisual methods */
    STDMETHOD( Init )( THIS_ LPDIRECT3DRMVISUAL ) PURE;
    STDMETHOD( AddPlane )( THIS_ LPDIRECT3DRMFRAME3, LPD3DVECTOR, LPD3DVECTOR, DWORD, LPDWORD ) PURE;
    STDMETHOD( DeletePlane )( THIS_ DWORD, DWORD ) PURE;
    STDMETHOD( GetPlaneIDs )( THIS_ LPDWORD, LPDWORD, DWORD ) PURE;
    STDMETHOD( GetPlane )( THIS_ DWORD, LPDIRECT3DRMFRAME3, LPD3DVECTOR, LPD3DVECTOR, DWORD ) PURE;
    STDMETHOD( SetPlane )( THIS_ DWORD, LPDIRECT3DRMFRAME3, LPD3DVECTOR, LPD3DVECTOR, DWORD ) PURE;
};

#ifdef __cplusplus
} /* extern "C" */
#endif

/* GUIDs */
EXTERN_C const IID      __cdecl IID_IDirect3DRMObject;
EXTERN_C const IID      __cdecl IID_IDirect3DRMObject2;
EXTERN_C const IID      __cdecl IID_IDirect3DRMVisual;
EXTERN_C const IID      __cdecl IID_IDirect3DRMDevice;
EXTERN_C const IID      __cdecl IID_IDirect3DRMDevice2;
EXTERN_C const IID      __cdecl IID_IDirect3DRMDevice3;
EXTERN_C const IID      __cdecl IID_IDirect3DRMViewport;
EXTERN_C const IID      __cdecl IID_IDirect3DRMViewport2;
EXTERN_C const IID      __cdecl IID_IDirect3DRMFrame;
EXTERN_C const IID      __cdecl IID_IDirect3DRMFrame2;
EXTERN_C const IID      __cdecl IID_IDirect3DRMFrame3;
EXTERN_C const IID      __cdecl IID_IDirect3DRMMesh;
EXTERN_C const IID      __cdecl IID_IDirect3DRMProgressiveMesh;
EXTERN_C const IID      __cdecl IID_IDirect3DRMShadow;
EXTERN_C const IID      __cdecl IID_IDirect3DRMShadow2;
EXTERN_C const IID      __cdecl IID_IDirect3DRMFace;
EXTERN_C const IID      __cdecl IID_IDirect3DRMFace2;
EXTERN_C const IID      __cdecl IID_IDirect3DRMMeshBuilder;
EXTERN_C const IID      __cdecl IID_IDirect3DRMMeshBuilder2;
EXTERN_C const IID      __cdecl IID_IDirect3DRMMeshBuilder3;
EXTERN_C const IID      __cdecl IID_IDirect3DRMLight;
EXTERN_C const IID      __cdecl IID_IDirect3DRMTexture;
EXTERN_C const IID      __cdecl IID_IDirect3DRMTexture2;
EXTERN_C const IID      __cdecl IID_IDirect3DRMTexture3;
EXTERN_C const IID      __cdecl IID_IDirect3DRMWrap;
EXTERN_C const IID      __cdecl IID_IDirect3DRMMaterial;
EXTERN_C const IID      __cdecl IID_IDirect3DRMMaterial2;
EXTERN_C const IID      __cdecl IID_IDirect3DRMAnimation;
EXTERN_C const IID      __cdecl IID_IDirect3DRMAnimation2;
EXTERN_C const IID      __cdecl IID_IDirect3DRMAnimationSet;
EXTERN_C const IID      __cdecl IID_IDirect3DRMAnimationSet2;
EXTERN_C const IID      __cdecl IID_IDirect3DRMUserVisual;
EXTERN_C const IID      __cdecl IID_IDirect3DRMArray;
EXTERN_C const IID      __cdecl IID_IDirect3DRMObjectArray;
EXTERN_C const IID      __cdecl IID_IDirect3DRMDeviceArray;
EXTERN_C const IID      __cdecl IID_IDirect3DRMFrameArray;
EXTERN_C const IID      __cdecl IID_IDirect3DRMViewportArray;
EXTERN_C const IID      __cdecl IID_IDirect3DRMVisualArray;
EXTERN_C const IID      __cdecl IID_IDirect3DRMAnimationArray;
EXTERN_C const IID      __cdecl IID_IDirect3DRMPickedArray;
EXTERN_C const IID      __cdecl IID_IDirect3DRMLightArray;
EXTERN_C const IID      __cdecl IID_IDirect3DRMFaceArray;
EXTERN_C const IID      __cdecl IID_IDirect3DRMPicked2Array;
EXTERN_C const IID      __cdecl IID_IDirect3DRMInterpolator;
EXTERN_C const IID      __cdecl IID_IDirect3DRMClippedVisual;
EXTERN_C const CLSID    __cdecl CLSID_CDirect3DRMDevice;
EXTERN_C const CLSID    __cdecl CLSID_CDirect3DRMViewport;
EXTERN_C const CLSID    __cdecl CLSID_CDirect3DRMFrame;
EXTERN_C const CLSID    __cdecl CLSID_CDirect3DRMMesh;
EXTERN_C const CLSID    __cdecl CLSID_CDirect3DRMMeshBuilder;
EXTERN_C const CLSID    __cdecl CLSID_CDirect3DRMFace;
EXTERN_C const CLSID    __cdecl CLSID_CDirect3DRMLight;
EXTERN_C const CLSID    __cdecl CLSID_CDirect3DRMTexture;
EXTERN_C const CLSID    __cdecl CLSID_CDirect3DRMWrap;
EXTERN_C const CLSID    __cdecl CLSID_CDirect3DRMMaterial;
EXTERN_C const CLSID    __cdecl CLSID_CDirect3DRMAnimation;
EXTERN_C const CLSID    __cdecl CLSID_CDirect3DRMAnimationSet;
EXTERN_C const CLSID    __cdecl CLSID_CDirect3DRMUserVisual;
EXTERN_C const CLSID    __cdecl CLSID_CDirect3DRMShadow;
EXTERN_C const CLSID    __cdecl CLSID_CDirect3DRMViewportInterpolator;
EXTERN_C const CLSID    __cdecl CLSID_CDirect3DRMFrameInterpolator;
EXTERN_C const CLSID    __cdecl CLSID_CDirect3DRMMeshInterpolator;
EXTERN_C const CLSID    __cdecl CLSID_CDirect3DRMLightInterpolator;
EXTERN_C const CLSID    __cdecl CLSID_CDirect3DRMMaterialInterpolator;
EXTERN_C const CLSID    __cdecl CLSID_CDirect3DRMTextureInterpolator;
EXTERN_C const CLSID    __cdecl CLSID_CDirect3DRMProgressiveMesh;
EXTERN_C const CLSID    __cdecl CLSID_CDirect3DRMClippedVisual;

#endif /* _D3DRMOBJ_H_ */
