/*
 *  ifmib.h     Interface Management Information Base (MIB) definitions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _IFMIB_
#define _IFMIB_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#include <ifdef.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Value used to declare an array of an unknown size */
#ifndef ANY_SIZE
    #define ANY_SIZE    1
#endif

/* Maximum lengths */
#define MAXLEN_PHYSADDR         8
#define MAXLEN_IFDESCR          256
#define MAX_INTERFACE_NAME_LEN  256

/* MIB interface number */
typedef struct _MIB_IFNUMBER {
    DWORD   dwValue;
} MIB_IFNUMBER;
typedef MIB_IFNUMBER    *PMIB_IFNUMBER;

/* MIB interface row */
typedef struct _MIB_IFROW {
    WCHAR                   wszName[MAX_INTERFACE_NAME_LEN];
    IF_INDEX                dwIndex;
    IFTYPE                  dwType;
    DWORD                   dwMtu;
    DWORD                   dwSpeed;
    DWORD                   dwPhysAddrLen;
    UCHAR                   bPhysAddr[MAXLEN_PHYSADDR];
    DWORD                   dwAdminStatus;
    INTERNAL_IF_OPER_STATUS dwOperStatus;
    DWORD                   dwLastChange;
    DWORD                   dwInOctets;
    DWORD                   dwInUcastPkts;
    DWORD                   dwInNUcastPkts;
    DWORD                   dwInDiscards;
    DWORD                   dwInErrors;
    DWORD                   dwInUnknownProtos;
    DWORD                   dwOutOctets;
    DWORD                   dwOutUcastPkts;
    DWORD                   dwOutNUcastPkts;
    DWORD                   dwOutDiscards;
    DWORD                   dwOutErrors;
    DWORD                   dwOutQLen;
    DWORD                   dwDescrLen;
    UCHAR                   bDescr[MAXLEN_IFDESCR];
} MIB_IFROW;
typedef MIB_IFROW   *PMIB_IFROW;

/* MIB interface table */
typedef struct _MIB_IFTABLE {
    DWORD       dwNumEntries;
    MIB_IFROW   table[ANY_SIZE];
} MIB_IFTABLE;
typedef MIB_IFTABLE *PMIB_IFTABLE;

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _IFMIB_ */
