/*
 *  ipxsap.h    IPX SAP structures
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _IPXSAP_
#define _IPXSAP_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#include <ipxconst.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Filter actions */
#define IPX_SERVICE_FILTER_PERMIT   1L
#define IPX_SERVICE_FILTER_DENY     2L

/* SAP table identifiers */
#define SAP_BASE_ENTRY      0
#define SAP_INTERFACE_TABLE 1

/* SAP global information */
typedef struct _SAP_GLOBAL_INFO {
    DWORD   EventLogMask;
} SAP_GLOBAL_INFO;
typedef SAP_GLOBAL_INFO *PSAP_GLOBAL_INFO;

/* SAP interface information */
typedef struct _SAP_IF_INFO {
    ULONG   AdminState;
    ULONG   UpdateMode;
    ULONG   PacketType;
    ULONG   Supply;
    ULONG   Listen;
    ULONG   GetNearestServerReply;
    ULONG   PeriodicUpdateInterval;
    ULONG   AgeIntervalMultiplier;
} SAP_IF_INFO;
typedef SAP_IF_INFO *PSAP_IF_INFO;

/* SAP service filter information */
typedef struct _SAP_SERVICE_FILTER_INFO {
    union {
        USHORT  ServiceType;
        ULONG   ServiceType_align;
    };
    UCHAR   ServiceName[48];
} SAP_SERVICE_FILTER_INFO;
typedef SAP_SERVICE_FILTER_INFO *PSAP_SERVICE_FILTER_INFO;

/* SAP interface filters */
typedef struct _SAP_IF_FILTERS {
    ULONG                   SupplyFilterAction;
    ULONG                   SupplyFilterCount;
    ULONG                   ListenFilterAction;
    ULONG                   ListenFilterCount;
    SAP_SERVICE_FILTER_INFO ServiceFilter[1];
} SAP_IF_FILTERS;
typedef SAP_IF_FILTERS  *PSAP_IF_FILTERS;

/* SAP interface configuration information */
typedef struct _SAP_IF_CONFIG {
    SAP_IF_INFO     SapIfInfo;
    SAP_IF_FILTERS  SapIfFilters;
} SAP_IF_CONFIG;
typedef SAP_IF_CONFIG   *PSAP_IF_CONFIG;

/* SAP MIB base */
typedef struct _SAP_MIB_BASE {
    ULONG   SapOperState;
} SAP_MIB_BASE;
typedef SAP_MIB_BASE    *PSAP_MIB_BASE;

/* SAP interface statistics */
typedef struct _SAP_IF_STATS {
    ULONG   SapIfOperState;
    ULONG   SapIfInputPackets;
    ULONG   SapIfOutputPackets;
} SAP_IF_STATS;
typedef SAP_IF_STATS    *PSAP_IF_STATS;

/* SAP interface */
typedef struct _SAP_INTERFACE {
    ULONG           InterfaceIndex;
    SAP_IF_INFO     SapIfInfo;
    SAP_IF_STATS    SapIfStats;
} SAP_INTERFACE;
typedef SAP_INTERFACE   *PSAP_INTERFACE;

/* SAP MIB input data */
typedef struct _SAP_MIB_GET_INPUT_DATA {
    ULONG   TableId;
    ULONG   InterfaceIndex;
} SAP_MIB_GET_INPUT_DATA;
typedef SAP_MIB_GET_INPUT_DATA  *PSAP_MIB_GET_INPUT_DATA;
typedef struct _SAP_MIB_SET_INPUT_DATA {
    ULONG           TableId;
    SAP_INTERFACE   SapInterface;
} SAP_MIB_SET_INPUT_DATA;
typedef SAP_MIB_SET_INPUT_DATA  *PSAP_MIB_SET_INPUT_DATA;

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _IPXSAP_ */
