/*
 *  oleidl.h    OLE interfaces
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#include <rpc.h>
#include <rpcndr.h>
#ifndef COM_NO_WINDOWS_H
    #include <windows.h>
    #include <ole2.h>
#endif

#ifndef __oleidl_h__
#define __oleidl_h__

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Forward declarations */
typedef interface IEnumOLEVERB              IEnumOLEVERB;
typedef interface IOleInPlaceActiveObject   IOleInPlaceActiveObject;

/* OLE menu handle */
typedef HMENU   HOLEMENU;

/* IOleCache2::UpdateCache() flags */
#define UPDFCACHE_NODATACACHE           0x00000001L
#define UPDFCACHE_ONSAVECACHE           0x00000002L
#define UPDFCACHE_ONSTOPCACHE           0x00000004L
#define UPDFCACHE_NORMALCACHE           0x00000008L
#define UPDFCACHE_IFBLANK               0x00000010L
#define UPDFCACHE_ONLYIFBLANK           0x80000000L
#define UPDFCACHE_IFBLANKORONSAVECACHE  (UPDFCACHE_IFBLANK | UPDFCACHE_ONSAVECACHE)
#define UPDFCACHE_ALL                   0x7FFFFFFFL
#define UPDFCACHE_ALLBUTNODATACACHE     0x7FFFFFFEL

/* Moniker flags */
#define MK_ALT  0x00000020L

/* Drop effects */
#define DROPEFFECT_NONE     0x00000000L
#define DROPEFFECT_COPY     0x00000001L
#define DROPEFFECT_MOVE     0x00000002L
#define DROPEFFECT_LINK     0x00000004L
#define DROPEFFECT_SCROLL   0x80000000L

/* Drop defaults */
#define DD_DEFSCROLLINSET       11L
#define DD_DEFSCROLLDELAY       50L
#define DD_DEFSCROLLINTERVAL    50L
#define DD_DEFDRAGDELAY         200L
#define DD_DEFDRAGMINDIST       2L

/* IOleCache2::DiscardCache() options */
typedef enum tagDISCARDCACHE {
    DISCARDCACHE_SAVEIFDIRTY    = 0,
    DISCARDCACHE_NOSAVE         = 1
} DISCARDCACHE;

/* IOleObject::GetMoniker() assignments */
typedef enum tagOLEGETMONIKER {
    OLEGETMONIKER_ONLYIFTHERE   = 1,
    OLEGETMONIKER_FORCEASSIGN   = 2,
    OLEGETMONIKER_UNASSIGN      = 3,
    OLEGETMONIKER_TEMPFORUSER   = 4
} OLEGETMONIKER;

/* OLE monikers */
typedef enum tagOLEWHICHMK {
    OLEWHICHMK_CONTAINER    = 1,
    OLEWHICHMK_OBJREL       = 2,
    OLEWHICHMK_OBJFULL      = 3
} OLEWHICHMK;

/* User class types */
typedef enum tagUSERCLASSTYPE {
    USERCLASSTYPE_FULL      = 1,
    USERCLASSTYPE_SHORT     = 2,
    USERCLASSTYPE_APPNAME   = 3
} USERCLASSTYPE;

/* OLE miscellaneous flags */
typedef enum tagOLEMISC {
    OLEMISC_RECOMPOSEONRESIZE               = 0x00000001,
    OLEMISC_ONLYICONIC                      = 0x00000002,
    OLEMISC_INSERTNOTREPLACE                = 0x00000004,
    OLEMISC_STATIC                          = 0x00000008,
    OLEMISC_CANTLINKINSIDE                  = 0x00000010,
    OLEMISC_CANLINKBYOLE1                   = 0x00000020,
    OLEMISC_ISLINKOBJECT                    = 0x00000040,
    OLEMISC_INSIDEOUT                       = 0x00000080,
    OLEMISC_ACTIVATEWHENVISIBLE             = 0x00000100,
    OLEMISC_RENDERINGISDEVICEINDEPENTENT    = 0x00000200,
    OLEMISC_INVISIBLEATRUNTIME              = 0x00000400,
    OLEMISC_ALWAYSRUN                       = 0x00000800,
    OLEMISC_ACTSLIKEBUTTON                  = 0x00001000,
    OLEMISC_ACTSLIKELABEL                   = 0x00002000,
    OLEMISC_NOUIACTIVATE                    = 0x00004000,
    OLEMISC_ALIGNABLE                       = 0x00008000,
    OLEMISC_SIMPLEFRAME                     = 0x00010000,
    OLEMISC_SETCLIENTSITEFIRST              = 0x00020000,
    OLEMISC_IMEMODE                         = 0x00040000,
    OLEMISC_IGNOREACTIVATEWHENVISIBLE       = 0x00080000,
    OLEMISC_WANTSTOMENUMERGE                = 0x00100000,
    OLEMISC_SUPPORTSMULTILEVELUNDO          = 0x00200000
} OLEMISC;

/* IOleObject::Close() save options */
typedef enum tagOLECLOSE {
    OLECLOSE_SAVEIFDIRTY    = 0,
    OLECLOSE_NOSAVE         = 1,
    OLECLOSE_PROMPTSAVE     = 2
} OLECLOSE;

/* OLE rendering options */
typedef enum tagOLERENDER {
    OLERENDER_NONE      = 0,
    OLERENDER_DRAW      = 1,
    OLERENDER_FORMAT    = 2,
    OLERENDER_ASIS      = 3
} OLERENDER;
typedef OLERENDER   *LPOLERENDER;

/* Object descriptor */
typedef struct tagOBJECTDESCRIPTOR {
    ULONG   cbSize;
    CLSID   clsid;
    DWORD   dwDrawAspect;
    SIZEL   sizel;
    POINTL  pointl;
    DWORD   dwStatus;
    DWORD   dwFullUserTypeName;
    DWORD   dwSrcOfCopy;
} OBJECTDESCRIPTOR;
typedef OBJECTDESCRIPTOR    *POBJECTDESCRIPTOR;
typedef OBJECTDESCRIPTOR    *LPOBJECTDESCRIPTOR;
typedef OBJECTDESCRIPTOR    LINKSRCDESCRIPTOR;
typedef OBJECTDESCRIPTOR    *PLINKSRCDESCRIPTOR;
typedef OBJECTDESCRIPTOR    *LPLINKSRCDESCRIPTOR;

/* OLE link update options */
typedef enum tagOLEUPDATE {
    OLEUPDATE_ALWAYS    = 1,
    OLEUPDATE_ONCALL    = 3
} OLEUPDATE;
typedef OLEUPDATE   *POLEUPDATE;
typedef OLEUPDATE   *LPOLEUPDATE;

/* IOleLink::BindToSource() options */
typedef enum tagOLELINKBIND {
    OLELINKBIND_EVENIFCLASSDIFF = 1
} OLELINKBIND;

/* Bind speeds */
typedef enum tagBINDSPEED {
    BINDSPEED_INDEFINITE    = 1,
    BINDSPEED_MODERATE      = 2,
    BINDSPEED_IMMEDIATE     = 3
} BINDSPEED;

/* OLE content flags */
typedef enum tagOLECONTF {
    OLECONTF_EMBEDDINGS     = 1,
    OLECONTF_LINKS          = 2,
    OLECONTF_OTHERS         = 4,
    OLECONTF_ONLYUSER       = 8,
    OLECONTF_ONLYIFRUNNING  = 16
} OLECONTF;

/* Border widths */
typedef RECT    BORDERWIDTHS;
typedef LPRECT  LPBORDERWIDTHS;
typedef LPCRECT LPCBORDERWIDTHS;

/* OLE in-place frame information */
typedef struct tagOIFI {
    UINT    cb;
    BOOL    fMDIApp;
    HWND    hwndFrame;
    HACCEL  haccel;
    UINT    cAccelEntries;
} OLEINPLACEFRAMEINFO;
typedef OLEINPLACEFRAMEINFO *LPOLEINPLACEFRAMEINFO;

/* OLE menu group widths */
typedef struct tagOleMenuGroupWidths {
    LONG    width[6];
} OLEMENUGROUPWIDTHS;
typedef OLEMENUGROUPWIDTHS  *LPOLEMENUGROUPWIDTHS;

/* OLE verb */
typedef struct tagOLEVERB {
    LONG        lVerb;
    LPOLESTR    lpszVerbName;
    DWORD       fuFlags;
    DWORD       grfAttribs;
} OLEVERB;
typedef OLEVERB *LPOLEVERB;

/* OLE verb attributes */
typedef enum tagOLEVERBATTRIB {
    OLEVERBATTRIB_NEVERDIRTIES      = 1,
    OLEVERBATTRIB_ONCONTAINERMENU   = 2
} OLEVERBATTRIB;

/* IOleAdviseHolder interface */
#undef INTERFACE
#define INTERFACE   IOleAdviseHolder
DECLARE_INTERFACE_( IOleAdviseHolder, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IOleAdviseHolder methods */
    STDMETHOD( Advise )( THIS_ IAdviseSink *, DWORD * ) PURE;
    STDMETHOD( Unadvise )( THIS_ DWORD ) PURE;
    STDMETHOD( EnumAdvise )( THIS_ IEnumSTATDATA ** ) PURE;
    STDMETHOD( SendOnRename )( THIS_ IMoniker * ) PURE;
    STDMETHOD( SendOnSave )( THIS ) PURE;
    STDMETHOD( SendOnClose )( THIS ) PURE;
};
typedef IOleAdviseHolder    *LPOLEADVISEHOLDER;

/* IOleCache interface */
#undef INTERFACE
#define INTERFACE   IOleCache
DECLARE_INTERFACE_( IOleCache, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IOleCache methods */
    STDMETHOD( Cache )( THIS_ FORMATETC *, DWORD, DWORD * ) PURE;
    STDMETHOD( Uncache )( THIS_ DWORD ) PURE;
    STDMETHOD( EnumCache )( THIS_ IEnumSTATDATA ** ) PURE;
    STDMETHOD( InitCache )( THIS_ IDataObject * ) PURE;
    STDMETHOD( SetData )( THIS_ FORMATETC *, STGMEDIUM *, BOOL ) PURE;
};
typedef IOleCache   *LPOLECACHE;

/* IOleCache2 interface */
#undef INTERFACE
#define INTERFACE   IOleCache2
DECLARE_INTERFACE_( IOleCache2, IOleCache ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IOleCache methods */
    STDMETHOD( Cache )( THIS_ FORMATETC *, DWORD, DWORD * ) PURE;
    STDMETHOD( Uncache )( THIS_ DWORD ) PURE;
    STDMETHOD( EnumCache )( THIS_ IEnumSTATDATA ** ) PURE;
    STDMETHOD( InitCache )( THIS_ IDataObject * ) PURE;
    STDMETHOD( SetData )( THIS_ FORMATETC *, STGMEDIUM *, BOOL ) PURE;
    
    /* IOleCache2 methods */
    STDMETHOD( UpdateCache )( THIS_ LPDATAOBJECT, DWORD, LPVOID ) PURE;
    STDMETHOD( DiscardCache )( THIS_ DWORD ) PURE;
};
typedef IOleCache2  *LPOLECACHE2;

/* IOleCacheControl interface */
#undef INTERFACE
#define INTERFACE   IOleCacheControl
DECLARE_INTERFACE_( IOleCacheControl, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IOleCacheControl methods */
    STDMETHOD( OnRun )( THIS_ LPDATAOBJECT ) PURE;
    STDMETHOD( OnStop )( THIS ) PURE;
};
typedef IOleCacheControl    *LPOLECACHECONTROL;

/* IParseDisplayName interface */
#undef INTERFACE
#define INTERFACE   IParseDisplayName
DECLARE_INTERFACE_( IParseDisplayName, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IParseDisplayName methods */
    STDMETHOD( ParseDisplayName )( THIS_ IBindCtx *, LPOLESTR, ULONG *, IMoniker ** ) PURE;
};
typedef IParseDisplayName   *LPPARSEDISPLAYNAME;

/* IOleContainer interface */
#undef INTERFACE
#define INTERFACE   IOleContainer
DECLARE_INTERFACE_( IOleContainer, IParseDisplayName ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IParseDisplayName methods */
    STDMETHOD( ParseDisplayName )( THIS_ IBindCtx *, LPOLESTR, ULONG *, IMoniker ** ) PURE;
    
    /* IOleContainer methods */
    STDMETHOD( EnumObjects )( THIS_ DWORD, IEnumUnknown ** ) PURE;
    STDMETHOD( LockContainer )( THIS_ BOOL ) PURE;
};
typedef IOleContainer   *LPOLECONTAINER;

/* IOleClientSite interface */
#undef INTERFACE
#define INTERFACE   IOleClientSite
DECLARE_INTERFACE_( IOleClientSite, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IOleClientSite methods */
    STDMETHOD( SaveObject )( THIS ) PURE;
    STDMETHOD( GetMoniker )( THIS_ DWORD, DWORD, IMoniker ** ) PURE;
    STDMETHOD( GetContainer )( THIS_ IOleContainer ** ) PURE;
    STDMETHOD( ShowObject )( THIS ) PURE;
    STDMETHOD( OnShowWindow )( THIS_ BOOL ) PURE;
    STDMETHOD( RequestNewObjectLayout )( THIS ) PURE;
};
typedef IOleClientSite  *LPOLECLIENTSITE;

/* IOleObject interface */
#undef INTERFACE
#define INTERFACE   IOleObject
DECLARE_INTERFACE_( IOleObject, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IOleObject methods */
    STDMETHOD( SetClientSite )( THIS_ IOleClientSite * ) PURE;
    STDMETHOD( GetClientSite )( THIS_ IOleClientSite ** ) PURE;
    STDMETHOD( SetHostNames )( THIS_ LPCOLESTR, LPCOLESTR ) PURE;
    STDMETHOD( Close )( THIS_ DWORD ) PURE;
    STDMETHOD( SetMoniker )( THIS_ DWORD, IMoniker * ) PURE;
    STDMETHOD( GetMoniker )( THIS_ DWORD, DWORD, IMoniker ** ) PURE;
    STDMETHOD( InitFromData )( THIS_ IDataObject *, BOOL, DWORD ) PURE;
    STDMETHOD( GetClipboardData )( THIS_ DWORD, IDataObject ** ) PURE;
    STDMETHOD( DoVerb )( THIS_ LONG, LPMSG, IOleClientSite *, LONG, HWND, LPCRECT ) PURE;
    STDMETHOD( EnumVerbs )( THIS_ IEnumOLEVERB ** ) PURE;
    STDMETHOD( Update )( THIS ) PURE;
    STDMETHOD( IsUpToDate )( THIS ) PURE;
    STDMETHOD( GetUserClassID )( THIS_ CLSID * ) PURE;
    STDMETHOD( GetUserType )( THIS_ DWORD, LPOLESTR * ) PURE;
    STDMETHOD( SetExtent )( THIS_ DWORD, SIZEL * ) PURE;
    STDMETHOD( GetExtent )( THIS_ DWORD, SIZEL * ) PURE;
    STDMETHOD( Advise )( THIS_ IAdviseSink *, DWORD * ) PURE;
    STDMETHOD( Unadvise )( THIS_ DWORD ) PURE;
    STDMETHOD( EnumAdvise )( THIS_ IEnumSTATDATA ** ) PURE;
    STDMETHOD( GetMiscStatus )( THIS_ DWORD, DWORD * ) PURE;
    STDMETHOD( SetColorScheme )( THIS_ LOGPALETTE * ) PURE;
};
typedef IOleObject  *LPOLEOBJECT;

/* IOleWindow interface */
#undef INTERFACE
#define INTERFACE   IOleWindow
DECLARE_INTERFACE_( IOleWindow, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IOleWindow methods */
    STDMETHOD( GetWindow )( THIS_ HWND * ) PURE;
    STDMETHOD( ContextSensitiveHelp )( THIS_ BOOL ) PURE;
};
typedef IOleWindow  *LPOLEWINDOW;

/* IOleLink interface */
#undef INTERFACE
#define INTERFACE   IOleLink
DECLARE_INTERFACE_( IOleLink, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IOleLink methods */
    STDMETHOD( SetUpdateOptions )( THIS_ DWORD ) PURE;
    STDMETHOD( GetUpdateOptions )( THIS_ DWORD * ) PURE;
    STDMETHOD( SetSourceMoniker )( THIS_ IMoniker *, REFCLSID ) PURE;
    STDMETHOD( GetSourceMoniker )( THIS_ IMoniker ** ) PURE;
    STDMETHOD( SetSourceDisplayName )( THIS_ LPCOLESTR ) PURE;
    STDMETHOD( GetSourceDisplayName )( THIS_ LPOLESTR * ) PURE;
    STDMETHOD( BindToSource )( THIS_ DWORD, IBindCtx * ) PURE;
    STDMETHOD( BindIfRunning )( THIS ) PURE;
    STDMETHOD( GetBoundSource )( THIS_ IUnknown * ) PURE;
    STDMETHOD( UnbindSource )( THIS ) PURE;
    STDMETHOD( Update )( THIS_ IBindCtx * ) PURE;
};
typedef IOleLink    *LPOLELINK;

/* IOleItemContainer interface */
#undef INTERFACE
#define INTERFACE   IOleItemContainer
DECLARE_INTERFACE_( IOleItemContainer, IOleContainer ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IParseDisplayName methods */
    STDMETHOD( ParseDisplayName )( THIS_ IBindCtx *, LPOLESTR, ULONG *, IMoniker ** ) PURE;
    
    /* IOleContainer methods */
    STDMETHOD( EnumObjects )( THIS_ DWORD, IEnumUnknown ** ) PURE;
    STDMETHOD( LockContainer )( THIS_ BOOL ) PURE;
    
    /* IOleItemContainer methods */
    STDMETHOD( GetObject )( THIS_ LPOLESTR, DWORD, IBindCtx *, REFIID, void ** ) PURE;
    STDMETHOD( GetObjectStorage )( THIS_ LPOLESTR, IBindCtx *, REFIID, void ** ) PURE;
    STDMETHOD( IsRunning )( THIS_ LPOLESTR ) PURE;
};
typedef IOleItemContainer   *LPOLEITEMCONTAINER;

/* IOleInPlaceUIWindow interface */
#undef INTERFACE
#define INTERFACE   IOleInPlaceUIWindow
DECLARE_INTERFACE_( IOleInPlaceUIWindow, IOleWindow ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IOleWindow methods */
    STDMETHOD( GetWindow )( THIS_ HWND * ) PURE;
    STDMETHOD( ContextSensitiveHelp )( THIS_ BOOL ) PURE;
    
    /* IOleInPlaceUIWindow methods */
    STDMETHOD( GetBorder )( THIS_ LPRECT ) PURE;
    STDMETHOD( RequestBorderSpace )( THIS_ LPCBORDERWIDTHS ) PURE;
    STDMETHOD( SetBorderSpace )( THIS_ LPCBORDERWIDTHS ) PURE;
    STDMETHOD( SetActiveObject )( THIS_ IOleInPlaceActiveObject *, LPCOLESTR ) PURE;
};
typedef IOleInPlaceUIWindow *LPOLEINPLACEUIWINDOW;

/* IOleInPlaceActiveObject interface */
#undef INTERFACE
#define INTERFACE   IOleInPlaceActiveObject
DECLARE_INTERFACE_( IOleInPlaceActiveObject, IOleWindow ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IOleWindow methods */
    STDMETHOD( GetWindow )( THIS_ HWND * ) PURE;
    STDMETHOD( ContextSensitiveHelp )( THIS_ BOOL ) PURE;
    
    /* IOleInPlaceActiveObject methods */
    STDMETHOD( TranslateAccelerator )( THIS_ LPMSG ) PURE;
    STDMETHOD( OnFrameWindowActivate )( THIS_ BOOL ) PURE;
    STDMETHOD( OnDocWindowActivate )( THIS_ BOOL ) PURE;
    STDMETHOD( ResizeBorder )( THIS_ LPCRECT, IOleInPlaceUIWindow *, BOOL ) PURE;
    STDMETHOD( EnableModeless )( THIS_ BOOL ) PURE;
};
typedef IOleInPlaceActiveObject *LPOLEINPLACEACTIVEOBJECT;

/* IOleInPlaceFrame interface */
#undef INTERFACE
#define INTERFACE   IOleInPlaceFrame
DECLARE_INTERFACE_( IOleInPlaceFrame, IOleInPlaceUIWindow ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IOleWindow methods */
    STDMETHOD( GetWindow )( THIS_ HWND * ) PURE;
    STDMETHOD( ContextSensitiveHelp )( THIS_ BOOL ) PURE;
    
    /* IOleInPlaceUIWindow methods */
    STDMETHOD( GetBorder )( THIS_ LPRECT ) PURE;
    STDMETHOD( RequestBorderSpace )( THIS_ LPCBORDERWIDTHS ) PURE;
    STDMETHOD( SetBorderSpace )( THIS_ LPCBORDERWIDTHS ) PURE;
    STDMETHOD( SetActiveObject )( THIS_ IOleInPlaceActiveObject *, LPCOLESTR ) PURE;
    
    /* IOleInPlaceFrame methods */
    STDMETHOD( InsertMenus )( THIS_ HMENU, LPOLEMENUGROUPWIDTHS ) PURE;
    STDMETHOD( SetMenu )( THIS_ HMENU, HOLEMENU, HWND ) PURE;
    STDMETHOD( RemoveMenus )( THIS_ HMENU ) PURE;
    STDMETHOD( SetStatusText )( THIS_ LPCOLESTR ) PURE;
    STDMETHOD( EnableModeless )( THIS_ BOOL ) PURE;
    STDMETHOD( TranslateAccelerator )( THIS_ LPMSG, WORD ) PURE;
};
typedef IOleInPlaceFrame    *LPOLEINPLACEFRAME;

/* IOleInPlaceObject interface */
#undef INTERFACE
#define INTERFACE   IOleInPlaceObject
DECLARE_INTERFACE_( IOleInPlaceObject, IOleWindow ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IOleWindow methods */
    STDMETHOD( GetWindow )( THIS_ HWND * ) PURE;
    STDMETHOD( ContextSensitiveHelp )( THIS_ BOOL ) PURE;
    STDMETHOD( InPlaceDeactivate )( THIS ) PURE;
    
    /* IOleInPlaceObject methods */
    STDMETHOD( UIDeactivate )( THIS ) PURE;
    STDMETHOD( SetObjectRects )( THIS_ LPCRECT, LPCRECT ) PURE;
    STDMETHOD( ReactivateAndUndo )( THIS ) PURE;
};
typedef IOleInPlaceObject   *LPOLEINPLACEOBJECT;

/* IOleInPlaceSite interface */
#undef INTERFACE
#define INTERFACE   IOleInPlaceSite
DECLARE_INTERFACE_( IOleInPlaceSite, IOleWindow ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IOleWindow methods */
    STDMETHOD( GetWindow )( THIS_ HWND * ) PURE;
    STDMETHOD( ContextSensitiveHelp )( THIS_ BOOL ) PURE;
    
    /* IOleInPlaceSite methods */
    STDMETHOD( CanInPlaceActivate )( THIS ) PURE;
    STDMETHOD( OnInPlaceActivate )( THIS ) PURE;
    STDMETHOD( OnUIActivate )( THIS ) PURE;
    STDMETHOD( GetWindowContext )( THIS_ IOleInPlaceFrame **, IOleInPlaceUIWindow **, LPRECT, LPRECT, LPOLEINPLACEFRAMEINFO ) PURE;
    STDMETHOD( Scroll )( THIS_ SIZE ) PURE;
    STDMETHOD( OnUIDeactivate )( THIS_ BOOL ) PURE;
    STDMETHOD( OnInPlaceDeactivate )( THIS ) PURE;
    STDMETHOD( DiscardUndoState )( THIS ) PURE;
    STDMETHOD( DeactivateAndUndo )( THIS ) PURE;
    STDMETHOD( OnPosRectChange )( THIS_ LPCRECT ) PURE;
};
typedef IOleInPlaceSite *LPOLEINPLACESITE;

/* IContinue interface */
#undef INTERFACE
#define INTERFACE   IContinue
DECLARE_INTERFACE_( IContinue, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IContinue methods */
    STDMETHOD( Continue )( THIS ) PURE;
};

/* IViewObject interface */
#undef INTERFACE
#define INTERFACE   IViewObject
DECLARE_INTERFACE_( IViewObject, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IViewObject methods */
    STDMETHOD( Draw )( THIS_ DWORD, LONG, void *, DVTARGETDEVICE *, HDC, HDC, LPCRECTL, LPCRECTL, BOOL (CALLBACK *)( ULONG_PTR ), ULONG_PTR ) PURE;
    STDMETHOD( GetColorSet )( THIS_ DWORD, LONG, void *, DVTARGETDEVICE *, HDC, LOGPALETTE ** ) PURE;
    STDMETHOD( Freeze )( THIS_ DWORD, LONG, void *, DWORD * ) PURE;
    STDMETHOD( Unfreeze )( THIS_ DWORD ) PURE;
    STDMETHOD( SetAdvise )( THIS_ DWORD, DWORD, IAdviseSink * ) PURE;
    STDMETHOD( GetAdvise )( THIS_ DWORD *, DWORD *, IAdviseSink ** ) PURE;
};
typedef IViewObject *LPVIEWOBJECT;

/* IViewObject2 interface */
#undef INTERFACE
#define INTERFACE   IViewObject2
DECLARE_INTERFACE_( IViewObject2, IViewObject ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IViewObject methods */
    STDMETHOD( Draw )( THIS_ DWORD, LONG, void *, DVTARGETDEVICE *, HDC, HDC, LPCRECTL, LPCRECTL, BOOL (CALLBACK *)( ULONG_PTR ), ULONG_PTR ) PURE;
    STDMETHOD( GetColorSet )( THIS_ DWORD, LONG, void *, DVTARGETDEVICE *, HDC, LOGPALETTE ** ) PURE;
    STDMETHOD( Freeze )( THIS_ DWORD, LONG, void *, DWORD * ) PURE;
    STDMETHOD( Unfreeze )( THIS_ DWORD ) PURE;
    STDMETHOD( SetAdvise )( THIS_ DWORD, DWORD, IAdviseSink * ) PURE;
    STDMETHOD( GetAdvise )( THIS_ DWORD *, DWORD *, IAdviseSink ** ) PURE;
    
    /* IViewObject2 methods */
    STDMETHOD( GetExtent )( THIS_ DWORD, LONG, DVTARGETDEVICE *, LPSIZEL ) PURE;
};
typedef IViewObject2    *LPVIEWOBJECT2;

/* IDropSource interface */
#undef INTERFACE
#define INTERFACE   IDropSource
DECLARE_INTERFACE_( IDropSource, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDropSource methods */
    STDMETHOD( QueryContinueDrag )( THIS_ BOOL, DWORD ) PURE;
    STDMETHOD( GiveFeedback )( THIS_ DWORD ) PURE;
};
typedef IDropSource *LPDROPSOURCE;

/* IDropTarget interface */
#undef INTERFACE
#define INTERFACE   IDropTarget
DECLARE_INTERFACE_( IDropTarget, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDropTarget methods */
    STDMETHOD( DragEnter )( THIS_ IDataObject *, DWORD, POINTL, DWORD * ) PURE;
    STDMETHOD( DragOver )( THIS_ DWORD, POINTL, DWORD * ) PURE;
    STDMETHOD( DragLeave )( THIS ) PURE;
    STDMETHOD( Drop )( THIS_ IDataObject *, DWORD, POINTL, DWORD * ) PURE;
};
typedef IDropTarget *LPDROPTARGET;

/* IDropSourceNotify interface */
#undef INTERFACE
#define INTERFACE   IDropSourceNotify
DECLARE_INTERFACE_( IDropSourceNotify, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDropSourceNotify methods */
    STDMETHOD( DragEnterTarget )( THIS_ HWND ) PURE;
    STDMETHOD( DragLeaveTarget )( THIS ) PURE;
};

/* IEnumOLEVERB interface */
#undef INTERFACE
#define INTERFACE   IEnumOLEVERB
DECLARE_INTERFACE_( IEnumOLEVERB, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IEnumOLEVERB methods */
    STDMETHOD( Next )( THIS_ ULONG, LPOLEVERB, ULONG * ) PURE;
    STDMETHOD( Skip )( THIS_ ULONG ) PURE;
    STDMETHOD( Reset )( THIS ) PURE;
    STDMETHOD( Clone )( THIS_ IEnumOLEVERB ** ) PURE;
};
typedef IEnumOLEVERB    *LPENUMOLEVERB;

/* C object macros */
#if (!defined( __cplusplus ) || defined( CINTERFACE )) && defined( COBJMACROS )
    #define IOleAdviseHolder_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IOleAdviseHolder_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IOleAdviseHolder_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IOleAdviseHolder_Advise( x, p1, p2 ) \
        (x)->lpVtbl->Advise( x, p1, p2 )
    #define IOleAdviseHolder_Unadvise( x, p ) \
        (x)->lpVtbl->Unadvise( x, p )
    #define IOleAdviseHolder_EnumAdvise( x, p ) \
        (x)->lpVtbl->EnumAdvise( x, p )
    #define IOleAdviseHolder_SendOnRename( x, p ) \
        (x)->lpVtbl->SendOnRename( x, p )
    #define IOleAdviseHolder_SendOnSave( x ) \
        (x)->lpVtbl->SendOnSave( x )
    #define IOleAdviseHolder_SendOnClose( x ) \
        (x)->lpVtbl->SendOnClose( x )
    #define IOleCache_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IOleCache_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IOleCache_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IOleCache_Cache( x, p1, p2, p3 ) \
        (x)->lpVtbl->Cache( x, p1, p2, p3 )
    #define IOleCache_Uncache( x, p ) \
        (x)->lpVtbl->Uncache( x, p )
    #define IOleCache_EnumCache( x, p ) \
        (x)->lpVtbl->EnumCache( x, p )
    #define IOleCache_InitCache( x, p ) \
        (x)->lpVtbl->InitCache( x, p )
    #define IOleCache_SetData( x, p1, p2, p3 ) \
        (x)->lpVtbl->SetData( x, p1, p2, p3 )
    #define IOleCache2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IOleCache2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IOleCache2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IOleCache2_Cache( x, p1, p2, p3 ) \
        (x)->lpVtbl->Cache( x, p1, p2, p3 )
    #define IOleCache2_Uncache( x, p ) \
        (x)->lpVtbl->Uncache( x, p )
    #define IOleCache2_EnumCache( x, p ) \
        (x)->lpVtbl->EnumCache( x, p )
    #define IOleCache2_InitCache( x, p ) \
        (x)->lpVtbl->InitCache( x, p )
    #define IOleCache2_SetData( x, p1, p2, p3 ) \
        (x)->lpVtbl->SetData( x, p1, p2, p3 )
    #define IOleCache2_UpdateCache( x, p1, p2, p3 ) \
        (x)->lpVtbl->UpdateCache( x, p1, p2, p3 )
    #define IOleCache2_DiscardCache( x, p ) \
        (x)->lpVtbl->DiscardCache( x, p )
    #define IOleCacheControl_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IOleCacheControl_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IOleCacheControl_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IOleCacheControl_OnRun( x, p ) \
        (x)->lpVtbl->OnRun( x, p )
    #define IOleCacheControl_OnStop( x ) \
        (x)->lpVtbl->OnStop( x )
    #define IParseDisplayName_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IParseDisplayName_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IParseDisplayName_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IParseDisplayName_ParseDisplayName( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->ParseDisplayName( x, p1, p2, p3, p4 )
    #define IOleContainer_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IOleContainer_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IOleContainer_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IOleContainer_ParseDisplayName( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->ParseDisplayName( x, p1, p2, p3, p4 )
    #define IOleContainer_EnumObjects( x, p1, p2 ) \
        (x)->lpVtbl->EnumObjects( x, p1, p2 )
    #define IOleContainer_LockContainer( x, p ) \
        (x)->lpVtbl->LockContainer( x, p )
    #define IOleClientSite_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IOleClientSite_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IOleClientSite_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IOleClientSite_SaveObject( x ) \
        (x)->lpVtbl->SaveObject( x )
    #define IOleClientSite_GetMoniker( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetMoniker( x, p1, p2, p3 )
    #define IOleClientSite_GetContainer( x, p ) \
        (x)->lpVtbl->GetContainer( x, p )
    #define IOleClientSite_ShowObject( x ) \
        (x)->lpVtbl->ShowObject( x )
    #define IOleClientSite_OnShowWindow( x, p ) \
        (x)->lpVtbl->OnShowWindow( x, p )
    #define IOleClientSite_RequestNewObjectLayout( x ) \
        (x)->lpVtbl->RequestNewObjectLayout( x )
    #define IOleObject_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IOleObject_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IOleObject_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IOleObject_SetClientSite( x, p ) \
        (x)->lpVtbl->SetClientSite( x, p )
    #define IOleObject_GetClientSite( x, p ) \
        (x)->lpVtbl->GetClientSite( x, p )
    #define IOleObject_SetHostNames( x, p1, p2 ) \
        (x)->lpVtbl->SetHostNames( x, p1, p2 )
    #define IOleObject_Close( x, p ) \
        (x)->lpVtbl->Close( x, p )
    #define IOleObject_SetMoniker( x, p1, p2 ) \
        (x)->lpVtbl->SetMoniker( x, p1, p2 )
    #define IOleObject_GetMoniker( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetMoniker( x, p1, p2, p3 )
    #define IOleObject_InitFromData( x, p1, p2, p3 ) \
        (x)->lpVtbl->InitFromData( x, p1, p2, p3 )
    #define IOleObject_GetClipboardData( x, p1, p2 ) \
        (x)->lpVtbl->GetClipboardData( x, p1, p2 )
    #define IOleObject_DoVerb( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->DoVerb( x, p1, p2, p3, p4, p5, p6 )
    #define IOleObject_EnumVerbs( x, p ) \
        (x)->lpVtbl->EnumVerbs( x, p )
    #define IOleObject_Update( x ) \
        (x)->lpVtbl->Update( x )
    #define IOleObject_IsUpToDate( x ) \
        (x)->lpVtbl->IsUpToDate( x )
    #define IOleObject_GetUserClassID( x, p ) \
        (x)->lpVtbl->GetUserClassID( x, p )
    #define IOleObject_GetUserType( x, p1, p2 ) \
        (x)->lpVtbl->GetUserType( x, p1, p2 )
    #define IOleObject_SetExtent( x, p1, p2 ) \
        (x)->lpVtbl->SetExtent( x, p1, p2 )
    #define IOleObject_GetExtent( x, p1, p2 ) \
        (x)->lpVtbl->GetExtent( x, p1, p2 )
    #define IOleObject_Advise( x, p1, p2 ) \
        (x)->lpVtbl->Advise( x, p1, p2 )
    #define IOleObject_Unadvise( x, p ) \
        (x)->lpVtbl->Unadvise( x, p )
    #define IOleObject_EnumAdvise( x, p ) \
        (x)->lpVtbl->EnumAdvise( x, p )
    #define IOleObject_GetMiscStatus( x, p1, p2 ) \
        (x)->lpVtbl->GetMiscStatus( x, p1, p2 )
    #define IOleObject_SetColorScheme( x, p ) \
        (x)->lpVtbl->SetColorScheme( x, p )
    #define IOleWindow_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IOleWindow_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IOleWindow_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IOleWindow_GetWindow( x, p ) \
        (x)->lpVtbl->GetWindow( x, p )
    #define IOleWindow_ContextSensitiveHelp( x, p ) \
        (x)->lpVtbl->ContextSensitiveHelp( x, p )
    #define IOleLink_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IOleLink_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IOleLink_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IOleLink_SetUpdateOptions( x, p ) \
        (x)->lpVtbl->SetUpdateOptions( x, p )
    #define IOleLink_GetUpdateOptions( x, p ) \
        (x)->lpVtbl->GetUpdateOptions( x, p )
    #define IOleLink_SetSourceMoniker( x, p1, p2 ) \
        (x)->lpVtbl->SetSourceMoniker( x, p1, p2 )
    #define IOleLink_GetSourceMoniker( x, p ) \
        (x)->lpVtbl->GetSourceMoniker( x, p )
    #define IOleLink_SetSourceDisplayName( x, p ) \
        (x)->lpVtbl->SetSourceDisplayName( x, p )
    #define IOleLink_GetSourceDisplayName( x, p ) \
        (x)->lpVtbl->GetSourceDisplayName( x, p )
    #define IOleLink_BindToSource( x, p1, p2 ) \
        (x)->lpVtbl->BindToSource( x, p1, p2 )
    #define IOleLink_BindIfRunning( x ) \
        (x)->lpVtbl->BindIfRunning( x )
    #define IOleLink_GetBoundSource( x, p ) \
        (x)->lpVtbl->GetBoundSource( x, p )
    #define IOleLink_UnbindSource( x ) \
        (x)->lpVtbl->UnbindSource( x )
    #define IOleLink_Update( x, p ) \
        (x)->lpVtbl->Update( x, p )
    #define IOleItemContainer_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IOleItemContainer_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IOleItemContainer_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IOleItemContainer_ParseDisplayName( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->ParseDisplayName( x, p1, p2, p3, p4 )
    #define IOleItemContainer_EnumObjects( x, p1, p2 ) \
        (x)->lpVtbl->EnumObjects( x, p1, p2 )
    #define IOleItemContainer_LockContainer( x, p ) \
        (x)->lpVtbl->LockContainer( x, p )
    #define IOleItemContainer_GetObject( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetObject( x, p1, p2, p3, p4, p5 )
    #define IOleItemContainer_GetObjectStorage( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetObjectStorage( x, p1, p2, p3, p4 )
    #define IOleItemContainer_IsRunning( x, p ) \
        (x)->lpVtbl->IsRunning( x, p )
    #define IOleInPlaceUIWindow_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IOleInPlaceUIWindow_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IOleInPlaceUIWindow_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IOleInPlaceUIWindow_GetWindow( x, p ) \
        (x)->lpVtbl->GetWindow( x, p )
    #define IOleInPlaceUIWindow_ContextSensitiveHelp( x, p ) \
        (x)->lpVtbl->ContextSensitiveHelp( x, p )
    #define IOleInPlaceUIWindow_GetBorder( x, p ) \
        (x)->lpVtbl->GetBorder( x, p )
    #define IOleInPlaceUIWindow_RequestBorderSpace( x, p ) \
        (x)->lpVtbl->RequestBorderSpace( x, p )
    #define IOleInPlaceUIWindow_SetBorderSpace( x, p ) \
        (x)->lpVtbl->SetBorderSpace( x, p )
    #define IOleInPlaceUIWindow_SetActiveObject( x, p1, p2 ) \
        (x)->lpVtbl->SetActiveObject( x, p1, p2 )
    #define IOleInPlaceActiveObject_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IOleInPlaceActiveObject_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IOleInPlaceActiveObject_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IOleInPlaceActiveObject_GetWindow( x, p ) \
        (x)->lpVtbl->GetWindow( x, p )
    #define IOleInPlaceActiveObject_ContextSensitiveHelp( x, p ) \
        (x)->lpVtbl->ContextSensitiveHelp( x, p )
    #define IOleInPlaceActiveObject_TranslateAccelerator( x, p ) \
        (x)->lpVtbl->TranslateAccelerator( x, p )
    #define IOleInPlaceActiveObject_OnFrameWindowActivate( x, p ) \
        (x)->lpVtbl->OnFrameWindowActivate( x, p )
    #define IOleInPlaceActiveObject_OnDocWindowActivate( x, p ) \
        (x)->lpVtbl->OnDocWindowActivate( x, p )
    #define IOleInPlaceActiveObject_ResizeBorder( x, p1, p2, p3 ) \
        (x)->lpVtbl->ResizeBorder( x, p1, p2, p3 )
    #define IOleInPlaceActiveObject_EnableModeless( x, p ) \
        (x)->lpVtbl->EnableModeless( x, p )
    #define IOleInPlaceFrame_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IOleInPlaceFrame_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IOleInPlaceFrame_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IOleInPlaceFrame_GetWindow( x, p ) \
        (x)->lpVtbl->GetWindow( x, p )
    #define IOleInPlaceFrame_ContextSensitiveHelp( x, p ) \
        (x)->lpVtbl->ContextSensitiveHelp( x, p )
    #define IOleInPlaceFrame_GetBorder( x, p ) \
        (x)->lpVtbl->GetBorder( x, p )
    #define IOleInPlaceFrame_RequestBorderSpace( x, p ) \
        (x)->lpVtbl->RequestBorderSpace( x, p )
    #define IOleInPlaceFrame_SetBorderSpace( x, p ) \
        (x)->lpVtbl->SetBorderSpace( x, p )
    #define IOleInPlaceFrame_SetActiveObject( x, p1, p2 ) \
        (x)->lpVtbl->SetActiveObject( x, p1, p2 )
    #define IOleInPlaceFrame_InsertMenus( x, p1, p2 ) \
        (x)->lpVtbl->InsertMenus( x, p1, p2 )
    #define IOleInPlaceFrame_SetMenu( x, p1, p2, p3 ) \
        (x)->lpVtbl->SetMenu( x, p1, p2, p3 )
    #define IOleInPlaceFrame_RemoveMenus( x, p ) \
        (x)->lpVtbl->RemoveMenus( x, p )
    #define IOleInPlaceFrame_SetStatusText( x, p ) \
        (x)->lpVtbl->SetStatusText( x, p )
    #define IOleInPlaceFrame_EnableModeless( x, p ) \
        (x)->lpVtbl->EnableModeless( x, p )
    #define IOleInPlaceFrame_TranslateAccelerator( x, p1, p2 ) \
        (x)->lpVtbl->TranslateAccelerator( x, p1, p2 )
    #define IOleInPlaceObject_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IOleInPlaceObject_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IOleInPlaceObject_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IOleInPlaceObject_GetWindow( x, p ) \
        (x)->lpVtbl->GetWindow( x, p )
    #define IOleInPlaceObject_ContextSensitiveHelp( x, p ) \
        (x)->lpVtbl->ContextSensitiveHelp( x, p )
    #define IOleInPlaceObject_InPlaceDeactivate( x ) \
        (x)->lpVtbl->InPlaceDeactivate( x )
    #define IOleInPlaceObject_UIDeactivate( x ) \
        (x)->lpVtbl->UIDeactivate( x )
    #define IOleInPlaceObject_SetObjectRects( x, p1, p2 ) \
        (x)->lpVtbl->SetObjectRects( x, p1, p2 )
    #define IOleInPlaceObject_ReactivateAndUndo( x ) \
        (x)->lpVtbl->ReactivateAndUndo( x )
    #define IOleInPlaceSite_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IOleInPlaceSite_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IOleInPlaceSite_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IOleInPlaceSite_GetWindow( x, p ) \
        (x)->lpVtbl->GetWindow( x, p )
    #define IOleInPlaceSite_ContextSensitiveHelp( x, p ) \
        (x)->lpVtbl->ContextSensitiveHelp( x, p )
    #define IOleInPlaceSite_CanInPlaceActivate( x ) \
        (x)->lpVtbl->CanInPlaceActivate( x )
    #define IOleInPlaceSite_OnInPlaceActivate( x ) \
        (x)->lpVtbl->OnInPlaceActivate( x )
    #define IOleInPlaceSite_OnUIActivate( x ) \
        (x)->lpVtbl->OnUIActivate( x )
    #define IOleInPlaceSite_GetWindowContext( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetWindowContext( x, p1, p2, p3, p4, p5 )
    #define IOleInPlaceSite_Scroll( x, p ) \
        (x)->lpVtbl->Scroll( x, p )
    #define IOleInPlaceSite_OnUIDeactivate( x, p ) \
        (x)->lpVtbl->OnUIDeactivate( x, p )
    #define IOleInPlaceSite_OnInPlaceDeactivate( x ) \
        (x)->lpVtbl->OnInPlaceDeactivate( x )
    #define IOleInPlaceSite_DiscardUndoState( x ) \
        (x)->lpVtbl->DiscardUndoState( x )
    #define IOleInPlaceSite_DeactivateAndUndo( x ) \
        (x)->lpVtbl->DeactivateAndUndo( x )
    #define IOleInPlaceSite_OnPosRectChange( x, p ) \
        (x)->lpVtbl->OnPosRectChange( x, p )
    #define IContinue_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IContinue_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IContinue_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IContinue_FContinue( x ) \
        (x)->lpVtbl->FContinue( x )
    #define IViewObject_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IViewObject_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IViewObject_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IViewObject_Draw( x, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10 ) \
        (x)->lpVtbl->Draw( x, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10 )
    #define IViewObject_GetColorSet( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->GetColorSet( x, p1, p2, p3, p4, p5, p6 )
    #define IViewObject_Freeze( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->Freeze( x, p1, p2, p3, p4 )
    #define IViewObject_Unfreeze( x, p ) \
        (x)->lpVtbl->Unfreeze( x, p )
    #define IViewObject_SetAdvise( x, p1, p2, p3 ) \
        (x)->lpVtbl->SetAdvise( x, p1, p2, p3 )
    #define IViewObject_GetAdvise( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetAdvise( x, p1, p2, p3 )
    #define IViewObject2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IViewObject2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IViewObject2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IViewObject2_Draw( x, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10 ) \
        (x)->lpVtbl->Draw( x, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10 )
    #define IViewObject2_GetColorSet( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->GetColorSet( x, p1, p2, p3, p4, p5, p6 )
    #define IViewObject2_Freeze( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->Freeze( x, p1, p2, p3, p4 )
    #define IViewObject2_Unfreeze( x, p ) \
        (x)->lpVtbl->Unfreeze( x, p )
    #define IViewObject2_SetAdvise( x, p1, p2, p3 ) \
        (x)->lpVtbl->SetAdvise( x, p1, p2, p3 )
    #define IViewObject2_GetAdvise( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetAdvise( x, p1, p2, p3 )
    #define IViewObject2_GetExtent( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetExtent( x, p1, p2, p3, p4 )
    #define IDropSource_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IDropSource_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IDropSource_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IDropSource_QueryContinueDrag( x, p1, p2 ) \
        (x)->lpVtbl->QueryContinueDrag( x, p1, p2 )
    #define IDropSource_GiveFeedback( x, p ) \
        (x)->lpVtbl->GiveFeedback( x, p )
    #define IDropTarget_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IDropTarget_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IDropTarget_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IDropTarget_DragEnter( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->DragEnter( x, p1, p2, p3, p4 )
    #define IDropTarget_DragOver( x, p1, p2, p3 ) \
        (x)->lpVtbl->DragOver( x, p1, p2, p3 )
    #define IDropTarget_DragLeave( x ) \
        (x)->lpVtbl->DragLeave( x )
    #define IDropTarget_Drop( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->Drop( x, p1, p2, p3, p4 )
    #define IDropSourceNotify_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IDropSourceNotify_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IDropSourceNotify_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IDropSourceNotify_DragEnterTarget( x, p ) \
        (x)->lpVtbl->DragEnterTarget( x, p )
    #define IDropSourceNotify_DragLeaveTarget( x ) \
        (x)->lpVtbl->DragLeaveTarget( x )
    #define IEnumOLEVERB_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IEnumOLEVERB_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IEnumOLEVERB_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IEnumOLEVERB_Next( x, p1, p2, p3 ) \
        (x)->lpVtbl->Next( x, p1, p2, p3 )
    #define IEnumOLEVERB_Skip( x, p ) \
        (x)->lpVtbl->Skip( x, p )
    #define IEnumOLEVERB_Reset( x ) \
        (x)->lpVtbl->Reset( x )
    #define IEnumOLEVERB_Clone( x, p ) \
        (x)->lpVtbl->Clone( x, p )
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

/* GUIDs */
EXTERN_C const IID  __cdecl IID_IOleAdviseHolder;
EXTERN_C const IID  __cdecl IID_IOleCache;
EXTERN_C const IID  __cdecl IID_IOleCache2;
EXTERN_C const IID  __cdecl IID_IOleCacheControl;
EXTERN_C const IID  __cdecl IID_IParseDisplayName;
EXTERN_C const IID  __cdecl IID_IOleContainer;
EXTERN_C const IID  __cdecl IID_IOleClientSite;
EXTERN_C const IID  __cdecl IID_IOleObject;
EXTERN_C const IID  __cdecl IID_IOleWindow;
EXTERN_C const IID  __cdecl IID_IOleLink;
EXTERN_C const IID  __cdecl IID_IOleItemContainer;
EXTERN_C const IID  __cdecl IID_IOleInPlaceUIWindow;
EXTERN_C const IID  __cdecl IID_IOleInPlaceActiveObject;
EXTERN_C const IID  __cdecl IID_IOleInPlaceFrame;
EXTERN_C const IID  __cdecl IID_IOleInPlaceObject;
EXTERN_C const IID  __cdecl IID_IOleInPlaceSite;
EXTERN_C const IID  __cdecl IID_IContinue;
EXTERN_C const IID  __cdecl IID_IViewObject;
EXTERN_C const IID  __cdecl IID_IViewObject2;
EXTERN_C const IID  __cdecl IID_IDropSource;
EXTERN_C const IID  __cdecl IID_IDropTarget;
EXTERN_C const IID  __cdecl IID_IDropSourceNotify;
EXTERN_C const IID  __cdecl IID_IEnumOLEVERB;

#endif /* __oleidl_h__ */
