/*
 *  propkdef.h / propkeydef.h   Property key definitions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

/* Macro to define a property key */
#ifdef DEFINE_PROPERTYKEY
    #undef DEFINE_PROPERTYKEY
#endif
#ifdef INITGUID
    #define DEFINE_PROPERTYKEY( x, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12 ) \
        EXTERN_C const GUID __cdecl x = { { p1, p2, p3, { p4, p5, p6, p7, p8, p9, p10, p11 } }, p12 }
#else
    #define DEFINE_PROPERTYKEY( x, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12 ) \
        EXTERN_C const GUID __cdecl x
#endif

/* Reference data types */
#ifndef REFPROPERTYKEY
    #ifdef __cplusplus
        #define REFPROPERTYKEY  const PROPERTYKEY &
    #else
        #define REFPROPERTYKEY  const PROPERTYKEY * const
    #endif
#endif

/* Property key comparison macro */
#ifndef IsEqualPropertyKey
    #define IsEqualPropertyKey( p1, p2 ) \
        (IsEqualIID( p1, p2 ) && ((p1).fmtid == (p2).fmtid))
#endif

/* First usable property identifier */
#ifndef PID_FIRST_USABLE
    #define PID_FIRST_USABLE    0x00000002L
#endif
