/*
 *  rpcdcep.h   RPC Distributed Computing Environment (DCE) private functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef __RPCDCEP_H__
#define __RPCDCEP_H__

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Private RPC primitive data types */
typedef void    *I_RPC_MUTEX;

/* RPC context handle special value */
#define RPC_CONTEXT_HANDLE_DEFAULT_GUARD    0xFFFFF00DL

/* RPC context handle flags */
#define RPC_CONTEXT_HANDLE_DEFAULT_FLAGS    0x00000000L
#define RPC_CONTEXT_HANDLE_FLAGS            0x30000000L
#define RPC_CONTEXT_HANDLE_SERIALIZE        0x10000000L
#define RPC_CONTEXT_HANDLE_DONT_SERIALIZE   0x20000000L
#if (NTDDI_VERSION >= 0x06000000)
    #define RPC_TYPE_STRICT_CONTEXT_HANDLE  0x40000000L
#endif

/* RPC function call types */
#define RPC_NCA_FLAGS_DEFAULT               0x00000000L
#define RPC_NCA_FLAGS_IDEMPOTENT            0x00000001L
#define RPC_NCA_FLAGS_BROADCAST             0x00000002L
#define RPC_NCA_FLAGS_MAYBE                 0x00000004L
#if (NTDDI_VERSION >= 0x06000000)
    #define RPCFLG_HAS_GUARANTEE            0x00000010L
#endif
#define RPC_BUFFER_COMPLETE                 0x00001000L
#define RPC_BUFFER_PARTIAL                  0x00002000L
#define RPC_BUFFER_EXTRA                    0x00004000L
#define RPC_BUFFER_ASYNC                    0x00008000L
#define RPC_BUFFER_NONOTIFY                 0x00010000L
#define RPCFLG_MESSAGE                      0x01000000L
#define RPCFLG_AUTO_COMPLETE                0x08000000L
#define RPCFLG_LOCAL_CALL                   0x10000000L
#define RPCFLG_INPUT_SYNCHRONOUS            0x20000000L
#define RPCFLG_ASYNCHRONOUS                 0x40000000L
#define RPCFLG_NON_NDR                      0x80000000L
#if (NTDDI_VERSION >= 0x05010000)
    #define RPCFLG_HAS_MULTI_SYNTAXES       0x02000000L
    #define RPCFLG_HAS_CALLBACKS            0x04000000L
#endif
#if (NTDDI_VERSION >= 0x06000000)
    #define RPCFLG_ACCESSIBILITY_BIT1       0x00100000L
    #define RPCFLG_ACCESSIBILITY_BIT2       0x00200000L
    #define RPCFLG_ACCESS_LOCAL             0x00400000L
    #define NDR_CUSTOM_OR_DEFAULT_ALLOCATOR 0x10000000L
    #define NDR_DEFAULT_ALLOCATOR           0x20000000L
#endif
#define RPC_FLAGS_VALID_BIT                 0x00008000L

/* RPC interface flags */
#define RPC_INTERFACE_HAS_PIPES 0x00000001

/* RPC proxy connection types */
#define RPC_PROXY_CONNECTION_TYPE_IN_PROXY  0
#define RPC_PROXY_CONNECTION_TYPE_OUT_PROXY 1

/* RPC binding options */
#if (NTDDI_VERSION >= 0x05020000)
    #define RPC_C_OPT_SESSION_ID            6L
    #define RPC_C_OPT_COOKIE_AUTH           7L
    #define RPC_C_OPT_RESOURCE_TYPE_UUID    8L
#endif

/* RPC address change types */
enum RPC_ADDRESS_CHANGE_TYPE {
    PROTOCOL_NOT_LOADED     = 1,
    PROTOCOL_LOADED         = 2,
    PROTOCOL_ADDRESS_CHANGE = 3
};

/* RPC version */
typedef struct _RPC_VERSION {
    unsigned short  MajorVersion;
    unsigned short  MinorVersion;
} RPC_VERSION;

/* RPC syntax identifier */
typedef struct _RPC_SYNTAX_IDENTIFIER {
    GUID        SyntaxGUID;
    RPC_VERSION SyntaxVersion;
} RPC_SYNTAX_IDENTIFIER;
typedef RPC_SYNTAX_IDENTIFIER   *PRPC_SYNTAX_IDENTIFIER;

/* RPC message */
typedef struct _RPC_MESSAGE {
    RPC_BINDING_HANDLE      Handle;
    unsigned long           DataRepresentation;
    void                    *Buffer;
    unsigned int            BufferLength;
    unsigned int            ProcNum;
    PRPC_SYNTAX_IDENTIFIER  TransferSyntax;
    void                    *RpcInterfaceInformation;
    void                    *ReservedForRuntime;
    RPC_MGR_EPV             *ManagerEpv;
    void                    *ImportContext;
    unsigned long           RpcFlags;
} RPC_MESSAGE;
typedef RPC_MESSAGE *PRPC_MESSAGE;

/* RPC private callbacks */
typedef RPC_STATUS (RPC_ENTRY RPC_FORWARD_FUNCTION)( UUID *, RPC_VERSION *, UUID *, unsigned char *, void ** );
typedef void (RPC_ENTRY RPC_ADDRESS_CHANGE_FN)( void * );
typedef void (RPC_ENTRY RPC_DISPATCH_FUNCTION)( PRPC_MESSAGE );
typedef void (RPC_ENTRY *PRPC_RUNDOWN)( void * );
typedef void (RPC_ENTRY *RPCLT_PDU_FILTER_FUNC)( void *, unsigned int, int );
typedef void (__cdecl *RPC_SETFILTER_FUNC)( RPCLT_PDU_FILTER_FUNC );
typedef RPC_STATUS (RPC_ENTRY *RPC_BLOCKING_FN)( void *, void *, void * );

/* RPC dispatch table */
typedef struct {
    unsigned int            DispatchTableCount;
    RPC_DISPATCH_FUNCTION   *DispatchTable;
    LONG_PTR                Reserved;
} RPC_DISPATCH_TABLE;
typedef RPC_DISPATCH_TABLE  *PRPC_DISPATCH_TABLE;

/* RPC protocol sequence endpoint */
typedef struct _RPC_PROTSEQ_ENDPOINT {
    unsigned char   *RpcProtocolSequence;
    unsigned char   *Endpoint;
} RPC_PROTSEQ_ENDPOINT;
typedef RPC_PROTSEQ_ENDPOINT    *PRPC_PROTSEQ_ENDPOINT;

/* RPC server interface */
typedef struct _RPC_SERVER_INTERFACE {
    unsigned int            Length;
    RPC_SYNTAX_IDENTIFIER   InterfaceId;
    RPC_SYNTAX_IDENTIFIER   TransferSyntax;
    PRPC_DISPATCH_TABLE     DispatchTable;
    unsigned int            RpcProtseqEndpointCount;
    PRPC_PROTSEQ_ENDPOINT   RpcProtseqEndpoint;
    RPC_MGR_EPV             *DefaultManagerEpv;
    void const              *InterpreterInfo;
    unsigned int            Flags;
} RPC_SERVER_INTERFACE;
typedef RPC_SERVER_INTERFACE    *PRPC_SERVER_INTERFACE;

/* RPC client interface */
typedef struct _RPC_CLIENT_INTERFACE {
    unsigned int            Length;
    RPC_SYNTAX_IDENTIFIER   InterfaceId;
    RPC_SYNTAX_IDENTIFIER   TransferSyntax;
    PRPC_DISPATCH_TABLE     DispatchTable;
    unsigned int            RpcProtseqEndpointCount;
    PRPC_PROTSEQ_ENDPOINT   RpcProtseqEndpoint;
    ULONG_PTR               Reserved;
    void const              *InterpreterInfo;
    unsigned int            Flags;
} RPC_CLIENT_INTERFACE;
typedef RPC_CLIENT_INTERFACE    *PRPC_CLIENT_INTERFACE;

/* RPC transfer syntax */
typedef struct _RPC_TRANSFER_SYNTAX {
    UUID            Uuid;
    unsigned short  VersMajor;
    unsigned short  VersMinor;
} RPC_TRANSFER_SYNTAX;

/* RPC cookie authentication descriptor */
#if (NTDDI_VERSION >= 0x05020000)
typedef struct _RPC_C_OPT_COOKIE_AUTH_DESCRIPTOR {
    unsigned long   BufferSize;
    char            *Buffer;
} RPC_C_OPT_COOKIE_AUTH_DESCRIPTOR;
#endif

/* RDR callout state */
#if (NTDDI_VERSION >= 0x05020000)
typedef struct _RDR_CALLOUT_STATE {
    RPC_STATUS                      LastError;
    void                            *LastEEInfo;
    RPC_HTTP_REDIRECTOR_STAGE       LastCalledStage;
    unsigned short                  *ServerName;
    unsigned short                  *ServerPort;
    unsigned short                  *RemoteUser;
    unsigned short                  *AuthType;
    unsigned char                   ResourceTypePresent;
    unsigned char                   SessionIdPresent;
    unsigned char                   InterfacePresent;
    UUID                            ResourceType;
    UUID                            SessionId;
    RPC_SYNTAX_IDENTIFIER           Interface;
    void                            *CertContext;
} RDR_CALLOUT_STATE;
#endif

/* RPC proxy performance counters */
#if (NTDDI_VERSION >= 0x06000000)
typedef enum RpcProxyPerfCounters {
    RpcCurrentUniqueUser            = 1,
    RpcBackEndConnectionAttempts    = 2,
    RpcBackEndConnectionFailed      = 3,
    RpcRequestsPerSecond            = 4,
    RpcIncomingConnections          = 5,
    RpcIncomingBandwidth            = 6,
    RpcAttemptedLbsDecisions        = 7,
    RpcFailedLbsDecisions           = 8,
    RpcAttemptedLbsMessages         = 9,
    RpcFailedLbsMessages            = 10,
    RpcLastCounter                  = 11
} RpcPerfCounters;
#endif

/* RPC proxy callback functions */
#if (NTDDI_VERSION >= 0x05010000)
typedef RPC_STATUS  (RPC_ENTRY *I_RpcProxyIsValidMachineFn)( RPC_WSTR, RPC_WSTR, unsigned long );
typedef RPC_STATUS  (RPC_ENTRY *I_RpcProxyGetClientAddressFn)( void *, char *, unsigned long );
typedef RPC_STATUS  (RPC_ENTRY *I_RpcProxyGetConnectionTimeoutFn)( unsigned long * );
#endif
#if (NTDDI_VERSION >= 0x05020000)
typedef RPC_STATUS  (RPC_ENTRY *I_RpcPerformCalloutFn)( void *, RDR_CALLOUT_STATE *, RPC_HTTP_REDIRECTOR_STAGE );
typedef RPC_STATUS  (RPC_ENTRY *I_RpcFreeCalloutStateFn)( RDR_CALLOUT_STATE * );
typedef RPC_STATUS  (RPC_ENTRY *I_RpcProxyGetClientSessionAndResourceUUID)( void *, int *, UUID *, int *, UUID * );
#endif
#if (NTDDI_VERSION >= 0x06000000)
typedef RPC_STATUS  (RPC_ENTRY *I_RpcProxyFilterIfFn)( void *, UUID *, unsigned short, int * );
typedef void        (RPC_ENTRY *I_RpcProxyUpdatePerfCounterFn)( RpcPerfCounters, int, unsigned long );
typedef void        (RPC_ENTRY *I_RpcProxyUpdatePerfCounterBackendServerFn)( unsigned short *, int );
#endif

/* RPC proxy callback interface */
#if (NTDDI_VERSION >= 0x05010000)
typedef struct tagI_RpcProxyCallbackInterface {
    I_RpcProxyIsValidMachineFn                  IsValidMachineFn;
    I_RpcProxyGetClientAddressFn                GetClientAddressFn;
    I_RpcProxyGetConnectionTimeoutFn            GetConnectionTimeoutFn;
#if (NTDDI_VERSION >= 0x05020000)
    I_RpcPerformCalloutFn                       PerformCalloutFn;
    I_RpcFreeCalloutStateFn                     FreeCalloutStateFn;
    I_RpcProxyGetClientSessionAndResourceUUID   GetClientSessionAndResourceUUID;
#endif
#if (NTDDI_VERSION >= 0x06000000)
    I_RpcProxyFilterIfFn                        ProxyFilterIfFn;
    I_RpcProxyUpdatePerfCounterFn               RpcProxyUpdatePerfCounterFn;
    I_RpcProxyUpdatePerfCounterBackendServerFn  RpcProxyUpdatePerfCounterBackendServerFn;
#endif
} I_RpcProxyCallbackInterface;
#endif

/* Functions in RPCRT4.DLL */
RPCRTAPI void * RPC_ENTRY       I_RpcAllocate( unsigned int );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcBindingCopy( RPC_BINDING_HANDLE, RPC_BINDING_HANDLE * );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcBindingCreateNP( RPC_WSTR, RPC_WSTR, RPC_WSTR, RPC_BINDING_HANDLE * );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcBindingInqConnId( RPC_BINDING_HANDLE, void **, int * );  
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcBindingInqDynamicEndpointA( RPC_BINDING_HANDLE, RPC_CSTR * );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcBindingInqDynamicEndpointW( RPC_BINDING_HANDLE, RPC_WSTR * );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcBindingInqSecurityContext( RPC_BINDING_HANDLE, void ** );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcBindingInqTransportType( RPC_BINDING_HANDLE, unsigned int * );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcBindingInqWireIdForSnego( RPC_BINDING_HANDLE, RPC_CSTR );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcBindingIsClientLocal( RPC_BINDING_HANDLE, unsigned int * );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcBindingSetAsync( RPC_BINDING_HANDLE, RPC_BLOCKING_FN, unsigned long );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcBindingToStaticStringBindingW( RPC_BINDING_HANDLE, unsigned short ** );
RPCRTAPI void RPC_ENTRY         I_RpcClearMutex( I_RPC_MUTEX );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcConnectionInqSockBuffSize( unsigned long *, unsigned long * );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcConnectionSetSockBuffSize( unsigned long, unsigned long );
RPCRTAPI void RPC_ENTRY         I_RpcDeleteMutex( I_RPC_MUTEX );
RPCRTAPI void RPC_ENTRY         I_RpcFree( void * );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcFreeBuffer( RPC_MESSAGE * );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcFreePipeBuffer( RPC_MESSAGE * );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcGetAssociationContext( RPC_BINDING_HANDLE, void ** );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcGetBuffer( RPC_MESSAGE * );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcGetBufferWithObject( RPC_MESSAGE *, UUID * );
RPCRTAPI RPC_BINDING_HANDLE RPC_ENTRY   I_RpcGetCurrentCallHandle( void );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcGetExtendedError( void );
RPCRTAPI void * RPC_ENTRY       I_RpcGetServerContextList( RPC_BINDING_HANDLE );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcIfInqTransferSyntaxes( RPC_IF_HANDLE, RPC_TRANSFER_SYNTAX *, unsigned int, unsigned int * );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcMapWin32Status( RPC_STATUS );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcMonitorAssociation( RPC_BINDING_HANDLE, PRPC_RUNDOWN, void * );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcNsBindingSetEntryNameA( RPC_BINDING_HANDLE, unsigned long, RPC_CSTR );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcNsBindingSetEntryNameW( RPC_BINDING_HANDLE, unsigned long, RPC_WSTR );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcNsInterfaceExported( unsigned long, unsigned short *, RPC_SERVER_INTERFACE * );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcNsInterfaceUnexported( unsigned long, unsigned short *, RPC_SERVER_INTERFACE * );
RPCRTAPI void RPC_ENTRY         I_RpcPauseExecution( unsigned long );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcReallocPipeBuffer( PRPC_MESSAGE, unsigned int );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcReceive( PRPC_MESSAGE, unsigned int );
RPCRTAPI void RPC_ENTRY         I_RpcRequestMutex( I_RPC_MUTEX * );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcSend( PRPC_MESSAGE );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcSendReceive( RPC_MESSAGE * );
RPCRTAPI RPC_ADDRESS_CHANGE_FN * RPC_ENTRY  I_RpcServerInqAddressChangeFn( void );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcServerInqTransportType( unsigned int * );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcServerRegisterForwardFunction( RPC_FORWARD_FUNCTION * );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcServerSetAddressChangeFn( RPC_ADDRESS_CHANGE_FN * );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcServerStartListening( void * );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcServerStartService( RPC_WSTR, RPC_WSTR, RPC_IF_HANDLE );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcServerStopListening( void );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcServerUseProtseq2A( RPC_CSTR, RPC_CSTR, unsigned int, void *, void * );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcServerUseProtseq2W( RPC_WSTR, RPC_WSTR, unsigned int, void *, void * );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcServerUseProtseqEp2A( RPC_CSTR, RPC_CSTR, unsigned int, RPC_CSTR, void *, void * );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcServerUseProtseqEp2W( RPC_WSTR, RPC_WSTR, unsigned int, RPC_WSTR, void *, void * );
RPCRTAPI void RPC_ENTRY         I_RpcSetServerContextList( RPC_BINDING_HANDLE, void * );
RPCRTAPI void RPC_ENTRY         I_RpcSsDontSerializeContext( void );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcStopMonitorAssociation( RPC_BINDING_HANDLE );
RPCRTAPI unsigned int RPC_ENTRY I_RpcWindowProc( void *, unsigned int, unsigned int, unsigned long );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_UuidCreate( UUID * );
#if (NTDDI_VERSION >= 0x05010000)
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcBindingHandleToAsyncHandle( RPC_BINDING_HANDLE, void ** );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcBindingInqLocalClientPID( RPC_BINDING_HANDLE, unsigned long * );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcNegotiateTransferSyntax( RPC_MESSAGE * );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcServerCheckClientRestriction( RPC_BINDING_HANDLE );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcServerInqLocalConnAddress( RPC_BINDING_HANDLE, void *, unsigned long *, unsigned long * );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcServerInqRemoteConnAddress( RPC_BINDING_HANDLE, void *, unsigned long *, unsigned long * );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcSessionStrictContextHandle( void );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcTurnOnEEInfoPropagation( void );
#endif
#if (NTDDI_VERSION >= 0x05020000)
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcBindingInqMarshalledTargetInfo( RPC_BINDING_HANDLE, unsigned long *, RPC_CSTR * );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcRecordCalloutFailure( RPC_STATUS, RDR_CALLOUT_STATE *, unsigned short * );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcReplyToClientWithStatus( void *, RPC_STATUS );
#endif
#if (NTDDI_VERSION >= 0x06000000)
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcBindingInqSecurityContextKeyInfo( RPC_BINDING_HANDLE, void * );
#endif
#if (NTDDI_VERSION >= 0x06010000)
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcMgmtEnableDedicatedThreadPool();
#endif

/* Functions in RPCRT4.DLL that are defined differently on different versions
 * of Windows.
 */
#if (NTDDI_VERSION >= 0x05020000)
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcProxyNewConnection( unsigned long, unsigned short *, unsigned short *, unsigned short *, void *, RDR_CALLOUT_STATE *, I_RpcProxyCallbackInterface * );
#elif (NTDDI_VERSION >= 0x05010000)
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcProxyNewConnection( unsigned long, unsigned short *, unsigned short *, void *, I_RpcProxyCallbackInterface * );
#endif

/* Map generic function names to the appropriate ANSI or Unicode version. */
#ifdef UNICODE
    #define I_RpcBindingInqDynamicEndpoint  I_RpcBindingInqDynamicEndpointW
    #define I_RpcNsBindingSetEntryName      I_RpcNsBindingSetEntryNameW
    #define I_RpcServerUnregisterEndpoint   I_RpcServerUnregisterEndpointW
    #define I_RpcServerUseProtseq2          I_RpcServerUseProtseq2W
    #define I_RpcServerUseProtseqEp2        I_RpcServerUseProtseqEp2W
#else
    #define I_RpcBindingInqDynamicEndpoint  I_RpcBindingInqDynamicEndpointA
    #define I_RpcNsBindingSetEntryName      I_RpcNsBindingSetEntryNameA
    #define I_RpcServerUnregisterEndpoint   I_RpcServerUnregisterEndpointA
    #define I_RpcServerUseProtseq2          I_RpcServerUseProtseq2A
    #define I_RpcServerUseProtseqEp2        I_RpcServerUseProtseqEp2A
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __RPCDCEP_H__ */
