/*
 *  setupapi.h  Setup functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _INC_SETUPAPI
#define _INC_SETUPAPI

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#include <spapidef.h>
#include <commctrl.h>
#include <devpropdef.h>

#pragma pack( __push, 1 )

#ifdef __cplusplus
extern "C" {
#endif

/* Setup API version number */
#ifndef _SETUPAPI_VER
    #define _SETUPAPI_VER           0x0501
    #ifdef _WIN32_WINNT
        #undef _SETUPAPI_VER
        #define _SETUPAPI_VER       _WIN32_WINNT
    #endif
    #if !defined( _WIN32_WINNT ) || (_WIN32_WINNT >= _WIN32_WINDOWS)
        #undef _SETUPAPI_VER
        #if (_WIN32_WINDOWS >= 0x0490)
            #define _SETUPAPI_VER   0x0500
        #elif (_WIN32_WINDOWS >= 0x0410)
            #define _SETUPAPI_VER   0x0410
        #else
            #define _SETUPAPI_VER   0x0400
        #endif
    #endif
#endif

/* Macro to specify setup functions */
#define WINSETUPAPI DECLSPEC_IMPORT

/* Handle data types */
typedef PVOID   HINF;
typedef PVOID   HSPFILEQ;
typedef PVOID   HDSKSPC;
typedef PVOID   HDEVINFO;
typedef PVOID   HSPFILELOG;

/* Device installer function data type */
typedef UINT    DI_FUNCTION;

/* Log severity data type */
#define LogSeverity DWORD

/* Maximum string lengths */
#define LINE_LEN                    256
#define MAX_INF_STRING_LENGTH       4096
#define MAX_INF_SECTION_NAME_LENGTH 255
#define MAX_TITLE_LEN               60
#define MAX_INSTRUCTION_LEN         256
#define MAX_LABEL_LEN               30
#define MAX_SERVICE_NAME_LEN        256
#define MAX_SUBTITLE_LEN            256
#define SP_MAX_MACHINENAME_LENGTH   (MAX_PATH + 3)

/* Setup alternate platform flags */
#if (_SETUPAPI_VER >= 0x0501)
    #define SP_ALTPLATFORM_FLAGS_VERSION_RANGE  0x0001
#endif

/* Information styles */
#define INF_STYLE_NONE              0x00000000L
#define INF_STYLE_OLDNT             0x00000001L
#define INF_STYLE_WIN4              0x00000002L
#define INF_STYLE_CACHE_ENABLE      0x00000010L
#define INF_STYLE_CACHE_DISABLE     0x00000020L
#if (_SETUPAPI_VER >= 0x0502)
    #define INF_STYLE_CACHE_IGNORE  0x00000040L
#endif

/* Directory identifiers */
#define DIRID_ABSOLUTE                  (-1)
#define DIRID_ABSOLUTE_16BIT            0xFFFF
#define DIRID_NULL                      0
#define DIRID_SRCPATH                   1
#define DIRID_WINDOWS                   10
#define DIRID_SYSTEM                    11
#define DIRID_DRIVERS                   12
#define DIRID_IOSUBSYS                  DIRID_DRIVERS
#define DIRID_INF                       17
#define DIRID_HELP                      18
#define DIRID_FONTS                     20
#define DIRID_VIEWERS                   21
#define DIRID_COLOR                     23
#define DIRID_APPS                      24
#define DIRID_SHARED                    25
#define DIRID_BOOT                      30
#define DIRID_SYSTEM16                  50
#define DIRID_SPOOL                     51
#define DIRID_SPOOLDRIVERS              52
#define DIRID_USERPROFILE               53
#define DIRID_LOADER                    54
#define DIRID_PRINTPROCESSOR            55
#define DIRID_DEFAULT                   DIRID_SYSTEM
#define DIRID_COMMON_STARTMENU          16406
#define DIRID_COMMON_PROGRAMS           16407
#define DIRID_COMMON_STARTUP            16408
#define DIRID_COMMON_DESKTOPDIRECTORY   16409
#define DIRID_COMMON_FAVORITES          16415
#define DIRID_COMMON_APPDATA            16419
#define DIRID_PROGRAM_FILES             16422
#define DIRID_SYSTEM_X86                16425
#define DIRID_PROGRAM_FILES_X86         16426
#define DIRID_PROGRAM_FILES_COMMON      16427
#define DIRID_PROGRAM_FILES_COMMONX86   16428
#define DIRID_COMMON_TEMPLATES          16429
#define DIRID_COMMON_DOCUMENTS          16430
#define DIRID_USER                      0x8000

/* Setup file notification ordinals */
#define SPFILENOTIFY_STARTQUEUE                 0x00000001L
#define SPFILENOTIFY_ENDQUEUE                   0x00000002L
#define SPFILENOTIFY_STARTSUBQUEUE              0x00000003L
#define SPFILENOTIFY_ENDSUBQUEUE                0x00000004L
#define SPFILENOTIFY_STARTDELETE                0x00000005L
#define SPFILENOTIFY_ENDDELETE                  0x00000006L
#define SPFILENOTIFY_DELETEERROR                0x00000007L
#define SPFILENOTIFY_STARTRENAME                0x00000008L
#define SPFILENOTIFY_ENDRENAME                  0x00000009L
#define SPFILENOTIFY_RENAMEERROR                0x0000000AL
#define SPFILENOTIFY_STARTCOPY                  0x0000000BL
#define SPFILENOTIFY_ENDCOPY                    0x0000000CL
#define SPFILENOTIFY_COPYERROR                  0x0000000DL
#define SPFILENOTIFY_NEEDMEDIA                  0x0000000EL
#define SPFILENOTIFY_QUEUESCAN                  0x0000000FL
#define SPFILENOTIFY_CABINETINFO                0x00000010L
#define SPFILENOTIFY_FILEINCABINET              0x00000011L
#define SPFILENOTIFY_NEEDNEWCABINET             0x00000012L
#define SPFILENOTIFY_FILEEXTRACTED              0x00000013L
#define SPFILENOTIFY_FILEOPDELAYED              0x00000014L
#define SPFILENOTIFY_STARTBACKUP                0x00000015L
#define SPFILENOTIFY_BACKUPERROR                0x00000016L
#define SPFILENOTIFY_ENDBACKUP                  0x00000017L
#define SPFILENOTIFY_QUEUESCAN_EX               0x00000018L
#define SPFILENOTIFY_STARTREGISTRATION          0x00000019L
#define SPFILENOTIFY_ENDREGISTRATION            0x00000020L
#if (_SETUPAPI_VER >= 0x0501)
    #define SPFILENOTIFY_QUEUESCAN_SIGNERINFO   0x00000040L
#endif
#define SPFILENOTIFY_LANGMISMATCH               0x00010000L
#define SPFILENOTIFY_TARGETEXISTS               0x00020000L
#define SPFILENOTIFY_TARGETNEWER                0x00040000L

/* File operation codes */
#define FILEOP_COPY     0
#define FILEOP_RENAME   1
#define FILEOP_DELETE   2
#define FILEOP_BACKUP   3

/* File operation callback return values */
#define FILEOP_ABORT    0
#define FILEOP_DOIT     1
#define FILEOP_SKIP     2
#define FILEOP_RETRY    FILEOP_DOIT
#define FILEOP_NEWPATH  4

/* Copy flags */
#define COPYFLG_WARN_IF_SKIP                    0x00000001L
#define COPYFLG_NOSKIP                          0x00000002L
#define COPYFLG_NOVERSIONCHECK                  0x00000004L
#define COPYFLG_FORCE_FILE_IN_USE               0x00000008L
#define COPYFLG_NO_OVERWRITE                    0x00000010L
#define COPYFLG_NO_VERSION_DIALOG               0x00000020L
#define COPYFLG_OVERWRITE_OLDER_ONLY            0x00000040L
#define COPYFLG_PROTECTED_WINDOWS_DRIVER_FILE   0x00000100L
#define COPYFLG_REPLACEONLY                     0x00000400L
#define COPYFLG_NODECOMP                        0x00000800L
#define COPYFLG_REPLACE_BOOT_FILE               0x00001000L
#define COPYFLG_NOPRUNE                         0x00002000L
#define COPYFLG_IN_USE_TRY_RENAME               0x00004000L

/* Delete flags */
#define DELFLG_IN_USE   0x00000001L
#define DELFLG_IN_USE1  0x00010000L

/* Setup register control status failure codes */
#define SPREG_SUCCESS       0x00000000L
#define SPREG_LOADLIBRARY   0x00000001L
#define SPREG_GETPROCADDR   0x00000002L
#define SPREG_REGSVR        0x00000003L
#define SPREG_DLLINSTALL    0x00000004L
#define SPREG_TIMEOUT       0x00000005L
#define SPREG_UNKNOWN       0xFFFFFFFFL

/* Setup device interface data flags */
#define SPINT_ACTIVE    0x00000001L
#define SPINT_DEFAULT   0x00000002L
#define SPINT_REMOVED   0x00000004L
#define SPID_ACTIVE     SPINT_ACTIVE
#define SPID_DEFAULT    SPINT_DEFAULT
#define SPID_REMOVED    SPINT_REMOVED

/* Device installation functions */
#define DIF_SELECTDEVICE                    0x00000001L
#define DIF_INSTALLDEVICE                   0x00000002L
#define DIF_ASSIGNRESOURCES                 0x00000003L
#define DIF_PROPERTIES                      0x00000004L
#define DIF_REMOVE                          0x00000005L
#define DIF_FIRSTTIMESETUP                  0x00000006L
#define DIF_FOUNDDEVICE                     0x00000007L
#define DIF_SELECTCLASSDRIVERS              0x00000008L
#define DIF_VALIDATECLASSDRIVERS            0x00000009L
#define DIF_INSTALLCLASSDRIVERS             0x0000000AL
#define DIF_CALCDISKSPACE                   0x0000000BL
#define DIF_DESTROYPRIVATEDATA              0x0000000CL
#define DIF_VALIDATEDRIVER                  0x0000000DL
#define DIF_MOVEDEVICE                      0x0000000EL
#define DIF_DETECT                          0x0000000FL
#define DIF_INSTALLWIZARD                   0x00000010L
#define DIF_DESTROYWIZARDDATA               0x00000011L
#define DIF_PROPERTYCHANGE                  0x00000012L
#define DIF_ENABLECLASS                     0x00000013L
#define DIF_DETECTVERIFY                    0x00000014L
#define DIF_INSTALLDEVICEFILES              0x00000015L
#define DIF_UNREMOVE                        0x00000016L
#define DIF_SELECTBESTCOMPATDRV             0x00000017L
#define DIF_ALLOW_INSTALL                   0x00000018L
#define DIF_REGISTERDEVICE                  0x00000019L
#define DIF_NEWDEVICEWIZARD_PRESELECT       0x0000001AL
#define DIF_NEWDEVICEWIZARD_SELECT          0x0000001BL
#define DIF_NEWDEVICEWIZARD_PREANALYZE      0x0000001CL
#define DIF_NEWDEVICEWIZARD_POSTANALYZE     0x0000001DL
#define DIF_NEWDEVICEWIZARD_FINISHINSTALL   0x0000001EL
#define DIF_INSTALLINTERFACES               0x00000020L
#define DIF_DETECTCANCEL                    0x00000021L
#define DIF_REGISTER_COINSTALLERS           0x00000022L
#define DIF_ADDPROPERTYPAGE_ADVANCED        0x00000023L
#define DIF_ADDPROPERTYPAGE_BASIC           0x00000024L
#define DIF_TROUBLESHOOTER                  0x00000026L
#define DIF_POWERMESSAGEWAKE                0x00000027L
#define DIF_ADDREMOTEPROPERTYPAGE_ADVANCED  0x00000028L
#define DIF_UPDATEDRIVER_UI                 0x00000029L
#define DIF_FINISHINSTALL_ACTION            0x0000002AL

/* Device installation flags */
#define DI_SHOWOEM              0x00000001L
#define DI_SHOWCOMPAT           0x00000002L
#define DI_SHOWCLASS            0x00000004L
#define DI_SHOWALL              0x00000007L
#define DI_NOVCP                0x00000008L
#define DI_DIDCOMPAT            0x00000010L
#define DI_DIDCLASS             0x00000020L
#define DI_AUTOASSIGNRES        0x00000040L
#define DI_NEEDRESTART          0x00000080L
#define DI_NEEDREBOOT           0x00000100L
#define DI_NOBROWSE             0x00000200L
#define DI_MULTMFGS             0x00000400L
#define DI_DISABLED             0x00000800L
#define DI_GENERALPAGE_ADDED    0x00001000L
#define DI_RESOURCEPAGE_ADDED   0x00002000L
#define DI_PROPERTIES_CHANGE    0x00004000L
#define DI_INF_IS_SORTED        0x00008000L
#define DI_ENUMSINGLEINF        0x00010000L
#define DI_DONOTCALLCONFIGMG    0x00020000L
#define DI_INSTALLDISABLED      0x00040000L
#define DI_COMPAT_FROM_CLASS    0x00080000L
#define DI_CLASSINSTALLPARAMS   0x00100000L
#define DI_NODI_DEFAULTACTION   0x00200000L
#define DI_QUIETINSTALL         0x00800000L
#define DI_NOFILECOPY           0x01000000L
#define DI_FORCECOPY            0x02000000L
#define DI_DRIVERPAGE_ADDED     0x04000000L
#define DI_USECI_SELECTSTRINGS  0x08000000L
#define DI_OVERRIDE_INFFLAGS    0x10000000L
#define DI_PROPS_NOCHANGEUSAGE  0x20000000L
#define DI_NOSELECTICONS        0x40000000L
#define DI_NOWRITE_IDS          0x80000000L

/* Device installation extended flags */
#define DI_FLAGSEX_CI_FAILED                    0x00000004L
#if (_SETUPAPI_VER >= 0x0600)
    #define DI_FLAGSEX_FINISHINSTALL_ACTION     0x00000008L
#endif
#define DI_FLAGSEX_DIDINFOLIST                  0x00000010L
#define DI_FLAGSEX_DIDCOMPATINFO                0x00000020L
#define DI_FLAGSEX_FILTERCLASSES                0x00000040L
#define DI_FLAGSEX_SETFAILEDINSTALL             0x00000080L
#define DI_FLAGSEX_DEVICECHANGE                 0x00000100L
#define DI_FLAGSEX_ALWAYSWRITEIDS               0x00000200L
#define DI_FLAGSEX_PROPCHANGE_PENDING           0x00000400L
#define DI_FLAGSEX_ALLOWEXCLUDEDDRVS            0x00000800L
#define DI_FLAGSEX_NOUIONQUERYREMOVE            0x00001000L
#define DI_FLAGSEX_USECLASSFORCOMPAT            0x00002000L
#define DI_FLAGSEX_NO_DRVREG_MODIFY             0x00008000L
#define DI_FLAGSEX_IN_SYSTEM_SETUP              0x00010000L
#define DI_FLAGSEX_INET_DRIVER                  0x00020000L
#define DI_FLAGSEX_APPENDDRIVERLIST             0x00040000L
#define DI_FLAGSEX_PREINSTALLBACKUP             0x00080000L
#define DI_FLAGSEX_BACKUPONREPLACE              0x00100000L
#define DI_FLAGSEX_DRIVERLIST_FROM_URL          0x00200000L
#define DI_FLAGSEX_EXCLUDE_OLD_INET_DRIVERS     0x00800000L
#define DI_FLAGSEX_POWERPAGE_ADDED              0x01000000L
#if (_SETUPAPI_VER >= 0x0501)
    #define DI_FLAGSEX_FILTERSIMILARDRIVERS     0x02000000L
    #define DI_FLAGSEX_INSTALLEDDRIVER          0x04000000L
    #define DI_FLAGSEX_NO_CLASSLIST_NODE_MERGE  0x08000000L
    #define DI_FLAGSEX_ALTPLATFORM_DRVSEARCH    0x10000000L
    #define DI_FLAGSEX_RESTART_DEVICE_ONLY      0x20000000L
#endif
#if (_SETUPAPI_VER >= 0x0600)
    #define DI_FLAGSEX_RECURSIVESEARCH          0x40000000L
    #define DI_FLAGSEX_SEARCH_PUBLISHED_INFS    0x80000000L
#endif

/* Enable class messages */
#define ENABLECLASS_QUERY   0L
#define ENABLECLASS_SUCCESS 1L
#define ENABLECLASS_FAILURE 2L

/* Device installation state changes */
#define DICS_ENABLE     0x00000001L
#define DICS_DISABLE    0x00000002L
#define DICS_PROPCHANGE 0x00000003L
#define DICS_START      0x00000004L
#define DICS_STOP       0x00000005L

/* Device installation state change flags */
#define DICS_FLAG_GLOBAL            0x00000001L
#define DICS_FLAG_CONFIGSPECIFIC    0x00000002L
#define DICS_FLAG_CONFIGGENERAL     0x00000004L

/* Device installation remove device flags */
#define DI_REMOVEDEVICE_GLOBAL          0x00000001L
#define DI_REMOVEDEVICE_CONFIGSPECIFIC  0x00000002L

/* Device installation unremove device flags */
#define DI_UNREMOVEDEVICE_CONFIGSPECIFIC    0x00000002L

/* Maximum number of dynamic pages */
#define MAX_INSTALLWIZARD_DYNAPAGES 20

/* New Device Wizard install flags */
#define NDW_INSTALLFLAG_DIDFACTDEFS         0x00000001L
#define NDW_INSTALLFLAG_HARDWAREALLREADYIN  0x00000002L
#define NDW_INSTALLFLAG_NEEDRESTART         DI_NEEDRESTART
#define NDW_INSTALLFLAG_NEEDREBOOT          DI_NEEDREBOOT
#define NDW_INSTALLFLAG_NEEDSHUTDOWN        0x00000200L
#define NDW_INSTALLFLAG_EXPRESSINTRO        0x00000400L
#define NDW_INSTALLFLAG_SKIPISDEVINSTALLED  0x00000800L
#define NDW_INSTALLFLAG_NODETECTEDDEVS      0x00001000L
#define NDW_INSTALLFLAG_INSTALLSPECIFIC     0x00002000L
#define NDW_INSTALLFLAG_SKIPCLASSLIST       0x00004000L
#define NDW_INSTALLFLAG_CI_PICKED_OEM       0x00008000L
#define NDW_INSTALLFLAG_PCMCIAMODE          0x00010000L
#define NDW_INSTALLFLAG_PCMCIADEVICE        0x00020000L
#define NDW_INSTALLFLAG_USERCANCEL          0x00040000L
#define NDW_INSTALLFLAG_KNOWNCLASS          0x00080000L

/* Dynamic wizard flags */
#define DYNAWIZ_FLAG_PAGESADDED             0x00000001L
#define DYNAWIZ_FLAG_INSTALLDET_NEXT        0x00000002L
#define DYNAWIZ_FLAG_INSTALLDET_PREV        0x00000004L
#define DYNAWIZ_FLAG_ANALYZE_HANDLECONFLICT 0x00000008L

/* Dynamic wizard dialog identifiers */
#define MIN_IDD_DYNAWIZ_RESOURCE_ID             10000
#define MAX_IDD_DYNAWIZ_RESOURCE_ID             11000
#define IDD_DYNAWIZ_FIRSTPAGE                   10000
#define IDD_DYNAWIZ_SELECT_PREVPAGE             10001
#define IDD_DYNAWIZ_SELECT_NEXTPAGE             10002
#define IDD_DYNAWIZ_ANALYZE_PREVPAGE            10003
#define IDD_DYNAWIZ_ANALYZE_NEXTPAGE            10004
#define IDD_DYNAWIZ_INSTALLDETECTED_PREVPAGE    10006
#define IDD_DYNAWIZ_INSTALLDETECTED_NEXTPAGE    10007
#define IDD_DYNAWIZ_INSTALLDETECTED_NODEVS      10008
#define IDD_DYNAWIZ_SELECTDEV_PAGE              10009
#define IDD_DYNAWIZ_ANALYZEDEV_PAGE             10010
#define IDD_DYNAWIZ_INSTALLDETECTEDDEVS_PAGE    10011
#define IDD_DYNAWIZ_SELECTCLASS_PAGE            10012

/* Driver installation flags */
#define DNF_DUPDESC                         0x00000001L
#define DNF_OLDDRIVER                       0x00000002L
#define DNF_EXCLUDEFROMLIST                 0x00000004L
#define DNF_NODRIVER                        0x00000008L
#define DNF_LEGACYINF                       0x00000010L
#define DNF_CLASS_DRIVER                    0x00000020L
#define DNF_COMPATIBLE_DRIVER               0x00000040L
#define DNF_INET_DRIVER                     0x00000080L
#define DNF_OLD_INET_DRIVER                 0x00000400L
#define DNF_BAD_DRIVER                      0x00000800L
#define DNF_DUPPROVIDER                     0x00001000L
#if (_SETUPAPI_VER >= 0x0501)
    #define DNF_INF_IS_SIGNED               0x00002000L
    #define DNF_OEM_F6_INF                  0x00004000L
    #define DNF_DUPDRIVERVER                0x00008000L
    #define DNF_BASIC_DRIVER                0x00010000L
#endif
#if (_SETUPAPI_VER >= 0x0502)
    #define DNF_AUTHENTICODE_SIGNED         0x00020000L
#endif
#if (_SETUPAPI_VER >= 0x0600)
    #define DNF_INSTALLEDDRIVER             0x00040000L
    #define DNF_ALWAYSEXCLUDEFROMLIST       0x00080000L
    #define DNF_INBOX_DRIVER                0x00100000L
#endif
#if (_SETUPAPI_VER >= 0x0601)
    #define DNF_REQUESTADDITIONALSOFTWARE   0x00200000L
#endif

/* Driver rank values */
#define DRIVER_HARDWAREID_RANK                  0x00000FFFL
#if (_SETUPAPI_VER >= 0x0600)
    #define DRIVER_HARDWAREID_MASK              0x80000FFFL
    #define DRIVER_UNTRUSTED_RANK               0x80000000L
    #define DRIVER_W9X_SUSPECT_RANK             0xC0000000L
#else
    #define DRIVER_HARDWAREID_MASK              0x00003FFFL
    #define DRIVER_UNTRUSTED_RANK               0x00008000L
    #define DRIVER_UNTRUSTED_HARDWAREID_RANK    0x00008FFFL
    #define DRIVER_UNTRUSTED_COMPATID_RANK      0x0000BFFFL
    #define DRIVER_W9X_SUSPECT_RANK             0x0000C000L
    #define DRIVER_W9X_SUSPECT_HARDWAREID_RANK  0x0000CFFFL
    #define DRIVER_W9X_SUSPECT_COMPATID_RANK    0x0000FFFFL
#endif

/* Setup property sheet page request pages */
#define SPPSR_SELECT_DEVICE_RESOURCES       1L
#define SPPSR_ENUM_BASIC_DEVICE_PROPERTIES  2L
#define SPPSR_ENUM_ADV_DEVICE_PROPERTIES    3L

/* Setup error codes */
#define ERROR_EXPECTED_SECTION_NAME \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0000L)
#define ERROR_BAD_SECTION_NAME_LINE \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0001L)
#define ERROR_SECTION_NAME_TOO_LONG \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0002L)
#define ERROR_GENERAL_SYNTAX \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0003L)
#define ERROR_WRONG_INF_STYLE \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0100L)
#define ERROR_SECTION_NOT_FOUND \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0101L)
#define ERROR_LINE_NOT_FOUND \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0102L)
#define ERROR_NO_BACKUP \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0103L)
#define ERROR_NO_ASSOCIATED_CLASS \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0200L)
#define ERROR_CLASS_MISMATCH \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0201L)
#define ERROR_DUPLICATE_FOUND \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0202L)
#define ERROR_NO_DRIVER_SELECTED \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0203L)
#define ERROR_KEY_DOES_NOT_EXIST \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0204L)
#define ERROR_INVALID_DEVINST_NAME \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0205L)
#define ERROR_INVALID_CLASS \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0206L)
#define ERROR_DEVINST_ALREADY_EXISTS \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0207L)
#define ERROR_DEVINFO_NOT_REGISTERED \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0208L)
#define ERROR_INVALID_REG_PROPERTY \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0209L)
#define ERROR_NO_INF \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x020AL)
#define ERROR_NO_SUCH_DEVINST \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x020BL)
#define ERROR_CANT_LOAD_CLASS_ICON \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x020CL)
#define ERROR_INVALID_CLASS_INSTALLER \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x020DL)
#define ERROR_DI_DO_DEFAULT \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x020EL)
#define ERROR_DI_NOFILECOPY \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x020FL)
#define ERROR_INVALID_HWPROFILE \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0210L)
#define ERROR_NO_DEVICE_SELECTED \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0211L)
#define ERROR_DEVINFO_LIST_LOCKED \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0212L)
#define ERROR_DEVINFO_DATA_LOCKED \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0213L)
#define ERROR_DI_BAD_PATH \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0214L)
#define ERROR_NO_CLASSINSTALL_PARAMS \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0215L)
#define ERROR_FILEQUEUE_LOCKED \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0216L)
#define ERROR_BAD_SERVICE_INSTALLSECT \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0217L)
#define ERROR_NO_CLASS_DRIVER_LIST \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0218L)
#define ERROR_NO_ASSOCIATED_SERVICE \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0219L)
#define ERROR_NO_DEFAULT_DEVICE_INTERFACE \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x021AL)
#define ERROR_DEVICE_INTERFACE_ACTIVE \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x021BL)
#define ERROR_DEVICE_INTERFACE_REMOVED \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x021CL)
#define ERROR_BAD_INTERFACE_INSTALLSECT \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x021DL)
#define ERROR_NO_SUCH_INTERFACE_CLASS \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x021EL)
#define ERROR_INVALID_REFERENCE_STRING \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x021FL)
#define ERROR_INVALID_MACHINENAME \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0220L)
#define ERROR_REMOTE_COMM_FAILURE \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0221L)
#define ERROR_MACHINE_UNAVAILABLE \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0222L)
#define ERROR_NO_CONFIGMGR_SERVICES \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0223L)
#define ERROR_INVALID_PROPPAGE_PROVIDER \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0224L)
#define ERROR_NO_SUCH_DEVICE_INTERFACE \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0225L)
#define ERROR_DI_POSTPROCESSING_REQUIRED \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0226L)
#define ERROR_INVALID_COINSTALLER \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0227L)
#define ERROR_NO_COMPAT_DRIVERS \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0228L)
#define ERROR_NO_DEVICE_ICON \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0229L)
#define ERROR_INVALID_INF_LOGCONFIG \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x022AL)
#define ERROR_DI_DONT_INSTALL \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x022BL)
#define ERROR_INVALID_FILTER_DRIVER \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x022CL)
#define ERROR_NON_WINDOWS_NT_DRIVER \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x022DL)
#define ERROR_NON_WINDOWS_DRIVER \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x022EL)
#define ERROR_NO_CATALOG_FOR_OEM_INF \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x022FL)
#define ERROR_DEVINSTALL_QUEUE_NONNATIVE \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0230L)
#define ERROR_NOT_DISABLEABLE \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0231L)
#define ERROR_CANT_REMOVE_DEVINST \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0232L)
#define ERROR_INVALID_TARGET \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0233L)
#define ERROR_DRIVER_NONNATIVE \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0234L)
#define ERROR_IN_WOW64 \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0235L)
#define ERROR_SET_SYSTEM_RESTORE_POINT \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0236L)
#define ERROR_SCE_DISABLED \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0238L)
#define ERROR_UNKNOWN_EXCEPTION \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0239L)
#define ERROR_PNP_REGISTRY_ERROR \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x023AL)
#define ERROR_REMOTE_REQUEST_UNSUPPORTED \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x023BL)
#define ERROR_NOT_AN_INSTALLED_OEM_INF \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x023CL)
#define ERROR_INF_IN_USE_BY_DEVICES \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x023DL)
#define ERROR_DI_FUNCTION_OBSOLETE \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x023EL)
#define ERROR_NO_AUTHENTICODE_CATALOG \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x023FL)
#define ERROR_AUTHENTICODE_DISALLOWED \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0240L)
#define ERROR_AUTHENTICODE_TRUSTED_PUBLISHER \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0241L)
#define ERROR_AUTHENTICODE_TRUST_NOT_ESTABLISHED \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0242L)
#define ERROR_AUTHENTICODE_PUBLISHER_NOT_TRUSTED \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0243L)
#define ERROR_SIGNATURE_OSATTRIBUTE_MISMATCH \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0244L)
#define ERROR_ONLY_VALIDATE_VIA_AUTHENTICODE \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0245L)
#define ERROR_DEVICE_INSTALLER_NOT_READY \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0246L)
#define ERROR_DRIVER_STORE_ADD_FAILED \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0247L)
#define ERROR_DEVICE_INSTALL_BLOCKED \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0248L)
#define ERROR_DRIVER_INSTALL_BLOCKED \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0249L)
#define ERROR_WRONG_INF_TYPE \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x024AL)
#define ERROR_FILE_HASH_NOT_IN_CATALOG \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x024BL)
#define ERROR_DRIVER_STORE_DELETE_FAILED \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x024CL)
#define ERROR_UNRECOVERABLE_STACK_OVERFLOW \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x0300L)
#define EXCEPTION_SPAPI_UNRECOVERABLE_STACK_OVERFLOW \
    ERROR_UNRECOVERABLE_STACK_OVERFLOW
#define ERROR_NO_DEFAULT_INTERFACE_DEVICE   ERROR_NO_DEFAULT_DEVICE_INTERFACE
#define ERROR_INTERFACE_DEVICE_ACTIVE       ERROR_DEVICE_INTERFACE_ACTIVE
#define ERROR_INTERFACE_DEVICE_REMOVED      ERROR_DEVICE_INTERFACE_REMOVED
#define ERROR_NO_SUCH_INTERFACE_DEVICE      ERROR_NO_SUCH_DEVICE_INTERFACE
#define ERROR_NOT_INSTALLED \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x1000L)

/* SetupGetInfInformation() search control values */
#define INFINFO_INF_SPEC_IS_HINF        1L
#define INFINFO_INF_NAME_IS_ABSOLUTE    2L
#define INFINFO_DEFAULT_SEARCH          3L
#define INFINFO_REVERSE_DEFAULT_SEARCH  4L
#define INFINFO_INF_PATH_LIST_SEARCH    5L

/* File compression types */
#define FILE_COMPRESSION_NONE   0
#define FILE_COMPRESSION_WINLZA 1
#define FILE_COMPRESSION_MSZIP  2
#define FILE_COMPRESSION_NTCAB  3

/* Source list flags */
#define SRCLIST_TEMPORARY       0x00000001L
#define SRCLIST_NOBROWSE        0x00000002L
#define SRCLIST_SYSTEM          0x00000010L
#define SRCLIST_USER            0x00000020L
#define SRCLIST_SYSIFADMIN      0x00000040L
#define SRCLIST_SUBDIRS         0x00000100L
#define SRCLIST_APPEND          0x00000200L
#define SRCLIST_NOSTRIPPLATFORM 0x00000400L

/* Installation dialog flags */
#define IDF_NOBROWSE                    0x00000001L
#define IDF_NOSKIP                      0x00000002L
#define IDF_NODETAILS                   0x00000004L
#define IDF_NOCOMPRESSED                0x00000008L
#define IDF_CHECKFIRST                  0x00000100L
#define IDF_NOBEEP                      0x00000200L
#define IDF_NOFOREGROUND                0x00000400L
#define IDF_WARNIFSKIP                  0x00000800L
#if (_SETUPAPI_VER >= 0x0501)
    #define IDF_NOREMOVABLEMEDIAPROMPT  0x00001000L
    #define IDF_USEDISKNAMEASPROMPT     0x00002000L
    #define IDF_OEMDISK                 0x80000000L
#endif

/* Disk prompt return values */
#define DPROMPT_SUCCESS         0
#define DPROMPT_CANCEL          1
#define DPROMPT_SKIPFILE        2
#define DPROMPT_BUFFERTOOSMALL  3
#define DPROMPT_OUTOFMEMORY     4

/* SetupSetDirectoryIdEx() flags */
#define SETDIRID_NOT_FULL_PATH  0x00000001L

/* Source information types */
#define SRCINFO_PATH            1
#define SRCINFO_TAGFILE         2
#define SRCINFO_DESCRIPTION     3
#define SRCINFO_FLAGS           4
#if (_SETUPAPI_VER >= 0x0501)
    #define SRCINFO_TAGFILE2    5
#endif

/* Source flags */
#if (_SETUPAPI_VER >= 0x0501)
    #define SRC_FLAGS_CABFILE   0x0010
#endif

/* Setup copy styles */
#define SP_COPY_DELETESOURCE            0x00000001L
#define SP_COPY_REPLACEONLY             0x00000002L
#define SP_COPY_NEWER                   0x00000004L
#define SP_COPY_NEWER_OR_SAME           SP_COPY_NEWER
#define SP_COPY_NOOVERWRITE             0x00000008L
#define SP_COPY_NODECOMP                0x00000010L
#define SP_COPY_LANGUAGEAWARE           0x00000020L
#define SP_COPY_SOURCE_ABSOLUTE         0x00000040L
#define SP_COPY_SOURCEPATH_ABSOLUTE     0x00000080L
#define SP_COPY_IN_USE_NEEDS_REBOOT     0x00000100L
#define SP_COPY_FORCE_IN_USE            0x00000200L
#define SP_COPY_NOSKIP                  0x00000400L
#define SP_COPY_CABINETCONTINUATION     0x00000800L
#define SP_COPY_FORCE_NOOVERWRITE       0x00001000L
#define SP_COPY_FORCE_NEWER             0x00002000L
#define SP_COPY_WARNIFSKIP              0x00004000L
#define SP_COPY_NOBROWSE                0x00008000L
#define SP_COPY_NEWER_ONLY              0x00010000L
#define SP_COPY_OEMINF_CATALOG_ONLY     0x00040000L
#define SP_COPY_REPLACE_BOOT_FILE       0x00080000L
#define SP_COPY_NOPRUNE                 0x00100000L
#if (_SETUPAPI_VER >= 0x0501)
    #define SP_COPY_OEM_F6_INF          0x00200000L
    #define SP_COPY_ALREADYDECOMP       0x00400000L
#endif
#if (_SETUPAPI_VER >= 0x0600)
    #define SP_COPY_WINDOWS_SIGNED      0x01000000L
    #define SP_COPY_PNPLOCKED           0x02000000L
    #define SP_COPY_IN_USE_TRY_RENAME   0x04000000L
    #define SP_COPY_INBOX_INF           0x08000000L
#endif
#if (_SETUPAPI_VER >= 0x0601)
    #define SP_COPY_HARDLINK            0x10000000L
#endif

/* Setup backup notification flags */
#if (_SETUPAPI_VER >= 0x0501)
    #define SP_BACKUP_BACKUPPASS    0x00000001L
    #define SP_BACKUP_DEMANDPASS    0x00000002L
    #define SP_BACKUP_SPECIAL       0x00000004L
    #define SP_BACKUP_BOOTFILE      0x00000008L
#endif

/* SetupScanFileQueue() flags */
#define SPQ_SCAN_FILE_PRESENCE                      0x00000001L
#define SPQ_SCAN_FILE_VALIDITY                      0x00000002L
#define SPQ_SCAN_USE_CALLBACK                       0x00000004L
#define SPQ_SCAN_USE_CALLBACKEX                     0x00000008L
#define SPQ_SCAN_INFORM_USER                        0x00000010L
#define SPQ_SCAN_PRUNE_COPY_QUEUE                   0x00000020L
#if (_SETUPAPI_VER >= 0x0501)
    #define SPQ_SCAN_USE_CALLBACK_SIGNERINFO        0x00000040L
    #define SPQ_SCAN_PRUNE_DELREN                   0x00000080L
#endif
#if (_SETUPAPI_VER >= 0x0600)
    #define SPQ_SCAN_FILE_PRESENCE_WITHOUT_SOURCE   0x00000100L
    #define SPQ_SCAN_FILE_COMPARISON                0x00000200L
    #define SPQ_SCAN_FILE_ACTIVATE_DRP              0x00000400L
#endif

/* Queue scan notification flags */
#define SPQ_DELAYED_COPY    0x00000001L

/* Setup file queue flags */
#if (_SETUPAPI_VER >= 0x0501)
    #define SPQ_FLAG_BACKUP_AWARE       0x00000001L
    #define SPQ_FLAG_ABORT_IF_UNSIGNED  0x00000002L
    #define SPQ_FLAG_FILES_MODIFIED     0x00000004L
    #define SPQ_FLAG_DO_SHUFFLEMOVE     0x00000008L
    #define SPQ_FLAG_VALID              0x0000000FL
#endif

/* Setup OEM source types */
#define SPOST_NONE  0L
#define SPOST_PATH  1L
#define SPOST_URL   2L
#define SPOST_MAX   3L

/* SetupUninstallOEMInf() flags */
#if (_SETUPAPI_VER >= 0x0501)
    #define SUOI_FORCEDELETE    0x00000001L
#endif

/* SetupCreateDiskSpaceList() flags */
#define SPDSL_IGNORE_DISK               0x00000001L
#define SPDSL_DISALLOW_NEGATIVE_ADJUST  0x00000002L

/* SetupPromptReboot() return flags */
#define SPFILEQ_FILE_IN_USE         0x00000001
#define SPFILEQ_REBOOT_RECOMMENDED  0x00000002
#define SPFILEQ_REBOOT_IN_PROGRESS  0x00000004

/* AddReg flags */
#define FLG_ADDREG_BINVALUETYPE         0x00000001
#define FLG_ADDREG_NOCLOBBER            0x00000002
#define FLG_ADDREG_DELVAL               0x00000004
#define FLG_ADDREG_APPEND               0x00000008
#define FLG_ADDREG_KEYONLY              0x00000010
#define FLG_ADDREG_OVERWRITEONLY        0x00000020
#if (_SETUPAPI_VER >= 0x0501)
    #define FLG_ADDREG_64BITKEY         0x00001000
    #define FLG_ADDREG_KEYONLY_COMMON   0x00002000
    #define FLG_ADDREG_32BITKEY         0x00004000
    #define FLG_ADDREG_DELREG_BIT       0x00008000
#endif
#define FLG_ADDREG_TYPE_SZ              0x00000000
#define FLG_ADDREG_TYPE_MULTI_SZ        0x00010000
#define FLG_ADDREG_TYPE_EXPAND_SZ       0x00020000
#define FLG_ADDREG_TYPE_BINARY          (0x00000000 | FLG_ADDREG_BINVALUETYPE)
#define FLG_ADDREG_TYPE_DWORD           (0x00010000 | FLG_ADDREG_BINVALUETYPE)
#define FLG_ADDREG_TYPE_NONE            (0x00020000 | FLG_ADDREG_BINVALUETYPE)
#define FLG_ADDREG_TYPE_MASK            (0xFFFF0000 | FLG_ADDREG_BINVALUETYPE)

/* DelReg flags */
#define FLG_DELREG_VALUE                0x00000000
#if (_SETUPAPI_VER >= 0x0501)
    #define FLG_DELREG_TYPE_MASK        FLG_ADDREG_TYPE_MASK
    #define FLG_DELREG_TYPE_SZ          FLG_ADDREG_TYPE_SZ
    #define FLG_DELREG_TYPE_MULTI_SZ    FLG_ADDREG_TYPE_MULTI_SZ
    #define FLG_DELREG_TYPE_EXPAND_SZ   FLG_ADDREG_TYPE_EXPAND_SZ
    #define FLG_DELREG_TYPE_BINARY      FLG_ADDREG_TYPE_BINARY
    #define FLG_DELREG_TYPE_DWORD       FLG_ADDREG_TYPE_DWORD
    #define FLG_DELREG_TYPE_NONE        FLG_ADDREG_TYPE_NONE
    #define FLG_DELREG_64BITKEY         FLG_ADDREG_64BITKEY
    #define FLG_DELREG_KEYONLY_COMMON   FLG_ADDREG_KEYONLY_COMMON
    #define FLG_DELREG_32BITKEY         FLG_ADDREG_32BITKEY
    #define FLG_DELREG_OPERATION_MASK   0x000000FE
    #define FLG_DELREG_MULTI_SZ_DELSTRING \
        (FLG_DELREG_TYPE_MULTI_SZ | FLG_ADDREG_DELREG_BIT | 0x00000002)
#endif

/* BitReg flags */
#define FLG_BITREG_CLEARBITS    0x00000000
#define FLG_BITREG_SETBITS      0x00000001
#if (_SETUPAPI_VER >= 0x0501)
    #define FLG_BITREG_64BITKEY 0x00001000
    #define FLG_BITREG_32BITKEY 0x00004000
#endif

/* Ini2Reg flags */
#if (_SETUPAPI_VER >= 0x0501)
    #define FLG_INI2REG_64BITKEY    0x00001000
    #define FLG_INI2REG_32BITKEY    0x00004000
#endif

/* RegSvr flags */
#define FLG_REGSVR_DLLREGISTER  0x00000001
#define FLG_REGSVR_DLLINSTALL   0x00000002

/* ProfItem flags */
#define FLG_PROFITEM_CURRENTUSER    0x00000001
#define FLG_PROFITEM_DELETE         0x00000002
#define FLG_PROFITEM_GROUP          0x00000004
#define FLG_PROFITEM_CSIDL          0x00000008

/* AddProperty flags */
#define FLG_ADDPROPERTY_NOCLOBBER       0x00000001
#define FLG_ADDPROPERTY_OVERWRITEONLY   0x00000002
#define FLG_ADDPROPERTY_APPEND          0x00000004
#define FLG_ADDPROPERTY_OR              0x00000008
#define FLG_ADDPROPERTY_AND             0x00000010

/* DelProperty flags */
#define FLG_DELPROPERTY_MULTI_SZ_DELSTRING  0x00000001

/* SetupInstallFromInfSection() flags */
#define SPINST_LOGCONFIG                    0x00000001
#define SPINST_INIFILES                     0x00000002
#define SPINST_REGISTRY                     0x00000004
#define SPINST_INI2REG                      0x00000008
#define SPINST_FILES                        0x00000010
#define SPINST_BITREG                       0x00000020
#define SPINST_REGSVR                       0x00000040
#define SPINST_UNREGSVR                     0x00000080
#define SPINST_PROFILEITEMS                 0x00000100
#if (_SETUPAPI_VER >= 0x0501)
    #define SPINST_COPYINF                  0x00000200
#endif
#if (_SETUPAPI_VER >= 0x0600)
    #define SPINST_PROPERTIES               0x00000400
    #define SPINST_ALL                      0x000007FF
#elif (_SETUPAPI_VER >= 0x0501)
    #define SPINST_ALL                      0x000003FF
#else
    #define SPINST_ALL                      0x000001FF
#endif
#define SPINST_SINGLESECTION                0x00010000
#define SPINST_LOGCONFIG_IS_FORCED          0x00020000
#define SPINST_LOGCONFIGS_ARE_OVERRIDES     0x00040000
#if (_SETUPAPI_VER >= 0x0501)
    #define SPINST_REGISTERCALLBACKAWARE    0x00080000
#endif
#if (_SETUPAPI_VER >= 0x0600)
    #define SPINST_DEVICEINSTALL            0x00100000
#endif

/* SetupInstallServicesFromInfSection() flags */
#define SPSVCINST_TAGTOFRONT                        0x00000001L
#define SPSVCINST_ASSOCSERVICE                      0x00000002L
#define SPSVCINST_DELETEEVENTLOGENTRY               0x00000004L
#define SPSVCINST_NOCLOBBER_DISPLAYNAME             0x00000008L
#define SPSVCINST_NOCLOBBER_STARTTYPE               0x00000010L
#define SPSVCINST_NOCLOBBER_ERRORCONTROL            0x00000020L
#define SPSVCINST_NOCLOBBER_LOADORDERGROUP          0x00000040L
#define SPSVCINST_NOCLOBBER_DEPENDENCIES            0x00000080L
#define SPSVCINST_NOCLOBBER_DESCRIPTION             0x00000100L
#define SPSVCINST_STOPSERVICE                       0x00000200L
#if (_SETUPAPI_VER >= 0x0501)
    #define SPSVCINST_CLOBBER_SECURITY              0x00000400L
#endif
#if (_SETUPAPI_VER >= 0x0600)
    #define SPSVCINST_STARTSERVICE                  0x00000800L
#endif
#if (_SETUPAPI_VER >= 0x0601)
    #define SPSVCINST_NOCLOBBER_REQUIREDPRIVILEGES  0x00001000L
#endif

/* SetupInitializeFileLog() flags */
#define SPFILELOG_SYSTEMLOG 0x00000001L
#define SPFILELOG_FORCENEW  0x00000002L
#define SPFILELOG_QUERYONLY 0x00000004L

/* SetupLogFile() flags */
#define SPFILELOG_OEMFILE   0x00000001L

/* Log severities */
#define LogSevInformation   0x00000000L
#define LogSevWarning       0x00000001L
#define LogSevError         0x00000002L
#define LogSevFatalError    0x00000003L
#define LogSevMaximum       0x00000004L

/* SetupDiCreateDeviceInfo() flags */
#define DICD_GENERATE_ID        0x00000001L
#define DICD_INHERIT_CLASSDRVS  0x00000002L

/* SetupDiOpenDeviceInfo() flags */
#define DIOD_INHERIT_CLASSDRVS  0x00000002L
#define DIOD_CANCEL_REMOVE      0x00000004L

/* SetupDiOpenDeviceInterface() flags */
#define DIODI_NO_ADD    0x00000001L

/* SetupDiRegisterDeviceInfo() flags */
#define SPRDI_FIND_DUPS 0x00000001L

/* Driver types */
#define SPDIT_NODRIVER      0x00000000L
#define SPDIT_CLASSDRIVER   0x00000001L
#define SPDIT_COMPATDRIVER  0x00000002L

/* SetupDiGetClassDevs() flags */
#define DIGCF_DEFAULT           0x00000001L
#define DIGCF_PRESENT           0x00000002L
#define DIGCF_ALLCLASSES        0x00000004L
#define DIGCF_PROFILE           0x00000008L
#define DIGCF_DEVICEINTERFACE   0x00000010L
#define DIGCF_INTERFACEDEVICE   DIGCF_DEVICEINTERFACE

/* SetupDiBuildClassInfoList() flags */
#define DIBCI_NOINSTALLCLASS    0x00000001L
#define DIBCI_NODISPLAYCLASS    0x00000002L

/* SetupDiOpenClassRegKeyEx() flags */
#define DIOCR_INSTALLER 0x00000001L
#define DIOCR_INTERFACE 0x00000002L
 
/* Device installer registry key types */
#define DIREG_DEV   0x00000001L
#define DIREG_DRV   0x00000002L
#define DIREG_BOTH  0x00000004L

/* Device installer class property flags */
#if (_SETUPAPI_VER >= 0x0600)
    #define DICLASSPROP_INSTALLER   0x00000001L
    #define DICLASSPROP_INTERFACE   0x00000002L
#endif

/* Setup device registry property codes */
#define SPDRP_DEVICEDESC                    0x00000000L
#define SPDRP_HARDWAREID                    0x00000001L
#define SPDRP_COMPATIBLEIDS                 0x00000002L
#define SPDRP_SERVICE                       0x00000004L
#define SPDRP_CLASS                         0x00000007L
#define SPDRP_CLASSGUID                     0x00000008L
#define SPDRP_DRIVER                        0x00000009L
#define SPDRP_CONFIGFLAGS                   0x0000000AL
#define SPDRP_MFG                           0x0000000BL
#define SPDRP_FRIENDLYNAME                  0x0000000CL
#define SPDRP_LOCATION_INFORMATION          0x0000000DL
#define SPDRP_PHYSICAL_DEVICE_OBJECT_NAME   0x0000000EL
#define SPDRP_CAPABILITIES                  0x0000000FL
#define SPDRP_UI_NUMBER                     0x00000010L
#define SPDRP_UPPERFILTERS                  0x00000011L
#define SPDRP_LOWERFILTERS                  0x00000012L
#define SPDRP_BUSTYPEGUID                   0x00000013L
#define SPDRP_LEGACYBUSTYPE                 0x00000014L
#define SPDRP_BUSNUMBER                     0x00000015L
#define SPDRP_ENUMERATOR_NAME               0x00000016L
#define SPDRP_SECURITY                      0x00000017L
#define SPDRP_SECURITY_SDS                  0x00000018L
#define SPDRP_DEVTYPE                       0x00000019L
#define SPDRP_EXCLUSIVE                     0x0000001AL
#define SPDRP_CHARACTERISTICS               0x0000001BL
#define SPDRP_ADDRESS                       0x0000001CL
#define SPDRP_UI_NUMBER_DESC_FORMAT         0x0000001DL
#define SPDRP_DEVICE_POWER_DATA             0x0000001EL
#define SPDRP_REMOVAL_POLICY                0x0000001FL
#define SPDRP_REMOVAL_POLICY_HW_DEFAULT     0x00000020L
#define SPDRP_REMOVAL_POLICY_OVERRIDE       0x00000021L
#define SPDRP_INSTALL_STATE                 0x00000022L
#define SPDRP_LOCATION_PATHS                0x00000023L
#define SPDRP_BASE_CONTAINERID              0x00000024L
#define SPDRP_MAXIMUM_PROPERTY              0x00000025L

/* Setup class registry property codes */
#define SPCRP_UPPERFILTERS      0x00000011L
#define SPCRP_LOWERFILTERS      0x00000012L
#define SPCRP_SECURITY          0x00000017L
#define SPCRP_SECURITY_SDS      0x00000018L
#define SPCRP_DEVTYPE           0x00000019L
#define SPCRP_EXCLUSIVE         0x0000001AL
#define SPCRP_CHARACTERISTICS   0x0000001BL
#define SPCRP_MAXIMUM_PROPERTY  0x0000001CL

/* SetupDiDrawMiniIcon() flags */
#define DMI_MASK    0x00000001L
#define DMI_BKCOLOR 0x00000002L
#define DMI_USERECT 0x00000004L

/* SetupDiGetClassDevPropertySheets() flags */
#define DIGCDP_FLAG_BASIC               0x00000001L
#define DIGCDP_FLAG_ADVANCED            0x00000002L
#if (_SETUPAPI_VER >= 0x0501)
    #define DIGCDP_FLAG_REMOTE_BASIC    0x00000003L
    #define DIGCDP_FLAG_REMOTE_ADVANCED 0x00000004L
#endif

/* Setup icon identifiers */
#define IDI_RESOURCEFIRST           159
#define IDI_RESOURCE                159
#define IDI_RESOURCELAST            161
#define IDI_RESOURCEOVERLAYFIRST    161
#define IDI_RESOURCEOVERLAYLAST     161
#define IDI_CONFLICT                161
#define IDI_CLASSICON_OVERLAYFIRST  500
#define IDI_CLASSICON_OVERLAYLAST   502
#define IDI_PROBLEM_OVL             500
#define IDI_DISABLED_OVL            501
#define IDI_FORCED_OVL              502

/* SetupDiGetWizardPage() page types */
#define SPWPT_SELECTDEVICE  0x00000001L

/* SetupDiGetWizardPage() flags */
#define SPWP_USE_DEVINFO_DATA   0x00000001L

/* Signer scores */
#if (_SETUPAPI_VER >= 0x0600)
    #define SIGNERSCORE_UNKNOWN         0xFF000000L
    #define SIGNERSCORE_W9X_SUSPECT     0xC0000000L
    #define SIGNERSCORE_UNSIGNED        0x80000000L
    #define SIGNERSCORE_AUTHENTICODE    0x0F000000L
    #define SIGNERSCORE_WHQL            0x0D000005L
    #define SIGNERSCORE_UNCLASSIFIED    0x0D000004L
    #define SIGNERSCORE_INBOX           0x0D000003L
    #define SIGNERSCORE_LOGO_STANDARD   0x0D000002L
    #define SIGNERSCORE_LOGO_PREMIUM    0x0D000001L
    #define SIGNERSCORE_MASK            0xFF000000L
    #define SIGNERSCORE_SIGNED_MASK     0xF0000000L
#endif

/* SetupDiGetCustomDeviceProperty() flags */
#if (_SETUPAPI_VER >= 0x0501)
    #define DICUSTOMDEVPROP_MERGE_MULTISZ   0x00000001L
#endif

/* SetupConfigureWmiFromInfSection() flags */
#if (_SETUPAPI_VER >= 0x0502)
    #define SCWMI_CLOBBER_SECURITY  0x00000001L
#endif

/* Information file context */
typedef struct _INFCONTEXT {
    PVOID   Inf;
    PVOID   CurrentInf;
    UINT    Section;
    UINT    Line;
} INFCONTEXT;
typedef INFCONTEXT  *PINFCONTEXT;

/* Setup information file information */
typedef struct _SP_INF_INFORMATION {
    DWORD   InfStyle;
    DWORD   InfCount;
    BYTE    VersionData[ANYSIZE_ARRAY];
} SP_INF_INFORMATION;
typedef SP_INF_INFORMATION  *PSP_INF_INFORMATION;

/* Setup alternate platform information (version 2) */
typedef struct _SP_ALTPLATFORM_INFO_V2 {
    DWORD   cbSize;
    DWORD   Platform;
    DWORD   MajorVersion;
    DWORD   MinorVersion;
    WORD    ProcessorArchitecture;
    union {
        WORD    Reserved;
        WORD    Flags;
    };
    DWORD   FirstValidatedMajorVersion;
    DWORD   FirstValidatedMinorVersion;
} SP_ALTPLATFORM_INFO_V2;
typedef SP_ALTPLATFORM_INFO_V2  *PSP_ALTPLATFORM_INFO_V2;

/* Setup alternate platform information (version 1) */
typedef struct _SP_ALTPLATFORM_INFO_V1 {
    DWORD   cbSize;
    DWORD   Platform;
    DWORD   MajorVersion;
    DWORD   MinorVersion;
    WORD    ProcessorArchitecture;
    WORD    Reserved;
} SP_ALTPLATFORM_INFO_V1;
typedef SP_ALTPLATFORM_INFO_V1  *PSP_ALTPLATFORM_INFO_V1;

/* Setup alternate platform information */
#if (_SETUPAPI_VER >= 0x0501)
typedef SP_ALTPLATFORM_INFO_V2  SP_ALTPLATFORM_INFO;
typedef PSP_ALTPLATFORM_INFO_V2 PSP_ALTPLATFORM_INFO;
#else
typedef SP_ALTPLATFORM_INFO_V1  SP_ALTPLATFORM_INFO;
typedef PSP_ALTPLATFORM_INFO_V1 PSP_ALTPLATFORM_INFO;
#endif

/* Setup original file information */
typedef struct _SP_ORIGINAL_FILE_INFO_A {
    DWORD   cbSize;
    CHAR    OriginalInfName[MAX_PATH];
    CHAR    OriginalCatalogName[MAX_PATH];
} SP_ORIGINAL_FILE_INFO_A;
typedef SP_ORIGINAL_FILE_INFO_A     *PSP_ORIGINAL_FILE_INFO_A;
typedef struct _SP_ORIGINAL_FILE_INFO_W {
    DWORD   cbSize;
    WCHAR   OriginalInfName[MAX_PATH];
    WCHAR   OriginalCatalogName[MAX_PATH];
} SP_ORIGINAL_FILE_INFO_W;
typedef SP_ORIGINAL_FILE_INFO_W     *PSP_ORIGINAL_FILE_INFO_W;
#ifdef UNICODE
typedef SP_ORIGINAL_FILE_INFO_W     SP_ORIGINAL_FILE_INFO;
typedef PSP_ORIGINAL_FILE_INFO_W    PSP_ORIGINAL_FILE_INFO;
#else
typedef SP_ORIGINAL_FILE_INFO_A     SP_ORIGINAL_FILE_INFO;
typedef PSP_ORIGINAL_FILE_INFO_A    PSP_ORIGINAL_FILE_INFO;
#endif

/* Setup file callback */
typedef UINT (CALLBACK *PSP_FILE_CALLBACK_A)( PVOID, UINT, UINT_PTR, UINT_PTR );
typedef UINT (CALLBACK *PSP_FILE_CALLBACK_W)( PVOID, UINT, UINT_PTR, UINT_PTR );
#ifdef UNICODE
    #define PSP_FILE_CALLBACK   PSP_FILE_CALLBACK_W
#else
    #define PSP_FILE_CALLBACK   PSP_FILE_CALLBACK_A
#endif

/* File paths */
typedef struct _FILEPATHS_A {
    PCSTR   Target;
    PCSTR   Source;
    UINT    Win32Error;
    DWORD   Flags;
} FILEPATHS_A;
typedef FILEPATHS_A     *PFILEPATHS_A;
typedef struct _FILEPATHS_W {
    PCWSTR  Target;
    PCWSTR  Source;
    UINT    Win32Error;
    DWORD   Flags;
} FILEPATHS_W;
typedef FILEPATHS_W     *PFILEPATHS_W;
#ifdef UNICODE
typedef FILEPATHS_W     FILEPATHS;
typedef PFILEPATHS_W    PFILEPATHS;
#else
typedef FILEPATHS_A     FILEPATHS;
typedef PFILEPATHS_A    PFILEPATHS;
#endif

/* File paths signer information */
#if (_SETUPAPI_VER > 0x0501)
typedef struct _FILEPATHS_SIGNERINFO_A {
    PCSTR   Target;
    PCSTR   Source;
    UINT    Win32Error;
    DWORD   Flags;
    PCSTR   DigitalSigner;
    PCSTR   Version;
    PCSTR   CatalogFile;
} FILEPATHS_SIGNERINFO_A;
typedef FILEPATHS_SIGNERINFO_A  *PFILEPATHS_SIGNERINFO_A;
typedef struct _FILEPATHS_SIGNERINFO_W {
    PCWSTR  Target;
    PCWSTR  Source;
    UINT    Win32Error;
    DWORD   Flags;
    PCWSTR  DigitalSigner;
    PCWSTR  Version;
    PCWSTR  CatalogFile;
} FILEPATHS_SIGNERINFO_W;
typedef FILEPATHS_SIGNERINFO_W  *PFILEPATHS_SIGNERINFO_W;
#ifdef UNICODE
typedef FILEPATHS_SIGNERINFO_W  FILEPATHS_SIGNERINFO;
typedef PFILEPATHS_SIGNERINFO_W PFILEPATHS_SIGNERINFO;
#else
typedef FILEPATHS_SIGNERINFO_A  FILEPATHS_SIGNERINFO;
typedef PFILEPATHS_SIGNERINFO_A PFILEPATHS_SIGNERINFO;
#endif
#endif

/* Source media information */
typedef struct _SOURCE_MEDIA_A {
    PCSTR   Reserved;
    PCSTR   Tagfile;
    PCSTR   Description;
    PCSTR   SourcePath;
    PCSTR   SourceFile;
    DWORD   Flags;
} SOURCE_MEDIA_A;
typedef SOURCE_MEDIA_A  *PSOURCE_MEDIA_A;
typedef struct _SOURCE_MEDIA_W {
    PCWSTR  Reserved;
    PCWSTR  Tagfile;
    PCWSTR  Description;
    PCWSTR  SourcePath;
    PCWSTR  SourceFile;
    DWORD   Flags;
} SOURCE_MEDIA_W;
typedef SOURCE_MEDIA_W  *PSOURCE_MEDIA_W;
#ifdef UNICODE
typedef SOURCE_MEDIA_W  SOURCE_MEDIA;
typedef PSOURCE_MEDIA_W PSOURCE_MEDIA;
#else
typedef SOURCE_MEDIA_A  SOURCE_MEDIA;
typedef PSOURCE_MEDIA_A PSOURCE_MEDIA;
#endif

/* Cabinet information */
typedef struct _CABINET_INFOA {
    PCSTR   CabinetPath;
    PCSTR   CabinetFile;
    PCSTR   DiskName;
    USHORT  SetId;
    USHORT  CabinetNumber;
} CABINET_INFOA;
typedef CABINET_INFOA   *PCABINET_INFOA;
typedef struct _CABINET_INFOW {
    PCWSTR  CabinetPath;
    PCWSTR  CbainetFile;
    PCWSTR  DiskName;
    USHORT  SetId;
    USHORT  CabinetNumber;
} CABINET_INFOW;
typedef CABINET_INFOW   *PCABINET_INFOW;
#ifdef UNICODE
typedef CABINET_INFOW   CABINET_INFO;
typedef PCABINET_INFOW  PCABINET_INFO;
#else
typedef CABINET_INFOA   CABINET_INFO;
typedef PCABINET_INFOA  PCABINET_INFO;
#endif

/* File in cabinet information */
typedef struct _FILE_IN_CABINET_INFO_A {
    PCSTR   NameInCabinet;
    DWORD   FileSize;
    DWORD   Win32Error;
    WORD    DosDate;
    WORD    DosTime;
    WORD    DosAttribs;
    CHAR    FullTargetName[MAX_PATH];
} FILE_IN_CABINET_INFO_A;
typedef FILE_IN_CABINET_INFO_A  *PFILE_IN_CABINET_INFO_A;
typedef struct _FILE_IN_CABINET_INFO_W {
    PCWSTR  NameInCabinet;
    DWORD   FileSize;
    DWORD   Win32Error;
    WORD    DosDate;
    WORD    DosTime;
    WORD    DosAttribs;
    WCHAR   FullTargetName[MAX_PATH];
} FILE_IN_CABINET_INFO_W;
typedef FILE_IN_CABINET_INFO_W  *PFILE_IN_CABINET_INFO_W;
#ifdef UNICODE
typedef FILE_IN_CABINET_INFO_W  FILE_IN_CABINET_INFO;
typedef PFILE_IN_CABINET_INFO_W PFILE_IN_CABINET_INFO;
#else
typedef FILE_IN_CABINET_INFO_A  FILE_IN_CABINET_INFO;
typedef PFILE_IN_CABINET_INFO_A PFILE_IN_CABINET_INFO;
#endif

/* Setup register control status */
typedef struct _SP_REGISTER_CONTROL_STATUSA {
    DWORD   cbSize;
    PCSTR   FileName;
    DWORD   Win32Error;
    DWORD   FailureCode;
} SP_REGISTER_CONTROL_STATUSA;
typedef SP_REGISTER_CONTROL_STATUSA     *PSP_REGISTER_CONTROL_STATUSA;
typedef struct _SP_REGISTER_CONTROL_STATUSW {
    DWORD   cbSize;
    PCWSTR  FileName;
    DWORD   Win32Error;
    DWORD   FailureCode;
} SP_REGISTER_CONTROL_STATUSW;
typedef SP_REGISTER_CONTROL_STATUSW     *PSP_REGISTER_CONTROL_STATUSW;
#ifdef UNICODE
typedef SP_REGISTER_CONTROL_STATUSW     SP_REGISTER_CONTROL_STATUS;
typedef PSP_REGISTER_CONTROL_STATUSW    PSP_REGISTER_CONTROL_STATUS;
#else
typedef SP_REGISTER_CONTROL_STATUSA     SP_REGISTER_CONTROL_STATUS;
typedef PSP_REGISTER_CONTROL_STATUSA    PSP_REGISTER_CONTROL_STATUS;
#endif

/* Setup file copy parameters */
typedef struct _SP_FILE_COPY_PARAMS_A {
    DWORD       cbSize;
    HSPFILEQ    QueueHandle;
    PCSTR       SourceRootPath;
    PCSTR       SourcePath;
    PCSTR       SourceFilename;
    PCSTR       SourceDescription;
    PCSTR       SourceTagfile;
    PCSTR       TargetDirectory;
    PCSTR       TargetFilename;
    DWORD       CopyStyle;
    HINF        LayoutInf;
    PCSTR       SecurityDescriptor;
} SP_FILE_COPY_PARAMS_A;
typedef SP_FILE_COPY_PARAMS_A   *PSP_FILE_COPY_PARAMS_A;
typedef struct _SP_FILE_COPY_PARAMS_W {
    DWORD       cbSize;
    HSPFILEQ    QueueHandle;
    PCWSTR      SourceRootPath;
    PCWSTR      SourcePath;
    PCWSTR      SourceFilename;
    PCWSTR      SourceDescription;
    PCWSTR      SourceTagfile;
    PCWSTR      TargetDirectory;
    PCWSTR      TargetFilename;
    DWORD       CopyStyle;
    HINF        LayoutInf;
    PCWSTR      SecurityDescriptor;
} SP_FILE_COPY_PARAMS_W;
typedef SP_FILE_COPY_PARAMS_W   *PSP_FILE_COPY_PARAMS_W;
#ifdef UNICODE
typedef SP_FILE_COPY_PARAMS_W   SP_FILE_COPY_PARAMS;
typedef PSP_FILE_COPY_PARAMS_W  PSP_FILE_COPY_PARAMS;
#else
typedef SP_FILE_COPY_PARAMS_A   SP_FILE_COPY_PARAMS;
typedef PSP_FILE_COPY_PARAMS_A  PSP_FILE_COPY_PARAMS;
#endif

/* Setup device information data */
typedef struct _SP_DEVINFO_DATA {
    DWORD       cbSize;
    GUID        ClassGuid;
    DWORD       DevInst;
    ULONG_PTR   Reserved;
} SP_DEVINFO_DATA;
typedef SP_DEVINFO_DATA *PSP_DEVINFO_DATA;

/* Setup device interface data */
typedef struct _SP_DEVICE_INTERFACE_DATA {
    DWORD       cbSize;
    GUID        InterfaceClassGuid;
    DWORD       Flags;
    ULONG_PTR   Reserved;
} SP_DEVICE_INTERFACE_DATA;
typedef SP_DEVICE_INTERFACE_DATA    *PSP_DEVICE_INTERFACE_DATA;
typedef SP_DEVICE_INTERFACE_DATA    SP_INTERFACE_DEVICE_DATA;
typedef SP_DEVICE_INTERFACE_DATA    *PSP_INTERFACE_DEVICE_DATA;

/* Setup device interface detail data */
typedef struct _SP_DEVICE_INTERFACE_DETAIL_DATA_A {
    DWORD   cbSize;
    CHAR    DevicePath[ANYSIZE_ARRAY];
} SP_DEVICE_INTERFACE_DETAIL_DATA_A;
typedef SP_DEVICE_INTERFACE_DETAIL_DATA_A   *PSP_DEVICE_INTERFACE_DETAIL_DATA_A;
typedef SP_DEVICE_INTERFACE_DETAIL_DATA_A   SP_INTERFACE_DEVICE_DETAIL_DATA_A;
typedef SP_DEVICE_INTERFACE_DETAIL_DATA_A   *PSP_INTERFACE_DEVICE_DETAIL_DATA_A;
typedef struct _SP_DEVICE_INTERFACE_DETAIL_DATA_W {
    DWORD   cbSize;
    WCHAR   DevicePath[ANYSIZE_ARRAY];
} SP_DEVICE_INTERFACE_DETAIL_DATA_W;
typedef SP_DEVICE_INTERFACE_DETAIL_DATA_W   *PSP_DEVICE_INTERFACE_DETAIL_DATA_W;
typedef SP_DEVICE_INTERFACE_DETAIL_DATA_W   SP_INTERFACE_DEVICE_DETAIL_DATA_W;
typedef SP_DEVICE_INTERFACE_DETAIL_DATA_W   *PSP_INTERFACE_DEVICE_DETAIL_DATA_W;
#ifdef UNICODE
typedef SP_DEVICE_INTERFACE_DETAIL_DATA_W   SP_DEVICE_INTERFACE_DETAIL_DATA;
typedef PSP_DEVICE_INTERFACE_DETAIL_DATA_W  PSP_DEVICE_INTERFACE_DETAIL_DATA;
typedef SP_INTERFACE_DEVICE_DETAIL_DATA_W   SP_INTERFACE_DEVICE_DETAIL_DATA;
typedef PSP_INTERFACE_DEVICE_DETAIL_DATA_W  PSP_INTERFACE_DEVICE_DETAIL_DATA;
#else
typedef SP_DEVICE_INTERFACE_DETAIL_DATA_A   SP_DEVICE_INTERFACE_DETAIL_DATA;
typedef PSP_DEVICE_INTERFACE_DETAIL_DATA_A  PSP_DEVICE_INTERFACE_DETAIL_DATA;
typedef SP_INTERFACE_DEVICE_DETAIL_DATA_A   SP_INTERFACE_DEVICE_DETAIL_DATA;
typedef PSP_INTERFACE_DEVICE_DETAIL_DATA_A  PSP_INTERFACE_DEVICE_DETAIL_DATA;
#endif

/* Setup device information list detail data */
typedef struct _SP_DEVINFO_LIST_DETAIL_DATA_A {
    DWORD   dwSize;
    GUID    ClassGuid;
    HANDLE  RemoteMachineHandle;
    CHAR    RemoteMachineName[SP_MAX_MACHINENAME_LENGTH];
} SP_DEVINFO_LIST_DETAIL_DATA_A;
typedef SP_DEVINFO_LIST_DETAIL_DATA_A   *PSP_DEVINFO_LIST_DETAIL_DATA_A;
typedef struct _SP_DEVINFO_LIST_DETAIL_DATA_W {
    DWORD   dwSize;
    GUID    ClassGuid;
    HANDLE  RemoteMachineHandle;
    WCHAR   RemoteMachineName[SP_MAX_MACHINENAME_LENGTH];
} SP_DEVINFO_LIST_DETAIL_DATA_W;
typedef SP_DEVINFO_LIST_DETAIL_DATA_W   *PSP_DEVINFO_LIST_DETAIL_DATA_W;
#ifdef UNICODE
typedef SP_DEVINFO_LIST_DETAIL_DATA_W   SP_DEVINFO_LIST_DETAIL_DATA_W;
typedef PSP_DEVINFO_LIST_DETAIL_DATA_W  PSP_DEVINFO_LIST_DETAIL_DATA_W;
#else
typedef SP_DEVINFO_LIST_DETAIL_DATA_A   SP_DEVINFO_LIST_DETAIL_DATA_A;
typedef PSP_DEVINFO_LIST_DETAIL_DATA_A  PSP_DEVINFO_LIST_DETAIL_DATA_A;
#endif

/* Setup device install parameters */
typedef struct _SP_DEVINSTALL_PARAMS_A {
    DWORD               cbSize;
    DWORD               Flags;
    DWORD               FlagsEx;
    HWND                hwndParent;
    PSP_FILE_CALLBACK   InstallMsgHandler;
    PVOID               InstallMsgHandlerContext;
    HSPFILEQ            FileQueue;
    ULONG_PTR           ClassInstallReserved;
    DWORD               Reserved;
    CHAR                DriverPath[MAX_PATH];
} SP_DEVINSTALL_PARAMS_A;
typedef SP_DEVINSTALL_PARAMS_A  *PSP_DEVINSTALL_PARAMS_A;
typedef struct _SP_DEVINSTALL_PARAMS_W {
    DWORD               cbSize;
    DWORD               Flags;
    DWORD               FlagsEx;
    HWND                hwndParent;
    PSP_FILE_CALLBACK   InstallMsgHandler;
    PVOID               InstallMsgHandlerContext;
    HSPFILEQ            FileQueue;
    ULONG_PTR           ClassInstallReserved;
    DWORD               Reserved;
    WCHAR               DriverPath[MAX_PATH];
} SP_DEVINSTALL_PARAMS_W;
typedef SP_DEVINSTALL_PARAMS_W  *PSP_DEVINSTALL_PARAMS_W;
#ifdef UNICODE
typedef SP_DEVINSTALL_PARAMS_W  SP_DEVINSTALL_PARAMS;
typedef PSP_DEVINSTALL_PARAMS_W PSP_DEVINSTALL_PARAMS;
#else
typedef SP_DEVINSTALL_PARAMS_A  SP_DEVINSTALL_PARAMS;
typedef PSP_DEVINSTALL_PARAMS_A PSP_DEVINSTALL_PARAMS;
#endif

/* Setup class install header */
typedef struct _SP_CLASSINSTALL_HEADER {
    DWORD       cbSize;
    DI_FUNCTION InstallFunction;
} SP_CLASSINSTALL_HEADER;
typedef SP_CLASSINSTALL_HEADER  *PSP_CLASSINSTALL_HEADER;

/* Setup enable class parameters */
typedef struct _SP_ENABLECLASS_PARAMS {
    SP_CLASSINSTALL_HEADER  ClassInstallHeader;
    GUID                    ClassGuid;
    DWORD                   EnableMessage;
} SP_ENABLECLASS_PARAMS;
typedef SP_ENABLECLASS_PARAMS   *PSP_ENABLECLASS_PARAMS;

/* Setup property change parameters */
typedef struct _SP_PROPCHANGE_PARAMS {
    SP_CLASSINSTALL_HEADER  ClassInstallHeader;
    DWORD                   StateChange;
    DWORD                   Scope;
    DWORD                   HwProfile;
} SP_PROPCHANGE_PARAMS;
typedef SP_PROPCHANGE_PARAMS    *PSP_PROPCHANGE_PARAMS;

/* Setup remove device parameters */
typedef struct _SP_REMOVEDEVICE_PARAMS {
    SP_CLASSINSTALL_HEADER  ClassInstallHeader;
    DWORD                   Scope;
    DWORD                   HwProfile;
} SP_REMOVEDEVICE_PARAMS;
typedef SP_REMOVEDEVICE_PARAMS  *PSP_REMOVEDEVICE_PARAMS;

/* Setup unremove device prameters */
typedef struct _SP_UNREMOVEDEVICE_PARAMS {
    SP_CLASSINSTALL_HEADER  ClassInstallHeader;
    DWORD                   Scope;
    DWORD                   HwProfile;
} SP_UNREMOVEDEVICE_PARAMS;
typedef SP_UNREMOVEDEVICE_PARAMS    *PSP_UNREMOVEDEVICE_PARAMS;

/* Setup select device parameters */
typedef struct _SP_SELECTDEVICE_PARAMS_A {
    SP_CLASSINSTALL_HEADER  ClassInstallHeader;
    CHAR                    Title[MAX_TITLE_LEN];
    CHAR                    Instructions[MAX_INSTRUCTION_LEN];
    CHAR                    ListLabel[MAX_LABEL_LEN];
    CHAR                    SubTitle[MAX_SUBTITLE_LEN];
    BYTE                    Reserved[2];
} SP_SELECTDEVICE_PARAMS_A;
typedef SP_SELECTDEVICE_PARAMS_A    *PSP_SELECTDEVICE_PARAMS_A;
typedef struct _SP_SELECTDEVICE_PARAMS_W {
    SP_CLASSINSTALL_HEADER  ClassInstallHeader;
    WCHAR                   Title[MAX_TITLE_LEN];
    WCHAR                   Instructions[MAX_INSTRUCTION_LEN];
    WCHAR                   ListLabel[MAX_LABEL_LEN];
    WCHAR                   SubTitle[MAX_SUBTITLE_LEN];
    BYTE                    Reserved[2];
} SP_SELECTDEVICE_PARAMS_W;
typedef SP_SELECTDEVICE_PARAMS_W    *PSP_SELECTDEVICE_PARAMS_W;
#ifdef UNICODE
typedef SP_SELECTDEVICE_PARAMS_W    SP_SELECTDEVICE_PARAMS;
typedef PSP_SELECTDEVICE_PARAMS_W   PSP_SELECTDEVICE_PARAMS;
#else
typedef SP_SELECTDEVICE_PARAMS_A    SP_SELECTDEVICE_PARAMS;
typedef PSP_SELECTDEVICE_PARAMS_A   PSP_SELECTDEVICE_PARAMS;
#endif

/* Detect progress notify callback */
typedef BOOL (CALLBACK *PDETECT_PROGRESS_NOTIFY)( PVOID, DWORD );

/* Setup detect device parameters */
typedef struct _SP_DETECTDEVICE_PARAMS {
    SP_CLASSINSTALL_HEADER  ClassInstallHeader;
    PDETECT_PROGRESS_NOTIFY DetectProgressNotify;
    PVOID                   ProgressNotifyParam;
} SP_DETECTDEVICE_PARAMS;
typedef SP_DETECTDEVICE_PARAMS  *PSP_DETECTDEVICE_PARAMS;

/* Setup install wizard data */
typedef struct _SP_INSTALLWIZARD_DATA {
    SP_CLASSINSTALL_HEADER  ClassInstallHeader;
    DWORD                   Flags;
    HPROPSHEETPAGE          DynamicPages[MAX_INSTALLWIZARD_DYNAPAGES];
    DWORD                   NumDynamicPages;
    DWORD                   DynamicPageFlags;
    DWORD                   PrivateFlags;
    LPARAM                  PrivateData;
    HWND                    hwndWizardDlg;
} SP_INSTALLWIZARD_DATA;
typedef SP_INSTALLWIZARD_DATA   *PSP_INSTALLWIZARD_DATA;

/* Setup New Device Wizard data */
typedef struct _SP_NEWDEVICEWIZARD_DATA {
    SP_CLASSINSTALL_HEADER  ClassInstallHeader;
    DWORD                   Flags;
    HPROPSHEETPAGE          DynamicPages[MAX_INSTALLWIZARD_DYNAPAGES];
    DWORD                   NumDynamicPages;
    HWND                    hwndWizardDlg;
} SP_NEWDEVICEWIZARD_DATA;
typedef SP_NEWDEVICEWIZARD_DATA *PSP_NEWDEVICEWIZARD_DATA;
typedef SP_NEWDEVICEWIZARD_DATA SP_ADDPROPERTYPAGE_DATA;
typedef SP_NEWDEVICEWIZARD_DATA *PSP_ADDPROPERTYPAGE_DATA;

/* Setup troubleshooter parameters */
typedef struct _SP_TROUBLESHOOTER_PARAMS_A {
    SP_CLASSINSTALL_HEADER  ClassInstallHeader;
    CHAR                    ChmFile[MAX_PATH];
    CHAR                    HtmlTroubleShooter[MAX_PATH];
} SP_TROUBLESHOOTER_PARAMS_A;
typedef SP_TROUBLESHOOTER_PARAMS_A  *PSP_TROUBLESHOOTER_PARAMS_A;
typedef struct _SP_TROUBLESHOOTER_PARAMS_W {
    SP_CLASSINSTALL_HEADER  ClassInstallHeader;
    WCHAR                   ChmFile[MAX_PATH];
    WCHAR                   HtmlTroubleShooter[MAX_PATH];
} SP_TROUBLESHOOTER_PARAMS_W;
typedef SP_TROUBLESHOOTER_PARAMS_W  *PSP_TROUBLESHOOTER_PARAMS_W;
#ifdef UNICODE
typedef SP_TROUBLESHOOTER_PARAMS_W  SP_TROUBLESHOOTER_PARAMS;
typedef PSP_TROUBLESHOOTER_PARAMS_W PSP_TROUBLESHOOTER_PARAMS;
#else
typedef SP_TROUBLESHOOTER_PARAMS_A  SP_TROUBLESHOOTER_PARAMS;
typedef PSP_TROUBLESHOOTER_PARAMS_A PSP_TROUBLESHOOTER_PARAMS;
#endif

/* Setup power message wake parameters */
typedef struct _SP_POWERMESSAGEWAKE_PARAMS_A {
    SP_CLASSINSTALL_HEADER  ClassInstallHeader;
    CHAR                    PowerMessageWake[LINE_LEN * 2];
} SP_POWERMESSAGEWAKE_PARAMS_A;
typedef SP_POWERMESSAGEWAKE_PARAMS_A    *PSP_POWERMESSAGEWAKE_PARAMS_A;
typedef struct _SP_POWERMESSAGEWAKE_PARAMS_W {
    SP_CLASSINSTALL_HEADER  ClassInstallHeader;
    WCHAR                   PowerMessageWake[LINE_LEN * 2];
} SP_POWERMESSAGEWAKE_PARAMS_W;
typedef SP_POWERMESSAGEWAKE_PARAMS_W    *PSP_POWERMESSAGEWAKE_PARAMS_W;
#ifdef UNICODE
typedef SP_POWERMESSAGEWAKE_PARAMS_W    SP_POWERMESSAGEWAKE_PARAMS;
typedef PSP_POWERMESSAGEWAKE_PARAMS_W   PSP_POWERMESSAGEWAKE_PARAMS;
#else
typedef SP_POWERMESSAGEWAKE_PARAMS_A    SP_POWERMESSAGEWAKE_PARAMS;
typedef PSP_POWERMESSAGEWAKE_PARAMS_A   PSP_POWERMESSAGEWAKE_PARAMS;
#endif

/* Setup driver information data (version 2) */
typedef struct _SP_DRVINFO_DATA_V2_A {
    DWORD       cbSize;
    DWORD       DriverType;
    ULONG_PTR   Reserved;
    CHAR        Description[LINE_LEN];
    CHAR        MfgName[LINE_LEN];
    CHAR        ProviderName[LINE_LEN];
    FILETIME    DriverDate;
    DWORDLONG   DriverVersion;
} SP_DRVINFO_DATA_V2_A;
typedef SP_DRVINFO_DATA_V2_A    *PSP_DRVINFO_DATA_V2_A;
typedef struct _SP_DRVINFO_DATA_V2_W {
    DWORD       cbSize;
    DWORD       DriverType;
    ULONG_PTR   Reserved;
    WCHAR       Description[LINE_LEN];
    WCHAR       MfgName[LINE_LEN];
    WCHAR       ProviderName[LINE_LEN];
    FILETIME    DriverDate;
    DWORDLONG   DriverVersion;
} SP_DRVINFO_DATA_V2_W;
typedef SP_DRVINFO_DATA_V2_W    *PSP_DRVINFO_DATA_V2_W;
#ifdef UNICODE
typedef SP_DRVINFO_DATA_V2_W    SP_DRVINFO_DATA_V2;
typedef PSP_DRVINFO_DATA_V2_W   PSP_DRVINFO_DATA_V2;
#else
typedef SP_DRVINFO_DATA_V2_A    SP_DRVINFO_DATA_V2;
typedef PSP_DRVINFO_DATA_V2_A   PSP_DRVINFO_DATA_V2;
#endif

/* Setup driver information data (version 1) */
typedef struct _SP_DRVINFO_DATA_V1_A {
    DWORD       cbSize;
    DWORD       DriverType;
    ULONG_PTR   Reserved;
    CHAR        Description[LINE_LEN];
    CHAR        MfgName[LINE_LEN];
    CHAR        ProviderName[LINE_LEN];
} SP_DRVINFO_DATA_V1_A;
typedef SP_DRVINFO_DATA_V1_A    *PSP_DRVINFO_DATA_V1_A;
typedef struct _SP_DRVINFO_DATA_V1_W {
    DWORD       cbSize;
    DWORD       DriverType;
    ULONG_PTR   Reserved;
    WCHAR       Description[LINE_LEN];
    WCHAR       MfgName[LINE_LEN];
    WCHAR       ProviderName[LINE_LEN];
} SP_DRVINFO_DATA_V1_W;
typedef SP_DRVINFO_DATA_V1_W    *PSP_DRVINFO_DATA_V1_W;
#ifdef UNICODE
typedef SP_DRVINFO_DATA_V1_W    SP_DRVINFO_DATA_V1;
typedef PSP_DRVINFO_DATA_V1_W   PSP_DRVINFO_DATA_V1;
#else
typedef SP_DRVINFO_DATA_V1_A    SP_DRVINFO_DATA_V1;
typedef PSP_DRVINFO_DATA_V1_A   PSP_DRVINFO_DATA_V1;
#endif

/* Setup driver information data */
#if (_SETUPAPI_VER >= 0x0500)
typedef SP_DRVINFO_DATA_V2_A    SP_DRVINFO_DATA_A;
typedef PSP_DRVINFO_DATA_V2_A   PSP_DRVINFO_DATA_A;
typedef SP_DRVINFO_DATA_V2_W    SP_DRVINFO_DATA_W;
typedef PSP_DRVINFO_DATA_V2_W   PSP_DRVINFO_DATA_W;
typedef SP_DRVINFO_DATA_V2      SP_DRVINFO_DATA;
typedef PSP_DRVINFO_DATA_V2     PSP_DRVINFO_DATA;
#else
typedef SP_DRVINFO_DATA_V1_A    SP_DRVINFO_DATA_A;
typedef PSP_DRVINFO_DATA_V1_A   PSP_DRVINFO_DATA_A;
typedef SP_DRVINFO_DATA_V2_W    SP_DRVINFO_DATA_W;
typedef PSP_DRVINFO_DATA_V2_W   PSP_DRVINFO_DATA_W;
typedef SP_DRVINFO_DATA_V2      SP_DRVINFO_DATA;
typedef PSP_DRVINFO_DATA_V2     PSP_DRVINFO_DATA;
#endif

/* Setup driver information detail data */
typedef struct _SP_DRVINFO_DETAIL_DATA_A {
    DWORD       cbSize;
    FILETIME    InfDate;
    DWORD       CompatIDsOffset;
    DWORD       CompatIDsLength;
    ULONG_PTR   Reserved;
    CHAR        SectionName[LINE_LEN];
    CHAR        InfFileName[MAX_PATH];
    CHAR        DrvDescription[LINE_LEN];
    CHAR        HardwareID[ANYSIZE_ARRAY];
} SP_DRVINFO_DETAIL_DATA_A;
typedef SP_DRVINFO_DETAIL_DATA_A    *PSP_DRVINFO_DETAIL_DATA_A;
typedef struct _SP_DRVINFO_DETAIL_DATA_W {
    DWORD       cbSize;
    FILETIME    InfDate;
    DWORD       CompatIDsOffset;
    DWORD       CompatIDsLength;
    ULONG_PTR   Reserved;
    WCHAR       SectionName[LINE_LEN];
    WCHAR       InfFileName[MAX_PATH];
    WCHAR       DrvDescription[LINE_LEN];
    WCHAR       HardwareID[ANYSIZE_ARRAY];
} SP_DRVINFO_DETAIL_DATA_W;
typedef SP_DRVINFO_DETAIL_DATA_W    *PSP_DRVINFO_DETAIL_DATA_W;
#ifdef UNICODE
typedef SP_DRVINFO_DETAIL_DATA_W    SP_DRVINFO_DETAIL_DATA;
typedef PSP_DRVINFO_DETAIL_DATA_W   PSP_DRVINFO_DETAIL_DATA;
#else
typedef SP_DRVINFO_DETAIL_DATA_W    SP_DRVINFO_DETAIL_DATA;
typedef PSP_DRVINFO_DETAIL_DATA_W   PSP_DRVINFO_DETAIL_DATA;
#endif

/* Setup driver installation parameters */
typedef struct _SP_DRVINSTALL_PARAMS {
    DWORD       cbSize;
    DWORD       Rank;
    DWORD       Flags;
    DWORD_PTR   PrivateData;
    DWORD       Reserved;
} SP_DRVINSTALL_PARAMS;
typedef SP_DRVINSTALL_PARAMS    *PSP_DRVINSTALL_PARAMS;

/* Setup detection signature compare procedure */
typedef DWORD (CALLBACK *PSP_DETSIG_CMPPROC)( HDEVINFO, PSP_DEVINFO_DATA, PSP_DEVINFO_DATA, PVOID );

/* Coinstaller context data */
typedef struct _COINSTALLER_CONTEXT_DATA {
    BOOL    PostProcessing;
    DWORD   InstallResult;
    PVOID   PrivateData;
} COINSTALLER_CONTEXT_DATA;
typedef COINSTALLER_CONTEXT_DATA    *PCOINSTALLER_CONTEXT_DATA;

/* Setup class image list data */
typedef struct _SP_CLASSIMAGELIST_DATA {
    DWORD       cbSize;
    HIMAGELIST  ImageList;
    ULONG_PTR   Reserved;
} SP_CLASSIMAGELIST_DATA;
typedef SP_CLASSIMAGELIST_DATA  *PSP_CLASSIMAGELIST_DATA;

/* Setup property sheet page request */
typedef struct _SP_PROPSHEETPAGE_REQUEST {
    DWORD               cbSize;
    DWORD               PageRequested;
    HDEVINFO            DeviceInfoSet;
    PSP_DEVINFO_DATA    DeviceInfoData;
} SP_PROPSHEETPAGE_REQUEST;
typedef SP_PROPSHEETPAGE_REQUEST    *PSP_PROPSHEETPAGE_REQUEST;

/* Setup backup queue parameters (version 2) */
typedef struct _SP_BACKUP_QUEUE_PARAMS_V2_A {
    DWORD   cbSize;
    CHAR    FullInfPath[MAX_PATH];
    INT     FilenameOffset;
    CHAR    ReinstallInstance[MAX_PATH];
} SP_BACKUP_QUEUE_PARAMS_V2_A;
typedef SP_BACKUP_QUEUE_PARAMS_V2_A     *PSP_BACKUP_QUEUE_PARAMS_V2_A;
typedef struct _SP_BACKUP_QUEUE_PARAMS_V2_W {
    DWORD   cbSize;
    WCHAR   FullInfPath[MAX_PATH];
    INT     FilenameOffset;
    WCHAR   ReinstallInstance[MAX_PATH];
} SP_BACKUP_QUEUE_PARAMS_V2_W;
typedef SP_BACKUP_QUEUE_PARAMS_V2_W     *PSP_BACKUP_QUEUE_PARAMS_V2_W;
#ifdef UNICODE
typedef SP_BACKUP_QUEUE_PARAMS_V2_W     SP_BACKUP_QUEUE_PARAMS_V2;
typedef PSP_BACKUP_QUEUE_PARAMS_V2_W    PSP_BACKUP_QUEUE_PARAMS_V2;
#else
typedef SP_BACKUP_QUEUE_PARAMS_V2_A     SP_BACKUP_QUEUE_PARAMS_V2;
typedef PSP_BACKUP_QUEUE_PARAMS_V2_A    PSP_BACKUP_QUEUE_PARAMS_V2;
#endif

/* Setup backup queue parameters (version 1) */
typedef struct _SP_BACKUP_QUEUE_PARAMS_V1_A {
    DWORD   cbSize;
    CHAR    FullInfPath[MAX_PATH];
    INT     FilenameOffset;
} SP_BACKUP_QUEUE_PARAMS_V1_A;
typedef SP_BACKUP_QUEUE_PARAMS_V1_A     *PSP_BACKUP_QUEUE_PARAMS_V1_A;
typedef struct _SP_BACKUP_QUEUE_PARAMS_V1_W {
    DWORD   cbSize;
    WCHAR   FullInfPath[MAX_PATH];
    INT     FilenameOffset;
} SP_BACKUP_QUEUE_PARAMS_V1_W;
typedef SP_BACKUP_QUEUE_PARAMS_V1_W     *PSP_BACKUP_QUEUE_PARAMS_V1_W;
#ifdef UNICODE
typedef SP_BACKUP_QUEUE_PARAMS_V1_W     SP_BACKUP_QUEUE_PARAMS_V1;
typedef PSP_BACKUP_QUEUE_PARAMS_V1_W    PSP_BACKUP_QUEUE_PARAMS_V1;
#else
typedef SP_BACKUP_QUEUE_PARAMS_V1_A     SP_BACKUP_QUEUE_PARAMS_V1;
typedef PSP_BACKUP_QUEUE_PARAMS_V1_A    PSP_BACKUP_QUEUE_PARAMS_V1;
#endif

/* Setup backup queue parameters */
#if (_SETUPAPI_VER >= 0x0501)
typedef SP_BACKUP_QUEUE_PARAMS_V2_A     SP_BACKUP_QUEUE_PARAMS_A;
typedef PSP_BACKUP_QUEUE_PARAMS_V2_A    PSP_BACKUP_QUEUE_PARAMS_A;
typedef SP_BACKUP_QUEUE_PARAMS_V2_W     SP_BACKUP_QUEUE_PARAMS_W;
typedef PSP_BACKUP_QUEUE_PARAMS_V2_W    PSP_BACKUP_QUEUE_PARAMS_W;
typedef SP_BACKUP_QUEUE_PARAMS_V2       SP_BACKUP_QUEUE_PARAMS;
typedef PSP_BACKUP_QUEUE_PARAMS_V2      PSP_BACKUP_QUEUE_PARAMS;
#else
typedef SP_BACKUP_QUEUE_PARAMS_V1_A     SP_BACKUP_QUEUE_PARAMS_A;
typedef PSP_BACKUP_QUEUE_PARAMS_V1_A    PSP_BACKUP_QUEUE_PARAMS_A;
typedef SP_BACKUP_QUEUE_PARAMS_V1_W     SP_BACKUP_QUEUE_PARAMS_W;
typedef PSP_BACKUP_QUEUE_PARAMS_V1_W    PSP_BACKUP_QUEUE_PARAMS_W;
typedef SP_BACKUP_QUEUE_PARAMS_V1       SP_BACKUP_QUEUE_PARAMS;
typedef PSP_BACKUP_QUEUE_PARAMS_V1      PSP_BACKUP_QUEUE_PARAMS;
#endif

/* SetupQueryFileLog() information types */
typedef enum {
    SetupFileLogSourceFilename  = 0,
    SetupFileLogChecksum        = 1,
    SetupFileLogDiskTagfile     = 2,
    SetupFileLogDiskDescription = 3,
    SetupFileLogOtherInfo       = 4,
    SetupFileLogMax             = 5
} SetupFileLogInfo;

/* Setup information signer information (version 1) */
#if (_SETUPAPI_VER >= 0x0501)
typedef struct _SP_INF_SIGNER_INFO_V1_A {
    DWORD   cbSize;
    CHAR    CatalogFile[MAX_PATH];
    CHAR    DigitalSigner[MAX_PATH];
    CHAR    DigitalSignerVersion[MAX_PATH];
} SP_INF_SIGNER_INFO_V1_A;
typedef SP_INF_SIGNER_INFO_V1_A     *PSP_INF_SIGNER_INFO_V1_A;
typedef struct _SP_INF_SIGNER_INFO_V1_W {
    DWORD   cbSize;
    WCHAR   CatalogFile[MAX_PATH];
    WCHAR   DigitalSigner[MAX_PATH];
    WCHAR   DigitalSignerVersion[MAX_PATH];
} SP_INF_SIGNER_INFO_V1_W;
typedef SP_INF_SIGNER_INFO_V1_W     *PSP_INF_SIGNER_INFO_V1_W;
#ifdef UNICODE
typedef SP_INF_SIGNER_INFO_V1_W     SP_INF_SIGNER_INFO_V1;
typedef PSP_INF_SIGNER_INFO_V1_W    PSP_INF_SIGNER_INFO_V1;
#else
typedef SP_INF_SIGNER_INFO_V1_A     SP_INF_SIGNER_INFO_V1;
typedef PSP_INF_SIGNER_INFO_V1_A    PSP_INF_SIGNER_INFO_V1;
#endif
#endif

/* Setup information signer information (version 2) */
#if (_SETUPAPI_VER >= 0x0600)
typedef struct _SP_INF_SIGNER_INFO_V2_A {
    DWORD   cbSize;
    CHAR    CatalogFile[MAX_PATH];
    CHAR    DigitalSigner[MAX_PATH];
    CHAR    DigitalSignerVersion[MAX_PATH];
    DWORD   SignerScore;
} SP_INF_SIGNER_INFO_V2_A;
typedef SP_INF_SIGNER_INFO_V2_A     *PSP_INF_SIGNER_INFO_V2_A;
typedef struct _SP_INF_SIGNER_INFO_V2_W {
    DWORD   cbSize;
    WCHAR   CatalogFile[MAX_PATH];
    WCHAR   DigitalSigner[MAX_PATH];
    WCHAR   DigitalSignerVersion[MAX_PATH];
    DWORD   SignerScore;
} SP_INF_SIGNER_INFO_V2_W;
typedef SP_INF_SIGNER_INFO_V2_W     *PSP_INF_SIGNER_INFO_V2_W;
#ifdef UNICODE
typedef SP_INF_SIGNER_INFO_V2_W     SP_INF_SIGNER_INFO_V2;
typedef PSP_INF_SIGNER_INFO_V2_W    PSP_INF_SIGNER_INFO_V2;
#else
typedef SP_INF_SIGNER_INFO_V2_A     SP_INF_SIGNER_INFO_V2;
typedef PSP_INF_SIGNER_INFO_V2_A    PSP_INF_SIGNER_INFO_V2;
#endif
#endif

/* Setup information signer information */
#if (_SETUPAPI_VER >= 0x0600)
typedef SP_INF_SIGNER_INFO_V2_A     SP_INF_SIGNER_INFO_A;
typedef PSP_INF_SIGNER_INFO_V2_A    PSP_INF_SIGNER_INFO_A;
typedef SP_INF_SIGNER_INFO_V2_W     SP_INF_SIGNER_INFO_W;
typedef PSP_INF_SIGNER_INFO_V2_W    PSP_INF_SIGNER_INFO_W;
typedef SP_INF_SIGNER_INFO_V2       SP_INF_SIGNER_INFO;
typedef PSP_INF_SIGNER_INFO_V2      PSP_INF_SIGNER_INFO;
#elif (_SETUPAPI_VER >= 0x0501)
typedef SP_INF_SIGNER_INFO_V1_A     SP_INF_SIGNER_INFO_A;
typedef PSP_INF_SIGNER_INFO_V1_A    PSP_INF_SIGNER_INFO_A;
typedef SP_INF_SIGNER_INFO_V1_W     SP_INF_SIGNER_INFO_W;
typedef PSP_INF_SIGNER_INFO_V1_W    PSP_INF_SIGNER_INFO_W;
typedef SP_INF_SIGNER_INFO_V1       SP_INF_SIGNER_INFO;
typedef PSP_INF_SIGNER_INFO_V1      PSP_INF_SIGNER_INFO;
#endif

/* Functions in SETUPAPI.DLL */
WINSETUPAPI VOID WINAPI     InstallHinfSectionA( HWND, HINSTANCE, PCSTR, INT );
WINSETUPAPI VOID WINAPI     InstallHinfSectionW( HWND, HINSTANCE, PCWSTR, INT );
WINSETUPAPI BOOL WINAPI     SetupAddInstallSectionToDiskSpaceListA( HDSKSPC, HINF, HINF, PCSTR, PVOID, UINT );
WINSETUPAPI BOOL WINAPI     SetupAddInstallSectionToDiskSpaceListW( HDSKSPC, HINF, HINF, PCWSTR, PVOID, UINT );
WINSETUPAPI BOOL WINAPI     SetupAddSectionToDiskSpaceListA( HDSKSPC, HINF, HINF, PCSTR, UINT, PVOID, UINT );
WINSETUPAPI BOOL WINAPI     SetupAddSectionToDiskSpaceListW( HDSKSPC, HINF, HINF, PCWSTR, UINT, PVOID, UINT );
WINSETUPAPI BOOL WINAPI     SetupAddToDiskSpaceListA( HDSKSPC, PCSTR, LONGLONG, UINT, PVOID, UINT );
WINSETUPAPI BOOL WINAPI     SetupAddToDiskSpaceListW( HDSKSPC, PCWSTR, LONGLONG, UINT, PVOID, UINT );
WINSETUPAPI BOOL WINAPI     SetupAddToSourceListA( DWORD, PCSTR );
WINSETUPAPI BOOL WINAPI     SetupAddToSourceListW( DWORD, PCWSTR );
WINSETUPAPI BOOL WINAPI     SetupAdjustDiskSpaceListA( HDSKSPC, LPCSTR, LONGLONG, PVOID, UINT );
WINSETUPAPI BOOL WINAPI     SetupAdjustDiskSpaceListW( HDSKSPC, LPCWSTR, LONGLONG, PVOID, UINT );
WINSETUPAPI UINT WINAPI     SetupBackupErrorA( HWND, PCSTR, PCSTR, PCSTR, UINT, DWORD );
WINSETUPAPI UINT WINAPI     SetupBackupErrorW( HWND, PCWSTR, PCWSTR, PCWSTR, UINT, DWORD );
WINSETUPAPI BOOL WINAPI     SetupCancelTemporarySourceList( VOID );
WINSETUPAPI BOOL WINAPI     SetupCloseFileQueue( HSPFILEQ );
WINSETUPAPI VOID WINAPI     SetupCloseInfFile( HINF );
WINSETUPAPI VOID WINAPI     SetupCloseLog( VOID );
WINSETUPAPI BOOL WINAPI     SetupCommitFileQueueA( HWND, HSPFILEQ, PSP_FILE_CALLBACK_A, PVOID );
WINSETUPAPI BOOL WINAPI     SetupCommitFileQueueW( HWND, HSPFILEQ, PSP_FILE_CALLBACK_W, PVOID );
WINSETUPAPI UINT WINAPI     SetupCopyErrorA( HWND, PCSTR, PCSTR, PCSTR, PCSTR, PCSTR, UINT, DWORD, PSTR, DWORD, PDWORD );
WINSETUPAPI UINT WINAPI     SetupCopyErrorW( HWND, PCWSTR, PCWSTR, PCWSTR, PCWSTR, PCWSTR, UINT, DWORD, PWSTR, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupCopyOEMInfA( PCSTR, PCSTR, DWORD, DWORD, PSTR, DWORD, PDWORD, PSTR * );
WINSETUPAPI BOOL WINAPI     SetupCopyOEMInfW( PCWSTR, PCWSTR, DWORD, DWORD, PWSTR, DWORD, PDWORD, PWSTR * );
WINSETUPAPI HDSKSPC WINAPI  SetupCreateDiskSpaceListA( PVOID, DWORD, UINT );
WINSETUPAPI HDSKSPC WINAPI  SetupCreateDiskSpaceListW( PVOID, DWORD, UINT );
WINSETUPAPI DWORD WINAPI    SetupDecompressOrCopyFileA( PCSTR, PCSTR, PUINT );
WINSETUPAPI DWORD WINAPI    SetupDecompressOrCopyFileW( PCWSTR, PCWSTR, PUINT );
WINSETUPAPI UINT WINAPI     SetupDefaultQueueCallbackA( PVOID, UINT, UINT_PTR, UINT_PTR );
WINSETUPAPI UINT WINAPI     SetupDefaultQueueCallbackW( PVOID, UINT, UINT_PTR, UINT_PTR );
WINSETUPAPI UINT WINAPI     SetupDeleteErrorA( HWND, PCSTR, PCSTR, UINT, DWORD );
WINSETUPAPI UINT WINAPI     SetupDeleteErrorW( HWND, PCWSTR, PCWSTR, UINT, DWORD );
WINSETUPAPI BOOL WINAPI     SetupDestroyDiskSpaceList( HDSKSPC );
WINSETUPAPI BOOL WINAPI     SetupDiAskForOEMDisk( HDEVINFO, PSP_DEVINFO_DATA );
WINSETUPAPI BOOL WINAPI     SetupDiBuildClassInfoList( DWORD, LPGUID, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupDiBuildClassInfoListExA( DWORD, LPGUID, DWORD, PDWORD, PCSTR, PVOID );
WINSETUPAPI BOOL WINAPI     SetupDiBuildClassInfoListExW( DWORD, LPGUID, DWORD, PDWORD, PCWSTR, PVOID );
WINSETUPAPI BOOL WINAPI     SetupDiBuildDriverInfoList( HDEVINFO, PSP_DEVINFO_DATA, DWORD );
WINSETUPAPI BOOL WINAPI     SetupDiCallClassInstaller( DI_FUNCTION, HDEVINFO, PSP_DEVINFO_DATA );
WINSETUPAPI BOOL WINAPI     SetupDiCancelDriverInfoSearch( HDEVINFO );
WINSETUPAPI BOOL WINAPI     SetupDiChangeState( HDEVINFO, PSP_DEVINFO_DATA );
WINSETUPAPI BOOL WINAPI     SetupDiClassGuidsFromNameA( PCSTR, LPGUID, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupDiClassGuidsFromNameExA( PCSTR, LPGUID, DWORD, PDWORD, PCSTR, PVOID );
WINSETUPAPI BOOL WINAPI     SetupDiClassGuidsFromNameExW( PCWSTR, LPGUID, DWORD, PDWORD, PCWSTR, PVOID );
WINSETUPAPI BOOL WINAPI     SetupDiClassGuidsFromNameW( PCWSTR, LPGUID, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupDiClassNameFromGuidA( CONST GUID *, PSTR, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupDiClassNameFromGuidExA( CONST GUID *, PSTR, DWORD, PDWORD, PCSTR, PVOID );
WINSETUPAPI BOOL WINAPI     SetupDiClassNameFromGuidExW( CONST GUID *, PWSTR, DWORD, PDWORD, PCWSTR, PVOID );
WINSETUPAPI BOOL WINAPI     SetupDiClassNameFromGuidW( CONST GUID *, PWSTR, DWORD, PDWORD );
WINSETUPAPI HKEY WINAPI     SetupDiCreateDevRegKeyA( HDEVINFO, PSP_DEVINFO_DATA, DWORD, DWORD, DWORD, HINF, PCSTR );
WINSETUPAPI HKEY WINAPI     SetupDiCreateDevRegKeyW( HDEVINFO, PSP_DEVINFO_DATA, DWORD, DWORD, DWORD, HINF, PCWSTR );
WINSETUPAPI BOOL WINAPI     SetupDiCreateDeviceInfoA( HDEVINFO, PCSTR, CONST GUID *, PCSTR, HWND, DWORD, PSP_DEVINFO_DATA );
WINSETUPAPI HDEVINFO WINAPI SetupDiCreateDeviceInfoList( CONST GUID *, HWND );
WINSETUPAPI HDEVINFO WINAPI SetupDiCreateDeviceInfoListExA( CONST GUID *, HWND, PCSTR, PVOID );
WINSETUPAPI HDEVINFO WINAPI SetupDiCreateDeviceInfoListExW( CONST GUID *, HWND, PCWSTR, PVOID );
WINSETUPAPI BOOL WINAPI     SetupDiCreateDeviceInfoW( HDEVINFO, PCWSTR, CONST GUID *, PCWSTR, HWND, DWORD, PSP_DEVINFO_DATA );
WINSETUPAPI BOOL WINAPI     SetupDiCreateDeviceInterfaceA( HDEVINFO, PSP_DEVINFO_DATA, CONST GUID *, PCSTR, DWORD, PSP_DEVICE_INTERFACE_DATA );
WINSETUPAPI HKEY WINAPI     SetupDiCreateDeviceInterfaceRegKeyA( HDEVINFO, PSP_DEVICE_INTERFACE_DATA, DWORD, REGSAM, HINF, PCSTR );
WINSETUPAPI HKEY WINAPI     SetupDiCreateDeviceInterfaceRegKeyW( HDEVINFO, PSP_DEVICE_INTERFACE_DATA, DWORD, REGSAM, HINF, PCWSTR );
WINSETUPAPI BOOL WINAPI     SetupDiCreateDeviceInterfaceW( HDEVINFO, PSP_DEVINFO_DATA, CONST GUID *, PCWSTR, DWORD, PSP_DEVICE_INTERFACE_DATA );
WINSETUPAPI BOOL WINAPI     SetupDiDeleteDevRegKey( HDEVINFO, PSP_DEVINFO_DATA, DWORD, DWORD, DWORD );
WINSETUPAPI BOOL WINAPI     SetupDiDeleteDeviceInfo( HDEVINFO, PSP_DEVINFO_DATA );
WINSETUPAPI BOOL WINAPI     SetupDiDeleteDeviceInterfaceData( HDEVINFO, PSP_DEVICE_INTERFACE_DATA );
WINSETUPAPI BOOL WINAPI     SetupDiDeleteDeviceInterfaceRegKey( HDEVINFO, PSP_DEVICE_INTERFACE_DATA, DWORD );
WINSETUPAPI BOOL WINAPI     SetupDiDestroyClassImageList( PSP_CLASSIMAGELIST_DATA );
WINSETUPAPI BOOL WINAPI     SetupDiDestroyDeviceInfoList( HDEVINFO );
WINSETUPAPI BOOL WINAPI     SetupDiDestroyDriverInfoList( HDEVINFO, PSP_DEVINFO_DATA, DWORD );
WINSETUPAPI INT WINAPI      SetupDiDrawMiniIcon( HDC, RECT, INT, DWORD );
WINSETUPAPI BOOL WINAPI     SetupDiEnumDeviceInfo( HDEVINFO, DWORD, PSP_DEVINFO_DATA );
WINSETUPAPI BOOL WINAPI     SetupDiEnumDeviceInterfaces( HDEVINFO, PSP_DEVINFO_DATA, CONST GUID *, DWORD, PSP_DEVICE_INTERFACE_DATA );
WINSETUPAPI BOOL WINAPI     SetupDiEnumDriverInfoA( HDEVINFO, PSP_DEVINFO_DATA, DWORD, DWORD, PSP_DRVINFO_DATA_A );
WINSETUPAPI BOOL WINAPI     SetupDiEnumDriverInfoW( HDEVINFO, PSP_DEVINFO_DATA, DWORD, DWORD, PSP_DRVINFO_DATA_W );
WINSETUPAPI BOOL WINAPI     SetupDiGetActualSectionToInstallA( HINF, PCSTR, PSTR, DWORD, PDWORD, PSTR * );
WINSETUPAPI BOOL WINAPI     SetupDiGetActualSectionToInstallW( HINF, PCWSTR, PWSTR, DWORD, PDWORD, PWSTR * );
WINSETUPAPI BOOL WINAPI     SetupDiGetClassBitmapIndex( CONST GUID *, PINT );
WINSETUPAPI BOOL WINAPI     SetupDiGetClassDescriptionA( CONST GUID *, PSTR, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupDiGetClassDescriptionExA( CONST GUID *, PSTR, DWORD, PDWORD, PCSTR, PVOID );
WINSETUPAPI BOOL WINAPI     SetupDiGetClassDescriptionExW( CONST GUID *, PWSTR, DWORD, PDWORD, PCWSTR, PVOID );
WINSETUPAPI BOOL WINAPI     SetupDiGetClassDescriptionW( CONST GUID *, PWSTR, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupDiGetClassDevPropertySheetsA( HDEVINFO, PSP_DEVINFO_DATA, LPPROPSHEETHEADERA, DWORD, PDWORD, DWORD );
WINSETUPAPI BOOL WINAPI     SetupDiGetClassDevPropertySheetsW( HDEVINFO, PSP_DEVINFO_DATA, LPPROPSHEETHEADERW, DWORD, PDWORD, DWORD );
WINSETUPAPI HDEVINFO WINAPI SetupDiGetClassDevsA( CONST GUID *, PCSTR, HWND, DWORD );
WINSETUPAPI HDEVINFO WINAPI SetupDiGetClassDevsExA( CONST GUID *, PCSTR, HWND, DWORD, HDEVINFO, PCSTR, PVOID );
WINSETUPAPI HDEVINFO WINAPI SetupDiGetClassDevsExW( CONST GUID *, PCWSTR, HWND, DWORD, HDEVINFO, PCWSTR, PVOID );
WINSETUPAPI HDEVINFO WINAPI SetupDiGetClassDevsW( CONST GUID *, PCWSTR, HWND, DWORD );
WINSETUPAPI BOOL WINAPI     SetupDiGetClassImageIndex( PSP_CLASSIMAGELIST_DATA, CONST GUID *, PINT );
WINSETUPAPI BOOL WINAPI     SetupDiGetClassImageList( PSP_CLASSIMAGELIST_DATA );
WINSETUPAPI BOOL WINAPI     SetupDiGetClassImageListExA( PSP_CLASSIMAGELIST_DATA, PCSTR, PVOID );
WINSETUPAPI BOOL WINAPI     SetupDiGetClassImageListExW( PSP_CLASSIMAGELIST_DATA, PCWSTR, PVOID );
WINSETUPAPI BOOL WINAPI     SetupDiGetClassInstallParamsA( HDEVINFO, PSP_DEVINFO_DATA, PSP_CLASSINSTALL_HEADER, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupDiGetClassInstallParamsW( HDEVINFO, PSP_DEVINFO_DATA, PSP_CLASSINSTALL_HEADER, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupDiGetDeviceInfoListClass( HDEVINFO, LPGUID );
WINSETUPAPI BOOL WINAPI     SetupDiGetDeviceInfoListDetailA( HDEVINFO, PSP_DEVINFO_LIST_DETAIL_DATA_A );
WINSETUPAPI BOOL WINAPI     SetupDiGetDeviceInfoListDetailW( HDEVINFO, PSP_DEVINFO_LIST_DETAIL_DATA_W );
WINSETUPAPI BOOL WINAPI     SetupDiGetDeviceInstallParamsA( HDEVINFO, PSP_DEVINFO_DATA, PSP_DEVINSTALL_PARAMS_A );
WINSETUPAPI BOOL WINAPI     SetupDiGetDeviceInstallParamsW( HDEVINFO, PSP_DEVINFO_DATA, PSP_DEVINSTALL_PARAMS_W );
WINSETUPAPI BOOL WINAPI     SetupDiGetDeviceInstanceIdA( HDEVINFO, PSP_DEVINFO_DATA, PSTR, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupDiGetDeviceInstanceIdW( HDEVINFO, PSP_DEVINFO_DATA, PWSTR, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupDiGetDeviceInterfaceAlias( HDEVINFO, PSP_DEVICE_INTERFACE_DATA, CONST GUID *, PSP_DEVICE_INTERFACE_DATA );
WINSETUPAPI BOOL WINAPI     SetupDiGetDeviceInterfaceDetailA( HDEVINFO, PSP_DEVICE_INTERFACE_DATA, PSP_DEVICE_INTERFACE_DETAIL_DATA_A, DWORD, PDWORD, PSP_DEVINFO_DATA );
WINSETUPAPI BOOL WINAPI     SetupDiGetDeviceInterfaceDetailW( HDEVINFO, PSP_DEVICE_INTERFACE_DATA, PSP_DEVICE_INTERFACE_DETAIL_DATA_W, DWORD, PDWORD, PSP_DEVINFO_DATA );
WINSETUPAPI BOOL WINAPI     SetupDiGetDeviceRegistryPropertyA( HDEVINFO, PSP_DEVINFO_DATA, DWORD, PDWORD, PBYTE, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupDiGetDeviceRegistryPropertyW( HDEVINFO, PSP_DEVINFO_DATA, DWORD, PDWORD, PBYTE, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupDiGetDriverInfoDetailA( HDEVINFO, PSP_DEVINFO_DATA, PSP_DRVINFO_DATA_A, PSP_DRVINFO_DETAIL_DATA_A, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupDiGetDriverInfoDetailW( HDEVINFO, PSP_DEVINFO_DATA, PSP_DRVINFO_DATA_W, PSP_DRVINFO_DETAIL_DATA_W, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupDiGetDriverInstallParamsA( HDEVINFO, PSP_DEVINFO_DATA, PSP_DRVINFO_DATA_A, PSP_DRVINSTALL_PARAMS );
WINSETUPAPI BOOL WINAPI     SetupDiGetDriverInstallParamsW( HDEVINFO, PSP_DEVINFO_DATA, PSP_DRVINFO_DATA_W, PSP_DRVINSTALL_PARAMS );
WINSETUPAPI BOOL WINAPI     SetupDiGetHwProfileFriendlyNameA( DWORD, PSTR, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupDiGetHwProfileFriendlyNameExA( DWORD, PSTR, DWORD, PDWORD, PCSTR, PVOID );
WINSETUPAPI BOOL WINAPI     SetupDiGetHwProfileFriendlyNameExW( DWORD, PWSTR, DWORD, PDWORD, PCWSTR, PVOID );
WINSETUPAPI BOOL WINAPI     SetupDiGetHwProfileFriendlyNameW( DWORD, PWSTR, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupDiGetHwProfileList( PDWORD, DWORD, PDWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupDiGetHwProfileListExA( PDWORD, DWORD, PDWORD, PDWORD, PCSTR, PVOID );
WINSETUPAPI BOOL WINAPI     SetupDiGetHwProfileListExW( PDWORD, DWORD, PDWORD, PDWORD, PCWSTR, PVOID );
WINSETUPAPI BOOL WINAPI     SetupDiGetINFClassA( PCSTR, LPGUID, PSTR, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupDiGetINFClassW( PCWSTR, LPGUID, PWSTR, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupDiGetSelectedDevice( HDEVINFO, PSP_DEVINFO_DATA );
WINSETUPAPI BOOL WINAPI     SetupDiGetSelectedDriverA( HDEVINFO, PSP_DEVINFO_DATA, PSP_DRVINFO_DATA_A );
WINSETUPAPI BOOL WINAPI     SetupDiGetSelectedDriverW( HDEVINFO, PSP_DEVINFO_DATA, PSP_DRVINFO_DATA_W );
WINSETUPAPI HPROPSHEETPAGE WINAPI   SetupDiGetWizardPage( HDEVINFO, PSP_DEVINFO_DATA, PSP_INSTALLWIZARD_DATA, DWORD, DWORD );
WINSETUPAPI BOOL WINAPI     SetupDiInstallClassA( HWND, PCSTR, DWORD, HSPFILEQ );
WINSETUPAPI BOOL WINAPI     SetupDiInstallClassExA( HWND, PCSTR, DWORD, HSPFILEQ, CONST GUID *, PVOID, PVOID );
WINSETUPAPI BOOL WINAPI     SetupDiInstallClassExW( HWND, PCWSTR, DWORD, HSPFILEQ, CONST GUID *, PVOID, PVOID );
WINSETUPAPI BOOL WINAPI     SetupDiInstallClassW( HWND, PCWSTR, DWORD, HSPFILEQ );
WINSETUPAPI BOOL WINAPI     SetupDiInstallDevice( HDEVINFO, PSP_DEVINFO_DATA );
WINSETUPAPI BOOL WINAPI     SetupDiInstallDeviceInterfaces( HDEVINFO, PSP_DEVINFO_DATA );
WINSETUPAPI BOOL WINAPI     SetupDiInstallDriverFiles( HDEVINFO, PSP_DEVINFO_DATA );
WINSETUPAPI BOOL WINAPI     SetupDiLoadClassIcon( CONST GUID *, HICON *, PINT );
WINSETUPAPI HKEY WINAPI     SetupDiOpenClassRegKey( CONST GUID *, REGSAM );
WINSETUPAPI HKEY WINAPI     SetupDiOpenClassRegKeyExA( CONST GUID *, REGSAM, DWORD, PCSTR, PVOID );
WINSETUPAPI HKEY WINAPI     SetupDiOpenClassRegKeyExW( CONST GUID *, REGSAM, DWORD, PCWSTR, PVOID );
WINSETUPAPI HKEY WINAPI     SetupDiOpenDevRegKey( HDEVINFO, PSP_DEVINFO_DATA, DWORD, DWORD, DWORD, REGSAM );
WINSETUPAPI BOOL WINAPI     SetupDiOpenDeviceInfoA( HDEVINFO, PCSTR, HWND, DWORD, PSP_DEVINFO_DATA );
WINSETUPAPI BOOL WINAPI     SetupDiOpenDeviceInfoW( HDEVINFO, PCWSTR, HWND, DWORD, PSP_DEVINFO_DATA );
WINSETUPAPI BOOL WINAPI     SetupDiOpenDeviceInterfaceA( HDEVINFO, PCSTR, DWORD, PSP_DEVICE_INTERFACE_DATA );
WINSETUPAPI HKEY WINAPI     SetupDiOpenDeviceInterfaceRegKey( HDEVINFO, PSP_DEVICE_INTERFACE_DATA, DWORD, REGSAM );
WINSETUPAPI BOOL WINAPI     SetupDiOpenDeviceInterfaceW( HDEVINFO, PCWSTR, DWORD, PSP_DEVICE_INTERFACE_DATA );
WINSETUPAPI BOOL WINAPI     SetupDiRegisterCoDeviceInstallers( HDEVINFO, PSP_DEVINFO_DATA );
WINSETUPAPI BOOL WINAPI     SetupDiRegisterDeviceInfo( HDEVINFO, PSP_DEVINFO_DATA, DWORD, PSP_DETSIG_CMPPROC, PVOID, PSP_DEVINFO_DATA );
WINSETUPAPI BOOL WINAPI     SetupDiRemoveDevice( HDEVINFO, PSP_DEVINFO_DATA );
WINSETUPAPI BOOL WINAPI     SetupDiRemoveDeviceInterface( HDEVINFO, PSP_DEVICE_INTERFACE_DATA );
WINSETUPAPI BOOL WINAPI     SetupDiSelectBestCompatDrv( HDEVINFO, PSP_DEVINFO_DATA );
WINSETUPAPI BOOL WINAPI     SetupDiSelectDevice( HDEVINFO, PSP_DEVINFO_DATA );
WINSETUPAPI BOOL WINAPI     SetupDiSelectOEMDrv( HWND, HDEVINFO, PSP_DEVINFO_DATA );
WINSETUPAPI BOOL WINAPI     SetupDiSetClassInstallParamsA( HDEVINFO, PSP_DEVINFO_DATA, PSP_CLASSINSTALL_HEADER, DWORD );
WINSETUPAPI BOOL WINAPI     SetupDiSetClassInstallParamsW( HDEVINFO, PSP_DEVINFO_DATA, PSP_CLASSINSTALL_HEADER, DWORD );
WINSETUPAPI BOOL WINAPI     SetupDiSetDeviceInstallParamsA( HDEVINFO, PSP_DEVINFO_DATA, PSP_DEVINSTALL_PARAMS_A );
WINSETUPAPI BOOL WINAPI     SetupDiSetDeviceInstallParamsW( HDEVINFO, PSP_DEVINFO_DATA, PSP_DEVINSTALL_PARAMS_W );
WINSETUPAPI BOOL WINAPI     SetupDiSetDeviceRegistryPropertyA( HDEVINFO, PSP_DEVINFO_DATA, DWORD, CONST BYTE *, DWORD );
WINSETUPAPI BOOL WINAPI     SetupDiSetDeviceRegistryPropertyW( HDEVINFO, PSP_DEVINFO_DATA, DWORD, CONST BYTE *, DWORD );
WINSETUPAPI BOOL WINAPI     SetupDiSetDriverInstallParamsA( HDEVINFO, PSP_DEVINFO_DATA, PSP_DRVINFO_DATA_A, PSP_DRVINSTALL_PARAMS );
WINSETUPAPI BOOL WINAPI     SetupDiSetDriverInstallParamsW( HDEVINFO, PSP_DEVINFO_DATA, PSP_DRVINFO_DATA_W, PSP_DRVINSTALL_PARAMS );
WINSETUPAPI BOOL WINAPI     SetupDiSetSelectedDevice( HDEVINFO, PSP_DEVINFO_DATA );
WINSETUPAPI BOOL WINAPI     SetupDiSetSelectedDriverA( HDEVINFO, PSP_DEVINFO_DATA, PSP_DRVINFO_DATA_A );
WINSETUPAPI BOOL WINAPI     SetupDiSetSelectedDriverW( HDEVINFO, PSP_DEVINFO_DATA, PSP_DRVINFO_DATA_W );
WINSETUPAPI BOOL WINAPI     SetupDiUnremoveDevice( HDEVINFO, PSP_DEVINFO_DATA );
WINSETUPAPI HDSKSPC WINAPI  SetupDuplicateDiskSpaceListA( HDSKSPC, PVOID, DWORD, UINT );
WINSETUPAPI HDSKSPC WINAPI  SetupDuplicateDiskSpaceListW( HDSKSPC, PVOID, DWORD, UINT );
WINSETUPAPI BOOL WINAPI     SetupFindFirstLineA( HINF, PCSTR, PCSTR, PINFCONTEXT );
WINSETUPAPI BOOL WINAPI     SetupFindFirstLineW( HINF, PCWSTR, PCWSTR, PINFCONTEXT );
WINSETUPAPI BOOL WINAPI     SetupFindNextLine( PINFCONTEXT, PINFCONTEXT );
WINSETUPAPI BOOL WINAPI     SetupFindNextMatchLineA( PINFCONTEXT, PCSTR, PINFCONTEXT );
WINSETUPAPI BOOL WINAPI     SetupFindNextMatchLineW( PINFCONTEXT, PCWSTR, PINFCONTEXT );
WINSETUPAPI BOOL WINAPI     SetupFreeSourceListA( PCSTR **, UINT );
WINSETUPAPI BOOL WINAPI     SetupFreeSourceListW( PCWSTR **, UINT );
WINSETUPAPI BOOL WINAPI     SetupGetBackupInformationA( HSPFILEQ, PSP_BACKUP_QUEUE_PARAMS_A );
WINSETUPAPI BOOL WINAPI     SetupGetBackupInformationW( HSPFILEQ, PSP_BACKUP_QUEUE_PARAMS_W );
WINSETUPAPI BOOL WINAPI     SetupGetBinaryField( PINFCONTEXT, DWORD, PBYTE, DWORD, LPDWORD );
WINSETUPAPI DWORD WINAPI    SetupGetFieldCount( PINFCONTEXT );
WINSETUPAPI DWORD WINAPI    SetupGetFileCompressionInfoA( PCSTR, PSTR *, PDWORD, PDWORD, PUINT );
WINSETUPAPI DWORD WINAPI    SetupGetFileCompressionInfoW( PCWSTR, PWSTR *, PDWORD, PDWORD, PUINT );
WINSETUPAPI BOOL WINAPI     SetupGetInfFileListA( PCSTR, DWORD, PSTR, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupGetInfFileListW( PCWSTR, DWORD, PWSTR, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupGetInfInformationA( LPCVOID, DWORD, PSP_INF_INFORMATION, DWORD, DWORD );
WINSETUPAPI BOOL WINAPI     SetupGetInfInformationW( LPCVOID, DWORD, PSP_INF_INFORMATION, DWORD, DWORD );
WINSETUPAPI BOOL WINAPI     SetupGetIntField( PINFCONTEXT, DWORD, PINT );
WINSETUPAPI BOOL WINAPI     SetupGetLineByIndexA( HINF, PCSTR, DWORD, PINFCONTEXT );
WINSETUPAPI BOOL WINAPI     SetupGetLineByIndexW( HINF, PCWSTR, DWORD, PINFCONTEXT );
WINSETUPAPI LONG WINAPI     SetupGetLineCountA( HINF, PCSTR );
WINSETUPAPI LONG WINAPI     SetupGetLineCountW( HINF, PCWSTR );
WINSETUPAPI BOOL WINAPI     SetupGetLineTextA( PINFCONTEXT, HINF, PCSTR, PCSTR, PSTR, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupGetLineTextW( PINFCONTEXT, HINF, PCWSTR, PCWSTR, PWSTR, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupGetMultiSzFieldA( PINFCONTEXT, DWORD, PSTR, DWORD, LPDWORD );
WINSETUPAPI BOOL WINAPI     SetupGetMultiSzFieldW( PINFCONTEXT, DWORD, PWSTR, DWORD, LPDWORD );
WINSETUPAPI BOOL WINAPI     SetupGetSourceFileLocationA( HINF, PINFCONTEXT, PCSTR, PUINT, PSTR, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupGetSourceFileLocationW( HINF, PINFCONTEXT, PCWSTR, PUINT, PWSTR, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupGetSourceFileSizeA( HINF, PINFCONTEXT, PCSTR, PCSTR, PDWORD, UINT );
WINSETUPAPI BOOL WINAPI     SetupGetSourceFileSizeW( HINF, PINFCONTEXT, PCWSTR, PCWSTR, PDWORD, UINT );
WINSETUPAPI BOOL WINAPI     SetupGetSourceInfoA( HINF, UINT, UINT, PSTR, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupGetSourceInfoW( HINF, UINT, UINT, PWSTR, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupGetStringFieldA( PINFCONTEXT, DWORD, PSTR, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupGetStringFieldW( PINFCONTEXT, DWORD, PWSTR, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupGetTargetPathA( HINF, PINFCONTEXT, PCSTR, PSTR, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupGetTargetPathW( HINF, PINFCONTEXT, PCWSTR, PWSTR, DWORD, PDWORD );
WINSETUPAPI PVOID WINAPI    SetupInitDefaultQueueCallback( HWND );
WINSETUPAPI PVOID WINAPI    SetupInitDefaultQueueCallbackEx( HWND, HWND, UINT, DWORD, PVOID );
WINSETUPAPI HSPFILELOG WINAPI   SetupInitializeFileLogA( PCSTR, DWORD );
WINSETUPAPI HSPFILELOG WINAPI   SetupInitializeFileLogW( PCWSTR, DWORD );
WINSETUPAPI BOOL WINAPI     SetupInstallFileA( HINF, PINFCONTEXT, PCSTR, PCSTR, PCSTR, DWORD, PSP_FILE_CALLBACK_A, PVOID );
WINSETUPAPI BOOL WINAPI     SetupInstallFileExA( HINF, PINFCONTEXT, PCSTR, PCSTR, PCSTR, DWORD, PSP_FILE_CALLBACK_A, PVOID, PBOOL );
WINSETUPAPI BOOL WINAPI     SetupInstallFileExW( HINF, PINFCONTEXT, PCWSTR, PCWSTR, PCWSTR, DWORD, PSP_FILE_CALLBACK_W, PVOID, PBOOL );
WINSETUPAPI BOOL WINAPI     SetupInstallFileW( HINF, PINFCONTEXT, PCWSTR, PCWSTR, PCWSTR, DWORD, PSP_FILE_CALLBACK_W, PVOID );
WINSETUPAPI BOOL WINAPI     SetupInstallFilesFromInfSectionA( HINF, HINF, HSPFILEQ, PCSTR, PCSTR, UINT );
WINSETUPAPI BOOL WINAPI     SetupInstallFilesFromInfSectionW( HINF, HINF, HSPFILEQ, PCWSTR, PCWSTR, UINT );
WINSETUPAPI BOOL WINAPI     SetupInstallFromInfSectionA( HWND, HINF, PCSTR, UINT, HKEY, PCSTR, UINT, PSP_FILE_CALLBACK_A, PVOID, HDEVINFO, PSP_DEVINFO_DATA );
WINSETUPAPI BOOL WINAPI     SetupInstallFromInfSectionW( HWND, HINF, PCWSTR, UINT, HKEY, PCWSTR, UINT, PSP_FILE_CALLBACK_W, PVOID, HDEVINFO, PSP_DEVINFO_DATA );
WINSETUPAPI BOOL WINAPI     SetupInstallServicesFromInfSectionA( HINF, PCSTR, DWORD );
WINSETUPAPI BOOL WINAPI     SetupInstallServicesFromInfSectionExA( HINF, PCSTR, DWORD, HDEVINFO, PSP_DEVINFO_DATA, PVOID, PVOID );
WINSETUPAPI BOOL WINAPI     SetupInstallServicesFromInfSectionExW( HINF, PCWSTR, DWORD, HDEVINFO, PSP_DEVINFO_DATA, PVOID, PVOID );
WINSETUPAPI BOOL WINAPI     SetupInstallServicesFromInfSectionW( HINF, PCWSTR, DWORD );
WINSETUPAPI BOOL WINAPI     SetupIterateCabinetA( PCSTR, DWORD, PSP_FILE_CALLBACK_A, PVOID );
WINSETUPAPI BOOL WINAPI     SetupIterateCabinetW( PCWSTR, DWORD, PSP_FILE_CALLBACK_W, PVOID );
WINSETUPAPI BOOL WINAPI     SetupLogErrorA( LPCSTR, LogSeverity );
WINSETUPAPI BOOL WINAPI     SetupLogErrorW( LPCWSTR, LogSeverity );
WINSETUPAPI BOOL WINAPI     SetupLogFileA( HSPFILELOG, PCSTR, PCSTR, PCSTR, DWORD, PCSTR, PCSTR, PCSTR, DWORD );
WINSETUPAPI BOOL WINAPI     SetupLogFileW( HSPFILELOG, PCWSTR, PCWSTR, PCWSTR, DWORD, PCWSTR, PCWSTR, PCWSTR, DWORD );
WINSETUPAPI BOOL WINAPI     SetupOpenAppendInfFileA( PCSTR, HINF, PUINT );
WINSETUPAPI BOOL WINAPI     SetupOpenAppendInfFileW( PCWSTR, HINF, PUINT );
WINSETUPAPI HSPFILEQ WINAPI SetupOpenFileQueue( VOID );
WINSETUPAPI HINF WINAPI     SetupOpenInfFileA( PCSTR, PCSTR, DWORD, PUINT );
WINSETUPAPI HINF WINAPI     SetupOpenInfFileW( PCWSTR, PCWSTR, DWORD, PUINT );
WINSETUPAPI BOOL WINAPI     SetupOpenLog( BOOL );
WINSETUPAPI HINF WINAPI     SetupOpenMasterInf( VOID );
WINSETUPAPI UINT WINAPI     SetupPromptForDiskA( HWND, PCSTR, PCSTR, PCSTR, PCSTR, PCSTR, DWORD, PSTR, DWORD, PDWORD );
WINSETUPAPI UINT WINAPI     SetupPromptForDiskW( HWND, PCWSTR, PCWSTR, PCWSTR, PCWSTR, PCWSTR, DWORD, PWSTR, DWORD, PDWORD );
WINSETUPAPI INT WINAPI      SetupPromptReboot( HSPFILEQ, HWND, BOOL );
WINSETUPAPI BOOL WINAPI     SetupQueryDrivesInDiskSpaceListA( HDSKSPC, PSTR, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupQueryDrivesInDiskSpaceListW( HDSKSPC, PWSTR, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupQueryFileLogA( HSPFILELOG, PCSTR, PCSTR, SetupFileLogInfo, PSTR, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupQueryFileLogW( HSPFILELOG, PCWSTR, PCWSTR, SetupFileLogInfo, PWSTR, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupQueryInfFileInformationA( PSP_INF_INFORMATION, UINT, PSTR, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupQueryInfFileInformationW( PSP_INF_INFORMATION, UINT, PWSTR, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupQueryInfOriginalFileInformationA( PSP_INF_INFORMATION, UINT, PSP_ALTPLATFORM_INFO, PSP_ORIGINAL_FILE_INFO_A );
WINSETUPAPI BOOL WINAPI     SetupQueryInfOriginalFileInformationW( PSP_INF_INFORMATION, UINT, PSP_ALTPLATFORM_INFO, PSP_ORIGINAL_FILE_INFO_W );
WINSETUPAPI BOOL WINAPI     SetupQueryInfVersionInformationA( PSP_INF_INFORMATION, UINT, PCSTR, PSTR, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupQueryInfVersionInformationW( PSP_INF_INFORMATION, UINT, PCWSTR, PWSTR, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupQuerySourceListA( DWORD, PCSTR **, PUINT );
WINSETUPAPI BOOL WINAPI     SetupQuerySourceListW( DWORD, PCWSTR **, PUINT );
WINSETUPAPI BOOL WINAPI     SetupQuerySpaceRequiredOnDriveA( HDSKSPC, PCSTR, LONGLONG *, PVOID, UINT );
WINSETUPAPI BOOL WINAPI     SetupQuerySpaceRequiredOnDriveW( HDSKSPC, PCWSTR, LONGLONG *, PVOID, UINT );
WINSETUPAPI BOOL WINAPI     SetupQueueCopyA( HSPFILEQ, PCSTR, PCSTR, PCSTR, PCSTR, PCSTR, PCSTR, PCSTR, DWORD );
WINSETUPAPI BOOL WINAPI     SetupQueueCopyIndirectA( PSP_FILE_COPY_PARAMS_A );
WINSETUPAPI BOOL WINAPI     SetupQueueCopyIndirectW( PSP_FILE_COPY_PARAMS_W );
WINSETUPAPI BOOL WINAPI     SetupQueueCopySectionA( HSPFILEQ, PCSTR, HINF, HINF, PCSTR, DWORD );
WINSETUPAPI BOOL WINAPI     SetupQueueCopySectionW( HSPFILEQ, PCWSTR, HINF, HINF, PCWSTR, DWORD );
WINSETUPAPI BOOL WINAPI     SetupQueueCopyW( HSPFILEQ, PCWSTR, PCWSTR, PCWSTR, PCWSTR, PCWSTR, PCWSTR, PCWSTR, DWORD );
WINSETUPAPI BOOL WINAPI     SetupQueueDefaultCopyA( HSPFILEQ, HINF, PCSTR, PCSTR, PCSTR, DWORD );
WINSETUPAPI BOOL WINAPI     SetupQueueDefaultCopyW( HSPFILEQ, HINF, PCWSTR, PCWSTR, PCWSTR, DWORD );
WINSETUPAPI BOOL WINAPI     SetupQueueDeleteA( HSPFILEQ, PCSTR, PCSTR );
WINSETUPAPI BOOL WINAPI     SetupQueueDeleteSectionA( HSPFILEQ, HINF, HINF, PCSTR );
WINSETUPAPI BOOL WINAPI     SetupQueueDeleteSectionW( HSPFILEQ, HINF, HINF, PCWSTR );
WINSETUPAPI BOOL WINAPI     SetupQueueDeleteW( HSPFILEQ, PCWSTR, PCWSTR );
WINSETUPAPI BOOL WINAPI     SetupQueueRenameA( HSPFILEQ, PCSTR, PCSTR, PCSTR, PCSTR );
WINSETUPAPI BOOL WINAPI     SetupQueueRenameSectionA( HSPFILEQ, HINF, HINF, PCSTR );
WINSETUPAPI BOOL WINAPI     SetupQueueRenameSectionW( HSPFILEQ, HINF, HINF, PCWSTR );
WINSETUPAPI BOOL WINAPI     SetupQueueRenameW( HSPFILEQ, PCWSTR, PCWSTR, PCWSTR, PCWSTR );
WINSETUPAPI BOOL WINAPI     SetupRemoveFileLogEntryA( HSPFILELOG, PCSTR, PCSTR );
WINSETUPAPI BOOL WINAPI     SetupRemoveFileLogEntryW( HSPFILELOG, PCWSTR, PCWSTR );
WINSETUPAPI BOOL WINAPI     SetupRemoveFromDiskSpaceListA( HDSKSPC, PCSTR, UINT, PVOID, UINT );
WINSETUPAPI BOOL WINAPI     SetupRemoveFromDiskSpaceListW( HDSKSPC, PCWSTR, UINT, PVOID, UINT );
WINSETUPAPI BOOL WINAPI     SetupRemoveFromSourceListA( DWORD, PCSTR );
WINSETUPAPI BOOL WINAPI     SetupRemoveFromSourceListW( DWORD, PCWSTR );
WINSETUPAPI BOOL WINAPI     SetupRemoveInstallSectionFromDiskSpaceListA( HDSKSPC, HINF, HINF, PCSTR, PVOID, UINT );
WINSETUPAPI BOOL WINAPI     SetupRemoveInstallSectionFromDiskSpaceListW( HDSKSPC, HINF, HINF, PCWSTR, PVOID, UINT );
WINSETUPAPI BOOL WINAPI     SetupRemoveSectionFromDiskSpaceListA( HDSKSPC, HINF, HINF, PCSTR, UINT, PVOID, UINT );
WINSETUPAPI BOOL WINAPI     SetupRemoveSectionFromDiskSpaceListW( HDSKSPC, HINF, HINF, PCWSTR, UINT, PVOID, UINT );
WINSETUPAPI UINT WINAPI     SetupRenameErrorA( HWND, PCSTR, PCSTR, PCSTR, UINT, DWORD );
WINSETUPAPI UINT WINAPI     SetupRenameErrorW( HWND, PCWSTR, PCWSTR, PCWSTR, UINT, DWORD );
WINSETUPAPI BOOL WINAPI     SetupScanFileQueueA( HSPFILEQ, DWORD, HWND, PSP_FILE_CALLBACK_A, PVOID, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupScanFileQueueW( HSPFILEQ, DWORD, HWND, PSP_FILE_CALLBACK_W, PVOID, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupSetDirectoryIdA( HINF, DWORD, PCSTR );
WINSETUPAPI BOOL WINAPI     SetupSetDirectoryIdExA( HINF, DWORD, PCSTR, DWORD, DWORD, PVOID );
WINSETUPAPI BOOL WINAPI     SetupSetDirectoryIdExW( HINF, DWORD, PCWSTR, DWORD, DWORD, PVOID );
WINSETUPAPI BOOL WINAPI     SetupSetDirectoryIdW( HINF, DWORD, PCWSTR );
WINSETUPAPI BOOL WINAPI     SetupSetFileQueueAlternatePlatformA( HSPFILEQ, PSP_ALTPLATFORM_INFO, PCSTR );
WINSETUPAPI BOOL WINAPI     SetupSetFileQueueAlternatePlatformW( HSPFILEQ, PSP_ALTPLATFORM_INFO, PCWSTR );
WINSETUPAPI BOOL WINAPI     SetupSetPlatformPathOverrideA( PCSTR );
WINSETUPAPI BOOL WINAPI     SetupSetPlatformPathOverrideW( PCWSTR );
WINSETUPAPI BOOL WINAPI     SetupSetSourceListA( DWORD, PCSTR *, UINT );
WINSETUPAPI BOOL WINAPI     SetupSetSourceListW( DWORD, PCWSTR *, UINT );
WINSETUPAPI VOID WINAPI     SetupTermDefaultQueueCallback( PVOID );
WINSETUPAPI BOOL WINAPI     SetupTerminateFileLog( HSPFILELOG );
#if (_SETUPAPI_VER >= 0x0501)
WINSETUPAPI BOOL WINAPI     SetupDiGetActualSectionToInstallExA( HINF, PCSTR, PSP_ALTPLATFORM_INFO, PSTR, DWORD, PDWORD, PSTR *, PVOID );
WINSETUPAPI BOOL WINAPI     SetupDiGetActualSectionToInstallExW( HINF, PCWSTR, PSP_ALTPLATFORM_INFO, PWSTR, DWORD, PDWORD, PWSTR *, PVOID );
WINSETUPAPI BOOL WINAPI     SetupDiGetClassRegistryPropertyA( CONST GUID *, DWORD, PDWORD, PBYTE, DWORD, PDWORD, PCSTR, PVOID );
WINSETUPAPI BOOL WINAPI     SetupDiGetClassRegistryPropertyW( CONST GUID *, DWORD, PDWORD, PBYTE, DWORD, PDWORD, PCWSTR, PVOID );
WINSETUPAPI BOOL WINAPI     SetupDiGetCustomDevicePropertyA( HDEVINFO, PSP_DEVINFO_DATA, PCSTR, DWORD, PDWORD, PBYTE, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupDiGetCustomDevicePropertyW( HDEVINFO, PSP_DEVINFO_DATA, PCWSTR, DWORD, PDWORD, PBYTE, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupDiSetClassRegistryPropertyA( CONST GUID *, DWORD, CONST BYTE *, DWORD, PCSTR, PVOID );
WINSETUPAPI BOOL WINAPI     SetupDiSetClassRegistryPropertyW( CONST GUID *, DWORD, CONST BYTE *, DWORD, PCWSTR, PVOID );
WINSETUPAPI BOOL WINAPI     SetupDiSetDeviceInterfaceDefault( HDEVINFO, PSP_DEVICE_INTERFACE_DATA, DWORD, PVOID );
WINSETUPAPI BOOL WINAPI     SetupEnumInfSectionsA( HINF, UINT, PSTR, UINT, UINT * );
WINSETUPAPI BOOL WINAPI     SetupEnumInfSectionsW( HINF, UINT, PWSTR, UINT, UINT * );
WINSETUPAPI BOOL WINAPI     SetupGetFileCompressionInfoExA( PCSTR, PSTR, DWORD, PDWORD, PDWORD, PDWORD, PUINT );
WINSETUPAPI BOOL WINAPI     SetupGetFileCompressionInfoExW( PCWSTR, PWSTR, DWORD, PDWORD, PDWORD, PDWORD, PUINT );
WINSETUPAPI BOOL WINAPI     SetupGetFileQueueCount( HSPFILEQ, UINT, PUINT );
WINSETUPAPI BOOL WINAPI     SetupGetFileQueueFlags( HSPFILEQ, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupGetNonInteractiveMode( VOID );
WINSETUPAPI BOOL WINAPI     SetupPrepareQueueForRestoreA( HSPFILEQ, PCSTR, DWORD );
WINSETUPAPI BOOL WINAPI     SetupPrepareQueueForRestoreW( HSPFILEQ, PCWSTR, DWORD );
WINSETUPAPI BOOL WINAPI     SetupSetFileQueueFlags( HSPFILEQ, DWORD, DWORD );
WINSETUPAPI BOOL WINAPI     SetupSetNonInteractiveMode( BOOL );
WINSETUPAPI BOOL WINAPI     SetupUninstallNewlyCopiedInfs( HSPFILEQ, DWORD, PVOID );
WINSETUPAPI BOOL WINAPI     SetupUninstallOEMInfA( PCSTR, DWORD, PVOID );
WINSETUPAPI BOOL WINAPI     SetupUninstallOEMInfW( PCWSTR, DWORD, PVOID );
WINSETUPAPI BOOL WINAPI     SetupVerifyInfFileA( PCSTR, PSP_ALTPLATFORM_INFO, PSP_INF_SIGNER_INFO_A );
WINSETUPAPI BOOL WINAPI     SetupVerifyInfFileW( PCWSTR, PSP_ALTPLATFORM_INFO, PSP_INF_SIGNER_INFO_W );
#endif
#if (_SETUPAPI_VER >= 0x0502)
WINSETUPAPI BOOL WINAPI     SetupConfigureWmiFromInfSectionA( HINF, PCSTR, DWORD );
WINSETUPAPI BOOL WINAPI     SetupConfigureWmiFromInfSectionW( HINF, PCWSTR, DWORD );
WINSETUPAPI BOOL WINAPI     SetupDiGetActualModelsSectionA( PINFCONTEXT, PSP_ALTPLATFORM_INFO, PSTR, DWORD, PDWORD, PVOID );
WINSETUPAPI BOOL WINAPI     SetupDiGetActualModelsSectionW( PINFCONTEXT, PSP_ALTPLATFORM_INFO, PWSTR, DWORD, PDWORD, PVOID );
#endif
#if (_SETUPAPI_VER >= 0x0600)
WINSETUPAPI BOOL WINAPI     SetupDiGetClassPropertyExW( CONST GUID *, CONST DEVPROPKEY *, DEVPROPTYPE *, PBYTE, DWORD, PDWORD, DWORD, PCWSTR, PVOID );
WINSETUPAPI BOOL WINAPI     SetupDiGetClassPropertyKeys( CONST GUID *, DEVPROPKEY *, DWORD, PDWORD, DWORD );
WINSETUPAPI BOOL WINAPI     SetupDiGetClassPropertyKeysExW( CONST GUID *, DEVPROPKEY *, DWORD, PDWORD, DWORD, PCWSTR, PVOID );
WINSETUPAPI BOOL WINAPI     SetupDiGetClassPropertyW( CONST GUID *, CONST DEVPROPKEY *, DEVPROPTYPE *, PBYTE, DWORD, PDWORD, DWORD );
WINSETUPAPI BOOL WINAPI     SetupDiGetDeviceInterfacePropertyKeys( HDEVINFO, PSP_DEVICE_INTERFACE_DATA, DEVPROPKEY *, DWORD, PDWORD, DWORD );
WINSETUPAPI BOOL WINAPI     SetupDiGetDeviceInterfacePropertyW( HDEVINFO, PSP_DEVICE_INTERFACE_DATA, CONST DEVPROPKEY *, DEVPROPTYPE *, PBYTE, DWORD, PDWORD, DWORD );
WINSETUPAPI BOOL WINAPI     SetupDiGetDevicePropertyKeys( HDEVINFO, PSP_DEVINFO_DATA, DEVPROPKEY *, DWORD, PDWORD, DWORD );
WINSETUPAPI BOOL WINAPI     SetupDiGetDevicePropertyW( HDEVINFO, PSP_DEVINFO_DATA, CONST DEVPROPKEY *, DEVPROPTYPE *, PBYTE, DWORD, PDWORD, DWORD );
WINSETUPAPI BOOL WINAPI     SetupDiLoadDeviceIcon( HDEVINFO, PSP_DEVINFO_DATA, UINT, UINT, DWORD, HICON * );
WINSETUPAPI BOOL WINAPI     SetupDiSetClassPropertyExW( CONST GUID *, CONST DEVPROPKEY *, DEVPROPTYPE *, CONST PBYTE, DWORD, DWORD, PCWSTR, PVOID );
WINSETUPAPI BOOL WINAPI     SetupDiSetClassPropertyW( CONST GUID *, CONST DEVPROPKEY *, DEVPROPTYPE *, CONST PBYTE, DWORD, DWORD );
WINSETUPAPI BOOL WINAPI     SetupDiSetDeviceInterfacePropertyW( HDEVINFO, PSP_DEVICE_INTERFACE_DATA, CONST DEVPROPKEY *, DEVPROPTYPE *, CONST PBYTE, DWORD, DWORD );
WINSETUPAPI BOOL WINAPI     SetupDiSetDevicePropertyW( HDEVINFO, PSP_DEVINFO_DATA, CONST DEVPROPKEY *, DEVPROPTYPE, CONST PBYTE, DWORD, DWORD );
WINSETUPAPI BOOL WINAPI     SetupGetInfDriverStoreLocationA( PCSTR, PSP_ALTPLATFORM_INFO, PCSTR, PSTR, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupGetInfDriverStoreLocationW( PCWSTR, PSP_ALTPLATFORM_INFO, PCWSTR, PWSTR, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupGetInfPublishedNameA( PCSTR, PSTR, DWORD, PDWORD );
WINSETUPAPI BOOL WINAPI     SetupGetInfPublishedNameW( PCWSTR, PWSTR, DWORD, PDWORD );
WINSETUPAPI SP_LOG_TOKEN WINAPI SetupGetThreadLogToken( VOID );
WINSETUPAPI VOID WINAPI     SetupSetThreadLogToken( SP_LOG_TOKEN );
WINSETUPAPI VOID WINAPIV    SetupWriteTextLog( SP_LOG_TOKEN, DWORD, DWORD, PCSTR, ... );
WINSETUPAPI VOID WINAPIV    SetupWriteTextLogError( SP_LOG_TOKEN, DWORD, DWORD, DWORD, PCSTR, ... );
WINSETUPAPI VOID WINAPI     SetupWriteTextLogInfLine( SP_LOG_TOKEN, DWORD, HINF, PINFCONTEXT );
#endif

/* Aliases */
#define SetupDiCreateInterfaceDeviceA       SetupDiCreateDeviceInterfaceA
#define SetupDiCreateInterfaceDeviceRegKeyA SetupDiCreateDeviceInterfaceRegKeyA
#define SetupDiCreateInterfaceDeviceRegKeyW SetupDiCreateDeviceInterfaceRegKeyW
#define SetupDiCreateInterfaceDeviceW       SetupDiCreateDeviceInterfaceW
#define SetupDiDeleteInterfaceDeviceData    SetupDiDeleteDeviceInterfaceData
#define SetupDiDeleteInterfaceDeviceRegKey  SetupDiDeleteDeviceInterfaceRegKey
#define SetupDiEnumInterfaceDevice          SetupDiEnumDeviceInterfaces
#define SetupDiGetInterfaceDeviceAlias      SetupDiGetDeviceInterfaceAlias
#define SetupDiGetInterfaceDeviceDetailA    SetupDiGetDeviceInterfaceDetailA
#define SetupDiGetInterfaceDeviceDetailW    SetupDiGetDeviceInterfaceDetailW
#define SetupDiInstallInterfaceDevices      SetupDiInstallDeviceInterfaces
#define SetupDiOpenInterfaceDeviceA         SetupDiOpenDeviceInterfaceA
#define SetupDiOpenInterfaceDeviceRegKey    SetupDiOpenDeviceInterfaceRegKey
#define SetupDiOpenInterfaceDeviceW         SetupDiOpenDeviceInterfaceW
#define SetupDiRemoveInterfaceDevice        SetupDiRemoveDeviceInterface

/* Map generic function names to the appropriate ANSI or Unicode version. */
#ifdef UNICODE
    #define InstallHinfSection                  InstallHinfSectionW
    #define SetupAddInstallSectionToDiskSpaceList   SetupAddInstallSectionToDiskSpaceListW
    #define SetupAddSectionToDiskSpaceList      SetupAddSectionToDiskSpaceListW
    #define SetupAddToDiskSpaceList             SetupAddToDiskSpaceListW
    #define SetupAddToSourceList                SetupAddToSourceListW
    #define SetupAdjustDiskSpaceList            SetupAdjustDiskSpaceListW
    #define SetupBackupError                    SetupBackupErrorW
    #define SetupCommitFileQueue                SetupCommitFileQueueW
    #define SetupConfigureWmiFromInfSection     SetupConfigureWmiFromInfSectionW
    #define SetupCopyError                      SetupCopyErrorW
    #define SetupCopyOEMInf                     SetupCopyOEMInfW
    #define SetupCreateDiskSpaceList            SetupCreateDiskSpaceListW
    #define SetupDecompressOrCopyFile           SetupDecompressOrCopyFileW
    #define SetupDefaultQueueCallback           SetupDefaultQueueCallbackW
    #define SetupDeleteError                    SetupDeleteErrorW
    #define SetupDiBuildClassInfoListEx         SetupDiBuildClassInfoListExW
    #define SetupDiClassGuidsFromName           SetupDiClassGuidsFromNameW
    #define SetupDiClassGuidsFromNameEx         SetupDiClassGuidsFromNameExW
    #define SetupDiClassNameFromGuid            SetupDiClassNameFromGuidW
    #define SetupDiClassNameFromGuidEx          SetupDiClassNameFromGuidExW
    #define SetupDiCreateDevRegKey              SetupDiCreateDevRegKeyW
    #define SetupDiCreateDeviceInfo             SetupDiCreateDeviceInfoW
    #define SetupDiCreateDeviceInfoListEx       SetupDiCreateDeviceInfoListExW
    #define SetupDiCreateDeviceInterface        SetupDiCreateDeviceInterfaceW
    #define SetupDiCreateDeviceInterfaceRegKey  SetupDiCreateDeviceInterfaceRegKeyW
    #define SetupDiCreateInterfaceDevice        SetupDiCreateInterfaceDeviceW
    #define SetupDiCreateInterfaceDeviceRegKey  SetupDiCreateInterfaceDeviceRegKeyW
    #define SetupDiEnumDriverInfo               SetupDiEnumDriverInfoW
    #define SetupDiGetActualSectionToInstall    SetupDiGetActualSectionToInstallW
    #define SetupDiGetClassDescription          SetupDiGetClassDescriptionW
    #define SetupDiGetClassDescriptionEx        SetupDiGetClassDescriptionExW
    #define SetupDiGetClassDevPropertySheets    SetupDiGetClassDevPropertySheetsW
    #define SetupDiGetClassDevs                 SetupDiGetClassDevsW
    #define SetupDiGetClassDevsEx               SetupDiGetClassDevsExW
    #define SetupDiGetClassImageListEx          SetupDiGetClassImageListExW
    #define SetupDiGetClassInstallParams        SetupDiGetClassInstallParamsW
    #define SetupDiGetDeviceInfoListDetail      SetupDiGetDeviceInfoListDetailW
    #define SetupDiGetDeviceInstallParams       SetupDiGetDeviceInstallParamsW
    #define SetupDiGetDeviceInstanceId          SetupDiGetDeviceInstanceIdW
    #define SetupDiGetDeviceInterfaceDetail     SetupDiGetDeviceInterfaceDetailW
    #define SetupDiGetDeviceRegistryProperty    SetupDiGetDeviceRegistryPropertyW
    #define SetupDiGetDriverInfoDetail          SetupDiGetDriverInfoDetailW
    #define SetupDiGetDriverInstallParams       SetupDiGetDriverInstallParamsW
    #define SetupDiGetHwProfileFriendlyName     SetupDiGetHwProfileFriendlyNameW
    #define SetupDiGetHwProfileFriendlyNameEx   SetupDiGetHwProfileFriendlyNameExW
    #define SetupDiGetHwProfileListEx           SetupDiGetHwProfileListExW
    #define SetupDiGetINFClass                  SetupDiGetINFClassW
    #define SetupDiGetInterfaceDeviceDetail     SetupDiGetInterfaceDeviceDetailW
    #define SetupDiGetSelectedDriver            SetupDiGetSelectedDriverW
    #define SetupDiInstallClass                 SetupDiInstallClassW
    #define SetupDiInstallClassEx               SetupDiInstallClassExW
    #define SetupDiOpenClassRegKeyEx            SetupDiOpenClassRegKeyExW
    #define SetupDiOpenDeviceInfo               SetupDiOpenDeviceInfoW
    #define SetupDiOpenDeviceInterface          SetupDiOpenDeviceInterfaceW
    #define SetupDiOpenInterfaceDevice          SetupDiOpenInterfaceDeviceW
    #define SetupDiSetClassInstallParams        SetupDiSetClassInstallParamsW
    #define SetupDiSetDeviceInstallParams       SetupDiSetDeviceInstallParamsW
    #define SetupDiSetDeviceRegistryProperty    SetupDiSetDeviceRegistryPropertyW
    #define SetupDiSetDriverInstallParams       SetupDiSetDriverInstallParamsW
    #define SetupDiSetSelectedDriver            SetupDiSetSelectedDriverW
    #define SetupFindFirstLine                  SetupFindFirstLineW
    #define SetupFindNextMatchLine              SetupFindNextMatchLineW
    #define SetupFreeSourceList                 SetupFreeSourceListW
    #define SetupGetBackupInformation           SetupGetBackupInformationW
    #define SetupGetFileCompressionInfo         SetupGetFileCompressionInfoW
    #define SetupGetInfFileList                 SetupGetInfFileListW
    #define SetupGetInfInformation              SetupGetInfInformationW
    #define SetupGetLineByIndex                 SetupGetLineByIndexW
    #define SetupGetLineCount                   SetupGetLineCountW
    #define SetupGetLineText                    SetupGetLineTextW
    #define SetupGetMultiSzField                SetupGetMultiSzFieldW
    #define SetupGetSourceFileLocation          SetupGetSourceFileLocationW
    #define SetupGetSourceFileSize              SetupGetSourceFileSizeW
    #define SetupGetSourceInfo                  SetupGetSourceInfoW
    #define SetupGetStringField                 SetupGetStringFieldW
    #define SetupGetTargetPath                  SetupGetTargetPathW
    #define SetupInitializeFileLog              SetupInitializeFileLogW
    #define SetupInstallFile                    SetupInstallFileW
    #define SetupInstallFileEx                  SetupInstallFileExW
    #define SetupInstallFilesFromInfSection     SetupInstallFilesFromInfSectionW
    #define SetupInstallFromInfSection          SetupInstallFromInfSectionW
    #define SetupInstallServicesFromInfSection  SetupInstallServicesFromInfSectionW
    #define SetupInstallServicesFromInfSectionEx    SetupInstallServicesFromInfSectionExW
    #define SetupIterateCabinet                 SetupIterateCabinetW
    #define SetupLogError                       SetupLogErrorW
    #define SetupLogFile                        SetupLogFileW
    #define SetupOpenAppendInfFile              SetupOpenAppendInfFileW
    #define SetupOpenInfFile                    SetupOpenInfFileW
    #define SetupPromptForDisk                  SetupPromptForDiskW
    #define SetupQueryDrivesInDiskSpaceList     SetupQueryDrivesInDiskSpaceListW
    #define SetupQueryFileLog                   SetupQueryFileLogW
    #define SetupQueryInfFileInformation        SetupQueryInfFileInformationW
    #define SetupQueryInfOriginalFileInformation    SetupQueryInfOriginalFileInformationW
    #define SetupQueryInfVersionInformation     SetupQueryInfVersionInformationW
    #define SetupQuerySourceList                SetupQuerySourceListW
    #define SetupQuerySpaceRequiredOnDrive      SetupQuerySpaceRequiredOnDriveW
    #define SetupQueueCopy                      SetupQueueCopyW
    #define SetupQueueCopyIndirect              SetupQueueCopyIndirectW
    #define SetupQueueCopySection               SetupQueueCopySectionW
    #define SetupQueueDefaultCopy               SetupQueueDefaultCopyW
    #define SetupQueueDelete                    SetupQueueDeleteW
    #define SetupQueueDeleteSection             SetupQueueDeleteSectionW
    #define SetupQueueRename                    SetupQueueRenameW
    #define SetupQueueRenameSection             SetupQueueRenameSectionW
    #define SetupRemoveFileLogEntry             SetupRemoveFileLogEntryW
    #define SetupRemoveFromDiskSpaceList        SetupRemoveFromDiskSpaceListW
    #define SetupRemoveFromSourceList           SetupRemoveFromSourceListW
    #define SetupRemoveInstallSectionFromDiskSpaceList  SetupRemoveInstallSectionFromDiskSpaceListW
    #define SetupRemoveSectionFromDiskSpaceList SetupRemoveSectionFromDiskSpaceListW
    #define SetupRenameError                    SetupRenameErrorW
    #define SetupScanFileQueue                  SetupScanFileQueueW
    #define SetupSetDirectoryId                 SetupSetDirectoryIdW
    #define SetupSetDirectoryIdEx               SetupSetDirectoryIdExW
    #define SetupSetFileQueueAlternatePlatform  SetupSetFileQueueAlternatePlatformW
    #define SetupSetPlatformPathOverride        SetupSetPlatformPathOverrideW
    #define SetupSetSourceList                  SetupSetSourceListW
    #if (_SETUPAPI_VER >= 0x0501)
        #define SetupDiGetActualSectionToInstallEx  SetupGetActualSectionToInstallExW
        #define SetupDiGetClassRegistryProperty SetupDiGetClassRegistryPropertyW
        #define SetupDiGetCustomDeviceProperty  SetupDiGetCustomDevicePropertyW
        #define SetupDiSetClassRegistryProperty SetupDiSetClassRegistryPropertyW
        #define SetupEnumInfSections            SetupEnumInfSectionsW
        #define SetupGetFileCompressionInfoEx   SetupGetFileCompressionInfoExW
        #define SetupPrepareQueueForRestore     SetupPrepareQueueForRestoreW
        #define SetupUninstallOEMInf            SetupUninstallOEMInfW
        #define SetupVerifyInfFile              SetupVerifyInfFileW
    #endif
    #if (_SETUPAPI_VER >= 0x0502)
        #define SetupDiGetActualModelsSection   SetupDiGetActualModelsSectionW
    #endif
    #if (_SETUPAPI_VER >= 0x0600)
        #define SetupDiGetClassProperty         SetupDiGetClassPropertyW
        #define SetupDiGetClassPropertyEx       SetupDiGetClassPropertyExW
        #define SetupDiGetClassPropertyKeysEx   SetupDiGetClassPropertyKeysExW
        #define SetupDiGetDeviceInterfaceProperty   SetupDiGetDeviceInterfacePropertyW
        #define SetupDiGetDeviceProperty        SetupDiGetDevicePropertyW
        #define SetupDiSetClassProperty         SetupDiSetClassPropertyW
        #define SetupDiSetClassPropertyEx       SetupDiSetClassPropertyExW
        #define SetupDiSetDeviceInterfaceProperty   SetupDiSetDeviceInterfacePropertyW
        #define SetupDiSetDeviceProperty        SetupDiSetDevicePropertyW
        #define SetupGetInfDriverStoreLocation  SetupGetInfDriverStoreLocationW
        #define SetupGetInfPublishedName        SetupGetInfPublishedNameW
    #endif
#else
    #define InstallHinfSection                  InstallHinfSectionA
    #define SetupAddInstallSectionToDiskSpaceList   SetupAddInstallSectionToDiskSpaceListA
    #define SetupAddSectionToDiskSpaceList      SetupAddSectionToDiskSpaceListA
    #define SetupAddToDiskSpaceList             SetupAddToDiskSpaceListA
    #define SetupAddToSourceList                SetupAddToSourceListA
    #define SetupAdjustDiskSpaceList            SetupAdjustDiskSpaceListA
    #define SetupBackupError                    SetupBackupErrorA
    #define SetupCommitFileQueue                SetupCommitFileQueueA
    #define SetupConfigureWmiFromInfSection     SetupConfigureWmiFromInfSectionA
    #define SetupCopyError                      SetupCopyErrorA
    #define SetupCopyOEMInf                     SetupCopyOEMInfA
    #define SetupCreateDiskSpaceList            SetupCreateDiskSpaceListA
    #define SetupDecompressOrCopyFile           SetupDecompressOrCopyFileA
    #define SetupDefaultQueueCallback           SetupDefaultQueueCallbackA
    #define SetupDeleteError                    SetupDeleteErrorA
    #define SetupDiBuildClassInfoListEx         SetupDiBuildClassInfoListExA
    #define SetupDiClassGuidsFromName           SetupDiClassGuidsFromNameA
    #define SetupDiClassGuidsFromNameEx         SetupDiClassGuidsFromNameExA
    #define SetupDiClassNameFromGuid            SetupDiClassNameFromGuidA
    #define SetupDiClassNameFromGuidEx          SetupDiClassNameFromGuidExA
    #define SetupDiCreateDevRegKey              SetupDiCreateDevRegKeyA
    #define SetupDiCreateDeviceInfo             SetupDiCreateDeviceInfoA
    #define SetupDiCreateDeviceInfoListEx       SetupDiCreateDeviceInfoListExA
    #define SetupDiCreateDeviceInterface        SetupDiCreateDeviceInterfaceA
    #define SetupDiCreateDeviceInterfaceRegKey  SetupDiCreateDeviceInterfaceRegKeyA
    #define SetupDiCreateInterfaceDevice        SetupDiCreateInterfaceDeviceA
    #define SetupDiCreateInterfaceDeviceRegKey  SetupDiCreateInterfaceDeviceRegKeyA
    #define SetupDiEnumDriverInfo               SetupDiEnumDriverInfoA
    #define SetupDiGetActualSectionToInstall    SetupDiGetActualSectionToInstallA
    #define SetupDiGetClassDescription          SetupDiGetClassDescriptionA
    #define SetupDiGetClassDescriptionEx        SetupDiGetClassDescriptionExA
    #define SetupDiGetClassDevPropertySheets    SetupDiGetClassDevPropertySheetsA
    #define SetupDiGetClassDevs                 SetupDiGetClassDevsA
    #define SetupDiGetClassDevsEx               SetupDiGetClassDevsExA
    #define SetupDiGetClassImageListEx          SetupDiGetClassImageListExA
    #define SetupDiGetClassInstallParams        SetupDiGetClassInstallParamsA
    #define SetupDiGetDeviceInfoListDetail      SetupDiGetDeviceInfoListDetailA
    #define SetupDiGetDeviceInstallParams       SetupDiGetDeviceInstallParamsA
    #define SetupDiGetDeviceInstanceId          SetupDiGetDeviceInstanceIdA
    #define SetupDiGetDeviceInterfaceDetail     SetupDiGetDeviceInterfaceDetailA
    #define SetupDiGetDeviceRegistryProperty    SetupDiGetDeviceRegistryPropertyA
    #define SetupDiGetDriverInfoDetail          SetupDiGetDriverInfoDetailA
    #define SetupDiGetDriverInstallParams       SetupDiGetDriverInstallParamsA
    #define SetupDiGetHwProfileFriendlyName     SetupDiGetHwProfileFriendlyNameA
    #define SetupDiGetHwProfileFriendlyNameEx   SetupDiGetHwProfileFriendlyNameExA
    #define SetupDiGetHwProfileListEx           SetupDiGetHwProfileListExA
    #define SetupDiGetINFClass                  SetupDiGetINFClassA
    #define SetupDiGetInterfaceDeviceDetail     SetupDiGetInterfaceDeviceDetailA
    #define SetupDiGetSelectedDriver            SetupDiGetSelectedDriverA
    #define SetupDiInstallClass                 SetupDiInstallClassA
    #define SetupDiInstallClassEx               SetupDiInstallClassExA
    #define SetupDiOpenClassRegKeyEx            SetupDiOpenClassRegKeyExA
    #define SetupDiOpenDeviceInfo               SetupDiOpenDeviceInfoA
    #define SetupDiOpenDeviceInterface          SetupDiOpenDeviceInterfaceA
    #define SetupDiOpenInterfaceDevice          SetupDiOpenInterfaceDeviceA
    #define SetupDiSetClassInstallParams        SetupDiSetClassInstallParamsA
    #define SetupDiSetDeviceInstallParams       SetupDiSetDeviceInstallParamsA
    #define SetupDiSetDeviceRegistryProperty    SetupDiSetDeviceRegistryPropertyA
    #define SetupDiSetDriverInstallParams       SetupDiSetDriverInstallParamsA
    #define SetupDiSetSelectedDriver            SetupDiSetSelectedDriverA
    #define SetupFindFirstLine                  SetupFindFirstLineA
    #define SetupFindNextMatchLine              SetupFindNextMatchLineA
    #define SetupFreeSourceList                 SetupFreeSourceListA
    #define SetupGetBackupInformation           SetupGetBackupInformationA
    #define SetupGetFileCompressionInfo         SetupGetFileCompressionInfoA
    #define SetupGetInfFileList                 SetupGetInfFileListA
    #define SetupGetInfInformation              SetupGetInfInformationA
    #define SetupGetLineByIndex                 SetupGetLineByIndexA
    #define SetupGetLineCount                   SetupGetLineCountA
    #define SetupGetLineText                    SetupGetLineTextA
    #define SetupGetMultiSzField                SetupGetMultiSzFieldA
    #define SetupGetSourceFileLocation          SetupGetSourceFileLocationA
    #define SetupGetSourceFileSize              SetupGetSourceFileSizeA
    #define SetupGetSourceInfo                  SetupGetSourceInfoA
    #define SetupGetStringField                 SetupGetStringFieldA
    #define SetupGetTargetPath                  SetupGetTargetPathA
    #define SetupInitializeFileLog              SetupInitializeFileLogA
    #define SetupInstallFile                    SetupInstallFileA
    #define SetupInstallFileEx                  SetupInstallFileExA
    #define SetupInstallFilesFromInfSection     SetupInstallFilesFromInfSectionA
    #define SetupInstallFromInfSection          SetupInstallFromInfSectionA
    #define SetupInstallServicesFromInfSection  SetupInstallServicesFromInfSectionA
    #define SetupInstallServicesFromInfSectionEx    SetupInstallServicesFromInfSectionExA
    #define SetupIterateCabinet                 SetupIterateCabinetA
    #define SetupLogError                       SetupLogErrorA
    #define SetupLogFile                        SetupLogFileA
    #define SetupOpenAppendInfFile              SetupOpenAppendInfFileA
    #define SetupOpenInfFile                    SetupOpenInfFileA
    #define SetupPromptForDisk                  SetupPromptForDiskA
    #define SetupQueryDrivesInDiskSpaceList     SetupQueryDrivesInDiskSpaceListA
    #define SetupQueryFileLog                   SetupQueryFileLogA
    #define SetupQueryInfFileInformation        SetupQueryInfFileInformationA
    #define SetupQueryInfOriginalFileInformation    SetupQueryInfOriginalFileInformationA
    #define SetupQueryInfVersionInformation     SetupQueryInfVersionInformationA
    #define SetupQuerySourceList                SetupQuerySourceListA
    #define SetupQuerySpaceRequiredOnDrive      SetupQuerySpaceRequiredOnDriveA
    #define SetupQueueCopy                      SetupQueueCopyA
    #define SetupQueueCopyIndirect              SetupQueueCopyIndirectA
    #define SetupQueueCopySection               SetupQueueCopySectionA
    #define SetupQueueDefaultCopy               SetupQueueDefaultCopyA
    #define SetupQueueDelete                    SetupQueueDeleteA
    #define SetupQueueDeleteSection             SetupQueueDeleteSectionA
    #define SetupQueueRename                    SetupQueueRenameA
    #define SetupQueueRenameSection             SetupQueueRenameSectionA
    #define SetupRemoveFileLogEntry             SetupRemoveFileLogEntryA
    #define SetupRemoveFromDiskSpaceList        SetupRemoveFromDiskSpaceListA
    #define SetupRemoveFromSourceList           SetupRemoveFromSourceListA
    #define SetupRemoveInstallSectionFromDiskSpaceList  SetupRemoveInstallSectionFromDiskSpaceListA
    #define SetupRemoveSectionFromDiskSpaceList SetupRemoveSectionFromDiskSpaceListA
    #define SetupRenameError                    SetupRenameErrorA
    #define SetupScanFileQueue                  SetupScanFileQueueA
    #define SetupSetDirectoryId                 SetupSetDirectoryIdA
    #define SetupSetDirectoryIdEx               SetupSetDirectoryIdExA
    #define SetupSetFileQueueAlternatePlatform  SetupSetFileQueueAlternatePlatformA
    #define SetupSetPlatformPathOverride        SetupSetPlatformPathOverrideA
    #define SetupSetSourceList                  SetupSetSourceListA
    #if (_SETUPAPI_VER >= 0x0501)
        #define SetupDiGetActualSectionToInstallEx  SetupDiGetActualSectionToInstallExA
        #define SetupDiGetClassRegistryProperty SetupDiGetClassRegistryPropertyA
        #define SetupDiGetCustomDeviceProperty  SetupDiGetCustomDevicePropertyA
        #define SetupDiSetClassRegistryProperty SetupDiSetClassRegistryPropertyA
        #define SetupEnumInfSections            SetupEnumInfSectionsA
        #define SetupGetFileCompressionInfoEx   SetupGetFileCompressionInfoExA
        #define SetupPrepareQueueForRestore     SetupPrepareQueueForRestoreA
        #define SetupUninstallOEMInf            SetupUninstallOEMInfA
        #define SetupVerifyInfFile              SetupVerifyInfFileA
    #endif
    #if (_SETUPAPI_VER >= 0x0502)
        #define SetupDiGetActualModelsSection   SetupDiGetActualModelsSectionA
    #endif
    #if (_SETUPAPI_VER >= 0x0600)
        #define SetupGetInfDriverStoreLocation  SetupGetInfDriverStoreLocationA
        #define SetupGetInfPublishedName        SetupGetInfPublishedNameA
    #endif
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#pragma pack( __pop )

#endif /* _INC_SETUPAPI */
