/*
 *  winefs.h    Win32 Encryption File System (EFS) functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef __WINEFS_H__
#define __WINEFS_H__

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Algorithm identifier data type */
#if (NTDDI_VERSION >= 0x05010000)
#ifndef ALGIDDEF
#define ALGIDDEF
typedef unsigned int    ALG_ID;
#endif
#endif

/* Maximum SID size */
#if (NTDDI_VERSION >= 0x05000000)
    #define MAX_SID_SIZE    256
#endif

/* EFS access types */
#if (NTDDI_VERSION >= 0x06000000)
    #define EFS_METADATA_ADD_USER       0x00000001L
    #define EFS_METADATA_REMOVE_USER    0x00000002L
    #define EFS_METADATA_REPLACE_USER   0x00000004L
    #define EFS_METADATA_GENERAL_OP     0x00000008L
#endif

/* Certificate blob */
#if (NTDDI_VERSION >= 0x05000000)
typedef struct _CERTIFICATE_BLOB {
    DWORD   dwCertEncodingType;
    DWORD   cbData;
    PBYTE   pbData;
} EFS_CERTIFICATE_BLOB;
typedef EFS_CERTIFICATE_BLOB    *PEFS_CERTIFICATE_BLOB;
#endif

/* EFS hash blob */
#if (NTDDI_VERSION >= 0x05000000)
typedef struct _EFS_HASH_BLOB {
    DWORD   cbData;
    PBYTE   pbData;
} EFS_HASH_BLOB;
typedef EFS_HASH_BLOB   *PEFS_HASH_BLOB;
#endif

/* EFS RPC blob */
#if (NTDDI_VERSION >= 0x05010000)
typedef struct _EFS_RPC_BLOB {
    DWORD   cbData;
    PBYTE   pbData;
} EFS_RPC_BLOB;
typedef EFS_RPC_BLOB    *PEFS_RPC_BLOB;
#endif

/* EFS pin blob */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _EFS_PIN_BLOB {
    DWORD   cbPadding;
    DWORD   cbData;
    PBYTE   pbData;
} EFS_PIN_BLOB;
typedef EFS_PIN_BLOB    *PEFS_PIN_BLOB;
#endif

/* EFS key information */
#if (NTDDI_VERSION >= 0x05010000)
typedef struct _EFS_KEY_INFO {
    DWORD   dwVersion;
    ULONG   Entropy;
    ALG_ID  Algorithm;
    ULONG   KeyLength;
} EFS_KEY_INFO;
typedef EFS_KEY_INFO    *PEFS_KEY_INFO;
#endif

/* EFS compatibility information */
#if (NTDDI_VERSION >= 0x06010000)
typedef struct _EFS_COMPATIBILITY_INFO {
    DWORD   EfsVersion;
} EFS_COMPATIBILITY_INFO;
typedef EFS_COMPATIBILITY_INFO  *PEFS_COMPATIBILITY_INFO;
#endif

/* EFS decryption status information */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _EFS_DECRYPTION_STATUS_INFO {
    DWORD   dwDecryptionError;
    DWORD   dwHashOffset;
    DWORD   cbHash;
} EFS_DECRYPTION_STATUS_INFO;
typedef EFS_DECRYPTION_STATUS_INFO  *PEFS_DECRYPTION_STATUS_INFO;
#endif

/* EFS encryption status information */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _EFS_ENCRYPTION_STATUS_INFO {
    BOOL    fHasCurrentKey;
    DWORD   dwEncryptionError;
} EFS_ENCRYPTION_STATUS_INFO;
typedef EFS_ENCRYPTION_STATUS_INFO  *PEFS_ENCRYPTION_STATUS_INFO;
#endif

/* Encryption certificate */
#if (NTDDI_VERSION >= 0x05000000)
typedef struct _ENCRYPTION_CERTIFICATE {
    DWORD                   cbTotalLength;
    SID                     *pUserSid;
    PEFS_CERTIFICATE_BLOB   pCertBlob;
} ENCRYPTION_CERTIFICATE;
typedef ENCRYPTION_CERTIFICATE  *PENCRYPTION_CERTIFICATE;
#endif

/* Encryption certificate hash */
#if (NTDDI_VERSION >= 0x05000000)
typedef struct _ENCRYPTION_CERTIFICATE_HASH {
    DWORD           cbTotalLength;
    SID             *pUserSid;
    PEFS_HASH_BLOB  pHash;
    LPWSTR          lpDisplayInformation;
} ENCRYPTION_CERTIFICATE_HASH;
typedef ENCRYPTION_CERTIFICATE_HASH *PENCRYPTION_CERTIFICATE_HASH;
#endif

/* Encryption certificate hash list */
#if (NTDDI_VERSION >= 0x05000000)
typedef struct _ENCRYPTION_CERTIFICATE_HASH_LIST {
    DWORD                           nCert_Hash;
    PENCRYPTION_CERTIFICATE_HASH    *pUsers;
} ENCRYPTION_CERTIFICATE_HASH_LIST;
typedef ENCRYPTION_CERTIFICATE_HASH_LIST    *PENCRYPTION_CERTIFICATE_HASH_LIST;
#endif

/* Encryption certificate list */
#if (NTDDI_VERSION >= 0x05000000)
typedef struct _ENCRYPTION_CERTIFICATE_LIST {
    DWORD                   nUsers;
    PENCRYPTION_CERTIFICATE *pUsers;
} ENCRYPTION_CERTIFICATE_LIST;
typedef ENCRYPTION_CERTIFICATE_LIST *PENCRYPTION_CERTIFICATE_LIST;
#endif

/* Encrypted file metadata signature */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _ENCRYPTED_FILE_METADATA_SIGNATURE {
    DWORD                               dwEfsAccessType;
    PENCRYPTION_CERTIFICATE_HASH_LIST   pCertificatesAdded;
    PENCRYPTION_CERTIFICATE             pEncryptionCertificate;
    PEFS_RPC_BLOB                       pEfsStreamSignature;
} ENCRYPTED_FILE_METADATA_SIGNATURE;
typedef ENCRYPTED_FILE_METADATA_SIGNATURE   *PENCRYPTED_FILE_METADATA_SIGNATURE;
#endif

/* Functions in ADVAPI32.DLL */
#if (NTDDI_VERSION >= 0x05000000)
WINADVAPI DWORD WINAPI  AddUsersToEncryptedFile( LPCWSTR, PENCRYPTION_CERTIFICATE_LIST );
WINADVAPI BOOL WINAPI   EncryptionDisable( LPCWSTR, BOOL );
WINADVAPI VOID WINAPI   FreeEncryptionCertificateHashList( PENCRYPTION_CERTIFICATE_HASH_LIST );
WINADVAPI DWORD WINAPI  QueryRecoveryAgentsOnEncryptedFile( LPCWSTR, PENCRYPTION_CERTIFICATE_HASH_LIST * );
WINADVAPI DWORD WINAPI  QueryUsersOnEncryptedFile( LPCWSTR, PENCRYPTION_CERTIFICATE_HASH_LIST * );
WINADVAPI DWORD WINAPI  RemoveUsersFromEncryptedFile( LPCWSTR, PENCRYPTION_CERTIFICATE_HASH_LIST );
WINADVAPI DWORD WINAPI  SetUserFileEncryptionKey( PENCRYPTION_CERTIFICATE );
#endif
#if (NTDDI_VERSION >= 0x50200000)
WINADVAPI DWORD WINAPI  DuplicateEncryptionInfoFile( LPCWSTR, LPCWSTR, DWORD, DWORD, CONST LPSECURITY_ATTRIBUTES );
#elif (NTDDI_VERSION >= 0x05010000)
WINADVAPI DWORD WINAPI  DuplicateEncryptionInfoFile( LPCWSTR, LPCWSTR, DWORD, DWORD, LPSECURITY_ATTRIBUTES );
#endif
#if (NTDDI_VERSION >= 0x06000000)
WINADVAPI VOID WINAPI   FreeEncryptedFileMetadata( PBYTE );
WINADVAPI DWORD WINAPI  GetEncryptedFileMetadata( LPCWSTR, PDWORD, PBYTE * );
WINADVAPI DWORD WINAPI  SetEncryptedFileMetadata( LPCWSTR, PBYTE, PBYTE, PENCRYPTION_CERTIFICATE_HASH, DWORD, PENCRYPTION_CERTIFICATE_HASH_LIST );
WINADVAPI DWORD WINAPI  SetUserFileEncryptionKeyEx( PENCRYPTION_CERTIFICATE, DWORD, DWORD, LPVOID );
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __WINEFS_H__ */
