/*
 *  winerror.h  Win32 error codes
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _WINERROR_
#define _WINERROR_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Facility codes */
#define FACILITY_XPS                        82
#define FACILITY_WINRM                      51
#define FACILITY_WINDOWSUPDATE              36
#define FACILITY_WINDOWS_DEFENDER           80
#define FACILITY_WINDOWS_CE                 24
#define FACILITY_WINDOWS                    8
#define FACILITY_USERMODE_VOLMGR            56
#define FACILITY_USERMODE_VIRTUALIZATION    55
#define FACILITY_USERMODE_VHD               58
#define FACILITY_URT                        19
#define FACILITY_UMI                        22
#define FACILITY_UI                         42
#define FACILITY_TPM_SOFTWARE               41
#define FACILITY_TPM_SERVICES               40
#define FACILITY_SXS                        23
#define FACILITY_STORAGE                    3
#define FACILITY_STATE_MANAGEMENT           34
#define FACILITY_SSPI                       9
#define FACILITY_SCARD                      16
#define FACILITY_SHELL                      39
#define FACILITY_SETUPAPI                   15
#define FACILITY_SECURITY                   9
#define FACILITY_SDIAG                      60
#define FACILITY_RPC                        1
#define FACILITY_RAS                        83
#define FACILITY_PLA                        48
#define FACILITY_OPC                        81
#define FACILITY_WIN32                      7
#define FACILITY_CONTROL                    10
#define FACILITY_WEBSERVICES                61
#define FACILITY_NULL                       0
#define FACILITY_NDIS                       52
#define FACILITY_METADIRECTORY              35
#define FACILITY_MSMQ                       14
#define FACILITY_MEDIASERVER                13
#define FACILITY_MBN                        84
#define FACILITY_INTERNET                   12
#define FACILITY_ITF                        4
#define FACILITY_USERMODE_HYPERVISOR        53
#define FACILITY_HTTP                       25
#define FACILITY_GRAPHICS                   38
#define FACILITY_FWP                        50
#define FACILITY_FVE                        49
#define FACILITY_USERMODE_FILTER_MANAGER    31
#define FACILITY_DPLAY                      21
#define FACILITY_DISPATCH                   2
#define FACILITY_DIRECTORYSERVICE           37
#define FACILITY_CONFIGURATION              33
#define FACILITY_COMPLUS                    17
#define FACILITY_USERMODE_COMMONLOG         26
#define FACILITY_CMI                        54
#define FACILITY_CERT                       11
#define FACILITY_BCD                        57
#define FACILITY_BACKGROUNDCOPY             32
#define FACILITY_ACS                        20
#define FACILITY_AAF                        18

/* Success value */
#define NO_ERROR    0L

/* Security success value */
#define SEC_E_OK    0x00000000L

/* Error codes */
#define ERROR_SUCCESS                                   0L
#define ERROR_INVALID_FUNCTION                          1L
#define ERROR_FILE_NOT_FOUND                            2L
#define ERROR_PATH_NOT_FOUND                            3L
#define ERROR_TOO_MANY_OPEN_FILES                       4L
#define ERROR_ACCESS_DENIED                             5L
#define ERROR_INVALID_HANDLE                            6L
#define ERROR_ARENA_TRASHED                             7L
#define ERROR_NOT_ENOUGH_MEMORY                         8L
#define ERROR_INVALID_BLOCK                             9L
#define ERROR_BAD_ENVIRONMENT                           10L
#define ERROR_BAD_FORMAT                                11L
#define ERROR_INVALID_ACCESS                            12L
#define ERROR_INVALID_DATA                              13L
#define ERROR_OUTOFMEMORY                               14L
#define ERROR_INVALID_DRIVE                             15L
#define ERROR_CURRENT_DIRECTORY                         16L
#define ERROR_NOT_SAME_DEVICE                           17L
#define ERROR_NO_MORE_FILES                             18L
#define ERROR_WRITE_PROTECT                             19L
#define ERROR_BAD_UNIT                                  20L
#define ERROR_NOT_READY                                 21L
#define ERROR_BAD_COMMAND                               22L
#define ERROR_CRC                                       23L
#define ERROR_BAD_LENGTH                                24L
#define ERROR_SEEK                                      25L
#define ERROR_NOT_DOS_DISK                              26L
#define ERROR_SECTOR_NOT_FOUND                          27L
#define ERROR_OUT_OF_PAPER                              28L
#define ERROR_WRITE_FAULT                               29L
#define ERROR_READ_FAULT                                30L
#define ERROR_GEN_FAILURE                               31L
#define ERROR_SHARING_VIOLATION                         32L
#define ERROR_LOCK_VIOLATION                            33L
#define ERROR_WRONG_DISK                                34L
#define ERROR_SHARING_BUFFER_EXCEEDED                   36L
#define ERROR_HANDLE_EOF                                38L
#define ERROR_HANDLE_DISK_FULL                          39L
#define ERROR_NOT_SUPPORTED                             50L
#define ERROR_REM_NOT_LIST                              51L
#define ERROR_DUP_NAME                                  52L
#define ERROR_BAD_NETPATH                               53L
#define ERROR_NETWORK_BUSY                              54L
#define ERROR_DEV_NOT_EXIST                             55L
#define ERROR_TOO_MANY_CMDS                             56L
#define ERROR_ADAP_HDW_ERR                              57L
#define ERROR_BAD_NET_RESP                              58L
#define ERROR_UNEXP_NET_ERR                             59L
#define ERROR_BAD_REM_ADAP                              60L
#define ERROR_PRINTQ_FULL                               61L
#define ERROR_NO_SPOOL_SPACE                            62L
#define ERROR_PRINT_CANCELLED                           63L
#define ERROR_NETNAME_DELETED                           64L
#define ERROR_NETWORK_ACCESS_DENIED                     65L
#define ERROR_BAD_DEV_TYPE                              66L
#define ERROR_BAD_NET_NAME                              67L
#define ERROR_TOO_MANY_NAMES                            68L
#define ERROR_TOO_MANY_SESS                             69L
#define ERROR_SHARING_PAUSED                            70L
#define ERROR_REQ_NOT_ACCEP                             71L
#define ERROR_REDIR_PAUSED                              72L
#define ERROR_FILE_EXISTS                               80L
#define ERROR_CANNOT_MAKE                               82L
#define ERROR_FAIL_I24                                  83L
#define ERROR_OUT_OF_STRUCTURES                         84L
#define ERROR_ALREADY_ASSIGNED                          85L
#define ERROR_INVALID_PASSWORD                          86L
#define ERROR_INVALID_PARAMETER                         87L
#define ERROR_NET_WRITE_FAULT                           88L
#define ERROR_NO_PROC_SLOTS                             89L
#define ERROR_TOO_MANY_SEMAPHORES                       100L
#define ERROR_EXCL_SEM_ALREADY_OWNED                    101L
#define ERROR_SEM_IS_SET                                102L
#define ERROR_TOO_MANY_SEM_REQUESTS                     103L
#define ERROR_INVALID_AT_INTERRUPT_TIME                 104L
#define ERROR_SEM_OWNER_DIED                            105L
#define ERROR_SEM_USER_LIMIT                            106L
#define ERROR_DISK_CHANGE                               107L
#define ERROR_DRIVE_LOCKED                              108L
#define ERROR_BROKEN_PIPE                               109L
#define ERROR_OPEN_FAILED                               110L
#define ERROR_BUFFER_OVERFLOW                           111L
#define ERROR_DISK_FULL                                 112L
#define ERROR_NO_MORE_SEARCH_HANDLES                    113L
#define ERROR_INVALID_TARGET_HANDLE                     114L
#define ERROR_INVALID_CATEGORY                          117L
#define ERROR_INVALID_VERIFY_SWITCH                     118L
#define ERROR_BAD_DRIVER_LEVEL                          119L
#define ERROR_CALL_NOT_IMPLEMENTED                      120L
#define ERROR_SEM_TIMEOUT                               121L
#define ERROR_INSUFFICIENT_BUFFER                       122L
#define ERROR_INVALID_NAME                              123L
#define ERROR_INVALID_LEVEL                             124L
#define ERROR_NO_VOLUME_LABEL                           125L
#define ERROR_MOD_NOT_FOUND                             126L
#define ERROR_PROC_NOT_FOUND                            127L
#define ERROR_WAIT_NO_CHILDREN                          128L
#define ERROR_CHILD_NOT_COMPLETE                        129L
#define ERROR_DIRECT_ACCESS_HANDLE                      130L
#define ERROR_NEGATIVE_SEEK                             131L
#define ERROR_SEEK_ON_DEVICE                            132L
#define ERROR_IS_JOIN_TARGET                            133L
#define ERROR_IS_JOINED                                 134L
#define ERROR_IS_SUBSTED                                135L
#define ERROR_NOT_JOINED                                136L
#define ERROR_NOT_SUBSTED                               137L
#define ERROR_JOIN_TO_JOIN                              138L
#define ERROR_SUBST_TO_SUBST                            139L
#define ERROR_JOIN_TO_SUBST                             140L
#define ERROR_SUBST_TO_JOIN                             141L
#define ERROR_BUSY_DRIVE                                142L
#define ERROR_SAME_DRIVE                                143L
#define ERROR_DIR_NOT_ROOT                              144L
#define ERROR_DIR_NOT_EMPTY                             145L
#define ERROR_IS_SUBST_PATH                             146L
#define ERROR_IS_JOIN_PATH                              147L
#define ERROR_PATH_BUSY                                 148L
#define ERROR_IS_SUBST_TARGET                           149L
#define ERROR_SYSTEM_TRACE                              150L
#define ERROR_INVALID_EVENT_COUNT                       151L
#define ERROR_TOO_MANY_MUXWAITERS                       152L
#define ERROR_INVALID_LIST_FORMAT                       153L
#define ERROR_LABEL_TOO_LONG                            154L
#define ERROR_TOO_MANY_TCBS                             155L
#define ERROR_SIGNAL_REFUSED                            156L
#define ERROR_DISCARDED                                 157L
#define ERROR_NOT_LOCKED                                158L
#define ERROR_BAD_THREADID_ADDR                         159L
#define ERROR_BAD_ARGUMENTS                             160L
#define ERROR_BAD_PATHNAME                              161L
#define ERROR_SIGNAL_PENDING                            162L
#define ERROR_MAX_THRDS_REACHED                         164L
#define ERROR_LOCK_FAILED                               167L
#define ERROR_BUSY                                      170L
#define ERROR_CANCEL_VIOLATION                          173L
#define ERROR_ATOMIC_LOCKS_NOT_SUPPORTED                174L
#define ERROR_INVALID_SEGMENT_NUMBER                    180L
#define ERROR_INVALID_ORDINAL                           182L
#define ERROR_ALREADY_EXISTS                            183L
#define ERROR_INVALID_FLAG_NUMBER                       186L
#define ERROR_SEM_NOT_FOUND                             187L
#define ERROR_INVALID_STARTING_CODESEG                  188L
#define ERROR_INVALID_STACKSEG                          189L
#define ERROR_INVALID_MODULETYPE                        190L
#define ERROR_INVALID_EXE_SIGNATURE                     191L
#define ERROR_EXE_MARKED_INVALID                        192L
#define ERROR_BAD_EXE_FORMAT                            193L
#define ERROR_ITERATED_DATA_EXCEEDS_64k                 194L
#define ERROR_INVALID_MINALLOCSIZE                      195L
#define ERROR_DYNLINK_FROM_INVALID_RING                 196L
#define ERROR_IOPL_NOT_ENABLED                          197L
#define ERROR_INVALID_SEGDPL                            198L
#define ERROR_AUTODATASEG_EXCEEDS_64k                   199L
#define ERROR_RING2SEG_MUST_BE_MOVABLE                  200L
#define ERROR_RELOC_CHAIN_XEEDS_SEGLIM                  201L
#define ERROR_INFLOOP_IN_RELOC_CHAIN                    202L
#define ERROR_ENVVAR_NOT_FOUND                          203L
#define ERROR_NO_SIGNAL_SENT                            205L
#define ERROR_FILENAME_EXCED_RANGE                      206L
#define ERROR_RING2_STACK_IN_USE                        207L
#define ERROR_META_EXPANSION_TOO_LONG                   208L
#define ERROR_INVALID_SIGNAL_NUMBER                     209L
#define ERROR_THREAD_1_INACTIVE                         210L
#define ERROR_LOCKED                                    212L
#define ERROR_TOO_MANY_MODULES                          214L
#define ERROR_NESTING_NOT_ALLOWED                       215L
#define ERROR_EXE_MACHINE_TYPE_MISMATCH                 216L
#define ERROR_EXE_CANNOT_MODIFY_SIGNED_BINARY           217L
#define ERROR_EXE_CANNOT_MODIFY_STRONG_SIGNED_BINARY    218L
#define ERROR_FILE_CHECKED_OUT                          220L
#define ERROR_CHECKOUT_REQUIRED                         221L
#define ERROR_BAD_FILE_TYPE                             222L
#define ERROR_FILE_TOO_LARGE                            223L
#define ERROR_FORMS_AUTH_REQUIRED                       224L
#define ERROR_VIRUS_INFECTED                            225L
#define ERROR_VIRUS_DELETED                             226L
#define ERROR_PIPE_LOCAL                                229L
#define ERROR_BAD_PIPE                                  230L
#define ERROR_PIPE_BUSY                                 231L
#define ERROR_NO_DATA                                   232L
#define ERROR_PIPE_NOT_CONNECTED                        233L
#define ERROR_MORE_DATA                                 234L
#define ERROR_VC_DISCONNECTED                           240L
#define ERROR_INVALID_EA_NAME                           254L
#define ERROR_EA_LIST_INCONSISTENT                      255L
#define WAIT_TIMEOUT                                    258L
#define ERROR_NO_MORE_ITEMS                             259L
#define ERROR_CANNOT_COPY                               266L
#define ERROR_DIRECTORY                                 267L
#define ERROR_EAS_DIDNT_FIT                             275L
#define ERROR_EA_FILE_CORRUPT                           276L
#define ERROR_EA_TABLE_FULL                             277L
#define ERROR_INVALID_EA_HANDLE                         278L
#define ERROR_EAS_NOT_SUPPORTED                         282L
#define ERROR_NOT_OWNER                                 288L
#define ERROR_TOO_MANY_POSTS                            298L
#define ERROR_PARTIAL_COPY                              299L
#define ERROR_OPLOCK_NOT_GRANTED                        300L
#define ERROR_INVALID_OPLOCK_PROTOCOL                   301L
#define ERROR_DISK_TOO_FRAGMENTED                       302L
#define ERROR_DELETE_PENDING                            303L
#define ERROR_INCOMPATIBLE_WITH_GLOBAL_SHORT_NAME_REGISTRY_SETTING  304L
#define ERROR_SHORT_NAMES_NOT_ENABLED_ON_VOLUME         305L
#define ERROR_SECURITY_STREAM_IS_INCONSISTENT           306L
#define ERROR_INVALID_LOCK_RANGE                        307L
#define ERROR_IMAGE_SUBSYSTEM_NOT_PRESENT               308L
#define ERROR_NOTIFICATION_GUID_ALREADY_DEFINED         309L
#define ERROR_MR_MID_NOT_FOUND                          317L
#define ERROR_SCOPE_NOT_FOUND                           318L
#define ERROR_FAIL_NOACTION_REBOOT                      350L
#define ERROR_FAIL_SHUTDOWN                             351L
#define ERROR_FAIL_RESTART                              352L
#define ERROR_MAX_SESSIONS_REACHED                      353L
#define ERROR_THREAD_MODE_ALREADY_BACKGROUND            400L
#define ERROR_THREAD_MODE_NOT_BACKGROUND                401L
#define ERROR_PROCESS_MODE_ALREADY_BACKGROUND           402L
#define ERROR_PROCESS_MODE_NOT_BACKGROUND               403L
#define ERROR_INVALID_ADDRESS                           487L
#define ERROR_USER_PROFILE_LOAD                         500L
#define ERROR_ARITHMETIC_OVERFLOW                       534L
#define ERROR_PIPE_CONNECTED                            535L
#define ERROR_PIPE_LISTENING                            536L
#define ERROR_VERIFIER_STOP                             537L
#define ERROR_ABIOS_ERROR                               538L
#define ERROR_WX86_WARNING                              539L
#define ERROR_WX86_ERROR                                540L
#define ERROR_TIMER_NOT_CREATED                         541L
#define ERROR_UNWIND                                    542L
#define ERROR_BAD_STACK                                 543L
#define ERROR_INVALID_UNWIND_TARGET                     544L
#define ERROR_INVALID_PORT_ATTRIBUTES                   545L
#define ERROR_PORT_MESSAGE_TOO_LONG                     546L
#define ERROR_INVALID_QUOTA_LOWER                       547L
#define ERROR_DEVICE_ALREADY_ATTACHED                   548L
#define ERROR_INSTRUCTION_MISALIGNMENT                  549L
#define ERROR_PROFILING_NOT_STARTED                     550L
#define ERROR_PROFILING_NOT_STOPPED                     551L
#define ERROR_COULD_NOT_INTERPRET                       552L
#define ERROR_PROFILING_AT_LIMIT                        553L
#define ERROR_CANT_WAIT                                 554L
#define ERROR_CANT_TERMINATE_SELF                       555L
#define ERROR_UNEXPECTED_MM_CREATE_ERROR                556L
#define ERROR_UNEXPECTED_MM_MAP_ERROR                   557L
#define ERROR_UNEXPECTED_MM_EXTEND_ERROR                558L
#define ERROR_BAD_FUNCTION_TABLE                        559L
#define ERROR_NO_GUID_TRANSLATION                       560L
#define ERROR_INVALID_LDT_SIZE                          561L
#define ERROR_INVALID_LDT_OFFSET                        562L
#define ERROR_INVALID_LDT_DESCRIPTOR                    564L
#define ERROR_TOO_MANY_THREADS                          565L
#define ERROR_THREAD_NOT_IN_PROGRESS                    566L
#define ERROR_PAGEFILE_QUOTA_EXCEEDED                   567L
#define ERROR_LOGON_SERVER_CONFLICT                     568L
#define ERROR_SYNCHRONIZATION_REQUIRED                  569L
#define ERROR_NET_OPEN_FAILED                           570L
#define ERROR_IO_PRIVILEGE_FAILED                       571L
#define ERROR_CONTROL_C_EXIT                            572L
#define ERROR_MISSING_SYSTEMFILE                        573L
#define ERROR_UNHANDLED_EXCEPTION                       574L
#define ERROR_APP_INIT_FAILURE                          575L
#define ERROR_PAGEFILE_CREATE_FAILED                    576L
#define ERROR_INVALID_IMAGE_HASH                        577L
#define ERROR_NO_PAGEFILE                               578L
#define ERROR_ILLEGAL_FLOAT_CONTEXT                     579L
#define ERROR_NO_EVENT_PAIR                             580L
#define ERROR_DOMAIN_CTRLR_CONFIG_ERROR                 581L
#define ERROR_ILLEGAL_CHARACTER                         582L
#define ERROR_UNDEFINED_CHARACTER                       583L
#define ERROR_FLOPPY_VOLUME                             584L
#define ERROR_BIOS_FAILED_TO_CONNECT_INTERRUPT          585L
#define ERROR_BACKUP_CONTROLLER                         586L
#define ERROR_MUTANT_LIMIT_EXCEEDED                     587L
#define ERROR_FS_DRIVER_REQUIRED                        588L
#define ERROR_CANNOT_LOAD_REGISTRY_FILE                 589L
#define ERROR_DEBUG_ATTACH_FAILED                       590L
#define ERROR_SYSTEM_PROCESS_TERMINATED                 591L
#define ERROR_DATA_NOT_ACCEPTED                         592L
#define ERROR_VDM_HARD_ERROR                            593L
#define ERROR_DRIVER_CANCEL_TIMEOUT                     594L
#define ERROR_REPLY_MESSAGE_MISMATCH                    595L
#define ERROR_LOST_WRITEBEHIND_DATA                     596L
#define ERROR_CLIENT_SERVER_PARAMETERS_INVALID          597L
#define ERROR_NOT_TINY_STREAM                           598L
#define ERROR_STACK_OVERFLOW_READ                       599L
#define ERROR_CONVERT_TO_LARGE                          600L
#define ERROR_FOUND_OUT_OF_SCOPE                        601L
#define ERROR_ALLOCATE_BUCKET                           602L
#define ERROR_MARSHALL_OVERFLOW                         603L
#define ERROR_INVALID_VARIANT                           604L
#define ERROR_BAD_COMPRESSION_BUFFER                    605L
#define ERROR_AUDIT_FAILED                              606L
#define ERROR_TIMER_RESOLUTION_NOT_SET                  607L
#define ERROR_INSUFFICIENT_LOGON_INFO                   608L
#define ERROR_BAD_DLL_ENTRYPOINT                        609L
#define ERROR_BAD_SERVICE_ENTRYPOINT                    610L
#define ERROR_IP_ADDRESS_CONFLICT1                      611L
#define ERROR_IP_ADDRESS_CONFLICT2                      612L
#define ERROR_REGISTRY_QUOTA_LIMIT                      613L
#define ERROR_NO_CALLBACK_ACTIVE                        614L
#define ERROR_PWD_TOO_SHORT                             615L
#define ERROR_PWD_TOO_RECENT                            616L
#define ERROR_PWD_HISTORY_CONFLICT                      617L
#define ERROR_UNSUPPORTED_COMPRESSION                   618L
#define ERROR_INVALID_HW_PROFILE                        619L
#define ERROR_INVALID_PLUGPLAY_DEVICE_PATH              620L
#define ERROR_QUOTA_LIST_INCONSISTENT                   621L
#define ERROR_EVALUATION_EXPIRATION                     622L
#define ERROR_ILLEGAL_DLL_RELOCATION                    623L
#define ERROR_DLL_INIT_FAILED_LOGOFF                    624L
#define ERROR_VALIDATE_CONTINUE                         625L
#define ERROR_NO_MORE_MATCHES                           626L
#define ERROR_RANGE_LIST_CONFLICT                       627L
#define ERROR_SERVER_SID_MISMATCH                       628L
#define ERROR_CANT_ENABLE_DENY_ONLY                     629L
#define ERROR_FLOAT_MULTIPLE_FAULTS                     630L
#define ERROR_FLOAT_MULTIPLE_TRAPS                      631L
#define ERROR_NOINTERFACE                               632L
#define ERROR_DRIVER_FAILED_SLEEP                       633L
#define ERROR_CORRUPT_SYSTEM_FILE                       634L
#define ERROR_COMMITMENT_MINIMUM                        635L
#define ERROR_PNP_RESTART_ENUMERATION                   636L
#define ERROR_SYSTEM_IMAGE_BAD_SIGNATURE                637L
#define ERROR_PNP_REBOOT_REQUIRED                       638L
#define ERROR_INSUFFICIENT_POWER                        639L
#define ERROR_MULTIPLE_FAULT_VIOLATION                  640L
#define ERROR_SYSTEM_SHUTDOWN                           641L
#define ERROR_PORT_NOT_SET                              642L
#define ERROR_DS_VERSION_CHECK_FAILURE                  643L
#define ERROR_RANGE_NOT_FOUND                           644L
#define ERROR_NOT_SAFE_MODE_DRIVER                      646L
#define ERROR_FAILED_DRIVER_ENTRY                       647L
#define ERROR_DEVICE_ENUMERATION_ERROR                  648L
#define ERROR_MOUNT_POINT_NOT_RESOLVED                  649L
#define ERROR_INVALID_DEVICE_OBJECT_PARAMETER           650L
#define ERROR_MCA_OCCURRED                              651L
#define ERROR_DRIVER_DATABASE_ERROR                     652L
#define ERROR_SYSTEM_HIVE_TOO_LARGE                     653L
#define ERROR_DRIVER_FAILED_PRIOR_UNLOAD                654L
#define ERROR_VOLSNAP_PREPARE_HIBERNATE                 655L
#define ERROR_HIBERNATION_FAILURE                       656L
#define ERROR_FILE_SYSTEM_LIMITATION                    665L
#define ERROR_ASSERTION_FAILURE                         668L
#define ERROR_ACPI_ERROR                                669L
#define ERROR_WOW_ASSERTION                             670L
#define ERROR_PNP_BAD_MPS_TABLE                         671L
#define ERROR_PNP_TRANSLATION_FAILED                    672L
#define ERROR_PNP_IRQ_TRANSLATION_FAILED                673L
#define ERROR_PNP_INVALID_ID                            674L
#define ERROR_WAKE_SYSTEM_DEBUGGER                      675L
#define ERROR_HANDLES_CLOSED                            676L
#define ERROR_EXTRANEOUS_INFORMATION                    677L
#define ERROR_RXACT_COMMIT_NECESSARY                    678L
#define ERROR_MEDIA_CHECK                               679L
#define ERROR_GUID_SUBSTITUTION_MADE                    680L
#define ERROR_STOPPED_ON_SYMLINK                        681L
#define ERROR_LONGJUMP                                  682L
#define ERROR_PLUGPLAY_QUERY_VETOED                     683L
#define ERROR_UNWIND_CONSOLIDATE                        684L
#define ERROR_REGISTRY_HIVE_RECOVERED                   685L
#define ERROR_DLL_MIGHT_BE_INSECURE                     686L
#define ERROR_DLL_MIGHT_BE_INCOMPATIBLE                 687L
#define ERROR_DBG_EXCEPTION_NOT_HANDLED                 688L
#define ERROR_DBG_REPLY_LATER                           689L
#define ERROR_DBG_UNABLE_TO_PROVIDE_HANDLE              690L
#define ERROR_DBG_TERMINATE_THREAD                      691L
#define ERROR_DBG_TERMINATE_PROCESS                     692L
#define ERROR_DBG_CONTROL_C                             693L
#define ERROR_DBG_PRINTEXCEPTION_C                      694L
#define ERROR_DBG_RIPEXCEPTION                          695L
#define ERROR_DBG_CONTROL_BREAK                         696L
#define ERROR_DBG_COMMAND_EXCEPTION                     697L
#define ERROR_OBJECT_NAME_EXISTS                        698L
#define ERROR_THREAD_WAS_SUSPENDED                      699L
#define ERROR_IMAGE_NOT_AT_BASE                         700L
#define ERROR_RXACT_STATE_CREATED                       701L
#define ERROR_SEGMENT_NOTIFICATION                      702L
#define ERROR_BAD_CURRENT_DIRECTORY                     703L
#define ERROR_FT_READ_RECOVERY_FROM_BACKUP              704L
#define ERROR_FT_WRITE_RECOVERY                         705L
#define ERROR_IMAGE_MACHINE_TYPE_MISMATCH               706L
#define ERROR_RECEIVE_PARTIAL                           707L
#define ERROR_RECEIVE_EXPEDITED                         708L
#define ERROR_RECEIVE_PARTIAL_EXPEDITED                 709L
#define ERROR_EVENT_DONE                                710L
#define ERROR_EVENT_PENDING                             711L
#define ERROR_CHECKING_FILE_SYSTEM                      712L
#define ERROR_FATAL_APP_EXIT                            713L
#define ERROR_PREDEFINED_HANDLE                         714L
#define ERROR_WAS_UNLOCKED                              715L
#define ERROR_SERVICE_NOTIFICATION                      716L
#define ERROR_WAS_LOCKED                                717L
#define ERROR_LOG_HARD_ERROR                            718L
#define ERROR_ALREADY_WIN32                             719L
#define ERROR_IMAGE_MACHINE_TYPE_MISMATCH_EXE           720L
#define ERROR_NO_YIELD_PERFORMED                        721L
#define ERROR_TIMER_RESUME_IGNORED                      722L
#define ERROR_ARBITRATION_UNHANDLED                     723L
#define ERROR_CARDBUS_NOT_SUPPORTED                     724L
#define ERROR_MP_PROCESSOR_MISMATCH                     725L
#define ERROR_HIBERNATED                                726L
#define ERROR_RESUME_HIBERNATION                        727L
#define ERROR_FIRMWARE_UPDATED                          728L
#define ERROR_DRIVERS_LEAKING_LOCKED_PAGES              729L
#define ERROR_WAKE_SYSTEM                               730L
#define ERROR_WAIT_1                                    731L
#define ERROR_WAIT_2                                    732L
#define ERROR_WAIT_3                                    733L
#define ERROR_WAIT_63                                   734L
#define ERROR_ABANDONED_WAIT_0                          735L
#define ERROR_ABANDONED_WAIT_63                         736L
#define ERROR_USER_APC                                  737L
#define ERROR_KERNEL_APC                                738L
#define ERROR_ALERTED                                   739L
#define ERROR_ELEVATION_REQUIRED                        740L
#define ERROR_REPARSE                                   741L
#define ERROR_OPLOCK_BREAK_IN_PROGRESS                  742L
#define ERROR_VOLUME_MOUNTED                            743L
#define ERROR_RXACT_COMMITTED                           744L
#define ERROR_NOTIFY_CLEANUP                            745L
#define ERROR_PRIMARY_TRANSPORT_CONNECT_FAILED          746L
#define ERROR_PAGE_FAULT_TRANSITION                     747L
#define ERROR_PAGE_FAULT_DEMAND_ZERO                    748L
#define ERROR_PAGE_FAULT_COPY_ON_WRITE                  749L
#define ERROR_PAGE_FAULT_GUARD_PAGE                     750L
#define ERROR_PAGE_FAULT_PAGING_FILE                    751L
#define ERROR_CACHE_PAGE_LOCKED                         752L
#define ERROR_CRASH_DUMP                                753L
#define ERROR_BUFFER_ALL_ZEROS                          754L
#define ERROR_REPARSE_OBJECT                            755L
#define ERROR_RESOURCE_REQUIREMENTS_CHANGED             756L
#define ERROR_TRANSLATION_COMPLETE                      757L
#define ERROR_NOTHING_TO_TERMIANTE                      758L
#define ERROR_PROCESS_NOT_IN_JOB                        759L
#define ERROR_PROCESS_IN_JOB                            760L
#define ERROR_VOLSNAP_HIBERNATE_READY                   761L
#define ERROR_FSFILTER_OP_COMPLETED_SUCCESSFULLY        762L
#define ERROR_INTERRUPT_VECTOR_ALREADY_CONNECTED        763L
#define ERROR_INTERRUPT_STILL_CONNECTED                 764L
#define ERROR_WAIT_FOR_OPLOCK                           765L
#define ERROR_DBG_EXCEPTION_HANDLED                     766L
#define ERROR_DBG_CONTINUE                              767L
#define ERROR_CALLBACK_POP_STACK                        768L
#define ERROR_COMPRESSION_DISABLED                      769L
#define ERROR_CANTFETCHBACKWARDS                        770L
#define ERROR_CANTSCROLLBACKWARDS                       771L
#define ERROR_ROWSNOTRELEASED                           772L
#define ERROR_BAD_ACCESSOR_FLAGS                        773L
#define ERROR_ERRORS_ENCOUNTERED                        774L
#define ERROR_NOT_CAPABLE                               775L
#define ERROR_REQUEST_OUT_OF_SEQUENCE                   776L
#define ERROR_VERSION_PARSE_ERROR                       777L
#define ERROR_BADSTARTPOSITION                          778L
#define ERROR_MEMORY_HARDWARE                           779L
#define ERROR_DISK_REPAIR_DISABLED                      780L
#define ERROR_INSUFFICIENT_RESOURCE_FOR_SPECIFIED_SHARED_SECTION_SIZE   781L
#define ERROR_SYSTEM_POWERSTATE_TRANSITION              782L
#define ERROR_SYSTEM_POWERSTATE_COMPLEX_TRANSITION      783L
#define ERROR_MCA_EXCEPTION                             784L
#define ERROR_ACCESS_AUDIT_BY_POLICY                    785L
#define ERROR_ACCESS_DISABLED_NO_SAFER_UI_BY_POLICY     786L
#define ERROR_ABANDON_HIBERFILE                         787L
#define ERROR_LOST_WRITEBEHIND_DATA_NETWORK_DISCONNECTED    788L
#define ERROR_LOST_WRITEBEHIND_DATA_NETWORK_SERVER_ERROR    789L
#define ERROR_LOST_WRITEBEHIND_DATA_LOCAL_DISK_ERROR        790L
#define ERROR_BAD_MCFG_TABLE                                791L
#define ERROR_OPLOCK_SWITCHED_TO_NEW_HANDLE             800L
#define ERROR_CANNOT_GRANT_REQUESTED_OPLOCK             801L
#define ERROR_CANNOT_BREAK_OPLOCK                       802L
#define ERROR_OPLOCK_HANDLE_CLOSED                      803L
#define ERROR_NO_ACE_CONDITION                          804L
#define ERROR_INVALID_ACE_CONDITION                     805L
#define ERROR_EA_ACCESS_DENIED                          994L
#define ERROR_OPERATION_ABORTED                         995L
#define ERROR_IO_INCOMPLETE                             996L
#define ERROR_IO_PENDING                                997L
#define ERROR_NOACCESS                                  998L
#define ERROR_SWAPERROR                                 999L
#define ERROR_STACK_OVERFLOW                            1001L
#define ERROR_INVALID_MESSAGE                           1002L
#define ERROR_CAN_NOT_COMPLETE                          1003L
#define ERROR_INVALID_FLAGS                             1004L
#define ERROR_UNRECOGNIZED_VOLUME                       1005L
#define ERROR_FILE_INVALID                              1006L
#define ERROR_FULLSCREEN_MODE                           1007L
#define ERROR_NO_TOKEN                                  1008L
#define ERROR_BADDB                                     1009L
#define ERROR_BADKEY                                    1010L
#define ERROR_CANTOPEN                                  1011L
#define ERROR_CANTREAD                                  1012L
#define ERROR_CANTWRITE                                 1013L
#define ERROR_REGISTRY_RECOVERED                        1014L
#define ERROR_REGISTRY_CORRUPT                          1015L
#define ERROR_REGISTRY_IO_FAILED                        1016L
#define ERROR_NOT_REGISTRY_FILE                         1017L
#define ERROR_KEY_DELETED                               1018L
#define ERROR_NO_LOG_SPACE                              1019L
#define ERROR_KEY_HAS_CHILDREN                          1020L
#define ERROR_CHILD_MUST_BE_VOLATILE                    1021L
#define ERROR_NOTIFY_ENUM_DIR                           1022L
#define ERROR_DEPENDENT_SERVICES_RUNNING                1051L
#define ERROR_INVALID_SERVICE_CONTROL                   1052L
#define ERROR_SERVICE_REQUEST_TIMEOUT                   1053L
#define ERROR_SERVICE_NO_THREAD                         1054L
#define ERROR_SERVICE_DATABASE_LOCKED                   1055L
#define ERROR_SERVICE_ALREADY_RUNNING                   1056L
#define ERROR_INVALID_SERVICE_ACCOUNT                   1057L
#define ERROR_SERVICE_DISABLED                          1058L
#define ERROR_CIRCULAR_DEPENDENCY                       1059L
#define ERROR_SERVICE_DOES_NOT_EXIST                    1060L
#define ERROR_SERVICE_CANNOT_ACCEPT_CTRL                1061L
#define ERROR_SERVICE_NOT_ACTIVE                        1062L
#define ERROR_FAILED_SERVICE_CONTROLLER_CONNECT         1063L
#define ERROR_EXCEPTION_IN_SERVICE                      1064L
#define ERROR_DATABASE_DOES_NOT_EXIST                   1065L
#define ERROR_SERVICE_SPECIFIC_ERROR                    1066L
#define ERROR_PROCESS_ABORTED                           1067L
#define ERROR_SERVICE_DEPENDENCY_FAIL                   1068L
#define ERROR_SERVICE_LOGON_FAILED                      1069L
#define ERROR_SERVICE_START_HANG                        1070L
#define ERROR_INVALID_SERVICE_LOCK                      1071L
#define ERROR_SERVICE_MARKED_FOR_DELETE                 1072L
#define ERROR_SERVICE_EXISTS                            1073L
#define ERROR_ALREADY_RUNNING_LKG                       1074L
#define ERROR_SERVICE_DEPENDENCY_DELETED                1075L
#define ERROR_BOOT_ALREADY_ACCEPTED                     1076L
#define ERROR_SERVICE_NEVER_STARTED                     1077L
#define ERROR_DUPLICATE_SERVICE_NAME                    1078L
#define ERROR_DIFFERENT_SERVICE_ACCOUNT                 1079L
#define ERROR_CANNOT_DETECT_DRIVER_FAILURE              1080L
#define ERROR_CANNOT_DETECT_PROCESS_ABORT               1081L
#define ERROR_NO_RECOVERY_PROGRAM                       1082L
#define ERROR_SERVICE_NOT_IN_EXE                        1083L
#define ERROR_NOT_SAFEBOOT_SERVICE                      1084L
#define ERROR_END_OF_MEDIA                              1100L
#define ERROR_FILEMARK_DETECTED                         1101L
#define ERROR_BEGINNING_OF_MEDIA                        1102L
#define ERROR_SETMARK_DETECTED                          1103L
#define ERROR_NO_DATA_DETECTED                          1104L
#define ERROR_PARTITION_FAILURE                         1105L
#define ERROR_INVALID_BLOCK_LENGTH                      1106L
#define ERROR_DEVICE_NOT_PARTITIONED                    1107L
#define ERROR_UNABLE_TO_LOCK_MEDIA                      1108L
#define ERROR_UNABLE_TO_UNLOAD_MEDIA                    1109L
#define ERROR_MEDIA_CHANGED                             1110L
#define ERROR_BUS_RESET                                 1111L
#define ERROR_NO_MEDIA_IN_DRIVE                         1112L
#define ERROR_NO_UNICODE_TRANSLATION                    1113L
#define ERROR_DLL_INIT_FAILED                           1114L
#define ERROR_SHUTDOWN_IN_PROGRESS                      1115L
#define ERROR_NO_SHUTDOWN_IN_PROGRESS                   1116L
#define ERROR_IO_DEVICE                                 1117L
#define ERROR_SERIAL_NO_DEVICE                          1118L
#define ERROR_IRQ_BUSY                                  1119L
#define ERROR_MORE_WRITES                               1120L
#define ERROR_COUNTER_TIMEOUT                           1121L
#define ERROR_FLOPPY_ID_MARK_NOT_FOUND                  1122L
#define ERROR_FLOPPY_WRONG_CYLINDER                     1123L
#define ERROR_FLOPPY_UNKNOWN_ERROR                      1124L
#define ERROR_FLOPPY_BAD_REGISTERS                      1125L
#define ERROR_DISK_RECALIBRATE_FAILED                   1126L
#define ERROR_DISK_OPERATION_FAILED                     1127L
#define ERROR_DISK_RESET_FAILED                         1128L
#define ERROR_EOM_OVERFLOW                              1129L
#define ERROR_NOT_ENOUGH_SERVER_MEMORY                  1130L
#define ERROR_POSSIBLE_DEADLOCK                         1131L
#define ERROR_MAPPED_ALIGNMENT                          1132L
#define ERROR_SET_POWER_STATE_VETOED                    1140L
#define ERROR_SET_POWER_STATE_FAILED                    1141L
#define ERROR_TOO_MANY_LINKS                            1142L
#define ERROR_OLD_WIN_VERSION                           1150L
#define ERROR_APP_WRONG_OS                              1151L
#define ERROR_SINGLE_INSTANCE_APP                       1152L
#define ERROR_RMODE_APP                                 1153L
#define ERROR_INVALID_DLL                               1154L
#define ERROR_NO_ASSOCIATION                            1155L
#define ERROR_DDE_FAIL                                  1156L
#define ERROR_DLL_NOT_FOUND                             1157L
#define ERROR_NO_MORE_USER_HANDLES                      1158L
#define ERROR_MESSAGE_SYNC_ONLY                         1159L
#define ERROR_SOURCE_ELEMENT_EMPTY                      1160L
#define ERROR_DESTINATION_ELEMENT_FULL                  1161L
#define ERROR_ILLEGAL_ELEMENT_ADDRESS                   1162L
#define ERROR_MAGAZINE_NOT_PRESENT                      1163L
#define ERROR_DEVICE_REINITIALIZATION_NEEDED            1164L
#define ERROR_DEVICE_REQUIRES_CLEANING                  1165L
#define ERROR_DEVICE_DOOR_OPEN                          1166L
#define ERROR_DEVICE_NOT_CONNECTED                      1167L
#define ERROR_NOT_FOUND                                 1168L
#define ERROR_NO_MATCH                                  1169L
#define ERROR_SET_NOT_FOUND                             1170L
#define ERROR_POINT_NOT_FOUND                           1171L
#define ERROR_NO_TRACKING_SERVICE                       1172L
#define ERROR_NO_VOLUME_ID                              1173L
#define ERROR_UNABLE_TO_REMOVE_REPLACED                 1175L
#define ERROR_UNABLE_TO_MOVE_REPLACEMENT                1176L
#define ERROR_UNABLE_TO_MOVE_REPLACEMENT_2              1177L
#define ERROR_JOURNAL_DELETE_IN_PROGRESS                1178L
#define ERROR_JOURNAL_NOT_ACTIVE                        1179L
#define ERROR_POTENTIAL_FILE_FOUND                      1180L
#define ERROR_JOURNAL_ENTRY_DELETED                     1181L
#define ERROR_SHUTDOWN_IS_SCHEDULED                     1190L
#define ERROR_SHUTDOWN_USERS_LOGGED_ON                  1191L
#define ERROR_BAD_DEVICE                                1200L
#define ERROR_CONNECTION_UNAVAIL                        1201L
#define ERROR_DEVICE_ALREADY_REMEMBERED                 1202L
#define ERROR_NO_NET_OR_BAD_PATH                        1203L
#define ERROR_BAD_PROVIDER                              1204L
#define ERROR_CANNOT_OPEN_PROFILE                       1205L
#define ERROR_BAD_PROFILE                               1206L
#define ERROR_NOT_CONTAINER                             1207L
#define ERROR_EXTENDED_ERROR                            1208L
#define ERROR_INVALID_GROUPNAME                         1209L
#define ERROR_INVALID_COMPUTERNAME                      1210L
#define ERROR_INVALID_EVENTNAME                         1211L
#define ERROR_INVALID_DOMAINNAME                        1212L
#define ERROR_INVALID_SERVICENAME                       1213L
#define ERROR_INVALID_NETNAME                           1214L
#define ERROR_INVALID_SHARENAME                         1215L
#define ERROR_INVALID_PASSWORDNAME                      1216L
#define ERROR_INVALID_MESSAGENAME                       1217L
#define ERROR_INVALID_MESSAGEDEST                       1218L
#define ERROR_SESSION_CREDENTIAL_CONFLICT               1219L
#define ERROR_REMOTE_SESSION_LIMIT_EXCEEDED             1220L
#define ERROR_DUP_DOMAINNAME                            1221L
#define ERROR_NO_NETWORK                                1222L
#define ERROR_CANCELLED                                 1223L
#define ERROR_USER_MAPPED_FILE                          1224L
#define ERROR_CONNECTION_REFUSED                        1225L
#define ERROR_GRACEFUL_DISCONNECT                       1226L
#define ERROR_ADDRESS_ALREADY_ASSOCIATED                1227L
#define ERROR_ADDRESS_NOT_ASSOCIATED                    1228L
#define ERROR_CONNECTION_INVALID                        1229L
#define ERROR_CONNECTION_ACTIVE                         1230L
#define ERROR_NETWORK_UNREACHABLE                       1231L
#define ERROR_HOST_UNREACHABLE                          1232L
#define ERROR_PROTOCOL_UNREACHABLE                      1233L
#define ERROR_PORT_UNREACHABLE                          1234L
#define ERROR_REQUEST_ABORTED                           1235L
#define ERROR_CONNECTION_ABORTED                        1236L
#define ERROR_RETRY                                     1237L
#define ERROR_CONNECTION_COUNT_LIMIT                    1238L
#define ERROR_LOGIN_TIME_RESTRICTION                    1239L
#define ERROR_LOGIN_WKSTA_RESTRICTION                   1240L
#define ERROR_INCORRECT_ADDRESS                         1241L
#define ERROR_ALREADY_REGISTERED                        1242L
#define ERROR_SERVICE_NOT_FOUND                         1243L
#define ERROR_NOT_AUTHENTICATED                         1244L
#define ERROR_NOT_LOGGED_ON                             1245L
#define ERROR_CONTINUE                                  1246L
#define ERROR_ALREADY_INITIALIZED                       1247L
#define ERROR_NO_MORE_DEVICES                           1248L
#define ERROR_NO_SUCH_SITE                              1249L
#define ERROR_DOMAIN_CONTROLLER_EXISTS                  1250L
#define ERROR_ONLY_IF_CONNECTED                         1251L
#define ERROR_OVERRIDE_NOCHANGES                        1252L
#define ERROR_BAD_USER_PROFILE                          1253L
#define ERROR_NOT_SUPPORTED_ON_SBS                      1254L
#define ERROR_SERVER_SHUTDOWN_IN_PROGRESS               1255L
#define ERROR_HOST_DOWN                                 1256L
#define ERROR_NON_ACCOUNT_SID                           1257L
#define ERROR_NON_DOMAIN_SID                            1258L
#define ERROR_APPHELP_BLOCK                             1259L
#define ERROR_ACCESS_DISABLED_BY_POLICY                 1260L
#define ERROR_REG_NAT_CONSUMPTION                       1261L
#define ERROR_CSCSHARE_OFFLINE                          1262L
#define ERROR_PKINIT_FAILURE                            1263L
#define ERROR_SMARTCARD_SUBSYSTEM_FAILURE               1264L
#define ERROR_DOWNGRADE_DETECTED                        1265L
#define ERROR_MACHINE_LOCKED                            1271L
#define ERROR_CALLBACK_SUPPLIED_INVALID_DATA            1273L
#define ERROR_SYNC_FOREGROUND_REFRESH_REQUIRED          1274L
#define ERROR_DRIVER_BLOCKED                            1275L
#define ERROR_INVALID_IMPORT_OF_NON_DLL                 1276L
#define ERROR_ACCESS_DISABLED_WEBBLADE                  1277L
#define ERROR_ACCESS_DISABLED_WEBBLADE_TAMPER           1278L
#define ERROR_RECOVERY_FAILURE                          1279L
#define ERROR_ALREADY_FIBER                             1280L
#define ERROR_ALREADY_THREAD                            1281L
#define ERROR_STACK_BUFFER_OVERRUN                      1282L
#define ERROR_PARAMETER_QUOTA_EXCEEDED                  1283L
#define ERROR_DEBUGGER_INACTIVE                         1284L
#define ERROR_DELAY_LOAD_FAILED                         1285L
#define ERROR_VDM_DISALLOWED                            1286L
#define ERROR_UNIDENTIFIED_ERROR                        1287L
#define ERROR_INVALID_CRUNTIME_PARAMETER                1288L
#define ERROR_BEYOND_VDL                                1289L
#define ERROR_INCOMPATIBLE_SERVICE_SID_TYPE             1290L
#define ERROR_DRIVER_PROCESS_TERMINATED                 1291L
#define ERROR_IMPLEMENTATION_LIMIT                      1292L
#define ERROR_PROCESS_IS_PROTECTED                      1293L
#define ERROR_SERVICE_NOTIFY_CLIENT_LAGGING             1294L
#define ERROR_DISK_QUOTA_EXCEEDED                       1295L
#define ERROR_CONTENT_BLOCKED                           1296L
#define ERROR_INCOMPATIBLE_SERVICE_PRIVILEGE            1297L
#define ERROR_APP_HANG                                  1298L

/* Security error codes */
#define ERROR_INVALID_LABEL                 1299L
#define ERROR_NOT_ALL_ASSIGNED              1300L
#define ERROR_SOME_NOT_MAPPED               1301L
#define ERROR_NO_QUOTAS_FOR_ACCOUNT         1302L
#define ERROR_LOCAL_USER_SESSION_KEY        1303L
#define ERROR_NULL_LM_PASSWORD              1304L
#define ERROR_UNKNOWN_REVISION              1305L
#define ERROR_REVISION_MISMATCH             1306L
#define ERROR_INVALID_OWNER                 1307L
#define ERROR_INVALID_PRIMARY_GROUP         1308L
#define ERROR_NO_IMPERSONATION_TOKEN        1309L
#define ERROR_CANT_DISABLE_MANDATORY        1310L
#define ERROR_NO_LOGON_SERVERS              1311L
#define ERROR_NO_SUCH_LOGON_SESSION         1312L
#define ERROR_NO_SUCH_PRIVILEGE             1313L
#define ERROR_PRIVILEGE_NOT_HELD            1314L
#define ERROR_INVALID_ACCOUNT_NAME          1315L
#define ERROR_USER_EXISTS                   1316L
#define ERROR_NO_SUCH_USER                  1317L
#define ERROR_GROUP_EXISTS                  1318L
#define ERROR_NO_SUCH_GROUP                 1319L
#define ERROR_MEMBER_IN_GROUP               1320L
#define ERROR_MEMBER_NOT_IN_GROUP           1321L
#define ERROR_LAST_ADMIN                    1322L
#define ERROR_WRONG_PASSWORD                1323L
#define ERROR_ILL_FORMED_PASSWORD           1324L
#define ERROR_PASSWORD_RESTRICTION          1325L
#define ERROR_LOGON_FAILURE                 1326L
#define ERROR_ACCOUNT_RESTRICTION           1327L
#define ERROR_INVALID_LOGON_HOURS           1328L
#define ERROR_INVALID_WORKSTATION           1329L
#define ERROR_PASSWORD_EXPIRED              1330L
#define ERROR_ACCOUNT_DISABLED              1331L
#define ERROR_NONE_MAPPED                   1332L
#define ERROR_TOO_MANY_LUIDS_REQUESTED      1333L
#define ERROR_LUIDS_EXHAUSTED               1334L
#define ERROR_INVALID_SUB_AUTHORITY         1335L
#define ERROR_INVALID_ACL                   1336L
#define ERROR_INVALID_SID                   1337L
#define ERROR_INVALID_SECURITY_DESCR        1338L
#define ERROR_BAD_INHERITANCE_ACL           1340L
#define ERROR_SERVER_DISABLED               1341L
#define ERROR_SERVER_NOT_DISABLED           1342L
#define ERROR_INVALID_ID_AUTHORITY          1343L
#define ERROR_ALLOTTED_SPACE_EXCEEDED       1344L
#define ERROR_INVALID_GROUP_ATTRIBUTES      1345L
#define ERROR_BAD_IMPERSONATION_LEVEL       1346L
#define ERROR_CANT_OPEN_ANONYMOUS           1347L
#define ERROR_BAD_VALIDATION_CLASS          1348L
#define ERROR_BAD_TOKEN_TYPE                1349L
#define ERROR_NO_SECURITY_ON_OBJECT         1350L
#define ERROR_CANT_ACCESS_DOMAIN_INFO       1351L
#define ERROR_INVALID_SERVER_STATE          1352L
#define ERROR_INVALID_DOMAIN_STATE          1353L
#define ERROR_INVALID_DOMAIN_ROLE           1354L
#define ERROR_NO_SUCH_DOMAIN                1355L
#define ERROR_DOMAIN_EXISTS                 1356L
#define ERROR_DOMAIN_LIMIT_EXCEEDED         1357L
#define ERROR_INTERNAL_DB_CORRUPTION        1358L
#define ERROR_INTERNAL_ERROR                1359L
#define ERROR_GENERIC_NOT_MAPPED            1360L
#define ERROR_BAD_DESCRIPTOR_FORMAT         1361L
#define ERROR_NOT_LOGON_PROCESS             1362L
#define ERROR_LOGON_SESSION_EXISTS          1363L
#define ERROR_NO_SUCH_PACKAGE               1364L
#define ERROR_BAD_LOGON_SESSION_STATE       1365L
#define ERROR_LOGON_SESSION_COLLISION       1366L
#define ERROR_INVALID_LOGON_TYPE            1367L
#define ERROR_CANNOT_IMPERSONATE            1368L
#define ERROR_RXACT_INVALID_STATE           1369L
#define ERROR_RXACT_COMMIT_FAILURE          1370L
#define ERROR_SPECIAL_ACCOUNT               1371L
#define ERROR_SPECIAL_GROUP                 1372L
#define ERROR_SPECIAL_USER                  1373L
#define ERROR_MEMBERS_PRIMARY_GROUP         1374L
#define ERROR_TOKEN_ALREADY_IN_USE          1375L
#define ERROR_NO_SUCH_ALIAS                 1376L
#define ERROR_MEMBER_NOT_IN_ALIAS           1377L
#define ERROR_MEMBER_IN_ALIAS               1378L
#define ERROR_ALIAS_EXISTS                  1379L
#define ERROR_LOGON_NOT_GRANTED             1380L
#define ERROR_TOO_MANY_SECRETS              1381L
#define ERROR_SECRET_TOO_LONG               1382L
#define ERROR_INTERNAL_DB_ERROR             1383L
#define ERROR_TOO_MANY_CONTEXT_IDS          1384L
#define ERROR_LOGON_TYPE_NOT_GRANTED        1385L
#define ERROR_NT_CROSS_ENCRYPTION_REQUIRED  1386L
#define ERROR_NO_SUCH_MEMBER                1387L
#define ERROR_INVALID_MEMBER                1388L
#define ERROR_TOO_MANY_SIDS                 1389L
#define ERROR_LM_CROSS_ENCRYPTION_REQUIRED  1390L
#define ERROR_NO_INHERITANCE                1391L
#define ERROR_FILE_CORRUPT                  1392L
#define ERROR_DISK_CORRUPT                  1393L
#define ERROR_NO_USER_SESSION_KEY           1394L
#define ERROR_LICENSE_QUOTA_EXCEEDED        1395L
#define ERROR_WRONG_TARGET_NAME             1396L
#define ERROR_MUTUAL_AUTH_FAILED            1397L
#define ERROR_TIME_SKEW                     1398L
#define ERROR_CURRENT_DOMAIN_NOT_ALLOWED    1399L

/* User interface error codes */
#define ERROR_INVALID_WINDOW_HANDLE                 1400L
#define ERROR_INVALID_MENU_HANDLE                   1401L
#define ERROR_INVALID_CURSOR_HANDLE                 1402L
#define ERROR_INVALID_ACCEL_HANDLE                  1403L
#define ERROR_INVALID_HOOK_HANDLE                   1404L
#define ERROR_INVALID_DWP_HANDLE                    1405L
#define ERROR_TLW_WITH_WSCHILD                      1406L
#define ERROR_CANNOT_FIND_WND_CLASS                 1407L
#define ERROR_WINDOW_OF_OTHER_THREAD                1408L
#define ERROR_HOTKEY_ALREADY_REGISTERED             1409L
#define ERROR_CLASS_ALREADY_EXISTS                  1410L
#define ERROR_CLASS_DOES_NOT_EXIST                  1411L
#define ERROR_CLASS_HAS_WINDOWS                     1412L
#define ERROR_INVALID_INDEX                         1413L
#define ERROR_INVALID_ICON_HANDLE                   1414L
#define ERROR_PRIVATE_DIALOG_INDEX                  1415L
#define ERROR_LISTBOX_ID_NOT_FOUND                  1416L
#define ERROR_NO_WILDCARD_CHARACTERS                1417L
#define ERROR_CLIPBOARD_NOT_OPEN                    1418L
#define ERROR_HOTKEY_NOT_REGISTERED                 1419L
#define ERROR_WINDOW_NOT_DIALOG                     1420L
#define ERROR_CONTROL_ID_NOT_FOUND                  1421L
#define ERROR_INVALID_COMBOBOX_MESSAGE              1422L
#define ERROR_WINDOW_NOT_COMBOBOX                   1423L
#define ERROR_INVALID_EDIT_HEIGHT                   1424L
#define ERROR_DC_NOT_FOUND                          1425L
#define ERROR_INVALID_HOOK_FILTER                   1426L
#define ERROR_INVALID_FILTER_PROC                   1427L
#define ERROR_HOOK_NEEDS_HMOD                       1428L
#define ERROR_GLOBAL_ONLY_HOOK                      1429L
#define ERROR_JOURNAL_HOOK_SET                      1430L
#define ERROR_HOOK_NOT_INSTALLED                    1431L
#define ERROR_INVALID_LB_MESSAGE                    1432L
#define ERROR_SETCOUNT_ON_BAD_LB                    1433L
#define ERROR_LB_WITHOUT_TABSTOPS                   1434L
#define ERROR_DESTROY_OBJECT_OF_OTHER_THREAD        1435L
#define ERROR_CHILD_WINDOW_MENU                     1436L
#define ERROR_NO_SYSTEM_MENU                        1437L
#define ERROR_INVALID_MSGBOX_STYLE                  1438L
#define ERROR_INVALID_SPI_VALUE                     1439L
#define ERROR_SCREEN_ALREADY_LOCKED                 1440L
#define ERROR_HWNDS_HAVE_DIFF_PARENT                1441L
#define ERROR_NOT_CHILD_WINDOW                      1442L
#define ERROR_INVALID_GW_COMMAND                    1443L
#define ERROR_INVALID_THREAD_ID                     1444L
#define ERROR_NON_MDICHILD_WINDOW                   1445L
#define ERROR_POPUP_ALREADY_ACTIVE                  1446L
#define ERROR_NO_SCROLLBARS                         1447L
#define ERROR_INVALID_SCROLLBAR_RANGE               1448L
#define ERROR_INVALID_SHOWWIN_COMMAND               1449L
#define ERROR_NO_SYSTEM_RESOURCES                   1450L
#define ERROR_NONPAGED_SYSTEM_RESOURCES             1451L
#define ERROR_PAGED_SYSTEM_RESOURCES                1452L
#define ERROR_WORKING_SET_QUOTA                     1453L
#define ERROR_PAGEFILE_QUOTA                        1454L
#define ERROR_COMMITMENT_LIMIT                      1455L
#define ERROR_MENU_ITEM_NOT_FOUND                   1456L
#define ERROR_INVALID_KEYBOARD_HANDLE               1457L
#define ERROR_HOOK_TYPE_NOT_ALLOWED                 1458L
#define ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION    1459L
#define ERROR_TIMEOUT                               1460L
#define ERROR_INVALID_MONITOR_HANDLE                1461L
#define ERROR_INCORRECT_SIZE                        1462L
#define ERROR_SYMLINK_CLASS_DISABLED                1463L
#define ERROR_SYMLINK_NOT_SUPPORTED                 1464L
#define ERROR_XML_PARSE_ERROR                       1465L
#define ERROR_XML_DSIG_ERROR                        1466L
#define ERROR_RESTART_APPLICATION                   1467L
#define ERROR_WRONG_COMPARTMENT                     1468L
#define ERROR_AUTHIP_FAILURE                        1469L
#define ERROR_NO_NVRAM_RESOURCES                    1470L

/* Event log error codes */
#define ERROR_EVENTLOG_FILE_CORRUPT 1500L
#define ERROR_EVENTLOG_CANT_START   1501L
#define ERROR_LOG_FILE_FULL         1502L
#define ERROR_EVENTLOG_FILE_CHANGED 1503L

/* Class scheduler error codes */
#define ERROR_INVALID_TASK_NAME         1550L
#define ERROR_INVALID_TASK_INDEX        1551L
#define ERROR_THREAD_ALREADY_IN_TASK    1552L

/* Windows Installer error codes */
#define ERROR_INSTALL_SERVICE_FAILURE           1601L
#define ERROR_INSTALL_USEREXIT                  1602L
#define ERROR_INSTALL_FAILURE                   1603L
#define ERROR_INSTALL_SUSPEND                   1604L
#define ERROR_UNKNOWN_PRODUCT                   1605L
#define ERROR_UNKNOWN_FEATURE                   1606L
#define ERROR_UNKNOWN_COMPONENT                 1607L
#define ERROR_UNKNOWN_PROPERTY                  1608L
#define ERROR_INVALID_HANDLE_STATE              1609L
#define ERROR_BAD_CONFIGURATION                 1610L
#define ERROR_INDEX_ABSENT                      1611L
#define ERROR_INSTALL_SOURCE_ABSENT             1612L
#define ERROR_INSTALL_PACKAGE_VERSION           1613L
#define ERROR_PRODUCT_UNINSTALLED               1614L
#define ERROR_BAD_QUERY_SYNTAX                  1615L
#define ERROR_INVALID_FIELD                     1616L
#define ERROR_DEVICE_REMOVED                    1617L
#define ERROR_INSTALL_ALREADY_RUNNING           1618L
#define ERROR_INSTALL_PACKAGE_OPEN_FAILED       1619L
#define ERROR_INSTALL_PACKAGE_INVALID           1620L
#define ERROR_INSTALL_UI_FAILURE                1621L
#define ERROR_INSTALL_LOG_FAILURE               1622L
#define ERROR_INSTALL_LANGUAGE_UNSUPPORTED      1623L
#define ERROR_INSTALL_TRANSFORM_FAILURE         1624L
#define ERROR_INSTALL_PACKAGE_REJECTED          1625L
#define ERROR_FUNCTION_NOT_CALLED               1626L
#define ERROR_FUNCTION_FAILED                   1627L
#define ERROR_INVALID_TABLE                     1628L
#define ERROR_DATATYPE_MISMATCH                 1629L
#define ERROR_UNSUPPORTED_TYPE                  1630L
#define ERROR_CREATE_FAILED                     1631L
#define ERROR_INSTALL_TEMP_UNWRITABLE           1632L
#define ERROR_INSTALL_PLATFORM_UNSUPPORTED      1633L
#define ERROR_INSTALL_NOTUSED                   1634L
#define ERROR_PATCH_PACKAGE_OPEN_FAILED         1635L
#define ERROR_PATCH_PACKAGE_INVALID             1636L
#define ERROR_PATCH_PACKAGE_UNSUPPORTED         1637L
#define ERROR_PRODUCT_VERSION                   1638L
#define ERROR_INVALID_COMMAND_LINE              1639L
#define ERROR_INSTALL_REMOTE_DISALLOWED         1640L
#define ERROR_SUCCESS_REBOOT_INITIATED          1641L
#define ERROR_PATCH_TARGET_NOT_FOUND            1642L
#define ERROR_PATCH_PACKAGE_REJECTED            1643L
#define ERROR_INSTALL_TRANSFORM_REJECTED        1644L
#define ERROR_INSTALL_REMOTE_PROHIBITED         1645L
#define ERROR_PATCH_REMOVAL_UNSUPPORTED         1646L
#define ERROR_UNKNOWN_PATCH                     1647L
#define ERROR_PATCH_NO_SEQUENCE                 1648L
#define ERROR_PATCH_REMOVAL_DISALLOWED          1649L
#define ERROR_INVALID_PATCH_XML                 1650L
#define ERROR_PATCH_MANAGED_ADVERTISED_PRODUCT  1651L
#define ERROR_INSTALL_SERVICE_SAFEBOOT          1652L
#define ERROR_FAIL_FAST_EXCEPTION               1653L

/* RPC error codes */
#define RPC_S_INVALID_STRING_BINDING            1700L
#define RPC_S_WRONG_KIND_OF_BINDING             1701L
#define RPC_S_INVALID_BINDING                   1702L
#define RPC_S_PROTSEQ_NOT_SUPPORTED             1703L
#define RPC_S_INVALID_RPC_PROTSEQ               1704L
#define RPC_S_INVALID_STRING_UUID               1705L
#define RPC_S_INVALID_ENDPOINT_FORMAT           1706L
#define RPC_S_INVALID_NET_ADDR                  1707L
#define RPC_S_NO_ENDPOINT_FOUND                 1708L
#define RPC_S_INVALID_TIMEOUT                   1709L
#define RPC_S_OBJECT_NOT_FOUND                  1710L
#define RPC_S_ALREADY_REGISTERED                1711L
#define RPC_S_TYPE_ALREADY_REGISTERED           1712L
#define RPC_S_ALREADY_LISTENING                 1713L
#define RPC_S_NO_PROTSEQS_REGISTERED            1714L
#define RPC_S_NOT_LISTENING                     1715L
#define RPC_S_UNKNOWN_MGR_TYPE                  1716L
#define RPC_S_UNKNOWN_IF                        1717L
#define RPC_S_NO_BINDINGS                       1718L
#define RPC_S_NO_PROTSEQS                       1719L
#define RPC_S_CANT_CREATE_ENDPOINT              1720L
#define RPC_S_OUT_OF_RESOURCES                  1721L
#define RPC_S_SERVER_UNAVAILABLE                1722L
#define RPC_S_SERVER_TOO_BUSY                   1723L
#define RPC_S_INVALID_NETWORK_OPTIONS           1724L
#define RPC_S_NO_CALL_ACTIVE                    1725L
#define RPC_S_CALL_FAILED                       1726L
#define RPC_S_CALL_FAILED_DNE                   1727L
#define RPC_S_PROTOCOL_ERROR                    1728L
#define RPC_S_PROXY_ACCESS_DENIED               1729L
#define RPC_S_UNSUPPORTED_TRANS_SYN             1730L
#define RPC_S_UNSUPPORTED_TYPE                  1732L
#define RPC_S_INVALID_TAG                       1733L
#define RPC_S_INVALID_BOUND                     1734L
#define RPC_S_NO_ENTRY_NAME                     1735L
#define RPC_S_INVALID_NAME_SYNTAX               1736L
#define RPC_S_UNSUPPORTED_NAME_SYNTAX           1737L
#define RPC_S_UUID_NO_ADDRESS                   1739L
#define RPC_S_DUPLICATE_ENDPOINT                1740L
#define RPC_S_UNKNOWN_AUTHN_TYPE                1741L
#define RPC_S_MAX_CALLS_TOO_SMALL               1742L
#define RPC_S_STRING_TOO_LONG                   1743L
#define RPC_S_PROTSEQ_NOT_FOUND                 1744L
#define RPC_S_PROCNUM_OUT_OF_RANGE              1745L
#define RPC_S_BINDING_HAS_NO_AUTH               1746L
#define RPC_S_UNKNOWN_AUTHN_SERVICE             1747L
#define RPC_S_UNKNOWN_AUTHN_LEVEL               1748L
#define RPC_S_INVALID_AUTH_IDENTITY             1749L
#define RPC_S_UNKNOWN_AUTHZ_SERVICE             1750L
#define EPT_S_INVALID_ENTRY                     1751L
#define EPT_S_CANT_PERFORM_OP                   1752L
#define EPT_S_NOT_REGISTERED                    1753L
#define RPC_S_NOTHING_TO_EXPORT                 1754L
#define RPC_S_INCOMPLETE_NAME                   1755L
#define RPC_S_INVALID_VERS_OPTION               1756L
#define RPC_S_NO_MORE_MEMBERS                   1757L
#define RPC_S_NOT_ALL_OBJS_UNEXPORTED           1758L
#define RPC_S_INTERFACE_NOT_FOUND               1759L
#define RPC_S_ENTRY_ALREADY_EXISTS              1760L
#define RPC_S_ENTRY_NOT_FOUND                   1761L
#define RPC_S_NAME_SERVICE_UNAVAILABLE          1762L
#define RPC_S_INVALID_NAF_ID                    1763L
#define RPC_S_CANNOT_SUPPORT                    1764L
#define RPC_S_NO_CONTEXT_AVAILABLE              1765L
#define RPC_S_INTERNAL_ERROR                    1766L
#define RPC_S_ZERO_DIVIDE                       1767L
#define RPC_S_ADDRESS_ERROR                     1768L
#define RPC_S_FP_DIV_ZERO                       1769L
#define RPC_S_FP_UNDERFLOW                      1770L
#define RPC_S_FP_OVERFLOW                       1771L
#define RPC_X_NO_MORE_ENTRIES                   1772L
#define RPC_X_SS_CHAR_TRANS_OPEN_FAIL           1773L
#define RPC_X_SS_CHAR_TRANS_SHORT_FILE          1774L
#define RPC_X_SS_IN_NULL_CONTEXT                1775L
#define RPC_X_SS_CONTEXT_DAMAGED                1777L
#define RPC_X_SS_HANDLES_MISMATCH               1778L
#define RPC_X_SS_CANNOT_GET_CALL_HANDLE         1779L
#define RPC_X_NULL_REF_POINTER                  1780L
#define RPC_X_ENUM_VALUE_OUT_OF_RANGE           1781L
#define RPC_X_BYTE_COUNT_TOO_SMALL              1782L
#define RPC_X_BAD_STUB_DATA                     1783L
#define ERROR_INVALID_USER_BUFFER               1784L
#define ERROR_UNRECOGNIZED_MEDIA                1785L
#define ERROR_NO_TRUST_LSA_SECRET               1786L
#define ERROR_NO_TRUST_SAM_ACCOUNT              1787L
#define ERROR_TRUSTED_DOMAIN_FAILURE            1788L
#define ERROR_TRUSTED_RELATIONSHIP_FAILURE      1789L
#define ERROR_TRUST_FAILURE                     1790L
#define RPC_S_CALL_IN_PROGRESS                  1791L
#define ERROR_NETLOGON_NOT_STARTED              1792L
#define ERROR_ACCOUNT_EXPIRED                   1793L
#define ERROR_REDIRECTOR_HAS_OPEN_HANDLES       1794L
#define ERROR_PRINTER_DRIVER_ALREADY_INSTALLED  1795L
#define ERROR_UNKNOWN_PORT                      1796L
#define ERROR_UNKNOWN_PRINTER_DRIVER            1797L
#define ERROR_UNKNOWN_PRINTPROCESSOR            1798L
#define ERROR_INVALID_SEPARATOR_FILE            1799L
#define ERROR_INVALID_PRIORITY                  1800L
#define ERROR_INVALID_PRINTER_NAME              1801L
#define ERROR_PRINTER_ALREADY_EXISTS            1802L
#define ERROR_INVALID_PRINTER_COMMAND           1803L
#define ERROR_INVALID_DATATYPE                  1804L
#define ERROR_INVALID_ENVIRONMENT               1805L
#define RPC_S_NO_MORE_BINDINGS                  1806L
#define ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT 1807L
#define ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT 1808L
#define ERROR_NOLOGON_SERVER_TRUST_ACCOUNT      1809L
#define ERROR_DOMAIN_TRUST_INCONSISTENT         1810L
#define ERROR_SERVER_HAS_OPEN_HANDLES           1811L
#define ERROR_RESOURCE_DATA_NOT_FOUND           1812L
#define ERROR_RESOURCE_TYPE_NOT_FOUND           1813L
#define ERROR_RESOURCE_NAME_NOT_FOUND           1814L
#define ERROR_RESOURCE_LANG_NOT_FOUND           1815L
#define ERROR_NOT_ENOUGH_QUOTA                  1816L
#define RPC_S_NO_INTERFACES                     1817L
#define RPC_S_CALL_CANCELLED                    1818L
#define RPC_S_BINDING_INCOMPLETE                1819L
#define RPC_S_COMM_FAILURE                      1820L
#define RPC_S_UNSUPPORTED_AUTHN_LEVEL           1821L
#define RPC_S_NO_PRINC_NAME                     1822L
#define RPC_S_NOT_RPC_ERROR                     1823L
#define RPC_S_UUID_LOCAL_ONLY                   1824L
#define RPC_S_SEC_PKG_ERROR                     1825L
#define RPC_S_NOT_CANCELLED                     1826L
#define RPC_X_INVALID_ES_ACTION                 1827L
#define RPC_X_WRONG_ES_VERSION                  1828L
#define RPC_X_WRONG_STUB_VERSION                1829L
#define RPC_X_INVALID_PIPE_OBJECT               1830L
#define RPC_X_WRONG_PIPE_ORDER                  1831L
#define RPC_X_WRONG_PIPE_VERSION                1832L
#define RPC_S_COOKIE_AUTH_FAILED                1833L
#define RPC_S_GROUP_MEMBER_NOT_FOUND            1898L
#define EPT_S_CANT_CREATE                       1899L
#define RPC_S_INVALID_OBJECT                    1900L
#define ERROR_INVALID_TIME                      1901L
#define ERROR_INVALID_FORM_NAME                 1902L
#define ERROR_INVALID_FORM_SIZE                 1903L
#define ERROR_ALREADY_WAITING                   1904L
#define ERROR_PRINTER_DELETED                   1905L
#define ERROR_INVALID_PRINTER_STATE             1906L
#define ERROR_PASSWORD_MUST_CHANGE              1907L
#define ERROR_DOMAIN_CONTROLLER_NOT_FOUND       1908L
#define ERROR_ACCOUNT_LOCKED_OUT                1909L
#define OR_INVALID_OXID                         1910L
#define OR_INVALID_OID                          1911L
#define OR_INVALID_SET                          1912L
#define RPC_S_SEND_INCOMPLETE                   1913L
#define RPC_S_INVALID_ASYNC_HANDLE              1914L
#define RPC_S_INVALID_ASYNC_CALL                1915L
#define RPC_X_PIPE_CLOSED                       1916L
#define RPC_X_PIPE_DISCIPLINE_ERROR             1917L
#define RPC_X_PIPE_EMPTY                        1918L
#define ERROR_NO_SITENAME                       1919L
#define ERROR_CANT_ACCESS_FILE                  1920L
#define ERROR_CANT_RESOLVE_FILENAME             1921L
#define RPC_S_ENTRY_TYPE_MISMATCH               1922L
#define RPC_S_NOT_ALL_OBJS_EXPORTED             1923L
#define RPC_S_INTERFACE_NOT_EXPORTED            1924L
#define RPC_S_PROFILE_NOT_ADDED                 1925L
#define RPC_S_PRF_ELT_NOT_ADDED                 1926L
#define RPC_S_PRF_ELT_NOT_REMOVED               1927L
#define RPC_S_GRP_ELT_NOT_ADDED                 1928L
#define RPC_S_GRP_ELT_NOT_REMOVED               1929L
#define ERROR_KM_DRIVER_BLOCKED                 1930L
#define ERROR_CONTEXT_EXPIRED                   1931L
#define ERROR_PER_USER_TRUST_QUOTA_EXCEEDED     1932L
#define ERROR_ALL_USER_TRUST_QUOTA_EXCEEDED     1933L
#define ERROR_USER_DELETE_TRUST_QUOTA_EXCEEDED  1934L
#define ERROR_AUTHENTICATION_FIREWALL_FAILED    1935L
#define ERROR_REMOTE_PRINT_CONNECTIONS_BLOCKED  1936L
#define ERROR_NTLM_BLOCKED                      1937L

/* OpenGL error codes */
#define ERROR_INVALID_PIXEL_FORMAT      2000L
#define ERROR_BAD_DRIVER                2001L
#define ERROR_INVALID_WINDOW_STYLE      2002L
#define ERROR_METAFILE_NOT_SUPPORTED    2003L
#define ERROR_TRANSFORM_NOT_SUPPORTED   2004L
#define ERROR_CLIPPING_NOT_SUPPORTED    2005L

/* Image Color Management error codes */
#define ERROR_INVALID_CMM                           2010L
#define ERROR_INVALID_PROFILE                       2011L
#define ERROR_TAG_NOT_FOUND                         2012L
#define ERROR_TAG_NOT_PRESENT                       2013L
#define ERROR_DUPLICATE_TAG                         2014L
#define ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE    2015L
#define ERROR_PROFILE_NOT_FOUND                     2016L
#define ERROR_INVALID_COLORSPACE                    2017L
#define ERROR_ICM_NOT_ENABLED                       2018L
#define ERROR_DELETING_ICM_XFORM                    2019L
#define ERROR_INVALID_TRANSFORM                     2020L
#define ERROR_COLORSPACE_MISMATCH                   2021L
#define ERROR_INVALID_COLORINDEX                    2022L
#define ERROR_PROFILE_DOES_NOT_MATCH_DEVICE         2023L

/* Network error codes */
#define ERROR_CONNECTED_OTHER_PASSWORD          2108L
#define ERROR_CONNECTED_OTHER_PASSWORD_DEFAULT  2109L
#define ERROR_BAD_USERNAME                      2202L
#define ERROR_NOT_CONNECTED                     2250L
#define ERROR_OPEN_FILES                        2401L
#define ERROR_ACTIVE_CONNECTIONS                2402L
#define ERROR_DEVICE_IN_USE                     2404L

/* Spooler error codes */
#define ERROR_UNKNOWN_PRINT_MONITOR             3000L
#define ERROR_PRINTER_DRIVER_IN_USE             3001L
#define ERROR_SPOOL_FILE_NOT_FOUND              3002L
#define ERROR_SPL_NO_STARTDOC                   3003L
#define ERROR_SPL_NO_ADDJOB                     3004L
#define ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED 3005L
#define ERROR_PRINT_MONITOR_ALREADY_INSTALLED   3006L
#define ERROR_INVALID_PRINT_MONITOR             3007L
#define ERROR_PRINT_MONITOR_IN_USE              3008L
#define ERROR_PRINTER_HAS_JOBS_QUEUED           3009L
#define ERROR_SUCCESS_REBOOT_REQUIRED           3010L
#define ERROR_SUCCESS_RESTART_REQUIRED          3011L
#define ERROR_PRINTER_NOT_FOUND                 3012L
#define ERROR_PRINTER_DRIVER_WARNED             3013L
#define ERROR_PRINTER_DRIVER_BLOCKED            3014L
#define ERROR_PRINTER_DRIVER_PACKAGE_IN_USE     3015L
#define ERROR_CORE_DRIVER_PACKAGE_NOT_FOUND     3016L
#define ERROR_FAIL_REBOOT_REQUIRED              3017L
#define ERROR_FAIL_REBOOT_INITIATED             3018L
#define ERROR_PRINTER_DRIVER_DOWNLOAD_NEEDED    3019L
#define ERROR_PRINT_JOB_RESTART_REQUIRED        3020L

/* I/O error codes */
#define ERROR_IO_REISSUE_AS_CACHED  3950L

/* WINS error codes */
#define ERROR_WINS_INTERNAL             4000L
#define ERROR_CAN_NOT_DEL_LOCAL_WINS    4001L
#define ERROR_STATIC_INIT               4002L
#define ERROR_INC_BACKUP                4003L
#define ERROR_FULL_BACKUP               4004L
#define ERROR_REC_NON_EXISTENT          4005L
#define ERROR_RPL_NOT_ALLOWED           4006L

/* Peer distribution error codes */
#define PEERDIST_ERROR_CONTENTINFO_VERSION_UNSUPPORTED  4050L
#define PEERDIST_ERROR_CANNOT_PARSE_CONTENTINFO         4051L
#define PEERDIST_ERROR_MISSING_DATA                     4052L
#define PEERDIST_ERROR_NO_MORE                          4053L
#define PEERDIST_ERROR_NOT_INITIALIZED                  4054L
#define PEERDIST_ERROR_ALREADY_INITIALIZED              4055L
#define PEERDIST_ERROR_SHUTDOWN_IN_PROGRESS             4056L
#define PEERDIST_ERROR_INVALIDATED                      4057L
#define PEERDIST_ERROR_ALREADY_EXISTS                   4058L
#define PEERDIST_ERROR_OPERATION_NOTFOUND               4059L
#define PEERDIST_ERROR_ALREADY_COMPLETED                4060L
#define PEERDIST_ERROR_OUT_OF_BOUNDS                    4061L
#define PEERDIST_ERROR_VERSION_UNSUPPORTED              4062L
#define PEERDIST_ERROR_INVALID_CONFIGURATION            4063L
#define PEERDIST_ERROR_NOT_LICENSED                     4064L
#define PEERDIST_ERROR_SERVICE_UNAVAILABLE              4065L

/* DHCP error codes */
#define ERROR_DHCP_ADDRESS_CONFLICT 4100L

/* WMI error codes */
#define ERROR_WMI_GUID_NOT_FOUND            4200L
#define ERROR_WMI_INSTANCE_NOT_FOUND        4201L
#define ERROR_WMI_ITEMID_NOT_FOUND          4202L
#define ERROR_WMI_TRY_AGAIN                 4203L
#define ERROR_WMI_DP_NOT_FOUND              4204L
#define ERROR_WMI_UNRESOLVED_INSTANCE_REF   4205L
#define ERROR_WMI_ALREADY_ENABLED           4206L
#define ERROR_WMI_GUID_DISCONNECTED         4207L
#define ERROR_WMI_SERVER_UNAVAILABLE        4208L
#define ERROR_WMI_DP_FAILED                 4209L
#define ERROR_WMI_INVALID_MOF               4210L
#define ERROR_WMI_INVALID_REGINFO           4211L
#define ERROR_WMI_ALREADY_DISABLED          4212L
#define ERROR_WMI_READ_ONLY                 4213L
#define ERROR_WMI_SET_FAILURE               4214L

/* Media services error codes */
#define ERROR_INVALID_MEDIA                 4300L
#define ERROR_INVALID_LIBRARY               4301L
#define ERROR_INVALID_MEDIA_POOL            4302L
#define ERROR_DRIVE_MEDIA_MISMATCH          4303L
#define ERROR_MEDIA_OFFLINE                 4304L
#define ERROR_LIBRARY_OFFLINE               4305L
#define ERROR_EMPTY                         4306L
#define ERROR_NOT_EMPTY                     4307L
#define ERROR_MEDIA_UNAVAILABLE             4308L
#define ERROR_RESOURCE_DISABLED             4309L
#define ERROR_INVALID_CLEANER               4310L
#define ERROR_UNABLE_TO_CLEAN               4311L
#define ERROR_OBJECT_NOT_FOUND              4312L
#define ERROR_DATABASE_FAILURE              4313L
#define ERROR_DATABASE_FULL                 4314L
#define ERROR_MEDIA_INCOMPATIBLE            4315L
#define ERROR_RESOURCE_NOT_PRESENT          4316L
#define ERROR_INVALID_OPERATION             4317L
#define ERROR_MEDIA_NOT_AVAILABLE           4318L
#define ERROR_DEVICE_NOT_AVAILABLE          4319L
#define ERROR_REQUEST_REFUSED               4320L
#define ERROR_INVALID_DRIVE_OBJECT          4321L
#define ERROR_LIBRARY_FULL                  4322L
#define ERROR_MEDIUM_NOT_ACCESSIBLE         4323L
#define ERROR_UNABLE_TO_LOAD_MEDIUM         4324L
#define ERROR_UNABLE_TO_INVENTORY_DRIVE     4325L
#define ERROR_UNABLE_TO_INVENTORY_SLOT      4326L
#define ERROR_UNABLE_TO_INVENTORY_TRANSPORT 4327L
#define ERROR_TRANSPORT_FULL                4328L
#define ERROR_CONTROLLING_IEPORT            4329L
#define ERROR_UNABLE_TO_EJECT_MOUNTED_MEDIA 4330L
#define ERROR_CLEANER_SLOT_SET              4331L
#define ERROR_CLEANER_SLOT_NOT_SET          4332L
#define ERROR_CLEANER_CARTRIDGE_SPENT       4333L
#define ERROR_UNEXPECTED_OMID               4334L
#define ERROR_CANT_DELETE_LAST_ITEM         4335L
#define ERROR_MESSAGE_EXCEEDS_MAX_SIZE      4336L
#define ERROR_VOLUME_CONTAINS_SYS_FILES     4337L
#define ERROR_INDIGENOUS_TYPE               4338L
#define ERROR_NO_SUPPORTING_DRIVES          4339L
#define ERROR_CLEANER_CARTRIDGE_INSTALLED   4340L
#define ERROR_IEPORT_FULL                   4341L

/* Remote storage error codes */
#define ERROR_FILE_OFFLINE                  4350L
#define ERROR_REMOTE_STORAGE_NOT_ACTIVE     4351L
#define ERROR_REMOTE_STORAGE_MEDIA_ERROR    4352L

/* Reparse point error codes */
#define ERROR_NOT_A_REPARSE_POINT           4390L
#define ERROR_REPARSE_ATTRIBUTE_CONFLICT    4391L
#define ERROR_INVALID_REPARSE_DATA          4392L
#define ERROR_REPARSE_TAG_INVALID           4393L
#define ERROR_REPARSE_TAG_MISMATCH          4394L

/* Single instance store error codes */
#define ERROR_VOLUME_NOT_SIS_ENABLED    4500L

/* Cluster error codes */
#define ERROR_DEPENDENT_RESOURCE_EXISTS                 5001L
#define ERROR_DEPENDENCY_NOT_FOUND                      5002L
#define ERROR_DEPENDENCY_ALREADY_EXISTS                 5003L
#define ERROR_RESOURCE_NOT_ONLINE                       5004L
#define ERROR_HOST_NODE_NOT_AVAILABLE                   5005L
#define ERROR_RESOURCE_NOT_AVAILABLE                    5006L
#define ERROR_RESOURCE_NOT_FOUND                        5007L
#define ERROR_SHUTDOWN_CLUSTER                          5008L
#define ERROR_CANT_EVICT_ACTIVE_NODE                    5009L
#define ERROR_OBJECT_ALREADY_EXISTS                     5010L
#define ERROR_OBJECT_IN_LIST                            5011L
#define ERROR_GROUP_NOT_AVAILABLE                       5012L
#define ERROR_GROUP_NOT_FOUND                           5013L
#define ERROR_GROUP_NOT_ONLINE                          5014L
#define ERROR_HOST_NODE_NOT_RESOURCE_OWNER              5015L
#define ERROR_HOST_NODE_NOT_GROUP_OWNER                 5016L
#define ERROR_RESMON_CREATE_FAILED                      5017L
#define ERROR_RESMON_ONLINE_FAILED                      5018L
#define ERROR_RESOURCE_ONLINE                           5019L
#define ERROR_QUORUM_RESOURCE                           5020L
#define ERROR_NOT_QUORUM_CAPABLE                        5021L
#define ERROR_CLUSTER_SHUTTING_DOWN                     5022L
#define ERROR_INVALID_STATE                             5023L
#define ERROR_RESOURCE_PROPERTIES_STORED                5024L
#define ERROR_NOT_QUORUM_CLASS                          5025L
#define ERROR_CORE_RESOURCE                             5026L
#define ERROR_QUORUM_RESOURCE_ONLINE_FAILED             5027L
#define ERROR_QUORUMLOG_OPEN_FAILED                     5028L
#define ERROR_CLUSTERLOG_CORRUPT                        5029L
#define ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE         5030L
#define ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE                5031L
#define ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND             5032L
#define ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE               5033L
#define ERROR_QUORUM_OWNER_ALIVE                        5034L
#define ERROR_NETWORK_NOT_AVAILABLE                     5035L
#define ERROR_NODE_NOT_AVAILABLE                        5036L
#define ERROR_ALL_NODES_NOT_AVAILABLE                   5037L
#define ERROR_RESOURCE_FAILED                           5038L
#define ERROR_CLUSTER_INVALID_NODE                      5039L
#define ERROR_CLUSTER_NODE_EXISTS                       5040L
#define ERROR_CLUSTER_JOIN_IN_PROGRESS                  5041L
#define ERROR_CLUSTER_NODE_NOT_FOUND                    5042L
#define ERROR_CLUSTER_LOCAL_NODE_NOT_FOUND              5043L
#define ERROR_CLUSTER_NETWORK_EXISTS                    5044L
#define ERROR_CLUSTER_NETWORK_NOT_FOUND                 5045L
#define ERROR_CLUSTER_NETINTERFACE_EXISTS               5046L
#define ERROR_CLUSTER_NETINTERFACE_NOT_FOUND            5047L
#define ERROR_CLUSTER_INVALID_REQUEST                   5048L
#define ERROR_CLUSTER_INVALID_NETWORK_PROVIDER          5049L
#define ERROR_CLUSTER_NODE_DOWN                         5050L
#define ERROR_CLUSTER_NODE_UNREACHABLE                  5051L
#define ERROR_CLUSTER_NODE_NOT_MEMBER                   5052L
#define ERROR_CLUSTER_JOIN_NOT_IN_PROGRESS              5053L
#define ERROR_CLUSTER_INVALID_NETWORK                   5054L
#define ERROR_CLUSTER_NODE_UP                           5056L
#define ERROR_CLUSTER_IPADDR_IN_USE                     5057L
#define ERROR_CLUSTER_NODE_NOT_PAUSED                   5058L
#define ERROR_CLUSTER_NO_SECURITY_CONTEXT               5059L
#define ERROR_CLUSTER_NETWORK_NOT_INTERNAL              5060L
#define ERROR_CLUSTER_NODE_ALREADY_UP                   5061L
#define ERROR_CLUSTER_NODE_ALREADY_DOWN                 5062L
#define ERROR_CLUSTER_NETWORK_ALREADY_ONLINE            5063L
#define ERROR_CLUSTER_NETWORK_ALREADY_OFFLINE           5064L
#define ERROR_CLUSTER_NODE_ALREADY_MEMBER               5065L
#define ERROR_CLUSTER_LAST_INTERNAL_NETWORK             5066L
#define ERROR_CLUSTER_NETWORK_HAS_DEPENDENTS            5067L
#define ERROR_INVALID_OPERATION_ON_QUORUM               5068L
#define ERROR_DEPENDENCY_NOT_ALLOWED                    5069L
#define ERROR_CLUSTER_NODE_PAUSED                       5070L
#define ERROR_NODE_CANT_HOST_RESOURCE                   5071L
#define ERROR_CLUSTER_NODE_NOT_READY                    5072L
#define ERROR_CLUSTER_NODE_SHUTTING_DOWN                5073L
#define ERROR_CLUSTER_JOIN_ABORTED                      5074L
#define ERROR_CLUSTER_INCOMPATIBLE_VERSIONS             5075L
#define ERROR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED      5076L
#define ERROR_CLUSTER_SYSTEM_CONFIG_CHANGED             5077L
#define ERROR_CLUSTER_RESOURCE_TYPE_NOT_FOUND           5078L
#define ERROR_CLUSTER_RESTYPE_NOT_SUPPORTED             5079L
#define ERROR_CLUSTER_RESNAME_NOT_FOUND                 5080L
#define ERROR_CLUSTER_NO_RPC_PACKAGES_REGISTERED        5081L
#define ERROR_CLUSTER_OWNER_NOT_IN_PREFLIST             5082L
#define ERROR_CLUSTER_DATABASE_SEQMISMATCH              5083L
#define ERROR_RESMON_INVALID_STATE                      5084L
#define ERROR_CLUSTER_GUM_NOT_LOCKER                    5085L
#define ERROR_QUORUM_DISK_NOT_FOUND                     5086L
#define ERROR_DATABASE_BACKUP_CORRUPT                   5087L
#define ERROR_CLUSTER_NODE_ALREADY_HAS_DFS_ROOT         5088L
#define ERROR_RESOURCE_PROPERTY_UNCHANGEABLE            5089L
#define ERROR_CLUSTER_MEMBERSHIP_INVALID_STATE          5890L
#define ERROR_CLUSTER_QUORUMLOG_NOT_FOUND               5891L
#define ERROR_CLUSTER_MEMBERSHIP_HALT                   5892L
#define ERROR_CLUSTER_INSTANCE_ID_MISMATCH              5893L
#define ERROR_CLUSTER_NETWORK_NOT_FOUND_FOR_IP          5894L
#define ERROR_CLUSTER_PROPERTY_DATA_TYPE_MISMATCH       5895L
#define ERROR_CLUSTER_EVICT_WITHOUT_CLEANUP             5896L
#define ERROR_CLUSTER_PARAMETER_MISMATCH                5897L
#define ERROR_NODE_CANNOT_BE_CLUSTERED                  5898L
#define ERROR_CLUSTER_WRONG_OS_VERSION                  5899L
#define ERROR_CLUSTER_CANT_CREATE_DUP_CLUSTER_NAME      5900L
#define ERROR_CLUSCFG_ALREADY_COMMITTED                 5901L
#define ERROR_CLUSCFG_ROLLBACK_FAILED                   5902L
#define ERROR_CLUSCFG_SYSTEM_DISK_DRIVE_LETTER_CONFLICT 5903L
#define ERROR_CLUSTER_OLD_VERSION                       5904L
#define ERROR_CLUSTER_MISMATCHED_COMPUTER_ACCT_NAME     5905L
#define ERROR_CLUSTER_NO_NET_ADAPTERS                   5906L
#define ERROR_CLUSTER_POISONED                          5907L
#define ERROR_CLUSTER_GROUP_MOVING                      5908L
#define ERROR_CLUSTER_RESOURCE_TYPE_BUSY                5909L
#define ERROR_RESOURCE_CALL_TIMED_OUT                   5910L
#define ERROR_INVALID_CLUSTER_IPV6_ADDRESS              5911L
#define ERROR_CLUSTER_INTERNAL_INVALID_FUNCTION         5912L
#define ERROR_CLUSTER_PARAMETER_OUT_OF_BOUNDS           5913L
#define ERROR_CLUSTER_PARTIAL_SEND                      5914L
#define ERROR_CLUSTER_REGISTRY_INVALID_FUNCTION         5915L
#define ERROR_CLUSTER_INVALID_STRING_TERMINATION        5916L
#define ERROR_CLUSTER_INVALID_STRING_FORMAT             5917L
#define ERROR_CLUSTER_DATABASE_TRANSACTION_IN_PROGRESS  5918L
#define ERROR_CLUSTER_DATABASE_TRANSACTION_NOT_IN_PROGRESS  5919L
#define ERROR_CLUSTER_NULL_DATA                         5920L
#define ERROR_CLUSTER_PARTIAL_READ                      5921L
#define ERROR_CLUSTER_PARTIAL_WRITE                     5922L
#define ERROR_CLUSTER_CANT_DESERIALIZE_DATA             5923L
#define ERROR_DEPENDENT_RESOURCE_PROPERTY_CONFLICT      5924L
#define ERROR_CLUSTER_NO_QUORUM                         5925L
#define ERROR_CLUSTER_INVALID_IPV6_NETWORK              5926L
#define ERROR_CLUSTER_INVALID_IPV6_TUNNEL_NETWORK       5927L
#define ERROR_QUORUM_NOT_ALLOWED_IN_THIS_GROUP          5928L
#define ERROR_DEPENDENCY_TREE_TOO_COMPLEX               5929L
#define ERROR_EXCEPTION_IN_RESOURCE_CALL                5930L
#define ERROR_CLUSTER_RHS_FAILED_INITIALIZATION         5931L
#define ERROR_CLUSTER_NOT_INSTALLED                     5932L
#define ERROR_CLUSTER_RESOURCES_MUST_BE_ONLINE_ON_THE_SAME_NODE 5933L
#define ERROR_CLUSTER_MAX_NODES_IN_CLUSTER              5934L
#define ERROR_CLUSTER_TOO_MANY_NODES                    5935L
#define ERROR_CLUSTER_OBJECT_ALREADY_USED               5936L
#define ERROR_NONCORE_GROUPS_FOUNDED                    5937L
#define ERROR_FILE_SHARE_RESOURCE_CONFLICT              5938L
#define ERROR_CLUSTER_EVICT_INVALID_REQUEST             5939L
#define ERROR_CLUSTER_SINGLETON_RESOURCE                5940L
#define ERROR_CLUSTER_GROUP_SINGLETON_RESOURCE          5941L
#define ERROR_CLUSTER_RESOURCE_PROVIDER_FAILED          5942L
#define ERROR_CLUSTER_RESOURCE_CONFIGURATION_ERROR      5943L
#define ERROR_CLUSTER_GROUP_BUSY                        5944L
#define ERROR_CLUSTER_NOT_SHARED_VOLUME                 5945L
#define ERROR_CLUSTER_INVALID_SECURITY_DESCRIPTOR       5946L
#define ERROR_CLUSTER_SHARED_VOLUMES_IN_USE             5947L
#define ERROR_CLUSTER_USE_SHARED_VOLUMES_API            5948L
#define ERROR_CLUSTER_BACKUP_IN_PROGRESS                5949L
#define ERROR_NON_CSV_PATH                              5950L
#define ERROR_CSV_VOLUME_NOT_LOCAL                      5951L
#define ERROR_CLUSTER_WATCHDOG_TERMINATING              5952L

/* EFS error codes */
#define ERROR_ENCRYPTION_FAILED                     6000L
#define ERROR_DECRYPTION_FAILED                     6001L
#define ERROR_FILE_ENCRYPTED                        6002L
#define ERROR_NO_RECOVERY_POLICY                    6003L
#define ERROR_NO_EFS                                6004L
#define ERROR_WRONG_EFS                             6005L
#define ERROR_NO_USER_KEYS                          6006L
#define ERROR_FILE_NOT_ENCRYPTED                    6007L
#define ERROR_NOT_EXPORT_FORMAT                     6008L
#define ERROR_FILE_READ_ONLY                        6009L
#define ERROR_DIR_EFS_DISALLOWED                    6010L
#define ERROR_EFS_SERVER_NOT_TRUSTED                6011L
#define ERROR_BAD_RECOVERY_POLICY                   6012L
#define ERROR_EFS_ALG_BLOB_TOO_BIG                  6013L
#define ERROR_VOLUME_NOT_SUPPORT_EFS                6014L
#define ERROR_EFS_DISABLED                          6015L
#define ERROR_EFS_VERSION_NOT_SUPPORT               6016L
#define ERROR_CS_ENCRYPTION_INVALID_SERVER_RESPONSE 6017L
#define ERROR_CS_ENCRYPTION_UNSUPPORTED_SERVER      6018L
#define ERROR_CS_ENCRYPTION_EXISTING_ENCRYPTED_FILE 6019L
#define ERROR_CS_ENCRYPTION_NEW_ENCRYPTED_FILE      6020L
#define ERROR_CS_ENCRYPTION_FILE_NOT_CSE            6021L
#define ERROR_ENCRYPTION_POLICY_DENIES_OPERATION    6022L

/* Browser error codes */
#define ERROR_NO_BROWSER_SERVERS_FOUND  6118L

/* Task scheduler error codes */
#define SCHED_E_SERVICE_NOT_LOCALSYSTEM 6200L

/* Common log error codes */
#define ERROR_LOG_SECTOR_INVALID            6600L
#define ERROR_LOG_SECTOR_PARITY_INVALID     6601L
#define ERROR_LOG_SECTOR_REMAPPED           6602L
#define ERROR_LOG_BLOCK_INCOMPLETE          6603L
#define ERROR_LOG_INVALID_RANGE             6604L
#define ERROR_LOG_BLOCKS_EXHAUSTED          6605L
#define ERROR_LOG_READ_CONTEXT_INVALID      6606L
#define ERROR_LOG_RESTART_INVALID           6607L
#define ERROR_LOG_BLOCK_VERSION             6608L
#define ERROR_LOG_BLOCK_INVALID             6609L
#define ERROR_LOG_READ_MODE_INVALID         6610L
#define ERROR_LOG_NO_RESTART                6611L
#define ERROR_LOG_METADATA_CORRUPT          6612L
#define ERROR_LOG_METADATA_INVALID          6613L
#define ERROR_LOG_METADATA_INCONSISTENT     6614L
#define ERROR_LOG_RESERVATION_INVALID       6615L
#define ERROR_LOG_CANT_DELETE               6616L
#define ERROR_LOG_CONTAINER_LIMIT_EXCEEDED  6617L
#define ERROR_LOG_START_OF_LOG              6618L
#define ERROR_LOG_POLICY_ALREADY_INSTALLED  6619L
#define ERROR_LOG_POLICY_NOT_INSTALLED      6620L
#define ERROR_LOG_POLICY_INVALID            6621L
#define ERROR_LOG_POLICY_CONFLICT           6622L
#define ERROR_LOG_PINNED_ARCHIVE_TAIL       6623L
#define ERROR_LOG_RECORD_NONEXISTENT        6624L
#define ERROR_LOG_RECORDS_RESERVED_INVALID  6625L
#define ERROR_LOG_SPACE_RESERVED_INVALID    6626L
#define ERROR_LOG_TAIL_INVALID              6627L
#define ERROR_LOG_FULL                      6628L
#define ERROR_COULD_NOT_RESIZE_LOG          6629L
#define ERROR_LOG_MULTIPLEXED               6630L
#define ERROR_LOG_DEDICATED                 6631L
#define ERROR_LOG_ARCHIVE_NOT_IN_PROGRESS   6632L
#define ERROR_LOG_ARCHIVE_IN_PROGRESS       6633L
#define ERROR_LOG_EPHEMERAL                 6634L
#define ERROR_LOG_NOT_ENOUGH_CONTAINERS     6635L
#define ERROR_LOG_CLIENT_ALREADY_REGISTERED 6636L
#define ERROR_LOG_CLIENT_NOT_REGISTERED     6637L
#define ERROR_LOG_FULL_HANDLER_IN_PROGRESS  6638L
#define ERROR_LOG_CONTAINER_READ_FAILED     6639L
#define ERROR_LOG_CONTAINER_WRITE_FAILED    6640L
#define ERROR_LOG_CONTAINER_OPEN_FAILED     6641L
#define ERROR_LOG_CONTAINER_STATE_INVALID   6642L
#define ERROR_LOG_STATE_INVALID             6643L
#define ERROR_LOG_PINNED                    6644L
#define ERROR_LOG_METADATA_FLUSH_FAILED     6645L
#define ERROR_LOG_INCONSISTENT_SECURITY     6646L
#define ERROR_LOG_APPENDED_FLUSH_FAILED     6647L
#define ERROR_LOG_PINNED_RESERVATION        6648L

/* Transaction error codes */
#define ERROR_INVALID_TRANSACTION                           6700L
#define ERROR_TRANSACTION_NOT_ACTIVE                        6701L
#define ERROR_TRANSACTION_REQUEST_NOT_VALID                 6702L
#define ERROR_TRANSACTION_NOT_REQUESTED                     6703L
#define ERROR_TRANSACTION_ALREADY_ABORTED                   6704L
#define ERROR_TRANSACTION_ALREADY_COMMITTED                 6705L
#define ERROR_TM_INITIALIZATION_FAILED                      6706L
#define ERROR_RESOURCEMANAGER_READ_ONLY                     6707L
#define ERROR_TRANSACTION_NOT_JOINED                        6708L
#define ERROR_TRANSACTION_SUPERIOR_EXISTS                   6709L
#define ERROR_CRM_PROTOCOL_ALREADY_EXISTS                   6710L
#define ERROR_TRANSACTION_PROPAGATION_FAILED                6711L
#define ERROR_CRM_PROTOCOL_NOT_FOUND                        6712L
#define ERROR_TRANSACTION_INVALID_MARSHALL_BUFFER           6713L
#define ERROR_CURRENT_TRANSACTION_NOT_VALID                 6714L
#define ERROR_TRANSACTION_NOT_FOUND                         6715L
#define ERROR_RESOURCEMANAGER_NOT_FOUND                     6716L
#define ERROR_ENLISTMENT_NOT_FOUND                          6717L
#define ERROR_TRANSACTIONMANAGER_NOT_FOUND                  6718L
#define ERROR_TRANSACTIONMANAGER_NOT_ONLINE                 6719L
#define ERROR_TRANSACTIONMANAGER_RECOVERY_NAME_COLLISION    6720L
#define ERROR_TRANSACTION_NOT_ROOT                          6721L
#define ERROR_TRANSACTION_OBJECT_EXPIRED                    6722L
#define ERROR_TRANSACTION_RESPONSE_NOT_ENLISTED             6723L
#define ERROR_TRANSACTION_RECORD_TOO_LONG                   6724L
#define ERROR_IMPLICIT_TRANSACTION_NOT_SUPPORTED            6725L
#define ERROR_TRANSACTION_INTEGRITY_VIOLATED                6726L
#define ERROR_TRANSACTIONMANAGER_IDENTITY_MISMATCH          6727L
#define ERROR_RM_CANNOT_BE_FROZEN_FOR_SNAPSHOT              6728L
#define ERROR_TRANSACTION_MUST_WRITETHROUGH                 6729L
#define ERROR_TRANSACTION_NO_SUPERIOR                       6730L
#define ERROR_HEURISTIC_DAMAGE_POSSIBLE                     6731L

/* Transaction file services error codes */
#define ERROR_TRANSACTIONAL_CONFLICT                                6800L
#define ERROR_RM_NOT_ACTIVE                                         6801L
#define ERROR_RM_METADATA_CORRUPT                                   6802L
#define ERROR_DIRECTORY_NOT_RM                                      6803L
#define ERROR_TRANSACTIONS_UNSUPPORTED_REMOTE                       6805L
#define ERROR_LOG_RESIZE_INVALID_SIZE                               6806L
#define ERROR_OBJECT_NO_LONGER_EXISTS                               6807L
#define ERROR_STREAM_MINIVERSION_NOT_FOUND                          6808L
#define ERROR_STREAM_MINIVERSION_NOT_VALID                          6809L
#define ERROR_MINIVERSION_INACCESSIBLE_FROM_SPECIFIED_TRANSACTION   6810L
#define ERROR_CANT_OPEN_MINIVERSION_WITH_MODIFY_INTENT              6811L
#define ERROR_CANT_CREATE_MORE_STREAM_MINIVERSIONS                  6812L
#define ERROR_REMOTE_FILE_VERSION_MISMATCH                          6814L
#define ERROR_HANDLE_NO_LONGER_VALID                                6815L
#define ERROR_NO_TXF_METADATA                                       6816L
#define ERROR_LOG_CORRUPTION_DETECTED                               6817L
#define ERROR_CANT_RECOVER_WITH_HANDLE_OPEN                         6818L
#define ERROR_RM_DISCONNECTED                                       6819L
#define ERROR_ENLISTMENT_NOT_SUPERIOR                               6820L
#define ERROR_RECOVERY_NOT_NEEDED                                   6821L
#define ERROR_RM_ALREADY_STARTED                                    6822L
#define ERROR_FILE_IDENTITY_NOT_PERSISTENT                          6823L
#define ERROR_CANT_BREAK_TRANSACTIONAL_DEPENDENCY                   6824L
#define ERROR_CANT_CROSS_RM_BOUNDARY                                6825L
#define ERROR_TXF_DIR_NOT_EMPTY                                     6826L
#define ERROR_INDOUBT_TRANSACTIONS_EXIST                            6827L
#define ERROR_TM_VOLATILE                                           6828L
#define ERROR_ROLLBACK_TIMER_EXPIRED                                6829L
#define ERROR_TXF_ATTRIBUTE_CORRUPT                                 6830L
#define ERROR_EFS_NOT_ALLOWED_IN_TRANSACTION                        6831L
#define ERROR_TRANSACTIONAL_OPEN_NOT_ALLOWED                        6832L
#define ERROR_LOG_GROWTH_FAILED                                     6833L
#define ERROR_TRANSACTED_MAPPING_UNSUPPORTED_REMOTE                 6834L
#define ERROR_TXF_METADATA_ALREADY_PRESENT                          6835L
#define ERROR_TRANSACTION_SCOPE_CALLBACKS_NOT_SET                   6836L
#define ERROR_TRANSACTION_REQUIRED_PROMOTION                        6837L
#define ERROR_CANNOT_EXECUTE_FILE_IN_TRANSACTION                    6838L
#define ERROR_TRANSACTIONS_NOT_FROZEN                               6839L
#define ERROR_TRANSACTION_FREEZE_IN_PROGRESS                        6840L
#define ERROR_NOT_SNAPSHOT_VOLUME                                   6841L
#define ERROR_NO_SAVEPOINT_WITH_OPEN_FILES                          6842L
#define ERROR_DATA_LOST_REPAIR                                      6843L
#define ERROR_SPARSE_NOT_ALLOWED_IN_TRANSACTION                     6844L
#define ERROR_TM_IDENTITY_MISMATCH                                  6845L
#define ERROR_FLOATED_SECTION                                       6846L
#define ERROR_CANNOT_ACCEPT_TRANSACTED_WORK                         6847L
#define ERROR_CANNOT_ABORT_TRANSACTIONS                             6848L
#define ERROR_BAD_CLUSTERS                                          6849L
#define ERROR_COMPRESSION_NOT_ALLOWED_IN_TRANSACTION                6850L
#define ERROR_VOLUME_DIRTY                                          6851L
#define ERROR_NO_LINK_TRACKING_IN_TRANSACTION                       6852L
#define ERROR_OPERATION_NOT_SUPPORTED_IN_TRANSACTION                6853L
#define ERROR_EXPIRED_HANDLE                                        6854L
#define ERROR_TRANSACTION_NOT_ENLISTED                              6855L

/* Terminal server error codes */
#define ERROR_CTX_WINSTATION_NAME_INVALID       7001L
#define ERROR_CTX_INVALID_PD                    7002L
#define ERROR_CTX_PD_NOT_FOUND                  7003L
#define ERROR_CTX_WD_NOT_FOUND                  7004L
#define ERROR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY    7005L
#define ERROR_CTX_SERVICE_NAME_COLLISION        7006L
#define ERROR_CTX_CLOSE_PENDING                 7007L
#define ERROR_CTX_NO_OUTBUF                     7008L
#define ERROR_CTX_MODEM_INF_NOT_FOUND           7009L
#define ERROR_CTX_INVALID_MODEMNAME             7010L
#define ERROR_CTX_MODEM_RESPONSE_ERROR          7011L
#define ERROR_CTX_MODEM_RESPONSE_TIMEOUT        7012L
#define ERROR_CTX_MODEM_RESPONSE_NO_CARRIER     7013L
#define ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE    7014L
#define ERROR_CTX_MODEM_RESPONSE_BUSY           7015L
#define ERROR_CTX_MODEM_RESPONSE_VOICE          7016L
#define ERROR_CTX_TD_ERROR                      7017L
#define ERROR_CTX_WINSTATION_NOT_FOUND          7022L
#define ERROR_CTX_WINSTATION_ALREADY_EXISTS     7023L
#define ERROR_CTX_WINSTATION_BUSY               7024L
#define ERROR_CTX_BAD_VIDEO_MODE                7025L
#define ERROR_CTX_GRAPHICS_INVALID              7035L
#define ERROR_CTX_LOGON_DISABLED                7037L
#define ERROR_CTX_NOT_CONSOLE                   7038L
#define ERROR_CTX_CLIENT_QUERY_TIMEOUT          7040L
#define ERROR_CTX_CONSOLE_DISCONNECT            7041L
#define ERROR_CTX_CONSOLE_CONNECT               7042L
#define ERROR_CTX_SHADOW_DENIED                 7044L
#define ERROR_CTX_WINSTATION_ACCESS_DENIED      7045L
#define ERROR_CTX_INVALID_WD                    7049L
#define ERROR_CTX_SHADOW_INVALID                7050L
#define ERROR_CTX_SHADOW_DISABLED               7051L
#define ERROR_CTX_CLIENT_LICENSE_IN_USE         7052L
#define ERROR_CTX_CLIENT_LICENSE_NOT_SET        7053L
#define ERROR_CTX_LICENSE_NOT_AVAILABLE         7054L
#define ERROR_CTX_LICENSE_CLIENT_INVALID        7055L
#define ERROR_CTX_LICENSE_EXPIRED               7056L
#define ERROR_CTX_SHADOW_NOT_RUNNING            7057L
#define ERROR_CTX_SHADOW_ENDED_BY_MODE_CHANGE   7058L
#define ERROR_ACTIVATION_COUNT_EXCEEDED         7059L
#define ERROR_CTX_WINSTATIONS_DISABLED          7060L
#define ERROR_CTX_ENCRYPTION_LEVEL_REQUIRED     7061L
#define ERROR_CTX_SESSION_IN_USE                7062L
#define ERROR_CTX_NO_FORCE_LOGOFF               7063L
#define ERROR_CTX_ACCOUNT_RESTRICTION           7064L
#define ERROR_RDP_PROTOCOL_ERROR                7065L
#define ERROR_CTX_CDM_CONNECT                   7066L
#define ERROR_CTX_CDM_DISCONNECT                7067L
#define ERROR_CTX_SECURITY_LAYER_ERROR          7068L
#define ERROR_TS_INCOMPATIBLE_SESSIONS          7069L
#define ERROR_TS_VIDEO_SUBSYSTEM_ERROR          7070L

/* Active Directory error codes */
#define DS_S_SUCCESS                                            NO_ERROR
#define FRS_ERR_INVALID_API_SEQUENCE                            8001L
#define FRS_ERR_STARTING_SERVICE                                8002L
#define FRS_ERR_STOPPING_SERVICE                                8003L
#define FRS_ERR_INTERNAL_API                                    8004L
#define FRS_ERR_INTERNAL                                        8005L
#define FRS_ERR_SERVICE_COMM                                    8006L
#define FRS_ERR_INSUFFICIENT_PRIV                               8007L
#define FRS_ERR_AUTHENTICATION                                  8008L
#define FRS_ERR_PARENT_INSUFFICIENT_PRIV                        8009L
#define FRS_ERR_PARENT_AUTHENTICATION                           8010L
#define FRS_ERR_CHILD_TO_PARENT_COMM                            8011L
#define FRS_ERR_PARENT_TO_CHILD_COMM                            8012L
#define FRS_ERR_SYSVOL_POPULATE                                 8013L
#define FRS_ERR_SYSVOL_POPULATE_TIMEOUT                         8014L
#define FRS_ERR_SYSVOL_IS_BUSY                                  8015L
#define FRS_ERR_SYSVOL_DEMOTE                                   8016L
#define FRS_ERR_INVALID_SERVICE_PARAMETER                       8017L
#define ERROR_DS_NOT_INSTALLED                                  8200L
#define ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY                   8201L
#define ERROR_DS_NO_ATTRIBUTE_OR_VALUE                          8202L
#define ERROR_DS_INVALID_ATTRIBUTE_SYNTAX                       8203L
#define ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED                       8204L
#define ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS                      8205L
#define ERROR_DS_BUSY                                           8206L
#define ERROR_DS_UNAVAILABLE                                    8207L
#define ERROR_DS_NO_RIDS_ALLOCATED                              8208L
#define ERROR_DS_NO_MORE_RIDS                                   8209L
#define ERROR_DS_INCORRECT_ROLE_OWNER                           8210L
#define ERROR_DS_RIDMGR_INIT_ERROR                              8211L
#define ERROR_DS_OBJ_CLASS_VIOLATION                            8212L
#define ERROR_DS_CANT_ON_NON_LEAF                               8213L
#define ERROR_DS_CANT_ON_RDN                                    8214L
#define ERROR_DS_CANT_MOD_OBJ_CLASS                             8215L
#define ERROR_DS_CROSS_DOM_MOVE_ERROR                           8216L
#define ERROR_DS_GC_NOT_AVAILABLE                               8217L
#define ERROR_SHARED_POLICY                                     8218L
#define ERROR_POLICY_OBJECT_NOT_FOUND                           8219L
#define ERROR_POLICY_ONLY_IN_DS                                 8220L
#define ERROR_PROMOTION_ACTIVE                                  8221L
#define ERROR_NO_PROMOTION_ACTIVE                               8222L
#define ERROR_DS_OPERATIONS_ERROR                               8224L
#define ERROR_DS_PROTOCOL_ERROR                                 8225L
#define ERROR_DS_TIMELIMIT_EXCEEDED                             8226L
#define ERROR_DS_SIZELIMIT_EXCEEDED                             8227L
#define ERROR_DS_ADMIN_LIMIT_EXCEEDED                           8228L
#define ERROR_DS_COMPARE_FALSE                                  8229L
#define ERROR_DS_COMPARE_TRUE                                   8230L
#define ERROR_DS_AUTH_METHOD_NOT_SUPPORTED                      8231L
#define ERROR_DS_STRONG_AUTH_REQUIRED                           8232L
#define ERROR_DS_INAPPROPRIATE_AUTH                             8233L
#define ERROR_DS_AUTH_UNKNOWN                                   8234L
#define ERROR_DS_REFERRAL                                       8235L
#define ERROR_DS_UNAVAILABLE_CRIT_EXTENSION                     8236L
#define ERROR_DS_CONFIDENTIALITY_REQUIRED                       8237L
#define ERROR_DS_INAPPROPRIATE_MATCHING                         8238L
#define ERROR_DS_CONSTRAINT_VIOLATION                           8239L
#define ERROR_DS_NO_SUCH_OBJECT                                 8240L
#define ERROR_DS_ALIAS_PROBLEM                                  8241L
#define ERROR_DS_INVALID_DN_SYNTAX                              8242L
#define ERROR_DS_IS_LEAF                                        8243L
#define ERROR_DS_ALIAS_DEREF_PROBLEM                            8244L
#define ERROR_DS_UNWILLING_TO_PERFORM                           8245L
#define ERROR_DS_LOOP_DETECT                                    8246L
#define ERROR_DS_NAMING_VIOLATION                               8247L
#define ERROR_DS_OBJECT_RESULTS_TOO_LARGE                       8248L
#define ERROR_DS_AFFECTS_MULTIPLE_DSAS                          8249L
#define ERROR_DS_SERVER_DOWN                                    8250L
#define ERROR_DS_LOCAL_ERROR                                    8251L
#define ERROR_DS_ENCODING_ERROR                                 8252L
#define ERROR_DS_DECODING_ERROR                                 8253L
#define ERROR_DS_FILTER_UNKNOWN                                 8254L
#define ERROR_DS_PARAM_ERROR                                    8255L
#define ERROR_DS_NOT_SUPPORTED                                  8256L
#define ERROR_DS_NO_RESULTS_RETURNED                            8257L
#define ERROR_DS_CONTROL_NOT_FOUND                              8258L
#define ERROR_DS_CLIENT_LOOP                                    8259L
#define ERROR_DS_REFERRAL_LIMIT_EXCEEDED                        8260L
#define ERROR_DS_SORT_CONTROL_MISSING                           8261L
#define ERROR_DS_OFFSET_RANGE_ERROR                             8262L
#define ERROR_DS_ROOT_MUST_BE_NC                                8301L
#define ERROR_DS_ADD_REPLICA_INHIBITED                          8302L
#define ERROR_DS_ATT_NOT_DEF_IN_SCHEMA                          8303L
#define ERROR_DS_MAX_OBJ_SIZE_EXCEEDED                          8304L
#define ERROR_DS_OBJ_STRING_NAME_EXISTS                         8305L
#define ERROR_DS_NO_RDN_DEFINED_IN_SCHEMA                       8306L
#define ERROR_DS_RDN_DOESNT_MATCH_SCHEMA                        8307L
#define ERROR_DS_NO_REQUESTED_ATTS_FOUND                        8308L
#define ERROR_DS_USER_BUFFER_TO_SMALL                           8309L
#define ERROR_DS_ATT_IS_NOT_ON_OBJ                              8310L
#define ERROR_DS_ILLEGAL_MOD_OPERATION                          8311L
#define ERROR_DS_OBJ_TOO_LARGE                                  8312L
#define ERROR_DS_BAD_INSTANCE_TYPE                              8313L
#define ERROR_DS_MASTERDSA_REQUIRED                             8314L
#define ERROR_DS_OBJECT_CLASS_REQUIRED                          8315L
#define ERROR_DS_MISSING_REQUIRED_ATT                           8316L
#define ERROR_DS_ATT_NOT_DEF_FOR_CLASS                          8317L
#define ERROR_DS_ATT_ALREADY_EXISTS                             8318L
#define ERROR_DS_CANT_ADD_ATT_VALUES                            8320L
#define ERROR_DS_SINGLE_VALUE_CONSTRAINT                        8321L
#define ERROR_DS_RANGE_CONSTRAINT                               8322L
#define ERROR_DS_ATT_VAL_ALREADY_EXISTS                         8323L
#define ERROR_DS_CANT_REM_MISSING_ATT                           8324L
#define ERROR_DS_CANT_REM_MISSING_ATT_VAL                       8325L
#define ERROR_DS_ROOT_CANT_BE_SUBREF                            8326L
#define ERROR_DS_NO_CHAINING                                    8327L
#define ERROR_DS_NO_CHAINED_EVAL                                8328L
#define ERROR_DS_NO_PARENT_OBJECT                               8329L
#define ERROR_DS_NO_PARENT_IS_AN_ALIAS                          8330L
#define ERROR_DS_CANT_MIX_MASTER_AND_REPS                       8331L
#define ERROR_DS_CHILDREN_EXIST                                 8332L
#define ERROR_DS_OBJ_NOT_FOUND                                  8333L
#define ERROR_DS_ALIASED_OBJ_MISSING                            8334L
#define ERROR_DS_BAD_NAME_SYNTAX                                8335L
#define ERROR_DS_ALIAS_POINTS_TO_ALIAS                          8336L
#define ERROR_DS_CANT_DEREF_ALIAS                               8337L
#define ERROR_DS_OUT_OF_SCOPE                                   8338L
#define ERROR_DS_OBJECT_BEING_REMOVED                           8339L
#define ERROR_DS_CANT_DELETE_DSA_OBJ                            8340L
#define ERROR_DS_GENERIC_ERROR                                  8341L
#define ERROR_DS_DSA_MUST_BE_INT_MASTER                         8342L
#define ERROR_DS_CLASS_NOT_DSA                                  8343L
#define ERROR_DS_INSUFF_ACCESS_RIGHTS                           8344L
#define ERROR_DS_ILLEGAL_SUPERIOR                               8345L
#define ERROR_DS_ATTRIBUTE_OWNED_BY_SAM                         8346L
#define ERROR_DS_NAME_TOO_MANY_PARTS                            8347L
#define ERROR_DS_NAME_TOO_LONG                                  8348L
#define ERROR_DS_NAME_VALUE_TOO_LONG                            8349L
#define ERROR_DS_NAME_UNPARSEABLE                               8350L
#define ERROR_DS_NAME_TYPE_UNKNOWN                              8351L
#define ERROR_DS_NOT_AN_OBJECT                                  8352L
#define ERROR_DS_SEC_DESC_TOO_SHORT                             8353L
#define ERROR_DS_SEC_DESC_INVALID                               8354L
#define ERROR_DS_NO_DELETED_NAME                                8355L
#define ERROR_DS_SUBREF_MUST_HAVE_PARENT                        8356L
#define ERROR_DS_NCNAME_MUST_BE_NC                              8357L
#define ERROR_DS_CANT_ADD_SYSTEM_ONLY                           8358L
#define ERROR_DS_CLASS_MUST_BE_CONCRETE                         8359L
#define ERROR_DS_INVALID_DMD                                    8360L
#define ERROR_DS_OBJ_GUID_EXISTS                                8361L
#define ERROR_DS_NOT_ON_BACKLINK                                8362L
#define ERROR_DS_NO_CROSSREF_FOR_NC                             8363L
#define ERROR_DS_SHUTTING_DOWN                                  8364L
#define ERROR_DS_UNKNOWN_OPERATION                              8365L
#define ERROR_DS_INVALID_ROLE_OWNER                             8366L
#define ERROR_DS_COULDNT_CONTACT_FSMO                           8367L
#define ERROR_DS_CROSS_NC_DN_RENAME                             8368L
#define ERROR_DS_CANT_MOD_SYSTEM_ONLY                           8369L
#define ERROR_DS_REPLICATOR_ONLY                                8370L
#define ERROR_DS_OBJ_CLASS_NOT_DEFINED                          8371L
#define ERROR_DS_OBJ_CLASS_NOT_SUBCLASS                         8372L
#define ERROR_DS_NAME_REFERENCE_INVALID                         8373L
#define ERROR_DS_CROSS_REF_EXISTS                               8374L
#define ERROR_DS_CANT_DEL_MASTER_CROSSREF                       8375L
#define ERROR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD                     8376L
#define ERROR_DS_NOTIFY_FILTER_TOO_COMPLEX                      8377L
#define ERROR_DS_DUP_RDN                                        8378L
#define ERROR_DS_DUP_OID                                        8379L
#define ERROR_DS_DUP_MAPI_ID                                    8380L
#define ERROR_DS_DUP_SCHEMA_ID_GUID                             8381L
#define ERROR_DS_DUP_LDAP_DISPLAY_NAME                          8382L
#define ERROR_DS_SEMANTIC_ATT_TEST                              8383L
#define ERROR_DS_SYNTAX_MISMATCH                                8384L
#define ERROR_DS_EXISTS_IN_MUST_HAVE                            8385L
#define ERROR_DS_EXISTS_IN_MAY_HAVE                             8386L
#define ERROR_DS_NONEXISTENT_MAY_HAVE                           8387L
#define ERROR_DS_NONEXISTENT_MUST_HAVE                          8388L
#define ERROR_DS_AUX_CLS_TEST_FAIL                              8389L
#define ERROR_DS_NONEXISTENT_POSS_SUP                           8390L
#define ERROR_DS_SUB_CLS_TEST_FAIL                              8391L
#define ERROR_DS_BAD_RDN_ATT_ID_SYNTAX                          8392L
#define ERROR_DS_EXISTS_IN_AUX_CLS                              8393L
#define ERROR_DS_EXISTS_IN_SUB_CLS                              8394L
#define ERROR_DS_EXISTS_IN_POSS_SUP                             8395L
#define ERROR_DS_RECALCSCHEMA_FAILED                            8396L
#define ERROR_DS_TREE_DELETE_NOT_FINISHED                       8397L
#define ERROR_DS_CANT_DELETE                                    8398L
#define ERROR_DS_ATT_SCHEMA_REQ_ID                              8399L
#define ERROR_DS_BAD_ATT_SCHEMA_SYNTAX                          8400L
#define ERROR_DS_CANT_CACHE_ATT                                 8401L
#define ERROR_DS_CANT_CACHE_CLASS                               8402L
#define ERROR_DS_CANT_REMOVE_ATT_CACHE                          8403L
#define ERROR_DS_CANT_REMOVE_CLASS_CACHE                        8404L
#define ERROR_DS_CANT_RETRIEVE_DN                               8405L
#define ERROR_DS_MISSING_SUPREF                                 8406L
#define ERROR_DS_CANT_RETRIEVE_INSTANCE                         8407L
#define ERROR_DS_CODE_INCONSISTENCY                             8408L
#define ERROR_DS_DATABASE_ERROR                                 8409L
#define ERROR_DS_GOVERNSID_MISSING                              8410L
#define ERROR_DS_MISSING_EXPECTED_ATT                           8411L
#define ERROR_DS_NCNAME_MISSING_CR_REF                          8412L
#define ERROR_DS_SECURITY_CHECKING_ERROR                        8413L
#define ERROR_DS_SCHEMA_NOT_LOADED                              8414L
#define ERROR_DS_SCHEMA_ALLOC_FAILED                            8415L
#define ERROR_DS_ATT_SCHEMA_REQ_SYNTAX                          8416L
#define ERROR_DS_GCVERIFY_ERROR                                 8417L
#define ERROR_DS_DRA_SCHEMA_MISMATCH                            8418L
#define ERROR_DS_CANT_FIND_DSA_OBJ                              8419L
#define ERROR_DS_CANT_FIND_EXPECTED_NC                          8420L
#define ERROR_DS_CANT_FIND_NC_IN_CACHE                          8421L
#define ERROR_DS_CANT_RETRIEVE_CHILD                            8422L
#define ERROR_DS_SECURITY_ILLEGAL_MODIFY                        8423L
#define ERROR_DS_CANT_REPLACE_HIDDEN_REC                        8424L
#define ERROR_DS_BAD_HIERARCHY_FILE                             8425L
#define ERROR_DS_BUILD_HIERARCHY_TABLE_FAILED                   8426L
#define ERROR_DS_CONFIG_PARAM_MISSING                           8427L
#define ERROR_DS_COUNTING_AB_INDICES_FAILED                     8428L
#define ERROR_DS_HIERARCHY_TABLE_MALLOC_FAILED                  8429L
#define ERROR_DS_INTERNAL_FAILURE                               8430L
#define ERROR_DS_UNKNOWN_ERROR                                  8431L
#define ERROR_DS_ROOT_REQUIRES_CLASS_TOP                        8432L
#define ERROR_DS_REFUSING_FSMO_ROLES                            8433L
#define ERROR_DS_MISSING_FSMO_SETTINGS                          8434L
#define ERROR_DS_UNABLE_TO_SURRENDER_ROLES                      8435L
#define ERROR_DS_DRA_GENERIC                                    8436L
#define ERROR_DS_DRA_INVALID_PARAMETER                          8437L
#define ERROR_DS_DRA_BUSY                                       8438L
#define ERROR_DS_DRA_BAD_DN                                     8439L
#define ERROR_DS_DRA_BAD_NC                                     8440L
#define ERROR_DS_DRA_DN_EXISTS                                  8441L
#define ERROR_DS_DRA_INTERNAL_ERROR                             8442L
#define ERROR_DS_DRA_INCONSISTENT_DIT                           8443L
#define ERROR_DS_DRA_CONNECTION_FAILED                          8444L
#define ERROR_DS_DRA_BAD_INSTANCE_TYPE                          8445L
#define ERROR_DS_DRA_OUT_OF_MEM                                 8446L
#define ERROR_DS_DRA_MAIL_PROBLEM                               8447L
#define ERROR_DS_DRA_REF_ALREADY_EXISTS                         8448L
#define ERROR_DS_DRA_REF_NOT_FOUND                              8449L
#define ERROR_DS_DRA_OBJ_IS_REP_SOURCE                          8450L
#define ERROR_DS_DRA_DB_ERROR                                   8451L
#define ERROR_DS_DRA_NO_REPLICA                                 8452L
#define ERROR_DS_DRA_ACCESS_DENIED                              8453L
#define ERROR_DS_DRA_NOT_SUPPORTED                              8454L
#define ERROR_DS_DRA_RPC_CANCELLED                              8455L
#define ERROR_DS_DRA_SOURCE_DISABLED                            8456L
#define ERROR_DS_DRA_SINK_DISABLED                              8457L
#define ERROR_DS_DRA_NAME_COLLISION                             8458L
#define ERROR_DS_DRA_SOURCE_REINSTALLED                         8459L
#define ERROR_DS_DRA_MISSING_PARENT                             8460L
#define ERROR_DS_DRA_PREEMPTED                                  8461L
#define ERROR_DS_DRA_ABANDON_SYNC                               8462L
#define ERROR_DS_DRA_SHUTDOWN                                   8463L
#define ERROR_DS_DRA_INCOMPATIBLE_PARTIAL_SET                   8464L
#define ERROR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA                  8465L
#define ERROR_DS_DRA_EXTN_CONNECTION_FAILED                     8466L
#define ERROR_DS_INSTALL_SCHEMA_MISMATCH                        8467L
#define ERROR_DS_DUP_LINK_ID                                    8468L
#define ERROR_DS_NAME_ERROR_RESOLVING                           8469L
#define ERROR_DS_NAME_ERROR_NOT_FOUND                           8470L
#define ERROR_DS_NAME_ERROR_NOT_UNIQUE                          8471L
#define ERROR_DS_NAME_ERROR_NO_MAPPING                          8472L
#define ERROR_DS_NAME_ERROR_DOMAIN_ONLY                         8473L
#define ERROR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING              8474L
#define ERROR_DS_CONSTRUCTED_ATT_MOD                            8475L
#define ERROR_DS_WRONG_OM_OBJ_CLASS                             8476L
#define ERROR_DS_DRA_REPL_PENDING                               8477L
#define ERROR_DS_DS_REQUIRED                                    8478L
#define ERROR_DS_INVALID_LDAP_DISPLAY_NAME                      8479L
#define ERROR_DS_NON_BASE_SEARCH                                8480L
#define ERROR_DS_CANT_RETRIEVE_ATTS                             8481L
#define ERROR_DS_BACKLINK_WITHOUT_LINK                          8482L
#define ERROR_DS_EPOCH_MISMATCH                                 8483L
#define ERROR_DS_SRC_NAME_MISMATCH                              8484L
#define ERROR_DS_SRC_AND_DST_NC_IDENTICAL                       8485L
#define ERROR_DS_DST_NC_MISMATCH                                8486L
#define ERROR_DS_NOT_AUTHORITIVE_FOR_DST_NC                     8487L
#define ERROR_DS_SRC_GUID_MISMATCH                              8488L
#define ERROR_DS_CANT_MOVE_DELETED_OBJECT                       8489L
#define ERROR_DS_PDC_OPERATION_IN_PROGRESS                      8490L
#define ERROR_DS_CROSS_DOMAIN_CLEANUP_REQD                      8491L
#define ERROR_DS_ILLEGAL_XDOM_MOVE_OPERATION                    8492L
#define ERROR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS                8493L
#define ERROR_DS_NC_MUST_HAVE_NC_PARENT                         8494L
#define ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE                      8495L
#define ERROR_DS_DST_DOMAIN_NOT_NATIVE                          8496L
#define ERROR_DS_MISSING_INFRASTRUCTURE_CONTAINER               8497L
#define ERROR_DS_CANT_MOVE_ACCOUNT_GROUP                        8498L
#define ERROR_DS_CANT_MOVE_RESOURCE_GROUP                       8499L
#define ERROR_DS_INVALID_SEARCH_FLAG                            8500L
#define ERROR_DS_NO_TREE_DELETE_ABOVE_NC                        8501L
#define ERROR_DS_COULDNT_LOCK_TREE_FOR_DELETE                   8502L
#define ERROR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE       8503L
#define ERROR_DS_SAM_INIT_FAILURE                               8504L
#define ERROR_DS_SENSITIVE_GROUP_VIOLATION                      8505L
#define ERROR_DS_CANT_MOD_PRIMARYGROUPID                        8506L
#define ERROR_DS_ILLEGAL_BASE_SCHEMA_MOD                        8507L
#define ERROR_DS_NONSAFE_SCHEMA_CHANGE                          8508L
#define ERROR_DS_SCHEMA_UPDATE_DISALLOWED                       8509L
#define ERROR_DS_CANT_CREATE_UNDER_SCHEMA                       8510L
#define ERROR_DS_INSTALL_NO_SRC_SCH_VERSION                     8511L
#define ERROR_DS_INSTALL_NO_SCH_VERSION_IN_INIFILE              8512L
#define ERROR_DS_INVALID_GROUP_TYPE                             8513L
#define ERROR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN             8514L
#define ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN              8515L
#define ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER                  8516L
#define ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER              8517L
#define ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER               8518L
#define ERROR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER            8519L
#define ERROR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER       8520L
#define ERROR_DS_HAVE_PRIMARY_MEMBERS                           8521L
#define ERROR_DS_STRING_SD_CONVERSION_FAILED                    8522L
#define ERROR_DS_NAMING_MASTER_GC                               8523L
#define ERROR_DS_DNS_LOOKUP_FAILURE                             8524L
#define ERROR_DS_COULDNT_UPDATE_SPNS                            8525L
#define ERROR_DS_CANT_RETRIEVE_SD                               8526L
#define ERROR_DS_KEY_NOT_UNIQUE                                 8527L
#define ERROR_DS_WRONG_LINKED_ATT_SYNTAX                        8528L
#define ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD                      8529L
#define ERROR_DS_SAM_NEED_BOOTKEY_FLOPPY                        8530L
#define ERROR_DS_CANT_START                                     8531L
#define ERROR_DS_INIT_FAILURE                                   8532L
#define ERROR_DS_NO_PKT_PRIVACY_ON_CONNECTION                   8533L
#define ERROR_DS_SOURCE_DOMAIN_IN_FOREST                        8534L
#define ERROR_DS_DESTINATION_DOMAIN_NOT_IN_FOREST               8535L
#define ERROR_DS_DESTINATION_AUDITING_NOT_ENABLED               8536L
#define ERROR_DS_CANT_FIND_DC_FOR_SRC_DOMAIN                    8537L
#define ERROR_DS_SRC_OBJ_NOT_GROUP_OR_USER                      8538L
#define ERROR_DS_SRC_SID_EXISTS_IN_FOREST                       8539L
#define ERROR_DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH              8540L
#define ERROR_SAM_INIT_FAILURE                                  8541L
#define ERROR_DS_DRA_SCHEMA_INFO_SHIP                           8542L
#define ERROR_DS_DRA_SCHEMA_CONFLICT                            8543L
#define ERROR_DS_DRA_EARLIER_SCHEMA_CONFLICT                    8544L
#define ERROR_DS_DRA_OBJ_NC_MISMATCH                            8545L
#define ERROR_DS_NC_STILL_HAS_DSAS                              8546L
#define ERROR_DS_GC_REQUIRED                                    8547L
#define ERROR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY                     8548L
#define ERROR_DS_NO_FPO_IN_UNIVERSAL_GROUPS                     8549L
#define ERROR_DS_CANT_ADD_TO_GC                                 8550L
#define ERROR_DS_NO_CHECKPOINT_WITH_PDC                         8551L
#define ERROR_DS_SOURCE_AUDITING_NOT_ENABLED                    8552L
#define ERROR_DS_CANT_CREATE_IN_NONDOMAIN_NC                    8553L
#define ERROR_DS_INVALID_NAME_FOR_SPN                           8554L
#define ERROR_DS_FILTER_USES_CONSTRUCTED_ATTRS                  8555L
#define ERROR_DS_UNICODEPWD_NOT_IN_QUOTES                       8556L
#define ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED                 8557L
#define ERROR_DS_MUST_BE_RUN_ON_DST_DC                          8558L
#define ERROR_DS_SRC_DC_MUST_BE_SP4_OR_GREATER                  8559L
#define ERROR_DS_CANT_TREE_DELETE_CRITICAL_OBJ                  8560L
#define ERROR_DS_INIT_FAILURE_CONSOLE                           8561L
#define ERROR_DS_SAM_INIT_FAILURE_CONSOLE                       8562L
#define ERROR_DS_FOREST_VERSION_TOO_HIGH                        8563L
#define ERROR_DS_DOMAIN_VERSION_TOO_HIGH                        8564L
#define ERROR_DS_FOREST_VERSION_TOO_LOW                         8565L
#define ERROR_DS_DOMAIN_VERSION_TOO_LOW                         8566L
#define ERROR_DS_INCOMPATIBLE_VERSION                           8567L
#define ERROR_DS_LOW_DSA_VERSION                                8568L
#define ERROR_DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN             8569L
#define ERROR_DS_NOT_SUPPORTED_SORT_ORDER                       8570L
#define ERROR_DS_NAME_NOT_UNIQUE                                8571L
#define ERROR_DS_MACHINE_ACCOUNT_CREATED_PRENT4                 8572L
#define ERROR_DS_OUT_OF_VERSION_STORE                           8573L
#define ERROR_DS_INCOMPATIBLE_CONTROLS_USED                     8574L
#define ERROR_DS_NO_REF_DOMAIN                                  8575L
#define ERROR_DS_RESERVED_LINK_ID                               8576L
#define ERROR_DS_LINK_ID_NOT_AVAILABLE                          8577L
#define ERROR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER                  8578L
#define ERROR_DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE           8579L
#define ERROR_DS_NO_OBJECT_MOVE_IN_SCHEMA_NC                    8580L
#define ERROR_DS_MODIFYDN_DISALLOWED_BY_FLAG                    8581L
#define ERROR_DS_MODIFYDN_WRONG_GRANDPARENT                     8582L
#define ERROR_DS_NAME_ERROR_TRUST_REFERRAL                      8583L
#define ERROR_NOT_SUPPORTED_ON_STANDARD_SERVER                  8584L
#define ERROR_DS_CANT_ACCESS_REMOTE_PART_OF_AD                  8585L
#define ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE_V2                   8586L
#define ERROR_DS_THREAD_LIMIT_EXCEEDED                          8587L
#define ERROR_DS_NOT_CLOSEST                                    8588L
#define ERROR_DS_CANT_DERIVE_SPN_WITHOUT_SERVER_REF             8589L
#define ERROR_DS_SINGLE_USER_MODE_FAILED                        8590L
#define ERROR_DS_NTDSCRIPT_SYNTAX_ERROR                         8591L
#define ERROR_DS_NTDSCRIPT_PROCESS_ERROR                        8592L
#define ERROR_DS_DIFFERENT_REPL_EPOCHS                          8593L
#define ERROR_DS_DRS_EXTENSIONS_CHANGED                         8594L
#define ERROR_DS_REPLICA_SET_CHANGE_NOT_ALLOWED_ON_DISABLED_CR  8595L
#define ERROR_DS_NO_MSDS_INTID                                  8596L
#define ERROR_DS_DUP_MSDS_INTID                                 8597L
#define ERROR_DS_EXISTS_IN_RDNATTID                             8598L
#define ERROR_DS_AUTHORIZATION_FAILED                           8599L
#define ERROR_DS_INVALID_SCRIPT                                 8600L
#define ERROR_DS_REMOTE_CROSSREF_OP_FAILED                      8601L
#define ERROR_DS_CROSS_REF_BUSY                                 8602L
#define ERROR_DS_CANT_DERIVE_SPN_FOR_DELETED_DOMAIN             8603L
#define ERROR_DS_CANT_DEMOTE_WITH_WRITEABLE_NC                  8604L
#define ERROR_DS_DUPLICATE_ID_FOUND                             8605L
#define ERROR_DS_INSUFFICIENT_ATTR_TO_CREATE_OBJECT             8606L
#define ERROR_DS_GROUP_CONVERSION_ERROR                         8607L
#define ERROR_DS_CANT_MOVE_APP_BASIC_GROUP                      8608L
#define ERROR_DS_CANT_MOVE_APP_QUERY_GROUP                      8609L
#define ERROR_DS_ROLE_NOT_VERIFIED                              8610L
#define ERROR_DS_WKO_CONTAINER_CANNOT_BE_SPECIAL                8611L
#define ERROR_DS_DOMAIN_RENAME_IN_PROGRESS                      8612L
#define ERROR_DS_EXISTING_AD_CHILD_NC                           8613L
#define ERROR_DS_REPL_LIFETIME_EXCEEDED                         8614L
#define ERROR_DS_DISALLOWED_IN_SYSTEM_CONTAINER                 8615L
#define ERROR_DS_LDAP_SEND_QUEUE_FULL                           8616L
#define ERROR_DS_DRA_OUT_SCHEDULE_WINDOW                        8617L
#define ERROR_DS_POLICY_NOT_KNOWN                               8618L
#define ERROR_NO_SITE_SETTINGS_OBJECT                           8619L
#define ERROR_NO_SECRETS                                        8620L
#define ERROR_NO_WRITABLE_DC_FOUND                              8621L
#define ERROR_DS_NO_SERVER_OBJECT                               8622L
#define ERROR_DS_NO_NTDSA_OBJECT                                8623L
#define ERROR_DS_NON_ASQ_SEARCH                                 8624L
#define ERROR_DS_AUDIT_FAILURE                                  8625L
#define ERROR_DS_INVALID_SEARCH_FLAG_SUBTREE                    8626L
#define ERROR_DS_INVALID_SEARCH_FLAG_TUPLE                      8627L
#define ERROR_DS_HIERARCHY_TABLE_TOO_DEEP                       8628L
#define ERROR_DS_DRA_CORRUPT_UTD_VECTOR                         8629L
#define ERROR_DS_DRA_SECRETS_DENIED                             8630L
#define ERROR_DS_RESERVED_MAPI_ID                               8631L
#define ERROR_DS_MAPI_ID_NOT_AVAILABLE                          8632L
#define ERROR_DS_DRA_MISSING_KRBTGT_SECRET                      8633L
#define ERROR_DS_DOMAIN_NAME_EXISTS_IN_FOREST                   8634L
#define ERROR_DS_FLAT_NAME_EXISTS_IN_FOREST                     8635L
#define ERROR_INVALID_USER_PRINCIPAL_NAME                       8636L
#define ERROR_DS_OID_MAPPED_GROUP_CANT_HAVE_MEMBERS             8637L
#define ERROR_DS_OID_NOT_FOUND                                  8638L
#define ERROR_DS_DRA_RECYCLED_TARGET                            8639L

/* DNS error codes */
#define DNS_ERROR_RESPONSE_CODES_BASE           9000L
#define DNS_ERROR_RCODE_NO_ERROR                NO_ERROR
#define DNS_ERROR_MASK                          9000L
#define DNS_ERROR_RCODE_FORMAT_ERROR            9001L
#define DNS_ERROR_RCODE_SERVER_FAILURE          9002L
#define DNS_ERROR_RCODE_NAME_ERROR              9003L
#define DNS_ERROR_RCODE_NOT_IMPLEMENTED         9004L
#define DNS_ERROR_RCODE_REFUSED                 9005L
#define DNS_ERROR_RCODE_YXDOMAIN                9006L
#define DNS_ERROR_RCODE_YXRRSET                 9007L
#define DNS_ERROR_RCODE_NXRRSET                 9008L
#define DNS_ERROR_RCODE_NOTAUTH                 9009L
#define DNS_ERROR_RCODE_NOTZONE                 9010L
#define DNS_ERROR_RCODE_BADSIG                  9016L
#define DNS_ERROR_RCODE_BADKEY                  9017L
#define DNS_ERROR_RCODE_BADTIME                 9018L
#define DNS_ERROR_RCODE_LAST                    DNS_ERROR_RCODE_BADTIME
#define DNS_ERROR_PACKET_FMT_BASE               9500L
#define DNS_INFO_NO_RECORDS                     9501L
#define DNS_ERROR_BAD_PACKET                    9502L
#define DNS_ERROR_NO_PACKET                     9503L
#define DNS_ERROR_RCODE                         9504L
#define DNS_ERROR_UNSECURE_PACKET               9505L
#define DNS_STATUS_PACKET_UNSECURE              DNS_ERROR_UNSECURE_PACKET
#define DNS_ERROR_NO_MEMORY                     ERROR_OUTOFMEMORY
#define DNS_ERROR_INVALID_NAME                  ERROR_INVALID_NAME
#define DNS_ERROR_INVALID_DATA                  ERROR_INVALID_DATA
#define DNS_ERROR_GENERAL_API_BASE              9550L
#define DNS_ERROR_INVALID_TYPE                  9551L
#define DNS_ERROR_INVALID_IP_ADDRESS            9552L
#define DNS_ERROR_INVALID_PROPERTY              9553L
#define DNS_ERROR_TRY_AGAIN_LATER               9554L
#define DNS_ERROR_NOT_UNIQUE                    9555L
#define DNS_ERROR_NON_RFC_NAME                  9556L
#define DNS_STATUS_FQDN                         9557L
#define DNS_STATUS_DOTTED_NAME                  9558L
#define DNS_STATUS_SINGLE_PART_NAME             9559L
#define DNS_ERROR_INVALID_NAME_CHAR             9560L
#define DNS_ERROR_NUMERIC_NAME                  9561L
#define DNS_ERROR_NOT_ALLOWED_ON_ROOT_SERVER    9562L
#define DNS_ERROR_NOT_ALLOWED_UNDER_DELEGATION  9563L
#define DNS_ERROR_CANNOT_FIND_ROOT_HINTS        9564L
#define DNS_ERROR_INCONSISTENT_ROOT_HINTS       9565L
#define DNS_ERROR_DWORD_VALUE_TOO_SMALL         9566L
#define DNS_ERROR_DWORD_VALUE_TOO_LARGE         9567L
#define DNS_ERROR_BACKGROUND_LOADING            9568L
#define DNS_ERROR_NOT_ALLOWED_ON_RODC           9569L
#define DNS_ERROR_NOT_ALLOWED_UNDER_DNAME       9570L
#define DNS_ERROR_DELEGATION_REQUIRED           9571L
#define DNS_ERROR_INVALID_POLICY_TABLE          9572L
#define DNS_ERROR_ZONE_BASE                     9600L
#define DNS_ERROR_ZONE_DOES_NOT_EXIST           9601L
#define DNS_ERROR_NO_ZONE_INFO                  9602L
#define DNS_ERROR_INVALID_ZONE_OPERATION        9603L
#define DNS_ERROR_ZONE_CONFIGURATION_ERROR      9604L
#define DNS_ERROR_ZONE_HAS_NO_SOA_RECORD        9605L
#define DNS_ERROR_ZONE_HAS_NO_NS_RECORDS        9606L
#define DNS_ERROR_ZONE_LOCKED                   9607L
#define DNS_ERROR_ZONE_CREATION_FAILED          9608L
#define DNS_ERROR_ZONE_ALREADY_EXISTS           9609L
#define DNS_ERROR_AUTOZONE_ALREADY_EXISTS       9610L
#define DNS_ERROR_INVALID_ZONE_TYPE             9611L
#define DNS_ERROR_SECONDARY_REQUIRES_MASTER_IP  9612L
#define DNS_ERROR_ZONE_NOT_SECONDARY            9613L
#define DNS_ERROR_NEED_SECONDARY_ADDRESSES      9614L
#define DNS_ERROR_WINS_INIT_FAILED              9615L
#define DNS_ERROR_NEED_WINS_SERVERS             9616L
#define DNS_ERROR_NBSTAT_INIT_FAILED            9617L
#define DNS_ERROR_SOA_DELETE_INVALID            9618L
#define DNS_ERROR_FORWARDER_ALREADY_EXISTS      9619L
#define DNS_ERROR_ZONE_REQUIRES_MASTER_IP       9620L
#define DNS_ERROR_ZONE_IS_SHUTDOWN              9621L
#define DNS_ERROR_DATAFILE_BASE                 9650L
#define DNS_ERROR_PRIMARY_REQUIRES_DATAFILE     9651L
#define DNS_ERROR_INVALID_DATAFILE_NAME         9652L
#define DNS_ERROR_DATAFILE_OPEN_FAILURE         9653L
#define DNS_ERROR_FILE_WRITEBACK_FAILED         9654L
#define DNS_ERROR_DATAFILE_PARSING              9655L
#define DNS_ERROR_DATABASE_BASE                 9700L
#define DNS_ERROR_RECORD_DOES_NOT_EXIST         9701L
#define DNS_ERROR_RECORD_FORMAT                 9702L
#define DNS_ERROR_NODE_CREATION_FAILED          9703L
#define DNS_ERROR_UNKNOWN_RECORD_TYPE           9704L
#define DNS_ERROR_RECORD_TIMED_OUT              9705L
#define DNS_ERROR_NAME_NOT_IN_ZONE              9706L
#define DNS_ERROR_CNAME_LOOP                    9707L
#define DNS_ERROR_NODE_IS_CNAME                 9708L
#define DNS_ERROR_CNAME_COLLISION               9709L
#define DNS_ERROR_RECORD_ONLY_AT_ZONE_ROOT      9710L
#define DNS_ERROR_RECORD_ALREADY_EXISTS         9711L
#define DNS_ERROR_SECONDARY_DATA                9712L
#define DNS_ERROR_NO_CREATE_CACHE_DATA          9713L
#define DNS_ERROR_NAME_DOES_NOT_EXIST           9714L
#define DNS_WARNING_PTR_CREATE_FAILED           9715L
#define DNS_WARNING_DOMAIN_UNDELETED            9716L
#define DNS_ERROR_DS_UNAVAILABLE                9717L
#define DNS_ERROR_DS_ZONE_ALREADY_EXISTS        9718L
#define DNS_ERROR_NO_BOOTFILE_IF_DS_ZONE        9719L
#define DNS_ERROR_NODE_IS_DNAME                 9720L
#define DNS_ERROR_DNAME_COLLISION               9721L
#define DNS_ERROR_ALIAS_LOOP                    9722L
#define DNS_ERROR_OPERATION_BASE                9750L
#define DNS_INFO_AXFR_COMPLETE                  9751L
#define DNS_ERROR_AXFR                          9752L
#define DNS_INFO_ADDED_LOCAL_WINS               9753L
#define DNS_ERROR_SECURE_BASE                   9800L
#define DNS_STATUS_CONTINUE_NEEDED              9801L
#define DNS_ERROR_SETUP_BASE                    9850L
#define DNS_ERROR_NO_TCPIP                      9851L
#define DNS_ERROR_NO_DNS_SERVERS                9852L
#define DNS_ERROR_DP_BASE                       9900L
#define DNS_ERROR_DP_DOES_NOT_EXIST             9901L
#define DNS_ERROR_DP_ALREADY_EXISTS             9902L
#define DNS_ERROR_DP_NOT_ENLISTED               9903L
#define DNS_ERROR_DP_ALREADY_ENLISTED           9904L
#define DNS_ERROR_DP_NOT_AVAILABLE              9905L
#define DNS_ERROR_DP_FSMO_ERROR                 9906L

/* WinSock error codes */
#define WSABASEERR                  10000L
#define WSAEINTR                    10004L
#define WSAEBADF                    10009L
#define WSAEACCES                   10013L
#define WSAEFAULT                   10014L
#define WSAEINVAL                   10022L
#define WSAEMFILE                   10024L
#define WSAEWOULDBLOCK              10035L
#define WSAEINPROGRESS              10036L
#define WSAEALREADY                 10037L
#define WSAENOTSOCK                 10038L
#define WSAEDESTADDRREQ             10039L
#define WSAEMSGSIZE                 10040L
#define WSAEPROTOTYPE               10041L
#define WSAENOPROTOOPT              10042L
#define WSAEPROTONOSUPPORT          10043L
#define WSAESOCKTNOSUPPORT          10044L
#define WSAEOPNOTSUPP               10045L
#define WSAEPFNOSUPPORT             10046L
#define WSAEAFNOSUPPORT             10047L
#define WSAEADDRINUSE               10048L
#define WSAEADDRNOTAVAIL            10049L
#define WSAENETDOWN                 10050L
#define WSAENETUNREACH              10051L
#define WSAENETRESET                10052L
#define WSAECONNABORTED             10053L
#define WSAECONNRESET               10054L
#define WSAENOBUFS                  10055L
#define WSAEISCONN                  10056L
#define WSAENOTCONN                 10057L
#define WSAESHUTDOWN                10058L
#define WSAETOOMANYREFS             10059L
#define WSAETIMEDOUT                10060L
#define WSAECONNREFUSED             10061L
#define WSAELOOP                    10062L
#define WSAENAMETOOLONG             10063L
#define WSAEHOSTDOWN                10064L
#define WSAEHOSTUNREACH             10065L
#define WSAENOTEMPTY                10066L
#define WSAEPROCLIM                 10067L
#define WSAEUSERS                   10068L
#define WSAEDQUOT                   10069L
#define WSAESTALE                   10070L
#define WSAEREMOTE                  10071L
#define WSASYSNOTREADY              10091L
#define WSAVERNOTSUPPORTED          10092L
#define WSANOTINITIALISED           10093L
#define WSAEDISCON                  10101L
#define WSAENOMORE                  10102L
#define WSAECANCELLED               10103L
#define WSAEINVALIDPROCTABLE        10104L
#define WSAEINVALIDPROVIDER         10105L
#define WSAEPROVIDERFAILEDINIT      10106L
#define WSASYSCALLFAILURE           10107L
#define WSASERVICE_NOT_FOUND        10108L
#define WSATYPE_NOT_FOUND           10109L
#define WSA_E_NO_MORE               10110L
#define WSA_E_CANCELLED             10111L
#define WSAEREFUSED                 10112L
#define WSAHOST_NOT_FOUND           11001L
#define WSATRY_AGAIN                11002L
#define WSANO_RECOVERY              11003L
#define WSANO_DATA                  11004L
#define WSA_QOS_RECEIVERS           11005L
#define WSA_QOS_SENDERS             11006L
#define WSA_QOS_NO_SENDERS          11007L
#define WSA_QOS_NO_RECEIVERS        11008L
#define WSA_QOS_REQUEST_CONFIRMED   11009L
#define WSA_QOS_ADMISSION_FAILURE   11010L
#define WSA_QOS_POLICY_FAILURE      11011L
#define WSA_QOS_BAD_STYLE           11012L
#define WSA_QOS_BAD_OBJECT          11013L
#define WSA_QOS_TRAFFIC_CTRL_ERROR  11014L
#define WSA_QOS_GENERIC_ERROR       11015L
#define WSA_QOS_ESERVICETYPE        11016L
#define WSA_QOS_EFLOWSPEC           11017L
#define WSA_QOS_EPROVSPECBUF        11018L
#define WSA_QOS_EFILTERSTYLE        11019L
#define WSA_QOS_EFILTERTYPE         11020L
#define WSA_QOS_EFILTERCOUNT        11021L
#define WSA_QOS_EOBJLENGTH          11022L
#define WSA_QOS_EFLOWCOUNT          11023L
#define WSA_QOS_EUNKNOWNPSOBJ       11024L
#define WSA_QOS_EPOLICYOBJ          11025L
#define WSA_QOS_EFLOWDESC           11026L
#define WSA_QOS_EPSFLOWSPEC         11027L
#define WSA_QOS_EPSFILTERSPEC       11028L
#define WSA_QOS_ESDMODEOBJ          11029L
#define WSA_QOS_ESHAPERATEOBJ       11030L
#define WSA_QOS_RESERVED_PETYPE     11031L
#define WSA_SECURE_HOST_NOT_FOUND   11032L
#define WSA_IPSEC_NAME_POLICY_ERROR 11033L

/* IPSec error codes */
#define ERROR_IPSEC_QM_POLICY_EXISTS                        13000L
#define ERROR_IPSEC_QM_POLICY_NOT_FOUND                     13001L
#define ERROR_IPSEC_QM_POLICY_IN_USE                        13002L
#define ERROR_IPSEC_MM_POLICY_EXISTS                        13003L
#define ERROR_IPSEC_MM_POLICY_NOT_FOUND                     13004L
#define ERROR_IPSEC_MM_POLICY_IN_USE                        13005L
#define ERROR_IPSEC_MM_FILTER_EXISTS                        13006L
#define ERROR_IPSEC_MM_FILTER_NOT_FOUND                     13007L
#define ERROR_IPSEC_TRANSPORT_FILTER_EXISTS                 13008L
#define ERROR_IPSEC_TRANSPORT_FILTER_NOT_FOUND              13009L
#define ERROR_IPSEC_MM_AUTH_EXISTS                          13010L
#define ERROR_IPSEC_MM_AUTH_NOT_FOUND                       13011L
#define ERROR_IPSEC_MM_AUTH_IN_USE                          13012L
#define ERROR_IPSEC_DEFAULT_MM_POLICY_NOT_FOUND             13013L
#define ERROR_IPSEC_DEFAULT_MM_AUTH_NOT_FOUND               13014L
#define ERROR_IPSEC_DEFAULT_QM_POLICY_NOT_FOUND             13015L
#define ERROR_IPSEC_TUNNEL_FILTER_EXISTS                    13016L
#define ERROR_IPSEC_TUNNEL_FILTER_NOT_FOUND                 13017L
#define ERROR_IPSEC_MM_FILTER_PENDING_DELETION              13018L
#define ERROR_IPSEC_TRANSPORT_FILTER_PENDING_DELETION       13019L
#define ERROR_IPSEC_TUNNEL_FILTER_PENDING_DELETION          13020L
#define ERROR_IPSEC_MM_POLICY_PENDING_DELETION              13021L
#define ERROR_IPSEC_MM_AUTH_PENDING_DELETION                13022L
#define ERROR_IPSEC_QM_POLICY_PENDING_DELETION              13023L
#define WARNING_IPSEC_MM_POLICY_PRUNED                      13024L
#define WARNING_IPSEC_QM_POLICY_PRUNED                      13025L
#define ERROR_IPSEC_IKE_NEG_STATUS_BEGIN                    13800L
#define ERROR_IPSEC_IKE_AUTH_FAIL                           13801L
#define ERROR_IPSEC_IKE_ATTRIB_FAIL                         13802L
#define ERROR_IPSEC_IKE_NEGOTIATION_PENDING                 13803L
#define ERROR_IPSEC_IKE_GENERAL_PROCESSING_ERROR            13804L
#define ERROR_IPSEC_IKE_TIMED_OUT                           13805L
#define ERROR_IPSEC_IKE_NO_CERT                             13806L
#define ERROR_IPSEC_IKE_SA_DELETED                          13807L
#define ERROR_IPSEC_IKE_SA_REAPED                           13808L
#define ERROR_IPSEC_IKE_MM_ACQUIRE_DROP                     13809L
#define ERROR_IPSEC_IKE_QM_ACQUIRE_DROP                     13810L
#define ERROR_IPSEC_IKE_QUEUE_DROP_MM                       13811L
#define ERROR_IPSEC_IKE_QUEUE_DROP_NO_MM                    13812L
#define ERROR_IPSEC_IKE_DROP_NO_RESPONSE                    13813L
#define ERROR_IPSEC_IKE_MM_DELAY_DROP                       13814L
#define ERROR_IPSEC_IKE_QM_DELAY_DROP                       13815L
#define ERROR_IPSEC_IKE_ERROR                               13816L
#define ERROR_IPSEC_IKE_CRL_FAILED                          13817L
#define ERROR_IPSEC_IKE_INVALID_KEY_USAGE                   13818L
#define ERROR_IPSEC_IKE_INVALID_CERT_TYPE                   13819L
#define ERROR_IPSEC_IKE_NO_PRIVATE_KEY                      13820L
#define ERROR_IPSEC_IKE_SIMULTANEOUS_REKEY                  13821L
#define ERROR_IPSEC_IKE_DH_FAIL                             13822L
#define ERROR_IPSEC_IKE_CRITICAL_PAYLOAD_NOT_RECOGNIZED     13823L
#define ERROR_IPSEC_IKE_INVALID_HEADER                      13824L
#define ERROR_IPSEC_IKE_NO_POLICY                           13825L
#define ERROR_IPSEC_IKE_INVALID_SIGNATURE                   13826L
#define ERROR_IPSEC_IKE_KERBEROS_ERROR                      13827L
#define ERROR_IPSEC_IKE_NO_PUBLIC_KEY                       13828L
#define ERROR_IPSEC_IKE_PROCESS_ERR                         13829L
#define ERROR_IPSEC_IKE_PROCESS_ERR_SA                      13830L
#define ERROR_IPSEC_IKE_PROCESS_ERR_PROP                    13831L
#define ERROR_IPSEC_IKE_PROCESS_ERR_TRANS                   13832L
#define ERROR_IPSEC_IKE_PROCESS_ERR_KE                      13833L
#define ERROR_IPSEC_IKE_PROCESS_ERR_ID                      13834L
#define ERROR_IPSEC_IKE_PROCESS_ERR_CERT                    13835L
#define ERROR_IPSEC_IKE_PROCESS_ERR_CERT_REQ                13836L
#define ERROR_IPSEC_IKE_PROCESS_ERR_HASH                    13837L
#define ERROR_IPSEC_IKE_PROCESS_ERR_SIG                     13838L
#define ERROR_IPSEC_IKE_PROCESS_ERR_NONCE                   13839L
#define ERROR_IPSEC_IKE_PROCESS_ERR_NOTIFY                  13840L
#define ERROR_IPSEC_IKE_PROCESS_ERR_DELETE                  13841L
#define ERROR_IPSEC_IKE_PROCESS_ERR_VENDOR                  13842L
#define ERROR_IPSEC_IKE_INVALID_PAYLOAD                     13843L
#define ERROR_IPSEC_IKE_LOAD_SOFT_SA                        13844L
#define ERROR_IPSEC_IKE_SOFT_SA_TORN_DOWN                   13845L
#define ERROR_IPSEC_IKE_INVALID_COOKIE                      13846L
#define ERROR_IPSEC_IKE_NO_PEER_CERT                        13847L
#define ERROR_IPSEC_IKE_PEER_CRL_FAILED                     13848L
#define ERROR_IPSEC_IKE_POLICY_CHANGE                       13849L
#define ERROR_IPSEC_IKE_NO_MM_POLICY                        13850L
#define ERROR_IPSEC_IKE_NOTCBPRIV                           18351L
#define ERROR_IPSEC_IKE_SECLOADFAIL                         13852L
#define ERROR_IPSEC_IKE_FAILSSPINIT                         13853L
#define ERROR_IPSEC_IKE_FAILQUERYSSP                        13854L
#define ERROR_IPSEC_IKE_SRVACQFAIL                          13855L
#define ERROR_IPSEC_IKE_SRVQUERYCRED                        13856L
#define ERROR_IPSEC_IKE_GETSPIFAIL                          13857L
#define ERROR_IPSEC_IKE_INVALID_FILTER                      13858L
#define ERROR_IPSEC_IKE_OUT_OF_MEMORY                       13859L
#define ERROR_IPSEC_IKE_ADD_UPDATE_KEY_FAILED               13860L
#define ERROR_IPSEC_IKE_INVALID_POLICY                      13861L
#define ERROR_IPSEC_IKE_UKNOWN_DOI                          13862L
#define ERROR_IPSEC_IKE_INVALID_SITUATION                   13863L
#define ERROR_IPSEC_IKE_DH_FAILURE                          13864L
#define ERROR_IPSEC_IKE_INVALID_GROUP                       13865L
#define ERROR_IPSEC_IKE_ENCRYPT                             13866L
#define ERROR_IPSEC_IKE_DECRYPT                             13867L
#define ERROR_IPSEC_IKE_POLICY_MATCH                        13868L
#define ERROR_IPSEC_IKE_UNSUPPORTED_ID                      13869L
#define ERROR_IPSEC_IKE_INVALID_HASH                        13870L
#define ERROR_IPSEC_IKE_INVALID_HASH_ALG                    13871L
#define ERROR_IPSEC_IKE_INVALID_HASH_SIZE                   13872L
#define ERROR_IPSEC_IKE_INVALID_ENCRYPT_ALG                 13873L
#define ERROR_IPSEC_IKE_INVALID_AUTH_ALG                    13874L
#define ERROR_IPSEC_IKE_INVALID_SIG                         13875L
#define ERROR_IPSEC_IKE_LOAD_FAILED                         13876L
#define ERROR_IPSEC_IKE_RPC_DELETE                          13877L
#define ERROR_IPSEC_IKE_BENIGN_REINIT                       13878L
#define ERROR_IPSEC_IKE_INVALID_RESPONDER_LIFETIME_NOTIFY   13879L
#define ERROR_IPSEC_IKE_INVALID_MAJOR_VERSION               13880L
#define ERROR_IPSEC_IKE_INVALID_CERT_KEYLEN                 13881L
#define ERROR_IPSEC_IKE_MM_LIMIT                            13882L
#define ERROR_IPSEC_IKE_NEGOTIATION_DISABLED                13883L
#define ERROR_IPSEC_IKE_QM_LIMIT                            13884L
#define ERROR_IPSEC_IKE_MM_EXPIRED                          13885L
#define ERROR_IPSEC_IKE_PEER_MM_ASSUMED_INVALID             13886L
#define ERROR_IPSEC_IKE_CERT_CHAIN_POLICY_MISMATCH          13887L
#define ERROR_IPSEC_IKE_UNEXPECTED_MESSAGE_ID               13888L
#define ERROR_IPSEC_IKE_INVALID_AUTH_PAYLOAD                13889L
#define ERROR_IPSEC_IKE_DOS_COOKIE_SENT                     13890L
#define ERROR_IPSEC_IKE_SHUTTING_DOWN                       13891L
#define ERROR_IPSEC_IKE_CGA_AUTH_FAILED                     13892L
#define ERROR_IPSEC_IKE_PROCESS_ERR_NATOA                   13893L
#define ERROR_IPSEC_IKE_INVALID_MM_FOR_QM                   13894L
#define ERROR_IPSEC_IKE_QM_EXPIRED                          13895L
#define ERROR_IPSEC_IKE_TOO_MANY_FILTERS                    13896L
#define ERROR_IPSEC_IKE_NEG_STATUS_END                      13897L
#define ERROR_IPSEC_IKE_KILL_DUMMY_NAP_TUNNEL               13898L
#define ERROR_IPSEC_IKE_INNER_IP_ASSIGNMENT_FAILURE         13899L
#define ERROR_IPSEC_IKE_REQUIRE_CP_PAYLOAD_MISSING          13900L
#define ERROR_IPSEC_IKE_KEY_MODULE_IMPERSONATION_NEGOTIATION_PENDING    13901L
#define ERROR_IPSEC_IKE_COEXISTENCE_SUPPRESS                13902L
#define ERROR_IPSEC_IKE_RATELIMIT_DROP                      13903L
#define ERROR_IPSEC_IKE_PEER_DOESNT_SUPPORT_MOBIKE          13904L
#define ERROR_IPSEC_IKE_AUTHORIZATION_FAILURE               13905L
#define ERROR_IPSEC_IKE_STRONG_CRED_AUTHORIZATION_FAILURE   13906L
#define ERROR_IPSEC_IKE_AUTHORIZATION_FAILURE_WITH_OPTIONAL_RETRY   13907L
#define ERROR_IPSEC_IKE_STRONG_CRED_AUTHORIZATION_AND_CERTMAP_FAILURE   13908L
#define ERROR_IPSEC_IKE_NEG_STATUS_EXTENDED_END             13909L
#define ERROR_IPSEC_BAD_SPI                                 13910L
#define ERROR_IPSEC_SA_LIFETIME_EXPIRED                     13911L
#define ERROR_IPSEC_WRONG_SA                                13912L
#define ERROR_IPSEC_REPLAY_CHECK_FAILED                     13913L
#define ERROR_IPSEC_INVALID_PACKET                          13914L
#define ERROR_IPSEC_INTEGRITY_CHECK_FAILED                  13915L
#define ERROR_IPSEC_CLEAR_TEXT_DROP                         13916L
#define ERROR_IPSEC_AUTH_FIREWALL_DROP                      13917L
#define ERROR_IPSEC_THROTTLE_DROP                           13918L
#define ERROR_IPSEC_DOSP_BLOCK                              13925L
#define ERROR_IPSEC_DOSP_RECEIVED_MULTICAST                 13926L
#define ERROR_IPSEC_DOSP_INVALID_PACKET                     13927L
#define ERROR_IPSEC_DOSP_STATE_LOOKUP_FAILED                13928L
#define ERROR_IPSEC_DOSP_MAX_ENTRIES                        13929L
#define ERROR_IPSEC_DOSP_KEYMOD_NOT_ALLOWED                 13930L
#define ERROR_IPSEC_DOSP_DOSP_NOT_INSTALLED                 13931L
#define ERROR_IPSEC_DOSP_MAX_PER_IP_RATELIMIT_QUEUES        13932L

/* Side-by-side error codes */
#define ERROR_SXS_SECTION_NOT_FOUND                                 14000L
#define ERROR_SXS_CANT_GEN_ACTCTX                                   14001L
#define ERROR_SXS_INVALID_ACTCTXDATA_FORMAT                         14002L
#define ERROR_SXS_ASSEMBLY_NOT_FOUND                                14003L
#define ERROR_SXS_MANIFEST_FORMAT_ERROR                             14004L
#define ERROR_SXS_MANIFEST_PARSE_ERROR                              14005L
#define ERROR_SXS_ACTIVATION_CONTEXT_DISABLED                       14006L
#define ERROR_SXS_KEY_NOT_FOUND                                     14007L
#define ERROR_SXS_VERSION_CONFLICT                                  14008L
#define ERROR_SXS_WRONG_SECTION_TYPE                                14009L
#define ERROR_SXS_THREAD_QUERIES_DISABLED                           14010L
#define ERROR_SXS_PROCESS_DEFAULT_ALREADY_SET                       14011L
#define ERROR_SXS_UNKNOWN_ENCODING_GROUP                            14012L
#define ERROR_SXS_UNKNOWN_ENCODING                                  14013L
#define ERROR_SXS_INVALID_XML_NAMESPACE_URI                         14014L
#define ERROR_SXS_ROOT_MANIFEST_DEPENDENCY_NOT_INSTALLED            14015L
#define ERROR_SXS_LEAF_MANIFEST_DEPENDENCY_NOT_INSTALLED            14016L
#define ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE               14017L
#define ERROR_SXS_MANIFEST_MISSING_REQUIRED_DEFAULT_NAMESPACE       14018L
#define ERROR_SXS_MANIFEST_INVALID_REQUIRED_DEFAULT_NAMESPACE       14019L
#define ERROR_SXS_PRIVATE_MANIFEST_CROSS_PATH_WITH_REPARSE_POINT    14020L
#define ERROR_SXS_DUPLICATE_DLL_NAME                                14021L
#define ERROR_SXS_DUPLICATE_WINDOWCLASS_NAME                        14022L
#define ERROR_SXS_DUPLICATE_CLSID                                   14023L
#define ERROR_SXS_DUPLICATE_IID                                     14024L
#define ERROR_SXS_DUPLICATE_TLBID                                   14025L
#define ERROR_SXS_DUPLICATE_PROGID                                  14026L
#define ERROR_SXS_DUPLICATE_ASSEMBLY_NAME                           14027L
#define ERROR_SXS_FILE_HASH_MISMATCH                                14028L
#define ERROR_SXS_POLICY_PARSE_ERROR                                14029L
#define ERROR_SXS_XML_E_MISSINGQUOTE                                14030L
#define ERROR_SXS_XML_E_COMMENTSYNTAX                               14031L
#define ERROR_SXS_XML_E_BADSTARTNAMECHAR                            14032L
#define ERROR_SXS_XML_E_BADNAMECHAR                                 14033L
#define ERROR_SXS_XML_E_BADCHARINSTRING                             14034L
#define ERROR_SXS_XML_E_XMLDECLSYNTAX                               14035L
#define ERROR_SXS_XML_E_BADCHARDATA                                 14036L
#define ERROR_SXS_XML_E_MISSINGWHITESPACE                           14037L
#define ERROR_SXS_XML_E_EXPECTINGTAGEND                             14038L
#define ERROR_SXS_XML_E_MISSINGSEMICOLON                            14039L
#define ERROR_SXS_XML_E_UNBALANCEDPAREN                             14040L
#define ERROR_SXS_XML_E_INTERNALERROR                               14041L
#define ERROR_SXS_XML_E_UNEXPECTED_WHITESPACE                       14042L
#define ERROR_SXS_XML_E_INCOMPLETE_ENCODING                         14043L
#define ERROR_SXS_XML_E_MISSING_PAREN                               14044L
#define ERROR_SXS_XML_E_EXPECTINGCLOSEQUOTE                         14045L
#define ERROR_SXS_XML_E_MULTIPLE_COLONS                             14046L
#define ERROR_SXS_XML_E_INVALID_DECIMAL                             14047L
#define ERROR_SXS_XML_E_INVALID_HEXIDECIMAL                         14048L
#define ERROR_SXS_XML_E_INVALID_UNICODE                             14049L
#define ERROR_SXS_XML_E_WHITESPACEORQUESTIONMARK                    14050L
#define ERROR_SXS_XML_E_UNEXPECTEDENDTAG                            14051L
#define ERROR_SXS_XML_E_UNCLOSEDTAG                                 14052L
#define ERROR_SXS_XML_E_DUPLICATEATTRIBUTE                          14053L
#define ERROR_SXS_XML_E_MULTIPLEROOTS                               14054L
#define ERROR_SXS_XML_E_INVALIDATROOTLEVEL                          14055L
#define ERROR_SXS_XML_E_BADXMLDECL                                  14056L
#define ERROR_SXS_XML_E_MISSINGROOT                                 14057L
#define ERROR_SXS_XML_E_UNEXPECTEDEOF                               14058L
#define ERROR_SXS_XML_E_BADPEREFINSUBSET                            14059L
#define ERROR_SXS_XML_E_UNCLOSEDSTARTTAG                            14060L
#define ERROR_SXS_XML_E_UNCLOSEDENDTAG                              14061L
#define ERROR_SXS_XML_E_UNCLOSEDSTRING                              14062L
#define ERROR_SXS_XML_E_UNCLOSEDCOMMENT                             14063L
#define ERROR_SXS_XML_E_UNCLOSEDDECL                                14064L
#define ERROR_SXS_XML_E_UNCLOSEDCDATA                               14065L
#define ERROR_SXS_XML_E_RESERVEDNAMESPACE                           14066L
#define ERROR_SXS_XML_E_INVALIDENCODING                             14067L
#define ERROR_SXS_XML_E_INVALIDSWITCH                               14068L
#define ERROR_SXS_XML_E_BADXMLCASE                                  14069L
#define ERROR_SXS_XML_E_INVALID_STANDALONE                          14070L
#define ERROR_SXS_XML_E_UNEXPECTED_STANDALONE                       14071L
#define ERROR_SXS_XML_E_INVALID_VERSION                             14072L
#define ERROR_SXS_XML_E_MISSINGEQUALS                               14073L
#define ERROR_SXS_PROTECTION_RECOVERY_FAILED                        14074L
#define ERROR_SXS_PROTECTION_PUBLIC_KEY_TOO_SHORT                   14075L
#define ERROR_SXS_PROTECTION_CATALOG_NOT_VALID                      14076L
#define ERROR_SXS_UNTRANSLATABLE_HRESULT                            14077L
#define ERROR_SXS_PROTECTION_CATALOG_FILE_MISSING                   14078L
#define ERROR_SXS_MISSING_ASSEMBLY_IDENTITY_ATTRIBUTE               14079L
#define ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE_NAME          14080L
#define ERROR_SXS_ASSEMBLY_MISSING                                  14081L
#define ERROR_SXS_CORRUPT_ACTIVATION_STACK                          14082L
#define ERROR_SXS_CORRUPTION                                        14083L
#define ERROR_SXS_EARLY_DEACTIVATION                                14084L
#define ERROR_SXS_INVALID_DEACTIVATION                              14085L
#define ERROR_SXS_MULTIPLE_DEACTIVATION                             14086L
#define ERROR_SXS_PROCESS_TERMINATION_REQUESTED                     14087L
#define ERROR_SXS_RELEASE_ACTIVATION_CONTEXT                        14088L
#define ERROR_SXS_SYSTEM_DEFAULT_ACTIVATION_CONTEXT_EMPTY           14089L
#define ERROR_SXS_INVALID_IDENTITY_ATTRIBUTE_VALUE                  14090L
#define ERROR_SXS_INVALID_IDENTITY_ATTRIBUTE_NAME                   14091L
#define ERROR_SXS_INVALID_DUPLICATE_ATTRIBUTE                       14092L
#define ERROR_SXS_IDENTITY_PARSE_ERROR                              14093L
#define ERROR_MALFORMED_SUBSTITUTION_STRING                         14094L
#define ERROR_SXS_INCORRECT_PUBLIC_KEY_TOKEN                        14095L
#define ERROR_UNMAPPED_SUBSTITUTION_STRING                          14096L
#define ERROR_SXS_ASSEMBLY_NOT_LOCKED                               14097L
#define ERROR_SXS_COMPONENT_STORE_CORRUPT                           14098L
#define ERROR_ADVANCED_INSTALLER_FAILED                             14099L
#define ERROR_XML_ENCODING_MISMATCH                                 14100L
#define ERROR_SXS_MANIFEST_IDENTITY_SAME_BUT_CONTENTS_DIFFERENT     14101L
#define ERROR_SXS_IDENTITIES_DIFFERENT                              14102L
#define ERROR_SXS_ASSEMBLY_IS_NOT_A_DEPLOYMENT                      14103L
#define ERROR_SXS_FILE_NOT_PART_OF_ASSEMBLY                         14104L
#define ERROR_SXS_MANIFEST_TOO_BIG                                  14105L
#define ERROR_SXS_SETTING_NOT_REGISTERED                            14106L
#define ERROR_SXS_TRANSACTION_CLOSURE_INCOMPLETE                    14107L
#define ERROR_SMI_PRIMITIVE_INSTALLER_FAILED                        14108L
#define ERROR_GENERIC_COMMAND_FAILED                                14109L
#define ERROR_SXS_FILE_HASH_MISSING                                 14110L

/* Event error codes */
#define ERROR_EVT_INVALID_CHANNEL_PATH                          15000L
#define ERROR_EVT_INVALID_QUERY                                 15001L
#define ERROR_EVT_PUBLISHER_METADATA_NOT_FOUND                  15002L
#define ERROR_EVT_EVENT_TEMPLATE_NOT_FOUND                      15003L
#define ERROR_EVT_INVALID_PUBLISHER_NAME                        15004L
#define ERROR_EVT_INVALID_EVENT_DATA                            15005L
#define ERROR_EVT_CHANNEL_NOT_FOUND                             15007L
#define ERROR_EVT_MALFORMED_XML_TEXT                            15008L
#define ERROR_EVT_SUBSCRIPTION_TO_DIRECT_CHANNEL                15009L
#define ERROR_EVT_CONFIGURATION_ERROR                           15010L
#define ERROR_EVT_QUERY_RESULT_STATE                            15011L
#define ERROR_EVT_QUERY_RESULT_INVALID_POSITION                 15012L
#define ERROR_EVT_NON_VALIDATING_MSXML                          15013L
#define ERROR_EVT_FILTER_ALREADYSCOPED                          15014L
#define ERROR_EVT_FILTER_NOTELTSET                              15015L
#define ERROR_EVT_FILTER_INVARG                                 15016L
#define ERROR_EVT_FILTER_INVTEST                                15017L
#define ERROR_EVT_FILTER_INVTYPE                                15018L
#define ERROR_EVT_FILTER_PARSEERR                               15019L
#define ERROR_EVT_FILTER_UNSUPPORTEDOP                          15020L
#define ERROR_EVT_FILTER_UNEXPECTEDTOKEN                        15021L
#define ERROR_EVT_INVALID_OPERATION_OVER_ENABLED_DIRECT_CHANNEL 15022L
#define ERROR_EVT_INVALID_CHANNEL_PROPERTY_VALUE                15023L
#define ERROR_EVT_INVALID_PUBLISHER_PROPERTY_VALUE              15024L
#define ERROR_EVT_CHANNEL_CANNOT_ACTIVATE                       15025L
#define ERROR_EVT_FILTER_TOO_COMPLEX                            15026L
#define ERROR_EVT_MESSAGE_NOT_FOUND                             15027L
#define ERROR_EVT_MESSAGE_ID_NOT_FOUND                          15028L
#define ERROR_EVT_UNRESOLVED_VALUE_INSERT                       15029L
#define ERROR_EVT_UNRESOLVED_PARAMETER_INSERT                   15030L
#define ERROR_EVT_MAX_INSERTS_REACHED                           15031L
#define ERROR_EVT_EVENT_DEFINITION_NOT_FOUND                    15032L
#define ERROR_EVT_MESSAGE_LOCALE_NOT_FOUND                      15033L
#define ERROR_EVT_VERSION_TOO_OLD                               15034L
#define ERROR_EVT_VERSION_TOO_NEW                               15035L
#define ERROR_EVT_CANNOT_OPEN_CHANNEL_OF_QUERY                  15036L
#define ERROR_EVT_PUBLISHER_DISABLED                            15037L
#define ERROR_EVT_FILTER_OUT_OF_RANGE                           15038L

/* WEC error codes */
#define ERROR_EC_SUBSCRIPTION_CANNOT_ACTIVATE   15080L
#define ERROR_EC_LOG_DISABLED                   15081L
#define ERROR_EC_CIRCULAR_FORWARDING            15082L
#define ERROR_EC_CREDSTORE_FULL                 15083L
#define ERROR_EC_CRED_NOT_FOUND                 15084L
#define ERROR_EC_NO_ACTIVE_CHANNEL              15085L

/* Multilingual User Interface (MUI) error codes */
#define ERROR_MUI_FILE_NOT_FOUND                    15100L
#define ERROR_MUI_INVALID_FILE                      15101L
#define ERROR_MUI_INVALID_RC_CONFIG                 15102L
#define ERROR_MUI_INVALID_LOCALE_NAME               15103L
#define ERROR_MUI_INVALID_ULTIMATEFALLBACK_NAME     15104L
#define ERROR_MUI_FILE_NOT_LOADED                   15105L
#define ERROR_RESOURCE_ENUM_USER_STOP               15106L
#define ERROR_MUI_INTLSETTINGS_UILANG_NOT_INSTALLED 15107L
#define ERROR_MUI_INTLSETTINGS_INVALID_LOCALE_NAME  15108L

/* Monitor Configuration API (MCA) error codes */
#define ERROR_MCA_INVALID_CAPABILITIES_STRING           15200L
#define ERROR_MCA_INVALID_VCP_VERSION                   15201L
#define ERROR_MCA_MONITOR_VIOLATES_MCCS_SPECIFICATION   15202L
#define ERROR_MCA_MCCS_VERSION_MISMATCH                 15203L
#define ERROR_MCA_UNSUPPORTED_MCCS_VERSION              15204L
#define ERROR_MCA_INTERNAL_ERROR                        15205L
#define ERROR_MCA_INVALID_TECHNOLOGY_TYPE_RETURNED      15206L
#define ERROR_MCA_UNSUPPORTED_COLOR_TEMPERATURE         15207L

/* System device error codes */
#define ERROR_AMBIGUOUS_SYSTEM_DEVICE   15250L
#define ERROR_SYSTEM_DEVICE_NOT_FOUND   15251L

/* Vortex error codes */
#define ERROR_HASH_NOT_SUPPORTED    15300L
#define ERROR_HASH_NOT_PRESENT      15301L

/* Severity codes */
#define SEVERITY_SUCCESS    0
#define SEVERITY_ERROR      1

/* Value used to map NT error codes to COM error codes */
#define FACILITY_NT_BIT 0x10000000L

/* Macros for working with COM error codes */
#define SUCCEEDED( x )              ((HRESULT)(x) >= 0)
#define FAILED( x )                 ((HRESULT)(x) < 0)
#define IS_ERROR( x )               (((unsigned long)(x) >> 31) == SEVERITY_ERROR)
#define HRESULT_CODE( x )           ((x) & 0x0000FFFF)
#define SCODE_CODE( x )             ((x) & 0x0000FFFF)
#define HRESULT_FACILITY( x )       (((x) >> 16) & 0x00001FFF)
#define SCODE_FACILITY( x )         (((x) >> 16) & 0x00001FFF)
#define HRESULT_SEVERITY( x )       (((x) >> 31) & 0x00000001)
#define SCODE_SEVERITY( x )         (((x) >> 31) & 0x00000001)
#define MAKE_HRESULT( p1, p2, p3 ) \
    ((HRESULT)(((unsigned long)(p1) << 31) | ((unsigned long)(p2) << 16) | \
    ((unsigned long)(p3))))
#define MAKE_SCODE( p1, p2, p3 ) \
    ((SCODE)(((unsigned long)(p1) << 31) | ((unsigned long)(p2) << 16) | \
    ((unsigned long)(p3))))
#define HRESULT_FROM_WIN32( x ) \
    ((HRESULT)(x) <= 0 ? ((HRESULT)(x)) : ((HRESULT)(((x) & 0x0000FFFF) | \
    (FACILITY_WIN32 << 16) | 0x80000000)))
#define HRESULT_FROM_NT( x )        ((HRESULT)((x) | FACILITY_NT_BIT))
#define HRESULT_FROM_SETUPAPI( x ) \
    ((((x) & (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR)) == \
    (APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR)) ? \
    ((HRESULT)(((x) & 0x0000FFFFL) | (FACILITY_SETUPAPI << 16) | 0x80000000L)) : \
    HRESULT_FROM_WIN32( x ))
#define FILTER_HRESULT_FROM_FLT_NTSTATUS( x ) \
    ((HRESULT)(((x) | 0x8000FFFFL) | (FACILITY_USERMODE_FACILITY_MANAGER << 16)))

/* Macros for compatibility */
#define GetScode( x )               ((SCODE)(x))
#define ResultFromScode( x )        ((HRESULT)(x))
#define PropagateResult( p1, p2 )   ((HRESULT)(p2))

/* COM equivalents of Win32 error codes */
#define E_NOT_SET               HRESULT_FROM_WIN32( ERROR_NOT_FOUND )
#define E_NOT_VALID_STATE       HRESULT_FROM_WIN32( ERROR_INVALID_STATE )
#define E_NOT_SUFFICIENT_BUFFER HRESULT_FROM_WIN32( ERROR_INSUFFICIENT_BUFFER )

/* Success values */
#define NOERROR 0

/* COM error codes */
#define E_UNEXPECTED                                    0x8000FFFFL
#define E_NOTIMPL                                       0x80004001L
#define E_OUTOFMEMORY                                   0x8007000EL
#define E_INVALIDARG                                    0x80070057L
#define E_NOINTERFACE                                   0x80004002L
#define E_POINTER                                       0x80004003L
#define E_HANDLE                                        0x80070006L
#define E_ABORT                                         0x80004004L
#define E_FAIL                                          0x80004005L
#define E_ACCESSDENIED                                  0x80070005L
#define E_PENDING                                       0x8000000AL
#define CO_E_INIT_TLS                                   0x80004006L
#define CO_E_INIT_SHARED_ALLOCATOR                      0x80004007L
#define CO_E_INIT_MEMORY_ALLOCATOR                      0x80004008L
#define CO_E_INIT_CLASS_CACHE                           0x80004009L
#define CO_E_INIT_RPC_CHANNEL                           0x8000400AL
#define CO_E_INIT_TLS_SET_CHANNEL_CONTROL               0x8000400BL
#define CO_E_INIT_TLS_CHANNEL_CONTROL                   0x8000400CL
#define CO_E_INIT_UNACCEPTED_USER_ALLOCATOR             0x8000400DL
#define CO_E_INIT_SCM_MUTEX_EXISTS                      0x8000400EL
#define CO_E_INIT_SCM_FILE_MAPPING_EXISTS               0x8000400FL
#define CO_E_INIT_SCM_MAP_VIEW_OF_FILE                  0x80004010L
#define CO_E_INIT_SCM_EXEC_FAILURE                      0x80004011L
#define CO_E_INIT_ONLY_SINGLE_THREADED                  0x80004012L
#define CO_E_CANT_REMOTE                                0x80004013L
#define CO_E_BAD_SERVER_NAME                            0x80004014L
#define CO_E_WRONG_SERVER_IDENTITY                      0x80004015L
#define CO_E_OLE1DDE_DISABLED                           0x80004016L
#define CO_E_RUNAS_SYNTAX                               0x80004017L
#define CO_E_CREATEPROCESS_FAILURE                      0x80004018L
#define CO_E_RUNAS_CREATEPROCESS_FAILURE                0x80004019L
#define CO_E_RUNAS_LOGON_FAILURE                        0x8000401AL
#define CO_E_LAUNCH_PERMSSION_DENIED                   0x8000401BL
#define CO_E_START_SERVICE_FAILURE                      0x8000401CL
#define CO_E_REMOTE_COMMUNICATION_FAILURE               0x8000401DL
#define CO_E_SERVER_START_TIMEOUT                       0x8000401EL
#define CO_E_CLSREG_INCONSISTENT                        0x8000401FL
#define CO_E_IIDREG_INCONSISTENT                        0x80004020L
#define CO_E_NOT_SUPPORTED                              0x80004021L
#define CO_E_RELOAD_DLL                                 0x80004022L
#define CO_E_MSI_ERROR                                  0x80004023L
#define CO_E_ATTEMPT_TO_CREATE_OUTSIDE_CLIENT_CONTEXT   0x80004024L
#define CO_E_SERVER_PAUSED                              0x80004025L
#define CO_E_SERVER_NOT_PAUSED                          0x80004026L
#define CO_E_CLASS_DISABLED                             0x80004027L
#define CO_E_CLRNOTAVAILABLE                            0x80004028L
#define CO_E_ASYNC_WORK_REJECTED                        0x80004029L
#define CO_E_SERVER_INIT_TIMEOUT                        0x8000402AL
#define CO_E_NO_SECCTX_IN_ACTIVATE                      0x8000402BL
#define CO_E_TRACKER_CONFIG                             0x80004030L
#define CO_E_THREADPOOL_CONFIG                          0x80004031L
#define CO_E_SXS_CONFIG                                 0x80004032L
#define CO_E_MALFORMED_SPN                              0x80004033L
#define S_OK                                            0x00000000L
#define S_FALSE                                         0x00000001L

/* OLE error codes */
#define OLE_E_FIRST                 0x80040000L
#define OLE_E_LAST                  0x800400FFL
#define OLE_S_FIRST                 0x00040000L
#define OLE_S_LAST                  0x000400FFL
#define OLE_E_OLEVERB               0x80040000L
#define OLE_E_ADVF                  0x80040001L
#define OLE_E_ENUM_NOMORE           0x80040002L
#define OLE_E_ADVISENOTSUPPORTED    0x80040003L
#define OLE_E_NOCONNECTION          0x80040004L
#define OLE_E_NOTRUNNING            0x80040005L
#define OLE_E_NOCACHE               0x80040006L
#define OLE_E_BLANK                 0x80040007L
#define OLE_E_CLASSDIFF             0x80040008L
#define OLE_E_CANT_GETMONIKER       0x80040009L
#define OLE_E_CANT_BINDTOSOURCE     0x8004000AL
#define OLE_E_STATIC                0x8004000BL
#define OLE_E_PROMPTSAVECANCELLED   0x8004000CL
#define OLE_E_INVALIDRECT           0x8004000DL
#define OLE_E_WRONGCOMPOBJ          0x8004000EL
#define OLE_E_INVALIDHWND           0x8004000FL
#define OLE_E_NOT_INPLACEACTIVE     0x80040010L
#define OLE_E_CANTCONVERT           0x80040011L
#define OLE_E_NOSTORAGE             0x80040012L
#define DV_E_FORMATETC              0x80040064L
#define DV_E_DVTARGETDEVICE         0x80040065L
#define DV_E_STGMEDIUM              0x80040066L
#define DV_E_STATDATA               0x80040067L
#define DV_E_LINDEX                 0x80040068L
#define DV_E_TYMED                  0x80040069L
#define DV_E_CLIPFORMAT             0x8004006AL
#define DV_E_DVASPECT               0x8004006BL
#define DV_E_DVTARGETDEVICE_SIZE    0x8004006CL
#define DV_E_NOIVIEWOBJECT          0x8004006DL

/* Drag/drop error codes */
#define DRAGDROP_E_FIRST                0x80040100L
#define DRAGDROP_E_LAST                 0x8004010FL
#define DRAGDROP_S_FIRST                0x00040100L
#define DRAGDROP_S_LAST                 0x0004010FL
#define DRAGDROP_E_NOTREGISTERED        0x80040100L
#define DRAGDROP_E_ALREADYREGISTERED    0x80040101L
#define DRAGDROP_E_INVALIDHWND          0x80040102L

/* Class factory error codes */
#define CLASSFACTORY_E_FIRST        0x80040110L
#define CLASSFACTORY_E_LAST         0x8004011FL
#define CLASSFACTORY_S_FIRST        0x00040110L
#define CLASSFACTORY_S_LAST         0x0004011FL
#define CLASS_E_NOAGGREGATION       0x80040110L
#define CLASS_E_CLASSNOTAVAILABLE   0x80040111L
#define CLASS_E_NOTLICENSED         0x80040112L

/* Marshalling error codes */
#define MARSHAL_E_FIRST 0x80040120L
#define MARSHAL_E_LAST  0x8004012FL
#define MARSHAL_S_FIRST 0x00040120L
#define MARSHAL_S_LAST  0x0004012FL

/* Data error codes */
#define DATA_E_FIRST    0x80040130L
#define DATA_E_LAST     0x8004013FL
#define DATA_S_FIRST    0x00040130L
#define DATA_S_LAST     0x0004013FL

/* View error codes */
#define VIEW_E_FIRST    0x80040140L
#define VIEW_E_LAST     0x8004014FL
#define VIEW_S_FIRST    0x00040140L
#define VIEW_S_LAST     0x0004014FL
#define VIEW_E_DRAW     0x80040140L

/* Registry error codes */
#define REGDB_E_FIRST               0x80040150L
#define REGDB_E_LAST                0x8004015FL
#define REGDB_S_FIRST               0x00040150L
#define REGDB_S_LAST                0x0004015FL
#define REGDB_E_READREGDB           0x80040150L
#define REGDB_E_WRITEREGDB          0x80040151L
#define REGDB_E_KEYMISSING          0x80040152L
#define REGDB_E_INVALIDVALUE        0x80040153L
#define REGDB_E_CLASSNOTREG         0x80040154L
#define REGDB_E_IIDNOTREG           0x80040155L
#define REGDB_E_BADTHREADINGMODEL   0x80040156L

/* Category error codes */
#define CAT_E_FIRST         0x80040160L
#define CAT_E_LAST          0x80040161L
#define CAT_E_CATIDNOEXIST  0x80040160L
#define CAT_E_NODESCRIPTION 0x80040161L

/* Class store error codes */
#define CS_E_FIRST                  0x80040164L
#define CS_E_LAST                   0x8004016FL
#define CS_E_PACKAGE_NOTFOUND       0x80040164L
#define CS_E_NOT_DELETABLE          0x80040165L
#define CS_E_CLASS_NOTFOUND         0x80040166L
#define CS_E_INVALID_VERSION        0x80040167L
#define CS_E_CLASSSTORE             0x80040168L
#define CS_E_OBJECT_NOTFOUND        0x80040169L
#define CS_E_OBJECT_ALREADY_EXISTS  0x8004016AL
#define CS_E_INVALID_PATH           0x8004016BL
#define CS_E_NETWORK_ERROR          0x8004016CL
#define CS_E_ADMIN_LIMIT_EXCEEDED   0x8004016DL
#define CS_E_SCHEMA_MISMATCH        0x8004016EL
#define CS_E_INTERNAL_ERROR         0x8004016FL

/* Cache error codes */
#define CACHE_E_FIRST           0x80040170L
#define CACHE_E_LAST            0x8004017FL
#define CACHE_S_FIRST           0x00040170L
#define CACHE_S_LAST            0x0004017FL
#define CACHE_E_NOCACHE_UPDATED 0x80040170L

/* OLE object error codes */
#define OLEOBJ_E_FIRST          0x80040180L
#define OLEOBJ_E_LAST           0x8004018FL
#define OLEOBJ_S_FIRST          0x00040180L
#define OLEOBJ_S_LAST           0x0004018FL
#define OLEOBJ_E_NOVERBS        0x80040180L
#define OLEOBJ_E_INVALIDVERB    0x80040181L

/* Client site error codes */
#define CLIENTSITE_E_FIRST      0x80040190L
#define CLIENTSITE_E_LAST       0x8004019FL
#define CLIENTSITE_S_FIRST      0x00040190L
#define CLIENTSITE_S_LAST       0x0004019FL

/* In-place error codes */
#define INPLACE_E_FIRST         0x800401A0L
#define INPLACE_E_LAST          0x800401AFL
#define INPLACE_S_FIRST         0x000401A0L
#define INPLACE_S_LAST          0x000401AFL
#define INPLACE_E_NOTUNDOABLE   0x800401A0L
#define INPLACE_E_NOTOOLSPACE   0x800401A1L

/* Enumeration error codes */
#define ENUM_E_FIRST    0x800401B0L
#define ENUM_E_LAST     0x800401BFL
#define ENUM_S_FIRST    0x000401B0L
#define ENUM_S_LAST     0x000401BFL

/* OLE 1.0 conversion error codes */
#define CONVERT10_E_FIRST                   0x800401C0L
#define CONVERT10_E_LAST                    0x800401CFL
#define CONVERT10_S_FIRST                   0x000401C0L
#define CONVERT10_S_LAST                    0x000401CFL
#define CONVERT10_E_OLESTREAM_GET           0x800401C0L
#define CONVERT10_E_OLESTREAM_PUT           0x800401C1L
#define CONVERT10_E_OLESTREAM_FMT           0x800401C2L
#define CONVERT10_E_OLESTREAM_BITMAP_TO_DIB 0x800401C3L
#define CONVERT10_E_STG_FMT                 0x800401C4L
#define CONVERT10_E_STG_NO_STD_STREAM       0x800401C5L
#define CONVERT10_E_STG_DIB_TO_BITMAP       0x800401C6L

/* Clipboard error codes */
#define CLIPBRD_E_FIRST         0x800401D0L
#define CLIPBRD_E_LAST          0x800401DFL
#define CLIPBRD_S_FIRST         0x000401D0L
#define CLIPBRD_S_LAST          0x000401DFL
#define CLIPBRD_E_CANT_OPEN     0x800401D0L
#define CLIPBRD_E_CANT_EMPTY    0x800401D1L
#define CLIPBRD_E_CANT_SET      0x800401D2L
#define CLIPBRD_E_BAD_DATA      0x800401D3L
#define CLIPBRD_E_CANT_CLOSE    0x800401D4L

/* Moniker error codes */
#define MK_E_FIRST                              0x800401E0L
#define MK_E_LAST                               0x800401EFL
#define MK_S_FIRST                              0x000401E0L
#define MK_S_LAST                               0x000401EFL
#define MK_E_CONNECTMANUALLY                    0x800401E0L
#define MK_E_EXCEEDEDDEADLINE                   0x800401E1L
#define MK_E_NEEDGENERIC                        0x800401E2L
#define MK_E_UNAVAILABLE                        0x800401E3L
#define MK_E_SYNTAX                             0x800401E4L
#define MK_E_NOOBJECT                           0x800401E5L
#define MK_E_INVALIDEXTENSION                   0x800401E6L
#define MK_E_INTERMEDIATEINTERFACENOTSUPPORTED  0x800401E7L
#define MK_E_NOTBINDABLE                        0x800401E8L
#define MK_E_NOTBOUND                           0x800401E9L
#define MK_E_CANTOPENFILE                       0x800401EAL
#define MK_E_MUSTBOTHERUSER                     0x800401EBL
#define MK_E_NOINVERSE                          0x800401ECL
#define MK_E_NOSTORAGE                          0x800401EDL
#define MK_E_NOPREFIX                           0x800401EEL
#define MK_E_ENUMERATION_FAILED                 0x800401EFL

/* COM error codes */
#define CO_E_FIRST              0x800401F0L
#define CO_E_LAST               0x800401FFL
#define CO_S_FIRST              0x000401F0L
#define CO_S_LAST               0x000401FFL
#define CO_E_NOTINITIALIZED     0x800401F0L
#define CO_E_ALREADYINITIALIZED 0x800401F1L
#define CO_E_CANTDETERMINECLASS 0x800401F2L
#define CO_E_CLASSSTRING        0x800401F3L
#define CO_E_IIDSTRING          0x800401F4L
#define CO_E_APPNOTFOUND        0x800401F5L
#define CO_E_APPSINGLEUSE       0x800401F6L
#define CO_E_ERRORINAPP         0x800401F7L
#define CO_E_DLLNOTFOUND        0x800401F8L
#define CO_E_ERRORINDLL         0x800401F9L
#define CO_E_WRONGOSFORAPP      0x800401FAL
#define CO_E_OBJNOTREG          0x800401FBL
#define CO_E_OBJISREG           0x800401FCL
#define CO_E_OBJNOTCONNECTED    0x800401FDL
#define CO_E_APPDIDNTREG        0x800401FEL
#define CO_E_RELEASED           0x800401FFL

/* Event error codes */
#define EVENT_E_FIRST                                       0x80040200L
#define EVENT_E_LAST                                        0x8004021FL
#define EVENT_S_FIRST                                       0x00040200L
#define EVENT_S_LAST                                        0x0004021FL
#define EVENT_S_SOME_SUBSCRIBERS_FAILED                     0x00040200L
#define EVENT_E_ALL_SUBSCRIBERS_FAILED                      0x80040201L
#define EVENT_S_NOSUBSCRIBERS                               0x00040202L
#define EVENT_E_QUERYSYNTAX                                 0x80040203L
#define EVENT_E_QUERYFIELD                                  0x80040204L
#define EVENT_E_INTERNALEXCEPTION                           0x80040205L
#define EVENT_E_INTERNALERROR                               0x80040206L
#define EVENT_E_INVALID_PER_USER_SID                        0x80040207L
#define EVENT_E_USER_EXCEPTION                              0x80040208L
#define EVENT_E_TOO_MANY_METHODS                            0x80040209L
#define EVENT_E_MISSING_EVENTCLASS                          0x8004020AL
#define EVENT_E_NOT_ALL_REMOVED                             0x8004020BL
#define EVENT_E_COMPLUS_NOT_INSTALLED                       0x8004020CL
#define EVENT_E_CANT_MODIFY_OR_DELETE_UNCONFIGURED_OBJECT   0x8004020DL
#define EVENT_E_CANT_MOIDFY_OR_DELETE_CONFIGURED_OBJECT     0x8004020EL
#define EVENT_E_INVALID_EVENT_CLASS_PARTITION               0x8004020FL
#define EVENT_E_PER_USER_SID_NOT_LOGGED_ON                  0x80040210L

/* Transaction error codes */
#define XACT_E_FIRST                        0x8004D000L
#define XACT_E_LAST                         0x8004D02BL
#define XACT_S_FIRST                        0x0004D000L
#define XACT_S_LAST                         0x0004D010L
#define XACT_E_ALREADYOTHERSINGLEPHASE      0x8004D000L
#define XACT_E_CANTRETAIN                   0x8004D001L
#define XACT_E_COMMITFAILED                 0x8004D002L
#define XACT_E_COMMITPREVENTED              0x8004D003L
#define XACT_E_HEURISTICABORT               0x8004D004L
#define XACT_E_HEURISTICCOMMIT              0x8004D005L
#define XACT_E_HEURISTICDAMAGE              0x8004D006L
#define XACT_E_HEURISTICDANGER              0x8004D007L
#define XACT_E_ISOLATIONLEVEL               0x8004D008L
#define XACT_E_NOASYNC                      0x8004D009L
#define XACT_E_NOENLIST                     0x8004D00AL
#define XACT_E_NOISORETAIN                  0x8004D00BL
#define XACT_E_NORESOURCE                   0x8004D00CL
#define XACT_E_NOTCURRENT                   0x8004D00DL
#define XACT_E_NOTRANSACTION                0x8004D00EL
#define XACT_E_NOTSUPPORTED                 0x8004D00FL
#define XACT_E_UNKNOWNMGRID                 0x8004D010L
#define XACT_E_WRONGSTATE                   0x8004D011L
#define XACT_E_WRONGUOW                     0x8004D012L
#define XACT_E_XTIONEXISTS                  0x8004D013L
#define XACT_E_NOIMPORTOBJECT               0x8004D014L
#define XACT_E_INVALIDCOOKIE                0x8004D015L
#define XACT_E_INDOUBT                      0x8004D016L
#define XACT_E_NOTIMEOUT                    0x8004D017L
#define XACT_E_ALREADYINPROGRESS            0x8004D018L
#define XACT_E_ABORTED                      0x8004D019L
#define XACT_E_LOGFULL                      0x8004D01AL
#define XACT_E_TMNOTAVAILABLE               0x8004D01BL
#define XACT_E_CONNECTION_DOWN              0x8004D01CL
#define XACT_E_CONNECTION_DENIED            0x8004D01DL
#define XACT_E_REENLISTTIMEOUT              0x8004D01EL
#define XACT_E_TIP_CONNECT_FAILED           0x8004D01FL
#define XACT_E_TIP_PROTOCOL_ERROR           0x8004D020L
#define XACT_E_TIP_PULL_FAILED              0x8004D021L
#define XACT_E_DEST_TMNOTAVAILABLE          0x8004D022L
#define XACT_E_TIP_DISABLED                 0x8004D023L
#define XACT_E_NETWORK_TX_DISABLED          0x8004D024L
#define XACT_E_PARTNER_NETWORK_TX_DISABLED  0x8004D025L
#define XACT_E_XA_TX_DISABLED               0x8004D026L
#define XACT_E_UNABLE_TO_READ_DTC_CONFIG    0x8004D027L
#define XACT_E_UNABLE_TO_LOAD_DTC_PROXY     0x8004D028L
#define XACT_E_ABORTING                     0x8004D029L
#define XACT_E_PUSH_COMM_FAILURE            0x8004D02AL
#define XACT_E_PULL_COMM_FAILURE            0x8004D02BL
#define XACT_E_LU_TX_DISABLED               0x8004D02CL
#define XACT_E_CLERKNOTFOUND                0x8004D080L
#define XACT_E_CLERKEXISTS                  0x8004D081L
#define XACT_E_RECOVERYINPROGRESS           0x8004D082L
#define XACT_E_TRANSACTIONCLOSED            0x8004D083L
#define XACT_E_INVALIDLSN                   0x8004D084L
#define XACT_E_REPLAYREQUEST                0x8004D085L
#define XACT_S_ASYNC                        0x0004D000L
#define XACT_S_DEFECT                       0x0004D001L
#define XACT_S_READONLY                     0x0004D002L
#define XACT_S_SOMENORETAIN                 0x0004D003L
#define XACT_S_OKINFORM                     0x0004D004L
#define XACT_S_MADECHANGESCONTENT           0x0004D005L
#define XACT_S_MADECHANGESINFORM            0x0004D006L
#define XACT_S_ALLNORETAIN                  0x0004D007L
#define XACT_S_ABORTING                     0x0004D008L
#define XACT_S_SINGLEPHASE                  0x0004D009L
#define XACT_S_LOCALLY_OK                   0x0004D00AL
#define XACT_S_LASTRESOURCEMANAGER          0x0004D010L

/* Context error codes */
#define CONTEXT_E_FIRST                         0x8004E000L
#define CONTEXT_E_LAST                          0x8004E02FL
#define CONTEXT_S_FIRST                         0x0004E000L
#define CONTEXT_S_LAST                          0x0004E02FL
#define CONTEXT_E_ABORTED                       0x8004E002L
#define CONTEXT_E_ABORTING                      0x8004E003L
#define CONTEXT_E_NOCONTEXT                     0x8004E004L
#define CONTEXT_E_WOULD_DEADLOCK                0x8004E005L
#define CONTEXT_E_SYNCH_TIMEOUT                 0x8004E006L
#define CONTEXT_E_OLDREF                        0x8004E007L
#define CONTEXT_E_ROLENOTFOUND                  0x8004E00CL
#define CONTEXT_E_TMNOTAVAILABLE                0x8004E00FL
#define CO_E_ACTIVATIONFAILED                   0x8004E021L
#define CO_E_ACTIVATIONFAILED_EVENTLOGGED       0x8004E022L
#define CO_E_ACTIVATIONFAILED_CATALOGERROR      0x8004E023L
#define CO_E_ACTIVATIONFAILED_TIMEOUT           0x8004E024L
#define CO_E_INITIALIZATIONFAILED               0x8004E025L
#define CONTEXT_E_NOJIT                         0x8004E026L
#define CONTEXT_E_NOTRANSACTION                 0x8004E027L
#define CO_E_THREADINGMODEL_CHANGED             0x8004E028L
#define CO_E_NOIISINTRINSICS                    0x8004E029L
#define CO_E_NOCOOKIES                          0x8004E02AL
#define CO_E_DBERROR                            0x8004E02BL
#define CO_E_NOTPOOLED                          0x8004E02CL
#define CO_E_NOTCONSTRUCTED                     0x8004E02DL
#define CO_E_NOSYNCHRONIZATION                  0x8004E02EL
#define CO_E_ISOLEVELMISMATCH                   0x8004E02FL
#define CO_E_CALL_OUT_OF_TX_SCOPE_NOT_ALLOWED   0x8004E030L
#define CO_E_EXIT_TRANSACTION_SCOPE_NOT_CALLED  0x8004E031L

/* Old OLE success codes */
#define OLE_S_USEREG            0x00040000L
#define OLE_S_STATIC            0x00040001L
#define OLE_S_MAC_CLIPFORMAT    0x00040002L

/* Old drag/drop success codes */
#define DRAGDROP_S_DROP                 0x00040100L
#define DRAGDROP_S_CANCEL               0x00040101L
#define DRAGDROP_S_USEDEFAULTCURSORS    0x00040102L

/* Old data success codes */
#define DATA_S_SAMEFORMATETC    0x00040130L

/* Old view success codes */
#define VIEW_S_ALREADY_FROZEN   0x00040140L

/* Old cache success codes */
#define CACHE_S_FORMATETC_NOTSUPPORTED  0x00040170L
#define CACHE_S_SAMECACHE               0x00040171L
#define CACHE_S_SOMECACHES_NOTUPDATED   0x00040172L

/* Old OLE object success codes */
#define OLEOBJ_S_INVALIDVERB        0x00040180L
#define OLEOBJ_S_CANNOT_DOVERB_NOW  0x00040181L
#define OLEOBJ_S_INVALIDHWND        0x00040182L

/* Old in-place success codes */
#define INPLACE_S_TRUNCATED 0x000401A0L

/* Old OLE 1.0 conversion success codes */
#define CONVERT10_S_NO_PRESENTATION 0x000401C0L

/* Old moniker success codes */
#define MK_S_REDUCED_TO_SELF            0x000401E2L
#define MK_S_ME                         0x000401E4L
#define MK_S_HIM                        0x000401E5L
#define MK_S_US                         0x000401E6L
#define MK_S_MONIKERALREADYREGISTERED   0x000401E7L

/* Task scheduler error codes */
#define SCHED_S_TASK_READY                  0x00041300L
#define SCHED_S_TASK_RUNNING                0x00041301L
#define SCHED_S_TASK_DISABLED               0x00041302L
#define SCHED_S_TASK_HAS_NOT_RUN            0x00041303L
#define SCHED_S_TASK_NO_MORE_RUNS           0x00041304L
#define SCHED_S_TASK_NOT_SCHEDULED          0x00041305L
#define SCHED_S_TASK_TERMINATED             0x00041306L
#define SCHED_S_TASK_NO_VALID_TRIGGERS      0x00041307L
#define SCHED_S_EVENT_TRIGGER               0x00041308L
#define SCHED_E_TRIGGER_NOT_FOUND           0x80041309L
#define SCHED_E_TASK_NOT_READY              0x8004130AL
#define SCHED_E_TASK_NOT_RUNNING            0x8004130BL
#define SCHED_E_SERVICE_NOT_INSTALLED       0x8004130CL
#define SCHED_E_CANNOT_OPEN_TASK            0x8004130DL
#define SCHED_E_INVALID_TASK                0x8004130EL
#define SCHED_E_ACCOUNT_INFORMATION_NOT_SET 0x8004130FL
#define SCHED_E_ACCOUNT_NAME_NOT_FOUND      0x80041310L
#define SCHED_E_ACCOUNT_DBASE_CORRUPT       0x80041311L
#define SCHED_E_NO_SECURITY_SERVICES        0x80041312L
#define SCHED_E_UNKNOWN_OBJECT_VERSION      0x80041313L
#define SCHED_E_UNSUPPORTED_ACCOUNT_OPTION  0x80041314L
#define SCHED_E_SERVICE_NOT_RUNNING         0x80041315L
#define SCHED_E_UNEXPECTEDNODE              0x80041316L
#define SCHED_E_NAMESPACE                   0x80041317L
#define SCHED_E_INVALIDVALUE                0x80041318L
#define SCHED_E_MISSINGNODE                 0x80041319L
#define SCHED_E_MALFORMEDXML                0x8004131AL
#define SCHED_S_SOME_TRIGGERS_FAILED        0x0004131BL
#define SCHED_S_BATCH_LOGON_PROBLEM         0x0004131CL
#define SCHED_E_TOO_MANY_NODES              0x8004131DL
#define SCHED_E_PAST_END_BOUNDARY           0x8004131EL
#define SCHED_E_ALREADY_RUNNING             0x8004131FL
#define SCHED_E_USER_NOT_LOGGED_ON          0x80041320L
#define SCHED_E_INVALID_TASK_HASH           0x80041321L
#define SCHED_E_SERVICE_NOT_AVAILABLE       0x80041322L
#define SCHED_E_SERVICE_TOO_BUSY            0x80041323L
#define SCHED_E_TASK_ATTEMPTED              0x80041324L
#define SCHED_E_TASK_QUEUED                 0x80041325L
#define SCHED_E_TASK_DISABLED               0x80041326L
#define SCHED_E_TASK_NOT_V1_COMPAT          0x80041327L
#define SCHED_E_START_ON_DEMAND             0x80041328L

/* Windows error codes */
#define CO_E_CLASS_CREATE_FAILED        0x80080001L
#define CO_E_SCM_ERROR                  0x80080002L
#define CO_E_SCM_RPC_FAILURE            0x80080003L
#define CO_E_BAD_PATH                   0x80080004L
#define CO_E_SERVER_EXEC_FAILURE        0x80080005L
#define CO_E_OBJSRV_RPC_FAILURE         0x80080006L
#define MK_E_NO_NORMALIZED              0x80080007L
#define CO_E_SERVER_STOPPING            0x80080008L
#define MEM_E_INVALID_ROOT              0x80080009L
#define MEM_E_INVALID_LINK              0x80080010L
#define MEM_E_INVALID_SIZE              0x80080011L
#define CO_S_NOTALLINTERFACES           0x00080012L
#define CO_S_MACHINENAMENOTFOUND        0x00080013L
#define CO_E_MISSING_DISPLAYNAME        0x80080015L
#define CO_E_RUNAS_VALUE_MUST_BE_AAA    0x80080016L
#define CO_E_ELEVATION_DISABLED         0x80080017L

/* Dispatch error codes */
#define DISP_E_UNKNOWNINTERFACE         0x80020001L
#define DISP_E_MEMBERNOTFOUND           0x80020003L
#define DISP_E_PARAMNOTFOUND            0x80020004L
#define DISP_E_TYPEMISMATCH             0x80020005L
#define DISP_E_UNKNOWNNAME              0x80020006L
#define DISP_E_NONAMEDARGS              0x80020007L
#define DISP_E_BADVARTYPE               0x80020008L
#define DISP_E_EXCEPTION                0x80020009L
#define DISP_E_OVERFLOW                 0x8002000AL
#define DISP_E_BADINDEX                 0x8002000BL
#define DISP_E_UNKNOWNLCID              0x8002000CL
#define DISP_E_ARRAYISLOCKED            0x8002000DL
#define DISP_E_BADPARAMCOUNT            0x8002000EL
#define DISP_E_PARAMNOTOPTIONAL         0x8002000FL
#define DISP_E_BADCALLEE                0x80020010L
#define DISP_E_NOTACOLLECTION           0x80020011L
#define DISP_E_DIVBYZERO                0x80020012L
#define DISP_E_BUFFERTOOSMALL           0x80020013L
#define TYPE_E_BUFFERTOOSMALL           0x80028016L
#define TYPE_E_FIELDNOTFOUND            0x80028017L
#define TYPE_E_INVDATAREAD              0x80028018L
#define TYPE_E_UNSUPFORMAT              0x80028019L
#define TYPE_E_REGISTRYACCESS           0x8002801CL
#define TYPE_E_LIBNOTREGISTERED         0x8002801DL
#define TYPE_E_UNDEFINEDTYPE            0x80028027L
#define TYPE_E_QUALIFIEDNAMEDISALLOWED  0x80028028L
#define TYPE_E_INVALIDSTATE             0x80028029L
#define TYPE_E_WRONGTYPEKIND            0x8002802AL
#define TYPE_E_ELEMENTNOTFOUND          0x8002802BL
#define TYPE_E_AMBIGUOUSNAME            0x8002802CL
#define TYPE_E_NAMECONFLICT             0x8002802DL
#define TYPE_E_UNKNOWNLCID              0x8002802EL
#define TYPE_E_DLLFUNCTIONNOTFOUND      0x8002802FL
#define TYPE_E_BADMODULEKIND            0x800288BDL
#define TYPE_E_SIZETOOBIG               0x800288C5L
#define TYPE_E_DUPLICATEID              0x800288C6L
#define TYPE_E_INVALIDID                0x800288CFL
#define TYPE_E_TYPEMISMATCH             0x80028CA0L
#define TYPE_E_OUTOFBOUNDS              0x80028CA1L
#define TYPE_E_IOERROR                  0x80028CA2L
#define TYPE_E_CANTCREATETMPFILE        0x80028CA3L
#define TYPE_E_CANTLOADLIBRARY          0x80029C4AL
#define TYPE_E_INCONSISTENTPROPFUNCS    0x80029C83L
#define TYPE_E_CIRCULARTYPE             0x80029C84L

/* Storage error codes */
#define STG_E_INVALIDFUNCTION                   0x80030001L
#define STG_E_FILENOTFOUND                      0x80030002L
#define STG_E_PATHNOTFOUND                      0x80030003L
#define STG_E_TOOMANYOPENFILES                  0x80030004L
#define STG_E_ACCESSDENIED                      0x80030005L
#define STG_E_INVALIDHANDLE                     0x80030006L
#define STG_E_INSUFFICIENTMEMORY                0x80030008L
#define STG_E_INVALIDPOINTER                    0x80030009L
#define STG_E_NOMOREFILES                       0x80030012L
#define STG_E_DISKISWRITEPROTECTED              0x80030013L
#define STG_E_SEEKERROR                         0x80030019L
#define STG_E_WRITEFAULT                        0x8003001DL
#define STG_E_READFAULT                         0x8003001EL
#define STG_E_SHAREVIOLATION                    0x80030020L
#define STG_E_LOCKVIOLATION                     0x80030021L
#define STG_E_FILEALREADYEXISTS                 0x80030050L
#define STG_E_INVALIDPARAMETER                  0x80030057L
#define STG_E_MEDIUMFULL                        0x80030070L
#define STG_E_PROPSETMISMATCHED                 0x800300F0L
#define STG_E_ABNORMALAPIEXIT                   0x800300FAL
#define STG_E_INVALIDHEADER                     0x800300FBL
#define STG_E_INVALIDNAME                       0x800300FCL
#define STG_E_UNKNOWN                           0x800300FDL
#define STG_E_UNIMPLEMENTEDFUNCTION             0x800300FEL
#define STG_E_INVALIDFLAG                       0x800300FFL
#define STG_E_INUSE                             0x80030100L
#define STG_E_NOTCURRENT                        0x80030101L
#define STG_E_REVERTED                          0x80030102L
#define STG_E_CANTSAVE                          0x80030103L
#define STG_E_OLDFORMAT                         0x80030104L
#define STG_E_OLDDLL                            0x80030105L
#define STG_E_SHAREREQUIRED                     0x80030106L
#define STG_E_NOTFILEBASEDSTORAGE               0x80030107L
#define STG_E_EXTANTMARSHALLINGS                0x80030108L
#define STG_E_DOCFILECORRUPT                    0x80030109L
#define STG_E_BADBASEADDRESS                    0x80030110L
#define STG_E_DOCFILETOOLARGE                   0x80030111L
#define STG_E_NOTSIMPLEFORMAT                   0x80030112L
#define STG_E_INCOMPLETE                        0x80030201L
#define STG_E_TERMINATED                        0x80030202L
#define STG_S_CONVERTED                         0x00030200L
#define STG_S_BLOCK                             0x00030201L
#define STG_S_RETRYNOW                          0x00030202L
#define STG_S_MONITORING                        0x00030203L
#define STG_S_MULTIPLEOPENS                     0x00030204L
#define STG_S_CONSOLIDATIONFAILED               0x00030205L
#define STG_S_CANNOTCONSOLIDATE                 0x00030206L
#define STG_E_STATUS_COPY_PROTECTION_FAILURE    0x80030305L
#define STG_E_CSS_AUTHENTICATION_FAILURE        0x80030306L
#define STG_E_CSS_KEY_NOT_PRESENT               0x80030307L
#define STG_E_CSS_KEY_NOT_ESTABLISHED           0x80030308L
#define STG_E_CSS_SCRAMBLED_SECTOR              0x80030309L
#define STG_E_CSS_REGION_MISMATCH               0x8003030AL
#define STG_E_RESETS_EXHAUSTED                  0x8003030BL

/* RPC error codes */
#define RPC_E_CALL_REJECTED                 0x80010001L
#define RPC_E_CALL_CANCELED                 0x80010002L
#define RPC_E_CANTPOST_INSENDCALL           0x80010003L
#define RPC_E_CANTCALLOUT_INASYNCCALL       0x80010004L
#define RPC_E_CANTCALLOUT_INEXTERNALCALL    0x80010005L
#define RPC_E_CONNECTION_TERMINATED         0x80010006L
#define RPC_E_SERVER_DIED                   0x80010007L
#define RPC_E_CLIENT_DIED                   0x80010008L
#define RPC_E_INVALID_DATAPACKET            0x80010009L
#define RPC_E_CANTTRANSMIT_CALL             0x8001000AL
#define RPC_E_CLIENT_CANTMARSHAL_DATA       0x8001000BL
#define RPC_E_CLIENT_CANTUNMARSHAL_DATA     0x8001000CL
#define RPC_E_SERVER_CANTMARSHAL_DATA       0x8001000DL
#define RPC_E_SERVER_CANTUNMARSHAL_DATA     0x8001000EL
#define RPC_E_INVALID_DATA                  0x8001000FL
#define RPC_E_INVALID_PARAMETER             0x80010010L
#define RPC_E_CANTCALLOUT_AGAIN             0x80010011L
#define RPC_E_SERVER_DIED_DNE               0x80010012L
#define RPC_E_SYS_CALL_FAILED               0x80010100L
#define RPC_E_OUT_OF_RESOURCES              0x80010101L
#define RPC_E_ATTEMPTED_MULTITHREAD         0x80010102L
#define RPC_E_NOT_REGISTERED                0x80010103L
#define RPC_E_FAULT                         0x80010104L
#define RPC_E_SERVERFAULT                   0x80010105L
#define RPC_E_CHANGED_MODE                  0x80010106L
#define RPC_E_INVALIDMETHOD                 0x80010107L
#define RPC_E_DISCONNECTED                  0x80010108L
#define RPC_E_RETRY                         0x80010109L
#define RPC_E_SERVERCALL_RETRYLATER         0x8001010AL
#define RPC_E_SERVERCALL_REJECTED           0x8001010BL
#define RPC_E_INVALID_CALLDATA              0x8001010CL
#define RPC_E_CANTCALLOUT_ININPUTSYNCCALL   0x8001010DL
#define RPC_E_WRONG_THREAD                  0x8001010EL
#define RPC_E_THREAD_NOT_INIT               0x8001010FL
#define RPC_E_VERSION_MISMATCH              0x80010110L
#define RPC_E_INVALID_HEADER                0x80010111L
#define RPC_E_INVALID_EXTENSION             0x80010112L
#define RPC_E_INVALID_IPID                  0x80010113L
#define RPC_E_INVALID_OBJECT                0x80010114L
#define RPC_S_CALLPENDING                   0x80010115L
#define RPC_S_WAITONTIMER                   0x80010116L
#define RPC_E_CALL_COMPLETE                 0x80010117L
#define RPC_E_UNSECURE_CALL                 0x80010118L
#define RPC_E_TOO_LATE                      0x80010119L
#define RPC_E_NO_GOOD_SECURITY_PACKAGES     0x8001011AL
#define RPC_E_ACCESS_DENIED                 0x8001011BL
#define RPC_E_REMOTE_DISABLED               0x8001011CL
#define RPC_E_INVALID_OBJREF                0x8001011DL
#define RPC_E_NO_CONTEXT                    0x8001011EL
#define RPC_E_TIMEOUT                       0x8001011FL
#define RPC_E_NO_SYNC                       0x80010120L
#define RPC_E_FULLSIC_REQUIRED              0x80010121L
#define RPC_E_INVALID_STD_NAME              0x80010122L
#define CO_E_FAILEDTOIMPERSONATE            0x80010123L
#define CO_E_FAILEDTOGETSECCTX              0x80010124L
#define CO_E_FAILEDTOOPENTHREADTOKEN        0x80010125L
#define CO_E_FAILEDTOGETTOKENINFO           0x80010126L
#define CO_E_TRUSTEEDOESNTMATCHCLIENT       0x80010127L
#define CO_E_FAILEDTOQUERYCLIENTBLANKET     0x80010128L
#define CO_E_FAILEDTOSETDACL                0x80010129L
#define CO_E_ACCESSCHECKFAILED              0x8001012AL
#define CO_E_NETACCESSAPIFAILED             0x8001012BL
#define CO_E_WRONGTRUSTEENAMESYNTAX         0x8001012CL
#define CO_E_INVALIDSID                     0x8001012DL
#define CO_E_CONVERSIONFAILED               0x8001012EL
#define CO_E_NOMATCHINGSIDFOUND             0x8001012FL
#define CO_E_LOOKUPACCSIDFAILED             0x80010130L
#define CO_E_NOMATCHINGNAMEFOUND            0x80010131L
#define CO_E_LOOKUPACCNAMEFAILED            0x80010132L
#define CO_E_SETSERLHNDLFAILED              0x80010133L
#define CO_E_FAILEDTOGETWINDIR              0x80010134L
#define CO_E_PATHTOOLONG                    0x80010135L
#define CO_E_FAILEDTOGENUUID                0x80010136L
#define CO_E_FAILEDTOCREATEFILE             0x80010137L
#define CO_E_FAILEDTOCLOSEHANDLE            0x80010138L
#define CO_E_EXCEEDSYSACLLIMIT              0x80010139L
#define CO_E_ACESINWRONGORDER               0x8001013AL
#define CO_E_INCOMPATIBLESTREAMVERSION      0x8001013BL
#define CO_E_FAILEDTOOPENPROCESSTOKEN       0x8001013CL
#define CO_E_DECODEFAILED                   0x8001013DL
#define CO_E_ACNOTINITIALIZED               0x8001013FL
#define CO_E_CANCEL_DISABLED                0x80010140L
#define RPC_E_UNEXPECTED                    0x8001FFFFL

/* Security error codes */
#define ERROR_AUDITING_DISABLED     0xC0090001L
#define ERROR_ALL_SIDS_FILTERED     0xC0090002L
#define ERROR_BIZRULES_NOT_ENABLED  0xC0090003L

/* SSPI error codes */
#define NTE_BAD_UID                         0x80090001L
#define NTE_BAD_HASH                        0x80090002L
#define NTE_BAD_KEY                         0x80090003L
#define NTE_BAD_LEN                         0x80090004L
#define NTE_BAD_DATA                        0x80090005L
#define NTE_BAD_SIGNATURE                   0x80090006L
#define NTE_BAD_VER                         0x80090007L
#define NTE_BAD_ALGID                       0x80090008L
#define NTE_BAD_FLAGS                       0x80090009L
#define NTE_BAD_TYPE                        0x8009000AL
#define NTE_BAD_KEY_STATE                   0x8009000BL
#define NTE_BAD_HASH_STATE                  0x8009000CL
#define NTE_NO_KEY                          0x8009000DL
#define NTE_NO_MEMORY                       0x8009000EL
#define NTE_EXISTS                          0x8009000FL
#define NTE_PERM                            0x80090010L
#define NTE_NOT_FOUND                       0x80090011L
#define NTE_DOUBLE_ENCRYPT                  0x80090012L
#define NTE_BAD_PROVIDER                    0x80090013L
#define NTE_BAD_PROV_TYPE                   0x80090014L
#define NTE_BAD_PUBLIC_KEY                  0x80090015L
#define NTE_BAD_KEYSET                      0x80090016L
#define NTE_PROV_TYPE_NOT_DEF               0x80090017L
#define NTE_PROV_TYPE_ENTRY_BAD             0x80090018L
#define NTE_KEYSET_NOT_DEF                  0x80090019L
#define NTE_KEYSET_ENTRY_BAD                0x8009001AL
#define NTE_PROV_TYPE_NO_MATCH              0x8009001BL
#define NTE_SIGNATURE_FILE_BAD              0x8009001CL
#define NTE_PROVIDER_DLL_FAIL               0x8009001DL
#define NTE_PROV_DLL_NOT_FOUND              0x8009001EL
#define NTE_BAD_KEYSET_PARAM                0x8009001FL
#define NTE_FAIL                            0x80090020L
#define NTE_SYS_ERR                         0x80090021L
#define NTE_SILENT_CONTEXT                  0x80090022L
#define NTE_TOKEN_KEYSET_STORAGE_FULL       0x80090023L
#define NTE_TEMPORARY_PROFILE               0x80090024L
#define NTE_FIXEDPARAMETER                  0x80090025L
#define NTE_INVALID_HANDLE                  0x80090026L
#define NTE_INVALID_PARAMETER               0x80090027L
#define NTE_BUFFER_TOO_SMALL                0x80090028L
#define NTE_NOT_SUPPORTED                   0x80090029L
#define NTE_NO_MORE_ITEMS                   0x8009002AL
#define NTE_BUFFERS_OVERLAP                 0x8009002BL
#define NTE_DECRYPTION_FAILURE              0x8009002CL
#define NTE_INTERNAL_ERROR                  0x8009002DL
#define NTE_UI_REQUIRED                     0x8009002EL
#define NTE_HMAC_NOT_SUPPORTED              0x8009002FL
#define SEC_E_INSUFFICIENT_MEMORY           0x80090300L
#define SEC_E_INVALID_HANDLE                0x80090301L
#define SEC_E_UNSUPPORTED_FUNCTION          0x80090302L
#define SEC_E_TARGET_UNKNOWN                0x80090303L
#define SEC_E_INTERNAL_ERROR                0x80090304L
#define SEC_E_SECPKG_NOT_FOUND              0x80090305L
#define SEC_E_NOT_OWNER                     0x80090306L
#define SEC_E_CANNOT_INSTALL                0x80090307L
#define SEC_E_INVALID_TOKEN                 0x80090308L
#define SEC_E_CANNOT_PACK                   0x80090309L
#define SEC_E_QOP_NOT_SUPPORTED             0x8009030AL
#define SEC_E_NO_IMPERSONATION              0x8009030BL
#define SEC_E_LOGON_DENIED                  0x8009030CL
#define SEC_E_UNKNOWN_CREDENTIALS           0x8009030DL
#define SEC_E_NO_CREDENTIALS                0x8009030EL
#define SEC_E_MESSAGE_ALTERED               0x8009030FL
#define SEC_E_OUT_OF_SEQUENCE               0x80090310L
#define SEC_E_NO_AUTHENTICATING_AUTHORITY   0x80090311L
#define SEC_I_CONTINUE_NEEDED               0x00090312L
#define SEC_I_COMPLETE_NEEDED               0x00090313L
#define SEC_I_COMPLETE_AND_CONTINUE         0x00090314L
#define SEC_I_LOCAL_LOGON                   0x00090315L
#define SEC_E_BAD_PKGID                     0x80090316L
#define SEC_E_CONTEXT_EXPIRED               0x80090317L
#define SEC_I_CONTEXT_EXPIRED               0x00090317L
#define SEC_E_INCOMPLETE_MESSAGE            0x80090318L
#define SEC_E_INCOMPLETE_CREDENTIALS        0x80090320L
#define SEC_E_BUFFER_TOO_SMALL              0x80090321L
#define SEC_I_INCOMPLETE_CREDENTIALS        0x00090320L
#define SEC_I_RENEGOTIATE                   0x00090321L
#define SEC_E_WRONG_PRINCIPAL               0x80090322L
#define SEC_I_NO_LSA_CONTEXT                0x00090323L
#define SEC_E_TIME_SKEW                     0x80090324L
#define SEC_E_UNTRUSTED_ROOT                0x80090325L
#define SEC_E_ILLEGAL_MESSAGE               0x80090326L
#define SEC_E_CERT_UNKNOWN                  0x80090327L
#define SEC_E_CERT_EXPIRED                  0x80090328L
#define SEC_E_ENCRYPT_FAILURE               0x80090329L
#define SEC_E_DECRYPT_FAILURE               0x80090330L
#define SEC_E_ALGORITHM_MISMATCH            0x80090331L
#define SEC_E_SECURITY_QOS_FAILED           0x80090332L
#define SEC_E_UNFINISHED_CONTEXT_DELETED    0x80090333L
#define SEC_E_NO_TGT_REPLY                  0x80090334L
#define SEC_E_NO_IP_ADDRESSES               0x80090335L
#define SEC_E_WRONG_CREDENTIAL_HANDLE       0x80090336L
#define SEC_E_CRYPTO_SYSTEM_INVALID         0x80090337L
#define SEC_E_MAX_REFERRALS_EXCEEDED        0x80090338L
#define SEC_E_MUST_BE_KDC                   0x80090339L
#define SEC_E_STRONG_CRYPTO_NOT_SUPPORTED   0x8009033AL
#define SEC_E_TOO_MANY_PRINCIPALS           0x8009033BL
#define SEC_E_NO_PA_DATA                    0x8009033CL
#define SEC_E_PKINIT_NAME_MISMATCH          0x8009033DL
#define SEC_E_SMARTCARD_LOGON_REQUIRED      0x8009033EL
#define SEC_E_SHUTDOWN_IN_PROGRESS          0x8009033FL
#define SEC_E_KDC_INVALID_REQUEST           0x80090340L
#define SEC_E_KDC_UNABLE_TO_REFER           0x80090341L
#define SEC_E_KDC_UNKNOWN_ETYPE             0x80090342L
#define SEC_E_UNSUPPORTED_PREAUTH           0x80090343L
#define SEC_E_DELEGATION_REQUIRED           0x80090345L
#define SEC_E_BAD_BINDINGS                  0x80090346L
#define SEC_E_MULTIPLE_ACCOUNTS             0x80090347L
#define SEC_E_NO_KERB_KEY                   0x80090348L
#define SEC_E_CERT_WRONG_USAGE              0x80090349L
#define SEC_E_DOWNGRADE_DETECTED            0x80090350L
#define SEC_E_SMARTCARD_CERT_REVOKED        0x80090351L
#define SEC_E_ISSUING_CA_UNTRUSTED          0x80090352L
#define SEC_E_REVOCATION_OFFLINE_C          0x80090353L
#define SEC_E_PKINIT_CLIENT_FAILURE         0x80090354L
#define SEC_E_SMARTCARD_CERT_EXPIRED        0x80090355L
#define SEC_E_NO_S4U_PROT_SUPPORT           0x80090356L
#define SEC_E_CROSSREALM_DELEGATION_FAILURE 0x80090357L
#define SEC_E_REVOCATION_OFFLINE_KDC        0x80090358L
#define SEC_E_ISSUING_CA_UNTRUSTED_KDC      0x80090359L
#define SEC_E_KDC_CERT_EXPIRED              0x8009035AL
#define SEC_E_KDC_CERT_REVOKED              0x8009035BL
#define SEC_I_SIGNATURE_NEEDED              0x0009035CL
#define SEC_E_INVALID_PARAMETER             0x8009035DL
#define SEC_E_DELEGATION_POLICY             0x8009035EL
#define SEC_E_POLICY_NTLM_ONLY              0x8009035FL
#define SEC_I_NO_RENEGOTIATION              0x00090360L
#define SEC_E_NO_CONTEXT                    0x80090361L
#define SEC_E_PKU2U_CERT_FAILURE            0x80090362L
#define SEC_E_MUTUAL_AUTH_FAILED            0x80090363L
#define SEC_E_NO_SPM                        SEC_E_INTERNAL_ERROR
#define SEC_E_NOT_SUPPORTED                 SEC_E_UNSUPPORTED_FUNCTION

/* Cryptography error codes */
#define CRYPT_E_MSG_ERROR                   0x80091001L
#define CRYPT_E_UNKNOWN_ALGO                0x80091002L
#define CRYPT_E_OID_FORMAT                  0x80091003L
#define CRYPT_E_INVALID_MSG_TYPE            0x80091004L
#define CRYPT_E_UNEXPECTED_ENCODING         0x80091005L
#define CRYPT_E_AUTH_ATTR_MISSING           0x80091006L
#define CRYPT_E_HASH_VALUE                  0x80091007L
#define CRYPT_E_INVALID_INDEX               0x80091008L
#define CRYPT_E_ALREADY_DECRYPTED           0x80091009L
#define CRYPT_E_NOT_DECRYPTED               0x8009100AL
#define CRYPT_E_RECIPIENT_NOT_FOUND         0x8009100BL
#define CRYPT_E_CONTROL_TYPE                0x8009100CL
#define CRYPT_E_ISSUER_SERIALNUMBER         0x8009100DL
#define CRYPT_E_SIGNER_NOT_FOUND            0x8009100EL
#define CRYPT_E_ATTRIBUTES_MISSING          0x8009100FL
#define CRYPT_E_STREAM_MSG_NOT_READY        0x80091010L
#define CRYPT_E_STREAM_INSUFFICIENT_DATA    0x80091011L
#define CRYPT_I_NEW_PROTECTION_REQUIRED     0x80091012L
#define CRYPT_E_BAD_LEN                     0x80092001L
#define CRYPT_E_BAD_ENCODE                  0x80092002L
#define CRYPT_E_FILE_ERROR                  0x80092003L
#define CRYPT_E_NOT_FOUND                   0x80092004L
#define CRYPT_E_EXISTS                      0x80092005L
#define CRYPT_E_NO_PROVIDER                 0x80092006L
#define CRYPT_E_SELF_SIGNED                 0x80092007L
#define CRYPT_E_DELETED_PREV                0x80092008L
#define CRYPT_E_NO_MATCH                    0x80092009L
#define CRYPT_E_UNEXPECTED_MSG_TYPE         0x8009200AL
#define CRYPT_E_NO_KEY_PROPERTY             0x8009200BL
#define CRYPT_E_NO_DECRYPT_CERT             0x8009200CL
#define CRYPT_E_BAD_MSG                     0x8009200DL
#define CRYPT_E_NO_SIGNER                   0x8009200EL
#define CRYPT_E_PENDING_CLOSE               0x8009200FL
#define CRYPT_E_REVOKED                     0x80092010L
#define CRYPT_E_NO_REVOCATION_DLL           0x80092011L
#define CRYPT_E_NO_REVOCATION_CHECK         0x80092012L
#define CRYPT_E_NO_REVOCATION_OFFLINE       0x80092013L
#define CRYPT_E_NOT_IN_REVOCATION_DATABASE  0x80092014L
#define CRYPT_E_INVALID_NUMERIC_STRING      0x80092020L
#define CRYPT_E_INVALID_PRINTABLE_STRING    0x80092021L
#define CRYPT_E_INVALID_IA5_STRING          0x80092022L
#define CRYPT_E_INVALID_X500_STRING         0x80092023L
#define CRYPT_E_NOT_CHAR_STRING             0x80092024L
#define CRYPT_E_FILERESIZED                 0x80092025L
#define CRYPT_E_SECURITY_SETTINGS           0x80092026L
#define CRYPT_E_NO_VERIFY_USAGE_DLL         0x80092027L
#define CRYPT_E_NO_VERIFY_USAGE_CHECK       0x80092028L
#define CRYPT_E_NO_VERIFY_USAGE_OFFLINE     0x80092029L
#define CRYPT_E_NOT_IN_CTL                  0x8009202AL
#define CRYPT_E_NO_TRUSTED_SIGNER           0x8009202BL
#define CRYPT_E_MISSING_PUBKEY_PARA         0x8009202CL
#define CRYPT_E_OSS_ERROR                   0x80093000L
#define OSS_MORE_BUF                        0x80093001L
#define OSS_NEGATIVE_UINTEGER               0x80093002L
#define OSS_PDU_RANGE                       0x80093003L
#define OSS_MORE_INPUT                      0x80093004L
#define OSS_DATA_ERROR                      0x80093005L
#define OSS_BAD_ARG                         0x80093006L
#define OSS_BAD_VERSION                     0x80093007L
#define OSS_OUT_MEMORY                      0x80093008L
#define OSS_PDU_MISMATCH                    0x80093009L
#define OSS_LIMITED                         0x8009300AL
#define OSS_BAD_PTR                         0x8009300BL
#define OSS_BAD_TIME                        0x8009300CL
#define OSS_INDEFINITE_NOT_SUPPORTED        0x8009300DL
#define OSS_MEM_ERROR                       0x8009300EL
#define OSS_BAD_TABLE                       0x8009300FL
#define OSS_TOO_LONG                        0x80093010L
#define OSS_CONSTRAINT_VIOLATED             0x80093011L
#define OSS_FATAL_ERROR                     0x80093012L
#define OSS_ACCESS_SERIALIZATION_ERROR      0x80093013L
#define OSS_NULL_TBL                        0x80093014L
#define OSS_NULL_FCN                        0x80093015L
#define OSS_BAD_ENCRULES                    0x80093016L
#define OSS_UNAVAIL_ENCRULES                0x80093017L
#define OSS_CANT_OPEN_TRACE_WINDOW          0x80093018L
#define OSS_UNIMPLEMENTED                   0x80093019L
#define OSS_OID_DLL_NOT_LINKED              0x8009301AL
#define OSS_CANT_OPEN_TRACE_FILE            0x8009301BL
#define OSS_TRACE_FILE_ALREADY_OPEN         0x8009301CL
#define OSS_TABLE_MISMATCH                  0x8009301DL
#define OSS_TYPE_NOT_SUPPORTED              0x8009301EL
#define OSS_REAL_DLL_NOT_LINKED             0x8009301FL
#define OSS_REAL_CODE_NOT_LINKED            0x80093020L
#define OSS_OUT_OF_RANGE                    0x80093021L
#define OSS_COPIER_DLL_NOT_LINKED           0x80093022L
#define OSS_CONSTRAINT_DLL_NOT_LINKED       0x80093023L
#define OSS_COMPARATOR_DLL_NOT_LINKED       0x80093024L
#define OSS_COMPARATOR_CODE_NOT_LINKED      0x80093025L
#define OSS_MEM_MGR_DLL_NOT_LINKED          0x80093026L
#define OSS_PDV_DLL_NOT_LINKED              0x80093027L
#define OSS_PDV_CODE_NOT_LINKED             0x80093028L
#define OSS_API_DLL_NOT_LINKED              0x80093029L
#define OSS_BERDER_DLL_NOT_LINKED           0x8009302AL
#define OSS_PER_DLL_NOT_LINKED              0x8009302BL
#define OSS_OPEN_TYPE_ERROR                 0x8009302CL
#define OSS_MUTEX_NOT_CREATED               0x8009302DL
#define OSS_CANT_CLOSE_TRACE_FILE           0x8009302EL
#define CRYPT_E_ASN1_ERROR                  0x80093100L
#define CRYPT_E_ASN1_INTERNAL               0x80093101L
#define CRYPT_E_ASN1_EOD                    0x80093102L
#define CRYPT_E_ASN1_CORRUPT                0x80093103L
#define CRYPT_E_ASN1_LARGE                  0x80093104L
#define CRYPT_E_ASN1_CONSTRAINT             0x80093105L
#define CRYPT_E_ASN1_MEMORY                 0x80093106L
#define CRYPT_E_ASN1_OVERFLOW               0x80093107L
#define CRYPT_E_ASN1_BADPDU                 0x80093108L
#define CRYPT_E_ASN1_BADARGS                0x80093109L
#define CRYPT_E_ASN1_BADREAL                0x8009310AL
#define CRYPT_E_ASN1_BADTAG                 0x8009310BL
#define CRYPT_E_ASN1_CHOICE                 0x8009310CL
#define CRYPT_E_ASN1_RULE                   0x8009310DL
#define CRYPT_E_ASN1_UTF8                   0x8009310EL
#define CRYPT_E_ASN1_PDU_TYPE               0x80093133L
#define CRYPT_E_ASN1_NYI                    0x80093134L
#define CRYPT_E_ASN1_EXTENDED               0x80093201L
#define CRYPT_E_ASN1_NOEOD                  0x80093202L

/* Certificate server error codes */
#define CERTSRV_E_BAD_REQUESTSUBJECT                0x80094001L
#define CERTSRV_E_NO_REQUEST                        0x80094002L
#define CERTSRV_E_BAD_REQUESTSTATUS                 0x80094003L
#define CERTSRV_E_PROPERTY_EMPTY                    0x80094004L
#define CERTSRV_E_INVALID_CA_CERTIFICATE            0x80094005L
#define CERTSRV_E_SERVER_SUSPENDED                  0x80094006L
#define CERTSRV_E_ENCODING_LENGTH                   0x80094007L
#define CERTSRV_E_ROLECONFLICT                      0x80094008L
#define CERTSRV_E_RESTRICTEDOFFICER                 0x80094009L
#define CERTSRV_E_KEY_ARCHIVAL_NOT_CONFIGURED       0x8009400AL
#define CERTSRV_E_NO_VALID_KRA                      0x8009400BL
#define CERTSRV_E_BAD_REQUEST_KEY_ARCHIVAL          0x8009400CL
#define CERTSRV_E_NO_CAADMIN_DEFINED                0x8009400DL
#define CERTSRV_E_BAD_RENEWAL_CERT_ATTRIBUTE        0x8009400EL
#define CERTSRV_E_NO_DB_SESSIONS                    0x8009400FL
#define CERTSRV_E_ALIGNMENT_FAULT                   0x80094010L
#define CERTSRV_E_ENROLL_DENIED                     0x80094011L
#define CERTSRV_E_TEMPLATE_DENIED                   0x80094012L
#define CERTSRV_E_DOWNLEVEL_DC_SSL_OR_UPGRADE       0x80094013L
#define CERTSRV_E_ADMIN_DENIED_REQUEST              0x80094014L
#define CERTSRV_E_NO_POLICY_SERVER                  0x80094015L
#define CERTSRV_E_UNSUPPORTED_CERT_TYPE             0x80094800L
#define CERTSRV_E_NO_CERT_TYPE                      0x80094801L
#define CERTSRV_E_TEMPLATE_CONFLICT                 0x80094802L
#define CERTSRV_E_SUBJECT_ALT_NAME_REQUIRED         0x80094803L
#define CERTSRV_E_ARCHIVED_KEY_REQUIRED             0x80094804L
#define CERTSRV_E_SMIME_REQUIRED                    0x80094805L
#define CERTSRV_E_BAD_RENEWAL_SUBJECT               0x80094806L
#define CERTSRV_E_BAD_TEMPLATE_VERSION              0x80094807L
#define CERTSRV_E_TEMPLATE_POLICY_REQUIRED          0x80094808L
#define CERTSRV_E_SIGNATURE_POLICY_REQUIRED         0x80094809L
#define CERTSRV_E_SIGNATURE_COUNT                   0x8009480AL
#define CERTSRV_E_SIGNATURE_REJECTED                0x8009480BL
#define CERTSRV_E_ISSUANCE_POLICY_REQUIRED          0x8009480CL
#define CERTSRV_E_SUBJECT_UPN_REQUIRED              0x8009480DL
#define CERTSRV_E_SUBJECT_DIRECTORY_GUID_REQUIRED   0x8009480EL
#define CERTSRV_E_SUBJECT_DNS_REQUIRED              0x8009480FL
#define CERTSRV_E_ARCHIVED_KEY_UNEXPECTED           0x80094810L
#define CERTSRV_E_KEY_LENGTH                        0x80094811L
#define CERTSRV_E_SUBJECT_EMAIL_REQUIRED            0x80094812L
#define CERTSRV_E_UNKNOWN_CERT_TYPE                 0x80094813L
#define CERTSRV_E_CERT_TYPE_OVERLAP                 0x80094814L
#define CERTSRV_E_TOO_MANY_SIGNATURES               0x80094815L

/* Xenroll error codes */
#define XENROLL_E_KEY_NOT_EXPORTABLE            0x80095000L
#define XENROLL_E_CANNOT_ADD_ROOT_CERT          0x80095001L
#define XENROLL_E_RESPONSE_KA_HASH_NOT_FOUND    0x80095002L
#define XENROLL_E_RESPONSE_UNEXPECTED_KA_HASH   0x80095003L
#define XENROLL_E_RESPONSE_KA_HASH_MISMATCH     0x80095004L
#define XENROLL_E_KEYSPEC_SMIME_MISMATCH        0x80095005L

/* Trust error codes */
#define TRUST_E_SYSTEM_ERROR        0x80096001L
#define TRUST_E_NO_SIGNER_CERT      0x80096002L
#define TRUST_E_COUNTER_SIGNER      0x80096003L
#define TRUST_E_CERT_SIGNATURE      0x80096004L
#define TRUST_E_TIME_STAMP          0x80096005L
#define TRUST_E_BAD_DIGEST          0x80096010L
#define TRUST_E_BAD_CONSTRAINTS     0x80096019L
#define TRUST_E_FINANCIAL_CRITERIA  0x8009601EL

/* MSSIPOTF.DLL error codes */
#define MSSIPOTF_E_OUTOFMEMRANGE                0x80097001L
#define MSSIPOTF_E_CANTGETOBJECT                0x80097002L
#define MSSIPOTF_E_NOHEADTABLE                  0x80097003L
#define MSSIPOTF_E_BAD_MAGICNUMBER              0x80097004L
#define MSSIPOTF_E_BAD_OFFSET_TABLE             0x80097005L
#define MSSIPOTF_E_TABLE_TAGORDER               0x80097006L
#define MSSIPOTF_E_TABLE_LONGWORD               0x80097007L
#define MSSIPOTF_E_BAD_FIRST_TABLE_PLACEMENT    0x80097008L
#define MSSIPOTF_E_TABLES_OVERLAP               0x80097009L
#define MSSIPOTF_E_TABLE_PADBYTES               0x8009700AL
#define MSSIPOTF_E_FILETOOSMALL                 0x8009700BL
#define MSSIPOTF_E_TABLE_CHECKSUM               0x8009700CL
#define MSSIPOTF_E_FILE_CHECKSUM                0x8009700DL
#define MSSIPOTF_E_FAILED_POLICY                0x80097010L
#define MSSIPOTF_E_FAILED_HINTS_CHECKED         0x80097011L
#define MSSIPOTF_E_NOT_OPENTYPE                 0x80097012L
#define MSSIPOTF_E_FILE                         0x80097013L
#define MSSIPOTF_E_CRYPT                        0x80097014L
#define MSSIPOTF_E_BADVERSION                   0x80097015L
#define MSSIPOTF_E_DSIG_SIGNATURE               0x80097016L
#define MSSIPOTF_E_PCONST_CHECK                 0x80097017L
#define MSSIPOTF_E_STRUCTURE                    0x80097018L
#define ERROR_CRED_REQUIRES_CONFIRMATION        0x80097019L

/* Certificate error codes */
#define TRUST_E_PROVIDER_UNKNOWN        0x800B0001L
#define TRUST_E_ACTION_UNKNOWN          0x800B0002L
#define TRUST_E_SUBJECT_FORM_UNKNOWN    0x800B0003L
#define TRUST_E_SUBJECT_NOT_TRUSTED     0x800B0004L
#define DIGSIG_E_ENCODE                 0x800B0005L
#define DIGSIG_E_DECODE                 0x800B0006L
#define DIGSIG_E_EXTENSIBILITY          0x800B0007L
#define DIGSIG_E_CRYPTO                 0x800B0008L
#define PERSIST_E_SIZEDEFINITE          0x800B0009L
#define PERSIST_E_SIZEINDEFINITE        0x800B000AL
#define PERSIST_E_NOTSELFSIZING         0x800B000BL
#define TRUST_E_NOSIGNATURE             0x800B0100L
#define CERT_E_EXPIRED                  0x800B0101L
#define CERT_E_VALIDITYPERIODNESTING    0x800B0102L
#define CERT_E_ROLE                     0x800B0103L
#define CERT_E_PATHLENCONST             0x800B0104L
#define CERT_E_CRITICAL                 0x800B0105L
#define CERT_E_PURPOSE                  0x800B0106L
#define CERT_E_ISSUERCHAINING           0x800B0107L
#define CERT_E_MALFORMED                0x800B0108L
#define CERT_E_UNTRUSTEDROOT            0x800B0109L
#define CERT_E_CHAINING                 0x800B010AL
#define TRUST_E_FAIL                    0x800B010BL
#define CERT_E_REVOKED                  0x800B010CL
#define CERT_E_UNTRUSTEDTESTROOT        0x800B010DL
#define CERT_E_REVOCATION_FAILURE       0x800B010EL
#define CERT_E_CN_NO_MATCH              0x800B010FL
#define CERT_E_WRONG_USAGE              0x800B0110L
#define TRUST_E_EXPLICIT_DISTRUST       0x800B0111L
#define CERT_E_UNTRUSTEDCA              0x800B0112L
#define CERT_E_INVALID_POLICY           0x800B0113L
#define CERT_E_INVALID_NAME             0x800B0114L

/* Setup API error codes */
#define SPAPI_E_EXPECTED_SECTION_NAME               0x800F0000L
#define SPAPI_E_BAD_SECTION_NAME_LINE               0x800F0001L
#define SPAPI_E_SECTION_NAME_TOO_LONG               0x800F0002L
#define SPAPI_E_GENERAL_SYNTAX                      0x800F0003L
#define SPAPI_E_WRONG_INF_STYLE                     0x800F0100L
#define SPAPI_E_SECTION_NOT_FOUND                   0x800F0101L
#define SPAPI_E_LINE_NOT_FOUND                      0x800F0102L
#define SPAPI_E_NO_BACKUP                           0x800F0103L
#define SPAPI_E_NO_ASSOCIATED_CLASS                 0x800F0200L
#define SPAPI_E_CLASS_MISMATCH                      0x800F0201L
#define SPAPI_E_DUPLICATE_FOUND                     0x800F0202L
#define SPAPI_E_NO_DRIVER_SELECTED                  0x800F0203L
#define SPAPI_E_KEY_DOES_NOT_EXIST                  0x800F0204L
#define SPAPI_E_INVALID_DEVINST_NAME                0x800F0205L
#define SPAPI_E_INVALID_CLASS                       0x800F0206L
#define SPAPI_E_DEVINST_ALREADY_EXISTS              0x800F0207L
#define SPAPI_E_DEVINFO_NOT_REGISTERED              0x800F0208L
#define SPAPI_E_INVALID_REG_PROPERTY                0x800F0209L
#define SPAPI_E_NO_INF                              0x800F020AL
#define SPAPI_E_NO_SUCH_DEVINST                     0x800F020BL
#define SPAPI_E_CANT_LOAD_CLASS_ICON                0x800F020CL
#define SPAPI_E_INVALID_CLASS_INSTALLER             0x800F020DL
#define SPAPI_E_DI_DO_DEFAULT                       0x800F020EL
#define SPAPI_E_DI_NOFILECOPY                       0x800F020FL
#define SPAPI_E_INVALID_HWPROFILE                   0x800F0210L
#define SPAPI_E_NO_DEVICE_SELECTED                  0x800F0211L
#define SPAPI_E_DEVINFO_LIST_LOCKED                 0x800F0212L
#define SPAPI_E_DEVINFO_DATA_LOCKED                 0x800F0213L
#define SPAPI_E_DI_BAD_PATH                         0x800F0214L
#define SPAPI_E_NO_CLASSINSTALL_PARAMS              0x800F0215L
#define SPAPI_E_FILEQUEUE_LOCKED                    0x800F0216L
#define SPAPI_E_BAD_SERVICE_INSTALLSECT             0x800F0217L
#define SPAPI_E_NO_CLASS_DRIVER_LIST                0x800F0218L
#define SPAPI_E_NO_ASSOCIATED_SERVICE               0x800F0219L
#define SPAPI_E_NO_DEFAULT_DEVICE_INTERFACE         0x800F021AL
#define SPAPI_E_DEVICE_INTERFACE_ACTIVE             0x800F021BL
#define SPAPI_E_DEVICE_INTERFACE_REMOVED            0x800F021CL
#define SPAPI_E_BAD_INTERFACE_INSTALLSECT           0x800F021DL
#define SPAPI_E_NO_SUCH_INTERFACE_CLASS             0x800F021EL
#define SPAPI_E_INVALID_REFERENCE_STRING            0x800F021FL
#define SPAPI_E_INVALID_MACHINENAME                 0x800F0220L
#define SPAPI_E_REMOTE_COMM_FAILURE                 0x800F0221L
#define SPAPI_E_MACHINE_UNAVAILABLE                 0x800F0222L
#define SPAPI_E_NO_CONFIGMGR_SERVICES               0x800F0223L
#define SPAPI_E_INVALID_PROPPAGE_PROVIDER           0x800F0224L
#define SPAPI_E_NO_SUCH_DEVICE_INTERFACE            0x800F0225L
#define SPAPI_E_DI_POSTPROCESSING_REQUIRED          0x800F0226L
#define SPAPI_E_INVALID_COINSTALLER                 0x800F0227L
#define SPAPI_E_NO_COMPAT_DRIVERS                   0x800F0228L
#define SPAPI_E_NO_DEVICE_ICON                      0x800F0229L
#define SPAPI_E_INVALID_INF_LOGCONFIG               0x800F022AL
#define SPAPI_E_DI_DONT_INSTALL                     0x800F022BL
#define SPAPI_E_INVALID_FILTER_DRIVER               0x800F022CL
#define SPAPI_E_NON_WINDOWS_NT_DRIVER               0x800F022DL
#define SPAPI_E_NON_WINDOWS_DRIVER                  0x800F022EL
#define SPAPI_E_NO_CATALOG_FOR_OEM_INF              0x800F022FL
#define SPAPI_E_DEVINSTALL_QUEUE_NONNATIVE          0x800F0230L
#define SPAPI_E_NOT_DISABLEABLE                     0x800F0231L
#define SPAPI_E_CANT_REMOVE_DEVINST                 0x800F0232L
#define SPAPI_E_INVALID_TARGET                      0x800F0233L
#define SPAPI_E_DRIVER_NONNATIVE                    0x800F0234L
#define SPAPI_E_IN_WOW64                            0x800F0235L
#define SPAPI_E_SET_SYSTEM_RESTORE_POINT            0x800F0236L
#define SPAPI_E_INCORRECTLY_COPIED_INF              0x800F0237L
#define SPAPI_E_SCE_DISABLED                        0x800F0238L
#define SPAPI_E_UNKNOWN_EXCEPTION                   0x800F0239L
#define SPAPI_E_PNP_REGISTRY_ERROR                  0x800F023AL
#define SPAPI_E_REMOTE_REQUEST_UNSUPPORTED          0x800F023BL
#define SPAPI_E_NOT_AN_INSTALLED_OEM_INF            0x800F023CL
#define SPAPI_E_INF_IN_USE_BY_DEVICES               0x800F023DL
#define SPAPI_E_DI_FUNCTION_OBSOLETE                0x800F023EL
#define SPAPI_E_NO_AUTHENTICODE_CATALOG             0x800F023FL
#define SPAPI_E_AUTHENTICODE_DISALLOWED             0x800F0240L
#define SPAPI_E_AUTHENTICODE_TRUSTED_PUBLISHER      0x800F0241L
#define SPAPI_E_AUTHENTICODE_TRUST_NOT_ESTABLISHED  0x800F0242L
#define SPAPI_E_AUTHENTICODE_PUBLISHER_NOT_TRUSTED  0x800F0243L
#define SPAPI_E_SIGNATURE_OSATTRIBUTE_MISMATCH      0x800F0244L
#define SPAPI_E_ONLY_VALIDATE_VIA_AUTHENTICODE      0x800F0245L
#define SPAPI_E_DEVICE_INSTALLER_NOT_READY          0x800F0246L
#define SPAPI_E_DRIVER_STORE_ADD_FAILED             0x800F0247L
#define SPAPI_E_DEVICE_INSTALL_BLOCKED              0x800F0248L
#define SPAPI_E_DRIVER_INSTALL_BLOCKED              0x800F0249L
#define SPAPI_E_WRONG_INF_TYPE                      0x800F024AL
#define SPAPI_E_FILE_HASH_NOT_IN_CATALOG            0x800F024BL
#define SPAPI_E_DRIVER_STORE_DELETE_FAILED          0x800F024CL
#define SPAPI_E_UNRECOVERABLE_STACK_OVERFLOW        0x800F0300L
#define SPAPI_E_ERROR_NOT_INSTALLED                 0x800F1000L

/* Smart card error codes */
#define SCARD_S_SUCCESS                 NO_ERROR
#define SCARD_F_INTERNAL_ERROR          0x80100001L
#define SCARD_E_CANCELLED               0x80100002L
#define SCARD_E_INVALID_HANDLE          0x80100003L
#define SCARD_E_INVALID_PARAMETER       0x80100004L
#define SCARD_E_INVALID_TARGET          0x80100005L
#define SCARD_E_NO_MEMORY               0x80100006L
#define SCARD_F_WAITED_TOO_LONG         0x80100007L
#define SCARD_E_INSUFFICIENT_BUFFER     0x80100008L
#define SCARD_E_UNKNOWN_READER          0x80100009L
#define SCARD_E_TIMEOUT                 0x8010000AL
#define SCARD_E_SHARING_VIOLATION       0x8010000BL
#define SCARD_E_NO_SMARTCARD            0x8010000CL
#define SCARD_E_UNKNOWN_CARD            0x8010000DL
#define SCARD_E_CANT_DISPOSE            0x8010000EL
#define SCARD_E_PROTO_MISMATCH          0x8010000FL
#define SCARD_E_NOT_READY               0x80100010L
#define SCARD_E_INVALID_VALUE           0x80100011L
#define SCARD_E_SYSTEM_CANCELLED        0x80100012L
#define SCARD_F_COMM_ERROR              0x80100013L
#define SCARD_F_UNKNOWN_ERROR           0x80100014L
#define SCARD_E_INVALID_ATR             0x80100015L
#define SCARD_E_NOT_TRANSACTED          0x80100016L
#define SCARD_E_READER_UNAVAILABLE      0x80100017L
#define SCARD_P_SHUTDOWN                0x80100018L
#define SCARD_E_PCI_TOO_SMALL           0x80100019L
#define SCARD_E_READER_UNSUPPORTED      0x8010001AL
#define SCARD_E_DUPLICATE_READER        0x8010001BL
#define SCARD_E_CARD_UNSUPPORTED        0x8010001CL
#define SCARD_E_NO_SERVICE              0x8010001DL
#define SCARD_E_SERVICE_STOPPED         0x8010001EL
#define SCARD_E_UNEXPECTED              0x8010001FL
#define SCARD_E_ICC_INSTALLATION        0x80100020L
#define SCARD_E_ICC_CREATEORDER         0x80100021L
#define SCARD_E_UNSUPPORTED_FEATURE     0x80100022L
#define SCARD_E_DIR_NOT_FOUND           0x80100023L
#define SCARD_E_FILE_NOT_FOUND          0x80100024L
#define SCARD_E_NO_DIR                  0x80100025L
#define SCARD_E_NO_FILE                 0x80100026L
#define SCARD_E_NO_ACCESS               0x80100027L
#define SCARD_E_WRITE_TOO_MANY          0x80100028L
#define SCARD_E_BAD_SEEK                0x80100029L
#define SCARD_E_INVALID_CHV             0x8010002AL
#define SCARD_E_UNKNOWN_RES_MNG         0x8010002BL
#define SCARD_E_NO_SUCH_CERTIFICATE     0x8010002CL
#define SCARD_E_CERTIFICATE_UNAVAILABLE 0x8010002DL
#define SCARD_E_NO_READERS_AVAILABLE    0x8010002EL
#define SCARD_E_COMM_DATA_LOST          0x8010002FL
#define SCARD_E_NO_KEY_CONTAINER        0x80100030L
#define SCARD_E_SERVER_TOO_BUSY         0x80100031L
#define SCARD_E_PIN_CACHE_EXPIRED       0x80100032L
#define SCARD_E_NO_PIN_CACHE            0x80100033L
#define SCARD_E_READ_ONLY_CARD          0x80100034L
#define SCARD_W_UNSUPPORTED_CARD        0x80100065L
#define SCARD_W_UNRESPONSIVE_CARD       0x80100066L
#define SCARD_W_UNPOWERED_CARD          0x80100067L
#define SCARD_W_RESET_CARD              0x80100068L
#define SCARD_W_REMOVED_CARD            0x80100069L
#define SCARD_W_SECURITY_VIOLATION      0x8010006AL
#define SCARD_W_WRONG_CHV               0x8010006BL
#define SCARD_W_CHV_BLOCKED             0x8010006CL
#define SCARD_W_EOF                     0x8010006DL
#define SCARD_W_CANCELLED_BY_USER       0x8010006EL
#define SCARD_W_CARD_NOT_AUTHENTICATED  0x8010006FL
#define SCARD_W_CACHE_ITEM_NOT_FOUND    0x80100070L
#define SCARD_W_CACHE_ITEM_STALE        0x80100071L
#define SCARD_W_CACHE_ITEM_TOO_BIG      0x80100072L

/* COM+ error codes */
#define COMADMIN_E_OBJECTERRORS                                     0x80110401L
#define COMADMIN_E_OBJECTINVALID                                    0x80110402L
#define COMADMIN_E_KEYMISSING                                       0x80110403L
#define COMADMIN_E_ALREADYINSTALLED                                 0x80110404L
#define COMADMIN_E_APP_FILE_WRITEFAIL                               0x80110407L
#define COMADMIN_E_APP_FILE_READFAIL                                0x80110408L
#define COMADMIN_E_APP_FILE_VERSION                                 0x80110409L
#define COMADMIN_E_BADPATH                                          0x8011040AL
#define COMADMIN_E_APPLICATIONEXISTS                                0x8011040BL
#define COMADMIN_E_ROLEEXISTS                                       0x8011040CL
#define COMADMIN_E_CANTCOPYFILE                                     0x8011040DL
#define COMADMIN_E_NOUSER                                           0x8011040FL
#define COMADMIN_E_INVALIDUSERIDS                                   0x80110410L
#define COMADMIN_E_NOREGISTRYCLSID                                  0x80110411L
#define COMADMIN_E_BADREGISTRYPROGID                                0x80110412L
#define COMADMIN_E_AUTHENTICATIONLEVEL                              0x80110413L
#define COMADMIN_E_USERPASSWDNOTVALID                               0x80110414L
#define COMADMIN_E_CLSIDORIIDMISMATCH                               0x80110418L
#define COMADMIN_E_REMOTEINTERFACE                                  0x80110419L
#define COMADMIN_E_DLLREGISTERSERVER                                0x8011041AL
#define COMADMIN_E_NOSERVERSHARE                                    0x8011041BL
#define COMADMIN_E_DLLLOADFAILED                                    0x8011041DL
#define COMADMIN_E_BADREGISTRYLIBID                                 0x8011041EL
#define COMADMIN_E_APPDIRNOTFOUND                                   0x8011041FL
#define COMADMIN_E_REGISTRARFAILED                                  0x80110423L
#define COMADMIN_E_COMPFILE_DOESNOTEXIST                            0x80110424L
#define COMADMIN_E_COMPFILE_LOADDLLFAIL                             0x80110425L
#define COMADMIN_E_COMPFILE_GETCLASSOBJ                             0x80110426L
#define COMADMIN_E_COMPFILE_CLASSNOTAVAIL                           0x80110427L
#define COMADMIN_E_COMPFILE_BADTLB                                  0x80110428L
#define COMADMIN_E_COMPFILE_NOTINSTALLABLE                          0x80110429L
#define COMADMIN_E_NOTCHANGEABLE                                    0x8011042AL
#define COMADMIN_E_NOTDELETEABLE                                    0x8011042BL
#define COMADMIN_E_SESSION                                          0x8011042CL
#define COMADMIN_E_COMP_MOVE_LOCKED                                 0x8011042DL
#define COMADMIN_E_COMP_MOVE_BAD_DEST                               0x8011042EL
#define COMADMIN_E_REGISTERTLB                                      0x80110430L
#define COMADMIN_E_SYSTEMAPP                                        0x80110433L
#define COMADMIN_E_COMPFILE_NOREGISTRAR                             0x80110434L
#define COMADMIN_E_COREQCOMPINSTALLED                               0x80110435L
#define COMADMIN_E_SERVICENOTINSTALLED                              0x80110436L
#define COMADMIN_E_PROPERTYSAVEFAILED                               0x80110437L
#define COMADMIN_E_OBJECTEXISTS                                     0x80110438L
#define COMADMIN_E_COMPONENTEXISTS                                  0x80110439L
#define COMADMIN_E_REGFILE_CORRUPT                                  0x8011043BL
#define COMADMIN_E_PROPERTY_OVERFLOW                                0x8011043CL
#define COMADMIN_E_NOTINREGISTRY                                    0x8011043EL
#define COMADMIN_E_OBJECTNOTPOOLABLE                                0x8011043FL
#define COMADMIN_E_APPLID_MATCHES_CLSID                             0x80110446L
#define COMADMIN_E_ROLE_DOES_NOT_EXIST                              0x80110447L
#define COMADMIN_E_START_APP_NEEDS_COMPONENTS                       0x80110448L
#define COMADMIN_E_REQUIRES_DIFFERENT_PLATFORM                      0x80110449L
#define COMADMIN_E_CAN_NOT_EXPORT_APP_PROXY                         0x8011044AL
#define COMADMIN_E_CAN_NOT_START_APP                                0x8011044BL
#define COMADMIN_E_CAN_NOT_EXPORT_SYS_APP                           0x8011044CL
#define COMADMIN_E_CANT_SUBSCRIBE_TO_COMPONENT                      0x8011044DL
#define COMADMIN_E_EVENTCLASS_CANT_BE_SUBSCRIBER                    0x8011044EL
#define COMADMIN_E_LIB_APP_PROXY_INCOMPATIBLE                       0x8011044FL
#define COMADMIN_E_BASE_PARTITION_ONLY                              0x80110450L
#define COMADMIN_E_START_APP_DISABLED                               0x80110451L
#define COMADMIN_E_CAT_DUPLICATE_PARTITION_NAME                     0x80110457L
#define COMADMIN_E_CAT_INVALID_PARTITION_NAME                       0x80110458L
#define COMADMIN_E_CAT_PARTITION_IN_USE                             0x80110459L
#define COMADMIN_E_FILE_PARTITION_DUPLICATE_FILES                   0x8011045AL
#define COMADMIN_E_CAT_IMPORTED_COMPONENTS_NOT_ALLOWED              0x8011045BL
#define COMADMIN_E_AMBIGUOUS_APPLICATION_NAME                       0x8011045CL
#define COMADMIN_E_AMBIGUOUS_PARTITION_NAME                         0x8011045DL
#define COMADMIN_E_REGDB_NOTINITIALIZED                             0x80110472L
#define COMADMIN_E_REGDB_NOTOPEN                                    0x80110473L
#define COMADMIN_E_REGDB_SYSTEMERR                                  0x80110474L
#define COMADMIN_E_REGDB_ALREADYRUNNING                             0x80110475L
#define COMADMIN_E_MIG_VERSIONNOTSUPPORTED                          0x80110480L
#define COMADMIN_E_MIG_SCHEMANOTFOUND                               0x80110481L
#define COMADMIN_E_CAT_BITNESSMISMATCH                              0x80110482L
#define COMADMIN_E_CAT_UNACCEPTABLEBITNESS                          0x80110483L
#define COMADMIN_E_CAT_WRONGAPPBITNESS                              0x80110484L
#define COMADMIN_E_CAT_PAUSE_RESUME_NOT_SUPPORTED                   0x80110485L
#define COMADMIN_E_CAT_SERVERFAULT                                  0x80110486L
#define COMQC_E_APPLICATION_NOT_QUEUED                              0x80110600L
#define COMQC_E_NO_QUEUEABLE_INTERFACES                             0x80110601L
#define COMQC_E_QUEUING_SERVICE_NOT_AVAILABLE                       0x80110602L
#define COMQC_E_NO_IPERSISTSTREAM                                   0x80110603L
#define COMQC_E_BAD_MESSAGE                                         0x80110604L
#define COMQC_E_UNAUTHENTICATED                                     0x80110605L
#define COMQC_E_UNTRUSTED_ENQUEUER                                  0x80110606L
#define MSDTC_E_DUPLICATE_RESOURCE                                  0x80110701L
#define COMADMIN_E_OBJECT_PARENT_MISSING                            0x80110808L
#define COMADMIN_E_OBJECT_DOES_NOT_EXIST                            0x80110809L
#define COMADMIN_E_APP_NOT_RUNNING                                  0x8011080AL
#define COMADMIN_E_INVALID_PARTITION                                0x8011080BL
#define COMADMIN_E_SVCAPP_NOT_POOLABLE_OR_RECYCLABLE                0x8011080DL
#define COMADMIN_E_USER_IN_SET                                      0x8011080EL
#define COMADMIN_E_CANTRECYCLELIBRARYAPPS                           0x8011080FL
#define COMADMIN_E_CANTRECYCLESERVICEAPPS                           0x80110811L
#define COMADMIN_E_PROCESSALREADYRECYCLED                           0x80110812L
#define COMADMIN_E_PAUSEDPROCESSMAYNOTBERECYCLED                    0x80110813L
#define COMADMIN_E_CANTMAKEINPROCSERVICE                            0x80110814L
#define COMADMIN_E_PROGIDINUSEBYCLSID                               0x80110815L
#define COMADMIN_E_DEFAULT_PARTITION_NOT_IN_SET                     0x80110816L
#define COMADMIN_E_RECYCLEDPROCESSMAYNOTBEPAUSED                    0x80110817L
#define COMADMIN_E_PARTITION_ACCESSDENIED                           0x80110818L
#define COMADMIN_E_PARTITION_MSI_ONLY                               0x80110819L
#define COMADMIN_E_LEGACYCOMPS_NOT_ALLOWED_IN_1_0_FORMAT            0x8011081AL
#define COMADMIN_E_LEGACYCOMPS_NOT_ALLOWED_IN_NONBASE_PARTITIONS    0x8011081BL
#define COMADMIN_E_COMP_MOVE_SOURCE                                 0x8011081CL
#define COMADMIN_E_COMP_MOVE_DEST                                   0x8011081DL
#define COMADMIN_E_COMP_MOVE_PRIVATE                                0x8011081EL
#define COMADMIN_E_BASEPARTITION_REQUIRED_IN_SET                    0x8011081FL
#define COMADMIN_E_CANNOT_ALIAS_EVENTCLASS                          0x80110820L
#define COMADMIN_E_PRIVATE_ACCESSDENIED                             0x80110821L
#define COMADMIN_E_SAFERINVALID                                     0x80110822L
#define COMADMIN_E_REGISTRY_ACCESSDENIED                            0x80110823L
#define COMADMIN_E_PARTITIONS_DISABLED                              0x80110824L

/* User mode filter manager error codes */
#define ERROR_FLT_IO_COMPLETE                   0x001F0001L
#define ERROR_FLT_NO_HANDLER_DEFINED            0x801F0001L
#define ERROR_FLT_CONTEXT_ALREADY_DEFINED       0x801F0002L
#define ERROR_FLT_INVALID_ASYNCHRONOUS_REQUEST  0x801F0003L
#define ERROR_FLT_DISALLOW_FAST_IO              0x801F0004L
#define ERROR_FLT_INVALID_NAME_REQUEST          0x801F0005L
#define ERROR_FLT_NOT_SAFE_TO_POST_OPERATION    0x801F0006L
#define ERROR_FLT_NOT_INITIALIZED               0x801F0007L
#define ERROR_FLT_FILTER_NOT_READY              0x801F0008L
#define ERROR_FLT_POST_OPERATION_CLEANUP        0x801F0009L
#define ERROR_FLT_INTERNAL_ERROR                0x801F000AL
#define ERROR_FLT_DELETING_OBJECT               0x801F000BL
#define ERROR_FLT_MUST_BE_NONPAGED_POOL         0x801F000CL
#define ERROR_FLT_DUPLICATE_ENTRY               0x801F000DL
#define ERROR_FLT_CBDQ_DISABLED                 0x801F000EL
#define ERROR_FLT_DO_NOT_ATTACH                 0x801F000FL
#define ERROR_FLT_DO_NOT_DETACH                 0x801F0010L
#define ERROR_FLT_INSTANCE_ALTITUDE_COLLISION   0x801F0011L
#define ERROR_FLT_INSTANCE_NAME_COLLISION       0x801F0012L
#define ERROR_FLT_FILTER_NOT_FOUND              0x801F0013L
#define ERROR_FLT_VOLUME_NOT_FOUND              0x801F0014L
#define ERROR_FLT_INSTANCE_NOT_FOUND            0x801F0015L
#define ERROR_FLT_CONTEXT_ALLOCATION_NOT_FOUND  0x801F0016L
#define ERROR_FLT_INVALID_CONTEXT_REGISTRATION  0x801F0017L
#define ERROR_FLT_NAME_CACHE_MISS               0x801F0018L
#define ERROR_FLT_NO_DEVICE_OBJECT              0x801F0019L
#define ERROR_FLT_VOLUME_ALREADY_MOUNTED        0x801F001AL
#define ERROR_FLT_ALREADY_ENLISTED              0x801F001BL
#define ERROR_FLT_CONTEXT_ALREADY_LINKED        0x801F001CL
#define ERROR_FLT_NO_WAITER_FOR_REPLY           0x801F0020L

/* Display Driver Loader and Video Port error codes */
#define ERROR_HUNG_DISPLAY_DRIVER_THREAD    0x80260001L

/* Desktop Window Manager error codes */
#define DWM_E_COMPOSITIONDISABLED               0x80263001L
#define DWM_E_REMOTING_NOT_SUPPORTED            0x80263002L
#define DWM_E_NO_REDIRECTION_SURFACE_AVAILABLE  0x80263003L
#define DWM_E_NOT_QUEUING_PRESENTS              0x80263004L
#define DWM_E_ADAPTER_NOT_FOUND                 0x80263005L
#define DWM_S_GDI_REDIRECTION_SURFACE           0x00263005L

/* Monitor driver error codes */
#define ERROR_MONITOR_NO_DESCRIPTOR                         0x80261001L
#define ERROR_MONITOR_UNKNOWN_DESCRIPTOR_FORMAT             0x80261002L
#define ERROR_MONITOR_INVALID_DESCRIPTOR_CHECKSUM           0xC0261003L
#define ERROR_MONITOR_INVALID_STANDARD_TIMING_BLOCK         0xC0261004L
#define ERROR_MONITOR_WMI_DATABLOCK_REGISTRATION_FAILED     0xC0261005L
#define ERROR_MONITOR_INVALID_SERIAL_NUMBER_MONDSC_BLOCK    0xC0261006L
#define ERROR_MONITOR_INVALID_USER_FRIENDLY_MONDSC_BLOCK    0xC0261007L
#define ERROR_MONITOR_NO_MORE_DESCRIPTOR_DATA               0xC0261008L
#define ERROR_MONITOR_INVALID_DETAILED_TIMING_BLOCK         0xC0261009L
#define ERROR_MONITOR_INVALID_MANUFACTURE_DATE              0xC026100AL

/* Graphics kernel subsystem error codes */
#define ERROR_GRAPHICS_NOT_EXCLUSIVE_MODE_OWNER     0xC0262000L
#define ERROR_GRAPHICS_INSUFFICIENT_DMA_BUFFER      0xC0262001L
#define ERROR_GRAPHICS_INVALID_DISPLAY_ADAPTER      0xC0262002L
#define ERROR_GRAPHICS_ADAPTER_WAS_RESET            0xC0262003L
#define ERROR_GRAPHICS_INVALID_DRIVER_MODEL         0xC0262004L
#define ERROR_GRAPHICS_PRESENT_MODE_CHANGED         0xC0262005L
#define ERROR_GRAPHICS_PRESENT_OCCLUDED             0xC0262006L
#define ERROR_GRAPHICS_PRESENT_DENIED               0xC0262007L
#define ERROR_GRAPHICS_CANNOTCOLORCONVERT           0xC0262008L
#define ERROR_GRAPHICS_DRIVER_MISMATCH              0xC0262009L
#define ERROR_GRAPHICS_PARTIAL_DATA_POPULATED       0x4026200AL
#define ERROR_GRAPHICS_PRESENT_REDIRECTION_DISABLED 0xC026200BL
#define ERROR_GRAPHICS_PRESENT_UNOCCLUDED           0xC026200CL

/* Video Memory Manager error codes */
#define ERROR_GRAPHICS_NO_VIDEO_MEMORY                  0xC0262100L
#define ERROR_GRAPHICS_CANT_LOCK_MEMORY                 0xC0262101L
#define ERROR_GRAPHICS_ALLOCATION_BUSY                  0xC0262102L
#define ERROR_GRAPHICS_TOO_MANY_REFERENCES              0xC0262103L
#define ERROR_GRAPHICS_TRY_AGAIN_LATER                  0xC0262104L
#define ERROR_GRAPHICS_TRY_AGAIN_NOW                    0xC0262105L
#define ERROR_GRAPHICS_ALLOCATION_INVALID               0xC0262106L
#define ERROR_GRAPHICS_UNSWIZZLING_APERTURE_UNAVAILABLE 0xC0262107L
#define ERROR_GRAPHICS_UNSWIZZLING_APERTURE_UNSUPPORTED 0xC0262108L
#define ERROR_GRAPHICS_CANT_EVICT_PINNED_ALLOCATION     0xC0262109L
#define ERROR_GRAPHICS_INVALID_ALLOCATION_USAGE         0xC0262110L
#define ERROR_GRAPHICS_CANT_RENDER_LOCKED_ALLOCATION    0xC0262111L
#define ERROR_GRAPHICS_ALLOCATION_CLOSED                0xC0262112L
#define ERROR_GRAPHICS_INVALID_ALLOCATION_INSTANCE      0xC0262113L
#define ERROR_GRAPHICS_INVALID_ALLOCATION_HANDLE        0xC0262114L
#define ERROR_GRAPHICS_WRONG_ALLOCATION_DEVICE          0xC0262115L
#define ERROR_GRAPHICS_ALLOCATION_CONTENT_LOST          0xC0262116L

/* Video GPU Scheduler subsystem error codes */
#define ERROR_GRAPHICS_GPU_EXCEPTION_ON_DEVICE  0xC0262200L

/* Video Present Network Manager subsystem error codes */
#define ERROR_GRAPHICS_INVALID_VIDPN_TOPOLOGY                   0xC0262300L
#define ERROR_GRAPHICS_VIDPN_TOPOLOGY_NOT_SUPPORTED             0xC0262301L
#define ERROR_GRAPHICS_VIDPN_TOPOLOGY_CURRENTLY_NOT_SUPPORTED   0xC0262302L
#define ERROR_GRAPHICS_INVALID_VIDPN                            0xC0262303L
#define ERROR_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE             0xC0262304L
#define ERROR_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET             0xC0262305L
#define ERROR_GRAPHICS_VIDPN_MODALITY_NOT_SUPPORTED             0xC0262306L
#define ERROR_GRAPHICS_MODE_NOT_PINNED                          0xC0262307L
#define ERROR_GRAPHICS_INVALID_VIDPN_SOURCEMODESET              0xC0262308L
#define ERROR_GRAPHICS_INVALID_VIDPN_TARGETMODESET              0xC0262309L
#define ERROR_GRAPHICS_INVALID_FREQUENCY                        0xC026230AL
#define ERROR_GRAPHICS_INVALID_ACTIVE_REGION                    0xC026230BL
#define ERROR_GRAPHICS_INVALID_TOTAL_REGION                     0xC026230CL
#define ERROR_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE_MODE        0xC0262310L
#define ERROR_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET_MODE        0xC0262311L
#define ERROR_GRAPHICS_PINNED_MODE_MUST_REMAIN_IN_SET           0xC0262312L
#define ERROR_GRAPHICS_PATH_ALREADY_IN_TOPOLOGY                 0xC0262313L
#define ERROR_GRAPHICS_MODE_ALREADY_IN_MODESET                  0xC0262314L
#define ERROR_GRAPHICS_INVALID_VIDEOPRESENTSOURCESET            0xC0262315L
#define ERROR_GRAPHICS_INVALID_VIDEOPRESENTTARGETSET            0xC0262316L
#define ERROR_GRAPHICS_SOURCE_ALREADY_IN_SET                    0xC0262317L
#define ERROR_GRAPHICS_TARGET_ALREADY_IN_SET                    0xC0262318L
#define ERROR_GRAPHICS_INVALID_VIDPN_PRESENT_PATH               0xC0262319L
#define ERROR_GRAPHICS_NO_RECOMMENDED_VIDPN_TOPOLOGY            0xC026231AL
#define ERROR_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGESET        0xC026231BL
#define ERROR_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE           0xC026231CL
#define ERROR_GRAPHICS_FREQUENCYRANGE_NOT_IN_SET                0xC026231DL
#define ERROR_GRAPHICS_NO_PREFERRED_MODE                        0xC026231EL
#define ERROR_GRAPHICS_FREQUENCYRANGE_ALREADY_IN_SET            0xC026231FL
#define ERROR_GRAPHICS_STALE_MODESET                            0xC0262320L
#define ERROR_GRAPHICS_INVALID_MONITOR_SOURCEMODESET            0xC0262321L
#define ERROR_GRAPHICS_INVALID_MONITOR_SOURCE_MODE              0xC0262322L
#define ERROR_GRAPHICS_NO_RECOMMENDED_FUNCTIONAL_VIDPN          0xC0262323L
#define ERROR_GRAPHICS_MODE_ID_MUST_BE_UNIQUE                   0xC0262324L
#define ERROR_GRAPHICS_EMPTY_ADAPTER_MONITOR_MODE_SUPPORT_INTERSECTION  0xC0262325L
#define ERROR_GRAPHICS_VIDEO_PRESENT_TARGETS_LESS_THAN_SOURCES  0xC0262326L
#define ERROR_GRAPHICS_PATH_NOT_IN_TOPOLOGY                     0xC0262327L
#define ERROR_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_SOURCE    0xC0262328L
#define ERROR_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_TARGET    0xC0262329L
#define ERROR_GRAPHICS_INVALID_MONITORDESCRIPTORSET             0xC026232AL
#define ERROR_GRAPHICS_INVALID_MONITORDESCRIPTOR                0xC026232BL
#define ERROR_GRAPHICS_MONITORDESCRIPTOR_NOT_IN_SET             0xC026232CL
#define ERROR_GRAPHICS_MONITORDESCRIPTOR_ALREADY_IN_SET         0xC026232DL
#define ERROR_GRAPHICS_MONITORDESCRIPTOR_ID_MUST_BE_UNIQUE      0xC026232EL
#define ERROR_GRAPHICS_INVALID_VIDPN_TARGET_SUBSET_TYPE         0xC026232FL
#define ERROR_GRAPHICS_RESOURCES_NOT_RELATED                    0xC0262330L
#define ERROR_GRAPHICS_SOURCE_ID_MUST_BE_UNIQUE                 0xC0262331L
#define ERROR_GRAPHICS_TARGET_ID_MUST_BE_UNIQUE                 0xC0262332L
#define ERROR_GRAPHICS_NO_AVAILABLE_VIDPN_TARGET                0xC0262333L
#define ERROR_GRAPHICS_MONITOR_COULD_NOT_BE_ASSOCIATED_WITH_ADAPTER 0xC0262334L
#define ERROR_GRAPHICS_NO_VIDPNMGR                              0xC0262335L
#define ERROR_GRAPHICS_NO_ACTIVE_VIDPN                          0xC0262336L
#define ERROR_GRAPHICS_STALE_VIDPN_TOPOLOGY                     0xC0262337L
#define ERROR_GRAPHICS_MONITOR_NOT_CONNECTED                    0xC0262338L
#define ERROR_GRAPHICS_SOURCE_NOT_IN_TOPOLOGY                   0xC0262339L
#define ERROR_GRAPHICS_INVALID_PRIMARYSURFACE_SIZE              0xC026233AL
#define ERROR_GRAPHICS_INVALID_VISIBLEREGION_SIZE               0xC026233BL
#define ERROR_GRAPHICS_INVALID_STRIDE                           0xC026233CL
#define ERROR_GRAPHICS_INVALID_PIXELFORMAT                      0xC026233DL
#define ERROR_GRAPHICS_INVALID_COLORBASIS                       0xC026233EL
#define ERROR_GRAPHICS_INVALID_PIXELVALUEACCESSMODE             0xC026233FL
#define ERROR_GRAPHICS_TARGET_NOT_IN_TOPOLOGY                   0xC0262340L
#define ERROR_GRAPHICS_NO_DISPLAY_MODE_MANAGEMENT_SUPPORT       0xC0262341L
#define ERROR_GRAPHICS_VIDPN_SOURCE_IN_USE                      0xC0262342L
#define ERROR_GRAPHICS_CANT_ACCESS_ACTIVE_VIDPN                 0xC0262343L
#define ERROR_GRAPHICS_INVALID_PATH_IMPORTANCE_ORDINAL          0xC0262344L
#define ERROR_GRAPHICS_INVALID_PATH_CONTENT_GEOMETRY_TRANSFORMATION 0xC0262345L
#define ERROR_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_SUPPORTED   0xC0262346L
#define ERROR_GRAPHICS_INVALID_GAMMA_RAMP                       0xC0262347L
#define ERROR_GRAPHICS_GAMMA_RAMP_NOT_SUPPORTED                 0xC0262348L
#define ERROR_GRAPHICS_MULTISAMPLING_NOT_SUPPORTED              0xC0262349L
#define ERROR_GRAPHICS_MODE_NOT_IN_MODESET                      0xC026234AL
#define ERROR_GRAPHICS_DATASET_IS_EMPTY                         0xC026234BL
#define ERROR_GRAPHICS_NO_MORE_ELEMENTS_IN_DATASET              0xC026234CL
#define ERROR_GRAPHICS_INVALID_VIDPN_TOPOLOGY_RECOMMENDATION_REASON 0xC026234DL
#define ERROR_GRAPHICS_INVALID_PATH_CONTENT_TYPE                0xC026234EL
#define ERROR_GRAPHICS_INVALID_COPYPROTECTION_TYPE              0xC026234FL
#define ERROR_GRAPHICS_UNASSIGNED_MODESET_ALREADY_EXISTS        0xC0262350L
#define ERROR_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_PINNED  0xC0262351L
#define ERROR_GRAPHICS_INVALID_SCANLINE_ORDERING                0xC0262352L
#define ERROR_GRAPHICS_TOPOLOGY_CHANGES_NOT_ALLOWED             0xC0262353L
#define ERROR_GRAPHICS_NO_AVAILABLE_IMPORTANCE_ORDINALS         0xC0262354L
#define ERROR_GRAPHICS_INCOMPATIBLE_PRIVATE_FORMAT              0xC0262355L
#define ERROR_GRAPHICS_INVALID_MODE_PRUNING_ALGORITHM           0xC0262356L
#define ERROR_GRAPHICS_INVALID_MONITOR_CAPABILITY_ORIGIN        0xC0262357L
#define ERROR_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE_CONSTRAINT    0xC0262358L
#define ERROR_GRAPHICS_MAX_NUM_PATHS_REACHED                    0xC0262359L
#define ERROR_GRAPHICS_CANCEL_VIDPN_TOPOLOGY_AUGMENTATION       0xC026235AL
#define ERROR_GRAPHICS_INVALID_CLIENT_TYPE                      0xC026235BL
#define ERROR_GRAPHICS_CLIENTVIDPN_NOT_SET                      0xC026235CL

/* Port error codes */
#define ERROR_GRAPHICS_SPECIFIED_CHILD_ALREADY_CONNECTED    0xC0262400L
#define ERROR_GRAPHICS_CHILD_DESCRIPTOR_NOT_SUPPORTED       0xC0262401L
#define ERROR_GRAPHICS_UKNOWN_CHILD_STATUS                  0xC026242FL
#define ERROR_GRAPHICS_NOT_A_LINKED_ADAPTER                 0xC0262430L
#define ERROR_GRAPHICS_LEADLINK_NOT_ENUMERATED              0xC0262431L
#define ERROR_GRAPHICS_CHAINLINKS_NOT_ENUMERATED            0xC0262432L
#define ERROR_GRAPHICS_ADAPTER_CHAIN_NOT_READY              0xC0262433L
#define ERROR_GRAPHICS_CHAINLINKS_NOT_STARTED               0xC0262434L
#define ERROR_GRAPHICS_CHAINLINKS_NOT_POWERED_ON            0xC0262435L
#define ERROR_GRAPHICS_INCONSISTENT_DEVICE_LINK_STATE       0xC0262436L
#define ERROR_GRAPHICS_LEADLINK_START_DEFERRED              0xC0262437L
#define ERROR_GRAPHICS_NOT_POST_DEVICE_DRIVER               0xC0262438L
#define ERROR_GRAPHICS_POLLING_TOO_FREQUENTLY               0xC0262439L
#define ERROR_GRAPHICS_START_DEFERRED                       0xC026243AL
#define ERROR_GRAPHICS_ADAPTER_ACCESS_NOT_EXCLUDED          0xC026243BL

/* OPM, UAB, and PVP error codes */
#define ERROR_GRAPHICS_OPM_NOT_SUPPORTED                    0xC0262500L
#define ERROR_GRAPHICS_COPP_NOT_SUPPORTED                   0xC0262501L
#define ERROR_GRAPHICS_UAB_NOT_SUPPORTED                    0xC0262502L
#define ERROR_GRAPHICS_OPM_INVALID_ENCYPTED_PARAMETERS      0xC0262503L
#define ERROR_GRAPHICS_OPM_NO_VIDEO_OUTPUTS_EXIST           0xC0262505L
#define ERROR_GRAPHICS_OPM_INTERNAL_ERROR                   0xC026250BL
#define ERROR_GRAPHICS_OPM_INVALID_HANDLE                   0xC026250CL
#define ERROR_GRAPHICS_PVP_INVALID_CERTIFICATE_LENGTH       0xC026250EL
#define ERROR_GRAPHICS_OPM_SPANNING_MODE_ENABLED            0xC026250FL
#define ERROR_GRAPHICS_OPM_THEATER_MODE_ENABLED             0xC0262510L
#define ERROR_GRAPHICS_PVP_HFS_FAILED                       0xC0262511L
#define ERROR_GRAPHICS_OPM_INVALID_SRM                      0xC0262512L
#define ERROR_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_HDCP     0xC0262513L
#define ERROR_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_ACP      0xC0262514L
#define ERROR_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_CGMSA    0xC0262515L
#define ERROR_GRAPHICS_OPM_HDCP_SRM_NEVER_SET               0xC0262516L
#define ERROR_GRAPHICS_OPM_RESOLUTION_TOO_HIGH              0xC0262517L
#define ERROR_GRAPHICS_OPM_ALL_HDCP_HARDWARE_ALREADY_IN_USE 0xC0262518L
#define ERROR_GRAPHICS_OPM_VIDEO_OUTPUT_NO_LONGER_EXISTS    0xC026251AL
#define ERROR_GRAPHICS_OPM_SESSION_TYPE_CHANGE_IN_PROGRESS  0xC026251BL
#define ERROR_GRAPHICS_OPM_VIDEO_OUTPUT_DOES_NOT_HAVE_COPP_SEMANTICS    0xC026251CL
#define ERROR_GRAPHICS_OPM_INVALID_INFORMATION_REQUEST      0xC026251DL
#define ERROR_GRAPHICS_OPM_DRIVER_INTERNAL_ERROR            0xC026251EL
#define ERROR_GRAPHICS_OPM_VIDEO_OUTPUT_DOES_NOT_HAVE_OPM_SEMANTICS 0xC026251FL
#define ERROR_GRAPHICS_OPM_SIGNALING_NOT_SUPPORTED          0xC0262520L
#define ERROR_GRAPHICS_OPM_INVALID_CONFIGURATION_REQUEST    0xC0262521L

/* Monitor Configuration API error codes */
#define ERROR_GRAPHICS_I2C_NOT_SUPPORTED                        0xC0262580L
#define ERROR_GRAPHICS_I2C_DEVICE_DOES_NOT_EXIST                0xC0262581L
#define ERROR_GRAPHICS_I2C_ERROR_TRANSMITTING_DATA              0xC0262582L
#define ERROR_GRAPHICS_I2C_ERROR_RECEIVING_DATA                 0xC0262583L
#define ERROR_GRAPHICS_DDCCI_VCP_NOT_SUPPORTED                  0xC0262584L
#define ERROR_GRAPHICS_DDCCI_INVALID_DATA                       0xC0262585L
#define ERROR_GRAPHICS_DDCCI_MONITOR_RETURNED_INVALID_TIMING_STATUS_BYTE    0xC0262586L
#define ERROR_GRAPHICS_MCA_INVALID_CAPABILITIES_STRING          0xC0262587L
#define ERROR_GRAPHICS_MCA_INTERNAL_ERROR                       0xC0262588L
#define ERROR_GRAPHICS_DDCCI_INVALID_MESSAGE_COMMAND            0xC0262589L
#define ERROR_GRAPHICS_DDCCI_INVALID_MESSAGE_LENGTH             0xC026258AL
#define ERROR_GRAPHICS_DDCCI_INVALID_MESSAGE_CHECKSUM           0xC026258BL
#define ERROR_GRAPHICS_INVALID_PHYSICAL_MONITOR_HANDLE          0xC026258CL
#define ERROR_GRAPHICS_MONITOR_NO_LONGER_EXISTS                 0xC026258DL
#define ERROR_GRAPHICS_DDCCI_CURRENT_CURRENT_VALUE_GREATER_THAN_MAXIMUM_VALUE   0xC02635D8L
#define ERROR_GRAPHICS_MCA_INVALID_VCP_VERSION                  0xC02625D9L
#define ERROR_GRAPHICS_MCA_MONITOR_VIOLATES_MCCS_SPECIFICATION  0xC02625DAL
#define ERROR_GRAPHICS_MCA_MCCS_VERSION_MISMATCH                0xC02635DBL
#define ERROR_GRAPHICS_MCA_UNSUPPORTED_MCCS_VERSION             0xC02635DCL
#define ERROR_GRAPHICS_MCA_INVALID_TECHNOLOGY_TYPE_RETURNED     0xC02625DEL
#define ERROR_GRAPHICS_MCA_UNSUPPORTED_COLOR_TEMPERATURE        0xC02625DFL

/* OPM, UAB, PVP, and DDC/CI error codes */
#define ERROR_GRAPHICS_ONLY_CONSOLE_SESSION_SUPPORTED           0xC02625E0L
#define ERROR_GRAPHICS_NO_DISPLAY_DEVICE_CORRESPONDS_TO_NAME    0xC02625E1L
#define ERROR_GRAPHICS_DISPLAY_DEVICE_NOT_ATTACHED_TO_DESKTOP   0xC02625E2L
#define ERROR_GRAPHICS_MIRRORING_DEVICES_NOT_SUPPORTED          0xC02625E3L
#define ERROR_GRAPHICS_INVALID_POINTER                          0xC02625E4L
#define ERROR_GRAPHICS_NO_MONITORS_CORRESPOND_TO_DISPLAY_DEVICE 0xC02625E5L
#define ERROR_GRAPHICS_PARAMETER_ARRAY_TOO_SMALL                0xC02625E6L
#define ERROR_GRAPHICS_INTERNAL_ERROR                           0xC02625E7L
#define ERROR_GRAPHICS_SESSION_TYPE_CHANGE_IN_PROGRESS          0xC02625E8L

/* TPM hardware error codes */
#define TPM_E_ERROR_MASK                0x80280000L
#define TPM_E_AUTHFAIL                  0x80280001L
#define TPM_E_BADINDEX                  0x80280002L
#define TPM_E_BADPARAMETER              0x80280003L
#define TPM_E_AUDITFAILURE              0x80280004L
#define TPM_E_CLEAR_DISABLED            0x80280005L
#define TPM_E_DEACTIVATED               0x80280006L
#define TPM_E_DISABLED                  0x80280007L
#define TPM_E_DISABLED_CMD              0x80280008L
#define TPM_E_FAIL                      0x80280009L
#define TPM_E_BAD_ORDINAL               0x8028000AL
#define TPM_E_INSTALL_DISABLED          0x8028000BL
#define TPM_E_INVALID_KEYHANDLE         0x8028000CL
#define TPM_E_KEYNOTFOUND               0x8028000DL
#define TPM_E_INAPPROPRIATE_ENC         0x8028000EL
#define TPM_E_MIGRATEFAIL               0x8028000FL
#define TPM_E_INVALID_PCR_INFO          0x80280010L
#define TPM_E_NOSPACE                   0x80280011L
#define TPM_E_NOSRK                     0x80280012L
#define TPM_E_NOTSEALED_BLOB            0x80280013L
#define TPM_E_OWNER_SET                 0x80280014L
#define TPM_E_RESOURCES                 0x80280015L
#define TPM_E_SHORTRANDOM               0x80280016L
#define TPM_E_SIZE                      0x80280017L
#define TPM_E_WRONGPCRVAL               0x80280018L
#define TPM_E_BAD_PARAM_SIZE            0x80280019L
#define TPM_E_SHA_THREAD                0x8028001AL
#define TPM_E_SHA_ERROR                 0x8028001BL
#define TPM_E_FAILEDSELFTEST            0x8028001CL
#define TPM_E_AUTH2FAIL                 0x8028001DL
#define TPM_E_BADTAG                    0x8028001EL
#define TPM_E_IOERROR                   0x8028001FL
#define TPM_E_ENCRYPT_ERROR             0x80280020L
#define TPM_E_DECRYPT_ERROR             0x80280021L
#define TPM_E_INVALID_AUTHHANDLE        0x80280022L
#define TPM_E_ENDORSEMENT               0x80280023L
#define TPM_E_INVALID_KEYUSAGE          0x80280024L
#define TPM_E_WRONG_ENTITYTYPE          0x80280025L
#define TPM_E_INVALID_POSTINIT          0x80280026L
#define TPM_E_INAPPROPRIATE_SIG         0x80280027L
#define TPM_E_BAD_KEY_PROPERTY          0x80280028L
#define TPM_E_BAD_MIGRATION             0x80280029L
#define TPM_E_BAD_SCHEME                0x8028002AL
#define TPM_E_BAD_DATASIZE              0x8028002BL
#define TPM_E_BAD_MODE                  0x8028002CL
#define TPM_E_BAD_PRESENCE              0x8028002DL
#define TPM_E_BAD_VERSION               0x8028002EL
#define TPM_E_NO_WRAP_TRANSPORT         0x8028002FL
#define TPM_E_AUDITFAIL_UNSUCCESSFUL    0x80280030L
#define TPM_E_AUDITFAIL_SUCCESSFUL      0x80280031L
#define TPM_E_NOTRESETABLE              0x80280032L
#define TPM_E_NOTLOCAL                  0x80280033L
#define TPM_E_BAD_TYPE                  0x80280034L
#define TPM_E_INVALID_RESOURCE          0x80280035L
#define TPM_E_NOTFIPS                   0x80280036L
#define TPM_E_INVALID_FAMILY            0x80280037L
#define TPM_E_NO_NV_PERMISSION          0x80280038L
#define TPM_E_REQUIRES_SIGN             0x80280039L
#define TPM_E_KEY_NOTSUPPORTED          0x8028003AL
#define TPM_E_AUTH_CONFLICT             0x8028003BL
#define TPM_E_AREA_LOCKED               0x8028003CL
#define TPM_E_BAD_LOCALITY              0x8028003DL
#define TPM_E_READ_ONLY                 0x8028003EL
#define TPM_E_PER_NOWRITE               0x8028003FL
#define TPM_E_FAMILYCOUNT               0x80280040L
#define TPM_E_WRITE_LOCKED              0x80280041L
#define TPM_E_BAD_ATTRIBUTES            0x80280042L
#define TPM_E_INVALID_STRUCTURE         0x80280043L
#define TPM_E_KEY_OWNER_CONTROL         0x80280044L
#define TPM_E_BAD_COUNTER               0x80280045L
#define TPM_E_NOT_FULLWRITE             0x80280046L
#define TPM_E_CONTEXT_GAP               0x80280047L
#define TPM_E_MAXNVWRITES               0x80280048L
#define TPM_E_NOOPERATOR                0x80280049L
#define TPM_E_RESOURCEMISSING           0x8028004AL
#define TPM_E_DELEGATE_LOCK             0x8028004BL
#define TPM_E_DELEGATE_FAMILY           0x8028004CL
#define TPM_E_DELEGATE_ADMIN            0x8028004DL
#define TPM_E_TRANSPORT_NOTEXCLUSIVE    0x8028004EL
#define TPM_E_OWNER_CONTROL             0x8028004FL
#define TPM_E_DAA_RESOURCES             0x80280050L
#define TPM_E_DAA_INPUT_DATA0           0x80280051L
#define TPM_E_DAA_INPUT_DATA1           0x80280052L
#define TPM_E_DAA_ISSUER_SETTINGS       0x80280053L
#define TPM_E_DAA_TPM_SETTINGS          0x80280054L
#define TPM_E_DAA_STAGE                 0x80280055L
#define TPM_E_DAA_ISSUER_VALIDITY       0x80280056L
#define TPM_E_DAA_WRONG_W               0x80280057L
#define TPM_E_BAD_HANDLE                0x80280058L
#define TPM_E_BAD_DELEGATE              0x80280059L
#define TPM_E_BADCONTEXT                0x8028005AL
#define TPM_E_TOOMANYCONTEXTS           0x8028005BL
#define TPM_E_MA_TICKET_SIGNATURE       0x8028005CL
#define TPM_E_MA_DESTINATION            0x8028005DL
#define TPM_E_MA_SOURCE                 0x8028005EL
#define TPM_E_MA_AUTHORITY              0x8028005FL
#define TPM_E_PARMANENTEK               0x80280061L
#define TPM_E_BADSIGNATURE              0x80280062L
#define TPM_E_NOCONTEXTSPACE            0x80280063L

/* TPM vendor-specific hardware error codes */
#define TPM_E_COMMAND_BLOCKED               0x80280400L
#define TPM_E_INVALID_HANDLE                0x80280401L
#define TPM_E_DUPLICATE_VHANDLE             0x80280402L
#define TPM_E_EMBEDDED_COMMAND_BLOCKED      0x80280403L
#define TPM_E_EMBEDDED_COMMAND_UNSUPPORTED  0x80280404L

/* TPM non-fatal hardware error codes */
#define TPM_E_RETRY                 0x80280800L
#define TPM_E_NEEDS_SELFTEST        0x80280801L
#define TPM_E_DOING_SELFTEST        0x80280802L
#define TPM_E_DEFEND_LOCK_RUNNING   0x80280803L

/* TPM Base Services error codes */
#define TBS_E_INTERNAL_ERROR            0x80284001L
#define TBS_E_BAD_PARAMETER             0x80284002L
#define TBS_E_INVALID_OUTPUT_POINTER    0x80284003L
#define TBS_E_INVALID_CONTEXT           0x80284004L
#define TBS_E_INSUFFICIENT_BUFFER       0x80284005L
#define TBS_E_IOERROR                   0x80284006L
#define TBS_E_INVALID_CONTEXT_PARAM     0x80284007L
#define TBS_E_SERVICE_NOT_RUNNING       0x80284008L
#define TBS_E_TOO_MANY_TBS_CONTEXTS     0x80284009L
#define TBS_E_TOO_MANY_RESOURCES        0x8028400AL
#define TBS_E_SERVICE_START_PENDING     0x8028400BL
#define TBS_E_PPI_NOT_SUPPORTED         0x8028400CL
#define TBS_E_COMMAND_CANCELLED         0x8028400DL
#define TBS_E_BUFFER_TOO_LARGE          0x8028400EL
#define TBS_E_TPM_NOT_FOUND             0x8028400FL
#define TBS_E_SERVICE_DISABLED          0x80284010L
#define TBS_E_NO_EVENT_LOG              0x80284011L

/* TPM API error codes */
#define TPMAPI_E_INVALID_STATE              0x80290100L
#define TPMAPI_E_NOT_ENOUGH_DATA            0x80290101L
#define TPMAPI_E_TOO_MUCH_DATA              0x80290102L
#define TPMAPI_E_INVALID_OUTPUT_POINTER     0x80290103L
#define TPMAPI_E_INVALID_PARAMETER          0x80290104L
#define TPMAPI_E_OUT_OF_MEMORY              0x80290105L
#define TPMAPI_E_BUFFER_TOO_SMALL           0x80290106L
#define TPMAPI_E_INTERNAL_ERROR             0x80290107L
#define TPMAPI_E_ACCESS_DENIED              0x80290108L
#define TPMAPI_E_AUTHORIZATION_FAILED       0x80290109L
#define TPMAPI_E_INVALID_CONTEXT_HANDLE     0x8029010AL
#define TPMAPI_E_TBS_COMMUNICATION_ERROR    0x8029010BL
#define TPMAPI_E_TPM_COMMAND_ERROR          0x8029010CL
#define TPMAPI_E_MESSAGE_TOO_LARGE          0x8029010DL
#define TPMAPI_E_INVALID_ENCODING           0x8029010EL
#define TPMAPI_E_INVALID_KEY_SIZE           0x8029010FL
#define TPMAPI_E_ENCRYPTION_FAILED          0x80290110L
#define TPMAPI_E_INVALID_KEY_PARAMS         0x80290111L
#define TPMAPI_E_INVALID_MIGRATION_AUTHORIZATION_BLOB   0x80290112L
#define TPMAPI_E_INVALID_PCR_INDEX          0x80290113L
#define TPMAPI_E_INVALID_DELEGATE_BLOB      0x80290114L
#define TPMAPI_E_INVALID_CONTEXT_PARAMS     0x80290115L
#define TPMAPI_E_INVALID_KEY_BLOB           0x80290116L
#define TPMAPI_E_INVALID_PCR_DATA           0x80290117L
#define TPMAPI_E_INVALID_OWNER_AUTH         0x80290118L
#define TPMAPI_E_FIPS_RNG_CHECK_FAILED      0x80290119L
#define TPMAPI_E_EMPTY_TCG_LOG              0x8029011AL
#define TPMAPI_E_INVALID_TCG_LOG_ENTRY      0x8029011BL
#define TPMAPI_E_TCG_SEPARATOR_ABSENT       0x8029011CL
#define TPMAPI_E_TCG_INVALID_DIGEST_ENTRY   0x8029011DL

/* TBS implementation error codes */
#define TBSIMP_E_BUFFER_TOO_SMALL           0x80290200L
#define TBSIMP_E_CLEANUP_FAILED             0x80290201L
#define TBSIMP_E_INVALID_CONTEXT_HANDLE     0x80290202L
#define TBSIMP_E_INVALID_CONTEXT_PARAM      0x80290203L
#define TBSIMP_E_TPM_ERROR                  0x80290204L
#define TBSIMP_E_HASH_BAD_KEY               0x80290205L
#define TBSIMP_E_DUPLICATE_VHANDLE          0x80290206L
#define TBSIMP_E_INVALID_OUTPUT_POINTER     0x80290207L
#define TBSIMP_E_INVALID_PARAMETER          0x80290208L
#define TBSIMP_E_RPC_INIT_FAILED            0x80290209L
#define TBSIMP_E_SCHEDULER_NOT_RUNNING      0x8029020AL
#define TBSIMP_E_COMMAND_CANCELED           0x8029020BL
#define TBSIMP_E_OUT_OF_MEMORY              0x8029020CL
#define TBSIMP_E_LIST_NO_MORE_ITEMS         0x8029020DL
#define TBSIMP_E_LIST_NOT_FOUND             0x8029020EL
#define TBSIMP_E_NOT_ENOUGH_SPACE           0x8029020FL
#define TBSIMP_E_NOT_ENOUGH_TPM_CONTEXTS    0x80290210L
#define TBSIMP_E_COMMAND_FAILED             0x80290211L
#define TBSIMP_E_UNKNOWN_ORDINAL            0x80290212L
#define TBSIMP_E_RESOURCE_EXPIRED           0x80290213L
#define TBSIMP_E_INVALID_RESOURCE           0x80290214L
#define TBSIMP_E_NOTHING_TO_UNLOAD          0x80290215L
#define TBSIMP_E_HASH_TABLE_FULL            0x80290216L
#define TBSIMP_E_TOO_MANY_TBS_CONTEXTS      0x80290217L
#define TBSIMP_E_TOO_MANY_RESOURCES         0x80290218L
#define TBSIMP_E_PPI_NOT_SUPPORTED          0x80290219L
#define TBSIMP_E_TPM_INCOMPATIBLE           0x8029021AL
#define TBSIMP_E_NO_EVENT_LOG               0x8029021BL

/* TPM physical presence implementation error codes */
#define TPM_E_PPI_ACPI_FAILURE              0x80290300L
#define TPM_E_PPI_USER_ABORT                0x80290301L
#define TPM_E_PPI_BIOS_FAILURE              0x80290302L
#define TPM_E_PPI_NOT_SUPPORTED             0x80290303L

/* Performance Logs and Alerts (PLA) error codes */
#define PLA_E_DCS_NOT_FOUND                 0x80300002L
#define PLA_E_DCS_IN_USE                    0x803000AAL
#define PLA_E_TOO_MANY_FOLDERS              0x80300045L
#define PLA_E_NO_MIN_DISK                   0x80300070L
#define PLA_E_DCS_ALREADY_EXISTS            0x803000B7L
#define PLA_S_PROPERTY_IGNORED              0x00300100L
#define PLA_E_PROPERTY_CONFLICT             0x80300101L
#define PLA_E_DCS_SINGLETON_REQUIRED        0x80300102L
#define PLA_E_CREDENTIALS_REQUIRED          0x80300103L
#define PLA_E_DCS_NOT_RUNNING               0x80300104L
#define PLA_E_CONFLICT_INCL_EXCL_API        0x80300105L
#define PLA_E_NETWORK_EXE_NOT_VALID         0x80300106L
#define PLA_E_EXE_ALREADY_CONFIGURED        0x80300107L
#define PLA_E_EXE_PATH_NOT_VALID            0x80300108L
#define PLA_E_DC_ALREADY_EXISTS             0x80300109L
#define PLA_E_DCS_START_WAIT_TIMEOUT        0x8030010AL
#define PLA_E_DC_START_WAIT_TIMEOUT         0x8030010BL
#define PLA_E_REPORT_WAIT_TIMEOUT           0x8030010CL
#define PLA_E_NO_DUPLICATES                 0x8030010DL
#define PLA_E_EXE_FULL_PATH_REQUIRED        0x8030010EL
#define PLA_E_INVALID_SESSION_NAME          0x8030010FL
#define PLA_E_PLA_CHANNEL_NOT_ENABLED       0x80300110L
#define PLA_E_TASKSCHED_CHANNEL_NOT_ENABLED 0x80300111L
#define PLA_E_RULES_MANAGER_FAILED          0x80300112L
#define PLA_E_CABAPI_FAILURE                0x80300113L

/* File Volume Encryption error codes */
#define FVE_E_LOCKED_VOLUME                         0x80310000L
#define FVE_E_NOT_ENCRYPTED                         0x80310001L
#define FVE_E_NO_TPM_BIOS                           0x80310002L
#define FVE_E_NO_MBR_METRIC                         0x80310003L
#define FVE_E_NO_BOOTSECTOR_METRIC                  0x80310004L
#define FVE_E_NO_BOOTMGR_METRIC                     0x80310005L
#define FVE_E_WRONG_BOOTMGR                         0x80310006L
#define FVE_E_SECURE_KEY_REQUIRED                   0x80310007L
#define FVE_E_NOT_ACTIVATED                         0x80310008L
#define FVE_E_ACTION_NOT_ALLOWED                    0x80310009L
#define FVE_E_AD_SCHEMA_NOT_INSTALLED               0x8031000AL
#define FVE_E_AD_INVALID_DATATYPE                   0x8031000BL
#define FVE_E_AD_INVALID_DATASIZE                   0x8031000CL
#define FVE_E_AD_NO_VALUES                          0x8031000DL
#define FVE_E_AD_ATTR_NOT_SET                       0x8031000EL
#define FVE_E_AD_GUID_NOT_FOUND                     0x8031000FL
#define FVE_E_BAD_INFORMATION                       0x80310010L
#define FVE_E_TOO_SMALL                             0x80310011L
#define FVE_E_SYSTEM_VOLUME                         0x80310012L
#define FVE_E_FAILED_WRONG_FS                       0x80310013L
#define FVE_E_FAILED_BAD_FS                         0x80310014L
#define FVE_E_NOT_SUPPORTED                         0x80310015L
#define FVE_E_BAD_DATA                              0x80310016L
#define FVE_E_VOLUME_NOT_BOUND                      0x80310017L
#define FVE_E_TPM_NOT_OWNED                         0x80310018L
#define FVE_E_NOT_DATA_VOLUME                       0x80310019L
#define FVE_E_AD_INSUFFICIENT_BUFFER                0x8031001AL
#define FVE_E_CONV_READ                             0x8031001BL
#define FVE_E_CONV_WRITE                            0x8031001CL
#define FVE_E_KEY_REQUIRED                          0x8031001DL
#define FVE_E_CLUSTERING_NOT_SUPPORTED              0x8031001EL
#define FVE_E_VOLUME_BOUND_ALREADY                  0x8031001FL
#define FVE_E_OS_NOT_PROTECTED                      0x80310020L
#define FVE_E_PROTECTION_DISABLED                   0x80310021L
#define FVE_E_RECOVERY_KEY_REQUIRED                 0x80310022L
#define FVE_E_FOREIGN_VOLUME                        0x80310023L
#define FVE_E_OVERLAPPED_UPDATE                     0x80310024L
#define FVE_E_TPM_SRK_AUTH_NOT_ZERO                 0x80310025L
#define FVE_E_FAILED_SECTOR_SIZE                    0x80310026L
#define FVE_E_FAILED_AUTHENTICATION                 0x80310027L
#define FVE_E_NOT_OS_VOLUME                         0x80310028L
#define FVE_E_AUTOUNLOCK_ENABLED                    0x80310029L
#define FVE_E_WRONG_BOOTSECTOR                      0x8031002AL
#define FVE_E_WRONG_SYSTEM_FS                       0x8031002BL
#define FVE_E_POLICY_PASSWORD_REQUIRED              0x8031002CL
#define FVE_E_CANNOT_SET_FVEK_ENCRYPTED             0x8031002DL
#define FVE_E_CANNOT_ENCRYPT_NO_KEY                 0x8031002EL
#define FVE_E_BOOTABLE_CDDVD                        0x80310030L
#define FVE_E_PROTECTOR_EXISTS                      0x80310031L
#define FVE_E_RELATIVE_PATH                         0x80310032L
#define FVE_E_PROTECTOR_NOT_FOUND                   0x80310033L
#define FVE_E_INVALID_KEY_FORMAT                    0x80310034L
#define FVE_E_INVALID_PASSWORD_FORMAT               0x80310035L
#define FVE_E_FIPS_RNG_CHECK_FAILED                 0x80310036L
#define FVE_E_FIPS_PREVENTS_RECOVERY_PASSWORD       0x80310037L
#define FVE_E_FIPS_PREVENTS_EXTERNAL_KEY_EXPORT     0x80310038L
#define FVE_E_NOT_DECRYPTED                         0x80310039L
#define FVE_E_INVALID_PROTECTOR_TYPE                0x8031003AL
#define FVE_E_NO_PROTECTORS_TO_TEST                 0x8031003BL
#define FVE_E_KEYFILE_NOT_FOUND                     0x8031003CL
#define FVE_E_KEYFILE_INVALID                       0x8031003DL
#define FVE_E_KEYFILE_NO_VMK                        0x8031003EL
#define FVE_E_TPM_DISABLED                          0x8031003FL
#define FVE_E_NOT_ALLOWED_IN_SAFE_MODE              0x80310040L
#define FVE_E_TPM_INVALID_PCR                       0x80310041L
#define FVE_E_TPM_NO_VMK                            0x80310042L
#define FVE_E_PIN_INVALID                           0x80310043L
#define FVE_E_AUTH_INVALID_APPLICATION              0x80310044L
#define FVE_E_AUTH_INVALID_CONFIG                   0x80310045L
#define FVE_E_FIPS_DISABLE_PROTECTION_NOT_ALLOWED   0x80310046L
#define FVE_E_FS_NOT_EXTENDED                       0x80310047L
#define FVE_E_FIRMWARE_TYPE_NOT_SUPPORTED           0x80310048L
#define FVE_E_NO_LICENSE                            0x80310049L
#define FVE_E_NOT_ON_STACK                          0x8031004AL
#define FVE_E_FS_MOUNTED                            0x8031004BL
#define FVE_E_TOKEN_NOT_IMPERSONATED                0x8031004CL
#define FVE_E_DRY_RUN_FAILED                        0x8031004DL
#define FVE_E_REBOOT_REQUIRED                       0x8031004EL
#define FVE_E_DEBUGGER_ENABLED                      0x8031004FL
#define FVE_E_RAW_ACCESS                            0x80310050L
#define FVE_E_RAW_BLOCKED                           0x80310051L
#define FVE_E_BCD_APPLICATIONS_PATH_INCORRECT       0x80310052L
#define FVE_E_NOT_ALLOWED_IN_VERSION                0x80310053L
#define FVE_E_NO_AUTOUNLOCK_MASTER_KEY              0x80310054L
#define FVE_E_MOR_FAILED                            0x80310055L
#define FVE_E_HIDDEN_VOLUME                         0x80310056L
#define FVE_E_TRANSIENT_STATE                       0x80310057L
#define FVE_E_PUBKEY_NOT_ALLOWED                    0x80310058L
#define FVE_E_VOLUME_HANDLE_OPEN                    0x80310059L
#define FVE_E_NO_FEATURE_LICENSE                    0x8031005AL
#define FVE_E_INVALID_STARTUP_OPTIONS               0x8031005BL
#define FVE_E_POLICY_RECOVERY_PASSWORD_NOT_ALLOWED  0x8031005CL
#define FVE_E_POLICY_RECOVERY_PASSWORD_REQUIRED     0x8031005DL
#define FVE_E_POLICY_RECOVERY_KEY_NOT_ALLOWED       0x8031005EL
#define FVE_E_POLICY_RECOVERY_KEY_REQUIRED          0x8031005FL
#define FVE_E_POLICY_STARTUP_PIN_NOT_ALLOWED        0x80310060L
#define FVE_E_POLICY_STARTUP_PIN_REQUIRED           0x80310061L
#define FVE_E_POLICY_STARTUP_KEY_NOT_ALLOWED        0x80310062L
#define FVE_E_POLICY_STARTUP_KEY_REQUIRED           0x80310063L
#define FVE_E_POLICY_STARTUP_PIN_KEY_NOT_ALLOWED    0x80310064L
#define FVE_E_POLICY_STARTUP_PIN_KEY_REQUIRED       0x80310065L
#define FVE_E_POLICY_STARTUP_TPM_NOT_ALLOWED        0x80310066L
#define FVE_E_POLICY_STARTUP_TPM_REQUIRED           0x80310067L
#define FVE_E_POLICY_INVALID_PIN_LENGTH             0x80310068L
#define FVE_E_KEY_PROTECTOR_NOT_SUPPORTED           0x80310069L
#define FVE_E_POLICY_PASSPHRASE_NOT_ALLOWED         0x8031006AL
#define FVE_E_POLICY_PASSPHRASE_REQUIRED            0x8031006BL
#define FVE_E_FIPS_PREVENTS_PASSPHRASE              0x8031006CL
#define FVE_E_OS_VOLUME_PASSPHRASE_NOT_ALLOWED      0x8031006DL
#define FVE_E_INVALID_BITLOCKER_OID                 0x8031006EL
#define FVE_E_VOLUME_TOO_SMALL                      0x8031006FL
#define FVE_E_DV_NOT_SUPPORTED_ON_FS                0x80310070L
#define FVE_E_DV_NOT_ALLOWED_BY_GP                  0x80310071L
#define FVE_E_POLICY_USER_CERTIFICATE_NOT_ALLOWED   0x80310072L
#define FVE_E_POLICY_USER_CERTIFICATE_REQUIRED      0x80310073L
#define FVE_E_POLICY_USER_CERT_MUST_BE_HW           0x80310074L
#define FVE_E_POLICY_USER_CONFIGURE_FDV_AUTOUNLOCK_NOT_ALLOWED  0x80310075L
#define FVE_E_POLICY_USER_CONFIGURE_RDV_AUTOUNLOCK_NOT_ALLOWED  0x80310076L
#define FVE_E_POLICY_USER_CONFIGURE_RDV_NOT_ALLOWED 0x80310077L
#define FVE_E_POLICY_USER_ENABLE_RDV_NOT_ALLOWED    0x80310078L
#define FVE_E_POLICY_USER_DISABLE_RDV_NOT_ALLOWED   0x80310079L
#define FVE_E_POLICY_INVALID_PASSPHRASE_LENGTH      0x80310080L
#define FVE_E_POLICY_PASSPHRASE_TOO_SIMPLE          0x80310081L
#define FVE_E_RECOVERY_PARTITION                    0x80310082L
#define FVE_E_POLICY_CONFLICT_FDV_RK_OFF_AUK_ON     0x80310083L
#define FVE_E_POLICY_CONFLICT_RDV_RK_OFF_AUK_ON     0x80310084L
#define FVE_E_NON_BITLOCKER_OID                     0x80310085L
#define FVE_E_POLICY_PROHIBITS_SELFSIGNED           0x80310086L
#define FVE_E_POLICY_CONFLICT_RO_AND_STARTUP_KEY_REQUIRED   0x80310087L
#define FVE_E_CONV_RECOVERY_FAILED                  0x80310088L
#define FVE_E_VIRTUALIZED_SPACE_TOO_BIG             0x80310089L
#define FVE_E_POLICY_CONFLICT_OSV_RP_OFF_ADB_ON     0x80310090L
#define FVE_E_POLICY_CONFLICT_FDV_RP_OFF_ADB_ON     0x80310091L
#define FVE_E_POLICY_CONFLICT_RDV_RP_OFF_ADB_ON     0x80310092L
#define FVE_E_NON_BITLOCKER_KU                      0x80310093L
#define FVE_E_PRIVATEKEY_AUTH_FAILED                0x80310094L
#define FVE_E_REMOVAL_OF_DRA_FAILED                 0x80310095L
#define FVE_E_OPERATION_NOT_SUPPORTED_ON_VISTA_VOLUME   0x80310096L
#define FVE_E_CANT_LOCK_AUTOUNLOCK_ENABLED_VOLUME   0x80310097L
#define FVE_E_FIPS_HASH_KDF_NOT_ALLOWED             0x80310098L
#define FVE_E_ENH_PIN_INVALID                       0x80310099L
#define FVE_E_INVALID_PIN_CHARS                     0x8031009AL
#define FVE_E_INVALID_DATUM_TYPE                    0x8031009BL

/* Windows Filtering Platform error codes */
#define FWP_E_CALLOUT_NOT_FOUND                 0x80320001L
#define FWP_E_CONDITION_NOT_FOUND               0x80320002L
#define FWP_E_FILTER_NOT_FOUND                  0x80320003L
#define FWP_E_LAYER_NOT_FOUND                   0x80320004L
#define FWP_E_PROVIDER_NOT_FOUND                0x80320005L
#define FWP_E_PROVIDER_CONTEXT_NOT_FOUND        0x80320006L
#define FWP_E_SUBLAYER_NOT_FOUND                0x80320007L
#define FWP_E_NOT_FOUND                         0x80320008L
#define FWP_E_ALREADY_EXISTS                    0x80320009L
#define FWP_E_IN_USE                            0x8032000AL
#define FWP_E_DYNAMIC_SESSION_IN_PROGRESS       0x8032000BL
#define FWP_E_WRONG_SESSION                     0x8032000CL
#define FWP_E_NO_TXN_IN_PROGRESS                0x8032000DL
#define FWP_E_TXN_IN_PROGRESS                   0x8032000EL
#define FWP_E_TXN_ABORTED                       0x8032000FL
#define FWP_E_SESSION_ABORTED                   0x80320010L
#define FWP_E_INCOMPATIBLE_TXN                  0x80320011L
#define FWP_E_TIMEOUT                           0x80320012L
#define FWP_E_NET_EVENTS_DISABLED               0x80320013L
#define FWP_E_INCOMPATIBLE_LAYER                0x80320014L
#define FWP_E_KM_CLIENTS_ONLY                   0x80320015L
#define FWP_E_LIFETIME_MISMATCH                 0x80320016L
#define FWP_E_BUILTIN_OBJECT                    0x80320017L
#define FWP_E_TOO_MANY_CALLOUTS                 0x80320018L
#define FWP_E_NOTIFICATION_DROPPED              0x80320019L
#define FWP_E_TRAFFIC_MISMATCH                  0x8032001AL
#define FWP_E_INCOMPATIBLE_SA_STATE             0x8032001BL
#define FWP_E_NULL_POINTER                      0x8032001CL
#define FWP_E_INVALID_ENUMERATOR                0x8032001DL
#define FWP_E_INVALID_FLAGS                     0x8032001EL
#define FWP_E_INVALID_NET_MASK                  0x8032001FL
#define FWP_E_INVALID_RANGE                     0x80320020L
#define FWP_E_INVALID_INTERVAL                  0x80320021L
#define FWP_E_ZERO_LENGTH_ARRAY                 0x80320022L
#define FWP_E_NULL_DISPLAY_NAME                 0x80320023L
#define FWP_E_INVALID_ACTION_TYPE               0x80320024L
#define FWP_E_INVALID_WEIGHT                    0x80320025L
#define FWP_E_MATCH_TYPE_MISMATCH               0x80320026L
#define FWP_E_TYPE_MISMATCH                     0x80320027L
#define FWP_E_OUT_OF_BOUNDS                     0x80320028L
#define FWP_E_RESERVED                          0x80320029L
#define FWP_E_DUPLICATE_CONDITION               0x8032002AL
#define FWP_E_DUPLICATE_KEYMOD                  0x8032002BL
#define FWP_E_ACTION_INCOMPATIBLE_WITH_LAYER    0x8032002CL
#define FWP_E_ACTION_INCOMPATIBLE_WITH_SUBLAYER 0x8032002DL
#define FWP_E_CONTEXT_INCOMPATIBLE_WITH_LAYER   0x8032002EL
#define FWP_E_CONTEXT_INCOMPATIBLE_WITH_CALLOUT 0x8032002FL
#define FWP_E_INCOMPATIBLE_AUTH_METHOD          0x80320030L
#define FWP_E_INCOMPATIBLE_DH_GROUP             0x80320031L
#define FWP_E_EM_NOT_SUPPORTED                  0x80320032L
#define FWP_E_NEVER_MATCH                       0x80320033L
#define FWP_E_PROVIDER_CONTEXT_MISMATCH         0x80320034L
#define FWP_E_INVALID_PARAMETER                 0x80320035L
#define FWP_E_TOO_MANY_SUBLAYERS                0x80320036L
#define FWP_E_CALLOUT_NOTIFICATION_FAILED       0x80320037L
#define FWP_E_INVALID_AUTH_TRANSFORM            0x80320038L
#define FWP_E_INVALID_CIPHER_TRANSFORM          0x80320039L
#define FWP_E_DROP_NOICMP                       0x80320104L
#define FWP_E_INCOMPATIBLE_CIPHER_TRANSFORM     0x8032003AL
#define FWP_E_INVALID_TRANSFORM_COMBINATION     0x8032003BL
#define FWP_E_DUPLICATE_AUTH_METHOD             0x8032003CL

/* Web Services error codes */
#define WS_S_ASYNC                          0x003D0000L
#define WS_S_END                            0x003D0001L
#define WS_E_INVALID_FORMAT                 0x803D0000L
#define WS_E_OBJECT_FAULTED                 0x803D0001L
#define WS_E_NUMERIC_OVERFLOW               0x803D0002L
#define WS_E_INVALID_OPERATION              0x803D0003L
#define WS_E_OPERATION_ABORTED              0x803D0004L
#define WS_E_ENDPOINT_ACCESS_DENIED         0x803D0005L
#define WS_E_OPERATION_TIMED_OUT            0x803D0006L
#define WS_E_OPERATION_ABANDONED            0x803D0007L
#define WS_E_QUOTA_EXCEEDED                 0x803D0008L
#define WS_E_NO_TRANSLATION_AVAILABLE       0x803D0009L
#define WS_E_SECURITY_VERIFICATION_FAILURE  0x803D000AL
#define WS_E_ADDRESS_IN_USE                 0x803D000BL
#define WS_E_ADDRESS_NOT_AVAILABLE          0x803D000CL
#define WS_E_ENDPOINT_NOT_FOUND             0x803D000DL
#define WS_E_ENDPOINT_NOT_AVAILABLE         0x803D000EL
#define WS_E_ENDPOINT_FAILURE               0x803D000FL
#define WS_E_ENDPOINT_UNREACHABLE           0x803D0010L
#define WS_E_ENDPOINT_ACTION_NOT_SUPPORTED  0x803D0011L
#define WS_E_ENDPOINT_TOO_BUSY              0x803D0012L
#define WS_E_ENDPOINT_FAULT_RECEIVED        0x803D0013L
#define WS_E_ENDPOINT_DISCONNECTED          0x803D0014L
#define WS_E_PROXY_FAILURE                  0x803D0015L
#define WS_E_PROXY_ACCESS_DENIED            0x803D0016L
#define WS_E_NOT_SUPPORTED                  0x803D0017L
#define WS_E_PROXY_REQUIRES_BASIC_AUTH      0x803D0018L
#define WS_E_PROXY_REQUIRES_DIGEST_AUTH     0x803D0019L
#define WS_E_PROXY_REQUIRES_NTLM_AUTH       0x803D001AL
#define WS_E_PROXY_REQUIRES_NEGOTIATE_AUTH  0x803D001BL
#define WS_E_SERVER_REQUIRES_BASIC_AUTH     0x803D001CL
#define WS_E_SERVER_REQUIRES_DIGEST_AUTH    0x803D001DL
#define WS_E_SERVER_REQUIRES_NTLM_AUTH      0x803D001EL
#define WS_E_SERVER_REQUIRES_NEGOTIATE_AUTH 0x803D001FL
#define WS_E_INVALID_ENDPOINT_URL           0x803D0020L
#define WS_E_OTHER                          0x803D0021L
#define WS_E_SECURITY_TOKEN_EXPIRED         0x803D0022L
#define WS_E_SECURITY_SYSTEM_FAILURE        0x803D0023L

/* NDIS error codes */
#define ERROR_NDIS_INTERFACE_CLOSING        0x80340002L
#define ERROR_NDIS_BAD_VERSION              0x80340004L
#define ERROR_NDIS_BAD_CHARACTERISTICS      0x80340005L
#define ERROR_NDIS_ADAPTER_NOT_FOUND        0x80340006L
#define ERROR_NDIS_OPEN_FAILED              0x80340007L
#define ERROR_NDIS_DEVICE_FAILED            0x80340008L
#define ERROR_NDIS_MULTICAST_FULL           0x80340009L
#define ERROR_NDIS_MULTICAST_EXISTS         0x8034000AL
#define ERROR_NDIS_MULTICAST_NOT_FOUND      0x8034000BL
#define ERROR_NDIS_REQUEST_ABORTED          0x8034000CL
#define ERROR_NDIS_RESET_IN_PROGRESS        0x8034000DL
#define ERROR_NDIS_NOT_SUPPORTED            0x803400BBL
#define ERROR_NDIS_INVALID_PACKET           0x8034000FL
#define ERROR_NDIS_ADAPTER_NOT_READY        0x80340011L
#define ERROR_NDIS_INVALID_LENGTH           0x80340014L
#define ERROR_NDIS_INVALID_DATA             0x80340015L
#define ERROR_NDIS_BUFFER_TOO_SHORT         0x80340016L
#define ERROR_NDIS_INVALID_OID              0x80340017L
#define ERROR_NDIS_ADAPTER_REMOVED          0x80340018L
#define ERROR_NDIS_UNSUPPORTED_MEDIA        0x80340019L
#define ERROR_NDIS_GROUP_ADDRESS_IN_USE     0x8034001AL
#define ERROR_NDIS_FILE_NOT_FOUND           0x8034001BL
#define ERROR_NDIS_ERROR_READING_FILE       0x8034001CL
#define ERROR_NDIS_ALREADY_MAPPED           0x8034001DL
#define ERROR_NDIS_RESOURCE_CONFLICT        0x8034001EL
#define ERROR_NDIS_MEDIA_DISCONNECTED       0x8034001FL
#define ERROR_NDIS_INVALID_ADDRESS          0x80340022L
#define ERROR_NDIS_INVALID_DEVICE_REQUEST   0x80340010L
#define ERROR_NDIS_PAUSED                   0x8034002AL
#define ERROR_NDIS_INTERFACE_NOT_FOUND      0x8034002BL
#define ERROR_NDIS_UNSUPPORTED_REVISION     0x8034002CL
#define ERROR_NDIS_INVALID_PORT             0x8034002DL
#define ERROR_NDIS_INVALID_PORT_STATE       0x8034002EL
#define ERROR_NDIS_LOW_POWER_STATE          0x8034002FL

/* 802.11 wireless LAN NDIS error codes */
#define ERROR_NDIS_DOT11_AUTO_CONFIG_ENABLED    0x80342000L
#define ERROR_NDIS_DOT11_MEDIA_IN_USE           0x80342001L
#define ERROR_NDIS_DOT11_POWER_STATE_INVALID    0x80342002L

/* New NDIS error codes */
#define ERROR_NDIS_PM_WOL_PATTERN_LIST_FULL         0x80342003L
#define ERROR_NDIS_PM_PROTOCOL_OFFLOAD_LIST_FULL    0x80342004L

/* NDIS informational error codes */
#define ERROR_NDIS_INDICATION_REQUIRED  0x00340001L

/* NDIS offload error codes */
#define ERROR_NDIS_OFFLOAD_POLICY               0xC034100FL
#define ERROR_NDIS_OFFLOAD_CONNECTION_REJECTED  0xC0341012L
#define ERROR_NDIS_OFFLOAD_PATH_REJECTED        0xC0341013L

/* Hypervisor error codes */
#define ERROR_HV_INVALID_HYPERCALL_CODE         0xC0350002L
#define ERROR_HV_INVALID_HYPERCALL_INPUT        0xC0350003L
#define ERROR_HV_INVALID_ALIGNMENT              0xC0350004L
#define ERROR_HV_INVALID_PARAMETER              0xC0350005L
#define ERROR_HV_ACCESS_DENIED                  0xC0350006L
#define ERROR_HV_INVALID_PARTITION_STATE        0xC0350007L
#define ERROR_HV_OPERATION_DENIED               0xC0350008L
#define ERROR_HV_UNKNOWN_PROPERTY               0xC0350009L
#define ERROR_HV_PROPERTY_VALUE_OUT_OF_RANGE    0xC035000AL
#define ERROR_HV_INSUFFICIENT_MEMORY            0xC035000BL
#define ERROR_HV_PARTITION_TOO_DEEP             0xC035000CL
#define ERROR_HV_INVALID_PARTITION_ID           0xC035000DL
#define ERROR_HV_INVALID_VP_INDEX               0xC035000EL
#define ERROR_HV_INVALID_PORT_ID                0xC0350011L
#define ERROR_HV_INVALID_CONNECTION_ID          0xC0350012L
#define ERROR_HV_INSUFFICIENT_BUFFER            0xC0350013L
#define ERROR_HV_NOT_ACKNOWLEDGED               0xC0350014L
#define ERROR_HV_ACKNOWLEDGED                   0xC0350016L
#define ERROR_HV_INVALID_SAVE_RESTORE_STATE     0xC0350017L
#define ERROR_HV_INVALID_SYNIC_STATE            0xC0350018L
#define ERROR_HV_OBJECT_IN_USE                  0xC0350019L
#define ERROR_HV_INVALID_PROXIMITY_DOMAIN_INFO  0xC035001AL
#define ERROR_HV_NO_DATA                        0xC035001BL
#define ERROR_HV_INACTIVE                       0xC035001CL
#define ERROR_HV_NO_RESOURCES                   0xC035001DL
#define ERROR_HV_FEATURE_UNAVAILABLE            0xC035001EL
#define ERROR_HV_NOT_PRESENT                    0xC0351000L

/* Virtualization error codes */
#define ERROR_VID_DUPLICATE_HANDLER                     0xC0370001L
#define ERROR_VID_TOO_MANY_HANDLERS                     0xC0370002L
#define ERROR_VID_QUEUE_FULL                            0xC0370003L
#define ERROR_VID_HANDLER_NOT_PRESENT                   0xC0370004L
#define ERROR_VID_INVALID_OBJECT_NAME                   0xC0370005L
#define ERROR_VID_PARTITION_NAME_TOO_LONG               0xC0370006L
#define ERROR_VID_MESSAGE_QUEUE_NAME_TOO_LONG           0xC0370007L
#define ERROR_VID_PARTITION_ALREADY_EXISTS              0xC0370008L
#define ERROR_VID_PARTITION_DOES_NOT_EXIST              0xC0370009L
#define ERROR_VID_PARTITION_NAME_NOT_FOUND              0xC037000AL
#define ERROR_VID_MESSAGE_QUEUE_ALREADY_EXISTS          0xC037000BL
#define ERROR_VID_EXCEEDED_MBP_ENTRY_MAP_LIMIT          0xC037000CL
#define ERROR_VID_MB_STILL_REFERENCED                   0xC037000DL
#define ERROR_VID_CHILD_GPA_PAGE_SET_CORRUPTED          0xC037000EL
#define ERROR_VID_INVALID_NUMA_SETTINGS                 0xC037000FL
#define ERROR_VID_INVALID_NUMA_NODE_INDEX               0xC0370010L
#define ERROR_VID_NOTIFICATION_QUEUE_ALREADY_ASSOCIATED 0xC0370011L
#define ERROR_VID_INVALID_MEMORY_BLOCK_HANDLE           0xC0370012L
#define ERROR_VID_PAGE_RANGE_OVERFLOW                   0xC0370013L
#define ERROR_VID_INVALID_MESSAGE_QUEUE_HANDLE          0xC0370014L
#define ERROR_VID_INVALID_GPA_RANGE_HANDLE              0xC0370015L
#define ERROR_VID_NO_MEMORY_BLOCK_NOTIFICATION_QUEUE    0xC0370016L
#define ERROR_VID_MEMORY_BLOCK_LOCK_COUNT_EXCEEDED      0xC0370017L
#define ERROR_VID_INVALID_PPM_HANDLE                    0xC0370018L
#define ERROR_VID_MBPS_ARE_LOCKED                       0xC0370019L
#define ERROR_VID_MESSAGE_QUEUE_CLOSED                  0xC037001AL
#define ERROR_VID_VIRTUAL_PROCESSOR_LIMIT_EXCEEDED      0xC037001BL
#define ERROR_VID_STOP_PENDING                          0xC037001CL
#define ERROR_VID_INVALID_PROCESSOR_STATE               0xC037001DL
#define ERROR_VID_EXCEEDED_KM_CONTEXT_COUNT_LIMIT       0xC037001EL
#define ERROR_VID_KM_INTERFACE_ALREADY_INITIALIZED      0xC037001FL
#define ERROR_VID_MB_PROPERTY_ALREADY_SET_RESET         0xC0370020L
#define ERROR_VID_MMIO_RANGE_DESTROYED                  0xC0370021L
#define ERROR_VID_INVALID_CHILD_GPA_PAGE_SET            0xC0370022L
#define ERROR_VID_RESERVE_PAGE_SET_IS_BEING_USED        0xC0370023L
#define ERROR_VID_RESERVE_PAGE_SET_TOO_SMALL            0xC0370024L
#define ERROR_VID_MBP_ALREADY_LOCKED_USING_RESERVED_PAGE    0xC0370025L
#define ERROR_VID_MBP_COUNT_EXCEEDED_LIMIT              0xC0370026L
#define ERROR_VID_SAVED_STATE_CORRUPT                   0xC0370027L
#define ERROR_VID_SAVED_STATE_UNRECOGNIZED_ITEM         0xC0370028L
#define ERROR_VID_SAVED_STATE_INCOMPATIBLE              0xC0370029L
#define ERROR_VID_REMOTE_NODE_PARENT_GPA_PAGES_USED     0xC037002AL

/* Volume manager error codes */
#define ERROR_VOLMGR_INCOMPLETE_REGENERATION                        0x80380001L
#define ERROR_VOLMGR_INCOMPLETE_DISK_MIGRATION                      0x80380002L
#define ERROR_VOLMGR_DATABASE_FULL                                  0xC0380001L
#define ERROR_VOLMGR_DISK_CONFIGURATION_CORRUPTED                   0xC0380002L
#define ERROR_VOLMGR_DISK_CONFIGURATION_NOT_IN_SYNC                 0xC0380003L
#define ERROR_VOLMGR_PACK_CONFIG_UPDATE_FAILED                      0xC0380004L
#define ERROR_VOLMGR_DISK_CONTAINS_NON_SIMPLE_VOLUME                0xC0380005L
#define ERROR_VOLMGR_DISK_DUPLICATE                                 0xC0380006L
#define ERROR_VOLMGR_DISK_DYNAMIC                                   0xC0380007L
#define ERROR_VOLMGR_DISK_ID_INVALID                                0xC0380008L
#define ERROR_VOLMGR_DISK_INVALID                                   0xC0380009L
#define ERROR_VOLMGR_DISK_LAST_VOTER                                0xC038000AL
#define ERROR_VOLMGR_DISK_LAYOUT_INVALID                            0xC038000BL
#define ERROR_VOLMGR_DISK_LAYOUT_NON_BASIC_BETWEEN_BASIC_PARTITIONS 0xC038000CL
#define ERROR_VOLMGR_DISK_LAYOUT_NOT_CYLINDER_ALIGNED               0xC038000DL
#define ERROR_VOLMGR_DISK_LAYOUT_PARTITIONS_TOO_SMALL               0xC038000EL
#define ERROR_VOLMGR_DISK_LAYOUT_PRIMARY_BETWEEN_LOGICAL_PARTITIONS 0xC038000FL
#define ERROR_VOLMGR_DISK_LAYOUT_TOO_MANY_PARTITIONS                0xC0380010L
#define ERROR_VOLMGR_DISK_MISSING                                   0xC0380011L
#define ERROR_VOLMGR_DISK_NOT_EMPTY                                 0xC0380012L
#define ERROR_VOLMGR_DISK_NOT_ENOUGH_SPACE                          0xC0380013L
#define ERROR_VOLMGR_DISK_REVECTORING_FAILED                        0xC0380014L
#define ERROR_VOLMGR_DISK_SECTOR_SIZE_INVALID                       0xC0380015L
#define ERROR_VOLMGR_DISK_SET_NOT_CONTAINED                         0xC0380016L
#define ERROR_VOLMGR_DISK_USED_BY_MULTIPLE_MEMBERS                  0xC0380017L
#define ERROR_VOLMGR_DISK_USED_BY_MULTIPLE_PLEXES                   0xC0380018L
#define ERROR_VOLMGR_DYNAMIC_DISK_NOT_SUPPORTED                     0xC0380019L
#define ERROR_VOLMGR_EXTENT_ALREADY_USED                            0xC038001AL
#define ERROR_VOLMGR_EXTENT_NOT_CONTIGUOUS                          0xC038001BL
#define ERROR_VOLMGR_EXTENT_NOT_IN_PUBLIC_REGION                    0xC038001CL
#define ERROR_VOLMGR_EXTENT_NOT_SECTOR_ALIGNED                      0xC038001DL
#define ERROR_VOLMGR_EXTENT_OVERLAPS_EBR_PARTITION                  0xC038001EL
#define ERROR_VOLMGR_EXTENT_VOLUME_LENGTHS_DO_NOT_MATCH             0xC038001FL
#define ERROR_VOLMGR_FAULT_TOLERANT_NOT_SUPPORTED                   0xC0380020L
#define ERROR_VOLMGR_INTERLEAVE_LENGTH_INVALID                      0xC0380021L
#define ERROR_VOLMGR_MAXIMUM_REGISTERED_USERS                       0xC0380022L
#define ERROR_VOLMGR_MEMBER_IN_SYNC                                 0xC0380023L
#define ERROR_VOLMGR_MEMBER_INDEX_DUPLICATE                         0xC0380024L
#define ERROR_VOLMGR_MEMBER_INDEX_INVALID                           0xC0380025L
#define ERROR_VOLMGR_MEMBER_MISSING                                 0xC0380026L
#define ERROR_VOLMGR_MEMBER_NOT_DETACHED                            0xC0380027L
#define ERROR_VOLMGR_MEMBER_REGENERATING                            0xC0380028L
#define ERROR_VOLMGR_ALL_DISKS_FAILED                               0xC0380029L
#define ERROR_VOLMGR_NO_REGISTERED_USERS                            0xC038002AL
#define ERROR_VOLMGR_NO_SUCH_USER                                   0xC038002BL
#define ERROR_VOLMGR_NOTIFICATION_RESET                             0xC038002CL
#define ERROR_VOLMGR_NUMBER_OF_MEMBERS_INVALID                      0xC038002DL
#define ERROR_VOLMGR_NUMBER_OF_PLEXES_INVALID                       0xC038002EL
#define ERROR_VOLMGR_PACK_DUPLICATE                                 0xC038002FL
#define ERROR_VOLMGR_PACK_ID_INVALID                                0xC0380030L
#define ERROR_VOLMGR_PACK_INVALID                                   0xC0380031L
#define ERROR_VOLMGR_PACK_NAME_INVALID                              0xC0380032L
#define ERROR_VOLMGR_PACK_OFFLINE                                   0xC0380033L
#define ERROR_VOLMGR_PACK_HAS_QUORUM                                0xC0380034L
#define ERROR_VOLMGR_PACK_WITHOUT_QUORUM                            0xC0380035L
#define ERROR_VOLMGR_PARTITION_STYLE_INVALID                        0xC0380036L
#define ERROR_VOLMGR_PARTITION_UPDATE_FAILED                        0xC0380037L
#define ERROR_VOLMGR_PLEX_IN_SYNC                                   0xC0380038L
#define ERROR_VOLMGR_PLEX_INDEX_DUPLICATE                           0xC0380039L
#define ERROR_VOLMGR_PLEX_INDEX_INVALID                             0xC038003AL
#define ERROR_VOLMGR_PLEX_LAST_ACTIVE                               0xC038003BL
#define ERROR_VOLMGR_PLEX_MISSING                                   0xC038003CL
#define ERROR_VOLMGR_PLEX_REGENERATING                              0xC038003DL
#define ERROR_VOLMGR_PLEX_TYPE_INVALID                              0xC038003EL
#define ERROR_VOLMGR_PLEX_NOT_RAID5                                 0xC038003FL
#define ERROR_VOLMGR_PLEX_NOT_SIMPLE                                0xC0380040L
#define ERROR_VOLMGR_STRUCTURE_SIZE_INVALID                         0xC0380041L
#define ERROR_VOLMGR_TOO_MANY_NOTIFICATION_REQUESTS                 0xC0380042L
#define ERROR_VOLMGR_TRANSACTION_IN_PROGRESS                        0xC0380043L
#define ERROR_VOLMGR_UNEXPECTED_DISK_LAYOUT_CHANGE                  0xC0380044L
#define ERROR_VOLMGR_VOLUME_CONTAINS_MISSING_DISK                   0xC0380045L
#define ERROR_VOLMGR_VOLUME_ID_INVALID                              0xC0380046L
#define ERROR_VOLMGR_VOLUME_LENGTH_INVALID                          0xC0380047L
#define ERROR_VOLMGR_VOLUME_LENGTH_NOT_SECTOR_SIZE_MULTIPLE         0xC0380048L
#define ERROR_VOLMGR_VOLUME_NOT_MIRRORED                            0xC0380049L
#define ERROR_VOLMGR_VOLUME_NOT_RETAINED                            0xC038004AL
#define ERROR_VOLMGR_VOLUME_OFFLINE                                 0xC038004BL
#define ERROR_VOLMGR_VOLUME_RETAINED                                0xC038004CL
#define ERROR_VOLMGR_NUMBER_OF_EXTENTS_INVALID                      0xC038004DL
#define ERROR_VOLMGR_DIFFERENT_SECTOR_SIZE                          0xC038004EL
#define ERROR_VOLMGR_BAD_BOOT_DISK                                  0xC038004FL
#define ERROR_VOLMGR_PACK_CONFIG_OFFLINE                            0xC0380050L
#define ERROR_VOLMGR_PACK_CONFIG_ONLINE                             0xC0380051L
#define ERROR_VOLMGR_NOT_PRIMARY_PACK                               0xC0380052L
#define ERROR_VOLMGR_PACK_LOG_UPDATE_FAILED                         0xC0380053L
#define ERROR_VOLMGR_NUMBER_OF_DISKS_IN_PLEX_INVALID                0xC0380054L
#define ERROR_VOLMGR_NUMBER_OF_DISKS_IN_MEMBER_INVALID              0xC0380055L
#define ERROR_VOLMGR_VOLUME_MIRRORED                                0xC0380056L
#define ERROR_VOLMGR_PLEX_NOT_SIMPLE_SPANNED                        0xC0380057L
#define ERROR_VOLMGR_NO_VALID_LOG_COPIES                            0xC0380058L
#define ERROR_VOLMGR_PRIMARY_PACK_PRESENT                           0xC0380059L
#define ERROR_VOLMGR_NUMBER_OF_DISKS_INVALID                        0xC038005AL
#define ERROR_VOLMGR_MIRROR_NOT_SUPPORTED                           0xC038005BL
#define ERROR_VOLMGR_RAID5_NOT_SUPPORTED                            0xC038005CL

/* Boot Code Data (BCD) error codes */
#define ERROR_BCD_NOT_ALL_ENTRIES_IMPORTED      0x80390001L
#define ERROR_BCD_TOO_MANY_ELEMENTS             0xC0390002L
#define ERROR_BCD_NOT_ALL_ENTRIES_SYNCHRONIZED  0x80390003L

/* Virtual Hard Disk (VHD) error codes */
#define ERROR_VHD_DRIVE_FOOTER_MISSING                  0xC03A0001L
#define ERROR_VHD_DRIVE_FOOTER_CHECKSUM_MISMATCH        0xC03A0002L
#define ERROR_VHD_DRIVE_FOOTER_CORRUPT                  0xC03A0003L
#define ERROR_VHD_FORMAT_UNKNOWN                        0xC03A0004L
#define ERROR_VHD_FORMAT_UNSUPPORTED_VERSION            0xC03A0005L
#define ERROR_VHD_SPARSE_HEADER_CHECKSUM_MISMATCH       0xC03A0006L
#define ERROR_VHD_SPARSE_HEADER_UNSUPPORTED_VERSION     0xC03A0007L
#define ERROR_VHD_SPARSE_HEADER_CORRUPT                 0xC03A0008L
#define ERROR_VHD_BLOCK_ALLOCATION_FAILURE              0xC03A0009L
#define ERROR_VHD_BLOCK_ALLOCATION_TABLE_CORRUPT        0xC03A000AL
#define ERROR_VHD_INVALID_BLOCK_SIZE                    0xC03A000BL
#define ERROR_VHD_BITMAP_MISMATCH                       0xC03A000CL
#define ERROR_VHD_PARENT_VHD_NOT_FOUND                  0xC03A000DL
#define ERROR_VHD_CHILD_PARENT_ID_MISMATCH              0xC03A000EL
#define ERROR_VHD_CHILD_PARENT_TIMESTAMP_MISMATCH       0xC03A000FL
#define ERROR_VHD_METADATA_READ_FAILURE                 0xC03A0010L
#define ERROR_VHD_METADATA_WRITE_FAILURE                0xC03A0011L
#define ERROR_VHD_INVALID_SIZE                          0xC03A0012L
#define ERROR_VHD_INVALID_FILE_SIZE                     0xC03A0013L
#define ERROR_VIRTDISK_PROVIDER_NOT_FOUND               0xC03A0014L
#define ERROR_VIRTDISK_NOT_VIRTUAL_DISK                 0xC03A0015L
#define ERROR_VHD_PARENT_VHD_ACCESS_DENIED              0xC03A0016L
#define ERROR_VHD_CHILD_PARENT_SIZE_MISMATCH            0xC03A0017L
#define ERROR_VHD_DIFFERENCING_CHAIN_CYCLE_DETECTED     0xC03A0018L
#define ERROR_VHD_DIFFERENCING_CHAIN_ERROR_IN_PARENT    0xC03A0019L
#define ERROR_VIRTUAL_DISK_LIMITATION                   0xC03A001AL
#define ERROR_VHD_INVALID_TYPE                          0xC03A001BL
#define ERROR_VHD_INVALID_STATE                         0xC03A001CL
#define ERROR_VIRTDISK_UNSUPPORTED_DISK_SECTOR_SIZE     0xC03A001DL
#define ERROR_QUERY_STORAGE_ERROR                       0x803A0001L

/* Script diagnostics error codes */
#define SDIAG_E_CANCELLED   0x803C0100L
#define SDIAG_E_SCRIPT      0x803C0101L
#define SDIAG_E_POWERSHELL  0x803C0102L
#define SDIAG_E_MANAGEDHOST 0x803C0103L
#define SDIAG_E_NOVERIFIER  0x803C0104L
#define SDIAG_S_CANNOTRUN   0x003C0105L
#define SDIAG_E_DISABLED    0x803C0106L
#define SDIAG_E_TRUST       0x803C0107L
#define SDIAG_E_CANNOTRUN   0x803C0108L
#define SDIAG_E_VERSION     0x803C0109L
#define SDIAG_E_RESOURCE    0x803C010AL
#define SDIAG_E_ROOTCAUSE   0x803C010BL

/* MBN error codes */
#define E_MBN_CONTEXT_NOT_ACTIVATED         0x80548201L
#define E_MBN_BAD_SIM                       0x80548202L
#define E_MBN_DATA_CLASS_NOT_AVAILABLE      0x80548203L
#define E_MBN_INVALID_ACCESS_STRING         0x80548204L
#define E_MBN_MAX_ACTIVATED_CONTEXTS        0x80548205L
#define E_MBN_PACKET_SVC_DETACHED           0x80548206L
#define E_MBN_PROVIDER_NOT_VISIBLE          0x80548207L
#define E_MBN_RADIO_POWER_OFF               0x80548208L
#define E_MBN_SERVICE_NOT_ACTIVATED         0x80548209L
#define E_MBN_SIM_NOT_INSERTED              0x8054820AL
#define E_MBN_VOICE_CALL_IN_PROGRESS        0x8054820BL
#define E_MBN_INVALID_CACHE                 0x8054820CL
#define E_MBN_NOT_REGISTERED                0x8054820DL
#define E_MBN_PROVIDERS_NOT_FOUND           0x8054820EL
#define E_MBN_PIN_NOT_SUPPORTED             0x8054820FL
#define E_MBN_PIN_REQUIRED                  0x80548210L
#define E_MBN_PIN_DISABLED                  0x80548211L
#define E_MBN_FAILURE                       0x80548212L
#define E_MBN_INVALID_PROFILE               0x80548218L
#define E_MBN_DEFAULT_PROFILE_EXIST         0x80548219L
#define E_MBN_SMS_ENCODING_NOT_SUPPORTED    0x80548220L
#define E_MBN_SMS_FILTER_NOT_SUPPORTED      0x80548221L
#define E_MBN_SMS_INVALID_MEMORY_INDEX      0x80548222L
#define E_MBN_SMS_LANG_NOT_SUPPORTED        0x80548223L
#define E_MBN_SMS_MEMORY_FAILURE            0x80548224L
#define E_MBN_SMS_NETWORK_TIMEOUT           0x80548225L
#define E_MBN_SMS_UNKNOWN_SMSC_ADDRESS      0x80548226L
#define E_MBN_SMS_FORMAT_NOT_SUPPORTED      0x80548227L
#define E_MBN_SMS_OPERATION_NOT_ALLOWED     0x80548228L
#define E_MBN_SMS_MEMORY_FULL               0x80548229L

/* User interface error codes */
#define UI_E_CREATE_FAILED                  0x802A0001L
#define UI_E_SHUTDOWN_CALLED                0x802A0002L
#define UI_E_ILLEGAL_REENTRANCY             0x802A0003L
#define UI_E_OBJECT_SEALED                  0x802A0004L
#define UI_E_VALUE_NOT_SET                  0x802A0005L
#define UI_E_VALUE_NOT_DETERMINED           0x802A0006L
#define UI_E_INVALID_OUTPUT                 0x802A0007L
#define UI_E_BOOLEAN_EXPECTED               0x802A0008L
#define UI_E_DIFFERENT_OWNER                0x802A0009L
#define UI_E_AMBIGUOUS_MATCH                0x802A000AL
#define UI_E_FP_OVERFLOW                    0x802A000BL
#define UI_E_WRONG_THREAD                   0x802A000CL
#define UI_E_STORYBOARD_ACTIVE              0x802A0101L
#define UI_E_STORYBOARD_NOT_PLAYING         0x802A0102L
#define UI_E_START_KEYFRAME_AFTER_END       0x802A0103L
#define UI_E_END_KEYFRAME_NOT_DETERMINED    0x802A0104L
#define UI_E_LOOPS_OVERLAP                  0x802A0105L
#define UI_E_TRANSITION_ALREADY_USED        0x802A0106L
#define UI_E_TRANSITION_NOT_IN_STORYBOARD   0x802A0107L
#define UI_E_TRANSITION_ECLIPSED            0x802A0108L
#define UI_E_TIME_BEFORE_LAST_UPDATE        0x802A0109L
#define UI_E_TIMER_CLIENT_ALREADY_CONNECTED 0x802A010AL

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _WINERROR_ */
